

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Callbacks
    ( 

 -- * Signals


-- ** CacheDestroyFunc #signal:CacheDestroyFunc#

    C_CacheDestroyFunc                      ,
    CacheDestroyFunc                        ,
    dynamic_CacheDestroyFunc                ,
    genClosure_CacheDestroyFunc             ,
    mk_CacheDestroyFunc                     ,
    noCacheDestroyFunc                      ,
    wrap_CacheDestroyFunc                   ,


-- ** CacheDupFunc #signal:CacheDupFunc#

    C_CacheDupFunc                          ,
    CacheDupFunc                            ,
    dynamic_CacheDupFunc                    ,
    genClosure_CacheDupFunc                 ,
    mk_CacheDupFunc                         ,
    noCacheDupFunc                          ,
    wrap_CacheDupFunc                       ,


-- ** CacheNewFunc #signal:CacheNewFunc#

    C_CacheNewFunc                          ,
    CacheNewFunc                            ,
    dynamic_CacheNewFunc                    ,
    genClosure_CacheNewFunc                 ,
    mk_CacheNewFunc                         ,
    noCacheNewFunc                          ,
    wrap_CacheNewFunc                       ,


-- ** ChildWatchFunc #signal:ChildWatchFunc#

    C_ChildWatchFunc                        ,
    ChildWatchFunc                          ,
    ChildWatchFunc_WithClosures             ,
    drop_closures_ChildWatchFunc            ,
    dynamic_ChildWatchFunc                  ,
    genClosure_ChildWatchFunc               ,
    mk_ChildWatchFunc                       ,
    noChildWatchFunc                        ,
    noChildWatchFunc_WithClosures           ,
    wrap_ChildWatchFunc                     ,


-- ** ClearHandleFunc #signal:ClearHandleFunc#

    C_ClearHandleFunc                       ,
    ClearHandleFunc                         ,
    dynamic_ClearHandleFunc                 ,
    genClosure_ClearHandleFunc              ,
    mk_ClearHandleFunc                      ,
    noClearHandleFunc                       ,
    wrap_ClearHandleFunc                    ,


-- ** CompareDataFunc #signal:CompareDataFunc#

    C_CompareDataFunc                       ,
    CompareDataFunc                         ,
    CompareDataFunc_WithClosures            ,
    drop_closures_CompareDataFunc           ,
    dynamic_CompareDataFunc                 ,
    genClosure_CompareDataFunc              ,
    mk_CompareDataFunc                      ,
    noCompareDataFunc                       ,
    noCompareDataFunc_WithClosures          ,
    wrap_CompareDataFunc                    ,


-- ** CompareFunc #signal:CompareFunc#

    C_CompareFunc                           ,
    CompareFunc                             ,
    dynamic_CompareFunc                     ,
    genClosure_CompareFunc                  ,
    mk_CompareFunc                          ,
    noCompareFunc                           ,
    wrap_CompareFunc                        ,


-- ** CompletionFunc #signal:CompletionFunc#

    C_CompletionFunc                        ,
    CompletionFunc                          ,
    dynamic_CompletionFunc                  ,
    genClosure_CompletionFunc               ,
    mk_CompletionFunc                       ,
    noCompletionFunc                        ,
    wrap_CompletionFunc                     ,


-- ** CompletionStrncmpFunc #signal:CompletionStrncmpFunc#

    C_CompletionStrncmpFunc                 ,
    CompletionStrncmpFunc                   ,
    dynamic_CompletionStrncmpFunc           ,
    genClosure_CompletionStrncmpFunc        ,
    mk_CompletionStrncmpFunc                ,
    noCompletionStrncmpFunc                 ,
    wrap_CompletionStrncmpFunc              ,


-- ** CopyFunc #signal:CopyFunc#

    C_CopyFunc                              ,
    CopyFunc                                ,
    dynamic_CopyFunc                        ,
    genClosure_CopyFunc                     ,
    mk_CopyFunc                             ,
    noCopyFunc                              ,
    wrap_CopyFunc                           ,


-- ** DataForeachFunc #signal:DataForeachFunc#

    C_DataForeachFunc                       ,
    DataForeachFunc                         ,
    DataForeachFunc_WithClosures            ,
    drop_closures_DataForeachFunc           ,
    dynamic_DataForeachFunc                 ,
    genClosure_DataForeachFunc              ,
    mk_DataForeachFunc                      ,
    noDataForeachFunc                       ,
    noDataForeachFunc_WithClosures          ,
    wrap_DataForeachFunc                    ,


-- ** DestroyNotify #signal:DestroyNotify#

    C_DestroyNotify                         ,
    DestroyNotify                           ,
    dynamic_DestroyNotify                   ,
    genClosure_DestroyNotify                ,
    mk_DestroyNotify                        ,
    noDestroyNotify                         ,
    wrap_DestroyNotify                      ,


-- ** DuplicateFunc #signal:DuplicateFunc#

    C_DuplicateFunc                         ,
    DuplicateFunc                           ,
    DuplicateFunc_WithClosures              ,
    drop_closures_DuplicateFunc             ,
    dynamic_DuplicateFunc                   ,
    genClosure_DuplicateFunc                ,
    mk_DuplicateFunc                        ,
    noDuplicateFunc                         ,
    noDuplicateFunc_WithClosures            ,
    wrap_DuplicateFunc                      ,


-- ** EqualFunc #signal:EqualFunc#

    C_EqualFunc                             ,
    EqualFunc                               ,
    dynamic_EqualFunc                       ,
    genClosure_EqualFunc                    ,
    mk_EqualFunc                            ,
    noEqualFunc                             ,
    wrap_EqualFunc                          ,


-- ** EqualFuncFull #signal:EqualFuncFull#

    C_EqualFuncFull                         ,
    EqualFuncFull                           ,
    EqualFuncFull_WithClosures              ,
    drop_closures_EqualFuncFull             ,
    dynamic_EqualFuncFull                   ,
    genClosure_EqualFuncFull                ,
    mk_EqualFuncFull                        ,
    noEqualFuncFull                         ,
    noEqualFuncFull_WithClosures            ,
    wrap_EqualFuncFull                      ,


-- ** ErrorClearFunc #signal:ErrorClearFunc#

    C_ErrorClearFunc                        ,
    ErrorClearFunc                          ,
    dynamic_ErrorClearFunc                  ,
    genClosure_ErrorClearFunc               ,
    mk_ErrorClearFunc                       ,
    noErrorClearFunc                        ,
    wrap_ErrorClearFunc                     ,


-- ** ErrorCopyFunc #signal:ErrorCopyFunc#

    C_ErrorCopyFunc                         ,
    ErrorCopyFunc                           ,
    dynamic_ErrorCopyFunc                   ,
    genClosure_ErrorCopyFunc                ,
    mk_ErrorCopyFunc                        ,
    noErrorCopyFunc                         ,
    wrap_ErrorCopyFunc                      ,


-- ** ErrorInitFunc #signal:ErrorInitFunc#

    C_ErrorInitFunc                         ,
    ErrorInitFunc                           ,
    dynamic_ErrorInitFunc                   ,
    genClosure_ErrorInitFunc                ,
    mk_ErrorInitFunc                        ,
    noErrorInitFunc                         ,
    wrap_ErrorInitFunc                      ,


-- ** FreeFunc #signal:FreeFunc#

    C_FreeFunc                              ,
    FreeFunc                                ,
    dynamic_FreeFunc                        ,
    genClosure_FreeFunc                     ,
    mk_FreeFunc                             ,
    noFreeFunc                              ,
    wrap_FreeFunc                           ,


-- ** Func #signal:Func#

    C_Func                                  ,
    Func                                    ,
    Func_WithClosures                       ,
    drop_closures_Func                      ,
    dynamic_Func                            ,
    genClosure_Func                         ,
    mk_Func                                 ,
    noFunc                                  ,
    noFunc_WithClosures                     ,
    wrap_Func                               ,


-- ** HFunc #signal:HFunc#

    C_HFunc                                 ,
    HFunc                                   ,
    HFunc_WithClosures                      ,
    drop_closures_HFunc                     ,
    dynamic_HFunc                           ,
    genClosure_HFunc                        ,
    mk_HFunc                                ,
    noHFunc                                 ,
    noHFunc_WithClosures                    ,
    wrap_HFunc                              ,


-- ** HRFunc #signal:HRFunc#

    C_HRFunc                                ,
    HRFunc                                  ,
    HRFunc_WithClosures                     ,
    drop_closures_HRFunc                    ,
    dynamic_HRFunc                          ,
    genClosure_HRFunc                       ,
    mk_HRFunc                               ,
    noHRFunc                                ,
    noHRFunc_WithClosures                   ,
    wrap_HRFunc                             ,


-- ** HashFunc #signal:HashFunc#

    C_HashFunc                              ,
    HashFunc                                ,
    dynamic_HashFunc                        ,
    genClosure_HashFunc                     ,
    mk_HashFunc                             ,
    noHashFunc                              ,
    wrap_HashFunc                           ,


-- ** HookCheckFunc #signal:HookCheckFunc#

    C_HookCheckFunc                         ,
    HookCheckFunc                           ,
    dynamic_HookCheckFunc                   ,
    genClosure_HookCheckFunc                ,
    mk_HookCheckFunc                        ,
    noHookCheckFunc                         ,
    wrap_HookCheckFunc                      ,


-- ** HookCheckMarshaller #signal:HookCheckMarshaller#

    C_HookCheckMarshaller                   ,
    HookCheckMarshaller                     ,
    dynamic_HookCheckMarshaller             ,
    genClosure_HookCheckMarshaller          ,
    mk_HookCheckMarshaller                  ,
    noHookCheckMarshaller                   ,
    wrap_HookCheckMarshaller                ,


-- ** HookCompareFunc #signal:HookCompareFunc#

    C_HookCompareFunc                       ,
    HookCompareFunc                         ,
    dynamic_HookCompareFunc                 ,
    genClosure_HookCompareFunc              ,
    mk_HookCompareFunc                      ,
    noHookCompareFunc                       ,
    wrap_HookCompareFunc                    ,


-- ** HookFinalizeFunc #signal:HookFinalizeFunc#

    C_HookFinalizeFunc                      ,
    HookFinalizeFunc                        ,
    dynamic_HookFinalizeFunc                ,
    genClosure_HookFinalizeFunc             ,
    mk_HookFinalizeFunc                     ,
    noHookFinalizeFunc                      ,
    wrap_HookFinalizeFunc                   ,


-- ** HookFindFunc #signal:HookFindFunc#

    C_HookFindFunc                          ,
    HookFindFunc                            ,
    dynamic_HookFindFunc                    ,
    genClosure_HookFindFunc                 ,
    mk_HookFindFunc                         ,
    noHookFindFunc                          ,
    wrap_HookFindFunc                       ,


-- ** HookFunc #signal:HookFunc#

    C_HookFunc                              ,
    HookFunc                                ,
    dynamic_HookFunc                        ,
    genClosure_HookFunc                     ,
    mk_HookFunc                             ,
    noHookFunc                              ,
    wrap_HookFunc                           ,


-- ** HookMarshaller #signal:HookMarshaller#

    C_HookMarshaller                        ,
    HookMarshaller                          ,
    dynamic_HookMarshaller                  ,
    genClosure_HookMarshaller               ,
    mk_HookMarshaller                       ,
    noHookMarshaller                        ,
    wrap_HookMarshaller                     ,


-- ** IOFunc #signal:IOFunc#

    C_IOFunc                                ,
    IOFunc                                  ,
    dynamic_IOFunc                          ,
    genClosure_IOFunc                       ,
    mk_IOFunc                               ,
    noIOFunc                                ,
    wrap_IOFunc                             ,


-- ** IOFuncsIoCloseFieldCallback #signal:IOFuncsIoCloseFieldCallback#

    C_IOFuncsIoCloseFieldCallback           ,
    IOFuncsIoCloseFieldCallback             ,
    dynamic_IOFuncsIoCloseFieldCallback     ,
    mk_IOFuncsIoCloseFieldCallback          ,
    noIOFuncsIoCloseFieldCallback           ,


-- ** IOFuncsIoCreateWatchFieldCallback #signal:IOFuncsIoCreateWatchFieldCallback#

    C_IOFuncsIoCreateWatchFieldCallback     ,
    IOFuncsIoCreateWatchFieldCallback       ,
    dynamic_IOFuncsIoCreateWatchFieldCallback,
    genClosure_IOFuncsIoCreateWatchFieldCallback,
    mk_IOFuncsIoCreateWatchFieldCallback    ,
    noIOFuncsIoCreateWatchFieldCallback     ,
    wrap_IOFuncsIoCreateWatchFieldCallback  ,


-- ** IOFuncsIoFreeFieldCallback #signal:IOFuncsIoFreeFieldCallback#

    C_IOFuncsIoFreeFieldCallback            ,
    IOFuncsIoFreeFieldCallback              ,
    dynamic_IOFuncsIoFreeFieldCallback      ,
    genClosure_IOFuncsIoFreeFieldCallback   ,
    mk_IOFuncsIoFreeFieldCallback           ,
    noIOFuncsIoFreeFieldCallback            ,
    wrap_IOFuncsIoFreeFieldCallback         ,


-- ** IOFuncsIoGetFlagsFieldCallback #signal:IOFuncsIoGetFlagsFieldCallback#

    C_IOFuncsIoGetFlagsFieldCallback        ,
    IOFuncsIoGetFlagsFieldCallback          ,
    dynamic_IOFuncsIoGetFlagsFieldCallback  ,
    genClosure_IOFuncsIoGetFlagsFieldCallback,
    mk_IOFuncsIoGetFlagsFieldCallback       ,
    noIOFuncsIoGetFlagsFieldCallback        ,
    wrap_IOFuncsIoGetFlagsFieldCallback     ,


-- ** IOFuncsIoReadFieldCallback #signal:IOFuncsIoReadFieldCallback#

    C_IOFuncsIoReadFieldCallback            ,
    IOFuncsIoReadFieldCallback              ,
    dynamic_IOFuncsIoReadFieldCallback      ,
    mk_IOFuncsIoReadFieldCallback           ,
    noIOFuncsIoReadFieldCallback            ,


-- ** IOFuncsIoSeekFieldCallback #signal:IOFuncsIoSeekFieldCallback#

    C_IOFuncsIoSeekFieldCallback            ,
    IOFuncsIoSeekFieldCallback              ,
    dynamic_IOFuncsIoSeekFieldCallback      ,
    mk_IOFuncsIoSeekFieldCallback           ,
    noIOFuncsIoSeekFieldCallback            ,


-- ** IOFuncsIoSetFlagsFieldCallback #signal:IOFuncsIoSetFlagsFieldCallback#

    C_IOFuncsIoSetFlagsFieldCallback        ,
    IOFuncsIoSetFlagsFieldCallback          ,
    dynamic_IOFuncsIoSetFlagsFieldCallback  ,
    mk_IOFuncsIoSetFlagsFieldCallback       ,
    noIOFuncsIoSetFlagsFieldCallback        ,


-- ** IOFuncsIoWriteFieldCallback #signal:IOFuncsIoWriteFieldCallback#

    C_IOFuncsIoWriteFieldCallback           ,
    IOFuncsIoWriteFieldCallback             ,
    dynamic_IOFuncsIoWriteFieldCallback     ,
    mk_IOFuncsIoWriteFieldCallback          ,
    noIOFuncsIoWriteFieldCallback           ,


-- ** LogFunc #signal:LogFunc#

    C_LogFunc                               ,
    LogFunc                                 ,
    LogFunc_WithClosures                    ,
    drop_closures_LogFunc                   ,
    dynamic_LogFunc                         ,
    genClosure_LogFunc                      ,
    mk_LogFunc                              ,
    noLogFunc                               ,
    noLogFunc_WithClosures                  ,
    wrap_LogFunc                            ,


-- ** LogWriterFunc #signal:LogWriterFunc#

    C_LogWriterFunc                         ,
    LogWriterFunc                           ,
    LogWriterFunc_WithClosures              ,
    drop_closures_LogWriterFunc             ,
    dynamic_LogWriterFunc                   ,
    genClosure_LogWriterFunc                ,
    mk_LogWriterFunc                        ,
    noLogWriterFunc                         ,
    noLogWriterFunc_WithClosures            ,
    wrap_LogWriterFunc                      ,


-- ** MarkupParserEndElementFieldCallback #signal:MarkupParserEndElementFieldCallback#

    C_MarkupParserEndElementFieldCallback   ,
    MarkupParserEndElementFieldCallback     ,
    MarkupParserEndElementFieldCallback_WithClosures,
    drop_closures_MarkupParserEndElementFieldCallback,
    dynamic_MarkupParserEndElementFieldCallback,
    mk_MarkupParserEndElementFieldCallback  ,
    noMarkupParserEndElementFieldCallback   ,
    noMarkupParserEndElementFieldCallback_WithClosures,


-- ** MarkupParserErrorFieldCallback #signal:MarkupParserErrorFieldCallback#

    C_MarkupParserErrorFieldCallback        ,
    MarkupParserErrorFieldCallback          ,
    MarkupParserErrorFieldCallback_WithClosures,
    drop_closures_MarkupParserErrorFieldCallback,
    dynamic_MarkupParserErrorFieldCallback  ,
    genClosure_MarkupParserErrorFieldCallback,
    mk_MarkupParserErrorFieldCallback       ,
    noMarkupParserErrorFieldCallback        ,
    noMarkupParserErrorFieldCallback_WithClosures,
    wrap_MarkupParserErrorFieldCallback     ,


-- ** MarkupParserPassthroughFieldCallback #signal:MarkupParserPassthroughFieldCallback#

    C_MarkupParserPassthroughFieldCallback  ,
    MarkupParserPassthroughFieldCallback    ,
    MarkupParserPassthroughFieldCallback_WithClosures,
    drop_closures_MarkupParserPassthroughFieldCallback,
    dynamic_MarkupParserPassthroughFieldCallback,
    mk_MarkupParserPassthroughFieldCallback ,
    noMarkupParserPassthroughFieldCallback  ,
    noMarkupParserPassthroughFieldCallback_WithClosures,


-- ** MarkupParserStartElementFieldCallback #signal:MarkupParserStartElementFieldCallback#

    C_MarkupParserStartElementFieldCallback ,
    MarkupParserStartElementFieldCallback   ,
    MarkupParserStartElementFieldCallback_WithClosures,
    drop_closures_MarkupParserStartElementFieldCallback,
    dynamic_MarkupParserStartElementFieldCallback,
    mk_MarkupParserStartElementFieldCallback,
    noMarkupParserStartElementFieldCallback ,
    noMarkupParserStartElementFieldCallback_WithClosures,


-- ** MarkupParserTextFieldCallback #signal:MarkupParserTextFieldCallback#

    C_MarkupParserTextFieldCallback         ,
    MarkupParserTextFieldCallback           ,
    MarkupParserTextFieldCallback_WithClosures,
    drop_closures_MarkupParserTextFieldCallback,
    dynamic_MarkupParserTextFieldCallback   ,
    mk_MarkupParserTextFieldCallback        ,
    noMarkupParserTextFieldCallback         ,
    noMarkupParserTextFieldCallback_WithClosures,


-- ** MemVTableCallocFieldCallback #signal:MemVTableCallocFieldCallback#

    C_MemVTableCallocFieldCallback          ,
    MemVTableCallocFieldCallback            ,
    dynamic_MemVTableCallocFieldCallback    ,
    genClosure_MemVTableCallocFieldCallback ,
    mk_MemVTableCallocFieldCallback         ,
    noMemVTableCallocFieldCallback          ,
    wrap_MemVTableCallocFieldCallback       ,


-- ** MemVTableFreeFieldCallback #signal:MemVTableFreeFieldCallback#

    C_MemVTableFreeFieldCallback            ,
    MemVTableFreeFieldCallback              ,
    dynamic_MemVTableFreeFieldCallback      ,
    genClosure_MemVTableFreeFieldCallback   ,
    mk_MemVTableFreeFieldCallback           ,
    noMemVTableFreeFieldCallback            ,
    wrap_MemVTableFreeFieldCallback         ,


-- ** MemVTableMallocFieldCallback #signal:MemVTableMallocFieldCallback#

    C_MemVTableMallocFieldCallback          ,
    MemVTableMallocFieldCallback            ,
    dynamic_MemVTableMallocFieldCallback    ,
    genClosure_MemVTableMallocFieldCallback ,
    mk_MemVTableMallocFieldCallback         ,
    noMemVTableMallocFieldCallback          ,
    wrap_MemVTableMallocFieldCallback       ,


-- ** MemVTableReallocFieldCallback #signal:MemVTableReallocFieldCallback#

    C_MemVTableReallocFieldCallback         ,
    MemVTableReallocFieldCallback           ,
    dynamic_MemVTableReallocFieldCallback   ,
    genClosure_MemVTableReallocFieldCallback,
    mk_MemVTableReallocFieldCallback        ,
    noMemVTableReallocFieldCallback         ,
    wrap_MemVTableReallocFieldCallback      ,


-- ** MemVTableTryMallocFieldCallback #signal:MemVTableTryMallocFieldCallback#

    C_MemVTableTryMallocFieldCallback       ,
    MemVTableTryMallocFieldCallback         ,
    dynamic_MemVTableTryMallocFieldCallback ,
    genClosure_MemVTableTryMallocFieldCallback,
    mk_MemVTableTryMallocFieldCallback      ,
    noMemVTableTryMallocFieldCallback       ,
    wrap_MemVTableTryMallocFieldCallback    ,


-- ** MemVTableTryReallocFieldCallback #signal:MemVTableTryReallocFieldCallback#

    C_MemVTableTryReallocFieldCallback      ,
    MemVTableTryReallocFieldCallback        ,
    dynamic_MemVTableTryReallocFieldCallback,
    genClosure_MemVTableTryReallocFieldCallback,
    mk_MemVTableTryReallocFieldCallback     ,
    noMemVTableTryReallocFieldCallback      ,
    wrap_MemVTableTryReallocFieldCallback   ,


-- ** NodeForeachFunc #signal:NodeForeachFunc#

    C_NodeForeachFunc                       ,
    NodeForeachFunc                         ,
    dynamic_NodeForeachFunc                 ,
    genClosure_NodeForeachFunc              ,
    mk_NodeForeachFunc                      ,
    noNodeForeachFunc                       ,
    wrap_NodeForeachFunc                    ,


-- ** NodeTraverseFunc #signal:NodeTraverseFunc#

    C_NodeTraverseFunc                      ,
    NodeTraverseFunc                        ,
    dynamic_NodeTraverseFunc                ,
    genClosure_NodeTraverseFunc             ,
    mk_NodeTraverseFunc                     ,
    noNodeTraverseFunc                      ,
    wrap_NodeTraverseFunc                   ,


-- ** OptionArgFunc #signal:OptionArgFunc#

    C_OptionArgFunc                         ,
    OptionArgFunc                           ,
    dynamic_OptionArgFunc                   ,
    mk_OptionArgFunc                        ,
    noOptionArgFunc                         ,


-- ** OptionErrorFunc #signal:OptionErrorFunc#

    C_OptionErrorFunc                       ,
    OptionErrorFunc                         ,
    dynamic_OptionErrorFunc                 ,
    mk_OptionErrorFunc                      ,
    noOptionErrorFunc                       ,


-- ** OptionParseFunc #signal:OptionParseFunc#

    C_OptionParseFunc                       ,
    OptionParseFunc                         ,
    dynamic_OptionParseFunc                 ,
    mk_OptionParseFunc                      ,
    noOptionParseFunc                       ,


-- ** PollFunc #signal:PollFunc#

    C_PollFunc                              ,
    PollFunc                                ,
    dynamic_PollFunc                        ,
    genClosure_PollFunc                     ,
    mk_PollFunc                             ,
    noPollFunc                              ,
    wrap_PollFunc                           ,


-- ** PrintFunc #signal:PrintFunc#

    C_PrintFunc                             ,
    PrintFunc                               ,
    dynamic_PrintFunc                       ,
    genClosure_PrintFunc                    ,
    mk_PrintFunc                            ,
    noPrintFunc                             ,
    wrap_PrintFunc                          ,


-- ** RegexEvalCallback #signal:RegexEvalCallback#

    C_RegexEvalCallback                     ,
    RegexEvalCallback                       ,
    RegexEvalCallback_WithClosures          ,
    drop_closures_RegexEvalCallback         ,
    dynamic_RegexEvalCallback               ,
    genClosure_RegexEvalCallback            ,
    mk_RegexEvalCallback                    ,
    noRegexEvalCallback                     ,
    noRegexEvalCallback_WithClosures        ,
    wrap_RegexEvalCallback                  ,


-- ** ScannerMsgFunc #signal:ScannerMsgFunc#

    C_ScannerMsgFunc                        ,
    ScannerMsgFunc                          ,
    dynamic_ScannerMsgFunc                  ,
    genClosure_ScannerMsgFunc               ,
    mk_ScannerMsgFunc                       ,
    noScannerMsgFunc                        ,
    wrap_ScannerMsgFunc                     ,


-- ** SequenceIterCompareFunc #signal:SequenceIterCompareFunc#

    C_SequenceIterCompareFunc               ,
    SequenceIterCompareFunc                 ,
    dynamic_SequenceIterCompareFunc         ,
    genClosure_SequenceIterCompareFunc      ,
    mk_SequenceIterCompareFunc              ,
    noSequenceIterCompareFunc               ,
    wrap_SequenceIterCompareFunc            ,


-- ** SourceCallbackFuncsRefFieldCallback #signal:SourceCallbackFuncsRefFieldCallback#

    C_SourceCallbackFuncsRefFieldCallback   ,
    SourceCallbackFuncsRefFieldCallback     ,
    dynamic_SourceCallbackFuncsRefFieldCallback,
    genClosure_SourceCallbackFuncsRefFieldCallback,
    mk_SourceCallbackFuncsRefFieldCallback  ,
    noSourceCallbackFuncsRefFieldCallback   ,
    wrap_SourceCallbackFuncsRefFieldCallback,


-- ** SourceCallbackFuncsUnrefFieldCallback #signal:SourceCallbackFuncsUnrefFieldCallback#

    C_SourceCallbackFuncsUnrefFieldCallback ,
    SourceCallbackFuncsUnrefFieldCallback   ,
    dynamic_SourceCallbackFuncsUnrefFieldCallback,
    genClosure_SourceCallbackFuncsUnrefFieldCallback,
    mk_SourceCallbackFuncsUnrefFieldCallback,
    noSourceCallbackFuncsUnrefFieldCallback ,
    wrap_SourceCallbackFuncsUnrefFieldCallback,


-- ** SourceDisposeFunc #signal:SourceDisposeFunc#

    C_SourceDisposeFunc                     ,
    SourceDisposeFunc                       ,
    dynamic_SourceDisposeFunc               ,
    genClosure_SourceDisposeFunc            ,
    mk_SourceDisposeFunc                    ,
    noSourceDisposeFunc                     ,
    wrap_SourceDisposeFunc                  ,


-- ** SourceDummyMarshal #signal:SourceDummyMarshal#

    C_SourceDummyMarshal                    ,
    SourceDummyMarshal                      ,
    dynamic_SourceDummyMarshal              ,
    genClosure_SourceDummyMarshal           ,
    mk_SourceDummyMarshal                   ,
    noSourceDummyMarshal                    ,
    wrap_SourceDummyMarshal                 ,


-- ** SourceFunc #signal:SourceFunc#

    C_SourceFunc                            ,
    SourceFunc                              ,
    SourceFunc_WithClosures                 ,
    drop_closures_SourceFunc                ,
    dynamic_SourceFunc                      ,
    genClosure_SourceFunc                   ,
    mk_SourceFunc                           ,
    noSourceFunc                            ,
    noSourceFunc_WithClosures               ,
    wrap_SourceFunc                         ,


-- ** SourceFuncsCheckFunc #signal:SourceFuncsCheckFunc#

    C_SourceFuncsCheckFunc                  ,
    SourceFuncsCheckFunc                    ,
    dynamic_SourceFuncsCheckFunc            ,
    genClosure_SourceFuncsCheckFunc         ,
    mk_SourceFuncsCheckFunc                 ,
    noSourceFuncsCheckFunc                  ,
    wrap_SourceFuncsCheckFunc               ,


-- ** SourceFuncsFinalizeFunc #signal:SourceFuncsFinalizeFunc#

    C_SourceFuncsFinalizeFunc               ,
    SourceFuncsFinalizeFunc                 ,
    dynamic_SourceFuncsFinalizeFunc         ,
    genClosure_SourceFuncsFinalizeFunc      ,
    mk_SourceFuncsFinalizeFunc              ,
    noSourceFuncsFinalizeFunc               ,
    wrap_SourceFuncsFinalizeFunc            ,


-- ** SourceFuncsPrepareFunc #signal:SourceFuncsPrepareFunc#

    C_SourceFuncsPrepareFunc                ,
    SourceFuncsPrepareFunc                  ,
    dynamic_SourceFuncsPrepareFunc          ,
    genClosure_SourceFuncsPrepareFunc       ,
    mk_SourceFuncsPrepareFunc               ,
    noSourceFuncsPrepareFunc                ,
    wrap_SourceFuncsPrepareFunc             ,


-- ** SourceOnceFunc #signal:SourceOnceFunc#

    C_SourceOnceFunc                        ,
    SourceOnceFunc                          ,
    SourceOnceFunc_WithClosures             ,
    drop_closures_SourceOnceFunc            ,
    dynamic_SourceOnceFunc                  ,
    genClosure_SourceOnceFunc               ,
    mk_SourceOnceFunc                       ,
    noSourceOnceFunc                        ,
    noSourceOnceFunc_WithClosures           ,
    wrap_SourceOnceFunc                     ,


-- ** SpawnChildSetupFunc #signal:SpawnChildSetupFunc#

    C_SpawnChildSetupFunc                   ,
    SpawnChildSetupFunc                     ,
    dynamic_SpawnChildSetupFunc             ,
    genClosure_SpawnChildSetupFunc          ,
    mk_SpawnChildSetupFunc                  ,
    noSpawnChildSetupFunc                   ,
    wrap_SpawnChildSetupFunc                ,


-- ** TestDataFunc #signal:TestDataFunc#

    C_TestDataFunc                          ,
    TestDataFunc                            ,
    TestDataFunc_WithClosures               ,
    drop_closures_TestDataFunc              ,
    dynamic_TestDataFunc                    ,
    genClosure_TestDataFunc                 ,
    mk_TestDataFunc                         ,
    noTestDataFunc                          ,
    noTestDataFunc_WithClosures             ,
    wrap_TestDataFunc                       ,


-- ** TestFixtureFunc #signal:TestFixtureFunc#

    C_TestFixtureFunc                       ,
    TestFixtureFunc                         ,
    TestFixtureFunc_WithClosures            ,
    drop_closures_TestFixtureFunc           ,
    dynamic_TestFixtureFunc                 ,
    genClosure_TestFixtureFunc              ,
    mk_TestFixtureFunc                      ,
    noTestFixtureFunc                       ,
    noTestFixtureFunc_WithClosures          ,
    wrap_TestFixtureFunc                    ,


-- ** TestFunc #signal:TestFunc#

    C_TestFunc                              ,
    TestFunc                                ,
    dynamic_TestFunc                        ,
    genClosure_TestFunc                     ,
    mk_TestFunc                             ,
    noTestFunc                              ,
    wrap_TestFunc                           ,


-- ** TestLogFatalFunc #signal:TestLogFatalFunc#

    C_TestLogFatalFunc                      ,
    TestLogFatalFunc                        ,
    TestLogFatalFunc_WithClosures           ,
    drop_closures_TestLogFatalFunc          ,
    dynamic_TestLogFatalFunc                ,
    genClosure_TestLogFatalFunc             ,
    mk_TestLogFatalFunc                     ,
    noTestLogFatalFunc                      ,
    noTestLogFatalFunc_WithClosures         ,
    wrap_TestLogFatalFunc                   ,


-- ** ThreadFunc #signal:ThreadFunc#

    C_ThreadFunc                            ,
    ThreadFunc                              ,
    dynamic_ThreadFunc                      ,
    genClosure_ThreadFunc                   ,
    mk_ThreadFunc                           ,
    noThreadFunc                            ,
    wrap_ThreadFunc                         ,


-- ** TranslateFunc #signal:TranslateFunc#

    C_TranslateFunc                         ,
    TranslateFunc                           ,
    dynamic_TranslateFunc                   ,
    genClosure_TranslateFunc                ,
    mk_TranslateFunc                        ,
    noTranslateFunc                         ,
    wrap_TranslateFunc                      ,


-- ** TraverseFunc #signal:TraverseFunc#

    C_TraverseFunc                          ,
    TraverseFunc                            ,
    dynamic_TraverseFunc                    ,
    genClosure_TraverseFunc                 ,
    mk_TraverseFunc                         ,
    noTraverseFunc                          ,
    wrap_TraverseFunc                       ,


-- ** TraverseNodeFunc #signal:TraverseNodeFunc#

    C_TraverseNodeFunc                      ,
    TraverseNodeFunc                        ,
    dynamic_TraverseNodeFunc                ,
    genClosure_TraverseNodeFunc             ,
    mk_TraverseNodeFunc                     ,
    noTraverseNodeFunc                      ,
    wrap_TraverseNodeFunc                   ,


-- ** UnixFDSourceFunc #signal:UnixFDSourceFunc#

    C_UnixFDSourceFunc                      ,
    UnixFDSourceFunc                        ,
    UnixFDSourceFunc_WithClosures           ,
    drop_closures_UnixFDSourceFunc          ,
    dynamic_UnixFDSourceFunc                ,
    genClosure_UnixFDSourceFunc             ,
    mk_UnixFDSourceFunc                     ,
    noUnixFDSourceFunc                      ,
    noUnixFDSourceFunc_WithClosures         ,
    wrap_UnixFDSourceFunc                   ,


-- ** VoidFunc #signal:VoidFunc#

    C_VoidFunc                              ,
    VoidFunc                                ,
    dynamic_VoidFunc                        ,
    genClosure_VoidFunc                     ,
    mk_VoidFunc                             ,
    noVoidFunc                              ,
    wrap_VoidFunc                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Allocator as GLib.Allocator
import {-# SOURCE #-} qualified GI.GLib.Structs.Bytes as GLib.Bytes
import {-# SOURCE #-} qualified GI.GLib.Structs.Cond as GLib.Cond
import {-# SOURCE #-} qualified GI.GLib.Structs.Data as GLib.Data
import {-# SOURCE #-} qualified GI.GLib.Structs.Hook as GLib.Hook
import {-# SOURCE #-} qualified GI.GLib.Structs.HookList as GLib.HookList
import {-# SOURCE #-} qualified GI.GLib.Structs.IOChannel as GLib.IOChannel
import {-# SOURCE #-} qualified GI.GLib.Structs.LogField as GLib.LogField
import {-# SOURCE #-} qualified GI.GLib.Structs.MainContext as GLib.MainContext
import {-# SOURCE #-} qualified GI.GLib.Structs.MarkupParseContext as GLib.MarkupParseContext
import {-# SOURCE #-} qualified GI.GLib.Structs.MarkupParser as GLib.MarkupParser
import {-# SOURCE #-} qualified GI.GLib.Structs.MatchInfo as GLib.MatchInfo
import {-# SOURCE #-} qualified GI.GLib.Structs.Node as GLib.Node
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionContext as GLib.OptionContext
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionEntry as GLib.OptionEntry
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Regex as GLib.Regex
import {-# SOURCE #-} qualified GI.GLib.Structs.Scanner as GLib.Scanner
import {-# SOURCE #-} qualified GI.GLib.Structs.ScannerConfig as GLib.ScannerConfig
import {-# SOURCE #-} qualified GI.GLib.Structs.Sequence as GLib.Sequence
import {-# SOURCE #-} qualified GI.GLib.Structs.SequenceIter as GLib.SequenceIter
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceCallbackFuncs as GLib.SourceCallbackFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.SourceFuncs as GLib.SourceFuncs
import {-# SOURCE #-} qualified GI.GLib.Structs.String as GLib.String
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal
import {-# SOURCE #-} qualified GI.GLib.Structs.TreeNode as GLib.TreeNode
import {-# SOURCE #-} qualified GI.GLib.Unions.Mutex as GLib.Mutex
import {-# SOURCE #-} qualified GI.GLib.Unions.TokenValue as GLib.TokenValue

#else
import {-# SOURCE #-} qualified GI.GLib.Enums as GLib.Enums
import {-# SOURCE #-} qualified GI.GLib.Flags as GLib.Flags
import {-# SOURCE #-} qualified GI.GLib.Structs.Hook as GLib.Hook
import {-# SOURCE #-} qualified GI.GLib.Structs.HookList as GLib.HookList
import {-# SOURCE #-} qualified GI.GLib.Structs.IOChannel as GLib.IOChannel
import {-# SOURCE #-} qualified GI.GLib.Structs.LogField as GLib.LogField
import {-# SOURCE #-} qualified GI.GLib.Structs.MarkupParseContext as GLib.MarkupParseContext
import {-# SOURCE #-} qualified GI.GLib.Structs.MatchInfo as GLib.MatchInfo
import {-# SOURCE #-} qualified GI.GLib.Structs.Node as GLib.Node
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionContext as GLib.OptionContext
import {-# SOURCE #-} qualified GI.GLib.Structs.OptionGroup as GLib.OptionGroup
import {-# SOURCE #-} qualified GI.GLib.Structs.PollFD as GLib.PollFD
import {-# SOURCE #-} qualified GI.GLib.Structs.Scanner as GLib.Scanner
import {-# SOURCE #-} qualified GI.GLib.Structs.SequenceIter as GLib.SequenceIter
import {-# SOURCE #-} qualified GI.GLib.Structs.Source as GLib.Source
import {-# SOURCE #-} qualified GI.GLib.Structs.String as GLib.String
import {-# SOURCE #-} qualified GI.GLib.Structs.TreeNode as GLib.TreeNode

#endif

-- callback VoidFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args = []
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Declares a type of function which takes no arguments\nand has no return value. It is used to specify the type\nfunction passed to g_atexit()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_VoidFunc =
    IO ()

-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_VoidFunc :: FunPtr C_VoidFunc -> C_VoidFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_VoidFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_VoidFunc
    -> m ()
dynamic_VoidFunc __funPtr = liftIO $ do
    (__dynamic_C_VoidFunc __funPtr)
    return ()

-- | Generate a function pointer callable from C code, from a `C_VoidFunc`.
foreign import ccall "wrapper"
    mk_VoidFunc :: C_VoidFunc -> IO (FunPtr C_VoidFunc)

-- | Declares a type of function which takes no arguments
-- and has no return value. It is used to specify the type
-- function passed to 'GI.GLib.Functions.atexit'.
type VoidFunc =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `VoidFunc`@.
noVoidFunc :: Maybe VoidFunc
noVoidFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_VoidFunc :: MonadIO m => VoidFunc -> m (GClosure C_VoidFunc)
genClosure_VoidFunc cb = liftIO $ do
    let cb' = wrap_VoidFunc Nothing cb
    mk_VoidFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `VoidFunc` into a `C_VoidFunc`.
wrap_VoidFunc :: 
    Maybe (Ptr (FunPtr C_VoidFunc)) ->
    VoidFunc ->
    C_VoidFunc
wrap_VoidFunc gi'funptrptr gi'cb = do
    gi'cb 
    maybeReleaseFunPtr gi'funptrptr


-- callback UnixFDSourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%FALSE if the source should be removed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "fd"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the fd that triggered the event"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "condition"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOCondition" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the IO conditions reported on @fd"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_unix_fd_add()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of functions to be called when a UNIX fd watch source\ntriggers."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_UnixFDSourceFunc =
    Int32 ->
    CUInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "fd"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the fd that triggered the event"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the IO conditions reported on @fd"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_unix_fd_add()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_UnixFDSourceFunc :: FunPtr C_UnixFDSourceFunc -> C_UnixFDSourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_UnixFDSourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_UnixFDSourceFunc
    -> Int32
    -- ^ /@fd@/: the fd that triggered the event
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the IO conditions reported on /@fd@/
    -> Ptr ()
    -- ^ /@userData@/: user data passed to @/g_unix_fd_add()/@
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed
dynamic_UnixFDSourceFunc __funPtr fd condition userData = liftIO $ do
    let condition' = gflagsToWord condition
    result <- (__dynamic_C_UnixFDSourceFunc __funPtr) fd condition' userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_UnixFDSourceFunc`.
foreign import ccall "wrapper"
    mk_UnixFDSourceFunc :: C_UnixFDSourceFunc -> IO (FunPtr C_UnixFDSourceFunc)

-- | The type of functions to be called when a UNIX fd watch source
-- triggers.
type UnixFDSourceFunc =
    Int32
    -- ^ /@fd@/: the fd that triggered the event
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the IO conditions reported on /@fd@/
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnixFDSourceFunc`@.
noUnixFDSourceFunc :: Maybe UnixFDSourceFunc
noUnixFDSourceFunc = Nothing

-- | The type of functions to be called when a UNIX fd watch source
-- triggers.
type UnixFDSourceFunc_WithClosures =
    Int32
    -- ^ /@fd@/: the fd that triggered the event
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the IO conditions reported on /@fd@/
    -> Ptr ()
    -- ^ /@userData@/: user data passed to @/g_unix_fd_add()/@
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed

-- | A convenience synonym for @`Nothing` :: `Maybe` `UnixFDSourceFunc_WithClosures`@.
noUnixFDSourceFunc_WithClosures :: Maybe UnixFDSourceFunc_WithClosures
noUnixFDSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_UnixFDSourceFunc :: UnixFDSourceFunc -> UnixFDSourceFunc_WithClosures
drop_closures_UnixFDSourceFunc _f fd condition _ = _f fd condition

-- | Wrap the callback into a `GClosure`.
genClosure_UnixFDSourceFunc :: MonadIO m => UnixFDSourceFunc -> m (GClosure C_UnixFDSourceFunc)
genClosure_UnixFDSourceFunc cb = liftIO $ do
    let cb' = drop_closures_UnixFDSourceFunc cb
    let cb'' = wrap_UnixFDSourceFunc Nothing cb'
    mk_UnixFDSourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `UnixFDSourceFunc` into a `C_UnixFDSourceFunc`.
wrap_UnixFDSourceFunc :: 
    Maybe (Ptr (FunPtr C_UnixFDSourceFunc)) ->
    UnixFDSourceFunc_WithClosures ->
    C_UnixFDSourceFunc
wrap_UnixFDSourceFunc gi'funptrptr gi'cb fd condition userData = do
    let condition' = wordToGFlags condition
    result <- gi'cb  fd condition' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TraverseNodeFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop the traversal"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "node"
          , argType =
              TInterface Name { namespace = "GLib" , name = "TreeNode" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GTreeNode" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_tree_foreach_node()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_tree_foreach_node(). It is\npassed each node, together with the @user_data parameter passed to\ng_tree_foreach_node(). If the function returns %TRUE, the traversal is\nstopped."
        , sinceVersion = Just "2.68"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TraverseNodeFunc =
    Ptr GLib.TreeNode.TreeNode ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TreeNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTreeNode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_tree_foreach_node()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TraverseNodeFunc :: FunPtr C_TraverseNodeFunc -> C_TraverseNodeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TraverseNodeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TraverseNodeFunc
    -> GLib.TreeNode.TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.TreeNode.TreeNode'
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Tree.treeForeachNode'
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal
dynamic_TraverseNodeFunc __funPtr node data_ = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- (__dynamic_C_TraverseNodeFunc __funPtr) node' data_
    let result' = (/= 0) result
    touchManagedPtr node
    return result'

-- | Generate a function pointer callable from C code, from a `C_TraverseNodeFunc`.
foreign import ccall "wrapper"
    mk_TraverseNodeFunc :: C_TraverseNodeFunc -> IO (FunPtr C_TraverseNodeFunc)

-- | Specifies the type of function passed to 'GI.GLib.Structs.Tree.treeForeachNode'. It is
-- passed each node, together with the /@userData@/ parameter passed to
-- 'GI.GLib.Structs.Tree.treeForeachNode'. If the function returns 'P.True', the traversal is
-- stopped.
-- 
-- /Since: 2.68/
type TraverseNodeFunc =
    GLib.TreeNode.TreeNode
    -- ^ /@node@/: a t'GI.GLib.Structs.TreeNode.TreeNode'
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Tree.treeForeachNode'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal

-- | A convenience synonym for @`Nothing` :: `Maybe` `TraverseNodeFunc`@.
noTraverseNodeFunc :: Maybe TraverseNodeFunc
noTraverseNodeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TraverseNodeFunc :: MonadIO m => TraverseNodeFunc -> m (GClosure C_TraverseNodeFunc)
genClosure_TraverseNodeFunc cb = liftIO $ do
    let cb' = wrap_TraverseNodeFunc Nothing cb
    mk_TraverseNodeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TraverseNodeFunc` into a `C_TraverseNodeFunc`.
wrap_TraverseNodeFunc :: 
    Maybe (Ptr (FunPtr C_TraverseNodeFunc)) ->
    TraverseNodeFunc ->
    C_TraverseNodeFunc
wrap_TraverseNodeFunc gi'funptrptr gi'cb node data_ = do
    node' <- (newPtr GLib.TreeNode.TreeNode) node
    result <- gi'cb  node' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TraverseFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop the traversal"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a key of a #GTree node"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the value corresponding to the key"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_tree_traverse()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_tree_traverse(). It is\npassed the key and value of each node, together with the @user_data\nparameter passed to g_tree_traverse(). If the function returns\n%TRUE, the traversal is stopped."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TraverseFunc =
    Ptr () ->
    Ptr () ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key of a #GTree node"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_tree_traverse()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TraverseFunc :: FunPtr C_TraverseFunc -> C_TraverseFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TraverseFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TraverseFunc
    -> Ptr ()
    -- ^ /@key@/: a key of a t'GI.GLib.Structs.Tree.Tree' node
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Tree.treeTraverse'
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal
dynamic_TraverseFunc __funPtr key value data_ = liftIO $ do
    result <- (__dynamic_C_TraverseFunc __funPtr) key value data_
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_TraverseFunc`.
foreign import ccall "wrapper"
    mk_TraverseFunc :: C_TraverseFunc -> IO (FunPtr C_TraverseFunc)

-- | Specifies the type of function passed to 'GI.GLib.Structs.Tree.treeTraverse'. It is
-- passed the key and value of each node, together with the /@userData@/
-- parameter passed to 'GI.GLib.Structs.Tree.treeTraverse'. If the function returns
-- 'P.True', the traversal is stopped.
type TraverseFunc =
    Ptr ()
    -- ^ /@key@/: a key of a t'GI.GLib.Structs.Tree.Tree' node
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Tree.treeTraverse'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal

-- | A convenience synonym for @`Nothing` :: `Maybe` `TraverseFunc`@.
noTraverseFunc :: Maybe TraverseFunc
noTraverseFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TraverseFunc :: MonadIO m => TraverseFunc -> m (GClosure C_TraverseFunc)
genClosure_TraverseFunc cb = liftIO $ do
    let cb' = wrap_TraverseFunc Nothing cb
    mk_TraverseFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TraverseFunc` into a `C_TraverseFunc`.
wrap_TraverseFunc :: 
    Maybe (Ptr (FunPtr C_TraverseFunc)) ->
    TraverseFunc ->
    C_TraverseFunc
wrap_TraverseFunc gi'funptrptr gi'cb key value data_ = do
    result <- gi'cb  key value data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TranslateFunc
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "a translation of the string for the current locale.\n The returned string is owned by GLib and must not be freed."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "str"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the untranslated string"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data specified when installing the function, e.g.\n in g_option_group_set_translate_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of functions which are used to translate user-visible\nstrings, for <option>--help</option> output."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TranslateFunc =
    CString ->
    Ptr () ->
    IO CString

-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the untranslated string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data specified when installing the function, e.g.\n in g_option_group_set_translate_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TranslateFunc :: FunPtr C_TranslateFunc -> C_TranslateFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TranslateFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TranslateFunc
    -> T.Text
    -- ^ /@str@/: the untranslated string
    -> Ptr ()
    -- ^ /@data@/: user data specified when installing the function, e.g.
    --  in 'GI.GLib.Structs.OptionGroup.optionGroupSetTranslateFunc'
    -> m T.Text
    -- ^ __Returns:__ a translation of the string for the current locale.
    --  The returned string is owned by GLib and must not be freed.
dynamic_TranslateFunc __funPtr str data_ = liftIO $ do
    str' <- textToCString str
    result <- (__dynamic_C_TranslateFunc __funPtr) str' data_
    checkUnexpectedReturnNULL "translateFunc" result
    result' <- cstringToText result
    freeMem str'
    return result'

-- | Generate a function pointer callable from C code, from a `C_TranslateFunc`.
foreign import ccall "wrapper"
    mk_TranslateFunc :: C_TranslateFunc -> IO (FunPtr C_TranslateFunc)

-- | The type of functions which are used to translate user-visible
-- strings, for \<option>--help\<\/option> output.
type TranslateFunc =
    T.Text
    -- ^ /@str@/: the untranslated string
    -> Ptr ()
    -- ^ /@data@/: user data specified when installing the function, e.g.
    --  in 'GI.GLib.Structs.OptionGroup.optionGroupSetTranslateFunc'
    -> IO T.Text
    -- ^ __Returns:__ a translation of the string for the current locale.
    --  The returned string is owned by GLib and must not be freed.

-- | A convenience synonym for @`Nothing` :: `Maybe` `TranslateFunc`@.
noTranslateFunc :: Maybe TranslateFunc
noTranslateFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TranslateFunc :: MonadIO m => TranslateFunc -> m (GClosure C_TranslateFunc)
genClosure_TranslateFunc cb = liftIO $ do
    let cb' = wrap_TranslateFunc Nothing cb
    mk_TranslateFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TranslateFunc` into a `C_TranslateFunc`.
wrap_TranslateFunc :: 
    Maybe (Ptr (FunPtr C_TranslateFunc)) ->
    TranslateFunc ->
    C_TranslateFunc
wrap_TranslateFunc gi'funptrptr gi'cb str data_ = do
    str' <- cstringToText str
    result <- gi'cb  str' data_
    maybeReleaseFunPtr gi'funptrptr
    result' <- textToCString result
    return result'


-- callback ThreadFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the return value of the thread"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "data passed to the thread"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the @func functions passed to g_thread_new()\nor g_thread_try_new()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ThreadFunc =
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data passed to the thread"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ThreadFunc :: FunPtr C_ThreadFunc -> C_ThreadFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ThreadFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ThreadFunc
    -> Ptr ()
    -- ^ /@data@/: data passed to the thread
    -> m (Ptr ())
    -- ^ __Returns:__ the return value of the thread
dynamic_ThreadFunc __funPtr data_ = liftIO $ do
    result <- (__dynamic_C_ThreadFunc __funPtr) data_
    return result

-- | Generate a function pointer callable from C code, from a `C_ThreadFunc`.
foreign import ccall "wrapper"
    mk_ThreadFunc :: C_ThreadFunc -> IO (FunPtr C_ThreadFunc)

-- | Specifies the type of the /@func@/ functions passed to 'GI.GLib.Structs.Thread.threadNew'
-- or 'GI.GLib.Structs.Thread.threadTryNew'.
type ThreadFunc =
    Ptr ()
    -- ^ /@data@/: data passed to the thread
    -> IO (Ptr ())
    -- ^ __Returns:__ the return value of the thread

-- | A convenience synonym for @`Nothing` :: `Maybe` `ThreadFunc`@.
noThreadFunc :: Maybe ThreadFunc
noThreadFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ThreadFunc :: MonadIO m => ThreadFunc -> m (GClosure C_ThreadFunc)
genClosure_ThreadFunc cb = liftIO $ do
    let cb' = wrap_ThreadFunc Nothing cb
    mk_ThreadFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ThreadFunc` into a `C_ThreadFunc`.
wrap_ThreadFunc :: 
    Maybe (Ptr (FunPtr C_ThreadFunc)) ->
    ThreadFunc ->
    C_ThreadFunc
wrap_ThreadFunc gi'funptrptr gi'cb data_ = do
    result <- gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback TestLogFatalFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if the program should abort, %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "log_domain"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the log domain of the message"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "log_level"
          , argType =
              TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the log level of the message (including the fatal and recursion flags)"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "message"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the message to process"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data, set in g_test_log_set_fatal_handler()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Specifies the prototype of fatal log handler functions."
        , sinceVersion = Just "2.22"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TestLogFatalFunc =
    CString ->
    CInt ->
    CString ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the log level of the message (including the fatal and recursion flags)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message to process"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data, set in g_test_log_set_fatal_handler()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TestLogFatalFunc :: FunPtr C_TestLogFatalFunc -> C_TestLogFatalFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TestLogFatalFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TestLogFatalFunc
    -> T.Text
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> Ptr ()
    -- ^ /@userData@/: user data, set in @/g_test_log_set_fatal_handler()/@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the program should abort, 'P.False' otherwise
dynamic_TestLogFatalFunc __funPtr logDomain logLevel message userData = liftIO $ do
    logDomain' <- textToCString logDomain
    let logLevel' = gflagsToWord logLevel
    message' <- textToCString message
    result <- (__dynamic_C_TestLogFatalFunc __funPtr) logDomain' logLevel' message' userData
    let result' = (/= 0) result
    freeMem logDomain'
    freeMem message'
    return result'

-- | Generate a function pointer callable from C code, from a `C_TestLogFatalFunc`.
foreign import ccall "wrapper"
    mk_TestLogFatalFunc :: C_TestLogFatalFunc -> IO (FunPtr C_TestLogFatalFunc)

-- | Specifies the prototype of fatal log handler functions.
-- 
-- /Since: 2.22/
type TestLogFatalFunc =
    T.Text
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the program should abort, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestLogFatalFunc`@.
noTestLogFatalFunc :: Maybe TestLogFatalFunc
noTestLogFatalFunc = Nothing

-- | Specifies the prototype of fatal log handler functions.
-- 
-- /Since: 2.22/
type TestLogFatalFunc_WithClosures =
    T.Text
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> Ptr ()
    -- ^ /@userData@/: user data, set in @/g_test_log_set_fatal_handler()/@
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the program should abort, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestLogFatalFunc_WithClosures`@.
noTestLogFatalFunc_WithClosures :: Maybe TestLogFatalFunc_WithClosures
noTestLogFatalFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TestLogFatalFunc :: TestLogFatalFunc -> TestLogFatalFunc_WithClosures
drop_closures_TestLogFatalFunc _f logDomain logLevel message _ = _f logDomain logLevel message

-- | Wrap the callback into a `GClosure`.
genClosure_TestLogFatalFunc :: MonadIO m => TestLogFatalFunc -> m (GClosure C_TestLogFatalFunc)
genClosure_TestLogFatalFunc cb = liftIO $ do
    let cb' = drop_closures_TestLogFatalFunc cb
    let cb'' = wrap_TestLogFatalFunc Nothing cb'
    mk_TestLogFatalFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TestLogFatalFunc` into a `C_TestLogFatalFunc`.
wrap_TestLogFatalFunc :: 
    Maybe (Ptr (FunPtr C_TestLogFatalFunc)) ->
    TestLogFatalFunc_WithClosures ->
    C_TestLogFatalFunc
wrap_TestLogFatalFunc gi'funptrptr gi'cb logDomain logLevel message userData = do
    logDomain' <- cstringToText logDomain
    let logLevel' = wordToGFlags logLevel
    message' <- cstringToText message
    result <- gi'cb  logDomain' logLevel' message' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback TestFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args = []
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText = Just "The type used for test case functions."
        , sinceVersion = Just "2.28"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TestFunc =
    IO ()

-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TestFunc :: FunPtr C_TestFunc -> C_TestFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TestFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TestFunc
    -> m ()
dynamic_TestFunc __funPtr = liftIO $ do
    (__dynamic_C_TestFunc __funPtr)
    return ()

-- | Generate a function pointer callable from C code, from a `C_TestFunc`.
foreign import ccall "wrapper"
    mk_TestFunc :: C_TestFunc -> IO (FunPtr C_TestFunc)

-- | The type used for test case functions.
-- 
-- /Since: 2.28/
type TestFunc =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestFunc`@.
noTestFunc :: Maybe TestFunc
noTestFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_TestFunc :: MonadIO m => TestFunc -> m (GClosure C_TestFunc)
genClosure_TestFunc cb = liftIO $ do
    let cb' = wrap_TestFunc Nothing cb
    mk_TestFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `TestFunc` into a `C_TestFunc`.
wrap_TestFunc :: 
    Maybe (Ptr (FunPtr C_TestFunc)) ->
    TestFunc ->
    C_TestFunc
wrap_TestFunc gi'funptrptr gi'cb = do
    gi'cb 
    maybeReleaseFunPtr gi'funptrptr


-- callback TestFixtureFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "fixture"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the test fixture" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data provided when registering the test"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type used for functions that operate on test fixtures.\n\nThis is used for the fixture setup and teardown functions\nas well as for the testcases themselves.\n\n@user_data is a pointer to the data that was given when\nregistering the test case.\n\n@fixture will be a pointer to the area of memory allocated by the\ntest framework, of the size requested.  If the requested size was\nzero then @fixture will be equal to @user_data."
        , sinceVersion = Just "2.28"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TestFixtureFunc =
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "fixture"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the test fixture" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data provided when registering the test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TestFixtureFunc :: FunPtr C_TestFixtureFunc -> C_TestFixtureFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TestFixtureFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TestFixtureFunc
    -> Ptr ()
    -- ^ /@fixture@/: the test fixture
    -> Ptr ()
    -- ^ /@userData@/: the data provided when registering the test
    -> m ()
dynamic_TestFixtureFunc __funPtr fixture userData = liftIO $ do
    (__dynamic_C_TestFixtureFunc __funPtr) fixture userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_TestFixtureFunc`.
foreign import ccall "wrapper"
    mk_TestFixtureFunc :: C_TestFixtureFunc -> IO (FunPtr C_TestFixtureFunc)

-- | The type used for functions that operate on test fixtures.
-- 
-- This is used for the fixture setup and teardown functions
-- as well as for the testcases themselves.
-- 
-- /@userData@/ is a pointer to the data that was given when
-- registering the test case.
-- 
-- /@fixture@/ will be a pointer to the area of memory allocated by the
-- test framework, of the size requested.  If the requested size was
-- zero then /@fixture@/ will be equal to /@userData@/.
-- 
-- /Since: 2.28/
type TestFixtureFunc =
    Ptr ()
    -- ^ /@fixture@/: the test fixture
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestFixtureFunc`@.
noTestFixtureFunc :: Maybe TestFixtureFunc
noTestFixtureFunc = Nothing

-- | The type used for functions that operate on test fixtures.
-- 
-- This is used for the fixture setup and teardown functions
-- as well as for the testcases themselves.
-- 
-- /@userData@/ is a pointer to the data that was given when
-- registering the test case.
-- 
-- /@fixture@/ will be a pointer to the area of memory allocated by the
-- test framework, of the size requested.  If the requested size was
-- zero then /@fixture@/ will be equal to /@userData@/.
-- 
-- /Since: 2.28/
type TestFixtureFunc_WithClosures =
    Ptr ()
    -- ^ /@fixture@/: the test fixture
    -> Ptr ()
    -- ^ /@userData@/: the data provided when registering the test
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestFixtureFunc_WithClosures`@.
noTestFixtureFunc_WithClosures :: Maybe TestFixtureFunc_WithClosures
noTestFixtureFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TestFixtureFunc :: TestFixtureFunc -> TestFixtureFunc_WithClosures
drop_closures_TestFixtureFunc _f fixture _ = _f fixture

-- | Wrap the callback into a `GClosure`.
genClosure_TestFixtureFunc :: MonadIO m => TestFixtureFunc -> m (GClosure C_TestFixtureFunc)
genClosure_TestFixtureFunc cb = liftIO $ do
    let cb' = drop_closures_TestFixtureFunc cb
    let cb'' = wrap_TestFixtureFunc Nothing cb'
    mk_TestFixtureFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TestFixtureFunc` into a `C_TestFixtureFunc`.
wrap_TestFixtureFunc :: 
    Maybe (Ptr (FunPtr C_TestFixtureFunc)) ->
    TestFixtureFunc_WithClosures ->
    C_TestFixtureFunc
wrap_TestFixtureFunc gi'funptrptr gi'cb fixture userData = do
    gi'cb  fixture userData
    maybeReleaseFunPtr gi'funptrptr


-- callback TestDataFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data provided when registering the test"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type used for test case functions that take an extra pointer\nargument."
        , sinceVersion = Just "2.28"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_TestDataFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data provided when registering the test"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_TestDataFunc :: FunPtr C_TestDataFunc -> C_TestDataFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_TestDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_TestDataFunc
    -> Ptr ()
    -- ^ /@userData@/: the data provided when registering the test
    -> m ()
dynamic_TestDataFunc __funPtr userData = liftIO $ do
    (__dynamic_C_TestDataFunc __funPtr) userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_TestDataFunc`.
foreign import ccall "wrapper"
    mk_TestDataFunc :: C_TestDataFunc -> IO (FunPtr C_TestDataFunc)

-- | The type used for test case functions that take an extra pointer
-- argument.
-- 
-- /Since: 2.28/
type TestDataFunc =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestDataFunc`@.
noTestDataFunc :: Maybe TestDataFunc
noTestDataFunc = Nothing

-- | The type used for test case functions that take an extra pointer
-- argument.
-- 
-- /Since: 2.28/
type TestDataFunc_WithClosures =
    Ptr ()
    -- ^ /@userData@/: the data provided when registering the test
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `TestDataFunc_WithClosures`@.
noTestDataFunc_WithClosures :: Maybe TestDataFunc_WithClosures
noTestDataFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_TestDataFunc :: TestDataFunc -> TestDataFunc_WithClosures
drop_closures_TestDataFunc _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_TestDataFunc :: MonadIO m => TestDataFunc -> m (GClosure C_TestDataFunc)
genClosure_TestDataFunc cb = liftIO $ do
    let cb' = drop_closures_TestDataFunc cb
    let cb'' = wrap_TestDataFunc Nothing cb'
    mk_TestDataFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `TestDataFunc` into a `C_TestDataFunc`.
wrap_TestDataFunc :: 
    Maybe (Ptr (FunPtr C_TestDataFunc)) ->
    TestDataFunc_WithClosures ->
    C_TestDataFunc
wrap_TestDataFunc gi'funptrptr gi'cb userData = do
    gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr


-- callback SpawnChildSetupFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the function."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the setup function passed to g_spawn_async(),\ng_spawn_sync() and g_spawn_async_with_pipes(), which can, in very\nlimited ways, be used to affect the child's execution.\n\nOn POSIX platforms, the function is called in the child after GLib\nhas performed all the setup it plans to perform, but before calling\nexec(). Actions taken in this function will only affect the child,\nnot the parent.\n\nOn Windows, the function is called in the parent. Its usefulness on\nWindows is thus questionable. In many cases executing the child setup\nfunction in the parent can have ill effects, and you should be very\ncareful when porting software to Windows that uses child setup\nfunctions.\n\nHowever, even on POSIX, you are extremely limited in what you can\nsafely do from a #GSpawnChildSetupFunc, because any mutexes that were\nheld by other threads in the parent process at the time of the fork()\nwill still be locked in the child process, and they will never be\nunlocked (since the threads that held them don't exist in the child).\nPOSIX allows only async-signal-safe functions (see signal(7)) to be\ncalled in the child between fork() and exec(), which drastically limits\nthe usefulness of child setup functions.\n\nIn particular, it is not safe to call any function which may\ncall malloc(), which includes POSIX functions such as setenv().\nIf you need to set up the child environment differently from\nthe parent, you should use g_get_environ(), g_environ_setenv(),\nand g_environ_unsetenv(), and then pass the complete environment\nlist to the `g_spawn...` function."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SpawnChildSetupFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the function."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SpawnChildSetupFunc :: FunPtr C_SpawnChildSetupFunc -> C_SpawnChildSetupFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SpawnChildSetupFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SpawnChildSetupFunc
    -> Ptr ()
    -- ^ /@data@/: user data passed to the function.
    -> m ()
dynamic_SpawnChildSetupFunc __funPtr data_ = liftIO $ do
    (__dynamic_C_SpawnChildSetupFunc __funPtr) data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_SpawnChildSetupFunc`.
foreign import ccall "wrapper"
    mk_SpawnChildSetupFunc :: C_SpawnChildSetupFunc -> IO (FunPtr C_SpawnChildSetupFunc)

-- | Specifies the type of the setup function passed to 'GI.GLib.Functions.spawnAsync',
-- 'GI.GLib.Functions.spawnSync' and 'GI.GLib.Functions.spawnAsyncWithPipes', which can, in very
-- limited ways, be used to affect the child\'s execution.
-- 
-- On POSIX platforms, the function is called in the child after GLib
-- has performed all the setup it plans to perform, but before calling
-- @/exec()/@. Actions taken in this function will only affect the child,
-- not the parent.
-- 
-- On Windows, the function is called in the parent. Its usefulness on
-- Windows is thus questionable. In many cases executing the child setup
-- function in the parent can have ill effects, and you should be very
-- careful when porting software to Windows that uses child setup
-- functions.
-- 
-- However, even on POSIX, you are extremely limited in what you can
-- safely do from a t'GI.GLib.Callbacks.SpawnChildSetupFunc', because any mutexes that were
-- held by other threads in the parent process at the time of the @/fork()/@
-- will still be locked in the child process, and they will never be
-- unlocked (since the threads that held them don\'t exist in the child).
-- POSIX allows only async-signal-safe functions (see signal(7)) to be
-- called in the child between @/fork()/@ and @/exec()/@, which drastically limits
-- the usefulness of child setup functions.
-- 
-- In particular, it is not safe to call any function which may
-- call @/malloc()/@, which includes POSIX functions such as @/setenv()/@.
-- If you need to set up the child environment differently from
-- the parent, you should use 'GI.GLib.Functions.getEnviron', 'GI.GLib.Functions.environSetenv',
-- and 'GI.GLib.Functions.environUnsetenv', and then pass the complete environment
-- list to the @g_spawn...@ function.
type SpawnChildSetupFunc =
    Ptr ()
    -- ^ /@data@/: user data passed to the function.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SpawnChildSetupFunc`@.
noSpawnChildSetupFunc :: Maybe SpawnChildSetupFunc
noSpawnChildSetupFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SpawnChildSetupFunc :: MonadIO m => SpawnChildSetupFunc -> m (GClosure C_SpawnChildSetupFunc)
genClosure_SpawnChildSetupFunc cb = liftIO $ do
    let cb' = wrap_SpawnChildSetupFunc Nothing cb
    mk_SpawnChildSetupFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SpawnChildSetupFunc` into a `C_SpawnChildSetupFunc`.
wrap_SpawnChildSetupFunc :: 
    Maybe (Ptr (FunPtr C_SpawnChildSetupFunc)) ->
    SpawnChildSetupFunc ->
    C_SpawnChildSetupFunc
wrap_SpawnChildSetupFunc gi'funptrptr gi'cb data_ = do
    gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr


-- callback SourceOnceFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "data passed to the function, set when the source was\n  created"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A source function that is only called once before being removed from the main\ncontext automatically.\n\nSee: [func@GLib.idle_add_once], [func@GLib.timeout_add_once]"
        , sinceVersion = Just "2.74"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceOnceFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "data passed to the function, set when the source was\n  created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceOnceFunc :: FunPtr C_SourceOnceFunc -> C_SourceOnceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceOnceFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceOnceFunc
    -> Ptr ()
    -- ^ /@userData@/: data passed to the function, set when the source was
    --   created
    -> m ()
dynamic_SourceOnceFunc __funPtr userData = liftIO $ do
    (__dynamic_C_SourceOnceFunc __funPtr) userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceOnceFunc`.
foreign import ccall "wrapper"
    mk_SourceOnceFunc :: C_SourceOnceFunc -> IO (FunPtr C_SourceOnceFunc)

-- | A source function that is only called once before being removed from the main
-- context automatically.
-- 
-- See: @/GLib.idle_add_once/@, @/GLib.timeout_add_once/@
-- 
-- /Since: 2.74/
type SourceOnceFunc =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceOnceFunc`@.
noSourceOnceFunc :: Maybe SourceOnceFunc
noSourceOnceFunc = Nothing

-- | A source function that is only called once before being removed from the main
-- context automatically.
-- 
-- See: @/GLib.idle_add_once/@, @/GLib.timeout_add_once/@
-- 
-- /Since: 2.74/
type SourceOnceFunc_WithClosures =
    Ptr ()
    -- ^ /@userData@/: data passed to the function, set when the source was
    --   created
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceOnceFunc_WithClosures`@.
noSourceOnceFunc_WithClosures :: Maybe SourceOnceFunc_WithClosures
noSourceOnceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SourceOnceFunc :: SourceOnceFunc -> SourceOnceFunc_WithClosures
drop_closures_SourceOnceFunc _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_SourceOnceFunc :: MonadIO m => SourceOnceFunc -> m (GClosure C_SourceOnceFunc)
genClosure_SourceOnceFunc cb = liftIO $ do
    let cb' = drop_closures_SourceOnceFunc cb
    let cb'' = wrap_SourceOnceFunc Nothing cb'
    mk_SourceOnceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SourceOnceFunc` into a `C_SourceOnceFunc`.
wrap_SourceOnceFunc :: 
    Maybe (Ptr (FunPtr C_SourceOnceFunc)) ->
    SourceOnceFunc_WithClosures ->
    C_SourceOnceFunc
wrap_SourceOnceFunc gi'funptrptr gi'cb userData = do
    gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr


-- callback SourceFuncsPrepareFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if the source is ready, %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "source"
          , argType =
              TInterface Name { namespace = "GLib" , name = "Source" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "timeout_"
          , argType = TBasicType TInt
          , direction = DirectionOut
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the maximum timeout (in milliseconds) which should be passed to the poll call"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferEverything
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Checks the source for readiness.\n\nCalled before all the file descriptors are polled. If the\nsource can determine that it is ready here (without waiting for the\nresults of the poll call) it should return %TRUE. It can also return\na @timeout_ value which should be the maximum timeout (in milliseconds)\nwhich should be passed to the poll call. The actual timeout used will\nbe `-1` if all sources returned `-1`, or it will be the minimum of all\nthe @timeout_ values returned which were greater than or equal to `0`.\nIf the prepare function returns a timeout and the source also has a\nready time set, then the lower of the two will be used.\n\nSince 2.36 this may be `NULL`, in which case the effect is as if the\nfunction always returns `FALSE` with a timeout of `-1`."
        , sinceVersion = Just "2.82"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceFuncsPrepareFunc =
    Ptr GLib.Source.Source ->
    Ptr Int32 ->
    IO CInt

-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout_"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum timeout (in milliseconds) which should be passed to the poll call"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceFuncsPrepareFunc :: FunPtr C_SourceFuncsPrepareFunc -> C_SourceFuncsPrepareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceFuncsPrepareFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceFuncsPrepareFunc
    -> GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> m ((Bool, Int32))
    -- ^ __Returns:__ 'P.True' if the source is ready, 'P.False' otherwise
dynamic_SourceFuncsPrepareFunc __funPtr source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    timeout_ <- allocMem :: IO (Ptr Int32)
    result <- (__dynamic_C_SourceFuncsPrepareFunc __funPtr) source' timeout_
    let result' = (/= 0) result
    timeout_' <- peek timeout_
    touchManagedPtr source
    freeMem timeout_
    return (result', timeout_')

-- | Generate a function pointer callable from C code, from a `C_SourceFuncsPrepareFunc`.
foreign import ccall "wrapper"
    mk_SourceFuncsPrepareFunc :: C_SourceFuncsPrepareFunc -> IO (FunPtr C_SourceFuncsPrepareFunc)

-- | Checks the source for readiness.
-- 
-- Called before all the file descriptors are polled. If the
-- source can determine that it is ready here (without waiting for the
-- results of the poll call) it should return 'P.True'. It can also return
-- a /@timeout_@/ value which should be the maximum timeout (in milliseconds)
-- which should be passed to the poll call. The actual timeout used will
-- be @-1@ if all sources returned @-1@, or it will be the minimum of all
-- the /@timeout_@/ values returned which were greater than or equal to @0@.
-- If the prepare function returns a timeout and the source also has a
-- ready time set, then the lower of the two will be used.
-- 
-- Since 2.36 this may be @NULL@, in which case the effect is as if the
-- function always returns @FALSE@ with a timeout of @-1@.
-- 
-- /Since: 2.82/
type SourceFuncsPrepareFunc =
    GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> IO ((Bool, Int32))
    -- ^ __Returns:__ 'P.True' if the source is ready, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceFuncsPrepareFunc`@.
noSourceFuncsPrepareFunc :: Maybe SourceFuncsPrepareFunc
noSourceFuncsPrepareFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceFuncsPrepareFunc :: MonadIO m => SourceFuncsPrepareFunc -> m (GClosure C_SourceFuncsPrepareFunc)
genClosure_SourceFuncsPrepareFunc cb = liftIO $ do
    let cb' = wrap_SourceFuncsPrepareFunc Nothing cb
    mk_SourceFuncsPrepareFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceFuncsPrepareFunc` into a `C_SourceFuncsPrepareFunc`.
wrap_SourceFuncsPrepareFunc :: 
    Maybe (Ptr (FunPtr C_SourceFuncsPrepareFunc)) ->
    SourceFuncsPrepareFunc ->
    C_SourceFuncsPrepareFunc
wrap_SourceFuncsPrepareFunc gi'funptrptr gi'cb source timeout_ = do
    B.ManagedPtr.withTransient  source $ \source' -> do
        (result, outtimeout_) <- gi'cb  source'
        poke timeout_ outtimeout_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback SourceFuncsFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "source"
          , argType =
              TInterface Name { namespace = "GLib" , name = "Source" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Finalizes the source.\n\nCalled when the source is finalized. At this point, the source\nwill have been destroyed, had its callback cleared, and have been removed\nfrom its [type@GLib.MainContext], but it will still have its final reference\ncount, so methods can be called on it from within this function."
        , sinceVersion = Just "2.82"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceFuncsFinalizeFunc =
    Ptr GLib.Source.Source ->
    IO ()

-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceFuncsFinalizeFunc :: FunPtr C_SourceFuncsFinalizeFunc -> C_SourceFuncsFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceFuncsFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceFuncsFinalizeFunc
    -> GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> m ()
dynamic_SourceFuncsFinalizeFunc __funPtr source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    (__dynamic_C_SourceFuncsFinalizeFunc __funPtr) source'
    touchManagedPtr source
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceFuncsFinalizeFunc`.
foreign import ccall "wrapper"
    mk_SourceFuncsFinalizeFunc :: C_SourceFuncsFinalizeFunc -> IO (FunPtr C_SourceFuncsFinalizeFunc)

-- | Finalizes the source.
-- 
-- Called when the source is finalized. At this point, the source
-- will have been destroyed, had its callback cleared, and have been removed
-- from its [type/@gLib@/.MainContext], but it will still have its final reference
-- count, so methods can be called on it from within this function.
-- 
-- /Since: 2.82/
type SourceFuncsFinalizeFunc =
    GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceFuncsFinalizeFunc`@.
noSourceFuncsFinalizeFunc :: Maybe SourceFuncsFinalizeFunc
noSourceFuncsFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceFuncsFinalizeFunc :: MonadIO m => SourceFuncsFinalizeFunc -> m (GClosure C_SourceFuncsFinalizeFunc)
genClosure_SourceFuncsFinalizeFunc cb = liftIO $ do
    let cb' = wrap_SourceFuncsFinalizeFunc Nothing cb
    mk_SourceFuncsFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceFuncsFinalizeFunc` into a `C_SourceFuncsFinalizeFunc`.
wrap_SourceFuncsFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_SourceFuncsFinalizeFunc)) ->
    SourceFuncsFinalizeFunc ->
    C_SourceFuncsFinalizeFunc
wrap_SourceFuncsFinalizeFunc gi'funptrptr gi'cb source = do
    B.ManagedPtr.withTransient  source $ \source' -> do
        gi'cb  source'
        maybeReleaseFunPtr gi'funptrptr


-- callback SourceFuncsCheckFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%TRUE if ready to be dispatched, %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "source"
          , argType =
              TInterface Name { namespace = "GLib" , name = "Source" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Checks if the source is ready to be dispatched.\n\nCalled after all the file descriptors are polled. The source\nshould return %TRUE if it is ready to be dispatched. Note that some\ntime may have passed since the previous prepare function was called,\nso the source should be checked again here.\n\nSince 2.36 this may be `NULL`, in which case the effect is\nas if the function always returns `FALSE`."
        , sinceVersion = Just "2.82"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceFuncsCheckFunc =
    Ptr GLib.Source.Source ->
    IO CInt

-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The #GSource" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceFuncsCheckFunc :: FunPtr C_SourceFuncsCheckFunc -> C_SourceFuncsCheckFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceFuncsCheckFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceFuncsCheckFunc
    -> GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> m Bool
    -- ^ __Returns:__ 'P.True' if ready to be dispatched, 'P.False' otherwise
dynamic_SourceFuncsCheckFunc __funPtr source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    result <- (__dynamic_C_SourceFuncsCheckFunc __funPtr) source'
    let result' = (/= 0) result
    touchManagedPtr source
    return result'

-- | Generate a function pointer callable from C code, from a `C_SourceFuncsCheckFunc`.
foreign import ccall "wrapper"
    mk_SourceFuncsCheckFunc :: C_SourceFuncsCheckFunc -> IO (FunPtr C_SourceFuncsCheckFunc)

-- | Checks if the source is ready to be dispatched.
-- 
-- Called after all the file descriptors are polled. The source
-- should return 'P.True' if it is ready to be dispatched. Note that some
-- time may have passed since the previous prepare function was called,
-- so the source should be checked again here.
-- 
-- Since 2.36 this may be @NULL@, in which case the effect is
-- as if the function always returns @FALSE@.
-- 
-- /Since: 2.82/
type SourceFuncsCheckFunc =
    GLib.Source.Source
    -- ^ /@source@/: The t'GI.GLib.Structs.Source.Source'
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if ready to be dispatched, 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceFuncsCheckFunc`@.
noSourceFuncsCheckFunc :: Maybe SourceFuncsCheckFunc
noSourceFuncsCheckFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceFuncsCheckFunc :: MonadIO m => SourceFuncsCheckFunc -> m (GClosure C_SourceFuncsCheckFunc)
genClosure_SourceFuncsCheckFunc cb = liftIO $ do
    let cb' = wrap_SourceFuncsCheckFunc Nothing cb
    mk_SourceFuncsCheckFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceFuncsCheckFunc` into a `C_SourceFuncsCheckFunc`.
wrap_SourceFuncsCheckFunc :: 
    Maybe (Ptr (FunPtr C_SourceFuncsCheckFunc)) ->
    SourceFuncsCheckFunc ->
    C_SourceFuncsCheckFunc
wrap_SourceFuncsCheckFunc gi'funptrptr gi'cb source = do
    B.ManagedPtr.withTransient  source $ \source' -> do
        result <- gi'cb  source'
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback SourceFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%FALSE if the source should be removed.\n[const@GLib.SOURCE_CONTINUE] and [const@GLib.SOURCE_REMOVE] are more\nmemorable names for the return value."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "data passed to the function, set when the source was\n    created with one of the above functions"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to [func@GLib.timeout_add],\n[func@GLib.timeout_add_full], [func@GLib.idle_add], and\n[func@GLib.idle_add_full].\n\nWhen calling [method@GLib.Source.set_callback], you may need to cast a\nfunction of a different type to this type. Use [func@GLib.SOURCE_FUNC] to\navoid warnings about incompatible function types."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceFunc =
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "data passed to the function, set when the source was\n    created with one of the above functions"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceFunc :: FunPtr C_SourceFunc -> C_SourceFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceFunc
    -> Ptr ()
    -- ^ /@userData@/: data passed to the function, set when the source was
    --     created with one of the above functions
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed.
    -- [const/@gLib@/.SOURCE_CONTINUE] and [const/@gLib@/.SOURCE_REMOVE] are more
    -- memorable names for the return value.
dynamic_SourceFunc __funPtr userData = liftIO $ do
    result <- (__dynamic_C_SourceFunc __funPtr) userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_SourceFunc`.
foreign import ccall "wrapper"
    mk_SourceFunc :: C_SourceFunc -> IO (FunPtr C_SourceFunc)

-- | Specifies the type of function passed to 'GI.GLib.Functions.timeoutAdd',
-- @/GLib.timeout_add_full/@, 'GI.GLib.Functions.idleAdd', and
-- @/GLib.idle_add_full/@.
-- 
-- When calling 'GI.GLib.Structs.Source.sourceSetCallback', you may need to cast a
-- function of a different type to this type. Use @/GLib.SOURCE_FUNC/@ to
-- avoid warnings about incompatible function types.
type SourceFunc =
    IO Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed.
    -- [const/@gLib@/.SOURCE_CONTINUE] and [const/@gLib@/.SOURCE_REMOVE] are more
    -- memorable names for the return value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceFunc`@.
noSourceFunc :: Maybe SourceFunc
noSourceFunc = Nothing

-- | Specifies the type of function passed to 'GI.GLib.Functions.timeoutAdd',
-- @/GLib.timeout_add_full/@, 'GI.GLib.Functions.idleAdd', and
-- @/GLib.idle_add_full/@.
-- 
-- When calling 'GI.GLib.Structs.Source.sourceSetCallback', you may need to cast a
-- function of a different type to this type. Use @/GLib.SOURCE_FUNC/@ to
-- avoid warnings about incompatible function types.
type SourceFunc_WithClosures =
    Ptr ()
    -- ^ /@userData@/: data passed to the function, set when the source was
    --     created with one of the above functions
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the source should be removed.
    -- [const/@gLib@/.SOURCE_CONTINUE] and [const/@gLib@/.SOURCE_REMOVE] are more
    -- memorable names for the return value.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceFunc_WithClosures`@.
noSourceFunc_WithClosures :: Maybe SourceFunc_WithClosures
noSourceFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_SourceFunc :: SourceFunc -> SourceFunc_WithClosures
drop_closures_SourceFunc _f _ = _f 

-- | Wrap the callback into a `GClosure`.
genClosure_SourceFunc :: MonadIO m => SourceFunc -> m (GClosure C_SourceFunc)
genClosure_SourceFunc cb = liftIO $ do
    let cb' = drop_closures_SourceFunc cb
    let cb'' = wrap_SourceFunc Nothing cb'
    mk_SourceFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `SourceFunc` into a `C_SourceFunc`.
wrap_SourceFunc :: 
    Maybe (Ptr (FunPtr C_SourceFunc)) ->
    SourceFunc_WithClosures ->
    C_SourceFunc
wrap_SourceFunc gi'funptrptr gi'cb userData = do
    result <- gi'cb  userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback SourceDummyMarshal
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args = []
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "This is just a placeholder for #GClosureMarshal,\nwhich cannot be used here for dependency reasons."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceDummyMarshal =
    IO ()

-- Args: []
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceDummyMarshal :: FunPtr C_SourceDummyMarshal -> C_SourceDummyMarshal

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceDummyMarshal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceDummyMarshal
    -> m ()
dynamic_SourceDummyMarshal __funPtr = liftIO $ do
    (__dynamic_C_SourceDummyMarshal __funPtr)
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceDummyMarshal`.
foreign import ccall "wrapper"
    mk_SourceDummyMarshal :: C_SourceDummyMarshal -> IO (FunPtr C_SourceDummyMarshal)

-- | This is just a placeholder for @/GClosureMarshal/@,
-- which cannot be used here for dependency reasons.
type SourceDummyMarshal =
    IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceDummyMarshal`@.
noSourceDummyMarshal :: Maybe SourceDummyMarshal
noSourceDummyMarshal = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceDummyMarshal :: MonadIO m => SourceDummyMarshal -> m (GClosure C_SourceDummyMarshal)
genClosure_SourceDummyMarshal cb = liftIO $ do
    let cb' = wrap_SourceDummyMarshal Nothing cb
    mk_SourceDummyMarshal cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceDummyMarshal` into a `C_SourceDummyMarshal`.
wrap_SourceDummyMarshal :: 
    Maybe (Ptr (FunPtr C_SourceDummyMarshal)) ->
    SourceDummyMarshal ->
    C_SourceDummyMarshal
wrap_SourceDummyMarshal gi'funptrptr gi'cb = do
    gi'cb 
    maybeReleaseFunPtr gi'funptrptr


-- callback SourceDisposeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "source"
          , argType =
              TInterface Name { namespace = "GLib" , name = "Source" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "#GSource that is currently being disposed"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Dispose function for @source. See [method@GLib.Source.set_dispose_function]\nfor details."
        , sinceVersion = Just "2.64"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceDisposeFunc =
    Ptr GLib.Source.Source ->
    IO ()

-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Source" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#GSource that is currently being disposed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceDisposeFunc :: FunPtr C_SourceDisposeFunc -> C_SourceDisposeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceDisposeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceDisposeFunc
    -> GLib.Source.Source
    -- ^ /@source@/: t'GI.GLib.Structs.Source.Source' that is currently being disposed
    -> m ()
dynamic_SourceDisposeFunc __funPtr source = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    (__dynamic_C_SourceDisposeFunc __funPtr) source'
    touchManagedPtr source
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceDisposeFunc`.
foreign import ccall "wrapper"
    mk_SourceDisposeFunc :: C_SourceDisposeFunc -> IO (FunPtr C_SourceDisposeFunc)

-- | Dispose function for /@source@/. See t'GI.GLib.Structs.Source.Source'.@/set_dispose_function/@()
-- for details.
-- 
-- /Since: 2.64/
type SourceDisposeFunc =
    GLib.Source.Source
    -- ^ /@source@/: t'GI.GLib.Structs.Source.Source' that is currently being disposed
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceDisposeFunc`@.
noSourceDisposeFunc :: Maybe SourceDisposeFunc
noSourceDisposeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceDisposeFunc :: MonadIO m => SourceDisposeFunc -> m (GClosure C_SourceDisposeFunc)
genClosure_SourceDisposeFunc cb = liftIO $ do
    let cb' = wrap_SourceDisposeFunc Nothing cb
    mk_SourceDisposeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceDisposeFunc` into a `C_SourceDisposeFunc`.
wrap_SourceDisposeFunc :: 
    Maybe (Ptr (FunPtr C_SourceDisposeFunc)) ->
    SourceDisposeFunc ->
    C_SourceDisposeFunc
wrap_SourceDisposeFunc gi'funptrptr gi'cb source = do
    B.ManagedPtr.withTransient  source $ \source' -> do
        gi'cb  source'
        maybeReleaseFunPtr gi'funptrptr


-- callback SourceCallbackFuncsUnrefFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "cb_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceCallbackFuncsUnrefFieldCallback =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "cb_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceCallbackFuncsUnrefFieldCallback :: FunPtr C_SourceCallbackFuncsUnrefFieldCallback -> C_SourceCallbackFuncsUnrefFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceCallbackFuncsUnrefFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceCallbackFuncsUnrefFieldCallback
    -> Ptr ()
    -> m ()
dynamic_SourceCallbackFuncsUnrefFieldCallback __funPtr cbData = liftIO $ do
    (__dynamic_C_SourceCallbackFuncsUnrefFieldCallback __funPtr) cbData
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceCallbackFuncsUnrefFieldCallback`.
foreign import ccall "wrapper"
    mk_SourceCallbackFuncsUnrefFieldCallback :: C_SourceCallbackFuncsUnrefFieldCallback -> IO (FunPtr C_SourceCallbackFuncsUnrefFieldCallback)

-- | /No description available in the introspection data./
type SourceCallbackFuncsUnrefFieldCallback =
    Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceCallbackFuncsUnrefFieldCallback`@.
noSourceCallbackFuncsUnrefFieldCallback :: Maybe SourceCallbackFuncsUnrefFieldCallback
noSourceCallbackFuncsUnrefFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceCallbackFuncsUnrefFieldCallback :: MonadIO m => SourceCallbackFuncsUnrefFieldCallback -> m (GClosure C_SourceCallbackFuncsUnrefFieldCallback)
genClosure_SourceCallbackFuncsUnrefFieldCallback cb = liftIO $ do
    let cb' = wrap_SourceCallbackFuncsUnrefFieldCallback Nothing cb
    mk_SourceCallbackFuncsUnrefFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceCallbackFuncsUnrefFieldCallback` into a `C_SourceCallbackFuncsUnrefFieldCallback`.
wrap_SourceCallbackFuncsUnrefFieldCallback :: 
    Maybe (Ptr (FunPtr C_SourceCallbackFuncsUnrefFieldCallback)) ->
    SourceCallbackFuncsUnrefFieldCallback ->
    C_SourceCallbackFuncsUnrefFieldCallback
wrap_SourceCallbackFuncsUnrefFieldCallback gi'funptrptr gi'cb cbData = do
    gi'cb  cbData
    maybeReleaseFunPtr gi'funptrptr


-- callback SourceCallbackFuncsRefFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "cb_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SourceCallbackFuncsRefFieldCallback =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "cb_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SourceCallbackFuncsRefFieldCallback :: FunPtr C_SourceCallbackFuncsRefFieldCallback -> C_SourceCallbackFuncsRefFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SourceCallbackFuncsRefFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SourceCallbackFuncsRefFieldCallback
    -> Ptr ()
    -> m ()
dynamic_SourceCallbackFuncsRefFieldCallback __funPtr cbData = liftIO $ do
    (__dynamic_C_SourceCallbackFuncsRefFieldCallback __funPtr) cbData
    return ()

-- | Generate a function pointer callable from C code, from a `C_SourceCallbackFuncsRefFieldCallback`.
foreign import ccall "wrapper"
    mk_SourceCallbackFuncsRefFieldCallback :: C_SourceCallbackFuncsRefFieldCallback -> IO (FunPtr C_SourceCallbackFuncsRefFieldCallback)

-- | /No description available in the introspection data./
type SourceCallbackFuncsRefFieldCallback =
    Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `SourceCallbackFuncsRefFieldCallback`@.
noSourceCallbackFuncsRefFieldCallback :: Maybe SourceCallbackFuncsRefFieldCallback
noSourceCallbackFuncsRefFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SourceCallbackFuncsRefFieldCallback :: MonadIO m => SourceCallbackFuncsRefFieldCallback -> m (GClosure C_SourceCallbackFuncsRefFieldCallback)
genClosure_SourceCallbackFuncsRefFieldCallback cb = liftIO $ do
    let cb' = wrap_SourceCallbackFuncsRefFieldCallback Nothing cb
    mk_SourceCallbackFuncsRefFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `SourceCallbackFuncsRefFieldCallback` into a `C_SourceCallbackFuncsRefFieldCallback`.
wrap_SourceCallbackFuncsRefFieldCallback :: 
    Maybe (Ptr (FunPtr C_SourceCallbackFuncsRefFieldCallback)) ->
    SourceCallbackFuncsRefFieldCallback ->
    C_SourceCallbackFuncsRefFieldCallback
wrap_SourceCallbackFuncsRefFieldCallback gi'funptrptr gi'cb cbData = do
    gi'cb  cbData
    maybeReleaseFunPtr gi'funptrptr


-- callback SequenceIterCompareFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "zero if the iterators are equal, a negative value if @a\n    comes before @b, and a positive value if @b comes before @a."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "a"
          , argType =
              TInterface Name { namespace = "GLib" , name = "SequenceIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType =
              TInterface Name { namespace = "GLib" , name = "SequenceIter" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A #GSequenceIterCompareFunc is a function used to compare iterators.\nIt must return zero if the iterators compare equal, a negative value\nif @a comes before @b, and a positive value if @b comes before @a."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_SequenceIterCompareFunc =
    Ptr GLib.SequenceIter.SequenceIter ->
    Ptr GLib.SequenceIter.SequenceIter ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SequenceIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GSequenceIter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_SequenceIterCompareFunc :: FunPtr C_SequenceIterCompareFunc -> C_SequenceIterCompareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_SequenceIterCompareFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_SequenceIterCompareFunc
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@a@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@b@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> Ptr ()
    -- ^ /@data@/: user data
    -> m Int32
    -- ^ __Returns:__ zero if the iterators are equal, a negative value if /@a@/
    --     comes before /@b@/, and a positive value if /@b@/ comes before /@a@/.
dynamic_SequenceIterCompareFunc __funPtr a b data_ = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- (__dynamic_C_SequenceIterCompareFunc __funPtr) a' b' data_
    touchManagedPtr a
    touchManagedPtr b
    return result

-- | Generate a function pointer callable from C code, from a `C_SequenceIterCompareFunc`.
foreign import ccall "wrapper"
    mk_SequenceIterCompareFunc :: C_SequenceIterCompareFunc -> IO (FunPtr C_SequenceIterCompareFunc)

-- | A t'GI.GLib.Callbacks.SequenceIterCompareFunc' is a function used to compare iterators.
-- It must return zero if the iterators compare equal, a negative value
-- if /@a@/ comes before /@b@/, and a positive value if /@b@/ comes before /@a@/.
type SequenceIterCompareFunc =
    GLib.SequenceIter.SequenceIter
    -- ^ /@a@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> GLib.SequenceIter.SequenceIter
    -- ^ /@b@/: a t'GI.GLib.Structs.SequenceIter.SequenceIter'
    -> Ptr ()
    -- ^ /@data@/: user data
    -> IO Int32
    -- ^ __Returns:__ zero if the iterators are equal, a negative value if /@a@/
    --     comes before /@b@/, and a positive value if /@b@/ comes before /@a@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `SequenceIterCompareFunc`@.
noSequenceIterCompareFunc :: Maybe SequenceIterCompareFunc
noSequenceIterCompareFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_SequenceIterCompareFunc :: MonadIO m => SequenceIterCompareFunc -> m (GClosure C_SequenceIterCompareFunc)
genClosure_SequenceIterCompareFunc cb = liftIO $ do
    let cb' = wrap_SequenceIterCompareFunc Nothing cb
    mk_SequenceIterCompareFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `SequenceIterCompareFunc` into a `C_SequenceIterCompareFunc`.
wrap_SequenceIterCompareFunc :: 
    Maybe (Ptr (FunPtr C_SequenceIterCompareFunc)) ->
    SequenceIterCompareFunc ->
    C_SequenceIterCompareFunc
wrap_SequenceIterCompareFunc gi'funptrptr gi'cb a b data_ = do
    a' <- (newPtr GLib.SequenceIter.SequenceIter) a
    b' <- (newPtr GLib.SequenceIter.SequenceIter) b
    result <- gi'cb  a' b' data_
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback ScannerMsgFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "scanner"
          , argType =
              TInterface Name { namespace = "GLib" , name = "Scanner" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GScanner" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "message"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the message" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TBasicType TBoolean
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "%TRUE if the message signals an error,\n    %FALSE if it signals a warning."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Specifies the type of the message handler function."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ScannerMsgFunc =
    Ptr GLib.Scanner.Scanner ->
    CString ->
    CInt ->
    IO ()

-- Args: [ Arg
--           { argCName = "scanner"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "Scanner" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GScanner" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if the message signals an error,\n    %FALSE if it signals a warning."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ScannerMsgFunc :: FunPtr C_ScannerMsgFunc -> C_ScannerMsgFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ScannerMsgFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ScannerMsgFunc
    -> GLib.Scanner.Scanner
    -- ^ /@scanner@/: a t'GI.GLib.Structs.Scanner.Scanner'
    -> T.Text
    -- ^ /@message@/: the message
    -> Bool
    -- ^ /@error@/: 'P.True' if the message signals an error,
    --     'P.False' if it signals a warning.
    -> m ()
dynamic_ScannerMsgFunc __funPtr scanner message error_ = liftIO $ do
    scanner' <- unsafeManagedPtrGetPtr scanner
    message' <- textToCString message
    let error_' = (P.fromIntegral . P.fromEnum) error_
    (__dynamic_C_ScannerMsgFunc __funPtr) scanner' message' error_'
    touchManagedPtr scanner
    freeMem message'
    return ()

-- | Generate a function pointer callable from C code, from a `C_ScannerMsgFunc`.
foreign import ccall "wrapper"
    mk_ScannerMsgFunc :: C_ScannerMsgFunc -> IO (FunPtr C_ScannerMsgFunc)

-- | Specifies the type of the message handler function.
type ScannerMsgFunc =
    GLib.Scanner.Scanner
    -- ^ /@scanner@/: a t'GI.GLib.Structs.Scanner.Scanner'
    -> T.Text
    -- ^ /@message@/: the message
    -> Bool
    -- ^ /@error@/: 'P.True' if the message signals an error,
    --     'P.False' if it signals a warning.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ScannerMsgFunc`@.
noScannerMsgFunc :: Maybe ScannerMsgFunc
noScannerMsgFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ScannerMsgFunc :: MonadIO m => ScannerMsgFunc -> m (GClosure C_ScannerMsgFunc)
genClosure_ScannerMsgFunc cb = liftIO $ do
    let cb' = wrap_ScannerMsgFunc Nothing cb
    mk_ScannerMsgFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ScannerMsgFunc` into a `C_ScannerMsgFunc`.
wrap_ScannerMsgFunc :: 
    Maybe (Ptr (FunPtr C_ScannerMsgFunc)) ->
    ScannerMsgFunc ->
    C_ScannerMsgFunc
wrap_ScannerMsgFunc gi'funptrptr gi'cb scanner message error_ = do
    scanner' <- (newPtr GLib.Scanner.Scanner) scanner
    message' <- cstringToText message
    let error_' = (/= 0) error_
    gi'cb  scanner' message' error_'
    maybeReleaseFunPtr gi'funptrptr


-- callback RegexEvalCallback
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "%FALSE to continue the replacement process, %TRUE to stop it"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "match_info"
          , argType =
              TInterface Name { namespace = "GLib" , name = "MatchInfo" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the #GMatchInfo generated by the match.\n    Use g_match_info_get_regex() and g_match_info_get_string() if you\n    need the #GRegex or the matched string."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "result"
          , argType =
              TInterface Name { namespace = "GLib" , name = "String" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GString containing the new string"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_regex_replace_eval()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the function passed to g_regex_replace_eval().\nIt is called for each occurrence of the pattern in the string passed\nto g_regex_replace_eval(), and it should append the replacement to\n@result."
        , sinceVersion = Just "2.14"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_RegexEvalCallback =
    Ptr GLib.MatchInfo.MatchInfo ->
    Ptr GLib.String.String ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "match_info"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "MatchInfo" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GMatchInfo generated by the match.\n    Use g_match_info_get_regex() and g_match_info_get_string() if you\n    need the #GRegex or the matched string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "String" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GString containing the new string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_regex_replace_eval()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_RegexEvalCallback :: FunPtr C_RegexEvalCallback -> C_RegexEvalCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_RegexEvalCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_RegexEvalCallback
    -> GLib.MatchInfo.MatchInfo
    -- ^ /@matchInfo@/: the t'GI.GLib.Structs.MatchInfo.MatchInfo' generated by the match.
    --     Use 'GI.GLib.Structs.MatchInfo.matchInfoGetRegex' and 'GI.GLib.Structs.MatchInfo.matchInfoGetString' if you
    --     need the t'GI.GLib.Structs.Regex.Regex' or the matched string.
    -> GLib.String.String
    -- ^ /@result@/: a t'GI.GLib.Structs.String.String' containing the new string
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Structs.Regex.regexReplaceEval'
    -> m Bool
    -- ^ __Returns:__ 'P.False' to continue the replacement process, 'P.True' to stop it
dynamic_RegexEvalCallback __funPtr matchInfo result_ userData = liftIO $ do
    matchInfo' <- unsafeManagedPtrGetPtr matchInfo
    result_' <- unsafeManagedPtrGetPtr result_
    result <- (__dynamic_C_RegexEvalCallback __funPtr) matchInfo' result_' userData
    let result' = (/= 0) result
    touchManagedPtr matchInfo
    touchManagedPtr result_
    return result'

-- | Generate a function pointer callable from C code, from a `C_RegexEvalCallback`.
foreign import ccall "wrapper"
    mk_RegexEvalCallback :: C_RegexEvalCallback -> IO (FunPtr C_RegexEvalCallback)

-- | Specifies the type of the function passed to 'GI.GLib.Structs.Regex.regexReplaceEval'.
-- It is called for each occurrence of the pattern in the string passed
-- to 'GI.GLib.Structs.Regex.regexReplaceEval', and it should append the replacement to
-- /@result@/.
-- 
-- /Since: 2.14/
type RegexEvalCallback =
    GLib.MatchInfo.MatchInfo
    -- ^ /@matchInfo@/: the t'GI.GLib.Structs.MatchInfo.MatchInfo' generated by the match.
    --     Use 'GI.GLib.Structs.MatchInfo.matchInfoGetRegex' and 'GI.GLib.Structs.MatchInfo.matchInfoGetString' if you
    --     need the t'GI.GLib.Structs.Regex.Regex' or the matched string.
    -> GLib.String.String
    -- ^ /@result@/: a t'GI.GLib.Structs.String.String' containing the new string
    -> IO Bool
    -- ^ __Returns:__ 'P.False' to continue the replacement process, 'P.True' to stop it

-- | A convenience synonym for @`Nothing` :: `Maybe` `RegexEvalCallback`@.
noRegexEvalCallback :: Maybe RegexEvalCallback
noRegexEvalCallback = Nothing

-- | Specifies the type of the function passed to 'GI.GLib.Structs.Regex.regexReplaceEval'.
-- It is called for each occurrence of the pattern in the string passed
-- to 'GI.GLib.Structs.Regex.regexReplaceEval', and it should append the replacement to
-- /@result@/.
-- 
-- /Since: 2.14/
type RegexEvalCallback_WithClosures =
    GLib.MatchInfo.MatchInfo
    -- ^ /@matchInfo@/: the t'GI.GLib.Structs.MatchInfo.MatchInfo' generated by the match.
    --     Use 'GI.GLib.Structs.MatchInfo.matchInfoGetRegex' and 'GI.GLib.Structs.MatchInfo.matchInfoGetString' if you
    --     need the t'GI.GLib.Structs.Regex.Regex' or the matched string.
    -> GLib.String.String
    -- ^ /@result@/: a t'GI.GLib.Structs.String.String' containing the new string
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Structs.Regex.regexReplaceEval'
    -> IO Bool
    -- ^ __Returns:__ 'P.False' to continue the replacement process, 'P.True' to stop it

-- | A convenience synonym for @`Nothing` :: `Maybe` `RegexEvalCallback_WithClosures`@.
noRegexEvalCallback_WithClosures :: Maybe RegexEvalCallback_WithClosures
noRegexEvalCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_RegexEvalCallback :: RegexEvalCallback -> RegexEvalCallback_WithClosures
drop_closures_RegexEvalCallback _f matchInfo result_ _ = _f matchInfo result_

-- | Wrap the callback into a `GClosure`.
genClosure_RegexEvalCallback :: MonadIO m => RegexEvalCallback -> m (GClosure C_RegexEvalCallback)
genClosure_RegexEvalCallback cb = liftIO $ do
    let cb' = drop_closures_RegexEvalCallback cb
    let cb'' = wrap_RegexEvalCallback Nothing cb'
    mk_RegexEvalCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `RegexEvalCallback` into a `C_RegexEvalCallback`.
wrap_RegexEvalCallback :: 
    Maybe (Ptr (FunPtr C_RegexEvalCallback)) ->
    RegexEvalCallback_WithClosures ->
    C_RegexEvalCallback
wrap_RegexEvalCallback gi'funptrptr gi'cb matchInfo result_ userData = do
    B.ManagedPtr.withTransient  matchInfo $ \matchInfo' -> do
        B.ManagedPtr.withTransient  result_ $ \result_' -> do
            result <- gi'cb  matchInfo' result_' userData
            maybeReleaseFunPtr gi'funptrptr
            let result' = (P.fromIntegral . P.fromEnum) result
            return result'


-- callback PrintFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "string"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the message to output"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the print handler functions.\nThese are called with the complete formatted string to output."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PrintFunc =
    CString ->
    IO ()

-- Args: [ Arg
--           { argCName = "string"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message to output"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PrintFunc :: FunPtr C_PrintFunc -> C_PrintFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PrintFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PrintFunc
    -> T.Text
    -- ^ /@string@/: the message to output
    -> m ()
dynamic_PrintFunc __funPtr string = liftIO $ do
    string' <- textToCString string
    (__dynamic_C_PrintFunc __funPtr) string'
    freeMem string'
    return ()

-- | Generate a function pointer callable from C code, from a `C_PrintFunc`.
foreign import ccall "wrapper"
    mk_PrintFunc :: C_PrintFunc -> IO (FunPtr C_PrintFunc)

-- | Specifies the type of the print handler functions.
-- These are called with the complete formatted string to output.
type PrintFunc =
    T.Text
    -- ^ /@string@/: the message to output
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `PrintFunc`@.
noPrintFunc :: Maybe PrintFunc
noPrintFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PrintFunc :: MonadIO m => PrintFunc -> m (GClosure C_PrintFunc)
genClosure_PrintFunc cb = liftIO $ do
    let cb' = wrap_PrintFunc Nothing cb
    mk_PrintFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PrintFunc` into a `C_PrintFunc`.
wrap_PrintFunc :: 
    Maybe (Ptr (FunPtr C_PrintFunc)) ->
    PrintFunc ->
    C_PrintFunc
wrap_PrintFunc gi'funptrptr gi'cb string = do
    string' <- cstringToText string
    gi'cb  string'
    maybeReleaseFunPtr gi'funptrptr


-- callback PollFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "the number of #GPollFD elements which have events or errors\n    reported, or -1 if an error occurred."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "ufds"
          , argType =
              TInterface Name { namespace = "GLib" , name = "PollFD" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "an array of #GPollFD elements"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "nfsd"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the number of elements in @ufds"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "timeout_"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the maximum time to wait for an event of the file descriptors.\n    A negative value indicates an infinite timeout."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_main_context_set_poll_func().\nThe semantics of the function should match those of the poll() system call."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_PollFunc =
    Ptr GLib.PollFD.PollFD ->
    Word32 ->
    Int32 ->
    IO Int32

-- Args: [ Arg
--           { argCName = "ufds"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "PollFD" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of #GPollFD elements"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "nfsd"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of elements in @ufds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout_"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the maximum time to wait for an event of the file descriptors.\n    A negative value indicates an infinite timeout."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_PollFunc :: FunPtr C_PollFunc -> C_PollFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_PollFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_PollFunc
    -> GLib.PollFD.PollFD
    -- ^ /@ufds@/: an array of t'GI.GLib.Structs.PollFD.PollFD' elements
    -> Word32
    -- ^ /@nfsd@/: the number of elements in /@ufds@/
    -> Int32
    -- ^ /@timeout_@/: the maximum time to wait for an event of the file descriptors.
    --     A negative value indicates an infinite timeout.
    -> m Int32
    -- ^ __Returns:__ the number of t'GI.GLib.Structs.PollFD.PollFD' elements which have events or errors
    --     reported, or -1 if an error occurred.
dynamic_PollFunc __funPtr ufds nfsd timeout_ = liftIO $ do
    ufds' <- unsafeManagedPtrGetPtr ufds
    result <- (__dynamic_C_PollFunc __funPtr) ufds' nfsd timeout_
    touchManagedPtr ufds
    return result

-- | Generate a function pointer callable from C code, from a `C_PollFunc`.
foreign import ccall "wrapper"
    mk_PollFunc :: C_PollFunc -> IO (FunPtr C_PollFunc)

-- | Specifies the type of function passed to @/g_main_context_set_poll_func()/@.
-- The semantics of the function should match those of the @/poll()/@ system call.
type PollFunc =
    GLib.PollFD.PollFD
    -- ^ /@ufds@/: an array of t'GI.GLib.Structs.PollFD.PollFD' elements
    -> Word32
    -- ^ /@nfsd@/: the number of elements in /@ufds@/
    -> Int32
    -- ^ /@timeout_@/: the maximum time to wait for an event of the file descriptors.
    --     A negative value indicates an infinite timeout.
    -> IO Int32
    -- ^ __Returns:__ the number of t'GI.GLib.Structs.PollFD.PollFD' elements which have events or errors
    --     reported, or -1 if an error occurred.

-- | A convenience synonym for @`Nothing` :: `Maybe` `PollFunc`@.
noPollFunc :: Maybe PollFunc
noPollFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_PollFunc :: MonadIO m => PollFunc -> m (GClosure C_PollFunc)
genClosure_PollFunc cb = liftIO $ do
    let cb' = wrap_PollFunc Nothing cb
    mk_PollFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `PollFunc` into a `C_PollFunc`.
wrap_PollFunc :: 
    Maybe (Ptr (FunPtr C_PollFunc)) ->
    PollFunc ->
    C_PollFunc
wrap_PollFunc gi'funptrptr gi'cb ufds nfsd timeout_ = do
    B.ManagedPtr.withTransient  ufds $ \ufds' -> do
        result <- gi'cb  ufds' nfsd timeout_
        maybeReleaseFunPtr gi'funptrptr
        return result


-- callback OptionParseFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the function completed successfully, %FALSE if an error\n occurred, in which case @error should be set with g_set_error()"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface Name { namespace = "GLib" , name = "OptionContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The active #GOptionContext"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "group"
          , argType =
              TInterface Name { namespace = "GLib" , name = "OptionGroup" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The group to which the function belongs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function that can be called before and after parsing."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_OptionParseFunc =
    Ptr GLib.OptionContext.OptionContext ->
    Ptr GLib.OptionGroup.OptionGroup ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The active #GOptionContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The group to which the function belongs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_OptionParseFunc :: FunPtr C_OptionParseFunc -> C_OptionParseFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_OptionParseFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_OptionParseFunc
    -> GLib.OptionContext.OptionContext
    -- ^ /@context@/: The active t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: The group to which the function belongs
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_OptionParseFunc __funPtr context group data_ = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    group' <- unsafeManagedPtrGetPtr group
    onException (do
        _ <- propagateGError $ (__dynamic_C_OptionParseFunc __funPtr) context' group' data_
        touchManagedPtr context
        touchManagedPtr group
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_OptionParseFunc`.
foreign import ccall "wrapper"
    mk_OptionParseFunc :: C_OptionParseFunc -> IO (FunPtr C_OptionParseFunc)

-- | The type of function that can be called before and after parsing.
type OptionParseFunc =
    GLib.OptionContext.OptionContext
    -- ^ /@context@/: The active t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: The group to which the function belongs
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> IO ()
    -- ^ __Returns:__ 'P.True' if the function completed successfully, 'P.False' if an error
    --  occurred, in which case /@error@/ should be set with @/g_set_error()/@ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `OptionParseFunc`@.
noOptionParseFunc :: Maybe OptionParseFunc
noOptionParseFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback OptionErrorFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface Name { namespace = "GLib" , name = "OptionContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The active #GOptionContext"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "group"
          , argType =
              TInterface Name { namespace = "GLib" , name = "OptionGroup" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The group to which the function belongs"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function to be used as callback when a parse error occurs."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_OptionErrorFunc =
    Ptr GLib.OptionContext.OptionContext ->
    Ptr GLib.OptionGroup.OptionGroup ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The active #GOptionContext"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "OptionGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The group to which the function belongs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_OptionErrorFunc :: FunPtr C_OptionErrorFunc -> C_OptionErrorFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_OptionErrorFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_OptionErrorFunc
    -> GLib.OptionContext.OptionContext
    -- ^ /@context@/: The active t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: The group to which the function belongs
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_OptionErrorFunc __funPtr context group data_ = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    group' <- unsafeManagedPtrGetPtr group
    onException (do
        propagateGError $ (__dynamic_C_OptionErrorFunc __funPtr) context' group' data_
        touchManagedPtr context
        touchManagedPtr group
        return ()
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_OptionErrorFunc`.
foreign import ccall "wrapper"
    mk_OptionErrorFunc :: C_OptionErrorFunc -> IO (FunPtr C_OptionErrorFunc)

-- | The type of function to be used as callback when a parse error occurs.
type OptionErrorFunc =
    GLib.OptionContext.OptionContext
    -- ^ /@context@/: The active t'GI.GLib.Structs.OptionContext.OptionContext'
    -> GLib.OptionGroup.OptionGroup
    -- ^ /@group@/: The group to which the function belongs
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `OptionErrorFunc`@.
noOptionErrorFunc :: Maybe OptionErrorFunc
noOptionErrorFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback OptionArgFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%TRUE if the option was successfully parsed, %FALSE if an error\n occurred, in which case @error should be set with g_set_error()"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "option_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "The name of the option being parsed. This will be either a\n single dash followed by a single letter (for a short name) or two dashes\n followed by a long option name."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "The value to be parsed."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of function to be passed as callback for %G_OPTION_ARG_CALLBACK\noptions."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_OptionArgFunc =
    CString ->
    CString ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO CInt

-- Args: [ Arg
--           { argCName = "option_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The name of the option being parsed. This will be either a\n single dash followed by a single letter (for a short name) or two dashes\n followed by a long option name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The value to be parsed."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "User data added to the #GOptionGroup containing the option when it\n was created with g_option_group_new()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_OptionArgFunc :: FunPtr C_OptionArgFunc -> C_OptionArgFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_OptionArgFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_OptionArgFunc
    -> T.Text
    -- ^ /@optionName@/: The name of the option being parsed. This will be either a
    --  single dash followed by a single letter (for a short name) or two dashes
    --  followed by a long option name.
    -> T.Text
    -- ^ /@value@/: The value to be parsed.
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_OptionArgFunc __funPtr optionName value data_ = liftIO $ do
    optionName' <- textToCString optionName
    value' <- textToCString value
    onException (do
        _ <- propagateGError $ (__dynamic_C_OptionArgFunc __funPtr) optionName' value' data_
        freeMem optionName'
        freeMem value'
        return ()
     ) (do
        freeMem optionName'
        freeMem value'
     )

-- | Generate a function pointer callable from C code, from a `C_OptionArgFunc`.
foreign import ccall "wrapper"
    mk_OptionArgFunc :: C_OptionArgFunc -> IO (FunPtr C_OptionArgFunc)

-- | The type of function to be passed as callback for 'GI.GLib.Enums.OptionArgCallback'
-- options.
type OptionArgFunc =
    T.Text
    -- ^ /@optionName@/: The name of the option being parsed. This will be either a
    --  single dash followed by a single letter (for a short name) or two dashes
    --  followed by a long option name.
    -> T.Text
    -- ^ /@value@/: The value to be parsed.
    -> Ptr ()
    -- ^ /@data@/: User data added to the t'GI.GLib.Structs.OptionGroup.OptionGroup' containing the option when it
    --  was created with 'GI.GLib.Structs.OptionGroup.optionGroupNew'
    -> IO ()
    -- ^ __Returns:__ 'P.True' if the option was successfully parsed, 'P.False' if an error
    --  occurred, in which case /@error@/ should be set with @/g_set_error()/@ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `OptionArgFunc`@.
noOptionArgFunc :: Maybe OptionArgFunc
noOptionArgFunc = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback NodeTraverseFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE to stop the traversal."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "node"
          , argType = TInterface Name { namespace = "GLib" , name = "Node" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GNode." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_node_traverse()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_node_traverse(). The\nfunction is called with each of the nodes visited, together with the\nuser data passed to g_node_traverse(). If the function returns\n%TRUE, then the traversal is stopped."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_NodeTraverseFunc =
    Ptr GLib.Node.Node ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_node_traverse()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_NodeTraverseFunc :: FunPtr C_NodeTraverseFunc -> C_NodeTraverseFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_NodeTraverseFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_NodeTraverseFunc
    -> GLib.Node.Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Node.nodeTraverse'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal.
dynamic_NodeTraverseFunc __funPtr node data_ = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    result <- (__dynamic_C_NodeTraverseFunc __funPtr) node' data_
    let result' = (/= 0) result
    touchManagedPtr node
    return result'

-- | Generate a function pointer callable from C code, from a `C_NodeTraverseFunc`.
foreign import ccall "wrapper"
    mk_NodeTraverseFunc :: C_NodeTraverseFunc -> IO (FunPtr C_NodeTraverseFunc)

-- | Specifies the type of function passed to 'GI.GLib.Structs.Node.nodeTraverse'. The
-- function is called with each of the nodes visited, together with the
-- user data passed to 'GI.GLib.Structs.Node.nodeTraverse'. If the function returns
-- 'P.True', then the traversal is stopped.
type NodeTraverseFunc =
    GLib.Node.Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Node.nodeTraverse'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the traversal.

-- | A convenience synonym for @`Nothing` :: `Maybe` `NodeTraverseFunc`@.
noNodeTraverseFunc :: Maybe NodeTraverseFunc
noNodeTraverseFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_NodeTraverseFunc :: MonadIO m => NodeTraverseFunc -> m (GClosure C_NodeTraverseFunc)
genClosure_NodeTraverseFunc cb = liftIO $ do
    let cb' = wrap_NodeTraverseFunc Nothing cb
    mk_NodeTraverseFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `NodeTraverseFunc` into a `C_NodeTraverseFunc`.
wrap_NodeTraverseFunc :: 
    Maybe (Ptr (FunPtr C_NodeTraverseFunc)) ->
    NodeTraverseFunc ->
    C_NodeTraverseFunc
wrap_NodeTraverseFunc gi'funptrptr gi'cb node data_ = do
    node' <- (newPtr GLib.Node.Node) node
    result <- gi'cb  node' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback NodeForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "node"
          , argType = TInterface Name { namespace = "GLib" , name = "Node" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GNode." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to g_node_children_foreach()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_node_children_foreach().\nThe function is called with each child node, together with the user\ndata passed to g_node_children_foreach()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_NodeForeachFunc =
    Ptr GLib.Node.Node ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "node"
--           , argType = TInterface Name { namespace = "GLib" , name = "Node" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GNode." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to g_node_children_foreach()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_NodeForeachFunc :: FunPtr C_NodeForeachFunc -> C_NodeForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_NodeForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_NodeForeachFunc
    -> GLib.Node.Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Node.nodeChildrenForeach'.
    -> m ()
dynamic_NodeForeachFunc __funPtr node data_ = liftIO $ do
    node' <- unsafeManagedPtrGetPtr node
    (__dynamic_C_NodeForeachFunc __funPtr) node' data_
    touchManagedPtr node
    return ()

-- | Generate a function pointer callable from C code, from a `C_NodeForeachFunc`.
foreign import ccall "wrapper"
    mk_NodeForeachFunc :: C_NodeForeachFunc -> IO (FunPtr C_NodeForeachFunc)

-- | Specifies the type of function passed to 'GI.GLib.Structs.Node.nodeChildrenForeach'.
-- The function is called with each child node, together with the user
-- data passed to 'GI.GLib.Structs.Node.nodeChildrenForeach'.
type NodeForeachFunc =
    GLib.Node.Node
    -- ^ /@node@/: a t'GI.GLib.Structs.Node.Node'.
    -> Ptr ()
    -- ^ /@data@/: user data passed to 'GI.GLib.Structs.Node.nodeChildrenForeach'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `NodeForeachFunc`@.
noNodeForeachFunc :: Maybe NodeForeachFunc
noNodeForeachFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_NodeForeachFunc :: MonadIO m => NodeForeachFunc -> m (GClosure C_NodeForeachFunc)
genClosure_NodeForeachFunc cb = liftIO $ do
    let cb' = wrap_NodeForeachFunc Nothing cb
    mk_NodeForeachFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `NodeForeachFunc` into a `C_NodeForeachFunc`.
wrap_NodeForeachFunc :: 
    Maybe (Ptr (FunPtr C_NodeForeachFunc)) ->
    NodeForeachFunc ->
    C_NodeForeachFunc
wrap_NodeForeachFunc gi'funptrptr gi'cb node data_ = do
    node' <- (newPtr GLib.Node.Node) node
    gi'cb  node' data_
    maybeReleaseFunPtr gi'funptrptr


-- callback MemVTableTryReallocFieldCallback
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "mem"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_bytes"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableTryReallocFieldCallback =
    Ptr () ->
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableTryReallocFieldCallback :: FunPtr C_MemVTableTryReallocFieldCallback -> C_MemVTableTryReallocFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableTryReallocFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableTryReallocFieldCallback
    -> Ptr ()
    -> FCT.CSize
    -> m (Ptr ())
dynamic_MemVTableTryReallocFieldCallback __funPtr mem nBytes = liftIO $ do
    result <- (__dynamic_C_MemVTableTryReallocFieldCallback __funPtr) mem nBytes
    return result

-- | Generate a function pointer callable from C code, from a `C_MemVTableTryReallocFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableTryReallocFieldCallback :: C_MemVTableTryReallocFieldCallback -> IO (FunPtr C_MemVTableTryReallocFieldCallback)

-- | /No description available in the introspection data./
type MemVTableTryReallocFieldCallback =
    Ptr ()
    -> FCT.CSize
    -> IO (Ptr ())

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableTryReallocFieldCallback`@.
noMemVTableTryReallocFieldCallback :: Maybe MemVTableTryReallocFieldCallback
noMemVTableTryReallocFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableTryReallocFieldCallback :: MonadIO m => MemVTableTryReallocFieldCallback -> m (GClosure C_MemVTableTryReallocFieldCallback)
genClosure_MemVTableTryReallocFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableTryReallocFieldCallback Nothing cb
    mk_MemVTableTryReallocFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableTryReallocFieldCallback` into a `C_MemVTableTryReallocFieldCallback`.
wrap_MemVTableTryReallocFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableTryReallocFieldCallback)) ->
    MemVTableTryReallocFieldCallback ->
    C_MemVTableTryReallocFieldCallback
wrap_MemVTableTryReallocFieldCallback gi'funptrptr gi'cb mem nBytes = do
    result <- gi'cb  mem nBytes
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback MemVTableTryMallocFieldCallback
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "n_bytes"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableTryMallocFieldCallback =
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableTryMallocFieldCallback :: FunPtr C_MemVTableTryMallocFieldCallback -> C_MemVTableTryMallocFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableTryMallocFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableTryMallocFieldCallback
    -> FCT.CSize
    -> m (Ptr ())
dynamic_MemVTableTryMallocFieldCallback __funPtr nBytes = liftIO $ do
    result <- (__dynamic_C_MemVTableTryMallocFieldCallback __funPtr) nBytes
    return result

-- | Generate a function pointer callable from C code, from a `C_MemVTableTryMallocFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableTryMallocFieldCallback :: C_MemVTableTryMallocFieldCallback -> IO (FunPtr C_MemVTableTryMallocFieldCallback)

-- | /No description available in the introspection data./
type MemVTableTryMallocFieldCallback =
    FCT.CSize
    -> IO (Ptr ())

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableTryMallocFieldCallback`@.
noMemVTableTryMallocFieldCallback :: Maybe MemVTableTryMallocFieldCallback
noMemVTableTryMallocFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableTryMallocFieldCallback :: MonadIO m => MemVTableTryMallocFieldCallback -> m (GClosure C_MemVTableTryMallocFieldCallback)
genClosure_MemVTableTryMallocFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableTryMallocFieldCallback Nothing cb
    mk_MemVTableTryMallocFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableTryMallocFieldCallback` into a `C_MemVTableTryMallocFieldCallback`.
wrap_MemVTableTryMallocFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableTryMallocFieldCallback)) ->
    MemVTableTryMallocFieldCallback ->
    C_MemVTableTryMallocFieldCallback
wrap_MemVTableTryMallocFieldCallback gi'funptrptr gi'cb nBytes = do
    result <- gi'cb  nBytes
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback MemVTableReallocFieldCallback
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "mem"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_bytes"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableReallocFieldCallback =
    Ptr () ->
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableReallocFieldCallback :: FunPtr C_MemVTableReallocFieldCallback -> C_MemVTableReallocFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableReallocFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableReallocFieldCallback
    -> Ptr ()
    -> FCT.CSize
    -> m (Ptr ())
dynamic_MemVTableReallocFieldCallback __funPtr mem nBytes = liftIO $ do
    result <- (__dynamic_C_MemVTableReallocFieldCallback __funPtr) mem nBytes
    return result

-- | Generate a function pointer callable from C code, from a `C_MemVTableReallocFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableReallocFieldCallback :: C_MemVTableReallocFieldCallback -> IO (FunPtr C_MemVTableReallocFieldCallback)

-- | /No description available in the introspection data./
type MemVTableReallocFieldCallback =
    Ptr ()
    -> FCT.CSize
    -> IO (Ptr ())

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableReallocFieldCallback`@.
noMemVTableReallocFieldCallback :: Maybe MemVTableReallocFieldCallback
noMemVTableReallocFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableReallocFieldCallback :: MonadIO m => MemVTableReallocFieldCallback -> m (GClosure C_MemVTableReallocFieldCallback)
genClosure_MemVTableReallocFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableReallocFieldCallback Nothing cb
    mk_MemVTableReallocFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableReallocFieldCallback` into a `C_MemVTableReallocFieldCallback`.
wrap_MemVTableReallocFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableReallocFieldCallback)) ->
    MemVTableReallocFieldCallback ->
    C_MemVTableReallocFieldCallback
wrap_MemVTableReallocFieldCallback gi'funptrptr gi'cb mem nBytes = do
    result <- gi'cb  mem nBytes
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback MemVTableMallocFieldCallback
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "n_bytes"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableMallocFieldCallback =
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "n_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableMallocFieldCallback :: FunPtr C_MemVTableMallocFieldCallback -> C_MemVTableMallocFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableMallocFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableMallocFieldCallback
    -> FCT.CSize
    -> m (Ptr ())
dynamic_MemVTableMallocFieldCallback __funPtr nBytes = liftIO $ do
    result <- (__dynamic_C_MemVTableMallocFieldCallback __funPtr) nBytes
    return result

-- | Generate a function pointer callable from C code, from a `C_MemVTableMallocFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableMallocFieldCallback :: C_MemVTableMallocFieldCallback -> IO (FunPtr C_MemVTableMallocFieldCallback)

-- | /No description available in the introspection data./
type MemVTableMallocFieldCallback =
    FCT.CSize
    -> IO (Ptr ())

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableMallocFieldCallback`@.
noMemVTableMallocFieldCallback :: Maybe MemVTableMallocFieldCallback
noMemVTableMallocFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableMallocFieldCallback :: MonadIO m => MemVTableMallocFieldCallback -> m (GClosure C_MemVTableMallocFieldCallback)
genClosure_MemVTableMallocFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableMallocFieldCallback Nothing cb
    mk_MemVTableMallocFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableMallocFieldCallback` into a `C_MemVTableMallocFieldCallback`.
wrap_MemVTableMallocFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableMallocFieldCallback)) ->
    MemVTableMallocFieldCallback ->
    C_MemVTableMallocFieldCallback
wrap_MemVTableMallocFieldCallback gi'funptrptr gi'cb nBytes = do
    result <- gi'cb  nBytes
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback MemVTableFreeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "mem"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableFreeFieldCallback =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "mem"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableFreeFieldCallback :: FunPtr C_MemVTableFreeFieldCallback -> C_MemVTableFreeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableFreeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableFreeFieldCallback
    -> Ptr ()
    -> m ()
dynamic_MemVTableFreeFieldCallback __funPtr mem = liftIO $ do
    (__dynamic_C_MemVTableFreeFieldCallback __funPtr) mem
    return ()

-- | Generate a function pointer callable from C code, from a `C_MemVTableFreeFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableFreeFieldCallback :: C_MemVTableFreeFieldCallback -> IO (FunPtr C_MemVTableFreeFieldCallback)

-- | /No description available in the introspection data./
type MemVTableFreeFieldCallback =
    Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableFreeFieldCallback`@.
noMemVTableFreeFieldCallback :: Maybe MemVTableFreeFieldCallback
noMemVTableFreeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableFreeFieldCallback :: MonadIO m => MemVTableFreeFieldCallback -> m (GClosure C_MemVTableFreeFieldCallback)
genClosure_MemVTableFreeFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableFreeFieldCallback Nothing cb
    mk_MemVTableFreeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableFreeFieldCallback` into a `C_MemVTableFreeFieldCallback`.
wrap_MemVTableFreeFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableFreeFieldCallback)) ->
    MemVTableFreeFieldCallback ->
    C_MemVTableFreeFieldCallback
wrap_MemVTableFreeFieldCallback gi'funptrptr gi'cb mem = do
    gi'cb  mem
    maybeReleaseFunPtr gi'funptrptr


-- callback MemVTableCallocFieldCallback
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "n_blocks"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_block_bytes"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MemVTableCallocFieldCallback =
    FCT.CSize ->
    FCT.CSize ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "n_blocks"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_block_bytes"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MemVTableCallocFieldCallback :: FunPtr C_MemVTableCallocFieldCallback -> C_MemVTableCallocFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MemVTableCallocFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MemVTableCallocFieldCallback
    -> FCT.CSize
    -> FCT.CSize
    -> m (Ptr ())
dynamic_MemVTableCallocFieldCallback __funPtr nBlocks nBlockBytes = liftIO $ do
    result <- (__dynamic_C_MemVTableCallocFieldCallback __funPtr) nBlocks nBlockBytes
    return result

-- | Generate a function pointer callable from C code, from a `C_MemVTableCallocFieldCallback`.
foreign import ccall "wrapper"
    mk_MemVTableCallocFieldCallback :: C_MemVTableCallocFieldCallback -> IO (FunPtr C_MemVTableCallocFieldCallback)

-- | /No description available in the introspection data./
type MemVTableCallocFieldCallback =
    FCT.CSize
    -> FCT.CSize
    -> IO (Ptr ())

-- | A convenience synonym for @`Nothing` :: `Maybe` `MemVTableCallocFieldCallback`@.
noMemVTableCallocFieldCallback :: Maybe MemVTableCallocFieldCallback
noMemVTableCallocFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_MemVTableCallocFieldCallback :: MonadIO m => MemVTableCallocFieldCallback -> m (GClosure C_MemVTableCallocFieldCallback)
genClosure_MemVTableCallocFieldCallback cb = liftIO $ do
    let cb' = wrap_MemVTableCallocFieldCallback Nothing cb
    mk_MemVTableCallocFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `MemVTableCallocFieldCallback` into a `C_MemVTableCallocFieldCallback`.
wrap_MemVTableCallocFieldCallback :: 
    Maybe (Ptr (FunPtr C_MemVTableCallocFieldCallback)) ->
    MemVTableCallocFieldCallback ->
    C_MemVTableCallocFieldCallback
wrap_MemVTableCallocFieldCallback gi'funptrptr gi'cb nBlocks nBlockBytes = do
    result <- gi'cb  nBlocks nBlockBytes
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback MarkupParserTextFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "GLib" , name = "MarkupParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "text"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "text_len"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MarkupParserTextFieldCallback =
    Ptr GLib.MarkupParseContext.MarkupParseContext ->
    CString ->
    FCT.CSize ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text_len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MarkupParserTextFieldCallback :: FunPtr C_MarkupParserTextFieldCallback -> C_MarkupParserTextFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MarkupParserTextFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MarkupParserTextFieldCallback
    -> GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_MarkupParserTextFieldCallback __funPtr context text textLen userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    text' <- textToCString text
    onException (do
        propagateGError $ (__dynamic_C_MarkupParserTextFieldCallback __funPtr) context' text' textLen userData
        touchManagedPtr context
        freeMem text'
        return ()
     ) (do
        freeMem text'
     )

-- | Generate a function pointer callable from C code, from a `C_MarkupParserTextFieldCallback`.
foreign import ccall "wrapper"
    mk_MarkupParserTextFieldCallback :: C_MarkupParserTextFieldCallback -> IO (FunPtr C_MarkupParserTextFieldCallback)

-- | /No description available in the introspection data./
type MarkupParserTextFieldCallback =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserTextFieldCallback`@.
noMarkupParserTextFieldCallback :: Maybe MarkupParserTextFieldCallback
noMarkupParserTextFieldCallback = Nothing

-- | /No description available in the introspection data./
type MarkupParserTextFieldCallback_WithClosures =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserTextFieldCallback_WithClosures`@.
noMarkupParserTextFieldCallback_WithClosures :: Maybe MarkupParserTextFieldCallback_WithClosures
noMarkupParserTextFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MarkupParserTextFieldCallback :: MarkupParserTextFieldCallback -> MarkupParserTextFieldCallback_WithClosures
drop_closures_MarkupParserTextFieldCallback _f context text textLen _ = _f context text textLen

-- No Haskell->C wrapper generated since the function throws.

-- callback MarkupParserStartElementFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "GLib" , name = "MarkupParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "element_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "attribute_names"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "attribute_values"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MarkupParserStartElementFieldCallback =
    Ptr GLib.MarkupParseContext.MarkupParseContext ->
    CString ->
    CString ->
    CString ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "element_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_names"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "attribute_values"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MarkupParserStartElementFieldCallback :: FunPtr C_MarkupParserStartElementFieldCallback -> C_MarkupParserStartElementFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MarkupParserStartElementFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MarkupParserStartElementFieldCallback
    -> GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_MarkupParserStartElementFieldCallback __funPtr context elementName attributeNames attributeValues userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    elementName' <- textToCString elementName
    attributeNames' <- textToCString attributeNames
    attributeValues' <- textToCString attributeValues
    onException (do
        propagateGError $ (__dynamic_C_MarkupParserStartElementFieldCallback __funPtr) context' elementName' attributeNames' attributeValues' userData
        touchManagedPtr context
        freeMem elementName'
        freeMem attributeNames'
        freeMem attributeValues'
        return ()
     ) (do
        freeMem elementName'
        freeMem attributeNames'
        freeMem attributeValues'
     )

-- | Generate a function pointer callable from C code, from a `C_MarkupParserStartElementFieldCallback`.
foreign import ccall "wrapper"
    mk_MarkupParserStartElementFieldCallback :: C_MarkupParserStartElementFieldCallback -> IO (FunPtr C_MarkupParserStartElementFieldCallback)

-- | /No description available in the introspection data./
type MarkupParserStartElementFieldCallback =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserStartElementFieldCallback`@.
noMarkupParserStartElementFieldCallback :: Maybe MarkupParserStartElementFieldCallback
noMarkupParserStartElementFieldCallback = Nothing

-- | /No description available in the introspection data./
type MarkupParserStartElementFieldCallback_WithClosures =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> T.Text
    -> T.Text
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserStartElementFieldCallback_WithClosures`@.
noMarkupParserStartElementFieldCallback_WithClosures :: Maybe MarkupParserStartElementFieldCallback_WithClosures
noMarkupParserStartElementFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MarkupParserStartElementFieldCallback :: MarkupParserStartElementFieldCallback -> MarkupParserStartElementFieldCallback_WithClosures
drop_closures_MarkupParserStartElementFieldCallback _f context elementName attributeNames attributeValues _ = _f context elementName attributeNames attributeValues

-- No Haskell->C wrapper generated since the function throws.

-- callback MarkupParserPassthroughFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "GLib" , name = "MarkupParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "passthrough_text"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "text_len"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MarkupParserPassthroughFieldCallback =
    Ptr GLib.MarkupParseContext.MarkupParseContext ->
    CString ->
    FCT.CSize ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "passthrough_text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text_len"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MarkupParserPassthroughFieldCallback :: FunPtr C_MarkupParserPassthroughFieldCallback -> C_MarkupParserPassthroughFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MarkupParserPassthroughFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MarkupParserPassthroughFieldCallback
    -> GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_MarkupParserPassthroughFieldCallback __funPtr context passthroughText textLen userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    passthroughText' <- textToCString passthroughText
    onException (do
        propagateGError $ (__dynamic_C_MarkupParserPassthroughFieldCallback __funPtr) context' passthroughText' textLen userData
        touchManagedPtr context
        freeMem passthroughText'
        return ()
     ) (do
        freeMem passthroughText'
     )

-- | Generate a function pointer callable from C code, from a `C_MarkupParserPassthroughFieldCallback`.
foreign import ccall "wrapper"
    mk_MarkupParserPassthroughFieldCallback :: C_MarkupParserPassthroughFieldCallback -> IO (FunPtr C_MarkupParserPassthroughFieldCallback)

-- | /No description available in the introspection data./
type MarkupParserPassthroughFieldCallback =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserPassthroughFieldCallback`@.
noMarkupParserPassthroughFieldCallback :: Maybe MarkupParserPassthroughFieldCallback
noMarkupParserPassthroughFieldCallback = Nothing

-- | /No description available in the introspection data./
type MarkupParserPassthroughFieldCallback_WithClosures =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> FCT.CSize
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserPassthroughFieldCallback_WithClosures`@.
noMarkupParserPassthroughFieldCallback_WithClosures :: Maybe MarkupParserPassthroughFieldCallback_WithClosures
noMarkupParserPassthroughFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MarkupParserPassthroughFieldCallback :: MarkupParserPassthroughFieldCallback -> MarkupParserPassthroughFieldCallback_WithClosures
drop_closures_MarkupParserPassthroughFieldCallback _f context passthroughText textLen _ = _f context passthroughText textLen

-- No Haskell->C wrapper generated since the function throws.

-- callback MarkupParserErrorFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "GLib" , name = "MarkupParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MarkupParserErrorFieldCallback =
    Ptr GLib.MarkupParseContext.MarkupParseContext ->
    Ptr GError ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MarkupParserErrorFieldCallback :: FunPtr C_MarkupParserErrorFieldCallback -> C_MarkupParserErrorFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MarkupParserErrorFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MarkupParserErrorFieldCallback
    -> GLib.MarkupParseContext.MarkupParseContext
    -> GError
    -> Ptr ()
    -> m ()
dynamic_MarkupParserErrorFieldCallback __funPtr context error_ userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_MarkupParserErrorFieldCallback __funPtr) context' error_' userData
    touchManagedPtr context
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_MarkupParserErrorFieldCallback`.
foreign import ccall "wrapper"
    mk_MarkupParserErrorFieldCallback :: C_MarkupParserErrorFieldCallback -> IO (FunPtr C_MarkupParserErrorFieldCallback)

-- | /No description available in the introspection data./
type MarkupParserErrorFieldCallback =
    GLib.MarkupParseContext.MarkupParseContext
    -> GError
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserErrorFieldCallback`@.
noMarkupParserErrorFieldCallback :: Maybe MarkupParserErrorFieldCallback
noMarkupParserErrorFieldCallback = Nothing

-- | /No description available in the introspection data./
type MarkupParserErrorFieldCallback_WithClosures =
    GLib.MarkupParseContext.MarkupParseContext
    -> GError
    -> Ptr ()
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserErrorFieldCallback_WithClosures`@.
noMarkupParserErrorFieldCallback_WithClosures :: Maybe MarkupParserErrorFieldCallback_WithClosures
noMarkupParserErrorFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MarkupParserErrorFieldCallback :: MarkupParserErrorFieldCallback -> MarkupParserErrorFieldCallback_WithClosures
drop_closures_MarkupParserErrorFieldCallback _f context error_ _ = _f context error_

-- | Wrap the callback into a `GClosure`.
genClosure_MarkupParserErrorFieldCallback :: MonadIO m => MarkupParserErrorFieldCallback -> m (GClosure C_MarkupParserErrorFieldCallback)
genClosure_MarkupParserErrorFieldCallback cb = liftIO $ do
    let cb' = drop_closures_MarkupParserErrorFieldCallback cb
    let cb'' = wrap_MarkupParserErrorFieldCallback Nothing cb'
    mk_MarkupParserErrorFieldCallback cb'' >>= B.GClosure.newGClosure


-- | Wrap a `MarkupParserErrorFieldCallback` into a `C_MarkupParserErrorFieldCallback`.
wrap_MarkupParserErrorFieldCallback :: 
    Maybe (Ptr (FunPtr C_MarkupParserErrorFieldCallback)) ->
    MarkupParserErrorFieldCallback_WithClosures ->
    C_MarkupParserErrorFieldCallback
wrap_MarkupParserErrorFieldCallback gi'funptrptr gi'cb context error_ userData = do
    B.ManagedPtr.withTransient  context $ \context' -> do
        error_' <- (newBoxed GError) error_
        gi'cb  context' error_' userData
        maybeReleaseFunPtr gi'funptrptr


-- callback MarkupParserEndElementFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "context"
          , argType =
              TInterface
                Name { namespace = "GLib" , name = "MarkupParseContext" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "element_name"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_MarkupParserEndElementFieldCallback =
    Ptr GLib.MarkupParseContext.MarkupParseContext ->
    CString ->
    Ptr () ->
    Ptr (Ptr GError) ->
    IO ()

-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface
--                 Name { namespace = "GLib" , name = "MarkupParseContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "element_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_MarkupParserEndElementFieldCallback :: FunPtr C_MarkupParserEndElementFieldCallback -> C_MarkupParserEndElementFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_MarkupParserEndElementFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_MarkupParserEndElementFieldCallback
    -> GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> Ptr ()
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_MarkupParserEndElementFieldCallback __funPtr context elementName userData = liftIO $ do
    context' <- unsafeManagedPtrGetPtr context
    elementName' <- textToCString elementName
    onException (do
        propagateGError $ (__dynamic_C_MarkupParserEndElementFieldCallback __funPtr) context' elementName' userData
        touchManagedPtr context
        freeMem elementName'
        return ()
     ) (do
        freeMem elementName'
     )

-- | Generate a function pointer callable from C code, from a `C_MarkupParserEndElementFieldCallback`.
foreign import ccall "wrapper"
    mk_MarkupParserEndElementFieldCallback :: C_MarkupParserEndElementFieldCallback -> IO (FunPtr C_MarkupParserEndElementFieldCallback)

-- | /No description available in the introspection data./
type MarkupParserEndElementFieldCallback =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserEndElementFieldCallback`@.
noMarkupParserEndElementFieldCallback :: Maybe MarkupParserEndElementFieldCallback
noMarkupParserEndElementFieldCallback = Nothing

-- | /No description available in the introspection data./
type MarkupParserEndElementFieldCallback_WithClosures =
    GLib.MarkupParseContext.MarkupParseContext
    -> T.Text
    -> Ptr ()
    -> IO ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `MarkupParserEndElementFieldCallback_WithClosures`@.
noMarkupParserEndElementFieldCallback_WithClosures :: Maybe MarkupParserEndElementFieldCallback_WithClosures
noMarkupParserEndElementFieldCallback_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_MarkupParserEndElementFieldCallback :: MarkupParserEndElementFieldCallback -> MarkupParserEndElementFieldCallback_WithClosures
drop_closures_MarkupParserEndElementFieldCallback _f context elementName _ = _f context elementName

-- No Haskell->C wrapper generated since the function throws.

-- callback LogWriterFunc
{- Callable
  { returnType =
      Just
        (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%G_LOG_WRITER_HANDLED if the log entry was handled successfully;\n  %G_LOG_WRITER_UNHANDLED otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "log_level"
          , argType =
              TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "log level of the message"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "fields"
          , argType =
              TCArray
                False
                (-1)
                2
                (TInterface Name { namespace = "GLib" , name = "LogField" })
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "fields forming the message"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n_fields"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "number of @fields" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_log_set_writer_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Writer function for log entries. A log entry is a collection of one or more\n#GLogFields, using the standard [field names from journal\nspecification](https://www.freedesktop.org/software/systemd/man/systemd.journal-fields.html).\nSee g_log_structured() for more information.\n\nWriter functions must ignore fields which they do not recognise, unless they\ncan write arbitrary binary output, as field values may be arbitrary binary.\n\n@log_level is guaranteed to be included in @fields as the `PRIORITY` field,\nbut is provided separately for convenience of deciding whether or where to\noutput the log entry.\n\nWriter functions should return %G_LOG_WRITER_HANDLED if they handled the log\nmessage successfully or if they deliberately ignored it. If there was an\nerror handling the message (for example, if the writer function is meant to\nsend messages to a remote logging server and there is a network error), it\nshould return %G_LOG_WRITER_UNHANDLED. This allows writer functions to be\nchained and fall back to simpler handlers in case of failure."
        , sinceVersion = Just "2.50"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_LogWriterFunc =
    CInt ->
    Ptr GLib.LogField.LogField ->
    FCT.CSize ->
    Ptr () ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "log level of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fields"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 2
--                 (TInterface Name { namespace = "GLib" , name = "LogField" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fields forming the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_fields"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of @fields" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_log_set_writer_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_fields"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "number of @fields" , sinceVersion = Nothing }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface Name { namespace = "GLib" , name = "LogWriterOutput" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_LogWriterFunc :: FunPtr C_LogWriterFunc -> C_LogWriterFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_LogWriterFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_LogWriterFunc
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level of the message
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: fields forming the message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> m GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' if the log entry was handled successfully;
    --   'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise
dynamic_LogWriterFunc __funPtr logLevel fields userData = liftIO $ do
    let nFields = fromIntegral $ P.length fields
    let logLevel' = gflagsToWord logLevel
    fields' <- mapM unsafeManagedPtrGetPtr fields
    fields'' <- packBlockArray 24 fields'
    result <- (__dynamic_C_LogWriterFunc __funPtr) logLevel' fields'' nFields userData
    let result' = (toEnum . fromIntegral) result
    mapM_ touchManagedPtr fields
    freeMem fields''
    return result'

-- | Generate a function pointer callable from C code, from a `C_LogWriterFunc`.
foreign import ccall "wrapper"
    mk_LogWriterFunc :: C_LogWriterFunc -> IO (FunPtr C_LogWriterFunc)

-- | Writer function for log entries. A log entry is a collection of one or more
-- @/GLogFields/@, using the standard <https://www.freedesktop.org/software/systemd/man/systemd.journal-fields.html field names from journal
-- specification>.
-- See @/g_log_structured()/@ for more information.
-- 
-- Writer functions must ignore fields which they do not recognise, unless they
-- can write arbitrary binary output, as field values may be arbitrary binary.
-- 
-- /@logLevel@/ is guaranteed to be included in /@fields@/ as the @PRIORITY@ field,
-- but is provided separately for convenience of deciding whether or where to
-- output the log entry.
-- 
-- Writer functions should return 'GI.GLib.Enums.LogWriterOutputHandled' if they handled the log
-- message successfully or if they deliberately ignored it. If there was an
-- error handling the message (for example, if the writer function is meant to
-- send messages to a remote logging server and there is a network error), it
-- should return 'GI.GLib.Enums.LogWriterOutputUnhandled'. This allows writer functions to be
-- chained and fall back to simpler handlers in case of failure.
-- 
-- /Since: 2.50/
type LogWriterFunc =
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level of the message
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: fields forming the message
    -> IO GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' if the log entry was handled successfully;
    --   'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `LogWriterFunc`@.
noLogWriterFunc :: Maybe LogWriterFunc
noLogWriterFunc = Nothing

-- | Writer function for log entries. A log entry is a collection of one or more
-- @/GLogFields/@, using the standard <https://www.freedesktop.org/software/systemd/man/systemd.journal-fields.html field names from journal
-- specification>.
-- See @/g_log_structured()/@ for more information.
-- 
-- Writer functions must ignore fields which they do not recognise, unless they
-- can write arbitrary binary output, as field values may be arbitrary binary.
-- 
-- /@logLevel@/ is guaranteed to be included in /@fields@/ as the @PRIORITY@ field,
-- but is provided separately for convenience of deciding whether or where to
-- output the log entry.
-- 
-- Writer functions should return 'GI.GLib.Enums.LogWriterOutputHandled' if they handled the log
-- message successfully or if they deliberately ignored it. If there was an
-- error handling the message (for example, if the writer function is meant to
-- send messages to a remote logging server and there is a network error), it
-- should return 'GI.GLib.Enums.LogWriterOutputUnhandled'. This allows writer functions to be
-- chained and fall back to simpler handlers in case of failure.
-- 
-- /Since: 2.50/
type LogWriterFunc_WithClosures =
    [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: log level of the message
    -> [GLib.LogField.LogField]
    -- ^ /@fields@/: fields forming the message
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.logSetWriterFunc'
    -> IO GLib.Enums.LogWriterOutput
    -- ^ __Returns:__ 'GI.GLib.Enums.LogWriterOutputHandled' if the log entry was handled successfully;
    --   'GI.GLib.Enums.LogWriterOutputUnhandled' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `LogWriterFunc_WithClosures`@.
noLogWriterFunc_WithClosures :: Maybe LogWriterFunc_WithClosures
noLogWriterFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_LogWriterFunc :: LogWriterFunc -> LogWriterFunc_WithClosures
drop_closures_LogWriterFunc _f logLevel fields _ = _f logLevel fields

-- | Wrap the callback into a `GClosure`.
genClosure_LogWriterFunc :: MonadIO m => LogWriterFunc -> m (GClosure C_LogWriterFunc)
genClosure_LogWriterFunc cb = liftIO $ do
    let cb' = drop_closures_LogWriterFunc cb
    let cb'' = wrap_LogWriterFunc Nothing cb'
    mk_LogWriterFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `LogWriterFunc` into a `C_LogWriterFunc`.
wrap_LogWriterFunc :: 
    Maybe (Ptr (FunPtr C_LogWriterFunc)) ->
    LogWriterFunc_WithClosures ->
    C_LogWriterFunc
wrap_LogWriterFunc gi'funptrptr gi'cb logLevel fields nFields userData = do
    let logLevel' = wordToGFlags logLevel
    fields' <- (unpackBlockArrayWithLength 24 nFields) fields
    fields'' <- mapM (newPtr GLib.LogField.LogField) fields'
    result <- gi'cb  logLevel' fields'' userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (fromIntegral . fromEnum) result
    return result'


-- callback LogFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "log_domain"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the log domain of the message"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "log_level"
          , argType =
              TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the log level of the message (including the\n  fatal and recursion flags)"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "message"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the message to process"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data, set in [func@GLib.log_set_handler]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the prototype of log handler functions.\n\nThe default log handler, [func@GLib.log_default_handler], automatically appends a\nnew-line character to @message when printing it. It is advised that any\ncustom log handler functions behave similarly, so that logging calls in user\ncode do not need modifying to add a new-line character to the message if the\nlog handler is changed.\n\nThe `log_domain` parameter can be set to `NULL` or an empty string to use the default\napplication domain.\n\nThis is not used if structured logging is enabled; see\n[Using Structured Logging](logging.html#using-structured-logging)."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_LogFunc =
    CString ->
    CInt ->
    CString ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "log_domain"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the log domain of the message"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "log_level"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "LogLevelFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the log level of the message (including the\n  fatal and recursion flags)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message to process"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data, set in [func@GLib.log_set_handler]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_LogFunc :: FunPtr C_LogFunc -> C_LogFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_LogFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_LogFunc
    -> Maybe (T.Text)
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the
    --   fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> Ptr ()
    -- ^ /@userData@/: user data, set in 'GI.GLib.Functions.logSetHandler'
    -> m ()
dynamic_LogFunc __funPtr logDomain logLevel message userData = liftIO $ do
    maybeLogDomain <- case logDomain of
        Nothing -> return FP.nullPtr
        Just jLogDomain -> do
            jLogDomain' <- textToCString jLogDomain
            return jLogDomain'
    let logLevel' = gflagsToWord logLevel
    message' <- textToCString message
    (__dynamic_C_LogFunc __funPtr) maybeLogDomain logLevel' message' userData
    freeMem maybeLogDomain
    freeMem message'
    return ()

-- | Generate a function pointer callable from C code, from a `C_LogFunc`.
foreign import ccall "wrapper"
    mk_LogFunc :: C_LogFunc -> IO (FunPtr C_LogFunc)

-- | Specifies the prototype of log handler functions.
-- 
-- The default log handler, 'GI.GLib.Functions.logDefaultHandler', automatically appends a
-- new-line character to /@message@/ when printing it. It is advised that any
-- custom log handler functions behave similarly, so that logging calls in user
-- code do not need modifying to add a new-line character to the message if the
-- log handler is changed.
-- 
-- The @log_domain@ parameter can be set to @NULL@ or an empty string to use the default
-- application domain.
-- 
-- This is not used if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
type LogFunc =
    Maybe T.Text
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the
    --   fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `LogFunc`@.
noLogFunc :: Maybe LogFunc
noLogFunc = Nothing

-- | Specifies the prototype of log handler functions.
-- 
-- The default log handler, 'GI.GLib.Functions.logDefaultHandler', automatically appends a
-- new-line character to /@message@/ when printing it. It is advised that any
-- custom log handler functions behave similarly, so that logging calls in user
-- code do not need modifying to add a new-line character to the message if the
-- log handler is changed.
-- 
-- The @log_domain@ parameter can be set to @NULL@ or an empty string to use the default
-- application domain.
-- 
-- This is not used if structured logging is enabled; see
-- <http://developer.gnome.org/glib/stable/logging.html#using-structured-logging Using Structured Logging>.
type LogFunc_WithClosures =
    Maybe T.Text
    -- ^ /@logDomain@/: the log domain of the message
    -> [GLib.Flags.LogLevelFlags]
    -- ^ /@logLevel@/: the log level of the message (including the
    --   fatal and recursion flags)
    -> T.Text
    -- ^ /@message@/: the message to process
    -> Ptr ()
    -- ^ /@userData@/: user data, set in 'GI.GLib.Functions.logSetHandler'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `LogFunc_WithClosures`@.
noLogFunc_WithClosures :: Maybe LogFunc_WithClosures
noLogFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_LogFunc :: LogFunc -> LogFunc_WithClosures
drop_closures_LogFunc _f logDomain logLevel message _ = _f logDomain logLevel message

-- | Wrap the callback into a `GClosure`.
genClosure_LogFunc :: MonadIO m => LogFunc -> m (GClosure C_LogFunc)
genClosure_LogFunc cb = liftIO $ do
    let cb' = drop_closures_LogFunc cb
    let cb'' = wrap_LogFunc Nothing cb'
    mk_LogFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `LogFunc` into a `C_LogFunc`.
wrap_LogFunc :: 
    Maybe (Ptr (FunPtr C_LogFunc)) ->
    LogFunc_WithClosures ->
    C_LogFunc
wrap_LogFunc gi'funptrptr gi'cb logDomain logLevel message userData = do
    maybeLogDomain <-
        if logDomain == FP.nullPtr
        then return Nothing
        else do
            logDomain' <- cstringToText logDomain
            return $ Just logDomain'
    let logLevel' = wordToGFlags logLevel
    message' <- cstringToText message
    gi'cb  maybeLogDomain logLevel' message' userData
    maybeReleaseFunPtr gi'funptrptr


-- callback IOFuncsIoWriteFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "buf"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "bytes_written"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoWriteFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    CString ->
    FCT.CSize ->
    FCT.CSize ->
    Ptr (Ptr GError) ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buf"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_written"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoWriteFieldCallback :: FunPtr C_IOFuncsIoWriteFieldCallback -> C_IOFuncsIoWriteFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoWriteFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoWriteFieldCallback
    -> GLib.IOChannel.IOChannel
    -> T.Text
    -> FCT.CSize
    -> FCT.CSize
    -> m GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_IOFuncsIoWriteFieldCallback __funPtr channel buf count bytesWritten = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    buf' <- textToCString buf
    onException (do
        result <- propagateGError $ (__dynamic_C_IOFuncsIoWriteFieldCallback __funPtr) channel' buf' count bytesWritten
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr channel
        freeMem buf'
        return result'
     ) (do
        freeMem buf'
     )

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoWriteFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoWriteFieldCallback :: C_IOFuncsIoWriteFieldCallback -> IO (FunPtr C_IOFuncsIoWriteFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoWriteFieldCallback =
    GLib.IOChannel.IOChannel
    -> T.Text
    -> FCT.CSize
    -> FCT.CSize
    -> IO GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoWriteFieldCallback`@.
noIOFuncsIoWriteFieldCallback :: Maybe IOFuncsIoWriteFieldCallback
noIOFuncsIoWriteFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback IOFuncsIoSetFlagsFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "flags"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOFlags" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoSetFlagsFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    CUInt ->
    Ptr (Ptr GError) ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoSetFlagsFieldCallback :: FunPtr C_IOFuncsIoSetFlagsFieldCallback -> C_IOFuncsIoSetFlagsFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoSetFlagsFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoSetFlagsFieldCallback
    -> GLib.IOChannel.IOChannel
    -> [GLib.Flags.IOFlags]
    -> m GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_IOFuncsIoSetFlagsFieldCallback __funPtr channel flags = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    let flags' = gflagsToWord flags
    onException (do
        result <- propagateGError $ (__dynamic_C_IOFuncsIoSetFlagsFieldCallback __funPtr) channel' flags'
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr channel
        return result'
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoSetFlagsFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoSetFlagsFieldCallback :: C_IOFuncsIoSetFlagsFieldCallback -> IO (FunPtr C_IOFuncsIoSetFlagsFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoSetFlagsFieldCallback =
    GLib.IOChannel.IOChannel
    -> [GLib.Flags.IOFlags]
    -> IO GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoSetFlagsFieldCallback`@.
noIOFuncsIoSetFlagsFieldCallback :: Maybe IOFuncsIoSetFlagsFieldCallback
noIOFuncsIoSetFlagsFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback IOFuncsIoSeekFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "offset"
          , argType = TBasicType TInt64
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "type"
          , argType =
              TInterface Name { namespace = "GLib" , name = "SeekType" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoSeekFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    Int64 ->
    CUInt ->
    Ptr (Ptr GError) ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "SeekType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoSeekFieldCallback :: FunPtr C_IOFuncsIoSeekFieldCallback -> C_IOFuncsIoSeekFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoSeekFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoSeekFieldCallback
    -> GLib.IOChannel.IOChannel
    -> Int64
    -> GLib.Enums.SeekType
    -> m GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_IOFuncsIoSeekFieldCallback __funPtr channel offset type_ = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    let type_' = (fromIntegral . fromEnum) type_
    onException (do
        result <- propagateGError $ (__dynamic_C_IOFuncsIoSeekFieldCallback __funPtr) channel' offset type_'
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr channel
        return result'
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoSeekFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoSeekFieldCallback :: C_IOFuncsIoSeekFieldCallback -> IO (FunPtr C_IOFuncsIoSeekFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoSeekFieldCallback =
    GLib.IOChannel.IOChannel
    -> Int64
    -> GLib.Enums.SeekType
    -> IO GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoSeekFieldCallback`@.
noIOFuncsIoSeekFieldCallback :: Maybe IOFuncsIoSeekFieldCallback
noIOFuncsIoSeekFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback IOFuncsIoReadFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "buf"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "count"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "bytes_read"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoReadFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    CString ->
    FCT.CSize ->
    FCT.CSize ->
    Ptr (Ptr GError) ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buf"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bytes_read"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoReadFieldCallback :: FunPtr C_IOFuncsIoReadFieldCallback -> C_IOFuncsIoReadFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoReadFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoReadFieldCallback
    -> GLib.IOChannel.IOChannel
    -> T.Text
    -> FCT.CSize
    -> FCT.CSize
    -> m GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_IOFuncsIoReadFieldCallback __funPtr channel buf count bytesRead = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    buf' <- textToCString buf
    onException (do
        result <- propagateGError $ (__dynamic_C_IOFuncsIoReadFieldCallback __funPtr) channel' buf' count bytesRead
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr channel
        freeMem buf'
        return result'
     ) (do
        freeMem buf'
     )

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoReadFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoReadFieldCallback :: C_IOFuncsIoReadFieldCallback -> IO (FunPtr C_IOFuncsIoReadFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoReadFieldCallback =
    GLib.IOChannel.IOChannel
    -> T.Text
    -> FCT.CSize
    -> FCT.CSize
    -> IO GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoReadFieldCallback`@.
noIOFuncsIoReadFieldCallback :: Maybe IOFuncsIoReadFieldCallback
noIOFuncsIoReadFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback IOFuncsIoGetFlagsFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOFlags" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoGetFlagsFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoGetFlagsFieldCallback :: FunPtr C_IOFuncsIoGetFlagsFieldCallback -> C_IOFuncsIoGetFlagsFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoGetFlagsFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoGetFlagsFieldCallback
    -> GLib.IOChannel.IOChannel
    -> m [GLib.Flags.IOFlags]
dynamic_IOFuncsIoGetFlagsFieldCallback __funPtr channel = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    result <- (__dynamic_C_IOFuncsIoGetFlagsFieldCallback __funPtr) channel'
    let result' = wordToGFlags result
    touchManagedPtr channel
    return result'

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoGetFlagsFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoGetFlagsFieldCallback :: C_IOFuncsIoGetFlagsFieldCallback -> IO (FunPtr C_IOFuncsIoGetFlagsFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoGetFlagsFieldCallback =
    GLib.IOChannel.IOChannel
    -> IO [GLib.Flags.IOFlags]

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoGetFlagsFieldCallback`@.
noIOFuncsIoGetFlagsFieldCallback :: Maybe IOFuncsIoGetFlagsFieldCallback
noIOFuncsIoGetFlagsFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_IOFuncsIoGetFlagsFieldCallback :: MonadIO m => IOFuncsIoGetFlagsFieldCallback -> m (GClosure C_IOFuncsIoGetFlagsFieldCallback)
genClosure_IOFuncsIoGetFlagsFieldCallback cb = liftIO $ do
    let cb' = wrap_IOFuncsIoGetFlagsFieldCallback Nothing cb
    mk_IOFuncsIoGetFlagsFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `IOFuncsIoGetFlagsFieldCallback` into a `C_IOFuncsIoGetFlagsFieldCallback`.
wrap_IOFuncsIoGetFlagsFieldCallback :: 
    Maybe (Ptr (FunPtr C_IOFuncsIoGetFlagsFieldCallback)) ->
    IOFuncsIoGetFlagsFieldCallback ->
    C_IOFuncsIoGetFlagsFieldCallback
wrap_IOFuncsIoGetFlagsFieldCallback gi'funptrptr gi'cb channel = do
    B.ManagedPtr.withTransient  channel $ \channel' -> do
        result <- gi'cb  channel'
        maybeReleaseFunPtr gi'funptrptr
        let result' = gflagsToWord result
        return result'


-- callback IOFuncsIoFreeFieldCallback
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoFreeFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    IO ()

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoFreeFieldCallback :: FunPtr C_IOFuncsIoFreeFieldCallback -> C_IOFuncsIoFreeFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoFreeFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoFreeFieldCallback
    -> GLib.IOChannel.IOChannel
    -> m ()
dynamic_IOFuncsIoFreeFieldCallback __funPtr channel = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    (__dynamic_C_IOFuncsIoFreeFieldCallback __funPtr) channel'
    touchManagedPtr channel
    return ()

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoFreeFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoFreeFieldCallback :: C_IOFuncsIoFreeFieldCallback -> IO (FunPtr C_IOFuncsIoFreeFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoFreeFieldCallback =
    GLib.IOChannel.IOChannel
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoFreeFieldCallback`@.
noIOFuncsIoFreeFieldCallback :: Maybe IOFuncsIoFreeFieldCallback
noIOFuncsIoFreeFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_IOFuncsIoFreeFieldCallback :: MonadIO m => IOFuncsIoFreeFieldCallback -> m (GClosure C_IOFuncsIoFreeFieldCallback)
genClosure_IOFuncsIoFreeFieldCallback cb = liftIO $ do
    let cb' = wrap_IOFuncsIoFreeFieldCallback Nothing cb
    mk_IOFuncsIoFreeFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `IOFuncsIoFreeFieldCallback` into a `C_IOFuncsIoFreeFieldCallback`.
wrap_IOFuncsIoFreeFieldCallback :: 
    Maybe (Ptr (FunPtr C_IOFuncsIoFreeFieldCallback)) ->
    IOFuncsIoFreeFieldCallback ->
    C_IOFuncsIoFreeFieldCallback
wrap_IOFuncsIoFreeFieldCallback gi'funptrptr gi'cb channel = do
    B.ManagedPtr.withTransient  channel $ \channel' -> do
        gi'cb  channel'
        maybeReleaseFunPtr gi'funptrptr


-- callback IOFuncsIoCreateWatchFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "Source" })
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "condition"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOCondition" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoCreateWatchFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    CUInt ->
    IO (Ptr GLib.Source.Source)

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Source" })
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoCreateWatchFieldCallback :: FunPtr C_IOFuncsIoCreateWatchFieldCallback -> C_IOFuncsIoCreateWatchFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoCreateWatchFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoCreateWatchFieldCallback
    -> GLib.IOChannel.IOChannel
    -> [GLib.Flags.IOCondition]
    -> m GLib.Source.Source
dynamic_IOFuncsIoCreateWatchFieldCallback __funPtr channel condition = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    let condition' = gflagsToWord condition
    result <- (__dynamic_C_IOFuncsIoCreateWatchFieldCallback __funPtr) channel' condition'
    checkUnexpectedReturnNULL "iOFuncsIoCreateWatchFieldCallback" result
    result' <- (wrapBoxed GLib.Source.Source) result
    touchManagedPtr channel
    return result'

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoCreateWatchFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoCreateWatchFieldCallback :: C_IOFuncsIoCreateWatchFieldCallback -> IO (FunPtr C_IOFuncsIoCreateWatchFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoCreateWatchFieldCallback =
    GLib.IOChannel.IOChannel
    -> [GLib.Flags.IOCondition]
    -> IO GLib.Source.Source

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoCreateWatchFieldCallback`@.
noIOFuncsIoCreateWatchFieldCallback :: Maybe IOFuncsIoCreateWatchFieldCallback
noIOFuncsIoCreateWatchFieldCallback = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_IOFuncsIoCreateWatchFieldCallback :: MonadIO m => IOFuncsIoCreateWatchFieldCallback -> m (GClosure C_IOFuncsIoCreateWatchFieldCallback)
genClosure_IOFuncsIoCreateWatchFieldCallback cb = liftIO $ do
    let cb' = wrap_IOFuncsIoCreateWatchFieldCallback Nothing cb
    mk_IOFuncsIoCreateWatchFieldCallback cb' >>= B.GClosure.newGClosure


-- | Wrap a `IOFuncsIoCreateWatchFieldCallback` into a `C_IOFuncsIoCreateWatchFieldCallback`.
wrap_IOFuncsIoCreateWatchFieldCallback :: 
    Maybe (Ptr (FunPtr C_IOFuncsIoCreateWatchFieldCallback)) ->
    IOFuncsIoCreateWatchFieldCallback ->
    C_IOFuncsIoCreateWatchFieldCallback
wrap_IOFuncsIoCreateWatchFieldCallback gi'funptrptr gi'cb channel condition = do
    B.ManagedPtr.withTransient  channel $ \channel' -> do
        let condition' = wordToGFlags condition
        result <- gi'cb  channel' condition'
        maybeReleaseFunPtr gi'funptrptr
        result' <- B.ManagedPtr.disownBoxed result
        return result'


-- callback IOFuncsIoCloseFieldCallback
{- Callable
  { returnType =
      Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "channel"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation { rawDocText = Nothing , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = True
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFuncsIoCloseFieldCallback =
    Ptr GLib.IOChannel.IOChannel ->
    Ptr (Ptr GError) ->
    IO CUInt

-- Args: [ Arg
--           { argCName = "channel"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation { rawDocText = Nothing , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "IOStatus" })
-- throws : True
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFuncsIoCloseFieldCallback :: FunPtr C_IOFuncsIoCloseFieldCallback -> C_IOFuncsIoCloseFieldCallback

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFuncsIoCloseFieldCallback ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFuncsIoCloseFieldCallback
    -> GLib.IOChannel.IOChannel
    -> m GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
dynamic_IOFuncsIoCloseFieldCallback __funPtr channel = liftIO $ do
    channel' <- unsafeManagedPtrGetPtr channel
    onException (do
        result <- propagateGError $ (__dynamic_C_IOFuncsIoCloseFieldCallback __funPtr) channel'
        let result' = (toEnum . fromIntegral) result
        touchManagedPtr channel
        return result'
     ) (do
        return ()
     )

-- | Generate a function pointer callable from C code, from a `C_IOFuncsIoCloseFieldCallback`.
foreign import ccall "wrapper"
    mk_IOFuncsIoCloseFieldCallback :: C_IOFuncsIoCloseFieldCallback -> IO (FunPtr C_IOFuncsIoCloseFieldCallback)

-- | /No description available in the introspection data./
type IOFuncsIoCloseFieldCallback =
    GLib.IOChannel.IOChannel
    -> IO GLib.Enums.IOStatus
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFuncsIoCloseFieldCallback`@.
noIOFuncsIoCloseFieldCallback :: Maybe IOFuncsIoCloseFieldCallback
noIOFuncsIoCloseFieldCallback = Nothing

-- No Haskell->C wrapper generated since the function throws.

-- callback IOFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "the function should return %FALSE if the event source\n         should be removed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "source"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOChannel" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GIOChannel event source"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "condition"
          , argType =
              TInterface Name { namespace = "GLib" , name = "IOCondition" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the condition which has been satisfied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data set in g_io_add_watch() or g_io_add_watch_full()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_io_add_watch() or\ng_io_add_watch_full(), which is called when the requested condition\non a #GIOChannel is satisfied."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_IOFunc =
    Ptr GLib.IOChannel.IOChannel ->
    CUInt ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "source"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOChannel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GIOChannel event source"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "condition"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "IOCondition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the condition which has been satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data set in g_io_add_watch() or g_io_add_watch_full()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_IOFunc :: FunPtr C_IOFunc -> C_IOFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_IOFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_IOFunc
    -> GLib.IOChannel.IOChannel
    -- ^ /@source@/: the t'GI.GLib.Structs.IOChannel.IOChannel' event source
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the condition which has been satisfied
    -> Ptr ()
    -- ^ /@data@/: user data set in @/g_io_add_watch()/@ or 'GI.GLib.Functions.ioAddWatch'
    -> m Bool
    -- ^ __Returns:__ the function should return 'P.False' if the event source
    --          should be removed
dynamic_IOFunc __funPtr source condition data_ = liftIO $ do
    source' <- unsafeManagedPtrGetPtr source
    let condition' = gflagsToWord condition
    result <- (__dynamic_C_IOFunc __funPtr) source' condition' data_
    let result' = (/= 0) result
    touchManagedPtr source
    return result'

-- | Generate a function pointer callable from C code, from a `C_IOFunc`.
foreign import ccall "wrapper"
    mk_IOFunc :: C_IOFunc -> IO (FunPtr C_IOFunc)

-- | Specifies the type of function passed to @/g_io_add_watch()/@ or
-- 'GI.GLib.Functions.ioAddWatch', which is called when the requested condition
-- on a t'GI.GLib.Structs.IOChannel.IOChannel' is satisfied.
type IOFunc =
    GLib.IOChannel.IOChannel
    -- ^ /@source@/: the t'GI.GLib.Structs.IOChannel.IOChannel' event source
    -> [GLib.Flags.IOCondition]
    -- ^ /@condition@/: the condition which has been satisfied
    -> Ptr ()
    -- ^ /@data@/: user data set in @/g_io_add_watch()/@ or 'GI.GLib.Functions.ioAddWatch'
    -> IO Bool
    -- ^ __Returns:__ the function should return 'P.False' if the event source
    --          should be removed

-- | A convenience synonym for @`Nothing` :: `Maybe` `IOFunc`@.
noIOFunc :: Maybe IOFunc
noIOFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_IOFunc :: MonadIO m => IOFunc -> m (GClosure C_IOFunc)
genClosure_IOFunc cb = liftIO $ do
    let cb' = wrap_IOFunc Nothing cb
    mk_IOFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `IOFunc` into a `C_IOFunc`.
wrap_IOFunc :: 
    Maybe (Ptr (FunPtr C_IOFunc)) ->
    IOFunc ->
    C_IOFunc
wrap_IOFunc gi'funptrptr gi'cb source condition data_ = do
    B.ManagedPtr.withTransient  source $ \source' -> do
        let condition' = wordToGFlags condition
        result <- gi'cb  source' condition' data_
        maybeReleaseFunPtr gi'funptrptr
        let result' = (P.fromIntegral . P.fromEnum) result
        return result'


-- callback HookMarshaller
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "hook"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "marshal_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Defines the type of function used by g_hook_list_marshal()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookMarshaller =
    Ptr GLib.Hook.Hook ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "hook"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookMarshaller :: FunPtr C_HookMarshaller -> C_HookMarshaller

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookMarshaller ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookMarshaller
    -> GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@marshalData@/: user data
    -> m ()
dynamic_HookMarshaller __funPtr hook marshalData = liftIO $ do
    hook' <- unsafeManagedPtrGetPtr hook
    (__dynamic_C_HookMarshaller __funPtr) hook' marshalData
    touchManagedPtr hook
    return ()

-- | Generate a function pointer callable from C code, from a `C_HookMarshaller`.
foreign import ccall "wrapper"
    mk_HookMarshaller :: C_HookMarshaller -> IO (FunPtr C_HookMarshaller)

-- | Defines the type of function used by 'GI.GLib.Structs.HookList.hookListMarshal'.
type HookMarshaller =
    GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@marshalData@/: user data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookMarshaller`@.
noHookMarshaller :: Maybe HookMarshaller
noHookMarshaller = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookMarshaller :: MonadIO m => HookMarshaller -> m (GClosure C_HookMarshaller)
genClosure_HookMarshaller cb = liftIO $ do
    let cb' = wrap_HookMarshaller Nothing cb
    mk_HookMarshaller cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookMarshaller` into a `C_HookMarshaller`.
wrap_HookMarshaller :: 
    Maybe (Ptr (FunPtr C_HookMarshaller)) ->
    HookMarshaller ->
    C_HookMarshaller
wrap_HookMarshaller gi'funptrptr gi'cb hook marshalData = do
    hook' <- (newPtr GLib.Hook.Hook) hook
    gi'cb  hook' marshalData
    maybeReleaseFunPtr gi'funptrptr


-- callback HookFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the data field of the #GHook is passed to the hook function here"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of a hook function that can be invoked\nby g_hook_list_invoke()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the data field of the #GHook is passed to the hook function here"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookFunc :: FunPtr C_HookFunc -> C_HookFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookFunc
    -> Ptr ()
    -- ^ /@data@/: the data field of the t'GI.GLib.Structs.Hook.Hook' is passed to the hook function here
    -> m ()
dynamic_HookFunc __funPtr data_ = liftIO $ do
    (__dynamic_C_HookFunc __funPtr) data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_HookFunc`.
foreign import ccall "wrapper"
    mk_HookFunc :: C_HookFunc -> IO (FunPtr C_HookFunc)

-- | Defines the type of a hook function that can be invoked
-- by 'GI.GLib.Structs.HookList.hookListInvoke'.
type HookFunc =
    Ptr ()
    -- ^ /@data@/: the data field of the t'GI.GLib.Structs.Hook.Hook' is passed to the hook function here
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookFunc`@.
noHookFunc :: Maybe HookFunc
noHookFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookFunc :: MonadIO m => HookFunc -> m (GClosure C_HookFunc)
genClosure_HookFunc cb = liftIO $ do
    let cb' = wrap_HookFunc Nothing cb
    mk_HookFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookFunc` into a `C_HookFunc`.
wrap_HookFunc :: 
    Maybe (Ptr (FunPtr C_HookFunc)) ->
    HookFunc ->
    C_HookFunc
wrap_HookFunc gi'funptrptr gi'cb data_ = do
    gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr


-- callback HookFindFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if the required #GHook has been found"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "hook"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_hook_find_func()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just "Defines the type of the function passed to g_hook_find()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookFindFunc =
    Ptr GLib.Hook.Hook ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "hook"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_hook_find_func()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookFindFunc :: FunPtr C_HookFindFunc -> C_HookFindFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookFindFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookFindFunc
    -> GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@data@/: user data passed to @/g_hook_find_func()/@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the required t'GI.GLib.Structs.Hook.Hook' has been found
dynamic_HookFindFunc __funPtr hook data_ = liftIO $ do
    hook' <- unsafeManagedPtrGetPtr hook
    result <- (__dynamic_C_HookFindFunc __funPtr) hook' data_
    let result' = (/= 0) result
    touchManagedPtr hook
    return result'

-- | Generate a function pointer callable from C code, from a `C_HookFindFunc`.
foreign import ccall "wrapper"
    mk_HookFindFunc :: C_HookFindFunc -> IO (FunPtr C_HookFindFunc)

-- | Defines the type of the function passed to @/g_hook_find()/@.
type HookFindFunc =
    GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@data@/: user data passed to @/g_hook_find_func()/@
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the required t'GI.GLib.Structs.Hook.Hook' has been found

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookFindFunc`@.
noHookFindFunc :: Maybe HookFindFunc
noHookFindFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookFindFunc :: MonadIO m => HookFindFunc -> m (GClosure C_HookFindFunc)
genClosure_HookFindFunc cb = liftIO $ do
    let cb' = wrap_HookFindFunc Nothing cb
    mk_HookFindFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookFindFunc` into a `C_HookFindFunc`.
wrap_HookFindFunc :: 
    Maybe (Ptr (FunPtr C_HookFindFunc)) ->
    HookFindFunc ->
    C_HookFindFunc
wrap_HookFindFunc gi'funptrptr gi'cb hook data_ = do
    hook' <- (newPtr GLib.Hook.Hook) hook
    result <- gi'cb  hook' data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback HookFinalizeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "hook_list"
          , argType =
              TInterface Name { namespace = "GLib" , name = "HookList" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "hook"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the hook in @hook_list that gets finalized"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of function to be called when a hook in a\nlist of hooks gets finalized."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookFinalizeFunc =
    Ptr GLib.HookList.HookList ->
    Ptr GLib.Hook.Hook ->
    IO ()

-- Args: [ Arg
--           { argCName = "hook_list"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "HookList" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHookList" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hook"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the hook in @hook_list that gets finalized"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookFinalizeFunc :: FunPtr C_HookFinalizeFunc -> C_HookFinalizeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookFinalizeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookFinalizeFunc
    -> GLib.HookList.HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> GLib.Hook.Hook
    -- ^ /@hook@/: the hook in /@hookList@/ that gets finalized
    -> m ()
dynamic_HookFinalizeFunc __funPtr hookList hook = liftIO $ do
    hookList' <- unsafeManagedPtrGetPtr hookList
    hook' <- unsafeManagedPtrGetPtr hook
    (__dynamic_C_HookFinalizeFunc __funPtr) hookList' hook'
    touchManagedPtr hookList
    touchManagedPtr hook
    return ()

-- | Generate a function pointer callable from C code, from a `C_HookFinalizeFunc`.
foreign import ccall "wrapper"
    mk_HookFinalizeFunc :: C_HookFinalizeFunc -> IO (FunPtr C_HookFinalizeFunc)

-- | Defines the type of function to be called when a hook in a
-- list of hooks gets finalized.
type HookFinalizeFunc =
    GLib.HookList.HookList
    -- ^ /@hookList@/: a t'GI.GLib.Structs.HookList.HookList'
    -> GLib.Hook.Hook
    -- ^ /@hook@/: the hook in /@hookList@/ that gets finalized
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookFinalizeFunc`@.
noHookFinalizeFunc :: Maybe HookFinalizeFunc
noHookFinalizeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookFinalizeFunc :: MonadIO m => HookFinalizeFunc -> m (GClosure C_HookFinalizeFunc)
genClosure_HookFinalizeFunc cb = liftIO $ do
    let cb' = wrap_HookFinalizeFunc Nothing cb
    mk_HookFinalizeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookFinalizeFunc` into a `C_HookFinalizeFunc`.
wrap_HookFinalizeFunc :: 
    Maybe (Ptr (FunPtr C_HookFinalizeFunc)) ->
    HookFinalizeFunc ->
    C_HookFinalizeFunc
wrap_HookFinalizeFunc gi'funptrptr gi'cb hookList hook = do
    hookList' <- (newPtr GLib.HookList.HookList) hookList
    hook' <- (newPtr GLib.Hook.Hook) hook
    gi'cb  hookList' hook'
    maybeReleaseFunPtr gi'funptrptr


-- callback HookCompareFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just "a value <= 0 if @new_hook should be before @sibling"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "new_hook"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GHook being inserted"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "sibling"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GHook to compare with @new_hook"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of function used to compare #GHook elements in\ng_hook_insert_sorted()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookCompareFunc =
    Ptr GLib.Hook.Hook ->
    Ptr GLib.Hook.Hook ->
    IO Int32

-- Args: [ Arg
--           { argCName = "new_hook"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GHook being inserted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sibling"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GHook to compare with @new_hook"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookCompareFunc :: FunPtr C_HookCompareFunc -> C_HookCompareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookCompareFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookCompareFunc
    -> GLib.Hook.Hook
    -- ^ /@newHook@/: the t'GI.GLib.Structs.Hook.Hook' being inserted
    -> GLib.Hook.Hook
    -- ^ /@sibling@/: the t'GI.GLib.Structs.Hook.Hook' to compare with /@newHook@/
    -> m Int32
    -- ^ __Returns:__ a value \<= 0 if /@newHook@/ should be before /@sibling@/
dynamic_HookCompareFunc __funPtr newHook sibling = liftIO $ do
    newHook' <- unsafeManagedPtrGetPtr newHook
    sibling' <- unsafeManagedPtrGetPtr sibling
    result <- (__dynamic_C_HookCompareFunc __funPtr) newHook' sibling'
    touchManagedPtr newHook
    touchManagedPtr sibling
    return result

-- | Generate a function pointer callable from C code, from a `C_HookCompareFunc`.
foreign import ccall "wrapper"
    mk_HookCompareFunc :: C_HookCompareFunc -> IO (FunPtr C_HookCompareFunc)

-- | Defines the type of function used to compare t'GI.GLib.Structs.Hook.Hook' elements in
-- 'GI.GLib.Functions.hookInsertSorted'.
type HookCompareFunc =
    GLib.Hook.Hook
    -- ^ /@newHook@/: the t'GI.GLib.Structs.Hook.Hook' being inserted
    -> GLib.Hook.Hook
    -- ^ /@sibling@/: the t'GI.GLib.Structs.Hook.Hook' to compare with /@newHook@/
    -> IO Int32
    -- ^ __Returns:__ a value \<= 0 if /@newHook@/ should be before /@sibling@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookCompareFunc`@.
noHookCompareFunc :: Maybe HookCompareFunc
noHookCompareFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookCompareFunc :: MonadIO m => HookCompareFunc -> m (GClosure C_HookCompareFunc)
genClosure_HookCompareFunc cb = liftIO $ do
    let cb' = wrap_HookCompareFunc Nothing cb
    mk_HookCompareFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookCompareFunc` into a `C_HookCompareFunc`.
wrap_HookCompareFunc :: 
    Maybe (Ptr (FunPtr C_HookCompareFunc)) ->
    HookCompareFunc ->
    C_HookCompareFunc
wrap_HookCompareFunc gi'funptrptr gi'cb newHook sibling = do
    newHook' <- (newPtr GLib.Hook.Hook) newHook
    sibling' <- (newPtr GLib.Hook.Hook) sibling
    result <- gi'cb  newHook' sibling'
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback HookCheckMarshaller
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%FALSE if @hook should be destroyed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "hook"
          , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "marshal_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of function used by g_hook_list_marshal_check()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookCheckMarshaller =
    Ptr GLib.Hook.Hook ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "hook"
--           , argType = TInterface Name { namespace = "GLib" , name = "Hook" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GHook" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "marshal_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookCheckMarshaller :: FunPtr C_HookCheckMarshaller -> C_HookCheckMarshaller

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookCheckMarshaller ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookCheckMarshaller
    -> GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@marshalData@/: user data
    -> m Bool
    -- ^ __Returns:__ 'P.False' if /@hook@/ should be destroyed
dynamic_HookCheckMarshaller __funPtr hook marshalData = liftIO $ do
    hook' <- unsafeManagedPtrGetPtr hook
    result <- (__dynamic_C_HookCheckMarshaller __funPtr) hook' marshalData
    let result' = (/= 0) result
    touchManagedPtr hook
    return result'

-- | Generate a function pointer callable from C code, from a `C_HookCheckMarshaller`.
foreign import ccall "wrapper"
    mk_HookCheckMarshaller :: C_HookCheckMarshaller -> IO (FunPtr C_HookCheckMarshaller)

-- | Defines the type of function used by 'GI.GLib.Structs.HookList.hookListMarshalCheck'.
type HookCheckMarshaller =
    GLib.Hook.Hook
    -- ^ /@hook@/: a t'GI.GLib.Structs.Hook.Hook'
    -> Ptr ()
    -- ^ /@marshalData@/: user data
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if /@hook@/ should be destroyed

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookCheckMarshaller`@.
noHookCheckMarshaller :: Maybe HookCheckMarshaller
noHookCheckMarshaller = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookCheckMarshaller :: MonadIO m => HookCheckMarshaller -> m (GClosure C_HookCheckMarshaller)
genClosure_HookCheckMarshaller cb = liftIO $ do
    let cb' = wrap_HookCheckMarshaller Nothing cb
    mk_HookCheckMarshaller cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookCheckMarshaller` into a `C_HookCheckMarshaller`.
wrap_HookCheckMarshaller :: 
    Maybe (Ptr (FunPtr C_HookCheckMarshaller)) ->
    HookCheckMarshaller ->
    C_HookCheckMarshaller
wrap_HookCheckMarshaller gi'funptrptr gi'cb hook marshalData = do
    hook' <- (newPtr GLib.Hook.Hook) hook
    result <- gi'cb  hook' marshalData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback HookCheckFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%FALSE if the #GHook should be destroyed"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the data field of the #GHook is passed to the hook function here"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Defines the type of a hook function that can be invoked\nby g_hook_list_invoke_check()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HookCheckFunc =
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the data field of the #GHook is passed to the hook function here"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HookCheckFunc :: FunPtr C_HookCheckFunc -> C_HookCheckFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HookCheckFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HookCheckFunc
    -> Ptr ()
    -- ^ /@data@/: the data field of the t'GI.GLib.Structs.Hook.Hook' is passed to the hook function here
    -> m Bool
    -- ^ __Returns:__ 'P.False' if the t'GI.GLib.Structs.Hook.Hook' should be destroyed
dynamic_HookCheckFunc __funPtr data_ = liftIO $ do
    result <- (__dynamic_C_HookCheckFunc __funPtr) data_
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_HookCheckFunc`.
foreign import ccall "wrapper"
    mk_HookCheckFunc :: C_HookCheckFunc -> IO (FunPtr C_HookCheckFunc)

-- | Defines the type of a hook function that can be invoked
-- by 'GI.GLib.Structs.HookList.hookListInvokeCheck'.
type HookCheckFunc =
    Ptr ()
    -- ^ /@data@/: the data field of the t'GI.GLib.Structs.Hook.Hook' is passed to the hook function here
    -> IO Bool
    -- ^ __Returns:__ 'P.False' if the t'GI.GLib.Structs.Hook.Hook' should be destroyed

-- | A convenience synonym for @`Nothing` :: `Maybe` `HookCheckFunc`@.
noHookCheckFunc :: Maybe HookCheckFunc
noHookCheckFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HookCheckFunc :: MonadIO m => HookCheckFunc -> m (GClosure C_HookCheckFunc)
genClosure_HookCheckFunc cb = liftIO $ do
    let cb' = wrap_HookCheckFunc Nothing cb
    mk_HookCheckFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HookCheckFunc` into a `C_HookCheckFunc`.
wrap_HookCheckFunc :: 
    Maybe (Ptr (FunPtr C_HookCheckFunc)) ->
    HookCheckFunc ->
    C_HookCheckFunc
wrap_HookCheckFunc gi'funptrptr gi'cb data_ = do
    result <- gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback HashFunc
{- Callable
  { returnType = Just (TBasicType TUInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the hash value corresponding to the key"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a key" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the hash function which is passed to\ng_hash_table_new() when a #GHashTable is created.\n\nThe function is passed a key and should return a #guint hash value.\nThe functions g_direct_hash(), g_int_hash() and g_str_hash() provide\nhash functions which can be used when the key is a #gpointer, #gint*,\nand #gchar* respectively.\n\ng_direct_hash() is also the appropriate hash function for keys\nof the form `GINT_TO_POINTER (n)` (or similar macros).\n\nA good hash functions should produce\nhash values that are evenly distributed over a fairly large range.\nThe modulus is taken with the hash table size (a prime number) to\nfind the 'bucket' to place each key into. The function should also\nbe very fast, since it is called for each key lookup.\n\nNote that the hash functions provided by GLib have these qualities,\nbut are not particularly robust against manufactured keys that\ncause hash collisions. Therefore, you should consider choosing\na more secure hash function when using a GHashTable with keys\nthat originate in untrusted data (such as HTTP requests).\nUsing g_str_hash() in that situation might make your application\nvulnerable to\n[Algorithmic Complexity Attacks](https://lwn.net/Articles/474912/).\n\nThe key to choosing a good hash is unpredictability.  Even\ncryptographic hashes are very easy to find collisions for when the\nremainder is taken modulo a somewhat predictable prime number.  There\nmust be an element of randomness that an attacker is unable to guess."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HashFunc =
    Ptr () ->
    IO Word32

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HashFunc :: FunPtr C_HashFunc -> C_HashFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HashFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HashFunc
    -> Ptr ()
    -- ^ /@key@/: a key
    -> m Word32
    -- ^ __Returns:__ the hash value corresponding to the key
dynamic_HashFunc __funPtr key = liftIO $ do
    result <- (__dynamic_C_HashFunc __funPtr) key
    return result

-- | Generate a function pointer callable from C code, from a `C_HashFunc`.
foreign import ccall "wrapper"
    mk_HashFunc :: C_HashFunc -> IO (FunPtr C_HashFunc)

-- | Specifies the type of the hash function which is passed to
-- @/g_hash_table_new()/@ when a t'GI.GLib.Structs.HashTable.HashTable' is created.
-- 
-- The function is passed a key and should return a @/guint/@ hash value.
-- The functions 'GI.GLib.Functions.directHash', 'GI.GLib.Functions.intHash' and 'GI.GLib.Functions.strHash' provide
-- hash functions which can be used when the key is a @/gpointer/@, @/gint/@*,
-- and @/gchar/@* respectively.
-- 
-- 'GI.GLib.Functions.directHash' is also the appropriate hash function for keys
-- of the form @GINT_TO_POINTER (n)@ (or similar macros).
-- 
-- A good hash functions should produce
-- hash values that are evenly distributed over a fairly large range.
-- The modulus is taken with the hash table size (a prime number) to
-- find the \'bucket\' to place each key into. The function should also
-- be very fast, since it is called for each key lookup.
-- 
-- Note that the hash functions provided by GLib have these qualities,
-- but are not particularly robust against manufactured keys that
-- cause hash collisions. Therefore, you should consider choosing
-- a more secure hash function when using a GHashTable with keys
-- that originate in untrusted data (such as HTTP requests).
-- Using 'GI.GLib.Functions.strHash' in that situation might make your application
-- vulnerable to
-- <https://lwn.net/Articles/474912/ Algorithmic Complexity Attacks>.
-- 
-- The key to choosing a good hash is unpredictability.  Even
-- cryptographic hashes are very easy to find collisions for when the
-- remainder is taken modulo a somewhat predictable prime number.  There
-- must be an element of randomness that an attacker is unable to guess.
type HashFunc =
    Ptr ()
    -- ^ /@key@/: a key
    -> IO Word32
    -- ^ __Returns:__ the hash value corresponding to the key

-- | A convenience synonym for @`Nothing` :: `Maybe` `HashFunc`@.
noHashFunc :: Maybe HashFunc
noHashFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_HashFunc :: MonadIO m => HashFunc -> m (GClosure C_HashFunc)
genClosure_HashFunc cb = liftIO $ do
    let cb' = wrap_HashFunc Nothing cb
    mk_HashFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `HashFunc` into a `C_HashFunc`.
wrap_HashFunc :: 
    Maybe (Ptr (FunPtr C_HashFunc)) ->
    HashFunc ->
    C_HashFunc
wrap_HashFunc gi'funptrptr gi'cb key = do
    result <- gi'cb  key
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback HRFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "true if the key/value pair should be selected, and\n  false otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a key" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the value associated with the key"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to the calling function"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the function passed to\n[func@GLib.HashTable.find], [func@GLib.HashTable.foreach_remove], and\n[func@GLib.HashTable.foreach_steal].\n\nThe function is called with each key/value pair, together with\nthe @user_data parameter passed to the calling function.\n\nThe function should return true if the key/value pair should be\nselected, meaning it has been found or it should be removed from the\n[struct@GLib.HashTable], depending on the calling function."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HRFunc =
    Ptr () ->
    Ptr () ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value associated with the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to the calling function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HRFunc :: FunPtr C_HRFunc -> C_HRFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HRFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HRFunc
    -> Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value associated with the key
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the calling function
    -> m Bool
    -- ^ __Returns:__ true if the key\/value pair should be selected, and
    --   false otherwise
dynamic_HRFunc __funPtr key value userData = liftIO $ do
    result <- (__dynamic_C_HRFunc __funPtr) key value userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_HRFunc`.
foreign import ccall "wrapper"
    mk_HRFunc :: C_HRFunc -> IO (FunPtr C_HRFunc)

-- | Specifies the type of the function passed to
-- 'GI.GLib.Structs.HashTable.hashTableFind', 'GI.GLib.Structs.HashTable.hashTableForeachRemove', and
-- 'GI.GLib.Structs.HashTable.hashTableForeachSteal'.
-- 
-- The function is called with each key\/value pair, together with
-- the /@userData@/ parameter passed to the calling function.
-- 
-- The function should return true if the key\/value pair should be
-- selected, meaning it has been found or it should be removed from the
-- t'GHashTable', depending on the calling function.
type HRFunc =
    Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value associated with the key
    -> IO Bool
    -- ^ __Returns:__ true if the key\/value pair should be selected, and
    --   false otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `HRFunc`@.
noHRFunc :: Maybe HRFunc
noHRFunc = Nothing

-- | Specifies the type of the function passed to
-- 'GI.GLib.Structs.HashTable.hashTableFind', 'GI.GLib.Structs.HashTable.hashTableForeachRemove', and
-- 'GI.GLib.Structs.HashTable.hashTableForeachSteal'.
-- 
-- The function is called with each key\/value pair, together with
-- the /@userData@/ parameter passed to the calling function.
-- 
-- The function should return true if the key\/value pair should be
-- selected, meaning it has been found or it should be removed from the
-- t'GHashTable', depending on the calling function.
type HRFunc_WithClosures =
    Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value associated with the key
    -> Ptr ()
    -- ^ /@userData@/: user data passed to the calling function
    -> IO Bool
    -- ^ __Returns:__ true if the key\/value pair should be selected, and
    --   false otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `HRFunc_WithClosures`@.
noHRFunc_WithClosures :: Maybe HRFunc_WithClosures
noHRFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_HRFunc :: HRFunc -> HRFunc_WithClosures
drop_closures_HRFunc _f key value _ = _f key value

-- | Wrap the callback into a `GClosure`.
genClosure_HRFunc :: MonadIO m => HRFunc -> m (GClosure C_HRFunc)
genClosure_HRFunc cb = liftIO $ do
    let cb' = drop_closures_HRFunc cb
    let cb'' = wrap_HRFunc Nothing cb'
    mk_HRFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `HRFunc` into a `C_HRFunc`.
wrap_HRFunc :: 
    Maybe (Ptr (FunPtr C_HRFunc)) ->
    HRFunc_WithClosures ->
    C_HRFunc
wrap_HRFunc gi'funptrptr gi'cb key value userData = do
    result <- gi'cb  key value userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback HFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a key" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "value"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the value corresponding to the key"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_hash_table_foreach()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the function passed to g_hash_table_foreach().\nIt is called with each key/value pair, together with the @user_data\nparameter which is passed to g_hash_table_foreach()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_HFunc =
    Ptr () ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the value corresponding to the key"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_hash_table_foreach()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_HFunc :: FunPtr C_HFunc -> C_HFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_HFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_HFunc
    -> Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.hashTableForeach'
    -> m ()
dynamic_HFunc __funPtr key value userData = liftIO $ do
    (__dynamic_C_HFunc __funPtr) key value userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_HFunc`.
foreign import ccall "wrapper"
    mk_HFunc :: C_HFunc -> IO (FunPtr C_HFunc)

-- | Specifies the type of the function passed to 'GI.GLib.Functions.hashTableForeach'.
-- It is called with each key\/value pair, together with the /@userData@/
-- parameter which is passed to 'GI.GLib.Functions.hashTableForeach'.
type HFunc =
    Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `HFunc`@.
noHFunc :: Maybe HFunc
noHFunc = Nothing

-- | Specifies the type of the function passed to 'GI.GLib.Functions.hashTableForeach'.
-- It is called with each key\/value pair, together with the /@userData@/
-- parameter which is passed to 'GI.GLib.Functions.hashTableForeach'.
type HFunc_WithClosures =
    Ptr ()
    -- ^ /@key@/: a key
    -> Ptr ()
    -- ^ /@value@/: the value corresponding to the key
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.hashTableForeach'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `HFunc_WithClosures`@.
noHFunc_WithClosures :: Maybe HFunc_WithClosures
noHFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_HFunc :: HFunc -> HFunc_WithClosures
drop_closures_HFunc _f key value _ = _f key value

-- | Wrap the callback into a `GClosure`.
genClosure_HFunc :: MonadIO m => HFunc -> m (GClosure C_HFunc)
genClosure_HFunc cb = liftIO $ do
    let cb' = drop_closures_HFunc cb
    let cb'' = wrap_HFunc Nothing cb'
    mk_HFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `HFunc` into a `C_HFunc`.
wrap_HFunc :: 
    Maybe (Ptr (FunPtr C_HFunc)) ->
    HFunc_WithClosures ->
    C_HFunc
wrap_HFunc gi'funptrptr gi'cb key value userData = do
    gi'cb  key value userData
    maybeReleaseFunPtr gi'funptrptr


-- callback Func
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the element's data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to g_list_foreach() or g_slist_foreach()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of functions passed to g_list_foreach() and\ng_slist_foreach()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_Func =
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the element's data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to g_list_foreach() or g_slist_foreach()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_Func :: FunPtr C_Func -> C_Func

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_Func ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_Func
    -> Ptr ()
    -- ^ /@data@/: the element\'s data
    -> Ptr ()
    -- ^ /@userData@/: user data passed to @/g_list_foreach()/@ or @/g_slist_foreach()/@
    -> m ()
dynamic_Func __funPtr data_ userData = liftIO $ do
    (__dynamic_C_Func __funPtr) data_ userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_Func`.
foreign import ccall "wrapper"
    mk_Func :: C_Func -> IO (FunPtr C_Func)

-- | Specifies the type of functions passed to @/g_list_foreach()/@ and
-- @/g_slist_foreach()/@.
type Func =
    Ptr ()
    -- ^ /@data@/: the element\'s data
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `Func`@.
noFunc :: Maybe Func
noFunc = Nothing

-- | Specifies the type of functions passed to @/g_list_foreach()/@ and
-- @/g_slist_foreach()/@.
type Func_WithClosures =
    Ptr ()
    -- ^ /@data@/: the element\'s data
    -> Ptr ()
    -- ^ /@userData@/: user data passed to @/g_list_foreach()/@ or @/g_slist_foreach()/@
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `Func_WithClosures`@.
noFunc_WithClosures :: Maybe Func_WithClosures
noFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_Func :: Func -> Func_WithClosures
drop_closures_Func _f data_ _ = _f data_

-- | Wrap the callback into a `GClosure`.
genClosure_Func :: MonadIO m => Func -> m (GClosure C_Func)
genClosure_Func cb = liftIO $ do
    let cb' = drop_closures_Func cb
    let cb'' = wrap_Func Nothing cb'
    mk_Func cb'' >>= B.GClosure.newGClosure


-- | Wrap a `Func` into a `C_Func`.
wrap_Func :: 
    Maybe (Ptr (FunPtr C_Func)) ->
    Func_WithClosures ->
    C_Func
wrap_Func gi'funptrptr gi'cb data_ userData = do
    gi'cb  data_ userData
    maybeReleaseFunPtr gi'funptrptr


-- callback FreeFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a data pointer" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Declares a type of function which takes an arbitrary\ndata pointer argument and has no return value. It is\nnot currently used in GLib or GTK."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_FreeFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a data pointer" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_FreeFunc :: FunPtr C_FreeFunc -> C_FreeFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_FreeFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_FreeFunc
    -> Ptr ()
    -- ^ /@data@/: a data pointer
    -> m ()
dynamic_FreeFunc __funPtr data_ = liftIO $ do
    (__dynamic_C_FreeFunc __funPtr) data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_FreeFunc`.
foreign import ccall "wrapper"
    mk_FreeFunc :: C_FreeFunc -> IO (FunPtr C_FreeFunc)

-- | Declares a type of function which takes an arbitrary
-- data pointer argument and has no return value. It is
-- not currently used in GLib or GTK.
type FreeFunc =
    Ptr ()
    -- ^ /@data@/: a data pointer
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `FreeFunc`@.
noFreeFunc :: Maybe FreeFunc
noFreeFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_FreeFunc :: MonadIO m => FreeFunc -> m (GClosure C_FreeFunc)
genClosure_FreeFunc cb = liftIO $ do
    let cb' = wrap_FreeFunc Nothing cb
    mk_FreeFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `FreeFunc` into a `C_FreeFunc`.
wrap_FreeFunc :: 
    Maybe (Ptr (FunPtr C_FreeFunc)) ->
    FreeFunc ->
    C_FreeFunc
wrap_FreeFunc gi'funptrptr gi'cb data_ = do
    gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr


-- callback ErrorInitFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "extended error" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function which is called just after an\nextended error instance is created and its fields filled. It should\nonly initialize the fields in the private data, which can be\nreceived with the generated `*_get_private()` function.\n\nNormally, it is better to use G_DEFINE_EXTENDED_ERROR(), as it\nalready takes care of getting the private data from @error."
        , sinceVersion = Just "2.68"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ErrorInitFunc =
    Ptr GError ->
    IO ()

-- Args: [ Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "extended error" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ErrorInitFunc :: FunPtr C_ErrorInitFunc -> C_ErrorInitFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ErrorInitFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ErrorInitFunc
    -> GError
    -- ^ /@error@/: extended error
    -> m ()
dynamic_ErrorInitFunc __funPtr error_ = liftIO $ do
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_ErrorInitFunc __funPtr) error_'
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_ErrorInitFunc`.
foreign import ccall "wrapper"
    mk_ErrorInitFunc :: C_ErrorInitFunc -> IO (FunPtr C_ErrorInitFunc)

-- | Specifies the type of function which is called just after an
-- extended error instance is created and its fields filled. It should
-- only initialize the fields in the private data, which can be
-- received with the generated @*_get_private()@ function.
-- 
-- Normally, it is better to use @/G_DEFINE_EXTENDED_ERROR()/@, as it
-- already takes care of getting the private data from /@error@/.
-- 
-- /Since: 2.68/
type ErrorInitFunc =
    GError
    -- ^ /@error@/: extended error
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ErrorInitFunc`@.
noErrorInitFunc :: Maybe ErrorInitFunc
noErrorInitFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ErrorInitFunc :: MonadIO m => ErrorInitFunc -> m (GClosure C_ErrorInitFunc)
genClosure_ErrorInitFunc cb = liftIO $ do
    let cb' = wrap_ErrorInitFunc Nothing cb
    mk_ErrorInitFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ErrorInitFunc` into a `C_ErrorInitFunc`.
wrap_ErrorInitFunc :: 
    Maybe (Ptr (FunPtr C_ErrorInitFunc)) ->
    ErrorInitFunc ->
    C_ErrorInitFunc
wrap_ErrorInitFunc gi'funptrptr gi'cb error_ = do
    error_' <- (newBoxed GError) error_
    gi'cb  error_'
    maybeReleaseFunPtr gi'funptrptr


-- callback ErrorCopyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "src_error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "source extended error"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "dest_error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "destination extended error"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function which is called when an extended\nerror instance is copied. It is passed the pointer to the\ndestination error and source error, and should copy only the fields\nof the private data from @src_error to @dest_error.\n\nNormally, it is better to use G_DEFINE_EXTENDED_ERROR(), as it\nalready takes care of getting the private data from @src_error and\n@dest_error."
        , sinceVersion = Just "2.68"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ErrorCopyFunc =
    Ptr GError ->
    Ptr GError ->
    IO ()

-- Args: [ Arg
--           { argCName = "src_error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "source extended error"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "destination extended error"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ErrorCopyFunc :: FunPtr C_ErrorCopyFunc -> C_ErrorCopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ErrorCopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ErrorCopyFunc
    -> GError
    -- ^ /@srcError@/: source extended error
    -> GError
    -- ^ /@destError@/: destination extended error
    -> m ()
dynamic_ErrorCopyFunc __funPtr srcError destError = liftIO $ do
    srcError' <- unsafeManagedPtrGetPtr srcError
    destError' <- unsafeManagedPtrGetPtr destError
    (__dynamic_C_ErrorCopyFunc __funPtr) srcError' destError'
    touchManagedPtr srcError
    touchManagedPtr destError
    return ()

-- | Generate a function pointer callable from C code, from a `C_ErrorCopyFunc`.
foreign import ccall "wrapper"
    mk_ErrorCopyFunc :: C_ErrorCopyFunc -> IO (FunPtr C_ErrorCopyFunc)

-- | Specifies the type of function which is called when an extended
-- error instance is copied. It is passed the pointer to the
-- destination error and source error, and should copy only the fields
-- of the private data from /@srcError@/ to /@destError@/.
-- 
-- Normally, it is better to use @/G_DEFINE_EXTENDED_ERROR()/@, as it
-- already takes care of getting the private data from /@srcError@/ and
-- /@destError@/.
-- 
-- /Since: 2.68/
type ErrorCopyFunc =
    GError
    -- ^ /@srcError@/: source extended error
    -> GError
    -- ^ /@destError@/: destination extended error
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ErrorCopyFunc`@.
noErrorCopyFunc :: Maybe ErrorCopyFunc
noErrorCopyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ErrorCopyFunc :: MonadIO m => ErrorCopyFunc -> m (GClosure C_ErrorCopyFunc)
genClosure_ErrorCopyFunc cb = liftIO $ do
    let cb' = wrap_ErrorCopyFunc Nothing cb
    mk_ErrorCopyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ErrorCopyFunc` into a `C_ErrorCopyFunc`.
wrap_ErrorCopyFunc :: 
    Maybe (Ptr (FunPtr C_ErrorCopyFunc)) ->
    ErrorCopyFunc ->
    C_ErrorCopyFunc
wrap_ErrorCopyFunc gi'funptrptr gi'cb srcError destError = do
    srcError' <- (newBoxed GError) srcError
    destError' <- (newBoxed GError) destError
    gi'cb  srcError' destError'
    maybeReleaseFunPtr gi'funptrptr


-- callback ErrorClearFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "error"
          , argType = TError
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "extended error to clear"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function which is called when an extended\nerror instance is freed. It is passed the error pointer about to be\nfreed, and should free the error's private data fields.\n\nNormally, it is better to use G_DEFINE_EXTENDED_ERROR(), as it\nalready takes care of getting the private data from @error."
        , sinceVersion = Just "2.68"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ErrorClearFunc =
    Ptr GError ->
    IO ()

-- Args: [ Arg
--           { argCName = "error"
--           , argType = TError
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "extended error to clear"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ErrorClearFunc :: FunPtr C_ErrorClearFunc -> C_ErrorClearFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ErrorClearFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ErrorClearFunc
    -> GError
    -- ^ /@error@/: extended error to clear
    -> m ()
dynamic_ErrorClearFunc __funPtr error_ = liftIO $ do
    error_' <- unsafeManagedPtrGetPtr error_
    (__dynamic_C_ErrorClearFunc __funPtr) error_'
    touchManagedPtr error_
    return ()

-- | Generate a function pointer callable from C code, from a `C_ErrorClearFunc`.
foreign import ccall "wrapper"
    mk_ErrorClearFunc :: C_ErrorClearFunc -> IO (FunPtr C_ErrorClearFunc)

-- | Specifies the type of function which is called when an extended
-- error instance is freed. It is passed the error pointer about to be
-- freed, and should free the error\'s private data fields.
-- 
-- Normally, it is better to use @/G_DEFINE_EXTENDED_ERROR()/@, as it
-- already takes care of getting the private data from /@error@/.
-- 
-- /Since: 2.68/
type ErrorClearFunc =
    GError
    -- ^ /@error@/: extended error to clear
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ErrorClearFunc`@.
noErrorClearFunc :: Maybe ErrorClearFunc
noErrorClearFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ErrorClearFunc :: MonadIO m => ErrorClearFunc -> m (GClosure C_ErrorClearFunc)
genClosure_ErrorClearFunc cb = liftIO $ do
    let cb' = wrap_ErrorClearFunc Nothing cb
    mk_ErrorClearFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ErrorClearFunc` into a `C_ErrorClearFunc`.
wrap_ErrorClearFunc :: 
    Maybe (Ptr (FunPtr C_ErrorClearFunc)) ->
    ErrorClearFunc ->
    C_ErrorClearFunc
wrap_ErrorClearFunc gi'funptrptr gi'cb error_ = do
    error_' <- (newBoxed GError) error_
    gi'cb  error_'
    maybeReleaseFunPtr gi'funptrptr


-- callback EqualFuncFull
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if @a = @b; %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "a"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value to compare with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data provided by the caller"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of a function used to test two values for\nequality. The function should return %TRUE if both values are equal\nand %FALSE otherwise.\n\nThis is a version of #GEqualFunc which provides a @user_data closure from\nthe caller."
        , sinceVersion = Just "2.74"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EqualFuncFull =
    Ptr () ->
    Ptr () ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "a"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value to compare with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data provided by the caller"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EqualFuncFull :: FunPtr C_EqualFuncFull -> C_EqualFuncFull

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EqualFuncFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_EqualFuncFull
    -> Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> Ptr ()
    -- ^ /@userData@/: user data provided by the caller
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@a@/ = /@b@/; 'P.False' otherwise
dynamic_EqualFuncFull __funPtr a b userData = liftIO $ do
    result <- (__dynamic_C_EqualFuncFull __funPtr) a b userData
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_EqualFuncFull`.
foreign import ccall "wrapper"
    mk_EqualFuncFull :: C_EqualFuncFull -> IO (FunPtr C_EqualFuncFull)

-- | Specifies the type of a function used to test two values for
-- equality. The function should return 'P.True' if both values are equal
-- and 'P.False' otherwise.
-- 
-- This is a version of t'GI.GLib.Callbacks.EqualFunc' which provides a /@userData@/ closure from
-- the caller.
-- 
-- /Since: 2.74/
type EqualFuncFull =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@a@/ = /@b@/; 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `EqualFuncFull`@.
noEqualFuncFull :: Maybe EqualFuncFull
noEqualFuncFull = Nothing

-- | Specifies the type of a function used to test two values for
-- equality. The function should return 'P.True' if both values are equal
-- and 'P.False' otherwise.
-- 
-- This is a version of t'GI.GLib.Callbacks.EqualFunc' which provides a /@userData@/ closure from
-- the caller.
-- 
-- /Since: 2.74/
type EqualFuncFull_WithClosures =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> Ptr ()
    -- ^ /@userData@/: user data provided by the caller
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@a@/ = /@b@/; 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `EqualFuncFull_WithClosures`@.
noEqualFuncFull_WithClosures :: Maybe EqualFuncFull_WithClosures
noEqualFuncFull_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_EqualFuncFull :: EqualFuncFull -> EqualFuncFull_WithClosures
drop_closures_EqualFuncFull _f a b _ = _f a b

-- | Wrap the callback into a `GClosure`.
genClosure_EqualFuncFull :: MonadIO m => EqualFuncFull -> m (GClosure C_EqualFuncFull)
genClosure_EqualFuncFull cb = liftIO $ do
    let cb' = drop_closures_EqualFuncFull cb
    let cb'' = wrap_EqualFuncFull Nothing cb'
    mk_EqualFuncFull cb'' >>= B.GClosure.newGClosure


-- | Wrap a `EqualFuncFull` into a `C_EqualFuncFull`.
wrap_EqualFuncFull :: 
    Maybe (Ptr (FunPtr C_EqualFuncFull)) ->
    EqualFuncFull_WithClosures ->
    C_EqualFuncFull
wrap_EqualFuncFull gi'funptrptr gi'cb a b userData = do
    result <- gi'cb  a b userData
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback EqualFunc
{- Callable
  { returnType = Just (TBasicType TBoolean)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "%TRUE if @a = @b; %FALSE otherwise"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "a"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value to compare with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of a function used to test two values for\nequality. The function should return %TRUE if both values are equal\nand %FALSE otherwise."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_EqualFunc =
    Ptr () ->
    Ptr () ->
    IO CInt

-- Args: [ Arg
--           { argCName = "a"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value to compare with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_EqualFunc :: FunPtr C_EqualFunc -> C_EqualFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_EqualFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_EqualFunc
    -> Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@a@/ = /@b@/; 'P.False' otherwise
dynamic_EqualFunc __funPtr a b = liftIO $ do
    result <- (__dynamic_C_EqualFunc __funPtr) a b
    let result' = (/= 0) result
    return result'

-- | Generate a function pointer callable from C code, from a `C_EqualFunc`.
foreign import ccall "wrapper"
    mk_EqualFunc :: C_EqualFunc -> IO (FunPtr C_EqualFunc)

-- | Specifies the type of a function used to test two values for
-- equality. The function should return 'P.True' if both values are equal
-- and 'P.False' otherwise.
type EqualFunc =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if /@a@/ = /@b@/; 'P.False' otherwise

-- | A convenience synonym for @`Nothing` :: `Maybe` `EqualFunc`@.
noEqualFunc :: Maybe EqualFunc
noEqualFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_EqualFunc :: MonadIO m => EqualFunc -> m (GClosure C_EqualFunc)
genClosure_EqualFunc cb = liftIO $ do
    let cb' = wrap_EqualFunc Nothing cb
    mk_EqualFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `EqualFunc` into a `C_EqualFunc`.
wrap_EqualFunc :: 
    Maybe (Ptr (FunPtr C_EqualFunc)) ->
    EqualFunc ->
    C_EqualFunc
wrap_EqualFunc gi'funptrptr gi'cb a b = do
    result <- gi'cb  a b
    maybeReleaseFunPtr gi'funptrptr
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- callback DuplicateFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a duplicate of data"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data to duplicate"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "user data that was specified in\n            g_datalist_id_dup_data()"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "The type of functions that are used to 'duplicate' an object.\nWhat this means depends on the context, it could just be\nincrementing the reference count, if @data is a ref-counted\nobject."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DuplicateFunc =
    Ptr () ->
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to duplicate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "user data that was specified in\n            g_datalist_id_dup_data()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DuplicateFunc :: FunPtr C_DuplicateFunc -> C_DuplicateFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DuplicateFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DuplicateFunc
    -> Ptr ()
    -- ^ /@data@/: the data to duplicate
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified in
    --             @/g_datalist_id_dup_data()/@
    -> m (Ptr ())
    -- ^ __Returns:__ a duplicate of data
dynamic_DuplicateFunc __funPtr data_ userData = liftIO $ do
    result <- (__dynamic_C_DuplicateFunc __funPtr) data_ userData
    return result

-- | Generate a function pointer callable from C code, from a `C_DuplicateFunc`.
foreign import ccall "wrapper"
    mk_DuplicateFunc :: C_DuplicateFunc -> IO (FunPtr C_DuplicateFunc)

-- | The type of functions that are used to \'duplicate\' an object.
-- What this means depends on the context, it could just be
-- incrementing the reference count, if /@data@/ is a ref-counted
-- object.
type DuplicateFunc =
    Ptr ()
    -- ^ /@data@/: the data to duplicate
    -> IO (Ptr ())
    -- ^ __Returns:__ a duplicate of data

-- | A convenience synonym for @`Nothing` :: `Maybe` `DuplicateFunc`@.
noDuplicateFunc :: Maybe DuplicateFunc
noDuplicateFunc = Nothing

-- | The type of functions that are used to \'duplicate\' an object.
-- What this means depends on the context, it could just be
-- incrementing the reference count, if /@data@/ is a ref-counted
-- object.
type DuplicateFunc_WithClosures =
    Ptr ()
    -- ^ /@data@/: the data to duplicate
    -> Ptr ()
    -- ^ /@userData@/: user data that was specified in
    --             @/g_datalist_id_dup_data()/@
    -> IO (Ptr ())
    -- ^ __Returns:__ a duplicate of data

-- | A convenience synonym for @`Nothing` :: `Maybe` `DuplicateFunc_WithClosures`@.
noDuplicateFunc_WithClosures :: Maybe DuplicateFunc_WithClosures
noDuplicateFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DuplicateFunc :: DuplicateFunc -> DuplicateFunc_WithClosures
drop_closures_DuplicateFunc _f data_ _ = _f data_

-- | Wrap the callback into a `GClosure`.
genClosure_DuplicateFunc :: MonadIO m => DuplicateFunc -> m (GClosure C_DuplicateFunc)
genClosure_DuplicateFunc cb = liftIO $ do
    let cb' = drop_closures_DuplicateFunc cb
    let cb'' = wrap_DuplicateFunc Nothing cb'
    mk_DuplicateFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DuplicateFunc` into a `C_DuplicateFunc`.
wrap_DuplicateFunc :: 
    Maybe (Ptr (FunPtr C_DuplicateFunc)) ->
    DuplicateFunc_WithClosures ->
    C_DuplicateFunc
wrap_DuplicateFunc gi'funptrptr gi'cb data_ userData = do
    result <- gi'cb  data_ userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback DestroyNotify
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data element." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function which is called when a data element\nis destroyed. It is passed the pointer to the data element and\nshould free any memory and resources allocated for it."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DestroyNotify =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data element." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DestroyNotify :: FunPtr C_DestroyNotify -> C_DestroyNotify

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DestroyNotify ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DestroyNotify
    -> Ptr ()
    -- ^ /@data@/: the data element.
    -> m ()
dynamic_DestroyNotify __funPtr data_ = liftIO $ do
    (__dynamic_C_DestroyNotify __funPtr) data_
    return ()

-- | Generate a function pointer callable from C code, from a `C_DestroyNotify`.
foreign import ccall "wrapper"
    mk_DestroyNotify :: C_DestroyNotify -> IO (FunPtr C_DestroyNotify)

-- | Specifies the type of function which is called when a data element
-- is destroyed. It is passed the pointer to the data element and
-- should free any memory and resources allocated for it.
type DestroyNotify =
    Ptr ()
    -- ^ /@data@/: the data element.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DestroyNotify`@.
noDestroyNotify :: Maybe DestroyNotify
noDestroyNotify = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_DestroyNotify :: MonadIO m => DestroyNotify -> m (GClosure C_DestroyNotify)
genClosure_DestroyNotify cb = liftIO $ do
    let cb' = wrap_DestroyNotify Nothing cb
    mk_DestroyNotify cb' >>= B.GClosure.newGClosure


-- | Wrap a `DestroyNotify` into a `C_DestroyNotify`.
wrap_DestroyNotify :: 
    Maybe (Ptr (FunPtr C_DestroyNotify)) ->
    DestroyNotify ->
    C_DestroyNotify
wrap_DestroyNotify gi'funptrptr gi'cb data_ = do
    gi'cb  data_
    maybeReleaseFunPtr gi'funptrptr


-- callback DataForeachFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "key_id"
          , argType = TBasicType TUInt32
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just "the #GQuark id to identifying the data element."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the data element." , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data passed to g_dataset_foreach()."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to g_dataset_foreach(). It is\ncalled with each #GQuark id and associated data element, together\nwith the @user_data parameter supplied to g_dataset_foreach()."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_DataForeachFunc =
    Word32 ->
    Ptr () ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "key_id"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the #GQuark id to identifying the data element."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data element." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to g_dataset_foreach()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_DataForeachFunc :: FunPtr C_DataForeachFunc -> C_DataForeachFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_DataForeachFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_DataForeachFunc
    -> Word32
    -- ^ /@keyId@/: the @/GQuark/@ id to identifying the data element.
    -> Ptr ()
    -- ^ /@data@/: the data element.
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.datasetForeach'.
    -> m ()
dynamic_DataForeachFunc __funPtr keyId data_ userData = liftIO $ do
    (__dynamic_C_DataForeachFunc __funPtr) keyId data_ userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_DataForeachFunc`.
foreign import ccall "wrapper"
    mk_DataForeachFunc :: C_DataForeachFunc -> IO (FunPtr C_DataForeachFunc)

-- | Specifies the type of function passed to 'GI.GLib.Functions.datasetForeach'. It is
-- called with each @/GQuark/@ id and associated data element, together
-- with the /@userData@/ parameter supplied to 'GI.GLib.Functions.datasetForeach'.
type DataForeachFunc =
    Word32
    -- ^ /@keyId@/: the @/GQuark/@ id to identifying the data element.
    -> Ptr ()
    -- ^ /@data@/: the data element.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DataForeachFunc`@.
noDataForeachFunc :: Maybe DataForeachFunc
noDataForeachFunc = Nothing

-- | Specifies the type of function passed to 'GI.GLib.Functions.datasetForeach'. It is
-- called with each @/GQuark/@ id and associated data element, together
-- with the /@userData@/ parameter supplied to 'GI.GLib.Functions.datasetForeach'.
type DataForeachFunc_WithClosures =
    Word32
    -- ^ /@keyId@/: the @/GQuark/@ id to identifying the data element.
    -> Ptr ()
    -- ^ /@data@/: the data element.
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.datasetForeach'.
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `DataForeachFunc_WithClosures`@.
noDataForeachFunc_WithClosures :: Maybe DataForeachFunc_WithClosures
noDataForeachFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_DataForeachFunc :: DataForeachFunc -> DataForeachFunc_WithClosures
drop_closures_DataForeachFunc _f keyId data_ _ = _f keyId data_

-- | Wrap the callback into a `GClosure`.
genClosure_DataForeachFunc :: MonadIO m => DataForeachFunc -> m (GClosure C_DataForeachFunc)
genClosure_DataForeachFunc cb = liftIO $ do
    let cb' = drop_closures_DataForeachFunc cb
    let cb'' = wrap_DataForeachFunc Nothing cb'
    mk_DataForeachFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `DataForeachFunc` into a `C_DataForeachFunc`.
wrap_DataForeachFunc :: 
    Maybe (Ptr (FunPtr C_DataForeachFunc)) ->
    DataForeachFunc_WithClosures ->
    C_DataForeachFunc
wrap_DataForeachFunc gi'funptrptr gi'cb keyId data_ userData = do
    gi'cb  keyId data_ userData
    maybeReleaseFunPtr gi'funptrptr


-- callback CopyFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "A pointer to the copy"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "src"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "A pointer to the data which should be copied"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "Additional data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "A function of this signature is used to copy the node data\nwhen doing a deep-copy of a tree."
        , sinceVersion = Just "2.4"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CopyFunc =
    Ptr () ->
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "src"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A pointer to the data which should be copied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Additional data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CopyFunc :: FunPtr C_CopyFunc -> C_CopyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CopyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CopyFunc
    -> Ptr ()
    -- ^ /@src@/: A pointer to the data which should be copied
    -> Ptr ()
    -- ^ /@data@/: Additional data
    -> m (Ptr ())
    -- ^ __Returns:__ A pointer to the copy
dynamic_CopyFunc __funPtr src data_ = liftIO $ do
    result <- (__dynamic_C_CopyFunc __funPtr) src data_
    return result

-- | Generate a function pointer callable from C code, from a `C_CopyFunc`.
foreign import ccall "wrapper"
    mk_CopyFunc :: C_CopyFunc -> IO (FunPtr C_CopyFunc)

-- | A function of this signature is used to copy the node data
-- when doing a deep-copy of a tree.
-- 
-- /Since: 2.4/
type CopyFunc =
    Ptr ()
    -- ^ /@src@/: A pointer to the data which should be copied
    -> Ptr ()
    -- ^ /@data@/: Additional data
    -> IO (Ptr ())
    -- ^ __Returns:__ A pointer to the copy

-- | A convenience synonym for @`Nothing` :: `Maybe` `CopyFunc`@.
noCopyFunc :: Maybe CopyFunc
noCopyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CopyFunc :: MonadIO m => CopyFunc -> m (GClosure C_CopyFunc)
genClosure_CopyFunc cb = liftIO $ do
    let cb' = wrap_CopyFunc Nothing cb
    mk_CopyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CopyFunc` into a `C_CopyFunc`.
wrap_CopyFunc :: 
    Maybe (Ptr (FunPtr C_CopyFunc)) ->
    CopyFunc ->
    C_CopyFunc
wrap_CopyFunc gi'funptrptr gi'cb src data_ = do
    result <- gi'cb  src data_
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback CompletionStrncmpFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "an integer less than, equal to, or greater than zero if\n         the first @n bytes of @s1 is found, respectively, to be\n         less than, to match, or to be greater than the first @n\n         bytes of @s2."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "s1"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "string to compare with @s2."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "s2"
          , argType = TBasicType TUTF8
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "string to compare with @s1."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "n"
          , argType = TBasicType TSize
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "maximal number of bytes to compare."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.26"
          , deprecationMessage = Just "Rarely used API"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the function passed to\ng_completion_set_compare(). This is used when you use strings as\n#GCompletion items."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CompletionStrncmpFunc =
    CString ->
    CString ->
    FCT.CSize ->
    IO Int32

-- Args: [ Arg
--           { argCName = "s1"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s2."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "s2"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "string to compare with @s1."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximal number of bytes to compare."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CompletionStrncmpFunc :: FunPtr C_CompletionStrncmpFunc -> C_CompletionStrncmpFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CompletionStrncmpFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CompletionStrncmpFunc
    -> T.Text
    -- ^ /@s1@/: string to compare with /@s2@/.
    -> T.Text
    -- ^ /@s2@/: string to compare with /@s1@/.
    -> FCT.CSize
    -- ^ /@n@/: maximal number of bytes to compare.
    -> m Int32
    -- ^ __Returns:__ an integer less than, equal to, or greater than zero if
    --          the first /@n@/ bytes of /@s1@/ is found, respectively, to be
    --          less than, to match, or to be greater than the first /@n@/
    --          bytes of /@s2@/.
dynamic_CompletionStrncmpFunc __funPtr s1 s2 n = liftIO $ do
    s1' <- textToCString s1
    s2' <- textToCString s2
    result <- (__dynamic_C_CompletionStrncmpFunc __funPtr) s1' s2' n
    freeMem s1'
    freeMem s2'
    return result

-- | Generate a function pointer callable from C code, from a `C_CompletionStrncmpFunc`.
foreign import ccall "wrapper"
    mk_CompletionStrncmpFunc :: C_CompletionStrncmpFunc -> IO (FunPtr C_CompletionStrncmpFunc)

{-# DEPRECATED CompletionStrncmpFunc ["(Since version 2.26)","Rarely used API"] #-}
-- | Specifies the type of the function passed to
-- @/g_completion_set_compare()/@. This is used when you use strings as
-- t'GI.GLib.Structs.Completion.Completion' items.
type CompletionStrncmpFunc =
    T.Text
    -- ^ /@s1@/: string to compare with /@s2@/.
    -> T.Text
    -- ^ /@s2@/: string to compare with /@s1@/.
    -> FCT.CSize
    -- ^ /@n@/: maximal number of bytes to compare.
    -> IO Int32
    -- ^ __Returns:__ an integer less than, equal to, or greater than zero if
    --          the first /@n@/ bytes of /@s1@/ is found, respectively, to be
    --          less than, to match, or to be greater than the first /@n@/
    --          bytes of /@s2@/.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CompletionStrncmpFunc`@.
noCompletionStrncmpFunc :: Maybe CompletionStrncmpFunc
noCompletionStrncmpFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CompletionStrncmpFunc :: MonadIO m => CompletionStrncmpFunc -> m (GClosure C_CompletionStrncmpFunc)
genClosure_CompletionStrncmpFunc cb = liftIO $ do
    let cb' = wrap_CompletionStrncmpFunc Nothing cb
    mk_CompletionStrncmpFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CompletionStrncmpFunc` into a `C_CompletionStrncmpFunc`.
wrap_CompletionStrncmpFunc :: 
    Maybe (Ptr (FunPtr C_CompletionStrncmpFunc)) ->
    CompletionStrncmpFunc ->
    C_CompletionStrncmpFunc
wrap_CompletionStrncmpFunc gi'funptrptr gi'cb s1 s2 n = do
    s1' <- cstringToText s1
    s2' <- cstringToText s2
    result <- gi'cb  s1' s2' n
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback CompletionFunc
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = False
  , returnTransfer = TransferEverything
  , returnDocumentation =
      Documentation
        { rawDocText = Just "the string corresponding to the item."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "item"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the completion item."
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.26"
          , deprecationMessage = Just "Rarely used API"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the function passed to g_completion_new(). It\nshould return the string corresponding to the given target item.\nThis is used when you use data structures as #GCompletion items."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CompletionFunc =
    Ptr () ->
    IO CString

-- Args: [ Arg
--           { argCName = "item"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the completion item."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CompletionFunc :: FunPtr C_CompletionFunc -> C_CompletionFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CompletionFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CompletionFunc
    -> Ptr ()
    -- ^ /@item@/: the completion item.
    -> m T.Text
    -- ^ __Returns:__ the string corresponding to the item.
dynamic_CompletionFunc __funPtr item = liftIO $ do
    result <- (__dynamic_C_CompletionFunc __funPtr) item
    checkUnexpectedReturnNULL "completionFunc" result
    result' <- cstringToText result
    freeMem result
    return result'

-- | Generate a function pointer callable from C code, from a `C_CompletionFunc`.
foreign import ccall "wrapper"
    mk_CompletionFunc :: C_CompletionFunc -> IO (FunPtr C_CompletionFunc)

{-# DEPRECATED CompletionFunc ["(Since version 2.26)","Rarely used API"] #-}
-- | Specifies the type of the function passed to @/g_completion_new()/@. It
-- should return the string corresponding to the given target item.
-- This is used when you use data structures as t'GI.GLib.Structs.Completion.Completion' items.
type CompletionFunc =
    Ptr ()
    -- ^ /@item@/: the completion item.
    -> IO T.Text
    -- ^ __Returns:__ the string corresponding to the item.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CompletionFunc`@.
noCompletionFunc :: Maybe CompletionFunc
noCompletionFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CompletionFunc :: MonadIO m => CompletionFunc -> m (GClosure C_CompletionFunc)
genClosure_CompletionFunc cb = liftIO $ do
    let cb' = wrap_CompletionFunc Nothing cb
    mk_CompletionFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CompletionFunc` into a `C_CompletionFunc`.
wrap_CompletionFunc :: 
    Maybe (Ptr (FunPtr C_CompletionFunc)) ->
    CompletionFunc ->
    C_CompletionFunc
wrap_CompletionFunc gi'funptrptr gi'cb item = do
    result <- gi'cb  item
    maybeReleaseFunPtr gi'funptrptr
    result' <- textToCString result
    return result'


-- callback CompareFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "negative value if @a < @b; zero if @a = @b; positive\n         value if @a > @b"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "a"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value to compare with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of a comparison function used to compare two\nvalues.  The function should return a negative integer if the first\nvalue comes before the second, 0 if they are equal, or a positive\ninteger if the first value comes after the second."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CompareFunc =
    Ptr () ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "a"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value to compare with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CompareFunc :: FunPtr C_CompareFunc -> C_CompareFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CompareFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CompareFunc
    -> Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> m Int32
    -- ^ __Returns:__ negative value if /@a@/ \< /@b@/; zero if /@a@/ = /@b@/; positive
    --          value if /@a@/ > /@b@/
dynamic_CompareFunc __funPtr a b = liftIO $ do
    result <- (__dynamic_C_CompareFunc __funPtr) a b
    return result

-- | Generate a function pointer callable from C code, from a `C_CompareFunc`.
foreign import ccall "wrapper"
    mk_CompareFunc :: C_CompareFunc -> IO (FunPtr C_CompareFunc)

-- | Specifies the type of a comparison function used to compare two
-- values.  The function should return a negative integer if the first
-- value comes before the second, 0 if they are equal, or a positive
-- integer if the first value comes after the second.
type CompareFunc =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> IO Int32
    -- ^ __Returns:__ negative value if /@a@/ \< /@b@/; zero if /@a@/ = /@b@/; positive
    --          value if /@a@/ > /@b@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `CompareFunc`@.
noCompareFunc :: Maybe CompareFunc
noCompareFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CompareFunc :: MonadIO m => CompareFunc -> m (GClosure C_CompareFunc)
genClosure_CompareFunc cb = liftIO $ do
    let cb' = wrap_CompareFunc Nothing cb
    mk_CompareFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CompareFunc` into a `C_CompareFunc`.
wrap_CompareFunc :: 
    Maybe (Ptr (FunPtr C_CompareFunc)) ->
    CompareFunc ->
    C_CompareFunc
wrap_CompareFunc gi'funptrptr gi'cb a b = do
    result <- gi'cb  a b
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback CompareDataFunc
{- Callable
  { returnType = Just (TBasicType TInt)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "negative value if @a < @b; zero if @a = @b; positive\n         value if @a > @b"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "a"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "b"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a value to compare with"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "user data" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of a comparison function used to compare two\nvalues.  The function should return a negative integer if the first\nvalue comes before the second, 0 if they are equal, or a positive\ninteger if the first value comes after the second."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CompareDataFunc =
    Ptr () ->
    Ptr () ->
    Ptr () ->
    IO Int32

-- Args: [ Arg
--           { argCName = "a"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a value to compare with"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CompareDataFunc :: FunPtr C_CompareDataFunc -> C_CompareDataFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CompareDataFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CompareDataFunc
    -> Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> m Int32
    -- ^ __Returns:__ negative value if /@a@/ \< /@b@/; zero if /@a@/ = /@b@/; positive
    --          value if /@a@/ > /@b@/
dynamic_CompareDataFunc __funPtr a b userData = liftIO $ do
    result <- (__dynamic_C_CompareDataFunc __funPtr) a b userData
    return result

-- | Generate a function pointer callable from C code, from a `C_CompareDataFunc`.
foreign import ccall "wrapper"
    mk_CompareDataFunc :: C_CompareDataFunc -> IO (FunPtr C_CompareDataFunc)

-- | Specifies the type of a comparison function used to compare two
-- values.  The function should return a negative integer if the first
-- value comes before the second, 0 if they are equal, or a positive
-- integer if the first value comes after the second.
type CompareDataFunc =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> IO Int32
    -- ^ __Returns:__ negative value if /@a@/ \< /@b@/; zero if /@a@/ = /@b@/; positive
    --          value if /@a@/ > /@b@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `CompareDataFunc`@.
noCompareDataFunc :: Maybe CompareDataFunc
noCompareDataFunc = Nothing

-- | Specifies the type of a comparison function used to compare two
-- values.  The function should return a negative integer if the first
-- value comes before the second, 0 if they are equal, or a positive
-- integer if the first value comes after the second.
type CompareDataFunc_WithClosures =
    Ptr ()
    -- ^ /@a@/: a value
    -> Ptr ()
    -- ^ /@b@/: a value to compare with
    -> Ptr ()
    -- ^ /@userData@/: user data
    -> IO Int32
    -- ^ __Returns:__ negative value if /@a@/ \< /@b@/; zero if /@a@/ = /@b@/; positive
    --          value if /@a@/ > /@b@/

-- | A convenience synonym for @`Nothing` :: `Maybe` `CompareDataFunc_WithClosures`@.
noCompareDataFunc_WithClosures :: Maybe CompareDataFunc_WithClosures
noCompareDataFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_CompareDataFunc :: CompareDataFunc -> CompareDataFunc_WithClosures
drop_closures_CompareDataFunc _f a b _ = _f a b

-- | Wrap the callback into a `GClosure`.
genClosure_CompareDataFunc :: MonadIO m => CompareDataFunc -> m (GClosure C_CompareDataFunc)
genClosure_CompareDataFunc cb = liftIO $ do
    let cb' = drop_closures_CompareDataFunc cb
    let cb'' = wrap_CompareDataFunc Nothing cb'
    mk_CompareDataFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `CompareDataFunc` into a `C_CompareDataFunc`.
wrap_CompareDataFunc :: 
    Maybe (Ptr (FunPtr C_CompareDataFunc)) ->
    CompareDataFunc_WithClosures ->
    C_CompareDataFunc
wrap_CompareDataFunc gi'funptrptr gi'cb a b userData = do
    result <- gi'cb  a b userData
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback ClearHandleFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "handle_id"
          , argType = TBasicType TUInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the handle ID to clear"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of function passed to [func@GLib.clear_handle_id] The\nimplementation is expected to free the resource identified by @handle_id;\nfor instance, if @handle_id is a [struct@GLib.Source] ID,\n[func@GLib.Source.remove] can be used."
        , sinceVersion = Just "2.56"
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ClearHandleFunc =
    Word32 ->
    IO ()

-- Args: [ Arg
--           { argCName = "handle_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the handle ID to clear"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ClearHandleFunc :: FunPtr C_ClearHandleFunc -> C_ClearHandleFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ClearHandleFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ClearHandleFunc
    -> Word32
    -- ^ /@handleId@/: the handle ID to clear
    -> m ()
dynamic_ClearHandleFunc __funPtr handleId = liftIO $ do
    (__dynamic_C_ClearHandleFunc __funPtr) handleId
    return ()

-- | Generate a function pointer callable from C code, from a `C_ClearHandleFunc`.
foreign import ccall "wrapper"
    mk_ClearHandleFunc :: C_ClearHandleFunc -> IO (FunPtr C_ClearHandleFunc)

-- | Specifies the type of function passed to @/GLib.clear_handle_id/@ The
-- implementation is expected to free the resource identified by /@handleId@/;
-- for instance, if /@handleId@/ is a t'GI.GLib.Structs.Source.Source' ID,
-- 'GI.GLib.Structs.Source.sourceRemove' can be used.
-- 
-- /Since: 2.56/
type ClearHandleFunc =
    Word32
    -- ^ /@handleId@/: the handle ID to clear
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ClearHandleFunc`@.
noClearHandleFunc :: Maybe ClearHandleFunc
noClearHandleFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ClearHandleFunc :: MonadIO m => ClearHandleFunc -> m (GClosure C_ClearHandleFunc)
genClosure_ClearHandleFunc cb = liftIO $ do
    let cb' = wrap_ClearHandleFunc Nothing cb
    mk_ClearHandleFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `ClearHandleFunc` into a `C_ClearHandleFunc`.
wrap_ClearHandleFunc :: 
    Maybe (Ptr (FunPtr C_ClearHandleFunc)) ->
    ClearHandleFunc ->
    C_ClearHandleFunc
wrap_ClearHandleFunc gi'funptrptr gi'cb handleId = do
    gi'cb  handleId
    maybeReleaseFunPtr gi'funptrptr


-- callback ChildWatchFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "pid"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the process id of the child process"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "wait_status"
          , argType = TBasicType TInt
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "Status information about the child process, encoded\n              in a platform-specific manner"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      , Arg
          { argCName = "user_data"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just "user data passed to [func@GLib.child_watch_add]"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = True
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Prototype of a #GChildWatchSource callback, called when a child\nprocess has exited.\n\nTo interpret @wait_status, see the documentation for\n[func@GLib.spawn_check_wait_status]. In particular,\non Unix platforms, note that it is usually not equal\nto the integer passed to `exit()` or returned from `main()`."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ChildWatchFunc =
    Int32 ->
    Int32 ->
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "pid"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the process id of the child process"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wait_status"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Status information about the child process, encoded\n              in a platform-specific manner"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "user data passed to [func@GLib.child_watch_add]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = True
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ChildWatchFunc :: FunPtr C_ChildWatchFunc -> C_ChildWatchFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ChildWatchFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ChildWatchFunc
    -> Int32
    -- ^ /@pid@/: the process id of the child process
    -> Int32
    -- ^ /@waitStatus@/: Status information about the child process, encoded
    --               in a platform-specific manner
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.childWatchAdd'
    -> m ()
dynamic_ChildWatchFunc __funPtr pid waitStatus userData = liftIO $ do
    (__dynamic_C_ChildWatchFunc __funPtr) pid waitStatus userData
    return ()

-- | Generate a function pointer callable from C code, from a `C_ChildWatchFunc`.
foreign import ccall "wrapper"
    mk_ChildWatchFunc :: C_ChildWatchFunc -> IO (FunPtr C_ChildWatchFunc)

-- | Prototype of a @/GChildWatchSource/@ callback, called when a child
-- process has exited.
-- 
-- To interpret /@waitStatus@/, see the documentation for
-- 'GI.GLib.Functions.spawnCheckWaitStatus'. In particular,
-- on Unix platforms, note that it is usually not equal
-- to the integer passed to @exit()@ or returned from @main()@.
type ChildWatchFunc =
    Int32
    -- ^ /@pid@/: the process id of the child process
    -> Int32
    -- ^ /@waitStatus@/: Status information about the child process, encoded
    --               in a platform-specific manner
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ChildWatchFunc`@.
noChildWatchFunc :: Maybe ChildWatchFunc
noChildWatchFunc = Nothing

-- | Prototype of a @/GChildWatchSource/@ callback, called when a child
-- process has exited.
-- 
-- To interpret /@waitStatus@/, see the documentation for
-- 'GI.GLib.Functions.spawnCheckWaitStatus'. In particular,
-- on Unix platforms, note that it is usually not equal
-- to the integer passed to @exit()@ or returned from @main()@.
type ChildWatchFunc_WithClosures =
    Int32
    -- ^ /@pid@/: the process id of the child process
    -> Int32
    -- ^ /@waitStatus@/: Status information about the child process, encoded
    --               in a platform-specific manner
    -> Ptr ()
    -- ^ /@userData@/: user data passed to 'GI.GLib.Functions.childWatchAdd'
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ChildWatchFunc_WithClosures`@.
noChildWatchFunc_WithClosures :: Maybe ChildWatchFunc_WithClosures
noChildWatchFunc_WithClosures = Nothing

-- | A simple wrapper that ignores the closure arguments.
drop_closures_ChildWatchFunc :: ChildWatchFunc -> ChildWatchFunc_WithClosures
drop_closures_ChildWatchFunc _f pid waitStatus _ = _f pid waitStatus

-- | Wrap the callback into a `GClosure`.
genClosure_ChildWatchFunc :: MonadIO m => ChildWatchFunc -> m (GClosure C_ChildWatchFunc)
genClosure_ChildWatchFunc cb = liftIO $ do
    let cb' = drop_closures_ChildWatchFunc cb
    let cb'' = wrap_ChildWatchFunc Nothing cb'
    mk_ChildWatchFunc cb'' >>= B.GClosure.newGClosure


-- | Wrap a `ChildWatchFunc` into a `C_ChildWatchFunc`.
wrap_ChildWatchFunc :: 
    Maybe (Ptr (FunPtr C_ChildWatchFunc)) ->
    ChildWatchFunc_WithClosures ->
    C_ChildWatchFunc
wrap_ChildWatchFunc gi'funptrptr gi'cb pid waitStatus userData = do
    gi'cb  pid waitStatus userData
    maybeReleaseFunPtr gi'funptrptr


-- callback CacheNewFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a new #GCache value corresponding to the key."
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "key"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "a #GCache key" , sinceVersion = Nothing }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.32"
          , deprecationMessage = Just "Use a #GHashTable instead"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the @value_new_func function passed to\ng_cache_new(). It is passed a #GCache key and should create the\nvalue corresponding to the key."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CacheNewFunc =
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "key"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GCache key" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CacheNewFunc :: FunPtr C_CacheNewFunc -> C_CacheNewFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CacheNewFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CacheNewFunc
    -> Ptr ()
    -- ^ /@key@/: a t'GI.GLib.Structs.Cache.Cache' key
    -> m (Ptr ())
    -- ^ __Returns:__ a new t'GI.GLib.Structs.Cache.Cache' value corresponding to the key.
dynamic_CacheNewFunc __funPtr key = liftIO $ do
    result <- (__dynamic_C_CacheNewFunc __funPtr) key
    return result

-- | Generate a function pointer callable from C code, from a `C_CacheNewFunc`.
foreign import ccall "wrapper"
    mk_CacheNewFunc :: C_CacheNewFunc -> IO (FunPtr C_CacheNewFunc)

{-# DEPRECATED CacheNewFunc ["(Since version 2.32)","Use a t'GI.GLib.Structs.HashTable.HashTable' instead"] #-}
-- | Specifies the type of the /@valueNewFunc@/ function passed to
-- @/g_cache_new()/@. It is passed a t'GI.GLib.Structs.Cache.Cache' key and should create the
-- value corresponding to the key.
type CacheNewFunc =
    Ptr ()
    -- ^ /@key@/: a t'GI.GLib.Structs.Cache.Cache' key
    -> IO (Ptr ())
    -- ^ __Returns:__ a new t'GI.GLib.Structs.Cache.Cache' value corresponding to the key.

-- | A convenience synonym for @`Nothing` :: `Maybe` `CacheNewFunc`@.
noCacheNewFunc :: Maybe CacheNewFunc
noCacheNewFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CacheNewFunc :: MonadIO m => CacheNewFunc -> m (GClosure C_CacheNewFunc)
genClosure_CacheNewFunc cb = liftIO $ do
    let cb' = wrap_CacheNewFunc Nothing cb
    mk_CacheNewFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CacheNewFunc` into a `C_CacheNewFunc`.
wrap_CacheNewFunc :: 
    Maybe (Ptr (FunPtr C_CacheNewFunc)) ->
    CacheNewFunc ->
    C_CacheNewFunc
wrap_CacheNewFunc gi'funptrptr gi'cb key = do
    result <- gi'cb  key
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback CacheDupFunc
{- Callable
  { returnType = Just (TBasicType TPtr)
  , returnMayBeNull = True
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText = Just "a copy of the #GCache key"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the #GCache key to destroy (__not__ a\n        #GCache value as it seems)"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.32"
          , deprecationMessage = Just "Use a #GHashTable instead"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the @key_dup_func function passed to\ng_cache_new(). The function is passed a key\n(__not__ a value as the prototype implies) and\nshould return a duplicate of the key."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CacheDupFunc =
    Ptr () ->
    IO (Ptr ())

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GCache key to destroy (__not__ a\n        #GCache value as it seems)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CacheDupFunc :: FunPtr C_CacheDupFunc -> C_CacheDupFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CacheDupFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CacheDupFunc
    -> Ptr ()
    -- ^ /@value@/: the t'GI.GLib.Structs.Cache.Cache' key to destroy (__not__ a
    --         t'GI.GLib.Structs.Cache.Cache' value as it seems)
    -> m (Ptr ())
    -- ^ __Returns:__ a copy of the t'GI.GLib.Structs.Cache.Cache' key
dynamic_CacheDupFunc __funPtr value = liftIO $ do
    result <- (__dynamic_C_CacheDupFunc __funPtr) value
    return result

-- | Generate a function pointer callable from C code, from a `C_CacheDupFunc`.
foreign import ccall "wrapper"
    mk_CacheDupFunc :: C_CacheDupFunc -> IO (FunPtr C_CacheDupFunc)

{-# DEPRECATED CacheDupFunc ["(Since version 2.32)","Use a t'GI.GLib.Structs.HashTable.HashTable' instead"] #-}
-- | Specifies the type of the /@keyDupFunc@/ function passed to
-- @/g_cache_new()/@. The function is passed a key
-- (__not__ a value as the prototype implies) and
-- should return a duplicate of the key.
type CacheDupFunc =
    Ptr ()
    -- ^ /@value@/: the t'GI.GLib.Structs.Cache.Cache' key to destroy (__not__ a
    --         t'GI.GLib.Structs.Cache.Cache' value as it seems)
    -> IO (Ptr ())
    -- ^ __Returns:__ a copy of the t'GI.GLib.Structs.Cache.Cache' key

-- | A convenience synonym for @`Nothing` :: `Maybe` `CacheDupFunc`@.
noCacheDupFunc :: Maybe CacheDupFunc
noCacheDupFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CacheDupFunc :: MonadIO m => CacheDupFunc -> m (GClosure C_CacheDupFunc)
genClosure_CacheDupFunc cb = liftIO $ do
    let cb' = wrap_CacheDupFunc Nothing cb
    mk_CacheDupFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CacheDupFunc` into a `C_CacheDupFunc`.
wrap_CacheDupFunc :: 
    Maybe (Ptr (FunPtr C_CacheDupFunc)) ->
    CacheDupFunc ->
    C_CacheDupFunc
wrap_CacheDupFunc gi'funptrptr gi'cb value = do
    result <- gi'cb  value
    maybeReleaseFunPtr gi'funptrptr
    return result


-- callback CacheDestroyFunc
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "value"
          , argType = TBasicType TPtr
          , direction = DirectionIn
          , mayBeNull = True
          , argDoc =
              Documentation
                { rawDocText = Just "the #GCache value to destroy"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated =
      Just
        DeprecationInfo
          { deprecatedSinceVersion = Just "2.32"
          , deprecationMessage = Just "Use a #GHashTable instead"
          }
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the @value_destroy_func and @key_destroy_func\nfunctions passed to g_cache_new(). The functions are passed a\npointer to the #GCache key or #GCache value and should free any\nmemory and other resources associated with it."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_CacheDestroyFunc =
    Ptr () ->
    IO ()

-- Args: [ Arg
--           { argCName = "value"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCache value to destroy"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_CacheDestroyFunc :: FunPtr C_CacheDestroyFunc -> C_CacheDestroyFunc

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_CacheDestroyFunc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_CacheDestroyFunc
    -> Ptr ()
    -- ^ /@value@/: the t'GI.GLib.Structs.Cache.Cache' value to destroy
    -> m ()
dynamic_CacheDestroyFunc __funPtr value = liftIO $ do
    (__dynamic_C_CacheDestroyFunc __funPtr) value
    return ()

-- | Generate a function pointer callable from C code, from a `C_CacheDestroyFunc`.
foreign import ccall "wrapper"
    mk_CacheDestroyFunc :: C_CacheDestroyFunc -> IO (FunPtr C_CacheDestroyFunc)

{-# DEPRECATED CacheDestroyFunc ["(Since version 2.32)","Use a t'GI.GLib.Structs.HashTable.HashTable' instead"] #-}
-- | Specifies the type of the /@valueDestroyFunc@/ and /@keyDestroyFunc@/
-- functions passed to @/g_cache_new()/@. The functions are passed a
-- pointer to the t'GI.GLib.Structs.Cache.Cache' key or t'GI.GLib.Structs.Cache.Cache' value and should free any
-- memory and other resources associated with it.
type CacheDestroyFunc =
    Ptr ()
    -- ^ /@value@/: the t'GI.GLib.Structs.Cache.Cache' value to destroy
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `CacheDestroyFunc`@.
noCacheDestroyFunc :: Maybe CacheDestroyFunc
noCacheDestroyFunc = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_CacheDestroyFunc :: MonadIO m => CacheDestroyFunc -> m (GClosure C_CacheDestroyFunc)
genClosure_CacheDestroyFunc cb = liftIO $ do
    let cb' = wrap_CacheDestroyFunc Nothing cb
    mk_CacheDestroyFunc cb' >>= B.GClosure.newGClosure


-- | Wrap a `CacheDestroyFunc` into a `C_CacheDestroyFunc`.
wrap_CacheDestroyFunc :: 
    Maybe (Ptr (FunPtr C_CacheDestroyFunc)) ->
    CacheDestroyFunc ->
    C_CacheDestroyFunc
wrap_CacheDestroyFunc gi'funptrptr gi'cb value = do
    gi'cb  value
    maybeReleaseFunPtr gi'funptrptr



