{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An opaque data structure which represents an asynchronous queue.
-- 
-- It should only be accessed through the @g_async_queue_*@ functions.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.AsyncQueue
    ( 

-- * Exported types
    AsyncQueue(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [length]("GI.GLib.Structs.AsyncQueue#g:method:length"), [lengthUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:lengthUnlocked"), [lock]("GI.GLib.Structs.AsyncQueue#g:method:lock"), [pop]("GI.GLib.Structs.AsyncQueue#g:method:pop"), [popUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:popUnlocked"), [push]("GI.GLib.Structs.AsyncQueue#g:method:push"), [pushFront]("GI.GLib.Structs.AsyncQueue#g:method:pushFront"), [pushFrontUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:pushFrontUnlocked"), [pushSorted]("GI.GLib.Structs.AsyncQueue#g:method:pushSorted"), [pushSortedUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:pushSortedUnlocked"), [pushUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:pushUnlocked"), [ref]("GI.GLib.Structs.AsyncQueue#g:method:ref"), [refUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:refUnlocked"), [remove]("GI.GLib.Structs.AsyncQueue#g:method:remove"), [removeUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:removeUnlocked"), [sort]("GI.GLib.Structs.AsyncQueue#g:method:sort"), [sortUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:sortUnlocked"), [timedPop]("GI.GLib.Structs.AsyncQueue#g:method:timedPop"), [timedPopUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:timedPopUnlocked"), [timeoutPop]("GI.GLib.Structs.AsyncQueue#g:method:timeoutPop"), [timeoutPopUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:timeoutPopUnlocked"), [tryPop]("GI.GLib.Structs.AsyncQueue#g:method:tryPop"), [tryPopUnlocked]("GI.GLib.Structs.AsyncQueue#g:method:tryPopUnlocked"), [unlock]("GI.GLib.Structs.AsyncQueue#g:method:unlock").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveAsyncQueueMethod                 ,
#endif

-- ** length #method:length#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueLengthMethodInfo              ,
#endif
    asyncQueueLength                        ,


-- ** lengthUnlocked #method:lengthUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueLengthUnlockedMethodInfo      ,
#endif
    asyncQueueLengthUnlocked                ,


-- ** lock #method:lock#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueLockMethodInfo                ,
#endif
    asyncQueueLock                          ,


-- ** new #method:new#

    asyncQueueNew                           ,


-- ** newFull #method:newFull#

    asyncQueueNewFull                       ,


-- ** pop #method:pop#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePopMethodInfo                 ,
#endif
    asyncQueuePop                           ,


-- ** popUnlocked #method:popUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePopUnlockedMethodInfo         ,
#endif
    asyncQueuePopUnlocked                   ,


-- ** push #method:push#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushMethodInfo                ,
#endif
    asyncQueuePush                          ,


-- ** pushFront #method:pushFront#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushFrontMethodInfo           ,
#endif
    asyncQueuePushFront                     ,


-- ** pushFrontUnlocked #method:pushFrontUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushFrontUnlockedMethodInfo   ,
#endif
    asyncQueuePushFrontUnlocked             ,


-- ** pushSorted #method:pushSorted#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushSortedMethodInfo          ,
#endif
    asyncQueuePushSorted                    ,


-- ** pushSortedUnlocked #method:pushSortedUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushSortedUnlockedMethodInfo  ,
#endif
    asyncQueuePushSortedUnlocked            ,


-- ** pushUnlocked #method:pushUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueuePushUnlockedMethodInfo        ,
#endif
    asyncQueuePushUnlocked                  ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueRefMethodInfo                 ,
#endif
    asyncQueueRef                           ,


-- ** refUnlocked #method:refUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueRefUnlockedMethodInfo         ,
#endif
    asyncQueueRefUnlocked                   ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueRemoveMethodInfo              ,
#endif
    asyncQueueRemove                        ,


-- ** removeUnlocked #method:removeUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueRemoveUnlockedMethodInfo      ,
#endif
    asyncQueueRemoveUnlocked                ,


-- ** sort #method:sort#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueSortMethodInfo                ,
#endif
    asyncQueueSort                          ,


-- ** sortUnlocked #method:sortUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueSortUnlockedMethodInfo        ,
#endif
    asyncQueueSortUnlocked                  ,


-- ** timedPop #method:timedPop#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTimedPopMethodInfo            ,
#endif
    asyncQueueTimedPop                      ,


-- ** timedPopUnlocked #method:timedPopUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTimedPopUnlockedMethodInfo    ,
#endif
    asyncQueueTimedPopUnlocked              ,


-- ** timeoutPop #method:timeoutPop#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTimeoutPopMethodInfo          ,
#endif
    asyncQueueTimeoutPop                    ,


-- ** timeoutPopUnlocked #method:timeoutPopUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTimeoutPopUnlockedMethodInfo  ,
#endif
    asyncQueueTimeoutPopUnlocked            ,


-- ** tryPop #method:tryPop#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTryPopMethodInfo              ,
#endif
    asyncQueueTryPop                        ,


-- ** tryPopUnlocked #method:tryPopUnlocked#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueTryPopUnlockedMethodInfo      ,
#endif
    asyncQueueTryPopUnlocked                ,


-- ** unlock #method:unlock#

#if defined(ENABLE_OVERLOADING)
    AsyncQueueUnlockMethodInfo              ,
#endif
    asyncQueueUnlock                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal

#else
import qualified GI.GLib.Callbacks as GLib.Callbacks
import {-# SOURCE #-} qualified GI.GLib.Structs.TimeVal as GLib.TimeVal

#endif

-- | Memory-managed wrapper type.
newtype AsyncQueue = AsyncQueue (SP.ManagedPtr AsyncQueue)
    deriving (Eq)

instance SP.ManagedPtrNewtype AsyncQueue where
    toManagedPtr (AsyncQueue p) = p

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr AsyncQueue where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AsyncQueue
type instance O.AttributeList AsyncQueue = AsyncQueueAttributeList
type AsyncQueueAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method AsyncQueue::length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_length" g_async_queue_length :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO Int32

-- | Returns the length of the queue.
-- 
-- Actually this function returns the number of data items in
-- the queue minus the number of waiting threads, so a negative
-- value means waiting threads, and a positive value means available
-- entries in the /@queue@/. A return value of 0 could mean n entries
-- in the queue and n threads waiting. This can happen due to locking
-- of the queue or due to scheduling.
asyncQueueLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'.
    -> m Int32
    -- ^ __Returns:__ the length of the /@queue@/
asyncQueueLength queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_length queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueLengthMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod AsyncQueueLengthMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueLength

instance O.OverloadedMethodInfo AsyncQueueLengthMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueLength"
        })


#endif

-- method AsyncQueue::length_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_length_unlocked" g_async_queue_length_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO Int32

-- | Returns the length of the queue.
-- 
-- Actually this function returns the number of data items in
-- the queue minus the number of waiting threads, so a negative
-- value means waiting threads, and a positive value means available
-- entries in the /@queue@/. A return value of 0 could mean n entries
-- in the queue and n threads waiting. This can happen due to locking
-- of the queue or due to scheduling.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueueLengthUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m Int32
    -- ^ __Returns:__ the length of the /@queue@/.
asyncQueueLengthUnlocked queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_length_unlocked queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueLengthUnlockedMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod AsyncQueueLengthUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueLengthUnlocked

instance O.OverloadedMethodInfo AsyncQueueLengthUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueLengthUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueLengthUnlocked"
        })


#endif

-- method AsyncQueue::lock
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_lock" g_async_queue_lock :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO ()

-- | Acquires the /@queue@/\'s lock. If another thread is already
-- holding the lock, this call will block until the lock
-- becomes available.
-- 
-- Call 'GI.GLib.Structs.AsyncQueue.asyncQueueUnlock' to drop the lock again.
-- 
-- While holding the lock, you can only call the
-- g_async_queue_*@/_unlocked()/@ functions on /@queue@/. Otherwise,
-- deadlock may occur.
asyncQueueLock ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m ()
asyncQueueLock queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_lock queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueueLockMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AsyncQueueLockMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueLock

instance O.OverloadedMethodInfo AsyncQueueLockMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueLock",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueLock"
        })


#endif

-- method AsyncQueue::pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_pop" g_async_queue_pop :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO (Ptr ())

-- | Pops data from the /@queue@/. If /@queue@/ is empty, this function
-- blocks until data becomes available.
asyncQueuePop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue
asyncQueuePop queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_pop queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePopMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueuePopMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePop

instance O.OverloadedMethodInfo AsyncQueuePopMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePop"
        })


#endif

-- method AsyncQueue::pop_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_pop_unlocked" g_async_queue_pop_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO (Ptr ())

-- | Pops data from the /@queue@/. If /@queue@/ is empty, this function
-- blocks until data becomes available.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueuePopUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue.
asyncQueuePopUnlocked queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_pop_unlocked queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePopUnlockedMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueuePopUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePopUnlocked

instance O.OverloadedMethodInfo AsyncQueuePopUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePopUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePopUnlocked"
        })


#endif

-- method AsyncQueue::push
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to push onto the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push" g_async_queue_push :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Pushes the /@data@/ into the /@queue@/.
-- 
-- The /@data@/ parameter must not be 'P.Nothing'.
asyncQueuePush ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@data@/: data to push onto the /@queue@/
    -> m ()
asyncQueuePush queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_push queue' data_
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePush

instance O.OverloadedMethodInfo AsyncQueuePushMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePush"
        })


#endif

-- method AsyncQueue::push_front
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to push into the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push_front" g_async_queue_push_front :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- item : TBasicType TPtr
    IO ()

-- | Pushes the /@item@/ into the /@queue@/. /@item@/ must not be 'P.Nothing'.
-- In contrast to 'GI.GLib.Structs.AsyncQueue.asyncQueuePush', this function
-- pushes the new item ahead of the items already in the queue,
-- so that it will be the next one to be popped off the queue.
-- 
-- /Since: 2.46/
asyncQueuePushFront ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@item@/: data to push into the /@queue@/
    -> m ()
asyncQueuePushFront queue item = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_push_front queue' item
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushFrontMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushFrontMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePushFront

instance O.OverloadedMethodInfo AsyncQueuePushFrontMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePushFront",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePushFront"
        })


#endif

-- method AsyncQueue::push_front_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to push into the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push_front_unlocked" g_async_queue_push_front_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- item : TBasicType TPtr
    IO ()

-- | Pushes the /@item@/ into the /@queue@/. /@item@/ must not be 'P.Nothing'.
-- In contrast to 'GI.GLib.Structs.AsyncQueue.asyncQueuePushUnlocked', this function
-- pushes the new item ahead of the items already in the queue,
-- so that it will be the next one to be popped off the queue.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
-- 
-- /Since: 2.46/
asyncQueuePushFrontUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@item@/: data to push into the /@queue@/
    -> m ()
asyncQueuePushFrontUnlocked queue item = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_push_front_unlocked queue' item
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushFrontUnlockedMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushFrontUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePushFrontUnlocked

instance O.OverloadedMethodInfo AsyncQueuePushFrontUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePushFrontUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePushFrontUnlocked"
        })


#endif

-- method AsyncQueue::push_sorted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the @data to push into the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompareDataFunc is used to sort @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push_sorted" g_async_queue_push_sorted :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Inserts /@data@/ into /@queue@/ using /@func@/ to determine the new
-- position.
-- 
-- This function requires that the /@queue@/ is sorted before pushing on
-- new elements, see 'GI.GLib.Structs.AsyncQueue.asyncQueueSort'.
-- 
-- This function will lock /@queue@/ before it sorts the queue and unlock
-- it when it is finished.
-- 
-- For an example of /@func@/ see 'GI.GLib.Structs.AsyncQueue.asyncQueueSort'.
-- 
-- /Since: 2.10/
asyncQueuePushSorted ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@data@/: the /@data@/ to push into the /@queue@/
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@func@/: the t'GI.GLib.Callbacks.CompareDataFunc' is used to sort /@queue@/
    -> m ()
asyncQueuePushSorted queue data_ func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc func))
    let userData = nullPtr
    g_async_queue_push_sorted queue' data_ func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushSortedMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushSortedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePushSorted

instance O.OverloadedMethodInfo AsyncQueuePushSortedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePushSorted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePushSorted"
        })


#endif

-- method AsyncQueue::push_sorted_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to push into the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompareDataFunc is used to sort @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 3
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push_sorted_unlocked" g_async_queue_push_sorted_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- data : TBasicType TPtr
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Inserts /@data@/ into /@queue@/ using /@func@/ to determine the new
-- position.
-- 
-- The sort function /@func@/ is passed two elements of the /@queue@/.
-- It should return 0 if they are equal, a negative value if the
-- first element should be higher in the /@queue@/ or a positive value
-- if the first element should be lower in the /@queue@/ than the second
-- element.
-- 
-- This function requires that the /@queue@/ is sorted before pushing on
-- new elements, see 'GI.GLib.Structs.AsyncQueue.asyncQueueSort'.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
-- 
-- For an example of /@func@/ see 'GI.GLib.Structs.AsyncQueue.asyncQueueSort'.
-- 
-- /Since: 2.10/
asyncQueuePushSortedUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@data@/: the data to push into the /@queue@/
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@func@/: the t'GI.GLib.Callbacks.CompareDataFunc' is used to sort /@queue@/
    -> m ()
asyncQueuePushSortedUnlocked queue data_ func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc func))
    let userData = nullPtr
    g_async_queue_push_sorted_unlocked queue' data_ func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushSortedUnlockedMethodInfo
instance (signature ~ (Ptr () -> GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushSortedUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePushSortedUnlocked

instance O.OverloadedMethodInfo AsyncQueuePushSortedUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePushSortedUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePushSortedUnlocked"
        })


#endif

-- method AsyncQueue::push_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to push onto the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_push_unlocked" g_async_queue_push_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- data : TBasicType TPtr
    IO ()

-- | Pushes the /@data@/ into the /@queue@/.
-- 
-- The /@data@/ parameter must not be 'P.Nothing'.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueuePushUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@data@/: data to push onto the /@queue@/
    -> m ()
asyncQueuePushUnlocked queue data_ = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_push_unlocked queue' data_
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueuePushUnlockedMethodInfo
instance (signature ~ (Ptr () -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueuePushUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueuePushUnlocked

instance O.OverloadedMethodInfo AsyncQueuePushUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueuePushUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueuePushUnlocked"
        })


#endif

-- method AsyncQueue::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "AsyncQueue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_ref" g_async_queue_ref :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO (Ptr AsyncQueue)

-- | Increases the reference count of the asynchronous /@queue@/ by 1.
-- You do not need to hold the lock to call this function.
asyncQueueRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m AsyncQueue
    -- ^ __Returns:__ the /@queue@/ that was passed in (since 2.6)
asyncQueueRef queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_ref queue'
    checkUnexpectedReturnNULL "asyncQueueRef" result
    result' <- (wrapPtr AsyncQueue) result
    touchManagedPtr queue
    return result'

#if defined(ENABLE_OVERLOADING)
data AsyncQueueRefMethodInfo
instance (signature ~ (m AsyncQueue), MonadIO m) => O.OverloadedMethod AsyncQueueRefMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueRef

instance O.OverloadedMethodInfo AsyncQueueRefMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueRef"
        })


#endif

-- method AsyncQueue::ref_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_ref_unlocked" g_async_queue_ref_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO ()

{-# DEPRECATED asyncQueueRefUnlocked ["(Since version 2.8)","Reference counting is done atomically.","so 'GI.GLib.Structs.AsyncQueue.asyncQueueRef' can be used regardless of the /@queue@/\\'s","lock."] #-}
-- | Increases the reference count of the asynchronous /@queue@/ by 1.
asyncQueueRefUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m ()
asyncQueueRefUnlocked queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_ref_unlocked queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueueRefUnlockedMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AsyncQueueRefUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueRefUnlocked

instance O.OverloadedMethodInfo AsyncQueueRefUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueRefUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueRefUnlocked"
        })


#endif

-- method AsyncQueue::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to remove from the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_remove" g_async_queue_remove :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- item : TBasicType TPtr
    IO CInt

-- | Remove an item from the queue.
-- 
-- /Since: 2.46/
asyncQueueRemove ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@item@/: the data to remove from the /@queue@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the item was removed
asyncQueueRemove queue item = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_remove queue' item
    let result' = (/= 0) result
    touchManagedPtr queue
    return result'

#if defined(ENABLE_OVERLOADING)
data AsyncQueueRemoveMethodInfo
instance (signature ~ (Ptr () -> m Bool), MonadIO m) => O.OverloadedMethod AsyncQueueRemoveMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueRemove

instance O.OverloadedMethodInfo AsyncQueueRemoveMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueRemove"
        })


#endif

-- method AsyncQueue::remove_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to remove from the @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_remove_unlocked" g_async_queue_remove_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr () ->                               -- item : TBasicType TPtr
    IO CInt

-- | Remove an item from the queue.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
-- 
-- /Since: 2.46/
asyncQueueRemoveUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Ptr ()
    -- ^ /@item@/: the data to remove from the /@queue@/
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the item was removed
asyncQueueRemoveUnlocked queue item = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_remove_unlocked queue' item
    let result' = (/= 0) result
    touchManagedPtr queue
    return result'

#if defined(ENABLE_OVERLOADING)
data AsyncQueueRemoveUnlockedMethodInfo
instance (signature ~ (Ptr () -> m Bool), MonadIO m) => O.OverloadedMethod AsyncQueueRemoveUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueRemoveUnlocked

instance O.OverloadedMethodInfo AsyncQueueRemoveUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueRemoveUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueRemoveUnlocked"
        })


#endif

-- method AsyncQueue::sort
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompareDataFunc is used to sort @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_sort" g_async_queue_sort :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Sorts /@queue@/ using /@func@/.
-- 
-- The sort function /@func@/ is passed two elements of the /@queue@/.
-- It should return 0 if they are equal, a negative value if the
-- first element should be higher in the /@queue@/ or a positive value
-- if the first element should be lower in the /@queue@/ than the second
-- element.
-- 
-- This function will lock /@queue@/ before it sorts the queue and unlock
-- it when it is finished.
-- 
-- If you were sorting a list of priority numbers to make sure the
-- lowest priority would be at the top of the queue, you could use:
-- 
-- === /C code/
-- >
-- > gint32 id1;
-- > gint32 id2;
-- >
-- > id1 = GPOINTER_TO_INT (element1);
-- > id2 = GPOINTER_TO_INT (element2);
-- >
-- > return (id1 > id2 ? +1 : id1 == id2 ? 0 : -1);
-- 
-- 
-- /Since: 2.10/
asyncQueueSort ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@func@/: the t'GI.GLib.Callbacks.CompareDataFunc' is used to sort /@queue@/
    -> m ()
asyncQueueSort queue func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc func))
    let userData = nullPtr
    g_async_queue_sort queue' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueueSortMethodInfo
instance (signature ~ (GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueueSortMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueSort

instance O.OverloadedMethodInfo AsyncQueueSortMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueSort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueSort"
        })


#endif

-- method AsyncQueue::sort_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "CompareDataFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GCompareDataFunc is used to sort @queue"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeCall
--           , argClosure = 2
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "user data passed to @func"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_sort_unlocked" g_async_queue_sort_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    FunPtr GLib.Callbacks.C_CompareDataFunc -> -- func : TInterface (Name {namespace = "GLib", name = "CompareDataFunc"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Sorts /@queue@/ using /@func@/.
-- 
-- The sort function /@func@/ is passed two elements of the /@queue@/.
-- It should return 0 if they are equal, a negative value if the
-- first element should be higher in the /@queue@/ or a positive value
-- if the first element should be lower in the /@queue@/ than the second
-- element.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
-- 
-- /Since: 2.10/
asyncQueueSortUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> GLib.Callbacks.CompareDataFunc
    -- ^ /@func@/: the t'GI.GLib.Callbacks.CompareDataFunc' is used to sort /@queue@/
    -> m ()
asyncQueueSortUnlocked queue func = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    func' <- GLib.Callbacks.mk_CompareDataFunc (GLib.Callbacks.wrap_CompareDataFunc Nothing (GLib.Callbacks.drop_closures_CompareDataFunc func))
    let userData = nullPtr
    g_async_queue_sort_unlocked queue' func' userData
    safeFreeFunPtr $ castFunPtrToPtr func'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueueSortUnlockedMethodInfo
instance (signature ~ (GLib.Callbacks.CompareDataFunc -> m ()), MonadIO m) => O.OverloadedMethod AsyncQueueSortUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueSortUnlocked

instance O.OverloadedMethodInfo AsyncQueueSortUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueSortUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueSortUnlocked"
        })


#endif

-- method AsyncQueue::timed_pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_time"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TimeVal" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTimeVal, determining the final time"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_timed_pop" g_async_queue_timed_pop :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr GLib.TimeVal.TimeVal ->             -- end_time : TInterface (Name {namespace = "GLib", name = "TimeVal"})
    IO (Ptr ())

{-# DEPRECATED asyncQueueTimedPop ["use 'GI.GLib.Structs.AsyncQueue.asyncQueueTimeoutPop'."] #-}
-- | Pops data from the /@queue@/. If the queue is empty, blocks until
-- /@endTime@/ or until data becomes available.
-- 
-- If no data is received before /@endTime@/, 'P.Nothing' is returned.
-- 
-- To easily calculate /@endTime@/, a combination of 'GI.GLib.Functions.getRealTime'
-- and 'GI.GLib.Structs.TimeVal.timeValAdd' can be used.
asyncQueueTimedPop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> GLib.TimeVal.TimeVal
    -- ^ /@endTime@/: a t'GI.GLib.Structs.TimeVal.TimeVal', determining the final time
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is received before /@endTime@/.
asyncQueueTimedPop queue endTime = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    endTime' <- unsafeManagedPtrGetPtr endTime
    result <- g_async_queue_timed_pop queue' endTime'
    touchManagedPtr queue
    touchManagedPtr endTime
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTimedPopMethodInfo
instance (signature ~ (GLib.TimeVal.TimeVal -> m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTimedPopMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTimedPop

instance O.OverloadedMethodInfo AsyncQueueTimedPopMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTimedPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTimedPop"
        })


#endif

-- method AsyncQueue::timed_pop_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end_time"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "TimeVal" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GTimeVal, determining the final time"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_timed_pop_unlocked" g_async_queue_timed_pop_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Ptr GLib.TimeVal.TimeVal ->             -- end_time : TInterface (Name {namespace = "GLib", name = "TimeVal"})
    IO (Ptr ())

{-# DEPRECATED asyncQueueTimedPopUnlocked ["use 'GI.GLib.Structs.AsyncQueue.asyncQueueTimeoutPopUnlocked'."] #-}
-- | Pops data from the /@queue@/. If the queue is empty, blocks until
-- /@endTime@/ or until data becomes available.
-- 
-- If no data is received before /@endTime@/, 'P.Nothing' is returned.
-- 
-- To easily calculate /@endTime@/, a combination of 'GI.GLib.Functions.getRealTime'
-- and 'GI.GLib.Structs.TimeVal.timeValAdd' can be used.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueueTimedPopUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> GLib.TimeVal.TimeVal
    -- ^ /@endTime@/: a t'GI.GLib.Structs.TimeVal.TimeVal', determining the final time
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is received before /@endTime@/.
asyncQueueTimedPopUnlocked queue endTime = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    endTime' <- unsafeManagedPtrGetPtr endTime
    result <- g_async_queue_timed_pop_unlocked queue' endTime'
    touchManagedPtr queue
    touchManagedPtr endTime
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTimedPopUnlockedMethodInfo
instance (signature ~ (GLib.TimeVal.TimeVal -> m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTimedPopUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTimedPopUnlocked

instance O.OverloadedMethodInfo AsyncQueueTimedPopUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTimedPopUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTimedPopUnlocked"
        })


#endif

-- method AsyncQueue::timeout_pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of microseconds to wait"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_timeout_pop" g_async_queue_timeout_pop :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Word64 ->                               -- timeout : TBasicType TUInt64
    IO (Ptr ())

-- | Pops data from the /@queue@/. If the queue is empty, blocks for
-- /@timeout@/ microseconds, or until data becomes available.
-- 
-- If no data is received before the timeout, 'P.Nothing' is returned.
asyncQueueTimeoutPop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Word64
    -- ^ /@timeout@/: the number of microseconds to wait
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is received before the timeout.
asyncQueueTimeoutPop queue timeout = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_timeout_pop queue' timeout
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTimeoutPopMethodInfo
instance (signature ~ (Word64 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTimeoutPopMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTimeoutPop

instance O.OverloadedMethodInfo AsyncQueueTimeoutPopMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTimeoutPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTimeoutPop"
        })


#endif

-- method AsyncQueue::timeout_pop_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "timeout"
--           , argType = TBasicType TUInt64
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of microseconds to wait"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_timeout_pop_unlocked" g_async_queue_timeout_pop_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    Word64 ->                               -- timeout : TBasicType TUInt64
    IO (Ptr ())

-- | Pops data from the /@queue@/. If the queue is empty, blocks for
-- /@timeout@/ microseconds, or until data becomes available.
-- 
-- If no data is received before the timeout, 'P.Nothing' is returned.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueueTimeoutPopUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> Word64
    -- ^ /@timeout@/: the number of microseconds to wait
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is received before the timeout.
asyncQueueTimeoutPopUnlocked queue timeout = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_timeout_pop_unlocked queue' timeout
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTimeoutPopUnlockedMethodInfo
instance (signature ~ (Word64 -> m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTimeoutPopUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTimeoutPopUnlocked

instance O.OverloadedMethodInfo AsyncQueueTimeoutPopUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTimeoutPopUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTimeoutPopUnlocked"
        })


#endif

-- method AsyncQueue::try_pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_try_pop" g_async_queue_try_pop :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO (Ptr ())

-- | Tries to pop data from the /@queue@/. If no data is available,
-- 'P.Nothing' is returned.
asyncQueueTryPop ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is available immediately.
asyncQueueTryPop queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_try_pop queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTryPopMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTryPopMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTryPop

instance O.OverloadedMethodInfo AsyncQueueTryPopMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTryPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTryPop"
        })


#endif

-- method AsyncQueue::try_pop_unlocked
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TPtr)
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_try_pop_unlocked" g_async_queue_try_pop_unlocked :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO (Ptr ())

-- | Tries to pop data from the /@queue@/. If no data is available,
-- 'P.Nothing' is returned.
-- 
-- This function must be called while holding the /@queue@/\'s lock.
asyncQueueTryPopUnlocked ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m (Ptr ())
    -- ^ __Returns:__ data from the queue or 'P.Nothing', when no
    --   data is available immediately.
asyncQueueTryPopUnlocked queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    result <- g_async_queue_try_pop_unlocked queue'
    touchManagedPtr queue
    return result

#if defined(ENABLE_OVERLOADING)
data AsyncQueueTryPopUnlockedMethodInfo
instance (signature ~ (m (Ptr ())), MonadIO m) => O.OverloadedMethod AsyncQueueTryPopUnlockedMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueTryPopUnlocked

instance O.OverloadedMethodInfo AsyncQueueTryPopUnlockedMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueTryPopUnlocked",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueTryPopUnlocked"
        })


#endif

-- method AsyncQueue::unlock
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "queue"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "AsyncQueue" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GAsyncQueue" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_unlock" g_async_queue_unlock :: 
    Ptr AsyncQueue ->                       -- queue : TInterface (Name {namespace = "GLib", name = "AsyncQueue"})
    IO ()

-- | Releases the queue\'s lock.
-- 
-- Calling this function when you have not acquired
-- the with 'GI.GLib.Structs.AsyncQueue.asyncQueueLock' leads to undefined
-- behaviour.
asyncQueueUnlock ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    AsyncQueue
    -- ^ /@queue@/: a t'GI.GLib.Structs.AsyncQueue.AsyncQueue'
    -> m ()
asyncQueueUnlock queue = liftIO $ do
    queue' <- unsafeManagedPtrGetPtr queue
    g_async_queue_unlock queue'
    touchManagedPtr queue
    return ()

#if defined(ENABLE_OVERLOADING)
data AsyncQueueUnlockMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod AsyncQueueUnlockMethodInfo AsyncQueue signature where
    overloadedMethod = asyncQueueUnlock

instance O.OverloadedMethodInfo AsyncQueueUnlockMethodInfo AsyncQueue where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.AsyncQueue.asyncQueueUnlock",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-AsyncQueue.html#v:asyncQueueUnlock"
        })


#endif

-- XXX Could not generate method AsyncQueue::unref
-- Bad introspection data: Transferring a non-boxed struct with unknown size!
-- XXX Could not generate method AsyncQueue::unref_and_unlock
-- Bad introspection data: Transferring a non-boxed struct with unknown size!
-- method AsyncQueue::new
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "AsyncQueue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_new" g_async_queue_new :: 
    IO (Ptr AsyncQueue)

-- | Creates a new asynchronous queue.
asyncQueueNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m AsyncQueue
    -- ^ __Returns:__ a new t'GI.GLib.Structs.AsyncQueue.AsyncQueue'. Free with 'GI.GLib.Structs.AsyncQueue.asyncQueueUnref'
asyncQueueNew  = liftIO $ do
    result <- g_async_queue_new
    checkUnexpectedReturnNULL "asyncQueueNew" result
    result' <- (wrapPtr AsyncQueue) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AsyncQueue::new_full
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "item_free_func"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "DestroyNotify" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "function to free queue elements"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "AsyncQueue" })
-- throws : False
-- Skip return : False

foreign import ccall "g_async_queue_new_full" g_async_queue_new_full :: 
    FunPtr GLib.Callbacks.C_DestroyNotify -> -- item_free_func : TInterface (Name {namespace = "GLib", name = "DestroyNotify"})
    IO (Ptr AsyncQueue)

-- | Creates a new asynchronous queue and sets up a destroy notify
-- function that is used to free any remaining queue items when
-- the queue is destroyed after the final unref.
-- 
-- /Since: 2.16/
asyncQueueNewFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (GLib.Callbacks.DestroyNotify)
    -- ^ /@itemFreeFunc@/: function to free queue elements
    -> m AsyncQueue
    -- ^ __Returns:__ a new t'GI.GLib.Structs.AsyncQueue.AsyncQueue'. Free with 'GI.GLib.Structs.AsyncQueue.asyncQueueUnref'
asyncQueueNewFull itemFreeFunc = liftIO $ do
    maybeItemFreeFunc <- case itemFreeFunc of
        Nothing -> return FP.nullFunPtr
        Just jItemFreeFunc -> do
            ptritemFreeFunc <- callocMem :: IO (Ptr (FunPtr GLib.Callbacks.C_DestroyNotify))
            jItemFreeFunc' <- GLib.Callbacks.mk_DestroyNotify (GLib.Callbacks.wrap_DestroyNotify (Just ptritemFreeFunc) jItemFreeFunc)
            poke ptritemFreeFunc jItemFreeFunc'
            return jItemFreeFunc'
    result <- g_async_queue_new_full maybeItemFreeFunc
    checkUnexpectedReturnNULL "asyncQueueNewFull" result
    result' <- (wrapPtr AsyncQueue) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAsyncQueueMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAsyncQueueMethod "length" o = AsyncQueueLengthMethodInfo
    ResolveAsyncQueueMethod "lengthUnlocked" o = AsyncQueueLengthUnlockedMethodInfo
    ResolveAsyncQueueMethod "lock" o = AsyncQueueLockMethodInfo
    ResolveAsyncQueueMethod "pop" o = AsyncQueuePopMethodInfo
    ResolveAsyncQueueMethod "popUnlocked" o = AsyncQueuePopUnlockedMethodInfo
    ResolveAsyncQueueMethod "push" o = AsyncQueuePushMethodInfo
    ResolveAsyncQueueMethod "pushFront" o = AsyncQueuePushFrontMethodInfo
    ResolveAsyncQueueMethod "pushFrontUnlocked" o = AsyncQueuePushFrontUnlockedMethodInfo
    ResolveAsyncQueueMethod "pushSorted" o = AsyncQueuePushSortedMethodInfo
    ResolveAsyncQueueMethod "pushSortedUnlocked" o = AsyncQueuePushSortedUnlockedMethodInfo
    ResolveAsyncQueueMethod "pushUnlocked" o = AsyncQueuePushUnlockedMethodInfo
    ResolveAsyncQueueMethod "ref" o = AsyncQueueRefMethodInfo
    ResolveAsyncQueueMethod "refUnlocked" o = AsyncQueueRefUnlockedMethodInfo
    ResolveAsyncQueueMethod "remove" o = AsyncQueueRemoveMethodInfo
    ResolveAsyncQueueMethod "removeUnlocked" o = AsyncQueueRemoveUnlockedMethodInfo
    ResolveAsyncQueueMethod "sort" o = AsyncQueueSortMethodInfo
    ResolveAsyncQueueMethod "sortUnlocked" o = AsyncQueueSortUnlockedMethodInfo
    ResolveAsyncQueueMethod "timedPop" o = AsyncQueueTimedPopMethodInfo
    ResolveAsyncQueueMethod "timedPopUnlocked" o = AsyncQueueTimedPopUnlockedMethodInfo
    ResolveAsyncQueueMethod "timeoutPop" o = AsyncQueueTimeoutPopMethodInfo
    ResolveAsyncQueueMethod "timeoutPopUnlocked" o = AsyncQueueTimeoutPopUnlockedMethodInfo
    ResolveAsyncQueueMethod "tryPop" o = AsyncQueueTryPopMethodInfo
    ResolveAsyncQueueMethod "tryPopUnlocked" o = AsyncQueueTryPopUnlockedMethodInfo
    ResolveAsyncQueueMethod "unlock" o = AsyncQueueUnlockMethodInfo
    ResolveAsyncQueueMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAsyncQueueMethod t AsyncQueue, O.OverloadedMethod info AsyncQueue p) => OL.IsLabel t (AsyncQueue -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAsyncQueueMethod t AsyncQueue, O.OverloadedMethod info AsyncQueue p, R.HasField t AsyncQueue p) => R.HasField t AsyncQueue p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAsyncQueueMethod t AsyncQueue, O.OverloadedMethodInfo info AsyncQueue) => OL.IsLabel t (O.MethodProxy info AsyncQueue) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


