

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GModule.Callbacks
    ( 

 -- * Signals


-- ** ModuleCheckInit #signal:ModuleCheckInit#

    C_ModuleCheckInit                       ,
    ModuleCheckInit                         ,
    dynamic_ModuleCheckInit                 ,
    genClosure_ModuleCheckInit              ,
    mk_ModuleCheckInit                      ,
    noModuleCheckInit                       ,
    wrap_ModuleCheckInit                    ,


-- ** ModuleUnload #signal:ModuleUnload#

    C_ModuleUnload                          ,
    ModuleUnload                            ,
    dynamic_ModuleUnload                    ,
    genClosure_ModuleUnload                 ,
    mk_ModuleUnload                         ,
    noModuleUnload                          ,
    wrap_ModuleUnload                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.GModule.Structs.Module as GModule.Module

#else
import {-# SOURCE #-} qualified GI.GModule.Structs.Module as GModule.Module

#endif

-- callback ModuleUnload
{- Callable
  { returnType = Nothing
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation { rawDocText = Nothing , sinceVersion = Nothing }
  , args =
      [ Arg
          { argCName = "module"
          , argType =
              TInterface Name { namespace = "GModule" , name = "Module" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText = Just "the #GModule about to be unloaded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the module function called when it is unloaded.\nIf a module contains a function named g_module_unload() it is called\nautomatically when the module is unloaded.\nIt is passed the #GModule structure."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ModuleUnload =
    Ptr GModule.Module.Module ->
    IO ()

-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GModule" , name = "Module" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #GModule about to be unloaded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ModuleUnload :: FunPtr C_ModuleUnload -> C_ModuleUnload

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ModuleUnload ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ModuleUnload
    -> GModule.Module.Module
    -- ^ /@module@/: the t'GI.GModule.Structs.Module.Module' about to be unloaded
    -> m ()
dynamic_ModuleUnload __funPtr module_ = liftIO $ do
    module_' <- unsafeManagedPtrGetPtr module_
    (__dynamic_C_ModuleUnload __funPtr) module_'
    touchManagedPtr module_
    return ()

-- | Generate a function pointer callable from C code, from a `C_ModuleUnload`.
foreign import ccall "wrapper"
    mk_ModuleUnload :: C_ModuleUnload -> IO (FunPtr C_ModuleUnload)

-- | Specifies the type of the module function called when it is unloaded.
-- If a module contains a function named @/g_module_unload()/@ it is called
-- automatically when the module is unloaded.
-- It is passed the t'GI.GModule.Structs.Module.Module' structure.
type ModuleUnload =
    GModule.Module.Module
    -- ^ /@module@/: the t'GI.GModule.Structs.Module.Module' about to be unloaded
    -> IO ()

-- | A convenience synonym for @`Nothing` :: `Maybe` `ModuleUnload`@.
noModuleUnload :: Maybe ModuleUnload
noModuleUnload = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ModuleUnload :: MonadIO m => ModuleUnload -> m (GClosure C_ModuleUnload)
genClosure_ModuleUnload cb = liftIO $ do
    let cb' = wrap_ModuleUnload Nothing cb
    mk_ModuleUnload cb' >>= B.GClosure.newGClosure


-- | Wrap a `ModuleUnload` into a `C_ModuleUnload`.
wrap_ModuleUnload :: 
    Maybe (Ptr (FunPtr C_ModuleUnload)) ->
    ModuleUnload ->
    C_ModuleUnload
wrap_ModuleUnload gi'funptrptr gi'cb module_ = do
    module_' <- (newPtr GModule.Module.Module) module_
    gi'cb  module_'
    maybeReleaseFunPtr gi'funptrptr


-- callback ModuleCheckInit
{- Callable
  { returnType = Just (TBasicType TUTF8)
  , returnMayBeNull = False
  , returnTransfer = TransferNothing
  , returnDocumentation =
      Documentation
        { rawDocText =
            Just
              "%NULL on success, or a string describing the initialization error"
        , sinceVersion = Nothing
        }
  , args =
      [ Arg
          { argCName = "module"
          , argType =
              TInterface Name { namespace = "GModule" , name = "Module" }
          , direction = DirectionIn
          , mayBeNull = False
          , argDoc =
              Documentation
                { rawDocText =
                    Just
                      "the #GModule corresponding to the module which has just been loaded"
                , sinceVersion = Nothing
                }
          , argScope = ScopeTypeInvalid
          , argClosure = -1
          , argDestroy = -1
          , argCallerAllocates = False
          , argCallbackUserData = False
          , transfer = TransferNothing
          }
      ]
  , skipReturn = False
  , callableThrows = False
  , callableDeprecated = Nothing
  , callableDocumentation =
      Documentation
        { rawDocText =
            Just
              "Specifies the type of the module initialization function.\nIf a module contains a function named g_module_check_init() it is called\nautomatically when the module is loaded. It is passed the #GModule structure\nand should return %NULL on success or a string describing the initialization\nerror."
        , sinceVersion = Nothing
        }
  , callableResolvable = Nothing
  }
-}
-- | Type for the callback on the (unwrapped) C side.
type C_ModuleCheckInit =
    Ptr GModule.Module.Module ->
    IO CString

-- Args: [ Arg
--           { argCName = "module"
--           , argType =
--               TInterface Name { namespace = "GModule" , name = "Module" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the #GModule corresponding to the module which has just been loaded"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "dynamic" __dynamic_C_ModuleCheckInit :: FunPtr C_ModuleCheckInit -> C_ModuleCheckInit

-- | Given a pointer to a foreign C function, wrap it into a function callable from Haskell.
dynamic_ModuleCheckInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    FunPtr C_ModuleCheckInit
    -> GModule.Module.Module
    -- ^ /@module@/: the t'GI.GModule.Structs.Module.Module' corresponding to the module which has just been loaded
    -> m T.Text
    -- ^ __Returns:__ 'P.Nothing' on success, or a string describing the initialization error
dynamic_ModuleCheckInit __funPtr module_ = liftIO $ do
    module_' <- unsafeManagedPtrGetPtr module_
    result <- (__dynamic_C_ModuleCheckInit __funPtr) module_'
    checkUnexpectedReturnNULL "moduleCheckInit" result
    result' <- cstringToText result
    touchManagedPtr module_
    return result'

-- | Generate a function pointer callable from C code, from a `C_ModuleCheckInit`.
foreign import ccall "wrapper"
    mk_ModuleCheckInit :: C_ModuleCheckInit -> IO (FunPtr C_ModuleCheckInit)

-- | Specifies the type of the module initialization function.
-- If a module contains a function named @/g_module_check_init()/@ it is called
-- automatically when the module is loaded. It is passed the t'GI.GModule.Structs.Module.Module' structure
-- and should return 'P.Nothing' on success or a string describing the initialization
-- error.
type ModuleCheckInit =
    GModule.Module.Module
    -- ^ /@module@/: the t'GI.GModule.Structs.Module.Module' corresponding to the module which has just been loaded
    -> IO T.Text
    -- ^ __Returns:__ 'P.Nothing' on success, or a string describing the initialization error

-- | A convenience synonym for @`Nothing` :: `Maybe` `ModuleCheckInit`@.
noModuleCheckInit :: Maybe ModuleCheckInit
noModuleCheckInit = Nothing

-- | Wrap the callback into a `GClosure`.
genClosure_ModuleCheckInit :: MonadIO m => ModuleCheckInit -> m (GClosure C_ModuleCheckInit)
genClosure_ModuleCheckInit cb = liftIO $ do
    let cb' = wrap_ModuleCheckInit Nothing cb
    mk_ModuleCheckInit cb' >>= B.GClosure.newGClosure


-- | Wrap a `ModuleCheckInit` into a `C_ModuleCheckInit`.
wrap_ModuleCheckInit :: 
    Maybe (Ptr (FunPtr C_ModuleCheckInit)) ->
    ModuleCheckInit ->
    C_ModuleCheckInit
wrap_ModuleCheckInit gi'funptrptr gi'cb module_ = do
    module_' <- (newPtr GModule.Module.Module) module_
    result <- gi'cb  module_'
    maybeReleaseFunPtr gi'funptrptr
    result' <- textToCString result
    return result'



