{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A 4 vertex quadrilateral, as represented by four t'GI.Graphene.Structs.Point.Point'.
-- 
-- The contents of a t'GI.Graphene.Structs.Quad.Quad' are private and should never be
-- accessed directly.
-- 
-- /Since: 1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Quad
    ( 

-- * Exported types
    Quad(..)                                ,
    newZeroQuad                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bounds]("GI.Graphene.Structs.Quad#g:method:bounds"), [contains]("GI.Graphene.Structs.Quad#g:method:contains"), [free]("GI.Graphene.Structs.Quad#g:method:free"), [init]("GI.Graphene.Structs.Quad#g:method:init"), [initFromPoints]("GI.Graphene.Structs.Quad#g:method:initFromPoints"), [initFromRect]("GI.Graphene.Structs.Quad#g:method:initFromRect").
-- 
-- ==== Getters
-- [getPoint]("GI.Graphene.Structs.Quad#g:method:getPoint").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveQuadMethod                       ,
#endif

-- ** alloc #method:alloc#

    quadAlloc                               ,


-- ** bounds #method:bounds#

#if defined(ENABLE_OVERLOADING)
    QuadBoundsMethodInfo                    ,
#endif
    quadBounds                              ,


-- ** contains #method:contains#

#if defined(ENABLE_OVERLOADING)
    QuadContainsMethodInfo                  ,
#endif
    quadContains                            ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    QuadFreeMethodInfo                      ,
#endif
    quadFree                                ,


-- ** getPoint #method:getPoint#

#if defined(ENABLE_OVERLOADING)
    QuadGetPointMethodInfo                  ,
#endif
    quadGetPoint                            ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    QuadInitMethodInfo                      ,
#endif
    quadInit                                ,


-- ** initFromPoints #method:initFromPoints#

#if defined(ENABLE_OVERLOADING)
    QuadInitFromPointsMethodInfo            ,
#endif
    quadInitFromPoints                      ,


-- ** initFromRect #method:initFromRect#

#if defined(ENABLE_OVERLOADING)
    QuadInitFromRectMethodInfo              ,
#endif
    quadInitFromRect                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect

#endif

-- | Memory-managed wrapper type.
newtype Quad = Quad (SP.ManagedPtr Quad)
    deriving (Eq)

instance SP.ManagedPtrNewtype Quad where
    toManagedPtr (Quad p) = p

foreign import ccall "graphene_quad_get_type" c_graphene_quad_get_type :: 
    IO GType

type instance O.ParentTypes Quad = '[]
instance O.HasParentTypes Quad

instance B.Types.TypedObject Quad where
    glibType = c_graphene_quad_get_type

instance B.Types.GBoxed Quad

-- | Convert t'Quad' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Quad) where
    gvalueGType_ = c_graphene_quad_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Quad)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Quad)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Quad ptr
        else return P.Nothing
        
    

-- | Construct a t'Quad' struct initialized to zero.
newZeroQuad :: MonadIO m => m Quad
newZeroQuad = liftIO $ callocBoxedBytes 32 >>= wrapBoxed Quad

instance tag ~ 'AttrSet => Constructible Quad tag where
    new _ attrs = do
        o <- newZeroQuad
        GI.Attributes.set o attrs
        return o



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Quad
type instance O.AttributeList Quad = QuadAttributeList
type QuadAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method Quad::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Quad" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_alloc" graphene_quad_alloc :: 
    IO (Ptr Quad)

-- | Allocates a new t'GI.Graphene.Structs.Quad.Quad' instance.
-- 
-- The contents of the returned instance are undefined.
-- 
-- /Since: 1.0/
quadAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Quad
    -- ^ __Returns:__ the newly created t'GI.Graphene.Structs.Quad.Quad' instance
quadAlloc  = liftIO $ do
    result <- graphene_quad_alloc
    checkUnexpectedReturnNULL "quadAlloc" result
    result' <- (wrapBoxed Quad) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Quad::bounds
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_quad_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_rect_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_bounds" graphene_quad_bounds :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Ptr Graphene.Rect.Rect ->               -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO ()

-- | Computes the bounding rectangle of /@q@/ and places it into /@r@/.
-- 
-- /Since: 1.0/
quadBounds ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: a t'GI.Graphene.Structs.Quad.Quad'
    -> m (Graphene.Rect.Rect)
quadBounds q = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    r <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Rect.Rect)
    graphene_quad_bounds q' r
    r' <- (wrapBoxed Graphene.Rect.Rect) r
    touchManagedPtr q
    return r'

#if defined(ENABLE_OVERLOADING)
data QuadBoundsMethodInfo
instance (signature ~ (m (Graphene.Rect.Rect)), MonadIO m) => O.OverloadedMethod QuadBoundsMethodInfo Quad signature where
    overloadedMethod = quadBounds

instance O.OverloadedMethodInfo QuadBoundsMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadBounds",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadBounds"
        })


#endif

-- method Quad::contains
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_quad_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_contains" graphene_quad_contains :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Ptr Graphene.Point.Point ->             -- p : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO CInt

-- | Checks if the given t'GI.Graphene.Structs.Quad.Quad' contains the given t'GI.Graphene.Structs.Point.Point'.
-- 
-- /Since: 1.0/
quadContains ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: a t'GI.Graphene.Structs.Quad.Quad'
    -> Graphene.Point.Point
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point.Point'
    -> m Bool
    -- ^ __Returns:__ @true@ if the point is inside the t'GI.Graphene.Structs.Quad.Quad'
quadContains q p = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_quad_contains q' p'
    let result' = (/= 0) result
    touchManagedPtr q
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data QuadContainsMethodInfo
instance (signature ~ (Graphene.Point.Point -> m Bool), MonadIO m) => O.OverloadedMethod QuadContainsMethodInfo Quad signature where
    overloadedMethod = quadContains

instance O.OverloadedMethodInfo QuadContainsMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadContains",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadContains"
        })


#endif

-- method Quad::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_quad_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_free" graphene_quad_free :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    IO ()

-- | Frees the resources allocated by 'GI.Graphene.Structs.Quad.quadAlloc'
-- 
-- /Since: 1.0/
quadFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: a t'GI.Graphene.Structs.Quad.Quad'
    -> m ()
quadFree q = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    graphene_quad_free q'
    touchManagedPtr q
    return ()

#if defined(ENABLE_OVERLOADING)
data QuadFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod QuadFreeMethodInfo Quad signature where
    overloadedMethod = quadFree

instance O.OverloadedMethodInfo QuadFreeMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadFree"
        })


#endif

-- method Quad::get_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_quad_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the index of the point to retrieve"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_get_point" graphene_quad_get_point :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Word32 ->                               -- index_ : TBasicType TUInt
    IO (Ptr Graphene.Point.Point)

-- | Retrieves the point of a t'GI.Graphene.Structs.Quad.Quad' at the given index.
-- 
-- /Since: 1.0/
quadGetPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: a t'GI.Graphene.Structs.Quad.Quad'
    -> Word32
    -- ^ /@index_@/: the index of the point to retrieve
    -> m Graphene.Point.Point
    -- ^ __Returns:__ a t'GI.Graphene.Structs.Point.Point'
quadGetPoint q index_ = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    result <- graphene_quad_get_point q' index_
    checkUnexpectedReturnNULL "quadGetPoint" result
    result' <- (newBoxed Graphene.Point.Point) result
    touchManagedPtr q
    return result'

#if defined(ENABLE_OVERLOADING)
data QuadGetPointMethodInfo
instance (signature ~ (Word32 -> m Graphene.Point.Point), MonadIO m) => O.OverloadedMethod QuadGetPointMethodInfo Quad signature where
    overloadedMethod = quadGetPoint

instance O.OverloadedMethodInfo QuadGetPointMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadGetPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadGetPoint"
        })


#endif

-- method Quad::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_quad_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p1"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first point of the quadrilateral"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p2"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the second point of the quadrilateral"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p3"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the third point of the quadrilateral"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "p4"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the fourth point of the quadrilateral"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Quad" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_init" graphene_quad_init :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Ptr Graphene.Point.Point ->             -- p1 : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Point.Point ->             -- p2 : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Point.Point ->             -- p3 : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Point.Point ->             -- p4 : TInterface (Name {namespace = "Graphene", name = "Point"})
    IO (Ptr Quad)

-- | Initializes a t'GI.Graphene.Structs.Quad.Quad' with the given points.
-- 
-- /Since: 1.0/
quadInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: the t'GI.Graphene.Structs.Quad.Quad' to initialize
    -> Graphene.Point.Point
    -- ^ /@p1@/: the first point of the quadrilateral
    -> Graphene.Point.Point
    -- ^ /@p2@/: the second point of the quadrilateral
    -> Graphene.Point.Point
    -- ^ /@p3@/: the third point of the quadrilateral
    -> Graphene.Point.Point
    -- ^ /@p4@/: the fourth point of the quadrilateral
    -> m Quad
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Quad.Quad'
quadInit q p1 p2 p3 p4 = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    p1' <- unsafeManagedPtrGetPtr p1
    p2' <- unsafeManagedPtrGetPtr p2
    p3' <- unsafeManagedPtrGetPtr p3
    p4' <- unsafeManagedPtrGetPtr p4
    result <- graphene_quad_init q' p1' p2' p3' p4'
    checkUnexpectedReturnNULL "quadInit" result
    result' <- (newBoxed Quad) result
    touchManagedPtr q
    touchManagedPtr p1
    touchManagedPtr p2
    touchManagedPtr p3
    touchManagedPtr p4
    return result'

#if defined(ENABLE_OVERLOADING)
data QuadInitMethodInfo
instance (signature ~ (Graphene.Point.Point -> Graphene.Point.Point -> Graphene.Point.Point -> Graphene.Point.Point -> m Quad), MonadIO m) => O.OverloadedMethod QuadInitMethodInfo Quad signature where
    overloadedMethod = quadInit

instance O.OverloadedMethodInfo QuadInitMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadInit"
        })


#endif

-- method Quad::init_from_points
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_quad_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "points"
--           , argType =
--               TCArray
--                 False
--                 4
--                 (-1)
--                 (TInterface Name { namespace = "Graphene" , name = "Point" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an array of 4 #graphene_point_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Quad" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_init_from_points" graphene_quad_init_from_points :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Ptr Graphene.Point.Point ->             -- points : TCArray False 4 (-1) (TInterface (Name {namespace = "Graphene", name = "Point"}))
    IO (Ptr Quad)

-- | Initializes a t'GI.Graphene.Structs.Quad.Quad' using an array of points.
-- 
-- /Since: 1.2/
quadInitFromPoints ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: the t'GI.Graphene.Structs.Quad.Quad' to initialize
    -> [Graphene.Point.Point]
    -- ^ /@points@/: an array of 4 t'GI.Graphene.Structs.Point.Point'
    -> m Quad
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Quad.Quad'
quadInitFromPoints q points = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    points' <- mapM unsafeManagedPtrGetPtr points
    points'' <- packBlockArray 8 points'
    result <- graphene_quad_init_from_points q' points''
    checkUnexpectedReturnNULL "quadInitFromPoints" result
    result' <- (newBoxed Quad) result
    touchManagedPtr q
    mapM_ touchManagedPtr points
    freeMem points''
    return result'

#if defined(ENABLE_OVERLOADING)
data QuadInitFromPointsMethodInfo
instance (signature ~ ([Graphene.Point.Point] -> m Quad), MonadIO m) => O.OverloadedMethod QuadInitFromPointsMethodInfo Quad signature where
    overloadedMethod = quadInitFromPoints

instance O.OverloadedMethodInfo QuadInitFromPointsMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadInitFromPoints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadInitFromPoints"
        })


#endif

-- method Quad::init_from_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "q"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Quad" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_quad_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "r"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Quad" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_quad_init_from_rect" graphene_quad_init_from_rect :: 
    Ptr Quad ->                             -- q : TInterface (Name {namespace = "Graphene", name = "Quad"})
    Ptr Graphene.Rect.Rect ->               -- r : TInterface (Name {namespace = "Graphene", name = "Rect"})
    IO (Ptr Quad)

-- | Initializes a t'GI.Graphene.Structs.Quad.Quad' using the four corners of the
-- given t'GI.Graphene.Structs.Rect.Rect'.
-- 
-- /Since: 1.0/
quadInitFromRect ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Quad
    -- ^ /@q@/: the t'GI.Graphene.Structs.Quad.Quad' to initialize
    -> Graphene.Rect.Rect
    -- ^ /@r@/: a t'GI.Graphene.Structs.Rect.Rect'
    -> m Quad
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Quad.Quad'
quadInitFromRect q r = liftIO $ do
    q' <- unsafeManagedPtrGetPtr q
    r' <- unsafeManagedPtrGetPtr r
    result <- graphene_quad_init_from_rect q' r'
    checkUnexpectedReturnNULL "quadInitFromRect" result
    result' <- (newBoxed Quad) result
    touchManagedPtr q
    touchManagedPtr r
    return result'

#if defined(ENABLE_OVERLOADING)
data QuadInitFromRectMethodInfo
instance (signature ~ (Graphene.Rect.Rect -> m Quad), MonadIO m) => O.OverloadedMethod QuadInitFromRectMethodInfo Quad signature where
    overloadedMethod = quadInitFromRect

instance O.OverloadedMethodInfo QuadInitFromRectMethodInfo Quad where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Quad.quadInitFromRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Quad.html#v:quadInitFromRect"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveQuadMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveQuadMethod "bounds" o = QuadBoundsMethodInfo
    ResolveQuadMethod "contains" o = QuadContainsMethodInfo
    ResolveQuadMethod "free" o = QuadFreeMethodInfo
    ResolveQuadMethod "init" o = QuadInitMethodInfo
    ResolveQuadMethod "initFromPoints" o = QuadInitFromPointsMethodInfo
    ResolveQuadMethod "initFromRect" o = QuadInitFromRectMethodInfo
    ResolveQuadMethod "getPoint" o = QuadGetPointMethodInfo
    ResolveQuadMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveQuadMethod t Quad, O.OverloadedMethod info Quad p) => OL.IsLabel t (Quad -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveQuadMethod t Quad, O.OverloadedMethod info Quad p, R.HasField t Quad p) => R.HasField t Quad p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveQuadMethod t Quad, O.OverloadedMethodInfo info Quad) => OL.IsLabel t (O.MethodProxy info Quad) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


