{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node that potentially diverts a part of the scene graph to a subsurface.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.SubsurfaceNode
    ( 

-- * Exported types
    SubsurfaceNode(..)                      ,
    IsSubsurfaceNode                        ,
    toSubsurfaceNode                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getChild]("GI.Gsk.Objects.SubsurfaceNode#g:method:getChild"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveSubsurfaceNodeMethod             ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    SubsurfaceNodeGetChildMethodInfo        ,
#endif
    subsurfaceNodeGetChild                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- | Memory-managed wrapper type.
newtype SubsurfaceNode = SubsurfaceNode (SP.ManagedPtr SubsurfaceNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype SubsurfaceNode where
    toManagedPtr (SubsurfaceNode p) = p

foreign import ccall "gsk_subsurface_node_get_type"
    c_gsk_subsurface_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject SubsurfaceNode where
    glibType = c_gsk_subsurface_node_get_type

-- | Type class for types which can be safely cast to t'SubsurfaceNode', for instance with `toSubsurfaceNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf SubsurfaceNode o) => IsSubsurfaceNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf SubsurfaceNode o) => IsSubsurfaceNode o

instance O.HasParentTypes SubsurfaceNode
type instance O.ParentTypes SubsurfaceNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'SubsurfaceNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSubsurfaceNode :: (MIO.MonadIO m, IsSubsurfaceNode o) => o -> m SubsurfaceNode
toSubsurfaceNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo SubsurfaceNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveSubsurfaceNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSubsurfaceNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveSubsurfaceNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveSubsurfaceNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveSubsurfaceNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveSubsurfaceNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveSubsurfaceNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveSubsurfaceNodeMethod "getChild" o = SubsurfaceNodeGetChildMethodInfo
    ResolveSubsurfaceNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveSubsurfaceNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveSubsurfaceNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSubsurfaceNodeMethod t SubsurfaceNode, O.OverloadedMethod info SubsurfaceNode p) => OL.IsLabel t (SubsurfaceNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSubsurfaceNodeMethod t SubsurfaceNode, O.OverloadedMethod info SubsurfaceNode p, R.HasField t SubsurfaceNode p) => R.HasField t SubsurfaceNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSubsurfaceNodeMethod t SubsurfaceNode, O.OverloadedMethodInfo info SubsurfaceNode) => OL.IsLabel t (O.MethodProxy info SubsurfaceNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr SubsurfaceNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method SubsurfaceNode::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "SubsurfaceNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a subsurface `GskRenderNode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_subsurface_node_get_child" gsk_subsurface_node_get_child :: 
    Ptr SubsurfaceNode ->                   -- node : TInterface (Name {namespace = "Gsk", name = "SubsurfaceNode"})
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Gets the child node that is getting drawn by the given /@node@/.
-- 
-- /Since: 4.14/
subsurfaceNodeGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsSubsurfaceNode a) =>
    a
    -- ^ /@node@/: a subsurface @GskRenderNode@
    -> m Gsk.RenderNode.RenderNode
    -- ^ __Returns:__ the child @GskRenderNode@
subsurfaceNodeGetChild node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_subsurface_node_get_child node'
    checkUnexpectedReturnNULL "subsurfaceNodeGetChild" result
    result' <- (newPtr Gsk.RenderNode.RenderNode) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data SubsurfaceNodeGetChildMethodInfo
instance (signature ~ (m Gsk.RenderNode.RenderNode), MonadIO m, IsSubsurfaceNode a) => O.OverloadedMethod SubsurfaceNodeGetChildMethodInfo a signature where
    overloadedMethod = subsurfaceNodeGetChild

instance O.OverloadedMethodInfo SubsurfaceNodeGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.SubsurfaceNode.subsurfaceNodeGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-SubsurfaceNode.html#v:subsurfaceNodeGetChild"
        })


#endif


