{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An interface that adds support for sections to list models.
-- 
-- A @GtkSectionModel@ groups successive items into so-called sections. List widgets
-- like @GtkListView@ and @GtkGridView@ then allow displaying section headers for
-- these sections by installing a header factory.
-- 
-- Many GTK list models support sections inherently, or they pass through the sections
-- of a model they are wrapping.
-- 
-- When the section groupings of a model change, the model will emit the
-- [SectionModel::sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:signal:sectionsChanged") signal by calling the
-- 'GI.Gtk.Interfaces.SectionModel.sectionModelSectionsChanged' function. All sections in the given range
-- then need to be queried again.
-- The [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") signal has the same effect, all sections in
-- that range are invalidated, too.
-- 
-- /Since: 4.12/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Interfaces.SectionModel
    ( 

-- * Exported types
    SectionModel(..)                        ,
    IsSectionModel                          ,
    toSectionModel                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSectionModelMethod               ,
#endif

-- ** getSection #method:getSection#

#if defined(ENABLE_OVERLOADING)
    SectionModelGetSectionMethodInfo        ,
#endif
    sectionModelGetSection                  ,


-- ** sectionsChanged #method:sectionsChanged#

#if defined(ENABLE_OVERLOADING)
    SectionModelSectionsChangedMethodInfo   ,
#endif
    sectionModelSectionsChanged             ,




 -- * Signals


-- ** sectionsChanged #signal:sectionsChanged#

    SectionModelSectionsChangedCallback     ,
#if defined(ENABLE_OVERLOADING)
    SectionModelSectionsChangedSignalInfo   ,
#endif
    afterSectionModelSectionsChanged        ,
    onSectionModelSectionsChanged           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#endif

-- interface SectionModel 
-- | Memory-managed wrapper type.
newtype SectionModel = SectionModel (SP.ManagedPtr SectionModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype SectionModel where
    toManagedPtr (SectionModel p) = p

foreign import ccall "gtk_section_model_get_type"
    c_gtk_section_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject SectionModel where
    glibType = c_gtk_section_model_get_type

instance B.Types.GObject SectionModel

-- | Type class for types which can be safely cast to t'SectionModel', for instance with `toSectionModel`.
class (SP.GObject o, O.IsDescendantOf SectionModel o) => IsSectionModel o
instance (SP.GObject o, O.IsDescendantOf SectionModel o) => IsSectionModel o

instance O.HasParentTypes SectionModel
type instance O.ParentTypes SectionModel = '[Gio.ListModel.ListModel, GObject.Object.Object]

-- | Cast to t'SectionModel', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toSectionModel :: (MIO.MonadIO m, IsSectionModel o) => o -> m SectionModel
toSectionModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo SectionModel

-- | Convert t'SectionModel' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SectionModel) where
    gvalueGType_ = c_gtk_section_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SectionModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SectionModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SectionModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SectionModel
type instance O.AttributeList SectionModel = SectionModelAttributeList
type SectionModelAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveSectionModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSectionModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSectionModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSectionModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSectionModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSectionModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSectionModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSectionModelMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveSectionModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSectionModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSectionModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSectionModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSectionModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSectionModelMethod "sectionsChanged" o = SectionModelSectionsChangedMethodInfo
    ResolveSectionModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSectionModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSectionModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSectionModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSectionModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSectionModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSectionModelMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveSectionModelMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveSectionModelMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveSectionModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSectionModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSectionModelMethod "getSection" o = SectionModelGetSectionMethodInfo
    ResolveSectionModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSectionModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSectionModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSectionModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSectionModelMethod t SectionModel, O.OverloadedMethod info SectionModel p) => OL.IsLabel t (SectionModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSectionModelMethod t SectionModel, O.OverloadedMethod info SectionModel p, R.HasField t SectionModel p) => R.HasField t SectionModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSectionModelMethod t SectionModel, O.OverloadedMethodInfo info SectionModel) => OL.IsLabel t (O.MethodProxy info SectionModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method SectionModel::get_section
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSectionModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the item to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_start"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the position of the first item in the section"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "out_end"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the position of the first item not part of the section\n  anymore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_section_model_get_section" gtk_section_model_get_section :: 
    Ptr SectionModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "SectionModel"})
    Word32 ->                               -- position : TBasicType TUInt
    Ptr Word32 ->                           -- out_start : TBasicType TUInt
    Ptr Word32 ->                           -- out_end : TBasicType TUInt
    IO ()

-- | Query the section that covers the given position. The number of
-- items in the section can be computed by @out_end - out_start@.
-- 
-- If the position is larger than the number of items, a single
-- range from n_items to G_MAXUINT will be returned.
-- 
-- /Since: 4.12/
sectionModelGetSection ::
    (B.CallStack.HasCallStack, MonadIO m, IsSectionModel a) =>
    a
    -- ^ /@self@/: a @GtkSectionModel@
    -> Word32
    -- ^ /@position@/: the position of the item to query
    -> m ((Word32, Word32))
sectionModelGetSection self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    outStart <- allocMem :: IO (Ptr Word32)
    outEnd <- allocMem :: IO (Ptr Word32)
    gtk_section_model_get_section self' position outStart outEnd
    outStart' <- peek outStart
    outEnd' <- peek outEnd
    touchManagedPtr self
    freeMem outStart
    freeMem outEnd
    return (outStart', outEnd')

#if defined(ENABLE_OVERLOADING)
data SectionModelGetSectionMethodInfo
instance (signature ~ (Word32 -> m ((Word32, Word32))), MonadIO m, IsSectionModel a) => O.OverloadedMethod SectionModelGetSectionMethodInfo a signature where
    overloadedMethod = sectionModelGetSection

instance O.OverloadedMethodInfo SectionModelGetSectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.SectionModel.sectionModelGetSection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-SectionModel.html#v:sectionModelGetSection"
        })


#endif

-- method SectionModel::sections_changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SectionModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSectionModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the first changed item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_items"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of changed items"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_section_model_sections_changed" gtk_section_model_sections_changed :: 
    Ptr SectionModel ->                     -- self : TInterface (Name {namespace = "Gtk", name = "SectionModel"})
    Word32 ->                               -- position : TBasicType TUInt
    Word32 ->                               -- n_items : TBasicType TUInt
    IO ()

-- | This function emits the [SectionModel::sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:signal:sectionsChanged")
-- signal to notify about changes to sections.
-- 
-- It must cover all positions that used to be a section start or that
-- are now a section start. It does not have to cover all positions for
-- which the section has changed.
-- 
-- The [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") implies the effect of the
-- [SectionModel::sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:signal:sectionsChanged") signal for all the items
-- it covers.
-- 
-- It is recommended that when changes to the items cause section changes
-- in a larger range, that the larger range is included in the emission
-- of the [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") instead of emitting
-- two signals.
-- 
-- /Since: 4.12/
sectionModelSectionsChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSectionModel a) =>
    a
    -- ^ /@self@/: a @GtkSectionModel@
    -> Word32
    -- ^ /@position@/: the first changed item
    -> Word32
    -- ^ /@nItems@/: the number of changed items
    -> m ()
sectionModelSectionsChanged self position nItems = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_section_model_sections_changed self' position nItems
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SectionModelSectionsChangedMethodInfo
instance (signature ~ (Word32 -> Word32 -> m ()), MonadIO m, IsSectionModel a) => O.OverloadedMethod SectionModelSectionsChangedMethodInfo a signature where
    overloadedMethod = sectionModelSectionsChanged

instance O.OverloadedMethodInfo SectionModelSectionsChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.SectionModel.sectionModelSectionsChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-SectionModel.html#v:sectionModelSectionsChanged"
        })


#endif

-- signal SectionModel::sections-changed
-- | Emitted when the start-of-section state of some of the items in /@model@/ changes.
-- 
-- Note that this signal does not specify the new section state of the
-- items, they need to be queried manually. It is also not necessary for
-- a model to change the section state of any of the items in the section
-- model, though it would be rather useless to emit such a signal.
-- 
-- The [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") implies the effect of the
-- [SectionModel::sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:signal:sectionsChanged") signal for all the items
-- it covers.
-- 
-- /Since: 4.12/
type SectionModelSectionsChangedCallback =
    Word32
    -- ^ /@position@/: The first item that may have changed
    -> Word32
    -- ^ /@nItems@/: number of items with changes
    -> IO ()

type C_SectionModelSectionsChangedCallback =
    Ptr SectionModel ->                     -- object
    Word32 ->
    Word32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SectionModelSectionsChangedCallback`.
foreign import ccall "wrapper"
    mk_SectionModelSectionsChangedCallback :: C_SectionModelSectionsChangedCallback -> IO (FunPtr C_SectionModelSectionsChangedCallback)

wrap_SectionModelSectionsChangedCallback :: 
    GObject a => (a -> SectionModelSectionsChangedCallback) ->
    C_SectionModelSectionsChangedCallback
wrap_SectionModelSectionsChangedCallback gi'cb gi'selfPtr position nItems _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  position nItems


-- | Connect a signal handler for the [sectionsChanged](#signal:sectionsChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' sectionModel #sectionsChanged callback
-- @
-- 
-- 
onSectionModelSectionsChanged :: (IsSectionModel a, MonadIO m) => a -> ((?self :: a) => SectionModelSectionsChangedCallback) -> m SignalHandlerId
onSectionModelSectionsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SectionModelSectionsChangedCallback wrapped
    wrapped'' <- mk_SectionModelSectionsChangedCallback wrapped'
    connectSignalFunPtr obj "sections-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [sectionsChanged](#signal:sectionsChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' sectionModel #sectionsChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSectionModelSectionsChanged :: (IsSectionModel a, MonadIO m) => a -> ((?self :: a) => SectionModelSectionsChangedCallback) -> m SignalHandlerId
afterSectionModelSectionsChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SectionModelSectionsChangedCallback wrapped
    wrapped'' <- mk_SectionModelSectionsChangedCallback wrapped'
    connectSignalFunPtr obj "sections-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SectionModelSectionsChangedSignalInfo
instance SignalInfo SectionModelSectionsChangedSignalInfo where
    type HaskellCallbackType SectionModelSectionsChangedSignalInfo = SectionModelSectionsChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SectionModelSectionsChangedCallback cb
        cb'' <- mk_SectionModelSectionsChangedCallback cb'
        connectSignalFunPtr obj "sections-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Interfaces.SectionModel::sections-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Interfaces-SectionModel.html#g:signal:sectionsChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SectionModel = SectionModelSignalList
type SectionModelSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", SectionModelSectionsChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif


