{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Sorts t'GI.Gtk.Objects.ColumnView.ColumnView' columns.
-- 
-- The sorter returned by 'GI.Gtk.Objects.ColumnView.columnViewGetSorter' is
-- a @GtkColumnViewSorter@.
-- 
-- In column views, sorting can be configured by associating
-- sorters with columns, and users can invert sort order by clicking
-- on column headers. The API of @GtkColumnViewSorter@ is designed
-- to allow saving and restoring this configuration.
-- 
-- If you are only interested in the primary sort column (i.e. the
-- column where a sort indicator is shown in the header), then
-- you can just look at [ColumnViewSorter:primarySortColumn]("GI.Gtk.Objects.ColumnViewSorter#g:attr:primarySortColumn")
-- and [ColumnViewSorter:primarySortOrder]("GI.Gtk.Objects.ColumnViewSorter#g:attr:primarySortOrder").
-- 
-- If you want to store the full sort configuration, including
-- secondary sort columns that are used for tie breaking, then
-- you can use 'GI.Gtk.Objects.ColumnViewSorter.columnViewSorterGetNthSortColumn'.
-- To get notified about changes, use [Sorter::changed]("GI.Gtk.Objects.Sorter#g:signal:changed").
-- 
-- To restore a saved sort configuration on a @GtkColumnView@,
-- use code like:
-- 
-- 
-- 	
-- >sorter = gtk_column_view_get_sorter (view);
-- >for (i = gtk_column_view_sorter_get_n_sort_columns (sorter) - 1; i >= 0; i--)
-- >  {
-- >    column = gtk_column_view_sorter_get_nth_sort_column (sorter, i, &order);
-- >    gtk_column_view_sort_by_column (view, column, order);
-- >  }
-- 
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ColumnViewSorter
    ( 

-- * Exported types
    ColumnViewSorter(..)                    ,
    IsColumnViewSorter                      ,
    toColumnViewSorter                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getNSortColumns]("GI.Gtk.Objects.ColumnViewSorter#g:method:getNSortColumns"), [getNthSortColumn]("GI.Gtk.Objects.ColumnViewSorter#g:method:getNthSortColumn"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getPrimarySortColumn]("GI.Gtk.Objects.ColumnViewSorter#g:method:getPrimarySortColumn"), [getPrimarySortOrder]("GI.Gtk.Objects.ColumnViewSorter#g:method:getPrimarySortOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveColumnViewSorterMethod           ,
#endif

-- ** getNSortColumns #method:getNSortColumns#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterGetNSortColumnsMethodInfo,
#endif
    columnViewSorterGetNSortColumns         ,


-- ** getNthSortColumn #method:getNthSortColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterGetNthSortColumnMethodInfo,
#endif
    columnViewSorterGetNthSortColumn        ,


-- ** getPrimarySortColumn #method:getPrimarySortColumn#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterGetPrimarySortColumnMethodInfo,
#endif
    columnViewSorterGetPrimarySortColumn    ,


-- ** getPrimarySortOrder #method:getPrimarySortOrder#

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterGetPrimarySortOrderMethodInfo,
#endif
    columnViewSorterGetPrimarySortOrder     ,




 -- * Properties


-- ** primarySortColumn #attr:primarySortColumn#
-- | The primary sort column.
-- 
-- The primary sort column is the one that displays the triangle
-- in a column view header.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterPrimarySortColumnPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewSorterPrimarySortColumn       ,
#endif
    getColumnViewSorterPrimarySortColumn    ,


-- ** primarySortOrder #attr:primarySortOrder#
-- | The primary sort order.
-- 
-- The primary sort order determines whether the triangle displayed
-- in the column view header of the primary sort column points upwards
-- or downwards.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ColumnViewSorterPrimarySortOrderPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    columnViewSorterPrimarySortOrder        ,
#endif
    getColumnViewSorterPrimarySortOrder     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColumnView as Gtk.ColumnView
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColumnViewColumn as Gtk.ColumnViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.ScrollInfo as Gtk.ScrollInfo
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.ColumnViewColumn as Gtk.ColumnViewColumn
import {-# SOURCE #-} qualified GI.Gtk.Objects.Sorter as Gtk.Sorter

#endif

-- | Memory-managed wrapper type.
newtype ColumnViewSorter = ColumnViewSorter (SP.ManagedPtr ColumnViewSorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColumnViewSorter where
    toManagedPtr (ColumnViewSorter p) = p

foreign import ccall "gtk_column_view_sorter_get_type"
    c_gtk_column_view_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject ColumnViewSorter where
    glibType = c_gtk_column_view_sorter_get_type

instance B.Types.GObject ColumnViewSorter

-- | Type class for types which can be safely cast to t'ColumnViewSorter', for instance with `toColumnViewSorter`.
class (SP.GObject o, O.IsDescendantOf ColumnViewSorter o) => IsColumnViewSorter o
instance (SP.GObject o, O.IsDescendantOf ColumnViewSorter o) => IsColumnViewSorter o

instance O.HasParentTypes ColumnViewSorter
type instance O.ParentTypes ColumnViewSorter = '[Gtk.Sorter.Sorter, GObject.Object.Object]

-- | Cast to t'ColumnViewSorter', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toColumnViewSorter :: (MIO.MonadIO m, IsColumnViewSorter o) => o -> m ColumnViewSorter
toColumnViewSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo ColumnViewSorter

-- | Convert t'ColumnViewSorter' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColumnViewSorter) where
    gvalueGType_ = c_gtk_column_view_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ColumnViewSorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ColumnViewSorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ColumnViewSorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveColumnViewSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColumnViewSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveColumnViewSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveColumnViewSorterMethod "changed" o = Gtk.Sorter.SorterChangedMethodInfo
    ResolveColumnViewSorterMethod "compare" o = Gtk.Sorter.SorterCompareMethodInfo
    ResolveColumnViewSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveColumnViewSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveColumnViewSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveColumnViewSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveColumnViewSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveColumnViewSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveColumnViewSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveColumnViewSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveColumnViewSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveColumnViewSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveColumnViewSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveColumnViewSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveColumnViewSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveColumnViewSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveColumnViewSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveColumnViewSorterMethod "getNSortColumns" o = ColumnViewSorterGetNSortColumnsMethodInfo
    ResolveColumnViewSorterMethod "getNthSortColumn" o = ColumnViewSorterGetNthSortColumnMethodInfo
    ResolveColumnViewSorterMethod "getOrder" o = Gtk.Sorter.SorterGetOrderMethodInfo
    ResolveColumnViewSorterMethod "getPrimarySortColumn" o = ColumnViewSorterGetPrimarySortColumnMethodInfo
    ResolveColumnViewSorterMethod "getPrimarySortOrder" o = ColumnViewSorterGetPrimarySortOrderMethodInfo
    ResolveColumnViewSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveColumnViewSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveColumnViewSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveColumnViewSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveColumnViewSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveColumnViewSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColumnViewSorterMethod t ColumnViewSorter, O.OverloadedMethod info ColumnViewSorter p) => OL.IsLabel t (ColumnViewSorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColumnViewSorterMethod t ColumnViewSorter, O.OverloadedMethod info ColumnViewSorter p, R.HasField t ColumnViewSorter p) => R.HasField t ColumnViewSorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColumnViewSorterMethod t ColumnViewSorter, O.OverloadedMethodInfo info ColumnViewSorter) => OL.IsLabel t (O.MethodProxy info ColumnViewSorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "primary-sort-column"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ColumnViewColumn"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@primary-sort-column@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnViewSorter #primarySortColumn
-- @
getColumnViewSorterPrimarySortColumn :: (MonadIO m, IsColumnViewSorter o) => o -> m (Maybe Gtk.ColumnViewColumn.ColumnViewColumn)
getColumnViewSorterPrimarySortColumn obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "primary-sort-column" Gtk.ColumnViewColumn.ColumnViewColumn

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterPrimarySortColumnPropertyInfo
instance AttrInfo ColumnViewSorterPrimarySortColumnPropertyInfo where
    type AttrAllowedOps ColumnViewSorterPrimarySortColumnPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ColumnViewSorterPrimarySortColumnPropertyInfo = IsColumnViewSorter
    type AttrSetTypeConstraint ColumnViewSorterPrimarySortColumnPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ColumnViewSorterPrimarySortColumnPropertyInfo = (~) ()
    type AttrTransferType ColumnViewSorterPrimarySortColumnPropertyInfo = ()
    type AttrGetType ColumnViewSorterPrimarySortColumnPropertyInfo = (Maybe Gtk.ColumnViewColumn.ColumnViewColumn)
    type AttrLabel ColumnViewSorterPrimarySortColumnPropertyInfo = "primary-sort-column"
    type AttrOrigin ColumnViewSorterPrimarySortColumnPropertyInfo = ColumnViewSorter
    attrGet = getColumnViewSorterPrimarySortColumn
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.primarySortColumn"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#g:attr:primarySortColumn"
        })
#endif

-- VVV Prop "primary-sort-order"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SortType"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@primary-sort-order@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' columnViewSorter #primarySortOrder
-- @
getColumnViewSorterPrimarySortOrder :: (MonadIO m, IsColumnViewSorter o) => o -> m Gtk.Enums.SortType
getColumnViewSorterPrimarySortOrder obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "primary-sort-order"

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterPrimarySortOrderPropertyInfo
instance AttrInfo ColumnViewSorterPrimarySortOrderPropertyInfo where
    type AttrAllowedOps ColumnViewSorterPrimarySortOrderPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ColumnViewSorterPrimarySortOrderPropertyInfo = IsColumnViewSorter
    type AttrSetTypeConstraint ColumnViewSorterPrimarySortOrderPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ColumnViewSorterPrimarySortOrderPropertyInfo = (~) ()
    type AttrTransferType ColumnViewSorterPrimarySortOrderPropertyInfo = ()
    type AttrGetType ColumnViewSorterPrimarySortOrderPropertyInfo = Gtk.Enums.SortType
    type AttrLabel ColumnViewSorterPrimarySortOrderPropertyInfo = "primary-sort-order"
    type AttrOrigin ColumnViewSorterPrimarySortOrderPropertyInfo = ColumnViewSorter
    attrGet = getColumnViewSorterPrimarySortOrder
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.primarySortOrder"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#g:attr:primarySortOrder"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColumnViewSorter
type instance O.AttributeList ColumnViewSorter = ColumnViewSorterAttributeList
type ColumnViewSorterAttributeList = ('[ '("primarySortColumn", ColumnViewSorterPrimarySortColumnPropertyInfo), '("primarySortOrder", ColumnViewSorterPrimarySortOrderPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
columnViewSorterPrimarySortColumn :: AttrLabelProxy "primarySortColumn"
columnViewSorterPrimarySortColumn = AttrLabelProxy

columnViewSorterPrimarySortOrder :: AttrLabelProxy "primarySortOrder"
columnViewSorterPrimarySortOrder = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ColumnViewSorter = ColumnViewSorterSignalList
type ColumnViewSorterSignalList = ('[ '("changed", Gtk.Sorter.SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ColumnViewSorter::get_n_sort_columns
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnviewsorter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_sorter_get_n_sort_columns" gtk_column_view_sorter_get_n_sort_columns :: 
    Ptr ColumnViewSorter ->                 -- self : TInterface (Name {namespace = "Gtk", name = "ColumnViewSorter"})
    IO Word32

-- | Returns the number of columns by which the sorter sorts.
-- 
-- If the sorter of the primary sort column does not determine
-- a total order, then the secondary sorters are consulted to
-- break the ties.
-- 
-- Use the [Sorter::changed]("GI.Gtk.Objects.Sorter#g:signal:changed") signal to get notified
-- when the number of sort columns changes.
-- 
-- /Since: 4.10/
columnViewSorterGetNSortColumns ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnViewSorter a) =>
    a
    -- ^ /@self@/: a columnviewsorter
    -> m Word32
    -- ^ __Returns:__ the number of sort columns
columnViewSorterGetNSortColumns self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_sorter_get_n_sort_columns self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterGetNSortColumnsMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsColumnViewSorter a) => O.OverloadedMethod ColumnViewSorterGetNSortColumnsMethodInfo a signature where
    overloadedMethod = columnViewSorterGetNSortColumns

instance O.OverloadedMethodInfo ColumnViewSorterGetNSortColumnsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.columnViewSorterGetNSortColumns",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#v:columnViewSorterGetNSortColumns"
        })


#endif

-- method ColumnViewSorter::get_nth_sort_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnviewsorter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the position of the sort column to retrieve (0 for the\n    primary sort column)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "sort_order"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SortType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the sort order"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_sorter_get_nth_sort_column" gtk_column_view_sorter_get_nth_sort_column :: 
    Ptr ColumnViewSorter ->                 -- self : TInterface (Name {namespace = "Gtk", name = "ColumnViewSorter"})
    Word32 ->                               -- position : TBasicType TUInt
    Ptr CUInt ->                            -- sort_order : TInterface (Name {namespace = "Gtk", name = "SortType"})
    IO (Ptr Gtk.ColumnViewColumn.ColumnViewColumn)

-- | Gets the /@position@/\'th sort column and its associated sort order.
-- 
-- Use the [Sorter::changed]("GI.Gtk.Objects.Sorter#g:signal:changed") signal to get notified
-- when sort columns change.
-- 
-- /Since: 4.10/
columnViewSorterGetNthSortColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnViewSorter a) =>
    a
    -- ^ /@self@/: a columnviewsorter
    -> Word32
    -- ^ /@position@/: the position of the sort column to retrieve (0 for the
    --     primary sort column)
    -> m ((Maybe Gtk.ColumnViewColumn.ColumnViewColumn, Gtk.Enums.SortType))
    -- ^ __Returns:__ the sort column at the /@position@/
columnViewSorterGetNthSortColumn self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    sortOrder <- allocMem :: IO (Ptr CUInt)
    result <- gtk_column_view_sorter_get_nth_sort_column self' position sortOrder
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ColumnViewColumn.ColumnViewColumn) result'
        return result''
    sortOrder' <- peek sortOrder
    let sortOrder'' = (toEnum . fromIntegral) sortOrder'
    touchManagedPtr self
    freeMem sortOrder
    return (maybeResult, sortOrder'')

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterGetNthSortColumnMethodInfo
instance (signature ~ (Word32 -> m ((Maybe Gtk.ColumnViewColumn.ColumnViewColumn, Gtk.Enums.SortType))), MonadIO m, IsColumnViewSorter a) => O.OverloadedMethod ColumnViewSorterGetNthSortColumnMethodInfo a signature where
    overloadedMethod = columnViewSorterGetNthSortColumn

instance O.OverloadedMethodInfo ColumnViewSorterGetNthSortColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.columnViewSorterGetNthSortColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#v:columnViewSorterGetNthSortColumn"
        })


#endif

-- method ColumnViewSorter::get_primary_sort_column
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnviewsorter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ColumnViewColumn" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_sorter_get_primary_sort_column" gtk_column_view_sorter_get_primary_sort_column :: 
    Ptr ColumnViewSorter ->                 -- self : TInterface (Name {namespace = "Gtk", name = "ColumnViewSorter"})
    IO (Ptr Gtk.ColumnViewColumn.ColumnViewColumn)

-- | Returns the primary sort column.
-- 
-- The primary sort column is the one that displays the triangle
-- in a column view header.
-- 
-- /Since: 4.10/
columnViewSorterGetPrimarySortColumn ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnViewSorter a) =>
    a
    -- ^ /@self@/: a columnviewsorter
    -> m (Maybe Gtk.ColumnViewColumn.ColumnViewColumn)
    -- ^ __Returns:__ the primary sort column
columnViewSorterGetPrimarySortColumn self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_sorter_get_primary_sort_column self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ColumnViewColumn.ColumnViewColumn) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterGetPrimarySortColumnMethodInfo
instance (signature ~ (m (Maybe Gtk.ColumnViewColumn.ColumnViewColumn)), MonadIO m, IsColumnViewSorter a) => O.OverloadedMethod ColumnViewSorterGetPrimarySortColumnMethodInfo a signature where
    overloadedMethod = columnViewSorterGetPrimarySortColumn

instance O.OverloadedMethodInfo ColumnViewSorterGetPrimarySortColumnMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.columnViewSorterGetPrimarySortColumn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#v:columnViewSorterGetPrimarySortColumn"
        })


#endif

-- method ColumnViewSorter::get_primary_sort_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ColumnViewSorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a columnviewsorter" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SortType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_column_view_sorter_get_primary_sort_order" gtk_column_view_sorter_get_primary_sort_order :: 
    Ptr ColumnViewSorter ->                 -- self : TInterface (Name {namespace = "Gtk", name = "ColumnViewSorter"})
    IO CUInt

-- | Returns the primary sort order.
-- 
-- The primary sort order determines whether the triangle displayed
-- in the column view header of the primary sort column points upwards
-- or downwards.
-- 
-- If there is no primary sort column, then this function returns
-- @GTK_SORT_ASCENDING@.
-- 
-- /Since: 4.10/
columnViewSorterGetPrimarySortOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsColumnViewSorter a) =>
    a
    -- ^ /@self@/: a columnviewsorter
    -> m Gtk.Enums.SortType
    -- ^ __Returns:__ the primary sort order
columnViewSorterGetPrimarySortOrder self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_column_view_sorter_get_primary_sort_order self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColumnViewSorterGetPrimarySortOrderMethodInfo
instance (signature ~ (m Gtk.Enums.SortType), MonadIO m, IsColumnViewSorter a) => O.OverloadedMethod ColumnViewSorterGetPrimarySortOrderMethodInfo a signature where
    overloadedMethod = columnViewSorterGetPrimarySortOrder

instance O.OverloadedMethodInfo ColumnViewSorterGetPrimarySortOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ColumnViewSorter.columnViewSorterGetPrimarySortOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ColumnViewSorter.html#v:columnViewSorterGetPrimarySortOrder"
        })


#endif


