{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A constant value in a @GtkExpression@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ConstantExpression
    ( 

-- * Exported types
    ConstantExpression(..)                  ,
    IsConstantExpression                    ,
    toConstantExpression                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bind]("GI.Gtk.Objects.Expression#g:method:bind"), [evaluate]("GI.Gtk.Objects.Expression#g:method:evaluate"), [isStatic]("GI.Gtk.Objects.Expression#g:method:isStatic"), [ref]("GI.Gtk.Objects.Expression#g:method:ref"), [unref]("GI.Gtk.Objects.Expression#g:method:unref"), [watch]("GI.Gtk.Objects.Expression#g:method:watch").
-- 
-- ==== Getters
-- [getValue]("GI.Gtk.Objects.ConstantExpression#g:method:getValue"), [getValueType]("GI.Gtk.Objects.Expression#g:method:getValueType").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveConstantExpressionMethod         ,
#endif

-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    ConstantExpressionGetValueMethodInfo    ,
#endif
    constantExpressionGetValue              ,


-- ** newForValue #method:newForValue#

    constantExpressionNewForValue           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression
import {-# SOURCE #-} qualified GI.Gtk.Structs.ExpressionWatch as Gtk.ExpressionWatch

#else
import {-# SOURCE #-} qualified GI.Gtk.Objects.Expression as Gtk.Expression

#endif

-- | Memory-managed wrapper type.
newtype ConstantExpression = ConstantExpression (SP.ManagedPtr ConstantExpression)
    deriving (Eq)

instance SP.ManagedPtrNewtype ConstantExpression where
    toManagedPtr (ConstantExpression p) = p

foreign import ccall "gtk_constant_expression_get_type"
    c_gtk_constant_expression_get_type :: IO B.Types.GType

instance B.Types.TypedObject ConstantExpression where
    glibType = c_gtk_constant_expression_get_type

-- | Type class for types which can be safely cast to t'ConstantExpression', for instance with `toConstantExpression`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ConstantExpression o) => IsConstantExpression o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf ConstantExpression o) => IsConstantExpression o

instance O.HasParentTypes ConstantExpression
type instance O.ParentTypes ConstantExpression = '[Gtk.Expression.Expression]

-- | Cast to t'ConstantExpression', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toConstantExpression :: (MIO.MonadIO m, IsConstantExpression o) => o -> m ConstantExpression
toConstantExpression = MIO.liftIO . B.ManagedPtr.unsafeCastTo ConstantExpression

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveConstantExpressionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveConstantExpressionMethod "bind" o = Gtk.Expression.ExpressionBindMethodInfo
    ResolveConstantExpressionMethod "evaluate" o = Gtk.Expression.ExpressionEvaluateMethodInfo
    ResolveConstantExpressionMethod "isStatic" o = Gtk.Expression.ExpressionIsStaticMethodInfo
    ResolveConstantExpressionMethod "ref" o = Gtk.Expression.ExpressionRefMethodInfo
    ResolveConstantExpressionMethod "unref" o = Gtk.Expression.ExpressionUnrefMethodInfo
    ResolveConstantExpressionMethod "watch" o = Gtk.Expression.ExpressionWatchMethodInfo
    ResolveConstantExpressionMethod "getValue" o = ConstantExpressionGetValueMethodInfo
    ResolveConstantExpressionMethod "getValueType" o = Gtk.Expression.ExpressionGetValueTypeMethodInfo
    ResolveConstantExpressionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveConstantExpressionMethod t ConstantExpression, O.OverloadedMethod info ConstantExpression p) => OL.IsLabel t (ConstantExpression -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveConstantExpressionMethod t ConstantExpression, O.OverloadedMethod info ConstantExpression p, R.HasField t ConstantExpression p) => R.HasField t ConstantExpression p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveConstantExpressionMethod t ConstantExpression, O.OverloadedMethodInfo info ConstantExpression) => OL.IsLabel t (O.MethodProxy info ConstantExpression) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr ConstantExpression where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method ConstantExpression::new_for_value
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GValue`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "ConstantExpression" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_constant_expression_new_for_value" gtk_constant_expression_new_for_value :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr ConstantExpression)

-- | Creates an expression that always evaluates to the given @value@.
constantExpressionNewForValue ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@
    -> m ConstantExpression
    -- ^ __Returns:__ a new @GtkExpression@
constantExpressionNewForValue value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gtk_constant_expression_new_for_value value'
    checkUnexpectedReturnNULL "constantExpressionNewForValue" result
    result' <- (wrapPtr ConstantExpression) result
    touchManagedPtr value
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ConstantExpression::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "expression"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ConstantExpression" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a constant `GtkExpression`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TGValue
-- throws : False
-- Skip return : False

foreign import ccall "gtk_constant_expression_get_value" gtk_constant_expression_get_value :: 
    Ptr ConstantExpression ->               -- expression : TInterface (Name {namespace = "Gtk", name = "ConstantExpression"})
    IO (Ptr GValue)

-- | Gets the value that a constant expression evaluates to.
constantExpressionGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsConstantExpression a) =>
    a
    -- ^ /@expression@/: a constant @GtkExpression@
    -> m GValue
    -- ^ __Returns:__ the value
constantExpressionGetValue expression = liftIO $ do
    expression' <- unsafeManagedPtrCastPtr expression
    result <- gtk_constant_expression_get_value expression'
    checkUnexpectedReturnNULL "constantExpressionGetValue" result
    result' <- B.GValue.newGValueFromPtr result
    touchManagedPtr expression
    return result'

#if defined(ENABLE_OVERLOADING)
data ConstantExpressionGetValueMethodInfo
instance (signature ~ (m GValue), MonadIO m, IsConstantExpression a) => O.OverloadedMethod ConstantExpressionGetValueMethodInfo a signature where
    overloadedMethod = constantExpressionGetValue

instance O.OverloadedMethodInfo ConstantExpressionGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ConstantExpression.constantExpressionGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ConstantExpression.html#v:constantExpressionGetValue"
        })


#endif


