{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A sub-parser for @GtkBuildable@ implementations.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.BuildableParser
    ( 

-- * Exported types
    BuildableParser(..)                     ,
    newZeroBuildableParser                  ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveBuildableParserMethod            ,
#endif



 -- * Properties


-- ** endElement #attr:endElement#
-- | function called for close elements

#if defined(ENABLE_OVERLOADING)
    buildableParser_endElement              ,
#endif
    clearBuildableParserEndElement          ,
    getBuildableParserEndElement            ,
    setBuildableParserEndElement            ,


-- ** error #attr:error#
-- | function called on error

#if defined(ENABLE_OVERLOADING)
    buildableParser_error                   ,
#endif
    clearBuildableParserError               ,
    getBuildableParserError                 ,
    setBuildableParserError                 ,


-- ** startElement #attr:startElement#
-- | function called for open elements

#if defined(ENABLE_OVERLOADING)
    buildableParser_startElement            ,
#endif
    clearBuildableParserStartElement        ,
    getBuildableParserStartElement          ,
    setBuildableParserStartElement          ,


-- ** text #attr:text#
-- | function called for character data

#if defined(ENABLE_OVERLOADING)
    buildableParser_text                    ,
#endif
    clearBuildableParserText                ,
    getBuildableParserText                  ,
    setBuildableParserText                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gtk.Callbacks as Gtk.Callbacks

#else
import qualified GI.Gtk.Callbacks as Gtk.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype BuildableParser = BuildableParser (SP.ManagedPtr BuildableParser)
    deriving (Eq)

instance SP.ManagedPtrNewtype BuildableParser where
    toManagedPtr (BuildableParser p) = p

instance BoxedPtr BuildableParser where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 64 >=> B.ManagedPtr.wrapPtr BuildableParser)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr BuildableParser where
    boxedPtrCalloc = callocBytes 64


-- | Construct a t'BuildableParser' struct initialized to zero.
newZeroBuildableParser :: MonadIO m => m BuildableParser
newZeroBuildableParser = liftIO $ boxedPtrCalloc >>= wrapPtr BuildableParser

instance tag ~ 'AttrSet => Constructible BuildableParser tag where
    new _ attrs = do
        o <- newZeroBuildableParser
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@start_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' buildableParser #startElement
-- @
getBuildableParserStartElement :: MonadIO m => BuildableParser -> m (Maybe Gtk.Callbacks.BuildableParserStartElementFieldCallback_WithClosures)
getBuildableParserStartElement s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_BuildableParserStartElementFieldCallback val'
        return val''
    return result

-- | Set the value of the “@start_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' buildableParser [ #startElement 'Data.GI.Base.Attributes.:=' value ]
-- @
setBuildableParserStartElement :: MonadIO m => BuildableParser -> FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback -> m ()
setBuildableParserStartElement s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)

-- | Set the value of the “@start_element@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #startElement
-- @
clearBuildableParserStartElement :: MonadIO m => BuildableParser -> m ()
clearBuildableParserStartElement s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)

#if defined(ENABLE_OVERLOADING)
data BuildableParserStartElementFieldInfo
instance AttrInfo BuildableParserStartElementFieldInfo where
    type AttrBaseTypeConstraint BuildableParserStartElementFieldInfo = (~) BuildableParser
    type AttrAllowedOps BuildableParserStartElementFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint BuildableParserStartElementFieldInfo = (~) (FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)
    type AttrTransferTypeConstraint BuildableParserStartElementFieldInfo = (~)(FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)
    type AttrTransferType BuildableParserStartElementFieldInfo = (FunPtr Gtk.Callbacks.C_BuildableParserStartElementFieldCallback)
    type AttrGetType BuildableParserStartElementFieldInfo = Maybe Gtk.Callbacks.BuildableParserStartElementFieldCallback_WithClosures
    type AttrLabel BuildableParserStartElementFieldInfo = "start_element"
    type AttrOrigin BuildableParserStartElementFieldInfo = BuildableParser
    attrGet = getBuildableParserStartElement
    attrSet = setBuildableParserStartElement
    attrConstruct = undefined
    attrClear = clearBuildableParserStartElement
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.BuildableParser.startElement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-BuildableParser.html#g:attr:startElement"
        })

buildableParser_startElement :: AttrLabelProxy "startElement"
buildableParser_startElement = AttrLabelProxy

#endif


-- | Get the value of the “@end_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' buildableParser #endElement
-- @
getBuildableParserEndElement :: MonadIO m => BuildableParser -> m (Maybe Gtk.Callbacks.BuildableParserEndElementFieldCallback_WithClosures)
getBuildableParserEndElement s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_BuildableParserEndElementFieldCallback val'
        return val''
    return result

-- | Set the value of the “@end_element@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' buildableParser [ #endElement 'Data.GI.Base.Attributes.:=' value ]
-- @
setBuildableParserEndElement :: MonadIO m => BuildableParser -> FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback -> m ()
setBuildableParserEndElement s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)

-- | Set the value of the “@end_element@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #endElement
-- @
clearBuildableParserEndElement :: MonadIO m => BuildableParser -> m ()
clearBuildableParserEndElement s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)

#if defined(ENABLE_OVERLOADING)
data BuildableParserEndElementFieldInfo
instance AttrInfo BuildableParserEndElementFieldInfo where
    type AttrBaseTypeConstraint BuildableParserEndElementFieldInfo = (~) BuildableParser
    type AttrAllowedOps BuildableParserEndElementFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint BuildableParserEndElementFieldInfo = (~) (FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)
    type AttrTransferTypeConstraint BuildableParserEndElementFieldInfo = (~)(FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)
    type AttrTransferType BuildableParserEndElementFieldInfo = (FunPtr Gtk.Callbacks.C_BuildableParserEndElementFieldCallback)
    type AttrGetType BuildableParserEndElementFieldInfo = Maybe Gtk.Callbacks.BuildableParserEndElementFieldCallback_WithClosures
    type AttrLabel BuildableParserEndElementFieldInfo = "end_element"
    type AttrOrigin BuildableParserEndElementFieldInfo = BuildableParser
    attrGet = getBuildableParserEndElement
    attrSet = setBuildableParserEndElement
    attrConstruct = undefined
    attrClear = clearBuildableParserEndElement
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.BuildableParser.endElement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-BuildableParser.html#g:attr:endElement"
        })

buildableParser_endElement :: AttrLabelProxy "endElement"
buildableParser_endElement = AttrLabelProxy

#endif


-- | Get the value of the “@text@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' buildableParser #text
-- @
getBuildableParserText :: MonadIO m => BuildableParser -> m (Maybe Gtk.Callbacks.BuildableParserTextFieldCallback_WithClosures)
getBuildableParserText s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO (FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_BuildableParserTextFieldCallback val'
        return val''
    return result

-- | Set the value of the “@text@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' buildableParser [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setBuildableParserText :: MonadIO m => BuildableParser -> FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback -> m ()
setBuildableParserText s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)

-- | Set the value of the “@text@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearBuildableParserText :: MonadIO m => BuildableParser -> m ()
clearBuildableParserText s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)

#if defined(ENABLE_OVERLOADING)
data BuildableParserTextFieldInfo
instance AttrInfo BuildableParserTextFieldInfo where
    type AttrBaseTypeConstraint BuildableParserTextFieldInfo = (~) BuildableParser
    type AttrAllowedOps BuildableParserTextFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint BuildableParserTextFieldInfo = (~) (FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)
    type AttrTransferTypeConstraint BuildableParserTextFieldInfo = (~)(FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)
    type AttrTransferType BuildableParserTextFieldInfo = (FunPtr Gtk.Callbacks.C_BuildableParserTextFieldCallback)
    type AttrGetType BuildableParserTextFieldInfo = Maybe Gtk.Callbacks.BuildableParserTextFieldCallback_WithClosures
    type AttrLabel BuildableParserTextFieldInfo = "text"
    type AttrOrigin BuildableParserTextFieldInfo = BuildableParser
    attrGet = getBuildableParserText
    attrSet = setBuildableParserText
    attrConstruct = undefined
    attrClear = clearBuildableParserText
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.BuildableParser.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-BuildableParser.html#g:attr:text"
        })

buildableParser_text :: AttrLabelProxy "text"
buildableParser_text = AttrLabelProxy

#endif


-- | Get the value of the “@error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' buildableParser #error
-- @
getBuildableParserError :: MonadIO m => BuildableParser -> m (Maybe Gtk.Callbacks.BuildableParserErrorFieldCallback_WithClosures)
getBuildableParserError s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO (FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_BuildableParserErrorFieldCallback val'
        return val''
    return result

-- | Set the value of the “@error@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' buildableParser [ #error 'Data.GI.Base.Attributes.:=' value ]
-- @
setBuildableParserError :: MonadIO m => BuildableParser -> FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback -> m ()
setBuildableParserError s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback)

-- | Set the value of the “@error@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #error
-- @
clearBuildableParserError :: MonadIO m => BuildableParser -> m ()
clearBuildableParserError s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback)

#if defined(ENABLE_OVERLOADING)
data BuildableParserErrorFieldInfo
instance AttrInfo BuildableParserErrorFieldInfo where
    type AttrBaseTypeConstraint BuildableParserErrorFieldInfo = (~) BuildableParser
    type AttrAllowedOps BuildableParserErrorFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint BuildableParserErrorFieldInfo = (~) (FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback)
    type AttrTransferTypeConstraint BuildableParserErrorFieldInfo = (~)Gtk.Callbacks.BuildableParserErrorFieldCallback_WithClosures
    type AttrTransferType BuildableParserErrorFieldInfo = (FunPtr Gtk.Callbacks.C_BuildableParserErrorFieldCallback)
    type AttrGetType BuildableParserErrorFieldInfo = Maybe Gtk.Callbacks.BuildableParserErrorFieldCallback_WithClosures
    type AttrLabel BuildableParserErrorFieldInfo = "error"
    type AttrOrigin BuildableParserErrorFieldInfo = BuildableParser
    attrGet = getBuildableParserError
    attrSet = setBuildableParserError
    attrConstruct = undefined
    attrClear = clearBuildableParserError
    attrTransfer _ v = do
        Gtk.Callbacks.mk_BuildableParserErrorFieldCallback (Gtk.Callbacks.wrap_BuildableParserErrorFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.BuildableParser.error"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-BuildableParser.html#g:attr:error"
        })

buildableParser_error :: AttrLabelProxy "error"
buildableParser_error = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList BuildableParser
type instance O.AttributeList BuildableParser = BuildableParserAttributeList
type BuildableParserAttributeList = ('[ '("startElement", BuildableParserStartElementFieldInfo), '("endElement", BuildableParserEndElementFieldInfo), '("text", BuildableParserTextFieldInfo), '("error", BuildableParserErrorFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveBuildableParserMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveBuildableParserMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveBuildableParserMethod t BuildableParser, O.OverloadedMethod info BuildableParser p) => OL.IsLabel t (BuildableParser -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveBuildableParserMethod t BuildableParser, O.OverloadedMethod info BuildableParser p, R.HasField t BuildableParser p) => R.HasField t BuildableParser p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveBuildableParserMethod t BuildableParser, O.OverloadedMethodInfo info BuildableParser) => OL.IsLabel t (O.MethodProxy info BuildableParser) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


