{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoItem@ structure stores information about a segment of text.
-- 
-- You typically obtain @PangoItems@ by itemizing a piece of text
-- with [func/@itemize@/].

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.Item
    ( 

-- * Exported types
    Item(..)                                ,
    newZeroItem                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [applyAttrs]("GI.Pango.Structs.Item#g:method:applyAttrs"), [copy]("GI.Pango.Structs.Item#g:method:copy"), [free]("GI.Pango.Structs.Item#g:method:free"), [split]("GI.Pango.Structs.Item#g:method:split").
-- 
-- ==== Getters
-- [getCharOffset]("GI.Pango.Structs.Item#g:method:getCharOffset").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveItemMethod                       ,
#endif

-- ** applyAttrs #method:applyAttrs#

#if defined(ENABLE_OVERLOADING)
    ItemApplyAttrsMethodInfo                ,
#endif
    itemApplyAttrs                          ,


-- ** copy #method:copy#

#if defined(ENABLE_OVERLOADING)
    ItemCopyMethodInfo                      ,
#endif
    itemCopy                                ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    ItemFreeMethodInfo                      ,
#endif
    itemFree                                ,


-- ** getCharOffset #method:getCharOffset#

#if defined(ENABLE_OVERLOADING)
    ItemGetCharOffsetMethodInfo             ,
#endif
    itemGetCharOffset                       ,


-- ** new #method:new#

    itemNew                                 ,


-- ** split #method:split#

#if defined(ENABLE_OVERLOADING)
    ItemSplitMethodInfo                     ,
#endif
    itemSplit                               ,




 -- * Properties


-- ** analysis #attr:analysis#
-- | analysis results for the item.

    getItemAnalysis                         ,
#if defined(ENABLE_OVERLOADING)
    item_analysis                           ,
#endif


-- ** length #attr:length#
-- | length of this item in bytes.

    getItemLength                           ,
#if defined(ENABLE_OVERLOADING)
    item_length                             ,
#endif
    setItemLength                           ,


-- ** numChars #attr:numChars#
-- | number of Unicode characters in the item.

    getItemNumChars                         ,
#if defined(ENABLE_OVERLOADING)
    item_numChars                           ,
#endif
    setItemNumChars                         ,


-- ** offset #attr:offset#
-- | byte offset of the start of this item in text.

    getItemOffset                           ,
#if defined(ENABLE_OVERLOADING)
    item_offset                             ,
#endif
    setItemOffset                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.HarfBuzz.Structs.FeatureT as HarfBuzz.FeatureT
import qualified GI.Pango.Callbacks as Pango.Callbacks
import {-# SOURCE #-} qualified GI.Pango.Enums as Pango.Enums
import {-# SOURCE #-} qualified GI.Pango.Flags as Pango.Flags
import {-# SOURCE #-} qualified GI.Pango.Objects.Context as Pango.Context
import {-# SOURCE #-} qualified GI.Pango.Objects.Coverage as Pango.Coverage
import {-# SOURCE #-} qualified GI.Pango.Objects.Font as Pango.Font
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFace as Pango.FontFace
import {-# SOURCE #-} qualified GI.Pango.Objects.FontFamily as Pango.FontFamily
import {-# SOURCE #-} qualified GI.Pango.Objects.FontMap as Pango.FontMap
import {-# SOURCE #-} qualified GI.Pango.Objects.Fontset as Pango.Fontset
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrClass as Pango.AttrClass
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrColor as Pango.AttrColor
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFloat as Pango.AttrFloat
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontDesc as Pango.AttrFontDesc
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrFontFeatures as Pango.AttrFontFeatures
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrInt as Pango.AttrInt
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrIterator as Pango.AttrIterator
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrLanguage as Pango.AttrLanguage
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrShape as Pango.AttrShape
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrSize as Pango.AttrSize
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrString as Pango.AttrString
import {-# SOURCE #-} qualified GI.Pango.Structs.Attribute as Pango.Attribute
import {-# SOURCE #-} qualified GI.Pango.Structs.Color as Pango.Color
import {-# SOURCE #-} qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import {-# SOURCE #-} qualified GI.Pango.Structs.FontMetrics as Pango.FontMetrics
import {-# SOURCE #-} qualified GI.Pango.Structs.Language as Pango.Language
import {-# SOURCE #-} qualified GI.Pango.Structs.Matrix as Pango.Matrix
import {-# SOURCE #-} qualified GI.Pango.Structs.Rectangle as Pango.Rectangle

#else
import {-# SOURCE #-} qualified GI.Pango.Structs.Analysis as Pango.Analysis
import {-# SOURCE #-} qualified GI.Pango.Structs.AttrIterator as Pango.AttrIterator

#endif

-- | Memory-managed wrapper type.
newtype Item = Item (SP.ManagedPtr Item)
    deriving (Eq)

instance SP.ManagedPtrNewtype Item where
    toManagedPtr (Item p) = p

foreign import ccall "pango_item_get_type" c_pango_item_get_type :: 
    IO GType

type instance O.ParentTypes Item = '[]
instance O.HasParentTypes Item

instance B.Types.TypedObject Item where
    glibType = c_pango_item_get_type

instance B.Types.GBoxed Item

-- | Convert t'Item' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Item) where
    gvalueGType_ = c_pango_item_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Item)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Item)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Item ptr
        else return P.Nothing
        
    

-- | Construct a t'Item' struct initialized to zero.
newZeroItem :: MonadIO m => m Item
newZeroItem = liftIO $ callocBoxedBytes 64 >>= wrapBoxed Item

instance tag ~ 'AttrSet => Constructible Item tag where
    new _ attrs = do
        o <- newZeroItem
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' item #offset
-- @
getItemOffset :: MonadIO m => Item -> m Int32
getItemOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' item [ #offset 'Data.GI.Base.Attributes.:=' value ]
-- @
setItemOffset :: MonadIO m => Item -> Int32 -> m ()
setItemOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data ItemOffsetFieldInfo
instance AttrInfo ItemOffsetFieldInfo where
    type AttrBaseTypeConstraint ItemOffsetFieldInfo = (~) Item
    type AttrAllowedOps ItemOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ItemOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint ItemOffsetFieldInfo = (~)Int32
    type AttrTransferType ItemOffsetFieldInfo = Int32
    type AttrGetType ItemOffsetFieldInfo = Int32
    type AttrLabel ItemOffsetFieldInfo = "offset"
    type AttrOrigin ItemOffsetFieldInfo = Item
    attrGet = getItemOffset
    attrSet = setItemOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.offset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#g:attr:offset"
        })

item_offset :: AttrLabelProxy "offset"
item_offset = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' item #length
-- @
getItemLength :: MonadIO m => Item -> m Int32
getItemLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' item [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setItemLength :: MonadIO m => Item -> Int32 -> m ()
setItemLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data ItemLengthFieldInfo
instance AttrInfo ItemLengthFieldInfo where
    type AttrBaseTypeConstraint ItemLengthFieldInfo = (~) Item
    type AttrAllowedOps ItemLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ItemLengthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint ItemLengthFieldInfo = (~)Int32
    type AttrTransferType ItemLengthFieldInfo = Int32
    type AttrGetType ItemLengthFieldInfo = Int32
    type AttrLabel ItemLengthFieldInfo = "length"
    type AttrOrigin ItemLengthFieldInfo = Item
    attrGet = getItemLength
    attrSet = setItemLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#g:attr:length"
        })

item_length :: AttrLabelProxy "length"
item_length = AttrLabelProxy

#endif


-- | Get the value of the “@num_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' item #numChars
-- @
getItemNumChars :: MonadIO m => Item -> m Int32
getItemNumChars s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@num_chars@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' item [ #numChars 'Data.GI.Base.Attributes.:=' value ]
-- @
setItemNumChars :: MonadIO m => Item -> Int32 -> m ()
setItemNumChars s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data ItemNumCharsFieldInfo
instance AttrInfo ItemNumCharsFieldInfo where
    type AttrBaseTypeConstraint ItemNumCharsFieldInfo = (~) Item
    type AttrAllowedOps ItemNumCharsFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint ItemNumCharsFieldInfo = (~) Int32
    type AttrTransferTypeConstraint ItemNumCharsFieldInfo = (~)Int32
    type AttrTransferType ItemNumCharsFieldInfo = Int32
    type AttrGetType ItemNumCharsFieldInfo = Int32
    type AttrLabel ItemNumCharsFieldInfo = "num_chars"
    type AttrOrigin ItemNumCharsFieldInfo = Item
    attrGet = getItemNumChars
    attrSet = setItemNumChars
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.numChars"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#g:attr:numChars"
        })

item_numChars :: AttrLabelProxy "numChars"
item_numChars = AttrLabelProxy

#endif


-- | Get the value of the “@analysis@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' item #analysis
-- @
getItemAnalysis :: MonadIO m => Item -> m Pango.Analysis.Analysis
getItemAnalysis s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 16 :: (Ptr Pango.Analysis.Analysis)
    val' <- (newPtr Pango.Analysis.Analysis) val
    return val'

#if defined(ENABLE_OVERLOADING)
data ItemAnalysisFieldInfo
instance AttrInfo ItemAnalysisFieldInfo where
    type AttrBaseTypeConstraint ItemAnalysisFieldInfo = (~) Item
    type AttrAllowedOps ItemAnalysisFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint ItemAnalysisFieldInfo = (~) (Ptr Pango.Analysis.Analysis)
    type AttrTransferTypeConstraint ItemAnalysisFieldInfo = (~)(Ptr Pango.Analysis.Analysis)
    type AttrTransferType ItemAnalysisFieldInfo = (Ptr Pango.Analysis.Analysis)
    type AttrGetType ItemAnalysisFieldInfo = Pango.Analysis.Analysis
    type AttrLabel ItemAnalysisFieldInfo = "analysis"
    type AttrOrigin ItemAnalysisFieldInfo = Item
    attrGet = getItemAnalysis
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.analysis"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#g:attr:analysis"
        })

item_analysis :: AttrLabelProxy "analysis"
item_analysis = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Item
type instance O.AttributeList Item = ItemAttributeList
type ItemAttributeList = ('[ '("offset", ItemOffsetFieldInfo), '("length", ItemLengthFieldInfo), '("numChars", ItemNumCharsFieldInfo), '("analysis", ItemAnalysisFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Item::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Item" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_new" pango_item_new :: 
    IO (Ptr Item)

-- | Creates a new @PangoItem@ structure initialized to default values.
itemNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Item
    -- ^ __Returns:__ the newly allocated @PangoItem@, which should
    --   be freed with 'GI.Pango.Structs.Item.itemFree'.
itemNew  = liftIO $ do
    result <- pango_item_new
    checkUnexpectedReturnNULL "itemNew" result
    result' <- (wrapBoxed Item) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Item::apply_attrs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "item"
--           , argType = TInterface Name { namespace = "Pango" , name = "Item" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrIterator" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoAttrIterator`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_apply_attrs" pango_item_apply_attrs :: 
    Ptr Item ->                             -- item : TInterface (Name {namespace = "Pango", name = "Item"})
    Ptr Pango.AttrIterator.AttrIterator ->  -- iter : TInterface (Name {namespace = "Pango", name = "AttrIterator"})
    IO ()

-- | Add attributes to a @PangoItem@.
-- 
-- The idea is that you have attributes that don\'t affect itemization,
-- such as font features, so you filter them out using
-- 'GI.Pango.Structs.AttrList.attrListFilter', itemize your text, then reapply the
-- attributes to the resulting items using this function.
-- 
-- The /@iter@/ should be positioned before the range of the item,
-- and will be advanced past it. This function is meant to be called
-- in a loop over the items resulting from itemization, while passing
-- the iter to each call.
-- 
-- /Since: 1.44/
itemApplyAttrs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Item
    -- ^ /@item@/: a @PangoItem@
    -> Pango.AttrIterator.AttrIterator
    -- ^ /@iter@/: a @PangoAttrIterator@
    -> m ()
itemApplyAttrs item iter = liftIO $ do
    item' <- unsafeManagedPtrGetPtr item
    iter' <- unsafeManagedPtrGetPtr iter
    pango_item_apply_attrs item' iter'
    touchManagedPtr item
    touchManagedPtr iter
    return ()

#if defined(ENABLE_OVERLOADING)
data ItemApplyAttrsMethodInfo
instance (signature ~ (Pango.AttrIterator.AttrIterator -> m ()), MonadIO m) => O.OverloadedMethod ItemApplyAttrsMethodInfo Item signature where
    overloadedMethod = itemApplyAttrs

instance O.OverloadedMethodInfo ItemApplyAttrsMethodInfo Item where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.itemApplyAttrs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#v:itemApplyAttrs"
        })


#endif

-- method Item::copy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "item"
--           , argType = TInterface Name { namespace = "Pango" , name = "Item" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Item" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_copy" pango_item_copy :: 
    Ptr Item ->                             -- item : TInterface (Name {namespace = "Pango", name = "Item"})
    IO (Ptr Item)

-- | Copy an existing @PangoItem@ structure.
itemCopy ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Item)
    -- ^ /@item@/: a @PangoItem@
    -> m (Maybe Item)
    -- ^ __Returns:__ the newly allocated @PangoItem@
itemCopy item = liftIO $ do
    maybeItem <- case item of
        Nothing -> return FP.nullPtr
        Just jItem -> do
            jItem' <- unsafeManagedPtrGetPtr jItem
            return jItem'
    result <- pango_item_copy maybeItem
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Item) result'
        return result''
    whenJust item touchManagedPtr
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ItemCopyMethodInfo
instance (signature ~ (m (Maybe Item)), MonadIO m) => O.OverloadedMethod ItemCopyMethodInfo Item signature where
    overloadedMethod i = itemCopy (Just i)

instance O.OverloadedMethodInfo ItemCopyMethodInfo Item where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.itemCopy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#v:itemCopy"
        })


#endif

-- method Item::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "item"
--           , argType = TInterface Name { namespace = "Pango" , name = "Item" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`, may be %NULL"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_free" pango_item_free :: 
    Ptr Item ->                             -- item : TInterface (Name {namespace = "Pango", name = "Item"})
    IO ()

-- | Free a @PangoItem@ and all associated memory.
itemFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (Item)
    -- ^ /@item@/: a @PangoItem@, may be 'P.Nothing'
    -> m ()
itemFree item = liftIO $ do
    maybeItem <- case item of
        Nothing -> return FP.nullPtr
        Just jItem -> do
            jItem' <- unsafeManagedPtrGetPtr jItem
            return jItem'
    pango_item_free maybeItem
    whenJust item touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ItemFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ItemFreeMethodInfo Item signature where
    overloadedMethod i = itemFree (Just i)

instance O.OverloadedMethodInfo ItemFreeMethodInfo Item where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.itemFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#v:itemFree"
        })


#endif

-- method Item::get_char_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "item"
--           , argType = TInterface Name { namespace = "Pango" , name = "Item" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_get_char_offset" pango_item_get_char_offset :: 
    Ptr Item ->                             -- item : TInterface (Name {namespace = "Pango", name = "Item"})
    IO Int32

-- | Returns the character offset of the item from the beginning
-- of the itemized text.
-- 
-- If the item has not been obtained from Pango\'s itemization
-- machinery, then the character offset is not available. In
-- that case, this function returns -1.
-- 
-- /Since: 1.54/
itemGetCharOffset ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Item
    -- ^ /@item@/: a @PangoItem@
    -> m Int32
    -- ^ __Returns:__ the character offset of the item from the beginning
    --   of the itemized text, or -1
itemGetCharOffset item = liftIO $ do
    item' <- unsafeManagedPtrGetPtr item
    result <- pango_item_get_char_offset item'
    touchManagedPtr item
    return result

#if defined(ENABLE_OVERLOADING)
data ItemGetCharOffsetMethodInfo
instance (signature ~ (m Int32), MonadIO m) => O.OverloadedMethod ItemGetCharOffsetMethodInfo Item signature where
    overloadedMethod = itemGetCharOffset

instance O.OverloadedMethodInfo ItemGetCharOffsetMethodInfo Item where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.itemGetCharOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#v:itemGetCharOffset"
        })


#endif

-- method Item::split
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "orig"
--           , argType = TInterface Name { namespace = "Pango" , name = "Item" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoItem`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "split_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "byte index of position to split item, relative to the\n  start of the item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "split_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "number of chars between start of @orig and @split_index"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Item" })
-- throws : False
-- Skip return : False

foreign import ccall "pango_item_split" pango_item_split :: 
    Ptr Item ->                             -- orig : TInterface (Name {namespace = "Pango", name = "Item"})
    Int32 ->                                -- split_index : TBasicType TInt
    Int32 ->                                -- split_offset : TBasicType TInt
    IO (Ptr Item)

-- | Modifies /@orig@/ to cover only the text after /@splitIndex@/, and
-- returns a new item that covers the text before /@splitIndex@/ that
-- used to be in /@orig@/.
-- 
-- You can think of /@splitIndex@/ as the length of the returned item.
-- /@splitIndex@/ may not be 0, and it may not be greater than or equal
-- to the length of /@orig@/ (that is, there must be at least one byte
-- assigned to each item, you can\'t create a zero-length item).
-- /@splitOffset@/ is the length of the first item in chars, and must be
-- provided because the text used to generate the item isn\'t available,
-- so @pango_item_split()@ can\'t count the char length of the split items
-- itself.
itemSplit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Item
    -- ^ /@orig@/: a @PangoItem@
    -> Int32
    -- ^ /@splitIndex@/: byte index of position to split item, relative to the
    --   start of the item
    -> Int32
    -- ^ /@splitOffset@/: number of chars between start of /@orig@/ and /@splitIndex@/
    -> m Item
    -- ^ __Returns:__ new item representing text before /@splitIndex@/, which
    --   should be freed with 'GI.Pango.Structs.Item.itemFree'.
itemSplit orig splitIndex splitOffset = liftIO $ do
    orig' <- unsafeManagedPtrGetPtr orig
    result <- pango_item_split orig' splitIndex splitOffset
    checkUnexpectedReturnNULL "itemSplit" result
    result' <- (wrapBoxed Item) result
    touchManagedPtr orig
    return result'

#if defined(ENABLE_OVERLOADING)
data ItemSplitMethodInfo
instance (signature ~ (Int32 -> Int32 -> m Item), MonadIO m) => O.OverloadedMethod ItemSplitMethodInfo Item signature where
    overloadedMethod = itemSplit

instance O.OverloadedMethodInfo ItemSplitMethodInfo Item where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.Item.itemSplit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-Item.html#v:itemSplit"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveItemMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveItemMethod "applyAttrs" o = ItemApplyAttrsMethodInfo
    ResolveItemMethod "copy" o = ItemCopyMethodInfo
    ResolveItemMethod "free" o = ItemFreeMethodInfo
    ResolveItemMethod "split" o = ItemSplitMethodInfo
    ResolveItemMethod "getCharOffset" o = ItemGetCharOffsetMethodInfo
    ResolveItemMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveItemMethod t Item, O.OverloadedMethod info Item p) => OL.IsLabel t (Item -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveItemMethod t Item, O.OverloadedMethod info Item p, R.HasField t Item p) => R.HasField t Item p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveItemMethod t Item, O.OverloadedMethodInfo info Item) => OL.IsLabel t (O.MethodProxy info Item) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


