// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.30.0
// 	protoc        v5.29.3
// source: envoy/extensions/filters/http/oauth2/v3/oauth.proto

package oauth2v3

import (
	_ "github.com/cncf/xds/go/udpa/annotations"
	v31 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
	v33 "github.com/envoyproxy/go-control-plane/envoy/config/route/v3"
	v3 "github.com/envoyproxy/go-control-plane/envoy/extensions/transport_sockets/tls/v3"
	v32 "github.com/envoyproxy/go-control-plane/envoy/type/matcher/v3"
	_ "github.com/envoyproxy/protoc-gen-validate/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CookieConfig_SameSite int32

const (
	CookieConfig_DISABLED CookieConfig_SameSite = 0
	CookieConfig_STRICT   CookieConfig_SameSite = 1
	CookieConfig_LAX      CookieConfig_SameSite = 2
	CookieConfig_NONE     CookieConfig_SameSite = 3
)

// Enum value maps for CookieConfig_SameSite.
var (
	CookieConfig_SameSite_name = map[int32]string{
		0: "DISABLED",
		1: "STRICT",
		2: "LAX",
		3: "NONE",
	}
	CookieConfig_SameSite_value = map[string]int32{
		"DISABLED": 0,
		"STRICT":   1,
		"LAX":      2,
		"NONE":     3,
	}
)

func (x CookieConfig_SameSite) Enum() *CookieConfig_SameSite {
	p := new(CookieConfig_SameSite)
	*p = x
	return p
}

func (x CookieConfig_SameSite) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CookieConfig_SameSite) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes[0].Descriptor()
}

func (CookieConfig_SameSite) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes[0]
}

func (x CookieConfig_SameSite) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CookieConfig_SameSite.Descriptor instead.
func (CookieConfig_SameSite) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{0, 0}
}

type OAuth2Config_AuthType int32

const (
	// The “client_id“ and “client_secret“ will be sent in the URL encoded request body.
	// This type should only be used when Auth server does not support Basic authentication.
	OAuth2Config_URL_ENCODED_BODY OAuth2Config_AuthType = 0
	// The “client_id“ and “client_secret“ will be sent using HTTP Basic authentication scheme.
	OAuth2Config_BASIC_AUTH OAuth2Config_AuthType = 1
)

// Enum value maps for OAuth2Config_AuthType.
var (
	OAuth2Config_AuthType_name = map[int32]string{
		0: "URL_ENCODED_BODY",
		1: "BASIC_AUTH",
	}
	OAuth2Config_AuthType_value = map[string]int32{
		"URL_ENCODED_BODY": 0,
		"BASIC_AUTH":       1,
	}
)

func (x OAuth2Config_AuthType) Enum() *OAuth2Config_AuthType {
	p := new(OAuth2Config_AuthType)
	*p = x
	return p
}

func (x OAuth2Config_AuthType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OAuth2Config_AuthType) Descriptor() protoreflect.EnumDescriptor {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes[1].Descriptor()
}

func (OAuth2Config_AuthType) Type() protoreflect.EnumType {
	return &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes[1]
}

func (x OAuth2Config_AuthType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OAuth2Config_AuthType.Descriptor instead.
func (OAuth2Config_AuthType) EnumDescriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{3, 0}
}

// OAuth cookie configuration attributes.
type CookieConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The value used for the SameSite cookie attribute.
	SameSite CookieConfig_SameSite `protobuf:"varint,1,opt,name=same_site,json=sameSite,proto3,enum=envoy.extensions.filters.http.oauth2.v3.CookieConfig_SameSite" json:"same_site,omitempty"`
}

func (x *CookieConfig) Reset() {
	*x = CookieConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookieConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookieConfig) ProtoMessage() {}

func (x *CookieConfig) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookieConfig.ProtoReflect.Descriptor instead.
func (*CookieConfig) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{0}
}

func (x *CookieConfig) GetSameSite() CookieConfig_SameSite {
	if x != nil {
		return x.SameSite
	}
	return CookieConfig_DISABLED
}

// [#next-free-field: 8]
type CookieConfigs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration for the bearer token cookie.
	BearerTokenCookieConfig *CookieConfig `protobuf:"bytes,1,opt,name=bearer_token_cookie_config,json=bearerTokenCookieConfig,proto3" json:"bearer_token_cookie_config,omitempty"`
	// Configuration for the OAuth HMAC cookie.
	OauthHmacCookieConfig *CookieConfig `protobuf:"bytes,2,opt,name=oauth_hmac_cookie_config,json=oauthHmacCookieConfig,proto3" json:"oauth_hmac_cookie_config,omitempty"`
	// Configuration for the OAuth expires cookie.
	OauthExpiresCookieConfig *CookieConfig `protobuf:"bytes,3,opt,name=oauth_expires_cookie_config,json=oauthExpiresCookieConfig,proto3" json:"oauth_expires_cookie_config,omitempty"`
	// Configuration for the ID token cookie.
	IdTokenCookieConfig *CookieConfig `protobuf:"bytes,4,opt,name=id_token_cookie_config,json=idTokenCookieConfig,proto3" json:"id_token_cookie_config,omitempty"`
	// Configuration for the refresh token cookie.
	RefreshTokenCookieConfig *CookieConfig `protobuf:"bytes,5,opt,name=refresh_token_cookie_config,json=refreshTokenCookieConfig,proto3" json:"refresh_token_cookie_config,omitempty"`
	// Configuration for the OAuth nonce cookie.
	OauthNonceCookieConfig *CookieConfig `protobuf:"bytes,6,opt,name=oauth_nonce_cookie_config,json=oauthNonceCookieConfig,proto3" json:"oauth_nonce_cookie_config,omitempty"`
	// Configuration for the code verifier cookie.
	CodeVerifierCookieConfig *CookieConfig `protobuf:"bytes,7,opt,name=code_verifier_cookie_config,json=codeVerifierCookieConfig,proto3" json:"code_verifier_cookie_config,omitempty"`
}

func (x *CookieConfigs) Reset() {
	*x = CookieConfigs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CookieConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CookieConfigs) ProtoMessage() {}

func (x *CookieConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CookieConfigs.ProtoReflect.Descriptor instead.
func (*CookieConfigs) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{1}
}

func (x *CookieConfigs) GetBearerTokenCookieConfig() *CookieConfig {
	if x != nil {
		return x.BearerTokenCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetOauthHmacCookieConfig() *CookieConfig {
	if x != nil {
		return x.OauthHmacCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetOauthExpiresCookieConfig() *CookieConfig {
	if x != nil {
		return x.OauthExpiresCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetIdTokenCookieConfig() *CookieConfig {
	if x != nil {
		return x.IdTokenCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetRefreshTokenCookieConfig() *CookieConfig {
	if x != nil {
		return x.RefreshTokenCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetOauthNonceCookieConfig() *CookieConfig {
	if x != nil {
		return x.OauthNonceCookieConfig
	}
	return nil
}

func (x *CookieConfigs) GetCodeVerifierCookieConfig() *CookieConfig {
	if x != nil {
		return x.CodeVerifierCookieConfig
	}
	return nil
}

// [#next-free-field: 6]
type OAuth2Credentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The client_id to be used in the authorize calls. This value will be URL encoded when sent to the OAuth server.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// The secret used to retrieve the access token. This value will be URL encoded when sent to the OAuth server.
	TokenSecret *v3.SdsSecretConfig `protobuf:"bytes,2,opt,name=token_secret,json=tokenSecret,proto3" json:"token_secret,omitempty"`
	// Configures how the secret token should be created.
	//
	// Types that are assignable to TokenFormation:
	//
	//	*OAuth2Credentials_HmacSecret
	TokenFormation isOAuth2Credentials_TokenFormation `protobuf_oneof:"token_formation"`
	// The cookie names used in OAuth filters flow.
	CookieNames *OAuth2Credentials_CookieNames `protobuf:"bytes,4,opt,name=cookie_names,json=cookieNames,proto3" json:"cookie_names,omitempty"`
	// The domain to set the cookie on. If not set, the cookie will default to the host of the request, not including the subdomains.
	// This is useful when token cookies need to be shared across multiple subdomains.
	CookieDomain string `protobuf:"bytes,5,opt,name=cookie_domain,json=cookieDomain,proto3" json:"cookie_domain,omitempty"`
}

func (x *OAuth2Credentials) Reset() {
	*x = OAuth2Credentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuth2Credentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuth2Credentials) ProtoMessage() {}

func (x *OAuth2Credentials) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuth2Credentials.ProtoReflect.Descriptor instead.
func (*OAuth2Credentials) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{2}
}

func (x *OAuth2Credentials) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *OAuth2Credentials) GetTokenSecret() *v3.SdsSecretConfig {
	if x != nil {
		return x.TokenSecret
	}
	return nil
}

func (m *OAuth2Credentials) GetTokenFormation() isOAuth2Credentials_TokenFormation {
	if m != nil {
		return m.TokenFormation
	}
	return nil
}

func (x *OAuth2Credentials) GetHmacSecret() *v3.SdsSecretConfig {
	if x, ok := x.GetTokenFormation().(*OAuth2Credentials_HmacSecret); ok {
		return x.HmacSecret
	}
	return nil
}

func (x *OAuth2Credentials) GetCookieNames() *OAuth2Credentials_CookieNames {
	if x != nil {
		return x.CookieNames
	}
	return nil
}

func (x *OAuth2Credentials) GetCookieDomain() string {
	if x != nil {
		return x.CookieDomain
	}
	return ""
}

type isOAuth2Credentials_TokenFormation interface {
	isOAuth2Credentials_TokenFormation()
}

type OAuth2Credentials_HmacSecret struct {
	// If present, the secret token will be a HMAC using the provided secret.
	HmacSecret *v3.SdsSecretConfig `protobuf:"bytes,3,opt,name=hmac_secret,json=hmacSecret,proto3,oneof"`
}

func (*OAuth2Credentials_HmacSecret) isOAuth2Credentials_TokenFormation() {}

// OAuth config
//
// [#next-free-field: 27]
type OAuth2Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoint on the authorization server to retrieve the access token from.
	TokenEndpoint *v31.HttpUri `protobuf:"bytes,1,opt,name=token_endpoint,json=tokenEndpoint,proto3" json:"token_endpoint,omitempty"`
	// Specifies the retry policy for requests to the OAuth server. If not specified, then no retries will be performed.
	RetryPolicy *v31.RetryPolicy `protobuf:"bytes,18,opt,name=retry_policy,json=retryPolicy,proto3" json:"retry_policy,omitempty"`
	// The endpoint redirect to for authorization in response to unauthorized requests.
	AuthorizationEndpoint string `protobuf:"bytes,2,opt,name=authorization_endpoint,json=authorizationEndpoint,proto3" json:"authorization_endpoint,omitempty"`
	// The endpoint at the authorization server to request the user be logged out of the Authorization server.
	// This field is optional and should be set only if openid is in the auth_scopes and the authorization server
	// supports the OpenID Connect RP-Initiated Logout specification.
	// For more information, see https://openid.net/specs/openid-connect-rpinitiated-1_0.html
	//
	// If configured, the OAuth2 filter will redirect users to this endpoint when they access the signout_path.
	EndSessionEndpoint string `protobuf:"bytes,23,opt,name=end_session_endpoint,json=endSessionEndpoint,proto3" json:"end_session_endpoint,omitempty"`
	// Credentials used for OAuth.
	Credentials *OAuth2Credentials `protobuf:"bytes,3,opt,name=credentials,proto3" json:"credentials,omitempty"`
	// The redirect URI passed to the authorization endpoint. Supports header formatting
	// tokens. For more information, including details on header value syntax, see the
	// documentation on :ref:`custom request headers <config_http_conn_man_headers_custom_request_headers>`.
	//
	// This URI should not contain any query parameters.
	RedirectUri string `protobuf:"bytes,4,opt,name=redirect_uri,json=redirectUri,proto3" json:"redirect_uri,omitempty"`
	// Matching criteria used to determine whether a path appears to be the result of a redirect from the authorization server.
	RedirectPathMatcher *v32.PathMatcher `protobuf:"bytes,5,opt,name=redirect_path_matcher,json=redirectPathMatcher,proto3" json:"redirect_path_matcher,omitempty"`
	// The path to sign a user out, clearing their credential cookies.
	SignoutPath *v32.PathMatcher `protobuf:"bytes,6,opt,name=signout_path,json=signoutPath,proto3" json:"signout_path,omitempty"`
	// Forward the OAuth token as a Bearer to upstream web service.
	ForwardBearerToken bool `protobuf:"varint,7,opt,name=forward_bearer_token,json=forwardBearerToken,proto3" json:"forward_bearer_token,omitempty"`
	// If set to true, preserve the existing authorization header.
	// By default the client strips the existing authorization header before forwarding upstream.
	// Can not be set to true if forward_bearer_token is already set to true.
	// Default value is false.
	PreserveAuthorizationHeader bool `protobuf:"varint,16,opt,name=preserve_authorization_header,json=preserveAuthorizationHeader,proto3" json:"preserve_authorization_header,omitempty"`
	// Any request that matches any of the provided matchers will be passed through without OAuth validation.
	PassThroughMatcher []*v33.HeaderMatcher `protobuf:"bytes,8,rep,name=pass_through_matcher,json=passThroughMatcher,proto3" json:"pass_through_matcher,omitempty"`
	// Optional list of OAuth scopes to be claimed in the authorization request. If not specified,
	// defaults to "user" scope.
	// OAuth RFC https://tools.ietf.org/html/rfc6749#section-3.3
	AuthScopes []string `protobuf:"bytes,9,rep,name=auth_scopes,json=authScopes,proto3" json:"auth_scopes,omitempty"`
	// Optional resource parameter for authorization request
	// RFC: https://tools.ietf.org/html/rfc8707
	Resources []string `protobuf:"bytes,10,rep,name=resources,proto3" json:"resources,omitempty"`
	// Defines how “client_id“ and “client_secret“ are sent in OAuth client to OAuth server requests.
	// RFC https://datatracker.ietf.org/doc/html/rfc6749#section-2.3.1
	AuthType OAuth2Config_AuthType `protobuf:"varint,11,opt,name=auth_type,json=authType,proto3,enum=envoy.extensions.filters.http.oauth2.v3.OAuth2Config_AuthType" json:"auth_type,omitempty"`
	// If set to true, allows automatic access token refresh using the associated refresh token (see
	// `RFC 6749 section 6 <https://datatracker.ietf.org/doc/html/rfc6749#section-6>`_), provided that the OAuth server supports that.
	// Default value is true.
	UseRefreshToken *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=use_refresh_token,json=useRefreshToken,proto3" json:"use_refresh_token,omitempty"`
	// The default lifetime in seconds of the access token, if omitted by the authorization server.
	//
	// If this value is not set, it will default to “0s“. In this case, the expiry must be set by
	// the authorization server or the OAuth flow will fail.
	DefaultExpiresIn *durationpb.Duration `protobuf:"bytes,13,opt,name=default_expires_in,json=defaultExpiresIn,proto3" json:"default_expires_in,omitempty"`
	// Any request that matches any of the provided matchers won't be redirected to OAuth server when tokens are not valid.
	// Automatic access token refresh will be performed for these requests, if enabled.
	// This behavior can be useful for AJAX requests.
	DenyRedirectMatcher []*v33.HeaderMatcher `protobuf:"bytes,14,rep,name=deny_redirect_matcher,json=denyRedirectMatcher,proto3" json:"deny_redirect_matcher,omitempty"`
	// The default lifetime in seconds of the refresh token, if the exp (expiration time) claim is omitted in the refresh token or the refresh token is not JWT.
	//
	// If this value is not set, it will default to “604800s“. In this case, the cookie with the refresh token will be expired
	// in a week.
	// This setting is only considered if “use_refresh_token“ is set to true, otherwise the authorization server expiration or “default_expires_in“ is used.
	DefaultRefreshTokenExpiresIn *durationpb.Duration `protobuf:"bytes,15,opt,name=default_refresh_token_expires_in,json=defaultRefreshTokenExpiresIn,proto3" json:"default_refresh_token_expires_in,omitempty"`
	// If set to true, the client will not set a cookie for ID Token even if one is received from the Identity Provider. This may be useful in cases where the ID
	// Token is too large for HTTP cookies (longer than 4096 characters). Enabling this option will only disable setting the cookie response header, the filter
	// will still process incoming ID Tokens as part of the HMAC if they are there. This is to ensure compatibility while switching this setting on. Future
	// sessions would not set the IdToken cookie header.
	DisableIdTokenSetCookie bool `protobuf:"varint,17,opt,name=disable_id_token_set_cookie,json=disableIdTokenSetCookie,proto3" json:"disable_id_token_set_cookie,omitempty"`
	// If set to true, the client will not set a cookie for Access Token even if one is received from the Identity Provider.
	// Enabling this option will only disable setting the cookie response header, the filter
	// will still process incoming Access Tokens as part of the HMAC if they are there. This is to ensure compatibility while switching this setting on. Future
	// sessions would not set the Access Token cookie header.
	DisableAccessTokenSetCookie bool `protobuf:"varint,19,opt,name=disable_access_token_set_cookie,json=disableAccessTokenSetCookie,proto3" json:"disable_access_token_set_cookie,omitempty"`
	// If set to true, the client will not set a cookie for Refresh Token even if one is received from the Identity Provider.
	// Enabling this option will only disable setting the cookie response header, the filter
	// will still process incoming Refresh Tokens as part of the HMAC if they are there. This is to ensure compatibility while switching this setting on. Future
	// sessions would not set the Refresh Token cookie header.
	DisableRefreshTokenSetCookie bool `protobuf:"varint,20,opt,name=disable_refresh_token_set_cookie,json=disableRefreshTokenSetCookie,proto3" json:"disable_refresh_token_set_cookie,omitempty"`
	// Controls for attributes that can be set on the cookies.
	CookieConfigs *CookieConfigs `protobuf:"bytes,21,opt,name=cookie_configs,json=cookieConfigs,proto3" json:"cookie_configs,omitempty"`
	// Optional additional prefix to use when emitting statistics.
	StatPrefix string `protobuf:"bytes,22,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Optional expiration time for the CSRF protection token cookie.
	// The CSRF token prevents cross-site request forgery attacks during the OAuth2 flow.
	// If not specified, defaults to “600s“ (10 minutes), which should provide sufficient time
	// for users to complete the OAuth2 authorization flow.
	CsrfTokenExpiresIn *durationpb.Duration `protobuf:"bytes,24,opt,name=csrf_token_expires_in,json=csrfTokenExpiresIn,proto3" json:"csrf_token_expires_in,omitempty"`
	// Optional expiration time for the code verifier cookie.
	// The code verifier is stored in a secure, HTTP-only cookie during the OAuth2 authorization process.
	// If not specified, defaults to “600s“ (10 minutes), which should provide sufficient time
	// for users to complete the OAuth2 authorization flow.
	CodeVerifierTokenExpiresIn *durationpb.Duration `protobuf:"bytes,25,opt,name=code_verifier_token_expires_in,json=codeVerifierTokenExpiresIn,proto3" json:"code_verifier_token_expires_in,omitempty"`
	// Disable token encryption. When set to true, both the access token and the ID token will be stored in plain text.
	// This option should only be used in secure environments where token encryption is not required.
	// Default is false (tokens are encrypted).
	DisableTokenEncryption bool `protobuf:"varint,26,opt,name=disable_token_encryption,json=disableTokenEncryption,proto3" json:"disable_token_encryption,omitempty"`
}

func (x *OAuth2Config) Reset() {
	*x = OAuth2Config{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuth2Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuth2Config) ProtoMessage() {}

func (x *OAuth2Config) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuth2Config.ProtoReflect.Descriptor instead.
func (*OAuth2Config) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{3}
}

func (x *OAuth2Config) GetTokenEndpoint() *v31.HttpUri {
	if x != nil {
		return x.TokenEndpoint
	}
	return nil
}

func (x *OAuth2Config) GetRetryPolicy() *v31.RetryPolicy {
	if x != nil {
		return x.RetryPolicy
	}
	return nil
}

func (x *OAuth2Config) GetAuthorizationEndpoint() string {
	if x != nil {
		return x.AuthorizationEndpoint
	}
	return ""
}

func (x *OAuth2Config) GetEndSessionEndpoint() string {
	if x != nil {
		return x.EndSessionEndpoint
	}
	return ""
}

func (x *OAuth2Config) GetCredentials() *OAuth2Credentials {
	if x != nil {
		return x.Credentials
	}
	return nil
}

func (x *OAuth2Config) GetRedirectUri() string {
	if x != nil {
		return x.RedirectUri
	}
	return ""
}

func (x *OAuth2Config) GetRedirectPathMatcher() *v32.PathMatcher {
	if x != nil {
		return x.RedirectPathMatcher
	}
	return nil
}

func (x *OAuth2Config) GetSignoutPath() *v32.PathMatcher {
	if x != nil {
		return x.SignoutPath
	}
	return nil
}

func (x *OAuth2Config) GetForwardBearerToken() bool {
	if x != nil {
		return x.ForwardBearerToken
	}
	return false
}

func (x *OAuth2Config) GetPreserveAuthorizationHeader() bool {
	if x != nil {
		return x.PreserveAuthorizationHeader
	}
	return false
}

func (x *OAuth2Config) GetPassThroughMatcher() []*v33.HeaderMatcher {
	if x != nil {
		return x.PassThroughMatcher
	}
	return nil
}

func (x *OAuth2Config) GetAuthScopes() []string {
	if x != nil {
		return x.AuthScopes
	}
	return nil
}

func (x *OAuth2Config) GetResources() []string {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *OAuth2Config) GetAuthType() OAuth2Config_AuthType {
	if x != nil {
		return x.AuthType
	}
	return OAuth2Config_URL_ENCODED_BODY
}

func (x *OAuth2Config) GetUseRefreshToken() *wrapperspb.BoolValue {
	if x != nil {
		return x.UseRefreshToken
	}
	return nil
}

func (x *OAuth2Config) GetDefaultExpiresIn() *durationpb.Duration {
	if x != nil {
		return x.DefaultExpiresIn
	}
	return nil
}

func (x *OAuth2Config) GetDenyRedirectMatcher() []*v33.HeaderMatcher {
	if x != nil {
		return x.DenyRedirectMatcher
	}
	return nil
}

func (x *OAuth2Config) GetDefaultRefreshTokenExpiresIn() *durationpb.Duration {
	if x != nil {
		return x.DefaultRefreshTokenExpiresIn
	}
	return nil
}

func (x *OAuth2Config) GetDisableIdTokenSetCookie() bool {
	if x != nil {
		return x.DisableIdTokenSetCookie
	}
	return false
}

func (x *OAuth2Config) GetDisableAccessTokenSetCookie() bool {
	if x != nil {
		return x.DisableAccessTokenSetCookie
	}
	return false
}

func (x *OAuth2Config) GetDisableRefreshTokenSetCookie() bool {
	if x != nil {
		return x.DisableRefreshTokenSetCookie
	}
	return false
}

func (x *OAuth2Config) GetCookieConfigs() *CookieConfigs {
	if x != nil {
		return x.CookieConfigs
	}
	return nil
}

func (x *OAuth2Config) GetStatPrefix() string {
	if x != nil {
		return x.StatPrefix
	}
	return ""
}

func (x *OAuth2Config) GetCsrfTokenExpiresIn() *durationpb.Duration {
	if x != nil {
		return x.CsrfTokenExpiresIn
	}
	return nil
}

func (x *OAuth2Config) GetCodeVerifierTokenExpiresIn() *durationpb.Duration {
	if x != nil {
		return x.CodeVerifierTokenExpiresIn
	}
	return nil
}

func (x *OAuth2Config) GetDisableTokenEncryption() bool {
	if x != nil {
		return x.DisableTokenEncryption
	}
	return false
}

// Filter config.
type OAuth2 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Leave this empty to disable OAuth2 for a specific route, using per filter config.
	Config *OAuth2Config `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
}

func (x *OAuth2) Reset() {
	*x = OAuth2{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuth2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuth2) ProtoMessage() {}

func (x *OAuth2) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuth2.ProtoReflect.Descriptor instead.
func (*OAuth2) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{4}
}

func (x *OAuth2) GetConfig() *OAuth2Config {
	if x != nil {
		return x.Config
	}
	return nil
}

// [#next-free-field: 8]
type OAuth2Credentials_CookieNames struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cookie name to hold OAuth bearer token value. When the authentication server validates the
	// client and returns an authorization token back to the OAuth filter, no matter what format
	// that token is, if :ref:`forward_bearer_token <envoy_v3_api_field_extensions.filters.http.oauth2.v3.OAuth2Config.forward_bearer_token>`
	// is set to true the filter will send over the bearer token as a cookie with this name to the
	// upstream. Defaults to “BearerToken“.
	BearerToken string `protobuf:"bytes,1,opt,name=bearer_token,json=bearerToken,proto3" json:"bearer_token,omitempty"`
	// Cookie name to hold OAuth HMAC value. Defaults to “OauthHMAC“.
	OauthHmac string `protobuf:"bytes,2,opt,name=oauth_hmac,json=oauthHmac,proto3" json:"oauth_hmac,omitempty"`
	// Cookie name to hold OAuth expiry value. Defaults to “OauthExpires“.
	OauthExpires string `protobuf:"bytes,3,opt,name=oauth_expires,json=oauthExpires,proto3" json:"oauth_expires,omitempty"`
	// Cookie name to hold the id token. Defaults to “IdToken“.
	IdToken string `protobuf:"bytes,4,opt,name=id_token,json=idToken,proto3" json:"id_token,omitempty"`
	// Cookie name to hold the refresh token. Defaults to “RefreshToken“.
	RefreshToken string `protobuf:"bytes,5,opt,name=refresh_token,json=refreshToken,proto3" json:"refresh_token,omitempty"`
	// Cookie name to hold the nonce value. Defaults to “OauthNonce“.
	OauthNonce string `protobuf:"bytes,6,opt,name=oauth_nonce,json=oauthNonce,proto3" json:"oauth_nonce,omitempty"`
	// Cookie name to hold the PKCE code verifier. Defaults to “OauthCodeVerifier“.
	CodeVerifier string `protobuf:"bytes,7,opt,name=code_verifier,json=codeVerifier,proto3" json:"code_verifier,omitempty"`
}

func (x *OAuth2Credentials_CookieNames) Reset() {
	*x = OAuth2Credentials_CookieNames{}
	if protoimpl.UnsafeEnabled {
		mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OAuth2Credentials_CookieNames) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OAuth2Credentials_CookieNames) ProtoMessage() {}

func (x *OAuth2Credentials_CookieNames) ProtoReflect() protoreflect.Message {
	mi := &file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OAuth2Credentials_CookieNames.ProtoReflect.Descriptor instead.
func (*OAuth2Credentials_CookieNames) Descriptor() ([]byte, []int) {
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP(), []int{2, 0}
}

func (x *OAuth2Credentials_CookieNames) GetBearerToken() string {
	if x != nil {
		return x.BearerToken
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetOauthHmac() string {
	if x != nil {
		return x.OauthHmac
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetOauthExpires() string {
	if x != nil {
		return x.OauthExpires
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetIdToken() string {
	if x != nil {
		return x.IdToken
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetRefreshToken() string {
	if x != nil {
		return x.RefreshToken
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetOauthNonce() string {
	if x != nil {
		return x.OauthNonce
	}
	return ""
}

func (x *OAuth2Credentials_CookieNames) GetCodeVerifier() string {
	if x != nil {
		return x.CodeVerifier
	}
	return ""
}

var File_envoy_extensions_filters_http_oauth2_v3_oauth_proto protoreflect.FileDescriptor

var file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDesc = []byte{
	0x0a, 0x33, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2f, 0x76, 0x33, 0x2f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e,
	0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x1a, 0x1f,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x33, 0x2f, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x63, 0x6f,
	0x72, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2f, 0x76, 0x33, 0x2f, 0x72, 0x6f, 0x75, 0x74,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x36, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73,
	0x6f, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2f, 0x74, 0x6c, 0x73, 0x2f, 0x76, 0x33, 0x2f, 0x73, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76,
	0x33, 0x2f, 0x70, 0x61, 0x74, 0x68, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x75, 0x64,
	0x70, 0x61, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xae, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x09, 0x73, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x69,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79,
	0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e,
	0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x53, 0x61, 0x6d, 0x65, 0x53, 0x69, 0x74, 0x65, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x08, 0x73, 0x61, 0x6d, 0x65, 0x53, 0x69, 0x74, 0x65, 0x22, 0x37, 0x0a, 0x08,
	0x53, 0x61, 0x6d, 0x65, 0x53, 0x69, 0x74, 0x65, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41,
	0x42, 0x4c, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x41, 0x58, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4e,
	0x4f, 0x4e, 0x45, 0x10, 0x03, 0x22, 0xb3, 0x06, 0x0a, 0x0d, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x72, 0x0a, 0x1a, 0x62, 0x65, 0x61, 0x72, 0x65,
	0x72, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x17, 0x62, 0x65, 0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x18, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x48, 0x6d, 0x61, 0x63, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x1b, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x73, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x6a, 0x0a, 0x16, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x13, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a,
	0x1b, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x18, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x70, 0x0a, 0x19, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6e, 0x6f, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33,
	0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x16, 0x6f,
	0x61, 0x75, 0x74, 0x68, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x74, 0x0a, 0x1b, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76,
	0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68,
	0x32, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x18, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8b, 0x06, 0x0a, 0x11,
	0x4f, 0x41, 0x75, 0x74, 0x68, 0x32, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x24, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52, 0x08, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x2e, 0x74, 0x6c, 0x73, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x64, 0x73, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x12, 0x67, 0x0a, 0x0b, 0x68, 0x6d, 0x61, 0x63, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f,
	0x72, 0x74, 0x5f, 0x73, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x2e, 0x74, 0x6c, 0x73, 0x2e, 0x76,
	0x33, 0x2e, 0x53, 0x64, 0x73, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x68,
	0x6d, 0x61, 0x63, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12, 0x69, 0x0a, 0x0c, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x46, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x32,
	0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x2e, 0x43, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x0b, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x64,
	0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6f,
	0x6b, 0x69, 0x65, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x1a, 0xd5, 0x02, 0x0a, 0x0b, 0x43, 0x6f,
	0x6f, 0x6b, 0x69, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x0c, 0x62, 0x65, 0x61,
	0x72, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0xc0, 0x01, 0x01, 0x52, 0x0b, 0x62, 0x65,
	0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x0a, 0x6f, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x68, 0x6d, 0x61, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa,
	0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0xc0, 0x01, 0x01, 0x52, 0x09, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x48, 0x6d, 0x61, 0x63, 0x12, 0x30, 0x0a, 0x0d, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42,
	0x08, 0x72, 0x06, 0xd0, 0x01, 0x01, 0xc0, 0x01, 0x01, 0x52, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68,
	0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x08, 0x69, 0x64, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06,
	0xd0, 0x01, 0x01, 0xc0, 0x01, 0x01, 0x52, 0x07, 0x69, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x30, 0x0a, 0x0d, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01,
	0xc0, 0x01, 0x01, 0x52, 0x0c, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x2c, 0x0a, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01,
	0xc0, 0x01, 0x01, 0x52, 0x0a, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x12,
	0x30, 0x0a, 0x0d, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xfa, 0x42, 0x08, 0x72, 0x06, 0xd0, 0x01, 0x01,
	0xc0, 0x01, 0x01, 0x52, 0x0c, 0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65,
	0x72, 0x42, 0x16, 0x0a, 0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x03, 0xf8, 0x42, 0x01, 0x22, 0xfa, 0x0e, 0x0a, 0x0c, 0x4f, 0x41,
	0x75, 0x74, 0x68, 0x32, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x44, 0x0a, 0x0e, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x55, 0x72,
	0x69, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x44, 0x0a, 0x0c, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x63, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x52, 0x65,
	0x74, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x16, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52,
	0x15, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x64, 0x5f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x17,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x66, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61,
	0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x32, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01,
	0x02, 0x10, 0x01, 0x52, 0x0b, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x12, 0x2a, 0x0a, 0x0c, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x07, 0xfa, 0x42, 0x04, 0x72, 0x02, 0x10, 0x01, 0x52,
	0x0b, 0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55, 0x72, 0x69, 0x12, 0x60, 0x0a, 0x15,
	0x72, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x65, 0x6e,
	0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02, 0x10, 0x01, 0x52, 0x13, 0x72, 0x65, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x50, 0x61, 0x74, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x4f,
	0x0a, 0x0c, 0x73, 0x69, 0x67, 0x6e, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x74,
	0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x42, 0x08, 0xfa, 0x42, 0x05, 0x8a, 0x01, 0x02,
	0x10, 0x01, 0x52, 0x0b, 0x73, 0x69, 0x67, 0x6e, 0x6f, 0x75, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x30, 0x0a, 0x14, 0x66, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x5f, 0x62, 0x65, 0x61, 0x72, 0x65,
	0x72, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x66,
	0x6f, 0x72, 0x77, 0x61, 0x72, 0x64, 0x42, 0x65, 0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x42, 0x0a, 0x1d, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x5f, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x70, 0x72, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x56, 0x0a, 0x14, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x74, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x12, 0x70, 0x61, 0x73, 0x73, 0x54,
	0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x1f, 0x0a,
	0x0b, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x12, 0x1c,
	0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x09,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x32,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x08, 0xfa, 0x42, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x46, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65,
	0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x75, 0x73, 0x65, 0x52,
	0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x47, 0x0a, 0x12, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x69,
	0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x10, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x45, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x73, 0x49, 0x6e, 0x12, 0x58, 0x0a, 0x15, 0x64, 0x65, 0x6e, 0x79, 0x5f, 0x72, 0x65, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x18, 0x0e, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x76, 0x33, 0x2e, 0x48, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x52, 0x13, 0x64, 0x65, 0x6e, 0x79, 0x52,
	0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x12, 0x61,
	0x0a, 0x20, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73,
	0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f,
	0x69, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x1c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x66, 0x72,
	0x65, 0x73, 0x68, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x49,
	0x6e, 0x12, 0x3c, 0x0a, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x49,
	0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x12,
	0x44, 0x0a, 0x1f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c,
	0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x74, 0x43,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x12, 0x46, 0x0a, 0x20, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x1c, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x53, 0x65, 0x74, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x12, 0x5d, 0x0a,
	0x0e, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e,
	0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x0d, 0x63,
	0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x74, 0x61, 0x74, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x4c, 0x0a,
	0x15, 0x63, 0x73, 0x72, 0x66, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x63, 0x73, 0x72, 0x66, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x49, 0x6e, 0x12, 0x5d, 0x0a, 0x1e, 0x63,
	0x6f, 0x64, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x19, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x1a,
	0x63, 0x6f, 0x64, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x49, 0x6e, 0x12, 0x38, 0x0a, 0x18, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x08, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x10, 0x55, 0x52, 0x4c, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x45, 0x44, 0x5f,
	0x42, 0x4f, 0x44, 0x59, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x41, 0x53, 0x49, 0x43, 0x5f,
	0x41, 0x55, 0x54, 0x48, 0x10, 0x01, 0x22, 0x57, 0x0a, 0x06, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x32,
	0x12, 0x4d, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x35, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76, 0x33, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68,
	0x32, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0xa6, 0x01, 0xba, 0x80, 0xc8, 0xd1, 0x06, 0x02, 0x10, 0x02, 0x0a, 0x35, 0x69, 0x6f, 0x2e, 0x65,
	0x6e, 0x76, 0x6f, 0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2e, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2e,
	0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x73, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x2e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2e, 0x76,
	0x33, 0x42, 0x0a, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x57, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x65, 0x6e, 0x76, 0x6f,
	0x79, 0x70, 0x72, 0x6f, 0x78, 0x79, 0x2f, 0x67, 0x6f, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
	0x6c, 0x2d, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x2f, 0x65, 0x6e, 0x76, 0x6f, 0x79, 0x2f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x68, 0x74, 0x74, 0x70, 0x2f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x2f, 0x76, 0x33, 0x3b,
	0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x76, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescOnce sync.Once
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescData = file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDesc
)

func file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescGZIP() []byte {
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescOnce.Do(func() {
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescData = protoimpl.X.CompressGZIP(file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescData)
	})
	return file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDescData
}

var file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_goTypes = []interface{}{
	(CookieConfig_SameSite)(0),            // 0: envoy.extensions.filters.http.oauth2.v3.CookieConfig.SameSite
	(OAuth2Config_AuthType)(0),            // 1: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.AuthType
	(*CookieConfig)(nil),                  // 2: envoy.extensions.filters.http.oauth2.v3.CookieConfig
	(*CookieConfigs)(nil),                 // 3: envoy.extensions.filters.http.oauth2.v3.CookieConfigs
	(*OAuth2Credentials)(nil),             // 4: envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials
	(*OAuth2Config)(nil),                  // 5: envoy.extensions.filters.http.oauth2.v3.OAuth2Config
	(*OAuth2)(nil),                        // 6: envoy.extensions.filters.http.oauth2.v3.OAuth2
	(*OAuth2Credentials_CookieNames)(nil), // 7: envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials.CookieNames
	(*v3.SdsSecretConfig)(nil),            // 8: envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig
	(*v31.HttpUri)(nil),                   // 9: envoy.config.core.v3.HttpUri
	(*v31.RetryPolicy)(nil),               // 10: envoy.config.core.v3.RetryPolicy
	(*v32.PathMatcher)(nil),               // 11: envoy.type.matcher.v3.PathMatcher
	(*v33.HeaderMatcher)(nil),             // 12: envoy.config.route.v3.HeaderMatcher
	(*wrapperspb.BoolValue)(nil),          // 13: google.protobuf.BoolValue
	(*durationpb.Duration)(nil),           // 14: google.protobuf.Duration
}
var file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_depIdxs = []int32{
	0,  // 0: envoy.extensions.filters.http.oauth2.v3.CookieConfig.same_site:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig.SameSite
	2,  // 1: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.bearer_token_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 2: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.oauth_hmac_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 3: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.oauth_expires_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 4: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.id_token_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 5: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.refresh_token_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 6: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.oauth_nonce_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	2,  // 7: envoy.extensions.filters.http.oauth2.v3.CookieConfigs.code_verifier_cookie_config:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfig
	8,  // 8: envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials.token_secret:type_name -> envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig
	8,  // 9: envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials.hmac_secret:type_name -> envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig
	7,  // 10: envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials.cookie_names:type_name -> envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials.CookieNames
	9,  // 11: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.token_endpoint:type_name -> envoy.config.core.v3.HttpUri
	10, // 12: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.retry_policy:type_name -> envoy.config.core.v3.RetryPolicy
	4,  // 13: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.credentials:type_name -> envoy.extensions.filters.http.oauth2.v3.OAuth2Credentials
	11, // 14: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.redirect_path_matcher:type_name -> envoy.type.matcher.v3.PathMatcher
	11, // 15: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.signout_path:type_name -> envoy.type.matcher.v3.PathMatcher
	12, // 16: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.pass_through_matcher:type_name -> envoy.config.route.v3.HeaderMatcher
	1,  // 17: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.auth_type:type_name -> envoy.extensions.filters.http.oauth2.v3.OAuth2Config.AuthType
	13, // 18: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.use_refresh_token:type_name -> google.protobuf.BoolValue
	14, // 19: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.default_expires_in:type_name -> google.protobuf.Duration
	12, // 20: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.deny_redirect_matcher:type_name -> envoy.config.route.v3.HeaderMatcher
	14, // 21: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.default_refresh_token_expires_in:type_name -> google.protobuf.Duration
	3,  // 22: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.cookie_configs:type_name -> envoy.extensions.filters.http.oauth2.v3.CookieConfigs
	14, // 23: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.csrf_token_expires_in:type_name -> google.protobuf.Duration
	14, // 24: envoy.extensions.filters.http.oauth2.v3.OAuth2Config.code_verifier_token_expires_in:type_name -> google.protobuf.Duration
	5,  // 25: envoy.extensions.filters.http.oauth2.v3.OAuth2.config:type_name -> envoy.extensions.filters.http.oauth2.v3.OAuth2Config
	26, // [26:26] is the sub-list for method output_type
	26, // [26:26] is the sub-list for method input_type
	26, // [26:26] is the sub-list for extension type_name
	26, // [26:26] is the sub-list for extension extendee
	0,  // [0:26] is the sub-list for field type_name
}

func init() { file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_init() }
func file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_init() {
	if File_envoy_extensions_filters_http_oauth2_v3_oauth_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CookieConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CookieConfigs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuth2Credentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuth2Config); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuth2); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OAuth2Credentials_CookieNames); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*OAuth2Credentials_HmacSecret)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_goTypes,
		DependencyIndexes: file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_depIdxs,
		EnumInfos:         file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_enumTypes,
		MessageInfos:      file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_msgTypes,
	}.Build()
	File_envoy_extensions_filters_http_oauth2_v3_oauth_proto = out.File
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_rawDesc = nil
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_goTypes = nil
	file_envoy_extensions_filters_http_oauth2_v3_oauth_proto_depIdxs = nil
}
