
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "klibexec_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KLibexec_Type = nullptr;
static PyTypeObject *Sbk_KLibexec_TypeF(void)
{
    return _Sbk_KLibexec_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KLibexec_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KLibexec");
    return -1;
}

static PyObject *Sbk_KLibexecFunc_kdeFrameworksPaths(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KLibexec::kdeFrameworksPaths(QString)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // kdeFrameworksPaths(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "kdeFrameworksPaths", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // kdeFrameworksPaths(QString)
            QStringList cppResult = ::KLibexec::kdeFrameworksPaths(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLibexecFunc_path(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KLibexec::path(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // path(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "path", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // path(QString)
            QString cppResult = ::KLibexec::path(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLibexecFunc_pathCandidates(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KLibexec::pathCandidates(QString)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // pathCandidates(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "pathCandidates", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pathCandidates(QString)
            QStringList cppResult = ::KLibexec::pathCandidates(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KLibexecFunc_pathFromAddress(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "pathFromAddress", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KLibexec::pathFromAddress(QString,void*)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
        overloadId = 0; // pathFromAddress(QString,void*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "pathFromAddress", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pathFromAddress(QString,void*)
            QString cppResult = ::KLibexec::pathFromAddress(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KLibexec_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KLibexec_methods[] = {
    {"kdeFrameworksPaths", reinterpret_cast<PyCFunction>(Sbk_KLibexecFunc_kdeFrameworksPaths), METH_O|METH_STATIC, nullptr},
    {"path", reinterpret_cast<PyCFunction>(Sbk_KLibexecFunc_path), METH_O|METH_STATIC, nullptr},
    {"pathCandidates", reinterpret_cast<PyCFunction>(Sbk_KLibexecFunc_pathCandidates), METH_O|METH_STATIC, nullptr},
    {"pathFromAddress", reinterpret_cast<PyCFunction>(Sbk_KLibexecFunc_pathFromAddress), METH_VARARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KLibexec_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KLibexec_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KLibexec_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KLibexec_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KLibexec_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KLibexec_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KLibexec_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KLibexec_spec = {
    "1:KCoreAddons.KLibexec",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KLibexec_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKLibexec_SignatureStrings[] = {
    "KCoreAddons.KLibexec.kdeFrameworksPaths(relativePath:QString)->QStringList",
    "KCoreAddons.KLibexec.path(relativePath:QString)->QString",
    "KCoreAddons.KLibexec.pathCandidates(relativePath:QString)->QStringList",
    "KCoreAddons.KLibexec.pathFromAddress(relativePath:QString,address:void)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKLibexec_SignatureByteSize = 120;
static constexpr uint8_t KCoreAddonsKLibexec_SignatureBytes[120] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0xf6,
    0xc9, 0x4c, 0x4a, 0xad, 0x48, 0x4d, 0xd6, 0xcb, 0x4e, 0x49, 0x75, 0x2b, 0x4a, 0xcc, 0x4d, 0x2d,
    0xcf, 0x2f, 0xca, 0x2e, 0x0e, 0x48, 0x2c, 0xc9, 0x28, 0xd6, 0x28, 0x4a, 0xcd, 0x49, 0x2c, 0xc9,
    0x2c, 0x4b, 0x05, 0xf1, 0xac, 0x02, 0x83, 0x4b, 0x8a, 0x32, 0xf3, 0xd2, 0x35, 0x75, 0xed, 0xa0,
    0x2c, 0x9f, 0xcc, 0xe2, 0x12, 0x2e, 0x6f, 0x6c, 0x46, 0x15, 0x00, 0xd5, 0x13, 0xd0, 0x8c, 0x5b,
    0xa3, 0x73, 0x62, 0x5e, 0x4a, 0x66, 0x4a, 0x62, 0x49, 0x2a, 0x65, 0xf6, 0xbb, 0x15, 0xe5, 0xe7,
    0x02, 0xc5, 0x8b, 0x52, 0x8b, 0xb1, 0x9b, 0xa3, 0x93, 0x08, 0x91, 0xb4, 0x2a, 0xcb, 0xcf, 0x4c,
    0x41, 0x72, 0x17, 0x00, 0x9a, 0xf9, 0x69, 0x01
};
#endif

PyTypeObject *init_KCoreAddonsKLibexec(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX].type;

    Shiboken::AutoDecRef Sbk_KLibexec_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KLibexec_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KLibexec",
        "KLibexec",
        &Sbk_KLibexec_spec,
        nullptr,
        Sbk_KLibexec_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KLibexec_Type; // references _Sbk_KLibexec_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKLibexec_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKLibexec_SignatureBytes, KCoreAddonsKLibexec_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KLibexec_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKLibexec_IDX].type = pyType;



    return pyType;
}
