#ifndef SBK_KAUTOSAVEFILEWRAPPER_H
#define SBK_KAUTOSAVEFILEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kautosavefile.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KAutoSaveFileWrapper : public KAutoSaveFile
{
public:
    KAutoSaveFileWrapper(::QObject * parent = nullptr);
    KAutoSaveFileWrapper(const ::QUrl & filename, ::QObject * parent = nullptr);
    KAutoSaveFileWrapper(const KAutoSaveFileWrapper &) = delete;
    KAutoSaveFileWrapper& operator=(const KAutoSaveFileWrapper &) = delete;
    KAutoSaveFileWrapper(KAutoSaveFileWrapper &&) = delete;
    KAutoSaveFileWrapper& operator=(KAutoSaveFileWrapper &&) = delete;
    ~KAutoSaveFileWrapper() override;

    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(::QChildEvent * event) override;
    void close() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QString fileName() const override;
    bool isSequential() const override;
    bool open(::QFlags<QIODeviceBase::OpenModeFlag> openmode) override;
    static bool sbk_o_open(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<QIODeviceBase::OpenModeFlag> openmode);
    ::QFlags<QFileDevice::Permission> permissions() const override;
    static ::QFlags<QFileDevice::Permission> sbk_o_permissions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    qint64 pos() const override;
    qint64 readData(char * data, qint64 maxlen) override;
    qint64 readLineData(char * data, qint64 maxlen) override;
    void releaseLock() override;
    bool reset() override;
    bool resize(qint64 sz) override;
    static bool sbk_o_resize(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, qint64 sz);
    bool seek(qint64 offset) override;
    bool setPermissions(::QFlags<QFileDevice::Permission> permissionSpec) override;
    static bool sbk_o_setPermissions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<QFileDevice::Permission> permissionSpec);
    qint64 size() const override;
    qint64 skipData(qint64 maxSize) override;
    void timerEvent(::QTimerEvent * event) override;
    bool waitForBytesWritten(int msecs) override;
    bool waitForReadyRead(int msecs) override;
    qint64 writeData(const char * data, qint64 len) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 29> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KAUTOSAVEFILEWRAPPER_H
