/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "k8s.io/api/networking/v1beta1"
	networkingv1beta1 "k8s.io/client-go/applyconfigurations/networking/v1beta1"
	gentype "k8s.io/client-go/gentype"
	typednetworkingv1beta1 "k8s.io/client-go/kubernetes/typed/networking/v1beta1"
)

// fakeIPAddresses implements IPAddressInterface
type fakeIPAddresses struct {
	*gentype.FakeClientWithListAndApply[*v1beta1.IPAddress, *v1beta1.IPAddressList, *networkingv1beta1.IPAddressApplyConfiguration]
	Fake *FakeNetworkingV1beta1
}

func newFakeIPAddresses(fake *FakeNetworkingV1beta1) typednetworkingv1beta1.IPAddressInterface {
	return &fakeIPAddresses{
		gentype.NewFakeClientWithListAndApply[*v1beta1.IPAddress, *v1beta1.IPAddressList, *networkingv1beta1.IPAddressApplyConfiguration](
			fake.Fake,
			"",
			v1beta1.SchemeGroupVersion.WithResource("ipaddresses"),
			v1beta1.SchemeGroupVersion.WithKind("IPAddress"),
			func() *v1beta1.IPAddress { return &v1beta1.IPAddress{} },
			func() *v1beta1.IPAddressList { return &v1beta1.IPAddressList{} },
			func(dst, src *v1beta1.IPAddressList) { dst.ListMeta = src.ListMeta },
			func(list *v1beta1.IPAddressList) []*v1beta1.IPAddress { return gentype.ToPointerSlice(list.Items) },
			func(list *v1beta1.IPAddressList, items []*v1beta1.IPAddress) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
