
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "klineediturldropeventfilter_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KLineEditUrlDropEventFilter_Type = nullptr;
static PyTypeObject *Sbk_KLineEditUrlDropEventFilter_TypeF(void)
{
    return _Sbk_KLineEditUrlDropEventFilter_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KLineEditUrlDropEventFilterWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KLineEditUrlDropEventFilterWrapper::KLineEditUrlDropEventFilterWrapper(::QObject * parent) : KLineEditUrlDropEventFilter(parent)
{
}

void KLineEditUrlDropEventFilterWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, event);
}

void KLineEditUrlDropEventFilterWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, signal);
}

void KLineEditUrlDropEventFilterWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, event);
}

void KLineEditUrlDropEventFilterWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, signal);
}

bool KLineEditUrlDropEventFilterWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, event);
}

bool KLineEditUrlDropEventFilterWrapper::eventFilter(::QObject * object, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KLineEditUrlDropEventFilter::eventFilter(object, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, object, event);
}

void KLineEditUrlDropEventFilterWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KLineEditUrlDropEventFilter_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KLineEditUrlDropEventFilter", funcName, gil, pyOverride, event);
}

const QMetaObject *KLineEditUrlDropEventFilterWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KLineEditUrlDropEventFilter::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KLineEditUrlDropEventFilterWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KLineEditUrlDropEventFilter::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KLineEditUrlDropEventFilterWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KLineEditUrlDropEventFilterWrapper *>(this));
    }
    return KLineEditUrlDropEventFilter::qt_metacast(_clname);
}

KLineEditUrlDropEventFilterWrapper::~KLineEditUrlDropEventFilterWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KLineEditUrlDropEventFilter_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KLineEditUrlDropEventFilter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KLineEditUrlDropEventFilter >()))
        return -1;

    KLineEditUrlDropEventFilterWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KLineEditUrlDropEventFilter", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KLineEditUrlDropEventFilter::KLineEditUrlDropEventFilter(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KLineEditUrlDropEventFilter(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KLineEditUrlDropEventFilter(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KLineEditUrlDropEventFilter(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KLineEditUrlDropEventFilterWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KLineEditUrlDropEventFilterWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KLineEditUrlDropEventFilter >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KLineEditUrlDropEventFilterFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KLineEditUrlDropEventFilter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KLineEditUrlDropEventFilter::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KLineEditUrlDropEventFilter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KLineEditUrlDropEventFilter_methods[] = {
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KLineEditUrlDropEventFilterFunc_eventFilter), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KLineEditUrlDropEventFilter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KLineEditUrlDropEventFilter *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KLineEditUrlDropEventFilterWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KLineEditUrlDropEventFilter_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KLineEditUrlDropEventFilter_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KLineEditUrlDropEventFilter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KLineEditUrlDropEventFilter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KLineEditUrlDropEventFilter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KLineEditUrlDropEventFilter_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KLineEditUrlDropEventFilter_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KLineEditUrlDropEventFilter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KLineEditUrlDropEventFilter_spec = {
    "1:KWidgetsAddons.KLineEditUrlDropEventFilter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KLineEditUrlDropEventFilter_slots
};

} //extern "C"

static void *Sbk_KLineEditUrlDropEventFilter_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KLineEditUrlDropEventFilter *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KLineEditUrlDropEventFilter_PythonToCpp_KLineEditUrlDropEventFilter_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KLineEditUrlDropEventFilter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KLineEditUrlDropEventFilter_PythonToCpp_KLineEditUrlDropEventFilter_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KLineEditUrlDropEventFilter_TypeF()))
        return KLineEditUrlDropEventFilter_PythonToCpp_KLineEditUrlDropEventFilter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KLineEditUrlDropEventFilter_PTR_CppToPython_KLineEditUrlDropEventFilter(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KLineEditUrlDropEventFilter *>(const_cast<void *>(cppIn)), Sbk_KLineEditUrlDropEventFilter_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KLineEditUrlDropEventFilter_SignatureStrings[] = {
    "KWidgetsAddons.KLineEditUrlDropEventFilter(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KWidgetsAddons.KLineEditUrlDropEventFilter.eventFilter(self,object:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KLineEditUrlDropEventFilter_SignatureByteSize = 122;
static constexpr uint8_t KLineEditUrlDropEventFilter_SignatureBytes[122] = {
    0x78, 0xda, 0xf3, 0x0e, 0xcf, 0x4c, 0x49, 0x4f, 0x2d, 0x29, 0x76, 0x4c, 0x49, 0xc9, 0xcf, 0x2b,
    0xd6, 0xf3, 0xf6, 0xc9, 0xcc, 0x4b, 0x75, 0x4d, 0xc9, 0x2c, 0x09, 0x2d, 0xca, 0x71, 0x29, 0xca,
    0x2f, 0x70, 0x2d, 0x4b, 0xcd, 0x2b, 0x71, 0xcb, 0xcc, 0x29, 0x49, 0x2d, 0xd2, 0x28, 0x4e, 0xcd,
    0x49, 0xd3, 0x29, 0x48, 0x2c, 0x02, 0x8a, 0x58, 0x05, 0x54, 0x06, 0x67, 0xa6, 0xa4, 0x9a, 0xe9,
    0x05, 0x96, 0x38, 0xe7, 0x17, 0xa5, 0xea, 0x05, 0xfa, 0x27, 0x65, 0xa5, 0x26, 0x97, 0xd8, 0xe6,
    0x95, 0xe6, 0xe4, 0x14, 0x94, 0x14, 0x69, 0x72, 0x79, 0x13, 0x6d, 0xac, 0x5e, 0x2a, 0xba, 0x15,
    0xf9, 0x60, 0xb3, 0x70, 0x58, 0xa1, 0x03, 0x56, 0x8e, 0x21, 0x09, 0x36, 0x50, 0x53, 0xd7, 0x2e,
    0x29, 0x3f, 0x3f, 0x87, 0x0b, 0x00, 0xf8, 0x8f, 0x4e, 0x0c
};
#endif

PyTypeObject *init_KLineEditUrlDropEventFilter(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX].type;

    Shiboken::AutoDecRef Sbk_KLineEditUrlDropEventFilter_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KLineEditUrlDropEventFilter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KLineEditUrlDropEventFilter",
        "KLineEditUrlDropEventFilter*",
        &Sbk_KLineEditUrlDropEventFilter_spec,
        &Shiboken::callCppDestructor< KLineEditUrlDropEventFilter >,
        Sbk_KLineEditUrlDropEventFilter_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KLineEditUrlDropEventFilter_Type; // references _Sbk_KLineEditUrlDropEventFilter_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KLineEditUrlDropEventFilter_SignatureStrings);
#else
    InitSignatureBytes(pyType, KLineEditUrlDropEventFilter_SignatureBytes, KLineEditUrlDropEventFilter_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KLineEditUrlDropEventFilter_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KLineEditUrlDropEventFilter_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KLineEditUrlDropEventFilter_PythonToCpp_KLineEditUrlDropEventFilter_PTR,
        is_KLineEditUrlDropEventFilter_PythonToCpp_KLineEditUrlDropEventFilter_PTR_Convertible,
        KLineEditUrlDropEventFilter_PTR_CppToPython_KLineEditUrlDropEventFilter);

    Shiboken::Conversions::registerConverterName(converter, "KLineEditUrlDropEventFilter");
    Shiboken::Conversions::registerConverterName(converter, "KLineEditUrlDropEventFilter*");
    Shiboken::Conversions::registerConverterName(converter, "KLineEditUrlDropEventFilter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KLineEditUrlDropEventFilter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KLineEditUrlDropEventFilterWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KLineEditUrlDropEventFilter_TypeF(), &Sbk_KLineEditUrlDropEventFilter_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KLineEditUrlDropEventFilter::staticMetaObject, sizeof(KLineEditUrlDropEventFilterWrapper));

    return pyType;
}
