#ifndef SBK_KPAGEMODELWRAPPER_H
#define SBK_KPAGEMODELWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kpagemodel.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KPageModelWrapper : public KPageModel
{
public:
    KPageModelWrapper(::QObject * parent = nullptr);
    KPageModelWrapper(const KPageModelWrapper &) = delete;
    KPageModelWrapper& operator=(const KPageModelWrapper &) = delete;
    KPageModelWrapper(KPageModelWrapper &&) = delete;
    KPageModelWrapper& operator=(KPageModelWrapper &&) = delete;
    ~KPageModelWrapper() override;

    ::QModelIndex buddy(const ::QModelIndex & index) const override;
    static ::QModelIndex sbk_o_buddy(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index);
    bool canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const override;
    static bool sbk_o_canDropMimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent);
    bool canFetchMore(const ::QModelIndex & parent) const override;
    static bool sbk_o_canFetchMore(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent);
    void childEvent(::QChildEvent * event) override;
    bool clearItemData(const ::QModelIndex & index) override;
    int columnCount(const ::QModelIndex & parent = QModelIndex()) const override;
    static int sbk_o_columnCount(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent = QModelIndex());
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    ::QVariant data(const ::QModelIndex & index, int role = Qt::DisplayRole) const override;
    static ::QVariant sbk_o_data(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, int role = Qt::DisplayRole);
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void fetchMore(const ::QModelIndex & parent) override;
    static void sbk_o_fetchMore(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & parent);
    ::QFlags<Qt::ItemFlag> flags(const ::QModelIndex & index) const override;
    static ::QFlags<Qt::ItemFlag> sbk_o_flags(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index);
    bool hasChildren(const ::QModelIndex & parent = QModelIndex()) const override;
    ::QVariant headerData(int section, ::Qt::Orientation orientation, int role = Qt::DisplayRole) const override;
    static ::QVariant sbk_o_headerData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int section, ::Qt::Orientation orientation, int role = Qt::DisplayRole);
    ::QModelIndex index(int row, int column, const ::QModelIndex & parent = QModelIndex()) const override;
    static ::QModelIndex sbk_o_index(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int row, int column, const ::QModelIndex & parent = QModelIndex());
    bool insertColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    static bool sbk_o_insertColumns(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int column, int count, const ::QModelIndex & parent = QModelIndex());
    bool insertRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    ::QMap<int,QVariant> itemData(const ::QModelIndex & index) const override;
    static ::QMap<int,QVariant> sbk_o_itemData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index);
    ::QList<QModelIndex> match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits = 1, ::QFlags<Qt::MatchFlag> flags = Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap)) const override;
    static ::QList<QModelIndex> sbk_o_match(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & start, int role, const ::QVariant & value, int hits = 1, ::QFlags<Qt::MatchFlag> flags = Qt::MatchFlags(Qt::MatchStartsWith|Qt::MatchWrap));
    ::QMimeData * mimeData(const ::QList<QModelIndex> & indexes) const override;
    static ::QMimeData * sbk_o_mimeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QList<QModelIndex> & indexes);
    ::QStringList mimeTypes() const override;
    static ::QStringList sbk_o_mimeTypes(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    bool moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    static bool sbk_o_moveColumns(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild);
    bool moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild) override;
    void multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const override;
    static void sbk_o_multiData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan);
    ::QModelIndex parent(const ::QModelIndex & child) const override;
    bool removeColumns(int column, int count, const ::QModelIndex & parent = QModelIndex()) override;
    bool removeRows(int row, int count, const ::QModelIndex & parent = QModelIndex()) override;
    void resetInternalData() override;
    void revert() override;
    ::QHash<int,QByteArray> roleNames() const override;
    static ::QHash<int,QByteArray> sbk_o_roleNames(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    int rowCount(const ::QModelIndex & parent = QModelIndex()) const override;
    bool setData(const ::QModelIndex & index, const ::QVariant & value, int role = Qt::EditRole) override;
    static bool sbk_o_setData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, const ::QVariant & value, int role = Qt::EditRole);
    bool setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role = Qt::EditRole) override;
    static bool sbk_o_setHeaderData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int section, ::Qt::Orientation orientation, const ::QVariant & value, int role = Qt::EditRole);
    bool setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles) override;
    static bool sbk_o_setItemData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index, const ::QMap<int,QVariant> & roles);
    ::QModelIndex sibling(int row, int column, const ::QModelIndex & idx) const override;
    void sort(int column, ::Qt::SortOrder order = Qt::AscendingOrder) override;
    static void sbk_o_sort(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int column, ::Qt::SortOrder order = Qt::AscendingOrder);
    ::QSize span(const ::QModelIndex & index) const override;
    static ::QSize sbk_o_span(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index);
    bool submit() override;
    ::QFlags<Qt::DropAction> supportedDragActions() const override;
    static ::QFlags<Qt::DropAction> sbk_o_supportedDragActions(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    ::QFlags<Qt::DropAction> supportedDropActions() const override;
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 44> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KPAGEMODELWRAPPER_H
