/* Generated by wayland-scanner 1.24.0 */

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_SERVER_PROTOCOL_H
#define KDE_LOCKSCREEN_OVERLAY_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_lockscreen_overlay_v1 The kde_lockscreen_overlay_v1 protocol
 * @section page_ifaces_kde_lockscreen_overlay_v1 Interfaces
 * - @subpage page_iface_kde_lockscreen_overlay_v1 - Allow surfaces over the lockscreen
 * @section page_copyright_kde_lockscreen_overlay_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2022 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct kde_lockscreen_overlay_v1;
struct wl_surface;

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_INTERFACE
#define KDE_LOCKSCREEN_OVERLAY_V1_INTERFACE
/**
 * @page page_iface_kde_lockscreen_overlay_v1 kde_lockscreen_overlay_v1
 * @section page_iface_kde_lockscreen_overlay_v1_desc Description
 *
 * Allows a client to request a surface to be visible when the system is locked.
 *
 * This is meant to be used for specific high urgency cases like phone calls or alarms.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 * @section page_iface_kde_lockscreen_overlay_v1_api API
 * See @ref iface_kde_lockscreen_overlay_v1.
 */
/**
 * @defgroup iface_kde_lockscreen_overlay_v1 The kde_lockscreen_overlay_v1 interface
 *
 * Allows a client to request a surface to be visible when the system is locked.
 *
 * This is meant to be used for specific high urgency cases like phone calls or alarms.
 *
 * Warning! The protocol described in this file is a desktop environment
 * implementation detail. Regular clients must not use this protocol.
 * Backward incompatible changes may be added without bumping the major
 * version of the extension.
 */
extern const struct wl_interface kde_lockscreen_overlay_v1_interface;
#endif

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM
#define KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM
enum kde_lockscreen_overlay_v1_error {
	/**
	 * the client provided an invalid surface state
	 */
	KDE_LOCKSCREEN_OVERLAY_V1_ERROR_INVALID_SURFACE_STATE = 0,
};
#endif /* KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM */

#ifndef KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM_IS_VALID
#define KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 * Validate a kde_lockscreen_overlay_v1 error value.
 *
 * @return true on success, false on error.
 * @ref kde_lockscreen_overlay_v1_error
 */
static inline bool
kde_lockscreen_overlay_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case KDE_LOCKSCREEN_OVERLAY_V1_ERROR_INVALID_SURFACE_STATE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* KDE_LOCKSCREEN_OVERLAY_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 * @struct kde_lockscreen_overlay_v1_interface
 */
struct kde_lockscreen_overlay_v1_interface {
	/**
	 * Tell about which surface could be raised above the lockscreen
	 *
	 * Informs the compositor that the surface could be shown when
	 * the screen is locked. This request should be called while the
	 * surface is unmapped.
	 */
	void (*allow)(struct wl_client *client,
		      struct wl_resource *resource,
		      struct wl_resource *surface);
	/**
	 * Destroy the kde_lockscreen_overlay_v1
	 *
	 * This won't affect the surface previously marked with the allow
	 * request.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 */
#define KDE_LOCKSCREEN_OVERLAY_V1_ALLOW_SINCE_VERSION 1
/**
 * @ingroup iface_kde_lockscreen_overlay_v1
 */
#define KDE_LOCKSCREEN_OVERLAY_V1_DESTROY_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
