// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

package common

const (
	//RegionAPChuncheon1 region Chuncheon
	RegionAPChuncheon1 Region = "ap-chuncheon-1"
	//RegionAPHyderabad1 region Hyderabad
	RegionAPHyderabad1 Region = "ap-hyderabad-1"
	//RegionAPMelbourne1 region Melbourne
	RegionAPMelbourne1 Region = "ap-melbourne-1"
	//RegionAPMumbai1 region Mumbai
	RegionAPMumbai1 Region = "ap-mumbai-1"
	//RegionAPOsaka1 region Osaka
	RegionAPOsaka1 Region = "ap-osaka-1"
	//RegionAPSeoul1 region Seoul
	RegionAPSeoul1 Region = "ap-seoul-1"
	//RegionAPSydney1 region Sydney
	RegionAPSydney1 Region = "ap-sydney-1"
	//RegionAPTokyo1 region Tokyo
	RegionAPTokyo1 Region = "ap-tokyo-1"
	//RegionCAMontreal1 region Montreal
	RegionCAMontreal1 Region = "ca-montreal-1"
	//RegionCAToronto1 region Toronto
	RegionCAToronto1 Region = "ca-toronto-1"
	//RegionEUAmsterdam1 region Amsterdam
	RegionEUAmsterdam1 Region = "eu-amsterdam-1"
	//RegionFRA region Frankfurt
	RegionFRA Region = "eu-frankfurt-1"
	//RegionEUZurich1 region Zurich
	RegionEUZurich1 Region = "eu-zurich-1"
	//RegionMEJeddah1 region Jeddah
	RegionMEJeddah1 Region = "me-jeddah-1"
	//RegionMEDubai1 region Dubai
	RegionMEDubai1 Region = "me-dubai-1"
	//RegionSASaopaulo1 region Saopaulo
	RegionSASaopaulo1 Region = "sa-saopaulo-1"
	//RegionUKCardiff1 region Cardiff
	RegionUKCardiff1 Region = "uk-cardiff-1"
	//RegionLHR region London
	RegionLHR Region = "uk-london-1"
	//RegionIAD region Ashburn
	RegionIAD Region = "us-ashburn-1"
	//RegionPHX region Phoenix
	RegionPHX Region = "us-phoenix-1"
	//RegionSJC1 region Sanjose
	RegionSJC1 Region = "us-sanjose-1"
	//RegionSAVinhedo1 region Vinhedo
	RegionSAVinhedo1 Region = "sa-vinhedo-1"
	//RegionSASantiago1 region Santiago
	RegionSASantiago1 Region = "sa-santiago-1"
	//RegionILJerusalem1 region Jerusalem
	RegionILJerusalem1 Region = "il-jerusalem-1"
	//RegionEUMarseille1 region Marseille
	RegionEUMarseille1 Region = "eu-marseille-1"
	//RegionAPSingapore1 region Singapore
	RegionAPSingapore1 Region = "ap-singapore-1"
	//RegionMEAbudhabi1 region Abudhabi
	RegionMEAbudhabi1 Region = "me-abudhabi-1"
	//RegionEUMilan1 region Milan
	RegionEUMilan1 Region = "eu-milan-1"
	//RegionEUStockholm1 region Stockholm
	RegionEUStockholm1 Region = "eu-stockholm-1"
	//RegionAFJohannesburg1 region Johannesburg
	RegionAFJohannesburg1 Region = "af-johannesburg-1"
	//RegionEUParis1 region Paris
	RegionEUParis1 Region = "eu-paris-1"
	//RegionMXQueretaro1 region Queretaro
	RegionMXQueretaro1 Region = "mx-queretaro-1"
	//RegionEUMadrid1 region Madrid
	RegionEUMadrid1 Region = "eu-madrid-1"
	//RegionUSChicago1 region Chicago
	RegionUSChicago1 Region = "us-chicago-1"
	//RegionMXMonterrey1 region Monterrey
	RegionMXMonterrey1 Region = "mx-monterrey-1"
	//RegionUSSaltlake2 region Saltlake
	RegionUSSaltlake2 Region = "us-saltlake-2"
	//RegionSABogota1 region Bogota
	RegionSABogota1 Region = "sa-bogota-1"
	//RegionSAValparaiso1 region Valparaiso
	RegionSAValparaiso1 Region = "sa-valparaiso-1"
	//RegionAPSingapore2 region Singapore
	RegionAPSingapore2 Region = "ap-singapore-2"
	//RegionMERiyadh1 region Riyadh
	RegionMERiyadh1 Region = "me-riyadh-1"
	//RegionAPDelhi1 region Delhi
	RegionAPDelhi1 Region = "ap-delhi-1"
	//RegionAPBatam1 region Batam
	RegionAPBatam1 Region = "ap-batam-1"
	//RegionUSLangley1 region Langley
	RegionUSLangley1 Region = "us-langley-1"
	//RegionUSLuke1 region Luke
	RegionUSLuke1 Region = "us-luke-1"
	//RegionUSGovAshburn1 gov region Ashburn
	RegionUSGovAshburn1 Region = "us-gov-ashburn-1"
	//RegionUSGovChicago1 gov region Chicago
	RegionUSGovChicago1 Region = "us-gov-chicago-1"
	//RegionUSGovPhoenix1 gov region Phoenix
	RegionUSGovPhoenix1 Region = "us-gov-phoenix-1"
	//RegionUKGovLondon1 gov region London
	RegionUKGovLondon1 Region = "uk-gov-london-1"
	//RegionUKGovCardiff1 gov region Cardiff
	RegionUKGovCardiff1 Region = "uk-gov-cardiff-1"
	//RegionAPChiyoda1 region Chiyoda
	RegionAPChiyoda1 Region = "ap-chiyoda-1"
	//RegionAPIbaraki1 region Ibaraki
	RegionAPIbaraki1 Region = "ap-ibaraki-1"
	//RegionMEDccMuscat1 region Muscat
	RegionMEDccMuscat1 Region = "me-dcc-muscat-1"
	//RegionMEIbri1 region Ibri
	RegionMEIbri1 Region = "me-ibri-1"
	//RegionAPDccCanberra1 region Canberra
	RegionAPDccCanberra1 Region = "ap-dcc-canberra-1"
	//RegionEUDccMilan1 region Milan
	RegionEUDccMilan1 Region = "eu-dcc-milan-1"
	//RegionEUDccMilan2 region Milan
	RegionEUDccMilan2 Region = "eu-dcc-milan-2"
	//RegionEUDccDublin2 region Dublin
	RegionEUDccDublin2 Region = "eu-dcc-dublin-2"
	//RegionEUDccRating2 region Rating
	RegionEUDccRating2 Region = "eu-dcc-rating-2"
	//RegionEUDccRating1 region Rating
	RegionEUDccRating1 Region = "eu-dcc-rating-1"
	//RegionEUDccDublin1 region Dublin
	RegionEUDccDublin1 Region = "eu-dcc-dublin-1"
	//RegionAPDccGazipur1 region Gazipur
	RegionAPDccGazipur1 Region = "ap-dcc-gazipur-1"
	//RegionEUMadrid2 region Madrid
	RegionEUMadrid2 Region = "eu-madrid-2"
	//RegionEUFrankfurt2 region Frankfurt
	RegionEUFrankfurt2 Region = "eu-frankfurt-2"
	//RegionEUJovanovac1 region Jovanovac
	RegionEUJovanovac1 Region = "eu-jovanovac-1"
	//RegionMEDccDoha1 region Doha
	RegionMEDccDoha1 Region = "me-dcc-doha-1"
	//RegionUSSomerset1 region Somerset
	RegionUSSomerset1 Region = "us-somerset-1"
	//RegionUSThames1 region Thames
	RegionUSThames1 Region = "us-thames-1"
	//RegionEUDccZurich1 region Zurich
	RegionEUDccZurich1 Region = "eu-dcc-zurich-1"
	//RegionEUCrissier1 region Crissier
	RegionEUCrissier1 Region = "eu-crissier-1"
	//RegionMEAbudhabi3 region Abudhabi
	RegionMEAbudhabi3 Region = "me-abudhabi-3"
	//RegionMEAlain1 region Alain
	RegionMEAlain1 Region = "me-alain-1"
	//RegionMEAbudhabi2 region Abudhabi
	RegionMEAbudhabi2 Region = "me-abudhabi-2"
	//RegionMEAbudhabi4 region Abudhabi
	RegionMEAbudhabi4 Region = "me-abudhabi-4"
	//RegionAPSeoul2 region Seoul
	RegionAPSeoul2 Region = "ap-seoul-2"
	//RegionAPSuwon1 region Suwon
	RegionAPSuwon1 Region = "ap-suwon-1"
	//RegionAPChuncheon2 region Chuncheon
	RegionAPChuncheon2 Region = "ap-chuncheon-2"
	//RegionUSAshburn2 region Ashburn
	RegionUSAshburn2 Region = "us-ashburn-2"
	//RegionUSNewark1 region Newark
	RegionUSNewark1 Region = "us-newark-1"
	//RegionEUBudapest1 region Budapest
	RegionEUBudapest1 Region = "eu-budapest-1"
)

var shortNameRegion = map[string]Region{
	"yny": RegionAPChuncheon1,
	"hyd": RegionAPHyderabad1,
	"mel": RegionAPMelbourne1,
	"bom": RegionAPMumbai1,
	"kix": RegionAPOsaka1,
	"icn": RegionAPSeoul1,
	"syd": RegionAPSydney1,
	"nrt": RegionAPTokyo1,
	"yul": RegionCAMontreal1,
	"yyz": RegionCAToronto1,
	"ams": RegionEUAmsterdam1,
	"fra": RegionFRA,
	"zrh": RegionEUZurich1,
	"jed": RegionMEJeddah1,
	"dxb": RegionMEDubai1,
	"gru": RegionSASaopaulo1,
	"cwl": RegionUKCardiff1,
	"lhr": RegionLHR,
	"iad": RegionIAD,
	"phx": RegionPHX,
	"sjc": RegionSJC1,
	"vcp": RegionSAVinhedo1,
	"scl": RegionSASantiago1,
	"mtz": RegionILJerusalem1,
	"mrs": RegionEUMarseille1,
	"sin": RegionAPSingapore1,
	"auh": RegionMEAbudhabi1,
	"lin": RegionEUMilan1,
	"arn": RegionEUStockholm1,
	"jnb": RegionAFJohannesburg1,
	"cdg": RegionEUParis1,
	"qro": RegionMXQueretaro1,
	"mad": RegionEUMadrid1,
	"ord": RegionUSChicago1,
	"mty": RegionMXMonterrey1,
	"aga": RegionUSSaltlake2,
	"bog": RegionSABogota1,
	"vap": RegionSAValparaiso1,
	"xsp": RegionAPSingapore2,
	"ruh": RegionMERiyadh1,
	"onm": RegionAPDelhi1,
	"hsg": RegionAPBatam1,
	"lfi": RegionUSLangley1,
	"luf": RegionUSLuke1,
	"ric": RegionUSGovAshburn1,
	"pia": RegionUSGovChicago1,
	"tus": RegionUSGovPhoenix1,
	"ltn": RegionUKGovLondon1,
	"brs": RegionUKGovCardiff1,
	"nja": RegionAPChiyoda1,
	"ukb": RegionAPIbaraki1,
	"mct": RegionMEDccMuscat1,
	"ibr": RegionMEIbri1,
	"wga": RegionAPDccCanberra1,
	"bgy": RegionEUDccMilan1,
	"mxp": RegionEUDccMilan2,
	"snn": RegionEUDccDublin2,
	"dtm": RegionEUDccRating2,
	"dus": RegionEUDccRating1,
	"ork": RegionEUDccDublin1,
	"dac": RegionAPDccGazipur1,
	"vll": RegionEUMadrid2,
	"str": RegionEUFrankfurt2,
	"beg": RegionEUJovanovac1,
	"doh": RegionMEDccDoha1,
	"ebb": RegionUSSomerset1,
	"ebl": RegionUSThames1,
	"avz": RegionEUDccZurich1,
	"avf": RegionEUCrissier1,
	"ahu": RegionMEAbudhabi3,
	"rba": RegionMEAlain1,
	"rkt": RegionMEAbudhabi2,
	"shj": RegionMEAbudhabi4,
	"dtz": RegionAPSeoul2,
	"dln": RegionAPSuwon1,
	"bno": RegionAPChuncheon2,
	"yxj": RegionUSAshburn2,
	"pgc": RegionUSNewark1,
	"jsk": RegionEUBudapest1,
}

var realm = map[string]string{
	"oc1":  "oraclecloud.com",
	"oc2":  "oraclegovcloud.com",
	"oc3":  "oraclegovcloud.com",
	"oc4":  "oraclegovcloud.uk",
	"oc8":  "oraclecloud8.com",
	"oc9":  "oraclecloud9.com",
	"oc10": "oraclecloud10.com",
	"oc14": "oraclecloud14.com",
	"oc15": "oraclecloud15.com",
	"oc19": "oraclecloud.eu",
	"oc20": "oraclecloud20.com",
	"oc21": "oraclecloud21.com",
	"oc23": "oraclecloud23.com",
	"oc24": "oraclecloud24.com",
	"oc26": "oraclecloud26.com",
	"oc29": "oraclecloud29.com",
	"oc35": "oraclecloud35.com",
	"oc42": "oraclecloud42.com",
	"oc51": "oraclecloud51.com",
}

var regionRealm = map[Region]string{
	RegionAPChuncheon1:    "oc1",
	RegionAPHyderabad1:    "oc1",
	RegionAPMelbourne1:    "oc1",
	RegionAPMumbai1:       "oc1",
	RegionAPOsaka1:        "oc1",
	RegionAPSeoul1:        "oc1",
	RegionAPSydney1:       "oc1",
	RegionAPTokyo1:        "oc1",
	RegionCAMontreal1:     "oc1",
	RegionCAToronto1:      "oc1",
	RegionEUAmsterdam1:    "oc1",
	RegionFRA:             "oc1",
	RegionEUZurich1:       "oc1",
	RegionMEJeddah1:       "oc1",
	RegionMEDubai1:        "oc1",
	RegionSASaopaulo1:     "oc1",
	RegionUKCardiff1:      "oc1",
	RegionLHR:             "oc1",
	RegionIAD:             "oc1",
	RegionPHX:             "oc1",
	RegionSJC1:            "oc1",
	RegionSAVinhedo1:      "oc1",
	RegionSASantiago1:     "oc1",
	RegionILJerusalem1:    "oc1",
	RegionEUMarseille1:    "oc1",
	RegionAPSingapore1:    "oc1",
	RegionMEAbudhabi1:     "oc1",
	RegionEUMilan1:        "oc1",
	RegionEUStockholm1:    "oc1",
	RegionAFJohannesburg1: "oc1",
	RegionEUParis1:        "oc1",
	RegionMXQueretaro1:    "oc1",
	RegionEUMadrid1:       "oc1",
	RegionUSChicago1:      "oc1",
	RegionMXMonterrey1:    "oc1",
	RegionUSSaltlake2:     "oc1",
	RegionSABogota1:       "oc1",
	RegionSAValparaiso1:   "oc1",
	RegionAPSingapore2:    "oc1",
	RegionMERiyadh1:       "oc1",
	RegionAPDelhi1:        "oc1",
	RegionAPBatam1:        "oc1",

	RegionUSLangley1: "oc2",
	RegionUSLuke1:    "oc2",

	RegionUSGovAshburn1: "oc3",
	RegionUSGovChicago1: "oc3",
	RegionUSGovPhoenix1: "oc3",

	RegionUKGovLondon1:  "oc4",
	RegionUKGovCardiff1: "oc4",

	RegionAPChiyoda1: "oc8",
	RegionAPIbaraki1: "oc8",

	RegionMEDccMuscat1: "oc9",
	RegionMEIbri1:      "oc9",

	RegionAPDccCanberra1: "oc10",

	RegionEUDccMilan1:  "oc14",
	RegionEUDccMilan2:  "oc14",
	RegionEUDccDublin2: "oc14",
	RegionEUDccRating2: "oc14",
	RegionEUDccRating1: "oc14",
	RegionEUDccDublin1: "oc14",

	RegionAPDccGazipur1: "oc15",

	RegionEUMadrid2:    "oc19",
	RegionEUFrankfurt2: "oc19",

	RegionEUJovanovac1: "oc20",

	RegionMEDccDoha1: "oc21",

	RegionUSSomerset1: "oc23",
	RegionUSThames1:   "oc23",

	RegionEUDccZurich1: "oc24",
	RegionEUCrissier1:  "oc24",

	RegionMEAbudhabi3: "oc26",
	RegionMEAlain1:    "oc26",

	RegionMEAbudhabi2: "oc29",
	RegionMEAbudhabi4: "oc29",

	RegionAPSeoul2:     "oc35",
	RegionAPSuwon1:     "oc35",
	RegionAPChuncheon2: "oc35",

	RegionUSAshburn2: "oc42",
	RegionUSNewark1:  "oc42",

	RegionEUBudapest1: "oc51",
}
