/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 85;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 16;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 75,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 13,
  Feature_NoV5TBit = 65,
  Feature_HasV5TEBit = 11,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 9,
  Feature_HasV6MBit = 28,
  Feature_HasV8MBaselineBit = 35,
  Feature_HasV8_1MMainlineBit = 41,
  Feature_HasMVEIntBit = 63,
  Feature_HasMVEFloatBit = 64,
  Feature_HasCDEBit = 84,
  Feature_HasFPRegsBit = 42,
  Feature_HasFPRegs16Bit = 43,
  Feature_HasFPRegs64Bit = 76,
  Feature_HasV6T2Bit = 8,
  Feature_HasV6KBit = 18,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 55,
  Feature_PreV8Bit = 19,
  Feature_HasV8_1aBit = 78,
  Feature_HasV8_3aBit = 79,
  Feature_NoVFPBit = 22,
  Feature_HasVFP2Bit = 21,
  Feature_HasVFP3Bit = 52,
  Feature_HasVFP4Bit = 50,
  Feature_HasDPVFPBit = 44,
  Feature_HasFPARMv8Bit = 47,
  Feature_HasNEONBit = 53,
  Feature_HasSHA2Bit = 62,
  Feature_HasAESBit = 54,
  Feature_HasDotProdBit = 56,
  Feature_HasCRCBit = 14,
  Feature_HasLOBBit = 40,
  Feature_HasFP16Bit = 61,
  Feature_HasFullFP16Bit = 46,
  Feature_HasMatMulInt8Bit = 57,
  Feature_HasDivideInThumbBit = 37,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 36,
  Feature_HasDBBit = 15,
  Feature_HasV7ClrexBit = 17,
  Feature_HasAcquireReleaseBit = 16,
  Feature_HasMPBit = 2,
  Feature_Has8MSecExtBit = 29,
  Feature_HasZCZBit = 58,
  Feature_UseNEONForFPBit = 82,
  Feature_DontUseNEONForFPBit = 45,
  Feature_IsThumbBit = 26,
  Feature_IsThumb1OnlyBit = 27,
  Feature_IsThumb2Bit = 34,
  Feature_IsNotMClassBit = 38,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPTPIDRURWBit = 68,
  Feature_IsReadTPTPIDRUROBit = 69,
  Feature_IsReadTPTPIDRPRWBit = 70,
  Feature_IsReadTPSoftBit = 20,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 39,
  Feature_DontUseMovtBit = 23,
  Feature_UseMovtInPicBit = 24,
  Feature_DontUseMovtInPicBit = 25,
  Feature_UseFPVMLxBit = 49,
  Feature_SLSBLRMitigationBit = 67,
  Feature_NoSLSBLRMitigationBit = 66,
  Feature_UseMulOpsBit = 10,
  Feature_UseFusedMACBit = 51,
  Feature_HasFastVGETLNi32Bit = 59,
  Feature_HasSlowVGETLNi32Bit = 80,
  Feature_HasFastVDUP32Bit = 60,
  Feature_HasSlowVDUP32Bit = 81,
  Feature_UseVMOVSRBit = 48,
  Feature_DontUseVMOVSRBit = 83,
  Feature_IsLEBit = 74,
  Feature_IsBEBit = 77,
  Feature_GenExecuteOnlyBit = 33,
  Feature_DontGenExecuteOnlyBit = 32,
  Feature_GenT1ExecuteOnlyBit = 73,
  Feature_SignRetAddrBit = 72,
  Feature_NoSignRetAddrBit = 71,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features.set(Feature_NoHonorSignDependentRoundingBit);
  if (Subtarget->hasV4TOps())
    Features.set(Feature_HasV4TBit);
  if (!Subtarget->hasV4TOps())
    Features.set(Feature_NoV4TBit);
  if (Subtarget->hasV5TOps())
    Features.set(Feature_HasV5TBit);
  if (!Subtarget->hasV5TOps())
    Features.set(Feature_NoV5TBit);
  if (Subtarget->hasV5TEOps())
    Features.set(Feature_HasV5TEBit);
  if (Subtarget->hasV6Ops())
    Features.set(Feature_HasV6Bit);
  if (!Subtarget->hasV6Ops())
    Features.set(Feature_NoV6Bit);
  if (Subtarget->hasV6MOps())
    Features.set(Feature_HasV6MBit);
  if (Subtarget->hasV8MBaselineOps())
    Features.set(Feature_HasV8MBaselineBit);
  if (Subtarget->hasV8_1MMainlineOps())
    Features.set(Feature_HasV8_1MMainlineBit);
  if (Subtarget->hasMVEIntegerOps())
    Features.set(Feature_HasMVEIntBit);
  if (Subtarget->hasMVEFloatOps())
    Features.set(Feature_HasMVEFloatBit);
  if (Subtarget->hasCDEOps())
    Features.set(Feature_HasCDEBit);
  if (Subtarget->hasFPRegs())
    Features.set(Feature_HasFPRegsBit);
  if (Subtarget->hasFPRegs16())
    Features.set(Feature_HasFPRegs16Bit);
  if (Subtarget->hasFPRegs64())
    Features.set(Feature_HasFPRegs64Bit);
  if (Subtarget->hasV6T2Ops())
    Features.set(Feature_HasV6T2Bit);
  if (Subtarget->hasV6KOps())
    Features.set(Feature_HasV6KBit);
  if (Subtarget->hasV7Ops())
    Features.set(Feature_HasV7Bit);
  if (Subtarget->hasV8Ops())
    Features.set(Feature_HasV8Bit);
  if (!Subtarget->hasV8Ops())
    Features.set(Feature_PreV8Bit);
  if (Subtarget->hasV8_1aOps())
    Features.set(Feature_HasV8_1aBit);
  if (Subtarget->hasV8_3aOps())
    Features.set(Feature_HasV8_3aBit);
  if (!Subtarget->hasVFP2Base())
    Features.set(Feature_NoVFPBit);
  if (Subtarget->hasVFP2Base())
    Features.set(Feature_HasVFP2Bit);
  if (Subtarget->hasVFP3Base())
    Features.set(Feature_HasVFP3Bit);
  if (Subtarget->hasVFP4Base())
    Features.set(Feature_HasVFP4Bit);
  if (Subtarget->hasFP64())
    Features.set(Feature_HasDPVFPBit);
  if (Subtarget->hasFPARMv8Base())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLOB())
    Features.set(Feature_HasLOBBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasDivideInThumbMode())
    Features.set(Feature_HasDivideInThumbBit);
  if (Subtarget->hasDivideInARMMode())
    Features.set(Feature_HasDivideInARMBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDataBarrier())
    Features.set(Feature_HasDBBit);
  if (Subtarget->hasV7Clrex())
    Features.set(Feature_HasV7ClrexBit);
  if (Subtarget->hasAcquireRelease())
    Features.set(Feature_HasAcquireReleaseBit);
  if (Subtarget->hasMPExtension())
    Features.set(Feature_HasMPBit);
  if (Subtarget->has8MSecExt())
    Features.set(Feature_Has8MSecExtBit);
  if (Subtarget->hasZeroCycleZeroing())
    Features.set(Feature_HasZCZBit);
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseNEONForFPBit);
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseNEONForFPBit);
  if (Subtarget->isThumb())
    Features.set(Feature_IsThumbBit);
  if (Subtarget->isThumb1Only())
    Features.set(Feature_IsThumb1OnlyBit);
  if (Subtarget->isThumb2())
    Features.set(Feature_IsThumb2Bit);
  if (!Subtarget->isMClass())
    Features.set(Feature_IsNotMClassBit);
  if (!Subtarget->isThumb())
    Features.set(Feature_IsARMBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (!Subtarget->isTargetWindows())
    Features.set(Feature_IsNotWindowsBit);
  if (Subtarget->isReadTPTPIDRURW())
    Features.set(Feature_IsReadTPTPIDRURWBit);
  if (Subtarget->isReadTPTPIDRURO())
    Features.set(Feature_IsReadTPTPIDRUROBit);
  if (Subtarget->isReadTPTPIDRPRW())
    Features.set(Feature_IsReadTPTPIDRPRWBit);
  if (Subtarget->isReadTPSoft())
    Features.set(Feature_IsReadTPSoftBit);
  if (Subtarget->useNaClTrap())
    Features.set(Feature_UseNaClTrapBit);
  if (!Subtarget->useNaClTrap())
    Features.set(Feature_DontUseNaClTrapBit);
  if (Subtarget->useMulOps())
    Features.set(Feature_UseMulOpsBit);
  if (TM.Options.AllowFPOpFusion ==  FPOpFusion::Fast && Subtarget->useFPVFMx())
    Features.set(Feature_UseFusedMACBit);
  if (!Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasFastVGETLNi32Bit);
  if (Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasSlowVGETLNi32Bit);
  if (!Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasFastVDUP32Bit);
  if (Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasSlowVDUP32Bit);
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseVMOVSRBit);
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseVMOVSRBit);
  if (Subtarget->genExecuteOnly())
    Features.set(Feature_GenExecuteOnlyBit);
  if (!Subtarget->genExecuteOnly())
    Features.set(Feature_DontGenExecuteOnlyBit);
  if (Subtarget->genExecuteOnly() && Subtarget->isThumb1Only() && !Subtarget->hasV8MBaselineOps())
    Features.set(Feature_GenT1ExecuteOnlyBit);
  return Features;
}

void ARMInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const ARMSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (Subtarget->useMovt())
    Features.set(Feature_UseMovtBit);
  if (!Subtarget->useMovt())
    Features.set(Feature_DontUseMovtBit);
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_UseMovtInPicBit);
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_DontUseMovtInPicBit);
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features.set(Feature_UseFPVMLxBit);
  if ( MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (MF->getDataLayout().isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (MF->getDataLayout().isBigEndian())
    Features.set(Feature_IsBEBit);
  if ( MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_SignRetAddrBit);
  if ( !MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_NoSignRetAddrBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_DontUseNaClTrap_IsARM,
  GIFBS_DontUseVMOVSR_HasNEON,
  GIFBS_Has8MSecExt_IsThumb,
  GIFBS_HasAES_HasV8,
  GIFBS_HasCRC_IsARM,
  GIFBS_HasCRC_IsThumb2,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPARMv8_HasNEON,
  GIFBS_HasFPRegs_HasFastVGETLNi32,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_HasV8_1MMainline,
  GIFBS_HasMVEInt_IsBE,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasV8_3a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasNEON_UseNEONForFP,
  GIFBS_HasSHA2_HasV8,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5T_IsThumb,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV5T,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsARM_UseNaClTrap,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_NoV5T,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_DontUseMovt_GenExecuteOnly_IsThumb1Only,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFPARMv8_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_HasV8_3a,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasLOB_HasV8_1MMainline_IsThumb2,
  GIFBS_HasNEON_UseFPVMLx_UseNEONForFP,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_HasVFP4_UseFusedMAC_UseNEONForFP,
  GIFBS_IsARM_NoV6_UseMulOps,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_DontUseNaClTrapBit, Feature_IsARMBit, },
  {Feature_DontUseVMOVSRBit, Feature_HasNEONBit, },
  {Feature_Has8MSecExtBit, Feature_IsThumbBit, },
  {Feature_HasAESBit, Feature_HasV8Bit, },
  {Feature_HasCRCBit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_IsThumb2Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_HasFastVGETLNi32Bit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsBEBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_UseNEONForFPBit, },
  {Feature_HasSHA2Bit, Feature_HasV8Bit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TBit, Feature_IsThumbBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV5TBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsARMBit, Feature_UseNaClTrapBit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_NoV5TBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_DontUseMovtBit, Feature_GenExecuteOnlyBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFPARMv8Bit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasLOBBit, Feature_HasV8_1MMainlineBit, Feature_IsThumb2Bit, },
  {Feature_HasNEONBit, Feature_UseFPVMLxBit, Feature_UseNEONForFPBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasVFP4Bit, Feature_UseFusedMACBit, Feature_UseNEONForFPBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_bf_inv_mask_imm = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_vfp_f32imm,
  GICXXPred_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_bf_inv_mask_imm: {
    
        // There's better methods of implementing this check. IntImmLeaf<> would be
        // equivalent and have less boilerplate but we need a test for C++
        // predicates and this one causes new rules to be imported into GlobalISel
        // without requiring additional features first.
        const auto &MO = MI.getOperand(1);
        if (!MO.isCImm())
          return false;
        return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
      
    llvm_unreachable("bf_inv_mask_imm should have returned");
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_vfp_f32imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f32imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f64imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f64imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool ARMInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex8 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex16,
  GICXXPred_I64_Predicate_VectorIndex32,
  GICXXPred_I64_Predicate_VectorIndex64,
  GICXXPred_I64_Predicate_asr_imm,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_32,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_239,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm0_255_expr,
  GICXXPred_I64_Predicate_imm0_4095,
  GICXXPred_I64_Predicate_imm0_65535,
  GICXXPred_I64_Predicate_imm0_65535_expr,
  GICXXPred_I64_Predicate_imm0_65535_neg,
  GICXXPred_I64_Predicate_imm1_7,
  GICXXPred_I64_Predicate_imm1_15,
  GICXXPred_I64_Predicate_imm1_16,
  GICXXPred_I64_Predicate_imm1_31,
  GICXXPred_I64_Predicate_imm8,
  GICXXPred_I64_Predicate_imm8_255,
  GICXXPred_I64_Predicate_imm8_or_16,
  GICXXPred_I64_Predicate_imm16,
  GICXXPred_I64_Predicate_imm16_31,
  GICXXPred_I64_Predicate_imm24b,
  GICXXPred_I64_Predicate_imm32,
  GICXXPred_I64_Predicate_imm256_510,
  GICXXPred_I64_Predicate_imm_3b,
  GICXXPred_I64_Predicate_imm_4b,
  GICXXPred_I64_Predicate_imm_6b,
  GICXXPred_I64_Predicate_imm_7b,
  GICXXPred_I64_Predicate_imm_9b,
  GICXXPred_I64_Predicate_imm_11b,
  GICXXPred_I64_Predicate_imm_12b,
  GICXXPred_I64_Predicate_imm_13b,
  GICXXPred_I64_Predicate_imm_even,
  GICXXPred_I64_Predicate_imm_odd,
  GICXXPred_I64_Predicate_imm_sr,
  GICXXPred_I64_Predicate_long_shift,
  GICXXPred_I64_Predicate_mod_imm,
  GICXXPred_I64_Predicate_mod_imm_not,
  GICXXPred_I64_Predicate_pkh_asr_amt,
  GICXXPred_I64_Predicate_pkh_lsl_amt,
  GICXXPred_I64_Predicate_shr_imm8,
  GICXXPred_I64_Predicate_shr_imm16,
  GICXXPred_I64_Predicate_shr_imm32,
  GICXXPred_I64_Predicate_shr_imm64,
  GICXXPred_I64_Predicate_t2_so_imm,
  GICXXPred_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex8: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex16: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex32: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex64: {
    
      return ((uint64_t)Imm) < 1;
    
  }
  case GICXXPred_I64_Predicate_asr_imm: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return Imm >= 0 && Imm < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return Imm >= 0 && Imm < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return Imm >= 0 && Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_32: {
    
      return Imm >= 0 && Imm < 33;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return Imm >= 0 && Imm < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
  }
  case GICXXPred_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_255_expr: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_4095: {
    
      return Imm >= 0 && Imm < 4096;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_expr: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_neg: {
    
      return -Imm >= 0 && -Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
  }
  case GICXXPred_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_imm1_16: {
    
        return Imm > 0 && Imm <= 16;
      
  }
  case GICXXPred_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_imm8: {
     return Imm == 8; 
  }
  case GICXXPred_I64_Predicate_imm8_255: {
    
      return Imm >= 8 && Imm < 256;
    
  }
  case GICXXPred_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
  }
  case GICXXPred_I64_Predicate_imm16: {
     return Imm == 16; 
  }
  case GICXXPred_I64_Predicate_imm16_31: {
    
      return (int32_t)Imm >= 16 && (int32_t)Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm24b: {
    
      return Imm >= 0 && Imm <= 0xffffff;
    
  }
  case GICXXPred_I64_Predicate_imm32: {
     return Imm == 32; 
  }
  case GICXXPred_I64_Predicate_imm256_510: {
    
      return Imm >= 256 && Imm < 511;
    
  }
  case GICXXPred_I64_Predicate_imm_3b: {
    { return Imm >= 0 && Imm < (1 << 3); }
    llvm_unreachable("imm_3b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_4b: {
    { return Imm >= 0 && Imm < (1 << 4); }
    llvm_unreachable("imm_4b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_6b: {
    { return Imm >= 0 && Imm < (1 << 6); }
    llvm_unreachable("imm_6b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_7b: {
    { return Imm >= 0 && Imm < (1 << 7); }
    llvm_unreachable("imm_7b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_9b: {
    { return Imm >= 0 && Imm < (1 << 9); }
    llvm_unreachable("imm_9b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_11b: {
    { return Imm >= 0 && Imm < (1 << 11); }
    llvm_unreachable("imm_11b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_12b: {
    { return Imm >= 0 && Imm < (1 << 12); }
    llvm_unreachable("imm_12b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_13b: {
    { return Imm >= 0 && Imm < (1 << 13); }
    llvm_unreachable("imm_13b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
  }
  case GICXXPred_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
  }
  case GICXXPred_I64_Predicate_imm_sr: {
    
      return Imm > 0 && Imm <= 32;
    
  }
  case GICXXPred_I64_Predicate_long_shift: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_mod_imm: {
    
        return ARM_AM::getSOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_mod_imm_not: {
    
        return ARM_AM::getSOImmVal(~(uint32_t)Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
  }
  case GICXXPred_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
  }
  case GICXXPred_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
  }
  case GICXXPred_I64_Predicate_t2_so_imm: {
    
        return ARM_AM::getT2SOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_t2_so_imm_neg: {
    
      return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_arm_i32imm = GICXXPred_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_arm_i32imm: {
    
      if (Subtarget->useMovt())
        return true;
      if (ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue()))
        return true;
      return ARM_AM::isSOImmTwoPartValNeg(Imm.getZExtValue());
    
    llvm_unreachable("arm_i32imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("ARMInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderInvertedImm,
  GICR_renderVFPF32Imm,
  GICR_renderVFPF64Imm,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &ARMInstructionSelector::renderInvertedImm,
  &ARMInstructionSelector::renderVFPF32Imm,
  &ARMInstructionSelector::renderVFPF64Imm,
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool ARMInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("ARMInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(312), /*)*//*default:*//*Label 79*/ GIMT_Encode4(130769),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1046),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(10373),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(13617),
     /*     22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(15321),
     /*     26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(15417), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(15513),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(18693),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(24502), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    114 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(26197), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(26584), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(35596),
     /*    146 */ /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(36004), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 12*/ GIMT_Encode4(36379), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 13*/ GIMT_Encode4(36754), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 14*/ GIMT_Encode4(36917), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 15*/ GIMT_Encode4(36938),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 16*/ GIMT_Encode4(91006), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 17*/ GIMT_Encode4(98668),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 18*/ GIMT_Encode4(98826), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 19*/ GIMT_Encode4(98984),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 20*/ GIMT_Encode4(99305), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 21*/ GIMT_Encode4(99401),
     /*    370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 22*/ GIMT_Encode4(99559),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 23*/ GIMT_Encode4(100164),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 24*/ GIMT_Encode4(100322),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 25*/ GIMT_Encode4(100538),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 26*/ GIMT_Encode4(100646), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 27*/ GIMT_Encode4(100919), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 28*/ GIMT_Encode4(101251),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 29*/ GIMT_Encode4(101499),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 30*/ GIMT_Encode4(101868),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 31*/ GIMT_Encode4(102513),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 32*/ GIMT_Encode4(103813),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 33*/ GIMT_Encode4(104458), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 34*/ GIMT_Encode4(105478),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 35*/ GIMT_Encode4(107831),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 36*/ GIMT_Encode4(109508),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 37*/ GIMT_Encode4(110489), GIMT_Encode4(0),
     /*    550 */ /*TargetOpcode::G_FDIV*//*Label 38*/ GIMT_Encode4(112580), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 39*/ GIMT_Encode4(112745),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 40*/ GIMT_Encode4(114276),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 41*/ GIMT_Encode4(114512),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 42*/ GIMT_Encode4(114784),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 43*/ GIMT_Encode4(116118),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 44*/ GIMT_Encode4(117452),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 45*/ GIMT_Encode4(118104), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 46*/ GIMT_Encode4(118756), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 47*/ GIMT_Encode4(119532),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 48*/ GIMT_Encode4(120124), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    666 */ /*TargetOpcode::G_FMINIMUM*//*Label 49*/ GIMT_Encode4(120716),
     /*    670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 50*/ GIMT_Encode4(121450), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    682 */ /*TargetOpcode::G_GET_FPENV*//*Label 51*/ GIMT_Encode4(122184),
     /*    686 */ /*TargetOpcode::G_SET_FPENV*//*Label 52*/ GIMT_Encode4(122217),
     /*    690 */ /*TargetOpcode::G_RESET_FPENV*//*Label 53*/ GIMT_Encode4(122253),
     /*    694 */ /*TargetOpcode::G_GET_FPMODE*//*Label 54*/ GIMT_Encode4(122382), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 55*/ GIMT_Encode4(122415),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 56*/ GIMT_Encode4(122958),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 57*/ GIMT_Encode4(123501),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 58*/ GIMT_Encode4(124422),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 59*/ GIMT_Encode4(125343), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 60*/ GIMT_Encode4(125814), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    766 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 61*/ GIMT_Encode4(125887),
     /*    770 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 62*/ GIMT_Encode4(126187), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    798 */ /*TargetOpcode::G_CTLZ*//*Label 63*/ GIMT_Encode4(126244), GIMT_Encode4(0),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 64*/ GIMT_Encode4(126805),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 65*/ GIMT_Encode4(126913),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 66*/ GIMT_Encode4(127203),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 67*/ GIMT_Encode4(127635), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 68*/ GIMT_Encode4(128010),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 69*/ GIMT_Encode4(128148),
     /*    874 */ /*TargetOpcode::G_FRINT*//*Label 70*/ GIMT_Encode4(128523),
     /*    878 */ /*TargetOpcode::G_FNEARBYINT*//*Label 71*/ GIMT_Encode4(128931), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    966 */ /*TargetOpcode::G_TRAP*//*Label 72*/ GIMT_Encode4(129069),
     /*    970 */ /*TargetOpcode::G_DEBUGTRAP*//*Label 73*/ GIMT_Encode4(129115), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1010 */ /*TargetOpcode::G_VECREDUCE_ADD*//*Label 74*/ GIMT_Encode4(129202), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1030 */ /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 75*/ GIMT_Encode4(129623),
     /*   1034 */ /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 76*/ GIMT_Encode4(129903),
     /*   1038 */ /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 77*/ GIMT_Encode4(130192),
     /*   1042 */ /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 78*/ GIMT_Encode4(130473),
     /*   1046 */ // Label 0: @1046
     /*   1046 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 89*/ GIMT_Encode4(10372),
     /*   1057 */ /*GILLT_s32*//*Label 80*/ GIMT_Encode4(1117),
     /*   1061 */ /*GILLT_s64*//*Label 81*/ GIMT_Encode4(6893), GIMT_Encode4(0),
     /*   1069 */ /*GILLT_v2s32*//*Label 82*/ GIMT_Encode4(6940),
     /*   1073 */ /*GILLT_v2s64*//*Label 83*/ GIMT_Encode4(7125), GIMT_Encode4(0),
     /*   1081 */ /*GILLT_v4s16*//*Label 84*/ GIMT_Encode4(7836),
     /*   1085 */ /*GILLT_v4s32*//*Label 85*/ GIMT_Encode4(8021), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1097 */ /*GILLT_v8s8*//*Label 86*/ GIMT_Encode4(8977),
     /*   1101 */ /*GILLT_v8s16*//*Label 87*/ GIMT_Encode4(9162), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1113 */ /*GILLT_v16s8*//*Label 88*/ GIMT_Encode4(10118),
     /*   1117 */ // Label 80: @1117
     /*   1117 */ GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(6892),
     /*   1122 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   1125 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   1128 */   GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1203), // Rule ID 5667 //
     /*   1133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   1136 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   1140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1148 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1152 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1156 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1161 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*   1172 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1176 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1178 */     // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1178 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
     /*   1181 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1183 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1185 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1189 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1192 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1195 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1201 */     GIR_RootConstrainSelectedInstOperands,
     /*   1202 */     // GIR_Coverage, 5667,
     /*   1202 */     GIR_EraseRootFromParent_Done,
     /*   1203 */   // Label 91: @1203
     /*   1203 */   GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1278), // Rule ID 5668 //
     /*   1208 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   1211 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   1215 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1219 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1223 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1227 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1231 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1236 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*   1247 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1251 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1253 */     // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1253 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
     /*   1256 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1258 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1260 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1264 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1267 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1270 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1276 */     GIR_RootConstrainSelectedInstOperands,
     /*   1277 */     // GIR_Coverage, 5668,
     /*   1277 */     GIR_EraseRootFromParent_Done,
     /*   1278 */   // Label 92: @1278
     /*   1278 */   GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1353), // Rule ID 5702 //
     /*   1283 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1286 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1290 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1294 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1298 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1302 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1306 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1311 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*   1322 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1326 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1328 */     // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1328 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
     /*   1331 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1333 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1335 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1339 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1345 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1351 */     GIR_RootConstrainSelectedInstOperands,
     /*   1352 */     // GIR_Coverage, 5702,
     /*   1352 */     GIR_EraseRootFromParent_Done,
     /*   1353 */   // Label 93: @1353
     /*   1353 */   GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1428), // Rule ID 5703 //
     /*   1358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1361 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1365 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1369 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1373 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1377 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1381 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1386 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*   1397 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1401 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1403 */     // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
     /*   1406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1408 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1414 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1417 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1420 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1426 */     GIR_RootConstrainSelectedInstOperands,
     /*   1427 */     // GIR_Coverage, 5703,
     /*   1427 */     GIR_EraseRootFromParent_Done,
     /*   1428 */   // Label 94: @1428
     /*   1428 */   GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1503), // Rule ID 1997 //
     /*   1433 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   1436 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   1440 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1452 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1456 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1460 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1465 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*   1476 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1478 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1478 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
     /*   1481 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1483 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   1485 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1489 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1492 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1495 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1501 */     GIR_RootConstrainSelectedInstOperands,
     /*   1502 */     // GIR_Coverage, 1997,
     /*   1502 */     GIR_EraseRootFromParent_Done,
     /*   1503 */   // Label 95: @1503
     /*   1503 */   GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1578), // Rule ID 1998 //
     /*   1508 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   1511 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   1515 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1519 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1523 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1527 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1531 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1535 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   1540 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*   1551 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1553 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1553 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
     /*   1556 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1558 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   1560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1567 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1570 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1576 */     GIR_RootConstrainSelectedInstOperands,
     /*   1577 */     // GIR_Coverage, 1998,
     /*   1577 */     GIR_EraseRootFromParent_Done,
     /*   1578 */   // Label 96: @1578
     /*   1578 */   GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1653), // Rule ID 2236 //
     /*   1583 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1586 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1590 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1594 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1598 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1602 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1606 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1610 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1615 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*   1626 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1628 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
     /*   1631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1633 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   1635 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1642 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1645 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1651 */     GIR_RootConstrainSelectedInstOperands,
     /*   1652 */     // GIR_Coverage, 2236,
     /*   1652 */     GIR_EraseRootFromParent_Done,
     /*   1653 */   // Label 97: @1653
     /*   1653 */   GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1728), // Rule ID 2237 //
     /*   1658 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1661 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1665 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1669 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1673 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   1677 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1681 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   1685 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1690 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*   1701 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1703 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   1703 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
     /*   1706 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1708 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   1710 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   1714 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   1717 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1720 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1726 */     GIR_RootConstrainSelectedInstOperands,
     /*   1727 */     // GIR_Coverage, 2237,
     /*   1727 */     GIR_EraseRootFromParent_Done,
     /*   1728 */   // Label 98: @1728
     /*   1728 */   GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1856), // Rule ID 5678 //
     /*   1733 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1740 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1744 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   1748 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1752 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   1756 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   1760 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   1764 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   1768 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*   1772 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*   1776 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   1780 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   1784 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1789 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*   1793 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
     /*   1797 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   1801 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*   1805 */     // MIs[4] Rm
     /*   1805 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*   1810 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*   1814 */     // MIs[1] Operand 2
     /*   1814 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   1825 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1829 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   1831 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] })), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   1831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   1834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1836 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   1842 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   1845 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1848 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1854 */     GIR_RootConstrainSelectedInstOperands,
     /*   1855 */     // GIR_Coverage, 5678,
     /*   1855 */     GIR_EraseRootFromParent_Done,
     /*   1856 */   // Label 99: @1856
     /*   1856 */   GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1984), // Rule ID 5679 //
     /*   1861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1864 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1868 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1872 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   1876 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   1880 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   1884 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   1888 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   1892 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   1896 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*   1900 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   1904 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   1908 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   1912 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1917 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*   1921 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
     /*   1925 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*   1929 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*   1933 */     // MIs[4] Rm
     /*   1933 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*   1938 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
     /*   1942 */     // MIs[1] Operand 2
     /*   1942 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   1953 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1957 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   1959 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] })), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   1959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   1962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   1964 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   1966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   1970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   1973 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   1976 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   1982 */     GIR_RootConstrainSelectedInstOperands,
     /*   1983 */     // GIR_Coverage, 5679,
     /*   1983 */     GIR_EraseRootFromParent_Done,
     /*   1984 */   // Label 100: @1984
     /*   1984 */   GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2112), // Rule ID 2103 //
     /*   1989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   1992 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   1996 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   2008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2012 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2016 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   2020 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2024 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2028 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*   2032 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*   2036 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2040 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2044 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2049 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*   2053 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
     /*   2057 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   2061 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*   2065 */     // MIs[4] Rm
     /*   2065 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*   2070 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*   2074 */     // MIs[1] Operand 2
     /*   2074 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   2085 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   2087 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] })), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   2087 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   2090 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2092 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   2094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   2101 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2104 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2110 */     GIR_RootConstrainSelectedInstOperands,
     /*   2111 */     // GIR_Coverage, 2103,
     /*   2111 */     GIR_EraseRootFromParent_Done,
     /*   2112 */   // Label 101: @2112
     /*   2112 */   GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2240), // Rule ID 5677 //
     /*   2117 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   2120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2124 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2128 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2132 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   2136 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2140 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2144 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   2148 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2152 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2156 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*   2160 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   2164 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2168 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2172 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2177 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*   2181 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
     /*   2185 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*   2189 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*   2193 */     // MIs[4] Rm
     /*   2193 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*   2198 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
     /*   2202 */     // MIs[1] Operand 2
     /*   2202 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   2213 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*   2215 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] })), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   2215 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   2218 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2220 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   2222 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2226 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   2229 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2232 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2238 */     GIR_RootConstrainSelectedInstOperands,
     /*   2239 */     // GIR_Coverage, 5677,
     /*   2239 */     GIR_EraseRootFromParent_Done,
     /*   2240 */   // Label 102: @2240
     /*   2240 */   GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(2350), // Rule ID 5446 //
     /*   2245 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   2248 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2260 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2264 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2268 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2272 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2276 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2280 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2284 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2289 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2293 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2297 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2301 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2305 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2309 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2314 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   2318 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   2322 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2324 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   2324 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
     /*   2327 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   2333 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2337 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   2339 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2342 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2348 */     GIR_RootConstrainSelectedInstOperands,
     /*   2349 */     // GIR_Coverage, 5446,
     /*   2349 */     GIR_EraseRootFromParent_Done,
     /*   2350 */   // Label 103: @2350
     /*   2350 */   GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(2460), // Rule ID 5483 //
     /*   2355 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   2358 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2362 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2366 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2370 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2374 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2378 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2382 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2386 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2390 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2394 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2399 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2403 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2407 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2411 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2415 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2419 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2424 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   2428 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2432 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2434 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   2434 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
     /*   2437 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2439 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   2443 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2447 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   2449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2452 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2458 */     GIR_RootConstrainSelectedInstOperands,
     /*   2459 */     // GIR_Coverage, 5483,
     /*   2459 */     GIR_EraseRootFromParent_Done,
     /*   2460 */   // Label 104: @2460
     /*   2460 */   GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2570), // Rule ID 192 //
     /*   2465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   2468 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2472 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   2476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2484 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2488 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2492 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2496 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2500 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2504 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2508 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2513 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2517 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2521 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2525 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2529 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2533 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2538 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   2542 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2544 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   2544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
     /*   2547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2549 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   2553 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2557 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   2559 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2562 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2568 */     GIR_RootConstrainSelectedInstOperands,
     /*   2569 */     // GIR_Coverage, 192,
     /*   2569 */     GIR_EraseRootFromParent_Done,
     /*   2570 */   // Label 105: @2570
     /*   2570 */   GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2680), // Rule ID 521 //
     /*   2575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   2578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2582 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2586 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2590 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2594 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2598 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2602 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2606 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2610 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2614 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2618 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2623 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2627 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2631 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2635 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2639 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2643 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2648 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   2652 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2654 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   2654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
     /*   2657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2659 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   2663 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   2667 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   2669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2672 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2678 */     GIR_RootConstrainSelectedInstOperands,
     /*   2679 */     // GIR_Coverage, 521,
     /*   2679 */     GIR_EraseRootFromParent_Done,
     /*   2680 */   // Label 106: @2680
     /*   2680 */   GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2793), // Rule ID 5445 //
     /*   2685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   2688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2692 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2696 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2700 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2704 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2708 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2712 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2716 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2720 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2724 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2729 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2733 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2737 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   2741 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2745 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2750 */     // MIs[3] Operand 2
     /*   2750 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   2761 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   2765 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2767 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   2767 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
     /*   2770 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
     /*   2776 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   2780 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   2782 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2785 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2791 */     GIR_RootConstrainSelectedInstOperands,
     /*   2792 */     // GIR_Coverage, 5445,
     /*   2792 */     GIR_EraseRootFromParent_Done,
     /*   2793 */   // Label 107: @2793
     /*   2793 */   GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(2906), // Rule ID 5482 //
     /*   2798 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   2801 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2805 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2809 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2813 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2817 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2821 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2825 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2829 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2833 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   2837 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2842 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   2846 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2850 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   2854 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2858 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2863 */     // MIs[3] Operand 2
     /*   2863 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   2874 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   2878 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2880 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   2880 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
     /*   2883 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2885 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
     /*   2889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   2893 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   2895 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   2898 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   2904 */     GIR_RootConstrainSelectedInstOperands,
     /*   2905 */     // GIR_Coverage, 5482,
     /*   2905 */     GIR_EraseRootFromParent_Done,
     /*   2906 */   // Label 108: @2906
     /*   2906 */   GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(3019), // Rule ID 5444 //
     /*   2911 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   2914 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2918 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2922 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   2926 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2930 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2934 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   2938 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   2942 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   2946 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2951 */     // MIs[2] Operand 2
     /*   2951 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   2962 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   2966 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   2970 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   2974 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   2978 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   2983 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   2987 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   2991 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   2993 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   2993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
     /*   2996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   2998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3006 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   3008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3011 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3017 */     GIR_RootConstrainSelectedInstOperands,
     /*   3018 */     // GIR_Coverage, 5444,
     /*   3018 */     GIR_EraseRootFromParent_Done,
     /*   3019 */   // Label 109: @3019
     /*   3019 */   GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(3132), // Rule ID 5481 //
     /*   3024 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   3027 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3031 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3035 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3039 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3043 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3047 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3051 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3055 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3059 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3064 */     // MIs[2] Operand 2
     /*   3064 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   3075 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3079 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   3083 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3087 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   3091 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3096 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   3100 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3104 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3106 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   3106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
     /*   3109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3115 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3119 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   3121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3124 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3130 */     GIR_RootConstrainSelectedInstOperands,
     /*   3131 */     // GIR_Coverage, 5481,
     /*   3131 */     GIR_EraseRootFromParent_Done,
     /*   3132 */   // Label 110: @3132
     /*   3132 */   GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(3245), // Rule ID 191 //
     /*   3137 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   3140 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3144 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   3148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3160 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3164 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3168 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   3172 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   3180 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3185 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   3189 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3193 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3197 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3201 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3206 */     // MIs[3] Operand 2
     /*   3206 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   3217 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3219 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (SMLATB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   3219 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATB),
     /*   3222 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3224 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3228 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3232 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   3234 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3237 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3243 */     GIR_RootConstrainSelectedInstOperands,
     /*   3244 */     // GIR_Coverage, 191,
     /*   3244 */     GIR_EraseRootFromParent_Done,
     /*   3245 */   // Label 111: @3245
     /*   3245 */   GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(3358), // Rule ID 520 //
     /*   3250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   3253 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3257 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3261 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3265 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3269 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3273 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3277 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3281 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   3285 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3289 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   3293 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3298 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*   3302 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3306 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3310 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3314 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3319 */     // MIs[3] Operand 2
     /*   3319 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   3330 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3332 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (t2SMLATB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   3332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATB),
     /*   3335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3337 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3341 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3345 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   3347 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3350 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3356 */     GIR_RootConstrainSelectedInstOperands,
     /*   3357 */     // GIR_Coverage, 520,
     /*   3357 */     GIR_EraseRootFromParent_Done,
     /*   3358 */   // Label 112: @3358
     /*   3358 */   GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(3471), // Rule ID 190 //
     /*   3363 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   3366 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3370 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   3374 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3378 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3382 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3386 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3390 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3394 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3398 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3402 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3407 */     // MIs[2] Operand 2
     /*   3407 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   3418 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3422 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   3426 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3430 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   3434 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3439 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   3443 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3445 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   3445 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
     /*   3448 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3450 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3458 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   3460 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3463 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3469 */     GIR_RootConstrainSelectedInstOperands,
     /*   3470 */     // GIR_Coverage, 190,
     /*   3470 */     GIR_EraseRootFromParent_Done,
     /*   3471 */   // Label 113: @3471
     /*   3471 */   GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(3584), // Rule ID 519 //
     /*   3476 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   3479 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3483 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3487 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3491 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3495 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3499 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3503 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3507 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3511 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3515 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3520 */     // MIs[2] Operand 2
     /*   3520 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   3531 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3535 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*   3539 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3543 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*   3547 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3552 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*   3556 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3558 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   3558 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
     /*   3561 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3563 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3567 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3571 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   3573 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3576 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3582 */     GIR_RootConstrainSelectedInstOperands,
     /*   3583 */     // GIR_Coverage, 519,
     /*   3583 */     GIR_EraseRootFromParent_Done,
     /*   3584 */   // Label 114: @3584
     /*   3584 */   GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(3675), // Rule ID 5676 //
     /*   3589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   3592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3596 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3608 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3612 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ROTR),
     /*   3616 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3620 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   3624 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3629 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*   3633 */     // MIs[1] Operand 2
     /*   3633 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   3644 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3648 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   3650 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (rotr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   3650 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   3653 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3655 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   3657 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   3661 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   3664 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3667 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3673 */     GIR_RootConstrainSelectedInstOperands,
     /*   3674 */     // GIR_Coverage, 5676,
     /*   3674 */     GIR_EraseRootFromParent_Done,
     /*   3675 */   // Label 115: @3675
     /*   3675 */   GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(3766), // Rule ID 2102 //
     /*   3680 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   3683 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3687 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3691 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3695 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3699 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3703 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3707 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ROTR),
     /*   3711 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3715 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*   3719 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3724 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*   3728 */     // MIs[1] Operand 2
     /*   3728 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   3739 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   3741 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (rotr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
     /*   3741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   3744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3746 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   3748 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*   3752 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   3755 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3758 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3764 */     GIR_RootConstrainSelectedInstOperands,
     /*   3765 */     // GIR_Coverage, 2102,
     /*   3765 */     GIR_EraseRootFromParent_Done,
     /*   3766 */   // Label 116: @3766
     /*   3766 */   GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(3882), // Rule ID 5443 //
     /*   3771 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   3774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3778 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3790 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3794 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3798 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3802 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3806 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3811 */     // MIs[2] Operand 2
     /*   3811 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   3822 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3826 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3830 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3834 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   3839 */     // MIs[3] Operand 2
     /*   3839 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   3850 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   3854 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3856 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   3856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABB),
     /*   3859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3861 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3865 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3869 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   3871 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3874 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3880 */     GIR_RootConstrainSelectedInstOperands,
     /*   3881 */     // GIR_Coverage, 5443,
     /*   3881 */     GIR_EraseRootFromParent_Done,
     /*   3882 */   // Label 117: @3882
     /*   3882 */   GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(3998), // Rule ID 5480 //
     /*   3887 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   3890 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3894 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3898 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   3902 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   3906 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   3910 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3914 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3918 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   3922 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3927 */     // MIs[2] Operand 2
     /*   3927 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   3938 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3942 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   3946 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   3950 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3955 */     // MIs[3] Operand 2
     /*   3955 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   3966 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   3970 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3972 */     // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   3972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABB),
     /*   3975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   3977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   3981 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   3985 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   3987 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3990 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   3996 */     GIR_RootConstrainSelectedInstOperands,
     /*   3997 */     // GIR_Coverage, 5480,
     /*   3997 */     GIR_EraseRootFromParent_Done,
     /*   3998 */   // Label 118: @3998
     /*   3998 */   GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(4114), // Rule ID 189 //
     /*   4003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
     /*   4006 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   4010 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   4014 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4018 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4022 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   4026 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   4030 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4034 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   4038 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   4042 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   4047 */     // MIs[2] Operand 2
     /*   4047 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   4058 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   4062 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   4066 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   4070 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   4075 */     // MIs[3] Operand 2
     /*   4075 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   4086 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4088 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (SMLABB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   4088 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABB),
     /*   4091 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4093 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   4097 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   4101 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   4103 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4106 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4112 */     GIR_RootConstrainSelectedInstOperands,
     /*   4113 */     // GIR_Coverage, 189,
     /*   4113 */     GIR_EraseRootFromParent_Done,
     /*   4114 */   // Label 119: @4114
     /*   4114 */   GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(4230), // Rule ID 518 //
     /*   4119 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   4122 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4126 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4130 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4134 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4138 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   4142 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   4146 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4150 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   4154 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*   4158 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4163 */     // MIs[2] Operand 2
     /*   4163 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*   4174 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   4178 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   4182 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*   4186 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4191 */     // MIs[3] Operand 2
     /*   4191 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*   4202 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4204 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (t2SMLABB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   4204 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABB),
     /*   4207 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4209 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*   4213 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*   4217 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   4219 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4222 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4228 */     GIR_RootConstrainSelectedInstOperands,
     /*   4229 */     // GIR_Coverage, 518,
     /*   4229 */     GIR_EraseRootFromParent_Done,
     /*   4230 */   // Label 120: @4230
     /*   4230 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(4318), // Rule ID 3245 //
     /*   4235 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4242 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4246 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4250 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4254 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4258 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4262 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4266 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4270 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4275 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4280 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4284 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4286 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau32:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v4i32] }:$src1, ?:{ *:[v4i32] }:$src2)
     /*   4286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau32),
     /*   4289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4291 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   4293 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4297 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4301 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4304 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4310 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4316 */     GIR_RootConstrainSelectedInstOperands,
     /*   4317 */     // GIR_Coverage, 3245,
     /*   4317 */     GIR_EraseRootFromParent_Done,
     /*   4318 */   // Label 121: @4318
     /*   4318 */   GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(4406), // Rule ID 3246 //
     /*   4323 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4326 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4330 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4334 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4338 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   4342 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4346 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4350 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   4354 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   4358 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4363 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4368 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4372 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4374 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau16:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v8i16] }:$src1, ?:{ *:[v8i16] }:$src2)
     /*   4374 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau16),
     /*   4377 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4379 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   4381 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4385 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4389 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4392 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4398 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4404 */     GIR_RootConstrainSelectedInstOperands,
     /*   4405 */     // GIR_Coverage, 3246,
     /*   4405 */     GIR_EraseRootFromParent_Done,
     /*   4406 */   // Label 122: @4406
     /*   4406 */   GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(4494), // Rule ID 3249 //
     /*   4411 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4414 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4418 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4422 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4426 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   4430 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4434 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4438 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   4442 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   4446 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4451 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4456 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4460 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4462 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$src1, MQPR:{ *:[v16i8] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau8:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v16i8] }:$src1, ?:{ *:[v16i8] }:$src2)
     /*   4462 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau8),
     /*   4465 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4467 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   4469 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4473 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4477 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4480 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4486 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4492 */     GIR_RootConstrainSelectedInstOperands,
     /*   4493 */     // GIR_Coverage, 3249,
     /*   4493 */     GIR_EraseRootFromParent_Done,
     /*   4494 */   // Label 123: @4494
     /*   4494 */   GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(4582), // Rule ID 5947 //
     /*   4499 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4502 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4506 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4510 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4514 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4518 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4522 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4526 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4530 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4534 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4538 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4543 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4548 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4550 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)))  =>  (MVE_VMLADAVau32:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v4i32] }:$src1, ?:{ *:[v4i32] }:$src2)
     /*   4550 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau32),
     /*   4553 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4555 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   4557 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4561 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4565 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4568 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4574 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4580 */     GIR_RootConstrainSelectedInstOperands,
     /*   4581 */     // GIR_Coverage, 5947,
     /*   4581 */     GIR_EraseRootFromParent_Done,
     /*   4582 */   // Label 124: @4582
     /*   4582 */   GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(4670), // Rule ID 5948 //
     /*   4587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4594 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4598 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4602 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4606 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   4610 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4614 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4618 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   4622 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   4626 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4631 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4636 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4638 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)))  =>  (MVE_VMLADAVau16:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v8i16] }:$src1, ?:{ *:[v8i16] }:$src2)
     /*   4638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau16),
     /*   4641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4643 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   4645 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4649 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4656 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4662 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4668 */     GIR_RootConstrainSelectedInstOperands,
     /*   4669 */     // GIR_Coverage, 5948,
     /*   4669 */     GIR_EraseRootFromParent_Done,
     /*   4670 */   // Label 125: @4670
     /*   4670 */   GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(4758), // Rule ID 5951 //
     /*   4675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   4678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4682 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   4686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   4694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   4698 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4702 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4706 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   4710 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   4714 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4719 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   4724 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4726 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$src1, MQPR:{ *:[v16i8] }:$src2)))  =>  (MVE_VMLADAVau8:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v16i8] }:$src1, ?:{ *:[v16i8] }:$src2)
     /*   4726 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau8),
     /*   4729 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
     /*   4731 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   4733 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*   4737 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*   4741 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   4744 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4750 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4756 */     GIR_RootConstrainSelectedInstOperands,
     /*   4757 */     // GIR_Coverage, 5951,
     /*   4757 */     GIR_EraseRootFromParent_Done,
     /*   4758 */   // Label 126: @4758
     /*   4758 */   GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(4815), // Rule ID 72 //
     /*   4763 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*   4766 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   4770 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   4774 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4778 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   4782 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*   4786 */     // MIs[1] Operand 1
     /*   4786 */     // No operand predicates
     /*   4786 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4788 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*   4788 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDri),
     /*   4791 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4793 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   4795 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   4798 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4801 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4807 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4813 */     GIR_RootConstrainSelectedInstOperands,
     /*   4814 */     // GIR_Coverage, 72,
     /*   4814 */     GIR_EraseRootFromParent_Done,
     /*   4815 */   // Label 127: @4815
     /*   4815 */   GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(4872), // Rule ID 303 //
     /*   4820 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*   4823 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   4827 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   4831 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4835 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   4839 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_7),
     /*   4843 */     // MIs[1] Operand 1
     /*   4843 */     // No operand predicates
     /*   4843 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4845 */     // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm0_7>>:$imm3)  =>  (tADDi3:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$imm3)
     /*   4845 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDi3),
     /*   4848 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4850 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*   4856 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*   4858 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm3
     /*   4861 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4864 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4870 */     GIR_RootConstrainSelectedInstOperands,
     /*   4871 */     // GIR_Coverage, 303,
     /*   4871 */     GIR_EraseRootFromParent_Done,
     /*   4872 */   // Label 128: @4872
     /*   4872 */   GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(4929), // Rule ID 304 //
     /*   4877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*   4880 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   4884 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   4888 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4892 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   4896 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_255_expr),
     /*   4900 */     // MIs[1] Operand 1
     /*   4900 */     // No operand predicates
     /*   4900 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4902 */     // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_255_expr>>:$imm8)  =>  (tADDi8:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm8)
     /*   4902 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDi8),
     /*   4905 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*   4907 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*   4913 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   4915 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm8
     /*   4918 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4921 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4927 */     GIR_RootConstrainSelectedInstOperands,
     /*   4928 */     // GIR_Coverage, 304,
     /*   4928 */     GIR_EraseRootFromParent_Done,
     /*   4929 */   // Label 129: @4929
     /*   4929 */   GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(4986), // Rule ID 407 //
     /*   4934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*   4937 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4941 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   4945 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4949 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   4953 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*   4957 */     // MIs[1] Operand 1
     /*   4957 */     // No operand predicates
     /*   4957 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4959 */     // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*   4959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri),
     /*   4962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   4964 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   4966 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   4969 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4972 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4978 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   4984 */     GIR_RootConstrainSelectedInstOperands,
     /*   4985 */     // GIR_Coverage, 407,
     /*   4985 */     GIR_EraseRootFromParent_Done,
     /*   4986 */   // Label 130: @4986
     /*   4986 */   GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(5037), // Rule ID 408 //
     /*   4991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*   4994 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   4998 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5002 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5006 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   5010 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
     /*   5014 */     // MIs[1] Operand 1
     /*   5014 */     // No operand predicates
     /*   5014 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5016 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*   5016 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri12),
     /*   5019 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5021 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   5023 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   5026 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5029 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5035 */     GIR_RootConstrainSelectedInstOperands,
     /*   5036 */     // GIR_Coverage, 408,
     /*   5036 */     GIR_EraseRootFromParent_Done,
     /*   5037 */   // Label 131: @5037
     /*   5037 */   GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(5113), // Rule ID 171 //
     /*   5042 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
     /*   5045 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5049 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5053 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5057 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5061 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5065 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5070 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5075 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5079 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5081 */     // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
     /*   5081 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
     /*   5084 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5086 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   5090 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   5094 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   5096 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5099 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5105 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5111 */     GIR_RootConstrainSelectedInstOperands,
     /*   5112 */     // GIR_Coverage, 171,
     /*   5112 */     GIR_EraseRootFromParent_Done,
     /*   5113 */   // Label 132: @5113
     /*   5113 */   GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(5189), // Rule ID 172 //
     /*   5118 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
     /*   5121 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5125 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5129 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5133 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5137 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5141 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5146 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5151 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5155 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5157 */     // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
     /*   5157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
     /*   5160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5162 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   5166 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   5170 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   5172 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5175 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5181 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5187 */     GIR_RootConstrainSelectedInstOperands,
     /*   5188 */     // GIR_Coverage, 172,
     /*   5188 */     GIR_EraseRootFromParent_Done,
     /*   5189 */   // Label 133: @5189
     /*   5189 */   GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(5259), // Rule ID 503 //
     /*   5194 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
     /*   5197 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5201 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5205 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5209 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5213 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5217 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5222 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5227 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5231 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5233 */     // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   5233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
     /*   5236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5238 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   5242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   5246 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   5248 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5251 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5257 */     GIR_RootConstrainSelectedInstOperands,
     /*   5258 */     // GIR_Coverage, 503,
     /*   5258 */     GIR_EraseRootFromParent_Done,
     /*   5259 */   // Label 134: @5259
     /*   5259 */   GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(5330), // Rule ID 5669 //
     /*   5264 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   5267 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5271 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5275 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   5279 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5283 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5288 */     // MIs[1] Operand 2
     /*   5288 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
     /*   5299 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5303 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5305 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i8:{ *:[Other] }), GPR:{ *:[i32] }:$Rn)  =>  (SXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   5305 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAB),
     /*   5308 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5310 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   5312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   5316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5319 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5322 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5328 */     GIR_RootConstrainSelectedInstOperands,
     /*   5329 */     // GIR_Coverage, 5669,
     /*   5329 */     GIR_EraseRootFromParent_Done,
     /*   5330 */   // Label 135: @5330
     /*   5330 */   GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(5401), // Rule ID 5670 //
     /*   5335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   5338 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5342 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5346 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   5350 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5354 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5359 */     // MIs[1] Operand 2
     /*   5359 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   5370 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5376 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] }), GPR:{ *:[i32] }:$Rn)  =>  (SXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   5376 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAH),
     /*   5379 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5381 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   5383 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   5387 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5390 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5393 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5399 */     GIR_RootConstrainSelectedInstOperands,
     /*   5400 */     // GIR_Coverage, 5670,
     /*   5400 */     GIR_EraseRootFromParent_Done,
     /*   5401 */   // Label 136: @5401
     /*   5401 */   GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(5472), // Rule ID 5704 //
     /*   5406 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   5409 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5413 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5417 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   5421 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5425 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5430 */     // MIs[1] Operand 2
     /*   5430 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
     /*   5441 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5445 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5447 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i8:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   5447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAB),
     /*   5450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5452 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   5454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   5458 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5461 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5464 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5470 */     GIR_RootConstrainSelectedInstOperands,
     /*   5471 */     // GIR_Coverage, 5704,
     /*   5471 */     GIR_EraseRootFromParent_Done,
     /*   5472 */   // Label 137: @5472
     /*   5472 */   GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(5543), // Rule ID 5705 //
     /*   5477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   5480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5484 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5488 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   5492 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5496 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5501 */     // MIs[1] Operand 2
     /*   5501 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   5512 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5516 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5518 */     // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   5518 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   5521 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5523 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   5525 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   5529 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5532 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5535 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5541 */     GIR_RootConstrainSelectedInstOperands,
     /*   5542 */     // GIR_Coverage, 5705,
     /*   5542 */     GIR_EraseRootFromParent_Done,
     /*   5543 */   // Label 138: @5543
     /*   5543 */   GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(5613), // Rule ID 180 //
     /*   5548 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
     /*   5551 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5555 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5559 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
     /*   5563 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5567 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5571 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5576 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5581 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   5585 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5587 */     // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   5587 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
     /*   5590 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   5596 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   5600 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   5602 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5605 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5611 */     GIR_RootConstrainSelectedInstOperands,
     /*   5612 */     // GIR_Coverage, 180,
     /*   5612 */     GIR_EraseRootFromParent_Done,
     /*   5613 */   // Label 139: @5613
     /*   5613 */   GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(5683), // Rule ID 509 //
     /*   5618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   5621 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5625 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5629 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
     /*   5633 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5637 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5641 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5646 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5651 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   5655 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5657 */     // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   5657 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
     /*   5660 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*   5666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   5670 */     GIR_RootToRootCopy, /*OpIdx*/2, // Ra
     /*   5672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5675 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5681 */     GIR_RootConstrainSelectedInstOperands,
     /*   5682 */     // GIR_Coverage, 509,
     /*   5682 */     GIR_EraseRootFromParent_Done,
     /*   5683 */   // Label 140: @5683
     /*   5683 */   GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(5746), // Rule ID 3050 //
     /*   5688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   5691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5695 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5699 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   5703 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   5707 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   5712 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5716 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5718 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v16i8] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu8acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v16i8] }:$vec)
     /*   5718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu8acc),
     /*   5721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   5723 */     GIR_RootToRootCopy, /*OpIdx*/2, // acc
     /*   5725 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   5729 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5732 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5738 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5744 */     GIR_RootConstrainSelectedInstOperands,
     /*   5745 */     // GIR_Coverage, 3050,
     /*   5745 */     GIR_EraseRootFromParent_Done,
     /*   5746 */   // Label 141: @5746
     /*   5746 */   GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(5809), // Rule ID 3078 //
     /*   5751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   5754 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   5766 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5770 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   5775 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5779 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5781 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v8i16] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu16acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v8i16] }:$vec)
     /*   5781 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu16acc),
     /*   5784 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   5786 */     GIR_RootToRootCopy, /*OpIdx*/2, // acc
     /*   5788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   5792 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5795 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5801 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5807 */     GIR_RootConstrainSelectedInstOperands,
     /*   5808 */     // GIR_Coverage, 3078,
     /*   5808 */     GIR_EraseRootFromParent_Done,
     /*   5809 */   // Label 142: @5809
     /*   5809 */   GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(5872), // Rule ID 3088 //
     /*   5814 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   5817 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5821 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5825 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   5829 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5833 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   5838 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   5842 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5844 */     // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v4i32] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu32acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v4i32] }:$vec)
     /*   5844 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu32acc),
     /*   5847 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   5849 */     GIR_RootToRootCopy, /*OpIdx*/2, // acc
     /*   5851 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   5855 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   5858 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5864 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5870 */     GIR_RootConstrainSelectedInstOperands,
     /*   5871 */     // GIR_Coverage, 3088,
     /*   5871 */     GIR_EraseRootFromParent_Done,
     /*   5872 */   // Label 143: @5872
     /*   5872 */   GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(5948), // Rule ID 5440 //
     /*   5877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
     /*   5880 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5884 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5888 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5892 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5896 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5900 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5904 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5909 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5914 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5916 */     // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
     /*   5916 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
     /*   5919 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5921 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   5925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   5929 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   5931 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   5934 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5940 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   5946 */     GIR_RootConstrainSelectedInstOperands,
     /*   5947 */     // GIR_Coverage, 5440,
     /*   5947 */     GIR_EraseRootFromParent_Done,
     /*   5948 */   // Label 144: @5948
     /*   5948 */   GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(6024), // Rule ID 5441 //
     /*   5953 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
     /*   5956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5960 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5964 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5968 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5972 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5976 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5980 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5985 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   5990 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5992 */     // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
     /*   5992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
     /*   5995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   5997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   6001 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   6005 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   6007 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6010 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6016 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6022 */     GIR_RootConstrainSelectedInstOperands,
     /*   6023 */     // GIR_Coverage, 5441,
     /*   6023 */     GIR_EraseRootFromParent_Done,
     /*   6024 */   // Label 145: @6024
     /*   6024 */   GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(6094), // Rule ID 5478 //
     /*   6029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
     /*   6032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6036 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6040 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6044 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   6048 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6052 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   6056 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6061 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6066 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6068 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   6068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
     /*   6071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6073 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   6077 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   6081 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   6083 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6086 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6092 */     GIR_RootConstrainSelectedInstOperands,
     /*   6093 */     // GIR_Coverage, 5478,
     /*   6093 */     GIR_EraseRootFromParent_Done,
     /*   6094 */   // Label 146: @6094
     /*   6094 */   GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(6165), // Rule ID 2001 //
     /*   6099 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   6102 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6106 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6110 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6114 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   6118 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6122 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6127 */     // MIs[1] Operand 2
     /*   6127 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
     /*   6138 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6140 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i8:{ *:[Other] }))  =>  (SXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   6140 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAB),
     /*   6143 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6145 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6147 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   6151 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6154 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6157 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6163 */     GIR_RootConstrainSelectedInstOperands,
     /*   6164 */     // GIR_Coverage, 2001,
     /*   6164 */     GIR_EraseRootFromParent_Done,
     /*   6165 */   // Label 147: @6165
     /*   6165 */   GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(6236), // Rule ID 2002 //
     /*   6170 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*   6173 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6177 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6181 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6185 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   6189 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6193 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6198 */     // MIs[1] Operand 2
     /*   6198 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   6209 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6211 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   6211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAH),
     /*   6214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6216 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6218 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   6222 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6225 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6228 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6234 */     GIR_RootConstrainSelectedInstOperands,
     /*   6235 */     // GIR_Coverage, 2002,
     /*   6235 */     GIR_EraseRootFromParent_Done,
     /*   6236 */   // Label 148: @6236
     /*   6236 */   GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(6307), // Rule ID 2240 //
     /*   6241 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   6244 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6248 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   6260 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6264 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6269 */     // MIs[1] Operand 2
     /*   6269 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
     /*   6280 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6282 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i8:{ *:[Other] }))  =>  (t2SXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   6282 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAB),
     /*   6285 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6287 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6289 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   6293 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6296 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6299 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6305 */     GIR_RootConstrainSelectedInstOperands,
     /*   6306 */     // GIR_Coverage, 2240,
     /*   6306 */     GIR_EraseRootFromParent_Done,
     /*   6307 */   // Label 149: @6307
     /*   6307 */   GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(6378), // Rule ID 2241 //
     /*   6312 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*   6315 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6319 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6323 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6327 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*   6331 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6335 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6340 */     // MIs[1] Operand 2
     /*   6340 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*   6351 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6353 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*   6353 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
     /*   6356 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6358 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6360 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   6364 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6367 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6370 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6376 */     GIR_RootConstrainSelectedInstOperands,
     /*   6377 */     // GIR_Coverage, 2241,
     /*   6377 */     GIR_EraseRootFromParent_Done,
     /*   6378 */   // Label 150: @6378
     /*   6378 */   GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(6448), // Rule ID 5442 //
     /*   6383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
     /*   6386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6390 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
     /*   6402 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6406 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   6410 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6415 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6420 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6422 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*   6422 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
     /*   6425 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6427 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*   6431 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*   6435 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   6437 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6440 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6446 */     GIR_RootConstrainSelectedInstOperands,
     /*   6447 */     // GIR_Coverage, 5442,
     /*   6447 */     GIR_EraseRootFromParent_Done,
     /*   6448 */   // Label 151: @6448
     /*   6448 */   GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(6518), // Rule ID 5479 //
     /*   6453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
     /*   6456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6460 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6464 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6468 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
     /*   6472 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   6476 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   6480 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6485 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6490 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6492 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*   6492 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
     /*   6495 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6497 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
     /*   6501 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*   6505 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*   6507 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6510 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6516 */     GIR_RootConstrainSelectedInstOperands,
     /*   6517 */     // GIR_Coverage, 5479,
     /*   6517 */     GIR_EraseRootFromParent_Done,
     /*   6518 */   // Label 152: @6518
     /*   6518 */   GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(6581), // Rule ID 5923 //
     /*   6523 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   6526 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6530 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6534 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6538 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   6542 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   6546 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   6551 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6553 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v16i8] }:$vec))  =>  (MVE_VADDVu8acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v16i8] }:$vec)
     /*   6553 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu8acc),
     /*   6556 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   6558 */     GIR_RootToRootCopy, /*OpIdx*/1, // acc
     /*   6560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   6564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6567 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6573 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6579 */     GIR_RootConstrainSelectedInstOperands,
     /*   6580 */     // GIR_Coverage, 5923,
     /*   6580 */     GIR_EraseRootFromParent_Done,
     /*   6581 */   // Label 153: @6581
     /*   6581 */   GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(6644), // Rule ID 5937 //
     /*   6586 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   6589 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6593 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6597 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6601 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   6605 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   6609 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   6614 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6616 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v8i16] }:$vec))  =>  (MVE_VADDVu16acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v8i16] }:$vec)
     /*   6616 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu16acc),
     /*   6619 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   6621 */     GIR_RootToRootCopy, /*OpIdx*/1, // acc
     /*   6623 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   6627 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6630 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6636 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6642 */     GIR_RootConstrainSelectedInstOperands,
     /*   6643 */     // GIR_Coverage, 5937,
     /*   6643 */     GIR_EraseRootFromParent_Done,
     /*   6644 */   // Label 154: @6644
     /*   6644 */   GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(6707), // Rule ID 5942 //
     /*   6649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   6652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6656 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
     /*   6660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
     /*   6668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6672 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   6677 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6679 */     // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v4i32] }:$vec))  =>  (MVE_VADDVu32acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v4i32] }:$vec)
     /*   6679 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu32acc),
     /*   6682 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
     /*   6684 */     GIR_RootToRootCopy, /*OpIdx*/1, // acc
     /*   6686 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
     /*   6690 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   6693 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6699 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6705 */     GIR_RootConstrainSelectedInstOperands,
     /*   6706 */     // GIR_Coverage, 5942,
     /*   6706 */     GIR_EraseRootFromParent_Done,
     /*   6707 */   // Label 155: @6707
     /*   6707 */   GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(6753), // Rule ID 73 //
     /*   6712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*   6715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6719 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6723 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*   6727 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*   6727 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDrr),
     /*   6730 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6732 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6734 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*   6736 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6739 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6745 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6751 */     GIR_RootConstrainSelectedInstOperands,
     /*   6752 */     // GIR_Coverage, 73,
     /*   6752 */     GIR_EraseRootFromParent_Done,
     /*   6753 */   // Label 156: @6753
     /*   6753 */   GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(6799), // Rule ID 305 //
     /*   6758 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*   6761 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   6765 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   6769 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*   6773 */     // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tADDrr:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*   6773 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDrr),
     /*   6776 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6778 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*   6784 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6786 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*   6788 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6791 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6797 */     GIR_RootConstrainSelectedInstOperands,
     /*   6798 */     // GIR_Coverage, 305,
     /*   6798 */     GIR_EraseRootFromParent_Done,
     /*   6799 */   // Label 157: @6799
     /*   6799 */   GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(6845), // Rule ID 409 //
     /*   6804 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*   6807 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6811 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6815 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6819 */     // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*   6819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
     /*   6822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6824 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*   6826 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*   6828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6831 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6837 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6843 */     GIR_RootConstrainSelectedInstOperands,
     /*   6844 */     // GIR_Coverage, 409,
     /*   6844 */     GIR_EraseRootFromParent_Done,
     /*   6845 */   // Label 158: @6845
     /*   6845 */   GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(6891), // Rule ID 5460 //
     /*   6850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*   6853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6857 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*   6861 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*   6865 */     // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*   6865 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
     /*   6868 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*   6870 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*   6872 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*   6874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6877 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6883 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6889 */     GIR_RootConstrainSelectedInstOperands,
     /*   6890 */     // GIR_Coverage, 5460,
     /*   6890 */     GIR_EraseRootFromParent_Done,
     /*   6891 */   // Label 159: @6891
     /*   6891 */   GIM_Reject,
     /*   6892 */ // Label 90: @6892
     /*   6892 */ GIM_Reject,
     /*   6893 */ // Label 81: @6893
     /*   6893 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(6939), // Rule ID 759 //
     /*   6898 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   6901 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   6904 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   6907 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6911 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6915 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6919 */   // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
     /*   6919 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv1i64),
     /*   6922 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   6924 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   6926 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   6928 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   6931 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   6937 */   GIR_RootConstrainSelectedInstOperands,
     /*   6938 */   // GIR_Coverage, 759,
     /*   6938 */   GIR_EraseRootFromParent_Done,
     /*   6939 */ // Label 160: @6939
     /*   6939 */ GIM_Reject,
     /*   6940 */ // Label 82: @6940
     /*   6940 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(7124),
     /*   6945 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6948 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   6951 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6955 */   GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(7021), // Rule ID 5529 //
     /*   6960 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   6963 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6967 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   6971 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   6975 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   6979 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6984 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6989 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   6993 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6995 */     // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   6995 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
     /*   6998 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7000 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   7010 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7013 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7019 */     GIR_RootConstrainSelectedInstOperands,
     /*   7020 */     // GIR_Coverage, 5529,
     /*   7020 */     GIR_EraseRootFromParent_Done,
     /*   7021 */   // Label 162: @7021
     /*   7021 */   GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(7087), // Rule ID 886 //
     /*   7026 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7029 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7033 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7037 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7041 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7045 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*   7049 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7054 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7059 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7061 */     // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7061 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
     /*   7064 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7066 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7068 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   7076 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7079 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7085 */     GIR_RootConstrainSelectedInstOperands,
     /*   7086 */     // GIR_Coverage, 886,
     /*   7086 */     GIR_EraseRootFromParent_Done,
     /*   7087 */   // Label 163: @7087
     /*   7087 */   GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(7123), // Rule ID 755 //
     /*   7092 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7095 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7099 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7103 */     // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i32),
     /*   7106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7108 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   7110 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   7112 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7115 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7121 */     GIR_RootConstrainSelectedInstOperands,
     /*   7122 */     // GIR_Coverage, 755,
     /*   7122 */     GIR_EraseRootFromParent_Done,
     /*   7123 */   // Label 164: @7123
     /*   7123 */   GIM_Reject,
     /*   7124 */ // Label 161: @7124
     /*   7124 */ GIM_Reject,
     /*   7125 */ // Label 83: @7125
     /*   7125 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(7835),
     /*   7130 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   7133 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   7136 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7140 */   GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(7208), // Rule ID 779 //
     /*   7145 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7160 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7165 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7169 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7173 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7177 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7182 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7184 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7184 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
     /*   7187 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7189 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7193 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   7197 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7200 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7206 */     GIR_RootConstrainSelectedInstOperands,
     /*   7207 */     // GIR_Coverage, 779,
     /*   7207 */     GIR_EraseRootFromParent_Done,
     /*   7208 */   // Label 166: @7208
     /*   7208 */   GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(7276), // Rule ID 778 //
     /*   7213 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7224 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7228 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7233 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7237 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7241 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7245 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7250 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7252 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7252 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
     /*   7255 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7257 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   7265 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7268 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7274 */     GIR_RootConstrainSelectedInstOperands,
     /*   7275 */     // GIR_Coverage, 778,
     /*   7275 */     GIR_EraseRootFromParent_Done,
     /*   7276 */   // Label 167: @7276
     /*   7276 */   GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(7344), // Rule ID 767 //
     /*   7281 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7284 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7288 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7292 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7296 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7301 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7305 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7309 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7313 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7318 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7320 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7320 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv2i64),
     /*   7323 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7325 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   7333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7336 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7342 */     GIR_RootConstrainSelectedInstOperands,
     /*   7343 */     // GIR_Coverage, 767,
     /*   7343 */     GIR_EraseRootFromParent_Done,
     /*   7344 */   // Label 168: @7344
     /*   7344 */   GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(7412), // Rule ID 777 //
     /*   7349 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7360 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7364 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7369 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7373 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7377 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7381 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7386 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7388 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7388 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
     /*   7391 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7393 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7397 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   7401 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7404 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7410 */     GIR_RootConstrainSelectedInstOperands,
     /*   7411 */     // GIR_Coverage, 777,
     /*   7411 */     GIR_EraseRootFromParent_Done,
     /*   7412 */   // Label 169: @7412
     /*   7412 */   GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(7480), // Rule ID 776 //
     /*   7417 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7420 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7424 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7428 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7432 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7437 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   7441 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7445 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7449 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7454 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   7456 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7456 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
     /*   7459 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7461 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7465 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   7469 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7472 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7478 */     GIR_RootConstrainSelectedInstOperands,
     /*   7479 */     // GIR_Coverage, 776,
     /*   7479 */     GIR_EraseRootFromParent_Done,
     /*   7480 */   // Label 170: @7480
     /*   7480 */   GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(7533), // Rule ID 5508 //
     /*   7485 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7496 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7500 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7505 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7509 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7511 */     // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7511 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
     /*   7514 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7516 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   7518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7522 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7525 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7531 */     GIR_RootConstrainSelectedInstOperands,
     /*   7532 */     // GIR_Coverage, 5508,
     /*   7532 */     GIR_EraseRootFromParent_Done,
     /*   7533 */   // Label 171: @7533
     /*   7533 */   GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(7586), // Rule ID 5502 //
     /*   7538 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7541 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7545 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7549 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7553 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7558 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7562 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7564 */     // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
     /*   7567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7569 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   7571 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7575 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7578 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7584 */     GIR_RootConstrainSelectedInstOperands,
     /*   7585 */     // GIR_Coverage, 5502,
     /*   7585 */     GIR_EraseRootFromParent_Done,
     /*   7586 */   // Label 172: @7586
     /*   7586 */   GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(7639), // Rule ID 5507 //
     /*   7591 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7594 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7598 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7602 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7606 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7611 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7615 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7617 */     // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7617 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
     /*   7620 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7622 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   7624 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7631 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7637 */     GIR_RootConstrainSelectedInstOperands,
     /*   7638 */     // GIR_Coverage, 5507,
     /*   7638 */     GIR_EraseRootFromParent_Done,
     /*   7639 */   // Label 173: @7639
     /*   7639 */   GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(7692), // Rule ID 788 //
     /*   7644 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7647 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7651 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7655 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   7659 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7663 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7668 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7670 */     // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7670 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
     /*   7673 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7675 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   7677 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7681 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7684 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7690 */     GIR_RootConstrainSelectedInstOperands,
     /*   7691 */     // GIR_Coverage, 788,
     /*   7691 */     GIR_EraseRootFromParent_Done,
     /*   7692 */   // Label 174: @7692
     /*   7692 */   GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(7745), // Rule ID 782 //
     /*   7697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7700 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7704 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7708 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   7712 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7716 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7721 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7723 */     // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7723 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
     /*   7726 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7728 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   7730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7734 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7737 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7743 */     GIR_RootConstrainSelectedInstOperands,
     /*   7744 */     // GIR_Coverage, 782,
     /*   7744 */     GIR_EraseRootFromParent_Done,
     /*   7745 */   // Label 175: @7745
     /*   7745 */   GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(7798), // Rule ID 787 //
     /*   7750 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7753 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7757 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7761 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   7765 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*   7769 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7774 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7776 */     // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*   7776 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
     /*   7779 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7781 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   7783 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   7787 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7790 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7796 */     GIR_RootConstrainSelectedInstOperands,
     /*   7797 */     // GIR_Coverage, 787,
     /*   7797 */     GIR_EraseRootFromParent_Done,
     /*   7798 */   // Label 176: @7798
     /*   7798 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(7834), // Rule ID 760 //
     /*   7803 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7806 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7810 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   7814 */     // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
     /*   7814 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i64),
     /*   7817 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7819 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   7821 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   7823 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7826 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7832 */     GIR_RootConstrainSelectedInstOperands,
     /*   7833 */     // GIR_Coverage, 760,
     /*   7833 */     GIR_EraseRootFromParent_Done,
     /*   7834 */   // Label 177: @7834
     /*   7834 */   GIM_Reject,
     /*   7835 */ // Label 165: @7835
     /*   7835 */ GIM_Reject,
     /*   7836 */ // Label 84: @7836
     /*   7836 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(8020),
     /*   7841 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   7844 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*   7847 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7851 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(7917), // Rule ID 5528 //
     /*   7856 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7859 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7863 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7867 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   7871 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*   7875 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7880 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7885 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7889 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7891 */     // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   7891 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
     /*   7894 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7896 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7902 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   7906 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7909 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7915 */     GIR_RootConstrainSelectedInstOperands,
     /*   7916 */     // GIR_Coverage, 5528,
     /*   7916 */     GIR_EraseRootFromParent_Done,
     /*   7917 */   // Label 179: @7917
     /*   7917 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(7983), // Rule ID 885 //
     /*   7922 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7925 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7929 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7933 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   7937 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   7941 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*   7945 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7950 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7955 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7957 */     // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   7957 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
     /*   7960 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   7962 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7964 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   7968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   7972 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   7975 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   7981 */     GIR_RootConstrainSelectedInstOperands,
     /*   7982 */     // GIR_Coverage, 885,
     /*   7982 */     GIR_EraseRootFromParent_Done,
     /*   7983 */   // Label 180: @7983
     /*   7983 */   GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(8019), // Rule ID 754 //
     /*   7988 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   7991 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7995 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   7999 */     // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   7999 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i16),
     /*   8002 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8004 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   8006 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   8008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8011 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8017 */     GIR_RootConstrainSelectedInstOperands,
     /*   8018 */     // GIR_Coverage, 754,
     /*   8018 */     GIR_EraseRootFromParent_Done,
     /*   8019 */   // Label 181: @8019
     /*   8019 */   GIM_Reject,
     /*   8020 */ // Label 178: @8020
     /*   8020 */ GIM_Reject,
     /*   8021 */ // Label 85: @8021
     /*   8021 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(8976),
     /*   8026 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8029 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8032 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(8104), // Rule ID 775 //
     /*   8037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8040 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8052 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8056 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8061 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   8065 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8069 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8073 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8078 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8080 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8080 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
     /*   8083 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8085 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8089 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   8093 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8096 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8102 */     GIR_RootConstrainSelectedInstOperands,
     /*   8103 */     // GIR_Coverage, 775,
     /*   8103 */     GIR_EraseRootFromParent_Done,
     /*   8104 */   // Label 183: @8104
     /*   8104 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(8176), // Rule ID 774 //
     /*   8109 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8112 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8116 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8120 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8124 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8128 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8133 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   8137 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8141 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8145 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8150 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8152 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8152 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
     /*   8155 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8157 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8161 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   8165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8168 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8174 */     GIR_RootConstrainSelectedInstOperands,
     /*   8175 */     // GIR_Coverage, 774,
     /*   8175 */     GIR_EraseRootFromParent_Done,
     /*   8176 */   // Label 184: @8176
     /*   8176 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(8248), // Rule ID 766 //
     /*   8181 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8184 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8188 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8192 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8196 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8200 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8205 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   8209 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8213 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8217 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8222 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8224 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8224 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv4i32),
     /*   8227 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8229 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8233 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   8237 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8240 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8246 */     GIR_RootConstrainSelectedInstOperands,
     /*   8247 */     // GIR_Coverage, 766,
     /*   8247 */     GIR_EraseRootFromParent_Done,
     /*   8248 */   // Label 185: @8248
     /*   8248 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(8320), // Rule ID 773 //
     /*   8253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8260 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8264 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8268 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8272 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8277 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   8281 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8285 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8289 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8294 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8296 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8296 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
     /*   8299 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8301 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8305 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   8309 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8312 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8318 */     GIR_RootConstrainSelectedInstOperands,
     /*   8319 */     // GIR_Coverage, 773,
     /*   8319 */     GIR_EraseRootFromParent_Done,
     /*   8320 */   // Label 186: @8320
     /*   8320 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(8392), // Rule ID 772 //
     /*   8325 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8328 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8332 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8336 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8340 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8344 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8349 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   8353 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8357 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8361 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8366 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   8368 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8368 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
     /*   8371 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8373 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   8381 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8384 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8390 */     GIR_RootConstrainSelectedInstOperands,
     /*   8391 */     // GIR_Coverage, 772,
     /*   8391 */     GIR_EraseRootFromParent_Done,
     /*   8392 */   // Label 187: @8392
     /*   8392 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(8462), // Rule ID 5532 //
     /*   8397 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8400 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8404 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8408 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8412 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8416 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8420 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8425 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8430 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8434 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8436 */     // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*   8436 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
     /*   8439 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8441 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8443 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   8451 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8454 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8460 */     GIR_RootConstrainSelectedInstOperands,
     /*   8461 */     // GIR_Coverage, 5532,
     /*   8461 */     GIR_EraseRootFromParent_Done,
     /*   8462 */   // Label 188: @8462
     /*   8462 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(8519), // Rule ID 5506 //
     /*   8467 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8470 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8474 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8478 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8482 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8486 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8491 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8497 */     // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8497 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
     /*   8500 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8502 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   8504 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8508 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8511 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8517 */     GIR_RootConstrainSelectedInstOperands,
     /*   8518 */     // GIR_Coverage, 5506,
     /*   8518 */     GIR_EraseRootFromParent_Done,
     /*   8519 */   // Label 189: @8519
     /*   8519 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(8576), // Rule ID 5501 //
     /*   8524 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8527 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8531 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8535 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8539 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8543 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8548 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8552 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8554 */     // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8554 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
     /*   8557 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8559 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   8561 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8565 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8568 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8574 */     GIR_RootConstrainSelectedInstOperands,
     /*   8575 */     // GIR_Coverage, 5501,
     /*   8575 */     GIR_EraseRootFromParent_Done,
     /*   8576 */   // Label 190: @8576
     /*   8576 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(8633), // Rule ID 5505 //
     /*   8581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8588 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8592 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8596 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8600 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8605 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8609 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8611 */     // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8611 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
     /*   8614 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8616 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   8618 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8622 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8625 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8631 */     GIR_RootConstrainSelectedInstOperands,
     /*   8632 */     // GIR_Coverage, 5505,
     /*   8632 */     GIR_EraseRootFromParent_Done,
     /*   8633 */   // Label 191: @8633
     /*   8633 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(8703), // Rule ID 889 //
     /*   8638 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8641 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8645 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8649 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8653 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   8657 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8661 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8665 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8670 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8675 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8677 */     // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*   8677 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
     /*   8680 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8682 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8684 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   8688 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   8692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8695 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8701 */     GIR_RootConstrainSelectedInstOperands,
     /*   8702 */     // GIR_Coverage, 889,
     /*   8702 */     GIR_EraseRootFromParent_Done,
     /*   8703 */   // Label 192: @8703
     /*   8703 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(8760), // Rule ID 786 //
     /*   8708 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8711 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8715 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8719 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8723 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   8727 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8731 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8736 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8738 */     // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8738 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
     /*   8741 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8743 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   8745 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8749 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8752 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8758 */     GIR_RootConstrainSelectedInstOperands,
     /*   8759 */     // GIR_Coverage, 786,
     /*   8759 */     GIR_EraseRootFromParent_Done,
     /*   8760 */   // Label 193: @8760
     /*   8760 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(8817), // Rule ID 781 //
     /*   8765 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8768 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8772 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8776 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8780 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   8784 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8788 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8793 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8795 */     // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8795 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
     /*   8798 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8800 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   8802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8806 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8809 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8815 */     GIR_RootConstrainSelectedInstOperands,
     /*   8816 */     // GIR_Coverage, 781,
     /*   8816 */     GIR_EraseRootFromParent_Done,
     /*   8817 */   // Label 194: @8817
     /*   8817 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(8874), // Rule ID 785 //
     /*   8822 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8825 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8829 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8833 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8837 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   8841 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*   8845 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8850 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8852 */     // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*   8852 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
     /*   8855 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8857 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   8859 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   8863 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8866 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8872 */     GIR_RootConstrainSelectedInstOperands,
     /*   8873 */     // GIR_Coverage, 785,
     /*   8873 */     GIR_EraseRootFromParent_Done,
     /*   8874 */   // Label 195: @8874
     /*   8874 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(8914), // Rule ID 758 //
     /*   8879 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   8882 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8886 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8890 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   8894 */     // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*   8894 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i32),
     /*   8897 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   8899 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   8901 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   8903 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   8906 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8912 */     GIR_RootConstrainSelectedInstOperands,
     /*   8913 */     // GIR_Coverage, 758,
     /*   8913 */     GIR_EraseRootFromParent_Done,
     /*   8914 */   // Label 196: @8914
     /*   8914 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(8975), // Rule ID 3493 //
     /*   8919 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*   8922 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   8926 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   8930 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*   8934 */     // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*   8934 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*   8937 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   8941 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   8946 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi32),
     /*   8949 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*   8951 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*   8953 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*   8955 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*   8958 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8964 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   8970 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   8973 */     GIR_RootConstrainSelectedInstOperands,
     /*   8974 */     // GIR_Coverage, 3493,
     /*   8974 */     GIR_EraseRootFromParent_Done,
     /*   8975 */   // Label 197: @8975
     /*   8975 */   GIM_Reject,
     /*   8976 */ // Label 182: @8976
     /*   8976 */ GIM_Reject,
     /*   8977 */ // Label 86: @8977
     /*   8977 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(9161),
     /*   8982 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   8985 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*   8988 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   8992 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(9058), // Rule ID 5527 //
     /*   8997 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   9008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*   9016 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9021 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9026 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9030 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9032 */     // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9032 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
     /*   9035 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9037 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   9039 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9043 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   9047 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9050 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9056 */     GIR_RootConstrainSelectedInstOperands,
     /*   9057 */     // GIR_Coverage, 5527,
     /*   9057 */     GIR_EraseRootFromParent_Done,
     /*   9058 */   // Label 199: @9058
     /*   9058 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(9124), // Rule ID 884 //
     /*   9063 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9066 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9070 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9074 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   9078 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9082 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*   9086 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9091 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9096 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9098 */     // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
     /*   9101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9103 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9105 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9109 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   9113 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9116 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9122 */     GIR_RootConstrainSelectedInstOperands,
     /*   9123 */     // GIR_Coverage, 884,
     /*   9123 */     GIR_EraseRootFromParent_Done,
     /*   9124 */   // Label 200: @9124
     /*   9124 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(9160), // Rule ID 753 //
     /*   9129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9132 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9136 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9140 */     // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9140 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i8),
     /*   9143 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9145 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   9147 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*   9149 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9152 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9158 */     GIR_RootConstrainSelectedInstOperands,
     /*   9159 */     // GIR_Coverage, 753,
     /*   9159 */     GIR_EraseRootFromParent_Done,
     /*   9160 */   // Label 201: @9160
     /*   9160 */   GIM_Reject,
     /*   9161 */ // Label 198: @9161
     /*   9161 */ GIM_Reject,
     /*   9162 */ // Label 87: @9162
     /*   9162 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(10117),
     /*   9167 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   9170 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   9173 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(9245), // Rule ID 771 //
     /*   9178 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9181 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9185 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9189 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9193 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9197 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9202 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   9206 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9210 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9214 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9219 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9221 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9221 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
     /*   9224 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9226 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9230 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   9234 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9237 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9243 */     GIR_RootConstrainSelectedInstOperands,
     /*   9244 */     // GIR_Coverage, 771,
     /*   9244 */     GIR_EraseRootFromParent_Done,
     /*   9245 */   // Label 203: @9245
     /*   9245 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(9317), // Rule ID 770 //
     /*   9250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9253 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9257 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9261 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9265 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9269 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9274 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   9278 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9282 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9286 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9291 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9293 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9293 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
     /*   9296 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9298 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9302 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   9306 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9309 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9315 */     GIR_RootConstrainSelectedInstOperands,
     /*   9316 */     // GIR_Coverage, 770,
     /*   9316 */     GIR_EraseRootFromParent_Done,
     /*   9317 */   // Label 204: @9317
     /*   9317 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(9389), // Rule ID 765 //
     /*   9322 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9325 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9329 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9333 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   9337 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9341 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9346 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   9350 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   9354 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9358 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9363 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9365 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9365 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv8i16),
     /*   9368 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9370 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9374 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   9378 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9381 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9387 */     GIR_RootConstrainSelectedInstOperands,
     /*   9388 */     // GIR_Coverage, 765,
     /*   9388 */     GIR_EraseRootFromParent_Done,
     /*   9389 */   // Label 205: @9389
     /*   9389 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(9461), // Rule ID 769 //
     /*   9394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9413 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9418 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   9422 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9426 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9430 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9435 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9437 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9437 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
     /*   9440 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   9450 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9453 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9459 */     GIR_RootConstrainSelectedInstOperands,
     /*   9460 */     // GIR_Coverage, 769,
     /*   9460 */     GIR_EraseRootFromParent_Done,
     /*   9461 */   // Label 206: @9461
     /*   9461 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(9533), // Rule ID 768 //
     /*   9466 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9469 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9473 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9477 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9481 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9485 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9490 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   9494 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9498 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9502 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9507 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   9509 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9509 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
     /*   9512 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9514 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*   9522 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9525 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9531 */     GIR_RootConstrainSelectedInstOperands,
     /*   9532 */     // GIR_Coverage, 768,
     /*   9532 */     GIR_EraseRootFromParent_Done,
     /*   9533 */   // Label 207: @9533
     /*   9533 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(9603), // Rule ID 5531 //
     /*   9538 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9541 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9545 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9549 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   9553 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   9557 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   9561 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9566 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9571 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9575 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9577 */     // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*   9577 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
     /*   9580 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9582 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   9584 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9588 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   9592 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9595 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9601 */     GIR_RootConstrainSelectedInstOperands,
     /*   9602 */     // GIR_Coverage, 5531,
     /*   9602 */     GIR_EraseRootFromParent_Done,
     /*   9603 */   // Label 208: @9603
     /*   9603 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(9660), // Rule ID 5504 //
     /*   9608 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9611 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9615 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9619 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9623 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9627 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9632 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9636 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9638 */     // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
     /*   9641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9643 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   9645 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   9649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9652 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9658 */     GIR_RootConstrainSelectedInstOperands,
     /*   9659 */     // GIR_Coverage, 5504,
     /*   9659 */     GIR_EraseRootFromParent_Done,
     /*   9660 */   // Label 209: @9660
     /*   9660 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(9717), // Rule ID 5500 //
     /*   9665 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9668 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9672 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9676 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   9680 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9684 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9689 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9695 */     // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9695 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
     /*   9698 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9700 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   9702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   9706 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9709 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9715 */     GIR_RootConstrainSelectedInstOperands,
     /*   9716 */     // GIR_Coverage, 5500,
     /*   9716 */     GIR_EraseRootFromParent_Done,
     /*   9717 */   // Label 210: @9717
     /*   9717 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(9774), // Rule ID 5503 //
     /*   9722 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9725 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9729 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9733 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9737 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9741 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9746 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9750 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9752 */     // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9752 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
     /*   9755 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9757 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vn
     /*   9759 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   9763 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9766 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9772 */     GIR_RootConstrainSelectedInstOperands,
     /*   9773 */     // GIR_Coverage, 5503,
     /*   9773 */     GIR_EraseRootFromParent_Done,
     /*   9774 */   // Label 211: @9774
     /*   9774 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(9844), // Rule ID 888 //
     /*   9779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9782 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9786 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9790 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9794 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   9798 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   9802 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   9806 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9811 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9816 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9818 */     // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*   9818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
     /*   9821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9823 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9825 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*   9829 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*   9833 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9836 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9842 */     GIR_RootConstrainSelectedInstOperands,
     /*   9843 */     // GIR_Coverage, 888,
     /*   9843 */     GIR_EraseRootFromParent_Done,
     /*   9844 */   // Label 212: @9844
     /*   9844 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(9901), // Rule ID 784 //
     /*   9849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9852 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9856 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9860 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9864 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   9868 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9872 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9877 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9879 */     // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9879 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
     /*   9882 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9884 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   9886 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   9890 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9893 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9899 */     GIR_RootConstrainSelectedInstOperands,
     /*   9900 */     // GIR_Coverage, 784,
     /*   9900 */     GIR_EraseRootFromParent_Done,
     /*   9901 */   // Label 213: @9901
     /*   9901 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(9958), // Rule ID 780 //
     /*   9906 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9909 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9913 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9917 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9921 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   9925 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9929 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9934 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9936 */     // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9936 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
     /*   9939 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9941 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*   9943 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*   9947 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   9950 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*   9956 */     GIR_RootConstrainSelectedInstOperands,
     /*   9957 */     // GIR_Coverage, 780,
     /*   9957 */     GIR_EraseRootFromParent_Done,
     /*   9958 */   // Label 214: @9958
     /*   9958 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(10015), // Rule ID 783 //
     /*   9963 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*   9966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9970 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*   9974 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9978 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   9982 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*   9986 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*   9991 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9993 */     // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*   9993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
     /*   9996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*   9998 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  10000 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  10004 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10007 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10013 */     GIR_RootConstrainSelectedInstOperands,
     /*  10014 */     // GIR_Coverage, 783,
     /*  10014 */     GIR_EraseRootFromParent_Done,
     /*  10015 */   // Label 215: @10015
     /*  10015 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(10055), // Rule ID 757 //
     /*  10020 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  10023 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10027 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10031 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10035 */     // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*  10035 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i16),
     /*  10038 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  10040 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  10042 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  10044 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10047 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10053 */     GIR_RootConstrainSelectedInstOperands,
     /*  10054 */     // GIR_Coverage, 757,
     /*  10054 */     GIR_EraseRootFromParent_Done,
     /*  10055 */   // Label 216: @10055
     /*  10055 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(10116), // Rule ID 3489 //
     /*  10060 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  10063 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10067 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10071 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10075 */     // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  10075 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  10078 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10082 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10087 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi16),
     /*  10090 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  10092 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  10094 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  10096 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  10099 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10105 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10111 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  10114 */     GIR_RootConstrainSelectedInstOperands,
     /*  10115 */     // GIR_Coverage, 3489,
     /*  10115 */     GIR_EraseRootFromParent_Done,
     /*  10116 */   // Label 217: @10116
     /*  10116 */   GIM_Reject,
     /*  10117 */ // Label 202: @10117
     /*  10117 */ GIM_Reject,
     /*  10118 */ // Label 88: @10118
     /*  10118 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(10371),
     /*  10123 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  10126 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  10129 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(10199), // Rule ID 5530 //
     /*  10134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  10137 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10141 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10145 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10149 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  10153 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  10157 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10162 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10167 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10171 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10173 */     // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  10173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
     /*  10176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  10178 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  10180 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  10184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  10188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10191 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10197 */     GIR_RootConstrainSelectedInstOperands,
     /*  10198 */     // GIR_Coverage, 5530,
     /*  10198 */     GIR_EraseRootFromParent_Done,
     /*  10199 */   // Label 219: @10199
     /*  10199 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(10269), // Rule ID 887 //
     /*  10204 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  10207 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10211 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10215 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10219 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10223 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  10227 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  10231 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10236 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10241 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10243 */     // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  10243 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
     /*  10246 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  10248 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10250 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  10254 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  10258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10261 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10267 */     GIR_RootConstrainSelectedInstOperands,
     /*  10268 */     // GIR_Coverage, 887,
     /*  10268 */     GIR_EraseRootFromParent_Done,
     /*  10269 */   // Label 220: @10269
     /*  10269 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(10309), // Rule ID 756 //
     /*  10274 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  10277 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10281 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10285 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  10289 */     // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  10289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv16i8),
     /*  10292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  10294 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  10296 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  10298 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10301 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10307 */     GIR_RootConstrainSelectedInstOperands,
     /*  10308 */     // GIR_Coverage, 756,
     /*  10308 */     GIR_EraseRootFromParent_Done,
     /*  10309 */   // Label 221: @10309
     /*  10309 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(10370), // Rule ID 3485 //
     /*  10314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  10317 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10321 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10325 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  10329 */     // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  10329 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  10332 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  10336 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  10341 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi8),
     /*  10344 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  10346 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  10348 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  10350 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  10353 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10359 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10365 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  10368 */     GIR_RootConstrainSelectedInstOperands,
     /*  10369 */     // GIR_Coverage, 3485,
     /*  10369 */     GIR_EraseRootFromParent_Done,
     /*  10370 */   // Label 222: @10370
     /*  10370 */   GIM_Reject,
     /*  10371 */ // Label 218: @10371
     /*  10371 */ GIM_Reject,
     /*  10372 */ // Label 89: @10372
     /*  10372 */ GIM_Reject,
     /*  10373 */ // Label 1: @10373
     /*  10373 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 232*/ GIMT_Encode4(13616),
     /*  10384 */ /*GILLT_s32*//*Label 223*/ GIMT_Encode4(10444),
     /*  10388 */ /*GILLT_s64*//*Label 224*/ GIMT_Encode4(11058), GIMT_Encode4(0),
     /*  10396 */ /*GILLT_v2s32*//*Label 225*/ GIMT_Encode4(11105),
     /*  10400 */ /*GILLT_v2s64*//*Label 226*/ GIMT_Encode4(11220), GIMT_Encode4(0),
     /*  10408 */ /*GILLT_v4s16*//*Label 227*/ GIMT_Encode4(11772),
     /*  10412 */ /*GILLT_v4s32*//*Label 228*/ GIMT_Encode4(11887), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  10424 */ /*GILLT_v8s8*//*Label 229*/ GIMT_Encode4(12602),
     /*  10428 */ /*GILLT_v8s16*//*Label 230*/ GIMT_Encode4(12717), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  10440 */ /*GILLT_v16s8*//*Label 231*/ GIMT_Encode4(13432),
     /*  10444 */ // Label 223: @10444
     /*  10444 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(11057),
     /*  10449 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  10452 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  10455 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(10499), // Rule ID 330 //
     /*  10460 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  10463 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  10467 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*  10471 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  10475 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, tGPR:{ *:[i32] }:$Rn)  =>  (tRSB:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)
     /*  10475 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tRSB),
     /*  10478 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10480 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  10486 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10488 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10491 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10497 */     GIR_RootConstrainSelectedInstOperands,
     /*  10498 */     // GIR_Coverage, 330,
     /*  10498 */     GIR_EraseRootFromParent_Done,
     /*  10499 */   // Label 234: @10499
     /*  10499 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(10556), // Rule ID 96 //
     /*  10504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  10507 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10511 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10515 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  10519 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  10523 */     // MIs[1] Operand 1
     /*  10523 */     // No operand predicates
     /*  10523 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10527 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10529 */     // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  10529 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::RSBri),
     /*  10532 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10534 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10536 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  10539 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10542 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10548 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10554 */     GIR_RootConstrainSelectedInstOperands,
     /*  10555 */     // GIR_Coverage, 96,
     /*  10555 */     GIR_EraseRootFromParent_Done,
     /*  10556 */   // Label 235: @10556
     /*  10556 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(10613), // Rule ID 427 //
     /*  10561 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  10564 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10568 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10572 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  10576 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  10580 */     // MIs[1] Operand 1
     /*  10580 */     // No operand predicates
     /*  10580 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10584 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10586 */     // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  10586 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2RSBri),
     /*  10589 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10591 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  10593 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  10596 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10599 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10605 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10611 */     GIR_RootConstrainSelectedInstOperands,
     /*  10612 */     // GIR_Coverage, 427,
     /*  10612 */     GIR_EraseRootFromParent_Done,
     /*  10613 */   // Label 236: @10613
     /*  10613 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(10670), // Rule ID 76 //
     /*  10618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  10621 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10625 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  10637 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  10641 */     // MIs[1] Operand 1
     /*  10641 */     // No operand predicates
     /*  10641 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10643 */     // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  10643 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBri),
     /*  10646 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10648 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10650 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  10653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10656 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10662 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10668 */     GIR_RootConstrainSelectedInstOperands,
     /*  10669 */     // GIR_Coverage, 76,
     /*  10669 */     GIR_EraseRootFromParent_Done,
     /*  10670 */   // Label 237: @10670
     /*  10670 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(10727), // Rule ID 411 //
     /*  10675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  10678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10682 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  10686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  10694 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  10698 */     // MIs[1] Operand 1
     /*  10698 */     // No operand predicates
     /*  10698 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10700 */     // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  10700 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri),
     /*  10703 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10705 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10707 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  10710 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10713 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10719 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10725 */     GIR_RootConstrainSelectedInstOperands,
     /*  10726 */     // GIR_Coverage, 411,
     /*  10726 */     GIR_EraseRootFromParent_Done,
     /*  10727 */   // Label 238: @10727
     /*  10727 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(10778), // Rule ID 412 //
     /*  10732 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  10735 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10739 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10743 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10747 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  10751 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
     /*  10755 */     // MIs[1] Operand 1
     /*  10755 */     // No operand predicates
     /*  10755 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10757 */     // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  10757 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri12),
     /*  10760 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10762 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10764 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  10767 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10770 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10776 */     GIR_RootConstrainSelectedInstOperands,
     /*  10777 */     // GIR_Coverage, 412,
     /*  10777 */     GIR_EraseRootFromParent_Done,
     /*  10778 */   // Label 239: @10778
     /*  10778 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(10848), // Rule ID 173 //
     /*  10783 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM_UseMulOps),
     /*  10786 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10790 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10794 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10798 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10802 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  10806 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  10810 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10815 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10820 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10822 */     // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
     /*  10822 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLS),
     /*  10825 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10827 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  10831 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  10835 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*  10837 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10840 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10846 */     GIR_RootConstrainSelectedInstOperands,
     /*  10847 */     // GIR_Coverage, 173,
     /*  10847 */     GIR_EraseRootFromParent_Done,
     /*  10848 */   // Label 240: @10848
     /*  10848 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(10918), // Rule ID 504 //
     /*  10853 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
     /*  10856 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10860 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10864 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10868 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  10872 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  10876 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  10880 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10885 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  10890 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10892 */     // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
     /*  10892 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLS),
     /*  10895 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10897 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  10901 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
     /*  10905 */     GIR_RootToRootCopy, /*OpIdx*/1, // Ra
     /*  10907 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10910 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10916 */     GIR_RootConstrainSelectedInstOperands,
     /*  10917 */     // GIR_Coverage, 504,
     /*  10917 */     GIR_EraseRootFromParent_Done,
     /*  10918 */   // Label 241: @10918
     /*  10918 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(10964), // Rule ID 77 //
     /*  10923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  10926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10930 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10934 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  10938 */     // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  10938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBrr),
     /*  10941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10943 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10945 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  10947 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  10950 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10956 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  10962 */     GIR_RootConstrainSelectedInstOperands,
     /*  10963 */     // GIR_Coverage, 77,
     /*  10963 */     GIR_EraseRootFromParent_Done,
     /*  10964 */   // Label 242: @10964
     /*  10964 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(11010), // Rule ID 333 //
     /*  10969 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  10972 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  10976 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  10980 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  10984 */     // (sub:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tSUBrr:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  10984 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tSUBrr),
     /*  10987 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  10989 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  10995 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  10997 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  10999 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11002 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11008 */     GIR_RootConstrainSelectedInstOperands,
     /*  11009 */     // GIR_Coverage, 333,
     /*  11009 */     GIR_EraseRootFromParent_Done,
     /*  11010 */   // Label 243: @11010
     /*  11010 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(11056), // Rule ID 413 //
     /*  11015 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  11018 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  11022 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  11026 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  11030 */     // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  11030 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBrr),
     /*  11033 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  11035 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  11037 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  11039 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11042 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11048 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11054 */     GIR_RootConstrainSelectedInstOperands,
     /*  11055 */     // GIR_Coverage, 413,
     /*  11055 */     GIR_EraseRootFromParent_Done,
     /*  11056 */   // Label 244: @11056
     /*  11056 */   GIM_Reject,
     /*  11057 */ // Label 233: @11057
     /*  11057 */ GIM_Reject,
     /*  11058 */ // Label 224: @11058
     /*  11058 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(11104), // Rule ID 963 //
     /*  11063 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11066 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  11069 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  11072 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11076 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11080 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11084 */   // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
     /*  11084 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv1i64),
     /*  11087 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11089 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11091 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  11093 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11096 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11102 */   GIR_RootConstrainSelectedInstOperands,
     /*  11103 */   // GIR_Coverage, 963,
     /*  11103 */   GIR_EraseRootFromParent_Done,
     /*  11104 */ // Label 245: @11104
     /*  11104 */ GIM_Reject,
     /*  11105 */ // Label 225: @11105
     /*  11105 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(11219),
     /*  11110 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11113 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11116 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11120 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11124 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(11186), // Rule ID 914 //
     /*  11129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11132 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11136 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  11140 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11144 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  11148 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11153 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11158 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11160 */     // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11160 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv2i32),
     /*  11163 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11165 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11171 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  11175 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11178 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11184 */     GIR_RootConstrainSelectedInstOperands,
     /*  11185 */     // GIR_Coverage, 914,
     /*  11185 */     GIR_EraseRootFromParent_Done,
     /*  11186 */   // Label 247: @11186
     /*  11186 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(11218), // Rule ID 959 //
     /*  11191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11194 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11198 */     // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11198 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i32),
     /*  11201 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11203 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11205 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  11207 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11210 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11216 */     GIR_RootConstrainSelectedInstOperands,
     /*  11217 */     // GIR_Coverage, 959,
     /*  11217 */     GIR_EraseRootFromParent_Done,
     /*  11218 */   // Label 248: @11218
     /*  11218 */   GIM_Reject,
     /*  11219 */ // Label 246: @11219
     /*  11219 */ GIM_Reject,
     /*  11220 */ // Label 226: @11220
     /*  11220 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(11771),
     /*  11225 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  11228 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  11231 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11235 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(11303), // Rule ID 983 //
     /*  11240 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11243 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11247 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11251 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11255 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11260 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11264 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11268 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11272 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11277 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11279 */     // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11279 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
     /*  11282 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11288 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11292 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11295 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11301 */     GIR_RootConstrainSelectedInstOperands,
     /*  11302 */     // GIR_Coverage, 983,
     /*  11302 */     GIR_EraseRootFromParent_Done,
     /*  11303 */   // Label 250: @11303
     /*  11303 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(11371), // Rule ID 982 //
     /*  11308 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11311 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11315 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11319 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11323 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11328 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11332 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  11336 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11340 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11345 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11347 */     // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
     /*  11350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11360 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11363 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11369 */     GIR_RootConstrainSelectedInstOperands,
     /*  11370 */     // GIR_Coverage, 982,
     /*  11370 */     GIR_EraseRootFromParent_Done,
     /*  11371 */   // Label 251: @11371
     /*  11371 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(11439), // Rule ID 971 //
     /*  11376 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11379 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11383 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  11387 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11391 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11396 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11400 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  11404 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11408 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11413 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11415 */     // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv2i64),
     /*  11418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11424 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11428 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11431 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11437 */     GIR_RootConstrainSelectedInstOperands,
     /*  11438 */     // GIR_Coverage, 971,
     /*  11438 */     GIR_EraseRootFromParent_Done,
     /*  11439 */   // Label 252: @11439
     /*  11439 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(11507), // Rule ID 981 //
     /*  11444 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11447 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11451 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  11455 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11459 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11464 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11468 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11472 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11476 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11481 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11483 */     // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11483 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
     /*  11486 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11496 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11499 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11505 */     GIR_RootConstrainSelectedInstOperands,
     /*  11506 */     // GIR_Coverage, 981,
     /*  11506 */     GIR_EraseRootFromParent_Done,
     /*  11507 */   // Label 253: @11507
     /*  11507 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(11575), // Rule ID 980 //
     /*  11512 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11515 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11519 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  11523 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11527 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11532 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11536 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  11540 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11544 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11549 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11551 */     // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11551 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
     /*  11554 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11556 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11567 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11573 */     GIR_RootConstrainSelectedInstOperands,
     /*  11574 */     // GIR_Coverage, 980,
     /*  11574 */     GIR_EraseRootFromParent_Done,
     /*  11575 */   // Label 254: @11575
     /*  11575 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(11628), // Rule ID 992 //
     /*  11580 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11583 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11587 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11591 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11595 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11599 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11604 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11606 */     // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11606 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
     /*  11609 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11611 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11613 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  11617 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11620 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11626 */     GIR_RootConstrainSelectedInstOperands,
     /*  11627 */     // GIR_Coverage, 992,
     /*  11627 */     GIR_EraseRootFromParent_Done,
     /*  11628 */   // Label 255: @11628
     /*  11628 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(11681), // Rule ID 986 //
     /*  11633 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11636 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11640 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11644 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  11648 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11652 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11657 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11659 */     // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv2i64),
     /*  11662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11664 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  11670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11673 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11679 */     GIR_RootConstrainSelectedInstOperands,
     /*  11680 */     // GIR_Coverage, 986,
     /*  11680 */     GIR_EraseRootFromParent_Done,
     /*  11681 */   // Label 256: @11681
     /*  11681 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(11734), // Rule ID 991 //
     /*  11686 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11689 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11693 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11697 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  11701 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  11705 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11710 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11712 */     // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  11712 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
     /*  11715 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11717 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11719 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  11723 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11726 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11732 */     GIR_RootConstrainSelectedInstOperands,
     /*  11733 */     // GIR_Coverage, 991,
     /*  11733 */     GIR_EraseRootFromParent_Done,
     /*  11734 */   // Label 257: @11734
     /*  11734 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(11770), // Rule ID 964 //
     /*  11739 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11742 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11746 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11750 */     // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
     /*  11750 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i64),
     /*  11753 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11755 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11757 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  11759 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11762 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11768 */     GIR_RootConstrainSelectedInstOperands,
     /*  11769 */     // GIR_Coverage, 964,
     /*  11769 */     GIR_EraseRootFromParent_Done,
     /*  11770 */   // Label 258: @11770
     /*  11770 */   GIM_Reject,
     /*  11771 */ // Label 249: @11771
     /*  11771 */ GIM_Reject,
     /*  11772 */ // Label 227: @11772
     /*  11772 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(11886),
     /*  11777 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  11780 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  11783 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11787 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11791 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(11853), // Rule ID 913 //
     /*  11796 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11799 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11803 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  11807 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  11811 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  11815 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11820 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11825 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11827 */     // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  11827 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i16),
     /*  11830 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11832 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11834 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  11842 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11845 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11851 */     GIR_RootConstrainSelectedInstOperands,
     /*  11852 */     // GIR_Coverage, 913,
     /*  11852 */     GIR_EraseRootFromParent_Done,
     /*  11853 */   // Label 260: @11853
     /*  11853 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(11885), // Rule ID 958 //
     /*  11858 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11861 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11865 */     // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  11865 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i16),
     /*  11868 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11870 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  11872 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  11874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11877 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11883 */     GIR_RootConstrainSelectedInstOperands,
     /*  11884 */     // GIR_Coverage, 958,
     /*  11884 */     GIR_EraseRootFromParent_Done,
     /*  11885 */   // Label 261: @11885
     /*  11885 */   GIM_Reject,
     /*  11886 */ // Label 259: @11886
     /*  11886 */ GIM_Reject,
     /*  11887 */ // Label 228: @11887
     /*  11887 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(12601),
     /*  11892 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11895 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11898 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(11970), // Rule ID 979 //
     /*  11903 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11910 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11914 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11918 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  11922 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11927 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11931 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11935 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  11939 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11944 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11946 */     // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  11946 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
     /*  11949 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  11951 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  11955 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  11959 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  11962 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  11968 */     GIR_RootConstrainSelectedInstOperands,
     /*  11969 */     // GIR_Coverage, 979,
     /*  11969 */     GIR_EraseRootFromParent_Done,
     /*  11970 */   // Label 263: @11970
     /*  11970 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(12042), // Rule ID 978 //
     /*  11975 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  11978 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  11982 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11986 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  11990 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  11994 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  11999 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12003 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12007 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12011 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12016 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12018 */     // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12018 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
     /*  12021 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12023 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12027 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12034 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12040 */     GIR_RootConstrainSelectedInstOperands,
     /*  12041 */     // GIR_Coverage, 978,
     /*  12041 */     GIR_EraseRootFromParent_Done,
     /*  12042 */   // Label 264: @12042
     /*  12042 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(12114), // Rule ID 970 //
     /*  12047 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12050 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12054 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12058 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12062 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12066 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12071 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12075 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12079 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12083 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12088 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12090 */     // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12090 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv4i32),
     /*  12093 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12095 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12099 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12103 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12106 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12112 */     GIR_RootConstrainSelectedInstOperands,
     /*  12113 */     // GIR_Coverage, 970,
     /*  12113 */     GIR_EraseRootFromParent_Done,
     /*  12114 */   // Label 265: @12114
     /*  12114 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(12186), // Rule ID 977 //
     /*  12119 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12122 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12126 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12130 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12134 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12138 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12143 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12147 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12151 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12155 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12160 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12162 */     // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12162 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
     /*  12165 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12171 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12175 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12178 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12184 */     GIR_RootConstrainSelectedInstOperands,
     /*  12185 */     // GIR_Coverage, 977,
     /*  12185 */     GIR_EraseRootFromParent_Done,
     /*  12186 */   // Label 266: @12186
     /*  12186 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(12258), // Rule ID 976 //
     /*  12191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12198 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12206 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12210 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12215 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12219 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12223 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12227 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12232 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12234 */     // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12234 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
     /*  12237 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12239 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12243 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12247 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12250 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12256 */     GIR_RootConstrainSelectedInstOperands,
     /*  12257 */     // GIR_Coverage, 976,
     /*  12257 */     GIR_EraseRootFromParent_Done,
     /*  12258 */   // Label 267: @12258
     /*  12258 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(12328), // Rule ID 917 //
     /*  12263 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12266 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12270 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12274 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12278 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  12282 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12286 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12290 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12295 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12300 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12302 */     // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  12302 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i32),
     /*  12305 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12307 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12309 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12313 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  12317 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12320 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12326 */     GIR_RootConstrainSelectedInstOperands,
     /*  12327 */     // GIR_Coverage, 917,
     /*  12327 */     GIR_EraseRootFromParent_Done,
     /*  12328 */   // Label 268: @12328
     /*  12328 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(12385), // Rule ID 990 //
     /*  12333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12340 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12344 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12348 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12352 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12356 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12361 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12363 */     // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12363 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
     /*  12366 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12368 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  12370 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  12374 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12377 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12383 */     GIR_RootConstrainSelectedInstOperands,
     /*  12384 */     // GIR_Coverage, 990,
     /*  12384 */     GIR_EraseRootFromParent_Done,
     /*  12385 */   // Label 269: @12385
     /*  12385 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(12442), // Rule ID 985 //
     /*  12390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12413 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12418 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12420 */     // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12420 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv4i32),
     /*  12423 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12425 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  12427 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  12431 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12434 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12440 */     GIR_RootConstrainSelectedInstOperands,
     /*  12441 */     // GIR_Coverage, 985,
     /*  12441 */     GIR_EraseRootFromParent_Done,
     /*  12442 */   // Label 270: @12442
     /*  12442 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(12499), // Rule ID 989 //
     /*  12447 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12450 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12454 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12458 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12462 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12466 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  12470 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12475 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12477 */     // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  12477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
     /*  12480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12482 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  12484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  12488 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12491 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12497 */     GIR_RootConstrainSelectedInstOperands,
     /*  12498 */     // GIR_Coverage, 989,
     /*  12498 */     GIR_EraseRootFromParent_Done,
     /*  12499 */   // Label 271: @12499
     /*  12499 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(12539), // Rule ID 962 //
     /*  12504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12507 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12511 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12515 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12519 */     // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  12519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i32),
     /*  12522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12524 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  12526 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  12528 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12531 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12537 */     GIR_RootConstrainSelectedInstOperands,
     /*  12538 */     // GIR_Coverage, 962,
     /*  12538 */     GIR_EraseRootFromParent_Done,
     /*  12539 */   // Label 272: @12539
     /*  12539 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(12600), // Rule ID 3505 //
     /*  12544 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  12547 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  12551 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  12555 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  12559 */     // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*  12559 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  12562 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  12566 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12571 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi32),
     /*  12574 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  12576 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  12578 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  12580 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  12583 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12589 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12595 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  12598 */     GIR_RootConstrainSelectedInstOperands,
     /*  12599 */     // GIR_Coverage, 3505,
     /*  12599 */     GIR_EraseRootFromParent_Done,
     /*  12600 */   // Label 273: @12600
     /*  12600 */   GIM_Reject,
     /*  12601 */ // Label 262: @12601
     /*  12601 */ GIM_Reject,
     /*  12602 */ // Label 229: @12602
     /*  12602 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(12716),
     /*  12607 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12610 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  12613 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12617 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12621 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(12683), // Rule ID 912 //
     /*  12626 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  12637 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12641 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  12645 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12650 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12655 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12657 */     // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12657 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i8),
     /*  12660 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12662 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  12672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12675 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12681 */     GIR_RootConstrainSelectedInstOperands,
     /*  12682 */     // GIR_Coverage, 912,
     /*  12682 */     GIR_EraseRootFromParent_Done,
     /*  12683 */   // Label 275: @12683
     /*  12683 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(12715), // Rule ID 957 //
     /*  12688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12691 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12695 */     // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12695 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i8),
     /*  12698 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12700 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  12702 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  12704 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12707 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12713 */     GIR_RootConstrainSelectedInstOperands,
     /*  12714 */     // GIR_Coverage, 957,
     /*  12714 */     GIR_EraseRootFromParent_Done,
     /*  12715 */   // Label 276: @12715
     /*  12715 */   GIM_Reject,
     /*  12716 */ // Label 274: @12716
     /*  12716 */ GIM_Reject,
     /*  12717 */ // Label 230: @12717
     /*  12717 */ GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(13431),
     /*  12722 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  12725 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  12728 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(12800), // Rule ID 975 //
     /*  12733 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12740 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12744 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12748 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12752 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12757 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12761 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12765 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12769 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12774 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12776 */     // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12776 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
     /*  12779 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12781 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12785 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12789 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12792 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12798 */     GIR_RootConstrainSelectedInstOperands,
     /*  12799 */     // GIR_Coverage, 975,
     /*  12799 */     GIR_EraseRootFromParent_Done,
     /*  12800 */   // Label 278: @12800
     /*  12800 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(12872), // Rule ID 974 //
     /*  12805 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12808 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12812 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12816 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12820 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12824 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12829 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12833 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12837 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12841 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12846 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12848 */     // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12848 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
     /*  12851 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12853 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12857 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12861 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12864 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12870 */     GIR_RootConstrainSelectedInstOperands,
     /*  12871 */     // GIR_Coverage, 974,
     /*  12871 */     GIR_EraseRootFromParent_Done,
     /*  12872 */   // Label 279: @12872
     /*  12872 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(12944), // Rule ID 969 //
     /*  12877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12880 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12884 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12888 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12892 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12896 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12901 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12905 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  12909 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12913 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12918 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12920 */     // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv8i16),
     /*  12923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  12929 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  12933 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  12936 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  12942 */     GIR_RootConstrainSelectedInstOperands,
     /*  12943 */     // GIR_Coverage, 969,
     /*  12943 */     GIR_EraseRootFromParent_Done,
     /*  12944 */   // Label 280: @12944
     /*  12944 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(13016), // Rule ID 973 //
     /*  12949 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  12952 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  12956 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12960 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  12964 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12968 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12973 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  12977 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  12981 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  12985 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  12990 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  12992 */     // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  12992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
     /*  12995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  12997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  13001 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  13005 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13008 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13014 */     GIR_RootConstrainSelectedInstOperands,
     /*  13015 */     // GIR_Coverage, 973,
     /*  13015 */     GIR_EraseRootFromParent_Done,
     /*  13016 */   // Label 281: @13016
     /*  13016 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(13088), // Rule ID 972 //
     /*  13021 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13024 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13028 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13032 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13036 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  13040 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  13045 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  13049 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13053 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  13057 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  13062 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13064 */     // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  13064 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
     /*  13067 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13069 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  13073 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
     /*  13077 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13080 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13086 */     GIR_RootConstrainSelectedInstOperands,
     /*  13087 */     // GIR_Coverage, 972,
     /*  13087 */     GIR_EraseRootFromParent_Done,
     /*  13088 */   // Label 282: @13088
     /*  13088 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(13158), // Rule ID 916 //
     /*  13093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13100 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  13112 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  13116 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  13120 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13125 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13130 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13132 */     // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*  13132 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i16),
     /*  13135 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13137 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  13143 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  13147 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13150 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13156 */     GIR_RootConstrainSelectedInstOperands,
     /*  13157 */     // GIR_Coverage, 916,
     /*  13157 */     GIR_EraseRootFromParent_Done,
     /*  13158 */   // Label 283: @13158
     /*  13158 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(13215), // Rule ID 988 //
     /*  13163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13170 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13174 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13178 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*  13182 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  13186 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  13191 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13193 */     // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  13193 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
     /*  13196 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13198 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  13200 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  13204 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13207 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13213 */     GIR_RootConstrainSelectedInstOperands,
     /*  13214 */     // GIR_Coverage, 988,
     /*  13214 */     GIR_EraseRootFromParent_Done,
     /*  13215 */   // Label 284: @13215
     /*  13215 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(13272), // Rule ID 984 //
     /*  13220 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13223 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13227 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13231 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13235 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*  13239 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  13243 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  13248 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13250 */     // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  13250 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv8i16),
     /*  13253 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13255 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  13257 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  13261 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13264 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13270 */     GIR_RootConstrainSelectedInstOperands,
     /*  13271 */     // GIR_Coverage, 984,
     /*  13271 */     GIR_EraseRootFromParent_Done,
     /*  13272 */   // Label 285: @13272
     /*  13272 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(13329), // Rule ID 987 //
     /*  13277 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13284 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13288 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13292 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*  13296 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  13300 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  13305 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13307 */     // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  13307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
     /*  13310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13312 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  13314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
     /*  13318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13321 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13327 */     GIR_RootConstrainSelectedInstOperands,
     /*  13328 */     // GIR_Coverage, 987,
     /*  13328 */     GIR_EraseRootFromParent_Done,
     /*  13329 */   // Label 286: @13329
     /*  13329 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(13369), // Rule ID 961 //
     /*  13334 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13337 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13341 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13345 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13349 */     // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*  13349 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i16),
     /*  13352 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13354 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  13356 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  13358 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13361 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13367 */     GIR_RootConstrainSelectedInstOperands,
     /*  13368 */     // GIR_Coverage, 961,
     /*  13368 */     GIR_EraseRootFromParent_Done,
     /*  13369 */   // Label 287: @13369
     /*  13369 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(13430), // Rule ID 3501 //
     /*  13374 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  13377 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13381 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13385 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13389 */     // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  13389 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13392 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13396 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13401 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi16),
     /*  13404 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  13406 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  13408 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  13410 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  13413 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13419 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13425 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  13428 */     GIR_RootConstrainSelectedInstOperands,
     /*  13429 */     // GIR_Coverage, 3501,
     /*  13429 */     GIR_EraseRootFromParent_Done,
     /*  13430 */   // Label 288: @13430
     /*  13430 */   GIM_Reject,
     /*  13431 */ // Label 277: @13431
     /*  13431 */ GIM_Reject,
     /*  13432 */ // Label 231: @13432
     /*  13432 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(13615),
     /*  13437 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  13440 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  13443 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(13513), // Rule ID 915 //
     /*  13448 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13451 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13455 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13459 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13463 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  13467 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  13471 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  13475 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13480 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13485 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13487 */     // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  13487 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv16i8),
     /*  13490 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13492 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13494 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
     /*  13498 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
     /*  13502 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13505 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13511 */     GIR_RootConstrainSelectedInstOperands,
     /*  13512 */     // GIR_Coverage, 915,
     /*  13512 */     GIR_EraseRootFromParent_Done,
     /*  13513 */   // Label 290: @13513
     /*  13513 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(13553), // Rule ID 960 //
     /*  13518 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  13521 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13525 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13529 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  13533 */     // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  13533 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv16i8),
     /*  13536 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  13538 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  13540 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  13542 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13545 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13551 */     GIR_RootConstrainSelectedInstOperands,
     /*  13552 */     // GIR_Coverage, 960,
     /*  13552 */     GIR_EraseRootFromParent_Done,
     /*  13553 */   // Label 291: @13553
     /*  13553 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(13614), // Rule ID 3497 //
     /*  13558 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  13561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13565 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13569 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  13573 */     // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  13573 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  13576 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13580 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi8),
     /*  13588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  13590 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  13592 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  13594 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  13597 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13603 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13609 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  13612 */     GIR_RootConstrainSelectedInstOperands,
     /*  13613 */     // GIR_Coverage, 3497,
     /*  13613 */     GIR_EraseRootFromParent_Done,
     /*  13614 */   // Label 292: @13614
     /*  13614 */   GIM_Reject,
     /*  13615 */ // Label 289: @13615
     /*  13615 */ GIM_Reject,
     /*  13616 */ // Label 232: @13616
     /*  13616 */ GIM_Reject,
     /*  13617 */ // Label 2: @13617
     /*  13617 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 300*/ GIMT_Encode4(15320),
     /*  13628 */ /*GILLT_s32*//*Label 293*/ GIMT_Encode4(13688), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  13640 */ /*GILLT_v2s32*//*Label 294*/ GIMT_Encode4(14607), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  13652 */ /*GILLT_v4s16*//*Label 295*/ GIMT_Encode4(14654),
     /*  13656 */ /*GILLT_v4s32*//*Label 296*/ GIMT_Encode4(14701), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  13668 */ /*GILLT_v8s8*//*Label 297*/ GIMT_Encode4(14930),
     /*  13672 */ /*GILLT_v8s16*//*Label 298*/ GIMT_Encode4(14977), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  13684 */ /*GILLT_v16s8*//*Label 299*/ GIMT_Encode4(15206),
     /*  13688 */ // Label 293: @13688
     /*  13688 */ GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(14606),
     /*  13693 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  13696 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  13699 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(13787), // Rule ID 186 //
     /*  13704 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
     /*  13707 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13711 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13715 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13719 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  13723 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  13727 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13732 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  13736 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  13740 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13744 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  13748 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  13752 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13757 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*  13761 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13763 */     // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  13763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULTT),
     /*  13766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  13768 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  13772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  13776 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13779 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13785 */     GIR_RootConstrainSelectedInstOperands,
     /*  13786 */     // GIR_Coverage, 186,
     /*  13786 */     GIR_EraseRootFromParent_Done,
     /*  13787 */   // Label 302: @13787
     /*  13787 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(13875), // Rule ID 515 //
     /*  13792 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  13795 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  13799 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13803 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13807 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  13811 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  13815 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  13820 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  13824 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  13828 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13832 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  13836 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  13840 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  13845 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*  13849 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13851 */     // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  13851 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULTT),
     /*  13854 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  13856 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  13860 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  13864 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13867 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13873 */     GIR_RootConstrainSelectedInstOperands,
     /*  13874 */     // GIR_Coverage, 515,
     /*  13874 */     GIR_EraseRootFromParent_Done,
     /*  13875 */   // Label 303: @13875
     /*  13875 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(13966), // Rule ID 185 //
     /*  13880 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
     /*  13883 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13887 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13891 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13895 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  13899 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  13903 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13908 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  13912 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  13916 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  13920 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  13924 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  13929 */     // MIs[2] Operand 2
     /*  13929 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  13940 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  13942 */     // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SMULTB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  13942 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULTB),
     /*  13945 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  13947 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  13951 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  13955 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  13958 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  13964 */     GIR_RootConstrainSelectedInstOperands,
     /*  13965 */     // GIR_Coverage, 185,
     /*  13965 */     GIR_EraseRootFromParent_Done,
     /*  13966 */   // Label 304: @13966
     /*  13966 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(14057), // Rule ID 514 //
     /*  13971 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  13974 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  13978 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13982 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  13986 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  13990 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  13994 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  13999 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  14003 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14007 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14011 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14015 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14020 */     // MIs[2] Operand 2
     /*  14020 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  14031 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14033 */     // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SMULTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  14033 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULTB),
     /*  14036 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  14042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14046 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14049 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14055 */     GIR_RootConstrainSelectedInstOperands,
     /*  14056 */     // GIR_Coverage, 514,
     /*  14056 */     GIR_EraseRootFromParent_Done,
     /*  14057 */   // Label 305: @14057
     /*  14057 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(14148), // Rule ID 184 //
     /*  14062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
     /*  14065 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14069 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14073 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14077 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14081 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14086 */     // MIs[1] Operand 2
     /*  14086 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*  14097 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14101 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  14105 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14109 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  14113 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14118 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*  14122 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14124 */     // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULBT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  14124 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULBT),
     /*  14127 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14129 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  14133 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14137 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14140 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14146 */     GIR_RootConstrainSelectedInstOperands,
     /*  14147 */     // GIR_Coverage, 184,
     /*  14147 */     GIR_EraseRootFromParent_Done,
     /*  14148 */   // Label 306: @14148
     /*  14148 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(14239), // Rule ID 513 //
     /*  14153 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  14156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14160 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14164 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14168 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14172 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14177 */     // MIs[1] Operand 2
     /*  14177 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*  14188 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14192 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  14196 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14200 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  14204 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14209 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
     /*  14213 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14215 */     // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  14215 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULBT),
     /*  14218 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14220 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  14224 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14228 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14231 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14237 */     GIR_RootConstrainSelectedInstOperands,
     /*  14238 */     // GIR_Coverage, 513,
     /*  14238 */     GIR_EraseRootFromParent_Done,
     /*  14239 */   // Label 307: @14239
     /*  14239 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(14333), // Rule ID 183 //
     /*  14244 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
     /*  14247 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14251 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14255 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14259 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14263 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14268 */     // MIs[1] Operand 2
     /*  14268 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*  14279 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14283 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14287 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14291 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  14296 */     // MIs[2] Operand 2
     /*  14296 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  14307 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14309 */     // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SMULBB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  14309 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULBB),
     /*  14312 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  14318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14322 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14325 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14331 */     GIR_RootConstrainSelectedInstOperands,
     /*  14332 */     // GIR_Coverage, 183,
     /*  14332 */     GIR_EraseRootFromParent_Done,
     /*  14333 */   // Label 308: @14333
     /*  14333 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(14427), // Rule ID 512 //
     /*  14338 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  14341 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14345 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14349 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14353 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  14357 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14362 */     // MIs[1] Operand 2
     /*  14362 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*  14373 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14377 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14381 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  14385 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14390 */     // MIs[2] Operand 2
     /*  14390 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  14401 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14403 */     // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SMULBB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  14403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULBB),
     /*  14406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  14412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  14416 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14419 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14425 */     GIR_RootConstrainSelectedInstOperands,
     /*  14426 */     // GIR_Coverage, 512,
     /*  14426 */     GIR_EraseRootFromParent_Done,
     /*  14427 */   // Label 309: @14427
     /*  14427 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(14473), // Rule ID 169 //
     /*  14432 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  14435 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14439 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14443 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14447 */     // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
     /*  14447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MUL),
     /*  14450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14452 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  14454 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  14456 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14459 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14465 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14471 */     GIR_RootConstrainSelectedInstOperands,
     /*  14472 */     // GIR_Coverage, 169,
     /*  14472 */     GIR_EraseRootFromParent_Done,
     /*  14473 */   // Label 310: @14473
     /*  14473 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(14519), // Rule ID 170 //
     /*  14478 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6_UseMulOps),
     /*  14481 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14485 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14489 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  14493 */     // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
     /*  14493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MULv5),
     /*  14496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14498 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  14500 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  14502 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14505 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14511 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14517 */     GIR_RootConstrainSelectedInstOperands,
     /*  14518 */     // GIR_Coverage, 170,
     /*  14518 */     GIR_EraseRootFromParent_Done,
     /*  14519 */   // Label 311: @14519
     /*  14519 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(14565), // Rule ID 323 //
     /*  14524 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  14527 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  14531 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  14535 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  14539 */     // (mul:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tMUL:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  14539 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tMUL),
     /*  14542 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14544 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  14550 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  14552 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  14554 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14557 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14563 */     GIR_RootConstrainSelectedInstOperands,
     /*  14564 */     // GIR_Coverage, 323,
     /*  14564 */     GIR_EraseRootFromParent_Done,
     /*  14565 */   // Label 312: @14565
     /*  14565 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(14605), // Rule ID 502 //
     /*  14570 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  14573 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14577 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14581 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  14585 */     // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  14585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MUL),
     /*  14588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  14590 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  14592 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  14594 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14597 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14603 */     GIR_RootConstrainSelectedInstOperands,
     /*  14604 */     // GIR_Coverage, 502,
     /*  14604 */     GIR_EraseRootFromParent_Done,
     /*  14605 */   // Label 313: @14605
     /*  14605 */   GIM_Reject,
     /*  14606 */ // Label 301: @14606
     /*  14606 */ GIM_Reject,
     /*  14607 */ // Label 294: @14607
     /*  14607 */ GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(14653), // Rule ID 834 //
     /*  14612 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14615 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  14618 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  14621 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14625 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14629 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14633 */   // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  14633 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv2i32),
     /*  14636 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  14638 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  14640 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  14642 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14645 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14651 */   GIR_RootConstrainSelectedInstOperands,
     /*  14652 */   // GIR_Coverage, 834,
     /*  14652 */   GIR_EraseRootFromParent_Done,
     /*  14653 */ // Label 314: @14653
     /*  14653 */ GIM_Reject,
     /*  14654 */ // Label 295: @14654
     /*  14654 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(14700), // Rule ID 833 //
     /*  14659 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14662 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  14665 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  14668 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14672 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14676 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14680 */   // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
     /*  14680 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i16),
     /*  14683 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  14685 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  14687 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  14689 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14692 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14698 */   GIR_RootConstrainSelectedInstOperands,
     /*  14699 */   // GIR_Coverage, 833,
     /*  14699 */   GIR_EraseRootFromParent_Done,
     /*  14700 */ // Label 315: @14700
     /*  14700 */ GIM_Reject,
     /*  14701 */ // Label 296: @14701
     /*  14701 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(14929),
     /*  14706 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14709 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14712 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(14827), // Rule ID 4418 //
     /*  14717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  14720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14732 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14736 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14741 */     // MIs[1] Operand 2
     /*  14741 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
     /*  14752 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  14756 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  14760 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14764 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14769 */     // MIs[2] Operand 2
     /*  14769 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  14780 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14782 */     // (mul:{ *:[v4i32] } (sext_inreg:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, v4i16:{ *:[Other] }), (sext_inreg:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src2, v4i16:{ *:[Other] }))  =>  (MVE_VMULLBs16:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)
     /*  14782 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14785 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14789 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14794 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULLBs16),
     /*  14797 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  14799 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  14803 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  14807 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14810 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14816 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14822 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  14825 */     GIR_RootConstrainSelectedInstOperands,
     /*  14826 */     // GIR_Coverage, 4418,
     /*  14826 */     GIR_EraseRootFromParent_Done,
     /*  14827 */   // Label 317: @14827
     /*  14827 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(14867), // Rule ID 837 //
     /*  14832 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14835 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  14839 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  14843 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  14847 */     // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  14847 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i32),
     /*  14850 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  14852 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  14854 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  14856 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14859 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14865 */     GIR_RootConstrainSelectedInstOperands,
     /*  14866 */     // GIR_Coverage, 837,
     /*  14866 */     GIR_EraseRootFromParent_Done,
     /*  14867 */   // Label 318: @14867
     /*  14867 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(14928), // Rule ID 3463 //
     /*  14872 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  14875 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14879 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14883 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  14887 */     // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VMULi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*  14887 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  14890 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  14894 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14899 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi32),
     /*  14902 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  14904 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  14906 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  14908 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  14911 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14917 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14923 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  14926 */     GIR_RootConstrainSelectedInstOperands,
     /*  14927 */     // GIR_Coverage, 3463,
     /*  14927 */     GIR_EraseRootFromParent_Done,
     /*  14928 */   // Label 319: @14928
     /*  14928 */   GIM_Reject,
     /*  14929 */ // Label 316: @14929
     /*  14929 */ GIM_Reject,
     /*  14930 */ // Label 297: @14930
     /*  14930 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(14976), // Rule ID 832 //
     /*  14935 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  14938 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  14941 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  14944 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14948 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14952 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  14956 */   // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
     /*  14956 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i8),
     /*  14959 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  14961 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  14963 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  14965 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  14968 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  14974 */   GIR_RootConstrainSelectedInstOperands,
     /*  14975 */   // GIR_Coverage, 832,
     /*  14975 */   GIR_EraseRootFromParent_Done,
     /*  14976 */ // Label 320: @14976
     /*  14976 */ GIM_Reject,
     /*  14977 */ // Label 298: @14977
     /*  14977 */ GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(15205),
     /*  14982 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  14985 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  14988 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(15103), // Rule ID 4423 //
     /*  14993 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  14996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  15008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  15012 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15017 */     // MIs[1] Operand 2
     /*  15017 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
     /*  15028 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  15032 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  15036 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  15040 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15045 */     // MIs[2] Operand 2
     /*  15045 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(8),
     /*  15056 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15058 */     // (mul:{ *:[v8i16] } (sext_inreg:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, v8i8:{ *:[Other] }), (sext_inreg:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src2, v8i8:{ *:[Other] }))  =>  (MVE_VMULLBs8:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)
     /*  15058 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  15061 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15065 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULLBs8),
     /*  15073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  15075 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  15079 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  15083 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15086 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15092 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15098 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15101 */     GIR_RootConstrainSelectedInstOperands,
     /*  15102 */     // GIR_Coverage, 4423,
     /*  15102 */     GIR_EraseRootFromParent_Done,
     /*  15103 */   // Label 322: @15103
     /*  15103 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(15143), // Rule ID 836 //
     /*  15108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15111 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15115 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15119 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15123 */     // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
     /*  15123 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i16),
     /*  15126 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  15128 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  15130 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  15132 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15135 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15141 */     GIR_RootConstrainSelectedInstOperands,
     /*  15142 */     // GIR_Coverage, 836,
     /*  15142 */     GIR_EraseRootFromParent_Done,
     /*  15143 */   // Label 323: @15143
     /*  15143 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(15204), // Rule ID 3459 //
     /*  15148 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  15151 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15155 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15159 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15163 */     // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VMULi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  15163 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  15166 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15170 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15175 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi16),
     /*  15178 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  15180 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  15182 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  15184 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15187 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15193 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15199 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15202 */     GIR_RootConstrainSelectedInstOperands,
     /*  15203 */     // GIR_Coverage, 3459,
     /*  15203 */     GIR_EraseRootFromParent_Done,
     /*  15204 */   // Label 324: @15204
     /*  15204 */   GIM_Reject,
     /*  15205 */ // Label 321: @15205
     /*  15205 */ GIM_Reject,
     /*  15206 */ // Label 299: @15206
     /*  15206 */ GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(15319),
     /*  15211 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  15214 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  15217 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(15257), // Rule ID 835 //
     /*  15222 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  15225 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15229 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15233 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  15237 */     // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
     /*  15237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv16i8),
     /*  15240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  15242 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  15244 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  15246 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15249 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15255 */     GIR_RootConstrainSelectedInstOperands,
     /*  15256 */     // GIR_Coverage, 835,
     /*  15256 */     GIR_EraseRootFromParent_Done,
     /*  15257 */   // Label 326: @15257
     /*  15257 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(15318), // Rule ID 3455 //
     /*  15262 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  15265 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15269 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15273 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  15277 */     // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VMULi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  15277 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  15280 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15284 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi8),
     /*  15292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  15294 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  15296 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  15298 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15301 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15307 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15313 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15316 */     GIR_RootConstrainSelectedInstOperands,
     /*  15317 */     // GIR_Coverage, 3455,
     /*  15317 */     GIR_EraseRootFromParent_Done,
     /*  15318 */   // Label 327: @15318
     /*  15318 */   GIM_Reject,
     /*  15319 */ // Label 325: @15319
     /*  15319 */ GIM_Reject,
     /*  15320 */ // Label 300: @15320
     /*  15320 */ GIM_Reject,
     /*  15321 */ // Label 3: @15321
     /*  15321 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(15416),
     /*  15326 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /*  15329 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  15332 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  15335 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(15375), // Rule ID 195 //
     /*  15340 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
     /*  15343 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15347 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15351 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15355 */     // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  15355 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SDIV),
     /*  15358 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15360 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  15362 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  15364 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15367 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15373 */     GIR_RootConstrainSelectedInstOperands,
     /*  15374 */     // GIR_Coverage, 195,
     /*  15374 */     GIR_EraseRootFromParent_Done,
     /*  15375 */   // Label 329: @15375
     /*  15375 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(15415), // Rule ID 532 //
     /*  15380 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
     /*  15383 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15387 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15391 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15395 */     // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  15395 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SDIV),
     /*  15398 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15400 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  15402 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  15404 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15407 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15413 */     GIR_RootConstrainSelectedInstOperands,
     /*  15414 */     // GIR_Coverage, 532,
     /*  15414 */     GIR_EraseRootFromParent_Done,
     /*  15415 */   // Label 330: @15415
     /*  15415 */   GIM_Reject,
     /*  15416 */ // Label 328: @15416
     /*  15416 */ GIM_Reject,
     /*  15417 */ // Label 4: @15417
     /*  15417 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(15512),
     /*  15422 */   GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
     /*  15425 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  15428 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  15431 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(15471), // Rule ID 196 //
     /*  15436 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
     /*  15439 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15443 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15447 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15451 */     // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  15451 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UDIV),
     /*  15454 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15456 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  15458 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  15460 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15463 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15469 */     GIR_RootConstrainSelectedInstOperands,
     /*  15470 */     // GIR_Coverage, 196,
     /*  15470 */     GIR_EraseRootFromParent_Done,
     /*  15471 */   // Label 332: @15471
     /*  15471 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(15511), // Rule ID 533 //
     /*  15476 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
     /*  15479 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15483 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15487 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15491 */     // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  15491 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UDIV),
     /*  15494 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15496 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  15498 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  15500 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15503 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15509 */     GIR_RootConstrainSelectedInstOperands,
     /*  15510 */     // GIR_Coverage, 533,
     /*  15510 */     GIR_EraseRootFromParent_Done,
     /*  15511 */   // Label 333: @15511
     /*  15511 */   GIM_Reject,
     /*  15512 */ // Label 331: @15512
     /*  15512 */ GIM_Reject,
     /*  15513 */ // Label 5: @15513
     /*  15513 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 347*/ GIMT_Encode4(18692),
     /*  15524 */ /*GILLT_s32*//*Label 334*/ GIMT_Encode4(15584),
     /*  15528 */ /*GILLT_s64*//*Label 335*/ GIMT_Encode4(17576),
     /*  15532 */ /*GILLT_v2s1*//*Label 336*/ GIMT_Encode4(17623),
     /*  15536 */ /*GILLT_v2s32*//*Label 337*/ GIMT_Encode4(17741),
     /*  15540 */ /*GILLT_v2s64*//*Label 338*/ GIMT_Encode4(17788),
     /*  15544 */ /*GILLT_v4s1*//*Label 339*/ GIMT_Encode4(17902),
     /*  15548 */ /*GILLT_v4s16*//*Label 340*/ GIMT_Encode4(18020),
     /*  15552 */ /*GILLT_v4s32*//*Label 341*/ GIMT_Encode4(18067), GIMT_Encode4(0),
     /*  15560 */ /*GILLT_v8s1*//*Label 342*/ GIMT_Encode4(18181),
     /*  15564 */ /*GILLT_v8s8*//*Label 343*/ GIMT_Encode4(18299),
     /*  15568 */ /*GILLT_v8s16*//*Label 344*/ GIMT_Encode4(18346), GIMT_Encode4(0),
     /*  15576 */ /*GILLT_v16s1*//*Label 345*/ GIMT_Encode4(18460),
     /*  15580 */ /*GILLT_v16s8*//*Label 346*/ GIMT_Encode4(18578),
     /*  15584 */ // Label 334: @15584
     /*  15584 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(17575),
     /*  15589 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  15592 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  15595 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(15668), // Rule ID 1852 //
     /*  15600 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  15603 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  15607 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15611 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15615 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  15619 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  15623 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15628 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  15632 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
     /*  15643 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15645 */     // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
     /*  15645 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
     /*  15648 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15650 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
     /*  15654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*  15657 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15660 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15666 */     GIR_RootConstrainSelectedInstOperands,
     /*  15667 */     // GIR_Coverage, 1852,
     /*  15667 */     GIR_EraseRootFromParent_Done,
     /*  15668 */   // Label 349: @15668
     /*  15668 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(15741), // Rule ID 2109 //
     /*  15673 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  15676 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15680 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15684 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  15688 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  15692 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  15696 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15701 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  15705 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
     /*  15716 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15718 */     // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
     /*  15718 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
     /*  15721 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15723 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
     /*  15727 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*  15730 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15733 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15739 */     GIR_RootConstrainSelectedInstOperands,
     /*  15740 */     // GIR_Coverage, 2109,
     /*  15740 */     GIR_EraseRootFromParent_Done,
     /*  15741 */   // Label 350: @15741
     /*  15741 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(15789), // Rule ID 1994 //
     /*  15746 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  15749 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  15753 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15757 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  15768 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
     /*  15768 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB),
     /*  15771 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15773 */     GIR_RootToRootCopy, /*OpIdx*/1, // Src
     /*  15775 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15778 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15781 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15787 */     GIR_RootConstrainSelectedInstOperands,
     /*  15788 */     // GIR_Coverage, 1994,
     /*  15788 */     GIR_EraseRootFromParent_Done,
     /*  15789 */   // Label 351: @15789
     /*  15789 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(15837), // Rule ID 1995 //
     /*  15794 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  15797 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  15801 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15805 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
     /*  15816 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
     /*  15816 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTH),
     /*  15819 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15821 */     GIR_RootToRootCopy, /*OpIdx*/1, // Src
     /*  15823 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15826 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15829 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15835 */     GIR_RootConstrainSelectedInstOperands,
     /*  15836 */     // GIR_Coverage, 1995,
     /*  15836 */     GIR_EraseRootFromParent_Done,
     /*  15837 */   // Label 352: @15837
     /*  15837 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(15885), // Rule ID 1996 //
     /*  15842 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  15845 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  15849 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  15853 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
     /*  15864 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
     /*  15864 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
     /*  15867 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15869 */     GIR_RootToRootCopy, /*OpIdx*/1, // Src
     /*  15871 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15877 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15883 */     GIR_RootConstrainSelectedInstOperands,
     /*  15884 */     // GIR_Coverage, 1996,
     /*  15884 */     GIR_EraseRootFromParent_Done,
     /*  15885 */   // Label 353: @15885
     /*  15885 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(15933), // Rule ID 2233 //
     /*  15890 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  15893 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15897 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15901 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  15912 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*  15912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB),
     /*  15915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15917 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  15919 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15922 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15925 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15931 */     GIR_RootConstrainSelectedInstOperands,
     /*  15932 */     // GIR_Coverage, 2233,
     /*  15932 */     GIR_EraseRootFromParent_Done,
     /*  15933 */   // Label 354: @15933
     /*  15933 */   GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(15981), // Rule ID 2234 //
     /*  15938 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  15941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15945 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15949 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
     /*  15960 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*  15960 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTH),
     /*  15963 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  15965 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  15967 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  15973 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  15979 */     GIR_RootConstrainSelectedInstOperands,
     /*  15980 */     // GIR_Coverage, 2234,
     /*  15980 */     GIR_EraseRootFromParent_Done,
     /*  15981 */   // Label 355: @15981
     /*  15981 */   GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(16029), // Rule ID 2235 //
     /*  15986 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  15989 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15993 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  15997 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
     /*  16008 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*  16008 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
     /*  16011 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16013 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  16015 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16018 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16021 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16027 */     GIR_RootConstrainSelectedInstOperands,
     /*  16028 */     // GIR_Coverage, 2235,
     /*  16028 */     GIR_EraseRootFromParent_Done,
     /*  16029 */   // Label 356: @16029
     /*  16029 */   GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(16106), // Rule ID 5436 //
     /*  16034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16037 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16049 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16053 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16057 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  16061 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16065 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16069 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  16073 */     // MIs[2] Operand 1
     /*  16073 */     // No operand predicates
     /*  16073 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16077 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16079 */     // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16079 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
     /*  16082 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16084 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16086 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16089 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16092 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16098 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16104 */     GIR_RootConstrainSelectedInstOperands,
     /*  16105 */     // GIR_Coverage, 5436,
     /*  16105 */     GIR_EraseRootFromParent_Done,
     /*  16106 */   // Label 357: @16106
     /*  16106 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(16183), // Rule ID 5469 //
     /*  16111 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  16114 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16118 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16122 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16126 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16130 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16134 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  16138 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16142 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16146 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  16150 */     // MIs[2] Operand 1
     /*  16150 */     // No operand predicates
     /*  16150 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16154 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16156 */     // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16156 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
     /*  16159 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16161 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16163 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16166 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16169 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16175 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16181 */     GIR_RootConstrainSelectedInstOperands,
     /*  16182 */     // GIR_Coverage, 5469,
     /*  16182 */     GIR_EraseRootFromParent_Done,
     /*  16183 */   // Label 358: @16183
     /*  16183 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(16260), // Rule ID 5435 //
     /*  16188 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16191 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16195 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16199 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16203 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16207 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16211 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16215 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16219 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  16223 */     // MIs[2] Operand 1
     /*  16223 */     // No operand predicates
     /*  16223 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16227 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16231 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16233 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
     /*  16236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16238 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16240 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16243 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16246 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16252 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16258 */     GIR_RootConstrainSelectedInstOperands,
     /*  16259 */     // GIR_Coverage, 5435,
     /*  16259 */     GIR_EraseRootFromParent_Done,
     /*  16260 */   // Label 359: @16260
     /*  16260 */   GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(16337), // Rule ID 5468 //
     /*  16265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  16268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16272 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16276 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16280 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16284 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16288 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16292 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16296 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  16300 */     // MIs[2] Operand 1
     /*  16300 */     // No operand predicates
     /*  16300 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16304 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16308 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16310 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16310 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
     /*  16313 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16315 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16317 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16320 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16323 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16329 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16335 */     GIR_RootConstrainSelectedInstOperands,
     /*  16336 */     // GIR_Coverage, 5468,
     /*  16336 */     GIR_EraseRootFromParent_Done,
     /*  16337 */   // Label 360: @16337
     /*  16337 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(16414), // Rule ID 5434 //
     /*  16342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16345 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16349 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16353 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16357 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16361 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16365 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16369 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  16373 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16377 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16381 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  16385 */     // MIs[2] Operand 1
     /*  16385 */     // No operand predicates
     /*  16385 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16387 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16387 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
     /*  16390 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16392 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16394 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16397 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16400 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16406 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16412 */     GIR_RootConstrainSelectedInstOperands,
     /*  16413 */     // GIR_Coverage, 5434,
     /*  16413 */     GIR_EraseRootFromParent_Done,
     /*  16414 */   // Label 361: @16414
     /*  16414 */   GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(16491), // Rule ID 5467 //
     /*  16419 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  16422 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16426 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16430 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16434 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16438 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16442 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16446 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  16450 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16454 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16458 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  16462 */     // MIs[2] Operand 1
     /*  16462 */     // No operand predicates
     /*  16462 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16464 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16464 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
     /*  16467 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16469 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16471 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16474 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16477 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16483 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16489 */     GIR_RootConstrainSelectedInstOperands,
     /*  16490 */     // GIR_Coverage, 5467,
     /*  16490 */     GIR_EraseRootFromParent_Done,
     /*  16491 */   // Label 362: @16491
     /*  16491 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(16568), // Rule ID 159 //
     /*  16496 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16499 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16503 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16507 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16511 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16515 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16519 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16523 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16527 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16531 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  16535 */     // MIs[2] Operand 1
     /*  16535 */     // No operand predicates
     /*  16535 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16539 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16541 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16541 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
     /*  16544 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16546 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16548 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16551 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16554 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16560 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16566 */     GIR_RootConstrainSelectedInstOperands,
     /*  16567 */     // GIR_Coverage, 159,
     /*  16567 */     GIR_EraseRootFromParent_Done,
     /*  16568 */   // Label 363: @16568
     /*  16568 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(16645), // Rule ID 490 //
     /*  16573 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  16576 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16580 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16584 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16588 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16592 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16596 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16600 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  16604 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16608 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  16612 */     // MIs[2] Operand 1
     /*  16612 */     // No operand predicates
     /*  16612 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16616 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16618 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  16618 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
     /*  16621 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16623 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16625 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  16628 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16631 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16637 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16643 */     GIR_RootConstrainSelectedInstOperands,
     /*  16644 */     // GIR_Coverage, 490,
     /*  16644 */     GIR_EraseRootFromParent_Done,
     /*  16645 */   // Label 364: @16645
     /*  16645 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(16716), // Rule ID 5437 //
     /*  16650 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16653 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16657 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16661 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16665 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16669 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16673 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16678 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16682 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16686 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16688 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  16688 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
     /*  16691 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16693 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16695 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  16699 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16702 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16708 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16714 */     GIR_RootConstrainSelectedInstOperands,
     /*  16715 */     // GIR_Coverage, 5437,
     /*  16715 */     GIR_EraseRootFromParent_Done,
     /*  16716 */   // Label 365: @16716
     /*  16716 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(16787), // Rule ID 5458 //
     /*  16721 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  16724 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16736 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16740 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16744 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16749 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16753 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16757 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16759 */     // (and:{ *:[i32] } (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), tGPR:{ *:[i32] }:$Rn)  =>  (tBIC:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  16759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tBIC),
     /*  16762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  16764 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  16770 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  16776 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16779 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16785 */     GIR_RootConstrainSelectedInstOperands,
     /*  16786 */     // GIR_Coverage, 5458,
     /*  16786 */     GIR_EraseRootFromParent_Done,
     /*  16787 */   // Label 366: @16787
     /*  16787 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(16858), // Rule ID 5470 //
     /*  16792 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  16795 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16799 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16803 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16807 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16811 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16815 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16820 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16824 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  16828 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16830 */     // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  16830 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
     /*  16833 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16835 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  16837 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  16841 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16844 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16850 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16856 */     GIR_RootConstrainSelectedInstOperands,
     /*  16857 */     // GIR_Coverage, 5470,
     /*  16857 */     GIR_EraseRootFromParent_Done,
     /*  16858 */   // Label 367: @16858
     /*  16858 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(16929), // Rule ID 160 //
     /*  16863 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  16866 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16870 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16874 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16878 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16882 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16886 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16890 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  16895 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16899 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16901 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  16901 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
     /*  16904 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  16906 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16908 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  16912 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16915 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16921 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16927 */     GIR_RootConstrainSelectedInstOperands,
     /*  16928 */     // GIR_Coverage, 160,
     /*  16928 */     GIR_EraseRootFromParent_Done,
     /*  16929 */   // Label 368: @16929
     /*  16929 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(17000), // Rule ID 313 //
     /*  16934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  16937 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16941 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16945 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16949 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16953 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16957 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16961 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  16966 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  16970 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16972 */     // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (tBIC:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  16972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tBIC),
     /*  16975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  16977 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  16983 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  16985 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  16989 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  16992 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  16998 */     GIR_RootConstrainSelectedInstOperands,
     /*  16999 */     // GIR_Coverage, 313,
     /*  16999 */     GIR_EraseRootFromParent_Done,
     /*  17000 */   // Label 369: @17000
     /*  17000 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(17071), // Rule ID 491 //
     /*  17005 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  17008 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17012 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17016 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17020 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17024 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17028 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17032 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17037 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  17041 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17043 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  17043 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
     /*  17046 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17048 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17050 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  17054 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17057 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17063 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17069 */     GIR_RootConstrainSelectedInstOperands,
     /*  17070 */     // GIR_Coverage, 491,
     /*  17070 */     GIR_EraseRootFromParent_Done,
     /*  17071 */   // Label 370: @17071
     /*  17071 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(17116), // Rule ID 345 //
     /*  17076 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
     /*  17079 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17083 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17087 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  17098 */     // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
     /*  17098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTB),
     /*  17101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17103 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  17105 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17108 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17114 */     GIR_RootConstrainSelectedInstOperands,
     /*  17115 */     // GIR_Coverage, 345,
     /*  17115 */     GIR_EraseRootFromParent_Done,
     /*  17116 */   // Label 371: @17116
     /*  17116 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(17161), // Rule ID 346 //
     /*  17121 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
     /*  17124 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17128 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17132 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
     /*  17143 */     // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
     /*  17143 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTH),
     /*  17146 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17148 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  17150 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17153 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17159 */     GIR_RootConstrainSelectedInstOperands,
     /*  17160 */     // GIR_Coverage, 346,
     /*  17160 */     GIR_EraseRootFromParent_Done,
     /*  17161 */   // Label 372: @17161
     /*  17161 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(17220), // Rule ID 1891 //
     /*  17166 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  17169 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17173 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17177 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17181 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17185 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm_not),
     /*  17189 */     // MIs[1] Operand 1
     /*  17189 */     // No operand predicates
     /*  17189 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17191 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>><<X:imm_not_XFORM>>:$imm)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm_not_XFORM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>>:$imm))
     /*  17191 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
     /*  17194 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17196 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  17198 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderInvertedImm), // imm
     /*  17203 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17206 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17212 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17218 */     GIR_RootConstrainSelectedInstOperands,
     /*  17219 */     // GIR_Coverage, 1891,
     /*  17219 */     GIR_EraseRootFromParent_Done,
     /*  17220 */   // Label 373: @17220
     /*  17220 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(17277), // Rule ID 147 //
     /*  17225 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  17228 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17232 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17236 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17240 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17244 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  17248 */     // MIs[1] Operand 1
     /*  17248 */     // No operand predicates
     /*  17248 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17250 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  17250 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDri),
     /*  17253 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17255 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17257 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  17260 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17263 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17269 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17275 */     GIR_RootConstrainSelectedInstOperands,
     /*  17276 */     // GIR_Coverage, 147,
     /*  17276 */     GIR_EraseRootFromParent_Done,
     /*  17277 */   // Label 374: @17277
     /*  17277 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(17334), // Rule ID 481 //
     /*  17282 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  17285 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17289 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17293 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17297 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17301 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  17305 */     // MIs[1] Operand 1
     /*  17305 */     // No operand predicates
     /*  17305 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17307 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  17307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDri),
     /*  17310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17312 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17314 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  17317 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17320 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17326 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17332 */     GIR_RootConstrainSelectedInstOperands,
     /*  17333 */     // GIR_Coverage, 481,
     /*  17333 */     GIR_EraseRootFromParent_Done,
     /*  17334 */   // Label 375: @17334
     /*  17334 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(17385), // Rule ID 163 //
     /*  17339 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
     /*  17342 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17346 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17358 */     // MIs[1] Operand 1
     /*  17358 */     // No operand predicates
     /*  17358 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
     /*  17362 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17364 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
     /*  17364 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BFC),
     /*  17367 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17369 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  17371 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  17374 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17377 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17383 */     GIR_RootConstrainSelectedInstOperands,
     /*  17384 */     // GIR_Coverage, 163,
     /*  17384 */     GIR_EraseRootFromParent_Done,
     /*  17385 */   // Label 376: @17385
     /*  17385 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(17436), // Rule ID 493 //
     /*  17390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  17393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17397 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17409 */     // MIs[1] Operand 1
     /*  17409 */     // No operand predicates
     /*  17409 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
     /*  17413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17415 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
     /*  17415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BFC),
     /*  17418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17420 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  17422 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  17425 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17428 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17434 */     GIR_RootConstrainSelectedInstOperands,
     /*  17435 */     // GIR_Coverage, 493,
     /*  17435 */     GIR_EraseRootFromParent_Done,
     /*  17436 */   // Label 377: @17436
     /*  17436 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(17482), // Rule ID 148 //
     /*  17441 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  17444 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17448 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17452 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  17456 */     // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  17456 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDrr),
     /*  17459 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17461 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17463 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  17465 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17468 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17474 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17480 */     GIR_RootConstrainSelectedInstOperands,
     /*  17481 */     // GIR_Coverage, 148,
     /*  17481 */     GIR_EraseRootFromParent_Done,
     /*  17482 */   // Label 378: @17482
     /*  17482 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(17528), // Rule ID 310 //
     /*  17487 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  17490 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17494 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17498 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  17502 */     // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tAND:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  17502 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tAND),
     /*  17505 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  17507 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  17513 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17515 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  17517 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17520 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17526 */     GIR_RootConstrainSelectedInstOperands,
     /*  17527 */     // GIR_Coverage, 310,
     /*  17527 */     GIR_EraseRootFromParent_Done,
     /*  17528 */   // Label 379: @17528
     /*  17528 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(17574), // Rule ID 482 //
     /*  17533 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  17536 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17540 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17544 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17548 */     // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  17548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
     /*  17551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  17553 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  17555 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  17557 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17560 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17566 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17572 */     GIR_RootConstrainSelectedInstOperands,
     /*  17573 */     // GIR_Coverage, 482,
     /*  17573 */     GIR_EraseRootFromParent_Done,
     /*  17574 */   // Label 380: @17574
     /*  17574 */   GIM_Reject,
     /*  17575 */ // Label 348: @17575
     /*  17575 */ GIM_Reject,
     /*  17576 */ // Label 335: @17576
     /*  17576 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(17622), // Rule ID 2523 //
     /*  17581 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17584 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  17587 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  17590 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17594 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17598 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17602 */   // (and:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VANDd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
     /*  17602 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
     /*  17605 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  17607 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  17609 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  17611 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17614 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17620 */   GIR_RootConstrainSelectedInstOperands,
     /*  17621 */   // GIR_Coverage, 2523,
     /*  17621 */   GIR_EraseRootFromParent_Done,
     /*  17622 */ // Label 381: @17622
     /*  17622 */ GIM_Reject,
     /*  17623 */ // Label 336: @17623
     /*  17623 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(17740), // Rule ID 1823 //
     /*  17628 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  17631 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  17634 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  17637 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17641 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17645 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17649 */   // (and:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  17649 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  17652 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17656 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17661 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  17665 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17670 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17673 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17677 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17682 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  17686 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17691 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17694 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
     /*  17698 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17703 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17706 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  17709 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  17712 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17718 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17724 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  17726 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17729 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17731 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17734 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17739 */   // GIR_Coverage, 1823,
     /*  17739 */   GIR_EraseRootFromParent_Done,
     /*  17740 */ // Label 382: @17740
     /*  17740 */ GIM_Reject,
     /*  17741 */ // Label 337: @17741
     /*  17741 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(17787), // Rule ID 1130 //
     /*  17746 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17749 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  17752 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  17755 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17759 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17763 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  17767 */   // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  17767 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
     /*  17770 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  17772 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  17774 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  17776 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17779 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17785 */   GIR_RootConstrainSelectedInstOperands,
     /*  17786 */   // GIR_Coverage, 1130,
     /*  17786 */   GIR_EraseRootFromParent_Done,
     /*  17787 */ // Label 383: @17787
     /*  17787 */ GIM_Reject,
     /*  17788 */ // Label 338: @17788
     /*  17788 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(17901),
     /*  17793 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  17796 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  17799 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(17839), // Rule ID 2526 //
     /*  17804 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  17807 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  17811 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  17815 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  17819 */     // (and:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VANDq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
     /*  17819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
     /*  17822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  17824 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  17826 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  17828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  17831 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17837 */     GIR_RootConstrainSelectedInstOperands,
     /*  17838 */     // GIR_Coverage, 2526,
     /*  17838 */     GIR_EraseRootFromParent_Done,
     /*  17839 */   // Label 385: @17839
     /*  17839 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(17900), // Rule ID 3367 //
     /*  17844 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  17847 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  17851 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  17855 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  17859 */     // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
     /*  17859 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  17862 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  17866 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17871 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
     /*  17874 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  17876 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  17878 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  17880 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17883 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17889 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17895 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17898 */     GIR_RootConstrainSelectedInstOperands,
     /*  17899 */     // GIR_Coverage, 3367,
     /*  17899 */     GIR_EraseRootFromParent_Done,
     /*  17900 */   // Label 386: @17900
     /*  17900 */   GIM_Reject,
     /*  17901 */ // Label 384: @17901
     /*  17901 */ GIM_Reject,
     /*  17902 */ // Label 339: @17902
     /*  17902 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(18019), // Rule ID 1824 //
     /*  17907 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  17910 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  17913 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  17916 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17920 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17924 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  17928 */   // (and:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  17928 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  17931 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17935 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17940 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  17944 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17949 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17952 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17956 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17961 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  17965 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  17970 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17973 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
     /*  17977 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17982 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17985 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  17988 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  17991 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  17997 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18003 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  18005 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18008 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18010 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18013 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18018 */   // GIR_Coverage, 1824,
     /*  18018 */   GIR_EraseRootFromParent_Done,
     /*  18019 */ // Label 387: @18019
     /*  18019 */ GIM_Reject,
     /*  18020 */ // Label 340: @18020
     /*  18020 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(18066), // Rule ID 2522 //
     /*  18025 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18028 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  18031 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  18034 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18038 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18042 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18046 */   // (and:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VANDd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
     /*  18046 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
     /*  18049 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  18051 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  18053 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  18055 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18058 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18064 */   GIR_RootConstrainSelectedInstOperands,
     /*  18065 */   // GIR_Coverage, 2522,
     /*  18065 */   GIR_EraseRootFromParent_Done,
     /*  18066 */ // Label 388: @18066
     /*  18066 */ GIM_Reject,
     /*  18067 */ // Label 341: @18067
     /*  18067 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(18180),
     /*  18072 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18075 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18078 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(18118), // Rule ID 1131 //
     /*  18083 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18086 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18090 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18094 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18098 */     // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  18098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
     /*  18101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  18103 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  18105 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  18107 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18110 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18116 */     GIR_RootConstrainSelectedInstOperands,
     /*  18117 */     // GIR_Coverage, 1131,
     /*  18117 */     GIR_EraseRootFromParent_Done,
     /*  18118 */   // Label 390: @18118
     /*  18118 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(18179), // Rule ID 3363 //
     /*  18123 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  18126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18130 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18134 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18138 */     // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*  18138 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  18141 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  18145 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18150 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
     /*  18153 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  18155 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  18157 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  18159 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18162 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18168 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18174 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18177 */     GIR_RootConstrainSelectedInstOperands,
     /*  18178 */     // GIR_Coverage, 3363,
     /*  18178 */     GIR_EraseRootFromParent_Done,
     /*  18179 */   // Label 391: @18179
     /*  18179 */   GIM_Reject,
     /*  18180 */ // Label 389: @18180
     /*  18180 */ GIM_Reject,
     /*  18181 */ // Label 342: @18181
     /*  18181 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(18298), // Rule ID 1825 //
     /*  18186 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  18189 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  18192 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  18195 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18199 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18203 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18207 */   // (and:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  18207 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  18210 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18214 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18219 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  18223 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18228 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  18231 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18235 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18240 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  18244 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18249 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  18252 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
     /*  18256 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18261 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  18264 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  18267 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  18270 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18276 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18282 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  18284 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18287 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18289 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18292 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18297 */   // GIR_Coverage, 1825,
     /*  18297 */   GIR_EraseRootFromParent_Done,
     /*  18298 */ // Label 392: @18298
     /*  18298 */ GIM_Reject,
     /*  18299 */ // Label 343: @18299
     /*  18299 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(18345), // Rule ID 2521 //
     /*  18304 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18307 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  18310 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  18313 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18317 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18321 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  18325 */   // (and:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VANDd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
     /*  18325 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
     /*  18328 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  18330 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  18332 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  18334 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18337 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18343 */   GIR_RootConstrainSelectedInstOperands,
     /*  18344 */   // GIR_Coverage, 2521,
     /*  18344 */   GIR_EraseRootFromParent_Done,
     /*  18345 */ // Label 393: @18345
     /*  18345 */ GIM_Reject,
     /*  18346 */ // Label 344: @18346
     /*  18346 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(18459),
     /*  18351 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  18354 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  18357 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(18397), // Rule ID 2525 //
     /*  18362 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18365 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18369 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18373 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18377 */     // (and:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VANDq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
     /*  18377 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
     /*  18380 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  18382 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  18384 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  18386 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18389 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18395 */     GIR_RootConstrainSelectedInstOperands,
     /*  18396 */     // GIR_Coverage, 2525,
     /*  18396 */     GIR_EraseRootFromParent_Done,
     /*  18397 */   // Label 395: @18397
     /*  18397 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(18458), // Rule ID 3359 //
     /*  18402 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  18405 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18409 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18413 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18417 */     // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  18417 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  18420 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  18424 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
     /*  18432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  18434 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  18436 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  18438 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18441 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18447 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18453 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18456 */     GIR_RootConstrainSelectedInstOperands,
     /*  18457 */     // GIR_Coverage, 3359,
     /*  18457 */     GIR_EraseRootFromParent_Done,
     /*  18458 */   // Label 396: @18458
     /*  18458 */   GIM_Reject,
     /*  18459 */ // Label 394: @18459
     /*  18459 */ GIM_Reject,
     /*  18460 */ // Label 345: @18460
     /*  18460 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(18577), // Rule ID 1826 //
     /*  18465 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  18468 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  18471 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  18474 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18478 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18482 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18486 */   // (and:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  18486 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  18489 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18493 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18498 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  18502 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18507 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  18510 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18514 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18519 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  18523 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18528 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  18531 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
     /*  18535 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18540 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  18543 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  18546 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  18549 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18555 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18561 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  18563 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  18566 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18568 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18571 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  18576 */   // GIR_Coverage, 1826,
     /*  18576 */   GIR_EraseRootFromParent_Done,
     /*  18577 */ // Label 397: @18577
     /*  18577 */ GIM_Reject,
     /*  18578 */ // Label 346: @18578
     /*  18578 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(18691),
     /*  18583 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  18586 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  18589 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(18629), // Rule ID 2524 //
     /*  18594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  18597 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18601 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18605 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  18609 */     // (and:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VANDq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
     /*  18609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
     /*  18612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  18614 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  18616 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  18618 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18621 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18627 */     GIR_RootConstrainSelectedInstOperands,
     /*  18628 */     // GIR_Coverage, 2524,
     /*  18628 */     GIR_EraseRootFromParent_Done,
     /*  18629 */   // Label 399: @18629
     /*  18629 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(18690), // Rule ID 3355 //
     /*  18634 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  18637 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18641 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18645 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  18649 */     // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  18649 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  18652 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  18656 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  18661 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
     /*  18664 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  18666 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  18668 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  18670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18673 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18679 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18685 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  18688 */     GIR_RootConstrainSelectedInstOperands,
     /*  18689 */     // GIR_Coverage, 3355,
     /*  18689 */     GIR_EraseRootFromParent_Done,
     /*  18690 */   // Label 400: @18690
     /*  18690 */   GIM_Reject,
     /*  18691 */ // Label 398: @18691
     /*  18691 */ GIM_Reject,
     /*  18692 */ // Label 347: @18692
     /*  18692 */ GIM_Reject,
     /*  18693 */ // Label 6: @18693
     /*  18693 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 414*/ GIMT_Encode4(24501),
     /*  18704 */ /*GILLT_s32*//*Label 401*/ GIMT_Encode4(18764),
     /*  18708 */ /*GILLT_s64*//*Label 402*/ GIMT_Encode4(23385),
     /*  18712 */ /*GILLT_v2s1*//*Label 403*/ GIMT_Encode4(23432),
     /*  18716 */ /*GILLT_v2s32*//*Label 404*/ GIMT_Encode4(23550),
     /*  18720 */ /*GILLT_v2s64*//*Label 405*/ GIMT_Encode4(23597),
     /*  18724 */ /*GILLT_v4s1*//*Label 406*/ GIMT_Encode4(23711),
     /*  18728 */ /*GILLT_v4s16*//*Label 407*/ GIMT_Encode4(23829),
     /*  18732 */ /*GILLT_v4s32*//*Label 408*/ GIMT_Encode4(23876), GIMT_Encode4(0),
     /*  18740 */ /*GILLT_v8s1*//*Label 409*/ GIMT_Encode4(23990),
     /*  18744 */ /*GILLT_v8s8*//*Label 410*/ GIMT_Encode4(24108),
     /*  18748 */ /*GILLT_v8s16*//*Label 411*/ GIMT_Encode4(24155), GIMT_Encode4(0),
     /*  18756 */ /*GILLT_v16s1*//*Label 412*/ GIMT_Encode4(24269),
     /*  18760 */ /*GILLT_v16s8*//*Label 413*/ GIMT_Encode4(24387),
     /*  18764 */ // Label 401: @18764
     /*  18764 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(23384),
     /*  18769 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  18772 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  18775 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(18902), // Rule ID 5652 //
     /*  18780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  18783 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  18787 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18791 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18795 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  18799 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18803 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18807 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18811 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18815 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18819 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  18824 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
     /*  18828 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  18839 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18843 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  18847 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18851 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18855 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18859 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  18863 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18867 */     // MIs[4] Rm
     /*  18867 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18872 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
     /*  18876 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  18880 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  18882 */     // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
     /*  18882 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
     /*  18885 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  18887 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  18891 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  18894 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  18900 */     GIR_RootConstrainSelectedInstOperands,
     /*  18901 */     // GIR_Coverage, 5652,
     /*  18901 */     GIR_EraseRootFromParent_Done,
     /*  18902 */   // Label 416: @18902
     /*  18902 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(19029), // Rule ID 5694 //
     /*  18907 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  18910 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18914 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18918 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18922 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  18926 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18930 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  18934 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18938 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18942 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18946 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  18951 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
     /*  18955 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  18966 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18970 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  18974 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18978 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18982 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18986 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  18990 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18994 */     // MIs[4] Rm
     /*  18994 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18999 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
     /*  19003 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  19007 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19009 */     // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
     /*  19009 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
     /*  19012 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19014 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19018 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19021 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19027 */     GIR_RootConstrainSelectedInstOperands,
     /*  19028 */     // GIR_Coverage, 5694,
     /*  19028 */     GIR_EraseRootFromParent_Done,
     /*  19029 */   // Label 417: @19029
     /*  19029 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(19156), // Rule ID 1911 //
     /*  19034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  19037 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  19041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  19049 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19053 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19057 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19061 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  19065 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19069 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19073 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  19078 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19082 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  19086 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19090 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19094 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19098 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19102 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19106 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19110 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19114 */     // MIs[4] Rm
     /*  19114 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19119 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  19123 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  19134 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19136 */     // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
     /*  19136 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
     /*  19139 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19145 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19148 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19154 */     GIR_RootConstrainSelectedInstOperands,
     /*  19155 */     // GIR_Coverage, 1911,
     /*  19155 */     GIR_EraseRootFromParent_Done,
     /*  19156 */   // Label 418: @19156
     /*  19156 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(19283), // Rule ID 2193 //
     /*  19161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  19164 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  19176 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19180 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19184 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19188 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  19192 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19196 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19200 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19205 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19209 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
     /*  19213 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19217 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19221 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19225 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19229 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19233 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19237 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19241 */     // MIs[4] Rm
     /*  19241 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19246 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  19250 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  19261 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19263 */     // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
     /*  19263 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
     /*  19266 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19268 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19272 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19275 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19281 */     GIR_RootConstrainSelectedInstOperands,
     /*  19282 */     // GIR_Coverage, 2193,
     /*  19282 */     GIR_EraseRootFromParent_Done,
     /*  19283 */   // Label 419: @19283
     /*  19283 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(19416), // Rule ID 5450 //
     /*  19288 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  19291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19311 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19315 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  19319 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19323 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19327 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19332 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19336 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19340 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
     /*  19344 */     // MIs[3] Operand 1
     /*  19344 */     // No operand predicates
     /*  19344 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  19355 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19359 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19363 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19367 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19371 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19376 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
     /*  19387 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19389 */     // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  19389 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  19392 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19394 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
     /*  19398 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19402 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  19405 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19408 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19414 */     GIR_RootConstrainSelectedInstOperands,
     /*  19415 */     // GIR_Coverage, 5450,
     /*  19415 */     GIR_EraseRootFromParent_Done,
     /*  19416 */   // Label 420: @19416
     /*  19416 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(19549), // Rule ID 5487 //
     /*  19421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  19424 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19428 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19432 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19436 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19440 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19444 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19448 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  19452 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19456 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19460 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19465 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19469 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19473 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
     /*  19477 */     // MIs[3] Operand 1
     /*  19477 */     // No operand predicates
     /*  19477 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  19488 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19492 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19496 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19500 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19504 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19509 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
     /*  19520 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19522 */     // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  19522 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  19525 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19527 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
     /*  19531 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19535 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  19538 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19541 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19547 */     GIR_RootConstrainSelectedInstOperands,
     /*  19548 */     // GIR_Coverage, 5487,
     /*  19548 */     GIR_EraseRootFromParent_Done,
     /*  19549 */   // Label 421: @19549
     /*  19549 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(19682), // Rule ID 5657 //
     /*  19554 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  19557 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19561 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19565 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19569 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19573 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19577 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19581 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19585 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19589 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19593 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19598 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19602 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19606 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
     /*  19610 */     // MIs[3] Operand 1
     /*  19610 */     // No operand predicates
     /*  19610 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  19621 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19625 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19629 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19633 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19637 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19642 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
     /*  19653 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19655 */     // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
     /*  19655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  19658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  19664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  19668 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  19671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19674 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19680 */     GIR_RootConstrainSelectedInstOperands,
     /*  19681 */     // GIR_Coverage, 5657,
     /*  19681 */     GIR_EraseRootFromParent_Done,
     /*  19682 */   // Label 422: @19682
     /*  19682 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(19815), // Rule ID 5699 //
     /*  19687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  19690 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19702 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19706 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19710 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19714 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19718 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19722 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19726 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19731 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19735 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19739 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
     /*  19743 */     // MIs[3] Operand 1
     /*  19743 */     // No operand predicates
     /*  19743 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  19754 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19758 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19762 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19766 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19770 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19775 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
     /*  19786 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19788 */     // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
     /*  19788 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  19791 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19793 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  19797 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  19801 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  19804 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19807 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19813 */     GIR_RootConstrainSelectedInstOperands,
     /*  19814 */     // GIR_Coverage, 5699,
     /*  19814 */     GIR_EraseRootFromParent_Done,
     /*  19815 */   // Label 423: @19815
     /*  19815 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(19948), // Rule ID 5449 //
     /*  19820 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  19823 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19827 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19831 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19835 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19839 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19843 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19847 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  19851 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19855 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19859 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19864 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  19868 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19872 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
     /*  19876 */     // MIs[3] Operand 1
     /*  19876 */     // No operand predicates
     /*  19876 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  19887 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19891 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19895 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19899 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19903 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  19908 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
     /*  19919 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  19921 */     // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  19921 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  19924 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  19926 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
     /*  19930 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  19934 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  19937 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  19940 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  19946 */     GIR_RootConstrainSelectedInstOperands,
     /*  19947 */     // GIR_Coverage, 5449,
     /*  19947 */     GIR_EraseRootFromParent_Done,
     /*  19948 */   // Label 424: @19948
     /*  19948 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(20081), // Rule ID 5486 //
     /*  19953 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  19956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19960 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19964 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19968 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  19972 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19976 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  19980 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  19984 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19988 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19992 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  19997 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  20001 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20005 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
     /*  20009 */     // MIs[3] Operand 1
     /*  20009 */     // No operand predicates
     /*  20009 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20020 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  20024 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20028 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20032 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20036 */     GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20041 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
     /*  20052 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20054 */     // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  20054 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  20057 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20059 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
     /*  20063 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20067 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  20070 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20073 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20079 */     GIR_RootConstrainSelectedInstOperands,
     /*  20080 */     // GIR_Coverage, 5486,
     /*  20080 */     GIR_EraseRootFromParent_Done,
     /*  20081 */   // Label 425: @20081
     /*  20081 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(20214), // Rule ID 203 //
     /*  20086 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  20089 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20093 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20097 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20101 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20105 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20109 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20114 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20125 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20129 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20133 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20137 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20141 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20145 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  20149 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20153 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20157 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20162 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20166 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20170 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
     /*  20174 */     // MIs[4] Operand 1
     /*  20174 */     // No operand predicates
     /*  20174 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  20185 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20187 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  20187 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  20190 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20192 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20196 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  20200 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20203 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20206 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20212 */     GIR_RootConstrainSelectedInstOperands,
     /*  20213 */     // GIR_Coverage, 203,
     /*  20213 */     GIR_EraseRootFromParent_Done,
     /*  20214 */   // Label 426: @20214
     /*  20214 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(20347), // Rule ID 540 //
     /*  20219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  20222 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20234 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20238 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20242 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20247 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20258 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20262 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20266 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20270 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20274 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20278 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  20282 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20286 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20290 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20295 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20299 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20303 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
     /*  20307 */     // MIs[4] Operand 1
     /*  20307 */     // No operand predicates
     /*  20307 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  20318 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20320 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  20320 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  20323 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20325 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  20333 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20336 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20339 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20345 */     GIR_RootConstrainSelectedInstOperands,
     /*  20346 */     // GIR_Coverage, 540,
     /*  20346 */     GIR_EraseRootFromParent_Done,
     /*  20347 */   // Label 427: @20347
     /*  20347 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(20480), // Rule ID 1916 //
     /*  20352 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  20355 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20359 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20363 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20367 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20371 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20375 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20380 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20391 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20395 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20399 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20403 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20407 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20411 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20415 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20419 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20423 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20428 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20432 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20436 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
     /*  20440 */     // MIs[4] Operand 1
     /*  20440 */     // No operand predicates
     /*  20440 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  20451 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20453 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
     /*  20453 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  20456 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20458 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20462 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  20466 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20469 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20472 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20478 */     GIR_RootConstrainSelectedInstOperands,
     /*  20479 */     // GIR_Coverage, 1916,
     /*  20479 */     GIR_EraseRootFromParent_Done,
     /*  20480 */   // Label 428: @20480
     /*  20480 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(20613), // Rule ID 2198 //
     /*  20485 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  20488 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20492 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20496 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20500 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20504 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20508 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20513 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20524 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20528 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20532 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20536 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20540 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20544 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20548 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20552 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20556 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20561 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20565 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20569 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
     /*  20573 */     // MIs[4] Operand 1
     /*  20573 */     // No operand predicates
     /*  20573 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  20584 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20586 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
     /*  20586 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  20589 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20591 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20595 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  20599 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20602 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20605 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20611 */     GIR_RootConstrainSelectedInstOperands,
     /*  20612 */     // GIR_Coverage, 2198,
     /*  20612 */     GIR_EraseRootFromParent_Done,
     /*  20613 */   // Label 429: @20613
     /*  20613 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(20746), // Rule ID 202 //
     /*  20618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  20621 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20625 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20629 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20633 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20637 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20641 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20646 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  20657 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20661 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20665 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20669 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20673 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20677 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  20681 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20685 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20689 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20694 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20698 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20702 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
     /*  20706 */     // MIs[4] Operand 1
     /*  20706 */     // No operand predicates
     /*  20706 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20717 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20719 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  20719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  20722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20724 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  20732 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20735 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20738 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20744 */     GIR_RootConstrainSelectedInstOperands,
     /*  20745 */     // GIR_Coverage, 202,
     /*  20745 */     GIR_EraseRootFromParent_Done,
     /*  20746 */   // Label 430: @20746
     /*  20746 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(20879), // Rule ID 539 //
     /*  20751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  20754 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20766 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20770 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20774 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20779 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  20790 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20794 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20798 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20802 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20806 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  20810 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  20814 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20818 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20822 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20827 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  20831 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  20835 */     GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
     /*  20839 */     // MIs[4] Operand 1
     /*  20839 */     // No operand predicates
     /*  20839 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20850 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  20852 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
     /*  20852 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  20855 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20857 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20861 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
     /*  20865 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
     /*  20868 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20871 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20877 */     GIR_RootConstrainSelectedInstOperands,
     /*  20878 */     // GIR_Coverage, 539,
     /*  20878 */     GIR_EraseRootFromParent_Done,
     /*  20879 */   // Label 431: @20879
     /*  20879 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(20984), // Rule ID 1912 //
     /*  20884 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  20887 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20891 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20895 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20899 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20903 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20907 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20912 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  20923 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  20927 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20931 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  20935 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20939 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  20944 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
     /*  20955 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20957 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*  20957 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  20960 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  20962 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  20966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  20970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20973 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  20976 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  20982 */     GIR_RootConstrainSelectedInstOperands,
     /*  20983 */     // GIR_Coverage, 1912,
     /*  20983 */     GIR_EraseRootFromParent_Done,
     /*  20984 */   // Label 432: @20984
     /*  20984 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(21089), // Rule ID 2194 //
     /*  20989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  20992 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  20996 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21000 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21004 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21008 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21012 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21017 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  21028 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21032 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21036 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21040 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21044 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21049 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21060 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21062 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  21062 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  21065 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21067 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21071 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21075 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21078 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21081 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21087 */     GIR_RootConstrainSelectedInstOperands,
     /*  21088 */     // GIR_Coverage, 2194,
     /*  21088 */     GIR_EraseRootFromParent_Done,
     /*  21089 */   // Label 433: @21089
     /*  21089 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(21194), // Rule ID 5653 //
     /*  21094 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  21097 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21101 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21105 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21109 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21113 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21117 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21122 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21133 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21137 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21141 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21145 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21149 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21154 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  21165 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21167 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
     /*  21167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  21170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21172 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
     /*  21176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  21180 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21183 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21186 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21192 */     GIR_RootConstrainSelectedInstOperands,
     /*  21193 */     // GIR_Coverage, 5653,
     /*  21193 */     GIR_EraseRootFromParent_Done,
     /*  21194 */   // Label 434: @21194
     /*  21194 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(21299), // Rule ID 5695 //
     /*  21199 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  21202 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21218 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21222 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21227 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21238 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21242 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21246 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21250 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21254 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21259 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  21270 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21272 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  21272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  21275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21277 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  21281 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  21285 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21288 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21291 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21297 */     GIR_RootConstrainSelectedInstOperands,
     /*  21298 */     // GIR_Coverage, 5695,
     /*  21298 */     GIR_EraseRootFromParent_Done,
     /*  21299 */   // Label 435: @21299
     /*  21299 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(21405), // Rule ID 1915 //
     /*  21304 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  21307 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21311 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21315 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21319 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21323 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21327 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21332 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21343 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21347 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  21351 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21355 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21359 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21364 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21368 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21372 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  21376 */     // MIs[3] Operand 1
     /*  21376 */     // No operand predicates
     /*  21376 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21378 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  21378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  21381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21383 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21387 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21391 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21394 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21397 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21403 */     GIR_RootConstrainSelectedInstOperands,
     /*  21404 */     // GIR_Coverage, 1915,
     /*  21404 */     GIR_EraseRootFromParent_Done,
     /*  21405 */   // Label 436: @21405
     /*  21405 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(21511), // Rule ID 2197 //
     /*  21410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  21413 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21417 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21421 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21425 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21429 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21433 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21438 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21449 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21453 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  21457 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21461 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21465 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21470 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21474 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21478 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  21482 */     // MIs[3] Operand 1
     /*  21482 */     // No operand predicates
     /*  21482 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21484 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  21484 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  21487 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21489 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21493 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21497 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21500 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21503 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21509 */     GIR_RootConstrainSelectedInstOperands,
     /*  21510 */     // GIR_Coverage, 2197,
     /*  21510 */     GIR_EraseRootFromParent_Done,
     /*  21511 */   // Label 437: @21511
     /*  21511 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(21617), // Rule ID 1914 //
     /*  21516 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  21519 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21523 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21527 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21531 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21535 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21539 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21544 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21555 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21559 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21563 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21567 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21571 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21576 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21580 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21584 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
     /*  21588 */     // MIs[3] Operand 1
     /*  21588 */     // No operand predicates
     /*  21588 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21590 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
     /*  21590 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  21593 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21595 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21599 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21603 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21606 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21609 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21615 */     GIR_RootConstrainSelectedInstOperands,
     /*  21616 */     // GIR_Coverage, 1914,
     /*  21616 */     GIR_EraseRootFromParent_Done,
     /*  21617 */   // Label 438: @21617
     /*  21617 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(21723), // Rule ID 2196 //
     /*  21622 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  21625 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21629 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21633 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21637 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21641 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21645 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21650 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
     /*  21661 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21665 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21669 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21673 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21677 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21682 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21686 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21690 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
     /*  21694 */     // MIs[3] Operand 1
     /*  21694 */     // No operand predicates
     /*  21694 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21696 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
     /*  21696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  21699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21701 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21705 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21709 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21712 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21715 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21721 */     GIR_RootConstrainSelectedInstOperands,
     /*  21722 */     // GIR_Coverage, 2196,
     /*  21722 */     GIR_EraseRootFromParent_Done,
     /*  21723 */   // Label 439: @21723
     /*  21723 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(21829), // Rule ID 1913 //
     /*  21728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  21731 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21735 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21739 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21743 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21747 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21751 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21756 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  21767 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21771 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  21775 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21779 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21783 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21788 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21792 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21796 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  21800 */     // MIs[3] Operand 1
     /*  21800 */     // No operand predicates
     /*  21800 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21802 */     // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  21802 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  21805 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21807 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
     /*  21811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
     /*  21815 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21818 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21821 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21827 */     GIR_RootConstrainSelectedInstOperands,
     /*  21828 */     // GIR_Coverage, 1913,
     /*  21828 */     GIR_EraseRootFromParent_Done,
     /*  21829 */   // Label 440: @21829
     /*  21829 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(21935), // Rule ID 2195 //
     /*  21834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  21837 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21841 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21845 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21849 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21853 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21857 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21862 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
     /*  21873 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  21877 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  21881 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  21885 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21889 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  21894 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21898 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21902 */     GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  21906 */     // MIs[3] Operand 1
     /*  21906 */     // No operand predicates
     /*  21906 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  21908 */     // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  21908 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  21911 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  21913 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21917 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
     /*  21921 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
     /*  21924 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  21927 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  21933 */     GIR_RootConstrainSelectedInstOperands,
     /*  21934 */     // GIR_Coverage, 2195,
     /*  21934 */     GIR_EraseRootFromParent_Done,
     /*  21935 */   // Label 441: @21935
     /*  21935 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(22041), // Rule ID 5656 //
     /*  21940 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  21943 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21947 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21951 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  21955 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21959 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21963 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  21968 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21972 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  21976 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  21980 */     // MIs[2] Operand 1
     /*  21980 */     // No operand predicates
     /*  21980 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21984 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21988 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21992 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21996 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22001 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
     /*  22012 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22014 */     // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  22014 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  22017 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22019 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  22023 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  22027 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22030 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22033 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22039 */     GIR_RootConstrainSelectedInstOperands,
     /*  22040 */     // GIR_Coverage, 5656,
     /*  22040 */     GIR_EraseRootFromParent_Done,
     /*  22041 */   // Label 442: @22041
     /*  22041 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(22147), // Rule ID 5698 //
     /*  22046 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  22049 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22053 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22057 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  22061 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22065 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22069 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22074 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22078 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22082 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  22086 */     // MIs[2] Operand 1
     /*  22086 */     // No operand predicates
     /*  22086 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22090 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22094 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22098 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22102 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22107 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
     /*  22118 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22120 */     // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  22120 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  22123 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22125 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  22129 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  22133 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22136 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22139 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22145 */     GIR_RootConstrainSelectedInstOperands,
     /*  22146 */     // GIR_Coverage, 5698,
     /*  22146 */     GIR_EraseRootFromParent_Done,
     /*  22147 */   // Label 443: @22147
     /*  22147 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(22253), // Rule ID 5655 //
     /*  22152 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  22155 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22159 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22163 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22167 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22171 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22175 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22180 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22184 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22188 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
     /*  22192 */     // MIs[2] Operand 1
     /*  22192 */     // No operand predicates
     /*  22192 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22196 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22200 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22204 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22208 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22213 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
     /*  22224 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22226 */     // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
     /*  22226 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
     /*  22229 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22231 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  22235 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  22239 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22242 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22245 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22251 */     GIR_RootConstrainSelectedInstOperands,
     /*  22252 */     // GIR_Coverage, 5655,
     /*  22252 */     GIR_EraseRootFromParent_Done,
     /*  22253 */   // Label 444: @22253
     /*  22253 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(22359), // Rule ID 5697 //
     /*  22258 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  22261 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22265 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22269 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22273 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22277 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22281 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22286 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22290 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22294 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
     /*  22298 */     // MIs[2] Operand 1
     /*  22298 */     // No operand predicates
     /*  22298 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22302 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22306 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22310 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22314 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22319 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
     /*  22330 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22332 */     // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
     /*  22332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
     /*  22335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22337 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  22341 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  22345 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22351 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22357 */     GIR_RootConstrainSelectedInstOperands,
     /*  22358 */     // GIR_Coverage, 5697,
     /*  22358 */     GIR_EraseRootFromParent_Done,
     /*  22359 */   // Label 445: @22359
     /*  22359 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(22465), // Rule ID 5654 //
     /*  22364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
     /*  22367 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22371 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22375 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  22379 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22383 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22387 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22392 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22396 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22400 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  22404 */     // MIs[2] Operand 1
     /*  22404 */     // No operand predicates
     /*  22404 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22408 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22412 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22416 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22420 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  22425 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  22436 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22438 */     // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  22438 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
     /*  22441 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22443 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
     /*  22447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  22451 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22454 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22457 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22463 */     GIR_RootConstrainSelectedInstOperands,
     /*  22464 */     // GIR_Coverage, 5654,
     /*  22464 */     GIR_EraseRootFromParent_Done,
     /*  22465 */   // Label 446: @22465
     /*  22465 */   GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(22571), // Rule ID 5696 //
     /*  22470 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
     /*  22473 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22477 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22481 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  22485 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22489 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22493 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22498 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22502 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22506 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
     /*  22510 */     // MIs[2] Operand 1
     /*  22510 */     // No operand predicates
     /*  22510 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22514 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22518 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  22522 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22526 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22531 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  22542 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  22544 */     // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
     /*  22544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
     /*  22547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22549 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  22553 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  22557 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
     /*  22560 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22563 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22569 */     GIR_RootConstrainSelectedInstOperands,
     /*  22570 */     // GIR_Coverage, 5696,
     /*  22570 */     GIR_EraseRootFromParent_Done,
     /*  22571 */   // Label 447: @22571
     /*  22571 */   GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(22648), // Rule ID 5474 //
     /*  22576 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22579 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22583 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22587 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22591 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22595 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22599 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  22603 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22607 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22611 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  22615 */     // MIs[2] Operand 1
     /*  22615 */     // No operand predicates
     /*  22615 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22619 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22621 */     // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  22621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
     /*  22624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22626 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  22628 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  22631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22634 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22640 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22646 */     GIR_RootConstrainSelectedInstOperands,
     /*  22647 */     // GIR_Coverage, 5474,
     /*  22647 */     GIR_EraseRootFromParent_Done,
     /*  22648 */   // Label 448: @22648
     /*  22648 */   GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(22725), // Rule ID 5473 //
     /*  22653 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22672 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22676 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22680 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22684 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  22688 */     // MIs[2] Operand 1
     /*  22688 */     // No operand predicates
     /*  22688 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  22692 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22696 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22698 */     // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  22698 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
     /*  22701 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22703 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  22705 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  22708 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22711 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22717 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22723 */     GIR_RootConstrainSelectedInstOperands,
     /*  22724 */     // GIR_Coverage, 5473,
     /*  22724 */     GIR_EraseRootFromParent_Done,
     /*  22725 */   // Label 449: @22725
     /*  22725 */   GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(22802), // Rule ID 5472 //
     /*  22730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22733 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22737 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22741 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22745 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22749 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22753 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22757 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
     /*  22761 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22765 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22769 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  22773 */     // MIs[2] Operand 1
     /*  22773 */     // No operand predicates
     /*  22773 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22775 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  22775 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
     /*  22778 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22780 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  22782 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  22785 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22788 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22794 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22800 */     GIR_RootConstrainSelectedInstOperands,
     /*  22801 */     // GIR_Coverage, 5472,
     /*  22801 */     GIR_EraseRootFromParent_Done,
     /*  22802 */   // Label 450: @22802
     /*  22802 */   GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(22879), // Rule ID 496 //
     /*  22807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22810 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22814 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22818 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22822 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22826 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22830 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22834 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22838 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  22842 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  22846 */     // MIs[2] Operand 1
     /*  22846 */     // No operand predicates
     /*  22846 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  22850 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  22852 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  22852 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
     /*  22855 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22857 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  22859 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*  22862 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22865 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22871 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22877 */     GIR_RootConstrainSelectedInstOperands,
     /*  22878 */     // GIR_Coverage, 496,
     /*  22878 */     GIR_EraseRootFromParent_Done,
     /*  22879 */   // Label 451: @22879
     /*  22879 */   GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(22950), // Rule ID 5475 //
     /*  22884 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22887 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22891 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22895 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22899 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22903 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22907 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22912 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  22916 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22920 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22922 */     // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  22922 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
     /*  22925 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22927 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rn
     /*  22929 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  22933 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  22936 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22942 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  22948 */     GIR_RootConstrainSelectedInstOperands,
     /*  22949 */     // GIR_Coverage, 5475,
     /*  22949 */     GIR_EraseRootFromParent_Done,
     /*  22950 */   // Label 452: @22950
     /*  22950 */   GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(23021), // Rule ID 497 //
     /*  22955 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  22958 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22962 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22966 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22970 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22974 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22978 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22982 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  22987 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*  22991 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22993 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  22993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
     /*  22996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  22998 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23000 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
     /*  23004 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23007 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23013 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23019 */     GIR_RootConstrainSelectedInstOperands,
     /*  23020 */     // GIR_Coverage, 497,
     /*  23020 */     GIR_EraseRootFromParent_Done,
     /*  23021 */   // Label 453: @23021
     /*  23021 */   GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(23076), // Rule ID 1845 //
     /*  23026 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
     /*  23029 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
     /*  23033 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23037 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
     /*  23048 */     // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
     /*  23048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MOVTi16),
     /*  23051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23053 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  23055 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
     /*  23065 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23068 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23074 */     GIR_RootConstrainSelectedInstOperands,
     /*  23075 */     // GIR_Coverage, 1845,
     /*  23075 */     GIR_EraseRootFromParent_Done,
     /*  23076 */   // Label 454: @23076
     /*  23076 */   GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(23131), // Rule ID 2091 //
     /*  23081 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  23084 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23088 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23092 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
     /*  23103 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
     /*  23103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MOVTi16),
     /*  23106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23108 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  23110 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
     /*  23120 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23123 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23129 */     GIR_RootConstrainSelectedInstOperands,
     /*  23130 */     // GIR_Coverage, 2091,
     /*  23130 */     GIR_EraseRootFromParent_Done,
     /*  23131 */   // Label 455: @23131
     /*  23131 */   GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(23188), // Rule ID 151 //
     /*  23136 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  23139 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23143 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23147 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23151 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  23155 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  23159 */     // MIs[1] Operand 1
     /*  23159 */     // No operand predicates
     /*  23159 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23161 */     // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  23161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRri),
     /*  23164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23166 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23168 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  23171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23174 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23180 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23186 */     GIR_RootConstrainSelectedInstOperands,
     /*  23187 */     // GIR_Coverage, 151,
     /*  23187 */     GIR_EraseRootFromParent_Done,
     /*  23188 */   // Label 456: @23188
     /*  23188 */   GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(23245), // Rule ID 484 //
     /*  23193 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  23196 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23200 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23204 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23208 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  23212 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  23216 */     // MIs[1] Operand 1
     /*  23216 */     // No operand predicates
     /*  23216 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23218 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  23218 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRri),
     /*  23221 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23223 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23225 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  23228 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23231 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23237 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23243 */     GIR_RootConstrainSelectedInstOperands,
     /*  23244 */     // GIR_Coverage, 484,
     /*  23244 */     GIR_EraseRootFromParent_Done,
     /*  23245 */   // Label 457: @23245
     /*  23245 */   GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(23291), // Rule ID 152 //
     /*  23250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  23253 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23257 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23261 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  23265 */     // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  23265 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRrr),
     /*  23268 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23270 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23272 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  23274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23277 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23283 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23289 */     GIR_RootConstrainSelectedInstOperands,
     /*  23290 */     // GIR_Coverage, 152,
     /*  23290 */     GIR_EraseRootFromParent_Done,
     /*  23291 */   // Label 458: @23291
     /*  23291 */   GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(23337), // Rule ID 325 //
     /*  23296 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  23299 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  23303 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  23307 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  23311 */     // (or:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tORR:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  23311 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tORR),
     /*  23314 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  23316 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  23322 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23324 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  23326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23329 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23335 */     GIR_RootConstrainSelectedInstOperands,
     /*  23336 */     // GIR_Coverage, 325,
     /*  23336 */     GIR_EraseRootFromParent_Done,
     /*  23337 */   // Label 459: @23337
     /*  23337 */   GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(23383), // Rule ID 485 //
     /*  23342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  23345 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23349 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23353 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23357 */     // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  23357 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
     /*  23360 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  23362 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  23364 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  23366 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23369 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23375 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23381 */     GIR_RootConstrainSelectedInstOperands,
     /*  23382 */     // GIR_Coverage, 485,
     /*  23382 */     GIR_EraseRootFromParent_Done,
     /*  23383 */   // Label 460: @23383
     /*  23383 */   GIM_Reject,
     /*  23384 */ // Label 415: @23384
     /*  23384 */ GIM_Reject,
     /*  23385 */ // Label 402: @23385
     /*  23385 */ GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(23431), // Rule ID 2529 //
     /*  23390 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  23393 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  23396 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  23399 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23403 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23407 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23411 */   // (or:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VORRd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
     /*  23411 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
     /*  23414 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  23416 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  23418 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  23420 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23423 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23429 */   GIR_RootConstrainSelectedInstOperands,
     /*  23430 */   // GIR_Coverage, 2529,
     /*  23430 */   GIR_EraseRootFromParent_Done,
     /*  23431 */ // Label 461: @23431
     /*  23431 */ GIM_Reject,
     /*  23432 */ // Label 403: @23432
     /*  23432 */ GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(23549), // Rule ID 1831 //
     /*  23437 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  23440 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  23443 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  23446 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23450 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23454 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23458 */   // (or:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  23458 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  23461 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23465 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23470 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  23474 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23479 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  23482 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23486 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23491 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  23495 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23500 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  23503 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
     /*  23507 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23512 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23515 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  23518 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  23521 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23527 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23533 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23535 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23538 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23540 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  23543 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23548 */   // GIR_Coverage, 1831,
     /*  23548 */   GIR_EraseRootFromParent_Done,
     /*  23549 */ // Label 462: @23549
     /*  23549 */ GIM_Reject,
     /*  23550 */ // Label 404: @23550
     /*  23550 */ GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(23596), // Rule ID 1134 //
     /*  23555 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  23558 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  23561 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  23564 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23568 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23572 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23576 */   // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  23576 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
     /*  23579 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  23581 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  23583 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  23585 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23588 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23594 */   GIR_RootConstrainSelectedInstOperands,
     /*  23595 */   // GIR_Coverage, 1134,
     /*  23595 */   GIR_EraseRootFromParent_Done,
     /*  23596 */ // Label 463: @23596
     /*  23596 */ GIM_Reject,
     /*  23597 */ // Label 405: @23597
     /*  23597 */ GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(23710),
     /*  23602 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  23605 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  23608 */   GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(23648), // Rule ID 2532 //
     /*  23613 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  23616 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23620 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23624 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23628 */     // (or:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VORRq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
     /*  23628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
     /*  23631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  23633 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  23635 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  23637 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23640 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23646 */     GIR_RootConstrainSelectedInstOperands,
     /*  23647 */     // GIR_Coverage, 2532,
     /*  23647 */     GIR_EraseRootFromParent_Done,
     /*  23648 */   // Label 465: @23648
     /*  23648 */   GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(23709), // Rule ID 3381 //
     /*  23653 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  23656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23660 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23668 */     // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
     /*  23668 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  23671 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23675 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23680 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
     /*  23683 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  23685 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  23687 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  23689 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23692 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23698 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23704 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  23707 */     GIR_RootConstrainSelectedInstOperands,
     /*  23708 */     // GIR_Coverage, 3381,
     /*  23708 */     GIR_EraseRootFromParent_Done,
     /*  23709 */   // Label 466: @23709
     /*  23709 */   GIM_Reject,
     /*  23710 */ // Label 464: @23710
     /*  23710 */ GIM_Reject,
     /*  23711 */ // Label 406: @23711
     /*  23711 */ GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(23828), // Rule ID 1832 //
     /*  23716 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  23719 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  23722 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  23725 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23729 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23733 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23737 */   // (or:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  23737 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  23740 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23744 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23749 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  23753 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23758 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  23761 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23765 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23770 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  23774 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  23779 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  23782 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
     /*  23786 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23791 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  23794 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  23797 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  23800 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23806 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23812 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  23814 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  23817 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23819 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  23822 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  23827 */   // GIR_Coverage, 1832,
     /*  23827 */   GIR_EraseRootFromParent_Done,
     /*  23828 */ // Label 467: @23828
     /*  23828 */ GIM_Reject,
     /*  23829 */ // Label 407: @23829
     /*  23829 */ GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(23875), // Rule ID 2528 //
     /*  23834 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  23837 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  23840 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  23843 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23847 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23851 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  23855 */   // (or:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VORRd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
     /*  23855 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
     /*  23858 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  23860 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  23862 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  23864 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23867 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23873 */   GIR_RootConstrainSelectedInstOperands,
     /*  23874 */   // GIR_Coverage, 2528,
     /*  23874 */   GIR_EraseRootFromParent_Done,
     /*  23875 */ // Label 468: @23875
     /*  23875 */ GIM_Reject,
     /*  23876 */ // Label 408: @23876
     /*  23876 */ GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(23989),
     /*  23881 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23884 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23887 */   GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(23927), // Rule ID 1135 //
     /*  23892 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  23895 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23899 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23903 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  23907 */     // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  23907 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
     /*  23910 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  23912 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  23914 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  23916 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  23919 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23925 */     GIR_RootConstrainSelectedInstOperands,
     /*  23926 */     // GIR_Coverage, 1135,
     /*  23926 */     GIR_EraseRootFromParent_Done,
     /*  23927 */   // Label 470: @23927
     /*  23927 */   GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(23988), // Rule ID 3377 //
     /*  23932 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  23935 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23939 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23943 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  23947 */     // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*  23947 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  23950 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  23954 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  23959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
     /*  23962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  23964 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  23966 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  23968 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23971 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23977 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  23983 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  23986 */     GIR_RootConstrainSelectedInstOperands,
     /*  23987 */     // GIR_Coverage, 3377,
     /*  23987 */     GIR_EraseRootFromParent_Done,
     /*  23988 */   // Label 471: @23988
     /*  23988 */   GIM_Reject,
     /*  23989 */ // Label 469: @23989
     /*  23989 */ GIM_Reject,
     /*  23990 */ // Label 409: @23990
     /*  23990 */ GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(24107), // Rule ID 1833 //
     /*  23995 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  23998 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  24001 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  24004 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24008 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24012 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24016 */   // (or:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  24016 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  24019 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24023 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24028 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  24032 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24037 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  24040 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24044 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24049 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  24053 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24058 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  24061 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
     /*  24065 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24070 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  24073 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  24076 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  24079 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24085 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24091 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  24093 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24096 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24098 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  24101 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24106 */   // GIR_Coverage, 1833,
     /*  24106 */   GIR_EraseRootFromParent_Done,
     /*  24107 */ // Label 472: @24107
     /*  24107 */ GIM_Reject,
     /*  24108 */ // Label 410: @24108
     /*  24108 */ GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(24154), // Rule ID 2527 //
     /*  24113 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24116 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  24119 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  24122 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  24126 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  24130 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  24134 */   // (or:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VORRd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
     /*  24134 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
     /*  24137 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  24139 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  24141 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  24143 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24146 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24152 */   GIR_RootConstrainSelectedInstOperands,
     /*  24153 */   // GIR_Coverage, 2527,
     /*  24153 */   GIR_EraseRootFromParent_Done,
     /*  24154 */ // Label 473: @24154
     /*  24154 */ GIM_Reject,
     /*  24155 */ // Label 411: @24155
     /*  24155 */ GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(24268),
     /*  24160 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  24163 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  24166 */   GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(24206), // Rule ID 2531 //
     /*  24171 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24174 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24178 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24182 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24186 */     // (or:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VORRq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
     /*  24186 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
     /*  24189 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  24191 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  24193 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  24195 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24198 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24204 */     GIR_RootConstrainSelectedInstOperands,
     /*  24205 */     // GIR_Coverage, 2531,
     /*  24205 */     GIR_EraseRootFromParent_Done,
     /*  24206 */   // Label 475: @24206
     /*  24206 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(24267), // Rule ID 3373 //
     /*  24211 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  24214 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24218 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24222 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24226 */     // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  24226 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  24229 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  24233 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24238 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
     /*  24241 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  24243 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  24245 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  24247 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24250 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24256 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24262 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  24265 */     GIR_RootConstrainSelectedInstOperands,
     /*  24266 */     // GIR_Coverage, 3373,
     /*  24266 */     GIR_EraseRootFromParent_Done,
     /*  24267 */   // Label 476: @24267
     /*  24267 */   GIM_Reject,
     /*  24268 */ // Label 474: @24268
     /*  24268 */ GIM_Reject,
     /*  24269 */ // Label 412: @24269
     /*  24269 */ GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(24386), // Rule ID 1834 //
     /*  24274 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  24277 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  24280 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  24283 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24287 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24291 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24295 */   // (or:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  24295 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  24298 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24302 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24307 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  24311 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24316 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  24319 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24323 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24328 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  24332 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24337 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  24340 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
     /*  24344 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24349 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  24352 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  24355 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  24358 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24364 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24370 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  24372 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  24375 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24377 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  24380 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  24385 */   // GIR_Coverage, 1834,
     /*  24385 */   GIR_EraseRootFromParent_Done,
     /*  24386 */ // Label 477: @24386
     /*  24386 */ GIM_Reject,
     /*  24387 */ // Label 413: @24387
     /*  24387 */ GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(24500),
     /*  24392 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  24395 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  24398 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(24438), // Rule ID 2530 //
     /*  24403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  24406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24410 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24414 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  24418 */     // (or:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VORRq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
     /*  24418 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
     /*  24421 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  24423 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  24425 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  24427 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24430 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24436 */     GIR_RootConstrainSelectedInstOperands,
     /*  24437 */     // GIR_Coverage, 2530,
     /*  24437 */     GIR_EraseRootFromParent_Done,
     /*  24438 */   // Label 479: @24438
     /*  24438 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(24499), // Rule ID 3369 //
     /*  24443 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  24446 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24450 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24454 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  24458 */     // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  24458 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  24461 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  24465 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  24470 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
     /*  24473 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  24475 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  24477 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  24479 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24482 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24488 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24494 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  24497 */     GIR_RootConstrainSelectedInstOperands,
     /*  24498 */     // GIR_Coverage, 3369,
     /*  24498 */     GIR_EraseRootFromParent_Done,
     /*  24499 */   // Label 480: @24499
     /*  24499 */   GIM_Reject,
     /*  24500 */ // Label 478: @24500
     /*  24500 */ GIM_Reject,
     /*  24501 */ // Label 414: @24501
     /*  24501 */ GIM_Reject,
     /*  24502 */ // Label 7: @24502
     /*  24502 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 494*/ GIMT_Encode4(26196),
     /*  24513 */ /*GILLT_s32*//*Label 481*/ GIMT_Encode4(24573),
     /*  24517 */ /*GILLT_s64*//*Label 482*/ GIMT_Encode4(25080),
     /*  24521 */ /*GILLT_v2s1*//*Label 483*/ GIMT_Encode4(25127),
     /*  24525 */ /*GILLT_v2s32*//*Label 484*/ GIMT_Encode4(25245),
     /*  24529 */ /*GILLT_v2s64*//*Label 485*/ GIMT_Encode4(25292),
     /*  24533 */ /*GILLT_v4s1*//*Label 486*/ GIMT_Encode4(25406),
     /*  24537 */ /*GILLT_v4s16*//*Label 487*/ GIMT_Encode4(25524),
     /*  24541 */ /*GILLT_v4s32*//*Label 488*/ GIMT_Encode4(25571), GIMT_Encode4(0),
     /*  24549 */ /*GILLT_v8s1*//*Label 489*/ GIMT_Encode4(25685),
     /*  24553 */ /*GILLT_v8s8*//*Label 490*/ GIMT_Encode4(25803),
     /*  24557 */ /*GILLT_v8s16*//*Label 491*/ GIMT_Encode4(25850), GIMT_Encode4(0),
     /*  24565 */ /*GILLT_v16s1*//*Label 492*/ GIMT_Encode4(25964),
     /*  24569 */ /*GILLT_v16s8*//*Label 493*/ GIMT_Encode4(26082),
     /*  24573 */ // Label 481: @24573
     /*  24573 */ GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(25079),
     /*  24578 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  24581 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  24584 */   GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(24639), // Rule ID 5477 //
     /*  24589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  24592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24596 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, uint8_t(-1),
     /*  24600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24608 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  24612 */     // MIs[1] Operand 1
     /*  24612 */     // No operand predicates
     /*  24612 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24614 */     // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
     /*  24614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
     /*  24617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24619 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  24622 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24625 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24631 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24637 */     GIR_RootConstrainSelectedInstOperands,
     /*  24638 */     // GIR_Coverage, 5477,
     /*  24638 */     GIR_EraseRootFromParent_Done,
     /*  24639 */   // Label 496: @24639
     /*  24639 */   GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(24694), // Rule ID 499 //
     /*  24644 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  24647 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24651 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24655 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24659 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  24663 */     // MIs[1] Operand 1
     /*  24663 */     // No operand predicates
     /*  24663 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  24667 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24669 */     // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
     /*  24669 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
     /*  24672 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24674 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  24677 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24680 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24686 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24692 */     GIR_RootConstrainSelectedInstOperands,
     /*  24693 */     // GIR_Coverage, 499,
     /*  24693 */     GIR_EraseRootFromParent_Done,
     /*  24694 */   // Label 497: @24694
     /*  24694 */   GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(24738), // Rule ID 500 //
     /*  24699 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  24702 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24706 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24710 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  24714 */     // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
     /*  24714 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNr),
     /*  24717 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24719 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  24721 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24724 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24730 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24736 */     GIR_RootConstrainSelectedInstOperands,
     /*  24737 */     // GIR_Coverage, 500,
     /*  24737 */     GIR_EraseRootFromParent_Done,
     /*  24738 */   // Label 498: @24738
     /*  24738 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(24782), // Rule ID 165 //
     /*  24743 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  24746 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24750 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24754 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  24758 */     // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
     /*  24758 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVNr),
     /*  24761 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24763 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rm
     /*  24765 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24768 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24774 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24780 */     GIR_RootConstrainSelectedInstOperands,
     /*  24781 */     // GIR_Coverage, 165,
     /*  24781 */     GIR_EraseRootFromParent_Done,
     /*  24782 */   // Label 499: @24782
     /*  24782 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(24826), // Rule ID 324 //
     /*  24787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  24790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  24794 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  24798 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
     /*  24802 */     // (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, -1:{ *:[i32] })  =>  (tMVN:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)
     /*  24802 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tMVN),
     /*  24805 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24807 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  24813 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  24815 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24818 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24824 */     GIR_RootConstrainSelectedInstOperands,
     /*  24825 */     // GIR_Coverage, 324,
     /*  24825 */     GIR_EraseRootFromParent_Done,
     /*  24826 */   // Label 500: @24826
     /*  24826 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(24883), // Rule ID 155 //
     /*  24831 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  24834 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24838 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24842 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24846 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24850 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
     /*  24854 */     // MIs[1] Operand 1
     /*  24854 */     // No operand predicates
     /*  24854 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24856 */     // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  24856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORri),
     /*  24859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24861 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  24863 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  24866 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24869 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24875 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24881 */     GIR_RootConstrainSelectedInstOperands,
     /*  24882 */     // GIR_Coverage, 155,
     /*  24882 */     GIR_EraseRootFromParent_Done,
     /*  24883 */   // Label 501: @24883
     /*  24883 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(24940), // Rule ID 487 //
     /*  24888 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  24891 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24895 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  24899 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24903 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  24907 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
     /*  24911 */     // MIs[1] Operand 1
     /*  24911 */     // No operand predicates
     /*  24911 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24913 */     // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
     /*  24913 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORri),
     /*  24916 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24918 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  24920 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*  24923 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24926 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24932 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24938 */     GIR_RootConstrainSelectedInstOperands,
     /*  24939 */     // GIR_Coverage, 487,
     /*  24939 */     GIR_EraseRootFromParent_Done,
     /*  24940 */   // Label 502: @24940
     /*  24940 */   GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(24986), // Rule ID 156 //
     /*  24945 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
     /*  24948 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24952 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24956 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  24960 */     // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
     /*  24960 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORrr),
     /*  24963 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  24965 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  24967 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  24969 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  24972 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24978 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  24984 */     GIR_RootConstrainSelectedInstOperands,
     /*  24985 */     // GIR_Coverage, 156,
     /*  24985 */     GIR_EraseRootFromParent_Done,
     /*  24986 */   // Label 503: @24986
     /*  24986 */   GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(25032), // Rule ID 317 //
     /*  24991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
     /*  24994 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  24998 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  25002 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
     /*  25006 */     // (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tEOR:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
     /*  25006 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tEOR),
     /*  25009 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
     /*  25011 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
     /*  25017 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  25019 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  25021 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25024 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25030 */     GIR_RootConstrainSelectedInstOperands,
     /*  25031 */     // GIR_Coverage, 317,
     /*  25031 */     GIR_EraseRootFromParent_Done,
     /*  25032 */   // Label 504: @25032
     /*  25032 */   GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(25078), // Rule ID 488 //
     /*  25037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
     /*  25040 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25044 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25048 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25052 */     // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
     /*  25052 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
     /*  25055 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
     /*  25057 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rn
     /*  25059 */     GIR_RootToRootCopy, /*OpIdx*/2, // Rm
     /*  25061 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25064 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25070 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25076 */     GIR_RootConstrainSelectedInstOperands,
     /*  25077 */     // GIR_Coverage, 488,
     /*  25077 */     GIR_EraseRootFromParent_Done,
     /*  25078 */   // Label 505: @25078
     /*  25078 */   GIM_Reject,
     /*  25079 */ // Label 495: @25079
     /*  25079 */ GIM_Reject,
     /*  25080 */ // Label 482: @25080
     /*  25080 */ GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(25126), // Rule ID 2535 //
     /*  25085 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25088 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  25091 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  25094 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25098 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25102 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25106 */   // (xor:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VEORd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
     /*  25106 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
     /*  25109 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25111 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  25113 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  25115 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25118 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25124 */   GIR_RootConstrainSelectedInstOperands,
     /*  25125 */   // GIR_Coverage, 2535,
     /*  25125 */   GIR_EraseRootFromParent_Done,
     /*  25126 */ // Label 506: @25126
     /*  25126 */ GIM_Reject,
     /*  25127 */ // Label 483: @25127
     /*  25127 */ GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(25244), // Rule ID 1827 //
     /*  25132 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25135 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  25138 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  25141 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25145 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25149 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25153 */   // (xor:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  25153 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  25156 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25160 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25165 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  25169 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25174 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  25177 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25181 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25186 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  25190 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25195 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  25198 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
     /*  25202 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25207 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  25210 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  25213 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  25216 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25222 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25228 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  25230 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25233 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25235 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25238 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25243 */   // GIR_Coverage, 1827,
     /*  25243 */   GIR_EraseRootFromParent_Done,
     /*  25244 */ // Label 507: @25244
     /*  25244 */ GIM_Reject,
     /*  25245 */ // Label 484: @25245
     /*  25245 */ GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(25291), // Rule ID 1132 //
     /*  25250 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25253 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  25256 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  25259 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25263 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25267 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25271 */   // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
     /*  25271 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
     /*  25274 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25276 */   GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  25278 */   GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  25280 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25283 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25289 */   GIR_RootConstrainSelectedInstOperands,
     /*  25290 */   // GIR_Coverage, 1132,
     /*  25290 */   GIR_EraseRootFromParent_Done,
     /*  25291 */ // Label 508: @25291
     /*  25291 */ GIM_Reject,
     /*  25292 */ // Label 485: @25292
     /*  25292 */ GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(25405),
     /*  25297 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  25300 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  25303 */   GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(25343), // Rule ID 2538 //
     /*  25308 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25311 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25315 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25319 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25323 */     // (xor:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VEORq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
     /*  25323 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
     /*  25326 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25328 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  25330 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  25332 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25335 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25341 */     GIR_RootConstrainSelectedInstOperands,
     /*  25342 */     // GIR_Coverage, 2538,
     /*  25342 */     GIR_EraseRootFromParent_Done,
     /*  25343 */   // Label 510: @25343
     /*  25343 */   GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(25404), // Rule ID 3395 //
     /*  25348 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25351 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25355 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25359 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25363 */     // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
     /*  25363 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  25366 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  25370 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25375 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
     /*  25378 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  25380 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  25382 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  25384 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25387 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25393 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25399 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25402 */     GIR_RootConstrainSelectedInstOperands,
     /*  25403 */     // GIR_Coverage, 3395,
     /*  25403 */     GIR_EraseRootFromParent_Done,
     /*  25404 */   // Label 511: @25404
     /*  25404 */   GIM_Reject,
     /*  25405 */ // Label 509: @25405
     /*  25405 */ GIM_Reject,
     /*  25406 */ // Label 486: @25406
     /*  25406 */ GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(25523), // Rule ID 1828 //
     /*  25411 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25414 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  25417 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  25420 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25424 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25428 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25432 */   // (xor:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  25432 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  25435 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25439 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25444 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  25448 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25453 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  25456 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25460 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25465 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  25469 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25474 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  25477 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
     /*  25481 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25486 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  25489 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  25492 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  25495 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25501 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25507 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  25509 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25512 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25514 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25517 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25522 */   // GIR_Coverage, 1828,
     /*  25522 */   GIR_EraseRootFromParent_Done,
     /*  25523 */ // Label 512: @25523
     /*  25523 */ GIM_Reject,
     /*  25524 */ // Label 487: @25524
     /*  25524 */ GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(25570), // Rule ID 2534 //
     /*  25529 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25532 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  25535 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  25538 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25542 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25546 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25550 */   // (xor:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VEORd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
     /*  25550 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
     /*  25553 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25555 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  25557 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  25559 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25562 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25568 */   GIR_RootConstrainSelectedInstOperands,
     /*  25569 */   // GIR_Coverage, 2534,
     /*  25569 */   GIR_EraseRootFromParent_Done,
     /*  25570 */ // Label 513: @25570
     /*  25570 */ GIM_Reject,
     /*  25571 */ // Label 488: @25571
     /*  25571 */ GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(25684),
     /*  25576 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25579 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25582 */   GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(25622), // Rule ID 1133 //
     /*  25587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25594 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25598 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25602 */     // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
     /*  25602 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
     /*  25605 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25607 */     GIR_RootToRootCopy, /*OpIdx*/1, // Vn
     /*  25609 */     GIR_RootToRootCopy, /*OpIdx*/2, // Vm
     /*  25611 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25614 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25620 */     GIR_RootConstrainSelectedInstOperands,
     /*  25621 */     // GIR_Coverage, 1133,
     /*  25621 */     GIR_EraseRootFromParent_Done,
     /*  25622 */   // Label 515: @25622
     /*  25622 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(25683), // Rule ID 3391 //
     /*  25627 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25630 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25634 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25638 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25642 */     // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
     /*  25642 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  25645 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  25649 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
     /*  25657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  25659 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  25661 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  25663 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25666 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25672 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25678 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25681 */     GIR_RootConstrainSelectedInstOperands,
     /*  25682 */     // GIR_Coverage, 3391,
     /*  25682 */     GIR_EraseRootFromParent_Done,
     /*  25683 */   // Label 516: @25683
     /*  25683 */   GIM_Reject,
     /*  25684 */ // Label 514: @25684
     /*  25684 */ GIM_Reject,
     /*  25685 */ // Label 489: @25685
     /*  25685 */ GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(25802), // Rule ID 1829 //
     /*  25690 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25693 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  25696 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  25699 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25703 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25707 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25711 */   // (xor:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  25711 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  25714 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25718 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25723 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  25727 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25732 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  25735 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25739 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25744 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  25748 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  25753 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  25756 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
     /*  25760 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25765 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  25768 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  25771 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  25774 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25780 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25786 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  25788 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25791 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25793 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25796 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25801 */   // GIR_Coverage, 1829,
     /*  25801 */   GIR_EraseRootFromParent_Done,
     /*  25802 */ // Label 517: @25802
     /*  25802 */ GIM_Reject,
     /*  25803 */ // Label 490: @25803
     /*  25803 */ GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(25849), // Rule ID 2533 //
     /*  25808 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25811 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  25814 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  25817 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25821 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25825 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  25829 */   // (xor:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VEORd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
     /*  25829 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
     /*  25832 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25834 */   GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  25836 */   GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  25838 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25841 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25847 */   GIR_RootConstrainSelectedInstOperands,
     /*  25848 */   // GIR_Coverage, 2533,
     /*  25848 */   GIR_EraseRootFromParent_Done,
     /*  25849 */ // Label 518: @25849
     /*  25849 */ GIM_Reject,
     /*  25850 */ // Label 491: @25850
     /*  25850 */ GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(25963),
     /*  25855 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  25858 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  25861 */   GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(25901), // Rule ID 2537 //
     /*  25866 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  25869 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25873 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25877 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  25881 */     // (xor:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VEORq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
     /*  25881 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
     /*  25884 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  25886 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  25888 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  25890 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  25893 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25899 */     GIR_RootConstrainSelectedInstOperands,
     /*  25900 */     // GIR_Coverage, 2537,
     /*  25900 */     GIR_EraseRootFromParent_Done,
     /*  25901 */   // Label 520: @25901
     /*  25901 */   GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(25962), // Rule ID 3387 //
     /*  25906 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25909 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25913 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25917 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  25921 */     // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
     /*  25921 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  25924 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  25928 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25933 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
     /*  25936 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  25938 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  25940 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  25942 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25945 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25951 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  25957 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25960 */     GIR_RootConstrainSelectedInstOperands,
     /*  25961 */     // GIR_Coverage, 3387,
     /*  25961 */     GIR_EraseRootFromParent_Done,
     /*  25962 */   // Label 521: @25962
     /*  25962 */   GIM_Reject,
     /*  25963 */ // Label 519: @25963
     /*  25963 */ GIM_Reject,
     /*  25964 */ // Label 492: @25964
     /*  25964 */ GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(26081), // Rule ID 1830 //
     /*  25969 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  25972 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  25975 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  25978 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25982 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25986 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
     /*  25990 */   // (xor:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
     /*  25990 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /*  25993 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25997 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26002 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
     /*  26006 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  26011 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  26014 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26018 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26023 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
     /*  26027 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
     /*  26032 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  26035 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
     /*  26039 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26044 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  26047 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  26050 */   GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  26053 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26059 */   GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26065 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  26067 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26070 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26072 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26075 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
     /*  26080 */   // GIR_Coverage, 1830,
     /*  26080 */   GIR_EraseRootFromParent_Done,
     /*  26081 */ // Label 522: @26081
     /*  26081 */ GIM_Reject,
     /*  26082 */ // Label 493: @26082
     /*  26082 */ GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(26195),
     /*  26087 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  26090 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  26093 */   GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(26133), // Rule ID 2536 //
     /*  26098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26101 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26105 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26109 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26113 */     // (xor:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VEORq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
     /*  26113 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
     /*  26116 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  26118 */     GIR_RootToRootCopy, /*OpIdx*/1, // LHS
     /*  26120 */     GIR_RootToRootCopy, /*OpIdx*/2, // RHS
     /*  26122 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  26125 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26131 */     GIR_RootConstrainSelectedInstOperands,
     /*  26132 */     // GIR_Coverage, 2536,
     /*  26132 */     GIR_EraseRootFromParent_Done,
     /*  26133 */   // Label 524: @26133
     /*  26133 */   GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(26194), // Rule ID 3383 //
     /*  26138 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  26141 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  26145 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  26149 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  26153 */     // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
     /*  26153 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  26156 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  26160 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
     /*  26168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  26170 */     GIR_RootToRootCopy, /*OpIdx*/1, // Qm
     /*  26172 */     GIR_RootToRootCopy, /*OpIdx*/2, // Qn
     /*  26174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26177 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26183 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26189 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26192 */     GIR_RootConstrainSelectedInstOperands,
     /*  26193 */     // GIR_Coverage, 3383,
     /*  26193 */     GIR_EraseRootFromParent_Done,
     /*  26194 */   // Label 525: @26194
     /*  26194 */   GIM_Reject,
     /*  26195 */ // Label 523: @26195
     /*  26195 */ GIM_Reject,
     /*  26196 */ // Label 494: @26196
     /*  26196 */ GIM_Reject,
     /*  26197 */ // Label 8: @26197
     /*  26197 */ GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(26583),
     /*  26202 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /*  26205 */   GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(5), GIMT_Encode2(16), /*)*//*default:*//*Label 531*/ GIMT_Encode4(26582),
     /*  26216 */   /*GILLT_v2s64*//*Label 527*/ GIMT_Encode4(26260), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  26228 */   /*GILLT_v4s32*//*Label 528*/ GIMT_Encode4(26318), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  26244 */   /*GILLT_v8s16*//*Label 529*/ GIMT_Encode4(26421), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  26256 */   /*GILLT_v16s8*//*Label 530*/ GIMT_Encode4(26524),
     /*  26260 */   // Label 527: @26260
     /*  26260 */   GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(26317), // Rule ID 3021 //
     /*  26265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26268 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  26271 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  26274 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26278 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26282 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26286 */     // (concat_vectors:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Dn, DPR:{ *:[v1i64] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v2i64] } QPR:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dm, dsub_1:{ *:[i32] })
     /*  26286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26291 */     GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26293 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26296 */     GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26298 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26301 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26306 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26311 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26316 */     // GIR_Coverage, 3021,
     /*  26316 */     GIR_EraseRootFromParent_Done,
     /*  26317 */   // Label 532: @26317
     /*  26317 */   GIM_Reject,
     /*  26318 */   // Label 528: @26318
     /*  26318 */   GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(26420),
     /*  26323 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  26326 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  26329 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26333 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26337 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26341 */     GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(26380), // Rule ID 3022 //
     /*  26346 */       GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26349 */       // (concat_vectors:{ *:[v4i32] } DPR:{ *:[v2i32] }:$Dn, DPR:{ *:[v2i32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4i32] } QPR:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dm, dsub_1:{ *:[i32] })
     /*  26349 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26352 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26354 */       GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26356 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26359 */       GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26361 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26364 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26369 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26374 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26379 */       // GIR_Coverage, 3022,
     /*  26379 */       GIR_EraseRootFromParent_Done,
     /*  26380 */     // Label 534: @26380
     /*  26380 */     GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(26419), // Rule ID 3025 //
     /*  26385 */       GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26388 */       // (concat_vectors:{ *:[v4f32] } DPR:{ *:[v2f32] }:$Dn, DPR:{ *:[v2f32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4f32] } QPR:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dm, dsub_1:{ *:[i32] })
     /*  26388 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26391 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26393 */       GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26395 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26398 */       GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26400 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26403 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26408 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26413 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26418 */       // GIR_Coverage, 3025,
     /*  26418 */       GIR_EraseRootFromParent_Done,
     /*  26419 */     // Label 535: @26419
     /*  26419 */     GIM_Reject,
     /*  26420 */   // Label 533: @26420
     /*  26420 */   GIM_Reject,
     /*  26421 */   // Label 529: @26421
     /*  26421 */   GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(26523),
     /*  26426 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26429 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  26432 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26436 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26440 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26444 */     GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(26483), // Rule ID 3023 //
     /*  26449 */       GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26452 */       // (concat_vectors:{ *:[v8i16] } DPR:{ *:[v4i16] }:$Dn, DPR:{ *:[v4i16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8i16] } QPR:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dm, dsub_1:{ *:[i32] })
     /*  26452 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26455 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26457 */       GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26459 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26462 */       GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26464 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26467 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26472 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26477 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26482 */       // GIR_Coverage, 3023,
     /*  26482 */       GIR_EraseRootFromParent_Done,
     /*  26483 */     // Label 537: @26483
     /*  26483 */     GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(26522), // Rule ID 3026 //
     /*  26488 */       GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26491 */       // (concat_vectors:{ *:[v8f16] } DPR:{ *:[v4f16] }:$Dn, DPR:{ *:[v4f16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8f16] } QPR:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dm, dsub_1:{ *:[i32] })
     /*  26491 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26494 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26496 */       GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26498 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26501 */       GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26503 */       GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26506 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26511 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26516 */       GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26521 */       // GIR_Coverage, 3026,
     /*  26521 */       GIR_EraseRootFromParent_Done,
     /*  26522 */     // Label 538: @26522
     /*  26522 */     GIM_Reject,
     /*  26523 */   // Label 536: @26523
     /*  26523 */   GIM_Reject,
     /*  26524 */   // Label 530: @26524
     /*  26524 */   GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(26581), // Rule ID 3024 //
     /*  26529 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26532 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  26535 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
     /*  26538 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  26542 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26546 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26550 */     // (concat_vectors:{ *:[v16i8] } DPR:{ *:[v8i8] }:$Dn, DPR:{ *:[v8i8] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v16i8] } QPR:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dm, dsub_1:{ *:[i32] })
     /*  26550 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  26553 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26555 */     GIR_RootToRootCopy, /*OpIdx*/1, // Dn
     /*  26557 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
     /*  26560 */     GIR_RootToRootCopy, /*OpIdx*/2, // Dm
     /*  26562 */     GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
     /*  26565 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  26570 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26575 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26580 */     // GIR_Coverage, 3024,
     /*  26580 */     GIR_EraseRootFromParent_Done,
     /*  26581 */   // Label 539: @26581
     /*  26581 */   GIM_Reject,
     /*  26582 */   // Label 531: @26582
     /*  26582 */   GIM_Reject,
     /*  26583 */ // Label 526: @26583
     /*  26583 */ GIM_Reject,
     /*  26584 */ // Label 9: @26584
     /*  26584 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 549*/ GIMT_Encode4(35595),
     /*  26595 */ /*GILLT_s32*//*Label 540*/ GIMT_Encode4(26655),
     /*  26599 */ /*GILLT_s64*//*Label 541*/ GIMT_Encode4(26803), GIMT_Encode4(0),
     /*  26607 */ /*GILLT_v2s32*//*Label 542*/ GIMT_Encode4(27558),
     /*  26611 */ /*GILLT_v2s64*//*Label 543*/ GIMT_Encode4(28313), GIMT_Encode4(0),
     /*  26619 */ /*GILLT_v4s16*//*Label 544*/ GIMT_Encode4(30032),
     /*  26623 */ /*GILLT_v4s32*//*Label 545*/ GIMT_Encode4(30787), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  26635 */ /*GILLT_v8s8*//*Label 546*/ GIMT_Encode4(32506),
     /*  26639 */ /*GILLT_v8s16*//*Label 547*/ GIMT_Encode4(32921), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  26651 */ /*GILLT_v16s8*//*Label 548*/ GIMT_Encode4(34640),
     /*  26655 */ // Label 540: @26655
     /*  26655 */ GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(26802),
     /*  26660 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  26663 */   GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(26697), // Rule ID 689 //
     /*  26668 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs),
     /*  26671 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  26675 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
     /*  26679 */     // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
     /*  26679 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVRS),
     /*  26682 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
     /*  26684 */     GIR_RootToRootCopy, /*OpIdx*/1, // Sn
     /*  26686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  26689 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26695 */     GIR_RootConstrainSelectedInstOperands,
     /*  26696 */     // GIR_Coverage, 689,
     /*  26696 */     GIR_EraseRootFromParent_Done,
     /*  26697 */   // Label 551: @26697
     /*  26697 */   GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(26731), // Rule ID 690 //
     /*  26702 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs_UseVMOVSR),
     /*  26705 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
     /*  26709 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  26713 */     // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
     /*  26713 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVSR),
     /*  26716 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sn]
     /*  26718 */     GIR_RootToRootCopy, /*OpIdx*/1, // Rt
     /*  26720 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  26723 */     GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26729 */     GIR_RootConstrainSelectedInstOperands,
     /*  26730 */     // GIR_Coverage, 690,
     /*  26730 */     GIR_EraseRootFromParent_Done,
     /*  26731 */   // Label 552: @26731
     /*  26731 */   GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(26801), // Rule ID 2715 //
     /*  26736 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseVMOVSR_HasNEON),
     /*  26739 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
     /*  26743 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
     /*  26747 */     // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$a)  =>  (EXTRACT_SUBREG:{ *:[f32] } (VMOVDRR:{ *:[f64] } GPR:{ *:[i32] }:$a, GPR:{ *:[i32] }:$a), ssub_0:{ *:[i32] })
     /*  26747 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  26750 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::VMOVDRR),
     /*  26754 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26759 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
     /*  26763 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
     /*  26767 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
     /*  26770 */     GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  26776 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  26778 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26781 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26783 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
     /*  26790 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
     /*  26795 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPR_VFP2RegClassID),
     /*  26800 */     // GIR_Coverage, 2715,
     /*  26800 */     GIR_EraseRootFromParent_Done,
     /*  26801 */   // Label 553: @26801
     /*  26801 */   GIM_Reject,
     /*  26802 */ // Label 550: @26802
     /*  26802 */ GIM_Reject,
     /*  26803 */ // Label 541: @26803
     /*  26803 */ GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(26835), // Rule ID 2717 //
     /*  26808 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26811 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  26814 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26818 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26822 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  26822 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26825 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26827 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26829 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26834 */   // GIR_Coverage, 2717,
     /*  26834 */   GIR_EraseRootFromParent_Done,
     /*  26835 */ // Label 554: @26835
     /*  26835 */ GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(26867), // Rule ID 2718 //
     /*  26840 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  26843 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  26846 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26850 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26854 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  26854 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26857 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26859 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26861 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26866 */   // GIR_Coverage, 2718,
     /*  26866 */   GIR_EraseRootFromParent_Done,
     /*  26867 */ // Label 555: @26867
     /*  26867 */ GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(26899), // Rule ID 2729 //
     /*  26872 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  26875 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  26878 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26882 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26886 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  26886 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26889 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26891 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26893 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26898 */   // GIR_Coverage, 2729,
     /*  26898 */   GIR_EraseRootFromParent_Done,
     /*  26899 */ // Label 556: @26899
     /*  26899 */ GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(26931), // Rule ID 2730 //
     /*  26904 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  26907 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  26910 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26914 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26918 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  26918 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26921 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26923 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26925 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26930 */   // GIR_Coverage, 2730,
     /*  26930 */   GIR_EraseRootFromParent_Done,
     /*  26931 */ // Label 557: @26931
     /*  26931 */ GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(26963), // Rule ID 2731 //
     /*  26936 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  26939 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26942 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26946 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26950 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  26950 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26953 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26955 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26957 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26962 */   // GIR_Coverage, 2731,
     /*  26962 */   GIR_EraseRootFromParent_Done,
     /*  26963 */ // Label 558: @26963
     /*  26963 */ GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(26995), // Rule ID 2732 //
     /*  26968 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  26971 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  26974 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26978 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  26982 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  26982 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  26985 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  26987 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  26989 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  26994 */   // GIR_Coverage, 2732,
     /*  26994 */   GIR_EraseRootFromParent_Done,
     /*  26995 */ // Label 559: @26995
     /*  26995 */ GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(27027), // Rule ID 2733 //
     /*  27000 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27003 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27006 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27010 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27014 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
     /*  27014 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27017 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27019 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27021 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27026 */   // GIR_Coverage, 2733,
     /*  27026 */   GIR_EraseRootFromParent_Done,
     /*  27027 */ // Label 560: @27027
     /*  27027 */ GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(27059), // Rule ID 2734 //
     /*  27032 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27035 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27038 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27042 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27046 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  27046 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27049 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27051 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27053 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27058 */   // GIR_Coverage, 2734,
     /*  27058 */   GIR_EraseRootFromParent_Done,
     /*  27059 */ // Label 561: @27059
     /*  27059 */ GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(27091), // Rule ID 2735 //
     /*  27064 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27067 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27070 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27074 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27078 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  27078 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27081 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27083 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27085 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27090 */   // GIR_Coverage, 2735,
     /*  27090 */   GIR_EraseRootFromParent_Done,
     /*  27091 */ // Label 562: @27091
     /*  27091 */ GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(27123), // Rule ID 2736 //
     /*  27096 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27099 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27102 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27106 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27110 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  27110 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27113 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27115 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27117 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27122 */   // GIR_Coverage, 2736,
     /*  27122 */   GIR_EraseRootFromParent_Done,
     /*  27123 */ // Label 563: @27123
     /*  27123 */ GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(27155), // Rule ID 2737 //
     /*  27128 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27131 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27134 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27138 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27142 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  27142 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27145 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27147 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27149 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27154 */   // GIR_Coverage, 2737,
     /*  27154 */   GIR_EraseRootFromParent_Done,
     /*  27155 */ // Label 564: @27155
     /*  27155 */ GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(27187), // Rule ID 2738 //
     /*  27160 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27163 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27166 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27170 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27174 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
     /*  27174 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27177 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27179 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27181 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27186 */   // GIR_Coverage, 2738,
     /*  27186 */   GIR_EraseRootFromParent_Done,
     /*  27187 */ // Label 565: @27187
     /*  27187 */ GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(27224), // Rule ID 2801 //
     /*  27192 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27195 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27198 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27202 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27206 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
     /*  27206 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  27209 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27211 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27213 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27216 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27222 */   GIR_RootConstrainSelectedInstOperands,
     /*  27223 */   // GIR_Coverage, 2801,
     /*  27223 */   GIR_EraseRootFromParent_Done,
     /*  27224 */ // Label 566: @27224
     /*  27224 */ GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(27261), // Rule ID 2802 //
     /*  27229 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27232 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27235 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27239 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27243 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
     /*  27243 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  27246 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27248 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27250 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27253 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27259 */   GIR_RootConstrainSelectedInstOperands,
     /*  27260 */   // GIR_Coverage, 2802,
     /*  27260 */   GIR_EraseRootFromParent_Done,
     /*  27261 */ // Label 567: @27261
     /*  27261 */ GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(27298), // Rule ID 2803 //
     /*  27266 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27269 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27272 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27276 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27280 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
     /*  27280 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  27283 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27285 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27287 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27290 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27296 */   GIR_RootConstrainSelectedInstOperands,
     /*  27297 */   // GIR_Coverage, 2803,
     /*  27297 */   GIR_EraseRootFromParent_Done,
     /*  27298 */ // Label 568: @27298
     /*  27298 */ GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(27335), // Rule ID 2804 //
     /*  27303 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27306 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27309 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27313 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27317 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
     /*  27317 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  27320 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27322 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27324 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27327 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27333 */   GIR_RootConstrainSelectedInstOperands,
     /*  27334 */   // GIR_Coverage, 2804,
     /*  27334 */   GIR_EraseRootFromParent_Done,
     /*  27335 */ // Label 569: @27335
     /*  27335 */ GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(27372), // Rule ID 2805 //
     /*  27340 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27343 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27346 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27350 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27354 */   // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
     /*  27354 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
     /*  27357 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27359 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27361 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27364 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27370 */   GIR_RootConstrainSelectedInstOperands,
     /*  27371 */   // GIR_Coverage, 2805,
     /*  27371 */   GIR_EraseRootFromParent_Done,
     /*  27372 */ // Label 570: @27372
     /*  27372 */ GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(27409), // Rule ID 2806 //
     /*  27377 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27380 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27383 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27387 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27391 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
     /*  27391 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  27394 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27396 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27398 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27401 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27407 */   GIR_RootConstrainSelectedInstOperands,
     /*  27408 */   // GIR_Coverage, 2806,
     /*  27408 */   GIR_EraseRootFromParent_Done,
     /*  27409 */ // Label 571: @27409
     /*  27409 */ GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(27446), // Rule ID 2807 //
     /*  27414 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27417 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27420 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27424 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27428 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
     /*  27428 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  27431 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27433 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27435 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27438 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27444 */   GIR_RootConstrainSelectedInstOperands,
     /*  27445 */   // GIR_Coverage, 2807,
     /*  27445 */   GIR_EraseRootFromParent_Done,
     /*  27446 */ // Label 572: @27446
     /*  27446 */ GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(27483), // Rule ID 2808 //
     /*  27451 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27454 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27457 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27461 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27465 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
     /*  27465 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  27468 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27470 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27472 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27475 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27481 */   GIR_RootConstrainSelectedInstOperands,
     /*  27482 */   // GIR_Coverage, 2808,
     /*  27482 */   GIR_EraseRootFromParent_Done,
     /*  27483 */ // Label 573: @27483
     /*  27483 */ GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(27520), // Rule ID 2809 //
     /*  27488 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27491 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27494 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27498 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27502 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
     /*  27502 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  27505 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27507 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27509 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27512 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27518 */   GIR_RootConstrainSelectedInstOperands,
     /*  27519 */   // GIR_Coverage, 2809,
     /*  27519 */   GIR_EraseRootFromParent_Done,
     /*  27520 */ // Label 574: @27520
     /*  27520 */ GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(27557), // Rule ID 2810 //
     /*  27525 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27528 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27531 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27535 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27539 */   // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
     /*  27539 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
     /*  27542 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27544 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27546 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27549 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27555 */   GIR_RootConstrainSelectedInstOperands,
     /*  27556 */   // GIR_Coverage, 2810,
     /*  27556 */   GIR_EraseRootFromParent_Done,
     /*  27557 */ // Label 575: @27557
     /*  27557 */ GIM_Reject,
     /*  27558 */ // Label 542: @27558
     /*  27558 */ GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(27590), // Rule ID 2719 //
     /*  27563 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27566 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27569 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27573 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27577 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27577 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27580 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27582 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27584 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27589 */   // GIR_Coverage, 2719,
     /*  27589 */   GIR_EraseRootFromParent_Done,
     /*  27590 */ // Label 576: @27590
     /*  27590 */ GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(27622), // Rule ID 2720 //
     /*  27595 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  27598 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  27601 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27605 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27609 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27609 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27612 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27614 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27616 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27621 */   // GIR_Coverage, 2720,
     /*  27621 */   GIR_EraseRootFromParent_Done,
     /*  27622 */ // Label 577: @27622
     /*  27622 */ GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(27654), // Rule ID 2739 //
     /*  27627 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27630 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27633 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27637 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27641 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27641 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27644 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27646 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27648 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27653 */   // GIR_Coverage, 2739,
     /*  27653 */   GIR_EraseRootFromParent_Done,
     /*  27654 */ // Label 578: @27654
     /*  27654 */ GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(27686), // Rule ID 2740 //
     /*  27659 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27662 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27665 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27669 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27673 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27673 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27676 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27678 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27680 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27685 */   // GIR_Coverage, 2740,
     /*  27685 */   GIR_EraseRootFromParent_Done,
     /*  27686 */ // Label 579: @27686
     /*  27686 */ GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(27718), // Rule ID 2741 //
     /*  27691 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27694 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27697 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27701 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27705 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27705 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27708 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27710 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27712 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27717 */   // GIR_Coverage, 2741,
     /*  27717 */   GIR_EraseRootFromParent_Done,
     /*  27718 */ // Label 580: @27718
     /*  27718 */ GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(27750), // Rule ID 2742 //
     /*  27723 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27726 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27729 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27733 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27737 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27737 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27740 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27742 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27744 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27749 */   // GIR_Coverage, 2742,
     /*  27749 */   GIR_EraseRootFromParent_Done,
     /*  27750 */ // Label 581: @27750
     /*  27750 */ GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(27782), // Rule ID 2743 //
     /*  27755 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27758 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27761 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27765 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27769 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
     /*  27769 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27772 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27774 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27776 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27781 */   // GIR_Coverage, 2743,
     /*  27781 */   GIR_EraseRootFromParent_Done,
     /*  27782 */ // Label 582: @27782
     /*  27782 */ GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(27814), // Rule ID 2744 //
     /*  27787 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27790 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27793 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27797 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27801 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27801 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27804 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27806 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27808 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27813 */   // GIR_Coverage, 2744,
     /*  27813 */   GIR_EraseRootFromParent_Done,
     /*  27814 */ // Label 583: @27814
     /*  27814 */ GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(27846), // Rule ID 2745 //
     /*  27819 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27822 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27825 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27829 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27833 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27833 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27836 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27838 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27840 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27845 */   // GIR_Coverage, 2745,
     /*  27845 */   GIR_EraseRootFromParent_Done,
     /*  27846 */ // Label 584: @27846
     /*  27846 */ GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(27878), // Rule ID 2746 //
     /*  27851 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27854 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27857 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27861 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27865 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27865 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27868 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27870 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27872 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27877 */   // GIR_Coverage, 2746,
     /*  27877 */   GIR_EraseRootFromParent_Done,
     /*  27878 */ // Label 585: @27878
     /*  27878 */ GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(27910), // Rule ID 2747 //
     /*  27883 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27886 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  27889 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27893 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27897 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27897 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27900 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27902 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27904 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27909 */   // GIR_Coverage, 2747,
     /*  27909 */   GIR_EraseRootFromParent_Done,
     /*  27910 */ // Label 586: @27910
     /*  27910 */ GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(27942), // Rule ID 2748 //
     /*  27915 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  27918 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  27921 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27925 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27929 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
     /*  27929 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  27932 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  27934 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27936 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  27941 */   // GIR_Coverage, 2748,
     /*  27941 */   GIR_EraseRootFromParent_Done,
     /*  27942 */ // Label 587: @27942
     /*  27942 */ GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(27979), // Rule ID 2811 //
     /*  27947 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27950 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27953 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27957 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27961 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
     /*  27961 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  27964 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  27966 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27968 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  27971 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  27977 */   GIR_RootConstrainSelectedInstOperands,
     /*  27978 */   // GIR_Coverage, 2811,
     /*  27978 */   GIR_EraseRootFromParent_Done,
     /*  27979 */ // Label 588: @27979
     /*  27979 */ GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(28016), // Rule ID 2812 //
     /*  27984 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  27987 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  27990 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27994 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  27998 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
     /*  27998 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  28001 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28003 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28005 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28008 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28014 */   GIR_RootConstrainSelectedInstOperands,
     /*  28015 */   // GIR_Coverage, 2812,
     /*  28015 */   GIR_EraseRootFromParent_Done,
     /*  28016 */ // Label 589: @28016
     /*  28016 */ GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(28053), // Rule ID 2813 //
     /*  28021 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28024 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28027 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28031 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28035 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
     /*  28035 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  28038 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28040 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28042 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28045 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28051 */   GIR_RootConstrainSelectedInstOperands,
     /*  28052 */   // GIR_Coverage, 2813,
     /*  28052 */   GIR_EraseRootFromParent_Done,
     /*  28053 */ // Label 590: @28053
     /*  28053 */ GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(28090), // Rule ID 2814 //
     /*  28058 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28061 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28064 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28068 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28072 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
     /*  28072 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  28075 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28077 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28079 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28082 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28088 */   GIR_RootConstrainSelectedInstOperands,
     /*  28089 */   // GIR_Coverage, 2814,
     /*  28089 */   GIR_EraseRootFromParent_Done,
     /*  28090 */ // Label 591: @28090
     /*  28090 */ GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(28127), // Rule ID 2815 //
     /*  28095 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28098 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  28101 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28105 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28109 */   // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
     /*  28109 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
     /*  28112 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28114 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28116 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28119 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28125 */   GIR_RootConstrainSelectedInstOperands,
     /*  28126 */   // GIR_Coverage, 2815,
     /*  28126 */   GIR_EraseRootFromParent_Done,
     /*  28127 */ // Label 592: @28127
     /*  28127 */ GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(28164), // Rule ID 2816 //
     /*  28132 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28135 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  28138 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28142 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28146 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
     /*  28146 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  28149 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28151 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28153 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28156 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28162 */   GIR_RootConstrainSelectedInstOperands,
     /*  28163 */   // GIR_Coverage, 2816,
     /*  28163 */   GIR_EraseRootFromParent_Done,
     /*  28164 */ // Label 593: @28164
     /*  28164 */ GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(28201), // Rule ID 2817 //
     /*  28169 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28172 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  28175 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28179 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28183 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
     /*  28183 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
     /*  28186 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28188 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28190 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28193 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28199 */   GIR_RootConstrainSelectedInstOperands,
     /*  28200 */   // GIR_Coverage, 2817,
     /*  28200 */   GIR_EraseRootFromParent_Done,
     /*  28201 */ // Label 594: @28201
     /*  28201 */ GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(28238), // Rule ID 2818 //
     /*  28206 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28209 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28212 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28216 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28220 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
     /*  28220 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  28223 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28225 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28227 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28230 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28236 */   GIR_RootConstrainSelectedInstOperands,
     /*  28237 */   // GIR_Coverage, 2818,
     /*  28237 */   GIR_EraseRootFromParent_Done,
     /*  28238 */ // Label 595: @28238
     /*  28238 */ GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(28275), // Rule ID 2819 //
     /*  28243 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28246 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  28249 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28253 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28257 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
     /*  28257 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  28260 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28262 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28264 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28267 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28273 */   GIR_RootConstrainSelectedInstOperands,
     /*  28274 */   // GIR_Coverage, 2819,
     /*  28274 */   GIR_EraseRootFromParent_Done,
     /*  28275 */ // Label 596: @28275
     /*  28275 */ GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(28312), // Rule ID 2820 //
     /*  28280 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28283 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  28286 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28290 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  28294 */   // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
     /*  28294 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
     /*  28297 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28299 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28301 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28304 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28310 */   GIR_RootConstrainSelectedInstOperands,
     /*  28311 */   // GIR_Coverage, 2820,
     /*  28311 */   GIR_EraseRootFromParent_Done,
     /*  28312 */ // Label 597: @28312
     /*  28312 */ GIM_Reject,
     /*  28313 */ // Label 543: @28313
     /*  28313 */ GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(28345), // Rule ID 2723 //
     /*  28318 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28321 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  28324 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28328 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28332 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28332 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28335 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28337 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28339 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28344 */   // GIR_Coverage, 2723,
     /*  28344 */   GIR_EraseRootFromParent_Done,
     /*  28345 */ // Label 598: @28345
     /*  28345 */ GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(28377), // Rule ID 2724 //
     /*  28350 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  28353 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  28356 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28360 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28364 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28364 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28367 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28369 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28371 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28376 */   // GIR_Coverage, 2724,
     /*  28376 */   GIR_EraseRootFromParent_Done,
     /*  28377 */ // Label 599: @28377
     /*  28377 */ GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(28409), // Rule ID 2765 //
     /*  28382 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28385 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28388 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28392 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28396 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28396 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28399 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28401 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28403 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28408 */   // GIR_Coverage, 2765,
     /*  28408 */   GIR_EraseRootFromParent_Done,
     /*  28409 */ // Label 600: @28409
     /*  28409 */ GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(28441), // Rule ID 2766 //
     /*  28414 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28417 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28420 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28424 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28428 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28428 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28431 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28433 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28435 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28440 */   // GIR_Coverage, 2766,
     /*  28440 */   GIR_EraseRootFromParent_Done,
     /*  28441 */ // Label 601: @28441
     /*  28441 */ GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(28473), // Rule ID 2767 //
     /*  28446 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28449 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28452 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28456 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28460 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28460 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28463 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28465 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28467 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28472 */   // GIR_Coverage, 2767,
     /*  28472 */   GIR_EraseRootFromParent_Done,
     /*  28473 */ // Label 602: @28473
     /*  28473 */ GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(28505), // Rule ID 2768 //
     /*  28478 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28481 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28484 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28488 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28492 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28492 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28495 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28497 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28499 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28504 */   // GIR_Coverage, 2768,
     /*  28504 */   GIR_EraseRootFromParent_Done,
     /*  28505 */ // Label 603: @28505
     /*  28505 */ GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(28537), // Rule ID 2769 //
     /*  28510 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28513 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  28516 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28520 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28524 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
     /*  28524 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28527 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28529 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28531 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28536 */   // GIR_Coverage, 2769,
     /*  28536 */   GIR_EraseRootFromParent_Done,
     /*  28537 */ // Label 604: @28537
     /*  28537 */ GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(28569), // Rule ID 2770 //
     /*  28542 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28545 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28548 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28552 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28556 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28556 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28559 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28561 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28563 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28568 */   // GIR_Coverage, 2770,
     /*  28568 */   GIR_EraseRootFromParent_Done,
     /*  28569 */ // Label 605: @28569
     /*  28569 */ GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(28601), // Rule ID 2771 //
     /*  28574 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28577 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28580 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28584 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28588 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28588 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28591 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28593 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28595 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28600 */   // GIR_Coverage, 2771,
     /*  28600 */   GIR_EraseRootFromParent_Done,
     /*  28601 */ // Label 606: @28601
     /*  28601 */ GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(28633), // Rule ID 2772 //
     /*  28606 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28609 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28612 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28616 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28620 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28620 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28623 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28625 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28627 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28632 */   // GIR_Coverage, 2772,
     /*  28632 */   GIR_EraseRootFromParent_Done,
     /*  28633 */ // Label 607: @28633
     /*  28633 */ GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(28665), // Rule ID 2773 //
     /*  28638 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28641 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28644 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28648 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28652 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28652 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28655 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28657 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28659 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28664 */   // GIR_Coverage, 2773,
     /*  28664 */   GIR_EraseRootFromParent_Done,
     /*  28665 */ // Label 608: @28665
     /*  28665 */ GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(28697), // Rule ID 2774 //
     /*  28670 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  28673 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  28676 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28680 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28684 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
     /*  28684 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  28687 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  28689 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28691 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  28696 */   // GIR_Coverage, 2774,
     /*  28696 */   GIR_EraseRootFromParent_Done,
     /*  28697 */ // Label 609: @28697
     /*  28697 */ GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(28734), // Rule ID 2837 //
     /*  28702 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28705 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28708 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28712 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28716 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
     /*  28716 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  28719 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28721 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28723 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28726 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28732 */   GIR_RootConstrainSelectedInstOperands,
     /*  28733 */   // GIR_Coverage, 2837,
     /*  28733 */   GIR_EraseRootFromParent_Done,
     /*  28734 */ // Label 610: @28734
     /*  28734 */ GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(28771), // Rule ID 2838 //
     /*  28739 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28742 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28745 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28749 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28753 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
     /*  28753 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  28756 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28758 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28760 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28763 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28769 */   GIR_RootConstrainSelectedInstOperands,
     /*  28770 */   // GIR_Coverage, 2838,
     /*  28770 */   GIR_EraseRootFromParent_Done,
     /*  28771 */ // Label 611: @28771
     /*  28771 */ GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(28808), // Rule ID 2839 //
     /*  28776 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28779 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28782 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28786 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28790 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
     /*  28790 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  28793 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28795 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28797 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28800 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28806 */   GIR_RootConstrainSelectedInstOperands,
     /*  28807 */   // GIR_Coverage, 2839,
     /*  28807 */   GIR_EraseRootFromParent_Done,
     /*  28808 */ // Label 612: @28808
     /*  28808 */ GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(28845), // Rule ID 2840 //
     /*  28813 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28816 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28819 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28823 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28827 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
     /*  28827 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  28830 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28832 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28834 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28837 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28843 */   GIR_RootConstrainSelectedInstOperands,
     /*  28844 */   // GIR_Coverage, 2840,
     /*  28844 */   GIR_EraseRootFromParent_Done,
     /*  28845 */ // Label 613: @28845
     /*  28845 */ GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(28882), // Rule ID 2841 //
     /*  28850 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28853 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  28856 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28860 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28864 */   // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
     /*  28864 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
     /*  28867 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28869 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28871 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28874 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28880 */   GIR_RootConstrainSelectedInstOperands,
     /*  28881 */   // GIR_Coverage, 2841,
     /*  28881 */   GIR_EraseRootFromParent_Done,
     /*  28882 */ // Label 614: @28882
     /*  28882 */ GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(28919), // Rule ID 2842 //
     /*  28887 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28890 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28893 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28897 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28901 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
     /*  28901 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  28904 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28906 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28908 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28911 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28917 */   GIR_RootConstrainSelectedInstOperands,
     /*  28918 */   // GIR_Coverage, 2842,
     /*  28918 */   GIR_EraseRootFromParent_Done,
     /*  28919 */ // Label 615: @28919
     /*  28919 */ GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(28956), // Rule ID 2843 //
     /*  28924 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28927 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28930 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28934 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28938 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
     /*  28938 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  28941 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28943 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28945 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28948 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28954 */   GIR_RootConstrainSelectedInstOperands,
     /*  28955 */   // GIR_Coverage, 2843,
     /*  28955 */   GIR_EraseRootFromParent_Done,
     /*  28956 */ // Label 616: @28956
     /*  28956 */ GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(28993), // Rule ID 2844 //
     /*  28961 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  28964 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  28967 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28971 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  28975 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
     /*  28975 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  28978 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  28980 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28982 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  28985 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  28991 */   GIR_RootConstrainSelectedInstOperands,
     /*  28992 */   // GIR_Coverage, 2844,
     /*  28992 */   GIR_EraseRootFromParent_Done,
     /*  28993 */ // Label 617: @28993
     /*  28993 */ GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(29030), // Rule ID 2845 //
     /*  28998 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  29001 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29004 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  29008 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  29012 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
     /*  29012 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  29015 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  29017 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29019 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  29022 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29028 */   GIR_RootConstrainSelectedInstOperands,
     /*  29029 */   // GIR_Coverage, 2845,
     /*  29029 */   GIR_EraseRootFromParent_Done,
     /*  29030 */ // Label 618: @29030
     /*  29030 */ GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(29067), // Rule ID 2846 //
     /*  29035 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  29038 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  29041 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  29045 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  29049 */   // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
     /*  29049 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
     /*  29052 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  29054 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29056 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  29059 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29065 */   GIR_RootConstrainSelectedInstOperands,
     /*  29066 */   // GIR_Coverage, 2846,
     /*  29066 */   GIR_EraseRootFromParent_Done,
     /*  29067 */ // Label 619: @29067
     /*  29067 */ GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(29099), // Rule ID 5280 //
     /*  29072 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  29075 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  29078 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29082 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29086 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29086 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29089 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29091 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29093 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29098 */   // GIR_Coverage, 5280,
     /*  29098 */   GIR_EraseRootFromParent_Done,
     /*  29099 */ // Label 620: @29099
     /*  29099 */ GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(29131), // Rule ID 5281 //
     /*  29104 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  29107 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  29110 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29114 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29118 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29118 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29121 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29123 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29125 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29130 */   // GIR_Coverage, 5281,
     /*  29130 */   GIR_EraseRootFromParent_Done,
     /*  29131 */ // Label 621: @29131
     /*  29131 */ GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(29163), // Rule ID 5286 //
     /*  29136 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29139 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29142 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29146 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29150 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29150 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29153 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29155 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29157 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29162 */   // GIR_Coverage, 5286,
     /*  29162 */   GIR_EraseRootFromParent_Done,
     /*  29163 */ // Label 622: @29163
     /*  29163 */ GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(29195), // Rule ID 5287 //
     /*  29168 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29171 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29174 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29178 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29182 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29182 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29185 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29187 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29189 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29194 */   // GIR_Coverage, 5287,
     /*  29194 */   GIR_EraseRootFromParent_Done,
     /*  29195 */ // Label 623: @29195
     /*  29195 */ GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(29227), // Rule ID 5288 //
     /*  29200 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29203 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29206 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29210 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29214 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29214 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29217 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29219 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29221 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29226 */   // GIR_Coverage, 5288,
     /*  29226 */   GIR_EraseRootFromParent_Done,
     /*  29227 */ // Label 624: @29227
     /*  29227 */ GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(29259), // Rule ID 5289 //
     /*  29232 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29235 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29238 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29242 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29246 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29246 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29249 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29251 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29253 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29258 */   // GIR_Coverage, 5289,
     /*  29258 */   GIR_EraseRootFromParent_Done,
     /*  29259 */ // Label 625: @29259
     /*  29259 */ GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(29291), // Rule ID 5290 //
     /*  29264 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29267 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  29270 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29274 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29278 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
     /*  29278 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29281 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29283 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29285 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29290 */   // GIR_Coverage, 5290,
     /*  29290 */   GIR_EraseRootFromParent_Done,
     /*  29291 */ // Label 626: @29291
     /*  29291 */ GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(29323), // Rule ID 5291 //
     /*  29296 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29299 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29302 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29306 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29310 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29310 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29313 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29315 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29317 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29322 */   // GIR_Coverage, 5291,
     /*  29322 */   GIR_EraseRootFromParent_Done,
     /*  29323 */ // Label 627: @29323
     /*  29323 */ GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(29355), // Rule ID 5292 //
     /*  29328 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29331 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29334 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29338 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29342 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29342 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29345 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29347 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29349 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29354 */   // GIR_Coverage, 5292,
     /*  29354 */   GIR_EraseRootFromParent_Done,
     /*  29355 */ // Label 628: @29355
     /*  29355 */ GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(29387), // Rule ID 5293 //
     /*  29360 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29363 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29366 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29370 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29374 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29374 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29377 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29379 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29381 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29386 */   // GIR_Coverage, 5293,
     /*  29386 */   GIR_EraseRootFromParent_Done,
     /*  29387 */ // Label 629: @29387
     /*  29387 */ GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(29419), // Rule ID 5294 //
     /*  29392 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29395 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29398 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29402 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29406 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29406 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29409 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29411 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29413 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29418 */   // GIR_Coverage, 5294,
     /*  29418 */   GIR_EraseRootFromParent_Done,
     /*  29419 */ // Label 630: @29419
     /*  29419 */ GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(29451), // Rule ID 5295 //
     /*  29424 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  29427 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  29430 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29434 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29438 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
     /*  29438 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29441 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  29443 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29445 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29450 */   // GIR_Coverage, 5295,
     /*  29450 */   GIR_EraseRootFromParent_Done,
     /*  29451 */ // Label 631: @29451
     /*  29451 */ GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(29509), // Rule ID 5322 //
     /*  29456 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29459 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29462 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29466 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29470 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)
     /*  29470 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29473 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29477 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29482 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  29485 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29487 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29489 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29492 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29498 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29504 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29507 */   GIR_RootConstrainSelectedInstOperands,
     /*  29508 */   // GIR_Coverage, 5322,
     /*  29508 */   GIR_EraseRootFromParent_Done,
     /*  29509 */ // Label 632: @29509
     /*  29509 */ GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(29567), // Rule ID 5323 //
     /*  29514 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29517 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29520 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29524 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29528 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)
     /*  29528 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29531 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29535 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29540 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  29543 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29545 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29547 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29550 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29556 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29562 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29565 */   GIR_RootConstrainSelectedInstOperands,
     /*  29566 */   // GIR_Coverage, 5323,
     /*  29566 */   GIR_EraseRootFromParent_Done,
     /*  29567 */ // Label 633: @29567
     /*  29567 */ GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(29625), // Rule ID 5324 //
     /*  29572 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29575 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29578 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29582 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29586 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)
     /*  29586 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29589 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29593 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29598 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  29601 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29603 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29605 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29608 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29614 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29620 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29623 */   GIR_RootConstrainSelectedInstOperands,
     /*  29624 */   // GIR_Coverage, 5324,
     /*  29624 */   GIR_EraseRootFromParent_Done,
     /*  29625 */ // Label 634: @29625
     /*  29625 */ GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(29683), // Rule ID 5325 //
     /*  29630 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29633 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29636 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29640 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29644 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)
     /*  29644 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29647 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29651 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29656 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  29659 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29661 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29663 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29666 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29672 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29678 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29681 */   GIR_RootConstrainSelectedInstOperands,
     /*  29682 */   // GIR_Coverage, 5325,
     /*  29682 */   GIR_EraseRootFromParent_Done,
     /*  29683 */ // Label 635: @29683
     /*  29683 */ GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(29741), // Rule ID 5326 //
     /*  29688 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29691 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  29694 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29698 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29702 */   // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)
     /*  29702 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29705 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29709 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29714 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
     /*  29717 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29719 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29721 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29724 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29730 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29736 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29739 */   GIR_RootConstrainSelectedInstOperands,
     /*  29740 */   // GIR_Coverage, 5326,
     /*  29740 */   GIR_EraseRootFromParent_Done,
     /*  29741 */ // Label 636: @29741
     /*  29741 */ GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(29799), // Rule ID 5327 //
     /*  29746 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29749 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29752 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29756 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29760 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)
     /*  29760 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29763 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29767 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29772 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  29775 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29777 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29779 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29782 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29788 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29794 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29797 */   GIR_RootConstrainSelectedInstOperands,
     /*  29798 */   // GIR_Coverage, 5327,
     /*  29798 */   GIR_EraseRootFromParent_Done,
     /*  29799 */ // Label 637: @29799
     /*  29799 */ GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(29857), // Rule ID 5328 //
     /*  29804 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29807 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29810 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29814 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29818 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)
     /*  29818 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29821 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29825 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29830 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  29833 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29835 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29837 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29840 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29846 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29852 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29855 */   GIR_RootConstrainSelectedInstOperands,
     /*  29856 */   // GIR_Coverage, 5328,
     /*  29856 */   GIR_EraseRootFromParent_Done,
     /*  29857 */ // Label 638: @29857
     /*  29857 */ GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(29915), // Rule ID 5329 //
     /*  29862 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29865 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29868 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29872 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29876 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)
     /*  29876 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29879 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29883 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29888 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  29891 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29893 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29895 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29898 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29904 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29910 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29913 */   GIR_RootConstrainSelectedInstOperands,
     /*  29914 */   // GIR_Coverage, 5329,
     /*  29914 */   GIR_EraseRootFromParent_Done,
     /*  29915 */ // Label 639: @29915
     /*  29915 */ GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(29973), // Rule ID 5330 //
     /*  29920 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29923 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  29926 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29930 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29934 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)
     /*  29934 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29937 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29941 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29946 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  29949 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  29951 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29953 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29956 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29962 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  29968 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29971 */   GIR_RootConstrainSelectedInstOperands,
     /*  29972 */   // GIR_Coverage, 5330,
     /*  29972 */   GIR_EraseRootFromParent_Done,
     /*  29973 */ // Label 640: @29973
     /*  29973 */ GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(30031), // Rule ID 5331 //
     /*  29978 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  29981 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  29984 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29988 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  29992 */   // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)
     /*  29992 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  29995 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29999 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30004 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
     /*  30007 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  30009 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30011 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30014 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30020 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30026 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  30029 */   GIR_RootConstrainSelectedInstOperands,
     /*  30030 */   // GIR_Coverage, 5331,
     /*  30030 */   GIR_EraseRootFromParent_Done,
     /*  30031 */ // Label 641: @30031
     /*  30031 */ GIM_Reject,
     /*  30032 */ // Label 544: @30032
     /*  30032 */ GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(30064), // Rule ID 2721 //
     /*  30037 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30040 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30043 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30047 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30051 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30051 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30054 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30056 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30058 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30063 */   // GIR_Coverage, 2721,
     /*  30063 */   GIR_EraseRootFromParent_Done,
     /*  30064 */ // Label 642: @30064
     /*  30064 */ GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(30096), // Rule ID 2722 //
     /*  30069 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30072 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  30075 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30079 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30083 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30083 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30086 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30088 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30090 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30095 */   // GIR_Coverage, 2722,
     /*  30095 */   GIR_EraseRootFromParent_Done,
     /*  30096 */ // Label 643: @30096
     /*  30096 */ GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(30128), // Rule ID 2749 //
     /*  30101 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30104 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30107 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30111 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30115 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30115 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30118 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30120 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30122 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30127 */   // GIR_Coverage, 2749,
     /*  30127 */   GIR_EraseRootFromParent_Done,
     /*  30128 */ // Label 644: @30128
     /*  30128 */ GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(30160), // Rule ID 2750 //
     /*  30133 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30136 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30139 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30143 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30147 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30147 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30150 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30152 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30154 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30159 */   // GIR_Coverage, 2750,
     /*  30159 */   GIR_EraseRootFromParent_Done,
     /*  30160 */ // Label 645: @30160
     /*  30160 */ GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(30192), // Rule ID 2751 //
     /*  30165 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30168 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30171 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30175 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30179 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30179 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30182 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30184 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30186 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30191 */   // GIR_Coverage, 2751,
     /*  30191 */   GIR_EraseRootFromParent_Done,
     /*  30192 */ // Label 646: @30192
     /*  30192 */ GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(30224), // Rule ID 2752 //
     /*  30197 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30200 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30203 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30207 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30211 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30211 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30214 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30216 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30218 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30223 */   // GIR_Coverage, 2752,
     /*  30223 */   GIR_EraseRootFromParent_Done,
     /*  30224 */ // Label 647: @30224
     /*  30224 */ GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(30256), // Rule ID 2753 //
     /*  30229 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30232 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  30235 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30239 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30243 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
     /*  30243 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30246 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30248 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30250 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30255 */   // GIR_Coverage, 2753,
     /*  30255 */   GIR_EraseRootFromParent_Done,
     /*  30256 */ // Label 648: @30256
     /*  30256 */ GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(30288), // Rule ID 2754 //
     /*  30261 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30264 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30267 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30271 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30275 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30275 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30278 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30280 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30282 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30287 */   // GIR_Coverage, 2754,
     /*  30287 */   GIR_EraseRootFromParent_Done,
     /*  30288 */ // Label 649: @30288
     /*  30288 */ GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(30320), // Rule ID 2755 //
     /*  30293 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30296 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30299 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30303 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30307 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30307 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30310 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30312 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30314 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30319 */   // GIR_Coverage, 2755,
     /*  30319 */   GIR_EraseRootFromParent_Done,
     /*  30320 */ // Label 650: @30320
     /*  30320 */ GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(30352), // Rule ID 2756 //
     /*  30325 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30328 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30331 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30335 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30339 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30339 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30342 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30344 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30346 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30351 */   // GIR_Coverage, 2756,
     /*  30351 */   GIR_EraseRootFromParent_Done,
     /*  30352 */ // Label 651: @30352
     /*  30352 */ GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(30384), // Rule ID 2757 //
     /*  30357 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30360 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30363 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30367 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30371 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30371 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30374 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30376 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30378 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30383 */   // GIR_Coverage, 2757,
     /*  30383 */   GIR_EraseRootFromParent_Done,
     /*  30384 */ // Label 652: @30384
     /*  30384 */ GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(30416), // Rule ID 2758 //
     /*  30389 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30392 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  30395 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30399 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30403 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
     /*  30403 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30406 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30408 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30410 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  30415 */   // GIR_Coverage, 2758,
     /*  30415 */   GIR_EraseRootFromParent_Done,
     /*  30416 */ // Label 653: @30416
     /*  30416 */ GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(30453), // Rule ID 2821 //
     /*  30421 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30424 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30427 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30431 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30435 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
     /*  30435 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  30438 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30440 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30442 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30445 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30451 */   GIR_RootConstrainSelectedInstOperands,
     /*  30452 */   // GIR_Coverage, 2821,
     /*  30452 */   GIR_EraseRootFromParent_Done,
     /*  30453 */ // Label 654: @30453
     /*  30453 */ GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(30490), // Rule ID 2822 //
     /*  30458 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30461 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30464 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30468 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30472 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
     /*  30472 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  30475 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30477 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30479 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30482 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30488 */   GIR_RootConstrainSelectedInstOperands,
     /*  30489 */   // GIR_Coverage, 2822,
     /*  30489 */   GIR_EraseRootFromParent_Done,
     /*  30490 */ // Label 655: @30490
     /*  30490 */ GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(30527), // Rule ID 2823 //
     /*  30495 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30498 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30501 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30505 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30509 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
     /*  30509 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  30512 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30514 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30516 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30519 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30525 */   GIR_RootConstrainSelectedInstOperands,
     /*  30526 */   // GIR_Coverage, 2823,
     /*  30526 */   GIR_EraseRootFromParent_Done,
     /*  30527 */ // Label 656: @30527
     /*  30527 */ GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(30564), // Rule ID 2824 //
     /*  30532 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30535 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30538 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30542 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30546 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
     /*  30546 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  30549 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30551 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30553 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30556 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30562 */   GIR_RootConstrainSelectedInstOperands,
     /*  30563 */   // GIR_Coverage, 2824,
     /*  30563 */   GIR_EraseRootFromParent_Done,
     /*  30564 */ // Label 657: @30564
     /*  30564 */ GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(30601), // Rule ID 2825 //
     /*  30569 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30572 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  30575 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30579 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30583 */   // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
     /*  30583 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
     /*  30586 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30588 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30590 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30593 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30599 */   GIR_RootConstrainSelectedInstOperands,
     /*  30600 */   // GIR_Coverage, 2825,
     /*  30600 */   GIR_EraseRootFromParent_Done,
     /*  30601 */ // Label 658: @30601
     /*  30601 */ GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(30638), // Rule ID 2826 //
     /*  30606 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30609 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30612 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30616 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30620 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
     /*  30620 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  30623 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30625 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30627 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30630 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30636 */   GIR_RootConstrainSelectedInstOperands,
     /*  30637 */   // GIR_Coverage, 2826,
     /*  30637 */   GIR_EraseRootFromParent_Done,
     /*  30638 */ // Label 659: @30638
     /*  30638 */ GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(30675), // Rule ID 2827 //
     /*  30643 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30646 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  30649 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30653 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30657 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
     /*  30657 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
     /*  30660 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30662 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30664 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30667 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30673 */   GIR_RootConstrainSelectedInstOperands,
     /*  30674 */   // GIR_Coverage, 2827,
     /*  30674 */   GIR_EraseRootFromParent_Done,
     /*  30675 */ // Label 660: @30675
     /*  30675 */ GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(30712), // Rule ID 2828 //
     /*  30680 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30683 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30686 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30690 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30694 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
     /*  30694 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  30697 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30699 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30701 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30704 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30710 */   GIR_RootConstrainSelectedInstOperands,
     /*  30711 */   // GIR_Coverage, 2828,
     /*  30711 */   GIR_EraseRootFromParent_Done,
     /*  30712 */ // Label 661: @30712
     /*  30712 */ GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(30749), // Rule ID 2829 //
     /*  30717 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30720 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  30723 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30727 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30731 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
     /*  30731 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
     /*  30734 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30736 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30738 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30741 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30747 */   GIR_RootConstrainSelectedInstOperands,
     /*  30748 */   // GIR_Coverage, 2829,
     /*  30748 */   GIR_EraseRootFromParent_Done,
     /*  30749 */ // Label 662: @30749
     /*  30749 */ GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(30786), // Rule ID 2830 //
     /*  30754 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  30757 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
     /*  30760 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30764 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  30768 */   // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
     /*  30768 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
     /*  30771 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  30773 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30775 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  30778 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  30784 */   GIR_RootConstrainSelectedInstOperands,
     /*  30785 */   // GIR_Coverage, 2830,
     /*  30785 */   GIR_EraseRootFromParent_Done,
     /*  30786 */ // Label 663: @30786
     /*  30786 */ GIM_Reject,
     /*  30787 */ // Label 545: @30787
     /*  30787 */ GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(30819), // Rule ID 2725 //
     /*  30792 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30795 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30798 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30802 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30806 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  30806 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30809 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30811 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30813 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30818 */   // GIR_Coverage, 2725,
     /*  30818 */   GIR_EraseRootFromParent_Done,
     /*  30819 */ // Label 664: @30819
     /*  30819 */ GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(30851), // Rule ID 2726 //
     /*  30824 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  30827 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30830 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30834 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30838 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30838 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30841 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30843 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30845 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30850 */   // GIR_Coverage, 2726,
     /*  30850 */   GIR_EraseRootFromParent_Done,
     /*  30851 */ // Label 665: @30851
     /*  30851 */ GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(30883), // Rule ID 2775 //
     /*  30856 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30859 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  30862 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30866 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30870 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30870 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30873 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30875 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30877 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30882 */   // GIR_Coverage, 2775,
     /*  30882 */   GIR_EraseRootFromParent_Done,
     /*  30883 */ // Label 666: @30883
     /*  30883 */ GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(30915), // Rule ID 2776 //
     /*  30888 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30891 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  30894 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30898 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30902 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30902 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30905 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30907 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30909 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30914 */   // GIR_Coverage, 2776,
     /*  30914 */   GIR_EraseRootFromParent_Done,
     /*  30915 */ // Label 667: @30915
     /*  30915 */ GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(30947), // Rule ID 2777 //
     /*  30920 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30923 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30926 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30930 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30934 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30934 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30937 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30939 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30941 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30946 */   // GIR_Coverage, 2777,
     /*  30946 */   GIR_EraseRootFromParent_Done,
     /*  30947 */ // Label 668: @30947
     /*  30947 */ GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(30979), // Rule ID 2778 //
     /*  30952 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30955 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30958 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30962 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30966 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30966 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30969 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  30971 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  30973 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  30978 */   // GIR_Coverage, 2778,
     /*  30978 */   GIR_EraseRootFromParent_Done,
     /*  30979 */ // Label 669: @30979
     /*  30979 */ GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(31011), // Rule ID 2779 //
     /*  30984 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  30987 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  30990 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30994 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  30998 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
     /*  30998 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31001 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31003 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31005 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31010 */   // GIR_Coverage, 2779,
     /*  31010 */   GIR_EraseRootFromParent_Done,
     /*  31011 */ // Label 670: @31011
     /*  31011 */ GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(31043), // Rule ID 2780 //
     /*  31016 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  31019 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31022 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31026 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31030 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  31030 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31033 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31035 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31037 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31042 */   // GIR_Coverage, 2780,
     /*  31042 */   GIR_EraseRootFromParent_Done,
     /*  31043 */ // Label 671: @31043
     /*  31043 */ GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(31075), // Rule ID 2781 //
     /*  31048 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  31051 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31054 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31058 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31062 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  31062 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31065 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31067 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31069 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31074 */   // GIR_Coverage, 2781,
     /*  31074 */   GIR_EraseRootFromParent_Done,
     /*  31075 */ // Label 672: @31075
     /*  31075 */ GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(31107), // Rule ID 2782 //
     /*  31080 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  31083 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31086 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31090 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31094 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  31094 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31097 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31099 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31101 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31106 */   // GIR_Coverage, 2782,
     /*  31106 */   GIR_EraseRootFromParent_Done,
     /*  31107 */ // Label 673: @31107
     /*  31107 */ GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(31139), // Rule ID 2783 //
     /*  31112 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  31115 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31118 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31122 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31126 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  31126 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31129 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31131 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31133 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31138 */   // GIR_Coverage, 2783,
     /*  31138 */   GIR_EraseRootFromParent_Done,
     /*  31139 */ // Label 674: @31139
     /*  31139 */ GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(31171), // Rule ID 2784 //
     /*  31144 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  31147 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31150 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31154 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31158 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
     /*  31158 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31161 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31163 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31165 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  31170 */   // GIR_Coverage, 2784,
     /*  31170 */   GIR_EraseRootFromParent_Done,
     /*  31171 */ // Label 675: @31171
     /*  31171 */ GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(31208), // Rule ID 2847 //
     /*  31176 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31179 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31182 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31186 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31190 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
     /*  31190 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  31193 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31195 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31197 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31200 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31206 */   GIR_RootConstrainSelectedInstOperands,
     /*  31207 */   // GIR_Coverage, 2847,
     /*  31207 */   GIR_EraseRootFromParent_Done,
     /*  31208 */ // Label 676: @31208
     /*  31208 */ GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(31245), // Rule ID 2848 //
     /*  31213 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31216 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31219 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31223 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31227 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
     /*  31227 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  31230 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31232 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31234 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31237 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31243 */   GIR_RootConstrainSelectedInstOperands,
     /*  31244 */   // GIR_Coverage, 2848,
     /*  31244 */   GIR_EraseRootFromParent_Done,
     /*  31245 */ // Label 677: @31245
     /*  31245 */ GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(31282), // Rule ID 2849 //
     /*  31250 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31253 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31256 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31260 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31264 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
     /*  31264 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  31267 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31269 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31271 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31274 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31280 */   GIR_RootConstrainSelectedInstOperands,
     /*  31281 */   // GIR_Coverage, 2849,
     /*  31281 */   GIR_EraseRootFromParent_Done,
     /*  31282 */ // Label 678: @31282
     /*  31282 */ GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(31319), // Rule ID 2850 //
     /*  31287 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31290 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31293 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31297 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31301 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
     /*  31301 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  31304 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31306 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31308 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31311 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31317 */   GIR_RootConstrainSelectedInstOperands,
     /*  31318 */   // GIR_Coverage, 2850,
     /*  31318 */   GIR_EraseRootFromParent_Done,
     /*  31319 */ // Label 679: @31319
     /*  31319 */ GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(31356), // Rule ID 2851 //
     /*  31324 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31327 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31330 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31334 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31338 */   // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
     /*  31338 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
     /*  31341 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31343 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31345 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31348 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31354 */   GIR_RootConstrainSelectedInstOperands,
     /*  31355 */   // GIR_Coverage, 2851,
     /*  31355 */   GIR_EraseRootFromParent_Done,
     /*  31356 */ // Label 680: @31356
     /*  31356 */ GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(31393), // Rule ID 2852 //
     /*  31361 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31364 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31367 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31371 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31375 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
     /*  31375 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  31378 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31380 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31382 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31385 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31391 */   GIR_RootConstrainSelectedInstOperands,
     /*  31392 */   // GIR_Coverage, 2852,
     /*  31392 */   GIR_EraseRootFromParent_Done,
     /*  31393 */ // Label 681: @31393
     /*  31393 */ GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(31430), // Rule ID 2853 //
     /*  31398 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31401 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31404 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31408 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31412 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
     /*  31412 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
     /*  31415 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31417 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31419 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31422 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31428 */   GIR_RootConstrainSelectedInstOperands,
     /*  31429 */   // GIR_Coverage, 2853,
     /*  31429 */   GIR_EraseRootFromParent_Done,
     /*  31430 */ // Label 682: @31430
     /*  31430 */ GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(31467), // Rule ID 2854 //
     /*  31435 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31438 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31441 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31445 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31449 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
     /*  31449 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  31452 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31454 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31456 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31459 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31465 */   GIR_RootConstrainSelectedInstOperands,
     /*  31466 */   // GIR_Coverage, 2854,
     /*  31466 */   GIR_EraseRootFromParent_Done,
     /*  31467 */ // Label 683: @31467
     /*  31467 */ GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(31504), // Rule ID 2855 //
     /*  31472 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31475 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31478 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31482 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31486 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
     /*  31486 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  31489 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31491 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31493 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31496 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31502 */   GIR_RootConstrainSelectedInstOperands,
     /*  31503 */   // GIR_Coverage, 2855,
     /*  31503 */   GIR_EraseRootFromParent_Done,
     /*  31504 */ // Label 684: @31504
     /*  31504 */ GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(31541), // Rule ID 2856 //
     /*  31509 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  31512 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31515 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31519 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  31523 */   // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
     /*  31523 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
     /*  31526 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  31528 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31530 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  31533 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31539 */   GIR_RootConstrainSelectedInstOperands,
     /*  31540 */   // GIR_Coverage, 2856,
     /*  31540 */   GIR_EraseRootFromParent_Done,
     /*  31541 */ // Label 685: @31541
     /*  31541 */ GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(31573), // Rule ID 5282 //
     /*  31546 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  31549 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31552 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31556 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31560 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31560 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31563 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31565 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31567 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31572 */   // GIR_Coverage, 5282,
     /*  31572 */   GIR_EraseRootFromParent_Done,
     /*  31573 */ // Label 686: @31573
     /*  31573 */ GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(31605), // Rule ID 5283 //
     /*  31578 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  31581 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31584 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31588 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31592 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31592 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31595 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31597 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31599 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31604 */   // GIR_Coverage, 5283,
     /*  31604 */   GIR_EraseRootFromParent_Done,
     /*  31605 */ // Label 687: @31605
     /*  31605 */ GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(31637), // Rule ID 5296 //
     /*  31610 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31613 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31616 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31620 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31624 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31624 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31627 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31629 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31631 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31636 */   // GIR_Coverage, 5296,
     /*  31636 */   GIR_EraseRootFromParent_Done,
     /*  31637 */ // Label 688: @31637
     /*  31637 */ GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(31669), // Rule ID 5297 //
     /*  31642 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31645 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31648 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31652 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31656 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31656 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31659 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31661 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31663 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31668 */   // GIR_Coverage, 5297,
     /*  31668 */   GIR_EraseRootFromParent_Done,
     /*  31669 */ // Label 689: @31669
     /*  31669 */ GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(31701), // Rule ID 5298 //
     /*  31674 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31677 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31680 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31684 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31688 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31688 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31691 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31693 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31695 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31700 */   // GIR_Coverage, 5298,
     /*  31700 */   GIR_EraseRootFromParent_Done,
     /*  31701 */ // Label 690: @31701
     /*  31701 */ GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(31733), // Rule ID 5299 //
     /*  31706 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31709 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31712 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31716 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31720 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31720 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31723 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31725 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31727 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31732 */   // GIR_Coverage, 5299,
     /*  31732 */   GIR_EraseRootFromParent_Done,
     /*  31733 */ // Label 691: @31733
     /*  31733 */ GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(31765), // Rule ID 5300 //
     /*  31738 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31741 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31744 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31748 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31752 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
     /*  31752 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31755 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31757 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31759 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31764 */   // GIR_Coverage, 5300,
     /*  31764 */   GIR_EraseRootFromParent_Done,
     /*  31765 */ // Label 692: @31765
     /*  31765 */ GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(31797), // Rule ID 5301 //
     /*  31770 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31773 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31776 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31780 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31784 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31784 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31787 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31789 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31791 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31796 */   // GIR_Coverage, 5301,
     /*  31796 */   GIR_EraseRootFromParent_Done,
     /*  31797 */ // Label 693: @31797
     /*  31797 */ GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(31829), // Rule ID 5302 //
     /*  31802 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31805 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31808 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31812 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31816 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31816 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31819 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31821 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31823 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31828 */   // GIR_Coverage, 5302,
     /*  31828 */   GIR_EraseRootFromParent_Done,
     /*  31829 */ // Label 694: @31829
     /*  31829 */ GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(31861), // Rule ID 5303 //
     /*  31834 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31837 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31840 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31844 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31848 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31848 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31851 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31853 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31855 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31860 */   // GIR_Coverage, 5303,
     /*  31860 */   GIR_EraseRootFromParent_Done,
     /*  31861 */ // Label 695: @31861
     /*  31861 */ GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(31893), // Rule ID 5304 //
     /*  31866 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31869 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  31872 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31876 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31880 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31880 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31883 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31885 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31887 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31892 */   // GIR_Coverage, 5304,
     /*  31892 */   GIR_EraseRootFromParent_Done,
     /*  31893 */ // Label 696: @31893
     /*  31893 */ GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(31925), // Rule ID 5305 //
     /*  31898 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  31901 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31904 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31908 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31912 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
     /*  31912 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  31915 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  31917 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31919 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31924 */   // GIR_Coverage, 5305,
     /*  31924 */   GIR_EraseRootFromParent_Done,
     /*  31925 */ // Label 697: @31925
     /*  31925 */ GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(31983), // Rule ID 5332 //
     /*  31930 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  31933 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31936 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31940 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31944 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)
     /*  31944 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  31947 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  31951 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  31956 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  31959 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  31961 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  31963 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31966 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31972 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  31978 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  31981 */   GIR_RootConstrainSelectedInstOperands,
     /*  31982 */   // GIR_Coverage, 5332,
     /*  31982 */   GIR_EraseRootFromParent_Done,
     /*  31983 */ // Label 698: @31983
     /*  31983 */ GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(32041), // Rule ID 5333 //
     /*  31988 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  31991 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  31994 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  31998 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32002 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)
     /*  32002 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32005 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32009 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32014 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  32017 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32019 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32021 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32024 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32030 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32036 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32039 */   GIR_RootConstrainSelectedInstOperands,
     /*  32040 */   // GIR_Coverage, 5333,
     /*  32040 */   GIR_EraseRootFromParent_Done,
     /*  32041 */ // Label 699: @32041
     /*  32041 */ GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(32099), // Rule ID 5334 //
     /*  32046 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32049 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32052 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32056 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32060 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)
     /*  32060 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32063 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32067 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32072 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  32075 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32077 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32079 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32082 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32088 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32094 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32097 */   GIR_RootConstrainSelectedInstOperands,
     /*  32098 */   // GIR_Coverage, 5334,
     /*  32098 */   GIR_EraseRootFromParent_Done,
     /*  32099 */ // Label 700: @32099
     /*  32099 */ GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(32157), // Rule ID 5335 //
     /*  32104 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32107 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32110 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32114 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32118 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)
     /*  32118 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32121 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32125 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32130 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  32133 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32135 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32137 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32140 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32146 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32152 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32155 */   GIR_RootConstrainSelectedInstOperands,
     /*  32156 */   // GIR_Coverage, 5335,
     /*  32156 */   GIR_EraseRootFromParent_Done,
     /*  32157 */ // Label 701: @32157
     /*  32157 */ GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(32215), // Rule ID 5336 //
     /*  32162 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32165 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  32168 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32172 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32176 */   // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)
     /*  32176 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32179 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32183 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32188 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
     /*  32191 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32193 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32195 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32198 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32204 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32210 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32213 */   GIR_RootConstrainSelectedInstOperands,
     /*  32214 */   // GIR_Coverage, 5336,
     /*  32214 */   GIR_EraseRootFromParent_Done,
     /*  32215 */ // Label 702: @32215
     /*  32215 */ GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(32273), // Rule ID 5337 //
     /*  32220 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32223 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  32226 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32230 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32234 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)
     /*  32234 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32237 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32241 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32246 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  32249 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32251 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32253 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32256 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32262 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32268 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32271 */   GIR_RootConstrainSelectedInstOperands,
     /*  32272 */   // GIR_Coverage, 5337,
     /*  32272 */   GIR_EraseRootFromParent_Done,
     /*  32273 */ // Label 703: @32273
     /*  32273 */ GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(32331), // Rule ID 5338 //
     /*  32278 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32281 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  32284 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32288 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32292 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)
     /*  32292 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32295 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32299 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32304 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
     /*  32307 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32309 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32311 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32314 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32320 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32326 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32329 */   GIR_RootConstrainSelectedInstOperands,
     /*  32330 */   // GIR_Coverage, 5338,
     /*  32330 */   GIR_EraseRootFromParent_Done,
     /*  32331 */ // Label 704: @32331
     /*  32331 */ GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(32389), // Rule ID 5339 //
     /*  32336 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32339 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32342 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32346 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32350 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)
     /*  32350 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32353 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32357 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32362 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  32365 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32367 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32369 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32372 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32378 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32384 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32387 */   GIR_RootConstrainSelectedInstOperands,
     /*  32388 */   // GIR_Coverage, 5339,
     /*  32388 */   GIR_EraseRootFromParent_Done,
     /*  32389 */ // Label 705: @32389
     /*  32389 */ GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(32447), // Rule ID 5340 //
     /*  32394 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32397 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32400 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32404 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32408 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)
     /*  32408 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32411 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32415 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32420 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  32423 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32425 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32427 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32430 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32436 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32442 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32445 */   GIR_RootConstrainSelectedInstOperands,
     /*  32446 */   // GIR_Coverage, 5340,
     /*  32446 */   GIR_EraseRootFromParent_Done,
     /*  32447 */ // Label 706: @32447
     /*  32447 */ GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(32505), // Rule ID 5341 //
     /*  32452 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  32455 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  32458 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32462 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  32466 */   // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)
     /*  32466 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  32469 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  32473 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  32478 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
     /*  32481 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  32483 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32485 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32488 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32494 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32500 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  32503 */   GIR_RootConstrainSelectedInstOperands,
     /*  32504 */   // GIR_Coverage, 5341,
     /*  32504 */   GIR_EraseRootFromParent_Done,
     /*  32505 */ // Label 707: @32505
     /*  32505 */ GIM_Reject,
     /*  32506 */ // Label 546: @32506
     /*  32506 */ GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(32538), // Rule ID 2759 //
     /*  32511 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32514 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  32517 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32521 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32525 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32525 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32528 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32530 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32532 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32537 */   // GIR_Coverage, 2759,
     /*  32537 */   GIR_EraseRootFromParent_Done,
     /*  32538 */ // Label 708: @32538
     /*  32538 */ GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(32570), // Rule ID 2760 //
     /*  32543 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32546 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  32549 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32553 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32557 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32557 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32560 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32562 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32564 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32569 */   // GIR_Coverage, 2760,
     /*  32569 */   GIR_EraseRootFromParent_Done,
     /*  32570 */ // Label 709: @32570
     /*  32570 */ GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(32602), // Rule ID 2761 //
     /*  32575 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32578 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  32581 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32585 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32589 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32589 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32592 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32594 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32596 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32601 */   // GIR_Coverage, 2761,
     /*  32601 */   GIR_EraseRootFromParent_Done,
     /*  32602 */ // Label 710: @32602
     /*  32602 */ GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(32634), // Rule ID 2762 //
     /*  32607 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32610 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  32613 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32617 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32621 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32621 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32624 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32626 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32628 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32633 */   // GIR_Coverage, 2762,
     /*  32633 */   GIR_EraseRootFromParent_Done,
     /*  32634 */ // Label 711: @32634
     /*  32634 */ GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(32666), // Rule ID 2763 //
     /*  32639 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32642 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  32645 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32649 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32653 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32653 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32656 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32658 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32660 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32665 */   // GIR_Coverage, 2763,
     /*  32665 */   GIR_EraseRootFromParent_Done,
     /*  32666 */ // Label 712: @32666
     /*  32666 */ GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(32698), // Rule ID 2764 //
     /*  32671 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32674 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  32677 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32681 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32685 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
     /*  32685 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32688 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32690 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32692 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
     /*  32697 */   // GIR_Coverage, 2764,
     /*  32697 */   GIR_EraseRootFromParent_Done,
     /*  32698 */ // Label 713: @32698
     /*  32698 */ GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(32735), // Rule ID 2831 //
     /*  32703 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32706 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  32709 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32713 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32717 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
     /*  32717 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
     /*  32720 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32722 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32724 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32727 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32733 */   GIR_RootConstrainSelectedInstOperands,
     /*  32734 */   // GIR_Coverage, 2831,
     /*  32734 */   GIR_EraseRootFromParent_Done,
     /*  32735 */ // Label 714: @32735
     /*  32735 */ GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(32772), // Rule ID 2832 //
     /*  32740 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32743 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  32746 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32750 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32754 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
     /*  32754 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
     /*  32757 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32759 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32761 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32764 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32770 */   GIR_RootConstrainSelectedInstOperands,
     /*  32771 */   // GIR_Coverage, 2832,
     /*  32771 */   GIR_EraseRootFromParent_Done,
     /*  32772 */ // Label 715: @32772
     /*  32772 */ GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(32809), // Rule ID 2833 //
     /*  32777 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32780 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  32783 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32787 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32791 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
     /*  32791 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
     /*  32794 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32796 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32798 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32801 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32807 */   GIR_RootConstrainSelectedInstOperands,
     /*  32808 */   // GIR_Coverage, 2833,
     /*  32808 */   GIR_EraseRootFromParent_Done,
     /*  32809 */ // Label 716: @32809
     /*  32809 */ GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(32846), // Rule ID 2834 //
     /*  32814 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32817 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  32820 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32824 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32828 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
     /*  32828 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
     /*  32831 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32833 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32835 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32838 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32844 */   GIR_RootConstrainSelectedInstOperands,
     /*  32845 */   // GIR_Coverage, 2834,
     /*  32845 */   GIR_EraseRootFromParent_Done,
     /*  32846 */ // Label 717: @32846
     /*  32846 */ GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(32883), // Rule ID 2835 //
     /*  32851 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32854 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  32857 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32861 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32865 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
     /*  32865 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
     /*  32868 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32870 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32872 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32875 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32881 */   GIR_RootConstrainSelectedInstOperands,
     /*  32882 */   // GIR_Coverage, 2835,
     /*  32882 */   GIR_EraseRootFromParent_Done,
     /*  32883 */ // Label 718: @32883
     /*  32883 */ GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(32920), // Rule ID 2836 //
     /*  32888 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  32891 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  32894 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32898 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
     /*  32902 */   // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
     /*  32902 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
     /*  32905 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  32907 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32909 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  32912 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  32918 */   GIR_RootConstrainSelectedInstOperands,
     /*  32919 */   // GIR_Coverage, 2836,
     /*  32919 */   GIR_EraseRootFromParent_Done,
     /*  32920 */ // Label 719: @32920
     /*  32920 */ GIM_Reject,
     /*  32921 */ // Label 547: @32921
     /*  32921 */ GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(32953), // Rule ID 2727 //
     /*  32926 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32929 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32932 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  32936 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  32940 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  32940 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32943 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32945 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32947 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  32952 */   // GIR_Coverage, 2727,
     /*  32952 */   GIR_EraseRootFromParent_Done,
     /*  32953 */ // Label 720: @32953
     /*  32953 */ GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(32985), // Rule ID 2728 //
     /*  32958 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
     /*  32961 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  32964 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  32968 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  32972 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  32972 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  32975 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  32977 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  32979 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  32984 */   // GIR_Coverage, 2728,
     /*  32984 */   GIR_EraseRootFromParent_Done,
     /*  32985 */ // Label 721: @32985
     /*  32985 */ GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(33017), // Rule ID 2785 //
     /*  32990 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  32993 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  32996 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33000 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33004 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  33004 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33007 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33009 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33011 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33016 */   // GIR_Coverage, 2785,
     /*  33016 */   GIR_EraseRootFromParent_Done,
     /*  33017 */ // Label 722: @33017
     /*  33017 */ GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(33049), // Rule ID 2786 //
     /*  33022 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33025 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33028 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33032 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33036 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  33036 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33039 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33041 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33043 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33048 */   // GIR_Coverage, 2786,
     /*  33048 */   GIR_EraseRootFromParent_Done,
     /*  33049 */ // Label 723: @33049
     /*  33049 */ GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(33081), // Rule ID 2787 //
     /*  33054 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33057 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33060 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33064 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33068 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  33068 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33071 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33073 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33075 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33080 */   // GIR_Coverage, 2787,
     /*  33080 */   GIR_EraseRootFromParent_Done,
     /*  33081 */ // Label 724: @33081
     /*  33081 */ GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(33113), // Rule ID 2788 //
     /*  33086 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33089 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33092 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33096 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33100 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  33100 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33103 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33105 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33107 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33112 */   // GIR_Coverage, 2788,
     /*  33112 */   GIR_EraseRootFromParent_Done,
     /*  33113 */ // Label 725: @33113
     /*  33113 */ GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(33145), // Rule ID 2789 //
     /*  33118 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33121 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  33124 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33128 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33132 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
     /*  33132 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33135 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33137 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33139 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33144 */   // GIR_Coverage, 2789,
     /*  33144 */   GIR_EraseRootFromParent_Done,
     /*  33145 */ // Label 726: @33145
     /*  33145 */ GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(33177), // Rule ID 2790 //
     /*  33150 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33153 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33156 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33160 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33164 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  33164 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33167 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33169 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33171 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33176 */   // GIR_Coverage, 2790,
     /*  33176 */   GIR_EraseRootFromParent_Done,
     /*  33177 */ // Label 727: @33177
     /*  33177 */ GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(33209), // Rule ID 2791 //
     /*  33182 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33185 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33188 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33192 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33196 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  33196 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33199 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33201 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33203 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33208 */   // GIR_Coverage, 2791,
     /*  33208 */   GIR_EraseRootFromParent_Done,
     /*  33209 */ // Label 728: @33209
     /*  33209 */ GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(33241), // Rule ID 2792 //
     /*  33214 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33217 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33220 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33224 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33228 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  33228 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33231 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33233 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33235 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33240 */   // GIR_Coverage, 2792,
     /*  33240 */   GIR_EraseRootFromParent_Done,
     /*  33241 */ // Label 729: @33241
     /*  33241 */ GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(33273), // Rule ID 2793 //
     /*  33246 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33249 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33252 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33256 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33260 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  33260 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33263 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33265 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33267 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33272 */   // GIR_Coverage, 2793,
     /*  33272 */   GIR_EraseRootFromParent_Done,
     /*  33273 */ // Label 730: @33273
     /*  33273 */ GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(33305), // Rule ID 2794 //
     /*  33278 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  33281 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  33284 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33288 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33292 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
     /*  33292 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33295 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33297 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33299 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  33304 */   // GIR_Coverage, 2794,
     /*  33304 */   GIR_EraseRootFromParent_Done,
     /*  33305 */ // Label 731: @33305
     /*  33305 */ GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(33342), // Rule ID 2857 //
     /*  33310 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33313 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33316 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33320 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33324 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
     /*  33324 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  33327 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33329 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33331 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33334 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33340 */   GIR_RootConstrainSelectedInstOperands,
     /*  33341 */   // GIR_Coverage, 2857,
     /*  33341 */   GIR_EraseRootFromParent_Done,
     /*  33342 */ // Label 732: @33342
     /*  33342 */ GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(33379), // Rule ID 2858 //
     /*  33347 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33350 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33353 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33357 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33361 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
     /*  33361 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  33364 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33366 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33368 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33371 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33377 */   GIR_RootConstrainSelectedInstOperands,
     /*  33378 */   // GIR_Coverage, 2858,
     /*  33378 */   GIR_EraseRootFromParent_Done,
     /*  33379 */ // Label 733: @33379
     /*  33379 */ GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(33416), // Rule ID 2859 //
     /*  33384 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33387 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33390 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33394 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33398 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
     /*  33398 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  33401 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33403 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33405 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33408 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33414 */   GIR_RootConstrainSelectedInstOperands,
     /*  33415 */   // GIR_Coverage, 2859,
     /*  33415 */   GIR_EraseRootFromParent_Done,
     /*  33416 */ // Label 734: @33416
     /*  33416 */ GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(33453), // Rule ID 2860 //
     /*  33421 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33424 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33427 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33431 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33435 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
     /*  33435 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  33438 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33440 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33442 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33445 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33451 */   GIR_RootConstrainSelectedInstOperands,
     /*  33452 */   // GIR_Coverage, 2860,
     /*  33452 */   GIR_EraseRootFromParent_Done,
     /*  33453 */ // Label 735: @33453
     /*  33453 */ GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(33490), // Rule ID 2861 //
     /*  33458 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33461 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  33464 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33468 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33472 */   // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
     /*  33472 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
     /*  33475 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33477 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33479 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33482 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33488 */   GIR_RootConstrainSelectedInstOperands,
     /*  33489 */   // GIR_Coverage, 2861,
     /*  33489 */   GIR_EraseRootFromParent_Done,
     /*  33490 */ // Label 736: @33490
     /*  33490 */ GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(33527), // Rule ID 2862 //
     /*  33495 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33498 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33501 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33505 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33509 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
     /*  33509 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  33512 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33514 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33516 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33519 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33525 */   GIR_RootConstrainSelectedInstOperands,
     /*  33526 */   // GIR_Coverage, 2862,
     /*  33526 */   GIR_EraseRootFromParent_Done,
     /*  33527 */ // Label 737: @33527
     /*  33527 */ GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(33564), // Rule ID 2863 //
     /*  33532 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33535 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33538 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33542 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33546 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
     /*  33546 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
     /*  33549 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33551 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33553 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33556 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33562 */   GIR_RootConstrainSelectedInstOperands,
     /*  33563 */   // GIR_Coverage, 2863,
     /*  33563 */   GIR_EraseRootFromParent_Done,
     /*  33564 */ // Label 738: @33564
     /*  33564 */ GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(33601), // Rule ID 2864 //
     /*  33569 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33572 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33575 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33579 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33583 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
     /*  33583 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  33586 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33588 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33590 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33593 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33599 */   GIR_RootConstrainSelectedInstOperands,
     /*  33600 */   // GIR_Coverage, 2864,
     /*  33600 */   GIR_EraseRootFromParent_Done,
     /*  33601 */ // Label 739: @33601
     /*  33601 */ GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(33638), // Rule ID 2865 //
     /*  33606 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33609 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33612 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33616 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33620 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
     /*  33620 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
     /*  33623 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33625 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33627 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33630 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33636 */   GIR_RootConstrainSelectedInstOperands,
     /*  33637 */   // GIR_Coverage, 2865,
     /*  33637 */   GIR_EraseRootFromParent_Done,
     /*  33638 */ // Label 740: @33638
     /*  33638 */ GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(33675), // Rule ID 2866 //
     /*  33643 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  33646 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  33649 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33653 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  33657 */   // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
     /*  33657 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
     /*  33660 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  33662 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33664 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  33667 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  33673 */   GIR_RootConstrainSelectedInstOperands,
     /*  33674 */   // GIR_Coverage, 2866,
     /*  33674 */   GIR_EraseRootFromParent_Done,
     /*  33675 */ // Label 741: @33675
     /*  33675 */ GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(33707), // Rule ID 5284 //
     /*  33680 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  33683 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  33686 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33690 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33694 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  33694 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33697 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33699 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33701 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33706 */   // GIR_Coverage, 5284,
     /*  33706 */   GIR_EraseRootFromParent_Done,
     /*  33707 */ // Label 742: @33707
     /*  33707 */ GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(33739), // Rule ID 5285 //
     /*  33712 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
     /*  33715 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  33718 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33722 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33726 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33726 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33729 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33731 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33733 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33738 */   // GIR_Coverage, 5285,
     /*  33738 */   GIR_EraseRootFromParent_Done,
     /*  33739 */ // Label 743: @33739
     /*  33739 */ GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(33771), // Rule ID 5306 //
     /*  33744 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33747 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33750 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33754 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33758 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33758 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33761 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33763 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33765 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33770 */   // GIR_Coverage, 5306,
     /*  33770 */   GIR_EraseRootFromParent_Done,
     /*  33771 */ // Label 744: @33771
     /*  33771 */ GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(33803), // Rule ID 5307 //
     /*  33776 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33779 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33782 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33786 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33790 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33790 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33793 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33795 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33797 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33802 */   // GIR_Coverage, 5307,
     /*  33802 */   GIR_EraseRootFromParent_Done,
     /*  33803 */ // Label 745: @33803
     /*  33803 */ GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(33835), // Rule ID 5308 //
     /*  33808 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33811 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33814 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33818 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33822 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33822 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33825 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33827 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33829 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33834 */   // GIR_Coverage, 5308,
     /*  33834 */   GIR_EraseRootFromParent_Done,
     /*  33835 */ // Label 746: @33835
     /*  33835 */ GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(33867), // Rule ID 5309 //
     /*  33840 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33843 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33846 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33850 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33854 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33854 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33857 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33859 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33861 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33866 */   // GIR_Coverage, 5309,
     /*  33866 */   GIR_EraseRootFromParent_Done,
     /*  33867 */ // Label 747: @33867
     /*  33867 */ GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(33899), // Rule ID 5310 //
     /*  33872 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33875 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  33878 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33882 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33886 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
     /*  33886 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33889 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33891 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33893 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33898 */   // GIR_Coverage, 5310,
     /*  33898 */   GIR_EraseRootFromParent_Done,
     /*  33899 */ // Label 748: @33899
     /*  33899 */ GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(33931), // Rule ID 5311 //
     /*  33904 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33907 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33910 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33914 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33918 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  33918 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33921 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33923 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33925 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33930 */   // GIR_Coverage, 5311,
     /*  33930 */   GIR_EraseRootFromParent_Done,
     /*  33931 */ // Label 749: @33931
     /*  33931 */ GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(33963), // Rule ID 5312 //
     /*  33936 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33939 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  33942 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33946 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33950 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  33950 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33953 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33955 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33957 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33962 */   // GIR_Coverage, 5312,
     /*  33962 */   GIR_EraseRootFromParent_Done,
     /*  33963 */ // Label 750: @33963
     /*  33963 */ GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(33995), // Rule ID 5313 //
     /*  33968 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  33971 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33974 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33978 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33982 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  33982 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  33985 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  33987 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  33989 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  33994 */   // GIR_Coverage, 5313,
     /*  33994 */   GIR_EraseRootFromParent_Done,
     /*  33995 */ // Label 751: @33995
     /*  33995 */ GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(34027), // Rule ID 5314 //
     /*  34000 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  34003 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34006 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34010 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34014 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  34014 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34017 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34019 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34021 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34026 */   // GIR_Coverage, 5314,
     /*  34026 */   GIR_EraseRootFromParent_Done,
     /*  34027 */ // Label 752: @34027
     /*  34027 */ GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(34059), // Rule ID 5315 //
     /*  34032 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  34035 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  34038 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34042 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34046 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
     /*  34046 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34049 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34051 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34053 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34058 */   // GIR_Coverage, 5315,
     /*  34058 */   GIR_EraseRootFromParent_Done,
     /*  34059 */ // Label 753: @34059
     /*  34059 */ GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(34117), // Rule ID 5342 //
     /*  34064 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34067 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34070 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34074 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34078 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)
     /*  34078 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34081 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34085 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34090 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  34093 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34095 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34097 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34100 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34106 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34112 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34115 */   GIR_RootConstrainSelectedInstOperands,
     /*  34116 */   // GIR_Coverage, 5342,
     /*  34116 */   GIR_EraseRootFromParent_Done,
     /*  34117 */ // Label 754: @34117
     /*  34117 */ GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(34175), // Rule ID 5343 //
     /*  34122 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34125 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34128 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34132 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34136 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)
     /*  34136 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34139 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34143 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34148 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  34151 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34153 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34155 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34158 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34164 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34170 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34173 */   GIR_RootConstrainSelectedInstOperands,
     /*  34174 */   // GIR_Coverage, 5343,
     /*  34174 */   GIR_EraseRootFromParent_Done,
     /*  34175 */ // Label 755: @34175
     /*  34175 */ GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(34233), // Rule ID 5344 //
     /*  34180 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34183 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34186 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34190 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34194 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)
     /*  34194 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34197 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34201 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34206 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  34209 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34211 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34213 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34216 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34222 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34228 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34231 */   GIR_RootConstrainSelectedInstOperands,
     /*  34232 */   // GIR_Coverage, 5344,
     /*  34232 */   GIR_EraseRootFromParent_Done,
     /*  34233 */ // Label 756: @34233
     /*  34233 */ GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(34291), // Rule ID 5345 //
     /*  34238 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34241 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34244 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34248 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34252 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)
     /*  34252 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34255 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34259 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34264 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  34267 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34269 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34271 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34274 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34280 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34286 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34289 */   GIR_RootConstrainSelectedInstOperands,
     /*  34290 */   // GIR_Coverage, 5345,
     /*  34290 */   GIR_EraseRootFromParent_Done,
     /*  34291 */ // Label 757: @34291
     /*  34291 */ GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(34349), // Rule ID 5346 //
     /*  34296 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34299 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  34302 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34306 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34310 */   // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)
     /*  34310 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34313 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34317 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34322 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
     /*  34325 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34327 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34329 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34332 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34338 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34344 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34347 */   GIR_RootConstrainSelectedInstOperands,
     /*  34348 */   // GIR_Coverage, 5346,
     /*  34348 */   GIR_EraseRootFromParent_Done,
     /*  34349 */ // Label 758: @34349
     /*  34349 */ GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(34407), // Rule ID 5347 //
     /*  34354 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34357 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34360 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34364 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34368 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)
     /*  34368 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34371 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34375 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34380 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  34383 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34385 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34387 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34390 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34396 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34402 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34405 */   GIR_RootConstrainSelectedInstOperands,
     /*  34406 */   // GIR_Coverage, 5347,
     /*  34406 */   GIR_EraseRootFromParent_Done,
     /*  34407 */ // Label 759: @34407
     /*  34407 */ GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(34465), // Rule ID 5348 //
     /*  34412 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34415 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34418 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34422 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34426 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)
     /*  34426 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34429 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34433 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34438 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
     /*  34441 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34443 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34445 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34448 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34454 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34460 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34463 */   GIR_RootConstrainSelectedInstOperands,
     /*  34464 */   // GIR_Coverage, 5348,
     /*  34464 */   GIR_EraseRootFromParent_Done,
     /*  34465 */ // Label 760: @34465
     /*  34465 */ GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(34523), // Rule ID 5349 //
     /*  34470 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34473 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34476 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34480 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34484 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)
     /*  34484 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34487 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34491 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34496 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  34499 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34501 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34503 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34506 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34512 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34518 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34521 */   GIR_RootConstrainSelectedInstOperands,
     /*  34522 */   // GIR_Coverage, 5349,
     /*  34522 */   GIR_EraseRootFromParent_Done,
     /*  34523 */ // Label 761: @34523
     /*  34523 */ GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(34581), // Rule ID 5350 //
     /*  34528 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34531 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34534 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34538 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34542 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)
     /*  34542 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34545 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34549 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34554 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
     /*  34557 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34559 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34561 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34564 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34570 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34576 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34579 */   GIR_RootConstrainSelectedInstOperands,
     /*  34580 */   // GIR_Coverage, 5350,
     /*  34580 */   GIR_EraseRootFromParent_Done,
     /*  34581 */ // Label 762: @34581
     /*  34581 */ GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(34639), // Rule ID 5351 //
     /*  34586 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  34589 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  34592 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34596 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  34600 */   // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)
     /*  34600 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  34603 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  34607 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  34612 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
     /*  34615 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  34617 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34619 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34622 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34628 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34634 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  34637 */   GIR_RootConstrainSelectedInstOperands,
     /*  34638 */   // GIR_Coverage, 5351,
     /*  34638 */   GIR_EraseRootFromParent_Done,
     /*  34639 */ // Label 763: @34639
     /*  34639 */ GIM_Reject,
     /*  34640 */ // Label 548: @34640
     /*  34640 */ GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(34672), // Rule ID 2795 //
     /*  34645 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34648 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34651 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34655 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34659 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34659 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34662 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34664 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34666 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34671 */   // GIR_Coverage, 2795,
     /*  34671 */   GIR_EraseRootFromParent_Done,
     /*  34672 */ // Label 764: @34672
     /*  34672 */ GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(34704), // Rule ID 2796 //
     /*  34677 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34680 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34683 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34687 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34691 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34691 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34694 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34696 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34698 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34703 */   // GIR_Coverage, 2796,
     /*  34703 */   GIR_EraseRootFromParent_Done,
     /*  34704 */ // Label 765: @34704
     /*  34704 */ GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(34736), // Rule ID 2797 //
     /*  34709 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34712 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34715 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34719 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34723 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34723 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34726 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34728 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34730 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34735 */   // GIR_Coverage, 2797,
     /*  34735 */   GIR_EraseRootFromParent_Done,
     /*  34736 */ // Label 766: @34736
     /*  34736 */ GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(34768), // Rule ID 2798 //
     /*  34741 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34744 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34747 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34751 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34755 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34755 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34758 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34760 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34762 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34767 */   // GIR_Coverage, 2798,
     /*  34767 */   GIR_EraseRootFromParent_Done,
     /*  34768 */ // Label 767: @34768
     /*  34768 */ GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(34800), // Rule ID 2799 //
     /*  34773 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34776 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34779 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34783 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34787 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34787 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34790 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34792 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34794 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34799 */   // GIR_Coverage, 2799,
     /*  34799 */   GIR_EraseRootFromParent_Done,
     /*  34800 */ // Label 768: @34800
     /*  34800 */ GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(34832), // Rule ID 2800 //
     /*  34805 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
     /*  34808 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34811 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34815 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34819 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
     /*  34819 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  34822 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  34824 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34826 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
     /*  34831 */   // GIR_Coverage, 2800,
     /*  34831 */   GIR_EraseRootFromParent_Done,
     /*  34832 */ // Label 769: @34832
     /*  34832 */ GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(34869), // Rule ID 2867 //
     /*  34837 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  34840 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34843 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34847 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34851 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
     /*  34851 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
     /*  34854 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  34856 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34858 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  34861 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34867 */   GIR_RootConstrainSelectedInstOperands,
     /*  34868 */   // GIR_Coverage, 2867,
     /*  34868 */   GIR_EraseRootFromParent_Done,
     /*  34869 */ // Label 770: @34869
     /*  34869 */ GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(34906), // Rule ID 2868 //
     /*  34874 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  34877 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  34880 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34884 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34888 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
     /*  34888 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
     /*  34891 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  34893 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34895 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  34898 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34904 */   GIR_RootConstrainSelectedInstOperands,
     /*  34905 */   // GIR_Coverage, 2868,
     /*  34905 */   GIR_EraseRootFromParent_Done,
     /*  34906 */ // Label 771: @34906
     /*  34906 */ GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(34943), // Rule ID 2869 //
     /*  34911 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  34914 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34917 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34921 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34925 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
     /*  34925 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
     /*  34928 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  34930 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34932 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  34935 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34941 */   GIR_RootConstrainSelectedInstOperands,
     /*  34942 */   // GIR_Coverage, 2869,
     /*  34942 */   GIR_EraseRootFromParent_Done,
     /*  34943 */ // Label 772: @34943
     /*  34943 */ GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(34980), // Rule ID 2870 //
     /*  34948 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  34951 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34954 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34958 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34962 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
     /*  34962 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
     /*  34965 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  34967 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  34969 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  34972 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  34978 */   GIR_RootConstrainSelectedInstOperands,
     /*  34979 */   // GIR_Coverage, 2870,
     /*  34979 */   GIR_EraseRootFromParent_Done,
     /*  34980 */ // Label 773: @34980
     /*  34980 */ GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(35017), // Rule ID 2871 //
     /*  34985 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  34988 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  34991 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34995 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  34999 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
     /*  34999 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
     /*  35002 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  35004 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35006 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  35009 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35015 */   GIR_RootConstrainSelectedInstOperands,
     /*  35016 */   // GIR_Coverage, 2871,
     /*  35016 */   GIR_EraseRootFromParent_Done,
     /*  35017 */ // Label 774: @35017
     /*  35017 */ GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(35054), // Rule ID 2872 //
     /*  35022 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
     /*  35025 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  35028 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  35032 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
     /*  35036 */   // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
     /*  35036 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
     /*  35039 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
     /*  35041 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35043 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*  35046 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35052 */   GIR_RootConstrainSelectedInstOperands,
     /*  35053 */   // GIR_Coverage, 2872,
     /*  35053 */   GIR_EraseRootFromParent_Done,
     /*  35054 */ // Label 775: @35054
     /*  35054 */ GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(35086), // Rule ID 5316 //
     /*  35059 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35062 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  35065 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35069 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35073 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35073 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35076 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35078 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35080 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35085 */   // GIR_Coverage, 5316,
     /*  35085 */   GIR_EraseRootFromParent_Done,
     /*  35086 */ // Label 776: @35086
     /*  35086 */ GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(35118), // Rule ID 5317 //
     /*  35091 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35094 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  35097 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35101 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35105 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35105 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35108 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35110 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35112 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35117 */   // GIR_Coverage, 5317,
     /*  35117 */   GIR_EraseRootFromParent_Done,
     /*  35118 */ // Label 777: @35118
     /*  35118 */ GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(35150), // Rule ID 5318 //
     /*  35123 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35126 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35129 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35133 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35137 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35137 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35140 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35142 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35144 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35149 */   // GIR_Coverage, 5318,
     /*  35149 */   GIR_EraseRootFromParent_Done,
     /*  35150 */ // Label 778: @35150
     /*  35150 */ GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(35182), // Rule ID 5319 //
     /*  35155 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35158 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35161 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35165 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35169 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35169 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35172 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35174 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35176 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35181 */   // GIR_Coverage, 5319,
     /*  35181 */   GIR_EraseRootFromParent_Done,
     /*  35182 */ // Label 779: @35182
     /*  35182 */ GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(35214), // Rule ID 5320 //
     /*  35187 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35190 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  35193 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35197 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35201 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35201 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35204 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35206 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35208 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35213 */   // GIR_Coverage, 5320,
     /*  35213 */   GIR_EraseRootFromParent_Done,
     /*  35214 */ // Label 780: @35214
     /*  35214 */ GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(35246), // Rule ID 5321 //
     /*  35219 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
     /*  35222 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  35225 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35229 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35233 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
     /*  35233 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35236 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /*  35238 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35240 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35245 */   // GIR_Coverage, 5321,
     /*  35245 */   GIR_EraseRootFromParent_Done,
     /*  35246 */ // Label 781: @35246
     /*  35246 */ GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(35304), // Rule ID 5352 //
     /*  35251 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35254 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  35257 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35261 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35265 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)
     /*  35265 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35268 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35272 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35277 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
     /*  35280 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35282 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35284 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35287 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35293 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35299 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35302 */   GIR_RootConstrainSelectedInstOperands,
     /*  35303 */   // GIR_Coverage, 5352,
     /*  35303 */   GIR_EraseRootFromParent_Done,
     /*  35304 */ // Label 782: @35304
     /*  35304 */ GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(35362), // Rule ID 5353 //
     /*  35309 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35312 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  35315 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35319 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35323 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)
     /*  35323 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35326 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35330 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35335 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
     /*  35338 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35340 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35342 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35345 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35351 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35357 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35360 */   GIR_RootConstrainSelectedInstOperands,
     /*  35361 */   // GIR_Coverage, 5353,
     /*  35361 */   GIR_EraseRootFromParent_Done,
     /*  35362 */ // Label 783: @35362
     /*  35362 */ GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(35420), // Rule ID 5354 //
     /*  35367 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35370 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35373 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35377 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35381 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)
     /*  35381 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35384 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35388 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35393 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
     /*  35396 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35398 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35400 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35403 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35409 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35415 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35418 */   GIR_RootConstrainSelectedInstOperands,
     /*  35419 */   // GIR_Coverage, 5354,
     /*  35419 */   GIR_EraseRootFromParent_Done,
     /*  35420 */ // Label 784: @35420
     /*  35420 */ GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(35478), // Rule ID 5355 //
     /*  35425 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35428 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35431 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35435 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35439 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)
     /*  35439 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35442 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35446 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35451 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
     /*  35454 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35456 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35458 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35461 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35467 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35473 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35476 */   GIR_RootConstrainSelectedInstOperands,
     /*  35477 */   // GIR_Coverage, 5355,
     /*  35477 */   GIR_EraseRootFromParent_Done,
     /*  35478 */ // Label 785: @35478
     /*  35478 */ GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(35536), // Rule ID 5356 //
     /*  35483 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35486 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  35489 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35493 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35497 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)
     /*  35497 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35500 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35504 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35509 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
     /*  35512 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35514 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35516 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35519 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35525 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35531 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35534 */   GIR_RootConstrainSelectedInstOperands,
     /*  35535 */   // GIR_Coverage, 5356,
     /*  35535 */   GIR_EraseRootFromParent_Done,
     /*  35536 */ // Label 786: @35536
     /*  35536 */ GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(35594), // Rule ID 5357 //
     /*  35541 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
     /*  35544 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  35547 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35551 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
     /*  35555 */   // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)
     /*  35555 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
     /*  35558 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35562 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35567 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
     /*  35570 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
     /*  35572 */   GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  35574 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35577 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35583 */   GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
     /*  35589 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  35592 */   GIR_RootConstrainSelectedInstOperands,
     /*  35593 */   // GIR