
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_wp14.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_wp14::OOXMLFactory_wp14()
{
}

OOXMLFactory_wp14::~OOXMLFactory_wp14()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_wp14::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_wp14::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_wp14();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_wp14::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_wp14|DEFINE_CT_SizeRelH:
        {
            const static AttributeInfo info[] = {
                { oox::XML_relativeFrom, ResourceType::List, NN_wp14|DEFINE_ST_SizeRelFromH },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_wp14|DEFINE_CT_SizeRelV:
        {
            const static AttributeInfo info[] = {
                { oox::XML_relativeFrom, ResourceType::List, NN_wp14|DEFINE_ST_SizeRelFromV },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_wp14::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_wp14|DEFINE_ST_SizeRelFromH:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'i':
            if (aValue == "insideMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_insideMargin; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "leftMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_leftMargin; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "margin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_margin; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "outsideMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_outsideMargin; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "page") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_page; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "rightMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromH_rightMargin; }
            else { return false; }
            return true;
        }
        return false;
    case NN_wp14|DEFINE_ST_SizeRelFromV:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bottomMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_bottomMargin; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "insideMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_insideMargin; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "margin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_margin; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "outsideMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_outsideMargin; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "page") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_page; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "topMargin") { rOutValue = NS_ooxml::LN_ST_SizeRelFromV_topMargin; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_wp14::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_wp14|DEFINE_CT_SizeRelH:
        switch (nId)
        {
        case oox::NMSP_wp14|oox::XML_pctWidth: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_ST_PositivePercentage; break;
        default: return false;
        }
        return true;
    case NN_wp14|DEFINE_CT_SizeRelV:
        switch (nId)
        {
        case oox::NMSP_wp14|oox::XML_pctHeight: rOutResource = ResourceType::Value; rOutElement = NN_dml_baseTypes|DEFINE_ST_PositivePercentage; break;
        default: return false;
        }
        return true;
    case NN_wp14|DEFINE_sizeRelH:
        switch (nId)
        {
        case oox::NMSP_wp14|oox::XML_sizeRelH: rOutResource = ResourceType::Properties; rOutElement = NN_wp14|DEFINE_CT_SizeRelH; break;
        default: return false;
        }
        return true;
    case NN_wp14|DEFINE_sizeRelV:
        switch (nId)
        {
        case oox::NMSP_wp14|oox::XML_sizeRelV: rOutResource = ResourceType::Properties; rOutElement = NN_wp14|DEFINE_CT_SizeRelV; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        /* start: sizeRelH*/
        case oox::NMSP_wp14|oox::XML_sizeRelH: rOutResource = ResourceType::Properties; rOutElement = NN_wp14|DEFINE_CT_SizeRelH; break;
        /* start: sizeRelV*/
        case oox::NMSP_wp14|oox::XML_sizeRelV: rOutResource = ResourceType::Properties; rOutElement = NN_wp14|DEFINE_CT_SizeRelV; break;
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_wp14::charactersAction(OOXMLFastContextHandler*, const OUString&)
{
}

Id OOXMLFactory_wp14::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_wp14|DEFINE_CT_SizeRelH:
        switch (nToken)
        {
        case oox::NMSP_wp14|oox::XML_pctWidth: return NS_ooxml::LN_CT_SizeRelH_pctWidth;
        case oox::XML_relativeFrom: return NS_ooxml::LN_CT_SizeRelH_relativeFrom;
        }
        break;
    case NN_wp14|DEFINE_CT_SizeRelV:
        switch (nToken)
        {
        case oox::NMSP_wp14|oox::XML_pctHeight: return NS_ooxml::LN_CT_SizeRelV_pctHeight;
        case oox::XML_relativeFrom: return NS_ooxml::LN_CT_SizeRelV_relativeFrom;
        }
        break;
    case NN_wp14|DEFINE_sizeRelH:
        switch (nToken)
        {
        case oox::NMSP_wp14|oox::XML_sizeRelH: return NS_ooxml::LN_sizeRelH_sizeRelH;
        }
        break;
    case NN_wp14|DEFINE_sizeRelV:
        switch (nToken)
        {
        case oox::NMSP_wp14|oox::XML_sizeRelV: return NS_ooxml::LN_sizeRelV_sizeRelV;
        }
        break;
    default:
        switch (nToken)
        {
        case oox::NMSP_wp14|oox::XML_sizeRelH: return NS_ooxml::LN_sizeRelH_sizeRelH;
        case oox::NMSP_wp14|oox::XML_sizeRelV: return NS_ooxml::LN_sizeRelV_sizeRelV;
        }
        break;
    }
    return 0;
}

void OOXMLFactory_wp14::attributeAction(OOXMLFastContextHandler*, Token_t, const OOXMLValue&)
{
}

/// @endcond
}}
