#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x0073";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0070\x0061\x006e\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x004e\x0049";
static constexpr OUStringLiteral countryDefaultName = u"\x004e\x0069\x0063\x0061\x0072\x0061\x0067\x0075\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_es_NI(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_es_GT(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_es_NI(sal_Int16& count)
{
	return getLocaleItem_es_GT(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x43, 0x24, 0x2d, 0x34, 0x43, 0x30, 0x41, 0x5d, 0x20, 0x0};
extern OUString const * getAllFormats0_es_GT(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_es_NI(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_es_GT(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_es_GT(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_es_NI(sal_Int16& count)
{
	return getDateAcceptancePatterns_es_GT(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_es_NI(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_es_NI(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_es_NI(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_es_NI(sal_Int16& count)
{
	return getIndexAlgorithm_es_ES(count);
}
extern const OUString *  getUnicodeScripts_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_es_NI(sal_Int16& count)
{
	return getUnicodeScripts_es_ES(count);
}
extern const OUString *  getFollowPageWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_es_NI(sal_Int16& count)
{
	return getFollowPageWords_es_ES(count);
}
extern const OUString *  getAllCalendars_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_es_NI(sal_Int16& count)
{
	return getAllCalendars_es_AR(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x004e\x0049\x004f";
static constexpr OUStringLiteral currencySymbol0 = u"\x0043\x0024";
static constexpr OUStringLiteral bankSymbol0 = u"\x004e\x0049\x004f";
static constexpr OUStringLiteral currencyName0 = u"\x0043\x006f\x0072\x0064\x006f\x0062\x0061\x0020\x004f\x0072\x006f";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_es_NI(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_es_NI(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_es_NI(sal_Int16& count)
{
	return getForbiddenCharacters_es_ES(count);
}
extern const OUString *  getBreakIteratorRules_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_es_NI(sal_Int16& count)
{
	return getBreakIteratorRules_es_ES(count);
}
extern const OUString *  getReservedWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_es_NI(sal_Int16& count)
{
	return getReservedWords_es_ES(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_es_NI(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_es_NI(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

