#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x006d\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x004d\x0061\x0072\x0061\x0074\x0068\x0069";
static constexpr OUStringLiteral countryID = u"\x0049\x004e";
static constexpr OUStringLiteral countryDefaultName = u"\x0049\x006e\x0064\x0069\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_mr_IN(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_mr_IN(sal_Int16& count)
{
	return getLocaleItem_hi_IN(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x20b9, 0x2d, 0x34, 0x34, 0x45, 0x5d, 0x0};
extern OUString const * getAllFormats0_hi_IN(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_mr_IN(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_hi_IN(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_mr_IN(sal_Int16& count)
{
	return getDateAcceptancePatterns_hi_IN(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_mr_IN(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_mr_IN(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_mr_IN(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_mr_IN(sal_Int16& count)
{
	return getIndexAlgorithm_en_US(count);
}
extern const OUString *  getUnicodeScripts_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_mr_IN(sal_Int16& count)
{
	return getUnicodeScripts_en_US(count);
}
extern const OUString *  getFollowPageWords_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_mr_IN(sal_Int16& count)
{
	return getFollowPageWords_en_US(count);
}
extern const OUString *  getAllCalendars_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_mr_IN(sal_Int16& count)
{
	return getAllCalendars_hi_IN(count);
}
extern const OUString *  getAllCurrencies_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCurrencies_mr_IN(sal_Int16& count)
{
	return getAllCurrencies_hi_IN(count);
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_mr_IN(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_mr_IN(sal_Int16& count)
{
	return getForbiddenCharacters_hi_IN(count);
}
extern const OUString *  getBreakIteratorRules_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_mr_IN(sal_Int16& count)
{
	return getBreakIteratorRules_hi_IN(count);
}
extern const OUString *  getReservedWords_hi_IN(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_mr_IN(sal_Int16& count)
{
	return getReservedWords_hi_IN(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_hi_IN(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_mr_IN(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_hi_IN(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_mr_IN(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

