/***********************************************************************
 * This file was generated by /build/libuhd/src/uhd/host/lib/ic_reg_maps/gen_ad9510_regs.py on Wed Dec 17 09:05:05 2025
 **********************************************************************/

#ifndef INCLUDED_AD9510_REGS_HPP
#define INCLUDED_AD9510_REGS_HPP

#include <uhd/config.hpp>
#include <uhd/exception.hpp>
#include <set>
#include <vector>
#include <stdint.h>

class ad9510_regs_t{
public:
    enum long_instruction_t{
        LONG_INSTRUCTION_8BITS = 0,
        LONG_INSTRUCTION_16BITS = 1
    };
    long_instruction_t long_instruction;
    uint8_t soft_reset;
    enum lsb_first_t{
        LSB_FIRST_MSB = 0,
        LSB_FIRST_LSB = 1
    };
    lsb_first_t lsb_first;
    enum sdo_inactive_t{
        SDO_INACTIVE_ACTIVE = 0,
        SDO_INACTIVE_INACTIVE = 1
    };
    sdo_inactive_t sdo_inactive;
    uint8_t acounter;
    uint8_t bcounter_msb;
    uint8_t bcounter_lsb;
    enum lor_enable_t{
        LOR_ENABLE_ENB = 0,
        LOR_ENABLE_DIS = 1
    };
    lor_enable_t lor_enable;
    enum lor_ildd_t{
        LOR_ILDD_3CYC = 0,
        LOR_ILDD_6CYC = 1,
        LOR_ILDD_12CYC = 2,
        LOR_ILDD_24CYC = 3
    };
    lor_ildd_t lor_ildd;
    enum charge_pump_mode_t{
        CHARGE_PUMP_MODE_3STATE = 0,
        CHARGE_PUMP_MODE_PUMP_UP = 1,
        CHARGE_PUMP_MODE_PUMP_DOWN = 2,
        CHARGE_PUMP_MODE_NORMAL = 3
    };
    charge_pump_mode_t charge_pump_mode;
    enum pll_mux_control_t{
        PLL_MUX_CONTROL_OFF = 0,
        PLL_MUX_CONTROL_DLD_HIGH = 1,
        PLL_MUX_CONTROL_NDIV = 2,
        PLL_MUX_CONTROL_DLD_LOW = 3,
        PLL_MUX_CONTROL_RDIV = 4,
        PLL_MUX_CONTROL_ALD_NCHAN = 5,
        PLL_MUX_CONTROL_ACOUNTER = 6,
        PLL_MUX_CONTROL_PRESCALER = 7,
        PLL_MUX_CONTROL_PFD_UP = 8,
        PLL_MUX_CONTROL_PFD_DOWN = 9,
        PLL_MUX_CONTROL_LOR_HIGH = 10,
        PLL_MUX_CONTROL_3STATE = 11,
        PLL_MUX_CONTROL_ALD_PCHAN = 12,
        PLL_MUX_CONTROL_LOR_LOL_HIGH = 13,
        PLL_MUX_CONTROL_LOR_LOL_LOW = 14,
        PLL_MUX_CONTROL_LOR_LOW = 15
    };
    pll_mux_control_t pll_mux_control;
    enum pfd_polarity_t{
        PFD_POLARITY_NEG = 0,
        PFD_POLARITY_POS = 1
    };
    pfd_polarity_t pfd_polarity;
    uint8_t reset_all_counters;
    uint8_t ncounter_reset;
    uint8_t rcounter_reset;
    enum cp_current_setting_t{
        CP_CURRENT_SETTING_0_60MA = 0,
        CP_CURRENT_SETTING_1_2MA = 1,
        CP_CURRENT_SETTING_1_8MA = 2,
        CP_CURRENT_SETTING_2_4MA = 3,
        CP_CURRENT_SETTING_3_0MA = 4,
        CP_CURRENT_SETTING_3_6MA = 5,
        CP_CURRENT_SETTING_4_2MA = 6,
        CP_CURRENT_SETTING_4_8MA = 7
    };
    cp_current_setting_t cp_current_setting;
    enum pll_power_down_t{
        PLL_POWER_DOWN_NORMAL = 0,
        PLL_POWER_DOWN_ASYNC_PD = 1,
        PLL_POWER_DOWN_SYNC_PD = 3
    };
    pll_power_down_t pll_power_down;
    enum prescaler_value_t{
        PRESCALER_VALUE_DIV1 = 0,
        PRESCALER_VALUE_DIV2 = 1,
        PRESCALER_VALUE_2_3 = 2,
        PRESCALER_VALUE_4_5 = 3,
        PRESCALER_VALUE_8_9 = 4,
        PRESCALER_VALUE_16_17 = 5,
        PRESCALER_VALUE_32_33 = 6,
        PRESCALER_VALUE_DIV3 = 7
    };
    prescaler_value_t prescaler_value;
    uint8_t b_counter_bypass;
    uint8_t ref_counter_msb;
    uint8_t ref_counter_lsb;
    enum antibacklash_pw_t{
        ANTIBACKLASH_PW_1_3NS = 0,
        ANTIBACKLASH_PW_2_9NS = 1,
        ANTIBACKLASH_PW_6_0NS = 2
    };
    antibacklash_pw_t antibacklash_pw;
    enum dld_window_t{
        DLD_WINDOW_9_5NS = 0,
        DLD_WINDOW_3_5NS = 1
    };
    dld_window_t dld_window;
    enum lock_detect_disable_t{
        LOCK_DETECT_DISABLE_ENB = 0,
        LOCK_DETECT_DISABLE_DIS = 1
    };
    lock_detect_disable_t lock_detect_disable;
    uint8_t delay_control_out5;
    enum ramp_current_out5_t{
        RAMP_CURRENT_OUT5_200UA = 0,
        RAMP_CURRENT_OUT5_400UA = 1,
        RAMP_CURRENT_OUT5_600UA = 2,
        RAMP_CURRENT_OUT5_800UA = 3,
        RAMP_CURRENT_OUT5_1000UA = 4,
        RAMP_CURRENT_OUT5_1200UA = 5,
        RAMP_CURRENT_OUT5_1400UA = 6,
        RAMP_CURRENT_OUT5_1600UA = 7
    };
    ramp_current_out5_t ramp_current_out5;
    enum ramp_capacitor_out5_t{
        RAMP_CAPACITOR_OUT5_4CAPS = 0,
        RAMP_CAPACITOR_OUT5_3CAPS = 1,
        RAMP_CAPACITOR_OUT5_2CAPS = 3,
        RAMP_CAPACITOR_OUT5_1CAP = 7
    };
    ramp_capacitor_out5_t ramp_capacitor_out5;
    uint8_t delay_fine_adjust_out5;
    uint8_t delay_control_out6;
    enum ramp_current_out6_t{
        RAMP_CURRENT_OUT6_200UA = 0,
        RAMP_CURRENT_OUT6_400UA = 1,
        RAMP_CURRENT_OUT6_600UA = 2,
        RAMP_CURRENT_OUT6_800UA = 3,
        RAMP_CURRENT_OUT6_1000UA = 4,
        RAMP_CURRENT_OUT6_1200UA = 5,
        RAMP_CURRENT_OUT6_1400UA = 6,
        RAMP_CURRENT_OUT6_1600UA = 7
    };
    ramp_current_out6_t ramp_current_out6;
    enum ramp_capacitor_out6_t{
        RAMP_CAPACITOR_OUT6_4CAPS = 0,
        RAMP_CAPACITOR_OUT6_3CAPS = 1,
        RAMP_CAPACITOR_OUT6_2CAPS = 3,
        RAMP_CAPACITOR_OUT6_1CAP = 7
    };
    ramp_capacitor_out6_t ramp_capacitor_out6;
    uint8_t delay_fine_adjust_out6;
    enum power_down_lvpecl_out0_t{
        POWER_DOWN_LVPECL_OUT0_NORMAL = 0,
        POWER_DOWN_LVPECL_OUT0_TEST = 1,
        POWER_DOWN_LVPECL_OUT0_SAFE_PD = 2,
        POWER_DOWN_LVPECL_OUT0_TOTAL_PD = 3
    };
    power_down_lvpecl_out0_t power_down_lvpecl_out0;
    enum output_level_lvpecl_out0_t{
        OUTPUT_LEVEL_LVPECL_OUT0_500MV = 0,
        OUTPUT_LEVEL_LVPECL_OUT0_340MV = 1,
        OUTPUT_LEVEL_LVPECL_OUT0_810MV = 2,
        OUTPUT_LEVEL_LVPECL_OUT0_660MV = 3
    };
    output_level_lvpecl_out0_t output_level_lvpecl_out0;
    enum power_down_lvpecl_out1_t{
        POWER_DOWN_LVPECL_OUT1_NORMAL = 0,
        POWER_DOWN_LVPECL_OUT1_TEST = 1,
        POWER_DOWN_LVPECL_OUT1_SAFE_PD = 2,
        POWER_DOWN_LVPECL_OUT1_TOTAL_PD = 3
    };
    power_down_lvpecl_out1_t power_down_lvpecl_out1;
    enum output_level_lvpecl_out1_t{
        OUTPUT_LEVEL_LVPECL_OUT1_500MV = 0,
        OUTPUT_LEVEL_LVPECL_OUT1_340MV = 1,
        OUTPUT_LEVEL_LVPECL_OUT1_810MV = 2,
        OUTPUT_LEVEL_LVPECL_OUT1_660MV = 3
    };
    output_level_lvpecl_out1_t output_level_lvpecl_out1;
    enum power_down_lvpecl_out2_t{
        POWER_DOWN_LVPECL_OUT2_NORMAL = 0,
        POWER_DOWN_LVPECL_OUT2_TEST = 1,
        POWER_DOWN_LVPECL_OUT2_SAFE_PD = 2,
        POWER_DOWN_LVPECL_OUT2_TOTAL_PD = 3
    };
    power_down_lvpecl_out2_t power_down_lvpecl_out2;
    enum output_level_lvpecl_out2_t{
        OUTPUT_LEVEL_LVPECL_OUT2_500MV = 0,
        OUTPUT_LEVEL_LVPECL_OUT2_340MV = 1,
        OUTPUT_LEVEL_LVPECL_OUT2_810MV = 2,
        OUTPUT_LEVEL_LVPECL_OUT2_660MV = 3
    };
    output_level_lvpecl_out2_t output_level_lvpecl_out2;
    enum power_down_lvpecl_out3_t{
        POWER_DOWN_LVPECL_OUT3_NORMAL = 0,
        POWER_DOWN_LVPECL_OUT3_TEST = 1,
        POWER_DOWN_LVPECL_OUT3_SAFE_PD = 2,
        POWER_DOWN_LVPECL_OUT3_TOTAL_PD = 3
    };
    power_down_lvpecl_out3_t power_down_lvpecl_out3;
    enum output_level_lvpecl_out3_t{
        OUTPUT_LEVEL_LVPECL_OUT3_500MV = 0,
        OUTPUT_LEVEL_LVPECL_OUT3_340MV = 1,
        OUTPUT_LEVEL_LVPECL_OUT3_810MV = 2,
        OUTPUT_LEVEL_LVPECL_OUT3_660MV = 3
    };
    output_level_lvpecl_out3_t output_level_lvpecl_out3;
    uint8_t power_down_lvds_cmos_out4;
    enum output_level_lvds_out4_t{
        OUTPUT_LEVEL_LVDS_OUT4_1_75MA = 0,
        OUTPUT_LEVEL_LVDS_OUT4_3_5MA = 1,
        OUTPUT_LEVEL_LVDS_OUT4_5_25MA = 2,
        OUTPUT_LEVEL_LVDS_OUT4_7MA = 3
    };
    output_level_lvds_out4_t output_level_lvds_out4;
    enum lvds_cmos_select_out4_t{
        LVDS_CMOS_SELECT_OUT4_LVDS = 0,
        LVDS_CMOS_SELECT_OUT4_CMOS = 1
    };
    lvds_cmos_select_out4_t lvds_cmos_select_out4;
    enum inverted_cmos_driver_out4_t{
        INVERTED_CMOS_DRIVER_OUT4_DIS = 0,
        INVERTED_CMOS_DRIVER_OUT4_ENB = 1
    };
    inverted_cmos_driver_out4_t inverted_cmos_driver_out4;
    uint8_t power_down_lvds_cmos_out5;
    enum output_level_lvds_out5_t{
        OUTPUT_LEVEL_LVDS_OUT5_1_75MA = 0,
        OUTPUT_LEVEL_LVDS_OUT5_3_5MA = 1,
        OUTPUT_LEVEL_LVDS_OUT5_5_25MA = 2,
        OUTPUT_LEVEL_LVDS_OUT5_7MA = 3
    };
    output_level_lvds_out5_t output_level_lvds_out5;
    enum lvds_cmos_select_out5_t{
        LVDS_CMOS_SELECT_OUT5_LVDS = 0,
        LVDS_CMOS_SELECT_OUT5_CMOS = 1
    };
    lvds_cmos_select_out5_t lvds_cmos_select_out5;
    enum inverted_cmos_driver_out5_t{
        INVERTED_CMOS_DRIVER_OUT5_DIS = 0,
        INVERTED_CMOS_DRIVER_OUT5_ENB = 1
    };
    inverted_cmos_driver_out5_t inverted_cmos_driver_out5;
    uint8_t power_down_lvds_cmos_out6;
    enum output_level_lvds_out6_t{
        OUTPUT_LEVEL_LVDS_OUT6_1_75MA = 0,
        OUTPUT_LEVEL_LVDS_OUT6_3_5MA = 1,
        OUTPUT_LEVEL_LVDS_OUT6_5_25MA = 2,
        OUTPUT_LEVEL_LVDS_OUT6_7MA = 3
    };
    output_level_lvds_out6_t output_level_lvds_out6;
    enum lvds_cmos_select_out6_t{
        LVDS_CMOS_SELECT_OUT6_LVDS = 0,
        LVDS_CMOS_SELECT_OUT6_CMOS = 1
    };
    lvds_cmos_select_out6_t lvds_cmos_select_out6;
    enum inverted_cmos_driver_out6_t{
        INVERTED_CMOS_DRIVER_OUT6_DIS = 0,
        INVERTED_CMOS_DRIVER_OUT6_ENB = 1
    };
    inverted_cmos_driver_out6_t inverted_cmos_driver_out6;
    uint8_t power_down_lvds_cmos_out7;
    enum output_level_lvds_out7_t{
        OUTPUT_LEVEL_LVDS_OUT7_1_75MA = 0,
        OUTPUT_LEVEL_LVDS_OUT7_3_5MA = 1,
        OUTPUT_LEVEL_LVDS_OUT7_5_25MA = 2,
        OUTPUT_LEVEL_LVDS_OUT7_7MA = 3
    };
    output_level_lvds_out7_t output_level_lvds_out7;
    enum lvds_cmos_select_out7_t{
        LVDS_CMOS_SELECT_OUT7_LVDS = 0,
        LVDS_CMOS_SELECT_OUT7_CMOS = 1
    };
    lvds_cmos_select_out7_t lvds_cmos_select_out7;
    enum inverted_cmos_driver_out7_t{
        INVERTED_CMOS_DRIVER_OUT7_DIS = 0,
        INVERTED_CMOS_DRIVER_OUT7_ENB = 1
    };
    inverted_cmos_driver_out7_t inverted_cmos_driver_out7;
    enum clock_select_t{
        CLOCK_SELECT_CLK2_DRIVES = 0,
        CLOCK_SELECT_CLK1_DRIVES = 1
    };
    clock_select_t clock_select;
    uint8_t clk1_power_down;
    uint8_t clk2_power_down;
    uint8_t prescaler_clock_pd;
    uint8_t refin_power_down;
    uint8_t all_clock_inputs_pd;
    uint8_t divider_high_cycles_out0;
    uint8_t divider_low_cycles_out0;
    uint8_t phase_offset_out0;
    uint8_t start_out0;
    uint8_t force_out0;
    uint8_t nosync_out0;
    uint8_t bypass_divider_out0;
    uint8_t divider_high_cycles_out1;
    uint8_t divider_low_cycles_out1;
    uint8_t phase_offset_out1;
    uint8_t start_out1;
    uint8_t force_out1;
    uint8_t nosync_out1;
    uint8_t bypass_divider_out1;
    uint8_t divider_high_cycles_out2;
    uint8_t divider_low_cycles_out2;
    uint8_t phase_offset_out2;
    uint8_t start_out2;
    uint8_t force_out2;
    uint8_t nosync_out2;
    uint8_t bypass_divider_out2;
    uint8_t divider_high_cycles_out3;
    uint8_t divider_low_cycles_out3;
    uint8_t phase_offset_out3;
    uint8_t start_out3;
    uint8_t force_out3;
    uint8_t nosync_out3;
    uint8_t bypass_divider_out3;
    uint8_t divider_high_cycles_out4;
    uint8_t divider_low_cycles_out4;
    uint8_t phase_offset_out4;
    uint8_t start_out4;
    uint8_t force_out4;
    uint8_t nosync_out4;
    uint8_t bypass_divider_out4;
    uint8_t divider_high_cycles_out5;
    uint8_t divider_low_cycles_out5;
    uint8_t phase_offset_out5;
    uint8_t start_out5;
    uint8_t force_out5;
    uint8_t nosync_out5;
    uint8_t bypass_divider_out5;
    uint8_t divider_high_cycles_out6;
    uint8_t divider_low_cycles_out6;
    uint8_t phase_offset_out6;
    uint8_t start_out6;
    uint8_t force_out6;
    uint8_t nosync_out6;
    uint8_t bypass_divider_out6;
    uint8_t divider_high_cycles_out7;
    uint8_t divider_low_cycles_out7;
    uint8_t phase_offset_out7;
    uint8_t start_out7;
    uint8_t force_out7;
    uint8_t nosync_out7;
    uint8_t bypass_divider_out7;
    enum sync_detect_enable_t{
        SYNC_DETECT_ENABLE_DIS = 0,
        SYNC_DETECT_ENABLE_ENB = 1
    };
    sync_detect_enable_t sync_detect_enable;
    enum sync_select_t{
        SYNC_SELECT_1_TO_0_5 = 0,
        SYNC_SELECT_0_5_TO_1 = 1
    };
    sync_select_t sync_select;
    uint8_t soft_sync;
    uint8_t dist_power_down;
    uint8_t sync_power_down;
    enum function_pin_select_t{
        FUNCTION_PIN_SELECT_RESETB = 0,
        FUNCTION_PIN_SELECT_SYNCB = 1,
        FUNCTION_PIN_SELECT_TEST = 2,
        FUNCTION_PIN_SELECT_PDB = 3
    };
    function_pin_select_t function_pin_select;
    uint8_t update_registers;

    ad9510_regs_t(void){
        _state = NULL;
        long_instruction = LONG_INSTRUCTION_16BITS;
        soft_reset = 0;
        lsb_first = LSB_FIRST_MSB;
        sdo_inactive = SDO_INACTIVE_ACTIVE;
        acounter = 0;
        bcounter_msb = 0;
        bcounter_lsb = 0;
        lor_enable = LOR_ENABLE_ENB;
        lor_ildd = LOR_ILDD_3CYC;
        charge_pump_mode = CHARGE_PUMP_MODE_3STATE;
        pll_mux_control = PLL_MUX_CONTROL_OFF;
        pfd_polarity = PFD_POLARITY_NEG;
        reset_all_counters = 0;
        ncounter_reset = 0;
        rcounter_reset = 0;
        cp_current_setting = CP_CURRENT_SETTING_0_60MA;
        pll_power_down = PLL_POWER_DOWN_NORMAL;
        prescaler_value = PRESCALER_VALUE_DIV1;
        b_counter_bypass = 0;
        ref_counter_msb = 0;
        ref_counter_lsb = 0;
        antibacklash_pw = ANTIBACKLASH_PW_1_3NS;
        dld_window = DLD_WINDOW_9_5NS;
        lock_detect_disable = LOCK_DETECT_DISABLE_ENB;
        delay_control_out5 = 0;
        ramp_current_out5 = RAMP_CURRENT_OUT5_200UA;
        ramp_capacitor_out5 = RAMP_CAPACITOR_OUT5_4CAPS;
        delay_fine_adjust_out5 = 0;
        delay_control_out6 = 0;
        ramp_current_out6 = RAMP_CURRENT_OUT6_200UA;
        ramp_capacitor_out6 = RAMP_CAPACITOR_OUT6_4CAPS;
        delay_fine_adjust_out6 = 0;
        power_down_lvpecl_out0 = POWER_DOWN_LVPECL_OUT0_NORMAL;
        output_level_lvpecl_out0 = OUTPUT_LEVEL_LVPECL_OUT0_810MV;
        power_down_lvpecl_out1 = POWER_DOWN_LVPECL_OUT1_NORMAL;
        output_level_lvpecl_out1 = OUTPUT_LEVEL_LVPECL_OUT1_810MV;
        power_down_lvpecl_out2 = POWER_DOWN_LVPECL_OUT2_NORMAL;
        output_level_lvpecl_out2 = OUTPUT_LEVEL_LVPECL_OUT2_810MV;
        power_down_lvpecl_out3 = POWER_DOWN_LVPECL_OUT3_NORMAL;
        output_level_lvpecl_out3 = OUTPUT_LEVEL_LVPECL_OUT3_810MV;
        power_down_lvds_cmos_out4 = 0;
        output_level_lvds_out4 = OUTPUT_LEVEL_LVDS_OUT4_3_5MA;
        lvds_cmos_select_out4 = LVDS_CMOS_SELECT_OUT4_CMOS;
        inverted_cmos_driver_out4 = INVERTED_CMOS_DRIVER_OUT4_DIS;
        power_down_lvds_cmos_out5 = 0;
        output_level_lvds_out5 = OUTPUT_LEVEL_LVDS_OUT5_3_5MA;
        lvds_cmos_select_out5 = LVDS_CMOS_SELECT_OUT5_CMOS;
        inverted_cmos_driver_out5 = INVERTED_CMOS_DRIVER_OUT5_DIS;
        power_down_lvds_cmos_out6 = 0;
        output_level_lvds_out6 = OUTPUT_LEVEL_LVDS_OUT6_3_5MA;
        lvds_cmos_select_out6 = LVDS_CMOS_SELECT_OUT6_CMOS;
        inverted_cmos_driver_out6 = INVERTED_CMOS_DRIVER_OUT6_DIS;
        power_down_lvds_cmos_out7 = 0;
        output_level_lvds_out7 = OUTPUT_LEVEL_LVDS_OUT7_3_5MA;
        lvds_cmos_select_out7 = LVDS_CMOS_SELECT_OUT7_CMOS;
        inverted_cmos_driver_out7 = INVERTED_CMOS_DRIVER_OUT7_DIS;
        clock_select = CLOCK_SELECT_CLK1_DRIVES;
        clk1_power_down = 0;
        clk2_power_down = 0;
        prescaler_clock_pd = 0;
        refin_power_down = 0;
        all_clock_inputs_pd = 0;
        divider_high_cycles_out0 = 0;
        divider_low_cycles_out0 = 0;
        phase_offset_out0 = 0;
        start_out0 = 0;
        force_out0 = 0;
        nosync_out0 = 0;
        bypass_divider_out0 = 0;
        divider_high_cycles_out1 = 0;
        divider_low_cycles_out1 = 0;
        phase_offset_out1 = 0;
        start_out1 = 0;
        force_out1 = 0;
        nosync_out1 = 0;
        bypass_divider_out1 = 0;
        divider_high_cycles_out2 = 0;
        divider_low_cycles_out2 = 0;
        phase_offset_out2 = 0;
        start_out2 = 0;
        force_out2 = 0;
        nosync_out2 = 0;
        bypass_divider_out2 = 0;
        divider_high_cycles_out3 = 0;
        divider_low_cycles_out3 = 0;
        phase_offset_out3 = 0;
        start_out3 = 0;
        force_out3 = 0;
        nosync_out3 = 0;
        bypass_divider_out3 = 0;
        divider_high_cycles_out4 = 0;
        divider_low_cycles_out4 = 0;
        phase_offset_out4 = 0;
        start_out4 = 0;
        force_out4 = 0;
        nosync_out4 = 0;
        bypass_divider_out4 = 0;
        divider_high_cycles_out5 = 0;
        divider_low_cycles_out5 = 0;
        phase_offset_out5 = 0;
        start_out5 = 0;
        force_out5 = 0;
        nosync_out5 = 0;
        bypass_divider_out5 = 0;
        divider_high_cycles_out6 = 0;
        divider_low_cycles_out6 = 0;
        phase_offset_out6 = 0;
        start_out6 = 0;
        force_out6 = 0;
        nosync_out6 = 0;
        bypass_divider_out6 = 0;
        divider_high_cycles_out7 = 0;
        divider_low_cycles_out7 = 0;
        phase_offset_out7 = 0;
        start_out7 = 0;
        force_out7 = 0;
        nosync_out7 = 0;
        bypass_divider_out7 = 0;
        sync_detect_enable = SYNC_DETECT_ENABLE_DIS;
        sync_select = SYNC_SELECT_1_TO_0_5;
        soft_sync = 0;
        dist_power_down = 0;
        sync_power_down = 0;
        function_pin_select = FUNCTION_PIN_SELECT_RESETB;
        update_registers = 0;
    }

    ~ad9510_regs_t(void){
        delete _state;
    }

    uint8_t get_reg(uint16_t addr){
        uint8_t reg = 0;
        switch(addr){
        case 0:
            reg |= (uint32_t(long_instruction) & 0x1) << 4;
            reg |= (uint32_t(soft_reset) & 0x1) << 5;
            reg |= (uint32_t(lsb_first) & 0x1) << 6;
            reg |= (uint32_t(sdo_inactive) & 0x1) << 7;
            break;
        case 4:
            reg |= (uint32_t(acounter) & 0x3f) << 0;
            break;
        case 5:
            reg |= (uint32_t(bcounter_msb) & 0x1f) << 0;
            break;
        case 6:
            reg |= (uint32_t(bcounter_lsb) & 0xff) << 0;
            break;
        case 7:
            reg |= (uint32_t(lor_enable) & 0x1) << 2;
            reg |= (uint32_t(lor_ildd) & 0x3) << 5;
            break;
        case 8:
            reg |= (uint32_t(charge_pump_mode) & 0x3) << 0;
            reg |= (uint32_t(pll_mux_control) & 0xf) << 2;
            reg |= (uint32_t(pfd_polarity) & 0x1) << 6;
            break;
        case 9:
            reg |= (uint32_t(reset_all_counters) & 0x1) << 0;
            reg |= (uint32_t(ncounter_reset) & 0x1) << 1;
            reg |= (uint32_t(rcounter_reset) & 0x1) << 2;
            reg |= (uint32_t(cp_current_setting) & 0x7) << 4;
            break;
        case 10:
            reg |= (uint32_t(pll_power_down) & 0x3) << 0;
            reg |= (uint32_t(prescaler_value) & 0x7) << 2;
            reg |= (uint32_t(b_counter_bypass) & 0x1) << 6;
            break;
        case 11:
            reg |= (uint32_t(ref_counter_msb) & 0x3f) << 0;
            break;
        case 12:
            reg |= (uint32_t(ref_counter_lsb) & 0xff) << 0;
            break;
        case 13:
            reg |= (uint32_t(antibacklash_pw) & 0x3) << 0;
            reg |= (uint32_t(dld_window) & 0x1) << 5;
            reg |= (uint32_t(lock_detect_disable) & 0x1) << 6;
            break;
        case 52:
            reg |= (uint32_t(delay_control_out5) & 0x1) << 0;
            break;
        case 53:
            reg |= (uint32_t(ramp_current_out5) & 0x7) << 0;
            reg |= (uint32_t(ramp_capacitor_out5) & 0x7) << 3;
            break;
        case 54:
            reg |= (uint32_t(delay_fine_adjust_out5) & 0x1f) << 1;
            break;
        case 56:
            reg |= (uint32_t(delay_control_out6) & 0x1) << 0;
            break;
        case 57:
            reg |= (uint32_t(ramp_current_out6) & 0x7) << 0;
            reg |= (uint32_t(ramp_capacitor_out6) & 0x7) << 3;
            break;
        case 58:
            reg |= (uint32_t(delay_fine_adjust_out6) & 0x1f) << 1;
            break;
        case 60:
            reg |= (uint32_t(power_down_lvpecl_out0) & 0x3) << 0;
            reg |= (uint32_t(output_level_lvpecl_out0) & 0x3) << 2;
            break;
        case 61:
            reg |= (uint32_t(power_down_lvpecl_out1) & 0x3) << 0;
            reg |= (uint32_t(output_level_lvpecl_out1) & 0x3) << 2;
            break;
        case 62:
            reg |= (uint32_t(power_down_lvpecl_out2) & 0x3) << 0;
            reg |= (uint32_t(output_level_lvpecl_out2) & 0x3) << 2;
            break;
        case 63:
            reg |= (uint32_t(power_down_lvpecl_out3) & 0x3) << 0;
            reg |= (uint32_t(output_level_lvpecl_out3) & 0x3) << 2;
            break;
        case 64:
            reg |= (uint32_t(power_down_lvds_cmos_out4) & 0x1) << 0;
            reg |= (uint32_t(output_level_lvds_out4) & 0x3) << 1;
            reg |= (uint32_t(lvds_cmos_select_out4) & 0x1) << 3;
            reg |= (uint32_t(inverted_cmos_driver_out4) & 0x1) << 4;
            break;
        case 65:
            reg |= (uint32_t(power_down_lvds_cmos_out5) & 0x1) << 0;
            reg |= (uint32_t(output_level_lvds_out5) & 0x3) << 1;
            reg |= (uint32_t(lvds_cmos_select_out5) & 0x1) << 3;
            reg |= (uint32_t(inverted_cmos_driver_out5) & 0x1) << 4;
            break;
        case 66:
            reg |= (uint32_t(power_down_lvds_cmos_out6) & 0x1) << 0;
            reg |= (uint32_t(output_level_lvds_out6) & 0x3) << 1;
            reg |= (uint32_t(lvds_cmos_select_out6) & 0x1) << 3;
            reg |= (uint32_t(inverted_cmos_driver_out6) & 0x1) << 4;
            break;
        case 67:
            reg |= (uint32_t(power_down_lvds_cmos_out7) & 0x1) << 0;
            reg |= (uint32_t(output_level_lvds_out7) & 0x3) << 1;
            reg |= (uint32_t(lvds_cmos_select_out7) & 0x1) << 3;
            reg |= (uint32_t(inverted_cmos_driver_out7) & 0x1) << 4;
            break;
        case 69:
            reg |= (uint32_t(clock_select) & 0x1) << 0;
            reg |= (uint32_t(clk1_power_down) & 0x1) << 1;
            reg |= (uint32_t(clk2_power_down) & 0x1) << 2;
            reg |= (uint32_t(prescaler_clock_pd) & 0x1) << 3;
            reg |= (uint32_t(refin_power_down) & 0x1) << 4;
            reg |= (uint32_t(all_clock_inputs_pd) & 0x1) << 5;
            break;
        case 72:
            reg |= (uint32_t(divider_high_cycles_out0) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out0) & 0xf) << 4;
            break;
        case 73:
            reg |= (uint32_t(phase_offset_out0) & 0xf) << 0;
            reg |= (uint32_t(start_out0) & 0x1) << 4;
            reg |= (uint32_t(force_out0) & 0x1) << 5;
            reg |= (uint32_t(nosync_out0) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out0) & 0x1) << 7;
            break;
        case 74:
            reg |= (uint32_t(divider_high_cycles_out1) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out1) & 0xf) << 4;
            break;
        case 75:
            reg |= (uint32_t(phase_offset_out1) & 0xf) << 0;
            reg |= (uint32_t(start_out1) & 0x1) << 4;
            reg |= (uint32_t(force_out1) & 0x1) << 5;
            reg |= (uint32_t(nosync_out1) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out1) & 0x1) << 7;
            break;
        case 76:
            reg |= (uint32_t(divider_high_cycles_out2) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out2) & 0xf) << 4;
            break;
        case 77:
            reg |= (uint32_t(phase_offset_out2) & 0xf) << 0;
            reg |= (uint32_t(start_out2) & 0x1) << 4;
            reg |= (uint32_t(force_out2) & 0x1) << 5;
            reg |= (uint32_t(nosync_out2) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out2) & 0x1) << 7;
            break;
        case 78:
            reg |= (uint32_t(divider_high_cycles_out3) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out3) & 0xf) << 4;
            break;
        case 79:
            reg |= (uint32_t(phase_offset_out3) & 0xf) << 0;
            reg |= (uint32_t(start_out3) & 0x1) << 4;
            reg |= (uint32_t(force_out3) & 0x1) << 5;
            reg |= (uint32_t(nosync_out3) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out3) & 0x1) << 7;
            break;
        case 80:
            reg |= (uint32_t(divider_high_cycles_out4) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out4) & 0xf) << 4;
            break;
        case 81:
            reg |= (uint32_t(phase_offset_out4) & 0xf) << 0;
            reg |= (uint32_t(start_out4) & 0x1) << 4;
            reg |= (uint32_t(force_out4) & 0x1) << 5;
            reg |= (uint32_t(nosync_out4) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out4) & 0x1) << 7;
            break;
        case 82:
            reg |= (uint32_t(divider_high_cycles_out5) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out5) & 0xf) << 4;
            break;
        case 83:
            reg |= (uint32_t(phase_offset_out5) & 0xf) << 0;
            reg |= (uint32_t(start_out5) & 0x1) << 4;
            reg |= (uint32_t(force_out5) & 0x1) << 5;
            reg |= (uint32_t(nosync_out5) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out5) & 0x1) << 7;
            break;
        case 84:
            reg |= (uint32_t(divider_high_cycles_out6) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out6) & 0xf) << 4;
            break;
        case 85:
            reg |= (uint32_t(phase_offset_out6) & 0xf) << 0;
            reg |= (uint32_t(start_out6) & 0x1) << 4;
            reg |= (uint32_t(force_out6) & 0x1) << 5;
            reg |= (uint32_t(nosync_out6) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out6) & 0x1) << 7;
            break;
        case 86:
            reg |= (uint32_t(divider_high_cycles_out7) & 0xf) << 0;
            reg |= (uint32_t(divider_low_cycles_out7) & 0xf) << 4;
            break;
        case 87:
            reg |= (uint32_t(phase_offset_out7) & 0xf) << 0;
            reg |= (uint32_t(start_out7) & 0x1) << 4;
            reg |= (uint32_t(force_out7) & 0x1) << 5;
            reg |= (uint32_t(nosync_out7) & 0x1) << 6;
            reg |= (uint32_t(bypass_divider_out7) & 0x1) << 7;
            break;
        case 88:
            reg |= (uint32_t(sync_detect_enable) & 0x1) << 0;
            reg |= (uint32_t(sync_select) & 0x1) << 1;
            reg |= (uint32_t(soft_sync) & 0x1) << 2;
            reg |= (uint32_t(dist_power_down) & 0x1) << 3;
            reg |= (uint32_t(sync_power_down) & 0x1) << 4;
            reg |= (uint32_t(function_pin_select) & 0x3) << 5;
            break;
        case 90:
            reg |= (uint32_t(update_registers) & 0x1) << 0;
            break;
        }
        return reg;
    }
    
    uint32_t get_write_reg(uint16_t addr){
        return (uint32_t(addr) << 8) | get_reg(addr);
    }
    
    uint32_t get_read_reg(uint16_t addr){
        return (uint32_t(addr) << 8) | (1 << 23);
    }

    void save_state(void){
        if (_state == NULL) _state = new ad9510_regs_t();
        _state->long_instruction = this->long_instruction;
        _state->soft_reset = this->soft_reset;
        _state->lsb_first = this->lsb_first;
        _state->sdo_inactive = this->sdo_inactive;
        _state->acounter = this->acounter;
        _state->bcounter_msb = this->bcounter_msb;
        _state->bcounter_lsb = this->bcounter_lsb;
        _state->lor_enable = this->lor_enable;
        _state->lor_ildd = this->lor_ildd;
        _state->charge_pump_mode = this->charge_pump_mode;
        _state->pll_mux_control = this->pll_mux_control;
        _state->pfd_polarity = this->pfd_polarity;
        _state->reset_all_counters = this->reset_all_counters;
        _state->ncounter_reset = this->ncounter_reset;
        _state->rcounter_reset = this->rcounter_reset;
        _state->cp_current_setting = this->cp_current_setting;
        _state->pll_power_down = this->pll_power_down;
        _state->prescaler_value = this->prescaler_value;
        _state->b_counter_bypass = this->b_counter_bypass;
        _state->ref_counter_msb = this->ref_counter_msb;
        _state->ref_counter_lsb = this->ref_counter_lsb;
        _state->antibacklash_pw = this->antibacklash_pw;
        _state->dld_window = this->dld_window;
        _state->lock_detect_disable = this->lock_detect_disable;
        _state->delay_control_out5 = this->delay_control_out5;
        _state->ramp_current_out5 = this->ramp_current_out5;
        _state->ramp_capacitor_out5 = this->ramp_capacitor_out5;
        _state->delay_fine_adjust_out5 = this->delay_fine_adjust_out5;
        _state->delay_control_out6 = this->delay_control_out6;
        _state->ramp_current_out6 = this->ramp_current_out6;
        _state->ramp_capacitor_out6 = this->ramp_capacitor_out6;
        _state->delay_fine_adjust_out6 = this->delay_fine_adjust_out6;
        _state->power_down_lvpecl_out0 = this->power_down_lvpecl_out0;
        _state->output_level_lvpecl_out0 = this->output_level_lvpecl_out0;
        _state->power_down_lvpecl_out1 = this->power_down_lvpecl_out1;
        _state->output_level_lvpecl_out1 = this->output_level_lvpecl_out1;
        _state->power_down_lvpecl_out2 = this->power_down_lvpecl_out2;
        _state->output_level_lvpecl_out2 = this->output_level_lvpecl_out2;
        _state->power_down_lvpecl_out3 = this->power_down_lvpecl_out3;
        _state->output_level_lvpecl_out3 = this->output_level_lvpecl_out3;
        _state->power_down_lvds_cmos_out4 = this->power_down_lvds_cmos_out4;
        _state->output_level_lvds_out4 = this->output_level_lvds_out4;
        _state->lvds_cmos_select_out4 = this->lvds_cmos_select_out4;
        _state->inverted_cmos_driver_out4 = this->inverted_cmos_driver_out4;
        _state->power_down_lvds_cmos_out5 = this->power_down_lvds_cmos_out5;
        _state->output_level_lvds_out5 = this->output_level_lvds_out5;
        _state->lvds_cmos_select_out5 = this->lvds_cmos_select_out5;
        _state->inverted_cmos_driver_out5 = this->inverted_cmos_driver_out5;
        _state->power_down_lvds_cmos_out6 = this->power_down_lvds_cmos_out6;
        _state->output_level_lvds_out6 = this->output_level_lvds_out6;
        _state->lvds_cmos_select_out6 = this->lvds_cmos_select_out6;
        _state->inverted_cmos_driver_out6 = this->inverted_cmos_driver_out6;
        _state->power_down_lvds_cmos_out7 = this->power_down_lvds_cmos_out7;
        _state->output_level_lvds_out7 = this->output_level_lvds_out7;
        _state->lvds_cmos_select_out7 = this->lvds_cmos_select_out7;
        _state->inverted_cmos_driver_out7 = this->inverted_cmos_driver_out7;
        _state->clock_select = this->clock_select;
        _state->clk1_power_down = this->clk1_power_down;
        _state->clk2_power_down = this->clk2_power_down;
        _state->prescaler_clock_pd = this->prescaler_clock_pd;
        _state->refin_power_down = this->refin_power_down;
        _state->all_clock_inputs_pd = this->all_clock_inputs_pd;
        _state->divider_high_cycles_out0 = this->divider_high_cycles_out0;
        _state->divider_low_cycles_out0 = this->divider_low_cycles_out0;
        _state->phase_offset_out0 = this->phase_offset_out0;
        _state->start_out0 = this->start_out0;
        _state->force_out0 = this->force_out0;
        _state->nosync_out0 = this->nosync_out0;
        _state->bypass_divider_out0 = this->bypass_divider_out0;
        _state->divider_high_cycles_out1 = this->divider_high_cycles_out1;
        _state->divider_low_cycles_out1 = this->divider_low_cycles_out1;
        _state->phase_offset_out1 = this->phase_offset_out1;
        _state->start_out1 = this->start_out1;
        _state->force_out1 = this->force_out1;
        _state->nosync_out1 = this->nosync_out1;
        _state->bypass_divider_out1 = this->bypass_divider_out1;
        _state->divider_high_cycles_out2 = this->divider_high_cycles_out2;
        _state->divider_low_cycles_out2 = this->divider_low_cycles_out2;
        _state->phase_offset_out2 = this->phase_offset_out2;
        _state->start_out2 = this->start_out2;
        _state->force_out2 = this->force_out2;
        _state->nosync_out2 = this->nosync_out2;
        _state->bypass_divider_out2 = this->bypass_divider_out2;
        _state->divider_high_cycles_out3 = this->divider_high_cycles_out3;
        _state->divider_low_cycles_out3 = this->divider_low_cycles_out3;
        _state->phase_offset_out3 = this->phase_offset_out3;
        _state->start_out3 = this->start_out3;
        _state->force_out3 = this->force_out3;
        _state->nosync_out3 = this->nosync_out3;
        _state->bypass_divider_out3 = this->bypass_divider_out3;
        _state->divider_high_cycles_out4 = this->divider_high_cycles_out4;
        _state->divider_low_cycles_out4 = this->divider_low_cycles_out4;
        _state->phase_offset_out4 = this->phase_offset_out4;
        _state->start_out4 = this->start_out4;
        _state->force_out4 = this->force_out4;
        _state->nosync_out4 = this->nosync_out4;
        _state->bypass_divider_out4 = this->bypass_divider_out4;
        _state->divider_high_cycles_out5 = this->divider_high_cycles_out5;
        _state->divider_low_cycles_out5 = this->divider_low_cycles_out5;
        _state->phase_offset_out5 = this->phase_offset_out5;
        _state->start_out5 = this->start_out5;
        _state->force_out5 = this->force_out5;
        _state->nosync_out5 = this->nosync_out5;
        _state->bypass_divider_out5 = this->bypass_divider_out5;
        _state->divider_high_cycles_out6 = this->divider_high_cycles_out6;
        _state->divider_low_cycles_out6 = this->divider_low_cycles_out6;
        _state->phase_offset_out6 = this->phase_offset_out6;
        _state->start_out6 = this->start_out6;
        _state->force_out6 = this->force_out6;
        _state->nosync_out6 = this->nosync_out6;
        _state->bypass_divider_out6 = this->bypass_divider_out6;
        _state->divider_high_cycles_out7 = this->divider_high_cycles_out7;
        _state->divider_low_cycles_out7 = this->divider_low_cycles_out7;
        _state->phase_offset_out7 = this->phase_offset_out7;
        _state->start_out7 = this->start_out7;
        _state->force_out7 = this->force_out7;
        _state->nosync_out7 = this->nosync_out7;
        _state->bypass_divider_out7 = this->bypass_divider_out7;
        _state->sync_detect_enable = this->sync_detect_enable;
        _state->sync_select = this->sync_select;
        _state->soft_sync = this->soft_sync;
        _state->dist_power_down = this->dist_power_down;
        _state->sync_power_down = this->sync_power_down;
        _state->function_pin_select = this->function_pin_select;
        _state->update_registers = this->update_registers;
    }

    long_instruction_t get_state_long_instruction(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->long_instruction;
    }

    uint8_t get_state_soft_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->soft_reset;
    }

    lsb_first_t get_state_lsb_first(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lsb_first;
    }

    sdo_inactive_t get_state_sdo_inactive(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sdo_inactive;
    }

    uint8_t get_state_acounter(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->acounter;
    }

    uint8_t get_state_bcounter_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bcounter_msb;
    }

    uint8_t get_state_bcounter_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bcounter_lsb;
    }

    lor_enable_t get_state_lor_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lor_enable;
    }

    lor_ildd_t get_state_lor_ildd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lor_ildd;
    }

    charge_pump_mode_t get_state_charge_pump_mode(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->charge_pump_mode;
    }

    pll_mux_control_t get_state_pll_mux_control(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_mux_control;
    }

    pfd_polarity_t get_state_pfd_polarity(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pfd_polarity;
    }

    uint8_t get_state_reset_all_counters(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->reset_all_counters;
    }

    uint8_t get_state_ncounter_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ncounter_reset;
    }

    uint8_t get_state_rcounter_reset(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->rcounter_reset;
    }

    cp_current_setting_t get_state_cp_current_setting(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->cp_current_setting;
    }

    pll_power_down_t get_state_pll_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->pll_power_down;
    }

    prescaler_value_t get_state_prescaler_value(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->prescaler_value;
    }

    uint8_t get_state_b_counter_bypass(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->b_counter_bypass;
    }

    uint8_t get_state_ref_counter_msb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ref_counter_msb;
    }

    uint8_t get_state_ref_counter_lsb(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ref_counter_lsb;
    }

    antibacklash_pw_t get_state_antibacklash_pw(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->antibacklash_pw;
    }

    dld_window_t get_state_dld_window(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dld_window;
    }

    lock_detect_disable_t get_state_lock_detect_disable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lock_detect_disable;
    }

    uint8_t get_state_delay_control_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->delay_control_out5;
    }

    ramp_current_out5_t get_state_ramp_current_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_current_out5;
    }

    ramp_capacitor_out5_t get_state_ramp_capacitor_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_capacitor_out5;
    }

    uint8_t get_state_delay_fine_adjust_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->delay_fine_adjust_out5;
    }

    uint8_t get_state_delay_control_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->delay_control_out6;
    }

    ramp_current_out6_t get_state_ramp_current_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_current_out6;
    }

    ramp_capacitor_out6_t get_state_ramp_capacitor_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->ramp_capacitor_out6;
    }

    uint8_t get_state_delay_fine_adjust_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->delay_fine_adjust_out6;
    }

    power_down_lvpecl_out0_t get_state_power_down_lvpecl_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvpecl_out0;
    }

    output_level_lvpecl_out0_t get_state_output_level_lvpecl_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvpecl_out0;
    }

    power_down_lvpecl_out1_t get_state_power_down_lvpecl_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvpecl_out1;
    }

    output_level_lvpecl_out1_t get_state_output_level_lvpecl_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvpecl_out1;
    }

    power_down_lvpecl_out2_t get_state_power_down_lvpecl_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvpecl_out2;
    }

    output_level_lvpecl_out2_t get_state_output_level_lvpecl_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvpecl_out2;
    }

    power_down_lvpecl_out3_t get_state_power_down_lvpecl_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvpecl_out3;
    }

    output_level_lvpecl_out3_t get_state_output_level_lvpecl_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvpecl_out3;
    }

    uint8_t get_state_power_down_lvds_cmos_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvds_cmos_out4;
    }

    output_level_lvds_out4_t get_state_output_level_lvds_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvds_out4;
    }

    lvds_cmos_select_out4_t get_state_lvds_cmos_select_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lvds_cmos_select_out4;
    }

    inverted_cmos_driver_out4_t get_state_inverted_cmos_driver_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inverted_cmos_driver_out4;
    }

    uint8_t get_state_power_down_lvds_cmos_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvds_cmos_out5;
    }

    output_level_lvds_out5_t get_state_output_level_lvds_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvds_out5;
    }

    lvds_cmos_select_out5_t get_state_lvds_cmos_select_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lvds_cmos_select_out5;
    }

    inverted_cmos_driver_out5_t get_state_inverted_cmos_driver_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inverted_cmos_driver_out5;
    }

    uint8_t get_state_power_down_lvds_cmos_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvds_cmos_out6;
    }

    output_level_lvds_out6_t get_state_output_level_lvds_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvds_out6;
    }

    lvds_cmos_select_out6_t get_state_lvds_cmos_select_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lvds_cmos_select_out6;
    }

    inverted_cmos_driver_out6_t get_state_inverted_cmos_driver_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inverted_cmos_driver_out6;
    }

    uint8_t get_state_power_down_lvds_cmos_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->power_down_lvds_cmos_out7;
    }

    output_level_lvds_out7_t get_state_output_level_lvds_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->output_level_lvds_out7;
    }

    lvds_cmos_select_out7_t get_state_lvds_cmos_select_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->lvds_cmos_select_out7;
    }

    inverted_cmos_driver_out7_t get_state_inverted_cmos_driver_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->inverted_cmos_driver_out7;
    }

    clock_select_t get_state_clock_select(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->clock_select;
    }

    uint8_t get_state_clk1_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->clk1_power_down;
    }

    uint8_t get_state_clk2_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->clk2_power_down;
    }

    uint8_t get_state_prescaler_clock_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->prescaler_clock_pd;
    }

    uint8_t get_state_refin_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->refin_power_down;
    }

    uint8_t get_state_all_clock_inputs_pd(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->all_clock_inputs_pd;
    }

    uint8_t get_state_divider_high_cycles_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out0;
    }

    uint8_t get_state_divider_low_cycles_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out0;
    }

    uint8_t get_state_phase_offset_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out0;
    }

    uint8_t get_state_start_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out0;
    }

    uint8_t get_state_force_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out0;
    }

    uint8_t get_state_nosync_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out0;
    }

    uint8_t get_state_bypass_divider_out0(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out0;
    }

    uint8_t get_state_divider_high_cycles_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out1;
    }

    uint8_t get_state_divider_low_cycles_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out1;
    }

    uint8_t get_state_phase_offset_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out1;
    }

    uint8_t get_state_start_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out1;
    }

    uint8_t get_state_force_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out1;
    }

    uint8_t get_state_nosync_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out1;
    }

    uint8_t get_state_bypass_divider_out1(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out1;
    }

    uint8_t get_state_divider_high_cycles_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out2;
    }

    uint8_t get_state_divider_low_cycles_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out2;
    }

    uint8_t get_state_phase_offset_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out2;
    }

    uint8_t get_state_start_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out2;
    }

    uint8_t get_state_force_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out2;
    }

    uint8_t get_state_nosync_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out2;
    }

    uint8_t get_state_bypass_divider_out2(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out2;
    }

    uint8_t get_state_divider_high_cycles_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out3;
    }

    uint8_t get_state_divider_low_cycles_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out3;
    }

    uint8_t get_state_phase_offset_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out3;
    }

    uint8_t get_state_start_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out3;
    }

    uint8_t get_state_force_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out3;
    }

    uint8_t get_state_nosync_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out3;
    }

    uint8_t get_state_bypass_divider_out3(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out3;
    }

    uint8_t get_state_divider_high_cycles_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out4;
    }

    uint8_t get_state_divider_low_cycles_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out4;
    }

    uint8_t get_state_phase_offset_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out4;
    }

    uint8_t get_state_start_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out4;
    }

    uint8_t get_state_force_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out4;
    }

    uint8_t get_state_nosync_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out4;
    }

    uint8_t get_state_bypass_divider_out4(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out4;
    }

    uint8_t get_state_divider_high_cycles_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out5;
    }

    uint8_t get_state_divider_low_cycles_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out5;
    }

    uint8_t get_state_phase_offset_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out5;
    }

    uint8_t get_state_start_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out5;
    }

    uint8_t get_state_force_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out5;
    }

    uint8_t get_state_nosync_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out5;
    }

    uint8_t get_state_bypass_divider_out5(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out5;
    }

    uint8_t get_state_divider_high_cycles_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out6;
    }

    uint8_t get_state_divider_low_cycles_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out6;
    }

    uint8_t get_state_phase_offset_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out6;
    }

    uint8_t get_state_start_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out6;
    }

    uint8_t get_state_force_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out6;
    }

    uint8_t get_state_nosync_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out6;
    }

    uint8_t get_state_bypass_divider_out6(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out6;
    }

    uint8_t get_state_divider_high_cycles_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_high_cycles_out7;
    }

    uint8_t get_state_divider_low_cycles_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->divider_low_cycles_out7;
    }

    uint8_t get_state_phase_offset_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->phase_offset_out7;
    }

    uint8_t get_state_start_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->start_out7;
    }

    uint8_t get_state_force_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->force_out7;
    }

    uint8_t get_state_nosync_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->nosync_out7;
    }

    uint8_t get_state_bypass_divider_out7(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->bypass_divider_out7;
    }

    sync_detect_enable_t get_state_sync_detect_enable(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sync_detect_enable;
    }

    sync_select_t get_state_sync_select(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sync_select;
    }

    uint8_t get_state_soft_sync(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->soft_sync;
    }

    uint8_t get_state_dist_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->dist_power_down;
    }

    uint8_t get_state_sync_power_down(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->sync_power_down;
    }

    function_pin_select_t get_state_function_pin_select(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->function_pin_select;
    }

    uint8_t get_state_update_registers(void){
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        return _state->update_registers;
    }


    template<typename T> std::set<T> get_changed_addrs(bool include_ro = false) {
        if (_state == NULL) throw uhd::runtime_error("no saved state");
        //check each register for changes
        std::set<T> addrs;
        if (include_ro || !false) {
            if(_state->long_instruction != this->long_instruction) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->soft_reset != this->soft_reset) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->lsb_first != this->lsb_first) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->sdo_inactive != this->sdo_inactive) {
                addrs.insert(0);
            }
        }
        if (include_ro || !false) {
            if(_state->acounter != this->acounter) {
                addrs.insert(4);
            }
        }
        if (include_ro || !false) {
            if(_state->bcounter_msb != this->bcounter_msb) {
                addrs.insert(5);
            }
        }
        if (include_ro || !false) {
            if(_state->bcounter_lsb != this->bcounter_lsb) {
                addrs.insert(6);
            }
        }
        if (include_ro || !false) {
            if(_state->lor_enable != this->lor_enable) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->lor_ildd != this->lor_ildd) {
                addrs.insert(7);
            }
        }
        if (include_ro || !false) {
            if(_state->charge_pump_mode != this->charge_pump_mode) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_mux_control != this->pll_mux_control) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->pfd_polarity != this->pfd_polarity) {
                addrs.insert(8);
            }
        }
        if (include_ro || !false) {
            if(_state->reset_all_counters != this->reset_all_counters) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->ncounter_reset != this->ncounter_reset) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->rcounter_reset != this->rcounter_reset) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->cp_current_setting != this->cp_current_setting) {
                addrs.insert(9);
            }
        }
        if (include_ro || !false) {
            if(_state->pll_power_down != this->pll_power_down) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->prescaler_value != this->prescaler_value) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->b_counter_bypass != this->b_counter_bypass) {
                addrs.insert(10);
            }
        }
        if (include_ro || !false) {
            if(_state->ref_counter_msb != this->ref_counter_msb) {
                addrs.insert(11);
            }
        }
        if (include_ro || !false) {
            if(_state->ref_counter_lsb != this->ref_counter_lsb) {
                addrs.insert(12);
            }
        }
        if (include_ro || !false) {
            if(_state->antibacklash_pw != this->antibacklash_pw) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->dld_window != this->dld_window) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->lock_detect_disable != this->lock_detect_disable) {
                addrs.insert(13);
            }
        }
        if (include_ro || !false) {
            if(_state->delay_control_out5 != this->delay_control_out5) {
                addrs.insert(52);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_current_out5 != this->ramp_current_out5) {
                addrs.insert(53);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_capacitor_out5 != this->ramp_capacitor_out5) {
                addrs.insert(53);
            }
        }
        if (include_ro || !false) {
            if(_state->delay_fine_adjust_out5 != this->delay_fine_adjust_out5) {
                addrs.insert(54);
            }
        }
        if (include_ro || !false) {
            if(_state->delay_control_out6 != this->delay_control_out6) {
                addrs.insert(56);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_current_out6 != this->ramp_current_out6) {
                addrs.insert(57);
            }
        }
        if (include_ro || !false) {
            if(_state->ramp_capacitor_out6 != this->ramp_capacitor_out6) {
                addrs.insert(57);
            }
        }
        if (include_ro || !false) {
            if(_state->delay_fine_adjust_out6 != this->delay_fine_adjust_out6) {
                addrs.insert(58);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvpecl_out0 != this->power_down_lvpecl_out0) {
                addrs.insert(60);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvpecl_out0 != this->output_level_lvpecl_out0) {
                addrs.insert(60);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvpecl_out1 != this->power_down_lvpecl_out1) {
                addrs.insert(61);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvpecl_out1 != this->output_level_lvpecl_out1) {
                addrs.insert(61);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvpecl_out2 != this->power_down_lvpecl_out2) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvpecl_out2 != this->output_level_lvpecl_out2) {
                addrs.insert(62);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvpecl_out3 != this->power_down_lvpecl_out3) {
                addrs.insert(63);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvpecl_out3 != this->output_level_lvpecl_out3) {
                addrs.insert(63);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvds_cmos_out4 != this->power_down_lvds_cmos_out4) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvds_out4 != this->output_level_lvds_out4) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->lvds_cmos_select_out4 != this->lvds_cmos_select_out4) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->inverted_cmos_driver_out4 != this->inverted_cmos_driver_out4) {
                addrs.insert(64);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvds_cmos_out5 != this->power_down_lvds_cmos_out5) {
                addrs.insert(65);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvds_out5 != this->output_level_lvds_out5) {
                addrs.insert(65);
            }
        }
        if (include_ro || !false) {
            if(_state->lvds_cmos_select_out5 != this->lvds_cmos_select_out5) {
                addrs.insert(65);
            }
        }
        if (include_ro || !false) {
            if(_state->inverted_cmos_driver_out5 != this->inverted_cmos_driver_out5) {
                addrs.insert(65);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvds_cmos_out6 != this->power_down_lvds_cmos_out6) {
                addrs.insert(66);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvds_out6 != this->output_level_lvds_out6) {
                addrs.insert(66);
            }
        }
        if (include_ro || !false) {
            if(_state->lvds_cmos_select_out6 != this->lvds_cmos_select_out6) {
                addrs.insert(66);
            }
        }
        if (include_ro || !false) {
            if(_state->inverted_cmos_driver_out6 != this->inverted_cmos_driver_out6) {
                addrs.insert(66);
            }
        }
        if (include_ro || !false) {
            if(_state->power_down_lvds_cmos_out7 != this->power_down_lvds_cmos_out7) {
                addrs.insert(67);
            }
        }
        if (include_ro || !false) {
            if(_state->output_level_lvds_out7 != this->output_level_lvds_out7) {
                addrs.insert(67);
            }
        }
        if (include_ro || !false) {
            if(_state->lvds_cmos_select_out7 != this->lvds_cmos_select_out7) {
                addrs.insert(67);
            }
        }
        if (include_ro || !false) {
            if(_state->inverted_cmos_driver_out7 != this->inverted_cmos_driver_out7) {
                addrs.insert(67);
            }
        }
        if (include_ro || !false) {
            if(_state->clock_select != this->clock_select) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->clk1_power_down != this->clk1_power_down) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->clk2_power_down != this->clk2_power_down) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->prescaler_clock_pd != this->prescaler_clock_pd) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->refin_power_down != this->refin_power_down) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->all_clock_inputs_pd != this->all_clock_inputs_pd) {
                addrs.insert(69);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out0 != this->divider_high_cycles_out0) {
                addrs.insert(72);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out0 != this->divider_low_cycles_out0) {
                addrs.insert(72);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out0 != this->phase_offset_out0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out0 != this->start_out0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out0 != this->force_out0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out0 != this->nosync_out0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out0 != this->bypass_divider_out0) {
                addrs.insert(73);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out1 != this->divider_high_cycles_out1) {
                addrs.insert(74);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out1 != this->divider_low_cycles_out1) {
                addrs.insert(74);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out1 != this->phase_offset_out1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out1 != this->start_out1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out1 != this->force_out1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out1 != this->nosync_out1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out1 != this->bypass_divider_out1) {
                addrs.insert(75);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out2 != this->divider_high_cycles_out2) {
                addrs.insert(76);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out2 != this->divider_low_cycles_out2) {
                addrs.insert(76);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out2 != this->phase_offset_out2) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out2 != this->start_out2) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out2 != this->force_out2) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out2 != this->nosync_out2) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out2 != this->bypass_divider_out2) {
                addrs.insert(77);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out3 != this->divider_high_cycles_out3) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out3 != this->divider_low_cycles_out3) {
                addrs.insert(78);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out3 != this->phase_offset_out3) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out3 != this->start_out3) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out3 != this->force_out3) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out3 != this->nosync_out3) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out3 != this->bypass_divider_out3) {
                addrs.insert(79);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out4 != this->divider_high_cycles_out4) {
                addrs.insert(80);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out4 != this->divider_low_cycles_out4) {
                addrs.insert(80);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out4 != this->phase_offset_out4) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out4 != this->start_out4) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out4 != this->force_out4) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out4 != this->nosync_out4) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out4 != this->bypass_divider_out4) {
                addrs.insert(81);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out5 != this->divider_high_cycles_out5) {
                addrs.insert(82);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out5 != this->divider_low_cycles_out5) {
                addrs.insert(82);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out5 != this->phase_offset_out5) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out5 != this->start_out5) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out5 != this->force_out5) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out5 != this->nosync_out5) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out5 != this->bypass_divider_out5) {
                addrs.insert(83);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out6 != this->divider_high_cycles_out6) {
                addrs.insert(84);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out6 != this->divider_low_cycles_out6) {
                addrs.insert(84);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out6 != this->phase_offset_out6) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out6 != this->start_out6) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out6 != this->force_out6) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out6 != this->nosync_out6) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out6 != this->bypass_divider_out6) {
                addrs.insert(85);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_high_cycles_out7 != this->divider_high_cycles_out7) {
                addrs.insert(86);
            }
        }
        if (include_ro || !false) {
            if(_state->divider_low_cycles_out7 != this->divider_low_cycles_out7) {
                addrs.insert(86);
            }
        }
        if (include_ro || !false) {
            if(_state->phase_offset_out7 != this->phase_offset_out7) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->start_out7 != this->start_out7) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->force_out7 != this->force_out7) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->nosync_out7 != this->nosync_out7) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->bypass_divider_out7 != this->bypass_divider_out7) {
                addrs.insert(87);
            }
        }
        if (include_ro || !false) {
            if(_state->sync_detect_enable != this->sync_detect_enable) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->sync_select != this->sync_select) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->soft_sync != this->soft_sync) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->dist_power_down != this->dist_power_down) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->sync_power_down != this->sync_power_down) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->function_pin_select != this->function_pin_select) {
                addrs.insert(88);
            }
        }
        if (include_ro || !false) {
            if(_state->update_registers != this->update_registers) {
                addrs.insert(90);
            }
        }
        return addrs;
    }

private:
    ad9510_regs_t *_state;
};

#endif /* INCLUDED_AD9510_REGS_HPP */
