/* Background.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Background.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-background.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/meta-background-image.h>
#include <mtk/mtk.h>

#define GREETER_COMPOSITOR_BACKGROUND_ANIMATION_OPACITY_STEP_INCREMENT 4.0
#define GREETER_COMPOSITOR_BACKGROUND_ANIMATION_MIN_WAKEUP_INTERVAL 1.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_BACKGROUND (greeter_compositor_background_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground))
#define GREETER_COMPOSITOR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackgroundClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND))
#define GREETER_COMPOSITOR_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackgroundClass))

typedef struct _GreeterCompositorBackground GreeterCompositorBackground;
typedef struct _GreeterCompositorBackgroundClass GreeterCompositorBackgroundClass;
typedef struct _GreeterCompositorBackgroundPrivate GreeterCompositorBackgroundPrivate;

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE (greeter_compositor_background_source_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))

typedef struct _GreeterCompositorBackgroundSource GreeterCompositorBackgroundSource;
typedef struct _GreeterCompositorBackgroundSourceClass GreeterCompositorBackgroundSourceClass;

#define GREETER_COMPOSITOR_TYPE_ANIMATION (greeter_compositor_animation_get_type ())
#define GREETER_COMPOSITOR_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimation))
#define GREETER_COMPOSITOR_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimationClass))
#define GREETER_COMPOSITOR_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION))
#define GREETER_COMPOSITOR_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_ANIMATION))
#define GREETER_COMPOSITOR_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimationClass))

typedef struct _GreeterCompositorAnimation GreeterCompositorAnimation;
typedef struct _GreeterCompositorAnimationClass GreeterCompositorAnimationClass;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE (greeter_compositor_background_cache_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCache))
#define GREETER_COMPOSITOR_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCacheClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE))
#define GREETER_COMPOSITOR_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCacheClass))

typedef struct _GreeterCompositorBackgroundCache GreeterCompositorBackgroundCache;
typedef struct _GreeterCompositorBackgroundCacheClass GreeterCompositorBackgroundCacheClass;
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _GreeterCompositorBackgroundLoadAnimationData GreeterCompositorBackgroundLoadAnimationData;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_CHANGED_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_LOADED_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_NUM_SIGNALS
};
static guint greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_NUM_SIGNALS] = {0};

struct _GreeterCompositorBackground {
	GObject parent_instance;
	GreeterCompositorBackgroundPrivate * priv;
};

struct _GreeterCompositorBackgroundClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorBackgroundPrivate {
	MetaDisplay* _display;
	gint _monitor_index;
	GreeterCompositorBackgroundSource* _background_source;
	gboolean _is_loaded;
	GDesktopBackgroundStyle _style;
	gchar* _filename;
	MetaBackground* _background;
	GreeterCompositorAnimation* animation;
	GeeHashMap* file_watches;
	GCancellable* cancellable;
	guint update_animation_timeout_id;
};

struct _Block2Data {
	int _ref_count_;
	GreeterCompositorBackground* self;
	gchar* filename;
};

struct _Block3Data {
	int _ref_count_;
	GreeterCompositorBackground* self;
	gchar** files;
	gint files_length1;
	gint _files_size_;
	gint num_pending_images;
};

struct _Block4Data {
	int _ref_count_;
	Block3Data * _data3_;
	MetaBackgroundImage* image;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gulong handler;
};

struct _GreeterCompositorBackgroundLoadAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorBackground* self;
	gchar* filename;
	GreeterCompositorBackgroundCache* _tmp0_;
	GreeterCompositorAnimation* _tmp1_;
	gboolean _tmp2_;
	GreeterCompositorAnimation* _tmp3_;
	GCancellable* _tmp4_;
};

struct _Block6Data {
	int _ref_count_;
	GreeterCompositorBackground* self;
	MetaBackgroundImage* image;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gulong handler;
};

static gint GreeterCompositorBackground_private_offset;
static gpointer greeter_compositor_background_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackground, g_object_unref)
VALA_EXTERN GType greeter_compositor_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundSource, g_object_unref)
VALA_EXTERN GType greeter_compositor_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorAnimation, g_object_unref)
VALA_EXTERN GreeterCompositorBackground* greeter_compositor_background_new (MetaDisplay* display,
                                                                gint monitor_index,
                                                                const gchar* filename,
                                                                GreeterCompositorBackgroundSource* background_source,
                                                                GDesktopBackgroundStyle style);
VALA_EXTERN GreeterCompositorBackground* greeter_compositor_background_construct (GType object_type,
                                                                      MetaDisplay* display,
                                                                      gint monitor_index,
                                                                      const gchar* filename,
                                                                      GreeterCompositorBackgroundSource* background_source,
                                                                      GDesktopBackgroundStyle style);
VALA_EXTERN void greeter_compositor_background_destroy (GreeterCompositorBackground* self);
static void greeter_compositor_background_remove_animation_timeout (GreeterCompositorBackground* self);
VALA_EXTERN GType greeter_compositor_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundCache, g_object_unref)
VALA_EXTERN GreeterCompositorBackgroundCache* greeter_compositor_background_cache_get_default (void);
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_get_background_source (GreeterCompositorBackground* self);
static void greeter_compositor_background_settings_changed (GreeterCompositorBackground* self);
static void _greeter_compositor_background_settings_changed_greeter_compositor_background_source_changed (GreeterCompositorBackgroundSource* _sender,
                                                                                                   gpointer self);
VALA_EXTERN void greeter_compositor_background_update_resolution (GreeterCompositorBackground* self);
static void greeter_compositor_background_update_animation (GreeterCompositorBackground* self);
static void greeter_compositor_background_set_loaded (GreeterCompositorBackground* self);
VALA_EXTERN gboolean greeter_compositor_background_get_is_loaded (GreeterCompositorBackground* self);
static void greeter_compositor_background_set_is_loaded (GreeterCompositorBackground* self,
                                                  gboolean value);
static gboolean __lambda11_ (GreeterCompositorBackground* self);
static gboolean ___lambda11__gsource_func (gpointer self);
static void greeter_compositor_background_load_pattern (GreeterCompositorBackground* self);
VALA_EXTERN GSettings* greeter_compositor_background_source_get_gnome_background_settings (GreeterCompositorBackgroundSource* self);
static void _vala_ClutterColor_free (ClutterColor* self);
VALA_EXTERN MetaBackground* greeter_compositor_background_get_background (GreeterCompositorBackground* self);
static void greeter_compositor_background_watch_file (GreeterCompositorBackground* self,
                                               const gchar* filename);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void greeter_compositor_background_cache_monitor_file (GreeterCompositorBackgroundCache* self,
                                                       const gchar* filename);
static void __lambda10_ (Block2Data* _data2_,
                  const gchar* changed_file);
static void ___lambda10__greeter_compositor_background_cache_file_changed (GreeterCompositorBackgroundCache* _sender,
                                                                    const gchar* filename,
                                                                    gpointer self);
static void greeter_compositor_background_finish_animation (GreeterCompositorBackground* self,
                                                     gchar** files,
                                                     gint files_length1);
VALA_EXTERN gdouble greeter_compositor_animation_get_transition_progress (GreeterCompositorAnimation* self);
VALA_EXTERN GDesktopBackgroundStyle greeter_compositor_background_get_style (GreeterCompositorBackground* self);
static void greeter_compositor_background_queue_update_animation (GreeterCompositorBackground* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void greeter_compositor_animation_update (GreeterCompositorAnimation* self,
                                          MtkRectangle* monitor);
VALA_EXTERN MetaDisplay* greeter_compositor_background_get_display (GreeterCompositorBackground* self);
VALA_EXTERN gint greeter_compositor_background_get_monitor_index (GreeterCompositorBackground* self);
VALA_EXTERN gchar** greeter_compositor_animation_get_key_frame_files (GreeterCompositorAnimation* self,
                                                          gint* result_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ______lambda13_ (Block5Data* _data5_);
static void _______lambda13__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                                    gpointer self);
VALA_EXTERN gdouble greeter_compositor_animation_get_transition_duration (GreeterCompositorAnimation* self);
static gboolean __lambda12_ (GreeterCompositorBackground* self);
static gboolean ___lambda12__gsource_func (gpointer self);
static void greeter_compositor_background_load_animation_data_free (gpointer _data);
static void greeter_compositor_background_load_animation (GreeterCompositorBackground* self,
                                                   const gchar* filename,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void greeter_compositor_background_load_animation_finish (GreeterCompositorBackground* self,
                                                          GAsyncResult* _res_);
static gboolean greeter_compositor_background_load_animation_co (GreeterCompositorBackgroundLoadAnimationData* _data_);
VALA_EXTERN void greeter_compositor_background_cache_get_animation (GreeterCompositorBackgroundCache* self,
                                                        const gchar* filename,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN GreeterCompositorAnimation* greeter_compositor_background_cache_get_animation_finish (GreeterCompositorBackgroundCache* self,
                                                                                      GAsyncResult* _res_);
static void greeter_compositor_background_load_animation_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void greeter_compositor_background_load_image (GreeterCompositorBackground* self,
                                               const gchar* filename);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda16_ (Block7Data* _data7_);
static void ____lambda16__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                                 gpointer self);
static void greeter_compositor_background_load_file (GreeterCompositorBackground* self,
                                              const gchar* filename);
static void greeter_compositor_background_load (GreeterCompositorBackground* self);
VALA_EXTERN const gchar* greeter_compositor_background_get_filename (GreeterCompositorBackground* self);
static void greeter_compositor_background_set_display (GreeterCompositorBackground* self,
                                                MetaDisplay* value);
static void greeter_compositor_background_set_monitor_index (GreeterCompositorBackground* self,
                                                      gint value);
static void greeter_compositor_background_set_background_source (GreeterCompositorBackground* self,
                                                          GreeterCompositorBackgroundSource* value);
static void greeter_compositor_background_set_style (GreeterCompositorBackground* self,
                                              GDesktopBackgroundStyle value);
static void greeter_compositor_background_set_filename (GreeterCompositorBackground* self,
                                                 const gchar* value);
static void greeter_compositor_background_set_background (GreeterCompositorBackground* self,
                                                   MetaBackground* value);
static GObject * greeter_compositor_background_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void greeter_compositor_background_finalize (GObject * obj);
static GType greeter_compositor_background_get_type_once (void);
static void _vala_greeter_compositor_background_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_greeter_compositor_background_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
greeter_compositor_background_get_instance_private (GreeterCompositorBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBackground_private_offset);
}

GreeterCompositorBackground*
greeter_compositor_background_construct (GType object_type,
                                         MetaDisplay* display,
                                         gint monitor_index,
                                         const gchar* filename,
                                         GreeterCompositorBackgroundSource* background_source,
                                         GDesktopBackgroundStyle style)
{
	GreeterCompositorBackground * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (background_source != NULL, NULL);
	self = (GreeterCompositorBackground*) g_object_new (object_type, "display", display, "monitor-index", monitor_index, "background-source", background_source, "style", style, "filename", filename, NULL);
	return self;
}

GreeterCompositorBackground*
greeter_compositor_background_new (MetaDisplay* display,
                                   gint monitor_index,
                                   const gchar* filename,
                                   GreeterCompositorBackgroundSource* background_source,
                                   GDesktopBackgroundStyle style)
{
	return greeter_compositor_background_construct (GREETER_COMPOSITOR_TYPE_BACKGROUND, display, monitor_index, filename, background_source, style);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_greeter_compositor_background_settings_changed_greeter_compositor_background_source_changed (GreeterCompositorBackgroundSource* _sender,
                                                                                              gpointer self)
{
	greeter_compositor_background_settings_changed ((GreeterCompositorBackground*) self);
}

void
greeter_compositor_background_destroy (GreeterCompositorBackground* self)
{
	GCancellable* _tmp0_;
	GreeterCompositorBackgroundCache* cache = NULL;
	GreeterCompositorBackgroundCache* _tmp1_;
	GreeterCompositorBackgroundCache* _tmp2_;
	GreeterCompositorBackgroundSource* _tmp13_;
	guint _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
	greeter_compositor_background_remove_animation_timeout (self);
	_tmp1_ = greeter_compositor_background_cache_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	cache = _tmp2_;
	{
		GeeIterator* _watch_it = NULL;
		GeeHashMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp3_ = self->priv->file_watches;
		_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_watch_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			gulong watch = 0UL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			GreeterCompositorBackgroundCache* _tmp12_;
			_tmp9_ = _watch_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _watch_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			watch = (gulong) ((guintptr) _tmp11_);
			_tmp12_ = cache;
			g_signal_handler_disconnect ((GObject*) _tmp12_, watch);
		}
		_g_object_unref0 (_watch_it);
	}
	_tmp13_ = self->priv->_background_source;
	g_signal_parse_name ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, &_tmp14_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _greeter_compositor_background_settings_changed_greeter_compositor_background_source_changed, self);
	_g_object_unref0 (cache);
}

void
greeter_compositor_background_update_resolution (GreeterCompositorBackground* self)
{
	GreeterCompositorAnimation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->animation;
	if (_tmp0_ != NULL) {
		greeter_compositor_background_remove_animation_timeout (self);
		greeter_compositor_background_update_animation (self);
	}
}

static gboolean
__lambda11_ (GreeterCompositorBackground* self)
{
	gboolean result;
	g_signal_emit (self, greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_LOADED_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((GreeterCompositorBackground*) self);
	return result;
}

static void
greeter_compositor_background_set_loaded (GreeterCompositorBackground* self)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_loaded;
	if (_tmp0_) {
		return;
	}
	greeter_compositor_background_set_is_loaded (self, TRUE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
greeter_compositor_background_load_pattern (GreeterCompositorBackground* self)
{
	gchar* color_string = NULL;
	GSettings* settings = NULL;
	GreeterCompositorBackgroundSource* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	ClutterColor* color = NULL;
	const gchar* _tmp6_;
	ClutterColor* _tmp7_;
	ClutterColor* _tmp8_;
	gint shading_type = 0;
	GSettings* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_background_source;
	_tmp1_ = greeter_compositor_background_source_get_gnome_background_settings (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	settings = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_string (_tmp4_, "primary-color");
	_g_free0 (color_string);
	color_string = _tmp5_;
	_tmp6_ = color_string;
	_tmp7_ = _vala_clutter_color_from_string (_tmp6_);
	color = _tmp7_;
	_tmp8_ = color;
	if (_tmp8_ == NULL) {
		ClutterColor* _tmp9_;
		_tmp9_ = _vala_clutter_color_from_string ("black");
		__vala_ClutterColor_free0 (color);
		color = _tmp9_;
	}
	_tmp10_ = settings;
	shading_type = g_settings_get_enum (_tmp10_, "color-shading-type");
	if (shading_type == ((gint) G_DESKTOP_BACKGROUND_SHADING_SOLID)) {
		MetaBackground* _tmp11_;
		ClutterColor* _tmp12_;
		ClutterColor _tmp13_;
		_tmp11_ = self->priv->_background;
		_tmp12_ = color;
		_tmp13_ = *_tmp12_;
		meta_background_set_color (_tmp11_, &_tmp13_);
	} else {
		GSettings* _tmp14_;
		gchar* _tmp15_;
		ClutterColor* second_color = NULL;
		const gchar* _tmp16_;
		ClutterColor* _tmp17_;
		ClutterColor* _tmp18_;
		MetaBackground* _tmp20_;
		ClutterColor* _tmp21_;
		ClutterColor* _tmp22_;
		ClutterColor _tmp23_;
		ClutterColor _tmp24_;
		_tmp14_ = settings;
		_tmp15_ = g_settings_get_string (_tmp14_, "secondary-color");
		_g_free0 (color_string);
		color_string = _tmp15_;
		_tmp16_ = color_string;
		_tmp17_ = _vala_clutter_color_from_string (_tmp16_);
		second_color = _tmp17_;
		_tmp18_ = second_color;
		if (_tmp18_ == NULL) {
			ClutterColor* _tmp19_;
			_tmp19_ = _vala_clutter_color_from_string ("black");
			__vala_ClutterColor_free0 (second_color);
			second_color = _tmp19_;
		}
		_tmp20_ = self->priv->_background;
		_tmp21_ = color;
		_tmp22_ = second_color;
		_tmp23_ = *_tmp21_;
		_tmp24_ = *_tmp22_;
		meta_background_set_gradient (_tmp20_, (GDesktopBackgroundShading) shading_type, &_tmp23_, &_tmp24_);
		__vala_ClutterColor_free0 (second_color);
	}
	__vala_ClutterColor_free0 (color);
	_g_object_unref0 (settings);
	_g_free0 (color_string);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data2_->self;
		_g_free0 (_data2_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda10_ (Block2Data* _data2_,
             const gchar* changed_file)
{
	GreeterCompositorBackground* self;
	self = _data2_->self;
	g_return_if_fail (changed_file != NULL);
	if (g_strcmp0 (changed_file, _data2_->filename) == 0) {
		MetaBackgroundImageCache* image_cache = NULL;
		MetaBackgroundImageCache* _tmp0_;
		MetaBackgroundImageCache* _tmp1_;
		MetaBackgroundImageCache* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp0_ = meta_background_image_cache_get_default ();
		_tmp1_ = _g_object_ref0 (_tmp0_);
		image_cache = _tmp1_;
		_tmp2_ = image_cache;
		_tmp3_ = g_file_new_for_path (changed_file);
		_tmp4_ = _tmp3_;
		meta_background_image_cache_purge (_tmp2_, _tmp4_);
		_g_object_unref0 (_tmp4_);
		g_signal_emit (self, greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_CHANGED_SIGNAL], 0);
		_g_object_unref0 (image_cache);
	}
}

static void
___lambda10__greeter_compositor_background_cache_file_changed (GreeterCompositorBackgroundCache* _sender,
                                                               const gchar* filename,
                                                               gpointer self)
{
	__lambda10_ (self, filename);
}

static void
greeter_compositor_background_watch_file (GreeterCompositorBackground* self,
                                          const gchar* filename)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GreeterCompositorBackgroundCache* cache = NULL;
	GreeterCompositorBackgroundCache* _tmp2_;
	GreeterCompositorBackgroundCache* _tmp3_;
	GreeterCompositorBackgroundCache* _tmp4_;
	GeeHashMap* _tmp5_;
	GreeterCompositorBackgroundCache* _tmp6_;
	gulong _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data2_->filename);
	_data2_->filename = _tmp0_;
	_tmp1_ = self->priv->file_watches;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _data2_->filename)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp2_ = greeter_compositor_background_cache_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cache = _tmp3_;
	_tmp4_ = cache;
	greeter_compositor_background_cache_monitor_file (_tmp4_, _data2_->filename);
	_tmp5_ = self->priv->file_watches;
	_tmp6_ = cache;
	_tmp7_ = g_signal_connect_data (_tmp6_, "file-changed", (GCallback) ___lambda10__greeter_compositor_background_cache_file_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _data2_->filename, (gpointer) ((guintptr) _tmp7_));
	_g_object_unref0 (cache);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
greeter_compositor_background_remove_animation_timeout (GreeterCompositorBackground* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_animation_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->update_animation_timeout_id);
		self->priv->update_animation_timeout_id = (guint) 0;
	}
}

static void
greeter_compositor_background_finish_animation (GreeterCompositorBackground* self,
                                                gchar** files,
                                                gint files_length1)
{
	g_return_if_fail (self != NULL);
	greeter_compositor_background_set_loaded (self);
	if (files_length1 > 1) {
		MetaBackground* _tmp0_;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GreeterCompositorAnimation* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		GDesktopBackgroundStyle _tmp10_;
		_tmp0_ = self->priv->_background;
		_tmp1_ = files[0];
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = files[1];
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->animation;
		_tmp8_ = greeter_compositor_animation_get_transition_progress (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_style;
		meta_background_set_blend (_tmp0_, _tmp3_, _tmp6_, _tmp9_, _tmp10_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp3_);
	} else {
		if (files_length1 > 0) {
			MetaBackground* _tmp11_;
			const gchar* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			GDesktopBackgroundStyle _tmp15_;
			_tmp11_ = self->priv->_background;
			_tmp12_ = files[0];
			_tmp13_ = g_file_new_for_path (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_style;
			meta_background_set_file (_tmp11_, _tmp14_, _tmp15_);
			_g_object_unref0 (_tmp14_);
		} else {
			MetaBackground* _tmp16_;
			GDesktopBackgroundStyle _tmp17_;
			_tmp16_ = self->priv->_background;
			_tmp17_ = self->priv->_style;
			meta_background_set_file (_tmp16_, NULL, _tmp17_);
		}
	}
	greeter_compositor_background_queue_update_animation (self);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data3_->self;
		_data3_->files = (_vala_array_free (_data3_->files, _data3_->files_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data4_->_data3_->self;
		_g_object_unref0 (_data4_->image);
		block3_data_unref (_data4_->_data3_);
		_data4_->_data3_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data5_->_data4_->_data3_->self;
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
______lambda13_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	Block3Data* _data3_;
	GreeterCompositorBackground* self;
	MetaBackgroundImage* _tmp0_;
	gint _tmp1_;
	_data4_ = _data5_->_data4_;
	_data3_ = _data4_->_data3_;
	self = _data3_->self;
	_tmp0_ = _data4_->image;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data5_->handler);
	_data3_->num_pending_images = _data3_->num_pending_images - 1;
	_tmp1_ = _data3_->num_pending_images;
	if (_tmp1_ == 0) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = _data3_->files;
		_tmp2__length1 = _data3_->files_length1;
		greeter_compositor_background_finish_animation (self, _tmp2_, (gint) _tmp2__length1);
	}
}

static void
_______lambda13__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                               gpointer self)
{
	______lambda13_ (self);
}

static void
greeter_compositor_background_update_animation (GreeterCompositorBackground* self)
{
	Block3Data* _data3_;
	GreeterCompositorAnimation* _tmp0_;
	MetaDisplay* _tmp1_;
	gint _tmp2_;
	MtkRectangle _tmp3_ = {0};
	GreeterCompositorAnimation* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	MetaBackgroundImageCache* cache = NULL;
	MetaBackgroundImageCache* _tmp9_;
	MetaBackgroundImageCache* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	self->priv->update_animation_timeout_id = (guint) 0;
	_tmp0_ = self->priv->animation;
	_tmp1_ = self->priv->_display;
	_tmp2_ = self->priv->_monitor_index;
	meta_display_get_monitor_geometry (_tmp1_, _tmp2_, &_tmp3_);
	greeter_compositor_animation_update (_tmp0_, &_tmp3_);
	_tmp4_ = self->priv->animation;
	_tmp5_ = greeter_compositor_animation_get_key_frame_files (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup2 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_data3_->files = _tmp8_;
	_data3_->files_length1 = _tmp8__length1;
	_data3_->_files_size_ = _data3_->files_length1;
	_tmp9_ = meta_background_image_cache_get_default ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	cache = _tmp10_;
	_tmp11_ = _data3_->files;
	_tmp11__length1 = _data3_->files_length1;
	_data3_->num_pending_images = _tmp11__length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				Block4Data* _data4_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				MetaBackgroundImageCache* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				GFile* _tmp20_;
				GFile* _tmp21_;
				MetaBackgroundImage* _tmp22_;
				MetaBackgroundImage* _tmp23_;
				MetaBackgroundImage* _tmp24_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->_data3_ = block3_data_ref (_data3_);
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = _data3_->files;
				_tmp14__length1 = _data3_->files_length1;
				if (!(i < _tmp14__length1)) {
					block4_data_unref (_data4_);
					_data4_ = NULL;
					break;
				}
				_tmp15_ = _data3_->files;
				_tmp15__length1 = _data3_->files_length1;
				_tmp16_ = _tmp15_[i];
				greeter_compositor_background_watch_file (self, _tmp16_);
				_tmp17_ = cache;
				_tmp18_ = _data3_->files;
				_tmp18__length1 = _data3_->files_length1;
				_tmp19_ = _tmp18_[i];
				_tmp20_ = g_file_new_for_path (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = meta_background_image_cache_load (_tmp17_, _tmp21_);
				_tmp23_ = _tmp22_;
				_g_object_unref0 (_tmp21_);
				_data4_->image = _tmp23_;
				_tmp24_ = _data4_->image;
				if (meta_background_image_is_loaded (_tmp24_)) {
					gint _tmp25_;
					_tmp25_ = _data3_->num_pending_images;
					_data3_->num_pending_images = _tmp25_ - 1;
					if (_data3_->num_pending_images == 0) {
						gchar** _tmp26_;
						gint _tmp26__length1;
						_tmp26_ = _data3_->files;
						_tmp26__length1 = _data3_->files_length1;
						greeter_compositor_background_finish_animation (self, _tmp26_, (gint) _tmp26__length1);
					}
				} else {
					Block5Data* _data5_;
					MetaBackgroundImage* _tmp27_;
					gulong _tmp28_;
					_data5_ = g_slice_new0 (Block5Data);
					_data5_->_ref_count_ = 1;
					_data5_->_data4_ = block4_data_ref (_data4_);
					_data5_->handler = (gulong) 0;
					_tmp27_ = _data4_->image;
					_tmp28_ = g_signal_connect_data (_tmp27_, "loaded", (GCallback) _______lambda13__meta_background_image_loaded, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
					_data5_->handler = _tmp28_;
					block5_data_unref (_data5_);
					_data5_ = NULL;
				}
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_g_object_unref0 (cache);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static gboolean
__lambda12_ (GreeterCompositorBackground* self)
{
	gboolean result;
	self->priv->update_animation_timeout_id = (guint) 0;
	greeter_compositor_background_update_animation (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((GreeterCompositorBackground*) self);
	return result;
}

static void
greeter_compositor_background_queue_update_animation (GreeterCompositorBackground* self)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GreeterCompositorAnimation* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble n_steps = 0.0;
	gdouble time_per_step = 0.0;
	GreeterCompositorAnimation* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	guint32 interval = 0U;
	g_return_if_fail (self != NULL);
	if (self->priv->update_animation_timeout_id != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->cancellable;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GCancellable* _tmp2_;
		_tmp2_ = self->priv->cancellable;
		_tmp0_ = g_cancellable_is_cancelled (_tmp2_);
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->animation;
	_tmp4_ = greeter_compositor_animation_get_transition_duration (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == ((gdouble) 0)) {
		return;
	}
	n_steps = 255.0 / GREETER_COMPOSITOR_BACKGROUND_ANIMATION_OPACITY_STEP_INCREMENT;
	_tmp6_ = self->priv->animation;
	_tmp7_ = greeter_compositor_animation_get_transition_duration (_tmp6_);
	_tmp8_ = _tmp7_;
	time_per_step = (_tmp8_ * 1000) / n_steps;
	interval = (guint32) fmax (GREETER_COMPOSITOR_BACKGROUND_ANIMATION_MIN_WAKEUP_INTERVAL * 1000, time_per_step);
	if (interval > G_MAXUINT32) {
		return;
	}
	self->priv->update_animation_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) interval, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

static void
greeter_compositor_background_load_animation_data_free (gpointer _data)
{
	GreeterCompositorBackgroundLoadAnimationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorBackgroundLoadAnimationData, _data_);
}

static void
greeter_compositor_background_load_animation (GreeterCompositorBackground* self,
                                              const gchar* filename,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GreeterCompositorBackgroundLoadAnimationData* _data_;
	GreeterCompositorBackground* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (GreeterCompositorBackgroundLoadAnimationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_background_load_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	greeter_compositor_background_load_animation_co (_data_);
}

static void
greeter_compositor_background_load_animation_finish (GreeterCompositorBackground* self,
                                                     GAsyncResult* _res_)
{
	GreeterCompositorBackgroundLoadAnimationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
greeter_compositor_background_load_animation_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GreeterCompositorBackgroundLoadAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	greeter_compositor_background_load_animation_co (_data_);
}

static gboolean
greeter_compositor_background_load_animation_co (GreeterCompositorBackgroundLoadAnimationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = greeter_compositor_background_cache_get_default ();
	_data_->_state_ = 1;
	greeter_compositor_background_cache_get_animation (_data_->_tmp0_, _data_->filename, greeter_compositor_background_load_animation_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = greeter_compositor_background_cache_get_animation_finish (_data_->_tmp0_, _data_->_res_);
	_g_object_unref0 (_data_->self->priv->animation);
	_data_->self->priv->animation = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->animation;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->self->priv->cancellable;
		_data_->_tmp2_ = g_cancellable_is_cancelled (_data_->_tmp4_);
	}
	if (_data_->_tmp2_) {
		greeter_compositor_background_set_loaded (_data_->self);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	greeter_compositor_background_update_animation (_data_->self);
	greeter_compositor_background_watch_file (_data_->self, _data_->filename);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->image);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GreeterCompositorBackground* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda16_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	GreeterCompositorBackground* self;
	MetaBackgroundImage* _tmp0_;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	greeter_compositor_background_set_loaded (self);
	_tmp0_ = _data6_->image;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data7_->handler);
}

static void
____lambda16__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                            gpointer self)
{
	___lambda16_ (self);
}

static void
greeter_compositor_background_load_image (GreeterCompositorBackground* self,
                                          const gchar* filename)
{
	Block6Data* _data6_;
	MetaBackground* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GDesktopBackgroundStyle _tmp3_;
	MetaBackgroundImageCache* cache = NULL;
	MetaBackgroundImageCache* _tmp4_;
	MetaBackgroundImageCache* _tmp5_;
	MetaBackgroundImageCache* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	MetaBackgroundImage* _tmp9_;
	MetaBackgroundImage* _tmp10_;
	MetaBackgroundImage* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->_background;
	_tmp1_ = g_file_new_for_path (filename);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_style;
	meta_background_set_file (_tmp0_, _tmp2_, _tmp3_);
	_g_object_unref0 (_tmp2_);
	greeter_compositor_background_watch_file (self, filename);
	_tmp4_ = meta_background_image_cache_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	cache = _tmp5_;
	_tmp6_ = cache;
	_tmp7_ = g_file_new_for_path (filename);
	_tmp8_ = _tmp7_;
	_tmp9_ = meta_background_image_cache_load (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_data6_->image = _tmp10_;
	_tmp11_ = _data6_->image;
	if (meta_background_image_is_loaded (_tmp11_)) {
		greeter_compositor_background_set_loaded (self);
	} else {
		Block7Data* _data7_;
		MetaBackgroundImage* _tmp12_;
		gulong _tmp13_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->_data6_ = block6_data_ref (_data6_);
		_data7_->handler = (gulong) 0;
		_tmp12_ = _data6_->image;
		_tmp13_ = g_signal_connect_data (_tmp12_, "loaded", (GCallback) ____lambda16__meta_background_image_loaded, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_data7_->handler = _tmp13_;
		block7_data_unref (_data7_);
		_data7_ = NULL;
	}
	_g_object_unref0 (cache);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
greeter_compositor_background_load_file (GreeterCompositorBackground* self,
                                         const gchar* filename)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	if (g_str_has_suffix (filename, ".xml")) {
		greeter_compositor_background_load_animation (self, filename, NULL, NULL);
	} else {
		greeter_compositor_background_load_image (self, filename);
	}
}

static void
greeter_compositor_background_load (GreeterCompositorBackground* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	greeter_compositor_background_load_pattern (self);
	_tmp0_ = self->priv->_filename;
	if (_tmp0_ == NULL) {
		greeter_compositor_background_set_loaded (self);
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_filename;
		greeter_compositor_background_load_file (self, _tmp1_);
	}
}

static void
greeter_compositor_background_settings_changed (GreeterCompositorBackground* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_CHANGED_SIGNAL], 0);
}

MetaDisplay*
greeter_compositor_background_get_display (GreeterCompositorBackground* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_set_display (GreeterCompositorBackground* self,
                                           MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY]);
	}
}

gint
greeter_compositor_background_get_monitor_index (GreeterCompositorBackground* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_index;
	return result;
}

static void
greeter_compositor_background_set_monitor_index (GreeterCompositorBackground* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_monitor_index (self);
	if (old_value != value) {
		self->priv->_monitor_index = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY]);
	}
}

GreeterCompositorBackgroundSource*
greeter_compositor_background_get_background_source (GreeterCompositorBackground* self)
{
	GreeterCompositorBackgroundSource* result;
	GreeterCompositorBackgroundSource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background_source;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_set_background_source (GreeterCompositorBackground* self,
                                                     GreeterCompositorBackgroundSource* value)
{
	GreeterCompositorBackgroundSource* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_background_source (self);
	if (old_value != value) {
		GreeterCompositorBackgroundSource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background_source);
		self->priv->_background_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY]);
	}
}

gboolean
greeter_compositor_background_get_is_loaded (GreeterCompositorBackground* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_loaded;
	return result;
}

static void
greeter_compositor_background_set_is_loaded (GreeterCompositorBackground* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_is_loaded (self);
	if (old_value != value) {
		self->priv->_is_loaded = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY]);
	}
}

GDesktopBackgroundStyle
greeter_compositor_background_get_style (GreeterCompositorBackground* self)
{
	GDesktopBackgroundStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

static void
greeter_compositor_background_set_style (GreeterCompositorBackground* self,
                                         GDesktopBackgroundStyle value)
{
	GDesktopBackgroundStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY]);
	}
}

const gchar*
greeter_compositor_background_get_filename (GreeterCompositorBackground* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_set_filename (GreeterCompositorBackground* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_filename (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY]);
	}
}

MetaBackground*
greeter_compositor_background_get_background (GreeterCompositorBackground* self)
{
	MetaBackground* result;
	MetaBackground* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_background;
	result = _tmp0_;
	return result;
}

static void
greeter_compositor_background_set_background (GreeterCompositorBackground* self,
                                              MetaBackground* value)
{
	MetaBackground* old_value;
	g_return_if_fail (self != NULL);
	old_value = greeter_compositor_background_get_background (self);
	if (old_value != value) {
		MetaBackground* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_background);
		self->priv->_background = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY]);
	}
}

static GObject *
greeter_compositor_background_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorBackground * self;
	MetaDisplay* _tmp0_;
	MetaBackground* _tmp1_;
	MetaBackground* _tmp2_;
	MetaBackground* _tmp3_;
	GeeHashMap* _tmp4_;
	GCancellable* _tmp5_;
	GreeterCompositorBackgroundSource* _tmp6_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_background_new (_tmp0_);
	_tmp2_ = _tmp1_;
	greeter_compositor_background_set_background (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_background;
	g_object_set_data_full ((GObject*) _tmp3_, "delegate", self, NULL);
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_watches);
	self->priv->file_watches = _tmp4_;
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp5_;
	_tmp6_ = self->priv->_background_source;
	g_signal_connect_object (_tmp6_, "changed", (GCallback) _greeter_compositor_background_settings_changed_greeter_compositor_background_source_changed, self, 0);
	greeter_compositor_background_load (self);
	return obj;
}

static void
greeter_compositor_background_class_init (GreeterCompositorBackgroundClass * klass,
                                          gpointer klass_data)
{
	greeter_compositor_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBackground_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_compositor_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_compositor_background_set_property;
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY] = g_param_spec_int ("monitor-index", "monitor-index", "monitor-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY] = g_param_spec_object ("background-source", "background-source", "background-source", GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY] = g_param_spec_boolean ("is-loaded", "is-loaded", "is-loaded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY] = g_param_spec_int ("style", "style", "style", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY, greeter_compositor_background_properties[GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY] = g_param_spec_object ("background", "background", "background", meta_background_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_CHANGED_SIGNAL] = g_signal_new ("changed", GREETER_COMPOSITOR_TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	greeter_compositor_background_signals[GREETER_COMPOSITOR_BACKGROUND_LOADED_SIGNAL] = g_signal_new ("loaded", GREETER_COMPOSITOR_TYPE_BACKGROUND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
greeter_compositor_background_instance_init (GreeterCompositorBackground * self,
                                             gpointer klass)
{
	self->priv = greeter_compositor_background_get_instance_private (self);
	self->priv->_is_loaded = FALSE;
	self->priv->animation = NULL;
	self->priv->update_animation_timeout_id = (guint) 0;
}

static void
greeter_compositor_background_finalize (GObject * obj)
{
	GreeterCompositorBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_background_source);
	_g_free0 (self->priv->_filename);
	_g_object_unref0 (self->priv->_background);
	_g_object_unref0 (self->priv->animation);
	_g_object_unref0 (self->priv->file_watches);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (greeter_compositor_background_parent_class)->finalize (obj);
}

static GType
greeter_compositor_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackground), 0, (GInstanceInitFunc) greeter_compositor_background_instance_init, NULL };
	GType greeter_compositor_background_type_id;
	greeter_compositor_background_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorBackground", &g_define_type_info, 0);
	GreeterCompositorBackground_private_offset = g_type_add_instance_private (greeter_compositor_background_type_id, sizeof (GreeterCompositorBackgroundPrivate));
	return greeter_compositor_background_type_id;
}

GType
greeter_compositor_background_get_type (void)
{
	static volatile gsize greeter_compositor_background_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_type_id__once)) {
		GType greeter_compositor_background_type_id;
		greeter_compositor_background_type_id = greeter_compositor_background_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_type_id__once, greeter_compositor_background_type_id);
	}
	return greeter_compositor_background_type_id__once;
}

static void
_vala_greeter_compositor_background_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GreeterCompositorBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY:
		g_value_set_object (value, greeter_compositor_background_get_display (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY:
		g_value_set_int (value, greeter_compositor_background_get_monitor_index (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY:
		g_value_set_object (value, greeter_compositor_background_get_background_source (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY:
		g_value_set_boolean (value, greeter_compositor_background_get_is_loaded (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY:
		g_value_set_int (value, greeter_compositor_background_get_style (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY:
		g_value_set_string (value, greeter_compositor_background_get_filename (self));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY:
		g_value_set_object (value, greeter_compositor_background_get_background (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_greeter_compositor_background_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GreeterCompositorBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GREETER_COMPOSITOR_TYPE_BACKGROUND, GreeterCompositorBackground);
	switch (property_id) {
		case GREETER_COMPOSITOR_BACKGROUND_DISPLAY_PROPERTY:
		greeter_compositor_background_set_display (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_MONITOR_INDEX_PROPERTY:
		greeter_compositor_background_set_monitor_index (self, g_value_get_int (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_SOURCE_PROPERTY:
		greeter_compositor_background_set_background_source (self, g_value_get_object (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_IS_LOADED_PROPERTY:
		greeter_compositor_background_set_is_loaded (self, g_value_get_boolean (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_STYLE_PROPERTY:
		greeter_compositor_background_set_style (self, g_value_get_int (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_FILENAME_PROPERTY:
		greeter_compositor_background_set_filename (self, g_value_get_string (value));
		break;
		case GREETER_COMPOSITOR_BACKGROUND_BACKGROUND_PROPERTY:
		greeter_compositor_background_set_background (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

