/* BackgroundCache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundCache.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2024 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <meta/display.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE (greeter_compositor_background_cache_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCache))
#define GREETER_COMPOSITOR_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCacheClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE))
#define GREETER_COMPOSITOR_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE))
#define GREETER_COMPOSITOR_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCacheClass))

typedef struct _GreeterCompositorBackgroundCache GreeterCompositorBackgroundCache;
typedef struct _GreeterCompositorBackgroundCacheClass GreeterCompositorBackgroundCacheClass;
typedef struct _GreeterCompositorBackgroundCachePrivate GreeterCompositorBackgroundCachePrivate;

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE (greeter_compositor_background_source_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSource))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE))
#define GREETER_COMPOSITOR_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_SOURCE, GreeterCompositorBackgroundSourceClass))

typedef struct _GreeterCompositorBackgroundSource GreeterCompositorBackgroundSource;
typedef struct _GreeterCompositorBackgroundSourceClass GreeterCompositorBackgroundSourceClass;

#define GREETER_COMPOSITOR_TYPE_ANIMATION (greeter_compositor_animation_get_type ())
#define GREETER_COMPOSITOR_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimation))
#define GREETER_COMPOSITOR_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimationClass))
#define GREETER_COMPOSITOR_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION))
#define GREETER_COMPOSITOR_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_ANIMATION))
#define GREETER_COMPOSITOR_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_ANIMATION, GreeterCompositorAnimationClass))

typedef struct _GreeterCompositorAnimation GreeterCompositorAnimation;
typedef struct _GreeterCompositorAnimationClass GreeterCompositorAnimationClass;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_CACHE_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_CACHE_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_cache_properties[GREETER_COMPOSITOR_BACKGROUND_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _GreeterCompositorBackgroundCacheGetAnimationData GreeterCompositorBackgroundCacheGetAnimationData;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_CACHE_NUM_SIGNALS
};
static guint greeter_compositor_background_cache_signals[GREETER_COMPOSITOR_BACKGROUND_CACHE_NUM_SIGNALS] = {0};

struct _GreeterCompositorBackgroundCache {
	GObject parent_instance;
	GreeterCompositorBackgroundCachePrivate * priv;
};

struct _GreeterCompositorBackgroundCacheClass {
	GObjectClass parent_class;
};

struct _GreeterCompositorBackgroundCachePrivate {
	GeeHashMap* file_monitors;
	GreeterCompositorBackgroundSource* background_source;
	GreeterCompositorAnimation* animation;
};

struct _Block8Data {
	int _ref_count_;
	GreeterCompositorBackgroundCache* self;
	gchar* filename;
};

struct _Block9Data {
	int _ref_count_;
	GreeterCompositorBackgroundCache* self;
	gpointer _async_data_;
};

struct _GreeterCompositorBackgroundCacheGetAnimationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorBackgroundCache* self;
	gchar* filename;
	GreeterCompositorAnimation* result;
	Block9Data* _data9_;
	gboolean _tmp0_;
	GreeterCompositorAnimation* _tmp1_;
	GreeterCompositorAnimation* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GreeterCompositorAnimation* _tmp5_;
	GreeterCompositorAnimation* _tmp6_;
	GreeterCompositorAnimation* animation;
	GreeterCompositorAnimation* _tmp7_;
	GreeterCompositorAnimation* _tmp8_;
};

static gint GreeterCompositorBackgroundCache_private_offset;
static gpointer greeter_compositor_background_cache_parent_class = NULL;
static GreeterCompositorBackgroundCache* greeter_compositor_background_cache_instance;
static GreeterCompositorBackgroundCache* greeter_compositor_background_cache_instance = NULL;

VALA_EXTERN GType greeter_compositor_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundCache, g_object_unref)
VALA_EXTERN GType greeter_compositor_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundSource, g_object_unref)
VALA_EXTERN GType greeter_compositor_animation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorAnimation, g_object_unref)
VALA_EXTERN GreeterCompositorBackgroundCache* greeter_compositor_background_cache_get_default (void);
VALA_EXTERN GreeterCompositorBackgroundCache* greeter_compositor_background_cache_new (void);
VALA_EXTERN GreeterCompositorBackgroundCache* greeter_compositor_background_cache_construct (GType object_type);
VALA_EXTERN void greeter_compositor_background_cache_monitor_file (GreeterCompositorBackgroundCache* self,
                                                       const gchar* filename);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda6_ (Block8Data* _data8_);
static void ____lambda6__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void greeter_compositor_background_cache_get_animation_data_free (gpointer _data);
VALA_EXTERN void greeter_compositor_background_cache_get_animation (GreeterCompositorBackgroundCache* self,
                                                        const gchar* filename,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN GreeterCompositorAnimation* greeter_compositor_background_cache_get_animation_finish (GreeterCompositorBackgroundCache* self,
                                                                                      GAsyncResult* _res_);
static gboolean greeter_compositor_background_cache_get_animation_co (GreeterCompositorBackgroundCacheGetAnimationData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN const gchar* greeter_compositor_animation_get_filename (GreeterCompositorAnimation* self);
static gboolean ___lambda7_ (Block9Data* _data9_);
static gboolean ____lambda7__gsource_func (gpointer self);
VALA_EXTERN GreeterCompositorAnimation* greeter_compositor_animation_new (const gchar* filename);
VALA_EXTERN GreeterCompositorAnimation* greeter_compositor_animation_construct (GType object_type,
                                                                    const gchar* filename);
VALA_EXTERN void greeter_compositor_animation_load (GreeterCompositorAnimation* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void greeter_compositor_animation_load_finish (GreeterCompositorAnimation* self,
                                               GAsyncResult* _res_);
static void greeter_compositor_background_cache_get_animation_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static gboolean __lambda8_ (Block9Data* _data9_);
static gboolean ___lambda8__gsource_func (gpointer self);
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_cache_get_background_source (GreeterCompositorBackgroundCache* self,
                                                                                              MetaDisplay* display);
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_source_new (MetaDisplay* display);
VALA_EXTERN GreeterCompositorBackgroundSource* greeter_compositor_background_source_construct (GType object_type,
                                                                                   MetaDisplay* display);
VALA_EXTERN void greeter_compositor_background_source_set_use_count (GreeterCompositorBackgroundSource* self,
                                                         gint value);
VALA_EXTERN gint greeter_compositor_background_source_get_use_count (GreeterCompositorBackgroundSource* self);
VALA_EXTERN void greeter_compositor_background_cache_release_background_source (GreeterCompositorBackgroundCache* self);
VALA_EXTERN void greeter_compositor_background_source_destroy (GreeterCompositorBackgroundSource* self);
static GObject * greeter_compositor_background_cache_constructor (GType type,
                                                           guint n_construct_properties,
                                                           GObjectConstructParam * construct_properties);
static void greeter_compositor_background_cache_finalize (GObject * obj);
static GType greeter_compositor_background_cache_get_type_once (void);

static inline gpointer
greeter_compositor_background_cache_get_instance_private (GreeterCompositorBackgroundCache* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterCompositorBackgroundCache_private_offset);
}

GreeterCompositorBackgroundCache*
greeter_compositor_background_cache_get_default (void)
{
	GreeterCompositorBackgroundCache* _tmp0_;
	GreeterCompositorBackgroundCache* _tmp2_;
	GreeterCompositorBackgroundCache* result;
	_tmp0_ = greeter_compositor_background_cache_instance;
	if (_tmp0_ == NULL) {
		GreeterCompositorBackgroundCache* _tmp1_;
		_tmp1_ = greeter_compositor_background_cache_new ();
		_g_object_unref0 (greeter_compositor_background_cache_instance);
		greeter_compositor_background_cache_instance = _tmp1_;
	}
	_tmp2_ = greeter_compositor_background_cache_instance;
	result = _tmp2_;
	return result;
}

GreeterCompositorBackgroundCache*
greeter_compositor_background_cache_construct (GType object_type)
{
	GreeterCompositorBackgroundCache * self = NULL;
	self = (GreeterCompositorBackgroundCache*) g_object_new (object_type, NULL);
	return self;
}

GreeterCompositorBackgroundCache*
greeter_compositor_background_cache_new (void)
{
	return greeter_compositor_background_cache_construct (GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GreeterCompositorBackgroundCache* self;
		self = _data8_->self;
		_g_free0 (_data8_->filename);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
___lambda6_ (Block8Data* _data8_)
{
	GreeterCompositorBackgroundCache* self;
	self = _data8_->self;
	g_signal_emit (self, greeter_compositor_background_cache_signals[GREETER_COMPOSITOR_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL], 0, _data8_->filename);
}

static void
____lambda6__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda6_ (self);
}

void
greeter_compositor_background_cache_monitor_file (GreeterCompositorBackgroundCache* self,
                                                  const gchar* filename)
{
	Block8Data* _data8_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_strdup (filename);
	_g_free0 (_data8_->filename);
	_data8_->filename = _tmp0_;
	_tmp1_ = self->priv->file_monitors;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, _data8_->filename)) {
		block8_data_unref (_data8_);
		_data8_ = NULL;
		return;
	}
	_tmp2_ = g_file_new_for_path (_data8_->filename);
	file = _tmp2_;
	{
		GFileMonitor* monitor = NULL;
		GFile* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GeeHashMap* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp3_ = file;
		_tmp4_ = g_file_monitor (_tmp3_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		monitor = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = monitor;
		g_signal_connect_data (_tmp5_, "changed", (GCallback) ____lambda6__g_file_monitor_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
		_tmp6_ = self->priv->file_monitors;
		_tmp7_ = monitor;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _data8_->filename, _tmp7_);
		_g_object_unref0 (monitor);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("BackgroundCache.vala:46: Failed to monitor %s: %s", _data8_->filename, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		block8_data_unref (_data8_);
		_data8_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
greeter_compositor_background_cache_get_animation_data_free (gpointer _data)
{
	GreeterCompositorBackgroundCacheGetAnimationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GreeterCompositorBackgroundCacheGetAnimationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
greeter_compositor_background_cache_get_animation (GreeterCompositorBackgroundCache* self,
                                                   const gchar* filename,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GreeterCompositorBackgroundCacheGetAnimationData* _data_;
	GreeterCompositorBackgroundCache* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (GreeterCompositorBackgroundCacheGetAnimationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_background_cache_get_animation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	greeter_compositor_background_cache_get_animation_co (_data_);
}

GreeterCompositorAnimation*
greeter_compositor_background_cache_get_animation_finish (GreeterCompositorBackgroundCache* self,
                                                          GAsyncResult* _res_)
{
	GreeterCompositorAnimation* result;
	GreeterCompositorBackgroundCacheGetAnimationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		GreeterCompositorBackgroundCache* self;
		self = _data9_->self;
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
___lambda7_ (Block9Data* _data9_)
{
	GreeterCompositorBackgroundCache* self;
	gboolean result;
	self = _data9_->self;
	greeter_compositor_background_cache_get_animation_co (_data9_->_async_data_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}

static void
greeter_compositor_background_cache_get_animation_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GreeterCompositorBackgroundCacheGetAnimationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	greeter_compositor_background_cache_get_animation_co (_data_);
}

static gboolean
__lambda8_ (Block9Data* _data9_)
{
	GreeterCompositorBackgroundCache* self;
	gboolean result;
	self = _data9_->self;
	greeter_compositor_background_cache_get_animation_co (_data9_->_async_data_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ (self);
	return result;
}

static gboolean
greeter_compositor_background_cache_get_animation_co (GreeterCompositorBackgroundCacheGetAnimationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->priv->animation;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->animation;
		_data_->_tmp3_ = greeter_compositor_animation_get_filename (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = g_strcmp0 (_data_->_tmp4_, _data_->filename) == 0;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda7__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp5_ = _data_->self->priv->animation;
		_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = greeter_compositor_animation_new (_data_->filename);
	_data_->animation = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->animation;
	_data_->_state_ = 2;
	greeter_compositor_animation_load (_data_->_tmp8_, greeter_compositor_background_cache_get_animation_ready, _data_);
	return FALSE;
	_state_2:
	greeter_compositor_animation_load_finish (_data_->_tmp8_, _data_->_res_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda8__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	_data_->result = _data_->animation;
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GreeterCompositorBackgroundSource*
greeter_compositor_background_cache_get_background_source (GreeterCompositorBackgroundCache* self,
                                                           MetaDisplay* display)
{
	GreeterCompositorBackgroundSource* _tmp0_;
	GreeterCompositorBackgroundSource* _tmp6_;
	GreeterCompositorBackgroundSource* _tmp7_;
	GreeterCompositorBackgroundSource* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	_tmp0_ = self->priv->background_source;
	if (_tmp0_ == NULL) {
		GreeterCompositorBackgroundSource* _tmp1_;
		GreeterCompositorBackgroundSource* _tmp2_;
		_tmp1_ = greeter_compositor_background_source_new (display);
		_g_object_unref0 (self->priv->background_source);
		self->priv->background_source = _tmp1_;
		_tmp2_ = self->priv->background_source;
		greeter_compositor_background_source_set_use_count (_tmp2_, 1);
	} else {
		GreeterCompositorBackgroundSource* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->background_source;
		_tmp4_ = greeter_compositor_background_source_get_use_count (_tmp3_);
		_tmp5_ = _tmp4_;
		greeter_compositor_background_source_set_use_count (_tmp3_, _tmp5_ + 1);
	}
	_tmp6_ = self->priv->background_source;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

void
greeter_compositor_background_cache_release_background_source (GreeterCompositorBackgroundCache* self)
{
	GreeterCompositorBackgroundSource* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->background_source;
	_tmp1_ = greeter_compositor_background_source_get_use_count (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2_ = _tmp2_ - 1;
	_tmp3_ = _tmp2_;
	greeter_compositor_background_source_set_use_count (_tmp0_, _tmp3_);
	if (_tmp3_ == 0) {
		GreeterCompositorBackgroundSource* _tmp4_;
		_tmp4_ = self->priv->background_source;
		greeter_compositor_background_source_destroy (_tmp4_);
	}
}

static GObject *
greeter_compositor_background_cache_constructor (GType type,
                                                 guint n_construct_properties,
                                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterCompositorBackgroundCache * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (greeter_compositor_background_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCache);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_monitor_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->file_monitors);
	self->priv->file_monitors = _tmp0_;
	return obj;
}

static void
greeter_compositor_background_cache_class_init (GreeterCompositorBackgroundCacheClass * klass,
                                                gpointer klass_data)
{
	greeter_compositor_background_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterCompositorBackgroundCache_private_offset);
	G_OBJECT_CLASS (klass)->constructor = greeter_compositor_background_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_compositor_background_cache_finalize;
	greeter_compositor_background_cache_signals[GREETER_COMPOSITOR_BACKGROUND_CACHE_FILE_CHANGED_SIGNAL] = g_signal_new ("file-changed", GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
greeter_compositor_background_cache_instance_init (GreeterCompositorBackgroundCache * self,
                                                   gpointer klass)
{
	self->priv = greeter_compositor_background_cache_get_instance_private (self);
}

static void
greeter_compositor_background_cache_finalize (GObject * obj)
{
	GreeterCompositorBackgroundCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_COMPOSITOR_TYPE_BACKGROUND_CACHE, GreeterCompositorBackgroundCache);
	_g_object_unref0 (self->priv->file_monitors);
	_g_object_unref0 (self->priv->background_source);
	_g_object_unref0 (self->priv->animation);
	G_OBJECT_CLASS (greeter_compositor_background_cache_parent_class)->finalize (obj);
}

static GType
greeter_compositor_background_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackgroundCache), 0, (GInstanceInitFunc) greeter_compositor_background_cache_instance_init, NULL };
	GType greeter_compositor_background_cache_type_id;
	greeter_compositor_background_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "GreeterCompositorBackgroundCache", &g_define_type_info, 0);
	GreeterCompositorBackgroundCache_private_offset = g_type_add_instance_private (greeter_compositor_background_cache_type_id, sizeof (GreeterCompositorBackgroundCachePrivate));
	return greeter_compositor_background_cache_type_id;
}

GType
greeter_compositor_background_cache_get_type (void)
{
	static volatile gsize greeter_compositor_background_cache_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_cache_type_id__once)) {
		GType greeter_compositor_background_cache_type_id;
		greeter_compositor_background_cache_type_id = greeter_compositor_background_cache_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_cache_type_id__once, greeter_compositor_background_cache_type_id);
	}
	return greeter_compositor_background_cache_type_id__once;
}

