/* BackgroundUtils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackgroundUtils.vala, do not modify */

/*
 * Copyright 2024 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */
/*
 *   The method for calculating the background information and the classes that are
 *   related to it are copied from Gala.DBus.
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include <string.h>
#include <gio/gio.h>
#include <meta/meta-plugin.h>
#include <meta/meta-background-actor.h>
#include <meta/meta-background-group.h>
#include <meta/display.h>
#include <stdlib.h>
#include <cogl/cogl.h>

#define GREETER_COMPOSITOR_BACKGROUND_UTILS_SATURATION_WEIGHT 1.5
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_WEIGHT_THRESHOLD 1.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT (greeter_compositor_background_utils_dummy_offscreen_effect_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, GreeterCompositorBackgroundUtilsDummyOffscreenEffect))
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass))
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_IS_DUMMY_OFFSCREEN_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_IS_DUMMY_OFFSCREEN_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT))
#define GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass))

typedef struct _GreeterCompositorBackgroundUtilsDummyOffscreenEffect GreeterCompositorBackgroundUtilsDummyOffscreenEffect;
typedef struct _GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass;
typedef struct _GreeterCompositorBackgroundUtilsDummyOffscreenEffectPrivate GreeterCompositorBackgroundUtilsDummyOffscreenEffectPrivate;
enum  {
	GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_0_PROPERTY,
	GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES
};
static GParamSpec* greeter_compositor_background_utils_dummy_offscreen_effect_properties[GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_PROPERTIES];
enum  {
	GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL,
	GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS
};
static guint greeter_compositor_background_utils_dummy_offscreen_effect_signals[GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_NUM_SIGNALS] = {0};

#define GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_COLOR_INFORMATION (greeter_compositor_background_utils_color_information_get_type ())
typedef struct _GreeterCompositorBackgroundUtilsColorInformation GreeterCompositorBackgroundUtilsColorInformation;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER (greeter_compositor_window_manager_get_type ())
#define GREETER_COMPOSITOR_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManager))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_IS_WINDOW_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER))
#define GREETER_COMPOSITOR_WINDOW_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_WINDOW_MANAGER, GreeterCompositorWindowManagerClass))

typedef struct _GreeterCompositorWindowManager GreeterCompositorWindowManager;
typedef struct _GreeterCompositorWindowManagerClass GreeterCompositorWindowManagerClass;
typedef struct _Block19Data Block19Data;

#define GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER (greeter_compositor_background_manager_get_type ())
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager))
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManagerClass))
#define GREETER_COMPOSITOR_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER))
#define GREETER_COMPOSITOR_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER))
#define GREETER_COMPOSITOR_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManagerClass))

typedef struct _GreeterCompositorBackgroundManager GreeterCompositorBackgroundManager;
typedef struct _GreeterCompositorBackgroundManagerClass GreeterCompositorBackgroundManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData;

struct _GreeterCompositorBackgroundUtilsDummyOffscreenEffect {
	ClutterOffscreenEffect parent_instance;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffectPrivate * priv;
};

struct _GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass {
	ClutterOffscreenEffectClass parent_class;
};

struct _GreeterCompositorBackgroundUtilsColorInformation {
	gdouble average_red;
	gdouble average_green;
	gdouble average_blue;
	gdouble mean_luminance;
	gdouble luminance_variance;
	gdouble mean_acutance;
};

struct _Block19Data {
	int _ref_count_;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* effect;
	MetaBackgroundActor* newest_background_actor;
	gint x_start;
	gint y_start;
	gint width;
	gint height;
	gdouble mean_acutance;
	gdouble variance;
	gdouble mean;
	gdouble r_total;
	gdouble g_total;
	gdouble b_total;
	gulong paint_signal_handler;
	gpointer _async_data_;
};

struct _GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GreeterCompositorWindowManager* wm;
	gint reference_x;
	gint reference_y;
	gint reference_width;
	gint reference_height;
	GreeterCompositorBackgroundUtilsColorInformation result;
	Block19Data* _data19_;
	GreeterCompositorBackgroundManager* bg_manager;
	MetaBackgroundGroup* _tmp0_;
	MetaBackgroundGroup* _tmp1_;
	MetaDisplay* _tmp2_;
	ClutterActor* _tmp3_;
	GreeterCompositorBackgroundManager* _tmp4_;
	GreeterCompositorBackgroundManager* _tmp5_;
	MetaDisplay* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp11_;
	GreeterCompositorBackgroundManager* _tmp12_;
	MetaBackgroundActor* _tmp13_;
	MetaBackgroundActor* _tmp14_;
	MetaBackgroundActor* _tmp15_;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp16_;
	gint bg_actor_width;
	MetaBackgroundActor* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gint bg_actor_height;
	MetaBackgroundActor* _tmp20_;
	gfloat _tmp21_;
	gfloat _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp30_;
	gulong _tmp31_;
	MetaBackgroundActor* _tmp32_;
	GreeterCompositorBackgroundUtilsColorInformation _tmp33_;
	GError* _inner_error0_;
};

static gpointer greeter_compositor_background_utils_dummy_offscreen_effect_parent_class = NULL;

VALA_EXTERN GType greeter_compositor_background_utils_dummy_offscreen_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundUtilsDummyOffscreenEffect, g_object_unref)
static void greeter_compositor_background_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                                                 ClutterPaintNode* node,
                                                                                 ClutterPaintContext* context);
static gboolean __lambda44_ (GreeterCompositorBackgroundUtilsDummyOffscreenEffect* self);
static gboolean ___lambda44__gsource_func (gpointer self);
VALA_EXTERN GreeterCompositorBackgroundUtilsDummyOffscreenEffect* greeter_compositor_background_utils_dummy_offscreen_effect_new (void);
VALA_EXTERN GreeterCompositorBackgroundUtilsDummyOffscreenEffect* greeter_compositor_background_utils_dummy_offscreen_effect_construct (GType object_type);
static GType greeter_compositor_background_utils_dummy_offscreen_effect_get_type_once (void);
VALA_EXTERN GType greeter_compositor_background_utils_color_information_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GreeterCompositorBackgroundUtilsColorInformation* greeter_compositor_background_utils_color_information_dup (const GreeterCompositorBackgroundUtilsColorInformation* self);
VALA_EXTERN void greeter_compositor_background_utils_color_information_free (GreeterCompositorBackgroundUtilsColorInformation* self);
static void greeter_compositor_background_utils_get_background_color_information_data_free (gpointer _data);
VALA_EXTERN GType greeter_compositor_window_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorWindowManager, g_object_unref)
VALA_EXTERN void greeter_compositor_background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                                           gint reference_x,
                                                                           gint reference_y,
                                                                           gint reference_width,
                                                                           gint reference_height,
                                                                           GAsyncReadyCallback _callback_,
                                                                           gpointer _user_data_);
VALA_EXTERN void greeter_compositor_background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                                                  GreeterCompositorBackgroundUtilsColorInformation* result,
                                                                                  GError** error);
static gboolean greeter_compositor_background_utils_get_background_color_information_co (GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData* _data_);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
VALA_EXTERN GType greeter_compositor_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterCompositorBackgroundManager, g_object_unref)
VALA_EXTERN MetaBackgroundGroup* greeter_compositor_window_manager_get_background_group (GreeterCompositorWindowManager* self);
VALA_EXTERN MetaBackgroundActor* greeter_compositor_background_manager_get_newest_background_actor (GreeterCompositorBackgroundManager* self);
static void __lambda45_ (Block19Data* _data19_);
static void ___lambda45__greeter_compositor_background_utils_dummy_offscreen_effect_done_painting (GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _sender,
                                                                                            gpointer self);

static gboolean
__lambda44_ (GreeterCompositorBackgroundUtilsDummyOffscreenEffect* self)
{
	gboolean result;
	g_signal_emit (self, greeter_compositor_background_utils_dummy_offscreen_effect_signals[GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL], 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda44__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda44_ ((GreeterCompositorBackgroundUtilsDummyOffscreenEffect*) self);
	return result;
}

static void
greeter_compositor_background_utils_dummy_offscreen_effect_real_post_paint (ClutterEffect* base,
                                                                            ClutterPaintNode* node,
                                                                            ClutterPaintContext* context)
{
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect * self;
	self = (GreeterCompositorBackgroundUtilsDummyOffscreenEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	CLUTTER_EFFECT_CLASS (greeter_compositor_background_utils_dummy_offscreen_effect_parent_class)->post_paint ((ClutterEffect*) G_TYPE_CHECK_INSTANCE_CAST (self, clutter_offscreen_effect_get_type (), ClutterOffscreenEffect), node, context);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda44__gsource_func, g_object_ref (self), g_object_unref);
}

GreeterCompositorBackgroundUtilsDummyOffscreenEffect*
greeter_compositor_background_utils_dummy_offscreen_effect_construct (GType object_type)
{
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect * self = NULL;
	self = (GreeterCompositorBackgroundUtilsDummyOffscreenEffect*) g_object_new (object_type, NULL);
	return self;
}

GreeterCompositorBackgroundUtilsDummyOffscreenEffect*
greeter_compositor_background_utils_dummy_offscreen_effect_new (void)
{
	return greeter_compositor_background_utils_dummy_offscreen_effect_construct (GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT);
}

static void
greeter_compositor_background_utils_dummy_offscreen_effect_class_init (GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass * klass,
                                                                       gpointer klass_data)
{
	greeter_compositor_background_utils_dummy_offscreen_effect_parent_class = g_type_class_peek_parent (klass);
	((ClutterEffectClass *) klass)->post_paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*)) greeter_compositor_background_utils_dummy_offscreen_effect_real_post_paint;
	greeter_compositor_background_utils_dummy_offscreen_effect_signals[GREETER_COMPOSITOR_BACKGROUND_UTILS_DUMMY_OFFSCREEN_EFFECT_DONE_PAINTING_SIGNAL] = g_signal_new ("done-painting", GREETER_COMPOSITOR_BACKGROUND_UTILS_TYPE_DUMMY_OFFSCREEN_EFFECT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
greeter_compositor_background_utils_dummy_offscreen_effect_instance_init (GreeterCompositorBackgroundUtilsDummyOffscreenEffect * self,
                                                                          gpointer klass)
{
}

static GType
greeter_compositor_background_utils_dummy_offscreen_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterCompositorBackgroundUtilsDummyOffscreenEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_compositor_background_utils_dummy_offscreen_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterCompositorBackgroundUtilsDummyOffscreenEffect), 0, (GInstanceInitFunc) greeter_compositor_background_utils_dummy_offscreen_effect_instance_init, NULL };
	GType greeter_compositor_background_utils_dummy_offscreen_effect_type_id;
	greeter_compositor_background_utils_dummy_offscreen_effect_type_id = g_type_register_static (clutter_offscreen_effect_get_type (), "GreeterCompositorBackgroundUtilsDummyOffscreenEffect", &g_define_type_info, 0);
	return greeter_compositor_background_utils_dummy_offscreen_effect_type_id;
}

GType
greeter_compositor_background_utils_dummy_offscreen_effect_get_type (void)
{
	static volatile gsize greeter_compositor_background_utils_dummy_offscreen_effect_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_utils_dummy_offscreen_effect_type_id__once)) {
		GType greeter_compositor_background_utils_dummy_offscreen_effect_type_id;
		greeter_compositor_background_utils_dummy_offscreen_effect_type_id = greeter_compositor_background_utils_dummy_offscreen_effect_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_utils_dummy_offscreen_effect_type_id__once, greeter_compositor_background_utils_dummy_offscreen_effect_type_id);
	}
	return greeter_compositor_background_utils_dummy_offscreen_effect_type_id__once;
}

GreeterCompositorBackgroundUtilsColorInformation*
greeter_compositor_background_utils_color_information_dup (const GreeterCompositorBackgroundUtilsColorInformation* self)
{
	GreeterCompositorBackgroundUtilsColorInformation* dup;
	dup = g_new0 (GreeterCompositorBackgroundUtilsColorInformation, 1);
	memcpy (dup, self, sizeof (GreeterCompositorBackgroundUtilsColorInformation));
	return dup;
}

void
greeter_compositor_background_utils_color_information_free (GreeterCompositorBackgroundUtilsColorInformation* self)
{
	g_free (self);
}

static GType
greeter_compositor_background_utils_color_information_get_type_once (void)
{
	GType greeter_compositor_background_utils_color_information_type_id;
	greeter_compositor_background_utils_color_information_type_id = g_boxed_type_register_static ("GreeterCompositorBackgroundUtilsColorInformation", (GBoxedCopyFunc) greeter_compositor_background_utils_color_information_dup, (GBoxedFreeFunc) greeter_compositor_background_utils_color_information_free);
	return greeter_compositor_background_utils_color_information_type_id;
}

GType
greeter_compositor_background_utils_color_information_get_type (void)
{
	static volatile gsize greeter_compositor_background_utils_color_information_type_id__once = 0;
	if (g_once_init_enter (&greeter_compositor_background_utils_color_information_type_id__once)) {
		GType greeter_compositor_background_utils_color_information_type_id;
		greeter_compositor_background_utils_color_information_type_id = greeter_compositor_background_utils_color_information_get_type_once ();
		g_once_init_leave (&greeter_compositor_background_utils_color_information_type_id__once, greeter_compositor_background_utils_color_information_type_id);
	}
	return greeter_compositor_background_utils_color_information_type_id__once;
}

static void
greeter_compositor_background_utils_get_background_color_information_data_free (gpointer _data)
{
	GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wm);
	g_slice_free (GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
greeter_compositor_background_utils_get_background_color_information (GreeterCompositorWindowManager* wm,
                                                                      gint reference_x,
                                                                      gint reference_y,
                                                                      gint reference_width,
                                                                      gint reference_height,
                                                                      GAsyncReadyCallback _callback_,
                                                                      gpointer _user_data_)
{
	GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData* _data_;
	GreeterCompositorWindowManager* _tmp0_;
	g_return_if_fail (wm != NULL);
	_data_ = g_slice_new0 (GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, greeter_compositor_background_utils_get_background_color_information_data_free);
	_tmp0_ = _g_object_ref0 (wm);
	_g_object_unref0 (_data_->wm);
	_data_->wm = _tmp0_;
	_data_->reference_x = reference_x;
	_data_->reference_y = reference_y;
	_data_->reference_width = reference_width;
	_data_->reference_height = reference_height;
	greeter_compositor_background_utils_get_background_color_information_co (_data_);
}

void
greeter_compositor_background_utils_get_background_color_information_finish (GAsyncResult* _res_,
                                                                             GreeterCompositorBackgroundUtilsColorInformation* result,
                                                                             GError** error)
{
	GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	*result = _data_->result;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		_g_object_unref0 (_data19_->effect);
		g_slice_free (Block19Data, _data19_);
	}
}

static void
__lambda45_ (Block19Data* _data19_)
{
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp2_;
	CoglTexture* texture = NULL;
	GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _tmp3_;
	CoglTexture* _tmp4_;
	CoglTexture* _tmp5_;
	guint texture_width = 0U;
	CoglTexture* _tmp6_;
	guint texture_height = 0U;
	CoglTexture* _tmp7_;
	guint8* pixels = NULL;
	guint8* _tmp8_;
	gint pixels_length1;
	gint _pixels_size_;
	gdouble* pixel_lums = NULL;
	gdouble* _tmp9_;
	gint pixel_lums_length1;
	gint _pixel_lums_size_;
	CoglTexture* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	gint size = 0;
	gdouble mean_squares = 0.0;
	gdouble pixel = 0.0;
	gdouble max = 0.0;
	gdouble min = 0.0;
	gdouble score = 0.0;
	gdouble delta = 0.0;
	gdouble score_total = 0.0;
	gdouble r_total2 = 0.0;
	gdouble g_total2 = 0.0;
	gdouble b_total2 = 0.0;
	gdouble max_val = 0.0;
	_tmp0_ = _data19_->effect;
	g_signal_handler_disconnect (_tmp0_, _data19_->paint_signal_handler);
	_tmp1_ = _data19_->newest_background_actor;
	_tmp2_ = _data19_->effect;
	clutter_actor_remove_effect ((ClutterActor*) _tmp1_, (ClutterEffect*) _tmp2_);
	_tmp3_ = _data19_->effect;
	_tmp4_ = clutter_offscreen_effect_get_texture ((ClutterOffscreenEffect*) _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, cogl_texture_get_type (), CoglTexture));
	texture = _tmp5_;
	_tmp6_ = texture;
	texture_width = cogl_texture_get_width (_tmp6_);
	_tmp7_ = texture;
	texture_height = cogl_texture_get_height (_tmp7_);
	_tmp8_ = g_new0 (guint8, (texture_width * texture_height) * 4);
	pixels = _tmp8_;
	pixels_length1 = (texture_width * texture_height) * 4;
	_pixels_size_ = pixels_length1;
	_tmp9_ = g_new0 (gdouble, texture_width * texture_height);
	pixel_lums = _tmp9_;
	pixel_lums_length1 = texture_width * texture_height;
	_pixel_lums_size_ = pixel_lums_length1;
	_tmp10_ = texture;
	_tmp11_ = pixels;
	_tmp11__length1 = pixels_length1;
	cogl_texture_get_data (_tmp10_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, (guint) 0, _tmp11_);
	size = _data19_->width * _data19_->height;
	mean_squares = (gdouble) 0;
	pixel = (gdouble) 0;
	score_total = (gdouble) 0;
	r_total2 = (gdouble) 0;
	g_total2 = (gdouble) 0;
	b_total2 = (gdouble) 0;
	{
		gint y = 0;
		y = _data19_->y_start;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = y;
					y = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(y < (_data19_->y_start + _data19_->height))) {
					break;
				}
				{
					gint x = 0;
					x = _data19_->x_start;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint i = 0;
							guint8 b = 0U;
							guint8* _tmp16_;
							gint _tmp16__length1;
							guint8 _tmp17_;
							guint8 g = 0U;
							guint8* _tmp18_;
							gint _tmp18__length1;
							guint8 _tmp19_;
							guint8 r = 0U;
							guint8* _tmp20_;
							gint _tmp20__length1;
							guint8 _tmp21_;
							gdouble* _tmp22_;
							gint _tmp22__length1;
							gdouble _tmp23_ = 0.0;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = x;
								x = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(x < (_data19_->x_start + _data19_->width))) {
								break;
							}
							i = ((y * ((gint) texture_width)) * 4) + (x * 4);
							_tmp16_ = pixels;
							_tmp16__length1 = pixels_length1;
							_tmp17_ = _tmp16_[i];
							b = _tmp17_;
							_tmp18_ = pixels;
							_tmp18__length1 = pixels_length1;
							_tmp19_ = _tmp18_[i + 1];
							g = _tmp19_;
							_tmp20_ = pixels;
							_tmp20__length1 = pixels_length1;
							_tmp21_ = _tmp20_[i + 2];
							r = _tmp21_;
							pixel = ((0.3 * r) + (0.59 * g)) + (0.11 * b);
							_tmp22_ = pixel_lums;
							_tmp22__length1 = pixel_lums_length1;
							_tmp22_[(y * _data19_->width) + x] = pixel;
							min = (gdouble) MIN (r, MIN (g, b));
							max = (gdouble) MAX (r, MAX (g, b));
							delta = max - min;
							if (delta == ((gdouble) 0)) {
								_tmp23_ = 0.0;
							} else {
								_tmp23_ = delta / max;
							}
							score = GREETER_COMPOSITOR_BACKGROUND_UTILS_SATURATION_WEIGHT * _tmp23_;
							_data19_->r_total += score * r;
							_data19_->g_total += score * g;
							_data19_->b_total += score * b;
							score_total += score;
							_data19_->r_total += (gdouble) r;
							_data19_->g_total += (gdouble) g;
							_data19_->b_total += (gdouble) b;
							_data19_->mean += pixel;
							mean_squares += pixel * pixel;
						}
					}
				}
			}
		}
	}
	{
		gint y = 0;
		y = _data19_->y_start + 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y;
					y = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(y < ((_data19_->y_start + _data19_->height) - 1))) {
					break;
				}
				{
					gint x = 0;
					x = _data19_->x_start + 1;
					{
						gboolean _tmp26_ = FALSE;
						_tmp26_ = TRUE;
						while (TRUE) {
							gdouble acutance = 0.0;
							gdouble* _tmp28_;
							gint _tmp28__length1;
							gdouble _tmp29_;
							gdouble* _tmp30_;
							gint _tmp30__length1;
							gdouble _tmp31_;
							gdouble* _tmp32_;
							gint _tmp32__length1;
							gdouble _tmp33_;
							gdouble* _tmp34_;
							gint _tmp34__length1;
							gdouble _tmp35_;
							gdouble* _tmp36_;
							gint _tmp36__length1;
							gdouble _tmp37_;
							gdouble _tmp38_ = 0.0;
							if (!_tmp26_) {
								gint _tmp27_;
								_tmp27_ = x;
								x = _tmp27_ + 1;
							}
							_tmp26_ = FALSE;
							if (!(x < ((_data19_->x_start + _data19_->width) - 1))) {
								break;
							}
							_tmp28_ = pixel_lums;
							_tmp28__length1 = pixel_lums_length1;
							_tmp29_ = _tmp28_[(y * _data19_->width) + x];
							_tmp30_ = pixel_lums;
							_tmp30__length1 = pixel_lums_length1;
							_tmp31_ = _tmp30_[((y * _data19_->width) + x) - 1];
							_tmp32_ = pixel_lums;
							_tmp32__length1 = pixel_lums_length1;
							_tmp33_ = _tmp32_[((y * _data19_->width) + x) + 1];
							_tmp34_ = pixel_lums;
							_tmp34__length1 = pixel_lums_length1;
							_tmp35_ = _tmp34_[((y - 1) * _data19_->width) + x];
							_tmp36_ = pixel_lums;
							_tmp36__length1 = pixel_lums_length1;
							_tmp37_ = _tmp36_[((y + 1) * _data19_->width) + x];
							acutance = (_tmp29_ * 4) - (((_tmp31_ + _tmp33_) + _tmp35_) + _tmp37_);
							if (acutance > ((gdouble) 0)) {
								_tmp38_ = acutance;
							} else {
								_tmp38_ = -acutance;
							}
							_data19_->mean_acutance += _tmp38_;
						}
					}
				}
			}
		}
	}
	score_total /= (gdouble) size;
	_data19_->b_total /= (gdouble) size;
	_data19_->g_total /= (gdouble) size;
	_data19_->r_total /= (gdouble) size;
	if (score_total > 0.0) {
		_data19_->b_total /= score_total;
		_data19_->g_total /= score_total;
		_data19_->r_total /= score_total;
	}
	b_total2 /= (gdouble) (size * G_MAXUINT8);
	g_total2 /= (gdouble) (size * G_MAXUINT8);
	r_total2 /= (gdouble) (size * G_MAXUINT8);
	if (score_total <= GREETER_COMPOSITOR_BACKGROUND_UTILS_WEIGHT_THRESHOLD) {
		gdouble f = 0.0;
		gdouble rf = 0.0;
		f = (1.0 / GREETER_COMPOSITOR_BACKGROUND_UTILS_WEIGHT_THRESHOLD) * score_total;
		rf = 1.0 - f;
		_data19_->b_total = (_data19_->b_total * f) + (b_total2 * rf);
		_data19_->g_total = (_data19_->g_total * f) + (g_total2 * rf);
		_data19_->r_total = (_data19_->r_total * f) + (r_total2 * rf);
	}
	max_val = MAX (_data19_->r_total, MAX (_data19_->g_total, _data19_->b_total));
	if (max_val > 1.0) {
		_data19_->b_total /= max_val;
		_data19_->g_total /= max_val;
		_data19_->r_total /= max_val;
	}
	_data19_->mean /= (gdouble) size;
	mean_squares = mean_squares / size;
	_data19_->variance = mean_squares - (_data19_->mean * _data19_->mean);
	_data19_->mean_acutance /= (gdouble) ((_data19_->width - 2) * (_data19_->height - 2));
	greeter_compositor_background_utils_get_background_color_information_co (_data19_->_async_data_);
	pixel_lums = (g_free (pixel_lums), NULL);
	pixels = (g_free (pixels), NULL);
	_g_object_unref0 (texture);
}

static void
___lambda45__greeter_compositor_background_utils_dummy_offscreen_effect_done_painting (GreeterCompositorBackgroundUtilsDummyOffscreenEffect* _sender,
                                                                                       gpointer self)
{
	__lambda45_ (self);
}

static gboolean
greeter_compositor_background_utils_get_background_color_information_co (GreeterCompositorBackgroundUtilsGetBackgroundColorInformationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data19_ = g_slice_new0 (Block19Data);
	_data_->_data19_->_ref_count_ = 1;
	_data_->_data19_->_async_data_ = _data_;
	_data_->_tmp0_ = greeter_compositor_window_manager_get_background_group (_data_->wm);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _data_->wm);
	_data_->_tmp3_ = clutter_actor_get_child_at_index ((ClutterActor*) _data_->_tmp1_, meta_display_get_primary_monitor (_data_->_tmp2_));
	_data_->_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GREETER_COMPOSITOR_TYPE_BACKGROUND_MANAGER, GreeterCompositorBackgroundManager));
	_data_->bg_manager = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->bg_manager;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = meta_plugin_get_display ((MetaPlugin*) _data_->wm);
		_data_->_tmp7_ = g_strdup_printf ("Invalid monitor requested: %i", meta_display_get_primary_monitor (_data_->_tmp6_));
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, _data_->_tmp8_);
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_free0 (_data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp10_;
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->bg_manager);
			block19_data_unref (_data_->_data19_);
			_data_->_data19_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->bg_manager);
			block19_data_unref (_data_->_data19_);
			_data_->_data19_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp11_ = greeter_compositor_background_utils_dummy_offscreen_effect_new ();
	g_object_ref_sink (_data_->_tmp11_);
	_data_->_data19_->effect = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->bg_manager;
	_data_->_tmp13_ = greeter_compositor_background_manager_get_newest_background_actor (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_data19_->newest_background_actor = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->_data19_->newest_background_actor;
	_data_->_tmp16_ = _data_->_data19_->effect;
	clutter_actor_add_effect ((ClutterActor*) _data_->_tmp15_, (ClutterEffect*) _data_->_tmp16_);
	_data_->_tmp17_ = _data_->_data19_->newest_background_actor;
	_data_->_tmp18_ = clutter_actor_get_width ((ClutterActor*) _data_->_tmp17_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_data_->bg_actor_width = (gint) _data_->_tmp19_;
	_data_->_tmp20_ = _data_->_data19_->newest_background_actor;
	_data_->_tmp21_ = clutter_actor_get_height ((ClutterActor*) _data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->bg_actor_height = (gint) _data_->_tmp22_;
	_data_->_data19_->x_start = _data_->reference_x;
	if (_data_->_data19_->x_start < 2) {
		_data_->_data19_->x_start = 2;
	}
	_data_->_data19_->y_start = _data_->reference_y;
	if (_data_->_data19_->y_start < 2) {
		_data_->_data19_->y_start = 2;
	}
	_data_->_data19_->width = MIN ((_data_->bg_actor_width - 2) - _data_->reference_x, _data_->reference_width);
	_data_->_data19_->height = MIN ((_data_->bg_actor_height - 2) - _data_->reference_y, _data_->reference_height);
	if (_data_->_data19_->x_start > _data_->bg_actor_width) {
		_data_->_tmp25_ = TRUE;
	} else {
		_data_->_tmp25_ = _data_->_data19_->y_start > _data_->bg_actor_height;
	}
	if (_data_->_tmp25_) {
		_data_->_tmp24_ = TRUE;
	} else {
		_data_->_tmp24_ = _data_->_data19_->width <= 0;
	}
	if (_data_->_tmp24_) {
		_data_->_tmp23_ = TRUE;
	} else {
		_data_->_tmp23_ = _data_->_data19_->height <= 0;
	}
	if (_data_->_tmp23_) {
		_data_->_tmp26_ = g_strdup_printf ("Invalid rectangle specified: %i, %i, %i, %i", _data_->_data19_->x_start, _data_->_data19_->y_start, _data_->_data19_->width, _data_->_data19_->height);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, _data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_g_free0 (_data_->_tmp27_);
		_data_->_inner_error0_ = _data_->_tmp29_;
		if (_data_->_inner_error0_->domain == G_DBUS_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->bg_manager);
			block19_data_unref (_data_->_data19_);
			_data_->_data19_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->bg_manager);
			block19_data_unref (_data_->_data19_);
			_data_->_data19_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_data19_->mean_acutance = (gdouble) 0;
	_data_->_data19_->variance = (gdouble) 0;
	_data_->_data19_->mean = (gdouble) 0;
	_data_->_data19_->r_total = (gdouble) 0;
	_data_->_data19_->g_total = (gdouble) 0;
	_data_->_data19_->b_total = (gdouble) 0;
	_data_->_data19_->paint_signal_handler = (gulong) 0;
	_data_->_tmp30_ = _data_->_data19_->effect;
	_data_->_tmp31_ = g_signal_connect_data (_data_->_tmp30_, "done-painting", (GCallback) ___lambda45__greeter_compositor_background_utils_dummy_offscreen_effect_done_painting, block19_data_ref (_data_->_data19_), (GClosureNotify) block19_data_unref, 0);
	_data_->_data19_->paint_signal_handler = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->_data19_->newest_background_actor;
	clutter_actor_queue_redraw ((ClutterActor*) _data_->_tmp32_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	memset (&_data_->_tmp33_, 0, sizeof (GreeterCompositorBackgroundUtilsColorInformation));
	_data_->_tmp33_.average_red = _data_->_data19_->r_total;
	_data_->_tmp33_.average_green = _data_->_data19_->g_total;
	_data_->_tmp33_.average_blue = _data_->_data19_->b_total;
	_data_->_tmp33_.mean_luminance = _data_->_data19_->mean;
	_data_->_tmp33_.luminance_variance = _data_->_data19_->variance;
	_data_->_tmp33_.mean_acutance = _data_->_data19_->mean_acutance;
	_data_->result = _data_->_tmp33_;
	_g_object_unref0 (_data_->bg_manager);
	block19_data_unref (_data_->_data19_);
	_data_->_data19_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

