/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * Copyright 2018-2024 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authors: Corentin Noël <corentin@elementary.io>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <lightdm.h>
#include <gio/gio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <locale.h>

#define CONSTANTS_GETTEXT_PACKAGE "io.elementary.greeter"
#define CONSTANTS_LOCALE_DIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GREETER_TYPE_APPLICATION (greeter_application_get_type ())
#define GREETER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_APPLICATION, GreeterApplication))
#define GREETER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_APPLICATION, GreeterApplicationClass))
#define GREETER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_APPLICATION))
#define GREETER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_APPLICATION))
#define GREETER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_APPLICATION, GreeterApplicationClass))

typedef struct _GreeterApplication GreeterApplication;
typedef struct _GreeterApplicationClass GreeterApplicationClass;
typedef struct _GreeterApplicationPrivate GreeterApplicationPrivate;
enum  {
	GREETER_APPLICATION_0_PROPERTY,
	GREETER_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* greeter_application_properties[GREETER_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GREETER_TYPE_SETTINGS_PORTAL (greeter_settings_portal_get_type ())
#define GREETER_SETTINGS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortal))
#define GREETER_SETTINGS_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortalClass))
#define GREETER_IS_SETTINGS_PORTAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_SETTINGS_PORTAL))
#define GREETER_IS_SETTINGS_PORTAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_SETTINGS_PORTAL))
#define GREETER_SETTINGS_PORTAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_SETTINGS_PORTAL, GreeterSettingsPortalClass))

typedef struct _GreeterSettingsPortal GreeterSettingsPortal;
typedef struct _GreeterSettingsPortalClass GreeterSettingsPortalClass;
typedef struct _Block1Data Block1Data;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define GREETER_TYPE_MAIN_WINDOW (greeter_main_window_get_type ())
#define GREETER_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindow))
#define GREETER_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))
#define GREETER_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GREETER_TYPE_MAIN_WINDOW))
#define GREETER_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GREETER_TYPE_MAIN_WINDOW, GreeterMainWindowClass))

typedef struct _GreeterMainWindow GreeterMainWindow;
typedef struct _GreeterMainWindowClass GreeterMainWindowClass;

struct _GreeterApplication {
	GtkApplication parent_instance;
	GreeterApplicationPrivate * priv;
};

struct _GreeterApplicationClass {
	GtkApplicationClass parent_class;
};

struct _GreeterApplicationPrivate {
	LightDMGreeter* lightdm_greeter;
};

struct _Block1Data {
	int _ref_count_;
	GreeterApplication* self;
	GtkSettings* gtk_settings;
	GreeterSettingsPortal* settings_portal;
	GSimpleAction* select_session_action;
	GVariantDict* vardict;
	gboolean has_pantheon_x11_session;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GSettings* a11y_settings;
};

static gint GreeterApplication_private_offset;
static gpointer greeter_application_parent_class = NULL;

VALA_EXTERN GType greeter_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterApplication, g_object_unref)
VALA_EXTERN GreeterApplication* greeter_application_new (void);
VALA_EXTERN GreeterApplication* greeter_application_construct (GType object_type);
static void greeter_application_real_startup (GApplication* base);
VALA_EXTERN GType greeter_settings_portal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterSettingsPortal, g_object_unref)
VALA_EXTERN guint greeter_settings_portal_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (GreeterApplication* self,
                 GDBusConnection* connection,
                 const gchar* name);
VALA_EXTERN GreeterSettingsPortal* greeter_settings_portal_get_default (void);
static void ___lambda4__gbus_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self);
static void __lambda6_ (GreeterApplication* self);
static void ___lambda6__gbus_name_acquired_callback (GDBusConnection* connection,
                                              const gchar* name,
                                              gpointer self);
static void __lambda7_ (GreeterApplication* self);
static void ___lambda7__gbus_name_lost_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self);
VALA_EXTERN gint greeter_settings_portal_get_prefers_color_scheme (GreeterSettingsPortal* self);
static void __lambda8_ (Block1Data* _data1_);
static void ___lambda8__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static GVariant* _variant_new1 (const gchar* value);
static void __lambda9_ (Block1Data* _data1_,
                 LightDMSession* session);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
static void __lambda10_ (Block1Data* _data1_,
                  GVariant* param);
static void ___lambda10__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda11_ (Block2Data* _data2_,
                   const gchar* key);
static void ____lambda11__g_settings_changed (GSettings* _sender,
                                       const gchar* key,
                                       gpointer self);
static void greeter_application_real_activate (GApplication* base);
VALA_EXTERN GreeterMainWindow* greeter_main_window_new (LightDMGreeter* lightdm_greeter);
VALA_EXTERN GreeterMainWindow* greeter_main_window_construct (GType object_type,
                                                  LightDMGreeter* lightdm_greeter);
VALA_EXTERN GType greeter_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterMainWindow, g_object_unref)
static gint greeter_application_main (gchar** args,
                               gint args_length1);
static GObject * greeter_application_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void greeter_application_finalize (GObject * obj);
static GType greeter_application_get_type_once (void);

static inline gpointer
greeter_application_get_instance_private (GreeterApplication* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterApplication_private_offset);
}

GreeterApplication*
greeter_application_construct (GType object_type)
{
	GreeterApplication * self = NULL;
	self = (GreeterApplication*) g_object_new (object_type, "application-id", "io.elementary.greeter", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}

GreeterApplication*
greeter_application_new (void)
{
	return greeter_application_construct (GREETER_TYPE_APPLICATION);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GreeterApplication* self;
		self = _data1_->self;
		_g_variant_dict_unref0 (_data1_->vardict);
		_g_object_unref0 (_data1_->select_session_action);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (GreeterApplication* self,
            GDBusConnection* connection,
            const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	{
		GreeterSettingsPortal* _tmp0_;
		_tmp0_ = greeter_settings_portal_get_default ();
		greeter_settings_portal_register_object (_tmp0_, connection, "/org/freedesktop/portal/desktop", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("Application.vala:55: Unable to register the object: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gbus_acquired_callback (GDBusConnection* connection,
                                    const gchar* name,
                                    gpointer self)
{
	__lambda4_ ((GreeterApplication*) self, connection, name);
}

static void
__lambda6_ (GreeterApplication* self)
{
	g_debug ("Application.vala:58: org.freedesktop.portal.Desktop acquired");
}

static void
___lambda6__gbus_name_acquired_callback (GDBusConnection* connection,
                                         const gchar* name,
                                         gpointer self)
{
	__lambda6_ ((GreeterApplication*) self);
}

static void
__lambda7_ (GreeterApplication* self)
{
	g_debug ("Application.vala:59: org.freedesktop.portal.Desktop lost");
}

static void
___lambda7__gbus_name_lost_callback (GDBusConnection* connection,
                                     const gchar* name,
                                     gpointer self)
{
	__lambda7_ ((GreeterApplication*) self);
}

static void
__lambda8_ (Block1Data* _data1_)
{
	GreeterApplication* self;
	gint _tmp0_;
	gint _tmp1_;
	self = _data1_->self;
	_tmp0_ = greeter_settings_portal_get_prefers_color_scheme (_data1_->settings_portal);
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == 1, NULL);
}

static void
___lambda8__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda8_ (self);
}

static GVariant*
_variant_new1 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda9_ (Block1Data* _data1_,
            LightDMSession* session)
{
	GreeterApplication* self;
	GVariantDict* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	self = _data1_->self;
	g_return_if_fail (session != NULL);
	_tmp0_ = _data1_->vardict;
	_tmp1_ = lightdm_session_get_name (session);
	_tmp2_ = _tmp1_;
	_tmp3_ = lightdm_session_get_key (session);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_new_string (_tmp4_);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	g_variant_dict_insert_value (_tmp0_, _tmp2_, _tmp6_);
	_g_variant_unref0 (_tmp6_);
	_tmp7_ = lightdm_session_get_key (session);
	_tmp8_ = _tmp7_;
	if (g_strcmp0 (_tmp8_, "pantheon") == 0) {
		_data1_->has_pantheon_x11_session = TRUE;
	}
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (LightDMSession*) data);
}

static void
__lambda10_ (Block1Data* _data1_,
             GVariant* param)
{
	GreeterApplication* self;
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->select_session_action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_equal (_tmp2_, param);
	_g_variant_unref0 (_tmp2_);
	if (_tmp3_) {
		GSimpleAction* _tmp4_;
		_tmp4_ = _data1_->select_session_action;
		g_simple_action_set_state (_tmp4_, param);
	}
}

static void
___lambda10__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda10_ (self, parameter);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GreeterApplication* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->a11y_settings);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
___lambda11_ (Block2Data* _data2_,
              const gchar* key)
{
	Block1Data* _data1_;
	GreeterApplication* self;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_;
	GSimpleAction* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GSimpleAction* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GNotification* notification = NULL;
	GNotification* _tmp10_;
	GNotification* _tmp11_;
	GNotification* _tmp12_;
	GThemedIcon* _tmp13_;
	GThemedIcon* _tmp14_;
	GNotification* _tmp15_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "screen-keyboard-enabled") != 0) {
		_tmp0_ = g_strcmp0 (key, "screen-reader-enabled") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = _data2_->a11y_settings;
	if (!g_settings_get_boolean (_tmp1_, key)) {
		return;
	}
	_tmp2_ = _data1_->select_session_action;
	_tmp3_ = g_action_get_state ((GAction*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_get_string (_tmp4_, NULL);
	_tmp6_ = g_strcmp0 (_tmp5_, "pantheon-wayland") != 0;
	_g_variant_unref0 (_tmp4_);
	if (_tmp6_) {
		return;
	}
	_tmp7_ = _data1_->select_session_action;
	_tmp8_ = g_variant_new_string ("pantheon");
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	g_simple_action_set_state (_tmp7_, _tmp9_);
	_g_variant_unref0 (_tmp9_);
	_tmp10_ = g_notification_new (_ ("Classic session automatically selected"));
	notification = _tmp10_;
	_tmp11_ = notification;
	g_notification_set_body (_tmp11_, _ ("Accessibility features may be unavailable in the Secure session"));
	_tmp12_ = notification;
	_tmp13_ = (GThemedIcon*) g_themed_icon_new ("preferences-desktop-accessibility");
	_tmp14_ = _tmp13_;
	g_notification_set_icon (_tmp12_, (GIcon*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = notification;
	g_application_send_notification ((GApplication*) self, "session-type", _tmp15_);
	_g_object_unref0 (notification);
}

static void
____lambda11__g_settings_changed (GSettings* _sender,
                                  const gchar* key,
                                  gpointer self)
{
	___lambda11_ (self, key);
}

static void
greeter_application_real_startup (GApplication* base)
{
	GreeterApplication * self;
	Block1Data* _data1_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	GtkSettings* _tmp2_;
	GreeterSettingsPortal* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GSettings* settings = NULL;
	GSettings* _tmp6_;
	LightDMGreeter* _tmp7_;
	GList* sessions = NULL;
	GList* _tmp11_;
	gchar* selected_session = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const GVariantType* _tmp31_;
	const gchar* _tmp32_;
	GVariant* _tmp33_;
	GSimpleAction* _tmp34_;
	GSimpleAction* _tmp35_;
	GVariantDict* _tmp36_;
	GList* _tmp37_;
	GSimpleAction* _tmp38_;
	GVariantDict* _tmp39_;
	GVariant* _tmp40_;
	GVariant* _tmp41_;
	GSimpleAction* _tmp42_;
	GSimpleAction* _tmp43_;
	GError* _inner_error0_ = NULL;
	self = (GreeterApplication*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (greeter_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	gtk_css_provider_load_from_resource (css_provider, "/io/elementary/greeter/Application.css");
	_tmp1_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.freedesktop.portal.Desktop", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((___lambda4__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda4__gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda6__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda6__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda7__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda7__gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp2_ = gtk_settings_get_default ();
	_data1_->gtk_settings = _tmp2_;
	_tmp3_ = greeter_settings_portal_get_default ();
	_data1_->settings_portal = _tmp3_;
	_tmp4_ = greeter_settings_portal_get_prefers_color_scheme (_data1_->settings_portal);
	_tmp5_ = _tmp4_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp5_ == 1, NULL);
	g_signal_connect_data ((GObject*) _data1_->settings_portal, "notify::prefers-color-scheme", (GCallback) ___lambda8__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = g_settings_new ("io.elementary.greeter");
	settings = _tmp6_;
	_tmp7_ = lightdm_greeter_new ();
	_g_object_unref0 (self->priv->lightdm_greeter);
	self->priv->lightdm_greeter = _tmp7_;
	{
		LightDMGreeter* _tmp8_;
		_tmp8_ = self->priv->lightdm_greeter;
		lightdm_greeter_connect_to_daemon_sync (_tmp8_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("Application.vala:77: LightDM couldn't connect to daemon: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (settings);
		_g_object_unref0 (css_provider);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = lightdm_get_sessions ();
	sessions = _tmp11_;
	_tmp12_ = g_strdup ("");
	selected_session = _tmp12_;
	_tmp13_ = g_settings_get_string (settings, "last-session-type");
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strcmp0 (_tmp14_, "") != 0;
	_g_free0 (_tmp14_);
	if (_tmp15_) {
		gchar* _tmp16_;
		_tmp16_ = g_settings_get_string (settings, "last-session-type");
		_g_free0 (selected_session);
		selected_session = _tmp16_;
	} else {
		LightDMGreeter* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = self->priv->lightdm_greeter;
		_tmp18_ = lightdm_greeter_get_default_session_hint (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			LightDMGreeter* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp20_ = self->priv->lightdm_greeter;
			_tmp21_ = lightdm_greeter_get_default_session_hint (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup (_tmp22_);
			_g_free0 (selected_session);
			selected_session = _tmp23_;
		} else {
			GList* _tmp24_;
			_tmp24_ = sessions;
			if (g_list_length (_tmp24_) > ((guint) 0)) {
				GList* _tmp25_;
				GList* _tmp26_;
				gconstpointer _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				_tmp25_ = sessions;
				_tmp26_ = g_list_first (_tmp25_);
				_tmp27_ = _tmp26_->data;
				_tmp28_ = lightdm_session_get_key ((LightDMSession*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (selected_session);
				selected_session = _tmp30_;
			}
		}
	}
	_tmp31_ = G_VARIANT_TYPE_STRING;
	_tmp32_ = selected_session;
	_tmp33_ = _variant_new1 (_tmp32_);
	_tmp34_ = g_simple_action_new_stateful ("select-session", _tmp31_, _tmp33_);
	_tmp35_ = _tmp34_;
	_g_variant_unref0 (_tmp33_);
	_data1_->select_session_action = _tmp35_;
	_tmp36_ = g_variant_dict_new (NULL);
	_data1_->vardict = _tmp36_;
	_data1_->has_pantheon_x11_session = FALSE;
	_tmp37_ = sessions;
	g_list_foreach (_tmp37_, ___lambda9__gfunc, _data1_);
	_tmp38_ = _data1_->select_session_action;
	_tmp39_ = _data1_->vardict;
	_tmp40_ = g_variant_dict_end (_tmp39_);
	g_variant_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	g_simple_action_set_state_hint (_tmp38_, _tmp41_);
	_g_variant_unref0 (_tmp41_);
	_tmp42_ = _data1_->select_session_action;
	g_signal_connect_data (_tmp42_, "activate", (GCallback) ___lambda10__g_simple_action_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp43_ = _data1_->select_session_action;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp43_);
	if (_data1_->has_pantheon_x11_session) {
		Block2Data* _data2_;
		GSettings* _tmp44_;
		GSettings* _tmp45_;
		_data2_ = g_slice_new0 (Block2Data);
		_data2_->_ref_count_ = 1;
		_data2_->_data1_ = block1_data_ref (_data1_);
		_tmp44_ = g_settings_new ("org.gnome.desktop.a11y.applications");
		_data2_->a11y_settings = _tmp44_;
		_tmp45_ = _data2_->a11y_settings;
		g_signal_connect_data (_tmp45_, "changed", (GCallback) ____lambda11__g_settings_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		block2_data_unref (_data2_);
		_data2_ = NULL;
	}
	_g_free0 (selected_session);
	_g_object_unref0 (settings);
	_g_object_unref0 (css_provider);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
greeter_application_real_activate (GApplication* base)
{
	GreeterApplication * self;
	LightDMGreeter* _tmp0_;
	GreeterMainWindow* _tmp1_;
	GreeterMainWindow* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	GtkWindow* _tmp6_;
	self = (GreeterApplication*) base;
	_tmp0_ = self->priv->lightdm_greeter;
	_tmp1_ = greeter_main_window_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp4_ = _tmp3_;
	gtk_widget_show_all ((GtkWidget*) _tmp4_);
	_tmp5_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp6_ = _tmp5_;
	gtk_window_present (_tmp6_);
}

static gint
greeter_application_main (gchar** args,
                          gint args_length1)
{
	GreeterApplication* _tmp0_;
	GreeterApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = greeter_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return greeter_application_main (argv, argc);
}

static GObject *
greeter_application_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterApplication * self;
	parent_class = G_OBJECT_CLASS (greeter_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_APPLICATION, GreeterApplication);
	setlocale (LC_ALL, "");
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	textdomain (CONSTANTS_GETTEXT_PACKAGE);
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALE_DIR);
	return obj;
}

static void
greeter_application_class_init (GreeterApplicationClass * klass,
                                gpointer klass_data)
{
	greeter_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GreeterApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) greeter_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) greeter_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = greeter_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = greeter_application_finalize;
}

static void
greeter_application_instance_init (GreeterApplication * self,
                                   gpointer klass)
{
	self->priv = greeter_application_get_instance_private (self);
}

static void
greeter_application_finalize (GObject * obj)
{
	GreeterApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GREETER_TYPE_APPLICATION, GreeterApplication);
	_g_object_unref0 (self->priv->lightdm_greeter);
	G_OBJECT_CLASS (greeter_application_parent_class)->finalize (obj);
}

static GType
greeter_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterApplication), 0, (GInstanceInitFunc) greeter_application_instance_init, NULL };
	GType greeter_application_type_id;
	greeter_application_type_id = g_type_register_static (gtk_application_get_type (), "GreeterApplication", &g_define_type_info, 0);
	GreeterApplication_private_offset = g_type_add_instance_private (greeter_application_type_id, sizeof (GreeterApplicationPrivate));
	return greeter_application_type_id;
}

GType
greeter_application_get_type (void)
{
	static volatile gsize greeter_application_type_id__once = 0;
	if (g_once_init_enter (&greeter_application_type_id__once)) {
		GType greeter_application_type_id;
		greeter_application_type_id = greeter_application_get_type_once ();
		g_once_init_leave (&greeter_application_type_id__once, greeter_application_type_id);
	}
	return greeter_application_type_id__once;
}

