/* greeter-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from greeter-list.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 *
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Robert Ancell <robert.ancell@canonical.com>
 *          Michael Terry <michael.terry@canonical.com>
 *          Scott Sweeny <scott.sweeny@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <lightdm.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define MAX_FIELD_SIZE 200
#define grid_size 40
#define GREETER_LIST_BORDER 4
#define GREETER_LIST_BOX_WIDTH 9
#define GREETER_LIST_DEFAULT_BOX_HEIGHT 3
#define MAIN_WINDOW_MENUBAR_HEIGHT 32
#define ANIMATE_TIMER_FAST 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_LIST_DBUS_INTERFACE (list_dbus_interface_get_type ())
#define LIST_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_DBUS_INTERFACE, ListDBusInterface))
#define LIST_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_DBUS_INTERFACE, ListDBusInterfaceClass))
#define IS_LIST_DBUS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_DBUS_INTERFACE))
#define IS_LIST_DBUS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_DBUS_INTERFACE))
#define LIST_DBUS_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_DBUS_INTERFACE, ListDBusInterfaceClass))

typedef struct _ListDBusInterface ListDBusInterface;
typedef struct _ListDBusInterfaceClass ListDBusInterfaceClass;
typedef struct _ListDBusInterfacePrivate ListDBusInterfacePrivate;

#define TYPE_FADABLE_BOX (fadable_box_get_type ())
#define FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE_BOX, FadableBox))
#define FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADABLE_BOX, FadableBoxClass))
#define IS_FADABLE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE_BOX))
#define IS_FADABLE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADABLE_BOX))
#define FADABLE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADABLE_BOX, FadableBoxClass))

typedef struct _FadableBox FadableBox;
typedef struct _FadableBoxClass FadableBoxClass;

#define TYPE_GREETER_LIST (greeter_list_get_type ())
#define GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GREETER_LIST, GreeterList))
#define GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GREETER_LIST, GreeterListClass))
#define IS_GREETER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GREETER_LIST))
#define IS_GREETER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GREETER_LIST))
#define GREETER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GREETER_LIST, GreeterListClass))

typedef struct _GreeterList GreeterList;
typedef struct _GreeterListClass GreeterListClass;
enum  {
	LIST_DBUS_INTERFACE_0_PROPERTY,
	LIST_DBUS_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* list_dbus_interface_properties[LIST_DBUS_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROMPT_BOX (prompt_box_get_type ())
#define PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROMPT_BOX, PromptBox))
#define PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROMPT_BOX, PromptBoxClass))
#define IS_PROMPT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROMPT_BOX))
#define IS_PROMPT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROMPT_BOX))
#define PROMPT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROMPT_BOX, PromptBoxClass))

typedef struct _PromptBox PromptBox;
typedef struct _PromptBoxClass PromptBoxClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	LIST_DBUS_INTERFACE_ENTRY_SELECTED_SIGNAL,
	LIST_DBUS_INTERFACE_NUM_SIGNALS
};
static guint list_dbus_interface_signals[LIST_DBUS_INTERFACE_NUM_SIGNALS] = {0};

#define TYPE_FADABLE (fadable_get_type ())
#define FADABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADABLE, Fadable))
#define IS_FADABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADABLE))
#define FADABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FADABLE, FadableIface))

typedef struct _Fadable Fadable;
typedef struct _FadableIface FadableIface;

#define TYPE_FADE_TRACKER (fade_tracker_get_type ())
#define FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FADE_TRACKER, FadeTracker))
#define FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FADE_TRACKER, FadeTrackerClass))
#define IS_FADE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FADE_TRACKER))
#define IS_FADE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FADE_TRACKER))
#define FADE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FADE_TRACKER, FadeTrackerClass))

typedef struct _FadeTracker FadeTracker;
typedef struct _FadeTrackerClass FadeTrackerClass;
typedef struct _FadableBoxPrivate FadableBoxPrivate;
typedef struct _GreeterListPrivate GreeterListPrivate;

#define TYPE_DASH_BOX (dash_box_get_type ())
#define DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_BOX, DashBox))
#define DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_BOX, DashBoxClass))
#define IS_DASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_BOX))
#define IS_DASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_BOX))
#define DASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_BOX, DashBoxClass))

typedef struct _DashBox DashBox;
typedef struct _DashBoxClass DashBoxClass;
typedef enum  {
	GREETER_LIST_MODE_ENTRY,
	GREETER_LIST_MODE_SCROLLING
} GreeterListMode;

#define GREETER_LIST_TYPE_MODE (greeter_list_mode_get_type ())

#define TYPE_BACKGROUND (background_get_type ())
#define BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND, Background))
#define BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND, BackgroundClass))
#define IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND))
#define IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND))
#define BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND, BackgroundClass))

typedef struct _Background Background;
typedef struct _BackgroundClass BackgroundClass;

#define TYPE_MENU_BAR (menu_bar_get_type ())
#define MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MENU_BAR, MenuBar))
#define MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MENU_BAR, MenuBarClass))
#define IS_MENU_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MENU_BAR))
#define IS_MENU_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MENU_BAR))
#define MENU_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MENU_BAR, MenuBarClass))

typedef struct _MenuBar MenuBar;
typedef struct _MenuBarClass MenuBarClass;

#define TYPE_ANIMATE_TIMER (animate_timer_get_type ())
#define ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATE_TIMER, AnimateTimer))
#define ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATE_TIMER, AnimateTimerClass))
#define IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATE_TIMER))
#define IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATE_TIMER))
#define ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATE_TIMER, AnimateTimerClass))

typedef struct _AnimateTimer AnimateTimer;
typedef struct _AnimateTimerClass AnimateTimerClass;
enum  {
	GREETER_LIST_0_PROPERTY,
	GREETER_LIST_BACKGROUND_PROPERTY,
	GREETER_LIST_MENUBAR_PROPERTY,
	GREETER_LIST_SELECTED_ENTRY_PROPERTY,
	GREETER_LIST_START_SCROLLING_PROPERTY,
	GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY,
	GREETER_LIST_MANUAL_NAME_PROPERTY,
	GREETER_LIST_NUM_PROPERTIES
};
static GParamSpec* greeter_list_properties[GREETER_LIST_NUM_PROPERTIES];
typedef enum  {
	GREETER_LIST_SCROLL_TARGET_START,
	GREETER_LIST_SCROLL_TARGET_END,
	GREETER_LIST_SCROLL_TARGET_UP,
	GREETER_LIST_SCROLL_TARGET_DOWN
} GreeterListScrollTarget;

#define GREETER_LIST_TYPE_SCROLL_TARGET (greeter_list_scroll_target_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SLICK_GREETER (slick_greeter_get_type ())
#define SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLICK_GREETER, SlickGreeter))
#define SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLICK_GREETER, SlickGreeterClass))
#define IS_SLICK_GREETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLICK_GREETER))
#define IS_SLICK_GREETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLICK_GREETER))
#define SLICK_GREETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLICK_GREETER, SlickGreeterClass))

typedef struct _SlickGreeter SlickGreeter;
typedef struct _SlickGreeterClass SlickGreeterClass;

#define TYPE_DASH_ENTRY (dash_entry_get_type ())
#define DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DASH_ENTRY, DashEntry))
#define DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DASH_ENTRY, DashEntryClass))
#define IS_DASH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DASH_ENTRY))
#define IS_DASH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DASH_ENTRY))
#define DASH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DASH_ENTRY, DashEntryClass))

typedef struct _DashEntry DashEntry;
typedef struct _DashEntryClass DashEntryClass;
typedef struct _SlickGreeterPrivate SlickGreeterPrivate;
typedef gdouble (*AnimateTimerEasingFunc) (gdouble x, gpointer user_data);
enum  {
	GREETER_LIST_ENTRY_SELECTED_SIGNAL,
	GREETER_LIST_ENTRY_DISPLAYED_START_SIGNAL,
	GREETER_LIST_ENTRY_DISPLAYED_DONE_SIGNAL,
	GREETER_LIST_NUM_SIGNALS
};
static guint greeter_list_signals[GREETER_LIST_NUM_SIGNALS] = {0};

struct _ListDBusInterface {
	GObject parent_instance;
	ListDBusInterfacePrivate * priv;
};

struct _ListDBusInterfaceClass {
	GObjectClass parent_class;
};

struct _ListDBusInterfacePrivate {
	GreeterList* list;
};

struct _FadableIface {
	GTypeInterface parent_iface;
	FadeTracker* (*get_fade_tracker) (Fadable* self);
	void (*set_fade_tracker) (Fadable* self, FadeTracker* value);
};

struct _FadableBox {
	GtkEventBox parent_instance;
	FadableBoxPrivate * priv;
};

struct _FadableBoxClass {
	GtkEventBoxClass parent_class;
	void (*draw_full_alpha) (FadableBox* self, cairo_t* c);
};

struct _GreeterList {
	FadableBox parent_instance;
	GreeterListPrivate * priv;
	gchar* greeter_authenticating_user;
	gboolean _always_show_manual;
	GList* entries;
	DashBox* greeter_box;
	GreeterListMode mode;
	gboolean will_clear;
	gboolean prompted;
	gboolean unacknowledged_messages;
	gchar* test_username;
	gboolean test_is_authenticated;
};

struct _GreeterListClass {
	FadableBoxClass parent_class;
	gchar* (*get_selected_id) (GreeterList* self);
	void (*focus_prompt) (GreeterList* self);
	void (*show_authenticated) (GreeterList* self, gboolean successful);
	void (*insert_entry) (GreeterList* self, PromptBox* entry);
	void (*add_manual_entry) (GreeterList* self);
	gint (*get_position_y) (GreeterList* self, gdouble position);
	void (*setup_prompt_box) (GreeterList* self, gboolean fade);
	void (*show_prompt_cb) (GreeterList* self, const gchar* text, LightDMPromptType type);
	void (*authentication_complete_cb) (GreeterList* self);
	void (*start_authentication) (GreeterList* self);
	gchar* (*get_lightdm_session) (GreeterList* self);
	void (*test_start_authentication) (GreeterList* self);
};

struct _GreeterListPrivate {
	Background* _background;
	MenuBar* _menubar;
	PromptBox* _selected_entry;
	gboolean _start_scrolling;
	ListDBusInterface* dbus_object;
	gdouble scroll_target_location;
	gdouble scroll_start_location;
	gdouble scroll_location;
	gdouble scroll_direction;
	AnimateTimer* scroll_timer;
	GtkFixed* fixed;
	gint cached_box_height;
	guint n_above;
	guint n_below;
	gchar* _manual_name;
	PromptBox* _scrolling_entry;
};

struct _SlickGreeter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SlickGreeterPrivate * priv;
	gboolean test_mode;
	gboolean orca_needs_kick;
};

struct _SlickGreeterClass {
	GTypeClass parent_class;
	void (*finalize) (SlickGreeter *self);
};

VALA_EXTERN gint _scale_factor;
gint _scale_factor = 1;
static gint ListDBusInterface_private_offset;
static gpointer list_dbus_interface_parent_class = NULL;
static gint GreeterList_private_offset;
static gpointer greeter_list_parent_class = NULL;
VALA_EXTERN SlickGreeter* slick_greeter_singleton;

VALA_EXTERN gint get_grid_offset (gint size);
VALA_EXTERN GType list_dbus_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ListDBusInterface, g_object_unref)
VALA_EXTERN guint list_dbus_interface_register_object (void* object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error);
VALA_EXTERN GType fadable_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadableBox, g_object_unref)
VALA_EXTERN GType greeter_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GreeterList, g_object_unref)
VALA_EXTERN ListDBusInterface* list_dbus_interface_new (GreeterList* list);
VALA_EXTERN ListDBusInterface* list_dbus_interface_construct (GType object_type,
                                                  GreeterList* list);
static void __lambda37_ (ListDBusInterface* self,
                  const gchar* name);
static void ___lambda37__greeter_list_entry_selected (GreeterList* _sender,
                                               const gchar* name,
                                               gpointer self);
VALA_EXTERN gchar* list_dbus_interface_get_active_entry (ListDBusInterface* self,
                                             GError** error);
VALA_EXTERN GType prompt_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PromptBox, g_object_unref)
VALA_EXTERN PromptBox* greeter_list_get_selected_entry (GreeterList* self);
VALA_EXTERN const gchar* prompt_box_get_id (PromptBox* self);
VALA_EXTERN void list_dbus_interface_set_active_entry (ListDBusInterface* self,
                                           const gchar* entry_name,
                                           GError** error);
VALA_EXTERN void greeter_list_set_active_entry (GreeterList* self,
                                    const gchar* name);
static void list_dbus_interface_finalize (GObject * obj);
static GType list_dbus_interface_get_type_once (void);
static void _dbus_list_dbus_interface_get_active_entry (ListDBusInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_list_dbus_interface_set_active_entry (ListDBusInterface* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void list_dbus_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data);
static GVariant* list_dbus_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GError** error,
                                                           gpointer user_data);
static gboolean list_dbus_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GVariant* value,
                                                          GError** error,
                                                          gpointer user_data);
static void _dbus_list_dbus_interface_entry_selected (GObject* _sender,
                                               const gchar* entry_name,
                                               gpointer* _data);
static void _list_dbus_interface_unregister_object (gpointer user_data);
VALA_EXTERN GType fade_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FadeTracker, g_object_unref)
VALA_EXTERN GType fadable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Fadable, g_object_unref)
VALA_EXTERN GType dash_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashBox, g_object_unref)
VALA_EXTERN GType greeter_list_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Background, g_object_unref)
VALA_EXTERN GType menu_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuBar, g_object_unref)
VALA_EXTERN GType animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimateTimer, g_object_unref)
VALA_EXTERN gchar* greeter_list_get_selected_id (GreeterList* self);
VALA_EXTERN void greeter_list_focus_prompt (GreeterList* self);
VALA_EXTERN void greeter_list_show_authenticated (GreeterList* self,
                                      gboolean successful);
VALA_EXTERN void greeter_list_insert_entry (GreeterList* self,
                                PromptBox* entry);
VALA_EXTERN void greeter_list_add_manual_entry (GreeterList* self);
VALA_EXTERN gint greeter_list_get_position_y (GreeterList* self,
                                  gdouble position);
VALA_EXTERN void greeter_list_setup_prompt_box (GreeterList* self,
                                    gboolean fade);
VALA_EXTERN void greeter_list_show_prompt_cb (GreeterList* self,
                                  const gchar* text,
                                  LightDMPromptType type);
VALA_EXTERN void greeter_list_authentication_complete_cb (GreeterList* self);
VALA_EXTERN void greeter_list_start_authentication (GreeterList* self);
VALA_EXTERN gchar* greeter_list_get_lightdm_session (GreeterList* self);
VALA_EXTERN void greeter_list_test_start_authentication (GreeterList* self);
VALA_EXTERN GType greeter_list_scroll_target_get_type (void) G_GNUC_CONST ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gchar* greeter_list_real_get_selected_id (GreeterList* self);
VALA_EXTERN GreeterList* greeter_list_construct (GType object_type,
                                     Background* bg,
                                     MenuBar* mb);
static void greeter_list_on_bus_acquired (GreeterList* self,
                                   GObject* obj,
                                   GAsyncResult* res);
static void greeter_list_real_get_preferred_width (GtkWidget* base,
                                            gint* min,
                                            gint* nat);
static void greeter_list_real_get_preferred_height (GtkWidget* base,
                                             gint* min,
                                             gint* nat);
VALA_EXTERN void greeter_list_cancel_authentication (GreeterList* self);
VALA_EXTERN gpointer slick_greeter_ref (gpointer instance);
VALA_EXTERN void slick_greeter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_slick_greeter (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_slick_greeter (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_slick_greeter (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_slick_greeter (const GValue* value);
VALA_EXTERN GType slick_greeter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SlickGreeter, slick_greeter_unref)
VALA_EXTERN void slick_greeter_cancel_authentication (SlickGreeter* self);
VALA_EXTERN void greeter_list_scroll (GreeterList* self,
                          GreeterListScrollTarget target);
VALA_EXTERN void greeter_list_select_entry (GreeterList* self,
                                PromptBox* entry,
                                gdouble direction,
                                gboolean do_scroll);
VALA_EXTERN void greeter_list_add_with_class (GreeterList* self,
                                  GtkWidget* widget);
VALA_EXTERN void slick_greeter_add_style_class (GtkWidget* widget);
VALA_EXTERN void greeter_list_redraw_greeter_box (GreeterList* self);
VALA_EXTERN void greeter_list_show_message (GreeterList* self,
                                const gchar* text,
                                gboolean is_error);
VALA_EXTERN void prompt_box_clear (PromptBox* self);
VALA_EXTERN void prompt_box_add_message (PromptBox* self,
                             const gchar* text,
                             gboolean is_error);
VALA_EXTERN GType dash_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DashEntry, g_object_unref)
VALA_EXTERN DashEntry* greeter_list_add_prompt (GreeterList* self,
                                    const gchar* text,
                                    gboolean secret);
VALA_EXTERN const gchar* prompt_box_get_label (PromptBox* self);
VALA_EXTERN DashEntry* prompt_box_add_prompt (PromptBox* self,
                                  const gchar* text,
                                  const gchar* accessible_text,
                                  gboolean is_secret);
VALA_EXTERN void prompt_box_show_prompts (PromptBox* self);
VALA_EXTERN GtkComboBox* greeter_list_add_combo (GreeterList* self,
                                     GPtrArray* texts,
                                     gboolean read_only);
VALA_EXTERN GtkComboBox* prompt_box_add_combo (PromptBox* self,
                                   GPtrArray* texts,
                                   gboolean read_only);
static void greeter_list_real_grab_focus (GtkWidget* base);
static void greeter_list_real_focus_prompt (GreeterList* self);
static void greeter_list_real_show_authenticated (GreeterList* self,
                                           gboolean successful);
VALA_EXTERN PromptBox* greeter_list_find_entry (GreeterList* self,
                                    const gchar* id);
VALA_EXTERN gint greeter_list_compare_entry (PromptBox* a,
                                 PromptBox* b);
VALA_EXTERN gboolean greeter_list_have_entries (GreeterList* self);
static void greeter_list_real_insert_entry (GreeterList* self,
                                     PromptBox* entry);
static gint _greeter_list_compare_entry_gcompare_func (gconstpointer a,
                                                gconstpointer b);
static void greeter_list_real_add_manual_entry (GreeterList* self);
VALA_EXTERN void greeter_list_add_entry (GreeterList* self,
                             PromptBox* entry);
static void greeter_list_entry_clicked_cb (GreeterList* self,
                                    PromptBox* entry);
static void _greeter_list_entry_clicked_cb_prompt_box_name_clicked (PromptBox* _sender,
                                                             gpointer self);
VALA_EXTERN void greeter_list_move_names (GreeterList* self);
VALA_EXTERN void greeter_list_set_active_first_entry_with_prefix (GreeterList* self,
                                                      const gchar* prefix);
VALA_EXTERN void greeter_list_remove_entry (GreeterList* self,
                                const gchar* name);
VALA_EXTERN void greeter_list_remove_entry_by_entry (GreeterList* self,
                                         PromptBox* entry);
VALA_EXTERN void greeter_list_remove_entries_with_prefix (GreeterList* self,
                                              const gchar* prefix);
VALA_EXTERN gboolean slick_greeter_show_remote_login_hint (SlickGreeter* self);
VALA_EXTERN gint greeter_list_get_greeter_box_height (GreeterList* self);
VALA_EXTERN gint greeter_list_get_greeter_box_height_grids (GreeterList* self);
VALA_EXTERN gint greeter_list_get_greeter_box_x (GreeterList* self);
static gint greeter_list_get_box_x (GreeterList* self);
VALA_EXTERN gint greeter_list_get_greeter_box_y (GreeterList* self);
static gint greeter_list_get_box_y (GreeterList* self);
static gint greeter_list_real_get_position_y (GreeterList* self,
                                       gdouble position);
static void greeter_list_move_entry (GreeterList* self,
                              PromptBox* entry,
                              gdouble position);
VALA_EXTERN void fadable_set_alpha (Fadable* self,
                        gdouble alpha);
VALA_EXTERN void prompt_box_set_position (PromptBox* self,
                              gdouble value);
VALA_EXTERN void greeter_list_greeter_box_size_allocate_cb (GreeterList* self,
                                                GtkAllocation* allocation);
static PromptBox* greeter_list_get_scrolling_entry (GreeterList* self);
static gboolean ___lambda39_ (GreeterList* self);
static gboolean ____lambda39__gsource_func (gpointer self);
VALA_EXTERN gboolean dash_box_get_has_base (DashBox* self);
VALA_EXTERN gdouble dash_box_get_base_alpha (DashBox* self);
static void greeter_list_animate_scrolling (GreeterList* self,
                                     gdouble progress);
static void greeter_list_finished_scrolling (GreeterList* self);
static void greeter_list_set_scrolling_entry (GreeterList* self,
                                       PromptBox* value);
static void greeter_list_set_selected_entry (GreeterList* self,
                                      PromptBox* value);
VALA_EXTERN void animate_timer_reset (AnimateTimer* self,
                          gint temp_speed);
VALA_EXTERN void dash_box_set_base (DashBox* self,
                        GtkWidget* w);
static void greeter_list_real_setup_prompt_box (GreeterList* self,
                                         gboolean fade);
VALA_EXTERN void prompt_box_add_static_prompts (PromptBox* self);
VALA_EXTERN void prompt_box_fade_in_prompts (PromptBox* self);
static void greeter_list_real_realize (GtkWidget* base);
VALA_EXTERN gboolean greeter_list_get_start_scrolling (GreeterList* self);
static void greeter_list_allocate_greeter_box (GreeterList* self);
VALA_EXTERN void prompt_box_set_zone (PromptBox* self,
                          GtkWidget* zone);
static void greeter_list_real_size_allocate (GtkWidget* base,
                                      GtkAllocation* allocation);
static gboolean greeter_list_real_draw (GtkWidget* base,
                                 cairo_t* c);
VALA_EXTERN FadeTracker* fadable_get_fade_tracker (Fadable* self);
VALA_EXTERN gdouble fade_tracker_get_alpha (FadeTracker* self);
VALA_EXTERN void greeter_list_connect_to_lightdm (GreeterList* self);
VALA_EXTERN void greeter_list_show_message_cb (GreeterList* self,
                                   const gchar* text,
                                   LightDMMessageType type);
static void _greeter_list_show_message_cb_slick_greeter_show_message (SlickGreeter* _sender,
                                                               const gchar* text,
                                                               LightDMMessageType type,
                                                               gpointer self);
static void _greeter_list_show_prompt_cb_slick_greeter_show_prompt (SlickGreeter* _sender,
                                                             const gchar* text,
                                                             LightDMPromptType type,
                                                             gpointer self);
static void _greeter_list_authentication_complete_cb_slick_greeter_authentication_complete (SlickGreeter* _sender,
                                                                                     gpointer self);
static void greeter_list_real_show_prompt_cb (GreeterList* self,
                                       const gchar* text,
                                       LightDMPromptType type);
VALA_EXTERN const gchar* greeter_list_get_manual_name (GreeterList* self);
VALA_EXTERN void greeter_list_set_manual_name (GreeterList* self,
                                   const gchar* value);
VALA_EXTERN gchar* slick_greeter_authentication_user (SlickGreeter* self);
static void greeter_list_real_authentication_complete_cb (GreeterList* self);
VALA_EXTERN gboolean slick_greeter_is_authenticated (SlickGreeter* self);
VALA_EXTERN void greeter_list_login_complete (GreeterList* self);
static void greeter_list_start_session (GreeterList* self);
VALA_EXTERN Background* greeter_list_get_background (GreeterList* self);
VALA_EXTERN gdouble background_get_alpha (Background* self);
static void greeter_list_background_loaded_cb (GreeterList* self,
                                        GParamSpec* pspec);
static void _greeter_list_background_loaded_cb_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
VALA_EXTERN void prompt_box_reset_spinners (PromptBox* self);
VALA_EXTERN gboolean prompt_box_get_has_errors (PromptBox* self);
static void greeter_list_real_start_authentication (GreeterList* self);
VALA_EXTERN void slick_greeter_authenticate (SlickGreeter* self,
                                 const gchar* userid);
VALA_EXTERN void slick_greeter_authenticate_as_guest (SlickGreeter* self);
VALA_EXTERN gboolean slick_greeter_start_session (SlickGreeter* self,
                                      const gchar* session,
                                      Background* bg);
static gchar* greeter_list_real_get_lightdm_session (GreeterList* self);
VALA_EXTERN gchar* slick_greeter_get_default_session (void);
static void greeter_list_real_test_start_authentication (GreeterList* self);
static void greeter_list_set_background (GreeterList* self,
                                  Background* value);
VALA_EXTERN MenuBar* greeter_list_get_menubar (GreeterList* self);
static void greeter_list_set_menubar (GreeterList* self,
                               MenuBar* value);
VALA_EXTERN void greeter_list_set_start_scrolling (GreeterList* self,
                                       gboolean value);
VALA_EXTERN gboolean greeter_list_get_always_show_manual (GreeterList* self);
VALA_EXTERN void greeter_list_set_always_show_manual (GreeterList* self,
                                          gboolean value);
VALA_EXTERN void prompt_box_set_options_image (PromptBox* self,
                                   GdkPixbuf* image,
                                   const gchar* tooltip);
static GObject * greeter_list_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
VALA_EXTERN DashBox* dash_box_new (Background* bg);
VALA_EXTERN DashBox* dash_box_construct (GType object_type,
                             Background* bg);
static void _greeter_list___lambda40_ (GreeterList* self);
static void __greeter_list___lambda40__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self);
static void _greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                          GtkAllocation* allocation,
                                                                          gpointer self);
VALA_EXTERN gdouble animate_timer_ease_out_quint (gdouble x);
static gdouble _animate_timer_ease_out_quint_animate_timer_easing_func (gdouble x,
                                                                 gpointer self);
VALA_EXTERN AnimateTimer* animate_timer_new (AnimateTimerEasingFunc func,
                                 gpointer func_target,
                                 gint speed);
VALA_EXTERN AnimateTimer* animate_timer_construct (GType object_type,
                                       AnimateTimerEasingFunc func,
                                       gpointer func_target,
                                       gint speed);
static void _greeter_list_animate_scrolling_animate_timer_animate (AnimateTimer* _sender,
                                                            gdouble progress,
                                                            gpointer self);
static void _greeter_list_on_bus_acquired_gasync_ready_callback (GObject* source_object,
                                                          GAsyncResult* res,
                                                          gpointer self);
static void greeter_list_finalize (GObject * obj);
static GType greeter_list_get_type_once (void);
static void _vala_greeter_list_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_greeter_list_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _list_dbus_interface_dbus_arg_info_get_active_entry_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _list_dbus_interface_dbus_arg_info_get_active_entry_in[] = {NULL};
static const GDBusArgInfo * const _list_dbus_interface_dbus_arg_info_get_active_entry_out[] = {&_list_dbus_interface_dbus_arg_info_get_active_entry_result, NULL};
static const GDBusMethodInfo _list_dbus_interface_dbus_method_info_get_active_entry = {-1, "GetActiveEntry", (GDBusArgInfo **) (&_list_dbus_interface_dbus_arg_info_get_active_entry_in), (GDBusArgInfo **) (&_list_dbus_interface_dbus_arg_info_get_active_entry_out), NULL};
static const GDBusArgInfo _list_dbus_interface_dbus_arg_info_set_active_entry_entry_name = {-1, "entry_name", "s", NULL};
static const GDBusArgInfo * const _list_dbus_interface_dbus_arg_info_set_active_entry_in[] = {&_list_dbus_interface_dbus_arg_info_set_active_entry_entry_name, NULL};
static const GDBusArgInfo * const _list_dbus_interface_dbus_arg_info_set_active_entry_out[] = {NULL};
static const GDBusMethodInfo _list_dbus_interface_dbus_method_info_set_active_entry = {-1, "SetActiveEntry", (GDBusArgInfo **) (&_list_dbus_interface_dbus_arg_info_set_active_entry_in), (GDBusArgInfo **) (&_list_dbus_interface_dbus_arg_info_set_active_entry_out), NULL};
static const GDBusMethodInfo * const _list_dbus_interface_dbus_method_info[] = {&_list_dbus_interface_dbus_method_info_get_active_entry, &_list_dbus_interface_dbus_method_info_set_active_entry, NULL};
static const GDBusArgInfo _list_dbus_interface_dbus_arg_info_entry_selected_entry_name = {-1, "entry_name", "s", NULL};
static const GDBusArgInfo * const _list_dbus_interface_dbus_arg_info_entry_selected[] = {&_list_dbus_interface_dbus_arg_info_entry_selected_entry_name, NULL};
static const GDBusSignalInfo _list_dbus_interface_dbus_signal_info_entry_selected = {-1, "EntrySelected", (GDBusArgInfo **) (&_list_dbus_interface_dbus_arg_info_entry_selected), NULL};
static const GDBusSignalInfo * const _list_dbus_interface_dbus_signal_info[] = {&_list_dbus_interface_dbus_signal_info_entry_selected, NULL};
static const GDBusPropertyInfo * const _list_dbus_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _list_dbus_interface_dbus_interface_info = {-1, "x.dm.SlickGreeter.List", (GDBusMethodInfo **) (&_list_dbus_interface_dbus_method_info), (GDBusSignalInfo **) (&_list_dbus_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_list_dbus_interface_dbus_property_info), NULL};
static const GDBusInterfaceVTable _list_dbus_interface_dbus_interface_vtable = {list_dbus_interface_dbus_interface_method_call, list_dbus_interface_dbus_interface_get_property, list_dbus_interface_dbus_interface_set_property};

gint
get_grid_offset (gint size)
{
	gint result;
#line 28 "../src/greeter-list.vala"
	result = ((gint) (size % grid_size)) / 2;
#line 28 "../src/greeter-list.vala"
	return result;
#line 696 "greeter-list.c"
}

static inline gpointer
list_dbus_interface_get_instance_private (ListDBusInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ListDBusInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 38 "../src/greeter-list.vala"
	return self ? g_object_ref (self) : NULL;
#line 710 "greeter-list.c"
}

static void
__lambda37_ (ListDBusInterface* self,
             const gchar* name)
{
#line 40 "../src/greeter-list.vala"
	g_signal_emit (self, list_dbus_interface_signals[LIST_DBUS_INTERFACE_ENTRY_SELECTED_SIGNAL], 0, name);
#line 719 "greeter-list.c"
}

static void
___lambda37__greeter_list_entry_selected (GreeterList* _sender,
                                          const gchar* name,
                                          gpointer self)
{
#line 39 "../src/greeter-list.vala"
	__lambda37_ ((ListDBusInterface*) self, name);
#line 729 "greeter-list.c"
}

ListDBusInterface*
list_dbus_interface_construct (GType object_type,
                               GreeterList* list)
{
	ListDBusInterface * self = NULL;
	GreeterList* _tmp0_;
	GreeterList* _tmp1_;
#line 36 "../src/greeter-list.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 36 "../src/greeter-list.vala"
	self = (ListDBusInterface*) g_object_new (object_type, NULL);
#line 38 "../src/greeter-list.vala"
	_tmp0_ = _g_object_ref0 (list);
#line 38 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->list);
#line 38 "../src/greeter-list.vala"
	self->priv->list = _tmp0_;
#line 39 "../src/greeter-list.vala"
	_tmp1_ = self->priv->list;
#line 39 "../src/greeter-list.vala"
	g_signal_connect_object (_tmp1_, "entry-selected", (GCallback) ___lambda37__greeter_list_entry_selected, self, 0);
#line 36 "../src/greeter-list.vala"
	return self;
#line 755 "greeter-list.c"
}

ListDBusInterface*
list_dbus_interface_new (GreeterList* list)
{
#line 36 "../src/greeter-list.vala"
	return list_dbus_interface_construct (TYPE_LIST_DBUS_INTERFACE, list);
#line 763 "greeter-list.c"
}

gchar*
list_dbus_interface_get_active_entry (ListDBusInterface* self,
                                      GError** error)
{
	gchar* entry = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GreeterList* _tmp2_;
	PromptBox* _tmp3_;
	PromptBox* _tmp4_;
	gchar* result;
#line 44 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "../src/greeter-list.vala"
	_tmp0_ = g_strdup ("");
#line 46 "../src/greeter-list.vala"
	entry = _tmp0_;
#line 48 "../src/greeter-list.vala"
	_tmp2_ = self->priv->list;
#line 48 "../src/greeter-list.vala"
	_tmp3_ = greeter_list_get_selected_entry (_tmp2_);
#line 48 "../src/greeter-list.vala"
	_tmp4_ = _tmp3_;
#line 48 "../src/greeter-list.vala"
	if (_tmp4_ != NULL) {
#line 791 "greeter-list.c"
		GreeterList* _tmp5_;
		PromptBox* _tmp6_;
		PromptBox* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 48 "../src/greeter-list.vala"
		_tmp5_ = self->priv->list;
#line 48 "../src/greeter-list.vala"
		_tmp6_ = greeter_list_get_selected_entry (_tmp5_);
#line 48 "../src/greeter-list.vala"
		_tmp7_ = _tmp6_;
#line 48 "../src/greeter-list.vala"
		_tmp8_ = prompt_box_get_id (_tmp7_);
#line 48 "../src/greeter-list.vala"
		_tmp9_ = _tmp8_;
#line 48 "../src/greeter-list.vala"
		_tmp1_ = _tmp9_ != NULL;
#line 809 "greeter-list.c"
	} else {
#line 48 "../src/greeter-list.vala"
		_tmp1_ = FALSE;
#line 813 "greeter-list.c"
	}
#line 48 "../src/greeter-list.vala"
	if (_tmp1_) {
#line 817 "greeter-list.c"
		GreeterList* _tmp10_;
		PromptBox* _tmp11_;
		PromptBox* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
#line 49 "../src/greeter-list.vala"
		_tmp10_ = self->priv->list;
#line 49 "../src/greeter-list.vala"
		_tmp11_ = greeter_list_get_selected_entry (_tmp10_);
#line 49 "../src/greeter-list.vala"
		_tmp12_ = _tmp11_;
#line 49 "../src/greeter-list.vala"
		_tmp13_ = prompt_box_get_id (_tmp12_);
#line 49 "../src/greeter-list.vala"
		_tmp14_ = _tmp13_;
#line 49 "../src/greeter-list.vala"
		_tmp15_ = g_strdup (_tmp14_);
#line 49 "../src/greeter-list.vala"
		_g_free0 (entry);
#line 49 "../src/greeter-list.vala"
		entry = _tmp15_;
#line 840 "greeter-list.c"
	}
#line 51 "../src/greeter-list.vala"
	result = entry;
#line 51 "../src/greeter-list.vala"
	return result;
#line 846 "greeter-list.c"
}

void
list_dbus_interface_set_active_entry (ListDBusInterface* self,
                                      const gchar* entry_name,
                                      GError** error)
{
	GreeterList* _tmp0_;
#line 54 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 54 "../src/greeter-list.vala"
	g_return_if_fail (entry_name != NULL);
#line 56 "../src/greeter-list.vala"
	_tmp0_ = self->priv->list;
#line 56 "../src/greeter-list.vala"
	greeter_list_set_active_entry (_tmp0_, entry_name);
#line 863 "greeter-list.c"
}

static void
list_dbus_interface_class_init (ListDBusInterfaceClass * klass,
                                gpointer klass_data)
{
#line 32 "../src/greeter-list.vala"
	list_dbus_interface_parent_class = g_type_class_peek_parent (klass);
#line 32 "../src/greeter-list.vala"
	g_type_class_adjust_private_offset (klass, &ListDBusInterface_private_offset);
#line 32 "../src/greeter-list.vala"
	G_OBJECT_CLASS (klass)->finalize = list_dbus_interface_finalize;
#line 32 "../src/greeter-list.vala"
	list_dbus_interface_signals[LIST_DBUS_INTERFACE_ENTRY_SELECTED_SIGNAL] = g_signal_new ("entry-selected", TYPE_LIST_DBUS_INTERFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 878 "greeter-list.c"
}

static void
list_dbus_interface_instance_init (ListDBusInterface * self,
                                   gpointer klass)
{
#line 32 "../src/greeter-list.vala"
	self->priv = list_dbus_interface_get_instance_private (self);
#line 887 "greeter-list.c"
}

static void
list_dbus_interface_finalize (GObject * obj)
{
	ListDBusInterface * self;
#line 32 "../src/greeter-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_DBUS_INTERFACE, ListDBusInterface);
#line 34 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->list);
#line 32 "../src/greeter-list.vala"
	G_OBJECT_CLASS (list_dbus_interface_parent_class)->finalize (obj);
#line 900 "greeter-list.c"
}

static GType
list_dbus_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ListDBusInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_dbus_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListDBusInterface), 0, (GInstanceInitFunc) list_dbus_interface_instance_init, NULL };
	GType list_dbus_interface_type_id;
	list_dbus_interface_type_id = g_type_register_static (G_TYPE_OBJECT, "ListDBusInterface", &g_define_type_info, 0);
	g_type_set_qdata (list_dbus_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) list_dbus_interface_register_object);
	ListDBusInterface_private_offset = g_type_add_instance_private (list_dbus_interface_type_id, sizeof (ListDBusInterfacePrivate));
	return list_dbus_interface_type_id;
}

GType
list_dbus_interface_get_type (void)
{
	static volatile gsize list_dbus_interface_type_id__once = 0;
	if (g_once_init_enter (&list_dbus_interface_type_id__once)) {
		GType list_dbus_interface_type_id;
		list_dbus_interface_type_id = list_dbus_interface_get_type_once ();
		g_once_init_leave (&list_dbus_interface_type_id__once, list_dbus_interface_type_id);
	}
	return list_dbus_interface_type_id__once;
}

static void
_dbus_list_dbus_interface_get_active_entry (ListDBusInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = list_dbus_interface_get_active_entry (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_list_dbus_interface_set_active_entry (ListDBusInterface* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* entry_name = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	entry_name = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	list_dbus_interface_set_active_entry (self, entry_name, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (entry_name);
	;
}

static void
list_dbus_interface_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetActiveEntry") == 0) {
		_dbus_list_dbus_interface_get_active_entry (object, parameters, invocation);
	} else if (strcmp (method_name, "SetActiveEntry") == 0) {
		_dbus_list_dbus_interface_set_active_entry (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
list_dbus_interface_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
list_dbus_interface_dbus_interface_set_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GVariant* value,
                                                 GError** error,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_list_dbus_interface_entry_selected (GObject* _sender,
                                          const gchar* entry_name,
                                          gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (entry_name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "x.dm.SlickGreeter.List", "EntrySelected", _arguments, NULL);
}

guint
list_dbus_interface_register_object (gpointer object,
                                     GDBusConnection* connection,
                                     const gchar* path,
                                     GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_list_dbus_interface_dbus_interface_info), &_list_dbus_interface_dbus_interface_vtable, data, _list_dbus_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "entry-selected", (GCallback) _dbus_list_dbus_interface_entry_selected, data);
	return result;
}

static void
_list_dbus_interface_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_list_dbus_interface_entry_selected, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
greeter_list_get_instance_private (GreeterList* self)
{
	return G_STRUCT_MEMBER_P (self, GreeterList_private_offset);
}

static GType
greeter_list_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GREETER_LIST_MODE_ENTRY, "GREETER_LIST_MODE_ENTRY", "entry"}, {GREETER_LIST_MODE_SCROLLING, "GREETER_LIST_MODE_SCROLLING", "scrolling"}, {0, NULL, NULL}};
	GType greeter_list_mode_type_id;
	greeter_list_mode_type_id = g_enum_register_static ("GreeterListMode", values);
	return greeter_list_mode_type_id;
}

GType
greeter_list_mode_get_type (void)
{
	static volatile gsize greeter_list_mode_type_id__once = 0;
	if (g_once_init_enter (&greeter_list_mode_type_id__once)) {
		GType greeter_list_mode_type_id;
		greeter_list_mode_type_id = greeter_list_mode_get_type_once ();
		g_once_init_leave (&greeter_list_mode_type_id__once, greeter_list_mode_type_id);
	}
	return greeter_list_mode_type_id__once;
}

static GType
greeter_list_scroll_target_get_type_once (void)
{
	static const GEnumValue values[] = {{GREETER_LIST_SCROLL_TARGET_START, "GREETER_LIST_SCROLL_TARGET_START", "start"}, {GREETER_LIST_SCROLL_TARGET_END, "GREETER_LIST_SCROLL_TARGET_END", "end"}, {GREETER_LIST_SCROLL_TARGET_UP, "GREETER_LIST_SCROLL_TARGET_UP", "up"}, {GREETER_LIST_SCROLL_TARGET_DOWN, "GREETER_LIST_SCROLL_TARGET_DOWN", "down"}, {0, NULL, NULL}};
	GType greeter_list_scroll_target_type_id;
	greeter_list_scroll_target_type_id = g_enum_register_static ("GreeterListScrollTarget", values);
	return greeter_list_scroll_target_type_id;
}

GType
greeter_list_scroll_target_get_type (void)
{
	static volatile gsize greeter_list_scroll_target_type_id__once = 0;
	if (g_once_init_enter (&greeter_list_scroll_target_type_id__once)) {
		GType greeter_list_scroll_target_type_id;
		greeter_list_scroll_target_type_id = greeter_list_scroll_target_get_type_once ();
		g_once_init_leave (&greeter_list_scroll_target_type_id__once, greeter_list_scroll_target_type_id);
	}
	return greeter_list_scroll_target_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
#line 85 "../src/greeter-list.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1145 "greeter-list.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 85 "../src/greeter-list.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 1153 "greeter-list.c"
}

static gchar*
greeter_list_real_get_selected_id (GreeterList* self)
{
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 138 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 138 "../src/greeter-list.vala"
	if (_tmp0_ == NULL) {
#line 139 "../src/greeter-list.vala"
		result = NULL;
#line 139 "../src/greeter-list.vala"
		return result;
#line 1173 "greeter-list.c"
	}
#line 140 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 140 "../src/greeter-list.vala"
	_tmp2_ = prompt_box_get_id (_tmp1_);
#line 140 "../src/greeter-list.vala"
	_tmp3_ = _tmp2_;
#line 140 "../src/greeter-list.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 140 "../src/greeter-list.vala"
	result = _tmp4_;
#line 140 "../src/greeter-list.vala"
	return result;
#line 1187 "greeter-list.c"
}

gchar*
greeter_list_get_selected_id (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 136 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 136 "../src/greeter-list.vala"
	if (_klass_->get_selected_id) {
#line 136 "../src/greeter-list.vala"
		return _klass_->get_selected_id (self);
#line 1202 "greeter-list.c"
	}
#line 136 "../src/greeter-list.vala"
	return NULL;
#line 1206 "greeter-list.c"
}

GreeterList*
greeter_list_construct (GType object_type,
                        Background* bg,
                        MenuBar* mb)
{
	GreeterList * self = NULL;
#line 169 "../src/greeter-list.vala"
	g_return_val_if_fail (bg != NULL, NULL);
#line 169 "../src/greeter-list.vala"
	g_return_val_if_fail (mb != NULL, NULL);
#line 171 "../src/greeter-list.vala"
	self = (GreeterList*) g_object_new (object_type, "background", bg, "menubar", mb, NULL);
#line 169 "../src/greeter-list.vala"
	return self;
#line 1223 "greeter-list.c"
}

static void
greeter_list_on_bus_acquired (GreeterList* self,
                              GObject* obj,
                              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
#line 204 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 204 "../src/greeter-list.vala"
	g_return_if_fail (res != NULL);
#line 1236 "greeter-list.c"
	{
		GDBusConnection* conn = NULL;
		GDBusConnection* _tmp0_;
		ListDBusInterface* _tmp1_;
		GDBusConnection* _tmp2_;
		ListDBusInterface* _tmp3_;
#line 208 "../src/greeter-list.vala"
		_tmp0_ = g_bus_get_finish (res, &_inner_error0_);
#line 208 "../src/greeter-list.vala"
		conn = _tmp0_;
#line 208 "../src/greeter-list.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 208 "../src/greeter-list.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 1251 "greeter-list.c"
				goto __catch0_g_io_error;
			}
#line 208 "../src/greeter-list.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 208 "../src/greeter-list.vala"
			g_clear_error (&_inner_error0_);
#line 208 "../src/greeter-list.vala"
			return;
#line 1260 "greeter-list.c"
		}
#line 209 "../src/greeter-list.vala"
		_tmp1_ = list_dbus_interface_new (self);
#line 209 "../src/greeter-list.vala"
		_g_object_unref0 (self->priv->dbus_object);
#line 209 "../src/greeter-list.vala"
		self->priv->dbus_object = _tmp1_;
#line 210 "../src/greeter-list.vala"
		_tmp2_ = conn;
#line 210 "../src/greeter-list.vala"
		_tmp3_ = self->priv->dbus_object;
#line 210 "../src/greeter-list.vala"
		list_dbus_interface_register_object (_tmp3_, _tmp2_, "/list", &_inner_error0_);
#line 210 "../src/greeter-list.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 210 "../src/greeter-list.vala"
			_g_object_unref0 (conn);
#line 210 "../src/greeter-list.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 1280 "greeter-list.c"
				goto __catch0_g_io_error;
			}
#line 210 "../src/greeter-list.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 210 "../src/greeter-list.vala"
			g_clear_error (&_inner_error0_);
#line 210 "../src/greeter-list.vala"
			return;
#line 1289 "greeter-list.c"
		}
#line 206 "../src/greeter-list.vala"
		_g_object_unref0 (conn);
#line 1293 "greeter-list.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 206 "../src/greeter-list.vala"
		e = _inner_error0_;
#line 206 "../src/greeter-list.vala"
		_inner_error0_ = NULL;
#line 214 "../src/greeter-list.vala"
		_tmp4_ = e;
#line 214 "../src/greeter-list.vala"
		_tmp5_ = _tmp4_->message;
#line 214 "../src/greeter-list.vala"
		g_debug ("greeter-list.vala:214: Error registering user list dbus object: %s", _tmp5_);
#line 206 "../src/greeter-list.vala"
		_g_error_free0 (e);
#line 1313 "greeter-list.c"
	}
	__finally0:
#line 206 "../src/greeter-list.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 206 "../src/greeter-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 206 "../src/greeter-list.vala"
		g_clear_error (&_inner_error0_);
#line 206 "../src/greeter-list.vala"
		return;
#line 1324 "greeter-list.c"
	}
}

static void
greeter_list_real_get_preferred_width (GtkWidget* base,
                                       gint* min,
                                       gint* nat)
{
	GreeterList * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
#line 226 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 228 "../src/greeter-list.vala"
	_vala_min = GREETER_LIST_BOX_WIDTH * grid_size;
#line 229 "../src/greeter-list.vala"
	_vala_nat = GREETER_LIST_BOX_WIDTH * grid_size;
#line 226 "../src/greeter-list.vala"
	if (min) {
#line 226 "../src/greeter-list.vala"
		*min = _vala_min;
#line 1346 "greeter-list.c"
	}
#line 226 "../src/greeter-list.vala"
	if (nat) {
#line 226 "../src/greeter-list.vala"
		*nat = _vala_nat;
#line 1352 "greeter-list.c"
	}
}

static void
greeter_list_real_get_preferred_height (GtkWidget* base,
                                        gint* min,
                                        gint* nat)
{
	GreeterList * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 232 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 234 "../src/greeter-list.vala"
	GTK_WIDGET_CLASS (greeter_list_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_, &_tmp1_);
#line 234 "../src/greeter-list.vala"
	_vala_min = _tmp0_;
#line 234 "../src/greeter-list.vala"
	_vala_nat = _tmp1_;
#line 235 "../src/greeter-list.vala"
	_vala_min = 0;
#line 232 "../src/greeter-list.vala"
	if (min) {
#line 232 "../src/greeter-list.vala"
		*min = _vala_min;
#line 1380 "greeter-list.c"
	}
#line 232 "../src/greeter-list.vala"
	if (nat) {
#line 232 "../src/greeter-list.vala"
		*nat = _vala_nat;
#line 1386 "greeter-list.c"
	}
}

void
greeter_list_cancel_authentication (GreeterList* self)
{
	SlickGreeter* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 238 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 240 "../src/greeter-list.vala"
	_tmp0_ = slick_greeter_singleton;
#line 240 "../src/greeter-list.vala"
	slick_greeter_cancel_authentication (_tmp0_);
#line 241 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 241 "../src/greeter-list.vala"
	_tmp2_ = prompt_box_get_id (_tmp1_);
#line 241 "../src/greeter-list.vala"
	_tmp3_ = _tmp2_;
#line 241 "../src/greeter-list.vala"
	g_signal_emit (self, greeter_list_signals[GREETER_LIST_ENTRY_SELECTED_SIGNAL], 0, _tmp3_);
#line 1411 "greeter-list.c"
}

void
greeter_list_scroll (GreeterList* self,
                     GreeterListScrollTarget target)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 244 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 246 "../src/greeter-list.vala"
	_tmp0_ = gtk_widget_get_sensitive ((GtkWidget*) self);
#line 246 "../src/greeter-list.vala"
	_tmp1_ = _tmp0_;
#line 246 "../src/greeter-list.vala"
	if (!_tmp1_) {
#line 247 "../src/greeter-list.vala"
		return;
#line 1430 "greeter-list.c"
	}
#line 249 "../src/greeter-list.vala"
	switch (target) {
#line 249 "../src/greeter-list.vala"
		case GREETER_LIST_SCROLL_TARGET_START:
#line 1436 "greeter-list.c"
		{
			GList* _tmp2_;
			gconstpointer _tmp3_;
#line 252 "../src/greeter-list.vala"
			_tmp2_ = self->entries;
#line 252 "../src/greeter-list.vala"
			_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 252 "../src/greeter-list.vala"
			greeter_list_select_entry (self, (PromptBox*) _tmp3_, -1.0, TRUE);
#line 253 "../src/greeter-list.vala"
			break;
#line 1448 "greeter-list.c"
		}
#line 249 "../src/greeter-list.vala"
		case GREETER_LIST_SCROLL_TARGET_END:
#line 1452 "greeter-list.c"
		{
			GList* _tmp4_;
			GList* _tmp5_;
			gconstpointer _tmp6_;
#line 255 "../src/greeter-list.vala"
			_tmp4_ = self->entries;
#line 255 "../src/greeter-list.vala"
			_tmp5_ = self->entries;
#line 255 "../src/greeter-list.vala"
			_tmp6_ = g_list_nth_data (_tmp4_, g_list_length (_tmp5_) - 1);
#line 255 "../src/greeter-list.vala"
			greeter_list_select_entry (self, (PromptBox*) _tmp6_, 1.0, TRUE);
#line 256 "../src/greeter-list.vala"
			break;
#line 1467 "greeter-list.c"
		}
#line 249 "../src/greeter-list.vala"
		case GREETER_LIST_SCROLL_TARGET_UP:
#line 1471 "greeter-list.c"
		{
			gint index = 0;
			GList* _tmp7_;
			PromptBox* _tmp8_;
			GList* _tmp9_;
			gconstpointer _tmp10_;
#line 258 "../src/greeter-list.vala"
			_tmp7_ = self->entries;
#line 258 "../src/greeter-list.vala"
			_tmp8_ = self->priv->_selected_entry;
#line 258 "../src/greeter-list.vala"
			index = g_list_index (_tmp7_, _tmp8_) - 1;
#line 259 "../src/greeter-list.vala"
			if (index < 0) {
#line 260 "../src/greeter-list.vala"
				index = 0;
#line 1488 "greeter-list.c"
			}
#line 261 "../src/greeter-list.vala"
			_tmp9_ = self->entries;
#line 261 "../src/greeter-list.vala"
			_tmp10_ = g_list_nth_data (_tmp9_, (guint) index);
#line 261 "../src/greeter-list.vala"
			greeter_list_select_entry (self, (PromptBox*) _tmp10_, -1.0, TRUE);
#line 262 "../src/greeter-list.vala"
			break;
#line 1498 "greeter-list.c"
		}
#line 249 "../src/greeter-list.vala"
		case GREETER_LIST_SCROLL_TARGET_DOWN:
#line 1502 "greeter-list.c"
		{
			gint index = 0;
			GList* _tmp11_;
			PromptBox* _tmp12_;
			GList* _tmp13_;
			GList* _tmp15_;
			gconstpointer _tmp16_;
#line 264 "../src/greeter-list.vala"
			_tmp11_ = self->entries;
#line 264 "../src/greeter-list.vala"
			_tmp12_ = self->priv->_selected_entry;
#line 264 "../src/greeter-list.vala"
			index = g_list_index (_tmp11_, _tmp12_) + 1;
#line 265 "../src/greeter-list.vala"
			_tmp13_ = self->entries;
#line 265 "../src/greeter-list.vala"
			if (index >= ((gint) g_list_length (_tmp13_))) {
#line 1520 "greeter-list.c"
				GList* _tmp14_;
#line 266 "../src/greeter-list.vala"
				_tmp14_ = self->entries;
#line 266 "../src/greeter-list.vala"
				index = ((gint) g_list_length (_tmp14_)) - 1;
#line 1526 "greeter-list.c"
			}
#line 267 "../src/greeter-list.vala"
			_tmp15_ = self->entries;
#line 267 "../src/greeter-list.vala"
			_tmp16_ = g_list_nth_data (_tmp15_, (guint) index);
#line 267 "../src/greeter-list.vala"
			greeter_list_select_entry (self, (PromptBox*) _tmp16_, 1.0, TRUE);
#line 268 "../src/greeter-list.vala"
			break;
#line 1536 "greeter-list.c"
		}
		default:
#line 249 "../src/greeter-list.vala"
		break;
#line 1541 "greeter-list.c"
	}
}

void
greeter_list_add_with_class (GreeterList* self,
                             GtkWidget* widget)
{
	GtkFixed* _tmp0_;
#line 272 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 272 "../src/greeter-list.vala"
	g_return_if_fail (widget != NULL);
#line 274 "../src/greeter-list.vala"
	_tmp0_ = self->priv->fixed;
#line 274 "../src/greeter-list.vala"
	gtk_container_add ((GtkContainer*) _tmp0_, widget);
#line 275 "../src/greeter-list.vala"
	slick_greeter_add_style_class (widget);
#line 1560 "greeter-list.c"
}

void
greeter_list_redraw_greeter_box (GreeterList* self)
{
	GtkAllocation allocation = {0};
	DashBox* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkAllocation _tmp5_;
#line 278 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 281 "../src/greeter-list.vala"
	_tmp0_ = self->greeter_box;
#line 281 "../src/greeter-list.vala"
	gtk_widget_get_allocation ((GtkWidget*) _tmp0_, &_tmp1_);
#line 281 "../src/greeter-list.vala"
	allocation = _tmp1_;
#line 282 "../src/greeter-list.vala"
	_tmp2_ = allocation;
#line 282 "../src/greeter-list.vala"
	_tmp3_ = allocation;
#line 282 "../src/greeter-list.vala"
	_tmp4_ = allocation;
#line 282 "../src/greeter-list.vala"
	_tmp5_ = allocation;
#line 282 "../src/greeter-list.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp2_.x, _tmp3_.y, _tmp4_.width, _tmp5_.height);
#line 1591 "greeter-list.c"
}

void
greeter_list_show_message (GreeterList* self,
                           const gchar* text,
                           gboolean is_error)
{
	PromptBox* _tmp1_;
#line 285 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 285 "../src/greeter-list.vala"
	g_return_if_fail (text != NULL);
#line 287 "../src/greeter-list.vala"
	if (self->will_clear) {
#line 1606 "greeter-list.c"
		PromptBox* _tmp0_;
#line 289 "../src/greeter-list.vala"
		_tmp0_ = self->priv->_selected_entry;
#line 289 "../src/greeter-list.vala"
		prompt_box_clear (_tmp0_);
#line 290 "../src/greeter-list.vala"
		self->will_clear = FALSE;
#line 1614 "greeter-list.c"
	}
#line 293 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 293 "../src/greeter-list.vala"
	prompt_box_add_message (_tmp1_, text, is_error);
#line 1620 "greeter-list.c"
}

DashEntry*
greeter_list_add_prompt (GreeterList* self,
                         const gchar* text,
                         gboolean secret)
{
	gchar* accessible_text = NULL;
	gboolean _tmp1_ = FALSE;
	PromptBox* _tmp2_;
	DashEntry* prompt = NULL;
	PromptBox* _tmp11_;
	const gchar* _tmp12_;
	DashEntry* _tmp13_;
	DashEntry* result;
#line 296 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 296 "../src/greeter-list.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 298 "../src/greeter-list.vala"
	if (self->will_clear) {
#line 1642 "greeter-list.c"
		PromptBox* _tmp0_;
#line 300 "../src/greeter-list.vala"
		_tmp0_ = self->priv->_selected_entry;
#line 300 "../src/greeter-list.vala"
		prompt_box_clear (_tmp0_);
#line 301 "../src/greeter-list.vala"
		self->will_clear = FALSE;
#line 1650 "greeter-list.c"
	}
#line 304 "../src/greeter-list.vala"
	accessible_text = NULL;
#line 305 "../src/greeter-list.vala"
	_tmp2_ = self->priv->_selected_entry;
#line 305 "../src/greeter-list.vala"
	if (_tmp2_ != NULL) {
#line 1658 "greeter-list.c"
		PromptBox* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 305 "../src/greeter-list.vala"
		_tmp3_ = self->priv->_selected_entry;
#line 305 "../src/greeter-list.vala"
		_tmp4_ = prompt_box_get_label (_tmp3_);
#line 305 "../src/greeter-list.vala"
		_tmp5_ = _tmp4_;
#line 305 "../src/greeter-list.vala"
		_tmp1_ = _tmp5_ != NULL;
#line 1670 "greeter-list.c"
	} else {
#line 305 "../src/greeter-list.vala"
		_tmp1_ = FALSE;
#line 1674 "greeter-list.c"
	}
#line 305 "../src/greeter-list.vala"
	if (_tmp1_) {
#line 306 "../src/greeter-list.vala"
		if (secret) {
#line 1680 "greeter-list.c"
			PromptBox* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
#line 307 "../src/greeter-list.vala"
			_tmp6_ = self->priv->_selected_entry;
#line 307 "../src/greeter-list.vala"
			_tmp7_ = prompt_box_get_label (_tmp6_);
#line 307 "../src/greeter-list.vala"
			_tmp8_ = _tmp7_;
#line 307 "../src/greeter-list.vala"
			_tmp9_ = g_strdup_printf (_ ("Enter password for %s"), _tmp8_);
#line 307 "../src/greeter-list.vala"
			_g_free0 (accessible_text);
#line 307 "../src/greeter-list.vala"
			accessible_text = _tmp9_;
#line 1697 "greeter-list.c"
		} else {
			gchar* _tmp10_;
#line 309 "../src/greeter-list.vala"
			_tmp10_ = g_strdup (_ ("Enter your username"));
#line 309 "../src/greeter-list.vala"
			_g_free0 (accessible_text);
#line 309 "../src/greeter-list.vala"
			accessible_text = _tmp10_;
#line 1706 "greeter-list.c"
		}
	}
#line 311 "../src/greeter-list.vala"
	_tmp11_ = self->priv->_selected_entry;
#line 311 "../src/greeter-list.vala"
	_tmp12_ = accessible_text;
#line 311 "../src/greeter-list.vala"
	_tmp13_ = prompt_box_add_prompt (_tmp11_, text, _tmp12_, secret);
#line 311 "../src/greeter-list.vala"
	prompt = _tmp13_;
#line 313 "../src/greeter-list.vala"
	if (self->mode != GREETER_LIST_MODE_SCROLLING) {
#line 1719 "greeter-list.c"
		PromptBox* _tmp14_;
#line 314 "../src/greeter-list.vala"
		_tmp14_ = self->priv->_selected_entry;
#line 314 "../src/greeter-list.vala"
		prompt_box_show_prompts (_tmp14_);
#line 1725 "greeter-list.c"
	}
#line 316 "../src/greeter-list.vala"
	greeter_list_focus_prompt (self);
#line 317 "../src/greeter-list.vala"
	greeter_list_redraw_greeter_box (self);
#line 319 "../src/greeter-list.vala"
	result = prompt;
#line 319 "../src/greeter-list.vala"
	_g_free0 (accessible_text);
#line 319 "../src/greeter-list.vala"
	return result;
#line 1737 "greeter-list.c"
}

GtkComboBox*
greeter_list_add_combo (GreeterList* self,
                        GPtrArray* texts,
                        gboolean read_only)
{
	GtkComboBox* combo = NULL;
	PromptBox* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* result;
#line 322 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 322 "../src/greeter-list.vala"
	g_return_val_if_fail (texts != NULL, NULL);
#line 324 "../src/greeter-list.vala"
	if (self->will_clear) {
#line 1755 "greeter-list.c"
		PromptBox* _tmp0_;
#line 326 "../src/greeter-list.vala"
		_tmp0_ = self->priv->_selected_entry;
#line 326 "../src/greeter-list.vala"
		prompt_box_clear (_tmp0_);
#line 327 "../src/greeter-list.vala"
		self->will_clear = FALSE;
#line 1763 "greeter-list.c"
	}
#line 330 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 330 "../src/greeter-list.vala"
	_tmp2_ = prompt_box_add_combo (_tmp1_, texts, read_only);
#line 330 "../src/greeter-list.vala"
	combo = _tmp2_;
#line 332 "../src/greeter-list.vala"
	greeter_list_focus_prompt (self);
#line 333 "../src/greeter-list.vala"
	greeter_list_redraw_greeter_box (self);
#line 335 "../src/greeter-list.vala"
	result = combo;
#line 335 "../src/greeter-list.vala"
	return result;
#line 1779 "greeter-list.c"
}

static void
greeter_list_real_grab_focus (GtkWidget* base)
{
	GreeterList * self;
#line 338 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 340 "../src/greeter-list.vala"
	greeter_list_focus_prompt (self);
#line 1790 "greeter-list.c"
}

static void
greeter_list_real_focus_prompt (GreeterList* self)
{
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
#line 345 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 345 "../src/greeter-list.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
#line 346 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 346 "../src/greeter-list.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
#line 1806 "greeter-list.c"
}

void
greeter_list_focus_prompt (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 343 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 343 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 343 "../src/greeter-list.vala"
	if (_klass_->focus_prompt) {
#line 343 "../src/greeter-list.vala"
		_klass_->focus_prompt (self);
#line 1821 "greeter-list.c"
	}
}

static void
greeter_list_real_show_authenticated (GreeterList* self,
                                      gboolean successful)
{
#line 349 "../src/greeter-list.vala"
	g_critical ("Type `%s' does not implement abstract method `greeter_list_show_authenticated'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 349 "../src/greeter-list.vala"
	return;
#line 1833 "greeter-list.c"
}

void
greeter_list_show_authenticated (GreeterList* self,
                                 gboolean successful)
{
	GreeterListClass* _klass_;
#line 349 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 349 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 349 "../src/greeter-list.vala"
	if (_klass_->show_authenticated) {
#line 349 "../src/greeter-list.vala"
		_klass_->show_authenticated (self, successful);
#line 1849 "greeter-list.c"
	}
}

PromptBox*
greeter_list_find_entry (GreeterList* self,
                         const gchar* id)
{
	GList* _tmp0_;
	PromptBox* result;
#line 351 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 351 "../src/greeter-list.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 353 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 1865 "greeter-list.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 353 "../src/greeter-list.vala"
		entry_collection = _tmp0_;
#line 353 "../src/greeter-list.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 1873 "greeter-list.c"
			PromptBox* _tmp1_;
			PromptBox* entry = NULL;
#line 353 "../src/greeter-list.vala"
			_tmp1_ = _g_object_ref0 ((PromptBox*) entry_it->data);
#line 353 "../src/greeter-list.vala"
			entry = _tmp1_;
#line 1880 "greeter-list.c"
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 355 "../src/greeter-list.vala"
				_tmp2_ = entry;
#line 355 "../src/greeter-list.vala"
				_tmp3_ = prompt_box_get_id (_tmp2_);
#line 355 "../src/greeter-list.vala"
				_tmp4_ = _tmp3_;
#line 355 "../src/greeter-list.vala"
				if (g_strcmp0 (_tmp4_, id) == 0) {
#line 356 "../src/greeter-list.vala"
					result = entry;
#line 356 "../src/greeter-list.vala"
					return result;
#line 1897 "greeter-list.c"
				}
#line 353 "../src/greeter-list.vala"
				_g_object_unref0 (entry);
#line 1901 "greeter-list.c"
			}
		}
	}
#line 359 "../src/greeter-list.vala"
	result = NULL;
#line 359 "../src/greeter-list.vala"
	return result;
#line 1909 "greeter-list.c"
}

gint
greeter_list_compare_entry (PromptBox* a,
                            PromptBox* b)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint result;
#line 362 "../src/greeter-list.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 362 "../src/greeter-list.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 364 "../src/greeter-list.vala"
	_tmp1_ = prompt_box_get_id (a);
#line 364 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 364 "../src/greeter-list.vala"
	if (g_str_has_prefix (_tmp2_, "*")) {
#line 364 "../src/greeter-list.vala"
		_tmp0_ = TRUE;
#line 1936 "greeter-list.c"
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
#line 364 "../src/greeter-list.vala"
		_tmp3_ = prompt_box_get_id (b);
#line 364 "../src/greeter-list.vala"
		_tmp4_ = _tmp3_;
#line 364 "../src/greeter-list.vala"
		_tmp0_ = g_str_has_prefix (_tmp4_, "*");
#line 1946 "greeter-list.c"
	}
#line 364 "../src/greeter-list.vala"
	if (_tmp0_) {
#line 1950 "greeter-list.c"
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
#line 367 "../src/greeter-list.vala"
		_tmp5_ = prompt_box_get_id (a);
#line 367 "../src/greeter-list.vala"
		_tmp6_ = _tmp5_;
#line 367 "../src/greeter-list.vala"
		if (!g_str_has_prefix (_tmp6_, "*")) {
#line 368 "../src/greeter-list.vala"
			result = -1;
#line 368 "../src/greeter-list.vala"
			return result;
#line 1969 "greeter-list.c"
		}
#line 369 "../src/greeter-list.vala"
		_tmp7_ = prompt_box_get_id (b);
#line 369 "../src/greeter-list.vala"
		_tmp8_ = _tmp7_;
#line 369 "../src/greeter-list.vala"
		if (!g_str_has_prefix (_tmp8_, "*")) {
#line 370 "../src/greeter-list.vala"
			result = 1;
#line 370 "../src/greeter-list.vala"
			return result;
#line 1981 "greeter-list.c"
		}
#line 373 "../src/greeter-list.vala"
		_tmp9_ = prompt_box_get_id (a);
#line 373 "../src/greeter-list.vala"
		_tmp10_ = _tmp9_;
#line 373 "../src/greeter-list.vala"
		if (g_strcmp0 (_tmp10_, "*other") == 0) {
#line 374 "../src/greeter-list.vala"
			result = -1;
#line 374 "../src/greeter-list.vala"
			return result;
#line 1993 "greeter-list.c"
		}
#line 375 "../src/greeter-list.vala"
		_tmp11_ = prompt_box_get_id (a);
#line 375 "../src/greeter-list.vala"
		_tmp12_ = _tmp11_;
#line 375 "../src/greeter-list.vala"
		if (g_strcmp0 (_tmp12_, "*guest") == 0) {
#line 376 "../src/greeter-list.vala"
			result = 1;
#line 376 "../src/greeter-list.vala"
			return result;
#line 2005 "greeter-list.c"
		}
	}
#line 380 "../src/greeter-list.vala"
	_tmp13_ = prompt_box_get_label (a);
#line 380 "../src/greeter-list.vala"
	_tmp14_ = _tmp13_;
#line 380 "../src/greeter-list.vala"
	_tmp15_ = prompt_box_get_label (b);
#line 380 "../src/greeter-list.vala"
	_tmp16_ = _tmp15_;
#line 380 "../src/greeter-list.vala"
	result = g_ascii_strcasecmp (_tmp14_, _tmp16_);
#line 380 "../src/greeter-list.vala"
	return result;
#line 2020 "greeter-list.c"
}

gboolean
greeter_list_have_entries (GreeterList* self)
{
	GList* _tmp0_;
	gboolean result;
#line 383 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 385 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 2032 "greeter-list.c"
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
#line 385 "../src/greeter-list.vala"
		e_collection = _tmp0_;
#line 385 "../src/greeter-list.vala"
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
#line 2040 "greeter-list.c"
			PromptBox* _tmp1_;
			PromptBox* e = NULL;
#line 385 "../src/greeter-list.vala"
			_tmp1_ = _g_object_ref0 ((PromptBox*) e_it->data);
#line 385 "../src/greeter-list.vala"
			e = _tmp1_;
#line 2047 "greeter-list.c"
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 387 "../src/greeter-list.vala"
				_tmp2_ = e;
#line 387 "../src/greeter-list.vala"
				_tmp3_ = prompt_box_get_id (_tmp2_);
#line 387 "../src/greeter-list.vala"
				_tmp4_ = _tmp3_;
#line 387 "../src/greeter-list.vala"
				if (g_strcmp0 (_tmp4_, "*other") != 0) {
#line 388 "../src/greeter-list.vala"
					result = TRUE;
#line 388 "../src/greeter-list.vala"
					_g_object_unref0 (e);
#line 388 "../src/greeter-list.vala"
					return result;
#line 2066 "greeter-list.c"
				}
#line 385 "../src/greeter-list.vala"
				_g_object_unref0 (e);
#line 2070 "greeter-list.c"
			}
		}
	}
#line 390 "../src/greeter-list.vala"
	result = FALSE;
#line 390 "../src/greeter-list.vala"
	return result;
#line 2078 "greeter-list.c"
}

static gint
_greeter_list_compare_entry_gcompare_func (gconstpointer a,
                                           gconstpointer b)
{
	gint result;
	result = greeter_list_compare_entry ((PromptBox*) a, (PromptBox*) b);
#line 395 "../src/greeter-list.vala"
	return result;
#line 2089 "greeter-list.c"
}

static void
greeter_list_real_insert_entry (GreeterList* self,
                                PromptBox* entry)
{
	PromptBox* _tmp0_;
#line 393 "../src/greeter-list.vala"
	g_return_if_fail (entry != NULL);
#line 395 "../src/greeter-list.vala"
	_tmp0_ = _g_object_ref0 (entry);
#line 395 "../src/greeter-list.vala"
	self->entries = g_list_insert_sorted (self->entries, _tmp0_, _greeter_list_compare_entry_gcompare_func);
#line 2103 "greeter-list.c"
}

void
greeter_list_insert_entry (GreeterList* self,
                           PromptBox* entry)
{
	GreeterListClass* _klass_;
#line 393 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 393 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 393 "../src/greeter-list.vala"
	if (_klass_->insert_entry) {
#line 393 "../src/greeter-list.vala"
		_klass_->insert_entry (self, entry);
#line 2119 "greeter-list.c"
	}
}

static void
greeter_list_real_add_manual_entry (GreeterList* self)
{
#line 398 "../src/greeter-list.vala"
	g_critical ("Type `%s' does not implement abstract method `greeter_list_add_manual_entry'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 398 "../src/greeter-list.vala"
	return;
#line 2130 "greeter-list.c"
}

void
greeter_list_add_manual_entry (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 398 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 398 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 398 "../src/greeter-list.vala"
	if (_klass_->add_manual_entry) {
#line 398 "../src/greeter-list.vala"
		_klass_->add_manual_entry (self);
#line 2145 "greeter-list.c"
	}
}

static void
_greeter_list_entry_clicked_cb_prompt_box_name_clicked (PromptBox* _sender,
                                                        gpointer self)
{
#line 408 "../src/greeter-list.vala"
	greeter_list_entry_clicked_cb ((GreeterList*) self, _sender);
#line 2155 "greeter-list.c"
}

void
greeter_list_add_entry (GreeterList* self,
                        PromptBox* entry)
{
	PromptBox* _tmp0_;
#line 400 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 400 "../src/greeter-list.vala"
	g_return_if_fail (entry != NULL);
#line 402 "../src/greeter-list.vala"
	g_object_set ((GtkWidget*) entry, "expand", TRUE, NULL);
#line 403 "../src/greeter-list.vala"
	gtk_widget_set_size_request ((GtkWidget*) entry, (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2), -1);
#line 404 "../src/greeter-list.vala"
	greeter_list_add_with_class (self, (GtkWidget*) entry);
#line 406 "../src/greeter-list.vala"
	greeter_list_insert_entry (self, entry);
#line 408 "../src/greeter-list.vala"
	g_signal_connect_object (entry, "name-clicked", (GCallback) _greeter_list_entry_clicked_cb_prompt_box_name_clicked, self, 0);
#line 410 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 410 "../src/greeter-list.vala"
	if (_tmp0_ == NULL) {
#line 411 "../src/greeter-list.vala"
		greeter_list_select_entry (self, entry, 1.0, TRUE);
#line 2183 "greeter-list.c"
	} else {
		PromptBox* _tmp1_;
#line 413 "../src/greeter-list.vala"
		_tmp1_ = self->priv->_selected_entry;
#line 413 "../src/greeter-list.vala"
		greeter_list_select_entry (self, _tmp1_, 1.0, TRUE);
#line 2190 "greeter-list.c"
	}
#line 415 "../src/greeter-list.vala"
	greeter_list_move_names (self);
#line 2194 "greeter-list.c"
}

void
greeter_list_set_active_entry (GreeterList* self,
                               const gchar* name)
{
	PromptBox* e = NULL;
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
#line 418 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 420 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_find_entry (self, name);
#line 420 "../src/greeter-list.vala"
	e = _tmp0_;
#line 421 "../src/greeter-list.vala"
	_tmp1_ = e;
#line 421 "../src/greeter-list.vala"
	if (_tmp1_ != NULL) {
#line 2214 "greeter-list.c"
		gdouble direction = 0.0;
		gboolean _tmp2_ = FALSE;
		PromptBox* _tmp3_;
		PromptBox* _tmp8_;
#line 423 "../src/greeter-list.vala"
		direction = 1.0;
#line 424 "../src/greeter-list.vala"
		_tmp3_ = self->priv->_selected_entry;
#line 424 "../src/greeter-list.vala"
		if (_tmp3_ != NULL) {
#line 2225 "greeter-list.c"
			GList* _tmp4_;
			PromptBox* _tmp5_;
			GList* _tmp6_;
			PromptBox* _tmp7_;
#line 425 "../src/greeter-list.vala"
			_tmp4_ = self->entries;
#line 425 "../src/greeter-list.vala"
			_tmp5_ = self->priv->_selected_entry;
#line 425 "../src/greeter-list.vala"
			_tmp6_ = self->entries;
#line 425 "../src/greeter-list.vala"
			_tmp7_ = e;
#line 425 "../src/greeter-list.vala"
			_tmp2_ = g_list_index (_tmp4_, _tmp5_) > g_list_index (_tmp6_, _tmp7_);
#line 2240 "greeter-list.c"
		} else {
#line 424 "../src/greeter-list.vala"
			_tmp2_ = FALSE;
#line 2244 "greeter-list.c"
		}
#line 424 "../src/greeter-list.vala"
		if (_tmp2_) {
#line 427 "../src/greeter-list.vala"
			direction = -1.0;
#line 2250 "greeter-list.c"
		}
#line 429 "../src/greeter-list.vala"
		_tmp8_ = e;
#line 429 "../src/greeter-list.vala"
		greeter_list_select_entry (self, _tmp8_, direction, TRUE);
#line 2256 "greeter-list.c"
	}
#line 418 "../src/greeter-list.vala"
	_g_object_unref0 (e);
#line 2260 "greeter-list.c"
}

void
greeter_list_set_active_first_entry_with_prefix (GreeterList* self,
                                                 const gchar* prefix)
{
	GList* _tmp0_;
#line 433 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 433 "../src/greeter-list.vala"
	g_return_if_fail (prefix != NULL);
#line 435 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 2274 "greeter-list.c"
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
#line 435 "../src/greeter-list.vala"
		e_collection = _tmp0_;
#line 435 "../src/greeter-list.vala"
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
#line 2282 "greeter-list.c"
			PromptBox* _tmp1_;
			PromptBox* e = NULL;
#line 435 "../src/greeter-list.vala"
			_tmp1_ = _g_object_ref0 ((PromptBox*) e_it->data);
#line 435 "../src/greeter-list.vala"
			e = _tmp1_;
#line 2289 "greeter-list.c"
			{
				PromptBox* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
#line 437 "../src/greeter-list.vala"
				_tmp2_ = e;
#line 437 "../src/greeter-list.vala"
				_tmp3_ = prompt_box_get_id (_tmp2_);
#line 437 "../src/greeter-list.vala"
				_tmp4_ = _tmp3_;
#line 437 "../src/greeter-list.vala"
				if (g_str_has_prefix (_tmp4_, prefix)) {
#line 2302 "greeter-list.c"
					PromptBox* _tmp5_;
#line 439 "../src/greeter-list.vala"
					_tmp5_ = e;
#line 439 "../src/greeter-list.vala"
					greeter_list_select_entry (self, _tmp5_, 1.0, TRUE);
#line 440 "../src/greeter-list.vala"
					_g_object_unref0 (e);
#line 440 "../src/greeter-list.vala"
					break;
#line 2312 "greeter-list.c"
				}
#line 435 "../src/greeter-list.vala"
				_g_object_unref0 (e);
#line 2316 "greeter-list.c"
			}
		}
	}
}

void
greeter_list_remove_entry (GreeterList* self,
                           const gchar* name)
{
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
#line 445 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 447 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_find_entry (self, name);
#line 447 "../src/greeter-list.vala"
	_tmp1_ = _tmp0_;
#line 447 "../src/greeter-list.vala"
	greeter_list_remove_entry_by_entry (self, _tmp1_);
#line 447 "../src/greeter-list.vala"
	_g_object_unref0 (_tmp1_);
#line 2338 "greeter-list.c"
}

void
greeter_list_remove_entries_with_prefix (GreeterList* self,
                                         const gchar* prefix)
{
	gint i = 0;
#line 450 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 450 "../src/greeter-list.vala"
	g_return_if_fail (prefix != NULL);
#line 452 "../src/greeter-list.vala"
	i = 0;
#line 453 "../src/greeter-list.vala"
	while (TRUE) {
#line 2354 "greeter-list.c"
		GList* _tmp0_;
		PromptBox* e = NULL;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		PromptBox* _tmp3_;
		PromptBox* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 453 "../src/greeter-list.vala"
		_tmp0_ = self->entries;
#line 453 "../src/greeter-list.vala"
		if (!(((guint) i) < g_list_length (_tmp0_))) {
#line 453 "../src/greeter-list.vala"
			break;
#line 2369 "greeter-list.c"
		}
#line 455 "../src/greeter-list.vala"
		_tmp1_ = self->entries;
#line 455 "../src/greeter-list.vala"
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) i);
#line 455 "../src/greeter-list.vala"
		_tmp3_ = _g_object_ref0 ((PromptBox*) _tmp2_);
#line 455 "../src/greeter-list.vala"
		e = _tmp3_;
#line 456 "../src/greeter-list.vala"
		_tmp4_ = e;
#line 456 "../src/greeter-list.vala"
		_tmp5_ = prompt_box_get_id (_tmp4_);
#line 456 "../src/greeter-list.vala"
		_tmp6_ = _tmp5_;
#line 456 "../src/greeter-list.vala"
		if (g_str_has_prefix (_tmp6_, prefix)) {
#line 2387 "greeter-list.c"
			PromptBox* _tmp7_;
#line 457 "../src/greeter-list.vala"
			_tmp7_ = e;
#line 457 "../src/greeter-list.vala"
			greeter_list_remove_entry_by_entry (self, _tmp7_);
#line 2393 "greeter-list.c"
		} else {
			gint _tmp8_;
#line 459 "../src/greeter-list.vala"
			_tmp8_ = i;
#line 459 "../src/greeter-list.vala"
			i = _tmp8_ + 1;
#line 2400 "greeter-list.c"
		}
#line 453 "../src/greeter-list.vala"
		_g_object_unref0 (e);
#line 2404 "greeter-list.c"
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
#line 5234 "glib-2.0.vapi"
	l = self;
#line 5235 "glib-2.0.vapi"
	while (TRUE) {
#line 2419 "greeter-list.c"
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
#line 5235 "glib-2.0.vapi"
		_tmp0_ = l;
#line 5235 "glib-2.0.vapi"
		if (!(_tmp0_ != NULL)) {
#line 5235 "glib-2.0.vapi"
			break;
#line 2429 "greeter-list.c"
		}
#line 5236 "glib-2.0.vapi"
		_tmp1_ = l;
#line 5236 "glib-2.0.vapi"
		_tmp2_ = ((GList*) _tmp1_)->data;
#line 5236 "glib-2.0.vapi"
		if (_tmp2_ != data) {
#line 2437 "greeter-list.c"
			GList* _tmp3_;
			GList* _tmp4_;
#line 5237 "glib-2.0.vapi"
			_tmp3_ = l;
#line 5237 "glib-2.0.vapi"
			_tmp4_ = ((GList*) _tmp3_)->next;
#line 5237 "glib-2.0.vapi"
			l = _tmp4_;
#line 2446 "greeter-list.c"
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
#line 5239 "glib-2.0.vapi"
			_tmp5_ = l;
#line 5239 "glib-2.0.vapi"
			_tmp6_ = ((GList*) _tmp5_)->data;
#line 5239 "glib-2.0.vapi"
			func (_tmp6_);
#line 5240 "glib-2.0.vapi"
			_tmp7_ = l;
#line 5240 "glib-2.0.vapi"
			self = g_list_delete_link (self, (GList*) _tmp7_);
#line 5241 "glib-2.0.vapi"
			break;
#line 2463 "greeter-list.c"
		}
	}
#line 5244 "glib-2.0.vapi"
	result = self;
#line 5244 "glib-2.0.vapi"
	return result;
#line 2470 "greeter-list.c"
}

void
greeter_list_remove_entry_by_entry (GreeterList* self,
                                    PromptBox* entry)
{
	gint index = 0;
	GList* _tmp0_;
	PromptBox* _tmp1_;
	gboolean _tmp11_ = FALSE;
#line 463 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 465 "../src/greeter-list.vala"
	if (entry == NULL) {
#line 466 "../src/greeter-list.vala"
		return;
#line 2487 "greeter-list.c"
	}
#line 468 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 468 "../src/greeter-list.vala"
	index = g_list_index (_tmp0_, entry);
#line 469 "../src/greeter-list.vala"
	gtk_widget_destroy ((GtkWidget*) entry);
#line 470 "../src/greeter-list.vala"
	self->entries = vala_g_list_remove_full (self->entries, entry, _g_object_unref0_);
#line 473 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 473 "../src/greeter-list.vala"
	if (entry == _tmp1_) {
#line 2501 "greeter-list.c"
		gboolean _tmp2_ = FALSE;
		GList* _tmp3_;
		GList* _tmp7_;
		gconstpointer _tmp8_;
#line 475 "../src/greeter-list.vala"
		_tmp3_ = self->entries;
#line 475 "../src/greeter-list.vala"
		if (((guint) index) >= g_list_length (_tmp3_)) {
#line 475 "../src/greeter-list.vala"
			_tmp2_ = index > 0;
#line 2512 "greeter-list.c"
		} else {
#line 475 "../src/greeter-list.vala"
			_tmp2_ = FALSE;
#line 2516 "greeter-list.c"
		}
#line 475 "../src/greeter-list.vala"
		if (_tmp2_) {
#line 2520 "greeter-list.c"
			gint _tmp4_;
#line 476 "../src/greeter-list.vala"
			_tmp4_ = index;
#line 476 "../src/greeter-list.vala"
			index = _tmp4_ - 1;
#line 2526 "greeter-list.c"
		} else {
			GList* _tmp5_;
#line 477 "../src/greeter-list.vala"
			_tmp5_ = self->entries;
#line 477 "../src/greeter-list.vala"
			if (((guint) index) < g_list_length (_tmp5_)) {
#line 2533 "greeter-list.c"
				gint _tmp6_;
#line 478 "../src/greeter-list.vala"
				_tmp6_ = index;
#line 478 "../src/greeter-list.vala"
				index = _tmp6_ + 1;
#line 2539 "greeter-list.c"
			}
		}
#line 480 "../src/greeter-list.vala"
		_tmp7_ = self->entries;
#line 480 "../src/greeter-list.vala"
		_tmp8_ = g_list_nth_data (_tmp7_, (guint) index);
#line 480 "../src/greeter-list.vala"
		if (((PromptBox*) _tmp8_) != NULL) {
#line 2548 "greeter-list.c"
			GList* _tmp9_;
			gconstpointer _tmp10_;
#line 481 "../src/greeter-list.vala"
			_tmp9_ = self->entries;
#line 481 "../src/greeter-list.vala"
			_tmp10_ = g_list_nth_data (_tmp9_, (guint) index);
#line 481 "../src/greeter-list.vala"
			greeter_list_select_entry (self, (PromptBox*) _tmp10_, -1.0, TRUE);
#line 2557 "greeter-list.c"
		}
	}
#line 485 "../src/greeter-list.vala"
	if (!greeter_list_have_entries (self)) {
#line 2562 "greeter-list.c"
		SlickGreeter* _tmp12_;
#line 485 "../src/greeter-list.vala"
		_tmp12_ = slick_greeter_singleton;
#line 485 "../src/greeter-list.vala"
		_tmp11_ = !slick_greeter_show_remote_login_hint (_tmp12_);
#line 2568 "greeter-list.c"
	} else {
#line 485 "../src/greeter-list.vala"
		_tmp11_ = FALSE;
#line 2572 "greeter-list.c"
	}
#line 485 "../src/greeter-list.vala"
	if (_tmp11_) {
#line 486 "../src/greeter-list.vala"
		greeter_list_add_manual_entry (self);
#line 2578 "greeter-list.c"
	}
#line 488 "../src/greeter-list.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 2582 "greeter-list.c"
}

gint
greeter_list_get_greeter_box_height (GreeterList* self)
{
	gint height = 0;
	DashBox* _tmp0_;
	gint _tmp1_ = 0;
	gint result;
#line 491 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 494 "../src/greeter-list.vala"
	_tmp0_ = self->greeter_box;
#line 494 "../src/greeter-list.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp0_, NULL, &_tmp1_);
#line 494 "../src/greeter-list.vala"
	height = _tmp1_;
#line 495 "../src/greeter-list.vala"
	result = height;
#line 495 "../src/greeter-list.vala"
	return result;
#line 2604 "greeter-list.c"
}

gint
greeter_list_get_greeter_box_height_grids (GreeterList* self)
{
	gint height = 0;
	gint result;
#line 498 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 500 "../src/greeter-list.vala"
	height = greeter_list_get_greeter_box_height (self);
#line 501 "../src/greeter-list.vala"
	result = (height / grid_size) + 1;
#line 501 "../src/greeter-list.vala"
	return result;
#line 2620 "greeter-list.c"
}

gint
greeter_list_get_greeter_box_x (GreeterList* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint result;
#line 504 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 506 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_get_box_x (self);
#line 506 "../src/greeter-list.vala"
	_tmp1_ = _tmp0_;
#line 506 "../src/greeter-list.vala"
	result = _tmp1_ + GREETER_LIST_BORDER;
#line 506 "../src/greeter-list.vala"
	return result;
#line 2639 "greeter-list.c"
}

gint
greeter_list_get_greeter_box_y (GreeterList* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint result;
#line 509 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 511 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_get_box_y (self);
#line 511 "../src/greeter-list.vala"
	_tmp1_ = _tmp0_;
#line 511 "../src/greeter-list.vala"
	result = _tmp1_ + GREETER_LIST_BORDER;
#line 511 "../src/greeter-list.vala"
	return result;
#line 2658 "greeter-list.c"
}

static gint
greeter_list_real_get_position_y (GreeterList* self,
                                  gdouble position)
{
	gint box_height = 0;
	gdouble offset = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gint result;
#line 518 "../src/greeter-list.vala"
	box_height = greeter_list_get_greeter_box_height_grids (self) * grid_size;
#line 521 "../src/greeter-list.vala"
	if (position < ((gdouble) 0)) {
#line 522 "../src/greeter-list.vala"
		offset = position * grid_size;
#line 2676 "greeter-list.c"
	} else {
#line 523 "../src/greeter-list.vala"
		if (position < ((gdouble) 1)) {
#line 524 "../src/greeter-list.vala"
			offset = position * box_height;
#line 2682 "greeter-list.c"
		} else {
#line 526 "../src/greeter-list.vala"
			offset = ((position - 1) * grid_size) + box_height;
#line 2686 "greeter-list.c"
		}
	}
#line 528 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_get_box_y (self);
#line 528 "../src/greeter-list.vala"
	_tmp1_ = _tmp0_;
#line 528 "../src/greeter-list.vala"
	result = _tmp1_ + ((gint) round (offset));
#line 528 "../src/greeter-list.vala"
	return result;
#line 2697 "greeter-list.c"
}

gint
greeter_list_get_position_y (GreeterList* self,
                             gdouble position)
{
	GreeterListClass* _klass_;
#line 514 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 514 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 514 "../src/greeter-list.vala"
	if (_klass_->get_position_y) {
#line 514 "../src/greeter-list.vala"
		return _klass_->get_position_y (self, position);
#line 2713 "greeter-list.c"
	}
#line 514 "../src/greeter-list.vala"
	return -1;
#line 2717 "greeter-list.c"
}

static void
greeter_list_move_entry (GreeterList* self,
                         PromptBox* entry,
                         gdouble position)
{
	gdouble alpha = 0.0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation child_allocation = {0};
	GtkAllocation _tmp1_;
	gint _tmp2_ = 0;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	GtkFixed* _tmp5_;
	GtkAllocation _tmp6_;
	GtkAllocation _tmp7_;
	GtkAllocation _tmp8_;
#line 531 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 531 "../src/greeter-list.vala"
	g_return_if_fail (entry != NULL);
#line 533 "../src/greeter-list.vala"
	alpha = 1.0;
#line 534 "../src/greeter-list.vala"
	if (position < ((gdouble) 0)) {
#line 535 "../src/greeter-list.vala"
		alpha = 1.0 + (position / (self->priv->n_above + 1));
#line 2747 "greeter-list.c"
	} else {
#line 537 "../src/greeter-list.vala"
		alpha = 1.0 - (position / (self->priv->n_below + 1));
#line 2751 "greeter-list.c"
	}
#line 538 "../src/greeter-list.vala"
	fadable_set_alpha ((Fadable*) entry, alpha);
#line 541 "../src/greeter-list.vala"
	prompt_box_set_position (entry, position);
#line 544 "../src/greeter-list.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
#line 544 "../src/greeter-list.vala"
	allocation = _tmp0_;
#line 546 "../src/greeter-list.vala"
	memset (&child_allocation, 0, sizeof (GtkAllocation));
#line 547 "../src/greeter-list.vala"
	child_allocation.width = (grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2);
#line 548 "../src/greeter-list.vala"
	_tmp1_ = child_allocation;
#line 548 "../src/greeter-list.vala"
	gtk_widget_get_preferred_height_for_width ((GtkWidget*) entry, _tmp1_.width, NULL, &_tmp2_);
#line 548 "../src/greeter-list.vala"
	child_allocation.height = _tmp2_;
#line 549 "../src/greeter-list.vala"
	_tmp3_ = allocation;
#line 549 "../src/greeter-list.vala"
	child_allocation.x = _tmp3_.x + greeter_list_get_greeter_box_x (self);
#line 550 "../src/greeter-list.vala"
	_tmp4_ = allocation;
#line 550 "../src/greeter-list.vala"
	child_allocation.y = _tmp4_.y + greeter_list_get_position_y (self, position);
#line 551 "../src/greeter-list.vala"
	_tmp5_ = self->priv->fixed;
#line 551 "../src/greeter-list.vala"
	_tmp6_ = child_allocation;
#line 551 "../src/greeter-list.vala"
	_tmp7_ = child_allocation;
#line 551 "../src/greeter-list.vala"
	gtk_fixed_move (_tmp5_, (GtkWidget*) entry, _tmp6_.x, _tmp7_.y);
#line 552 "../src/greeter-list.vala"
	_tmp8_ = child_allocation;
#line 552 "../src/greeter-list.vala"
	gtk_widget_size_allocate ((GtkWidget*) entry, &_tmp8_);
#line 2791 "greeter-list.c"
}

static gboolean
___lambda39_ (GreeterList* self)
{
	gboolean result;
#line 563 "../src/greeter-list.vala"
	greeter_list_move_names (self);
#line 563 "../src/greeter-list.vala"
	result = FALSE;
#line 563 "../src/greeter-list.vala"
	return result;
#line 2804 "greeter-list.c"
}

static gboolean
____lambda39__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda39_ ((GreeterList*) self);
#line 563 "../src/greeter-list.vala"
	return result;
#line 2814 "greeter-list.c"
}

void
greeter_list_greeter_box_size_allocate_cb (GreeterList* self,
                                           GtkAllocation* allocation)
{
	gboolean _tmp0_ = FALSE;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
	GtkAllocation _tmp4_;
#line 555 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 555 "../src/greeter-list.vala"
	g_return_if_fail (allocation != NULL);
#line 558 "../src/greeter-list.vala"
	_tmp1_ = greeter_list_get_scrolling_entry (self);
#line 558 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 558 "../src/greeter-list.vala"
	if (_tmp2_ == NULL) {
#line 2835 "greeter-list.c"
		GtkAllocation _tmp3_;
#line 558 "../src/greeter-list.vala"
		_tmp3_ = *allocation;
#line 558 "../src/greeter-list.vala"
		_tmp0_ = _tmp3_.height != self->priv->cached_box_height;
#line 2841 "greeter-list.c"
	} else {
#line 558 "../src/greeter-list.vala"
		_tmp0_ = FALSE;
#line 2845 "greeter-list.c"
	}
#line 558 "../src/greeter-list.vala"
	if (_tmp0_) {
#line 563 "../src/greeter-list.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda39__gsource_func, g_object_ref (self), g_object_unref);
#line 2851 "greeter-list.c"
	}
#line 565 "../src/greeter-list.vala"
	_tmp4_ = *allocation;
#line 565 "../src/greeter-list.vala"
	self->priv->cached_box_height = _tmp4_.height;
#line 2857 "greeter-list.c"
}

void
greeter_list_move_names (GreeterList* self)
{
	gint index = 0;
	GList* _tmp0_;
#line 568 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 570 "../src/greeter-list.vala"
	index = 0;
#line 571 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 2871 "greeter-list.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 571 "../src/greeter-list.vala"
		entry_collection = _tmp0_;
#line 571 "../src/greeter-list.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 2879 "greeter-list.c"
			PromptBox* _tmp1_;
			PromptBox* entry = NULL;
#line 571 "../src/greeter-list.vala"
			_tmp1_ = _g_object_ref0 ((PromptBox*) entry_it->data);
#line 571 "../src/greeter-list.vala"
			entry = _tmp1_;
#line 2886 "greeter-list.c"
			{
				gdouble position = 0.0;
				gboolean _tmp2_ = FALSE;
				gint _tmp14_;
#line 573 "../src/greeter-list.vala"
				position = index - self->priv->scroll_location;
#line 576 "../src/greeter-list.vala"
				if (position > ((gdouble) (-1 * ((gint) (self->priv->n_above + 1))))) {
#line 576 "../src/greeter-list.vala"
					_tmp2_ = position < ((gdouble) (self->priv->n_below + 1));
#line 2897 "greeter-list.c"
				} else {
#line 576 "../src/greeter-list.vala"
					_tmp2_ = FALSE;
#line 2901 "greeter-list.c"
				}
#line 576 "../src/greeter-list.vala"
				if (_tmp2_) {
#line 2905 "greeter-list.c"
					PromptBox* _tmp3_;
					gboolean _tmp4_ = FALSE;
					gboolean _tmp5_ = FALSE;
					gboolean is_hidden = FALSE;
#line 578 "../src/greeter-list.vala"
					_tmp3_ = entry;
#line 578 "../src/greeter-list.vala"
					greeter_list_move_entry (self, _tmp3_, position);
#line 581 "../src/greeter-list.vala"
					if (position == ((gdouble) 0)) {
#line 2916 "greeter-list.c"
						DashBox* _tmp6_;
						gboolean _tmp7_;
						gboolean _tmp8_;
#line 581 "../src/greeter-list.vala"
						_tmp6_ = self->greeter_box;
#line 581 "../src/greeter-list.vala"
						_tmp7_ = dash_box_get_has_base (_tmp6_);
#line 581 "../src/greeter-list.vala"
						_tmp8_ = _tmp7_;
#line 581 "../src/greeter-list.vala"
						_tmp5_ = _tmp8_;
#line 2928 "greeter-list.c"
					} else {
#line 581 "../src/greeter-list.vala"
						_tmp5_ = FALSE;
#line 2932 "greeter-list.c"
					}
#line 581 "../src/greeter-list.vala"
					if (_tmp5_) {
#line 2936 "greeter-list.c"
						DashBox* _tmp9_;
						gdouble _tmp10_;
						gdouble _tmp11_;
#line 582 "../src/greeter-list.vala"
						_tmp9_ = self->greeter_box;
#line 582 "../src/greeter-list.vala"
						_tmp10_ = dash_box_get_base_alpha (_tmp9_);
#line 582 "../src/greeter-list.vala"
						_tmp11_ = _tmp10_;
#line 582 "../src/greeter-list.vala"
						_tmp4_ = _tmp11_ == 0.0;
#line 2948 "greeter-list.c"
					} else {
#line 581 "../src/greeter-list.vala"
						_tmp4_ = FALSE;
#line 2952 "greeter-list.c"
					}
#line 581 "../src/greeter-list.vala"
					is_hidden = _tmp4_;
#line 583 "../src/greeter-list.vala"
					if (!is_hidden) {
#line 2958 "greeter-list.c"
						PromptBox* _tmp12_;
#line 584 "../src/greeter-list.vala"
						_tmp12_ = entry;
#line 584 "../src/greeter-list.vala"
						gtk_widget_show ((GtkWidget*) _tmp12_);
#line 2964 "greeter-list.c"
					}
				} else {
					PromptBox* _tmp13_;
#line 587 "../src/greeter-list.vala"
					_tmp13_ = entry;
#line 587 "../src/greeter-list.vala"
					gtk_widget_hide ((GtkWidget*) _tmp13_);
#line 2972 "greeter-list.c"
				}
#line 589 "../src/greeter-list.vala"
				_tmp14_ = index;
#line 589 "../src/greeter-list.vala"
				index = _tmp14_ + 1;
#line 571 "../src/greeter-list.vala"
				_g_object_unref0 (entry);
#line 2980 "greeter-list.c"
			}
		}
	}
#line 591 "../src/greeter-list.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 2986 "greeter-list.c"
}

static void
greeter_list_animate_scrolling (GreeterList* self,
                                gdouble progress)
{
	guint h = 0U;
	GList* _tmp0_;
	gdouble distance = 0.0;
	gboolean _tmp1_ = FALSE;
#line 594 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 597 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 597 "../src/greeter-list.vala"
	h = g_list_length (_tmp0_);
#line 600 "../src/greeter-list.vala"
	distance = self->priv->scroll_target_location - self->priv->scroll_start_location;
#line 601 "../src/greeter-list.vala"
	if ((self->priv->scroll_direction * distance) < ((gdouble) 0)) {
#line 602 "../src/greeter-list.vala"
		distance += self->priv->scroll_direction * h;
#line 3009 "greeter-list.c"
	}
#line 605 "../src/greeter-list.vala"
	distance *= progress;
#line 608 "../src/greeter-list.vala"
	self->priv->scroll_location = self->priv->scroll_start_location + distance;
#line 609 "../src/greeter-list.vala"
	if (self->priv->scroll_location > ((gdouble) h)) {
#line 610 "../src/greeter-list.vala"
		self->priv->scroll_location = self->priv->scroll_location - h;
#line 3019 "greeter-list.c"
	}
#line 611 "../src/greeter-list.vala"
	if (self->priv->scroll_location < ((gdouble) 0)) {
#line 612 "../src/greeter-list.vala"
		self->priv->scroll_location = self->priv->scroll_location + h;
#line 3025 "greeter-list.c"
	}
#line 614 "../src/greeter-list.vala"
	greeter_list_move_names (self);
#line 616 "../src/greeter-list.vala"
	if (progress >= 0.975) {
#line 3031 "greeter-list.c"
		DashBox* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
#line 616 "../src/greeter-list.vala"
		_tmp2_ = self->greeter_box;
#line 616 "../src/greeter-list.vala"
		_tmp3_ = dash_box_get_has_base (_tmp2_);
#line 616 "../src/greeter-list.vala"
		_tmp4_ = _tmp3_;
#line 616 "../src/greeter-list.vala"
		_tmp1_ = !_tmp4_;
#line 3043 "greeter-list.c"
	} else {
#line 616 "../src/greeter-list.vala"
		_tmp1_ = FALSE;
#line 3047 "greeter-list.c"
	}
#line 616 "../src/greeter-list.vala"
	if (_tmp1_) {
#line 618 "../src/greeter-list.vala"
		greeter_list_setup_prompt_box (self, TRUE);
#line 619 "../src/greeter-list.vala"
		g_signal_emit (self, greeter_list_signals[GREETER_LIST_ENTRY_DISPLAYED_START_SIGNAL], 0);
#line 3055 "greeter-list.c"
	}
#line 623 "../src/greeter-list.vala"
	if (progress >= 1.0) {
#line 624 "../src/greeter-list.vala"
		greeter_list_finished_scrolling (self);
#line 3061 "greeter-list.c"
	}
}

static void
greeter_list_finished_scrolling (GreeterList* self)
{
	PromptBox* _tmp0_;
#line 627 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 629 "../src/greeter-list.vala"
	greeter_list_set_scrolling_entry (self, NULL);
#line 630 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 630 "../src/greeter-list.vala"
	prompt_box_show_prompts (_tmp0_);
#line 631 "../src/greeter-list.vala"
	greeter_list_focus_prompt (self);
#line 632 "../src/greeter-list.vala"
	g_signal_emit (self, greeter_list_signals[GREETER_LIST_ENTRY_DISPLAYED_DONE_SIGNAL], 0);
#line 633 "../src/greeter-list.vala"
	self->mode = GREETER_LIST_MODE_ENTRY;
#line 636 "../src/greeter-list.vala"
	gtk_widget_queue_allocate ((GtkWidget*) self);
#line 3085 "greeter-list.c"
}

void
greeter_list_select_entry (GreeterList* self,
                           PromptBox* entry,
                           gdouble direction,
                           gboolean do_scroll)
{
	GList* _tmp0_;
	PromptBox* _tmp5_;
#line 640 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 640 "../src/greeter-list.vala"
	g_return_if_fail (entry != NULL);
#line 642 "../src/greeter-list.vala"
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
#line 645 "../src/greeter-list.vala"
		greeter_list_set_selected_entry (self, entry);
#line 646 "../src/greeter-list.vala"
		return;
#line 3106 "greeter-list.c"
	}
#line 649 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 649 "../src/greeter-list.vala"
	if (self->priv->scroll_target_location != ((gdouble) g_list_index (_tmp0_, entry))) {
#line 3112 "greeter-list.c"
		gint new_target = 0;
		GList* _tmp1_;
		gdouble new_direction = 0.0;
		gdouble new_start = 0.0;
		gboolean _tmp2_ = FALSE;
		PromptBox* _tmp4_;
#line 651 "../src/greeter-list.vala"
		_tmp1_ = self->entries;
#line 651 "../src/greeter-list.vala"
		new_target = g_list_index (_tmp1_, entry);
#line 652 "../src/greeter-list.vala"
		new_direction = direction;
#line 653 "../src/greeter-list.vala"
		new_start = self->priv->scroll_location;
#line 655 "../src/greeter-list.vala"
		if (self->priv->scroll_location != ((gdouble) new_target)) {
#line 655 "../src/greeter-list.vala"
			_tmp2_ = do_scroll;
#line 3131 "greeter-list.c"
		} else {
#line 655 "../src/greeter-list.vala"
			_tmp2_ = FALSE;
#line 3135 "greeter-list.c"
		}
#line 655 "../src/greeter-list.vala"
		if (_tmp2_) {
#line 3139 "greeter-list.c"
			gdouble new_distance = 0.0;
			AnimateTimer* _tmp3_;
#line 657 "../src/greeter-list.vala"
			new_distance = new_direction * (new_target - new_start);
#line 659 "../src/greeter-list.vala"
			_tmp3_ = self->priv->scroll_timer;
#line 659 "../src/greeter-list.vala"
			animate_timer_reset (_tmp3_, 250 + MIN ((gint) (100 * fabs (new_distance)), 500));
#line 661 "../src/greeter-list.vala"
			self->mode = GREETER_LIST_MODE_SCROLLING;
#line 3150 "greeter-list.c"
		}
#line 664 "../src/greeter-list.vala"
		_tmp4_ = self->priv->_selected_entry;
#line 664 "../src/greeter-list.vala"
		greeter_list_set_scrolling_entry (self, _tmp4_);
#line 665 "../src/greeter-list.vala"
		self->priv->scroll_target_location = (gdouble) new_target;
#line 666 "../src/greeter-list.vala"
		self->priv->scroll_direction = new_direction;
#line 667 "../src/greeter-list.vala"
		self->priv->scroll_start_location = new_start;
#line 3162 "greeter-list.c"
	}
#line 670 "../src/greeter-list.vala"
	_tmp5_ = self->priv->_selected_entry;
#line 670 "../src/greeter-list.vala"
	if (_tmp5_ != entry) {
#line 3168 "greeter-list.c"
		DashBox* _tmp6_;
		PromptBox* _tmp7_;
		PromptBox* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
#line 672 "../src/greeter-list.vala"
		_tmp6_ = self->greeter_box;
#line 672 "../src/greeter-list.vala"
		dash_box_set_base (_tmp6_, NULL);
#line 673 "../src/greeter-list.vala"
		_tmp7_ = self->priv->_selected_entry;
#line 673 "../src/greeter-list.vala"
		if (_tmp7_ != NULL) {
#line 3182 "greeter-list.c"
			PromptBox* _tmp8_;
#line 674 "../src/greeter-list.vala"
			_tmp8_ = self->priv->_selected_entry;
#line 674 "../src/greeter-list.vala"
			prompt_box_clear (_tmp8_);
#line 3188 "greeter-list.c"
		}
#line 676 "../src/greeter-list.vala"
		greeter_list_set_selected_entry (self, entry);
#line 677 "../src/greeter-list.vala"
		_tmp9_ = self->priv->_selected_entry;
#line 677 "../src/greeter-list.vala"
		_tmp10_ = prompt_box_get_id (_tmp9_);
#line 677 "../src/greeter-list.vala"
		_tmp11_ = _tmp10_;
#line 677 "../src/greeter-list.vala"
		g_signal_emit (self, greeter_list_signals[GREETER_LIST_ENTRY_SELECTED_SIGNAL], 0, _tmp11_);
#line 679 "../src/greeter-list.vala"
		if (self->mode == GREETER_LIST_MODE_ENTRY) {
#line 3202 "greeter-list.c"
			AnimateTimer* _tmp12_;
#line 682 "../src/greeter-list.vala"
			greeter_list_setup_prompt_box (self, TRUE);
#line 683 "../src/greeter-list.vala"
			_tmp12_ = self->priv->scroll_timer;
#line 683 "../src/greeter-list.vala"
			animate_timer_reset (_tmp12_, 0);
#line 3210 "greeter-list.c"
		}
	}
}

static void
greeter_list_real_setup_prompt_box (GreeterList* self,
                                    gboolean fade)
{
	DashBox* _tmp0_;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
#line 690 "../src/greeter-list.vala"
	_tmp0_ = self->greeter_box;
#line 690 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 690 "../src/greeter-list.vala"
	dash_box_set_base (_tmp0_, (GtkWidget*) _tmp1_);
#line 691 "../src/greeter-list.vala"
	_tmp2_ = self->priv->_selected_entry;
#line 691 "../src/greeter-list.vala"
	prompt_box_add_static_prompts (_tmp2_);
#line 692 "../src/greeter-list.vala"
	if (fade) {
#line 3234 "greeter-list.c"
		PromptBox* _tmp3_;
#line 693 "../src/greeter-list.vala"
		_tmp3_ = self->priv->_selected_entry;
#line 693 "../src/greeter-list.vala"
		prompt_box_fade_in_prompts (_tmp3_);
#line 3240 "greeter-list.c"
	} else {
		PromptBox* _tmp4_;
#line 695 "../src/greeter-list.vala"
		_tmp4_ = self->priv->_selected_entry;
#line 695 "../src/greeter-list.vala"
		prompt_box_show_prompts (_tmp4_);
#line 3247 "greeter-list.c"
	}
}

void
greeter_list_setup_prompt_box (GreeterList* self,
                               gboolean fade)
{
	GreeterListClass* _klass_;
#line 688 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 688 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 688 "../src/greeter-list.vala"
	if (_klass_->setup_prompt_box) {
#line 688 "../src/greeter-list.vala"
		_klass_->setup_prompt_box (self, fade);
#line 3264 "greeter-list.c"
	}
}

static void
greeter_list_real_realize (GtkWidget* base)
{
	GreeterList * self;
	PromptBox* saved_entry = NULL;
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
	gboolean _tmp2_;
#line 698 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 700 "../src/greeter-list.vala"
	GTK_WIDGET_CLASS (greeter_list_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox));
#line 703 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 703 "../src/greeter-list.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 703 "../src/greeter-list.vala"
	saved_entry = _tmp1_;
#line 704 "../src/greeter-list.vala"
	greeter_list_set_selected_entry (self, NULL);
#line 705 "../src/greeter-list.vala"
	_tmp2_ = self->priv->_start_scrolling;
#line 705 "../src/greeter-list.vala"
	greeter_list_select_entry (self, saved_entry, (gdouble) 1, _tmp2_);
#line 706 "../src/greeter-list.vala"
	greeter_list_move_names (self);
#line 698 "../src/greeter-list.vala"
	_g_object_unref0 (saved_entry);
#line 3296 "greeter-list.c"
}

static void
greeter_list_allocate_greeter_box (GreeterList* self)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	GtkAllocation child_allocation = {0};
	DashBox* _tmp1_;
	gint _tmp2_ = 0;
	DashBox* _tmp3_;
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_;
	GtkAllocation _tmp6_;
	GtkFixed* _tmp7_;
	DashBox* _tmp8_;
	GtkAllocation _tmp9_;
	GtkAllocation _tmp10_;
	DashBox* _tmp11_;
	GtkAllocation _tmp12_;
	GList* _tmp13_;
#line 709 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 712 "../src/greeter-list.vala"
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
#line 712 "../src/greeter-list.vala"
	allocation = _tmp0_;
#line 714 "../src/greeter-list.vala"
	memset (&child_allocation, 0, sizeof (GtkAllocation));
#line 715 "../src/greeter-list.vala"
	_tmp1_ = self->greeter_box;
#line 715 "../src/greeter-list.vala"
	gtk_widget_get_preferred_width ((GtkWidget*) _tmp1_, NULL, &_tmp2_);
#line 715 "../src/greeter-list.vala"
	child_allocation.width = _tmp2_;
#line 716 "../src/greeter-list.vala"
	_tmp3_ = self->greeter_box;
#line 716 "../src/greeter-list.vala"
	gtk_widget_get_preferred_height ((GtkWidget*) _tmp3_, NULL, &_tmp4_);
#line 716 "../src/greeter-list.vala"
	child_allocation.height = _tmp4_;
#line 717 "../src/greeter-list.vala"
	_tmp5_ = allocation;
#line 717 "../src/greeter-list.vala"
	child_allocation.x = _tmp5_.x + greeter_list_get_greeter_box_x (self);
#line 718 "../src/greeter-list.vala"
	_tmp6_ = allocation;
#line 718 "../src/greeter-list.vala"
	child_allocation.y = _tmp6_.y + greeter_list_get_greeter_box_y (self);
#line 719 "../src/greeter-list.vala"
	_tmp7_ = self->priv->fixed;
#line 719 "../src/greeter-list.vala"
	_tmp8_ = self->greeter_box;
#line 719 "../src/greeter-list.vala"
	_tmp9_ = child_allocation;
#line 719 "../src/greeter-list.vala"
	_tmp10_ = child_allocation;
#line 719 "../src/greeter-list.vala"
	gtk_fixed_move (_tmp7_, (GtkWidget*) _tmp8_, _tmp9_.x, _tmp10_.y);
#line 720 "../src/greeter-list.vala"
	_tmp11_ = self->greeter_box;
#line 720 "../src/greeter-list.vala"
	_tmp12_ = child_allocation;
#line 720 "../src/greeter-list.vala"
	gtk_widget_size_allocate ((GtkWidget*) _tmp11_, &_tmp12_);
#line 722 "../src/greeter-list.vala"
	_tmp13_ = self->entries;
#line 3364 "greeter-list.c"
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
#line 722 "../src/greeter-list.vala"
		entry_collection = _tmp13_;
#line 722 "../src/greeter-list.vala"
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
#line 3372 "greeter-list.c"
			PromptBox* _tmp14_;
			PromptBox* entry = NULL;
#line 722 "../src/greeter-list.vala"
			_tmp14_ = _g_object_ref0 ((PromptBox*) entry_it->data);
#line 722 "../src/greeter-list.vala"
			entry = _tmp14_;
#line 3379 "greeter-list.c"
			{
				PromptBox* _tmp15_;
				DashBox* _tmp16_;
#line 724 "../src/greeter-list.vala"
				_tmp15_ = entry;
#line 724 "../src/greeter-list.vala"
				_tmp16_ = self->greeter_box;
#line 724 "../src/greeter-list.vala"
				prompt_box_set_zone (_tmp15_, (GtkWidget*) _tmp16_);
#line 722 "../src/greeter-list.vala"
				_g_object_unref0 (entry);
#line 3391 "greeter-list.c"
			}
		}
	}
}

static void
greeter_list_real_size_allocate (GtkWidget* base,
                                 GtkAllocation* allocation)
{
	GreeterList * self;
	GtkAllocation _tmp0_;
#line 728 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 728 "../src/greeter-list.vala"
	g_return_if_fail (allocation != NULL);
#line 730 "../src/greeter-list.vala"
	_tmp0_ = *allocation;
#line 730 "../src/greeter-list.vala"
	GTK_WIDGET_CLASS (greeter_list_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FADABLE_BOX, FadableBox), &_tmp0_);
#line 732 "../src/greeter-list.vala"
	if (!gtk_widget_get_realized ((GtkWidget*) self)) {
#line 733 "../src/greeter-list.vala"
		return;
#line 3415 "greeter-list.c"
	}
#line 735 "../src/greeter-list.vala"
	greeter_list_allocate_greeter_box (self);
#line 736 "../src/greeter-list.vala"
	greeter_list_move_names (self);
#line 3421 "greeter-list.c"
}

static gboolean
greeter_list_real_draw (GtkWidget* base,
                        cairo_t* c)
{
	GreeterList * self;
	GtkFixed* _tmp0_;
	DashBox* _tmp1_;
	DashBox* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	FadeTracker* _tmp14_;
	FadeTracker* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gboolean result;
#line 739 "../src/greeter-list.vala"
	self = (GreeterList*) base;
#line 739 "../src/greeter-list.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 741 "../src/greeter-list.vala"
	cairo_push_group (c);
#line 743 "../src/greeter-list.vala"
	cairo_save (c);
#line 744 "../src/greeter-list.vala"
	_tmp0_ = self->priv->fixed;
#line 744 "../src/greeter-list.vala"
	_tmp1_ = self->greeter_box;
#line 744 "../src/greeter-list.vala"
	gtk_container_propagate_draw ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp1_, c);
#line 745 "../src/greeter-list.vala"
	cairo_restore (c);
#line 747 "../src/greeter-list.vala"
	_tmp2_ = self->greeter_box;
#line 747 "../src/greeter-list.vala"
	_tmp3_ = dash_box_get_base_alpha (_tmp2_);
#line 747 "../src/greeter-list.vala"
	_tmp4_ = _tmp3_;
#line 747 "../src/greeter-list.vala"
	if (_tmp4_ != 0.0) {
#line 3463 "greeter-list.c"
		GtkFixed* _tmp5_;
		GList* _tmp6_;
		DashBox* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
#line 749 "../src/greeter-list.vala"
		cairo_save (c);
#line 750 "../src/greeter-list.vala"
		cairo_push_group (c);
#line 752 "../src/greeter-list.vala"
		cairo_rectangle (c, (gdouble) greeter_list_get_greeter_box_x (self), (gdouble) (greeter_list_get_greeter_box_y (self) - (self->priv->n_above * grid_size)), (gdouble) ((grid_size * GREETER_LIST_BOX_WIDTH) - (GREETER_LIST_BORDER * 2)), (gdouble) (grid_size * ((self->priv->n_above + self->priv->n_below) + greeter_list_get_greeter_box_height_grids (self))));
#line 753 "../src/greeter-list.vala"
		cairo_clip (c);
#line 755 "../src/greeter-list.vala"
		_tmp5_ = self->priv->fixed;
#line 755 "../src/greeter-list.vala"
		_tmp6_ = gtk_container_get_children ((GtkContainer*) _tmp5_);
#line 3481 "greeter-list.c"
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
#line 755 "../src/greeter-list.vala"
			child_collection = _tmp6_;
#line 755 "../src/greeter-list.vala"
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
#line 3489 "greeter-list.c"
				GtkWidget* child = NULL;
#line 755 "../src/greeter-list.vala"
				child = (GtkWidget*) child_it->data;
#line 3493 "greeter-list.c"
				{
					GtkWidget* _tmp7_;
					DashBox* _tmp8_;
#line 757 "../src/greeter-list.vala"
					_tmp7_ = child;
#line 757 "../src/greeter-list.vala"
					_tmp8_ = self->greeter_box;
#line 757 "../src/greeter-list.vala"
					if (_tmp7_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget)) {
#line 3503 "greeter-list.c"
						GtkFixed* _tmp9_;
						GtkWidget* _tmp10_;
#line 758 "../src/greeter-list.vala"
						_tmp9_ = self->priv->fixed;
#line 758 "../src/greeter-list.vala"
						_tmp10_ = child;
#line 758 "../src/greeter-list.vala"
						gtk_container_propagate_draw ((GtkContainer*) _tmp9_, _tmp10_, c);
#line 3512 "greeter-list.c"
					}
				}
			}
#line 755 "../src/greeter-list.vala"
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
#line 3518 "greeter-list.c"
		}
#line 761 "../src/greeter-list.vala"
		cairo_pop_group_to_source (c);
#line 762 "../src/greeter-list.vala"
		_tmp11_ = self->greeter_box;
#line 762 "../src/greeter-list.vala"
		_tmp12_ = dash_box_get_base_alpha (_tmp11_);
#line 762 "../src/greeter-list.vala"
		_tmp13_ = _tmp12_;
#line 762 "../src/greeter-list.vala"
		cairo_paint_with_alpha (c, _tmp13_);
#line 763 "../src/greeter-list.vala"
		cairo_restore (c);
#line 3532 "greeter-list.c"
	}
#line 766 "../src/greeter-list.vala"
	cairo_pop_group_to_source (c);
#line 767 "../src/greeter-list.vala"
	_tmp14_ = fadable_get_fade_tracker ((Fadable*) self);
#line 767 "../src/greeter-list.vala"
	_tmp15_ = _tmp14_;
#line 767 "../src/greeter-list.vala"
	_tmp16_ = fade_tracker_get_alpha (_tmp15_);
#line 767 "../src/greeter-list.vala"
	_tmp17_ = _tmp16_;
#line 767 "../src/greeter-list.vala"
	cairo_paint_with_alpha (c, _tmp17_);
#line 769 "../src/greeter-list.vala"
	result = FALSE;
#line 769 "../src/greeter-list.vala"
	return result;
#line 3550 "greeter-list.c"
}

static void
greeter_list_entry_clicked_cb (GreeterList* self,
                               PromptBox* entry)
{
	gint index = 0;
	GList* _tmp0_;
	gdouble position = 0.0;
#line 772 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 772 "../src/greeter-list.vala"
	g_return_if_fail (entry != NULL);
#line 774 "../src/greeter-list.vala"
	if (self->mode != GREETER_LIST_MODE_ENTRY) {
#line 775 "../src/greeter-list.vala"
		return;
#line 3568 "greeter-list.c"
	}
#line 777 "../src/greeter-list.vala"
	_tmp0_ = self->entries;
#line 777 "../src/greeter-list.vala"
	index = g_list_index (_tmp0_, entry);
#line 778 "../src/greeter-list.vala"
	position = index - self->priv->scroll_location;
#line 780 "../src/greeter-list.vala"
	if (position < 0.0) {
#line 781 "../src/greeter-list.vala"
		greeter_list_select_entry (self, entry, -1.0, TRUE);
#line 3580 "greeter-list.c"
	} else {
#line 782 "../src/greeter-list.vala"
		if (position >= 1.0) {
#line 783 "../src/greeter-list.vala"
			greeter_list_select_entry (self, entry, 1.0, TRUE);
#line 3586 "greeter-list.c"
		}
	}
}

static void
_greeter_list_show_message_cb_slick_greeter_show_message (SlickGreeter* _sender,
                                                          const gchar* text,
                                                          LightDMMessageType type,
                                                          gpointer self)
{
#line 795 "../src/greeter-list.vala"
	greeter_list_show_message_cb ((GreeterList*) self, text, type);
#line 3599 "greeter-list.c"
}

static void
_greeter_list_show_prompt_cb_slick_greeter_show_prompt (SlickGreeter* _sender,
                                                        const gchar* text,
                                                        LightDMPromptType type,
                                                        gpointer self)
{
#line 796 "../src/greeter-list.vala"
	greeter_list_show_prompt_cb ((GreeterList*) self, text, type);
#line 3610 "greeter-list.c"
}

static void
_greeter_list_authentication_complete_cb_slick_greeter_authentication_complete (SlickGreeter* _sender,
                                                                                gpointer self)
{
#line 797 "../src/greeter-list.vala"
	greeter_list_authentication_complete_cb ((GreeterList*) self);
#line 3619 "greeter-list.c"
}

void
greeter_list_connect_to_lightdm (GreeterList* self)
{
	SlickGreeter* _tmp0_;
	SlickGreeter* _tmp1_;
	SlickGreeter* _tmp2_;
#line 793 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 795 "../src/greeter-list.vala"
	_tmp0_ = slick_greeter_singleton;
#line 795 "../src/greeter-list.vala"
	g_signal_connect_object (_tmp0_, "show-message", (GCallback) _greeter_list_show_message_cb_slick_greeter_show_message, self, 0);
#line 796 "../src/greeter-list.vala"
	_tmp1_ = slick_greeter_singleton;
#line 796 "../src/greeter-list.vala"
	g_signal_connect_object (_tmp1_, "show-prompt", (GCallback) _greeter_list_show_prompt_cb_slick_greeter_show_prompt, self, 0);
#line 797 "../src/greeter-list.vala"
	_tmp2_ = slick_greeter_singleton;
#line 797 "../src/greeter-list.vala"
	g_signal_connect_object (_tmp2_, "authentication-complete", (GCallback) _greeter_list_authentication_complete_cb_slick_greeter_authentication_complete, self, 0);
#line 3642 "greeter-list.c"
}

void
greeter_list_show_message_cb (GreeterList* self,
                              const gchar* text,
                              LightDMMessageType type)
{
#line 800 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 800 "../src/greeter-list.vala"
	g_return_if_fail (text != NULL);
#line 802 "../src/greeter-list.vala"
	self->unacknowledged_messages = TRUE;
#line 803 "../src/greeter-list.vala"
	greeter_list_show_message (self, text, type == LIGHTDM_MESSAGE_TYPE_ERROR);
#line 3658 "greeter-list.c"
}

static void
greeter_list_real_show_prompt_cb (GreeterList* self,
                                  const gchar* text,
                                  LightDMPromptType type)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	DashEntry* entry = NULL;
	DashEntry* _tmp11_;
#line 806 "../src/greeter-list.vala"
	g_return_if_fail (text != NULL);
#line 809 "../src/greeter-list.vala"
	_tmp1_ = greeter_list_get_selected_id (self);
#line 809 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 809 "../src/greeter-list.vala"
	_tmp3_ = g_strcmp0 (_tmp2_, "*other") == 0;
#line 809 "../src/greeter-list.vala"
	_g_free0 (_tmp2_);
#line 809 "../src/greeter-list.vala"
	if (_tmp3_) {
#line 3684 "greeter-list.c"
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 809 "../src/greeter-list.vala"
		_tmp4_ = greeter_list_get_manual_name (self);
#line 809 "../src/greeter-list.vala"
		_tmp5_ = _tmp4_;
#line 809 "../src/greeter-list.vala"
		_tmp0_ = _tmp5_ == NULL;
#line 3693 "greeter-list.c"
	} else {
#line 809 "../src/greeter-list.vala"
		_tmp0_ = FALSE;
#line 3697 "greeter-list.c"
	}
#line 809 "../src/greeter-list.vala"
	if (_tmp0_) {
#line 3701 "greeter-list.c"
		SlickGreeter* _tmp6_;
#line 811 "../src/greeter-list.vala"
		_tmp6_ = slick_greeter_singleton;
#line 811 "../src/greeter-list.vala"
		if (_tmp6_->test_mode) {
#line 3707 "greeter-list.c"
			const gchar* _tmp7_;
#line 812 "../src/greeter-list.vala"
			_tmp7_ = self->test_username;
#line 812 "../src/greeter-list.vala"
			greeter_list_set_manual_name (self, _tmp7_);
#line 3713 "greeter-list.c"
		} else {
			SlickGreeter* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
#line 814 "../src/greeter-list.vala"
			_tmp8_ = slick_greeter_singleton;
#line 814 "../src/greeter-list.vala"
			_tmp9_ = slick_greeter_authentication_user (_tmp8_);
#line 814 "../src/greeter-list.vala"
			_tmp10_ = _tmp9_;
#line 814 "../src/greeter-list.vala"
			greeter_list_set_manual_name (self, _tmp10_);
#line 814 "../src/greeter-list.vala"
			_g_free0 (_tmp10_);
#line 3728 "greeter-list.c"
		}
	}
#line 817 "../src/greeter-list.vala"
	self->prompted = TRUE;
#line 818 "../src/greeter-list.vala"
	if (g_strcmp0 (text, "Password: ") == 0) {
#line 819 "../src/greeter-list.vala"
		text = _ ("Password:");
#line 3737 "greeter-list.c"
	}
#line 820 "../src/greeter-list.vala"
	if (g_strcmp0 (text, "login:") == 0) {
#line 821 "../src/greeter-list.vala"
		text = _ ("Username:");
#line 3743 "greeter-list.c"
	}
#line 822 "../src/greeter-list.vala"
	_tmp11_ = greeter_list_add_prompt (self, text, type == LIGHTDM_PROMPT_TYPE_SECRET);
#line 822 "../src/greeter-list.vala"
	entry = _tmp11_;
#line 825 "../src/greeter-list.vala"
	gtk_entry_set_max_length ((GtkEntry*) entry, MAX_FIELD_SIZE);
#line 826 "../src/greeter-list.vala"
	gtk_widget_queue_resize ((GtkWidget*) self);
#line 806 "../src/greeter-list.vala"
	_g_object_unref0 (entry);
#line 3755 "greeter-list.c"
}

void
greeter_list_show_prompt_cb (GreeterList* self,
                             const gchar* text,
                             LightDMPromptType type)
{
	GreeterListClass* _klass_;
#line 806 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 806 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 806 "../src/greeter-list.vala"
	if (_klass_->show_prompt_cb) {
#line 806 "../src/greeter-list.vala"
		_klass_->show_prompt_cb (self, text, type);
#line 3772 "greeter-list.c"
	}
}

static void
_greeter_list_background_loaded_cb_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
#line 862 "../src/greeter-list.vala"
	greeter_list_background_loaded_cb ((GreeterList*) self, pspec);
#line 3783 "greeter-list.c"
}

static void
greeter_list_real_authentication_complete_cb (GreeterList* self)
{
	const gchar* _tmp0_;
	PromptBox* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean is_authenticated = FALSE;
	SlickGreeter* _tmp4_;
#line 840 "../src/greeter-list.vala"
	_tmp0_ = self->greeter_authenticating_user;
#line 840 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 840 "../src/greeter-list.vala"
	_tmp2_ = prompt_box_get_id (_tmp1_);
#line 840 "../src/greeter-list.vala"
	_tmp3_ = _tmp2_;
#line 840 "../src/greeter-list.vala"
	if (g_strcmp0 (_tmp0_, _tmp3_) != 0) {
#line 841 "../src/greeter-list.vala"
		return;
#line 3807 "greeter-list.c"
	}
#line 844 "../src/greeter-list.vala"
	_tmp4_ = slick_greeter_singleton;
#line 844 "../src/greeter-list.vala"
	if (_tmp4_->test_mode) {
#line 845 "../src/greeter-list.vala"
		is_authenticated = self->test_is_authenticated;
#line 3815 "greeter-list.c"
	} else {
		SlickGreeter* _tmp5_;
#line 847 "../src/greeter-list.vala"
		_tmp5_ = slick_greeter_singleton;
#line 847 "../src/greeter-list.vala"
		is_authenticated = slick_greeter_is_authenticated (_tmp5_);
#line 3822 "greeter-list.c"
	}
#line 849 "../src/greeter-list.vala"
	if (is_authenticated) {
#line 3826 "greeter-list.c"
		gboolean _tmp6_ = FALSE;
#line 852 "../src/greeter-list.vala"
		if (self->prompted) {
#line 852 "../src/greeter-list.vala"
			_tmp6_ = !self->unacknowledged_messages;
#line 3832 "greeter-list.c"
		} else {
#line 852 "../src/greeter-list.vala"
			_tmp6_ = FALSE;
#line 3836 "greeter-list.c"
		}
#line 852 "../src/greeter-list.vala"
		if (_tmp6_) {
#line 3840 "greeter-list.c"
			SlickGreeter* _tmp7_;
#line 854 "../src/greeter-list.vala"
			greeter_list_login_complete (self);
#line 855 "../src/greeter-list.vala"
			_tmp7_ = slick_greeter_singleton;
#line 855 "../src/greeter-list.vala"
			if (_tmp7_->test_mode) {
#line 856 "../src/greeter-list.vala"
				greeter_list_start_session (self);
#line 3850 "greeter-list.c"
			} else {
				Background* _tmp8_;
				gdouble _tmp9_;
				gdouble _tmp10_;
#line 859 "../src/greeter-list.vala"
				_tmp8_ = self->priv->_background;
#line 859 "../src/greeter-list.vala"
				_tmp9_ = background_get_alpha (_tmp8_);
#line 859 "../src/greeter-list.vala"
				_tmp10_ = _tmp9_;
#line 859 "../src/greeter-list.vala"
				if (_tmp10_ == 1.0) {
#line 860 "../src/greeter-list.vala"
					greeter_list_start_session (self);
#line 3865 "greeter-list.c"
				} else {
					Background* _tmp11_;
#line 862 "../src/greeter-list.vala"
					_tmp11_ = self->priv->_background;
#line 862 "../src/greeter-list.vala"
					g_signal_connect_object ((GObject*) _tmp11_, "notify::alpha", (GCallback) _greeter_list_background_loaded_cb_g_object_notify, self, 0);
#line 3872 "greeter-list.c"
				}
			}
		} else {
#line 867 "../src/greeter-list.vala"
			self->prompted = TRUE;
#line 868 "../src/greeter-list.vala"
			greeter_list_show_authenticated (self, TRUE);
#line 3880 "greeter-list.c"
		}
	} else {
#line 873 "../src/greeter-list.vala"
		if (self->prompted) {
#line 3885 "greeter-list.c"
			PromptBox* _tmp12_;
#line 876 "../src/greeter-list.vala"
			if (self->will_clear) {
#line 877 "../src/greeter-list.vala"
				greeter_list_show_message (self, _ ("Invalid password, please try again"), TRUE);
#line 3891 "greeter-list.c"
			}
#line 879 "../src/greeter-list.vala"
			_tmp12_ = self->priv->_selected_entry;
#line 879 "../src/greeter-list.vala"
			prompt_box_reset_spinners (_tmp12_);
#line 882 "../src/greeter-list.vala"
			greeter_list_start_authentication (self);
#line 3899 "greeter-list.c"
		} else {
			PromptBox* _tmp13_;
			gboolean _tmp14_;
			gboolean _tmp15_;
#line 887 "../src/greeter-list.vala"
			_tmp13_ = self->priv->_selected_entry;
#line 887 "../src/greeter-list.vala"
			_tmp14_ = prompt_box_get_has_errors (_tmp13_);
#line 887 "../src/greeter-list.vala"
			_tmp15_ = _tmp14_;
#line 887 "../src/greeter-list.vala"
			if (!_tmp15_) {
#line 888 "../src/greeter-list.vala"
				greeter_list_show_message (self, _ ("Failed to authenticate"), TRUE);
#line 3914 "greeter-list.c"
			}
#line 891 "../src/greeter-list.vala"
			greeter_list_show_authenticated (self, FALSE);
#line 3918 "greeter-list.c"
		}
	}
}

void
greeter_list_authentication_complete_cb (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 829 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 829 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 829 "../src/greeter-list.vala"
	if (_klass_->authentication_complete_cb) {
#line 829 "../src/greeter-list.vala"
		_klass_->authentication_complete_cb (self);
#line 3935 "greeter-list.c"
	}
}

static void
greeter_list_real_start_authentication (GreeterList* self)
{
	gchar* _tmp0_;
	SlickGreeter* _tmp1_;
#line 898 "../src/greeter-list.vala"
	self->prompted = FALSE;
#line 899 "../src/greeter-list.vala"
	self->unacknowledged_messages = FALSE;
#line 902 "../src/greeter-list.vala"
	greeter_list_set_manual_name (self, NULL);
#line 904 "../src/greeter-list.vala"
	self->will_clear = FALSE;
#line 906 "../src/greeter-list.vala"
	_tmp0_ = greeter_list_get_selected_id (self);
#line 906 "../src/greeter-list.vala"
	_g_free0 (self->greeter_authenticating_user);
#line 906 "../src/greeter-list.vala"
	self->greeter_authenticating_user = _tmp0_;
#line 908 "../src/greeter-list.vala"
	_tmp1_ = slick_greeter_singleton;
#line 908 "../src/greeter-list.vala"
	if (_tmp1_->test_mode) {
#line 909 "../src/greeter-list.vala"
		greeter_list_test_start_authentication (self);
#line 3964 "greeter-list.c"
	} else {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
#line 912 "../src/greeter-list.vala"
		_tmp2_ = greeter_list_get_selected_id (self);
#line 912 "../src/greeter-list.vala"
		_tmp3_ = _tmp2_;
#line 912 "../src/greeter-list.vala"
		_tmp4_ = g_strcmp0 (_tmp3_, "*other") == 0;
#line 912 "../src/greeter-list.vala"
		_g_free0 (_tmp3_);
#line 912 "../src/greeter-list.vala"
		if (_tmp4_) {
#line 3979 "greeter-list.c"
			SlickGreeter* _tmp5_;
#line 913 "../src/greeter-list.vala"
			_tmp5_ = slick_greeter_singleton;
#line 913 "../src/greeter-list.vala"
			slick_greeter_authenticate (_tmp5_, NULL);
#line 3985 "greeter-list.c"
		} else {
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
#line 914 "../src/greeter-list.vala"
			_tmp6_ = greeter_list_get_selected_id (self);
#line 914 "../src/greeter-list.vala"
			_tmp7_ = _tmp6_;
#line 914 "../src/greeter-list.vala"
			_tmp8_ = g_strcmp0 (_tmp7_, "*guest") == 0;
#line 914 "../src/greeter-list.vala"
			_g_free0 (_tmp7_);
#line 914 "../src/greeter-list.vala"
			if (_tmp8_) {
#line 4000 "greeter-list.c"
				SlickGreeter* _tmp9_;
#line 915 "../src/greeter-list.vala"
				_tmp9_ = slick_greeter_singleton;
#line 915 "../src/greeter-list.vala"
				slick_greeter_authenticate_as_guest (_tmp9_);
#line 4006 "greeter-list.c"
			} else {
				SlickGreeter* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
#line 917 "../src/greeter-list.vala"
				_tmp10_ = slick_greeter_singleton;
#line 917 "../src/greeter-list.vala"
				_tmp11_ = greeter_list_get_selected_id (self);
#line 917 "../src/greeter-list.vala"
				_tmp12_ = _tmp11_;
#line 917 "../src/greeter-list.vala"
				slick_greeter_authenticate (_tmp10_, _tmp12_);
#line 917 "../src/greeter-list.vala"
				_g_free0 (_tmp12_);
#line 4021 "greeter-list.c"
			}
		}
	}
}

void
greeter_list_start_authentication (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 896 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 896 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 896 "../src/greeter-list.vala"
	if (_klass_->start_authentication) {
#line 896 "../src/greeter-list.vala"
		_klass_->start_authentication (self);
#line 4039 "greeter-list.c"
	}
}

static void
greeter_list_background_loaded_cb (GreeterList* self,
                                   GParamSpec* pspec)
{
	Background* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
#line 921 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 921 "../src/greeter-list.vala"
	g_return_if_fail (pspec != NULL);
#line 923 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_background;
#line 923 "../src/greeter-list.vala"
	_tmp1_ = background_get_alpha (_tmp0_);
#line 923 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 923 "../src/greeter-list.vala"
	if (_tmp2_ == 1.0) {
#line 4062 "greeter-list.c"
		Background* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
#line 925 "../src/greeter-list.vala"
		_tmp3_ = self->priv->_background;
#line 925 "../src/greeter-list.vala"
		g_signal_parse_name ("notify::alpha", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
#line 925 "../src/greeter-list.vala"
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _greeter_list_background_loaded_cb_g_object_notify, self);
#line 926 "../src/greeter-list.vala"
		greeter_list_start_session (self);
#line 4074 "greeter-list.c"
	}
}

static void
greeter_list_start_session (GreeterList* self)
{
	SlickGreeter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Background* _tmp3_;
	gboolean _tmp4_;
	Background* _tmp5_;
#line 930 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 932 "../src/greeter-list.vala"
	_tmp0_ = slick_greeter_singleton;
#line 932 "../src/greeter-list.vala"
	_tmp1_ = greeter_list_get_lightdm_session (self);
#line 932 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 932 "../src/greeter-list.vala"
	_tmp3_ = self->priv->_background;
#line 932 "../src/greeter-list.vala"
	_tmp4_ = !slick_greeter_start_session (_tmp0_, _tmp2_, _tmp3_);
#line 932 "../src/greeter-list.vala"
	_g_free0 (_tmp2_);
#line 932 "../src/greeter-list.vala"
	if (_tmp4_) {
#line 934 "../src/greeter-list.vala"
		greeter_list_show_message (self, _ ("Failed to start session"), TRUE);
#line 935 "../src/greeter-list.vala"
		greeter_list_start_authentication (self);
#line 936 "../src/greeter-list.vala"
		return;
#line 4109 "greeter-list.c"
	}
#line 940 "../src/greeter-list.vala"
	_tmp5_ = self->priv->_background;
#line 940 "../src/greeter-list.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp5_);
#line 4115 "greeter-list.c"
}

void
greeter_list_login_complete (GreeterList* self)
{
	PromptBox* _tmp0_;
	PromptBox* _tmp1_;
#line 943 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 945 "../src/greeter-list.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
#line 947 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 947 "../src/greeter-list.vala"
	prompt_box_clear (_tmp0_);
#line 948 "../src/greeter-list.vala"
	_tmp1_ = self->priv->_selected_entry;
#line 948 "../src/greeter-list.vala"
	prompt_box_add_message (_tmp1_, _ ("Logging in..."), FALSE);
#line 950 "../src/greeter-list.vala"
	greeter_list_redraw_greeter_box (self);
#line 4137 "greeter-list.c"
}

static gchar*
greeter_list_real_get_lightdm_session (GreeterList* self)
{
	gchar* _tmp0_;
	gchar* result;
#line 955 "../src/greeter-list.vala"
	_tmp0_ = slick_greeter_get_default_session ();
#line 955 "../src/greeter-list.vala"
	result = _tmp0_;
#line 955 "../src/greeter-list.vala"
	return result;
#line 4151 "greeter-list.c"
}

gchar*
greeter_list_get_lightdm_session (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 953 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 953 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 953 "../src/greeter-list.vala"
	if (_klass_->get_lightdm_session) {
#line 953 "../src/greeter-list.vala"
		return _klass_->get_lightdm_session (self);
#line 4166 "greeter-list.c"
	}
#line 953 "../src/greeter-list.vala"
	return NULL;
#line 4170 "greeter-list.c"
}

static void
greeter_list_real_test_start_authentication (GreeterList* self)
{
}

void
greeter_list_test_start_authentication (GreeterList* self)
{
	GreeterListClass* _klass_;
#line 963 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 963 "../src/greeter-list.vala"
	_klass_ = GREETER_LIST_GET_CLASS (self);
#line 963 "../src/greeter-list.vala"
	if (_klass_->test_start_authentication) {
#line 963 "../src/greeter-list.vala"
		_klass_->test_start_authentication (self);
#line 4190 "greeter-list.c"
	}
}

Background*
greeter_list_get_background (GreeterList* self)
{
	Background* result;
	Background* _tmp0_;
#line 64 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_background;
#line 64 "../src/greeter-list.vala"
	result = _tmp0_;
#line 64 "../src/greeter-list.vala"
	return result;
#line 4207 "greeter-list.c"
}

static void
greeter_list_set_background (GreeterList* self,
                             Background* value)
{
	Background* old_value;
#line 64 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 64 "../src/greeter-list.vala"
	old_value = greeter_list_get_background (self);
#line 64 "../src/greeter-list.vala"
	if (old_value != value) {
#line 4221 "greeter-list.c"
		Background* _tmp0_;
#line 64 "../src/greeter-list.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 64 "../src/greeter-list.vala"
		_g_object_unref0 (self->priv->_background);
#line 64 "../src/greeter-list.vala"
		self->priv->_background = _tmp0_;
#line 64 "../src/greeter-list.vala"
		g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_BACKGROUND_PROPERTY]);
#line 4231 "greeter-list.c"
	}
}

MenuBar*
greeter_list_get_menubar (GreeterList* self)
{
	MenuBar* result;
	MenuBar* _tmp0_;
#line 65 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_menubar;
#line 65 "../src/greeter-list.vala"
	result = _tmp0_;
#line 65 "../src/greeter-list.vala"
	return result;
#line 4248 "greeter-list.c"
}

static void
greeter_list_set_menubar (GreeterList* self,
                          MenuBar* value)
{
	MenuBar* old_value;
#line 65 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 65 "../src/greeter-list.vala"
	old_value = greeter_list_get_menubar (self);
#line 65 "../src/greeter-list.vala"
	if (old_value != value) {
#line 4262 "greeter-list.c"
		MenuBar* _tmp0_;
#line 65 "../src/greeter-list.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 65 "../src/greeter-list.vala"
		_g_object_unref0 (self->priv->_menubar);
#line 65 "../src/greeter-list.vala"
		self->priv->_menubar = _tmp0_;
#line 65 "../src/greeter-list.vala"
		g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_MENUBAR_PROPERTY]);
#line 4272 "greeter-list.c"
	}
}

PromptBox*
greeter_list_get_selected_entry (GreeterList* self)
{
	PromptBox* result;
	PromptBox* _tmp0_;
#line 66 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 66 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_selected_entry;
#line 66 "../src/greeter-list.vala"
	result = _tmp0_;
#line 66 "../src/greeter-list.vala"
	return result;
#line 4289 "greeter-list.c"
}

static void
greeter_list_set_selected_entry (GreeterList* self,
                                 PromptBox* value)
{
	PromptBox* old_value;
#line 66 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 66 "../src/greeter-list.vala"
	old_value = greeter_list_get_selected_entry (self);
#line 66 "../src/greeter-list.vala"
	if (old_value != value) {
#line 4303 "greeter-list.c"
		PromptBox* _tmp0_;
#line 66 "../src/greeter-list.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 66 "../src/greeter-list.vala"
		_g_object_unref0 (self->priv->_selected_entry);
#line 66 "../src/greeter-list.vala"
		self->priv->_selected_entry = _tmp0_;
#line 66 "../src/greeter-list.vala"
		g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_SELECTED_ENTRY_PROPERTY]);
#line 4313 "greeter-list.c"
	}
}

gboolean
greeter_list_get_start_scrolling (GreeterList* self)
{
	gboolean result;
#line 67 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 67 "../src/greeter-list.vala"
	result = self->priv->_start_scrolling;
#line 67 "../src/greeter-list.vala"
	return result;
#line 4327 "greeter-list.c"
}

void
greeter_list_set_start_scrolling (GreeterList* self,
                                  gboolean value)
{
	gboolean old_value;
#line 67 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 67 "../src/greeter-list.vala"
	old_value = greeter_list_get_start_scrolling (self);
#line 67 "../src/greeter-list.vala"
	if (old_value != value) {
#line 67 "../src/greeter-list.vala"
		self->priv->_start_scrolling = value;
#line 67 "../src/greeter-list.vala"
		g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_START_SCROLLING_PROPERTY]);
#line 4345 "greeter-list.c"
	}
}

gboolean
greeter_list_get_always_show_manual (GreeterList* self)
{
	gboolean result;
#line 74 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 74 "../src/greeter-list.vala"
	result = self->_always_show_manual;
#line 74 "../src/greeter-list.vala"
	return result;
#line 4359 "greeter-list.c"
}

void
greeter_list_set_always_show_manual (GreeterList* self,
                                     gboolean value)
{
#line 75 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 77 "../src/greeter-list.vala"
	self->_always_show_manual = value;
#line 78 "../src/greeter-list.vala"
	if (value) {
#line 79 "../src/greeter-list.vala"
		greeter_list_add_manual_entry (self);
#line 4374 "greeter-list.c"
	} else {
#line 80 "../src/greeter-list.vala"
		if (greeter_list_have_entries (self)) {
#line 81 "../src/greeter-list.vala"
			greeter_list_remove_entry (self, "*other");
#line 4380 "greeter-list.c"
		}
	}
#line 75 "../src/greeter-list.vala"
	g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY]);
#line 4385 "greeter-list.c"
}

static gint
greeter_list_get_box_x (GreeterList* self)
{
	gint result;
#line 116 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 116 "../src/greeter-list.vala"
	result = 0;
#line 116 "../src/greeter-list.vala"
	return result;
#line 4398 "greeter-list.c"
}

static gint
greeter_list_get_box_y (GreeterList* self)
{
	gint result;
	gint row = 0;
#line 121 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 124 "../src/greeter-list.vala"
	row = (MAIN_WINDOW_MENUBAR_HEIGHT + gtk_widget_get_allocated_height ((GtkWidget*) self)) / grid_size;
#line 125 "../src/greeter-list.vala"
	row = row - GREETER_LIST_DEFAULT_BOX_HEIGHT;
#line 126 "../src/greeter-list.vala"
	row = row / 2;
#line 128 "../src/greeter-list.vala"
	result = (row * grid_size) - MAIN_WINDOW_MENUBAR_HEIGHT;
#line 128 "../src/greeter-list.vala"
	return result;
#line 4418 "greeter-list.c"
}

const gchar*
greeter_list_get_manual_name (GreeterList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 146 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_manual_name;
#line 146 "../src/greeter-list.vala"
	result = _tmp0_;
#line 146 "../src/greeter-list.vala"
	return result;
#line 4434 "greeter-list.c"
}

void
greeter_list_set_manual_name (GreeterList* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	PromptBox* _tmp1_;
	PromptBox* _tmp2_;
	gboolean _tmp3_;
#line 147 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 149 "../src/greeter-list.vala"
	_tmp0_ = g_strdup (value);
#line 149 "../src/greeter-list.vala"
	_g_free0 (self->priv->_manual_name);
#line 149 "../src/greeter-list.vala"
	self->priv->_manual_name = _tmp0_;
#line 150 "../src/greeter-list.vala"
	_tmp1_ = greeter_list_find_entry (self, "*other");
#line 150 "../src/greeter-list.vala"
	_tmp2_ = _tmp1_;
#line 150 "../src/greeter-list.vala"
	_tmp3_ = _tmp2_ != NULL;
#line 150 "../src/greeter-list.vala"
	_g_object_unref0 (_tmp2_);
#line 150 "../src/greeter-list.vala"
	if (_tmp3_) {
#line 151 "../src/greeter-list.vala"
		greeter_list_add_manual_entry (self);
#line 4465 "greeter-list.c"
	}
#line 147 "../src/greeter-list.vala"
	g_object_notify_by_pspec ((GObject *) self, greeter_list_properties[GREETER_LIST_MANUAL_NAME_PROPERTY]);
#line 4469 "greeter-list.c"
}

static PromptBox*
greeter_list_get_scrolling_entry (GreeterList* self)
{
	PromptBox* result;
	PromptBox* _tmp0_;
#line 158 "../src/greeter-list.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 158 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_scrolling_entry;
#line 158 "../src/greeter-list.vala"
	result = _tmp0_;
#line 158 "../src/greeter-list.vala"
	return result;
#line 4485 "greeter-list.c"
}

static void
greeter_list_set_scrolling_entry (GreeterList* self,
                                  PromptBox* value)
{
	PromptBox* _tmp0_;
	PromptBox* _tmp2_;
#line 159 "../src/greeter-list.vala"
	g_return_if_fail (self != NULL);
#line 163 "../src/greeter-list.vala"
	_tmp0_ = self->priv->_scrolling_entry;
#line 163 "../src/greeter-list.vala"
	if (_tmp0_ != NULL) {
#line 4500 "greeter-list.c"
		PromptBox* _tmp1_;
#line 164 "../src/greeter-list.vala"
		_tmp1_ = self->priv->_scrolling_entry;
#line 164 "../src/greeter-list.vala"
		prompt_box_set_options_image (_tmp1_, NULL, NULL);
#line 4506 "greeter-list.c"
	}
#line 165 "../src/greeter-list.vala"
	_tmp2_ = _g_object_ref0 (value);
#line 165 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->_scrolling_entry);
#line 165 "../src/greeter-list.vala"
	self->priv->_scrolling_entry = _tmp2_;
#line 4514 "greeter-list.c"
}

static void
_greeter_list___lambda40_ (GreeterList* self)
{
#line 186 "../src/greeter-list.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 4522 "greeter-list.c"
}

static void
__greeter_list___lambda40__g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self)
{
#line 186 "../src/greeter-list.vala"
	_greeter_list___lambda40_ ((GreeterList*) self);
#line 4532 "greeter-list.c"
}

static void
_greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                     GtkAllocation* allocation,
                                                                     gpointer self)
{
#line 188 "../src/greeter-list.vala"
	greeter_list_greeter_box_size_allocate_cb ((GreeterList*) self, allocation);
#line 4542 "greeter-list.c"
}

static gdouble
_animate_timer_ease_out_quint_animate_timer_easing_func (gdouble x,
                                                         gpointer self)
{
	gdouble result;
	result = animate_timer_ease_out_quint (x);
#line 191 "../src/greeter-list.vala"
	return result;
#line 4553 "greeter-list.c"
}

static void
_greeter_list_animate_scrolling_animate_timer_animate (AnimateTimer* _sender,
                                                       gdouble progress,
                                                       gpointer self)
{
#line 192 "../src/greeter-list.vala"
	greeter_list_animate_scrolling ((GreeterList*) self, progress);
#line 4563 "greeter-list.c"
}

static void
_greeter_list_on_bus_acquired_gasync_ready_callback (GObject* source_object,
                                                     GAsyncResult* res,
                                                     gpointer self)
{
#line 196 "../src/greeter-list.vala"
	greeter_list_on_bus_acquired ((GreeterList*) self, source_object, res);
#line 196 "../src/greeter-list.vala"
	g_object_unref (self);
#line 4575 "greeter-list.c"
}

static GObject *
greeter_list_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GreeterList * self;
	GtkFixed* _tmp0_;
	GtkFixed* _tmp1_;
	GtkFixed* _tmp2_;
	Background* _tmp3_;
	DashBox* _tmp4_;
	DashBox* _tmp5_;
	DashBox* _tmp6_;
	DashBox* _tmp7_;
	DashBox* _tmp8_;
	AnimateTimer* _tmp9_;
	AnimateTimer* _tmp10_;
	GError* _inner_error0_ = NULL;
#line 174 "../src/greeter-list.vala"
	parent_class = G_OBJECT_CLASS (greeter_list_parent_class);
#line 174 "../src/greeter-list.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 174 "../src/greeter-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GREETER_LIST, GreeterList);
#line 176 "../src/greeter-list.vala"
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
#line 177 "../src/greeter-list.vala"
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
#line 179 "../src/greeter-list.vala"
	_scale_factor = gtk_widget_get_scale_factor ((GtkWidget*) self);
#line 181 "../src/greeter-list.vala"
	_tmp0_ = (GtkFixed*) gtk_fixed_new ();
#line 181 "../src/greeter-list.vala"
	g_object_ref_sink (_tmp0_);
#line 181 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->fixed);
#line 181 "../src/greeter-list.vala"
	self->priv->fixed = _tmp0_;
#line 182 "../src/greeter-list.vala"
	_tmp1_ = self->priv->fixed;
#line 182 "../src/greeter-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 183 "../src/greeter-list.vala"
	_tmp2_ = self->priv->fixed;
#line 183 "../src/greeter-list.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
#line 185 "../src/greeter-list.vala"
	_tmp3_ = self->priv->_background;
#line 185 "../src/greeter-list.vala"
	_tmp4_ = dash_box_new (_tmp3_);
#line 185 "../src/greeter-list.vala"
	g_object_ref_sink (_tmp4_);
#line 185 "../src/greeter-list.vala"
	_g_object_unref0 (self->greeter_box);
#line 185 "../src/greeter-list.vala"
	self->greeter_box = _tmp4_;
#line 186 "../src/greeter-list.vala"
	_tmp5_ = self->greeter_box;
#line 186 "../src/greeter-list.vala"
	g_signal_connect_object ((GObject*) _tmp5_, "notify::base-alpha", (GCallback) __greeter_list___lambda40__g_object_notify, self, 0);
#line 187 "../src/greeter-list.vala"
	_tmp6_ = self->greeter_box;
#line 187 "../src/greeter-list.vala"
	gtk_widget_show ((GtkWidget*) _tmp6_);
#line 188 "../src/greeter-list.vala"
	_tmp7_ = self->greeter_box;
#line 188 "../src/greeter-list.vala"
	g_signal_connect_object ((GtkWidget*) _tmp7_, "size-allocate", (GCallback) _greeter_list_greeter_box_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 189 "../src/greeter-list.vala"
	_tmp8_ = self->greeter_box;
#line 189 "../src/greeter-list.vala"
	greeter_list_add_with_class (self, (GtkWidget*) _tmp8_);
#line 191 "../src/greeter-list.vala"
	_tmp9_ = animate_timer_new (_animate_timer_ease_out_quint_animate_timer_easing_func, NULL, ANIMATE_TIMER_FAST);
#line 191 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->scroll_timer);
#line 191 "../src/greeter-list.vala"
	self->priv->scroll_timer = _tmp9_;
#line 192 "../src/greeter-list.vala"
	_tmp10_ = self->priv->scroll_timer;
#line 192 "../src/greeter-list.vala"
	g_signal_connect_object (_tmp10_, "animate", (GCallback) _greeter_list_animate_scrolling_animate_timer_animate, self, 0);
#line 4662 "greeter-list.c"
	{
#line 196 "../src/greeter-list.vala"
		g_bus_get (G_BUS_TYPE_SESSION, NULL, _greeter_list_on_bus_acquired_gasync_ready_callback, g_object_ref (self));
#line 4666 "greeter-list.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
#line 194 "../src/greeter-list.vala"
		e = _inner_error0_;
#line 194 "../src/greeter-list.vala"
		_inner_error0_ = NULL;
#line 200 "../src/greeter-list.vala"
		_tmp11_ = e;
#line 200 "../src/greeter-list.vala"
		_tmp12_ = _tmp11_->message;
#line 200 "../src/greeter-list.vala"
		g_debug ("greeter-list.vala:200: Error getting session bus: %s", _tmp12_);
#line 194 "../src/greeter-list.vala"
		_g_error_free0 (e);
#line 4686 "greeter-list.c"
	}
	__finally0:
#line 194 "../src/greeter-list.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 194 "../src/greeter-list.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 194 "../src/greeter-list.vala"
		g_clear_error (&_inner_error0_);
#line 4695 "greeter-list.c"
	}
#line 174 "../src/greeter-list.vala"
	return obj;
#line 4699 "greeter-list.c"
}

static void
greeter_list_class_init (GreeterListClass * klass,
                         gpointer klass_data)
{
#line 62 "../src/greeter-list.vala"
	greeter_list_parent_class = g_type_class_peek_parent (klass);
#line 62 "../src/greeter-list.vala"
	g_type_class_adjust_private_offset (klass, &GreeterList_private_offset);
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->get_selected_id = (gchar* (*) (GreeterList*)) greeter_list_real_get_selected_id;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) greeter_list_real_get_preferred_width;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) greeter_list_real_get_preferred_height;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->grab_focus = (void (*) (GtkWidget*)) greeter_list_real_grab_focus;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->focus_prompt = (void (*) (GreeterList*)) greeter_list_real_focus_prompt;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->show_authenticated = (void (*) (GreeterList*, gboolean)) greeter_list_real_show_authenticated;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->insert_entry = (void (*) (GreeterList*, PromptBox*)) greeter_list_real_insert_entry;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->add_manual_entry = (void (*) (GreeterList*)) greeter_list_real_add_manual_entry;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->get_position_y = (gint (*) (GreeterList*, gdouble)) greeter_list_real_get_position_y;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->setup_prompt_box = (void (*) (GreeterList*, gboolean)) greeter_list_real_setup_prompt_box;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) greeter_list_real_realize;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) greeter_list_real_size_allocate;
#line 62 "../src/greeter-list.vala"
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) greeter_list_real_draw;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->show_prompt_cb = (void (*) (GreeterList*, const gchar*, LightDMPromptType)) greeter_list_real_show_prompt_cb;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->authentication_complete_cb = (void (*) (GreeterList*)) greeter_list_real_authentication_complete_cb;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->start_authentication = (void (*) (GreeterList*)) greeter_list_real_start_authentication;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->get_lightdm_session = (gchar* (*) (GreeterList*)) greeter_list_real_get_lightdm_session;
#line 62 "../src/greeter-list.vala"
	((GreeterListClass *) klass)->test_start_authentication = (void (*) (GreeterList*)) greeter_list_real_test_start_authentication;
#line 62 "../src/greeter-list.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_greeter_list_get_property;
#line 62 "../src/greeter-list.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_greeter_list_set_property;
#line 62 "../src/greeter-list.vala"
	G_OBJECT_CLASS (klass)->constructor = greeter_list_constructor;
#line 62 "../src/greeter-list.vala"
	G_OBJECT_CLASS (klass)->finalize = greeter_list_finalize;
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_BACKGROUND_PROPERTY, greeter_list_properties[GREETER_LIST_BACKGROUND_PROPERTY] = g_param_spec_object ("background", "background", "background", TYPE_BACKGROUND, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_MENUBAR_PROPERTY, greeter_list_properties[GREETER_LIST_MENUBAR_PROPERTY] = g_param_spec_object ("menubar", "menubar", "menubar", TYPE_MENU_BAR, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_SELECTED_ENTRY_PROPERTY, greeter_list_properties[GREETER_LIST_SELECTED_ENTRY_PROPERTY] = g_param_spec_object ("selected-entry", "selected-entry", "selected-entry", TYPE_PROMPT_BOX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_START_SCROLLING_PROPERTY, greeter_list_properties[GREETER_LIST_START_SCROLLING_PROPERTY] = g_param_spec_boolean ("start-scrolling", "start-scrolling", "start-scrolling", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY, greeter_list_properties[GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY] = g_param_spec_boolean ("always-show-manual", "always-show-manual", "always-show-manual", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "../src/greeter-list.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GREETER_LIST_MANUAL_NAME_PROPERTY, greeter_list_properties[GREETER_LIST_MANUAL_NAME_PROPERTY] = g_param_spec_string ("manual-name", "manual-name", "manual-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 62 "../src/greeter-list.vala"
	greeter_list_signals[GREETER_LIST_ENTRY_SELECTED_SIGNAL] = g_signal_new ("entry-selected", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 62 "../src/greeter-list.vala"
	greeter_list_signals[GREETER_LIST_ENTRY_DISPLAYED_START_SIGNAL] = g_signal_new ("entry-displayed-start", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 62 "../src/greeter-list.vala"
	greeter_list_signals[GREETER_LIST_ENTRY_DISPLAYED_DONE_SIGNAL] = g_signal_new ("entry-displayed-done", TYPE_GREETER_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 4772 "greeter-list.c"
}

static void
greeter_list_instance_init (GreeterList * self,
                            gpointer klass)
{
#line 62 "../src/greeter-list.vala"
	self->priv = greeter_list_get_instance_private (self);
#line 66 "../src/greeter-list.vala"
	self->priv->_selected_entry = NULL;
#line 67 "../src/greeter-list.vala"
	self->priv->_start_scrolling = TRUE;
#line 71 "../src/greeter-list.vala"
	self->_always_show_manual = FALSE;
#line 85 "../src/greeter-list.vala"
	self->entries = NULL;
#line 98 "../src/greeter-list.vala"
	self->priv->cached_box_height = -1;
#line 105 "../src/greeter-list.vala"
	self->mode = GREETER_LIST_MODE_ENTRY;
#line 111 "../src/greeter-list.vala"
	self->priv->n_above = (guint) 4;
#line 112 "../src/greeter-list.vala"
	self->priv->n_below = (guint) 4;
#line 143 "../src/greeter-list.vala"
	self->priv->_manual_name = NULL;
#line 155 "../src/greeter-list.vala"
	self->priv->_scrolling_entry = NULL;
#line 789 "../src/greeter-list.vala"
	self->will_clear = FALSE;
#line 790 "../src/greeter-list.vala"
	self->prompted = FALSE;
#line 791 "../src/greeter-list.vala"
	self->unacknowledged_messages = FALSE;
#line 960 "../src/greeter-list.vala"
	self->test_username = NULL;
#line 961 "../src/greeter-list.vala"
	self->test_is_authenticated = FALSE;
#line 4811 "greeter-list.c"
}

static void
greeter_list_finalize (GObject * obj)
{
	GreeterList * self;
#line 62 "../src/greeter-list.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GREETER_LIST, GreeterList);
#line 64 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->_background);
#line 65 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->_menubar);
#line 66 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->_selected_entry);
#line 69 "../src/greeter-list.vala"
	_g_free0 (self->greeter_authenticating_user);
#line 85 "../src/greeter-list.vala"
	(self->entries == NULL) ? NULL : (self->entries = (_g_list_free__g_object_unref0_ (self->entries), NULL));
#line 87 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->dbus_object);
#line 94 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->scroll_timer);
#line 96 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->fixed);
#line 97 "../src/greeter-list.vala"
	_g_object_unref0 (self->greeter_box);
#line 143 "../src/greeter-list.vala"
	_g_free0 (self->priv->_manual_name);
#line 155 "../src/greeter-list.vala"
	_g_object_unref0 (self->priv->_scrolling_entry);
#line 960 "../src/greeter-list.vala"
	_g_free0 (self->test_username);
#line 62 "../src/greeter-list.vala"
	G_OBJECT_CLASS (greeter_list_parent_class)->finalize (obj);
#line 4846 "greeter-list.c"
}

static GType
greeter_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GreeterListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) greeter_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GreeterList), 0, (GInstanceInitFunc) greeter_list_instance_init, NULL };
	GType greeter_list_type_id;
	greeter_list_type_id = g_type_register_static (TYPE_FADABLE_BOX, "GreeterList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GreeterList_private_offset = g_type_add_instance_private (greeter_list_type_id, sizeof (GreeterListPrivate));
	return greeter_list_type_id;
}

GType
greeter_list_get_type (void)
{
	static volatile gsize greeter_list_type_id__once = 0;
	if (g_once_init_enter (&greeter_list_type_id__once)) {
		GType greeter_list_type_id;
		greeter_list_type_id = greeter_list_get_type_once ();
		g_once_init_leave (&greeter_list_type_id__once, greeter_list_type_id);
	}
	return greeter_list_type_id__once;
}

static void
_vala_greeter_list_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	GreeterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GREETER_LIST, GreeterList);
#line 62 "../src/greeter-list.vala"
	switch (property_id) {
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_BACKGROUND_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_object (value, greeter_list_get_background (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_MENUBAR_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_object (value, greeter_list_get_menubar (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_SELECTED_ENTRY_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_object (value, greeter_list_get_selected_entry (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_START_SCROLLING_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_boolean (value, greeter_list_get_start_scrolling (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_boolean (value, greeter_list_get_always_show_manual (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_MANUAL_NAME_PROPERTY:
#line 62 "../src/greeter-list.vala"
		g_value_set_string (value, greeter_list_get_manual_name (self));
#line 62 "../src/greeter-list.vala"
		break;
#line 4917 "greeter-list.c"
		default:
#line 62 "../src/greeter-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "../src/greeter-list.vala"
		break;
#line 4923 "greeter-list.c"
	}
}

static void
_vala_greeter_list_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	GreeterList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GREETER_LIST, GreeterList);
#line 62 "../src/greeter-list.vala"
	switch (property_id) {
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_BACKGROUND_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_background (self, g_value_get_object (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_MENUBAR_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_menubar (self, g_value_get_object (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_SELECTED_ENTRY_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_selected_entry (self, g_value_get_object (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_START_SCROLLING_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_start_scrolling (self, g_value_get_boolean (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_ALWAYS_SHOW_MANUAL_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_always_show_manual (self, g_value_get_boolean (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 62 "../src/greeter-list.vala"
		case GREETER_LIST_MANUAL_NAME_PROPERTY:
#line 62 "../src/greeter-list.vala"
		greeter_list_set_manual_name (self, g_value_get_string (value));
#line 62 "../src/greeter-list.vala"
		break;
#line 4973 "greeter-list.c"
		default:
#line 62 "../src/greeter-list.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 62 "../src/greeter-list.vala"
		break;
#line 4979 "greeter-list.c"
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

