/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: SystemZ.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FeatureSoftFloatBit = 37,
  Feature_FeatureBackChainBit = 1,
  Feature_FeatureUnalignedSymbolsBit = 40,
  Feature_FeatureDistinctOpsBit = 6,
  Feature_FeatureFastSerializationBit = 11,
  Feature_FeatureFPExtensionBit = 10,
  Feature_FeatureHighWordBit = 13,
  Feature_FeatureInterlockedAccess1Bit = 15,
  Feature_FeatureLoadStoreOnCondBit = 18,
  Feature_FeaturePopulationCountBit = 32,
  Feature_FeatureMessageSecurityAssist3Bit = 20,
  Feature_FeatureMessageSecurityAssist4Bit = 21,
  Feature_FeatureResetReferenceBitsMultipleBit = 36,
  Feature_FeatureExecutionHintBit = 9,
  Feature_FeatureLoadAndTrapBit = 16,
  Feature_FeatureMiscellaneousExtensionsBit = 27,
  Feature_FeatureProcessorAssistBit = 34,
  Feature_FeatureTransactionalExecutionBit = 39,
  Feature_FeatureDFPZonedConversionBit = 4,
  Feature_FeatureEnhancedDAT2Bit = 7,
  Feature_FeatureLoadAndZeroRightmostByteBit = 17,
  Feature_FeatureLoadStoreOnCond2Bit = 19,
  Feature_FeatureMessageSecurityAssist5Bit = 22,
  Feature_FeatureDFPPackedConversionBit = 3,
  Feature_FeatureVectorBit = 41,
  Feature_FeatureMiscellaneousExtensions2Bit = 28,
  Feature_FeatureGuardedStorageBit = 12,
  Feature_FeatureMessageSecurityAssist7Bit = 23,
  Feature_FeatureMessageSecurityAssist8Bit = 24,
  Feature_FeatureVectorEnhancements1Bit = 42,
  Feature_FeatureVectorPackedDecimalBit = 45,
  Feature_FeatureInsertReferenceBitsMultipleBit = 14,
  Feature_FeatureTestPendingExternalInterruptionBit = 38,
  Feature_FeatureMiscellaneousExtensions3Bit = 29,
  Feature_FeatureMessageSecurityAssist9Bit = 25,
  Feature_FeatureVectorEnhancements2Bit = 43,
  Feature_FeatureVectorPackedDecimalEnhancementBit = 46,
  Feature_FeatureEnhancedSortBit = 8,
  Feature_FeatureDeflateConversionBit = 5,
  Feature_FeatureVectorPackedDecimalEnhancement2Bit = 47,
  Feature_FeatureNNPAssistBit = 31,
  Feature_FeatureBEAREnhancementBit = 0,
  Feature_FeatureResetDATProtectionBit = 35,
  Feature_FeatureProcessorActivityInstrumentationBit = 33,
  Feature_FeatureMiscellaneousExtensions4Bit = 30,
  Feature_FeatureVectorEnhancements3Bit = 44,
  Feature_FeatureVectorPackedDecimalEnhancement3Bit = 48,
  Feature_FeatureMessageSecurityAssist12Bit = 26,
  Feature_FeatureConcurrentFunctionsBit = 2,
};

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_FeatureSoftFloatBit: return "soft-float";
  case Feature_FeatureBackChainBit: return "backchain";
  case Feature_FeatureUnalignedSymbolsBit: return "unaligned-symbols";
  case Feature_FeatureDistinctOpsBit: return "distinct-ops";
  case Feature_FeatureFastSerializationBit: return "fast-serialization";
  case Feature_FeatureFPExtensionBit: return "fp-extension";
  case Feature_FeatureHighWordBit: return "high-word";
  case Feature_FeatureInterlockedAccess1Bit: return "interlocked-access1";
  case Feature_FeatureLoadStoreOnCondBit: return "load-store-on-cond";
  case Feature_FeaturePopulationCountBit: return "population-count";
  case Feature_FeatureMessageSecurityAssist3Bit: return "message-security-assist-extension3";
  case Feature_FeatureMessageSecurityAssist4Bit: return "message-security-assist-extension4";
  case Feature_FeatureResetReferenceBitsMultipleBit: return "reset-reference-bits-multiple";
  case Feature_FeatureExecutionHintBit: return "execution-hint";
  case Feature_FeatureLoadAndTrapBit: return "load-and-trap";
  case Feature_FeatureMiscellaneousExtensionsBit: return "miscellaneous-extensions";
  case Feature_FeatureProcessorAssistBit: return "processor-assist";
  case Feature_FeatureTransactionalExecutionBit: return "transactional-execution";
  case Feature_FeatureDFPZonedConversionBit: return "dfp-zoned-conversion";
  case Feature_FeatureEnhancedDAT2Bit: return "enhanced-dat-2";
  case Feature_FeatureLoadAndZeroRightmostByteBit: return "load-and-zero-rightmost-byte";
  case Feature_FeatureLoadStoreOnCond2Bit: return "load-store-on-cond-2";
  case Feature_FeatureMessageSecurityAssist5Bit: return "message-security-assist-extension5";
  case Feature_FeatureDFPPackedConversionBit: return "dfp-packed-conversion";
  case Feature_FeatureVectorBit: return "vector";
  case Feature_FeatureMiscellaneousExtensions2Bit: return "miscellaneous-extensions-2";
  case Feature_FeatureGuardedStorageBit: return "guarded-storage";
  case Feature_FeatureMessageSecurityAssist7Bit: return "message-security-assist-extension7";
  case Feature_FeatureMessageSecurityAssist8Bit: return "message-security-assist-extension8";
  case Feature_FeatureVectorEnhancements1Bit: return "vector-enhancements-1";
  case Feature_FeatureVectorPackedDecimalBit: return "vector-packed-decimal";
  case Feature_FeatureInsertReferenceBitsMultipleBit: return "insert-reference-bits-multiple";
  case Feature_FeatureTestPendingExternalInterruptionBit: return "test-pending-external-interruption";
  case Feature_FeatureMiscellaneousExtensions3Bit: return "miscellaneous-extensions-3";
  case Feature_FeatureMessageSecurityAssist9Bit: return "message-security-assist-extension9";
  case Feature_FeatureVectorEnhancements2Bit: return "vector-enhancements-2";
  case Feature_FeatureVectorPackedDecimalEnhancementBit: return "vector-packed-decimal-enhancement";
  case Feature_FeatureEnhancedSortBit: return "enhanced-sort";
  case Feature_FeatureDeflateConversionBit: return "deflate-conversion";
  case Feature_FeatureVectorPackedDecimalEnhancement2Bit: return "vector-packed-decimal-enhancement-2";
  case Feature_FeatureNNPAssistBit: return "nnp-assist";
  case Feature_FeatureBEAREnhancementBit: return "bear-enhancement";
  case Feature_FeatureResetDATProtectionBit: return "reset-dat-protection";
  case Feature_FeatureProcessorActivityInstrumentationBit: return "processor-activity-instrumentation";
  case Feature_FeatureMiscellaneousExtensions4Bit: return "miscellaneous-extensions-4";
  case Feature_FeatureVectorEnhancements3Bit: return "vector-enhancements-3";
  case Feature_FeatureVectorPackedDecimalEnhancement3Bit: return "vector-packed-decimal-enhancement-3";
  case Feature_FeatureMessageSecurityAssist12Bit: return "message-security-assist-extension12";
  case Feature_FeatureConcurrentFunctionsBit: return "concurrent-functions";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (VariantID) {
  case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 11 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jge";	 // "brel"
          return;
        case 'h':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "jhe";	 // "brhe"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "jgh";	 // "brhl"
            return;
          }
          break;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "jle";	 // "brle"
            return;
          case 'h':	 // 1 string to match.
            Mnemonic = "jlh";	 // "brlh"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "jgl";	 // "brll"
            return;
          }
          break;
        case 'm':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgm";	 // "brml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgo";	 // "brol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgp";	 // "brpl"
          return;
        case 'u':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jg";	 // "brul"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jgz";	 // "brzl"
          return;
        }
        break;
      case 5:	 // 13 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+3, "el", 2) != 0)
            break;
          Mnemonic = "jghe";	 // "brhel"
          return;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgle";	 // "brlel"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jglh";	 // "brlhl"
            return;
          }
          break;
        case 'n':	 // 10 strings to match.
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgne";	 // "brnel"
            return;
          case 'h':	 // 2 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "jnhe";	 // "brnhe"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "jgnh";	 // "brnhl"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            switch (Mnemonic[4]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "jnle";	 // "brnle"
              return;
            case 'h':	 // 1 string to match.
              Mnemonic = "jnlh";	 // "brnlh"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "jgnl";	 // "brnll"
              return;
            }
            break;
          case 'm':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnm";	 // "brnml"
            return;
          case 'o':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgno";	 // "brnol"
            return;
          case 'p':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnp";	 // "brnpl"
            return;
          case 'z':	 // 1 string to match.
            if (Mnemonic[4] != 'l')
              break;
            Mnemonic = "jgnz";	 // "brnzl"
            return;
          }
          break;
        }
        break;
      case 6:	 // 3 strings to match.
        if (memcmp(Mnemonic.data()+0, "brn", 3) != 0)
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+4, "el", 2) != 0)
            break;
          Mnemonic = "jgnhe";	 // "brnhel"
          return;
        case 'l':	 // 2 strings to match.
          switch (Mnemonic[4]) {
          default: break;
          case 'e':	 // 1 string to match.
            if (Mnemonic[5] != 'l')
              break;
            Mnemonic = "jgnle";	 // "brnlel"
            return;
          case 'h':	 // 1 string to match.
            if (Mnemonic[5] != 'l')
              break;
            Mnemonic = "jgnlh";	 // "brnlhl"
            return;
          }
          break;
        }
        break;
      }
    break;
  case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 8 strings to match.
        if (memcmp(Mnemonic.data()+0, "br", 2) != 0)
          break;
        switch (Mnemonic[2]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jle";	 // "brel"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlh";	 // "brhl"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jll";	 // "brll"
          return;
        case 'm':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlm";	 // "brml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlo";	 // "brol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlp";	 // "brpl"
          return;
        case 'u':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlu";	 // "brul"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[3] != 'l')
            break;
          Mnemonic = "jlz";	 // "brzl"
          return;
        }
        break;
      case 5:	 // 7 strings to match.
        if (memcmp(Mnemonic.data()+0, "brn", 3) != 0)
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'e':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlne";	 // "brnel"
          return;
        case 'h':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnh";	 // "brnhl"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnl";	 // "brnll"
          return;
        case 'm':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnm";	 // "brnml"
          return;
        case 'o':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlno";	 // "brnol"
          return;
        case 'p':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnp";	 // "brnpl"
          return;
        case 'z':	 // 1 string to match.
          if (Mnemonic[4] != 'l')
            break;
          Mnemonic = "jlnz";	 // "brnzl"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "jc", 2) != 0)
      break;
    Mnemonic = "brc";	 // "jc"
    return;
  case 3:	 // 11 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'b':	 // 8 strings to match.
      if (Mnemonic[1] != 'r')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "je";	 // "bre"
        return;
      case 'h':	 // 1 string to match.
        Mnemonic = "jh";	 // "brh"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jl";	 // "brl"
        return;
      case 'm':	 // 1 string to match.
        Mnemonic = "jm";	 // "brm"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jo";	 // "bro"
        return;
      case 'p':	 // 1 string to match.
        Mnemonic = "jp";	 // "brp"
        return;
      case 'u':	 // 1 string to match.
        Mnemonic = "j";	 // "bru"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jz";	 // "brz"
        return;
      }
      break;
    case 'j':	 // 3 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[2] != 's')
          break;
        Mnemonic = "bras";	 // "jas"
        return;
      case 'c':	 // 1 string to match.
        if (Mnemonic[2] != 't')
          break;
        Mnemonic = "brct";	 // "jct"
        return;
      case 'x':	 // 1 string to match.
        if (Mnemonic[2] != 'h')
          break;
        Mnemonic = "brxh";	 // "jxh"
        return;
      }
      break;
    }
    break;
  case 4:	 // 12 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'b':	 // 7 strings to match.
      if (memcmp(Mnemonic.data()+1, "rn", 2) != 0)
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jne";	 // "brne"
        return;
      case 'h':	 // 1 string to match.
        Mnemonic = "jnh";	 // "brnh"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jnl";	 // "brnl"
        return;
      case 'm':	 // 1 string to match.
        Mnemonic = "jnm";	 // "brnm"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jno";	 // "brno"
        return;
      case 'p':	 // 1 string to match.
        Mnemonic = "jnp";	 // "brnp"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jnz";	 // "brnz"
        return;
      }
      break;
    case 'j':	 // 5 strings to match.
      switch (Mnemonic[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+2, "sl", 2) != 0)
          break;
        Mnemonic = "brasl";	 // "jasl"
        return;
      case 'c':	 // 2 strings to match.
        if (Mnemonic[2] != 't')
          break;
        switch (Mnemonic[3]) {
        default: break;
        case 'g':	 // 1 string to match.
          Mnemonic = "brctg";	 // "jctg"
          return;
        case 'h':	 // 1 string to match.
          Mnemonic = "brcth";	 // "jcth"
          return;
        }
        break;
      case 'x':	 // 2 strings to match.
        switch (Mnemonic[2]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (Mnemonic[3] != 'g')
            break;
          Mnemonic = "brxhg";	 // "jxhg"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[3] != 'e')
            break;
          Mnemonic = "brxle";	 // "jxle"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "jxleg", 5) != 0)
      break;
    Mnemonic = "brxlg";	 // "jxleg"
    return;
  }
}

enum {
  Tie0_1_1,
  Tie1_1_1,
  Tie2_1_1,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie1_1_1 */ { 1, 1, 1 },
  /* Tie2_1_1 */ { 2, 1, 1 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addRegOperands,
  CVT_95_addBDXAddrOperands,
  CVT_95_addImmOperands,
  CVT_95_addBDAddrOperands,
  CVT_95_addBDLAddrOperands,
  CVT_95_addImmTLSOperands,
  CVT_95_addLXAAddrOperands,
  CVT_95_addBDRAddrOperands,
  CVT_imm_95_0,
  CVT_95_addBDVAddrOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP641_0__Tie0_1_1__FP641_1,
  Convert__FP641_0__FP641_1__FP641_2,
  Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP321_0__Tie0_1_1__FP321_1,
  Convert__GR321_0__Tie0_1_1__S32Imm1_1,
  Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GR641_0__Tie0_1_1__S32Imm1_1,
  Convert__GR641_0__Tie0_1_1__GR321_1,
  Convert__GR641_0__Tie0_1_1__S16Imm1_1,
  Convert__GR641_0__GR641_1__S16Imm1_2,
  Convert__GR641_0__Tie0_1_1__GR641_1,
  Convert__GR641_0__GR641_1__GR641_2,
  Convert__BDAddr64Disp202_0__S8Imm1_1,
  Convert__GRH321_0__GRH321_1__GRH321_2,
  Convert__GRH321_0__GRH321_1__GR321_2,
  Convert__GR321_0__Tie0_1_1__S16Imm1_1,
  Convert__GR321_0__GR321_1__S16Imm1_2,
  Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GRH321_0__Tie0_1_1__S32Imm1_1,
  Convert__GR321_0__Tie0_1_1__GR321_1,
  Convert__GR321_0__Tie0_1_1__U32Imm1_1,
  Convert__GR641_0__Tie0_1_1__U32Imm1_1,
  Convert__GR321_0__GR321_1__GR321_2,
  Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1,
  Convert__FP1281_0__Tie0_1_1__FP1281_1,
  Convert__FP1281_0__FP1281_1__FP1281_2,
  Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3,
  Convert__BDXAddr64Disp123_0,
  Convert__GR641_0__GR641_1,
  Convert__GR641_0__BDXAddr64Disp123_1,
  Convert__GR641_0__ADDR641_1,
  Convert__U4Imm1_0__BDXAddr64Disp123_1,
  Convert__U4Imm1_0__GR641_1,
  Convert__GR321_0__Tie0_1_1__GR641_1,
  Convert__ADDR641_0,
  Convert__BDXAddr64Disp203_0,
  Convert__U4Imm1_0__BDXAddr64Disp203_1,
  Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2,
  Convert__U4Imm1_0__PCRel121_1__PCRel241_2,
  Convert__GR641_0__PCRelTLS162_1,
  Convert__GR641_0__PCRelTLS322_1,
  Convert__U4Imm1_0__PCRel161_1,
  Convert__U4Imm1_0__PCRel321_1,
  Convert__GR321_0__Tie0_1_1__PCRel161_1,
  Convert__GR641_0__Tie0_1_1__PCRel161_1,
  Convert__GRH321_0__Tie0_1_1__PCRel321_1,
  Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2,
  Convert__GR321_0__BDXAddr64Disp123_1,
  Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__FP641_0__BDXAddr64Disp123_1,
  Convert__FP641_0__FP641_1,
  Convert__FP641_0__GR321_1,
  Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP641_0__GR641_1,
  Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2,
  Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2,
  Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2,
  Convert__FP321_0__BDXAddr64Disp123_1,
  Convert__FP321_0__FP321_1,
  Convert__FP321_0__GR321_1,
  Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP321_0__GR641_1,
  Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__FP1281_1,
  Convert__BDAddr64Disp122_0,
  Convert__GR321_0__U4Imm1_1__FP641_2,
  Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__GR321_0__U4Imm1_1__FP321_2,
  Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__GR321_0__S32Imm1_1,
  Convert__GR321_0__U4Imm1_1__FP1281_2,
  Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GR641_0__BDXAddr64Disp203_1,
  Convert__GR641_0__U4Imm1_1__FP641_2,
  Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__GR641_0__U4Imm1_1__FP321_2,
  Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__GR641_0__S32Imm1_1,
  Convert__GR641_0__GR321_1,
  Convert__GR641_0__PCRel321_1,
  Convert__GR641_0__S16Imm1_1,
  Convert__BDAddr64Disp122_0__S16Imm1_1,
  Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2,
  Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__S8Imm1_1__PCRel161_2,
  Convert__GR641_0__S16Imm1_1__U4Imm1_2,
  Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__GR641_1__BDAddr64Disp122_2,
  Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__GR641_1__PCRel161_2,
  Convert__GR641_0__GR641_1__U4Imm1_2,
  Convert__GR641_0__U4Imm1_1__FP1281_2,
  Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GRH321_0__BDXAddr64Disp203_1,
  Convert__GRH321_0__GRH321_1,
  Convert__GR321_0__S16Imm1_1,
  Convert__GRH321_0__GR321_1,
  Convert__GR321_0__PCRel321_1,
  Convert__GR321_0__BDXAddr64Disp203_1,
  Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__S32Imm1_1,
  Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__S8Imm1_1__PCRel161_2,
  Convert__GR321_0__S16Imm1_1__U4Imm1_2,
  Convert__GR321_0__GR1281_1__Tie0_1_1__Tie1_1_1,
  Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2,
  Convert__BDAddr64Disp122_0__U16Imm1_1,
  Convert__GR321_0__U32Imm1_1,
  Convert__GR321_0__U16Imm1_1__U4Imm1_2,
  Convert__GR321_0__U16Imm1_1,
  Convert__GR641_0__U32Imm1_1,
  Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2,
  Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR641_0__U8Imm1_1__PCRel161_2,
  Convert__GR641_0__U16Imm1_1__U4Imm1_2,
  Convert__GR641_0__U16Imm1_1,
  Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1,
  Convert__GR641_0__BDAddr64Disp202_1,
  Convert__BDAddr64Disp122_0__U8Imm1_1,
  Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__U32Imm1_1,
  Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__U8Imm1_1__PCRel161_2,
  Convert__BDAddr64Disp202_0__U8Imm1_1,
  Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__GR321_1,
  Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3,
  Convert__GR321_0__GR321_1__BDAddr64Disp122_2,
  Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3,
  Convert__GR321_0__GR321_1__PCRel161_2,
  Convert__GR321_0__GR321_1__U4Imm1_2,
  Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1,
  Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1,
  Convert__GR321_0__BDAddr64Disp202_1,
  Convert__FP641_0__FP641_2__FP641_1,
  Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2,
  Convert__AR321_0__AR321_1,
  Convert__GR1281_0__GR1281_2__GR641_1,
  Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3,
  Convert_NoOperands,
  Convert__GR641_0__FP641_1__U4Imm1_2,
  Convert__GR1281_0__Tie0_1_1__GR641_1,
  Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2,
  Convert__GR1281_0__FP1281_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR641_0__FP641_1,
  Convert__GR1281_0__FP1281_1,
  Convert__FP1281_0__GR321_1,
  Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3,
  Convert__FP1281_0__GR641_1,
  Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__GR1281_1,
  Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2,
  Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3,
  Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1,
  Convert__GR1281_0__Tie0_1_1__GR321_1,
  Convert__GR321_0__AR321_1,
  Convert__GR641_0__GR641_1__BDAddr32Disp202_2,
  Convert__GR321_0__GR641_1,
  Convert__GR641_0__FP1281_1,
  Convert__GR321_0,
  Convert__GR641_0,
  Convert__GR321_0__Tie0_1_1,
  Convert__GR1281_0__GR321_1,
  Convert__ADDR641_0__BDXAddr64Disp123_1,
  Convert__ADDR641_0__PCRel321_1,
  Convert__FP641_0__U4Imm1_1__FP641_2,
  Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__U4Imm1_1__FP321_2,
  Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3,
  Convert__FP1281_0__U4Imm1_1__FP1281_2,
  Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3,
  Convert__GR1281_0__GR641_1,
  Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2,
  Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2,
  Convert__GR641_0__GR641_2__GR641_1,
  Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3,
  Convert__FP641_0__GR641_2__FP641_1,
  Convert__FP1281_0__GR641_2__FP1281_1,
  Convert__GRH321_0__Tie0_1_1__U16Imm1_1,
  Convert__GR321_0__Tie0_1_1__U16Imm1_1,
  Convert__GR641_0__GR321_1__GR321_2,
  Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3,
  Convert__PCRel161_0,
  Convert__PCRel321_0,
  Convert__GR1281_1__GR641_0__Tie0_1_1,
  Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1,
  Convert__GR321_0__GR321_1__BDAddr64Disp202_2,
  Convert__GR641_0__GR641_1__BDAddr64Disp202_2,
  Convert__AR321_0__AR321_1__BDAddr64Disp122_2,
  Convert__AR321_0__AR321_1__BDAddr64Disp202_2,
  Convert__BDAddr64Disp122_0__BDAddr64Disp122_1,
  Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__CR641_0__CR641_1__BDAddr64Disp122_2,
  Convert__CR641_0__CR641_1__BDAddr64Disp202_2,
  Convert__FP641_0__FP321_1,
  Convert__FP641_0__FP321_1__U4Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1,
  Convert__FP641_0__FP1281_1,
  Convert__FP641_0__BDXAddr64Disp203_1,
  Convert__FP321_0__FP641_1,
  Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3,
  Convert__FP321_0__FP1281_1,
  Convert__FP321_0__BDXAddr64Disp203_1,
  Convert__GR641_0__LXAAddr64Disp203_1,
  Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3,
  Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2,
  Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__GRH321_1,
  Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1,
  Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GRH321_0__Tie0_1_1__S16Imm1_1,
  Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2,
  Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2,
  Convert__GR1281_0__BDXAddr64Disp203_1,
  Convert__BDAddr64Disp202_0,
  Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3,
  Convert__FP1281_0__BDXAddr64Disp123_1,
  Convert__FP1281_0__FP641_1,
  Convert__FP1281_0__FP641_1__U4Imm1_2,
  Convert__FP1281_0__FP321_1,
  Convert__FP641_0,
  Convert__FP321_0,
  Convert__FP1281_0,
  Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2,
  Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2,
  Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2,
  Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2,
  Convert__FP641_0__Tie0_1_1__FP321_1,
  Convert__GR1281_0__GR641_1__GR641_2,
  Convert__GR1281_0,
  Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2,
  Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1,
  Convert__FP1281_0__Tie0_1_1__FP641_1,
  Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2,
  Convert__FP641_0__FP641_1__BDXAddr64Disp123_2,
  Convert__FP1281_0__FP641_1__FP641_2,
  Convert__U4Imm1_0__U4Imm1_1,
  Convert__GRH321_0__Tie0_1_1__U32Imm1_1,
  Convert__GR641_0__GR641_1__imm_95_0,
  Convert__GR321_0__GR321_1__imm_95_0,
  Convert__GR641_1__GR321_0__Tie0_1_1,
  Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1,
  Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3,
  Convert__GR641_0__Tie0_1_1,
  Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3,
  Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3,
  Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3,
  Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3,
  Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4,
  Convert__GR321_0__GR321_1__BDAddr32Disp202_2,
  Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3,
  Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3,
  Convert__AR321_0__GR321_1,
  Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3,
  Convert__GRH321_0__GRH321_2__GRH321_1,
  Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3,
  Convert__GR321_0__GR321_2__GR321_1,
  Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1,
  Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1,
  Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2,
  Convert__BDAddr32Disp122_0,
  Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2,
  Convert__GR321_0__GR641_1__U4Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0,
  Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__GRH321_0__BDAddr64Disp202_1,
  Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2,
  Convert__U8Imm1_0,
  Convert__FP321_0__U4Imm1_1__FP641_2,
  Convert__GRH321_0__U16Imm1_1,
  Convert__BDLAddr64Disp12Len43_0,
  Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1,
  Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2,
  Convert__GR641_1__GR1281_0__Tie1_1_1,
  Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__VR1281_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3,
  Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U4Imm1_2,
  Convert__VR1281_0__VR1281_1,
  Convert__GR321_0__VR1281_1__U4Imm1_2,
  Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__GR641_0__VR1281_1__U4Imm1_2,
  Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3,
  Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5,
  Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U12Imm1_2,
  Convert__VR1281_0__U16Imm1_1,
  Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3,
  Convert__VR1281_0__U8Imm1_1__U8Imm1_2,
  Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0,
  Convert__VR1281_0__VR1281_1__imm_95_0,
  Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2,
  Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2,
  Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__GR641_0__VR1281_1__BDAddr32Disp122_2,
  Convert__VR1281_0__U16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__GR321_1__BDAddr64Disp122_2,
  Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2,
  Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3,
  Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2,
  Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3,
  Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2,
  Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2,
  Convert__VR1281_0__GR641_1__GR641_2,
  Convert__VR1281_0__VR1281_1__VR1281_1,
  Convert__VR1281_0,
  Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4,
  Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3,
  Convert__VR1281_0__VR1281_1__U16Imm1_2,
  Convert__VR1281_0__S16Imm1_1__U4Imm1_2,
  Convert__VR1281_0__S16Imm1_1,
  Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3,
  Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2,
  Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0,
  Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0,
  Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3,
  Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__VR641_2,
  Convert__VR321_0__VR321_1__VR321_2,
  Convert__VR641_0__VR641_1,
  Convert__VR321_0__VR321_1,
  Convert__VR1281_0__VR641_1,
  Convert__VR641_0__VR321_1,
  Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__VR641_2__VR641_3,
  Convert__VR321_0__VR321_1__VR321_2__VR321_3,
  Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3,
  Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3,
  Convert__VR641_0__VR641_1__U4Imm1_2,
  Convert__VR321_0__VR321_1__U4Imm1_2,
  Convert__VR641_0__VR641_1__U12Imm1_2,
  Convert__VR321_0__VR321_1__U12Imm1_2,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__S16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp202_0__S8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_1__GRH321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GRH321_0__GRH321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__S16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP1281_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__BDXAddr64Disp123_0
  { CVT_95_addBDXAddrOperands, 1, CVT_Done },
  // Convert__GR641_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__ADDR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__BDXAddr64Disp123_1
  { CVT_95_addImmOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__GR641_1
  { CVT_95_addImmOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__ADDR641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__BDXAddr64Disp203_0
  { CVT_95_addBDXAddrOperands, 1, CVT_Done },
  // Convert__U4Imm1_0__BDXAddr64Disp203_1
  { CVT_95_addImmOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__U4Imm1_0__PCRel121_1__PCRel241_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__PCRelTLS162_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmTLSOperands, 2, CVT_Done },
  // Convert__GR641_0__PCRelTLS322_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmTLSOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel161_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__U4Imm1_0__PCRel321_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__PCRel161_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__PCRel161_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP321_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__S16Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__S8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__GR641_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GRH321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__S32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__S8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__GR1281_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp122_0__U16Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__U8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__U8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__U8Imm1_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp202_0__U8Imm1_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_1__PCRel161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__GR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP641_2__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__GR641_0__FP641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR1281_0__FP1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__GR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__GR321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__AR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__GR641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__GR321_0__Tie0_1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__GR1281_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__ADDR641_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__ADDR641_0__PCRel321_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__FP1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR1281_0__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_2__GR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP641_0__GR641_2__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__GR641_2__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR321_1__GR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__PCRel161_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__PCRel321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR1281_1__GR641_0__Tie0_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Tied, Tie2_1_1, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__AR321_0__AR321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDAddr64Disp122_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__CR641_0__CR641_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__CR641_0__CR641_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__FP321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP641_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP321_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP321_0__FP1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP321_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__LXAAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addLXAAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__GR1281_0__BDXAddr64Disp203_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__BDAddr64Disp202_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP641_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP321_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP641_0__Tie0_1_1__FP321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR1281_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GR1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2
  { CVT_95_addBDRAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__Tie0_1_1__FP641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__FP1281_0__FP641_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__U4Imm1_0__U4Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__U32Imm1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR641_0__GR641_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR321_0__GR321_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR641_1__GR321_0__Tie0_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1
  { CVT_95_addBDAddrOperands, 1, CVT_95_addBDLAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addBDAddrOperands, 4, CVT_Done },
  // Convert__GR641_0__Tie0_1_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__GR321_0__GR321_1__BDAddr32Disp202_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AR321_0__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GRH321_0__GRH321_2__GRH321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR321_0__GR321_2__GR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDXAddrOperands, 3, CVT_Done },
  // Convert__BDAddr32Disp122_0
  { CVT_95_addBDAddrOperands, 1, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2
  { CVT_95_addBDLAddrOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__GR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GRH321_0__BDAddr64Disp202_1
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_Done },
  // Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__U8Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__FP321_0__U4Imm1_1__FP641_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GRH321_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__BDLAddr64Disp12Len43_0
  { CVT_95_addBDLAddrOperands, 1, CVT_Done },
  // Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Tied, Tie0_1_1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_1__GR1281_0__Tie1_1_1
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie1_1_1, CVT_Done },
  // Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2
  { CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 1, CVT_Tied, Tie1_1_1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GR321_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__VR1281_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__U16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__U8Imm1_1__U8Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__GR641_0__VR1281_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__U16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__GR321_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 2, CVT_95_addBDAddrOperands, 3, CVT_Done },
  // Convert__VR1281_0__GR641_1__GR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR1281_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__VR1281_1__U16Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__S16Imm1_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__S16Imm1_1
  { CVT_95_addRegOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDVAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addBDXAddrOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_imm_95_0, 0, CVT_Done },
  // Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__VR641_0__VR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR321_0__VR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR1281_0__VR641_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR641_0__VR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2__VR641_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2__VR321_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__VR641_0__VR641_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__U4Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR641_0__VR641_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__VR321_0__VR321_1__U12Imm1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
};

void SystemZAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1);
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addRegOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addBDXAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDXAddrOperands(Inst, 3);
      break;
    case CVT_95_addImmOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addBDAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDAddrOperands(Inst, 2);
      break;
    case CVT_95_addBDLAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDLAddrOperands(Inst, 3);
      break;
    case CVT_95_addImmTLSOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addImmTLSOperands(Inst, 2);
      break;
    case CVT_95_addLXAAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addLXAAddrOperands(Inst, 3);
      break;
    case CVT_95_addBDRAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDRAddrOperands(Inst, 3);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addBDVAddrOperands:
      static_cast<SystemZOperand &>(*Operands[OpIdx]).addBDVAddrOperands(Inst, 3);
      break;
    }
  }
}

void SystemZAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBDXAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addBDAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addBDLAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addImmTLSOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addLXAAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_95_addBDRAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addBDVAddrOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 3;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK_LAST_TOKEN = OptionalMatchClass,
  MCK_CCR, // register class 'CCR'
  MCK_FPCRegs, // register class 'FPCRegs'
  MCK_ADDR128Bit, // register class 'ADDR128Bit'
  MCK_FP128Bit, // register class 'FP128Bit'
  MCK_GR128Bit, // register class 'GR128Bit'
  MCK_ADDR32Bit, // register class 'ADDR32Bit'
  MCK_ADDR64Bit, // register class 'ADDR64Bit'
  MCK_AR32Bit, // register class 'AR32Bit'
  MCK_CR64Bit, // register class 'CR64Bit'
  MCK_FP16Bit, // register class 'FP16Bit'
  MCK_FP32Bit, // register class 'FP32Bit'
  MCK_FP64Bit, // register class 'FP64Bit'
  MCK_GR32Bit, // register class 'GR32Bit'
  MCK_GR64Bit, // register class 'GR64Bit'
  MCK_GRH32Bit, // register class 'GRH32Bit'
  MCK_VF128Bit, // register class 'VF128Bit'
  MCK_Reg15, // derived register class
  MCK_GRX32Bit, // register class 'GRX32Bit'
  MCK_VR128Bit, // register class 'VR128Bit'
  MCK_VR16Bit, // register class 'VR16Bit'
  MCK_VR32Bit, // register class 'VR32Bit'
  MCK_VR64Bit, // register class 'VR64Bit'
  MCK_AnyRegBit, // register class 'AnyRegBit'
  MCK_LAST_REGISTER = MCK_AnyRegBit,
  MCK_ADDR128, // user defined class 'ADDR128AsmOperand'
  MCK_ADDR32, // user defined class 'ADDR32AsmOperand'
  MCK_ADDR64, // user defined class 'ADDR64AsmOperand'
  MCK_AR32, // user defined class 'AR32AsmOperand'
  MCK_AnyReg, // user defined class 'AnyRegAsmOperand'
  MCK_BDAddr32Disp12, // user defined class 'BDAddr32Disp12'
  MCK_BDAddr32Disp20, // user defined class 'BDAddr32Disp20'
  MCK_BDAddr64Disp12, // user defined class 'BDAddr64Disp12'
  MCK_BDAddr64Disp20, // user defined class 'BDAddr64Disp20'
  MCK_BDLAddr64Disp12Len4, // user defined class 'BDLAddr64Disp12Len4'
  MCK_BDLAddr64Disp12Len8, // user defined class 'BDLAddr64Disp12Len8'
  MCK_BDRAddr64Disp12, // user defined class 'BDRAddr64Disp12'
  MCK_BDVAddr64Disp12, // user defined class 'BDVAddr64Disp12'
  MCK_BDXAddr64Disp12, // user defined class 'BDXAddr64Disp12'
  MCK_BDXAddr64Disp20, // user defined class 'BDXAddr64Disp20'
  MCK_CR64, // user defined class 'CR64AsmOperand'
  MCK_FP128, // user defined class 'FP128AsmOperand'
  MCK_FP16, // user defined class 'FP16AsmOperand'
  MCK_FP32, // user defined class 'FP32AsmOperand'
  MCK_FP64, // user defined class 'FP64AsmOperand'
  MCK_GR128, // user defined class 'GR128AsmOperand'
  MCK_GR32, // user defined class 'GR32AsmOperand'
  MCK_GR64, // user defined class 'GR64AsmOperand'
  MCK_GRH32, // user defined class 'GRH32AsmOperand'
  MCK_GRX32, // user defined class 'GRX32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_LXAAddr64Disp20, // user defined class 'LXAAddr64Disp20'
  MCK_PCRel12, // user defined class 'PCRel12'
  MCK_PCRel16, // user defined class 'PCRel16'
  MCK_PCRel24, // user defined class 'PCRel24'
  MCK_PCRel32, // user defined class 'PCRel32'
  MCK_PCRelTLS16, // user defined class 'PCRelTLS16'
  MCK_PCRelTLS32, // user defined class 'PCRelTLS32'
  MCK_S16Imm, // user defined class 'S16Imm'
  MCK_S32Imm, // user defined class 'S32Imm'
  MCK_S8Imm, // user defined class 'S8Imm'
  MCK_U12Imm, // user defined class 'U12Imm'
  MCK_U16Imm, // user defined class 'U16Imm'
  MCK_U1Imm, // user defined class 'U1Imm'
  MCK_U2Imm, // user defined class 'U2Imm'
  MCK_U32Imm, // user defined class 'U32Imm'
  MCK_U3Imm, // user defined class 'U3Imm'
  MCK_U48Imm, // user defined class 'U48Imm'
  MCK_U4Imm, // user defined class 'U4Imm'
  MCK_U8Imm, // user defined class 'U8Imm'
  MCK_VF128, // user defined class 'VF128AsmOperand'
  MCK_VR128, // user defined class 'VR128AsmOperand'
  MCK_VR16, // user defined class 'VR16AsmOperand'
  MCK_VR32, // user defined class 'VR32AsmOperand'
  MCK_VR64, // user defined class 'VR64AsmOperand'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 6, 1},
    {1, 0, 0},
    {1, 0, 0},
    {1, 14, 6},
    {7, 15, 10},
    {17, 0, 0},
    {17, 0, 0},
    {17, 21, 1},
    {18, 22, 1},
    {19, 18, 7},
    {26, 19, 1},
    {27, 24, 1},
    {28, 19, 1},
    {29, 18, 7},
    {36, 24, 1},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
    {37, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0xC3,
    0x00,
    0x0F,
    0xBF,
    0x18,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  SystemZOperand &Operand = (SystemZOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_ADDR128: {
    DiagnosticPredicate DP(Operand.isADDR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ADDR32: {
    DiagnosticPredicate DP(Operand.isADDR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ADDR64: {
    DiagnosticPredicate DP(Operand.isADDR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AR32: {
    DiagnosticPredicate DP(Operand.isAR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AnyReg: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr32Disp12: {
    DiagnosticPredicate DP(Operand.isBDAddr32Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr32Disp20: {
    DiagnosticPredicate DP(Operand.isBDAddr32Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isBDAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDLAddr64Disp12Len4: {
    DiagnosticPredicate DP(Operand.isBDLAddr64Disp12Len4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDLAddr64Disp12Len8: {
    DiagnosticPredicate DP(Operand.isBDLAddr64Disp12Len8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDRAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDRAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDVAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDVAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDXAddr64Disp12: {
    DiagnosticPredicate DP(Operand.isBDXAddr64Disp12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BDXAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isBDXAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_CR64: {
    DiagnosticPredicate DP(Operand.isCR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP128: {
    DiagnosticPredicate DP(Operand.isFP128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP16: {
    DiagnosticPredicate DP(Operand.isFP16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP32: {
    DiagnosticPredicate DP(Operand.isFP32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FP64: {
    DiagnosticPredicate DP(Operand.isFP64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR128: {
    DiagnosticPredicate DP(Operand.isGR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR32: {
    DiagnosticPredicate DP(Operand.isGR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GR64: {
    DiagnosticPredicate DP(Operand.isGR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GRH32: {
    DiagnosticPredicate DP(Operand.isGRH32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GRX32: {
    DiagnosticPredicate DP(Operand.isGRX32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_LXAAddr64Disp20: {
    DiagnosticPredicate DP(Operand.isLXAAddr64Disp20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel12: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel16: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel24: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRel32: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRelTLS16: {
    DiagnosticPredicate DP(Operand.isImmTLS());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_PCRelTLS32: {
    DiagnosticPredicate DP(Operand.isImmTLS());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S16Imm: {
    DiagnosticPredicate DP(Operand.isS16Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S32Imm: {
    DiagnosticPredicate DP(Operand.isS32Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_S8Imm: {
    DiagnosticPredicate DP(Operand.isS8Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U12Imm: {
    DiagnosticPredicate DP(Operand.isU12Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U16Imm: {
    DiagnosticPredicate DP(Operand.isU16Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U1Imm: {
    DiagnosticPredicate DP(Operand.isU1Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U2Imm: {
    DiagnosticPredicate DP(Operand.isU2Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U32Imm: {
    DiagnosticPredicate DP(Operand.isU32Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U3Imm: {
    DiagnosticPredicate DP(Operand.isU3Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U48Imm: {
    DiagnosticPredicate DP(Operand.isU48Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U4Imm: {
    DiagnosticPredicate DP(Operand.isU4Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_U8Imm: {
    DiagnosticPredicate DP(Operand.isU8Imm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VF128: {
    DiagnosticPredicate DP(Operand.isVF128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR128: {
    DiagnosticPredicate DP(Operand.isVR128());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR16: {
    DiagnosticPredicate DP(Operand.isVR16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR32: {
    DiagnosticPredicate DP(Operand.isVR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VR64: {
    DiagnosticPredicate DP(Operand.isVR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[SystemZ::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      MCK_CCR,
      MCK_FPCRegs,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_AR32Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_CR64Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VF128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_VR128Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_FP64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_VR64Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_FP16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_VR16Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP128Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_FP32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_VR32Bit,
      MCK_GR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_ADDR64Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GRH32Bit,
      MCK_GR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_ADDR32Bit,
      MCK_GR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
      MCK_ADDR128Bit,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK_CCR: return "MCK_CCR";
  case MCK_FPCRegs: return "MCK_FPCRegs";
  case MCK_ADDR128Bit: return "MCK_ADDR128Bit";
  case MCK_FP128Bit: return "MCK_FP128Bit";
  case MCK_GR128Bit: return "MCK_GR128Bit";
  case MCK_ADDR32Bit: return "MCK_ADDR32Bit";
  case MCK_ADDR64Bit: return "MCK_ADDR64Bit";
  case MCK_AR32Bit: return "MCK_AR32Bit";
  case MCK_CR64Bit: return "MCK_CR64Bit";
  case MCK_FP16Bit: return "MCK_FP16Bit";
  case MCK_FP32Bit: return "MCK_FP32Bit";
  case MCK_FP64Bit: return "MCK_FP64Bit";
  case MCK_GR32Bit: return "MCK_GR32Bit";
  case MCK_GR64Bit: return "MCK_GR64Bit";
  case MCK_GRH32Bit: return "MCK_GRH32Bit";
  case MCK_VF128Bit: return "MCK_VF128Bit";
  case MCK_Reg15: return "MCK_Reg15";
  case MCK_GRX32Bit: return "MCK_GRX32Bit";
  case MCK_VR128Bit: return "MCK_VR128Bit";
  case MCK_VR16Bit: return "MCK_VR16Bit";
  case MCK_VR32Bit: return "MCK_VR32Bit";
  case MCK_VR64Bit: return "MCK_VR64Bit";
  case MCK_AnyRegBit: return "MCK_AnyRegBit";
  case MCK_ADDR128: return "MCK_ADDR128";
  case MCK_ADDR32: return "MCK_ADDR32";
  case MCK_ADDR64: return "MCK_ADDR64";
  case MCK_AR32: return "MCK_AR32";
  case MCK_AnyReg: return "MCK_AnyReg";
  case MCK_BDAddr32Disp12: return "MCK_BDAddr32Disp12";
  case MCK_BDAddr32Disp20: return "MCK_BDAddr32Disp20";
  case MCK_BDAddr64Disp12: return "MCK_BDAddr64Disp12";
  case MCK_BDAddr64Disp20: return "MCK_BDAddr64Disp20";
  case MCK_BDLAddr64Disp12Len4: return "MCK_BDLAddr64Disp12Len4";
  case MCK_BDLAddr64Disp12Len8: return "MCK_BDLAddr64Disp12Len8";
  case MCK_BDRAddr64Disp12: return "MCK_BDRAddr64Disp12";
  case MCK_BDVAddr64Disp12: return "MCK_BDVAddr64Disp12";
  case MCK_BDXAddr64Disp12: return "MCK_BDXAddr64Disp12";
  case MCK_BDXAddr64Disp20: return "MCK_BDXAddr64Disp20";
  case MCK_CR64: return "MCK_CR64";
  case MCK_FP128: return "MCK_FP128";
  case MCK_FP16: return "MCK_FP16";
  case MCK_FP32: return "MCK_FP32";
  case MCK_FP64: return "MCK_FP64";
  case MCK_GR128: return "MCK_GR128";
  case MCK_GR32: return "MCK_GR32";
  case MCK_GR64: return "MCK_GR64";
  case MCK_GRH32: return "MCK_GRH32";
  case MCK_GRX32: return "MCK_GRX32";
  case MCK_Imm: return "MCK_Imm";
  case MCK_LXAAddr64Disp20: return "MCK_LXAAddr64Disp20";
  case MCK_PCRel12: return "MCK_PCRel12";
  case MCK_PCRel16: return "MCK_PCRel16";
  case MCK_PCRel24: return "MCK_PCRel24";
  case MCK_PCRel32: return "MCK_PCRel32";
  case MCK_PCRelTLS16: return "MCK_PCRelTLS16";
  case MCK_PCRelTLS32: return "MCK_PCRelTLS32";
  case MCK_S16Imm: return "MCK_S16Imm";
  case MCK_S32Imm: return "MCK_S32Imm";
  case MCK_S8Imm: return "MCK_S8Imm";
  case MCK_U12Imm: return "MCK_U12Imm";
  case MCK_U16Imm: return "MCK_U16Imm";
  case MCK_U1Imm: return "MCK_U1Imm";
  case MCK_U2Imm: return "MCK_U2Imm";
  case MCK_U32Imm: return "MCK_U32Imm";
  case MCK_U3Imm: return "MCK_U3Imm";
  case MCK_U48Imm: return "MCK_U48Imm";
  case MCK_U4Imm: return "MCK_U4Imm";
  case MCK_U8Imm: return "MCK_U8Imm";
  case MCK_VF128: return "MCK_VF128";
  case MCK_VR128: return "MCK_VR128";
  case MCK_VR16: return "MCK_VR16";
  case MCK_VR32: return "MCK_VR32";
  case MCK_VR64: return "MCK_VR64";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset SystemZAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[SystemZ::FeatureSoftFloat])
    Features.set(Feature_FeatureSoftFloatBit);
  if (FB[SystemZ::FeatureBackChain])
    Features.set(Feature_FeatureBackChainBit);
  if (FB[SystemZ::FeatureUnalignedSymbols])
    Features.set(Feature_FeatureUnalignedSymbolsBit);
  if (FB[SystemZ::FeatureDistinctOps])
    Features.set(Feature_FeatureDistinctOpsBit);
  if (FB[SystemZ::FeatureFastSerialization])
    Features.set(Feature_FeatureFastSerializationBit);
  if (FB[SystemZ::FeatureFPExtension])
    Features.set(Feature_FeatureFPExtensionBit);
  if (FB[SystemZ::FeatureHighWord])
    Features.set(Feature_FeatureHighWordBit);
  if (FB[SystemZ::FeatureInterlockedAccess1])
    Features.set(Feature_FeatureInterlockedAccess1Bit);
  if (FB[SystemZ::FeatureLoadStoreOnCond])
    Features.set(Feature_FeatureLoadStoreOnCondBit);
  if (FB[SystemZ::FeaturePopulationCount])
    Features.set(Feature_FeaturePopulationCountBit);
  if (FB[SystemZ::FeatureMessageSecurityAssist3])
    Features.set(Feature_FeatureMessageSecurityAssist3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist4])
    Features.set(Feature_FeatureMessageSecurityAssist4Bit);
  if (FB[SystemZ::FeatureResetReferenceBitsMultiple])
    Features.set(Feature_FeatureResetReferenceBitsMultipleBit);
  if (FB[SystemZ::FeatureExecutionHint])
    Features.set(Feature_FeatureExecutionHintBit);
  if (FB[SystemZ::FeatureLoadAndTrap])
    Features.set(Feature_FeatureLoadAndTrapBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions])
    Features.set(Feature_FeatureMiscellaneousExtensionsBit);
  if (FB[SystemZ::FeatureProcessorAssist])
    Features.set(Feature_FeatureProcessorAssistBit);
  if (FB[SystemZ::FeatureTransactionalExecution])
    Features.set(Feature_FeatureTransactionalExecutionBit);
  if (FB[SystemZ::FeatureDFPZonedConversion])
    Features.set(Feature_FeatureDFPZonedConversionBit);
  if (FB[SystemZ::FeatureEnhancedDAT2])
    Features.set(Feature_FeatureEnhancedDAT2Bit);
  if (FB[SystemZ::FeatureLoadAndZeroRightmostByte])
    Features.set(Feature_FeatureLoadAndZeroRightmostByteBit);
  if (FB[SystemZ::FeatureLoadStoreOnCond2])
    Features.set(Feature_FeatureLoadStoreOnCond2Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist5])
    Features.set(Feature_FeatureMessageSecurityAssist5Bit);
  if (FB[SystemZ::FeatureDFPPackedConversion])
    Features.set(Feature_FeatureDFPPackedConversionBit);
  if (FB[SystemZ::FeatureVector])
    Features.set(Feature_FeatureVectorBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions2])
    Features.set(Feature_FeatureMiscellaneousExtensions2Bit);
  if (FB[SystemZ::FeatureGuardedStorage])
    Features.set(Feature_FeatureGuardedStorageBit);
  if (FB[SystemZ::FeatureMessageSecurityAssist7])
    Features.set(Feature_FeatureMessageSecurityAssist7Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist8])
    Features.set(Feature_FeatureMessageSecurityAssist8Bit);
  if (FB[SystemZ::FeatureVectorEnhancements1])
    Features.set(Feature_FeatureVectorEnhancements1Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimal])
    Features.set(Feature_FeatureVectorPackedDecimalBit);
  if (FB[SystemZ::FeatureInsertReferenceBitsMultiple])
    Features.set(Feature_FeatureInsertReferenceBitsMultipleBit);
  if (FB[SystemZ::FeatureTestPendingExternalInterruption])
    Features.set(Feature_FeatureTestPendingExternalInterruptionBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions3])
    Features.set(Feature_FeatureMiscellaneousExtensions3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist9])
    Features.set(Feature_FeatureMessageSecurityAssist9Bit);
  if (FB[SystemZ::FeatureVectorEnhancements2])
    Features.set(Feature_FeatureVectorEnhancements2Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancementBit);
  if (FB[SystemZ::FeatureEnhancedSort])
    Features.set(Feature_FeatureEnhancedSortBit);
  if (FB[SystemZ::FeatureDeflateConversion])
    Features.set(Feature_FeatureDeflateConversionBit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement2])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancement2Bit);
  if (FB[SystemZ::FeatureNNPAssist])
    Features.set(Feature_FeatureNNPAssistBit);
  if (FB[SystemZ::FeatureBEAREnhancement])
    Features.set(Feature_FeatureBEAREnhancementBit);
  if (FB[SystemZ::FeatureResetDATProtection])
    Features.set(Feature_FeatureResetDATProtectionBit);
  if (FB[SystemZ::FeatureProcessorActivityInstrumentation])
    Features.set(Feature_FeatureProcessorActivityInstrumentationBit);
  if (FB[SystemZ::FeatureMiscellaneousExtensions4])
    Features.set(Feature_FeatureMiscellaneousExtensions4Bit);
  if (FB[SystemZ::FeatureVectorEnhancements3])
    Features.set(Feature_FeatureVectorEnhancements3Bit);
  if (FB[SystemZ::FeatureVectorPackedDecimalEnhancement3])
    Features.set(Feature_FeatureVectorPackedDecimalEnhancement3Bit);
  if (FB[SystemZ::FeatureMessageSecurityAssist12])
    Features.set(Feature_FeatureMessageSecurityAssist12Bit);
  if (FB[SystemZ::FeatureConcurrentFunctions])
    Features.set(Feature_FeatureConcurrentFunctionsBit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const SystemZAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\001a\002ad\003adb\004adbr\003adr\004adtr\005adtra\002ae\003aeb\004aebr"
    "\003aer\003afi\002ag\003agf\004agfi\004agfr\003agh\004aghi\005aghik\003"
    "agr\004agrk\004agsi\002ah\005ahhhr\005ahhlr\003ahi\004ahik\003ahy\003ai"
    "h\002al\003alc\004alcg\005alcgr\004alcr\004alfi\003alg\004algf\005algfi"
    "\005algfr\007alghsik\004algr\005algrk\005algsi\006alhhhr\006alhhlr\006a"
    "lhsik\003alr\004alrk\004alsi\005alsih\006alsihn\003aly\002ap\002ar\003a"
    "rk\003asi\002au\003aur\002aw\003awr\004axbr\003axr\004axtr\005axtra\002"
    "ay\001b\004bakr\003bal\004balr\003bas\004basr\005bassm\002bc\003bcr\003"
    "bct\004bctg\005bctgr\004bctr\005bdepg\002be\003ber\005bextg\002bh\003bh"
    "e\004bher\003bhr\002bi\003bic\003bie\003bih\004bihe\003bil\004bile\004b"
    "ilh\003bim\004bine\004binh\005binhe\004binl\005binle\005binlh\004binm\004"
    "bino\004binp\004binz\003bio\003bip\003biz\002bl\003ble\004bler\003blh\004"
    "blhr\003blr\002bm\003bmr\003bne\004bner\003bnh\004bnhe\005bnher\004bnhr"
    "\003bnl\004bnle\005bnler\004bnlh\005bnlhr\004bnlr\003bnm\004bnmr\003bno"
    "\004bnor\003bnp\004bnpr\003bnz\004bnzr\002bo\003bor\002bp\003bpp\003bpr"
    "\004bprp\002br\004bras\005brasl\003brc\004brcl\004brct\005brctg\005brct"
    "h\004brxh\005brxhg\005brxle\005brxlg\003bsa\003bsg\003bsm\003bxh\004bxh"
    "g\004bxle\005bxleg\002bz\003bzr\001c\003cal\004calg\005calgf\002cd\003c"
    "db\004cdbr\005cdfbr\006cdfbra\004cdfr\005cdftr\005cdgbr\006cdgbra\004cd"
    "gr\005cdgtr\006cdgtra\006cdlfbr\006cdlftr\006cdlgbr\006cdlgtr\004cdpt\003"
    "cdr\003cds\004cdsg\005cdstr\004cdsy\004cdtr\005cdutr\004cdzt\002ce\003c"
    "eb\004cebr\005cedtr\005cefbr\006cefbra\004cefr\005cegbr\006cegbra\004ce"
    "gr\006celfbr\006celgbr\003cer\005cextr\003cfc\005cfdbr\006cfdbra\004cfd"
    "r\005cfdtr\005cfebr\006cfebra\004cfer\003cfi\005cfxbr\006cfxbra\004cfxr"
    "\005cfxtr\002cg\005cgdbr\006cgdbra\004cgdr\005cgdtr\006cgdtra\005cgebr\006"
    "cgebra\004cger\003cgf\004cgfi\004cgfr\005cgfrl\003cgh\004cghi\005cghrl\005"
    "cghsi\004cgib\005cgibe\005cgibh\006cgibhe\005cgibl\006cgible\006cgiblh\006"
    "cgibne\006cgibnh\007cgibnhe\006cgibnl\007cgibnle\007cgibnlh\004cgij\005"
    "cgije\005cgijh\006cgijhe\005cgijl\006cgijle\006cgijlh\006cgijne\006cgij"
    "nh\007cgijnhe\006cgijnl\007cgijnle\007cgijnlh\004cgit\005cgite\005cgith"
    "\006cgithe\005cgitl\006cgitle\006cgitlh\006cgitne\006cgitnh\007cgitnhe\006"
    "cgitnl\007cgitnle\007cgitnlh\003cgr\004cgrb\005cgrbe\005cgrbh\006cgrbhe"
    "\005cgrbl\006cgrble\006cgrblh\006cgrbne\006cgrbnh\007cgrbnhe\006cgrbnl\007"
    "cgrbnle\007cgrbnlh\004cgrj\005cgrje\005cgrjh\006cgrjhe\005cgrjl\006cgrj"
    "le\006cgrjlh\006cgrjne\006cgrjnh\007cgrjnhe\006cgrjnl\007cgrjnle\007cgr"
    "jnlh\004cgrl\004cgrt\005cgrte\005cgrth\006cgrthe\005cgrtl\006cgrtle\006"
    "cgrtlh\006cgrtne\006cgrtnh\007cgrtnhe\006cgrtnl\007cgrtnle\007cgrtnlh\005"
    "cgxbr\006cgxbra\004cgxr\005cgxtr\006cgxtra\002ch\003chf\004chhr\005chhs"
    "i\003chi\004chlr\004chrl\004chsi\003chy\003cib\004cibe\004cibh\005cibhe"
    "\004cibl\005cible\005ciblh\005cibne\005cibnh\006cibnhe\005cibnl\006cibn"
    "le\006cibnlh\003cih\003cij\004cije\004cijh\005cijhe\004cijl\005cijle\005"
    "cijlh\005cijne\005cijnh\006cijnhe\005cijnl\006cijnle\006cijnlh\003cit\004"
    "cite\004cith\005cithe\004citl\005citle\005citlh\005citne\005citnh\006ci"
    "tnhe\005citnl\006citnle\006citnlh\004cksm\002cl\003clc\004clcl\005clcle"
    "\005clclu\006clfdbr\006clfdtr\006clfebr\006clfhsi\004clfi\005clfit\006c"
    "lfite\006clfith\007clfithe\006clfitl\007clfitle\007clfitlh\007clfitne\007"
    "clfitnh\010clfitnhe\007clfitnl\010clfitnle\010clfitnlh\006clfxbr\006clf"
    "xtr\003clg\006clgdbr\006clgdtr\006clgebr\004clgf\005clgfi\005clgfr\006c"
    "lgfrl\006clghrl\006clghsi\005clgib\006clgibe\006clgibh\007clgibhe\006cl"
    "gibl\007clgible\007clgiblh\007clgibne\007clgibnh\010clgibnhe\007clgibnl"
    "\010clgibnle\010clgibnlh\005clgij\006clgije\006clgijh\007clgijhe\006clg"
    "ijl\007clgijle\007clgijlh\007clgijne\007clgijnh\010clgijnhe\007clgijnl\010"
    "clgijnle\010clgijnlh\005clgit\006clgite\006clgith\007clgithe\006clgitl\007"
    "clgitle\007clgitlh\007clgitne\007clgitnh\010clgitnhe\007clgitnl\010clgi"
    "tnle\010clgitnlh\004clgr\005clgrb\006clgrbe\006clgrbh\007clgrbhe\006clg"
    "rbl\007clgrble\007clgrblh\007clgrbne\007clgrbnh\010clgrbnhe\007clgrbnl\010"
    "clgrbnle\010clgrbnlh\005clgrj\006clgrje\006clgrjh\007clgrjhe\006clgrjl\007"
    "clgrjle\007clgrjlh\007clgrjne\007clgrjnh\010clgrjnhe\007clgrjnl\010clgr"
    "jnle\010clgrjnlh\005clgrl\005clgrt\006clgrte\006clgrth\007clgrthe\006cl"
    "grtl\007clgrtle\007clgrtlh\007clgrtne\007clgrtnh\010clgrtnhe\007clgrtnl"
    "\010clgrtnle\010clgrtnlh\004clgt\005clgte\005clgth\006clgthe\005clgtl\006"
    "clgtle\006clgtlh\006clgtne\006clgtnh\007clgtnhe\006clgtnl\007clgtnle\007"
    "clgtnlh\006clgxbr\006clgxtr\004clhf\005clhhr\006clhhsi\005clhlr\005clhr"
    "l\003cli\004clib\005clibe\005clibh\006clibhe\005clibl\006clible\006clib"
    "lh\006clibne\006clibnh\007clibnhe\006clibnl\007clibnle\007clibnlh\004cl"
    "ih\004clij\005clije\005clijh\006clijhe\005clijl\006clijle\006clijlh\006"
    "clijne\006clijnh\007clijnhe\006clijnl\007clijnle\007clijnlh\004cliy\003"
    "clm\004clmh\004clmy\003clr\004clrb\005clrbe\005clrbh\006clrbhe\005clrbl"
    "\006clrble\006clrblh\006clrbne\006clrbnh\007clrbnhe\006clrbnl\007clrbnl"
    "e\007clrbnlh\004clrj\005clrje\005clrjh\006clrjhe\005clrjl\006clrjle\006"
    "clrjlh\006clrjne\006clrjnh\007clrjnhe\006clrjnl\007clrjnle\007clrjnlh\004"
    "clrl\004clrt\005clrte\005clrth\006clrthe\005clrtl\006clrtle\006clrtlh\006"
    "clrtne\006clrtnh\007clrtnhe\006clrtnl\007clrtnle\007clrtnlh\004clst\003"
    "clt\004clte\004clth\005clthe\004cltl\005cltle\005cltlh\005cltne\005cltn"
    "h\006cltnhe\005cltnl\006cltnle\006cltnlh\003cly\004clzg\005cmpsc\002cp\004"
    "cpdt\005cpsdr\004cpxt\004cpya\002cr\003crb\004crbe\004crbh\005crbhe\004"
    "crbl\005crble\005crblh\005crbne\005crbnh\006crbnhe\005crbnl\006crbnle\006"
    "crbnlh\005crdte\003crj\004crje\004crjh\005crjhe\004crjl\005crjle\005crj"
    "lh\005crjne\005crjnh\006crjnhe\005crjnl\006crjnle\006crjnlh\003crl\003c"
    "rt\004crte\004crth\005crthe\004crtl\005crtle\005crtlh\005crtne\005crtnh"
    "\006crtnhe\005crtnl\006crtnle\006crtnlh\002cs\004csch\005csdtr\003csg\003"
    "csp\004cspg\004csst\005csxtr\003csy\004ctzg\004cu12\004cu14\004cu21\004"
    "cu24\004cu41\004cu42\005cudtr\004cuse\005cutfu\005cuutf\005cuxtr\003cvb"
    "\004cvbg\004cvby\003cvd\004cvdg\004cvdy\004cxbr\005cxfbr\006cxfbra\004c"
    "xfr\005cxftr\005cxgbr\006cxgbra\004cxgr\005cxgtr\006cxgtra\006cxlfbr\006"
    "cxlftr\006cxlgbr\006cxlgtr\004cxpt\003cxr\005cxstr\004cxtr\005cxutr\004"
    "cxzt\002cy\004czdt\004czxt\001d\002dd\003ddb\004ddbr\003ddr\004ddtr\005"
    "ddtra\002de\003deb\004debr\003der\006dfltcc\004diag\005didbr\005diebr\002"
    "dl\003dlg\004dlgr\003dlr\002dp\002dr\003dsg\004dsgf\005dsgfr\004dsgr\004"
    "dxbr\003dxr\004dxtr\005dxtra\003ear\004ecag\005ecctr\005ecpga\004ectg\002"
    "ed\004edmk\005eedtr\005eextr\004efpc\005epair\004epar\005epctr\004epsw\004"
    "ereg\005eregg\005esair\004esar\005esdtr\004esea\004esta\005esxtr\004etn"
    "d\002ex\004exrl\005fidbr\006fidbra\004fidr\005fidtr\005fiebr\006fiebra\004"
    "fier\005fixbr\006fixbra\004fixr\005fixtr\005flogr\003hdr\003her\004hsch"
    "\003iac\002ic\003icm\004icmh\004icmy\003icy\004idte\005iedtr\005iextr\004"
    "iihf\004iihh\004iihl\004iilf\004iilh\004iill\003ipk\003ipm\004ipte\004i"
    "rbm\004iske\004ivsk\001j\002je\002jg\003jge\003jgh\004jghe\003jgl\004jg"
    "le\004jglh\003jgm\004jgne\004jgnh\005jgnhe\004jgnl\005jgnle\005jgnlh\004"
    "jgnm\004jgno\005jgnop\004jgnp\004jgnz\003jgo\003jgp\003jgz\002jh\003jhe"
    "\002jl\003jle\003jlh\003jll\003jlm\004jlne\004jlnh\004jlnl\004jlnm\004j"
    "lno\005jlnop\004jlnp\004jlnz\003jlo\003jlp\003jlu\003jlz\002jm\003jne\003"
    "jnh\004jnhe\003jnl\004jnle\004jnlh\003jnm\003jno\004jnop\003jnp\003jnz\002"
    "jo\002jp\002jz\003kdb\004kdbr\004kdsa\004kdtr\003keb\004kebr\004kimd\004"
    "klmd\002km\003kma\004kmac\003kmc\005kmctr\003kmf\003kmo\004kxbr\004kxtr"
    "\001l\002la\003laa\004laag\004laal\005laalg\003lae\004laey\003lam\004la"
    "my\003lan\004lang\003lao\004laog\004larl\004lasp\003lat\003lax\004laxg\003"
    "lay\002lb\005lbear\003lbh\003lbr\004lcbb\005lcctl\005lcdbr\005lcdfr\004"
    "lcdr\005lcebr\004lcer\005lcgfr\004lcgr\003lcr\004lctl\005lctlg\005lcxbr"
    "\004lcxr\002ld\003lde\004ldeb\005ldebr\004lder\005ldetr\004ldgr\003ldr\004"
    "ldrv\005ldxbr\006ldxbra\004ldxr\005ldxtr\003ldy\002le\005ledbr\006ledbr"
    "a\004ledr\005ledtr\003ler\004lerv\005lexbr\006lexbra\004lexr\003ley\004"
    "lfas\003lfh\005lfhat\003lfi\004lfpc\002lg\004lgat\003lgb\004lgbr\004lgd"
    "r\003lgf\004lgfi\004lgfr\005lgfrl\003lgg\003lgh\004lghi\004lghr\005lghr"
    "l\003lgr\004lgrl\004lgsc\002lh\003lhh\003lhi\003lhr\004lhrl\003lhy\003l"
    "lc\004llch\004llcr\004llgc\005llgcr\004llgf\006llgfat\005llgfi\005llgfr"
    "\006llgfrl\006llgfsg\004llgh\005llghi\005llghr\006llghrl\004llgt\006llg"
    "tat\005llgtr\003llh\004llhh\004llhr\005llhrl\005llihf\005llihh\005llihl"
    "\005llilf\005llilh\005llill\005llxab\005llxaf\005llxag\005llxah\005llxa"
    "q\006llzrgf\002lm\003lmd\003lmg\003lmh\003lmy\005lndbr\005lndfr\004lndr"
    "\005lnebr\004lner\005lngfr\004lngr\003lnr\005lnxbr\004lnxr\003loc\004lo"
    "ce\005locfh\006locfhe\006locfhh\007locfhhe\006locfhl\007locfhle\007locf"
    "hlh\006locfhm\007locfhne\007locfhnh\010locfhnhe\007locfhnl\010locfhnle\010"
    "locfhnlh\007locfhnm\007locfhno\007locfhnp\007locfhnz\006locfho\006locfh"
    "p\006locfhr\007locfhre\007locfhrh\010locfhrhe\007locfhrl\010locfhrle\010"
    "locfhrlh\007locfhrm\010locfhrne\010locfhrnh\tlocfhrnhe\010locfhrnl\tloc"
    "fhrnle\tlocfhrnlh\010locfhrnm\010locfhrno\010locfhrnp\010locfhrnz\007lo"
    "cfhro\007locfhrp\007locfhrz\006locfhz\004locg\005locge\005locgh\006locg"
    "he\006locghi\007locghie\007locghih\010locghihe\007locghil\010locghile\010"
    "locghilh\007locghim\010locghine\010locghinh\tlocghinhe\010locghinl\tloc"
    "ghinle\tlocghinlh\010locghinm\010locghino\010locghinp\010locghinz\007lo"
    "cghio\007locghip\007locghiz\005locgl\006locgle\006locglh\005locgm\006lo"
    "cgne\006locgnh\007locgnhe\006locgnl\007locgnle\007locgnlh\006locgnm\006"
    "locgno\006locgnp\006locgnz\005locgo\005locgp\005locgr\006locgre\006locg"
    "rh\007locgrhe\006locgrl\007locgrle\007locgrlh\006locgrm\007locgrne\007l"
    "ocgrnh\010locgrnhe\007locgrnl\010locgrnle\010locgrnlh\007locgrnm\007loc"
    "grno\007locgrnp\007locgrnz\006locgro\006locgrp\006locgrz\005locgz\004lo"
    "ch\005loche\006lochhi\007lochhie\007lochhih\010lochhihe\007lochhil\010l"
    "ochhile\010lochhilh\007lochhim\010lochhine\010lochhinh\tlochhinhe\010lo"
    "chhinl\tlochhinle\tlochhinlh\010lochhinm\010lochhino\010lochhinp\010loc"
    "hhinz\007lochhio\007lochhip\007lochhiz\005lochi\006lochie\006lochih\007"
    "lochihe\006lochil\007lochile\007lochilh\006lochim\007lochine\007lochinh"
    "\010lochinhe\007lochinl\010lochinle\010lochinlh\007lochinm\007lochino\007"
    "lochinp\007lochinz\006lochio\006lochip\006lochiz\004locl\005locle\005lo"
    "clh\004locm\005locne\005locnh\006locnhe\005locnl\006locnle\006locnlh\005"
    "locnm\005locno\005locnp\005locnz\004loco\004locp\004locr\005locre\005lo"
    "crh\006locrhe\005locrl\006locrle\006locrlh\005locrm\006locrne\006locrnh"
    "\007locrnhe\006locrnl\007locrnle\007locrnlh\006locrnm\006locrno\006locr"
    "np\006locrnz\005locro\005locrp\005locrz\004locz\005lpctl\003lpd\005lpdb"
    "r\005lpdfr\004lpdg\004lpdr\005lpebr\004lper\005lpgfr\004lpgr\003lpp\003"
    "lpq\003lpr\004lpsw\005lpswe\006lpswey\005lptea\005lpxbr\004lpxr\002lr\003"
    "lra\004lrag\004lray\004lrdr\004lrer\003lrl\003lrv\004lrvg\005lrvgr\004l"
    "rvh\004lrvr\005lsctl\002lt\005ltdbr\004ltdr\005ltdtr\005ltebr\004lter\003"
    "ltg\004ltgf\005ltgfr\004ltgr\003ltr\005ltxbr\004ltxr\005ltxtr\004lura\005"
    "lurag\004lxab\004lxaf\004lxag\004lxah\004lxaq\003lxd\004lxdb\005lxdbr\004"
    "lxdr\005lxdtr\003lxe\004lxeb\005lxebr\004lxer\003lxr\002ly\004lzdr\004l"
    "zer\004lzrf\004lzrg\004lzxr\001m\003mad\004madb\005madbr\004madr\003mae"
    "\004maeb\005maebr\004maer\003may\004mayh\005mayhr\004mayl\005maylr\004m"
    "ayr\002mc\002md\003mdb\004mdbr\003mde\004mdeb\005mdebr\004mder\003mdr\004"
    "mdtr\005mdtra\002me\003mee\004meeb\005meebr\004meer\003mer\003mfy\002mg"
    "\003mgh\004mghi\004mgrk\002mh\003mhi\003mhy\002ml\003mlg\004mlgr\003mlr"
    "\002mp\002mr\002ms\003msc\004msch\003msd\004msdb\005msdbr\004msdr\003ms"
    "e\004mseb\005msebr\004mser\004msfi\003msg\004msgc\004msgf\005msgfi\005m"
    "sgfr\004msgr\006msgrkc\003msr\005msrkc\004msta\003msy\003mvc\005mvcdk\005"
    "mvcin\004mvck\004mvcl\005mvcle\005mvclu\005mvcos\004mvcp\005mvcrl\004mv"
    "cs\005mvcsk\005mvghi\005mvhhi\004mvhi\003mvi\004mviy\003mvn\003mvo\004m"
    "vpg\004mvst\003mvz\004mxbr\003mxd\004mxdb\005mxdbr\004mxdr\003mxr\004mx"
    "tr\005mxtra\002my\003myh\004myhr\003myl\004mylr\003myr\001n\002nc\005nc"
    "grk\004ncrk\002ng\003ngr\004ngrk\002ni\004niai\004nihf\004nihh\004nihl\004"
    "nilf\004nilh\004nill\003niy\005nngrk\004nnpa\004nnrk\005nogrk\003nop\004"
    "nopr\004nork\005notgr\004notr\002nr\003nrk\005ntstg\005nxgrk\004nxrk\002"
    "ny\001o\002oc\005ocgrk\004ocrk\002og\003ogr\004ogrk\002oi\004oihf\004oi"
    "hh\004oihl\004oilf\004oilh\004oill\003oiy\002or\003ork\002oy\004pack\004"
    "palb\002pc\003pcc\005pckmo\004pfcr\003pfd\005pfdrl\004pfmf\004pfpo\004p"
    "gin\005pgout\003pka\003pku\003plo\006popcnt\003ppa\004ppno\002pr\004prn"
    "o\002pt\003ptf\004ptff\003pti\004ptlb\005qadtr\005qaxtr\005qctri\005qpa"
    "ci\003qsi\004rchp\003rdp\005risbg\006risbgn\007risbgnz\006risbgz\006ris"
    "bhg\006risblg\003rll\004rllg\005rnsbg\005rosbg\002rp\004rrbe\004rrbm\005"
    "rrdtr\005rrxtr\004rsch\005rxsbg\001s\003sac\004sacf\003sal\005sam24\005"
    "sam31\005sam64\003sar\005scctr\004schm\003sck\004sckc\005sckpf\002sd\003"
    "sdb\004sdbr\003sdr\004sdtr\005sdtra\002se\003seb\004sebr\006selfhr\007s"
    "elfhre\007selfhrh\010selfhrhe\007selfhrl\010selfhrle\010selfhrlh\007sel"
    "fhrm\010selfhrne\010selfhrnh\tselfhrnhe\010selfhrnl\tselfhrnle\tselfhrn"
    "lh\010selfhrnm\010selfhrno\010selfhrnp\010selfhrnz\007selfhro\007selfhr"
    "p\007selfhrz\005selgr\006selgre\006selgrh\007selgrhe\006selgrl\007selgr"
    "le\007selgrlh\006selgrm\007selgrne\007selgrnh\010selgrnhe\007selgrnl\010"
    "selgrnle\010selgrnlh\007selgrnm\007selgrno\007selgrnp\007selgrnz\006sel"
    "gro\006selgrp\006selgrz\004selr\005selre\005selrh\006selrhe\005selrl\006"
    "selrle\006selrlh\005selrm\006selrne\006selrnh\007selrnhe\006selrnl\007s"
    "elrnle\007selrnlh\006selrnm\006selrno\006selrnp\006selrnz\005selro\005s"
    "elrp\005selrz\003ser\005sfasr\004sfpc\002sg\003sgf\004sgfr\003sgh\003sg"
    "r\004sgrk\002sh\005shhhr\005shhlr\003shy\003sie\004siga\004sigp\002sl\003"
    "sla\004slag\004slak\003slb\004slbg\005slbgr\004slbr\004slda\004sldl\004"
    "sldt\004slfi\003slg\004slgf\005slgfi\005slgfr\004slgr\005slgrk\006slhhh"
    "r\006slhhlr\003sll\004sllg\004sllk\003slr\004slrk\004slxt\003sly\005sor"
    "tl\002sp\005spctr\004spka\003spm\003spt\003spx\003sqd\004sqdb\005sqdbr\004"
    "sqdr\003sqe\004sqeb\005sqebr\004sqer\005sqxbr\004sqxr\002sr\003sra\004s"
    "rag\004srak\004srda\004srdl\004srdt\003srk\003srl\004srlg\004srlk\004sr"
    "nm\005srnmb\005srnmt\003srp\004srst\005srstu\004srxt\005ssair\004ssar\004"
    "ssch\004sske\003ssm\002st\004stam\005stamy\004stap\006stbear\003stc\004"
    "stch\004stck\005stckc\005stcke\005stckf\004stcm\005stcmh\005stcmy\005st"
    "cps\005stcrw\005stctg\005stctl\004stcy\003std\005stdrv\004stdy\003ste\005"
    "sterv\004stey\004stfh\004stfl\005stfle\005stfpc\003stg\005stgrl\005stgs"
    "c\003sth\004sthh\005sthrl\004sthy\005stidp\003stm\004stmg\004stmh\004st"
    "my\005stnsm\004stoc\005stoce\006stocfh\007stocfhe\007stocfhh\010stocfhh"
    "e\007stocfhl\010stocfhle\010stocfhlh\007stocfhm\010stocfhne\010stocfhnh"
    "\tstocfhnhe\010stocfhnl\tstocfhnle\tstocfhnlh\010stocfhnm\010stocfhno\010"
    "stocfhnp\010stocfhnz\007stocfho\007stocfhp\007stocfhz\005stocg\006stocg"
    "e\006stocgh\007stocghe\006stocgl\007stocgle\007stocglh\006stocgm\007sto"
    "cgne\007stocgnh\010stocgnhe\007stocgnl\010stocgnle\010stocgnlh\007stocg"
    "nm\007stocgno\007stocgnp\007stocgnz\006stocgo\006stocgp\006stocgz\005st"
    "och\006stoche\005stocl\006stocle\006stoclh\005stocm\006stocne\006stocnh"
    "\007stocnhe\006stocnl\007stocnle\007stocnlh\006stocnm\006stocno\006stoc"
    "np\006stocnz\005stoco\005stocp\005stocz\005stosm\004stpq\004stpt\004stp"
    "x\005strag\004strl\004strv\005strvg\005strvh\005stsch\004stsi\005stura\005"
    "sturg\003sty\002su\003sur\003svc\002sw\003swr\004sxbr\003sxr\004sxtr\005"
    "sxtra\002sy\006tabort\003tam\003tar\002tb\004tbdr\005tbedr\006tbegin\007"
    "tbeginc\004tcdb\004tceb\004tcxb\005tdcdt\005tdcet\005tdcxt\005tdgdt\005"
    "tdget\005tdgxt\004tend\005thder\004thdr\002tm\003tmh\004tmhh\004tmhl\003"
    "tml\004tmlh\004tmll\003tmy\002tp\004tpei\003tpi\005tprot\002tr\005trace"
    "\005tracg\005trap2\005trap4\003tre\004troo\004trot\003trt\004trte\004tr"
    "to\004trtr\005trtre\004trtt\002ts\004tsch\004unpk\005unpka\005unpku\003"
    "upt\002va\003vab\003vac\004vacc\005vaccb\005vaccc\006vacccq\005vaccf\005"
    "vaccg\005vacch\005vaccq\004vacq\003vaf\003vag\003vah\003vap\003vaq\004v"
    "avg\005vavgb\005vavgf\005vavgg\005vavgh\005vavgl\006vavglb\006vavglf\006"
    "vavglg\006vavglh\006vavglq\005vavgq\006vblend\007vblendb\007vblendf\007"
    "vblendg\007vblendh\007vblendq\006vbperm\004vcdg\005vcdgb\005vcdlg\006vc"
    "dlgb\005vcefb\006vcelfb\004vceq\005vceqb\006vceqbs\005vceqf\006vceqfs\005"
    "vceqg\006vceqgs\005vceqh\006vceqhs\005vceqq\006vceqqs\005vcfeb\004vcfn\005"
    "vcfpl\005vcfps\004vcgd\005vcgdb\003vch\004vchb\005vchbs\004vchf\005vchf"
    "s\004vchg\005vchgs\004vchh\005vchhs\004vchl\005vchlb\006vchlbs\005vchlf"
    "\006vchlfs\005vchlg\006vchlgs\005vchlh\006vchlhs\005vchlq\006vchlqs\004"
    "vchq\005vchqs\005vcksm\006vclfeb\006vclfnh\006vclfnl\005vclfp\005vclgd\006"
    "vclgdb\004vclz\005vclzb\006vclzdp\005vclzf\005vclzg\005vclzh\005vclzq\004"
    "vcnf\003vcp\005vcrnf\005vcsfp\005vcsph\004vctz\005vctzb\005vctzf\005vct"
    "zg\005vctzh\005vctzq\004vcvb\005vcvbg\005vcvbq\004vcvd\005vcvdg\005vcvd"
    "q\002vd\003vdf\003vdg\003vdl\004vdlf\004vdlg\004vdlq\003vdp\003vdq\003v"
    "ec\004vecb\004vecf\004vecg\004vech\004vecl\005veclb\005veclf\005veclg\005"
    "veclh\005veclq\004vecq\005verim\006verimb\006verimf\006verimg\006verimh"
    "\005verll\006verllb\006verllf\006verllg\006verllh\006verllv\007verllvb\007"
    "verllvf\007verllvg\007verllvh\004vesl\005veslb\005veslf\005veslg\005ves"
    "lh\005veslv\006veslvb\006veslvf\006veslvg\006veslvh\005vesra\006vesrab\006"
    "vesraf\006vesrag\006vesrah\006vesrav\007vesravb\007vesravf\007vesravg\007"
    "vesravh\005vesrl\006vesrlb\006vesrlf\006vesrlg\006vesrlh\006vesrlv\007v"
    "esrlvb\007vesrlvf\007vesrlvg\007vesrlvh\005veval\003vfa\005vfadb\004vfa"
    "e\005vfaeb\006vfaebs\005vfaef\006vfaefs\005vfaeh\006vfaehs\006vfaezb\007"
    "vfaezbs\006vfaezf\007vfaezfs\006vfaezh\007vfaezhs\005vfasb\004vfce\006v"
    "fcedb\007vfcedbs\006vfcesb\007vfcesbs\004vfch\006vfchdb\007vfchdbs\005v"
    "fche\007vfchedb\010vfchedbs\007vfchesb\010vfchesbs\006vfchsb\007vfchsbs"
    "\003vfd\005vfddb\005vfdsb\004vfee\005vfeeb\006vfeebs\005vfeef\006vfeefs"
    "\005vfeeh\006vfeehs\006vfeezb\007vfeezbs\006vfeezf\007vfeezfs\006vfeezh"
    "\007vfeezhs\005vfene\006vfeneb\007vfenebs\006vfenef\007vfenefs\006vfene"
    "h\007vfenehs\007vfenezb\010vfenezbs\007vfenezf\010vfenezfs\007vfenezh\010"
    "vfenezhs\003vfi\005vfidb\005vfisb\006vfkedb\007vfkedbs\006vfkesb\007vfk"
    "esbs\006vfkhdb\007vfkhdbs\007vfkhedb\010vfkhedbs\007vfkhesb\010vfkhesbs"
    "\006vfkhsb\007vfkhsbs\006vflcdb\006vflcsb\004vfll\005vflls\006vflndb\006"
    "vflnsb\006vflpdb\006vflpsb\004vflr\005vflrd\003vfm\004vfma\006vfmadb\006"
    "vfmasb\005vfmax\007vfmaxdb\007vfmaxsb\005vfmdb\005vfmin\007vfmindb\007v"
    "fminsb\004vfms\005vfmsb\006vfmsdb\006vfmssb\005vfnma\007vfnmadb\007vfnm"
    "asb\005vfnms\007vfnmsdb\007vfnmssb\005vfpso\007vfpsodb\007vfpsosb\003vf"
    "s\005vfsdb\004vfsq\006vfsqdb\006vfsqsb\005vfssb\005vftci\007vftcidb\007"
    "vftcisb\004vgbm\004vgef\004vgeg\004vgem\005vgemb\005vgemf\005vgemg\005v"
    "gemh\005vgemq\004vgfm\005vgfma\006vgfmab\006vgfmaf\006vgfmag\006vgfmah\005"
    "vgfmb\005vgfmf\005vgfmg\005vgfmh\003vgm\004vgmb\004vgmf\004vgmg\004vgmh"
    "\005vistr\006vistrb\007vistrbs\006vistrf\007vistrfs\006vistrh\007vistrh"
    "s\002vl\004vlbb\004vlbr\005vlbrf\005vlbrg\005vlbrh\005vlbrq\007vlbrrep\010"
    "vlbrrepf\010vlbrrepg\010vlbrreph\003vlc\004vlcb\004vlcf\004vlcg\004vlch"
    "\004vlcq\004vlde\005vldeb\004vleb\006vlebrf\006vlebrg\006vlebrh\004vled"
    "\005vledb\004vlef\004vleg\004vleh\005vleib\005vleif\005vleig\005vleih\004"
    "vler\005vlerf\005vlerg\005vlerh\004vlgv\005vlgvb\005vlgvf\005vlgvg\005v"
    "lgvh\004vlip\003vll\007vllebrz\010vllebrze\010vllebrzf\010vllebrzg\010v"
    "llebrzh\005vllez\006vllezb\006vllezf\006vllezg\006vllezh\007vllezlf\003"
    "vlm\003vlp\004vlpb\004vlpf\004vlpg\004vlph\004vlpq\003vlr\005vlrep\006v"
    "lrepb\006vlrepf\006vlrepg\006vlreph\004vlrl\005vlrlr\004vlvg\005vlvgb\005"
    "vlvgf\005vlvgg\005vlvgh\005vlvgp\004vmae\005vmaeb\005vmaef\005vmaeg\005"
    "vmaeh\004vmah\005vmahb\005vmahf\005vmahg\005vmahh\005vmahq\004vmal\005v"
    "malb\005vmale\006vmaleb\006vmalef\006vmaleg\006vmaleh\005vmalf\005vmalg"
    "\005vmalh\006vmalhb\006vmalhf\006vmalhg\006vmalhh\006vmalhq\006vmalhw\005"
    "vmalo\006vmalob\006vmalof\006vmalog\006vmaloh\005vmalq\004vmao\005vmaob"
    "\005vmaof\005vmaog\005vmaoh\003vme\004vmeb\004vmef\004vmeg\004vmeh\003v"
    "mh\004vmhb\004vmhf\004vmhg\004vmhh\004vmhq\003vml\004vmlb\004vmle\005vm"
    "leb\005vmlef\005vmleg\005vmleh\004vmlf\004vmlg\004vmlh\005vmlhb\005vmlh"
    "f\005vmlhg\005vmlhh\005vmlhq\005vmlhw\004vmlo\005vmlob\005vmlof\005vmlo"
    "g\005vmloh\004vmlq\003vmn\004vmnb\004vmnf\004vmng\004vmnh\004vmnl\005vm"
    "nlb\005vmnlf\005vmnlg\005vmnlh\005vmnlq\004vmnq\003vmo\004vmob\004vmof\004"
    "vmog\004vmoh\003vmp\004vmrh\005vmrhb\005vmrhf\005vmrhg\005vmrhh\004vmrl"
    "\005vmrlb\005vmrlf\005vmrlg\005vmrlh\004vmsl\005vmslg\004vmsp\003vmx\004"
    "vmxb\004vmxf\004vmxg\004vmxh\004vmxl\005vmxlb\005vmxlf\005vmxlg\005vmxl"
    "h\005vmxlq\004vmxq\002vn\003vnc\003vnn\003vno\004vnot\003vnx\002vo\003v"
    "oc\004vone\004vpdi\005vperm\003vpk\004vpkf\004vpkg\004vpkh\005vpkls\006"
    "vpklsf\007vpklsfs\006vpklsg\007vpklsgs\006vpklsh\007vpklshs\004vpks\005"
    "vpksf\006vpksfs\005vpksg\006vpksgs\005vpksh\006vpkshs\004vpkz\005vpkzr\006"
    "vpopct\007vpopctb\007vpopctf\007vpopctg\007vpopcth\005vpsop\002vr\004vr"
    "ep\005vrepb\005vrepf\005vrepg\005vreph\005vrepi\006vrepib\006vrepif\006"
    "vrepig\006vrepih\003vrf\003vrg\003vrl\004vrlf\004vrlg\004vrlq\003vrp\003"
    "vrq\002vs\003vsb\006vsbcbi\007vsbcbiq\004vsbi\005vsbiq\005vscbi\006vscb"
    "ib\006vscbif\006vscbig\006vscbih\006vscbiq\005vscef\005vsceg\006vschdp\005"
    "vschp\006vschsp\006vschxp\006vscshp\004vsdp\004vseg\005vsegb\005vsegf\005"
    "vsegh\004vsel\003vsf\003vsg\003vsh\003vsl\004vslb\004vsld\005vsldb\003v"
    "sp\003vsq\004vsra\005vsrab\004vsrd\004vsrl\005vsrlb\004vsrp\005vsrpr\003"
    "vst\005vstbr\006vstbrf\006vstbrg\006vstbrh\006vstbrq\005vsteb\007vstebr"
    "f\007vstebrg\007vstebrh\005vstef\005vsteg\005vsteh\005vster\006vsterf\006"
    "vsterg\006vsterh\004vstl\004vstm\005vstrc\006vstrcb\007vstrcbs\006vstrc"
    "f\007vstrcfs\006vstrch\007vstrchs\007vstrczb\010vstrczbs\007vstrczf\010"
    "vstrczfs\007vstrczh\010vstrczhs\005vstrl\006vstrlr\005vstrs\006vstrsb\006"
    "vstrsf\006vstrsh\007vstrszb\007vstrszf\007vstrszh\004vsum\005vsumb\005v"
    "sumg\006vsumgf\006vsumgh\005vsumh\005vsumq\006vsumqf\006vsumqg\003vtm\003"
    "vtp\003vtz\004vuph\005vuphb\005vuphf\005vuphg\005vuphh\005vupkz\006vupk"
    "zh\006vupkzl\004vupl\005vuplb\005vuplf\005vuplg\005vuplh\006vuplhb\006v"
    "uplhf\006vuplhg\006vuplhh\006vuplhw\005vupll\006vupllb\006vupllf\006vup"
    "llg\006vupllh\002vx\005vzero\005wcdgb\006wcdlgb\005wcefb\006wcelfb\005w"
    "cfeb\005wcgdb\006wclfeb\006wclgdb\005wfadb\005wfasb\005wfaxb\003wfc\005"
    "wfcdb\006wfcedb\007wfcedbs\006wfcesb\007wfcesbs\006wfcexb\007wfcexbs\006"
    "wfchdb\007wfchdbs\007wfchedb\010wfchedbs\007wfchesb\010wfchesbs\007wfch"
    "exb\010wfchexbs\006wfchsb\007wfchsbs\006wfchxb\007wfchxbs\005wfcsb\005w"
    "fcxb\005wfddb\005wfdsb\005wfdxb\005wfidb\005wfisb\005wfixb\003wfk\005wf"
    "kdb\006wfkedb\007wfkedbs\006wfkesb\007wfkesbs\006wfkexb\007wfkexbs\006w"
    "fkhdb\007wfkhdbs\007wfkhedb\010wfkhedbs\007wfkhesb\010wfkhesbs\007wfkhe"
    "xb\010wfkhexbs\006wfkhsb\007wfkhsbs\006wfkhxb\007wfkhxbs\005wfksb\005wf"
    "kxb\006wflcdb\006wflcsb\006wflcxb\005wflld\005wflls\006wflndb\006wflnsb"
    "\006wflnxb\006wflpdb\006wflpsb\006wflpxb\005wflrd\005wflrx\006wfmadb\006"
    "wfmasb\006wfmaxb\007wfmaxdb\007wfmaxsb\007wfmaxxb\005wfmdb\007wfmindb\007"
    "wfminsb\007wfminxb\005wfmsb\006wfmsdb\006wfmssb\006wfmsxb\005wfmxb\007w"
    "fnmadb\007wfnmasb\007wfnmaxb\007wfnmsdb\007wfnmssb\007wfnmsxb\007wfpsod"
    "b\007wfpsosb\007wfpsoxb\005wfsdb\006wfsqdb\006wfsqsb\006wfsqxb\005wfssb"
    "\005wfsxb\007wftcidb\007wftcisb\007wftcixb\005wldeb\005wledb\001x\002xc"
    "\002xg\003xgr\004xgrk\002xi\004xihf\004xilf\003xiy\002xr\003xrk\004xsch"
    "\002xy\003zap";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_FeatureBEAREnhancement,
  AMFBS_FeatureConcurrentFunctions,
  AMFBS_FeatureDFPPackedConversion,
  AMFBS_FeatureDFPZonedConversion,
  AMFBS_FeatureDeflateConversion,
  AMFBS_FeatureDistinctOps,
  AMFBS_FeatureEnhancedDAT2,
  AMFBS_FeatureEnhancedSort,
  AMFBS_FeatureExecutionHint,
  AMFBS_FeatureFPExtension,
  AMFBS_FeatureGuardedStorage,
  AMFBS_FeatureHighWord,
  AMFBS_FeatureInsertReferenceBitsMultiple,
  AMFBS_FeatureInterlockedAccess1,
  AMFBS_FeatureLoadAndTrap,
  AMFBS_FeatureLoadAndZeroRightmostByte,
  AMFBS_FeatureLoadStoreOnCond,
  AMFBS_FeatureLoadStoreOnCond2,
  AMFBS_FeatureMessageSecurityAssist12,
  AMFBS_FeatureMessageSecurityAssist3,
  AMFBS_FeatureMessageSecurityAssist4,
  AMFBS_FeatureMessageSecurityAssist5,
  AMFBS_FeatureMessageSecurityAssist7,
  AMFBS_FeatureMessageSecurityAssist8,
  AMFBS_FeatureMessageSecurityAssist9,
  AMFBS_FeatureMiscellaneousExtensions,
  AMFBS_FeatureMiscellaneousExtensions2,
  AMFBS_FeatureMiscellaneousExtensions3,
  AMFBS_FeatureMiscellaneousExtensions4,
  AMFBS_FeatureNNPAssist,
  AMFBS_FeaturePopulationCount,
  AMFBS_FeatureProcessorActivityInstrumentation,
  AMFBS_FeatureProcessorAssist,
  AMFBS_FeatureResetDATProtection,
  AMFBS_FeatureResetReferenceBitsMultiple,
  AMFBS_FeatureTestPendingExternalInterruption,
  AMFBS_FeatureTransactionalExecution,
  AMFBS_FeatureVector,
  AMFBS_FeatureVectorEnhancements1,
  AMFBS_FeatureVectorEnhancements2,
  AMFBS_FeatureVectorEnhancements3,
  AMFBS_FeatureVectorPackedDecimal,
  AMFBS_FeatureVectorPackedDecimalEnhancement,
  AMFBS_FeatureVectorPackedDecimalEnhancement2,
  AMFBS_FeatureVectorPackedDecimalEnhancement3,
  AMFBS_FeatureVector_FeatureNNPAssist,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_FeatureBEAREnhancementBit, },
  {Feature_FeatureConcurrentFunctionsBit, },
  {Feature_FeatureDFPPackedConversionBit, },
  {Feature_FeatureDFPZonedConversionBit, },
  {Feature_FeatureDeflateConversionBit, },
  {Feature_FeatureDistinctOpsBit, },
  {Feature_FeatureEnhancedDAT2Bit, },
  {Feature_FeatureEnhancedSortBit, },
  {Feature_FeatureExecutionHintBit, },
  {Feature_FeatureFPExtensionBit, },
  {Feature_FeatureGuardedStorageBit, },
  {Feature_FeatureHighWordBit, },
  {Feature_FeatureInsertReferenceBitsMultipleBit, },
  {Feature_FeatureInterlockedAccess1Bit, },
  {Feature_FeatureLoadAndTrapBit, },
  {Feature_FeatureLoadAndZeroRightmostByteBit, },
  {Feature_FeatureLoadStoreOnCondBit, },
  {Feature_FeatureLoadStoreOnCond2Bit, },
  {Feature_FeatureMessageSecurityAssist12Bit, },
  {Feature_FeatureMessageSecurityAssist3Bit, },
  {Feature_FeatureMessageSecurityAssist4Bit, },
  {Feature_FeatureMessageSecurityAssist5Bit, },
  {Feature_FeatureMessageSecurityAssist7Bit, },
  {Feature_FeatureMessageSecurityAssist8Bit, },
  {Feature_FeatureMessageSecurityAssist9Bit, },
  {Feature_FeatureMiscellaneousExtensionsBit, },
  {Feature_FeatureMiscellaneousExtensions2Bit, },
  {Feature_FeatureMiscellaneousExtensions3Bit, },
  {Feature_FeatureMiscellaneousExtensions4Bit, },
  {Feature_FeatureNNPAssistBit, },
  {Feature_FeaturePopulationCountBit, },
  {Feature_FeatureProcessorActivityInstrumentationBit, },
  {Feature_FeatureProcessorAssistBit, },
  {Feature_FeatureResetDATProtectionBit, },
  {Feature_FeatureResetReferenceBitsMultipleBit, },
  {Feature_FeatureTestPendingExternalInterruptionBit, },
  {Feature_FeatureTransactionalExecutionBit, },
  {Feature_FeatureVectorBit, },
  {Feature_FeatureVectorEnhancements1Bit, },
  {Feature_FeatureVectorEnhancements2Bit, },
  {Feature_FeatureVectorEnhancements3Bit, },
  {Feature_FeatureVectorPackedDecimalBit, },
  {Feature_FeatureVectorPackedDecimalEnhancementBit, },
  {Feature_FeatureVectorPackedDecimalEnhancement2Bit, },
  {Feature_FeatureVectorPackedDecimalEnhancement3Bit, },
  {Feature_FeatureVectorBit, Feature_FeatureNNPAssistBit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[6];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 0 /* a */, SystemZ::A, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2 /* ad */, SystemZ::AD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5 /* adb */, SystemZ::ADB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9 /* adbr */, SystemZ::ADBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 14 /* adr */, SystemZ::ADR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 18 /* adtr */, SystemZ::ADTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 23 /* adtra */, SystemZ::ADTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 29 /* ae */, SystemZ::AE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 32 /* aeb */, SystemZ::AEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 36 /* aebr */, SystemZ::AEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 41 /* aer */, SystemZ::AER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 45 /* afi */, SystemZ::AFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 49 /* ag */, SystemZ::AG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 52 /* agf */, SystemZ::AGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 56 /* agfi */, SystemZ::AGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 61 /* agfr */, SystemZ::AGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 66 /* agh */, SystemZ::AGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 70 /* aghi */, SystemZ::AGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 75 /* aghik */, SystemZ::AGHIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 81 /* agr */, SystemZ::AGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 85 /* agrk */, SystemZ::AGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 90 /* agsi */, SystemZ::AGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 95 /* ah */, SystemZ::AH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 98 /* ahhhr */, SystemZ::AHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 104 /* ahhlr */, SystemZ::AHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 110 /* ahi */, SystemZ::AHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 114 /* ahik */, SystemZ::AHIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 119 /* ahy */, SystemZ::AHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 123 /* aih */, SystemZ::AIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 127 /* al */, SystemZ::AL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 130 /* alc */, SystemZ::ALC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 134 /* alcg */, SystemZ::ALCG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 139 /* alcgr */, SystemZ::ALCGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 145 /* alcr */, SystemZ::ALCR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 150 /* alfi */, SystemZ::ALFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 155 /* alg */, SystemZ::ALG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 159 /* algf */, SystemZ::ALGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 164 /* algfi */, SystemZ::ALGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 170 /* algfr */, SystemZ::ALGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 176 /* alghsik */, SystemZ::ALGHSIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 184 /* algr */, SystemZ::ALGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 189 /* algrk */, SystemZ::ALGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 195 /* algsi */, SystemZ::ALGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 201 /* alhhhr */, SystemZ::ALHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 208 /* alhhlr */, SystemZ::ALHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 215 /* alhsik */, SystemZ::ALHSIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 222 /* alr */, SystemZ::ALR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 226 /* alrk */, SystemZ::ALRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 231 /* alsi */, SystemZ::ALSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 236 /* alsih */, SystemZ::ALSIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 242 /* alsihn */, SystemZ::ALSIHN, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 249 /* aly */, SystemZ::ALY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 253 /* ap */, SystemZ::AP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 256 /* ar */, SystemZ::AR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 259 /* ark */, SystemZ::ARK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 263 /* asi */, SystemZ::ASI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 267 /* au */, SystemZ::AU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 270 /* aur */, SystemZ::AUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 274 /* aw */, SystemZ::AW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 277 /* awr */, SystemZ::AWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 281 /* axbr */, SystemZ::AXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 286 /* axr */, SystemZ::AXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 290 /* axtr */, SystemZ::AXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 295 /* axtra */, SystemZ::AXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 301 /* ay */, SystemZ::AY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 304 /* b */, SystemZ::B, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 306 /* bakr */, SystemZ::BAKR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 311 /* bal */, SystemZ::BAL, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 315 /* balr */, SystemZ::BALR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 320 /* bas */, SystemZ::BAS, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 324 /* basr */, SystemZ::BASR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 329 /* bassm */, SystemZ::BASSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 335 /* bc */, SystemZ::BCAsm, Convert__U4Imm1_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp12 }, },
  { 338 /* bcr */, SystemZ::BCRAsm, Convert__U4Imm1_0__GR641_1, AMFBS_None, { MCK_U4Imm, MCK_GR64 }, },
  { 342 /* bct */, SystemZ::BCT, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 346 /* bctg */, SystemZ::BCTG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 351 /* bctgr */, SystemZ::BCTGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 357 /* bctr */, SystemZ::BCTR, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 362 /* bdepg */, SystemZ::BDEPG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 368 /* be */, SystemZ::BAsmE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 371 /* ber */, SystemZ::BRAsmE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 375 /* bextg */, SystemZ::BEXTG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 381 /* bh */, SystemZ::BAsmH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 384 /* bhe */, SystemZ::BAsmHE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 388 /* bher */, SystemZ::BRAsmHE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 393 /* bhr */, SystemZ::BRAsmH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 397 /* bi */, SystemZ::BI, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 400 /* bic */, SystemZ::BICAsm, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 404 /* bie */, SystemZ::BIAsmE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 408 /* bih */, SystemZ::BIAsmH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 412 /* bihe */, SystemZ::BIAsmHE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 417 /* bil */, SystemZ::BIAsmL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 421 /* bile */, SystemZ::BIAsmLE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 426 /* bilh */, SystemZ::BIAsmLH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 431 /* bim */, SystemZ::BIAsmM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 435 /* bine */, SystemZ::BIAsmNE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 440 /* binh */, SystemZ::BIAsmNH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 445 /* binhe */, SystemZ::BIAsmNHE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 451 /* binl */, SystemZ::BIAsmNL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 456 /* binle */, SystemZ::BIAsmNLE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 462 /* binlh */, SystemZ::BIAsmNLH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 468 /* binm */, SystemZ::BIAsmNM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 473 /* bino */, SystemZ::BIAsmNO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 478 /* binp */, SystemZ::BIAsmNP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 483 /* binz */, SystemZ::BIAsmNZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 488 /* bio */, SystemZ::BIAsmO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 492 /* bip */, SystemZ::BIAsmP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 496 /* biz */, SystemZ::BIAsmZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 500 /* bl */, SystemZ::BAsmL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 503 /* ble */, SystemZ::BAsmLE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 507 /* bler */, SystemZ::BRAsmLE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 512 /* blh */, SystemZ::BAsmLH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 516 /* blhr */, SystemZ::BRAsmLH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 521 /* blr */, SystemZ::BRAsmL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 525 /* bm */, SystemZ::BAsmM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 528 /* bmr */, SystemZ::BRAsmM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 532 /* bne */, SystemZ::BAsmNE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 536 /* bner */, SystemZ::BRAsmNE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 541 /* bnh */, SystemZ::BAsmNH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 545 /* bnhe */, SystemZ::BAsmNHE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 550 /* bnher */, SystemZ::BRAsmNHE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 556 /* bnhr */, SystemZ::BRAsmNH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 561 /* bnl */, SystemZ::BAsmNL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 565 /* bnle */, SystemZ::BAsmNLE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 570 /* bnler */, SystemZ::BRAsmNLE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 576 /* bnlh */, SystemZ::BAsmNLH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 581 /* bnlhr */, SystemZ::BRAsmNLH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 587 /* bnlr */, SystemZ::BRAsmNL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 592 /* bnm */, SystemZ::BAsmNM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 596 /* bnmr */, SystemZ::BRAsmNM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 601 /* bno */, SystemZ::BAsmNO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 605 /* bnor */, SystemZ::BRAsmNO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 610 /* bnp */, SystemZ::BAsmNP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 614 /* bnpr */, SystemZ::BRAsmNP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 619 /* bnz */, SystemZ::BAsmNZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 623 /* bnzr */, SystemZ::BRAsmNZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 628 /* bo */, SystemZ::BAsmO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 631 /* bor */, SystemZ::BRAsmO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 635 /* bp */, SystemZ::BAsmP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 638 /* bpp */, SystemZ::BPP, Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel16, MCK_BDAddr64Disp12 }, },
  { 642 /* bpr */, SystemZ::BRAsmP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 646 /* bprp */, SystemZ::BPRP, Convert__U4Imm1_0__PCRel121_1__PCRel241_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel12, MCK_PCRel24 }, },
  { 651 /* br */, SystemZ::BR, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 654 /* bras */, SystemZ::BRAS, Convert__GR641_0__PCRelTLS162_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS16 }, },
  { 659 /* brasl */, SystemZ::BRASL, Convert__GR641_0__PCRelTLS322_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS32 }, },
  { 665 /* brc */, SystemZ::BRCAsm, Convert__U4Imm1_0__PCRel161_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel16 }, },
  { 669 /* brcl */, SystemZ::BRCLAsm, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 674 /* brct */, SystemZ::BRCT, Convert__GR321_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR32, MCK_PCRel16 }, },
  { 679 /* brctg */, SystemZ::BRCTG, Convert__GR641_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR64, MCK_PCRel16 }, },
  { 685 /* brcth */, SystemZ::BRCTH, Convert__GRH321_0__Tie0_1_1__PCRel321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_PCRel32 }, },
  { 691 /* brxh */, SystemZ::BRXH, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 696 /* brxhg */, SystemZ::BRXHG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 702 /* brxle */, SystemZ::BRXLE, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 708 /* brxlg */, SystemZ::BRXLG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 714 /* bsa */, SystemZ::BSA, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 718 /* bsg */, SystemZ::BSG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 722 /* bsm */, SystemZ::BSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 726 /* bxh */, SystemZ::BXH, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 730 /* bxhg */, SystemZ::BXHG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 735 /* bxle */, SystemZ::BXLE, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 740 /* bxleg */, SystemZ::BXLEG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 746 /* bz */, SystemZ::BAsmZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 749 /* bzr */, SystemZ::BRAsmZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 753 /* c */, SystemZ::C, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 755 /* cal */, SystemZ::CAL, Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR32, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 759 /* calg */, SystemZ::CALG, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 764 /* calgf */, SystemZ::CALGF, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 770 /* cd */, SystemZ::CD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 773 /* cdb */, SystemZ::CDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 777 /* cdbr */, SystemZ::CDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 782 /* cdfbr */, SystemZ::CDFBR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 788 /* cdfbra */, SystemZ::CDFBRA, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 795 /* cdfr */, SystemZ::CDFR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 800 /* cdftr */, SystemZ::CDFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 806 /* cdgbr */, SystemZ::CDGBR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 812 /* cdgbra */, SystemZ::CDGBRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 819 /* cdgr */, SystemZ::CDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 824 /* cdgtr */, SystemZ::CDGTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 830 /* cdgtra */, SystemZ::CDGTRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 837 /* cdlfbr */, SystemZ::CDLFBR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 844 /* cdlftr */, SystemZ::CDLFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 851 /* cdlgbr */, SystemZ::CDLGBR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 858 /* cdlgtr */, SystemZ::CDLGTR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 865 /* cdpt */, SystemZ::CDPT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 870 /* cdr */, SystemZ::CDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 874 /* cds */, SystemZ::CDS, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp12 }, },
  { 878 /* cdsg */, SystemZ::CDSG, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 883 /* cdstr */, SystemZ::CDSTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 889 /* cdsy */, SystemZ::CDSY, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 894 /* cdtr */, SystemZ::CDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 899 /* cdutr */, SystemZ::CDUTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 905 /* cdzt */, SystemZ::CDZT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 910 /* ce */, SystemZ::CE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 913 /* ceb */, SystemZ::CEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 917 /* cebr */, SystemZ::CEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 922 /* cedtr */, SystemZ::CEDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 928 /* cefbr */, SystemZ::CEFBR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 934 /* cefbra */, SystemZ::CEFBRA, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 941 /* cefr */, SystemZ::CEFR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 946 /* cegbr */, SystemZ::CEGBR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 952 /* cegbra */, SystemZ::CEGBRA, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 959 /* cegr */, SystemZ::CEGR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 964 /* celfbr */, SystemZ::CELFBR, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 971 /* celgbr */, SystemZ::CELGBR, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 978 /* cer */, SystemZ::CER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 982 /* cextr */, SystemZ::CEXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 988 /* cfc */, SystemZ::CFC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 992 /* cfdbr */, SystemZ::CFDBR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 998 /* cfdbra */, SystemZ::CFDBRA, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1005 /* cfdr */, SystemZ::CFDR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 1010 /* cfdtr */, SystemZ::CFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1016 /* cfebr */, SystemZ::CFEBR, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1022 /* cfebra */, SystemZ::CFEBRA, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1029 /* cfer */, SystemZ::CFER, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1034 /* cfi */, SystemZ::CFI, Convert__GR321_0__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 1038 /* cfxbr */, SystemZ::CFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1044 /* cfxbra */, SystemZ::CFXBRA, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1051 /* cfxr */, SystemZ::CFXR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1056 /* cfxtr */, SystemZ::CFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1062 /* cg */, SystemZ::CG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1065 /* cgdbr */, SystemZ::CGDBR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1071 /* cgdbra */, SystemZ::CGDBRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1078 /* cgdr */, SystemZ::CGDR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1083 /* cgdtr */, SystemZ::CGDTR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1089 /* cgdtra */, SystemZ::CGDTRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1096 /* cgebr */, SystemZ::CGEBR, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1102 /* cgebra */, SystemZ::CGEBRA, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1109 /* cger */, SystemZ::CGER, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1114 /* cgf */, SystemZ::CGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1118 /* cgfi */, SystemZ::CGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 1123 /* cgfr */, SystemZ::CGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 1128 /* cgfrl */, SystemZ::CGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1134 /* cgh */, SystemZ::CGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1138 /* cghi */, SystemZ::CGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1143 /* cghrl */, SystemZ::CGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1149 /* cghsi */, SystemZ::CGHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1155 /* cgib */, SystemZ::CGIBAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1160 /* cgibe */, SystemZ::CGIBAsmE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1166 /* cgibh */, SystemZ::CGIBAsmH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1172 /* cgibhe */, SystemZ::CGIBAsmHE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1179 /* cgibl */, SystemZ::CGIBAsmL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1185 /* cgible */, SystemZ::CGIBAsmLE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1192 /* cgiblh */, SystemZ::CGIBAsmLH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1199 /* cgibne */, SystemZ::CGIBAsmNE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1206 /* cgibnh */, SystemZ::CGIBAsmNH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1213 /* cgibnhe */, SystemZ::CGIBAsmNHE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1221 /* cgibnl */, SystemZ::CGIBAsmNL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1228 /* cgibnle */, SystemZ::CGIBAsmNLE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1236 /* cgibnlh */, SystemZ::CGIBAsmNLH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1244 /* cgij */, SystemZ::CGIJAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1249 /* cgije */, SystemZ::CGIJAsmE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1255 /* cgijh */, SystemZ::CGIJAsmH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1261 /* cgijhe */, SystemZ::CGIJAsmHE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1268 /* cgijl */, SystemZ::CGIJAsmL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1274 /* cgijle */, SystemZ::CGIJAsmLE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1281 /* cgijlh */, SystemZ::CGIJAsmLH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1288 /* cgijne */, SystemZ::CGIJAsmNE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1295 /* cgijnh */, SystemZ::CGIJAsmNH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1302 /* cgijnhe */, SystemZ::CGIJAsmNHE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1310 /* cgijnl */, SystemZ::CGIJAsmNL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1317 /* cgijnle */, SystemZ::CGIJAsmNLE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1325 /* cgijnlh */, SystemZ::CGIJAsmNLH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1333 /* cgit */, SystemZ::CGITAsm, Convert__GR641_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 1338 /* cgite */, SystemZ::CGITAsmE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1344 /* cgith */, SystemZ::CGITAsmH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1350 /* cgithe */, SystemZ::CGITAsmHE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1357 /* cgitl */, SystemZ::CGITAsmL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1363 /* cgitle */, SystemZ::CGITAsmLE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1370 /* cgitlh */, SystemZ::CGITAsmLH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1377 /* cgitne */, SystemZ::CGITAsmNE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1384 /* cgitnh */, SystemZ::CGITAsmNH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1391 /* cgitnhe */, SystemZ::CGITAsmNHE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1399 /* cgitnl */, SystemZ::CGITAsmNL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1406 /* cgitnle */, SystemZ::CGITAsmNLE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1414 /* cgitnlh */, SystemZ::CGITAsmNLH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1422 /* cgr */, SystemZ::CGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1426 /* cgrb */, SystemZ::CGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1431 /* cgrbe */, SystemZ::CGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1437 /* cgrbh */, SystemZ::CGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1443 /* cgrbhe */, SystemZ::CGRBAsmHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1450 /* cgrbl */, SystemZ::CGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1456 /* cgrble */, SystemZ::CGRBAsmLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1463 /* cgrblh */, SystemZ::CGRBAsmLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1470 /* cgrbne */, SystemZ::CGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1477 /* cgrbnh */, SystemZ::CGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1484 /* cgrbnhe */, SystemZ::CGRBAsmNHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1492 /* cgrbnl */, SystemZ::CGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1499 /* cgrbnle */, SystemZ::CGRBAsmNLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1507 /* cgrbnlh */, SystemZ::CGRBAsmNLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1515 /* cgrj */, SystemZ::CGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 1520 /* cgrje */, SystemZ::CGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1526 /* cgrjh */, SystemZ::CGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1532 /* cgrjhe */, SystemZ::CGRJAsmHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1539 /* cgrjl */, SystemZ::CGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1545 /* cgrjle */, SystemZ::CGRJAsmLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1552 /* cgrjlh */, SystemZ::CGRJAsmLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1559 /* cgrjne */, SystemZ::CGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1566 /* cgrjnh */, SystemZ::CGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1573 /* cgrjnhe */, SystemZ::CGRJAsmNHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1581 /* cgrjnl */, SystemZ::CGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1588 /* cgrjnle */, SystemZ::CGRJAsmNLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1596 /* cgrjnlh */, SystemZ::CGRJAsmNLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1604 /* cgrl */, SystemZ::CGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1609 /* cgrt */, SystemZ::CGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 1614 /* cgrte */, SystemZ::CGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1620 /* cgrth */, SystemZ::CGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1626 /* cgrthe */, SystemZ::CGRTAsmHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1633 /* cgrtl */, SystemZ::CGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1639 /* cgrtle */, SystemZ::CGRTAsmLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1646 /* cgrtlh */, SystemZ::CGRTAsmLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1653 /* cgrtne */, SystemZ::CGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1660 /* cgrtnh */, SystemZ::CGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1667 /* cgrtnhe */, SystemZ::CGRTAsmNHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1675 /* cgrtnl */, SystemZ::CGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1682 /* cgrtnle */, SystemZ::CGRTAsmNLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1690 /* cgrtnlh */, SystemZ::CGRTAsmNLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1698 /* cgxbr */, SystemZ::CGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1704 /* cgxbra */, SystemZ::CGXBRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1711 /* cgxr */, SystemZ::CGXR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1716 /* cgxtr */, SystemZ::CGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1722 /* cgxtra */, SystemZ::CGXTRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1729 /* ch */, SystemZ::CH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 1732 /* chf */, SystemZ::CHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 1736 /* chhr */, SystemZ::CHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 1741 /* chhsi */, SystemZ::CHHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1747 /* chi */, SystemZ::CHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1751 /* chlr */, SystemZ::CHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 1756 /* chrl */, SystemZ::CHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 1761 /* chsi */, SystemZ::CHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1766 /* chy */, SystemZ::CHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 1770 /* cib */, SystemZ::CIBAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1774 /* cibe */, SystemZ::CIBAsmE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1779 /* cibh */, SystemZ::CIBAsmH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1784 /* cibhe */, SystemZ::CIBAsmHE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1790 /* cibl */, SystemZ::CIBAsmL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1795 /* cible */, SystemZ::CIBAsmLE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1801 /* ciblh */, SystemZ::CIBAsmLH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1807 /* cibne */, SystemZ::CIBAsmNE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1813 /* cibnh */, SystemZ::CIBAsmNH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1819 /* cibnhe */, SystemZ::CIBAsmNHE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1826 /* cibnl */, SystemZ::CIBAsmNL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1832 /* cibnle */, SystemZ::CIBAsmNLE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1839 /* cibnlh */, SystemZ::CIBAsmNLH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1846 /* cih */, SystemZ::CIH, Convert__GRH321_0__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 1850 /* cij */, SystemZ::CIJAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1854 /* cije */, SystemZ::CIJAsmE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1859 /* cijh */, SystemZ::CIJAsmH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1864 /* cijhe */, SystemZ::CIJAsmHE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1870 /* cijl */, SystemZ::CIJAsmL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1875 /* cijle */, SystemZ::CIJAsmLE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1881 /* cijlh */, SystemZ::CIJAsmLH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1887 /* cijne */, SystemZ::CIJAsmNE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1893 /* cijnh */, SystemZ::CIJAsmNH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1899 /* cijnhe */, SystemZ::CIJAsmNHE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1906 /* cijnl */, SystemZ::CIJAsmNL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1912 /* cijnle */, SystemZ::CIJAsmNLE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1919 /* cijnlh */, SystemZ::CIJAsmNLH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1926 /* cit */, SystemZ::CITAsm, Convert__GR321_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 1930 /* cite */, SystemZ::CITAsmE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1935 /* cith */, SystemZ::CITAsmH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1940 /* cithe */, SystemZ::CITAsmHE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1946 /* citl */, SystemZ::CITAsmL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1951 /* citle */, SystemZ::CITAsmLE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1957 /* citlh */, SystemZ::CITAsmLH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1963 /* citne */, SystemZ::CITAsmNE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1969 /* citnh */, SystemZ::CITAsmNH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1975 /* citnhe */, SystemZ::CITAsmNHE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1982 /* citnl */, SystemZ::CITAsmNL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1988 /* citnle */, SystemZ::CITAsmNLE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1995 /* citnlh */, SystemZ::CITAsmNLH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 2002 /* cksm */, SystemZ::CKSM, Convert__GR321_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR32, MCK_GR128 }, },
  { 2007 /* cl */, SystemZ::CL, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2010 /* clc */, SystemZ::CLC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 2014 /* clcl */, SystemZ::CLCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 2019 /* clcle */, SystemZ::CLCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 2025 /* clclu */, SystemZ::CLCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 2031 /* clfdbr */, SystemZ::CLFDBR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2038 /* clfdtr */, SystemZ::CLFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2045 /* clfebr */, SystemZ::CLFEBR, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2052 /* clfhsi */, SystemZ::CLFHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2059 /* clfi */, SystemZ::CLFI, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 2064 /* clfit */, SystemZ::CLFITAsm, Convert__GR321_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_U16Imm, MCK_U4Imm }, },
  { 2070 /* clfite */, SystemZ::CLFITAsmE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2077 /* clfith */, SystemZ::CLFITAsmH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2084 /* clfithe */, SystemZ::CLFITAsmHE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2092 /* clfitl */, SystemZ::CLFITAsmL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2099 /* clfitle */, SystemZ::CLFITAsmLE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2107 /* clfitlh */, SystemZ::CLFITAsmLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2115 /* clfitne */, SystemZ::CLFITAsmNE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2123 /* clfitnh */, SystemZ::CLFITAsmNH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2131 /* clfitnhe */, SystemZ::CLFITAsmNHE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2140 /* clfitnl */, SystemZ::CLFITAsmNL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2148 /* clfitnle */, SystemZ::CLFITAsmNLE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2157 /* clfitnlh */, SystemZ::CLFITAsmNLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2166 /* clfxbr */, SystemZ::CLFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2173 /* clfxtr */, SystemZ::CLFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2180 /* clg */, SystemZ::CLG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2184 /* clgdbr */, SystemZ::CLGDBR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2191 /* clgdtr */, SystemZ::CLGDTR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2198 /* clgebr */, SystemZ::CLGEBR, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2205 /* clgf */, SystemZ::CLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2210 /* clgfi */, SystemZ::CLGFI, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 2216 /* clgfr */, SystemZ::CLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 2222 /* clgfrl */, SystemZ::CLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2229 /* clghrl */, SystemZ::CLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2236 /* clghsi */, SystemZ::CLGHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2243 /* clgib */, SystemZ::CLGIBAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2249 /* clgibe */, SystemZ::CLGIBAsmE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2256 /* clgibh */, SystemZ::CLGIBAsmH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2263 /* clgibhe */, SystemZ::CLGIBAsmHE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2271 /* clgibl */, SystemZ::CLGIBAsmL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2278 /* clgible */, SystemZ::CLGIBAsmLE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2286 /* clgiblh */, SystemZ::CLGIBAsmLH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2294 /* clgibne */, SystemZ::CLGIBAsmNE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2302 /* clgibnh */, SystemZ::CLGIBAsmNH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2310 /* clgibnhe */, SystemZ::CLGIBAsmNHE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2319 /* clgibnl */, SystemZ::CLGIBAsmNL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2327 /* clgibnle */, SystemZ::CLGIBAsmNLE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2336 /* clgibnlh */, SystemZ::CLGIBAsmNLH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2345 /* clgij */, SystemZ::CLGIJAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 2351 /* clgije */, SystemZ::CLGIJAsmE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2358 /* clgijh */, SystemZ::CLGIJAsmH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2365 /* clgijhe */, SystemZ::CLGIJAsmHE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2373 /* clgijl */, SystemZ::CLGIJAsmL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2380 /* clgijle */, SystemZ::CLGIJAsmLE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2388 /* clgijlh */, SystemZ::CLGIJAsmLH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2396 /* clgijne */, SystemZ::CLGIJAsmNE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2404 /* clgijnh */, SystemZ::CLGIJAsmNH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2412 /* clgijnhe */, SystemZ::CLGIJAsmNHE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2421 /* clgijnl */, SystemZ::CLGIJAsmNL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2429 /* clgijnle */, SystemZ::CLGIJAsmNLE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2438 /* clgijnlh */, SystemZ::CLGIJAsmNLH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2447 /* clgit */, SystemZ::CLGITAsm, Convert__GR641_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_U16Imm, MCK_U4Imm }, },
  { 2453 /* clgite */, SystemZ::CLGITAsmE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2460 /* clgith */, SystemZ::CLGITAsmH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2467 /* clgithe */, SystemZ::CLGITAsmHE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2475 /* clgitl */, SystemZ::CLGITAsmL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2482 /* clgitle */, SystemZ::CLGITAsmLE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2490 /* clgitlh */, SystemZ::CLGITAsmLH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2498 /* clgitne */, SystemZ::CLGITAsmNE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2506 /* clgitnh */, SystemZ::CLGITAsmNH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2514 /* clgitnhe */, SystemZ::CLGITAsmNHE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2523 /* clgitnl */, SystemZ::CLGITAsmNL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2531 /* clgitnle */, SystemZ::CLGITAsmNLE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2540 /* clgitnlh */, SystemZ::CLGITAsmNLH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2549 /* clgr */, SystemZ::CLGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2554 /* clgrb */, SystemZ::CLGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2560 /* clgrbe */, SystemZ::CLGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2567 /* clgrbh */, SystemZ::CLGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2574 /* clgrbhe */, SystemZ::CLGRBAsmHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2582 /* clgrbl */, SystemZ::CLGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2589 /* clgrble */, SystemZ::CLGRBAsmLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2597 /* clgrblh */, SystemZ::CLGRBAsmLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2605 /* clgrbne */, SystemZ::CLGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2613 /* clgrbnh */, SystemZ::CLGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2621 /* clgrbnhe */, SystemZ::CLGRBAsmNHE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2630 /* clgrbnl */, SystemZ::CLGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2638 /* clgrbnle */, SystemZ::CLGRBAsmNLE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2647 /* clgrbnlh */, SystemZ::CLGRBAsmNLH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2656 /* clgrj */, SystemZ::CLGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 2662 /* clgrje */, SystemZ::CLGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2669 /* clgrjh */, SystemZ::CLGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2676 /* clgrjhe */, SystemZ::CLGRJAsmHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2684 /* clgrjl */, SystemZ::CLGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2691 /* clgrjle */, SystemZ::CLGRJAsmLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2699 /* clgrjlh */, SystemZ::CLGRJAsmLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2707 /* clgrjne */, SystemZ::CLGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2715 /* clgrjnh */, SystemZ::CLGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2723 /* clgrjnhe */, SystemZ::CLGRJAsmNHE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2732 /* clgrjnl */, SystemZ::CLGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2740 /* clgrjnle */, SystemZ::CLGRJAsmNLE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2749 /* clgrjnlh */, SystemZ::CLGRJAsmNLH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2758 /* clgrl */, SystemZ::CLGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2764 /* clgrt */, SystemZ::CLGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 2770 /* clgrte */, SystemZ::CLGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2777 /* clgrth */, SystemZ::CLGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2784 /* clgrthe */, SystemZ::CLGRTAsmHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2792 /* clgrtl */, SystemZ::CLGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2799 /* clgrtle */, SystemZ::CLGRTAsmLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2807 /* clgrtlh */, SystemZ::CLGRTAsmLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2815 /* clgrtne */, SystemZ::CLGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2823 /* clgrtnh */, SystemZ::CLGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2831 /* clgrtnhe */, SystemZ::CLGRTAsmNHE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2840 /* clgrtnl */, SystemZ::CLGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2848 /* clgrtnle */, SystemZ::CLGRTAsmNLE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2857 /* clgrtnlh */, SystemZ::CLGRTAsmNLH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2866 /* clgt */, SystemZ::CLGTAsm, Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 2871 /* clgte */, SystemZ::CLGTAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2877 /* clgth */, SystemZ::CLGTAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2883 /* clgthe */, SystemZ::CLGTAsmHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2890 /* clgtl */, SystemZ::CLGTAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2896 /* clgtle */, SystemZ::CLGTAsmLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2903 /* clgtlh */, SystemZ::CLGTAsmLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2910 /* clgtne */, SystemZ::CLGTAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2917 /* clgtnh */, SystemZ::CLGTAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2924 /* clgtnhe */, SystemZ::CLGTAsmNHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2932 /* clgtnl */, SystemZ::CLGTAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2939 /* clgtnle */, SystemZ::CLGTAsmNLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2947 /* clgtnlh */, SystemZ::CLGTAsmNLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2955 /* clgxbr */, SystemZ::CLGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2962 /* clgxtr */, SystemZ::CLGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2969 /* clhf */, SystemZ::CLHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 2974 /* clhhr */, SystemZ::CLHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 2980 /* clhhsi */, SystemZ::CLHHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2987 /* clhlr */, SystemZ::CLHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 2993 /* clhrl */, SystemZ::CLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 2999 /* cli */, SystemZ::CLI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 3003 /* clib */, SystemZ::CLIBAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3008 /* clibe */, SystemZ::CLIBAsmE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3014 /* clibh */, SystemZ::CLIBAsmH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3020 /* clibhe */, SystemZ::CLIBAsmHE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3027 /* clibl */, SystemZ::CLIBAsmL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3033 /* clible */, SystemZ::CLIBAsmLE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3040 /* cliblh */, SystemZ::CLIBAsmLH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3047 /* clibne */, SystemZ::CLIBAsmNE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3054 /* clibnh */, SystemZ::CLIBAsmNH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3061 /* clibnhe */, SystemZ::CLIBAsmNHE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3069 /* clibnl */, SystemZ::CLIBAsmNL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3076 /* clibnle */, SystemZ::CLIBAsmNLE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3084 /* clibnlh */, SystemZ::CLIBAsmNLH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3092 /* clih */, SystemZ::CLIH, Convert__GRH321_0__U32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_U32Imm }, },
  { 3097 /* clij */, SystemZ::CLIJAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 3102 /* clije */, SystemZ::CLIJAsmE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3108 /* clijh */, SystemZ::CLIJAsmH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3114 /* clijhe */, SystemZ::CLIJAsmHE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3121 /* clijl */, SystemZ::CLIJAsmL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3127 /* clijle */, SystemZ::CLIJAsmLE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3134 /* clijlh */, SystemZ::CLIJAsmLH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3141 /* clijne */, SystemZ::CLIJAsmNE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3148 /* clijnh */, SystemZ::CLIJAsmNH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3155 /* clijnhe */, SystemZ::CLIJAsmNHE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3163 /* clijnl */, SystemZ::CLIJAsmNL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3170 /* clijnle */, SystemZ::CLIJAsmNLE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3178 /* clijnlh */, SystemZ::CLIJAsmNLH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3186 /* cliy */, SystemZ::CLIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 3191 /* clm */, SystemZ::CLM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3195 /* clmh */, SystemZ::CLMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3200 /* clmy */, SystemZ::CLMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3205 /* clr */, SystemZ::CLR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3209 /* clrb */, SystemZ::CLRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3214 /* clrbe */, SystemZ::CLRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3220 /* clrbh */, SystemZ::CLRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3226 /* clrbhe */, SystemZ::CLRBAsmHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3233 /* clrbl */, SystemZ::CLRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3239 /* clrble */, SystemZ::CLRBAsmLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3246 /* clrblh */, SystemZ::CLRBAsmLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3253 /* clrbne */, SystemZ::CLRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3260 /* clrbnh */, SystemZ::CLRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3267 /* clrbnhe */, SystemZ::CLRBAsmNHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3275 /* clrbnl */, SystemZ::CLRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3282 /* clrbnle */, SystemZ::CLRBAsmNLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3290 /* clrbnlh */, SystemZ::CLRBAsmNLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3298 /* clrj */, SystemZ::CLRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3303 /* clrje */, SystemZ::CLRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3309 /* clrjh */, SystemZ::CLRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3315 /* clrjhe */, SystemZ::CLRJAsmHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3322 /* clrjl */, SystemZ::CLRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3328 /* clrjle */, SystemZ::CLRJAsmLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3335 /* clrjlh */, SystemZ::CLRJAsmLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3342 /* clrjne */, SystemZ::CLRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3349 /* clrjnh */, SystemZ::CLRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3356 /* clrjnhe */, SystemZ::CLRJAsmNHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3364 /* clrjnl */, SystemZ::CLRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3371 /* clrjnle */, SystemZ::CLRJAsmNLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3379 /* clrjnlh */, SystemZ::CLRJAsmNLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3387 /* clrl */, SystemZ::CLRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3392 /* clrt */, SystemZ::CLRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3397 /* clrte */, SystemZ::CLRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3403 /* clrth */, SystemZ::CLRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3409 /* clrthe */, SystemZ::CLRTAsmHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3416 /* clrtl */, SystemZ::CLRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3422 /* clrtle */, SystemZ::CLRTAsmLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3429 /* clrtlh */, SystemZ::CLRTAsmLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3436 /* clrtne */, SystemZ::CLRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3443 /* clrtnh */, SystemZ::CLRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3450 /* clrtnhe */, SystemZ::CLRTAsmNHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3458 /* clrtnl */, SystemZ::CLRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3465 /* clrtnle */, SystemZ::CLRTAsmNLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3473 /* clrtnlh */, SystemZ::CLRTAsmNLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3481 /* clst */, SystemZ::CLST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3486 /* clt */, SystemZ::CLTAsm, Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3490 /* clte */, SystemZ::CLTAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3495 /* clth */, SystemZ::CLTAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3500 /* clthe */, SystemZ::CLTAsmHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3506 /* cltl */, SystemZ::CLTAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3511 /* cltle */, SystemZ::CLTAsmLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3517 /* cltlh */, SystemZ::CLTAsmLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3523 /* cltne */, SystemZ::CLTAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3529 /* cltnh */, SystemZ::CLTAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3535 /* cltnhe */, SystemZ::CLTAsmNHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3542 /* cltnl */, SystemZ::CLTAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3548 /* cltnle */, SystemZ::CLTAsmNLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3555 /* cltnlh */, SystemZ::CLTAsmNLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3562 /* cly */, SystemZ::CLY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3566 /* clzg */, SystemZ::CLZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3571 /* cmpsc */, SystemZ::CMPSC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3577 /* cp */, SystemZ::CP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 3580 /* cpdt */, SystemZ::CPDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3585 /* cpsdr */, SystemZ::CPSDRdd, Convert__FP641_0__FP641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 3591 /* cpxt */, SystemZ::CPXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3596 /* cpya */, SystemZ::CPYA, Convert__AR321_0__AR321_1, AMFBS_None, { MCK_AR32, MCK_AR32 }, },
  { 3601 /* cr */, SystemZ::CR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3604 /* crb */, SystemZ::CRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3608 /* crbe */, SystemZ::CRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3613 /* crbh */, SystemZ::CRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3618 /* crbhe */, SystemZ::CRBAsmHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3624 /* crbl */, SystemZ::CRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3629 /* crble */, SystemZ::CRBAsmLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3635 /* crblh */, SystemZ::CRBAsmLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3641 /* crbne */, SystemZ::CRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3647 /* crbnh */, SystemZ::CRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3653 /* crbnhe */, SystemZ::CRBAsmNHE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3660 /* crbnl */, SystemZ::CRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3666 /* crbnle */, SystemZ::CRBAsmNLE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3673 /* crbnlh */, SystemZ::CRBAsmNLH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3680 /* crdte */, SystemZ::CRDTEOpt, Convert__GR1281_0__GR1281_2__GR641_1, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128 }, },
  { 3680 /* crdte */, SystemZ::CRDTE, Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 3686 /* crj */, SystemZ::CRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3690 /* crje */, SystemZ::CRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3695 /* crjh */, SystemZ::CRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3700 /* crjhe */, SystemZ::CRJAsmHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3706 /* crjl */, SystemZ::CRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3711 /* crjle */, SystemZ::CRJAsmLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3717 /* crjlh */, SystemZ::CRJAsmLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3723 /* crjne */, SystemZ::CRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3729 /* crjnh */, SystemZ::CRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3735 /* crjnhe */, SystemZ::CRJAsmNHE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3742 /* crjnl */, SystemZ::CRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3748 /* crjnle */, SystemZ::CRJAsmNLE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3755 /* crjnlh */, SystemZ::CRJAsmNLH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3762 /* crl */, SystemZ::CRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3766 /* crt */, SystemZ::CRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3770 /* crte */, SystemZ::CRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3775 /* crth */, SystemZ::CRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3780 /* crthe */, SystemZ::CRTAsmHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3786 /* crtl */, SystemZ::CRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3791 /* crtle */, SystemZ::CRTAsmLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3797 /* crtlh */, SystemZ::CRTAsmLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3803 /* crtne */, SystemZ::CRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3809 /* crtnh */, SystemZ::CRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3815 /* crtnhe */, SystemZ::CRTAsmNHE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3822 /* crtnl */, SystemZ::CRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3828 /* crtnle */, SystemZ::CRTAsmNLE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3835 /* crtnlh */, SystemZ::CRTAsmNLH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3842 /* cs */, SystemZ::CS, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3845 /* csch */, SystemZ::CSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 3850 /* csdtr */, SystemZ::CSDTR, Convert__GR641_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_FP64, MCK_U4Imm }, },
  { 3856 /* csg */, SystemZ::CSG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 3860 /* csp */, SystemZ::CSP, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3864 /* cspg */, SystemZ::CSPG, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3869 /* csst */, SystemZ::CSST, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 3874 /* csxtr */, SystemZ::CSXTR, Convert__GR1281_0__FP1281_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_FP128, MCK_U4Imm }, },
  { 3880 /* csy */, SystemZ::CSY, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3884 /* ctzg */, SystemZ::CTZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3889 /* cu12 */, SystemZ::CU12Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3889 /* cu12 */, SystemZ::CU12, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3894 /* cu14 */, SystemZ::CU14Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3894 /* cu14 */, SystemZ::CU14, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3899 /* cu21 */, SystemZ::CU21Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3899 /* cu21 */, SystemZ::CU21, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3904 /* cu24 */, SystemZ::CU24Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3904 /* cu24 */, SystemZ::CU24, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3909 /* cu41 */, SystemZ::CU41, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3914 /* cu42 */, SystemZ::CU42, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3919 /* cudtr */, SystemZ::CUDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 3925 /* cuse */, SystemZ::CUSE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3930 /* cutfu */, SystemZ::CUTFUOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3930 /* cutfu */, SystemZ::CUTFU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3936 /* cuutf */, SystemZ::CUUTFOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3936 /* cuutf */, SystemZ::CUUTF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3942 /* cuxtr */, SystemZ::CUXTR, Convert__GR1281_0__FP1281_1, AMFBS_None, { MCK_GR128, MCK_FP128 }, },
  { 3948 /* cvb */, SystemZ::CVB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3952 /* cvbg */, SystemZ::CVBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3957 /* cvby */, SystemZ::CVBY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3962 /* cvd */, SystemZ::CVD, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3966 /* cvdg */, SystemZ::CVDG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3971 /* cvdy */, SystemZ::CVDY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3976 /* cxbr */, SystemZ::CXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 3981 /* cxfbr */, SystemZ::CXFBR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3987 /* cxfbra */, SystemZ::CXFBRA, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 3994 /* cxfr */, SystemZ::CXFR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3999 /* cxftr */, SystemZ::CXFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4005 /* cxgbr */, SystemZ::CXGBR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4011 /* cxgbra */, SystemZ::CXGBRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4018 /* cxgr */, SystemZ::CXGR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4023 /* cxgtr */, SystemZ::CXGTR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4029 /* cxgtra */, SystemZ::CXGTRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4036 /* cxlfbr */, SystemZ::CXLFBR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4043 /* cxlftr */, SystemZ::CXLFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4050 /* cxlgbr */, SystemZ::CXLGBR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4057 /* cxlgtr */, SystemZ::CXLGTR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4064 /* cxpt */, SystemZ::CXPT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4069 /* cxr */, SystemZ::CXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4073 /* cxstr */, SystemZ::CXSTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4079 /* cxtr */, SystemZ::CXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4084 /* cxutr */, SystemZ::CXUTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4090 /* cxzt */, SystemZ::CXZT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4095 /* cy */, SystemZ::CY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4098 /* czdt */, SystemZ::CZDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4103 /* czxt */, SystemZ::CZXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4108 /* d */, SystemZ::D, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 4110 /* dd */, SystemZ::DD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4113 /* ddb */, SystemZ::DDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4117 /* ddbr */, SystemZ::DDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4122 /* ddr */, SystemZ::DDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4126 /* ddtr */, SystemZ::DDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 4131 /* ddtra */, SystemZ::DDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4137 /* de */, SystemZ::DE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4140 /* deb */, SystemZ::DEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4144 /* debr */, SystemZ::DEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4149 /* der */, SystemZ::DER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4153 /* dfltcc */, SystemZ::DFLTCC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2, AMFBS_FeatureDeflateConversion, { MCK_GR128, MCK_GR128, MCK_GR64 }, },
  { 4160 /* diag */, SystemZ::DIAG, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 4165 /* didbr */, SystemZ::DIDBR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4171 /* diebr */, SystemZ::DIEBR, Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32, MCK_U4Imm }, },
  { 4177 /* dl */, SystemZ::DL, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4180 /* dlg */, SystemZ::DLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4184 /* dlgr */, SystemZ::DLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4189 /* dlr */, SystemZ::DLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4193 /* dp */, SystemZ::DP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 4196 /* dr */, SystemZ::DR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4199 /* dsg */, SystemZ::DSG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4203 /* dsgf */, SystemZ::DSGF, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4208 /* dsgfr */, SystemZ::DSGFR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4214 /* dsgr */, SystemZ::DSGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4219 /* dxbr */, SystemZ::DXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4224 /* dxr */, SystemZ::DXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4228 /* dxtr */, SystemZ::DXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 4233 /* dxtra */, SystemZ::DXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 4239 /* ear */, SystemZ::EAR, Convert__GR321_0__AR321_1, AMFBS_None, { MCK_GR32, MCK_AR32 }, },
  { 4243 /* ecag */, SystemZ::ECAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 4248 /* ecctr */, SystemZ::ECCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4254 /* ecpga */, SystemZ::ECPGA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4260 /* ectg */, SystemZ::ECTG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 4265 /* ed */, SystemZ::ED, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4268 /* edmk */, SystemZ::EDMK, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4273 /* eedtr */, SystemZ::EEDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4279 /* eextr */, SystemZ::EEXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4285 /* efpc */, SystemZ::EFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4290 /* epair */, SystemZ::EPAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4296 /* epar */, SystemZ::EPAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4301 /* epctr */, SystemZ::EPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4307 /* epsw */, SystemZ::EPSW, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4312 /* ereg */, SystemZ::EREG, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4317 /* eregg */, SystemZ::EREGG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4323 /* esair */, SystemZ::ESAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4329 /* esar */, SystemZ::ESAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4334 /* esdtr */, SystemZ::ESDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4340 /* esea */, SystemZ::ESEA, Convert__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 4345 /* esta */, SystemZ::ESTA, Convert__GR1281_0__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4350 /* esxtr */, SystemZ::ESXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4356 /* etnd */, SystemZ::ETND, Convert__GR321_0, AMFBS_FeatureTransactionalExecution, { MCK_GR32 }, },
  { 4361 /* ex */, SystemZ::EX, Convert__ADDR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_ADDR64, MCK_BDXAddr64Disp12 }, },
  { 4364 /* exrl */, SystemZ::EXRL, Convert__ADDR641_0__PCRel321_1, AMFBS_None, { MCK_ADDR64, MCK_PCRel32 }, },
  { 4369 /* fidbr */, SystemZ::FIDBR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 4375 /* fidbra */, SystemZ::FIDBRA, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4382 /* fidr */, SystemZ::FIDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4387 /* fidtr */, SystemZ::FIDTR, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4393 /* fiebr */, SystemZ::FIEBR, Convert__FP321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP32 }, },
  { 4399 /* fiebra */, SystemZ::FIEBRA, Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 4406 /* fier */, SystemZ::FIER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4411 /* fixbr */, SystemZ::FIXBR, Convert__FP1281_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128 }, },
  { 4417 /* fixbra */, SystemZ::FIXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4424 /* fixr */, SystemZ::FIXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4429 /* fixtr */, SystemZ::FIXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4435 /* flogr */, SystemZ::FLOGR, Convert__GR1281_0__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4441 /* hdr */, SystemZ::HDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4445 /* her */, SystemZ::HER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4449 /* hsch */, SystemZ::HSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 4454 /* iac */, SystemZ::IAC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4458 /* ic */, SystemZ::IC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4461 /* icm */, SystemZ::ICM, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 4465 /* icmh */, SystemZ::ICMH, Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4470 /* icmy */, SystemZ::ICMY, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4475 /* icy */, SystemZ::ICY, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4479 /* idte */, SystemZ::IDTEOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4479 /* idte */, SystemZ::IDTE, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 4484 /* iedtr */, SystemZ::IEDTR, Convert__FP641_0__GR641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR64 }, },
  { 4490 /* iextr */, SystemZ::IEXTR, Convert__FP1281_0__GR641_2__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR64 }, },
  { 4496 /* iihf */, SystemZ::IIHF, Convert__GRH321_0__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 4501 /* iihh */, SystemZ::IIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4506 /* iihl */, SystemZ::IIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4511 /* iilf */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 4516 /* iilh */, SystemZ::IILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4521 /* iill */, SystemZ::IILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4526 /* ipk */, SystemZ::IPK, Convert_NoOperands, AMFBS_None, {  }, },
  { 4530 /* ipm */, SystemZ::IPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTEOptOpt, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTEOpt, Convert__GR641_0__GR321_1__GR321_2, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTE, Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 4539 /* irbm */, SystemZ::IRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureInsertReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 4544 /* iske */, SystemZ::ISKE, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4549 /* ivsk */, SystemZ::IVSK, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4554 /* j */, SystemZ::J, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4556 /* je */, SystemZ::JAsmE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4559 /* jg */, SystemZ::JG, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4562 /* jge */, SystemZ::JGAsmE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4566 /* jgh */, SystemZ::JGAsmH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4570 /* jghe */, SystemZ::JGAsmHE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4575 /* jgl */, SystemZ::JGAsmL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4579 /* jgle */, SystemZ::JGAsmLE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4584 /* jglh */, SystemZ::JGAsmLH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4589 /* jgm */, SystemZ::JGAsmM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4593 /* jgne */, SystemZ::JGAsmNE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4598 /* jgnh */, SystemZ::JGAsmNH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4603 /* jgnhe */, SystemZ::JGAsmNHE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4609 /* jgnl */, SystemZ::JGAsmNL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4614 /* jgnle */, SystemZ::JGAsmNLE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4620 /* jgnlh */, SystemZ::JGAsmNLH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4626 /* jgnm */, SystemZ::JGAsmNM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4631 /* jgno */, SystemZ::JGAsmNO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4636 /* jgnop */, SystemZ::JGNOP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4642 /* jgnp */, SystemZ::JGAsmNP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4647 /* jgnz */, SystemZ::JGAsmNZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4652 /* jgo */, SystemZ::JGAsmO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4656 /* jgp */, SystemZ::JGAsmP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4660 /* jgz */, SystemZ::JGAsmZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4664 /* jh */, SystemZ::JAsmH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4667 /* jhe */, SystemZ::JAsmHE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4671 /* jl */, SystemZ::JAsmL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4674 /* jle */, SystemZ::JAsmLE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4678 /* jlh */, SystemZ::JAsmLH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4747 /* jm */, SystemZ::JAsmM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4750 /* jne */, SystemZ::JAsmNE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4754 /* jnh */, SystemZ::JAsmNH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4758 /* jnhe */, SystemZ::JAsmNHE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4763 /* jnl */, SystemZ::JAsmNL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4767 /* jnle */, SystemZ::JAsmNLE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4772 /* jnlh */, SystemZ::JAsmNLH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4777 /* jnm */, SystemZ::JAsmNM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4781 /* jno */, SystemZ::JAsmNO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4785 /* jnop */, SystemZ::JNOP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4790 /* jnp */, SystemZ::JAsmNP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4794 /* jnz */, SystemZ::JAsmNZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4798 /* jo */, SystemZ::JAsmO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4801 /* jp */, SystemZ::JAsmP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4804 /* jz */, SystemZ::JAsmZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4807 /* kdb */, SystemZ::KDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4811 /* kdbr */, SystemZ::KDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4816 /* kdsa */, SystemZ::KDSA, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_FeatureMessageSecurityAssist9, { MCK_GR64, MCK_GR128 }, },
  { 4821 /* kdtr */, SystemZ::KDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4826 /* keb */, SystemZ::KEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4830 /* kebr */, SystemZ::KEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4835 /* kimd */, SystemZ::KIMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4835 /* kimd */, SystemZ::KIMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4840 /* klmd */, SystemZ::KLMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4840 /* klmd */, SystemZ::KLMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4845 /* km */, SystemZ::KM, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4848 /* kma */, SystemZ::KMA, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist8, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4852 /* kmac */, SystemZ::KMAC, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4857 /* kmc */, SystemZ::KMC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4861 /* kmctr */, SystemZ::KMCTR, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4867 /* kmf */, SystemZ::KMF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4871 /* kmo */, SystemZ::KMO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4875 /* kxbr */, SystemZ::KXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4880 /* kxtr */, SystemZ::KXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4885 /* l */, SystemZ::L, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 4887 /* la */, SystemZ::LA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4890 /* laa */, SystemZ::LAA, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4894 /* laag */, SystemZ::LAAG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4899 /* laal */, SystemZ::LAAL, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4904 /* laalg */, SystemZ::LAALG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4910 /* lae */, SystemZ::LAE, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4914 /* laey */, SystemZ::LAEY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4919 /* lam */, SystemZ::LAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 4923 /* lamy */, SystemZ::LAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 4928 /* lan */, SystemZ::LAN, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4932 /* lang */, SystemZ::LANG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4937 /* lao */, SystemZ::LAO, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4941 /* laog */, SystemZ::LAOG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4946 /* larl */, SystemZ::LARL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 4951 /* lasp */, SystemZ::LASP, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 4956 /* lat */, SystemZ::LAT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4960 /* lax */, SystemZ::LAX, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4964 /* laxg */, SystemZ::LAXG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4969 /* lay */, SystemZ::LAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4973 /* lb */, SystemZ::LB, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4976 /* lbear */, SystemZ::LBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 4982 /* lbh */, SystemZ::LBH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 4986 /* lbr */, SystemZ::LBR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4990 /* lcbb */, SystemZ::LCBB, Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_GR32, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 4995 /* lcctl */, SystemZ::LCCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5001 /* lcdbr */, SystemZ::LCDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5007 /* lcdfr */, SystemZ::LCDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5013 /* lcdr */, SystemZ::LCDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5018 /* lcebr */, SystemZ::LCEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5024 /* lcer */, SystemZ::LCER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5029 /* lcgfr */, SystemZ::LCGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5035 /* lcgr */, SystemZ::LCGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5040 /* lcr */, SystemZ::LCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5044 /* lctl */, SystemZ::LCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 5049 /* lctlg */, SystemZ::LCTLG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 5055 /* lcxbr */, SystemZ::LCXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5061 /* lcxr */, SystemZ::LCXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5066 /* ld */, SystemZ::LD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5069 /* lde */, SystemZ::LDE, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5073 /* ldeb */, SystemZ::LDEB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5078 /* ldebr */, SystemZ::LDEBR, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5084 /* lder */, SystemZ::LDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5089 /* ldetr */, SystemZ::LDETR, Convert__FP641_0__FP321_1__U4Imm1_2, AMFBS_None, { MCK_FP64, MCK_FP32, MCK_U4Imm }, },
  { 5095 /* ldgr */, SystemZ::LDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 5100 /* ldr */, SystemZ::LDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5104 /* ldrv */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5109 /* ldxbr */, SystemZ::LDXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5115 /* ldxbra */, SystemZ::LDXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5122 /* ldxr */, SystemZ::LDXR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 5127 /* ldxtr */, SystemZ::LDXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5133 /* ldy */, SystemZ::LDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 5137 /* le */, SystemZ::LE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 5140 /* ledbr */, SystemZ::LEDBR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5146 /* ledbra */, SystemZ::LEDBRA, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5153 /* ledr */, SystemZ::LEDR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5158 /* ledtr */, SystemZ::LEDTR, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5164 /* ler */, SystemZ::LER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5168 /* lerv */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5173 /* lexbr */, SystemZ::LEXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5179 /* lexbra */, SystemZ::LEXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5186 /* lexr */, SystemZ::LEXR, Convert__FP321_0__FP1281_1, AMFBS_None, { MCK_FP32, MCK_FP128 }, },
  { 5191 /* ley */, SystemZ::LEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 5195 /* lfas */, SystemZ::LFAS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5200 /* lfh */, SystemZ::LFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5204 /* lfhat */, SystemZ::LFHAT, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5210 /* lfi */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 5214 /* lfpc */, SystemZ::LFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5219 /* lg */, SystemZ::LG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5222 /* lgat */, SystemZ::LGAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5227 /* lgb */, SystemZ::LGB, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5231 /* lgbr */, SystemZ::LGBR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5236 /* lgdr */, SystemZ::LGDR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 5241 /* lgf */, SystemZ::LGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5245 /* lgfi */, SystemZ::LGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 5250 /* lgfr */, SystemZ::LGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5255 /* lgfrl */, SystemZ::LGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5261 /* lgg */, SystemZ::LGG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5265 /* lgh */, SystemZ::LGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5269 /* lghi */, SystemZ::LGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 5274 /* lghr */, SystemZ::LGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5279 /* lghrl */, SystemZ::LGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5285 /* lgr */, SystemZ::LGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5289 /* lgrl */, SystemZ::LGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5294 /* lgsc */, SystemZ::LGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5299 /* lh */, SystemZ::LH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 5302 /* lhh */, SystemZ::LHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5306 /* lhi */, SystemZ::LHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 5310 /* lhr */, SystemZ::LHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5314 /* lhrl */, SystemZ::LHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5319 /* lhy */, SystemZ::LHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5323 /* llc */, SystemZ::LLC, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5327 /* llch */, SystemZ::LLCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5332 /* llcr */, SystemZ::LLCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5337 /* llgc */, SystemZ::LLGC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5342 /* llgcr */, SystemZ::LLGCR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5348 /* llgf */, SystemZ::LLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5353 /* llgfat */, SystemZ::LLGFAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5360 /* llgfi */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5366 /* llgfr */, SystemZ::LLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5372 /* llgfrl */, SystemZ::LLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5379 /* llgfsg */, SystemZ::LLGFSG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5386 /* llgh */, SystemZ::LLGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5391 /* llghi */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5397 /* llghr */, SystemZ::LLGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5403 /* llghrl */, SystemZ::LLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5410 /* llgt */, SystemZ::LLGT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5415 /* llgtat */, SystemZ::LLGTAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5422 /* llgtr */, SystemZ::LLGTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5428 /* llh */, SystemZ::LLH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5432 /* llhh */, SystemZ::LLHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5437 /* llhr */, SystemZ::LLHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5442 /* llhrl */, SystemZ::LLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5448 /* llihf */, SystemZ::LLIHF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5454 /* llihh */, SystemZ::LLIHH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5460 /* llihl */, SystemZ::LLIHL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5466 /* llilf */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5472 /* llilh */, SystemZ::LLILH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5478 /* llill */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5484 /* llxab */, SystemZ::LLXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5490 /* llxaf */, SystemZ::LLXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5496 /* llxag */, SystemZ::LLXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5502 /* llxah */, SystemZ::LLXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5508 /* llxaq */, SystemZ::LLXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5514 /* llzrgf */, SystemZ::LLZRGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5521 /* lm */, SystemZ::LM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 5524 /* lmd */, SystemZ::LMD, Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 5528 /* lmg */, SystemZ::LMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5532 /* lmh */, SystemZ::LMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5536 /* lmy */, SystemZ::LMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5540 /* lndbr */, SystemZ::LNDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5546 /* lndfr */, SystemZ::LNDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5552 /* lndr */, SystemZ::LNDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5557 /* lnebr */, SystemZ::LNEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5563 /* lner */, SystemZ::LNER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5568 /* lngfr */, SystemZ::LNGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5574 /* lngr */, SystemZ::LNGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5579 /* lnr */, SystemZ::LNR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5583 /* lnxbr */, SystemZ::LNXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5589 /* lnxr */, SystemZ::LNXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5594 /* loc */, SystemZ::LOCAsm, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5598 /* loce */, SystemZ::LOCAsmE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5603 /* locfh */, SystemZ::LOCFHAsm, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5609 /* locfhe */, SystemZ::LOCFHAsmE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5616 /* locfhh */, SystemZ::LOCFHAsmH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5623 /* locfhhe */, SystemZ::LOCFHAsmHE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5631 /* locfhl */, SystemZ::LOCFHAsmL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5638 /* locfhle */, SystemZ::LOCFHAsmLE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5646 /* locfhlh */, SystemZ::LOCFHAsmLH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5654 /* locfhm */, SystemZ::LOCFHAsmM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5661 /* locfhne */, SystemZ::LOCFHAsmNE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5669 /* locfhnh */, SystemZ::LOCFHAsmNH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5677 /* locfhnhe */, SystemZ::LOCFHAsmNHE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5686 /* locfhnl */, SystemZ::LOCFHAsmNL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5694 /* locfhnle */, SystemZ::LOCFHAsmNLE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5703 /* locfhnlh */, SystemZ::LOCFHAsmNLH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5712 /* locfhnm */, SystemZ::LOCFHAsmNM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5720 /* locfhno */, SystemZ::LOCFHAsmNO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5728 /* locfhnp */, SystemZ::LOCFHAsmNP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5736 /* locfhnz */, SystemZ::LOCFHAsmNZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5744 /* locfho */, SystemZ::LOCFHAsmO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5751 /* locfhp */, SystemZ::LOCFHAsmP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5758 /* locfhr */, SystemZ::LOCFHRAsm, Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 5765 /* locfhre */, SystemZ::LOCFHRAsmE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5773 /* locfhrh */, SystemZ::LOCFHRAsmH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5781 /* locfhrhe */, SystemZ::LOCFHRAsmHE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5790 /* locfhrl */, SystemZ::LOCFHRAsmL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5798 /* locfhrle */, SystemZ::LOCFHRAsmLE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5807 /* locfhrlh */, SystemZ::LOCFHRAsmLH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5816 /* locfhrm */, SystemZ::LOCFHRAsmM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5824 /* locfhrne */, SystemZ::LOCFHRAsmNE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5833 /* locfhrnh */, SystemZ::LOCFHRAsmNH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5842 /* locfhrnhe */, SystemZ::LOCFHRAsmNHE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5852 /* locfhrnl */, SystemZ::LOCFHRAsmNL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5861 /* locfhrnle */, SystemZ::LOCFHRAsmNLE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5871 /* locfhrnlh */, SystemZ::LOCFHRAsmNLH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5881 /* locfhrnm */, SystemZ::LOCFHRAsmNM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5890 /* locfhrno */, SystemZ::LOCFHRAsmNO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5899 /* locfhrnp */, SystemZ::LOCFHRAsmNP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5908 /* locfhrnz */, SystemZ::LOCFHRAsmNZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5917 /* locfhro */, SystemZ::LOCFHRAsmO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5925 /* locfhrp */, SystemZ::LOCFHRAsmP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5933 /* locfhrz */, SystemZ::LOCFHRAsmZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5941 /* locfhz */, SystemZ::LOCFHAsmZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5948 /* locg */, SystemZ::LOCGAsm, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5953 /* locge */, SystemZ::LOCGAsmE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5959 /* locgh */, SystemZ::LOCGAsmH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5965 /* locghe */, SystemZ::LOCGAsmHE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5972 /* locghi */, SystemZ::LOCGHIAsm, Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 5979 /* locghie */, SystemZ::LOCGHIAsmE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5987 /* locghih */, SystemZ::LOCGHIAsmH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5995 /* locghihe */, SystemZ::LOCGHIAsmHE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6004 /* locghil */, SystemZ::LOCGHIAsmL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6012 /* locghile */, SystemZ::LOCGHIAsmLE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6021 /* locghilh */, SystemZ::LOCGHIAsmLH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6030 /* locghim */, SystemZ::LOCGHIAsmM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6038 /* locghine */, SystemZ::LOCGHIAsmNE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6047 /* locghinh */, SystemZ::LOCGHIAsmNH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6056 /* locghinhe */, SystemZ::LOCGHIAsmNHE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6066 /* locghinl */, SystemZ::LOCGHIAsmNL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6075 /* locghinle */, SystemZ::LOCGHIAsmNLE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6085 /* locghinlh */, SystemZ::LOCGHIAsmNLH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6095 /* locghinm */, SystemZ::LOCGHIAsmNM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6104 /* locghino */, SystemZ::LOCGHIAsmNO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6113 /* locghinp */, SystemZ::LOCGHIAsmNP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6122 /* locghinz */, SystemZ::LOCGHIAsmNZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6131 /* locghio */, SystemZ::LOCGHIAsmO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6139 /* locghip */, SystemZ::LOCGHIAsmP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6147 /* locghiz */, SystemZ::LOCGHIAsmZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6155 /* locgl */, SystemZ::LOCGAsmL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6161 /* locgle */, SystemZ::LOCGAsmLE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6168 /* locglh */, SystemZ::LOCGAsmLH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6175 /* locgm */, SystemZ::LOCGAsmM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6181 /* locgne */, SystemZ::LOCGAsmNE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6188 /* locgnh */, SystemZ::LOCGAsmNH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6195 /* locgnhe */, SystemZ::LOCGAsmNHE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6203 /* locgnl */, SystemZ::LOCGAsmNL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6210 /* locgnle */, SystemZ::LOCGAsmNLE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6218 /* locgnlh */, SystemZ::LOCGAsmNLH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6226 /* locgnm */, SystemZ::LOCGAsmNM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6233 /* locgno */, SystemZ::LOCGAsmNO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6240 /* locgnp */, SystemZ::LOCGAsmNP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6247 /* locgnz */, SystemZ::LOCGAsmNZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6254 /* locgo */, SystemZ::LOCGAsmO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6260 /* locgp */, SystemZ::LOCGAsmP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6266 /* locgr */, SystemZ::LOCGRAsm, Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 6272 /* locgre */, SystemZ::LOCGRAsmE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6279 /* locgrh */, SystemZ::LOCGRAsmH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6286 /* locgrhe */, SystemZ::LOCGRAsmHE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6294 /* locgrl */, SystemZ::LOCGRAsmL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6301 /* locgrle */, SystemZ::LOCGRAsmLE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6309 /* locgrlh */, SystemZ::LOCGRAsmLH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6317 /* locgrm */, SystemZ::LOCGRAsmM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6324 /* locgrne */, SystemZ::LOCGRAsmNE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6332 /* locgrnh */, SystemZ::LOCGRAsmNH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6340 /* locgrnhe */, SystemZ::LOCGRAsmNHE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6349 /* locgrnl */, SystemZ::LOCGRAsmNL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6357 /* locgrnle */, SystemZ::LOCGRAsmNLE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6366 /* locgrnlh */, SystemZ::LOCGRAsmNLH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6375 /* locgrnm */, SystemZ::LOCGRAsmNM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6383 /* locgrno */, SystemZ::LOCGRAsmNO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6391 /* locgrnp */, SystemZ::LOCGRAsmNP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6399 /* locgrnz */, SystemZ::LOCGRAsmNZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6407 /* locgro */, SystemZ::LOCGRAsmO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6414 /* locgrp */, SystemZ::LOCGRAsmP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6421 /* locgrz */, SystemZ::LOCGRAsmZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6428 /* locgz */, SystemZ::LOCGAsmZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6434 /* loch */, SystemZ::LOCAsmH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6439 /* loche */, SystemZ::LOCAsmHE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6445 /* lochhi */, SystemZ::LOCHHIAsm, Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm, MCK_U4Imm }, },
  { 6452 /* lochhie */, SystemZ::LOCHHIAsmE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6460 /* lochhih */, SystemZ::LOCHHIAsmH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6468 /* lochhihe */, SystemZ::LOCHHIAsmHE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6477 /* lochhil */, SystemZ::LOCHHIAsmL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6485 /* lochhile */, SystemZ::LOCHHIAsmLE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6494 /* lochhilh */, SystemZ::LOCHHIAsmLH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6503 /* lochhim */, SystemZ::LOCHHIAsmM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6511 /* lochhine */, SystemZ::LOCHHIAsmNE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6520 /* lochhinh */, SystemZ::LOCHHIAsmNH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6529 /* lochhinhe */, SystemZ::LOCHHIAsmNHE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6539 /* lochhinl */, SystemZ::LOCHHIAsmNL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6548 /* lochhinle */, SystemZ::LOCHHIAsmNLE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6558 /* lochhinlh */, SystemZ::LOCHHIAsmNLH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6568 /* lochhinm */, SystemZ::LOCHHIAsmNM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6577 /* lochhino */, SystemZ::LOCHHIAsmNO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6586 /* lochhinp */, SystemZ::LOCHHIAsmNP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6595 /* lochhinz */, SystemZ::LOCHHIAsmNZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6604 /* lochhio */, SystemZ::LOCHHIAsmO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6612 /* lochhip */, SystemZ::LOCHHIAsmP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6620 /* lochhiz */, SystemZ::LOCHHIAsmZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6628 /* lochi */, SystemZ::LOCHIAsm, Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 6634 /* lochie */, SystemZ::LOCHIAsmE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6641 /* lochih */, SystemZ::LOCHIAsmH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6648 /* lochihe */, SystemZ::LOCHIAsmHE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6656 /* lochil */, SystemZ::LOCHIAsmL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6663 /* lochile */, SystemZ::LOCHIAsmLE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6671 /* lochilh */, SystemZ::LOCHIAsmLH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6679 /* lochim */, SystemZ::LOCHIAsmM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6686 /* lochine */, SystemZ::LOCHIAsmNE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6694 /* lochinh */, SystemZ::LOCHIAsmNH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6702 /* lochinhe */, SystemZ::LOCHIAsmNHE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6711 /* lochinl */, SystemZ::LOCHIAsmNL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6719 /* lochinle */, SystemZ::LOCHIAsmNLE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6728 /* lochinlh */, SystemZ::LOCHIAsmNLH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6737 /* lochinm */, SystemZ::LOCHIAsmNM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6745 /* lochino */, SystemZ::LOCHIAsmNO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6753 /* lochinp */, SystemZ::LOCHIAsmNP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6761 /* lochinz */, SystemZ::LOCHIAsmNZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6769 /* lochio */, SystemZ::LOCHIAsmO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6776 /* lochip */, SystemZ::LOCHIAsmP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6783 /* lochiz */, SystemZ::LOCHIAsmZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6790 /* locl */, SystemZ::LOCAsmL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6795 /* locle */, SystemZ::LOCAsmLE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6801 /* loclh */, SystemZ::LOCAsmLH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6807 /* locm */, SystemZ::LOCAsmM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6812 /* locne */, SystemZ::LOCAsmNE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6818 /* locnh */, SystemZ::LOCAsmNH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6824 /* locnhe */, SystemZ::LOCAsmNHE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6831 /* locnl */, SystemZ::LOCAsmNL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6837 /* locnle */, SystemZ::LOCAsmNLE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6844 /* locnlh */, SystemZ::LOCAsmNLH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6851 /* locnm */, SystemZ::LOCAsmNM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6857 /* locno */, SystemZ::LOCAsmNO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6863 /* locnp */, SystemZ::LOCAsmNP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6869 /* locnz */, SystemZ::LOCAsmNZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6875 /* loco */, SystemZ::LOCAsmO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6880 /* locp */, SystemZ::LOCAsmP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6885 /* locr */, SystemZ::LOCRAsm, Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 6890 /* locre */, SystemZ::LOCRAsmE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6896 /* locrh */, SystemZ::LOCRAsmH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6902 /* locrhe */, SystemZ::LOCRAsmHE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6909 /* locrl */, SystemZ::LOCRAsmL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6915 /* locrle */, SystemZ::LOCRAsmLE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6922 /* locrlh */, SystemZ::LOCRAsmLH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6929 /* locrm */, SystemZ::LOCRAsmM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6935 /* locrne */, SystemZ::LOCRAsmNE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6942 /* locrnh */, SystemZ::LOCRAsmNH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6949 /* locrnhe */, SystemZ::LOCRAsmNHE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6957 /* locrnl */, SystemZ::LOCRAsmNL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6964 /* locrnle */, SystemZ::LOCRAsmNLE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6972 /* locrnlh */, SystemZ::LOCRAsmNLH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6980 /* locrnm */, SystemZ::LOCRAsmNM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6987 /* locrno */, SystemZ::LOCRAsmNO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6994 /* locrnp */, SystemZ::LOCRAsmNP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7001 /* locrnz */, SystemZ::LOCRAsmNZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7008 /* locro */, SystemZ::LOCRAsmO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7014 /* locrp */, SystemZ::LOCRAsmP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7020 /* locrz */, SystemZ::LOCRAsmZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7026 /* locz */, SystemZ::LOCAsmZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 7031 /* lpctl */, SystemZ::LPCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7037 /* lpd */, SystemZ::LPD, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7041 /* lpdbr */, SystemZ::LPDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7047 /* lpdfr */, SystemZ::LPDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7053 /* lpdg */, SystemZ::LPDG, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7058 /* lpdr */, SystemZ::LPDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7063 /* lpebr */, SystemZ::LPEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7069 /* lper */, SystemZ::LPER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7074 /* lpgfr */, SystemZ::LPGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7080 /* lpgr */, SystemZ::LPGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7085 /* lpp */, SystemZ::LPP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7089 /* lpq */, SystemZ::LPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7093 /* lpr */, SystemZ::LPR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7097 /* lpsw */, SystemZ::LPSW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7102 /* lpswe */, SystemZ::LPSWE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7108 /* lpswey */, SystemZ::LPSWEY, Convert__BDAddr64Disp202_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp20 }, },
  { 7115 /* lptea */, SystemZ::LPTEA, Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 7121 /* lpxbr */, SystemZ::LPXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7127 /* lpxr */, SystemZ::LPXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7132 /* lr */, SystemZ::LR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7135 /* lra */, SystemZ::LRA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 7139 /* lrag */, SystemZ::LRAG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7144 /* lray */, SystemZ::LRAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7149 /* lrdr */, SystemZ::LRDR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 7154 /* lrer */, SystemZ::LRER, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 7159 /* lrl */, SystemZ::LRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 7163 /* lrv */, SystemZ::LRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7167 /* lrvg */, SystemZ::LRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7172 /* lrvgr */, SystemZ::LRVGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7178 /* lrvh */, SystemZ::LRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7183 /* lrvr */, SystemZ::LRVR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7188 /* lsctl */, SystemZ::LSCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7194 /* lt */, SystemZ::LT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7197 /* ltdbr */, SystemZ::LTDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7203 /* ltdr */, SystemZ::LTDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7208 /* ltdtr */, SystemZ::LTDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7214 /* ltebr */, SystemZ::LTEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7220 /* lter */, SystemZ::LTER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7225 /* ltg */, SystemZ::LTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7229 /* ltgf */, SystemZ::LTGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7234 /* ltgfr */, SystemZ::LTGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7240 /* ltgr */, SystemZ::LTGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7245 /* ltr */, SystemZ::LTR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7249 /* ltxbr */, SystemZ::LTXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7255 /* ltxr */, SystemZ::LTXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7260 /* ltxtr */, SystemZ::LTXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7266 /* lura */, SystemZ::LURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 7271 /* lurag */, SystemZ::LURAG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7277 /* lxab */, SystemZ::LXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7282 /* lxaf */, SystemZ::LXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7287 /* lxag */, SystemZ::LXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7292 /* lxah */, SystemZ::LXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7297 /* lxaq */, SystemZ::LXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7302 /* lxd */, SystemZ::LXD, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7306 /* lxdb */, SystemZ::LXDB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7311 /* lxdbr */, SystemZ::LXDBR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7317 /* lxdr */, SystemZ::LXDR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7322 /* lxdtr */, SystemZ::LXDTR, Convert__FP1281_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_U4Imm }, },
  { 7328 /* lxe */, SystemZ::LXE, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7332 /* lxeb */, SystemZ::LXEB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7337 /* lxebr */, SystemZ::LXEBR, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7343 /* lxer */, SystemZ::LXER, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7348 /* lxr */, SystemZ::LXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7352 /* ly */, SystemZ::LY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7355 /* lzdr */, SystemZ::LZDR, Convert__FP641_0, AMFBS_None, { MCK_FP64 }, },
  { 7360 /* lzer */, SystemZ::LZER, Convert__FP321_0, AMFBS_None, { MCK_FP32 }, },
  { 7365 /* lzrf */, SystemZ::LZRF, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7370 /* lzrg */, SystemZ::LZRG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7375 /* lzxr */, SystemZ::LZXR, Convert__FP1281_0, AMFBS_None, { MCK_FP128 }, },
  { 7380 /* m */, SystemZ::M, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 7382 /* mad */, SystemZ::MAD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7386 /* madb */, SystemZ::MADB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7391 /* madbr */, SystemZ::MADBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7397 /* madr */, SystemZ::MADR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7402 /* mae */, SystemZ::MAE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7406 /* maeb */, SystemZ::MAEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7411 /* maebr */, SystemZ::MAEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7417 /* maer */, SystemZ::MAER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7422 /* may */, SystemZ::MAY, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7426 /* mayh */, SystemZ::MAYH, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7431 /* mayhr */, SystemZ::MAYHR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7437 /* mayl */, SystemZ::MAYL, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7442 /* maylr */, SystemZ::MAYLR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7448 /* mayr */, SystemZ::MAYR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7453 /* mc */, SystemZ::MC, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7456 /* md */, SystemZ::MD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7459 /* mdb */, SystemZ::MDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7463 /* mdbr */, SystemZ::MDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7468 /* mde */, SystemZ::MDE, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7472 /* mdeb */, SystemZ::MDEB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7477 /* mdebr */, SystemZ::MDEBR, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7483 /* mder */, SystemZ::MDER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7488 /* mdr */, SystemZ::MDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7492 /* mdtr */, SystemZ::MDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7497 /* mdtra */, SystemZ::MDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 7503 /* me */, SystemZ::ME, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7506 /* mee */, SystemZ::MEE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7510 /* meeb */, SystemZ::MEEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7515 /* meebr */, SystemZ::MEEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7521 /* meer */, SystemZ::MEER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7526 /* mer */, SystemZ::MER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7530 /* mfy */, SystemZ::MFY, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7534 /* mg */, SystemZ::MG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7537 /* mgh */, SystemZ::MGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7541 /* mghi */, SystemZ::MGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 7546 /* mgrk */, SystemZ::MGRK, Convert__GR1281_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_GR64, MCK_GR64 }, },
  { 7551 /* mh */, SystemZ::MH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7554 /* mhi */, SystemZ::MHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 7558 /* mhy */, SystemZ::MHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7562 /* ml */, SystemZ::ML, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7565 /* mlg */, SystemZ::MLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7569 /* mlgr */, SystemZ::MLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 7574 /* mlr */, SystemZ::MLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7578 /* mp */, SystemZ::MP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7581 /* mr */, SystemZ::MR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7584 /* ms */, SystemZ::MS, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7587 /* msc */, SystemZ::MSC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7591 /* msch */, SystemZ::MSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7596 /* msd */, SystemZ::MSD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7600 /* msdb */, SystemZ::MSDB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7605 /* msdbr */, SystemZ::MSDBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7611 /* msdr */, SystemZ::MSDR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7616 /* mse */, SystemZ::MSE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7620 /* mseb */, SystemZ::MSEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7625 /* msebr */, SystemZ::MSEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7631 /* mser */, SystemZ::MSER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7636 /* msfi */, SystemZ::MSFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 7641 /* msg */, SystemZ::MSG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7645 /* msgc */, SystemZ::MSGC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7650 /* msgf */, SystemZ::MSGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7655 /* msgfi */, SystemZ::MSGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 7661 /* msgfr */, SystemZ::MSGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7667 /* msgr */, SystemZ::MSGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7672 /* msgrkc */, SystemZ::MSGRKC, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7679 /* msr */, SystemZ::MSR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7683 /* msrkc */, SystemZ::MSRKC, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7689 /* msta */, SystemZ::MSTA, Convert__GR1281_0, AMFBS_None, { MCK_GR128 }, },
  { 7694 /* msy */, SystemZ::MSY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7698 /* mvc */, SystemZ::MVC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7702 /* mvcdk */, SystemZ::MVCDK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7708 /* mvcin */, SystemZ::MVCIN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7714 /* mvck */, SystemZ::MVCK, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7719 /* mvcl */, SystemZ::MVCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 7724 /* mvcle */, SystemZ::MVCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 7730 /* mvclu */, SystemZ::MVCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 7736 /* mvcos */, SystemZ::MVCOS, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7742 /* mvcp */, SystemZ::MVCP, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7747 /* mvcrl */, SystemZ::MVCRL, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7753 /* mvcs */, SystemZ::MVCS, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7758 /* mvcsk */, SystemZ::MVCSK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7764 /* mvghi */, SystemZ::MVGHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7770 /* mvhhi */, SystemZ::MVHHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7776 /* mvhi */, SystemZ::MVHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7781 /* mvi */, SystemZ::MVI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7785 /* mviy */, SystemZ::MVIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7790 /* mvn */, SystemZ::MVN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7794 /* mvo */, SystemZ::MVO, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7798 /* mvpg */, SystemZ::MVPG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7803 /* mvst */, SystemZ::MVST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7808 /* mvz */, SystemZ::MVZ, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7812 /* mxbr */, SystemZ::MXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7817 /* mxd */, SystemZ::MXD, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7821 /* mxdb */, SystemZ::MXDB, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7826 /* mxdbr */, SystemZ::MXDBR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7832 /* mxdr */, SystemZ::MXDR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7837 /* mxr */, SystemZ::MXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7841 /* mxtr */, SystemZ::MXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 7846 /* mxtra */, SystemZ::MXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 7852 /* my */, SystemZ::MY, Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7855 /* myh */, SystemZ::MYH, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7859 /* myhr */, SystemZ::MYHR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7864 /* myl */, SystemZ::MYL, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7868 /* mylr */, SystemZ::MYLR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7873 /* myr */, SystemZ::MYR, Convert__FP1281_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_FP64 }, },
  { 7877 /* n */, SystemZ::N, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7879 /* nc */, SystemZ::NC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7882 /* ncgrk */, SystemZ::NCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7888 /* ncrk */, SystemZ::NCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7893 /* ng */, SystemZ::NG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7896 /* ngr */, SystemZ::NGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7900 /* ngrk */, SystemZ::NGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7905 /* ni */, SystemZ::NI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7908 /* niai */, SystemZ::NIAI, Convert__U4Imm1_0__U4Imm1_1, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_U4Imm }, },
  { 7913 /* nihf */, SystemZ::NIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 7918 /* nihh */, SystemZ::NIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7923 /* nihl */, SystemZ::NIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7928 /* nilf */, SystemZ::NILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 7933 /* nilh */, SystemZ::NILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7938 /* nill */, SystemZ::NILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7943 /* niy */, SystemZ::NIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7947 /* nngrk */, SystemZ::NNGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7953 /* nnpa */, SystemZ::NNPA, Convert_NoOperands, AMFBS_FeatureNNPAssist, {  }, },
  { 7958 /* nnrk */, SystemZ::NNRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7963 /* nogrk */, SystemZ::NOGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7969 /* nop */, SystemZ::NOPOpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7969 /* nop */, SystemZ::NOP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 7973 /* nopr */, SystemZ::NOPROpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7973 /* nopr */, SystemZ::NOPR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 7978 /* nork */, SystemZ::NORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7983 /* notgr */, SystemZ::NOTGR, Convert__GR641_0__GR641_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64 }, },
  { 7989 /* notr */, SystemZ::NOTR, Convert__GR321_0__GR321_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32 }, },
  { 7994 /* nr */, SystemZ::NR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7997 /* nrk */, SystemZ::NRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8001 /* ntstg */, SystemZ::NTSTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureTransactionalExecution, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8007 /* nxgrk */, SystemZ::NXGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8013 /* nxrk */, SystemZ::NXRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8018 /* ny */, SystemZ::NY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8021 /* o */, SystemZ::O, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8023 /* oc */, SystemZ::OC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 8026 /* ocgrk */, SystemZ::OCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8032 /* ocrk */, SystemZ::OCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8037 /* og */, SystemZ::OG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8040 /* ogr */, SystemZ::OGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8044 /* ogrk */, SystemZ::OGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8049 /* oi */, SystemZ::OI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 8052 /* oihf */, SystemZ::OIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 8057 /* oihh */, SystemZ::OIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8062 /* oihl */, SystemZ::OIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8067 /* oilf */, SystemZ::OILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 8072 /* oilh */, SystemZ::OILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8077 /* oill */, SystemZ::OILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8082 /* oiy */, SystemZ::OIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 8086 /* or */, SystemZ::OR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8089 /* ork */, SystemZ::ORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8093 /* oy */, SystemZ::OY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8096 /* pack */, SystemZ::PACK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 8101 /* palb */, SystemZ::PALB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8106 /* pc */, SystemZ::PC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8109 /* pcc */, SystemZ::PCC, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist4, {  }, },
  { 8113 /* pckmo */, SystemZ::PCKMO, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist3, {  }, },
  { 8119 /* pfcr */, SystemZ::PFCR, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8124 /* pfd */, SystemZ::PFD, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 8128 /* pfdrl */, SystemZ::PFDRL, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 8134 /* pfmf */, SystemZ::PFMF, Convert__GR641_1__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8139 /* pfpo */, SystemZ::PFPO, Convert_NoOperands, AMFBS_None, {  }, },
  { 8144 /* pgin */, SystemZ::PGIN, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8149 /* pgout */, SystemZ::PGOUT, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8155 /* pka */, SystemZ::PKA, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8159 /* pku */, SystemZ::PKU, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8163 /* plo */, SystemZ::PLO, Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_BDAddr64Disp12, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 8167 /* popcnt */, SystemZ::POPCNT, Convert__GR641_0__GR641_1, AMFBS_FeaturePopulationCount, { MCK_GR64, MCK_GR64 }, },
  { 8167 /* popcnt */, SystemZ::POPCNTOpt, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8174 /* ppa */, SystemZ::PPA, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureProcessorAssist, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8178 /* ppno */, SystemZ::PPNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist5, { MCK_GR128, MCK_GR128 }, },
  { 8183 /* pr */, SystemZ::PR, Convert_NoOperands, AMFBS_None, {  }, },
  { 8186 /* prno */, SystemZ::PRNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist7, { MCK_GR128, MCK_GR128 }, },
  { 8191 /* pt */, SystemZ::PT, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8194 /* ptf */, SystemZ::PTF, Convert__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 8198 /* ptff */, SystemZ::PTFF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8203 /* pti */, SystemZ::PTI, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8207 /* ptlb */, SystemZ::PTLB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8212 /* qadtr */, SystemZ::QADTR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8218 /* qaxtr */, SystemZ::QAXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 8224 /* qctri */, SystemZ::QCTRI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8230 /* qpaci */, SystemZ::QPACI, Convert__BDAddr64Disp122_0, AMFBS_FeatureProcessorActivityInstrumentation, { MCK_BDAddr64Disp12 }, },
  { 8236 /* qsi */, SystemZ::QSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8240 /* rchp */, SystemZ::RCHP, Convert_NoOperands, AMFBS_None, {  }, },
  { 8245 /* rdp */, SystemZ::RDPOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8245 /* rdp */, SystemZ::RDP, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8249 /* risbg */, SystemZ::RISBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8249 /* risbg */, SystemZ::RISBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8255 /* risbgn */, SystemZ::RISBGNOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8255 /* risbgn */, SystemZ::RISBGN, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8262 /* risbgnz */, SystemZ::RISBGNZOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8262 /* risbgnz */, SystemZ::RISBGNZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8270 /* risbgz */, SystemZ::RISBGZOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8270 /* risbgz */, SystemZ::RISBGZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8277 /* risbhg */, SystemZ::RISBHGOpt, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8277 /* risbhg */, SystemZ::RISBHG, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8284 /* risblg */, SystemZ::RISBLGOpt, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8284 /* risblg */, SystemZ::RISBLG, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8291 /* rll */, SystemZ::RLL, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 8295 /* rllg */, SystemZ::RLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8300 /* rnsbg */, SystemZ::RNSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8300 /* rnsbg */, SystemZ::RNSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8306 /* rosbg */, SystemZ::ROSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8306 /* rosbg */, SystemZ::ROSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8312 /* rp */, SystemZ::RP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8315 /* rrbe */, SystemZ::RRBE, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8320 /* rrbm */, SystemZ::RRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureResetReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 8325 /* rrdtr */, SystemZ::RRDTR, Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR32, MCK_U4Imm }, },
  { 8331 /* rrxtr */, SystemZ::RRXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR32, MCK_U4Imm }, },
  { 8337 /* rsch */, SystemZ::RSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 8342 /* rxsbg */, SystemZ::RXSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8342 /* rxsbg */, SystemZ::RXSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8348 /* s */, SystemZ::S, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8350 /* sac */, SystemZ::SAC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8354 /* sacf */, SystemZ::SACF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8359 /* sal */, SystemZ::SAL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8363 /* sam24 */, SystemZ::SAM24, Convert_NoOperands, AMFBS_None, {  }, },
  { 8369 /* sam31 */, SystemZ::SAM31, Convert_NoOperands, AMFBS_None, {  }, },
  { 8375 /* sam64 */, SystemZ::SAM64, Convert_NoOperands, AMFBS_None, {  }, },
  { 8381 /* sar */, SystemZ::SAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 8385 /* scctr */, SystemZ::SCCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8391 /* schm */, SystemZ::SCHM, Convert_NoOperands, AMFBS_None, {  }, },
  { 8396 /* sck */, SystemZ::SCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8400 /* sckc */, SystemZ::SCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8405 /* sckpf */, SystemZ::SCKPF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8411 /* sd */, SystemZ::SD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8414 /* sdb */, SystemZ::SDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8418 /* sdbr */, SystemZ::SDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8423 /* sdr */, SystemZ::SDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8427 /* sdtr */, SystemZ::SDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 8432 /* sdtra */, SystemZ::SDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8438 /* se */, SystemZ::SE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8441 /* seb */, SystemZ::SEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8445 /* sebr */, SystemZ::SEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8450 /* selfhr */, SystemZ::SELFHRAsm, Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 8457 /* selfhre */, SystemZ::SELFHRAsmE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8465 /* selfhrh */, SystemZ::SELFHRAsmH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8473 /* selfhrhe */, SystemZ::SELFHRAsmHE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8482 /* selfhrl */, SystemZ::SELFHRAsmL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8490 /* selfhrle */, SystemZ::SELFHRAsmLE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8499 /* selfhrlh */, SystemZ::SELFHRAsmLH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8508 /* selfhrm */, SystemZ::SELFHRAsmM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8516 /* selfhrne */, SystemZ::SELFHRAsmNE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8525 /* selfhrnh */, SystemZ::SELFHRAsmNH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8534 /* selfhrnhe */, SystemZ::SELFHRAsmNHE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8544 /* selfhrnl */, SystemZ::SELFHRAsmNL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8553 /* selfhrnle */, SystemZ::SELFHRAsmNLE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8563 /* selfhrnlh */, SystemZ::SELFHRAsmNLH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8573 /* selfhrnm */, SystemZ::SELFHRAsmNM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8582 /* selfhrno */, SystemZ::SELFHRAsmNO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8591 /* selfhrnp */, SystemZ::SELFHRAsmNP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8600 /* selfhrnz */, SystemZ::SELFHRAsmNZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8609 /* selfhro */, SystemZ::SELFHRAsmO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8617 /* selfhrp */, SystemZ::SELFHRAsmP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8625 /* selfhrz */, SystemZ::SELFHRAsmZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8633 /* selgr */, SystemZ::SELGRAsm, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8639 /* selgre */, SystemZ::SELGRAsmE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8646 /* selgrh */, SystemZ::SELGRAsmH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8653 /* selgrhe */, SystemZ::SELGRAsmHE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8661 /* selgrl */, SystemZ::SELGRAsmL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8668 /* selgrle */, SystemZ::SELGRAsmLE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8676 /* selgrlh */, SystemZ::SELGRAsmLH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8684 /* selgrm */, SystemZ::SELGRAsmM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8691 /* selgrne */, SystemZ::SELGRAsmNE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8699 /* selgrnh */, SystemZ::SELGRAsmNH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8707 /* selgrnhe */, SystemZ::SELGRAsmNHE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8716 /* selgrnl */, SystemZ::SELGRAsmNL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8724 /* selgrnle */, SystemZ::SELGRAsmNLE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8733 /* selgrnlh */, SystemZ::SELGRAsmNLH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8742 /* selgrnm */, SystemZ::SELGRAsmNM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8750 /* selgrno */, SystemZ::SELGRAsmNO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8758 /* selgrnp */, SystemZ::SELGRAsmNP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8766 /* selgrnz */, SystemZ::SELGRAsmNZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8774 /* selgro */, SystemZ::SELGRAsmO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8781 /* selgrp */, SystemZ::SELGRAsmP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8788 /* selgrz */, SystemZ::SELGRAsmZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8795 /* selr */, SystemZ::SELRAsm, Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 8800 /* selre */, SystemZ::SELRAsmE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8806 /* selrh */, SystemZ::SELRAsmH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8812 /* selrhe */, SystemZ::SELRAsmHE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8819 /* selrl */, SystemZ::SELRAsmL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8825 /* selrle */, SystemZ::SELRAsmLE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8832 /* selrlh */, SystemZ::SELRAsmLH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8839 /* selrm */, SystemZ::SELRAsmM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8845 /* selrne */, SystemZ::SELRAsmNE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8852 /* selrnh */, SystemZ::SELRAsmNH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8859 /* selrnhe */, SystemZ::SELRAsmNHE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8867 /* selrnl */, SystemZ::SELRAsmNL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8874 /* selrnle */, SystemZ::SELRAsmNLE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8882 /* selrnlh */, SystemZ::SELRAsmNLH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8890 /* selrnm */, SystemZ::SELRAsmNM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8897 /* selrno */, SystemZ::SELRAsmNO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8904 /* selrnp */, SystemZ::SELRAsmNP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8911 /* selrnz */, SystemZ::SELRAsmNZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8918 /* selro */, SystemZ::SELRAsmO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8924 /* selrp */, SystemZ::SELRAsmP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8930 /* selrz */, SystemZ::SELRAsmZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8936 /* ser */, SystemZ::SER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8940 /* sfasr */, SystemZ::SFASR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8946 /* sfpc */, SystemZ::SFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8951 /* sg */, SystemZ::SG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8954 /* sgf */, SystemZ::SGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8958 /* sgfr */, SystemZ::SGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 8963 /* sgh */, SystemZ::SGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8967 /* sgr */, SystemZ::SGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8971 /* sgrk */, SystemZ::SGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8976 /* sh */, SystemZ::SH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8979 /* shhhr */, SystemZ::SHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8985 /* shhlr */, SystemZ::SHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 8991 /* shy */, SystemZ::SHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8995 /* sie */, SystemZ::SIE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8999 /* siga */, SystemZ::SIGA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9004 /* sigp */, SystemZ::SIGP, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 9009 /* sl */, SystemZ::SL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9012 /* sla */, SystemZ::SLA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9016 /* slag */, SystemZ::SLAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9021 /* slak */, SystemZ::SLAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9026 /* slb */, SystemZ::SLB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9030 /* slbg */, SystemZ::SLBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9035 /* slbgr */, SystemZ::SLBGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9041 /* slbr */, SystemZ::SLBR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9046 /* slda */, SystemZ::SLDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9051 /* sldl */, SystemZ::SLDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9056 /* sldt */, SystemZ::SLDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9061 /* slfi */, SystemZ::SLFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 9066 /* slg */, SystemZ::SLG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9070 /* slgf */, SystemZ::SLGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9075 /* slgfi */, SystemZ::SLGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 9081 /* slgfr */, SystemZ::SLGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 9087 /* slgr */, SystemZ::SLGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9092 /* slgrk */, SystemZ::SLGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 9098 /* slhhhr */, SystemZ::SLHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 9105 /* slhhlr */, SystemZ::SLHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 9112 /* sll */, SystemZ::SLL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9116 /* sllg */, SystemZ::SLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9121 /* sllk */, SystemZ::SLLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9126 /* slr */, SystemZ::SLR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9130 /* slrk */, SystemZ::SLRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9135 /* slxt */, SystemZ::SLXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9140 /* sly */, SystemZ::SLY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9144 /* sortl */, SystemZ::SORTL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureEnhancedSort, { MCK_GR128, MCK_GR128 }, },
  { 9150 /* sp */, SystemZ::SP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 9153 /* spctr */, SystemZ::SPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9159 /* spka */, SystemZ::SPKA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9164 /* spm */, SystemZ::SPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9168 /* spt */, SystemZ::SPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9172 /* spx */, SystemZ::SPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9176 /* sqd */, SystemZ::SQD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9180 /* sqdb */, SystemZ::SQDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9185 /* sqdbr */, SystemZ::SQDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9191 /* sqdr */, SystemZ::SQDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9196 /* sqe */, SystemZ::SQE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9200 /* sqeb */, SystemZ::SQEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9205 /* sqebr */, SystemZ::SQEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9211 /* sqer */, SystemZ::SQER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9216 /* sqxbr */, SystemZ::SQXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9222 /* sqxr */, SystemZ::SQXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9227 /* sr */, SystemZ::SR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9230 /* sra */, SystemZ::SRA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9234 /* srag */, SystemZ::SRAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9239 /* srak */, SystemZ::SRAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9244 /* srda */, SystemZ::SRDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9249 /* srdl */, SystemZ::SRDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9254 /* srdt */, SystemZ::SRDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9259 /* srk */, SystemZ::SRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9263 /* srl */, SystemZ::SRL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9267 /* srlg */, SystemZ::SRLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9272 /* srlk */, SystemZ::SRLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9277 /* srnm */, SystemZ::SRNM, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9282 /* srnmb */, SystemZ::SRNMB, Convert__BDAddr32Disp122_0, AMFBS_FeatureFPExtension, { MCK_BDAddr32Disp12 }, },
  { 9288 /* srnmt */, SystemZ::SRNMT, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9294 /* srp */, SystemZ::SRP, Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 9298 /* srst */, SystemZ::SRST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9303 /* srstu */, SystemZ::SRSTU, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9309 /* srxt */, SystemZ::SRXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9314 /* ssair */, SystemZ::SSAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 9320 /* ssar */, SystemZ::SSAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9325 /* ssch */, SystemZ::SSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9330 /* sske */, SystemZ::SSKEOpt, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 9330 /* sske */, SystemZ::SSKE, Convert__GR321_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR64, MCK_U4Imm }, },
  { 9335 /* ssm */, SystemZ::SSM, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9339 /* st */, SystemZ::ST, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9342 /* stam */, SystemZ::STAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 9347 /* stamy */, SystemZ::STAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 9353 /* stap */, SystemZ::STAP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9358 /* stbear */, SystemZ::STBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 9365 /* stc */, SystemZ::STC, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9369 /* stch */, SystemZ::STCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9374 /* stck */, SystemZ::STCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9379 /* stckc */, SystemZ::STCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9385 /* stcke */, SystemZ::STCKE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9391 /* stckf */, SystemZ::STCKF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9397 /* stcm */, SystemZ::STCM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 9402 /* stcmh */, SystemZ::STCMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9408 /* stcmy */, SystemZ::STCMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9414 /* stcps */, SystemZ::STCPS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9420 /* stcrw */, SystemZ::STCRW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9426 /* stctg */, SystemZ::STCTG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 9432 /* stctl */, SystemZ::STCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 9438 /* stcy */, SystemZ::STCY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9443 /* std */, SystemZ::STD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9447 /* stdrv */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9453 /* stdy */, SystemZ::STDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 9458 /* ste */, SystemZ::STE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9462 /* sterv */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9468 /* stey */, SystemZ::STEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 9473 /* stfh */, SystemZ::STFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9478 /* stfl */, SystemZ::STFL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9483 /* stfle */, SystemZ::STFLE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9489 /* stfpc */, SystemZ::STFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9495 /* stg */, SystemZ::STG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9499 /* stgrl */, SystemZ::STGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 9505 /* stgsc */, SystemZ::STGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9511 /* sth */, SystemZ::STH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9515 /* sthh */, SystemZ::STHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9520 /* sthrl */, SystemZ::STHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 9526 /* sthy */, SystemZ::STHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9531 /* stidp */, SystemZ::STIDP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9537 /* stm */, SystemZ::STM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 9541 /* stmg */, SystemZ::STMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9546 /* stmh */, SystemZ::STMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9551 /* stmy */, SystemZ::STMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9556 /* stnsm */, SystemZ::STNSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 9562 /* stoc */, SystemZ::STOCAsm, Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9567 /* stoce */, SystemZ::STOCAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9573 /* stocfh */, SystemZ::STOCFHAsm, Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9580 /* stocfhe */, SystemZ::STOCFHAsmE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9588 /* stocfhh */, SystemZ::STOCFHAsmH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9596 /* stocfhhe */, SystemZ::STOCFHAsmHE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9605 /* stocfhl */, SystemZ::STOCFHAsmL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9613 /* stocfhle */, SystemZ::STOCFHAsmLE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9622 /* stocfhlh */, SystemZ::STOCFHAsmLH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9631 /* stocfhm */, SystemZ::STOCFHAsmM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9639 /* stocfhne */, SystemZ::STOCFHAsmNE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9648 /* stocfhnh */, SystemZ::STOCFHAsmNH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9657 /* stocfhnhe */, SystemZ::STOCFHAsmNHE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9667 /* stocfhnl */, SystemZ::STOCFHAsmNL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9676 /* stocfhnle */, SystemZ::STOCFHAsmNLE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9686 /* stocfhnlh */, SystemZ::STOCFHAsmNLH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9696 /* stocfhnm */, SystemZ::STOCFHAsmNM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9705 /* stocfhno */, SystemZ::STOCFHAsmNO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9714 /* stocfhnp */, SystemZ::STOCFHAsmNP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9723 /* stocfhnz */, SystemZ::STOCFHAsmNZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9732 /* stocfho */, SystemZ::STOCFHAsmO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9740 /* stocfhp */, SystemZ::STOCFHAsmP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9748 /* stocfhz */, SystemZ::STOCFHAsmZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9756 /* stocg */, SystemZ::STOCGAsm, Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9762 /* stocge */, SystemZ::STOCGAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9769 /* stocgh */, SystemZ::STOCGAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9776 /* stocghe */, SystemZ::STOCGAsmHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9784 /* stocgl */, SystemZ::STOCGAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9791 /* stocgle */, SystemZ::STOCGAsmLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9799 /* stocglh */, SystemZ::STOCGAsmLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9807 /* stocgm */, SystemZ::STOCGAsmM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9814 /* stocgne */, SystemZ::STOCGAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9822 /* stocgnh */, SystemZ::STOCGAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9830 /* stocgnhe */, SystemZ::STOCGAsmNHE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9839 /* stocgnl */, SystemZ::STOCGAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9847 /* stocgnle */, SystemZ::STOCGAsmNLE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9856 /* stocgnlh */, SystemZ::STOCGAsmNLH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9865 /* stocgnm */, SystemZ::STOCGAsmNM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9873 /* stocgno */, SystemZ::STOCGAsmNO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9881 /* stocgnp */, SystemZ::STOCGAsmNP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9889 /* stocgnz */, SystemZ::STOCGAsmNZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9897 /* stocgo */, SystemZ::STOCGAsmO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9904 /* stocgp */, SystemZ::STOCGAsmP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9911 /* stocgz */, SystemZ::STOCGAsmZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9918 /* stoch */, SystemZ::STOCAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9924 /* stoche */, SystemZ::STOCAsmHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9931 /* stocl */, SystemZ::STOCAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9937 /* stocle */, SystemZ::STOCAsmLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9944 /* stoclh */, SystemZ::STOCAsmLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9951 /* stocm */, SystemZ::STOCAsmM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9957 /* stocne */, SystemZ::STOCAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9964 /* stocnh */, SystemZ::STOCAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9971 /* stocnhe */, SystemZ::STOCAsmNHE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9979 /* stocnl */, SystemZ::STOCAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9986 /* stocnle */, SystemZ::STOCAsmNLE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9994 /* stocnlh */, SystemZ::STOCAsmNLH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10002 /* stocnm */, SystemZ::STOCAsmNM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10009 /* stocno */, SystemZ::STOCAsmNO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10016 /* stocnp */, SystemZ::STOCAsmNP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10023 /* stocnz */, SystemZ::STOCAsmNZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10030 /* stoco */, SystemZ::STOCAsmO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10036 /* stocp */, SystemZ::STOCAsmP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10042 /* stocz */, SystemZ::STOCAsmZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10048 /* stosm */, SystemZ::STOSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10054 /* stpq */, SystemZ::STPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 10059 /* stpt */, SystemZ::STPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10064 /* stpx */, SystemZ::STPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10069 /* strag */, SystemZ::STRAG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10075 /* strl */, SystemZ::STRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 10080 /* strv */, SystemZ::STRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10085 /* strvg */, SystemZ::STRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 10091 /* strvh */, SystemZ::STRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10097 /* stsch */, SystemZ::STSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10103 /* stsi */, SystemZ::STSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10108 /* stura */, SystemZ::STURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 10114 /* sturg */, SystemZ::STURG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10120 /* sty */, SystemZ::STY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10124 /* su */, SystemZ::SU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10127 /* sur */, SystemZ::SUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 10131 /* svc */, SystemZ::SVC, Convert__U8Imm1_0, AMFBS_None, { MCK_U8Imm }, },
  { 10135 /* sw */, SystemZ::SW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10138 /* swr */, SystemZ::SWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10142 /* sxbr */, SystemZ::SXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10147 /* sxr */, SystemZ::SXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10151 /* sxtr */, SystemZ::SXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 10156 /* sxtra */, SystemZ::SXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 10162 /* sy */, SystemZ::SY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10165 /* tabort */, SystemZ::TABORT, Convert__BDAddr64Disp122_0, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12 }, },
  { 10172 /* tam */, SystemZ::TAM, Convert_NoOperands, AMFBS_None, {  }, },
  { 10176 /* tar */, SystemZ::TAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 10180 /* tb */, SystemZ::TB, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10183 /* tbdr */, SystemZ::TBDR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 10188 /* tbedr */, SystemZ::TBEDR, Convert__FP321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64 }, },
  { 10194 /* tbegin */, SystemZ::TBEGIN, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10201 /* tbeginc */, SystemZ::TBEGINC, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10209 /* tcdb */, SystemZ::TCDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10214 /* tceb */, SystemZ::TCEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10219 /* tcxb */, SystemZ::TCXB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10224 /* tdcdt */, SystemZ::TDCDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10230 /* tdcet */, SystemZ::TDCET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10236 /* tdcxt */, SystemZ::TDCXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10242 /* tdgdt */, SystemZ::TDGDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10248 /* tdget */, SystemZ::TDGET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10254 /* tdgxt */, SystemZ::TDGXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10260 /* tend */, SystemZ::TEND, Convert_NoOperands, AMFBS_FeatureTransactionalExecution, {  }, },
  { 10265 /* thder */, SystemZ::THDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 10271 /* thdr */, SystemZ::THDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10276 /* tm */, SystemZ::TM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10279 /* tmh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10283 /* tmhh */, SystemZ::TMHH, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10288 /* tmhl */, SystemZ::TMHL, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10293 /* tml */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10297 /* tmlh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10302 /* tmll */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10307 /* tmy */, SystemZ::TMY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 10311 /* tp */, SystemZ::TP, Convert__BDLAddr64Disp12Len43_0, AMFBS_None, { MCK_BDLAddr64Disp12Len4 }, },
  { 10314 /* tpei */, SystemZ::TPEI, Convert__GR641_0__GR641_1, AMFBS_FeatureTestPendingExternalInterruption, { MCK_GR64, MCK_GR64 }, },
  { 10319 /* tpi */, SystemZ::TPI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10323 /* tprot */, SystemZ::TPROT, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10329 /* tr */, SystemZ::TR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10332 /* trace */, SystemZ::TRACE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 10338 /* tracg */, SystemZ::TRACG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 10344 /* trap2 */, SystemZ::TRAP2, Convert_NoOperands, AMFBS_None, {  }, },
  { 10350 /* trap4 */, SystemZ::TRAP4, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10356 /* tre */, SystemZ::TRE, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10360 /* troo */, SystemZ::TROOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10360 /* troo */, SystemZ::TROO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10365 /* trot */, SystemZ::TROTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10365 /* trot */, SystemZ::TROT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10370 /* trt */, SystemZ::TRT, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10374 /* trte */, SystemZ::TRTEOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10374 /* trte */, SystemZ::TRTE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10379 /* trto */, SystemZ::TRTOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10379 /* trto */, SystemZ::TRTO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10384 /* trtr */, SystemZ::TRTR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10389 /* trtre */, SystemZ::TRTREOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10389 /* trtre */, SystemZ::TRTRE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10395 /* trtt */, SystemZ::TRTTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10395 /* trtt */, SystemZ::TRTT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10400 /* ts */, SystemZ::TS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10403 /* tsch */, SystemZ::TSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10408 /* unpk */, SystemZ::UNPK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 10413 /* unpka */, SystemZ::UNPKA, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10419 /* unpku */, SystemZ::UNPKU, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10425 /* upt */, SystemZ::UPT, Convert_NoOperands, AMFBS_None, {  }, },
  { 10429 /* va */, SystemZ::VA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10432 /* vab */, SystemZ::VAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10436 /* vac */, SystemZ::VAC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10440 /* vacc */, SystemZ::VACC, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10445 /* vaccb */, SystemZ::VACCB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10451 /* vaccc */, SystemZ::VACCC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10457 /* vacccq */, SystemZ::VACCCQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10464 /* vaccf */, SystemZ::VACCF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10470 /* vaccg */, SystemZ::VACCG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10476 /* vacch */, SystemZ::VACCH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10482 /* vaccq */, SystemZ::VACCQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10488 /* vacq */, SystemZ::VACQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10493 /* vaf */, SystemZ::VAF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10497 /* vag */, SystemZ::VAG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10501 /* vah */, SystemZ::VAH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10505 /* vap */, SystemZ::VAP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 10509 /* vaq */, SystemZ::VAQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10513 /* vavg */, SystemZ::VAVG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10518 /* vavgb */, SystemZ::VAVGB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10524 /* vavgf */, SystemZ::VAVGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10530 /* vavgg */, SystemZ::VAVGG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10536 /* vavgh */, SystemZ::VAVGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10542 /* vavgl */, SystemZ::VAVGL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10548 /* vavglb */, SystemZ::VAVGLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10555 /* vavglf */, SystemZ::VAVGLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10562 /* vavglg */, SystemZ::VAVGLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10569 /* vavglh */, SystemZ::VAVGLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10576 /* vavglq */, SystemZ::VAVGLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10583 /* vavgq */, SystemZ::VAVGQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10589 /* vblend */, SystemZ::VBLEND, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10596 /* vblendb */, SystemZ::VBLENDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10604 /* vblendf */, SystemZ::VBLENDF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10612 /* vblendg */, SystemZ::VBLENDG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10620 /* vblendh */, SystemZ::VBLENDH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10628 /* vblendq */, SystemZ::VBLENDQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10636 /* vbperm */, SystemZ::VBPERM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10643 /* vcdg */, SystemZ::VCDG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10648 /* vcdgb */, SystemZ::VCDGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10654 /* vcdlg */, SystemZ::VCDLG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10660 /* vcdlgb */, SystemZ::VCDLGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10667 /* vcefb */, SystemZ::VCEFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10673 /* vcelfb */, SystemZ::VCELFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10680 /* vceq */, SystemZ::VCEQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10685 /* vceqb */, SystemZ::VCEQB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10691 /* vceqbs */, SystemZ::VCEQBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10698 /* vceqf */, SystemZ::VCEQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10704 /* vceqfs */, SystemZ::VCEQFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10711 /* vceqg */, SystemZ::VCEQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10717 /* vceqgs */, SystemZ::VCEQGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10724 /* vceqh */, SystemZ::VCEQH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10730 /* vceqhs */, SystemZ::VCEQHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10737 /* vceqq */, SystemZ::VCEQQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10743 /* vceqqs */, SystemZ::VCEQQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10750 /* vcfeb */, SystemZ::VCFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10756 /* vcfn */, SystemZ::VCFN, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10761 /* vcfpl */, SystemZ::VCFPL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10767 /* vcfps */, SystemZ::VCFPS, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10773 /* vcgd */, SystemZ::VCGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10778 /* vcgdb */, SystemZ::VCGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10784 /* vch */, SystemZ::VCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10788 /* vchb */, SystemZ::VCHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10793 /* vchbs */, SystemZ::VCHBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10799 /* vchf */, SystemZ::VCHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10804 /* vchfs */, SystemZ::VCHFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10810 /* vchg */, SystemZ::VCHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10815 /* vchgs */, SystemZ::VCHGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10821 /* vchh */, SystemZ::VCHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10826 /* vchhs */, SystemZ::VCHHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10832 /* vchl */, SystemZ::VCHL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10837 /* vchlb */, SystemZ::VCHLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10843 /* vchlbs */, SystemZ::VCHLBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10850 /* vchlf */, SystemZ::VCHLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10856 /* vchlfs */, SystemZ::VCHLFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10863 /* vchlg */, SystemZ::VCHLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10869 /* vchlgs */, SystemZ::VCHLGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10876 /* vchlh */, SystemZ::VCHLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10882 /* vchlhs */, SystemZ::VCHLHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10889 /* vchlq */, SystemZ::VCHLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10895 /* vchlqs */, SystemZ::VCHLQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10902 /* vchq */, SystemZ::VCHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10907 /* vchqs */, SystemZ::VCHQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10913 /* vcksm */, SystemZ::VCKSM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10919 /* vclfeb */, SystemZ::VCLFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10926 /* vclfnh */, SystemZ::VCLFNH, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10933 /* vclfnl */, SystemZ::VCLFNL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10940 /* vclfp */, SystemZ::VCLFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10946 /* vclgd */, SystemZ::VCLGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10952 /* vclgdb */, SystemZ::VCLGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10959 /* vclz */, SystemZ::VCLZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10964 /* vclzb */, SystemZ::VCLZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10970 /* vclzdp */, SystemZ::VCLZDP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10977 /* vclzf */, SystemZ::VCLZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10983 /* vclzg */, SystemZ::VCLZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10989 /* vclzh */, SystemZ::VCLZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10995 /* vclzq */, SystemZ::VCLZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11001 /* vcnf */, SystemZ::VCNF, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11006 /* vcp */, SystemZ::VCP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11010 /* vcrnf */, SystemZ::VCRNF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11016 /* vcsfp */, SystemZ::VCSFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11022 /* vcsph */, SystemZ::VCSPH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11028 /* vctz */, SystemZ::VCTZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11033 /* vctzb */, SystemZ::VCTZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11039 /* vctzf */, SystemZ::VCTZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11045 /* vctzg */, SystemZ::VCTZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11051 /* vctzh */, SystemZ::VCTZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11057 /* vctzq */, SystemZ::VCTZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11063 /* vcvb */, SystemZ::VCVB, Convert__GR321_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR32, MCK_VR128, MCK_U4Imm }, },
  { 11063 /* vcvb */, SystemZ::VCVBOpt, Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR32, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11068 /* vcvbg */, SystemZ::VCVBG, Convert__GR641_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR64, MCK_VR128, MCK_U4Imm }, },
  { 11068 /* vcvbg */, SystemZ::VCVBGOpt, Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11074 /* vcvbq */, SystemZ::VCVBQ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11080 /* vcvd */, SystemZ::VCVD, Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_U8Imm, MCK_U4Imm }, },
  { 11085 /* vcvdg */, SystemZ::VCVDG, Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR64, MCK_U8Imm, MCK_U4Imm }, },
  { 11091 /* vcvdq */, SystemZ::VCVDQ, Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11097 /* vd */, SystemZ::VD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11100 /* vdf */, SystemZ::VDF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11104 /* vdg */, SystemZ::VDG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11108 /* vdl */, SystemZ::VDL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11112 /* vdlf */, SystemZ::VDLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11117 /* vdlg */, SystemZ::VDLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11122 /* vdlq */, SystemZ::VDLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11127 /* vdp */, SystemZ::VDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11131 /* vdq */, SystemZ::VDQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11135 /* vec */, SystemZ::VEC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11139 /* vecb */, SystemZ::VECB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11144 /* vecf */, SystemZ::VECF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11149 /* vecg */, SystemZ::VECG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11154 /* vech */, SystemZ::VECH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11159 /* vecl */, SystemZ::VECL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11164 /* veclb */, SystemZ::VECLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11170 /* veclf */, SystemZ::VECLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11176 /* veclg */, SystemZ::VECLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11182 /* veclh */, SystemZ::VECLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11188 /* veclq */, SystemZ::VECLQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11194 /* vecq */, SystemZ::VECQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11199 /* verim */, SystemZ::VERIM, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11205 /* verimb */, SystemZ::VERIMB, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11212 /* verimf */, SystemZ::VERIMF, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11219 /* verimg */, SystemZ::VERIMG, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11226 /* verimh */, SystemZ::VERIMH, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11233 /* verll */, SystemZ::VERLL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11239 /* verllb */, SystemZ::VERLLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11246 /* verllf */, SystemZ::VERLLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11253 /* verllg */, SystemZ::VERLLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11260 /* verllh */, SystemZ::VERLLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11267 /* verllv */, SystemZ::VERLLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11274 /* verllvb */, SystemZ::VERLLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11282 /* verllvf */, SystemZ::VERLLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11290 /* verllvg */, SystemZ::VERLLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11298 /* verllvh */, SystemZ::VERLLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11306 /* vesl */, SystemZ::VESL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11311 /* veslb */, SystemZ::VESLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11317 /* veslf */, SystemZ::VESLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11323 /* veslg */, SystemZ::VESLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11329 /* veslh */, SystemZ::VESLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11335 /* veslv */, SystemZ::VESLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11341 /* veslvb */, SystemZ::VESLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11348 /* veslvf */, SystemZ::VESLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11355 /* veslvg */, SystemZ::VESLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11362 /* veslvh */, SystemZ::VESLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11369 /* vesra */, SystemZ::VESRA, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11375 /* vesrab */, SystemZ::VESRAB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11382 /* vesraf */, SystemZ::VESRAF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11389 /* vesrag */, SystemZ::VESRAG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11396 /* vesrah */, SystemZ::VESRAH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11403 /* vesrav */, SystemZ::VESRAV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11410 /* vesravb */, SystemZ::VESRAVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11418 /* vesravf */, SystemZ::VESRAVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11426 /* vesravg */, SystemZ::VESRAVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11434 /* vesravh */, SystemZ::VESRAVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11442 /* vesrl */, SystemZ::VESRL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11448 /* vesrlb */, SystemZ::VESRLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11455 /* vesrlf */, SystemZ::VESRLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11462 /* vesrlg */, SystemZ::VESRLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11469 /* vesrlh */, SystemZ::VESRLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11476 /* vesrlv */, SystemZ::VESRLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11483 /* vesrlvb */, SystemZ::VESRLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11491 /* vesrlvf */, SystemZ::VESRLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11499 /* vesrlvg */, SystemZ::VESRLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11507 /* vesrlvh */, SystemZ::VESRLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11515 /* veval */, SystemZ::VEVAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11521 /* vfa */, SystemZ::VFA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11525 /* vfadb */, SystemZ::VFADB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11531 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11531 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11536 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11536 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11542 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11542 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11549 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11549 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11555 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11555 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11562 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11562 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11568 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11568 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11575 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11575 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11582 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11582 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11590 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11590 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11597 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11597 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11605 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11605 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11612 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11612 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11620 /* vfasb */, SystemZ::VFASB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11626 /* vfce */, SystemZ::VFCE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11631 /* vfcedb */, SystemZ::VFCEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11638 /* vfcedbs */, SystemZ::VFCEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11646 /* vfcesb */, SystemZ::VFCESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11653 /* vfcesbs */, SystemZ::VFCESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11661 /* vfch */, SystemZ::VFCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11666 /* vfchdb */, SystemZ::VFCHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11673 /* vfchdbs */, SystemZ::VFCHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11681 /* vfche */, SystemZ::VFCHE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11687 /* vfchedb */, SystemZ::VFCHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11695 /* vfchedbs */, SystemZ::VFCHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11704 /* vfchesb */, SystemZ::VFCHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11712 /* vfchesbs */, SystemZ::VFCHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11721 /* vfchsb */, SystemZ::VFCHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11728 /* vfchsbs */, SystemZ::VFCHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11736 /* vfd */, SystemZ::VFD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11740 /* vfddb */, SystemZ::VFDDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11746 /* vfdsb */, SystemZ::VFDSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11752 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11752 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11757 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11757 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11763 /* vfeebs */, SystemZ::VFEEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11770 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11770 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11776 /* vfeefs */, SystemZ::VFEEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11783 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11783 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11789 /* vfeehs */, SystemZ::VFEEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11796 /* vfeezb */, SystemZ::VFEEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11803 /* vfeezbs */, SystemZ::VFEEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11811 /* vfeezf */, SystemZ::VFEEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11818 /* vfeezfs */, SystemZ::VFEEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11826 /* vfeezh */, SystemZ::VFEEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11833 /* vfeezhs */, SystemZ::VFEEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11841 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11841 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11847 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11847 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11854 /* vfenebs */, SystemZ::VFENEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11862 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11862 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11869 /* vfenefs */, SystemZ::VFENEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11877 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11877 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11884 /* vfenehs */, SystemZ::VFENEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11892 /* vfenezb */, SystemZ::VFENEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11900 /* vfenezbs */, SystemZ::VFENEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11909 /* vfenezf */, SystemZ::VFENEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11917 /* vfenezfs */, SystemZ::VFENEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11926 /* vfenezh */, SystemZ::VFENEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11934 /* vfenezhs */, SystemZ::VFENEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11943 /* vfi */, SystemZ::VFI, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11947 /* vfidb */, SystemZ::VFIDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11953 /* vfisb */, SystemZ::VFISB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11959 /* vfkedb */, SystemZ::VFKEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11966 /* vfkedbs */, SystemZ::VFKEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11974 /* vfkesb */, SystemZ::VFKESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11981 /* vfkesbs */, SystemZ::VFKESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11989 /* vfkhdb */, SystemZ::VFKHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11996 /* vfkhdbs */, SystemZ::VFKHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12004 /* vfkhedb */, SystemZ::VFKHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12012 /* vfkhedbs */, SystemZ::VFKHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12021 /* vfkhesb */, SystemZ::VFKHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12029 /* vfkhesbs */, SystemZ::VFKHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12038 /* vfkhsb */, SystemZ::VFKHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12045 /* vfkhsbs */, SystemZ::VFKHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12053 /* vflcdb */, SystemZ::VFLCDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12060 /* vflcsb */, SystemZ::VFLCSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12067 /* vfll */, SystemZ::VFLL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12072 /* vflls */, SystemZ::VFLLS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12078 /* vflndb */, SystemZ::VFLNDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12085 /* vflnsb */, SystemZ::VFLNSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12092 /* vflpdb */, SystemZ::VFLPDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12099 /* vflpsb */, SystemZ::VFLPSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12106 /* vflr */, SystemZ::VFLR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12111 /* vflrd */, SystemZ::VFLRD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12117 /* vfm */, SystemZ::VFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12121 /* vfma */, SystemZ::VFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12126 /* vfmadb */, SystemZ::VFMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12133 /* vfmasb */, SystemZ::VFMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12140 /* vfmax */, SystemZ::VFMAX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12146 /* vfmaxdb */, SystemZ::VFMAXDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12154 /* vfmaxsb */, SystemZ::VFMAXSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12162 /* vfmdb */, SystemZ::VFMDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12168 /* vfmin */, SystemZ::VFMIN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12174 /* vfmindb */, SystemZ::VFMINDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12182 /* vfminsb */, SystemZ::VFMINSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12190 /* vfms */, SystemZ::VFMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12195 /* vfmsb */, SystemZ::VFMSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12201 /* vfmsdb */, SystemZ::VFMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12208 /* vfmssb */, SystemZ::VFMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12215 /* vfnma */, SystemZ::VFNMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12221 /* vfnmadb */, SystemZ::VFNMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12229 /* vfnmasb */, SystemZ::VFNMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12237 /* vfnms */, SystemZ::VFNMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12243 /* vfnmsdb */, SystemZ::VFNMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12251 /* vfnmssb */, SystemZ::VFNMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12259 /* vfpso */, SystemZ::VFPSO, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12265 /* vfpsodb */, SystemZ::VFPSODB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12273 /* vfpsosb */, SystemZ::VFPSOSB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12281 /* vfs */, SystemZ::VFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12285 /* vfsdb */, SystemZ::VFSDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12291 /* vfsq */, SystemZ::VFSQ, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12296 /* vfsqdb */, SystemZ::VFSQDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12303 /* vfsqsb */, SystemZ::VFSQSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12310 /* vfssb */, SystemZ::VFSSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12316 /* vftci */, SystemZ::VFTCI, Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12322 /* vftcidb */, SystemZ::VFTCIDB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12330 /* vftcisb */, SystemZ::VFTCISB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12338 /* vgbm */, SystemZ::VGBM, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_U16Imm }, },
  { 12343 /* vgef */, SystemZ::VGEF, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 12348 /* vgeg */, SystemZ::VGEG, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 12353 /* vgem */, SystemZ::VGEM, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12358 /* vgemb */, SystemZ::VGEMB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12364 /* vgemf */, SystemZ::VGEMF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12370 /* vgemg */, SystemZ::VGEMG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12376 /* vgemh */, SystemZ::VGEMH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12382 /* vgemq */, SystemZ::VGEMQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12388 /* vgfm */, SystemZ::VGFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12393 /* vgfma */, SystemZ::VGFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12399 /* vgfmab */, SystemZ::VGFMAB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12406 /* vgfmaf */, SystemZ::VGFMAF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12413 /* vgfmag */, SystemZ::VGFMAG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12420 /* vgfmah */, SystemZ::VGFMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12427 /* vgfmb */, SystemZ::VGFMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12433 /* vgfmf */, SystemZ::VGFMF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12439 /* vgfmg */, SystemZ::VGFMG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12445 /* vgfmh */, SystemZ::VGFMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12451 /* vgm */, SystemZ::VGM, Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 12455 /* vgmb */, SystemZ::VGMB, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12460 /* vgmf */, SystemZ::VGMF, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12465 /* vgmg */, SystemZ::VGMG, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12470 /* vgmh */, SystemZ::VGMH, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12475 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12475 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12481 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12481 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12488 /* vistrbs */, SystemZ::VISTRBS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12496 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12496 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12503 /* vistrfs */, SystemZ::VISTRFS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12511 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12511 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12518 /* vistrhs */, SystemZ::VISTRHS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12526 /* vl */, SystemZ::VL, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12526 /* vl */, SystemZ::VLAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12529 /* vlbb */, SystemZ::VLBB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12534 /* vlbr */, SystemZ::VLBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12539 /* vlbrf */, SystemZ::VLBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12545 /* vlbrg */, SystemZ::VLBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12551 /* vlbrh */, SystemZ::VLBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12557 /* vlbrq */, SystemZ::VLBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12563 /* vlbrrep */, SystemZ::VLBRREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12571 /* vlbrrepf */, SystemZ::VLBRREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12580 /* vlbrrepg */, SystemZ::VLBRREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12589 /* vlbrreph */, SystemZ::VLBRREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12598 /* vlc */, SystemZ::VLC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12602 /* vlcb */, SystemZ::VLCB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12607 /* vlcf */, SystemZ::VLCF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12612 /* vlcg */, SystemZ::VLCG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12617 /* vlch */, SystemZ::VLCH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12622 /* vlcq */, SystemZ::VLCQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12627 /* vlde */, SystemZ::VLDE, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12632 /* vldeb */, SystemZ::VLDEB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12638 /* vleb */, SystemZ::VLEB, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12643 /* vlebrf */, SystemZ::VLEBRF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12650 /* vlebrg */, SystemZ::VLEBRG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12657 /* vlebrh */, SystemZ::VLEBRH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12664 /* vled */, SystemZ::VLED, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12669 /* vledb */, SystemZ::VLEDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12675 /* vlef */, SystemZ::VLEF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12680 /* vleg */, SystemZ::VLEG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12685 /* vleh */, SystemZ::VLEH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12690 /* vleib */, SystemZ::VLEIB, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 12696 /* vleif */, SystemZ::VLEIF, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U2Imm }, },
  { 12702 /* vleig */, SystemZ::VLEIG, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U1Imm }, },
  { 12708 /* vleih */, SystemZ::VLEIH, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U3Imm }, },
  { 12714 /* vler */, SystemZ::VLER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12719 /* vlerf */, SystemZ::VLERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12725 /* vlerg */, SystemZ::VLERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12731 /* vlerh */, SystemZ::VLERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12737 /* vlgv */, SystemZ::VLGV, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12742 /* vlgvb */, SystemZ::VLGVB, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12748 /* vlgvf */, SystemZ::VLGVF, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12754 /* vlgvg */, SystemZ::VLGVG, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12760 /* vlgvh */, SystemZ::VLGVH, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12766 /* vlip */, SystemZ::VLIP, Convert__VR1281_0__U16Imm1_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 12771 /* vll */, SystemZ::VLL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12775 /* vllebrz */, SystemZ::VLLEBRZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12783 /* vllebrze */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12792 /* vllebrzf */, SystemZ::VLLEBRZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12801 /* vllebrzg */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12810 /* vllebrzh */, SystemZ::VLLEBRZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12819 /* vllez */, SystemZ::VLLEZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12825 /* vllezb */, SystemZ::VLLEZB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12832 /* vllezf */, SystemZ::VLLEZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12839 /* vllezg */, SystemZ::VLLEZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12846 /* vllezh */, SystemZ::VLLEZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12853 /* vllezlf */, SystemZ::VLLEZLF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12861 /* vlm */, SystemZ::VLM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 12861 /* vlm */, SystemZ::VLMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 12865 /* vlp */, SystemZ::VLP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12869 /* vlpb */, SystemZ::VLPB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12874 /* vlpf */, SystemZ::VLPF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12879 /* vlpg */, SystemZ::VLPG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12884 /* vlph */, SystemZ::VLPH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12889 /* vlpq */, SystemZ::VLPQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12894 /* vlr */, SystemZ::VLR, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12898 /* vlrep */, SystemZ::VLREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12904 /* vlrepb */, SystemZ::VLREPB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12911 /* vlrepf */, SystemZ::VLREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12918 /* vlrepg */, SystemZ::VLREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12925 /* vlreph */, SystemZ::VLREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12932 /* vlrl */, SystemZ::VLRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 12937 /* vlrlr */, SystemZ::VLRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12943 /* vlvg */, SystemZ::VLVG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12948 /* vlvgb */, SystemZ::VLVGB, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12954 /* vlvgf */, SystemZ::VLVGF, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12960 /* vlvgg */, SystemZ::VLVGG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12 }, },
  { 12966 /* vlvgh */, SystemZ::VLVGH, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12972 /* vlvgp */, SystemZ::VLVGP, Convert__VR1281_0__GR641_1__GR641_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_GR64 }, },
  { 12978 /* vmae */, SystemZ::VMAE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12983 /* vmaeb */, SystemZ::VMAEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12989 /* vmaef */, SystemZ::VMAEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12995 /* vmaeg */, SystemZ::VMAEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13001 /* vmaeh */, SystemZ::VMAEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13007 /* vmah */, SystemZ::VMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13012 /* vmahb */, SystemZ::VMAHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13018 /* vmahf */, SystemZ::VMAHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13024 /* vmahg */, SystemZ::VMAHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13030 /* vmahh */, SystemZ::VMAHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13036 /* vmahq */, SystemZ::VMAHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13042 /* vmal */, SystemZ::VMAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13047 /* vmalb */, SystemZ::VMALB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13053 /* vmale */, SystemZ::VMALE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13059 /* vmaleb */, SystemZ::VMALEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13066 /* vmalef */, SystemZ::VMALEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13073 /* vmaleg */, SystemZ::VMALEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13080 /* vmaleh */, SystemZ::VMALEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13087 /* vmalf */, SystemZ::VMALF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13093 /* vmalg */, SystemZ::VMALG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13099 /* vmalh */, SystemZ::VMALH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13105 /* vmalhb */, SystemZ::VMALHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13112 /* vmalhf */, SystemZ::VMALHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13119 /* vmalhg */, SystemZ::VMALHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13126 /* vmalhh */, SystemZ::VMALHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13133 /* vmalhq */, SystemZ::VMALHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13140 /* vmalhw */, SystemZ::VMALHW, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13147 /* vmalo */, SystemZ::VMALO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13153 /* vmalob */, SystemZ::VMALOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13160 /* vmalof */, SystemZ::VMALOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13167 /* vmalog */, SystemZ::VMALOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13174 /* vmaloh */, SystemZ::VMALOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13181 /* vmalq */, SystemZ::VMALQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13187 /* vmao */, SystemZ::VMAO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13192 /* vmaob */, SystemZ::VMAOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13198 /* vmaof */, SystemZ::VMAOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13204 /* vmaog */, SystemZ::VMAOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13210 /* vmaoh */, SystemZ::VMAOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13216 /* vme */, SystemZ::VME, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13220 /* vmeb */, SystemZ::VMEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13225 /* vmef */, SystemZ::VMEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13230 /* vmeg */, SystemZ::VMEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13235 /* vmeh */, SystemZ::VMEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13240 /* vmh */, SystemZ::VMH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13244 /* vmhb */, SystemZ::VMHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13249 /* vmhf */, SystemZ::VMHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13254 /* vmhg */, SystemZ::VMHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13259 /* vmhh */, SystemZ::VMHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13264 /* vmhq */, SystemZ::VMHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13269 /* vml */, SystemZ::VML, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13273 /* vmlb */, SystemZ::VMLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13278 /* vmle */, SystemZ::VMLE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13283 /* vmleb */, SystemZ::VMLEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13289 /* vmlef */, SystemZ::VMLEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13295 /* vmleg */, SystemZ::VMLEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13301 /* vmleh */, SystemZ::VMLEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13307 /* vmlf */, SystemZ::VMLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13312 /* vmlg */, SystemZ::VMLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13317 /* vmlh */, SystemZ::VMLH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13322 /* vmlhb */, SystemZ::VMLHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13328 /* vmlhf */, SystemZ::VMLHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13334 /* vmlhg */, SystemZ::VMLHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13340 /* vmlhh */, SystemZ::VMLHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13346 /* vmlhq */, SystemZ::VMLHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13352 /* vmlhw */, SystemZ::VMLHW, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13358 /* vmlo */, SystemZ::VMLO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13363 /* vmlob */, SystemZ::VMLOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13369 /* vmlof */, SystemZ::VMLOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13375 /* vmlog */, SystemZ::VMLOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13381 /* vmloh */, SystemZ::VMLOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13387 /* vmlq */, SystemZ::VMLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13392 /* vmn */, SystemZ::VMN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13396 /* vmnb */, SystemZ::VMNB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13401 /* vmnf */, SystemZ::VMNF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13406 /* vmng */, SystemZ::VMNG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13411 /* vmnh */, SystemZ::VMNH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13416 /* vmnl */, SystemZ::VMNL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13421 /* vmnlb */, SystemZ::VMNLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13427 /* vmnlf */, SystemZ::VMNLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13433 /* vmnlg */, SystemZ::VMNLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13439 /* vmnlh */, SystemZ::VMNLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13445 /* vmnlq */, SystemZ::VMNLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13451 /* vmnq */, SystemZ::VMNQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13456 /* vmo */, SystemZ::VMO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13460 /* vmob */, SystemZ::VMOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13465 /* vmof */, SystemZ::VMOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13470 /* vmog */, SystemZ::VMOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13475 /* vmoh */, SystemZ::VMOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13480 /* vmp */, SystemZ::VMP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13484 /* vmrh */, SystemZ::VMRH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13489 /* vmrhb */, SystemZ::VMRHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13495 /* vmrhf */, SystemZ::VMRHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13501 /* vmrhg */, SystemZ::VMRHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13507 /* vmrhh */, SystemZ::VMRHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13513 /* vmrl */, SystemZ::VMRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13518 /* vmrlb */, SystemZ::VMRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13524 /* vmrlf */, SystemZ::VMRLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13530 /* vmrlg */, SystemZ::VMRLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13536 /* vmrlh */, SystemZ::VMRLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13542 /* vmsl */, SystemZ::VMSL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13547 /* vmslg */, SystemZ::VMSLG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13553 /* vmsp */, SystemZ::VMSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13558 /* vmx */, SystemZ::VMX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13562 /* vmxb */, SystemZ::VMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13567 /* vmxf */, SystemZ::VMXF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13572 /* vmxg */, SystemZ::VMXG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13577 /* vmxh */, SystemZ::VMXH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13582 /* vmxl */, SystemZ::VMXL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13587 /* vmxlb */, SystemZ::VMXLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13593 /* vmxlf */, SystemZ::VMXLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13599 /* vmxlg */, SystemZ::VMXLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13605 /* vmxlh */, SystemZ::VMXLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13611 /* vmxlq */, SystemZ::VMXLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13617 /* vmxq */, SystemZ::VMXQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13622 /* vn */, SystemZ::VN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13625 /* vnc */, SystemZ::VNC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13629 /* vnn */, SystemZ::VNN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13633 /* vno */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13637 /* vnot */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 13642 /* vnx */, SystemZ::VNX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13646 /* vo */, SystemZ::VO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13649 /* voc */, SystemZ::VOC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13653 /* vone */, SystemZ::VONE, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 13658 /* vpdi */, SystemZ::VPDI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13663 /* vperm */, SystemZ::VPERM, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13669 /* vpk */, SystemZ::VPK, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13673 /* vpkf */, SystemZ::VPKF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13678 /* vpkg */, SystemZ::VPKG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13683 /* vpkh */, SystemZ::VPKH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13688 /* vpkls */, SystemZ::VPKLS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13694 /* vpklsf */, SystemZ::VPKLSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13701 /* vpklsfs */, SystemZ::VPKLSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13709 /* vpklsg */, SystemZ::VPKLSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13716 /* vpklsgs */, SystemZ::VPKLSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13724 /* vpklsh */, SystemZ::VPKLSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13731 /* vpklshs */, SystemZ::VPKLSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13739 /* vpks */, SystemZ::VPKS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13744 /* vpksf */, SystemZ::VPKSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13750 /* vpksfs */, SystemZ::VPKSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13757 /* vpksg */, SystemZ::VPKSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13763 /* vpksgs */, SystemZ::VPKSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13770 /* vpksh */, SystemZ::VPKSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13776 /* vpkshs */, SystemZ::VPKSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13783 /* vpkz */, SystemZ::VPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 13788 /* vpkzr */, SystemZ::VPKZR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13794 /* vpopct */, SystemZ::VPOPCT, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13801 /* vpopctb */, SystemZ::VPOPCTB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13809 /* vpopctf */, SystemZ::VPOPCTF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13817 /* vpopctg */, SystemZ::VPOPCTG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13825 /* vpopcth */, SystemZ::VPOPCTH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13833 /* vpsop */, SystemZ::VPSOP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 13839 /* vr */, SystemZ::VR, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13842 /* vrep */, SystemZ::VREP, Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 13847 /* vrepb */, SystemZ::VREPB, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13853 /* vrepf */, SystemZ::VREPF, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13859 /* vrepg */, SystemZ::VREPG, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13865 /* vreph */, SystemZ::VREPH, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13871 /* vrepi */, SystemZ::VREPI, Convert__VR1281_0__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 13877 /* vrepib */, SystemZ::VREPIB, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13884 /* vrepif */, SystemZ::VREPIF, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13891 /* vrepig */, SystemZ::VREPIG, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13898 /* vrepih */, SystemZ::VREPIH, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13905 /* vrf */, SystemZ::VRF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13909 /* vrg */, SystemZ::VRG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13913 /* vrl */, SystemZ::VRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13917 /* vrlf */, SystemZ::VRLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13922 /* vrlg */, SystemZ::VRLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13927 /* vrlq */, SystemZ::VRLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13932 /* vrp */, SystemZ::VRP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13936 /* vrq */, SystemZ::VRQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13940 /* vs */, SystemZ::VS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13943 /* vsb */, SystemZ::VSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13947 /* vsbcbi */, SystemZ::VSBCBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13954 /* vsbcbiq */, SystemZ::VSBCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13962 /* vsbi */, SystemZ::VSBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13967 /* vsbiq */, SystemZ::VSBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13973 /* vscbi */, SystemZ::VSCBI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13979 /* vscbib */, SystemZ::VSCBIB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13986 /* vscbif */, SystemZ::VSCBIF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13993 /* vscbig */, SystemZ::VSCBIG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14000 /* vscbih */, SystemZ::VSCBIH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14007 /* vscbiq */, SystemZ::VSCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14014 /* vscef */, SystemZ::VSCEF, Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 14020 /* vsceg */, SystemZ::VSCEG, Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 14026 /* vschdp */, SystemZ::VSCHDP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14033 /* vschp */, SystemZ::VSCHP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14039 /* vschsp */, SystemZ::VSCHSP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14046 /* vschxp */, SystemZ::VSCHXP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14053 /* vscshp */, SystemZ::VSCSHP, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14060 /* vsdp */, SystemZ::VSDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14065 /* vseg */, SystemZ::VSEG, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14070 /* vsegb */, SystemZ::VSEGB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14076 /* vsegf */, SystemZ::VSEGF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14082 /* vsegh */, SystemZ::VSEGH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14088 /* vsel */, SystemZ::VSEL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14093 /* vsf */, SystemZ::VSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14097 /* vsg */, SystemZ::VSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14101 /* vsh */, SystemZ::VSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14105 /* vsl */, SystemZ::VSL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14109 /* vslb */, SystemZ::VSLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14114 /* vsld */, SystemZ::VSLD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14119 /* vsldb */, SystemZ::VSLDB, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14125 /* vsp */, SystemZ::VSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14129 /* vsq */, SystemZ::VSQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14133 /* vsra */, SystemZ::VSRA, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14138 /* vsrab */, SystemZ::VSRAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14144 /* vsrd */, SystemZ::VSRD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14149 /* vsrl */, SystemZ::VSRL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14154 /* vsrlb */, SystemZ::VSRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14160 /* vsrp */, SystemZ::VSRP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 14165 /* vsrpr */, SystemZ::VSRPR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14171 /* vst */, SystemZ::VST, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14171 /* vst */, SystemZ::VSTAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14175 /* vstbr */, SystemZ::VSTBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14181 /* vstbrf */, SystemZ::VSTBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14188 /* vstbrg */, SystemZ::VSTBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14195 /* vstbrh */, SystemZ::VSTBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14202 /* vstbrq */, SystemZ::VSTBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14209 /* vsteb */, SystemZ::VSTEB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14215 /* vstebrf */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14223 /* vstebrg */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14231 /* vstebrh */, SystemZ::VSTEBRH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14239 /* vstef */, SystemZ::VSTEF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14245 /* vsteg */, SystemZ::VSTEG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14251 /* vsteh */, SystemZ::VSTEH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14257 /* vster */, SystemZ::VSTER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14263 /* vsterf */, SystemZ::VSTERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14270 /* vsterg */, SystemZ::VSTERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14277 /* vsterh */, SystemZ::VSTERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14284 /* vstl */, SystemZ::VSTL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14289 /* vstm */, SystemZ::VSTM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 14289 /* vstm */, SystemZ::VSTMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 14294 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14294 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14300 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14300 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14307 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14307 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14315 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14315 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14322 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14322 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14330 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14330 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14337 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14337 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14345 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14345 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14353 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14353 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14362 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14362 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14370 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14370 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14379 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14379 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14387 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14387 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14396 /* vstrl */, SystemZ::VSTRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14402 /* vstrlr */, SystemZ::VSTRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14409 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14409 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14415 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14415 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14422 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14422 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14429 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14429 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14436 /* vstrszb */, SystemZ::VSTRSZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14444 /* vstrszf */, SystemZ::VSTRSZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14452 /* vstrszh */, SystemZ::VSTRSZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14460 /* vsum */, SystemZ::VSUM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14465 /* vsumb */, SystemZ::VSUMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14471 /* vsumg */, SystemZ::VSUMG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14477 /* vsumgf */, SystemZ::VSUMGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14484 /* vsumgh */, SystemZ::VSUMGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14491 /* vsumh */, SystemZ::VSUMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14497 /* vsumq */, SystemZ::VSUMQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14503 /* vsumqf */, SystemZ::VSUMQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14510 /* vsumqg */, SystemZ::VSUMQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14517 /* vtm */, SystemZ::VTM, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14521 /* vtp */, SystemZ::VTP, Convert__VR1281_0, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128 }, },
  { 14521 /* vtp */, SystemZ::VTPOpt, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_U16Imm }, },
  { 14525 /* vtz */, SystemZ::VTZ, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 14529 /* vuph */, SystemZ::VUPH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14534 /* vuphb */, SystemZ::VUPHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14540 /* vuphf */, SystemZ::VUPHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14546 /* vuphg */, SystemZ::VUPHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14552 /* vuphh */, SystemZ::VUPHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14558 /* vupkz */, SystemZ::VUPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14564 /* vupkzh */, SystemZ::VUPKZH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14571 /* vupkzl */, SystemZ::VUPKZL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14578 /* vupl */, SystemZ::VUPL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14583 /* vuplb */, SystemZ::VUPLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14589 /* vuplf */, SystemZ::VUPLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14595 /* vuplg */, SystemZ::VUPLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14601 /* vuplh */, SystemZ::VUPLH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14607 /* vuplhb */, SystemZ::VUPLHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14614 /* vuplhf */, SystemZ::VUPLHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14621 /* vuplhg */, SystemZ::VUPLHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14628 /* vuplhh */, SystemZ::VUPLHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14635 /* vuplhw */, SystemZ::VUPLHW, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14642 /* vupll */, SystemZ::VUPLL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14648 /* vupllb */, SystemZ::VUPLLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14655 /* vupllf */, SystemZ::VUPLLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14662 /* vupllg */, SystemZ::VUPLLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14669 /* vupllh */, SystemZ::VUPLLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14676 /* vx */, SystemZ::VX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14679 /* vzero */, SystemZ::VZERO, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 14685 /* wcdgb */, SystemZ::WCDGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14691 /* wcdlgb */, SystemZ::WCDLGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14698 /* wcefb */, SystemZ::WCEFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14704 /* wcelfb */, SystemZ::WCELFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14711 /* wcfeb */, SystemZ::WCFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14717 /* wcgdb */, SystemZ::WCGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14723 /* wclfeb */, SystemZ::WCLFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14730 /* wclgdb */, SystemZ::WCLGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14737 /* wfadb */, SystemZ::WFADB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14743 /* wfasb */, SystemZ::WFASB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14749 /* wfaxb */, SystemZ::WFAXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14755 /* wfc */, SystemZ::WFC, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14759 /* wfcdb */, SystemZ::WFCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14765 /* wfcedb */, SystemZ::WFCEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14772 /* wfcedbs */, SystemZ::WFCEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14780 /* wfcesb */, SystemZ::WFCESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14787 /* wfcesbs */, SystemZ::WFCESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14795 /* wfcexb */, SystemZ::WFCEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14802 /* wfcexbs */, SystemZ::WFCEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14810 /* wfchdb */, SystemZ::WFCHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14817 /* wfchdbs */, SystemZ::WFCHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14825 /* wfchedb */, SystemZ::WFCHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14833 /* wfchedbs */, SystemZ::WFCHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14842 /* wfchesb */, SystemZ::WFCHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14850 /* wfchesbs */, SystemZ::WFCHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14859 /* wfchexb */, SystemZ::WFCHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14867 /* wfchexbs */, SystemZ::WFCHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14876 /* wfchsb */, SystemZ::WFCHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14883 /* wfchsbs */, SystemZ::WFCHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14891 /* wfchxb */, SystemZ::WFCHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14898 /* wfchxbs */, SystemZ::WFCHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14906 /* wfcsb */, SystemZ::WFCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 14912 /* wfcxb */, SystemZ::WFCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 14918 /* wfddb */, SystemZ::WFDDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14924 /* wfdsb */, SystemZ::WFDSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14930 /* wfdxb */, SystemZ::WFDXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14936 /* wfidb */, SystemZ::WFIDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14942 /* wfisb */, SystemZ::WFISB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14948 /* wfixb */, SystemZ::WFIXB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14954 /* wfk */, SystemZ::WFK, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14958 /* wfkdb */, SystemZ::WFKDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14964 /* wfkedb */, SystemZ::WFKEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14971 /* wfkedbs */, SystemZ::WFKEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14979 /* wfkesb */, SystemZ::WFKESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14986 /* wfkesbs */, SystemZ::WFKESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14994 /* wfkexb */, SystemZ::WFKEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15001 /* wfkexbs */, SystemZ::WFKEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15009 /* wfkhdb */, SystemZ::WFKHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15016 /* wfkhdbs */, SystemZ::WFKHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15024 /* wfkhedb */, SystemZ::WFKHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15032 /* wfkhedbs */, SystemZ::WFKHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15041 /* wfkhesb */, SystemZ::WFKHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15049 /* wfkhesbs */, SystemZ::WFKHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15058 /* wfkhexb */, SystemZ::WFKHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15066 /* wfkhexbs */, SystemZ::WFKHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15075 /* wfkhsb */, SystemZ::WFKHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15082 /* wfkhsbs */, SystemZ::WFKHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15090 /* wfkhxb */, SystemZ::WFKHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15097 /* wfkhxbs */, SystemZ::WFKHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15105 /* wfksb */, SystemZ::WFKSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15111 /* wfkxb */, SystemZ::WFKXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15117 /* wflcdb */, SystemZ::WFLCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15124 /* wflcsb */, SystemZ::WFLCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15131 /* wflcxb */, SystemZ::WFLCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15138 /* wflld */, SystemZ::WFLLD, Convert__VR1281_0__VR641_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR64 }, },
  { 15144 /* wflls */, SystemZ::WFLLS, Convert__VR641_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR32 }, },
  { 15150 /* wflndb */, SystemZ::WFLNDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15157 /* wflnsb */, SystemZ::WFLNSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15164 /* wflnxb */, SystemZ::WFLNXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15171 /* wflpdb */, SystemZ::WFLPDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15178 /* wflpsb */, SystemZ::WFLPSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15185 /* wflpxb */, SystemZ::WFLPXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15192 /* wflrd */, SystemZ::WFLRD, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15198 /* wflrx */, SystemZ::WFLRX, Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 15204 /* wfmadb */, SystemZ::WFMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15211 /* wfmasb */, SystemZ::WFMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15218 /* wfmaxb */, SystemZ::WFMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15225 /* wfmaxdb */, SystemZ::WFMAXDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15233 /* wfmaxsb */, SystemZ::WFMAXSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15241 /* wfmaxxb */, SystemZ::WFMAXXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15249 /* wfmdb */, SystemZ::WFMDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15255 /* wfmindb */, SystemZ::WFMINDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15263 /* wfminsb */, SystemZ::WFMINSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15271 /* wfminxb */, SystemZ::WFMINXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15279 /* wfmsb */, SystemZ::WFMSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15285 /* wfmsdb */, SystemZ::WFMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15292 /* wfmssb */, SystemZ::WFMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15299 /* wfmsxb */, SystemZ::WFMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15306 /* wfmxb */, SystemZ::WFMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15312 /* wfnmadb */, SystemZ::WFNMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15320 /* wfnmasb */, SystemZ::WFNMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15328 /* wfnmaxb */, SystemZ::WFNMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15336 /* wfnmsdb */, SystemZ::WFNMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15344 /* wfnmssb */, SystemZ::WFNMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15352 /* wfnmsxb */, SystemZ::WFNMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15360 /* wfpsodb */, SystemZ::WFPSODB, Convert__VR641_0__VR641_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15368 /* wfpsosb */, SystemZ::WFPSOSB, Convert__VR321_0__VR321_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15376 /* wfpsoxb */, SystemZ::WFPSOXB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15384 /* wfsdb */, SystemZ::WFSDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15390 /* wfsqdb */, SystemZ::WFSQDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15397 /* wfsqsb */, SystemZ::WFSQSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15404 /* wfsqxb */, SystemZ::WFSQXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15411 /* wfssb */, SystemZ::WFSSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15417 /* wfsxb */, SystemZ::WFSXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15423 /* wftcidb */, SystemZ::WFTCIDB, Convert__VR641_0__VR641_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U12Imm }, },
  { 15431 /* wftcisb */, SystemZ::WFTCISB, Convert__VR321_0__VR321_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U12Imm }, },
  { 15439 /* wftcixb */, SystemZ::WFTCIXB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 15447 /* wldeb */, SystemZ::WLDEB, Convert__VR641_0__VR321_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR32 }, },
  { 15453 /* wledb */, SystemZ::WLEDB, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15459 /* x */, SystemZ::X, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 15461 /* xc */, SystemZ::XC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 15464 /* xg */, SystemZ::XG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 15467 /* xgr */, SystemZ::XGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 15471 /* xgrk */, SystemZ::XGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 15476 /* xi */, SystemZ::XI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 15479 /* xihf */, SystemZ::XIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 15484 /* xilf */, SystemZ::XILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 15489 /* xiy */, SystemZ::XIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 15493 /* xr */, SystemZ::XR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 15496 /* xrk */, SystemZ::XRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 15500 /* xsch */, SystemZ::XSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 15505 /* xy */, SystemZ::XY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 15508 /* zap */, SystemZ::ZAP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
};

static const MatchEntry MatchTable1[] = {
  { 0 /* a */, SystemZ::A, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2 /* ad */, SystemZ::AD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5 /* adb */, SystemZ::ADB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9 /* adbr */, SystemZ::ADBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 14 /* adr */, SystemZ::ADR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 18 /* adtr */, SystemZ::ADTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 23 /* adtra */, SystemZ::ADTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 29 /* ae */, SystemZ::AE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 32 /* aeb */, SystemZ::AEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 36 /* aebr */, SystemZ::AEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 41 /* aer */, SystemZ::AER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 45 /* afi */, SystemZ::AFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 49 /* ag */, SystemZ::AG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 52 /* agf */, SystemZ::AGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 56 /* agfi */, SystemZ::AGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 61 /* agfr */, SystemZ::AGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 66 /* agh */, SystemZ::AGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 70 /* aghi */, SystemZ::AGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 75 /* aghik */, SystemZ::AGHIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 81 /* agr */, SystemZ::AGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 85 /* agrk */, SystemZ::AGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 90 /* agsi */, SystemZ::AGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 95 /* ah */, SystemZ::AH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 98 /* ahhhr */, SystemZ::AHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 104 /* ahhlr */, SystemZ::AHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 110 /* ahi */, SystemZ::AHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 114 /* ahik */, SystemZ::AHIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 119 /* ahy */, SystemZ::AHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 123 /* aih */, SystemZ::AIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 127 /* al */, SystemZ::AL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 130 /* alc */, SystemZ::ALC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 134 /* alcg */, SystemZ::ALCG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 139 /* alcgr */, SystemZ::ALCGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 145 /* alcr */, SystemZ::ALCR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 150 /* alfi */, SystemZ::ALFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 155 /* alg */, SystemZ::ALG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 159 /* algf */, SystemZ::ALGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 164 /* algfi */, SystemZ::ALGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 170 /* algfr */, SystemZ::ALGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 176 /* alghsik */, SystemZ::ALGHSIK, Convert__GR641_0__GR641_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_S16Imm }, },
  { 184 /* algr */, SystemZ::ALGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 189 /* algrk */, SystemZ::ALGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 195 /* algsi */, SystemZ::ALGSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 201 /* alhhhr */, SystemZ::ALHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 208 /* alhhlr */, SystemZ::ALHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 215 /* alhsik */, SystemZ::ALHSIK, Convert__GR321_0__GR321_1__S16Imm1_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_S16Imm }, },
  { 222 /* alr */, SystemZ::ALR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 226 /* alrk */, SystemZ::ALRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 231 /* alsi */, SystemZ::ALSI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 236 /* alsih */, SystemZ::ALSIH, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 242 /* alsihn */, SystemZ::ALSIHN, Convert__GRH321_0__Tie0_1_1__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 249 /* aly */, SystemZ::ALY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 253 /* ap */, SystemZ::AP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 256 /* ar */, SystemZ::AR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 259 /* ark */, SystemZ::ARK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 263 /* asi */, SystemZ::ASI, Convert__BDAddr64Disp202_0__S8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_S8Imm }, },
  { 267 /* au */, SystemZ::AU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 270 /* aur */, SystemZ::AUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 274 /* aw */, SystemZ::AW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 277 /* awr */, SystemZ::AWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 281 /* axbr */, SystemZ::AXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 286 /* axr */, SystemZ::AXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 290 /* axtr */, SystemZ::AXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 295 /* axtra */, SystemZ::AXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 301 /* ay */, SystemZ::AY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 304 /* b */, SystemZ::B, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 306 /* bakr */, SystemZ::BAKR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 311 /* bal */, SystemZ::BAL, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 315 /* balr */, SystemZ::BALR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 320 /* bas */, SystemZ::BAS, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 324 /* basr */, SystemZ::BASR, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 329 /* bassm */, SystemZ::BASSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 335 /* bc */, SystemZ::BCAsm, Convert__U4Imm1_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp12 }, },
  { 338 /* bcr */, SystemZ::BCRAsm, Convert__U4Imm1_0__GR641_1, AMFBS_None, { MCK_U4Imm, MCK_GR64 }, },
  { 342 /* bct */, SystemZ::BCT, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 346 /* bctg */, SystemZ::BCTG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 351 /* bctgr */, SystemZ::BCTGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 357 /* bctr */, SystemZ::BCTR, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 362 /* bdepg */, SystemZ::BDEPG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 368 /* be */, SystemZ::BAsmE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 371 /* ber */, SystemZ::BRAsmE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 375 /* bextg */, SystemZ::BEXTG, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 381 /* bh */, SystemZ::BAsmH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 393 /* bhr */, SystemZ::BRAsmH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 397 /* bi */, SystemZ::BI, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 400 /* bic */, SystemZ::BICAsm, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 404 /* bie */, SystemZ::BIAsmE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 408 /* bih */, SystemZ::BIAsmH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 417 /* bil */, SystemZ::BIAsmL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 431 /* bim */, SystemZ::BIAsmM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 435 /* bine */, SystemZ::BIAsmNE, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 440 /* binh */, SystemZ::BIAsmNH, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 451 /* binl */, SystemZ::BIAsmNL, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 468 /* binm */, SystemZ::BIAsmNM, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 473 /* bino */, SystemZ::BIAsmNO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 478 /* binp */, SystemZ::BIAsmNP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 483 /* binz */, SystemZ::BIAsmNZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 488 /* bio */, SystemZ::BIAsmO, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 492 /* bip */, SystemZ::BIAsmP, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 496 /* biz */, SystemZ::BIAsmZ, Convert__BDXAddr64Disp203_0, AMFBS_FeatureMiscellaneousExtensions2, { MCK_BDXAddr64Disp20 }, },
  { 500 /* bl */, SystemZ::BAsmL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 521 /* blr */, SystemZ::BRAsmL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 525 /* bm */, SystemZ::BAsmM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 528 /* bmr */, SystemZ::BRAsmM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 532 /* bne */, SystemZ::BAsmNE, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 536 /* bner */, SystemZ::BRAsmNE, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 541 /* bnh */, SystemZ::BAsmNH, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 556 /* bnhr */, SystemZ::BRAsmNH, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 561 /* bnl */, SystemZ::BAsmNL, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 587 /* bnlr */, SystemZ::BRAsmNL, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 592 /* bnm */, SystemZ::BAsmNM, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 596 /* bnmr */, SystemZ::BRAsmNM, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 601 /* bno */, SystemZ::BAsmNO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 605 /* bnor */, SystemZ::BRAsmNO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 610 /* bnp */, SystemZ::BAsmNP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 614 /* bnpr */, SystemZ::BRAsmNP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 619 /* bnz */, SystemZ::BAsmNZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 623 /* bnzr */, SystemZ::BRAsmNZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 628 /* bo */, SystemZ::BAsmO, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 631 /* bor */, SystemZ::BRAsmO, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 635 /* bp */, SystemZ::BAsmP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 638 /* bpp */, SystemZ::BPP, Convert__U4Imm1_0__PCRel161_1__BDAddr64Disp122_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel16, MCK_BDAddr64Disp12 }, },
  { 642 /* bpr */, SystemZ::BRAsmP, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 646 /* bprp */, SystemZ::BPRP, Convert__U4Imm1_0__PCRel121_1__PCRel241_2, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_PCRel12, MCK_PCRel24 }, },
  { 651 /* br */, SystemZ::BR, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 654 /* bras */, SystemZ::BRAS, Convert__GR641_0__PCRelTLS162_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS16 }, },
  { 659 /* brasl */, SystemZ::BRASL, Convert__GR641_0__PCRelTLS322_1, AMFBS_None, { MCK_GR64, MCK_PCRelTLS32 }, },
  { 665 /* brc */, SystemZ::BRCAsm, Convert__U4Imm1_0__PCRel161_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel16 }, },
  { 669 /* brcl */, SystemZ::BRCLAsm, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 674 /* brct */, SystemZ::BRCT, Convert__GR321_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR32, MCK_PCRel16 }, },
  { 679 /* brctg */, SystemZ::BRCTG, Convert__GR641_0__Tie0_1_1__PCRel161_1, AMFBS_None, { MCK_GR64, MCK_PCRel16 }, },
  { 685 /* brcth */, SystemZ::BRCTH, Convert__GRH321_0__Tie0_1_1__PCRel321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_PCRel32 }, },
  { 691 /* brxh */, SystemZ::BRXH, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 696 /* brxhg */, SystemZ::BRXHG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 702 /* brxle */, SystemZ::BRXLE, Convert__GR321_0__Tie0_1_1__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 708 /* brxlg */, SystemZ::BRXLG, Convert__GR641_0__Tie0_1_1__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 714 /* bsa */, SystemZ::BSA, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 718 /* bsg */, SystemZ::BSG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 722 /* bsm */, SystemZ::BSM, Convert__GR641_0__ADDR641_1, AMFBS_None, { MCK_GR64, MCK_ADDR64 }, },
  { 726 /* bxh */, SystemZ::BXH, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 730 /* bxhg */, SystemZ::BXHG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 735 /* bxle */, SystemZ::BXLE, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 740 /* bxleg */, SystemZ::BXLEG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 746 /* bz */, SystemZ::BAsmZ, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 749 /* bzr */, SystemZ::BRAsmZ, Convert__ADDR641_0, AMFBS_None, { MCK_ADDR64 }, },
  { 753 /* c */, SystemZ::C, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 755 /* cal */, SystemZ::CAL, Convert__GR321_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR32, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 759 /* calg */, SystemZ::CALG, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 764 /* calgf */, SystemZ::CALGF, Convert__GR641_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 770 /* cd */, SystemZ::CD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 773 /* cdb */, SystemZ::CDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 777 /* cdbr */, SystemZ::CDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 782 /* cdfbr */, SystemZ::CDFBR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 788 /* cdfbra */, SystemZ::CDFBRA, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 795 /* cdfr */, SystemZ::CDFR, Convert__FP641_0__GR321_1, AMFBS_None, { MCK_FP64, MCK_GR32 }, },
  { 800 /* cdftr */, SystemZ::CDFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 806 /* cdgbr */, SystemZ::CDGBR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 812 /* cdgbra */, SystemZ::CDGBRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 819 /* cdgr */, SystemZ::CDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 824 /* cdgtr */, SystemZ::CDGTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 830 /* cdgtra */, SystemZ::CDGTRA, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 837 /* cdlfbr */, SystemZ::CDLFBR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 844 /* cdlftr */, SystemZ::CDLFTR, Convert__FP641_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 851 /* cdlgbr */, SystemZ::CDLGBR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 858 /* cdlgtr */, SystemZ::CDLGTR, Convert__FP641_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 865 /* cdpt */, SystemZ::CDPT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 870 /* cdr */, SystemZ::CDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 874 /* cds */, SystemZ::CDS, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp12 }, },
  { 878 /* cdsg */, SystemZ::CDSG, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 883 /* cdstr */, SystemZ::CDSTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 889 /* cdsy */, SystemZ::CDSY, Convert__GR1281_0__Tie0_1_1__GR1281_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr64Disp20 }, },
  { 894 /* cdtr */, SystemZ::CDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 899 /* cdutr */, SystemZ::CDUTR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 905 /* cdzt */, SystemZ::CDZT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 910 /* ce */, SystemZ::CE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 913 /* ceb */, SystemZ::CEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 917 /* cebr */, SystemZ::CEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 922 /* cedtr */, SystemZ::CEDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 928 /* cefbr */, SystemZ::CEFBR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 934 /* cefbra */, SystemZ::CEFBRA, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 941 /* cefr */, SystemZ::CEFR, Convert__FP321_0__GR321_1, AMFBS_None, { MCK_FP32, MCK_GR32 }, },
  { 946 /* cegbr */, SystemZ::CEGBR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 952 /* cegbra */, SystemZ::CEGBRA, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 959 /* cegr */, SystemZ::CEGR, Convert__FP321_0__GR641_1, AMFBS_None, { MCK_FP32, MCK_GR64 }, },
  { 964 /* celfbr */, SystemZ::CELFBR, Convert__FP321_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 971 /* celgbr */, SystemZ::CELGBR, Convert__FP321_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 978 /* cer */, SystemZ::CER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 982 /* cextr */, SystemZ::CEXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 988 /* cfc */, SystemZ::CFC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 992 /* cfdbr */, SystemZ::CFDBR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 998 /* cfdbra */, SystemZ::CFDBRA, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1005 /* cfdr */, SystemZ::CFDR, Convert__GR321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP64 }, },
  { 1010 /* cfdtr */, SystemZ::CFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1016 /* cfebr */, SystemZ::CFEBR, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1022 /* cfebra */, SystemZ::CFEBRA, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1029 /* cfer */, SystemZ::CFER, Convert__GR321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP32 }, },
  { 1034 /* cfi */, SystemZ::CFI, Convert__GR321_0__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 1038 /* cfxbr */, SystemZ::CFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1044 /* cfxbra */, SystemZ::CFXBRA, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1051 /* cfxr */, SystemZ::CFXR, Convert__GR321_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_FP128 }, },
  { 1056 /* cfxtr */, SystemZ::CFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1062 /* cg */, SystemZ::CG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1065 /* cgdbr */, SystemZ::CGDBR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1071 /* cgdbra */, SystemZ::CGDBRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1078 /* cgdr */, SystemZ::CGDR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1083 /* cgdtr */, SystemZ::CGDTR, Convert__GR641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP64 }, },
  { 1089 /* cgdtra */, SystemZ::CGDTRA, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 1096 /* cgebr */, SystemZ::CGEBR, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1102 /* cgebra */, SystemZ::CGEBRA, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 1109 /* cger */, SystemZ::CGER, Convert__GR641_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP32 }, },
  { 1114 /* cgf */, SystemZ::CGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1118 /* cgfi */, SystemZ::CGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 1123 /* cgfr */, SystemZ::CGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 1128 /* cgfrl */, SystemZ::CGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1134 /* cgh */, SystemZ::CGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 1138 /* cghi */, SystemZ::CGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1143 /* cghrl */, SystemZ::CGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1149 /* cghsi */, SystemZ::CGHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1155 /* cgib */, SystemZ::CGIBAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1160 /* cgibe */, SystemZ::CGIBAsmE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1166 /* cgibh */, SystemZ::CGIBAsmH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1179 /* cgibl */, SystemZ::CGIBAsmL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1199 /* cgibne */, SystemZ::CGIBAsmNE, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1206 /* cgibnh */, SystemZ::CGIBAsmNH, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1221 /* cgibnl */, SystemZ::CGIBAsmNL, Convert__GR641_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1244 /* cgij */, SystemZ::CGIJAsm, Convert__GR641_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1249 /* cgije */, SystemZ::CGIJAsmE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1255 /* cgijh */, SystemZ::CGIJAsmH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1268 /* cgijl */, SystemZ::CGIJAsmL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1288 /* cgijne */, SystemZ::CGIJAsmNE, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1295 /* cgijnh */, SystemZ::CGIJAsmNH, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1310 /* cgijnl */, SystemZ::CGIJAsmNL, Convert__GR641_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_S8Imm, MCK_PCRel16 }, },
  { 1333 /* cgit */, SystemZ::CGITAsm, Convert__GR641_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 1338 /* cgite */, SystemZ::CGITAsmE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1344 /* cgith */, SystemZ::CGITAsmH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1357 /* cgitl */, SystemZ::CGITAsmL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1377 /* cgitne */, SystemZ::CGITAsmNE, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1384 /* cgitnh */, SystemZ::CGITAsmNH, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1399 /* cgitnl */, SystemZ::CGITAsmNL, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 1422 /* cgr */, SystemZ::CGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1426 /* cgrb */, SystemZ::CGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1431 /* cgrbe */, SystemZ::CGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1437 /* cgrbh */, SystemZ::CGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1450 /* cgrbl */, SystemZ::CGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1470 /* cgrbne */, SystemZ::CGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1477 /* cgrbnh */, SystemZ::CGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1492 /* cgrbnl */, SystemZ::CGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 1515 /* cgrj */, SystemZ::CGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 1520 /* cgrje */, SystemZ::CGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1526 /* cgrjh */, SystemZ::CGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1539 /* cgrjl */, SystemZ::CGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1559 /* cgrjne */, SystemZ::CGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1566 /* cgrjnh */, SystemZ::CGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1581 /* cgrjnl */, SystemZ::CGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 1604 /* cgrl */, SystemZ::CGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 1609 /* cgrt */, SystemZ::CGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 1614 /* cgrte */, SystemZ::CGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1620 /* cgrth */, SystemZ::CGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1633 /* cgrtl */, SystemZ::CGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1653 /* cgrtne */, SystemZ::CGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1660 /* cgrtnh */, SystemZ::CGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1675 /* cgrtnl */, SystemZ::CGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 1698 /* cgxbr */, SystemZ::CGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1704 /* cgxbra */, SystemZ::CGXBRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1711 /* cgxr */, SystemZ::CGXR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1716 /* cgxtr */, SystemZ::CGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_GR64, MCK_U4Imm, MCK_FP128 }, },
  { 1722 /* cgxtra */, SystemZ::CGXTRA, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 1729 /* ch */, SystemZ::CH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 1732 /* chf */, SystemZ::CHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 1736 /* chhr */, SystemZ::CHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 1741 /* chhsi */, SystemZ::CHHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1747 /* chi */, SystemZ::CHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1751 /* chlr */, SystemZ::CHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 1756 /* chrl */, SystemZ::CHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 1761 /* chsi */, SystemZ::CHSI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 1766 /* chy */, SystemZ::CHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 1770 /* cib */, SystemZ::CIBAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 1774 /* cibe */, SystemZ::CIBAsmE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1779 /* cibh */, SystemZ::CIBAsmH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1790 /* cibl */, SystemZ::CIBAsmL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1807 /* cibne */, SystemZ::CIBAsmNE, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1813 /* cibnh */, SystemZ::CIBAsmNH, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1826 /* cibnl */, SystemZ::CIBAsmNL, Convert__GR321_0__S8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_BDAddr64Disp12 }, },
  { 1846 /* cih */, SystemZ::CIH, Convert__GRH321_0__S32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_S32Imm }, },
  { 1850 /* cij */, SystemZ::CIJAsm, Convert__GR321_0__S8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 1854 /* cije */, SystemZ::CIJAsmE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1859 /* cijh */, SystemZ::CIJAsmH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1870 /* cijl */, SystemZ::CIJAsmL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1887 /* cijne */, SystemZ::CIJAsmNE, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1893 /* cijnh */, SystemZ::CIJAsmNH, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1906 /* cijnl */, SystemZ::CIJAsmNL, Convert__GR321_0__S8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_S8Imm, MCK_PCRel16 }, },
  { 1926 /* cit */, SystemZ::CITAsm, Convert__GR321_0__S16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 1930 /* cite */, SystemZ::CITAsmE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1935 /* cith */, SystemZ::CITAsmH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1946 /* citl */, SystemZ::CITAsmL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1963 /* citne */, SystemZ::CITAsmNE, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1969 /* citnh */, SystemZ::CITAsmNH, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 1982 /* citnl */, SystemZ::CITAsmNL, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 2002 /* cksm */, SystemZ::CKSM, Convert__GR321_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR32, MCK_GR128 }, },
  { 2007 /* cl */, SystemZ::CL, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 2010 /* clc */, SystemZ::CLC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 2014 /* clcl */, SystemZ::CLCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 2019 /* clcle */, SystemZ::CLCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 2025 /* clclu */, SystemZ::CLCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 2031 /* clfdbr */, SystemZ::CLFDBR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2038 /* clfdtr */, SystemZ::CLFDTR, Convert__GR321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2045 /* clfebr */, SystemZ::CLFEBR, Convert__GR321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2052 /* clfhsi */, SystemZ::CLFHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2059 /* clfi */, SystemZ::CLFI, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 2064 /* clfit */, SystemZ::CLFITAsm, Convert__GR321_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_U16Imm, MCK_U4Imm }, },
  { 2070 /* clfite */, SystemZ::CLFITAsmE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2077 /* clfith */, SystemZ::CLFITAsmH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2092 /* clfitl */, SystemZ::CLFITAsmL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2115 /* clfitne */, SystemZ::CLFITAsmNE, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2123 /* clfitnh */, SystemZ::CLFITAsmNH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2140 /* clfitnl */, SystemZ::CLFITAsmNL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 2166 /* clfxbr */, SystemZ::CLFXBR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2173 /* clfxtr */, SystemZ::CLFXTR, Convert__GR321_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR32, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2180 /* clg */, SystemZ::CLG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2184 /* clgdbr */, SystemZ::CLGDBR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2191 /* clgdtr */, SystemZ::CLGDTR, Convert__GR641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 2198 /* clgebr */, SystemZ::CLGEBR, Convert__GR641_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 2205 /* clgf */, SystemZ::CLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 2210 /* clgfi */, SystemZ::CLGFI, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 2216 /* clgfr */, SystemZ::CLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 2222 /* clgfrl */, SystemZ::CLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2229 /* clghrl */, SystemZ::CLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2236 /* clghsi */, SystemZ::CLGHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2243 /* clgib */, SystemZ::CLGIBAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2249 /* clgibe */, SystemZ::CLGIBAsmE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2256 /* clgibh */, SystemZ::CLGIBAsmH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2271 /* clgibl */, SystemZ::CLGIBAsmL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2294 /* clgibne */, SystemZ::CLGIBAsmNE, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2302 /* clgibnh */, SystemZ::CLGIBAsmNH, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2319 /* clgibnl */, SystemZ::CLGIBAsmNL, Convert__GR641_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 2345 /* clgij */, SystemZ::CLGIJAsm, Convert__GR641_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 2351 /* clgije */, SystemZ::CLGIJAsmE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2358 /* clgijh */, SystemZ::CLGIJAsmH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2373 /* clgijl */, SystemZ::CLGIJAsmL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2396 /* clgijne */, SystemZ::CLGIJAsmNE, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2404 /* clgijnh */, SystemZ::CLGIJAsmNH, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2421 /* clgijnl */, SystemZ::CLGIJAsmNL, Convert__GR641_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_U8Imm, MCK_PCRel16 }, },
  { 2447 /* clgit */, SystemZ::CLGITAsm, Convert__GR641_0__U16Imm1_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_U16Imm, MCK_U4Imm }, },
  { 2453 /* clgite */, SystemZ::CLGITAsmE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2460 /* clgith */, SystemZ::CLGITAsmH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2475 /* clgitl */, SystemZ::CLGITAsmL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2498 /* clgitne */, SystemZ::CLGITAsmNE, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2506 /* clgitnh */, SystemZ::CLGITAsmNH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2523 /* clgitnl */, SystemZ::CLGITAsmNL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 2549 /* clgr */, SystemZ::CLGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2554 /* clgrb */, SystemZ::CLGRBAsm, Convert__GR641_0__GR641_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 2560 /* clgrbe */, SystemZ::CLGRBAsmE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2567 /* clgrbh */, SystemZ::CLGRBAsmH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2582 /* clgrbl */, SystemZ::CLGRBAsmL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2605 /* clgrbne */, SystemZ::CLGRBAsmNE, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2613 /* clgrbnh */, SystemZ::CLGRBAsmNH, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2630 /* clgrbnl */, SystemZ::CLGRBAsmNL, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 2656 /* clgrj */, SystemZ::CLGRJAsm, Convert__GR641_0__GR641_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm, MCK_PCRel16 }, },
  { 2662 /* clgrje */, SystemZ::CLGRJAsmE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2669 /* clgrjh */, SystemZ::CLGRJAsmH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2684 /* clgrjl */, SystemZ::CLGRJAsmL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2707 /* clgrjne */, SystemZ::CLGRJAsmNE, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2715 /* clgrjnh */, SystemZ::CLGRJAsmNH, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2732 /* clgrjnl */, SystemZ::CLGRJAsmNL, Convert__GR641_0__GR641_1__PCRel161_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_PCRel16 }, },
  { 2758 /* clgrl */, SystemZ::CLGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 2764 /* clgrt */, SystemZ::CLGRTAsm, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 2770 /* clgrte */, SystemZ::CLGRTAsmE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2777 /* clgrth */, SystemZ::CLGRTAsmH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2792 /* clgrtl */, SystemZ::CLGRTAsmL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2815 /* clgrtne */, SystemZ::CLGRTAsmNE, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2823 /* clgrtnh */, SystemZ::CLGRTAsmNH, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2840 /* clgrtnl */, SystemZ::CLGRTAsmNL, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 2866 /* clgt */, SystemZ::CLGTAsm, Convert__GR641_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 2871 /* clgte */, SystemZ::CLGTAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2877 /* clgth */, SystemZ::CLGTAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2890 /* clgtl */, SystemZ::CLGTAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2910 /* clgtne */, SystemZ::CLGTAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2917 /* clgtnh */, SystemZ::CLGTAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2932 /* clgtnl */, SystemZ::CLGTAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 2955 /* clgxbr */, SystemZ::CLGXBR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2962 /* clgxtr */, SystemZ::CLGXTR, Convert__GR641_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_GR64, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 2969 /* clhf */, SystemZ::CLHF, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 2974 /* clhhr */, SystemZ::CLHHR, Convert__GRH321_0__GRH321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32 }, },
  { 2980 /* clhhsi */, SystemZ::CLHHSI, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 2987 /* clhlr */, SystemZ::CLHLR, Convert__GRH321_0__GR321_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR32 }, },
  { 2993 /* clhrl */, SystemZ::CLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 2999 /* cli */, SystemZ::CLI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 3003 /* clib */, SystemZ::CLIBAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3008 /* clibe */, SystemZ::CLIBAsmE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3014 /* clibh */, SystemZ::CLIBAsmH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3027 /* clibl */, SystemZ::CLIBAsmL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3047 /* clibne */, SystemZ::CLIBAsmNE, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3054 /* clibnh */, SystemZ::CLIBAsmNH, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3069 /* clibnl */, SystemZ::CLIBAsmNL, Convert__GR321_0__U8Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_BDAddr64Disp12 }, },
  { 3092 /* clih */, SystemZ::CLIH, Convert__GRH321_0__U32Imm1_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_U32Imm }, },
  { 3097 /* clij */, SystemZ::CLIJAsm, Convert__GR321_0__U8Imm1_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_U4Imm, MCK_PCRel16 }, },
  { 3102 /* clije */, SystemZ::CLIJAsmE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3108 /* clijh */, SystemZ::CLIJAsmH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3121 /* clijl */, SystemZ::CLIJAsmL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3141 /* clijne */, SystemZ::CLIJAsmNE, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3148 /* clijnh */, SystemZ::CLIJAsmNH, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3163 /* clijnl */, SystemZ::CLIJAsmNL, Convert__GR321_0__U8Imm1_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_U8Imm, MCK_PCRel16 }, },
  { 3186 /* cliy */, SystemZ::CLIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 3191 /* clm */, SystemZ::CLM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3195 /* clmh */, SystemZ::CLMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3200 /* clmy */, SystemZ::CLMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3205 /* clr */, SystemZ::CLR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3209 /* clrb */, SystemZ::CLRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3214 /* clrbe */, SystemZ::CLRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3220 /* clrbh */, SystemZ::CLRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3233 /* clrbl */, SystemZ::CLRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3253 /* clrbne */, SystemZ::CLRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3260 /* clrbnh */, SystemZ::CLRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3275 /* clrbnl */, SystemZ::CLRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3298 /* clrj */, SystemZ::CLRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3303 /* clrje */, SystemZ::CLRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3309 /* clrjh */, SystemZ::CLRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3322 /* clrjl */, SystemZ::CLRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3342 /* clrjne */, SystemZ::CLRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3349 /* clrjnh */, SystemZ::CLRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3364 /* clrjnl */, SystemZ::CLRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3387 /* clrl */, SystemZ::CLRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3392 /* clrt */, SystemZ::CLRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3397 /* clrte */, SystemZ::CLRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3403 /* clrth */, SystemZ::CLRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3416 /* clrtl */, SystemZ::CLRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3436 /* clrtne */, SystemZ::CLRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3443 /* clrtnh */, SystemZ::CLRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3458 /* clrtnl */, SystemZ::CLRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3481 /* clst */, SystemZ::CLST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 3486 /* clt */, SystemZ::CLTAsm, Convert__GR321_0__BDAddr64Disp202_2__U4Imm1_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 3490 /* clte */, SystemZ::CLTAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3495 /* clth */, SystemZ::CLTAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3506 /* cltl */, SystemZ::CLTAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3523 /* cltne */, SystemZ::CLTAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3529 /* cltnh */, SystemZ::CLTAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3542 /* cltnl */, SystemZ::CLTAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3562 /* cly */, SystemZ::CLY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3566 /* clzg */, SystemZ::CLZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3571 /* cmpsc */, SystemZ::CMPSC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3577 /* cp */, SystemZ::CP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 3580 /* cpdt */, SystemZ::CPDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3585 /* cpsdr */, SystemZ::CPSDRdd, Convert__FP641_0__FP641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 3591 /* cpxt */, SystemZ::CPXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 3596 /* cpya */, SystemZ::CPYA, Convert__AR321_0__AR321_1, AMFBS_None, { MCK_AR32, MCK_AR32 }, },
  { 3601 /* cr */, SystemZ::CR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3604 /* crb */, SystemZ::CRBAsm, Convert__GR321_0__GR321_1__U4Imm1_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 3608 /* crbe */, SystemZ::CRBAsmE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3613 /* crbh */, SystemZ::CRBAsmH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3624 /* crbl */, SystemZ::CRBAsmL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3641 /* crbne */, SystemZ::CRBAsmNE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3647 /* crbnh */, SystemZ::CRBAsmNH, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3660 /* crbnl */, SystemZ::CRBAsmNL, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3680 /* crdte */, SystemZ::CRDTEOpt, Convert__GR1281_0__GR1281_2__GR641_1, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128 }, },
  { 3680 /* crdte */, SystemZ::CRDTE, Convert__GR1281_0__GR1281_2__GR641_1__U4Imm1_3, AMFBS_FeatureEnhancedDAT2, { MCK_GR128, MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 3686 /* crj */, SystemZ::CRJAsm, Convert__GR321_0__GR321_1__U4Imm1_2__PCRel161_3, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm, MCK_PCRel16 }, },
  { 3690 /* crje */, SystemZ::CRJAsmE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3695 /* crjh */, SystemZ::CRJAsmH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3706 /* crjl */, SystemZ::CRJAsmL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3723 /* crjne */, SystemZ::CRJAsmNE, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3729 /* crjnh */, SystemZ::CRJAsmNH, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3742 /* crjnl */, SystemZ::CRJAsmNL, Convert__GR321_0__GR321_1__PCRel161_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_PCRel16 }, },
  { 3762 /* crl */, SystemZ::CRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 3766 /* crt */, SystemZ::CRTAsm, Convert__GR321_0__GR321_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 3770 /* crte */, SystemZ::CRTAsmE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3775 /* crth */, SystemZ::CRTAsmH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3786 /* crtl */, SystemZ::CRTAsmL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3803 /* crtne */, SystemZ::CRTAsmNE, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3809 /* crtnh */, SystemZ::CRTAsmNH, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3822 /* crtnl */, SystemZ::CRTAsmNL, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 3842 /* cs */, SystemZ::CS, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 3845 /* csch */, SystemZ::CSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 3850 /* csdtr */, SystemZ::CSDTR, Convert__GR641_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_GR64, MCK_FP64, MCK_U4Imm }, },
  { 3856 /* csg */, SystemZ::CSG, Convert__GR641_0__Tie0_1_1__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 3860 /* csp */, SystemZ::CSP, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3864 /* cspg */, SystemZ::CSPG, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 3869 /* csst */, SystemZ::CSST, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 3874 /* csxtr */, SystemZ::CSXTR, Convert__GR1281_0__FP1281_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_FP128, MCK_U4Imm }, },
  { 3880 /* csy */, SystemZ::CSY, Convert__GR321_0__Tie0_1_1__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 3884 /* ctzg */, SystemZ::CTZG, Convert__GR641_0__GR641_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_GR64 }, },
  { 3889 /* cu12 */, SystemZ::CU12Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3889 /* cu12 */, SystemZ::CU12, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3894 /* cu14 */, SystemZ::CU14Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3894 /* cu14 */, SystemZ::CU14, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3899 /* cu21 */, SystemZ::CU21Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3899 /* cu21 */, SystemZ::CU21, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3904 /* cu24 */, SystemZ::CU24Opt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3904 /* cu24 */, SystemZ::CU24, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3909 /* cu41 */, SystemZ::CU41, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3914 /* cu42 */, SystemZ::CU42, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3919 /* cudtr */, SystemZ::CUDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 3925 /* cuse */, SystemZ::CUSE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3930 /* cutfu */, SystemZ::CUTFUOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3930 /* cutfu */, SystemZ::CUTFU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3936 /* cuutf */, SystemZ::CUUTFOpt, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 3936 /* cuutf */, SystemZ::CUUTF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_U4Imm }, },
  { 3942 /* cuxtr */, SystemZ::CUXTR, Convert__GR1281_0__FP1281_1, AMFBS_None, { MCK_GR128, MCK_FP128 }, },
  { 3948 /* cvb */, SystemZ::CVB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3952 /* cvbg */, SystemZ::CVBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3957 /* cvby */, SystemZ::CVBY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3962 /* cvd */, SystemZ::CVD, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 3966 /* cvdg */, SystemZ::CVDG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 3971 /* cvdy */, SystemZ::CVDY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 3976 /* cxbr */, SystemZ::CXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 3981 /* cxfbr */, SystemZ::CXFBR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3987 /* cxfbra */, SystemZ::CXFBRA, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 3994 /* cxfr */, SystemZ::CXFR, Convert__FP1281_0__GR321_1, AMFBS_None, { MCK_FP128, MCK_GR32 }, },
  { 3999 /* cxftr */, SystemZ::CXFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4005 /* cxgbr */, SystemZ::CXGBR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4011 /* cxgbra */, SystemZ::CXGBRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4018 /* cxgr */, SystemZ::CXGR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4023 /* cxgtr */, SystemZ::CXGTR, Convert__FP1281_0__GR641_1, AMFBS_None, { MCK_FP128, MCK_GR64 }, },
  { 4029 /* cxgtra */, SystemZ::CXGTRA, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4036 /* cxlfbr */, SystemZ::CXLFBR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4043 /* cxlftr */, SystemZ::CXLFTR, Convert__FP1281_0__U4Imm1_1__GR321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR32, MCK_U4Imm }, },
  { 4050 /* cxlgbr */, SystemZ::CXLGBR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4057 /* cxlgtr */, SystemZ::CXLGTR, Convert__FP1281_0__U4Imm1_1__GR641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_GR64, MCK_U4Imm }, },
  { 4064 /* cxpt */, SystemZ::CXPT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPPackedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4069 /* cxr */, SystemZ::CXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4073 /* cxstr */, SystemZ::CXSTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4079 /* cxtr */, SystemZ::CXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4084 /* cxutr */, SystemZ::CXUTR, Convert__FP1281_0__GR1281_1, AMFBS_None, { MCK_FP128, MCK_GR128 }, },
  { 4090 /* cxzt */, SystemZ::CXZT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4095 /* cy */, SystemZ::CY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4098 /* czdt */, SystemZ::CZDT, Convert__FP641_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP64, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4103 /* czxt */, SystemZ::CZXT, Convert__FP1281_0__BDLAddr64Disp12Len83_1__U4Imm1_2, AMFBS_FeatureDFPZonedConversion, { MCK_FP128, MCK_BDLAddr64Disp12Len8, MCK_U4Imm }, },
  { 4108 /* d */, SystemZ::D, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 4110 /* dd */, SystemZ::DD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4113 /* ddb */, SystemZ::DDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4117 /* ddbr */, SystemZ::DDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4122 /* ddr */, SystemZ::DDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4126 /* ddtr */, SystemZ::DDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 4131 /* ddtra */, SystemZ::DDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4137 /* de */, SystemZ::DE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4140 /* deb */, SystemZ::DEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4144 /* debr */, SystemZ::DEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4149 /* der */, SystemZ::DER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4153 /* dfltcc */, SystemZ::DFLTCC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__GR641_2, AMFBS_FeatureDeflateConversion, { MCK_GR128, MCK_GR128, MCK_GR64 }, },
  { 4160 /* diag */, SystemZ::DIAG, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 4165 /* didbr */, SystemZ::DIDBR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 4171 /* diebr */, SystemZ::DIEBR, Convert__FP321_0__FP321_1__Tie0_1_1__FP321_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32, MCK_U4Imm }, },
  { 4177 /* dl */, SystemZ::DL, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4180 /* dlg */, SystemZ::DLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4184 /* dlgr */, SystemZ::DLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4189 /* dlr */, SystemZ::DLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4193 /* dp */, SystemZ::DP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 4196 /* dr */, SystemZ::DR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4199 /* dsg */, SystemZ::DSG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4203 /* dsgf */, SystemZ::DSGF, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 4208 /* dsgfr */, SystemZ::DSGFR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4214 /* dsgr */, SystemZ::DSGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4219 /* dxbr */, SystemZ::DXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4224 /* dxr */, SystemZ::DXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4228 /* dxtr */, SystemZ::DXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 4233 /* dxtra */, SystemZ::DXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 4239 /* ear */, SystemZ::EAR, Convert__GR321_0__AR321_1, AMFBS_None, { MCK_GR32, MCK_AR32 }, },
  { 4243 /* ecag */, SystemZ::ECAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 4248 /* ecctr */, SystemZ::ECCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4254 /* ecpga */, SystemZ::ECPGA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4260 /* ectg */, SystemZ::ECTG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 4265 /* ed */, SystemZ::ED, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4268 /* edmk */, SystemZ::EDMK, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 4273 /* eedtr */, SystemZ::EEDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4279 /* eextr */, SystemZ::EEXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4285 /* efpc */, SystemZ::EFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4290 /* epair */, SystemZ::EPAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4296 /* epar */, SystemZ::EPAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4301 /* epctr */, SystemZ::EPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4307 /* epsw */, SystemZ::EPSW, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4312 /* ereg */, SystemZ::EREG, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4317 /* eregg */, SystemZ::EREGG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 4323 /* esair */, SystemZ::ESAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 4329 /* esar */, SystemZ::ESAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4334 /* esdtr */, SystemZ::ESDTR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 4340 /* esea */, SystemZ::ESEA, Convert__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32 }, },
  { 4345 /* esta */, SystemZ::ESTA, Convert__GR1281_0__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 4350 /* esxtr */, SystemZ::ESXTR, Convert__GR641_0__FP1281_1, AMFBS_None, { MCK_GR64, MCK_FP128 }, },
  { 4356 /* etnd */, SystemZ::ETND, Convert__GR321_0, AMFBS_FeatureTransactionalExecution, { MCK_GR32 }, },
  { 4361 /* ex */, SystemZ::EX, Convert__ADDR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_ADDR64, MCK_BDXAddr64Disp12 }, },
  { 4364 /* exrl */, SystemZ::EXRL, Convert__ADDR641_0__PCRel321_1, AMFBS_None, { MCK_ADDR64, MCK_PCRel32 }, },
  { 4369 /* fidbr */, SystemZ::FIDBR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 4375 /* fidbra */, SystemZ::FIDBRA, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4382 /* fidr */, SystemZ::FIDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4387 /* fidtr */, SystemZ::FIDTR, Convert__FP641_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 4393 /* fiebr */, SystemZ::FIEBR, Convert__FP321_0__U4Imm1_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP32 }, },
  { 4399 /* fiebra */, SystemZ::FIEBRA, Convert__FP321_0__U4Imm1_1__FP321_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP32, MCK_U4Imm }, },
  { 4406 /* fier */, SystemZ::FIER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4411 /* fixbr */, SystemZ::FIXBR, Convert__FP1281_0__U4Imm1_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128 }, },
  { 4417 /* fixbra */, SystemZ::FIXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4424 /* fixr */, SystemZ::FIXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4429 /* fixtr */, SystemZ::FIXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 4435 /* flogr */, SystemZ::FLOGR, Convert__GR1281_0__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 4441 /* hdr */, SystemZ::HDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4445 /* her */, SystemZ::HER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4449 /* hsch */, SystemZ::HSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 4454 /* iac */, SystemZ::IAC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4458 /* ic */, SystemZ::IC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4461 /* icm */, SystemZ::ICM, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 4465 /* icmh */, SystemZ::ICMH, Convert__GRH321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4470 /* icmy */, SystemZ::ICMY, Convert__GR321_0__Tie0_1_1__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 4475 /* icy */, SystemZ::ICY, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4479 /* idte */, SystemZ::IDTEOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4479 /* idte */, SystemZ::IDTE, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 4484 /* iedtr */, SystemZ::IEDTR, Convert__FP641_0__GR641_2__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR64 }, },
  { 4490 /* iextr */, SystemZ::IEXTR, Convert__FP1281_0__GR641_2__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR64 }, },
  { 4496 /* iihf */, SystemZ::IIHF, Convert__GRH321_0__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 4501 /* iihh */, SystemZ::IIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4506 /* iihl */, SystemZ::IIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 4511 /* iilf */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 4516 /* iilh */, SystemZ::IILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4521 /* iill */, SystemZ::IILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 4526 /* ipk */, SystemZ::IPK, Convert_NoOperands, AMFBS_None, {  }, },
  { 4530 /* ipm */, SystemZ::IPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTEOptOpt, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTEOpt, Convert__GR641_0__GR321_1__GR321_2, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32 }, },
  { 4534 /* ipte */, SystemZ::IPTE, Convert__GR641_0__GR321_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 4539 /* irbm */, SystemZ::IRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureInsertReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 4544 /* iske */, SystemZ::ISKE, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4549 /* ivsk */, SystemZ::IVSK, Convert__GR321_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 4554 /* j */, SystemZ::J, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4556 /* je */, SystemZ::JAsmE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4664 /* jh */, SystemZ::JAsmH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4671 /* jl */, SystemZ::JAsmL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4674 /* jle */, SystemZ::JGAsmE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4678 /* jlh */, SystemZ::JGAsmH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4682 /* jll */, SystemZ::JGAsmL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4686 /* jlm */, SystemZ::JGAsmM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4690 /* jlne */, SystemZ::JGAsmNE, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4695 /* jlnh */, SystemZ::JGAsmNH, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4700 /* jlnl */, SystemZ::JGAsmNL, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4705 /* jlnm */, SystemZ::JGAsmNM, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4710 /* jlno */, SystemZ::JGAsmNO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4715 /* jlnop */, SystemZ::JGNOP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4721 /* jlnp */, SystemZ::JGAsmNP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4726 /* jlnz */, SystemZ::JGAsmNZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4731 /* jlo */, SystemZ::JGAsmO, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4735 /* jlp */, SystemZ::JGAsmP, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4739 /* jlu */, SystemZ::JG, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4743 /* jlz */, SystemZ::JGAsmZ, Convert__PCRel321_0, AMFBS_None, { MCK_PCRel32 }, },
  { 4747 /* jm */, SystemZ::JAsmM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4750 /* jne */, SystemZ::JAsmNE, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4754 /* jnh */, SystemZ::JAsmNH, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4763 /* jnl */, SystemZ::JAsmNL, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4777 /* jnm */, SystemZ::JAsmNM, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4781 /* jno */, SystemZ::JAsmNO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4785 /* jnop */, SystemZ::JNOP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4790 /* jnp */, SystemZ::JAsmNP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4794 /* jnz */, SystemZ::JAsmNZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4798 /* jo */, SystemZ::JAsmO, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4801 /* jp */, SystemZ::JAsmP, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4804 /* jz */, SystemZ::JAsmZ, Convert__PCRel161_0, AMFBS_None, { MCK_PCRel16 }, },
  { 4807 /* kdb */, SystemZ::KDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 4811 /* kdbr */, SystemZ::KDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4816 /* kdsa */, SystemZ::KDSA, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_FeatureMessageSecurityAssist9, { MCK_GR64, MCK_GR128 }, },
  { 4821 /* kdtr */, SystemZ::KDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 4826 /* keb */, SystemZ::KEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 4830 /* kebr */, SystemZ::KEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 4835 /* kimd */, SystemZ::KIMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4835 /* kimd */, SystemZ::KIMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4840 /* klmd */, SystemZ::KLMD, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4840 /* klmd */, SystemZ::KLMDOpt, Convert__GR641_0__GR1281_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_FeatureMessageSecurityAssist12, { MCK_GR64, MCK_GR128, MCK_U4Imm }, },
  { 4845 /* km */, SystemZ::KM, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4848 /* kma */, SystemZ::KMA, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist8, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4852 /* kmac */, SystemZ::KMAC, Convert__GR1281_1__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64, MCK_GR128 }, },
  { 4857 /* kmc */, SystemZ::KMC, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 4861 /* kmctr */, SystemZ::KMCTR, Convert__GR1281_0__GR1281_2__GR1281_1__Tie0_1_1__Tie1_1_1__Tie2_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128, MCK_GR128 }, },
  { 4867 /* kmf */, SystemZ::KMF, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4871 /* kmo */, SystemZ::KMO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist4, { MCK_GR128, MCK_GR128 }, },
  { 4875 /* kxbr */, SystemZ::KXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4880 /* kxtr */, SystemZ::KXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 4885 /* l */, SystemZ::L, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 4887 /* la */, SystemZ::LA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4890 /* laa */, SystemZ::LAA, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4894 /* laag */, SystemZ::LAAG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4899 /* laal */, SystemZ::LAAL, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4904 /* laalg */, SystemZ::LAALG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4910 /* lae */, SystemZ::LAE, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 4914 /* laey */, SystemZ::LAEY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4919 /* lam */, SystemZ::LAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 4923 /* lamy */, SystemZ::LAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 4928 /* lan */, SystemZ::LAN, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4932 /* lang */, SystemZ::LANG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4937 /* lao */, SystemZ::LAO, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4941 /* laog */, SystemZ::LAOG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4946 /* larl */, SystemZ::LARL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 4951 /* lasp */, SystemZ::LASP, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 4956 /* lat */, SystemZ::LAT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4960 /* lax */, SystemZ::LAX, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 4964 /* laxg */, SystemZ::LAXG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 4969 /* lay */, SystemZ::LAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 4973 /* lb */, SystemZ::LB, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 4976 /* lbear */, SystemZ::LBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 4982 /* lbh */, SystemZ::LBH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 4986 /* lbr */, SystemZ::LBR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 4990 /* lcbb */, SystemZ::LCBB, Convert__GR321_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_GR32, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 4995 /* lcctl */, SystemZ::LCCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5001 /* lcdbr */, SystemZ::LCDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5007 /* lcdfr */, SystemZ::LCDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5013 /* lcdr */, SystemZ::LCDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5018 /* lcebr */, SystemZ::LCEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5024 /* lcer */, SystemZ::LCER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5029 /* lcgfr */, SystemZ::LCGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5035 /* lcgr */, SystemZ::LCGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5040 /* lcr */, SystemZ::LCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5044 /* lctl */, SystemZ::LCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 5049 /* lctlg */, SystemZ::LCTLG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 5055 /* lcxbr */, SystemZ::LCXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5061 /* lcxr */, SystemZ::LCXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5066 /* ld */, SystemZ::LD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5069 /* lde */, SystemZ::LDE, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5073 /* ldeb */, SystemZ::LDEB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 5078 /* ldebr */, SystemZ::LDEBR, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5084 /* lder */, SystemZ::LDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 5089 /* ldetr */, SystemZ::LDETR, Convert__FP641_0__FP321_1__U4Imm1_2, AMFBS_None, { MCK_FP64, MCK_FP32, MCK_U4Imm }, },
  { 5095 /* ldgr */, SystemZ::LDGR, Convert__FP641_0__GR641_1, AMFBS_None, { MCK_FP64, MCK_GR64 }, },
  { 5100 /* ldr */, SystemZ::LDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5104 /* ldrv */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5109 /* ldxbr */, SystemZ::LDXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5115 /* ldxbra */, SystemZ::LDXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5122 /* ldxr */, SystemZ::LDXR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 5127 /* ldxtr */, SystemZ::LDXTR, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5133 /* ldy */, SystemZ::LDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 5137 /* le */, SystemZ::LE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 5140 /* ledbr */, SystemZ::LEDBR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5146 /* ledbra */, SystemZ::LEDBRA, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5153 /* ledr */, SystemZ::LEDR, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 5158 /* ledtr */, SystemZ::LEDTR, Convert__FP321_0__U4Imm1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64, MCK_U4Imm }, },
  { 5164 /* ler */, SystemZ::LER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5168 /* lerv */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 5173 /* lexbr */, SystemZ::LEXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5179 /* lexbra */, SystemZ::LEXBRA, Convert__FP1281_0__U4Imm1_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_U4Imm, MCK_FP128, MCK_U4Imm }, },
  { 5186 /* lexr */, SystemZ::LEXR, Convert__FP321_0__FP1281_1, AMFBS_None, { MCK_FP32, MCK_FP128 }, },
  { 5191 /* ley */, SystemZ::LEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 5195 /* lfas */, SystemZ::LFAS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5200 /* lfh */, SystemZ::LFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5204 /* lfhat */, SystemZ::LFHAT, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5210 /* lfi */, SystemZ::IILF, Convert__GR321_0__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 5214 /* lfpc */, SystemZ::LFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 5219 /* lg */, SystemZ::LG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5222 /* lgat */, SystemZ::LGAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5227 /* lgb */, SystemZ::LGB, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5231 /* lgbr */, SystemZ::LGBR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5236 /* lgdr */, SystemZ::LGDR, Convert__GR641_0__FP641_1, AMFBS_None, { MCK_GR64, MCK_FP64 }, },
  { 5241 /* lgf */, SystemZ::LGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5245 /* lgfi */, SystemZ::LGFI, Convert__GR641_0__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 5250 /* lgfr */, SystemZ::LGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5255 /* lgfrl */, SystemZ::LGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5261 /* lgg */, SystemZ::LGG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5265 /* lgh */, SystemZ::LGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5269 /* lghi */, SystemZ::LGHI, Convert__GR641_0__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 5274 /* lghr */, SystemZ::LGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5279 /* lghrl */, SystemZ::LGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5285 /* lgr */, SystemZ::LGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5289 /* lgrl */, SystemZ::LGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5294 /* lgsc */, SystemZ::LGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5299 /* lh */, SystemZ::LH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 5302 /* lhh */, SystemZ::LHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5306 /* lhi */, SystemZ::LHI, Convert__GR321_0__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 5310 /* lhr */, SystemZ::LHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5314 /* lhrl */, SystemZ::LHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5319 /* lhy */, SystemZ::LHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5323 /* llc */, SystemZ::LLC, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5327 /* llch */, SystemZ::LLCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5332 /* llcr */, SystemZ::LLCR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5337 /* llgc */, SystemZ::LLGC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5342 /* llgcr */, SystemZ::LLGCR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5348 /* llgf */, SystemZ::LLGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5353 /* llgfat */, SystemZ::LLGFAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5360 /* llgfi */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5366 /* llgfr */, SystemZ::LLGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5372 /* llgfrl */, SystemZ::LLGFRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5379 /* llgfsg */, SystemZ::LLGFSG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5386 /* llgh */, SystemZ::LLGH, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5391 /* llghi */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5397 /* llghr */, SystemZ::LLGHR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5403 /* llghrl */, SystemZ::LLGHRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 5410 /* llgt */, SystemZ::LLGT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5415 /* llgtat */, SystemZ::LLGTAT, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndTrap, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5422 /* llgtr */, SystemZ::LLGTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5428 /* llh */, SystemZ::LLH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 5432 /* llhh */, SystemZ::LLHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 5437 /* llhr */, SystemZ::LLHR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5442 /* llhrl */, SystemZ::LLHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 5448 /* llihf */, SystemZ::LLIHF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5454 /* llihh */, SystemZ::LLIHH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5460 /* llihl */, SystemZ::LLIHL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5466 /* llilf */, SystemZ::LLILF, Convert__GR641_0__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 5472 /* llilh */, SystemZ::LLILH, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5478 /* llill */, SystemZ::LLILL, Convert__GR641_0__U16Imm1_1, AMFBS_None, { MCK_GR64, MCK_U16Imm }, },
  { 5484 /* llxab */, SystemZ::LLXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5490 /* llxaf */, SystemZ::LLXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5496 /* llxag */, SystemZ::LLXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5502 /* llxah */, SystemZ::LLXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5508 /* llxaq */, SystemZ::LLXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 5514 /* llzrgf */, SystemZ::LLZRGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 5521 /* lm */, SystemZ::LM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 5524 /* lmd */, SystemZ::LMD, Convert__GR641_0__GR641_1__BDAddr64Disp122_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 5528 /* lmg */, SystemZ::LMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5532 /* lmh */, SystemZ::LMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5536 /* lmy */, SystemZ::LMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5540 /* lndbr */, SystemZ::LNDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5546 /* lndfr */, SystemZ::LNDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5552 /* lndr */, SystemZ::LNDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 5557 /* lnebr */, SystemZ::LNEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5563 /* lner */, SystemZ::LNER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 5568 /* lngfr */, SystemZ::LNGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 5574 /* lngr */, SystemZ::LNGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 5579 /* lnr */, SystemZ::LNR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 5583 /* lnxbr */, SystemZ::LNXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5589 /* lnxr */, SystemZ::LNXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 5594 /* loc */, SystemZ::LOCAsm, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5598 /* loce */, SystemZ::LOCAsmE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 5603 /* locfh */, SystemZ::LOCFHAsm, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5609 /* locfhe */, SystemZ::LOCFHAsmE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5616 /* locfhh */, SystemZ::LOCFHAsmH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5631 /* locfhl */, SystemZ::LOCFHAsmL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5654 /* locfhm */, SystemZ::LOCFHAsmM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5661 /* locfhne */, SystemZ::LOCFHAsmNE, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5669 /* locfhnh */, SystemZ::LOCFHAsmNH, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5686 /* locfhnl */, SystemZ::LOCFHAsmNL, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5712 /* locfhnm */, SystemZ::LOCFHAsmNM, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5720 /* locfhno */, SystemZ::LOCFHAsmNO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5728 /* locfhnp */, SystemZ::LOCFHAsmNP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5736 /* locfhnz */, SystemZ::LOCFHAsmNZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5744 /* locfho */, SystemZ::LOCFHAsmO, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5751 /* locfhp */, SystemZ::LOCFHAsmP, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5758 /* locfhr */, SystemZ::LOCFHRAsm, Convert__GRH321_0__Tie0_1_1__GRH321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 5765 /* locfhre */, SystemZ::LOCFHRAsmE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5773 /* locfhrh */, SystemZ::LOCFHRAsmH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5790 /* locfhrl */, SystemZ::LOCFHRAsmL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5816 /* locfhrm */, SystemZ::LOCFHRAsmM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5824 /* locfhrne */, SystemZ::LOCFHRAsmNE, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5833 /* locfhrnh */, SystemZ::LOCFHRAsmNH, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5852 /* locfhrnl */, SystemZ::LOCFHRAsmNL, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5881 /* locfhrnm */, SystemZ::LOCFHRAsmNM, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5890 /* locfhrno */, SystemZ::LOCFHRAsmNO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5899 /* locfhrnp */, SystemZ::LOCFHRAsmNP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5908 /* locfhrnz */, SystemZ::LOCFHRAsmNZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5917 /* locfhro */, SystemZ::LOCFHRAsmO, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5925 /* locfhrp */, SystemZ::LOCFHRAsmP, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5933 /* locfhrz */, SystemZ::LOCFHRAsmZ, Convert__GRH321_0__Tie0_1_1__GRH321_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_GRH32 }, },
  { 5941 /* locfhz */, SystemZ::LOCFHAsmZ, Convert__GRH321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 5948 /* locg */, SystemZ::LOCGAsm, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 5953 /* locge */, SystemZ::LOCGAsmE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5959 /* locgh */, SystemZ::LOCGAsmH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 5972 /* locghi */, SystemZ::LOCGHIAsm, Convert__GR641_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm, MCK_U4Imm }, },
  { 5979 /* locghie */, SystemZ::LOCGHIAsmE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 5987 /* locghih */, SystemZ::LOCGHIAsmH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6004 /* locghil */, SystemZ::LOCGHIAsmL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6030 /* locghim */, SystemZ::LOCGHIAsmM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6038 /* locghine */, SystemZ::LOCGHIAsmNE, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6047 /* locghinh */, SystemZ::LOCGHIAsmNH, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6066 /* locghinl */, SystemZ::LOCGHIAsmNL, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6095 /* locghinm */, SystemZ::LOCGHIAsmNM, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6104 /* locghino */, SystemZ::LOCGHIAsmNO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6113 /* locghinp */, SystemZ::LOCGHIAsmNP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6122 /* locghinz */, SystemZ::LOCGHIAsmNZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6131 /* locghio */, SystemZ::LOCGHIAsmO, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6139 /* locghip */, SystemZ::LOCGHIAsmP, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6147 /* locghiz */, SystemZ::LOCGHIAsmZ, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR64, MCK_S16Imm }, },
  { 6155 /* locgl */, SystemZ::LOCGAsmL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6175 /* locgm */, SystemZ::LOCGAsmM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6181 /* locgne */, SystemZ::LOCGAsmNE, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6188 /* locgnh */, SystemZ::LOCGAsmNH, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6203 /* locgnl */, SystemZ::LOCGAsmNL, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6226 /* locgnm */, SystemZ::LOCGAsmNM, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6233 /* locgno */, SystemZ::LOCGAsmNO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6240 /* locgnp */, SystemZ::LOCGAsmNP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6247 /* locgnz */, SystemZ::LOCGAsmNZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6254 /* locgo */, SystemZ::LOCGAsmO, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6260 /* locgp */, SystemZ::LOCGAsmP, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6266 /* locgr */, SystemZ::LOCGRAsm, Convert__GR641_0__Tie0_1_1__GR641_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 6272 /* locgre */, SystemZ::LOCGRAsmE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6279 /* locgrh */, SystemZ::LOCGRAsmH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6294 /* locgrl */, SystemZ::LOCGRAsmL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6317 /* locgrm */, SystemZ::LOCGRAsmM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6324 /* locgrne */, SystemZ::LOCGRAsmNE, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6332 /* locgrnh */, SystemZ::LOCGRAsmNH, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6349 /* locgrnl */, SystemZ::LOCGRAsmNL, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6375 /* locgrnm */, SystemZ::LOCGRAsmNM, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6383 /* locgrno */, SystemZ::LOCGRAsmNO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6391 /* locgrnp */, SystemZ::LOCGRAsmNP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6399 /* locgrnz */, SystemZ::LOCGRAsmNZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6407 /* locgro */, SystemZ::LOCGRAsmO, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6414 /* locgrp */, SystemZ::LOCGRAsmP, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6421 /* locgrz */, SystemZ::LOCGRAsmZ, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_GR64 }, },
  { 6428 /* locgz */, SystemZ::LOCGAsmZ, Convert__GR641_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 6434 /* loch */, SystemZ::LOCAsmH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6445 /* lochhi */, SystemZ::LOCHHIAsm, Convert__GRH321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm, MCK_U4Imm }, },
  { 6452 /* lochhie */, SystemZ::LOCHHIAsmE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6460 /* lochhih */, SystemZ::LOCHHIAsmH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6477 /* lochhil */, SystemZ::LOCHHIAsmL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6503 /* lochhim */, SystemZ::LOCHHIAsmM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6511 /* lochhine */, SystemZ::LOCHHIAsmNE, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6520 /* lochhinh */, SystemZ::LOCHHIAsmNH, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6539 /* lochhinl */, SystemZ::LOCHHIAsmNL, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6568 /* lochhinm */, SystemZ::LOCHHIAsmNM, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6577 /* lochhino */, SystemZ::LOCHHIAsmNO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6586 /* lochhinp */, SystemZ::LOCHHIAsmNP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6595 /* lochhinz */, SystemZ::LOCHHIAsmNZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6604 /* lochhio */, SystemZ::LOCHHIAsmO, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6612 /* lochhip */, SystemZ::LOCHHIAsmP, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6620 /* lochhiz */, SystemZ::LOCHHIAsmZ, Convert__GRH321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_S16Imm }, },
  { 6628 /* lochi */, SystemZ::LOCHIAsm, Convert__GR321_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm, MCK_U4Imm }, },
  { 6634 /* lochie */, SystemZ::LOCHIAsmE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6641 /* lochih */, SystemZ::LOCHIAsmH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6656 /* lochil */, SystemZ::LOCHIAsmL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6679 /* lochim */, SystemZ::LOCHIAsmM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6686 /* lochine */, SystemZ::LOCHIAsmNE, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6694 /* lochinh */, SystemZ::LOCHIAsmNH, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6711 /* lochinl */, SystemZ::LOCHIAsmNL, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6737 /* lochinm */, SystemZ::LOCHIAsmNM, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6745 /* lochino */, SystemZ::LOCHIAsmNO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6753 /* lochinp */, SystemZ::LOCHIAsmNP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6761 /* lochinz */, SystemZ::LOCHIAsmNZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6769 /* lochio */, SystemZ::LOCHIAsmO, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6776 /* lochip */, SystemZ::LOCHIAsmP, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6783 /* lochiz */, SystemZ::LOCHIAsmZ, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GR32, MCK_S16Imm }, },
  { 6790 /* locl */, SystemZ::LOCAsmL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6807 /* locm */, SystemZ::LOCAsmM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6812 /* locne */, SystemZ::LOCAsmNE, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6818 /* locnh */, SystemZ::LOCAsmNH, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6831 /* locnl */, SystemZ::LOCAsmNL, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6851 /* locnm */, SystemZ::LOCAsmNM, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6857 /* locno */, SystemZ::LOCAsmNO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6863 /* locnp */, SystemZ::LOCAsmNP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6869 /* locnz */, SystemZ::LOCAsmNZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6875 /* loco */, SystemZ::LOCAsmO, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6880 /* locp */, SystemZ::LOCAsmP, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 6885 /* locr */, SystemZ::LOCRAsm, Convert__GR321_0__Tie0_1_1__GR321_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 6890 /* locre */, SystemZ::LOCRAsmE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6896 /* locrh */, SystemZ::LOCRAsmH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6909 /* locrl */, SystemZ::LOCRAsmL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6929 /* locrm */, SystemZ::LOCRAsmM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6935 /* locrne */, SystemZ::LOCRAsmNE, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6942 /* locrnh */, SystemZ::LOCRAsmNH, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6957 /* locrnl */, SystemZ::LOCRAsmNL, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6980 /* locrnm */, SystemZ::LOCRAsmNM, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6987 /* locrno */, SystemZ::LOCRAsmNO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 6994 /* locrnp */, SystemZ::LOCRAsmNP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7001 /* locrnz */, SystemZ::LOCRAsmNZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7008 /* locro */, SystemZ::LOCRAsmO, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7014 /* locrp */, SystemZ::LOCRAsmP, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7020 /* locrz */, SystemZ::LOCRAsmZ, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_GR32 }, },
  { 7026 /* locz */, SystemZ::LOCAsmZ, Convert__GR321_0__Tie0_1_1__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 7031 /* lpctl */, SystemZ::LPCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7037 /* lpd */, SystemZ::LPD, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7041 /* lpdbr */, SystemZ::LPDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7047 /* lpdfr */, SystemZ::LPDFR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7053 /* lpdg */, SystemZ::LPDG, Convert__GR1281_0__BDAddr64Disp122_1__BDAddr64Disp122_2, AMFBS_FeatureInterlockedAccess1, { MCK_GR128, MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7058 /* lpdr */, SystemZ::LPDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7063 /* lpebr */, SystemZ::LPEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7069 /* lper */, SystemZ::LPER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7074 /* lpgfr */, SystemZ::LPGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7080 /* lpgr */, SystemZ::LPGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7085 /* lpp */, SystemZ::LPP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7089 /* lpq */, SystemZ::LPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7093 /* lpr */, SystemZ::LPR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7097 /* lpsw */, SystemZ::LPSW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7102 /* lpswe */, SystemZ::LPSWE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7108 /* lpswey */, SystemZ::LPSWEY, Convert__BDAddr64Disp202_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp20 }, },
  { 7115 /* lptea */, SystemZ::LPTEA, Convert__GR641_0__GR641_1__Tie0_1_1__GR641_2__U4Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 7121 /* lpxbr */, SystemZ::LPXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7127 /* lpxr */, SystemZ::LPXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7132 /* lr */, SystemZ::LR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7135 /* lra */, SystemZ::LRA, Convert__GR641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp12 }, },
  { 7139 /* lrag */, SystemZ::LRAG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7144 /* lray */, SystemZ::LRAY, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7149 /* lrdr */, SystemZ::LRDR, Convert__FP641_0__FP1281_1, AMFBS_None, { MCK_FP64, MCK_FP128 }, },
  { 7154 /* lrer */, SystemZ::LRER, Convert__FP321_0__FP641_1, AMFBS_None, { MCK_FP32, MCK_FP64 }, },
  { 7159 /* lrl */, SystemZ::LRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 7163 /* lrv */, SystemZ::LRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7167 /* lrvg */, SystemZ::LRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7172 /* lrvgr */, SystemZ::LRVGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7178 /* lrvh */, SystemZ::LRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7183 /* lrvr */, SystemZ::LRVR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7188 /* lsctl */, SystemZ::LSCTL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7194 /* lt */, SystemZ::LT, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7197 /* ltdbr */, SystemZ::LTDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7203 /* ltdr */, SystemZ::LTDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7208 /* ltdtr */, SystemZ::LTDTR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7214 /* ltebr */, SystemZ::LTEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7220 /* lter */, SystemZ::LTER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7225 /* ltg */, SystemZ::LTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7229 /* ltgf */, SystemZ::LTGF, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7234 /* ltgfr */, SystemZ::LTGFR, Convert__GR641_0__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7240 /* ltgr */, SystemZ::LTGR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7245 /* ltr */, SystemZ::LTR, Convert__GR321_0__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7249 /* ltxbr */, SystemZ::LTXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7255 /* ltxr */, SystemZ::LTXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7260 /* ltxtr */, SystemZ::LTXTR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7266 /* lura */, SystemZ::LURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 7271 /* lurag */, SystemZ::LURAG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7277 /* lxab */, SystemZ::LXAB, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7282 /* lxaf */, SystemZ::LXAF, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7287 /* lxag */, SystemZ::LXAG, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7292 /* lxah */, SystemZ::LXAH, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7297 /* lxaq */, SystemZ::LXAQ, Convert__GR641_0__LXAAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions4, { MCK_GR64, MCK_LXAAddr64Disp20 }, },
  { 7302 /* lxd */, SystemZ::LXD, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7306 /* lxdb */, SystemZ::LXDB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7311 /* lxdbr */, SystemZ::LXDBR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7317 /* lxdr */, SystemZ::LXDR, Convert__FP1281_0__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7322 /* lxdtr */, SystemZ::LXDTR, Convert__FP1281_0__FP641_1__U4Imm1_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_U4Imm }, },
  { 7328 /* lxe */, SystemZ::LXE, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7332 /* lxeb */, SystemZ::LXEB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7337 /* lxebr */, SystemZ::LXEBR, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7343 /* lxer */, SystemZ::LXER, Convert__FP1281_0__FP321_1, AMFBS_None, { MCK_FP128, MCK_FP32 }, },
  { 7348 /* lxr */, SystemZ::LXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7352 /* ly */, SystemZ::LY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7355 /* lzdr */, SystemZ::LZDR, Convert__FP641_0, AMFBS_None, { MCK_FP64 }, },
  { 7360 /* lzer */, SystemZ::LZER, Convert__FP321_0, AMFBS_None, { MCK_FP32 }, },
  { 7365 /* lzrf */, SystemZ::LZRF, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7370 /* lzrg */, SystemZ::LZRG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureLoadAndZeroRightmostByte, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7375 /* lzxr */, SystemZ::LZXR, Convert__FP1281_0, AMFBS_None, { MCK_FP128 }, },
  { 7380 /* m */, SystemZ::M, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp12 }, },
  { 7382 /* mad */, SystemZ::MAD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7386 /* madb */, SystemZ::MADB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7391 /* madbr */, SystemZ::MADBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7397 /* madr */, SystemZ::MADR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7402 /* mae */, SystemZ::MAE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7406 /* maeb */, SystemZ::MAEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7411 /* maebr */, SystemZ::MAEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7417 /* maer */, SystemZ::MAER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7422 /* may */, SystemZ::MAY, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7426 /* mayh */, SystemZ::MAYH, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7431 /* mayhr */, SystemZ::MAYHR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7437 /* mayl */, SystemZ::MAYL, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7442 /* maylr */, SystemZ::MAYLR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7448 /* mayr */, SystemZ::MAYR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7453 /* mc */, SystemZ::MC, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7456 /* md */, SystemZ::MD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7459 /* mdb */, SystemZ::MDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7463 /* mdbr */, SystemZ::MDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7468 /* mde */, SystemZ::MDE, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7472 /* mdeb */, SystemZ::MDEB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7477 /* mdebr */, SystemZ::MDEBR, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7483 /* mder */, SystemZ::MDER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7488 /* mdr */, SystemZ::MDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 7492 /* mdtr */, SystemZ::MDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7497 /* mdtra */, SystemZ::MDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 7503 /* me */, SystemZ::ME, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7506 /* mee */, SystemZ::MEE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7510 /* meeb */, SystemZ::MEEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7515 /* meebr */, SystemZ::MEEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7521 /* meer */, SystemZ::MEER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 7526 /* mer */, SystemZ::MER, Convert__FP641_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 7530 /* mfy */, SystemZ::MFY, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7534 /* mg */, SystemZ::MG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7537 /* mgh */, SystemZ::MGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7541 /* mghi */, SystemZ::MGHI, Convert__GR641_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR64, MCK_S16Imm }, },
  { 7546 /* mgrk */, SystemZ::MGRK, Convert__GR1281_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR128, MCK_GR64, MCK_GR64 }, },
  { 7551 /* mh */, SystemZ::MH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7554 /* mhi */, SystemZ::MHI, Convert__GR321_0__Tie0_1_1__S16Imm1_1, AMFBS_None, { MCK_GR32, MCK_S16Imm }, },
  { 7558 /* mhy */, SystemZ::MHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7562 /* ml */, SystemZ::ML, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7565 /* mlg */, SystemZ::MLG, Convert__GR1281_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 7569 /* mlgr */, SystemZ::MLGR, Convert__GR1281_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 7574 /* mlr */, SystemZ::MLR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7578 /* mp */, SystemZ::MP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7581 /* mr */, SystemZ::MR, Convert__GR1281_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR128, MCK_GR32 }, },
  { 7584 /* ms */, SystemZ::MS, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7587 /* msc */, SystemZ::MSC, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7591 /* msch */, SystemZ::MSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 7596 /* msd */, SystemZ::MSD, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7600 /* msdb */, SystemZ::MSDB, Convert__FP641_0__Tie0_1_1__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7605 /* msdbr */, SystemZ::MSDBR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7611 /* msdr */, SystemZ::MSDR, Convert__FP641_0__Tie0_1_1__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7616 /* mse */, SystemZ::MSE, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7620 /* mseb */, SystemZ::MSEB, Convert__FP321_0__Tie0_1_1__FP321_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 7625 /* msebr */, SystemZ::MSEBR, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7631 /* mser */, SystemZ::MSER, Convert__FP321_0__Tie0_1_1__FP321_1__FP321_2, AMFBS_None, { MCK_FP32, MCK_FP32, MCK_FP32 }, },
  { 7636 /* msfi */, SystemZ::MSFI, Convert__GR321_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR32, MCK_S32Imm }, },
  { 7641 /* msg */, SystemZ::MSG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7645 /* msgc */, SystemZ::MSGC, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7650 /* msgf */, SystemZ::MSGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7655 /* msgfi */, SystemZ::MSGFI, Convert__GR641_0__Tie0_1_1__S32Imm1_1, AMFBS_None, { MCK_GR64, MCK_S32Imm }, },
  { 7661 /* msgfr */, SystemZ::MSGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 7667 /* msgr */, SystemZ::MSGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7672 /* msgrkc */, SystemZ::MSGRKC, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7679 /* msr */, SystemZ::MSR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7683 /* msrkc */, SystemZ::MSRKC, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7689 /* msta */, SystemZ::MSTA, Convert__GR1281_0, AMFBS_None, { MCK_GR128 }, },
  { 7694 /* msy */, SystemZ::MSY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 7698 /* mvc */, SystemZ::MVC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7702 /* mvcdk */, SystemZ::MVCDK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7708 /* mvcin */, SystemZ::MVCIN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7714 /* mvck */, SystemZ::MVCK, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7719 /* mvcl */, SystemZ::MVCL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR128 }, },
  { 7724 /* mvcle */, SystemZ::MVCLE, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp122_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 7730 /* mvclu */, SystemZ::MVCLU, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR128, MCK_GR128, MCK_BDAddr32Disp20 }, },
  { 7736 /* mvcos */, SystemZ::MVCOS, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7742 /* mvcp */, SystemZ::MVCP, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7747 /* mvcrl */, SystemZ::MVCRL, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7753 /* mvcs */, SystemZ::MVCS, Convert__BDRAddr64Disp123_0__BDAddr64Disp122_1__GR641_2, AMFBS_None, { MCK_BDRAddr64Disp12, MCK_BDAddr64Disp12, MCK_GR64 }, },
  { 7758 /* mvcsk */, SystemZ::MVCSK, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 7764 /* mvghi */, SystemZ::MVGHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7770 /* mvhhi */, SystemZ::MVHHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7776 /* mvhi */, SystemZ::MVHI, Convert__BDAddr64Disp122_0__S16Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_S16Imm }, },
  { 7781 /* mvi */, SystemZ::MVI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7785 /* mviy */, SystemZ::MVIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7790 /* mvn */, SystemZ::MVN, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7794 /* mvo */, SystemZ::MVO, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 7798 /* mvpg */, SystemZ::MVPG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7803 /* mvst */, SystemZ::MVST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7808 /* mvz */, SystemZ::MVZ, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7812 /* mxbr */, SystemZ::MXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7817 /* mxd */, SystemZ::MXD, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7821 /* mxdb */, SystemZ::MXDB, Convert__FP1281_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 7826 /* mxdbr */, SystemZ::MXDBR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7832 /* mxdr */, SystemZ::MXDR, Convert__FP1281_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP128, MCK_FP64 }, },
  { 7837 /* mxr */, SystemZ::MXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 7841 /* mxtr */, SystemZ::MXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 7846 /* mxtra */, SystemZ::MXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 7852 /* my */, SystemZ::MY, Convert__FP1281_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7855 /* myh */, SystemZ::MYH, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7859 /* myhr */, SystemZ::MYHR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7864 /* myl */, SystemZ::MYL, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 7868 /* mylr */, SystemZ::MYLR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 7873 /* myr */, SystemZ::MYR, Convert__FP1281_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP128, MCK_FP64, MCK_FP64 }, },
  { 7877 /* n */, SystemZ::N, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 7879 /* nc */, SystemZ::NC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 7882 /* ncgrk */, SystemZ::NCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7888 /* ncrk */, SystemZ::NCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7893 /* ng */, SystemZ::NG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 7896 /* ngr */, SystemZ::NGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 7900 /* ngrk */, SystemZ::NGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7905 /* ni */, SystemZ::NI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 7908 /* niai */, SystemZ::NIAI, Convert__U4Imm1_0__U4Imm1_1, AMFBS_FeatureExecutionHint, { MCK_U4Imm, MCK_U4Imm }, },
  { 7913 /* nihf */, SystemZ::NIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 7918 /* nihh */, SystemZ::NIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7923 /* nihl */, SystemZ::NIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 7928 /* nilf */, SystemZ::NILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 7933 /* nilh */, SystemZ::NILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7938 /* nill */, SystemZ::NILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 7943 /* niy */, SystemZ::NIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 7947 /* nngrk */, SystemZ::NNGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7953 /* nnpa */, SystemZ::NNPA, Convert_NoOperands, AMFBS_FeatureNNPAssist, {  }, },
  { 7958 /* nnrk */, SystemZ::NNRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7963 /* nogrk */, SystemZ::NOGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 7969 /* nop */, SystemZ::NOPOpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7969 /* nop */, SystemZ::NOP, Convert__BDXAddr64Disp123_0, AMFBS_None, { MCK_BDXAddr64Disp12 }, },
  { 7973 /* nopr */, SystemZ::NOPROpt, Convert_NoOperands, AMFBS_None, {  }, },
  { 7973 /* nopr */, SystemZ::NOPR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 7978 /* nork */, SystemZ::NORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 7983 /* notgr */, SystemZ::NOTGR, Convert__GR641_0__GR641_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64 }, },
  { 7989 /* notr */, SystemZ::NOTR, Convert__GR321_0__GR321_1__imm_95_0, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32 }, },
  { 7994 /* nr */, SystemZ::NR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 7997 /* nrk */, SystemZ::NRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8001 /* ntstg */, SystemZ::NTSTG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureTransactionalExecution, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8007 /* nxgrk */, SystemZ::NXGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8013 /* nxrk */, SystemZ::NXRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8018 /* ny */, SystemZ::NY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8021 /* o */, SystemZ::O, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8023 /* oc */, SystemZ::OC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 8026 /* ocgrk */, SystemZ::OCGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8032 /* ocrk */, SystemZ::OCRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8037 /* og */, SystemZ::OG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8040 /* ogr */, SystemZ::OGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8044 /* ogrk */, SystemZ::OGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8049 /* oi */, SystemZ::OI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 8052 /* oihf */, SystemZ::OIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 8057 /* oihh */, SystemZ::OIHH, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8062 /* oihl */, SystemZ::OIHL, Convert__GRH321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 8067 /* oilf */, SystemZ::OILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 8072 /* oilh */, SystemZ::OILH, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8077 /* oill */, SystemZ::OILL, Convert__GR321_0__Tie0_1_1__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 8082 /* oiy */, SystemZ::OIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 8086 /* or */, SystemZ::OR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 8089 /* ork */, SystemZ::ORK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8093 /* oy */, SystemZ::OY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8096 /* pack */, SystemZ::PACK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 8101 /* palb */, SystemZ::PALB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8106 /* pc */, SystemZ::PC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8109 /* pcc */, SystemZ::PCC, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist4, {  }, },
  { 8113 /* pckmo */, SystemZ::PCKMO, Convert_NoOperands, AMFBS_FeatureMessageSecurityAssist3, {  }, },
  { 8119 /* pfcr */, SystemZ::PFCR, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_FeatureConcurrentFunctions, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8124 /* pfd */, SystemZ::PFD, Convert__U4Imm1_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_U4Imm, MCK_BDXAddr64Disp20 }, },
  { 8128 /* pfdrl */, SystemZ::PFDRL, Convert__U4Imm1_0__PCRel321_1, AMFBS_None, { MCK_U4Imm, MCK_PCRel32 }, },
  { 8134 /* pfmf */, SystemZ::PFMF, Convert__GR641_1__GR321_0__Tie0_1_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8139 /* pfpo */, SystemZ::PFPO, Convert_NoOperands, AMFBS_None, {  }, },
  { 8144 /* pgin */, SystemZ::PGIN, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8149 /* pgout */, SystemZ::PGOUT, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8155 /* pka */, SystemZ::PKA, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8159 /* pku */, SystemZ::PKU, Convert__BDAddr64Disp122_0__BDLAddr64Disp12Len83_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDLAddr64Disp12Len8 }, },
  { 8163 /* plo */, SystemZ::PLO, Convert__GR641_0__BDAddr64Disp122_1__GR641_2__BDAddr64Disp122_3, AMFBS_None, { MCK_GR64, MCK_BDAddr64Disp12, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 8167 /* popcnt */, SystemZ::POPCNT, Convert__GR641_0__GR641_1, AMFBS_FeaturePopulationCount, { MCK_GR64, MCK_GR64 }, },
  { 8167 /* popcnt */, SystemZ::POPCNTOpt, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8174 /* ppa */, SystemZ::PPA, Convert__GR641_0__GR641_1__U4Imm1_2, AMFBS_FeatureProcessorAssist, { MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8178 /* ppno */, SystemZ::PPNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist5, { MCK_GR128, MCK_GR128 }, },
  { 8183 /* pr */, SystemZ::PR, Convert_NoOperands, AMFBS_None, {  }, },
  { 8186 /* prno */, SystemZ::PRNO, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureMessageSecurityAssist7, { MCK_GR128, MCK_GR128 }, },
  { 8191 /* pt */, SystemZ::PT, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8194 /* ptf */, SystemZ::PTF, Convert__GR641_0__Tie0_1_1, AMFBS_None, { MCK_GR64 }, },
  { 8198 /* ptff */, SystemZ::PTFF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8203 /* pti */, SystemZ::PTI, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8207 /* ptlb */, SystemZ::PTLB, Convert_NoOperands, AMFBS_None, {  }, },
  { 8212 /* qadtr */, SystemZ::QADTR, Convert__FP641_0__FP641_1__Tie0_1_1__FP641_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8218 /* qaxtr */, SystemZ::QAXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__FP1281_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 8224 /* qctri */, SystemZ::QCTRI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8230 /* qpaci */, SystemZ::QPACI, Convert__BDAddr64Disp122_0, AMFBS_FeatureProcessorActivityInstrumentation, { MCK_BDAddr64Disp12 }, },
  { 8236 /* qsi */, SystemZ::QSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8240 /* rchp */, SystemZ::RCHP, Convert_NoOperands, AMFBS_None, {  }, },
  { 8245 /* rdp */, SystemZ::RDPOpt, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8245 /* rdp */, SystemZ::RDP, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureResetDATProtection, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8249 /* risbg */, SystemZ::RISBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8249 /* risbg */, SystemZ::RISBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8255 /* risbgn */, SystemZ::RISBGNOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8255 /* risbgn */, SystemZ::RISBGN, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8262 /* risbgnz */, SystemZ::RISBGNZOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8262 /* risbgnz */, SystemZ::RISBGNZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureMiscellaneousExtensions, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8270 /* risbgz */, SystemZ::RISBGZOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8270 /* risbgz */, SystemZ::RISBGZ, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8277 /* risbhg */, SystemZ::RISBHGOpt, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8277 /* risbhg */, SystemZ::RISBHG, Convert__GRH321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8284 /* risblg */, SystemZ::RISBLGOpt, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8284 /* risblg */, SystemZ::RISBLG, Convert__GR321_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_FeatureHighWord, { MCK_GR32, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8291 /* rll */, SystemZ::RLL, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 8295 /* rllg */, SystemZ::RLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 8300 /* rnsbg */, SystemZ::RNSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8300 /* rnsbg */, SystemZ::RNSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8306 /* rosbg */, SystemZ::ROSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8306 /* rosbg */, SystemZ::ROSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8312 /* rp */, SystemZ::RP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8315 /* rrbe */, SystemZ::RRBE, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 8320 /* rrbm */, SystemZ::RRBM, Convert__GR641_0__GR641_1, AMFBS_FeatureResetReferenceBitsMultiple, { MCK_GR64, MCK_GR64 }, },
  { 8325 /* rrdtr */, SystemZ::RRDTR, Convert__FP641_0__FP641_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_GR32, MCK_U4Imm }, },
  { 8331 /* rrxtr */, SystemZ::RRXTR, Convert__FP1281_0__FP1281_1__Tie0_1_1__GR321_2__U4Imm1_3, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_GR32, MCK_U4Imm }, },
  { 8337 /* rsch */, SystemZ::RSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 8342 /* rxsbg */, SystemZ::RXSBGOpt, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm }, },
  { 8342 /* rxsbg */, SystemZ::RXSBG, Convert__GR641_0__Tie0_1_1__GR641_1__U8Imm1_2__U8Imm1_3__U8Imm1_4, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_U8Imm, MCK_U8Imm, MCK_U8Imm }, },
  { 8348 /* s */, SystemZ::S, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8350 /* sac */, SystemZ::SAC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8354 /* sacf */, SystemZ::SACF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8359 /* sal */, SystemZ::SAL, Convert_NoOperands, AMFBS_None, {  }, },
  { 8363 /* sam24 */, SystemZ::SAM24, Convert_NoOperands, AMFBS_None, {  }, },
  { 8369 /* sam31 */, SystemZ::SAM31, Convert_NoOperands, AMFBS_None, {  }, },
  { 8375 /* sam64 */, SystemZ::SAM64, Convert_NoOperands, AMFBS_None, {  }, },
  { 8381 /* sar */, SystemZ::SAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 8385 /* scctr */, SystemZ::SCCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8391 /* schm */, SystemZ::SCHM, Convert_NoOperands, AMFBS_None, {  }, },
  { 8396 /* sck */, SystemZ::SCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8400 /* sckc */, SystemZ::SCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8405 /* sckpf */, SystemZ::SCKPF, Convert_NoOperands, AMFBS_None, {  }, },
  { 8411 /* sd */, SystemZ::SD, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8414 /* sdb */, SystemZ::SDB, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 8418 /* sdbr */, SystemZ::SDBR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8423 /* sdr */, SystemZ::SDR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 8427 /* sdtr */, SystemZ::SDTR, Convert__FP641_0__FP641_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_FP64 }, },
  { 8432 /* sdtra */, SystemZ::SDTRA, Convert__FP641_0__FP641_1__FP641_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP64, MCK_FP64, MCK_FP64, MCK_U4Imm }, },
  { 8438 /* se */, SystemZ::SE, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8441 /* seb */, SystemZ::SEB, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 8445 /* sebr */, SystemZ::SEBR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8450 /* selfhr */, SystemZ::SELFHRAsm, Convert__GRH321_0__GRH321_2__GRH321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32, MCK_U4Imm }, },
  { 8457 /* selfhre */, SystemZ::SELFHRAsmE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8465 /* selfhrh */, SystemZ::SELFHRAsmH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8482 /* selfhrl */, SystemZ::SELFHRAsmL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8508 /* selfhrm */, SystemZ::SELFHRAsmM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8516 /* selfhrne */, SystemZ::SELFHRAsmNE, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8525 /* selfhrnh */, SystemZ::SELFHRAsmNH, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8544 /* selfhrnl */, SystemZ::SELFHRAsmNL, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8573 /* selfhrnm */, SystemZ::SELFHRAsmNM, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8582 /* selfhrno */, SystemZ::SELFHRAsmNO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8591 /* selfhrnp */, SystemZ::SELFHRAsmNP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8600 /* selfhrnz */, SystemZ::SELFHRAsmNZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8609 /* selfhro */, SystemZ::SELFHRAsmO, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8617 /* selfhrp */, SystemZ::SELFHRAsmP, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8625 /* selfhrz */, SystemZ::SELFHRAsmZ, Convert__GRH321_0__GRH321_2__GRH321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8633 /* selgr */, SystemZ::SELGRAsm, Convert__GR641_0__GR641_2__GR641_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64, MCK_U4Imm }, },
  { 8639 /* selgre */, SystemZ::SELGRAsmE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8646 /* selgrh */, SystemZ::SELGRAsmH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8661 /* selgrl */, SystemZ::SELGRAsmL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8684 /* selgrm */, SystemZ::SELGRAsmM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8691 /* selgrne */, SystemZ::SELGRAsmNE, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8699 /* selgrnh */, SystemZ::SELGRAsmNH, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8716 /* selgrnl */, SystemZ::SELGRAsmNL, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8742 /* selgrnm */, SystemZ::SELGRAsmNM, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8750 /* selgrno */, SystemZ::SELGRAsmNO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8758 /* selgrnp */, SystemZ::SELGRAsmNP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8766 /* selgrnz */, SystemZ::SELGRAsmNZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8774 /* selgro */, SystemZ::SELGRAsmO, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8781 /* selgrp */, SystemZ::SELGRAsmP, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8788 /* selgrz */, SystemZ::SELGRAsmZ, Convert__GR641_0__GR641_2__GR641_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8795 /* selr */, SystemZ::SELRAsm, Convert__GR321_0__GR321_2__GR321_1__U4Imm1_3, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32, MCK_U4Imm }, },
  { 8800 /* selre */, SystemZ::SELRAsmE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8806 /* selrh */, SystemZ::SELRAsmH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8819 /* selrl */, SystemZ::SELRAsmL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8839 /* selrm */, SystemZ::SELRAsmM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8845 /* selrne */, SystemZ::SELRAsmNE, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8852 /* selrnh */, SystemZ::SELRAsmNH, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8867 /* selrnl */, SystemZ::SELRAsmNL, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8890 /* selrnm */, SystemZ::SELRAsmNM, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8897 /* selrno */, SystemZ::SELRAsmNO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8904 /* selrnp */, SystemZ::SELRAsmNP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8911 /* selrnz */, SystemZ::SELRAsmNZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8918 /* selro */, SystemZ::SELRAsmO, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8924 /* selrp */, SystemZ::SELRAsmP, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8930 /* selrz */, SystemZ::SELRAsmZ, Convert__GR321_0__GR321_2__GR321_1, AMFBS_FeatureMiscellaneousExtensions3, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 8936 /* ser */, SystemZ::SER, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 8940 /* sfasr */, SystemZ::SFASR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8946 /* sfpc */, SystemZ::SFPC, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 8951 /* sg */, SystemZ::SG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8954 /* sgf */, SystemZ::SGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8958 /* sgfr */, SystemZ::SGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 8963 /* sgh */, SystemZ::SGH, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_FeatureMiscellaneousExtensions2, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 8967 /* sgr */, SystemZ::SGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 8971 /* sgrk */, SystemZ::SGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 8976 /* sh */, SystemZ::SH, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 8979 /* shhhr */, SystemZ::SHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 8985 /* shhlr */, SystemZ::SHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 8991 /* shy */, SystemZ::SHY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 8995 /* sie */, SystemZ::SIE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 8999 /* siga */, SystemZ::SIGA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9004 /* sigp */, SystemZ::SIGP, Convert__GR641_0__GR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp12 }, },
  { 9009 /* sl */, SystemZ::SL, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9012 /* sla */, SystemZ::SLA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9016 /* slag */, SystemZ::SLAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9021 /* slak */, SystemZ::SLAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9026 /* slb */, SystemZ::SLB, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9030 /* slbg */, SystemZ::SLBG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9035 /* slbgr */, SystemZ::SLBGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9041 /* slbr */, SystemZ::SLBR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9046 /* slda */, SystemZ::SLDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9051 /* sldl */, SystemZ::SLDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9056 /* sldt */, SystemZ::SLDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9061 /* slfi */, SystemZ::SLFI, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 9066 /* slg */, SystemZ::SLG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9070 /* slgf */, SystemZ::SLGF, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9075 /* slgfi */, SystemZ::SLGFI, Convert__GR641_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR64, MCK_U32Imm }, },
  { 9081 /* slgfr */, SystemZ::SLGFR, Convert__GR641_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR64, MCK_GR32 }, },
  { 9087 /* slgr */, SystemZ::SLGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9092 /* slgrk */, SystemZ::SLGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 9098 /* slhhhr */, SystemZ::SLHHHR, Convert__GRH321_0__GRH321_1__GRH321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GRH32 }, },
  { 9105 /* slhhlr */, SystemZ::SLHHLR, Convert__GRH321_0__GRH321_1__GR321_2, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_GRH32, MCK_GR32 }, },
  { 9112 /* sll */, SystemZ::SLL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9116 /* sllg */, SystemZ::SLLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9121 /* sllk */, SystemZ::SLLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9126 /* slr */, SystemZ::SLR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9130 /* slrk */, SystemZ::SLRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9135 /* slxt */, SystemZ::SLXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9140 /* sly */, SystemZ::SLY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9144 /* sortl */, SystemZ::SORTL, Convert__GR1281_0__GR1281_1__Tie0_1_1__Tie1_1_1, AMFBS_FeatureEnhancedSort, { MCK_GR128, MCK_GR128 }, },
  { 9150 /* sp */, SystemZ::SP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 9153 /* spctr */, SystemZ::SPCTR, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9159 /* spka */, SystemZ::SPKA, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9164 /* spm */, SystemZ::SPM, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9168 /* spt */, SystemZ::SPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9172 /* spx */, SystemZ::SPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9176 /* sqd */, SystemZ::SQD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9180 /* sqdb */, SystemZ::SQDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9185 /* sqdbr */, SystemZ::SQDBR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9191 /* sqdr */, SystemZ::SQDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 9196 /* sqe */, SystemZ::SQE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9200 /* sqeb */, SystemZ::SQEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9205 /* sqebr */, SystemZ::SQEBR, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9211 /* sqer */, SystemZ::SQER, Convert__FP321_0__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 9216 /* sqxbr */, SystemZ::SQXBR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9222 /* sqxr */, SystemZ::SQXR, Convert__FP1281_0__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 9227 /* sr */, SystemZ::SR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 9230 /* sra */, SystemZ::SRA, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9234 /* srag */, SystemZ::SRAG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9239 /* srak */, SystemZ::SRAK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9244 /* srda */, SystemZ::SRDA, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9249 /* srdl */, SystemZ::SRDL, Convert__GR1281_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR128, MCK_BDAddr32Disp12 }, },
  { 9254 /* srdt */, SystemZ::SRDT, Convert__FP641_0__FP641_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP64, MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9259 /* srk */, SystemZ::SRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 9263 /* srl */, SystemZ::SRL, Convert__GR321_0__Tie0_1_1__BDAddr32Disp122_1, AMFBS_None, { MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 9267 /* srlg */, SystemZ::SRLG, Convert__GR641_0__GR641_1__BDAddr32Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr32Disp20 }, },
  { 9272 /* srlk */, SystemZ::SRLK, Convert__GR321_0__GR321_1__BDAddr32Disp202_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_BDAddr32Disp20 }, },
  { 9277 /* srnm */, SystemZ::SRNM, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9282 /* srnmb */, SystemZ::SRNMB, Convert__BDAddr32Disp122_0, AMFBS_FeatureFPExtension, { MCK_BDAddr32Disp12 }, },
  { 9288 /* srnmt */, SystemZ::SRNMT, Convert__BDAddr32Disp122_0, AMFBS_None, { MCK_BDAddr32Disp12 }, },
  { 9294 /* srp */, SystemZ::SRP, Convert__BDLAddr64Disp12Len43_0__BDAddr32Disp122_1__U4Imm1_2, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 9298 /* srst */, SystemZ::SRST, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9303 /* srstu */, SystemZ::SRSTU, Convert__GR641_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 9309 /* srxt */, SystemZ::SRXT, Convert__FP1281_0__FP1281_1__BDXAddr64Disp123_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 9314 /* ssair */, SystemZ::SSAIR, Convert__GR641_0, AMFBS_None, { MCK_GR64 }, },
  { 9320 /* ssar */, SystemZ::SSAR, Convert__GR321_0, AMFBS_None, { MCK_GR32 }, },
  { 9325 /* ssch */, SystemZ::SSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9330 /* sske */, SystemZ::SSKEOpt, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 9330 /* sske */, SystemZ::SSKE, Convert__GR321_0__GR641_1__U4Imm1_2, AMFBS_None, { MCK_GR32, MCK_GR64, MCK_U4Imm }, },
  { 9335 /* ssm */, SystemZ::SSM, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9339 /* st */, SystemZ::ST, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9342 /* stam */, SystemZ::STAM, Convert__AR321_0__AR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp12 }, },
  { 9347 /* stamy */, SystemZ::STAMY, Convert__AR321_0__AR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_AR32, MCK_AR32, MCK_BDAddr64Disp20 }, },
  { 9353 /* stap */, SystemZ::STAP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9358 /* stbear */, SystemZ::STBEAR, Convert__BDAddr64Disp122_0, AMFBS_FeatureBEAREnhancement, { MCK_BDAddr64Disp12 }, },
  { 9365 /* stc */, SystemZ::STC, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9369 /* stch */, SystemZ::STCH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9374 /* stck */, SystemZ::STCK, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9379 /* stckc */, SystemZ::STCKC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9385 /* stcke */, SystemZ::STCKE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9391 /* stckf */, SystemZ::STCKF, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9397 /* stcm */, SystemZ::STCM, Convert__GR321_0__U4Imm1_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp12 }, },
  { 9402 /* stcmh */, SystemZ::STCMH, Convert__GRH321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9408 /* stcmy */, SystemZ::STCMY, Convert__GR321_0__U4Imm1_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_U4Imm, MCK_BDAddr64Disp20 }, },
  { 9414 /* stcps */, SystemZ::STCPS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9420 /* stcrw */, SystemZ::STCRW, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9426 /* stctg */, SystemZ::STCTG, Convert__CR641_0__CR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp20 }, },
  { 9432 /* stctl */, SystemZ::STCTL, Convert__CR641_0__CR641_1__BDAddr64Disp122_2, AMFBS_None, { MCK_CR64, MCK_CR64, MCK_BDAddr64Disp12 }, },
  { 9438 /* stcy */, SystemZ::STCY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9443 /* std */, SystemZ::STD, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 9447 /* stdrv */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9453 /* stdy */, SystemZ::STDY, Convert__FP641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp20 }, },
  { 9458 /* ste */, SystemZ::STE, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 9462 /* sterv */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 9468 /* stey */, SystemZ::STEY, Convert__FP321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp20 }, },
  { 9473 /* stfh */, SystemZ::STFH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9478 /* stfl */, SystemZ::STFL, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9483 /* stfle */, SystemZ::STFLE, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9489 /* stfpc */, SystemZ::STFPC, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9495 /* stg */, SystemZ::STG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9499 /* stgrl */, SystemZ::STGRL, Convert__GR641_0__PCRel321_1, AMFBS_None, { MCK_GR64, MCK_PCRel32 }, },
  { 9505 /* stgsc */, SystemZ::STGSC, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_FeatureGuardedStorage, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 9511 /* sth */, SystemZ::STH, Convert__GR321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 9515 /* sthh */, SystemZ::STHH, Convert__GRH321_0__BDXAddr64Disp203_1, AMFBS_FeatureHighWord, { MCK_GRH32, MCK_BDXAddr64Disp20 }, },
  { 9520 /* sthrl */, SystemZ::STHRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 9526 /* sthy */, SystemZ::STHY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 9531 /* stidp */, SystemZ::STIDP, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 9537 /* stm */, SystemZ::STM, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 9541 /* stmg */, SystemZ::STMG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9546 /* stmh */, SystemZ::STMH, Convert__GRH321_0__GRH321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GRH32, MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9551 /* stmy */, SystemZ::STMY, Convert__GR321_0__GR321_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9556 /* stnsm */, SystemZ::STNSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 9562 /* stoc */, SystemZ::STOCAsm, Convert__GR321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9567 /* stoce */, SystemZ::STOCAsmE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9573 /* stocfh */, SystemZ::STOCFHAsm, Convert__GRH321_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9580 /* stocfhe */, SystemZ::STOCFHAsmE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9588 /* stocfhh */, SystemZ::STOCFHAsmH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9605 /* stocfhl */, SystemZ::STOCFHAsmL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9631 /* stocfhm */, SystemZ::STOCFHAsmM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9639 /* stocfhne */, SystemZ::STOCFHAsmNE, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9648 /* stocfhnh */, SystemZ::STOCFHAsmNH, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9667 /* stocfhnl */, SystemZ::STOCFHAsmNL, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9696 /* stocfhnm */, SystemZ::STOCFHAsmNM, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9705 /* stocfhno */, SystemZ::STOCFHAsmNO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9714 /* stocfhnp */, SystemZ::STOCFHAsmNP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9723 /* stocfhnz */, SystemZ::STOCFHAsmNZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9732 /* stocfho */, SystemZ::STOCFHAsmO, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9740 /* stocfhp */, SystemZ::STOCFHAsmP, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9748 /* stocfhz */, SystemZ::STOCFHAsmZ, Convert__GRH321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond2, { MCK_GRH32, MCK_BDAddr64Disp20 }, },
  { 9756 /* stocg */, SystemZ::STOCGAsm, Convert__GR641_0__BDAddr64Disp202_1__U4Imm1_2, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20, MCK_U4Imm }, },
  { 9762 /* stocge */, SystemZ::STOCGAsmE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9769 /* stocgh */, SystemZ::STOCGAsmH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9784 /* stocgl */, SystemZ::STOCGAsmL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9807 /* stocgm */, SystemZ::STOCGAsmM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9814 /* stocgne */, SystemZ::STOCGAsmNE, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9822 /* stocgnh */, SystemZ::STOCGAsmNH, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9839 /* stocgnl */, SystemZ::STOCGAsmNL, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9865 /* stocgnm */, SystemZ::STOCGAsmNM, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9873 /* stocgno */, SystemZ::STOCGAsmNO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9881 /* stocgnp */, SystemZ::STOCGAsmNP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9889 /* stocgnz */, SystemZ::STOCGAsmNZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9897 /* stocgo */, SystemZ::STOCGAsmO, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9904 /* stocgp */, SystemZ::STOCGAsmP, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9911 /* stocgz */, SystemZ::STOCGAsmZ, Convert__GR641_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 9918 /* stoch */, SystemZ::STOCAsmH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9931 /* stocl */, SystemZ::STOCAsmL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9951 /* stocm */, SystemZ::STOCAsmM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9957 /* stocne */, SystemZ::STOCAsmNE, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9964 /* stocnh */, SystemZ::STOCAsmNH, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 9979 /* stocnl */, SystemZ::STOCAsmNL, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10002 /* stocnm */, SystemZ::STOCAsmNM, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10009 /* stocno */, SystemZ::STOCAsmNO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10016 /* stocnp */, SystemZ::STOCAsmNP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10023 /* stocnz */, SystemZ::STOCAsmNZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10030 /* stoco */, SystemZ::STOCAsmO, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10036 /* stocp */, SystemZ::STOCAsmP, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10042 /* stocz */, SystemZ::STOCAsmZ, Convert__GR321_0__BDAddr64Disp202_1, AMFBS_FeatureLoadStoreOnCond, { MCK_GR32, MCK_BDAddr64Disp20 }, },
  { 10048 /* stosm */, SystemZ::STOSM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10054 /* stpq */, SystemZ::STPQ, Convert__GR1281_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR128, MCK_BDXAddr64Disp20 }, },
  { 10059 /* stpt */, SystemZ::STPT, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10064 /* stpx */, SystemZ::STPX, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10069 /* strag */, SystemZ::STRAG, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10075 /* strl */, SystemZ::STRL, Convert__GR321_0__PCRel321_1, AMFBS_None, { MCK_GR32, MCK_PCRel32 }, },
  { 10080 /* strv */, SystemZ::STRV, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10085 /* strvg */, SystemZ::STRVG, Convert__GR641_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 10091 /* strvh */, SystemZ::STRVH, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10097 /* stsch */, SystemZ::STSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10103 /* stsi */, SystemZ::STSI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10108 /* stura */, SystemZ::STURA, Convert__GR321_0__GR641_1, AMFBS_None, { MCK_GR32, MCK_GR64 }, },
  { 10114 /* sturg */, SystemZ::STURG, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10120 /* sty */, SystemZ::STY, Convert__GR321_0__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10124 /* su */, SystemZ::SU, Convert__FP321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10127 /* sur */, SystemZ::SUR, Convert__FP321_0__Tie0_1_1__FP321_1, AMFBS_None, { MCK_FP32, MCK_FP32 }, },
  { 10131 /* svc */, SystemZ::SVC, Convert__U8Imm1_0, AMFBS_None, { MCK_U8Imm }, },
  { 10135 /* sw */, SystemZ::SW, Convert__FP641_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10138 /* swr */, SystemZ::SWR, Convert__FP641_0__Tie0_1_1__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10142 /* sxbr */, SystemZ::SXBR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10147 /* sxr */, SystemZ::SXR, Convert__FP1281_0__Tie0_1_1__FP1281_1, AMFBS_None, { MCK_FP128, MCK_FP128 }, },
  { 10151 /* sxtr */, SystemZ::SXTR, Convert__FP1281_0__FP1281_1__FP1281_2, AMFBS_None, { MCK_FP128, MCK_FP128, MCK_FP128 }, },
  { 10156 /* sxtra */, SystemZ::SXTRA, Convert__FP1281_0__FP1281_1__FP1281_2__U4Imm1_3, AMFBS_FeatureFPExtension, { MCK_FP128, MCK_FP128, MCK_FP128, MCK_U4Imm }, },
  { 10162 /* sy */, SystemZ::SY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 10165 /* tabort */, SystemZ::TABORT, Convert__BDAddr64Disp122_0, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12 }, },
  { 10172 /* tam */, SystemZ::TAM, Convert_NoOperands, AMFBS_None, {  }, },
  { 10176 /* tar */, SystemZ::TAR, Convert__AR321_0__GR321_1, AMFBS_None, { MCK_AR32, MCK_GR32 }, },
  { 10180 /* tb */, SystemZ::TB, Convert__GR641_0__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 10183 /* tbdr */, SystemZ::TBDR, Convert__FP641_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP64, MCK_U4Imm, MCK_FP64 }, },
  { 10188 /* tbedr */, SystemZ::TBEDR, Convert__FP321_0__U4Imm1_1__FP641_2, AMFBS_None, { MCK_FP32, MCK_U4Imm, MCK_FP64 }, },
  { 10194 /* tbegin */, SystemZ::TBEGIN, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10201 /* tbeginc */, SystemZ::TBEGINC, Convert__BDAddr64Disp122_0__U16Imm1_1, AMFBS_FeatureTransactionalExecution, { MCK_BDAddr64Disp12, MCK_U16Imm }, },
  { 10209 /* tcdb */, SystemZ::TCDB, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10214 /* tceb */, SystemZ::TCEB, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10219 /* tcxb */, SystemZ::TCXB, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10224 /* tdcdt */, SystemZ::TDCDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10230 /* tdcet */, SystemZ::TDCET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10236 /* tdcxt */, SystemZ::TDCXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10242 /* tdgdt */, SystemZ::TDGDT, Convert__FP641_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP64, MCK_BDXAddr64Disp12 }, },
  { 10248 /* tdget */, SystemZ::TDGET, Convert__FP321_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP32, MCK_BDXAddr64Disp12 }, },
  { 10254 /* tdgxt */, SystemZ::TDGXT, Convert__FP1281_0__BDXAddr64Disp123_1, AMFBS_None, { MCK_FP128, MCK_BDXAddr64Disp12 }, },
  { 10260 /* tend */, SystemZ::TEND, Convert_NoOperands, AMFBS_FeatureTransactionalExecution, {  }, },
  { 10265 /* thder */, SystemZ::THDER, Convert__FP641_0__FP321_1, AMFBS_None, { MCK_FP64, MCK_FP32 }, },
  { 10271 /* thdr */, SystemZ::THDR, Convert__FP641_0__FP641_1, AMFBS_None, { MCK_FP64, MCK_FP64 }, },
  { 10276 /* tm */, SystemZ::TM, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 10279 /* tmh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10283 /* tmhh */, SystemZ::TMHH, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10288 /* tmhl */, SystemZ::TMHL, Convert__GRH321_0__U16Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U16Imm }, },
  { 10293 /* tml */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10297 /* tmlh */, SystemZ::TMLH, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10302 /* tmll */, SystemZ::TMLL, Convert__GR321_0__U16Imm1_1, AMFBS_None, { MCK_GR32, MCK_U16Imm }, },
  { 10307 /* tmy */, SystemZ::TMY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 10311 /* tp */, SystemZ::TP, Convert__BDLAddr64Disp12Len43_0, AMFBS_None, { MCK_BDLAddr64Disp12Len4 }, },
  { 10314 /* tpei */, SystemZ::TPEI, Convert__GR641_0__GR641_1, AMFBS_FeatureTestPendingExternalInterruption, { MCK_GR64, MCK_GR64 }, },
  { 10319 /* tpi */, SystemZ::TPI, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10323 /* tprot */, SystemZ::TPROT, Convert__BDAddr64Disp122_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_BDAddr64Disp12 }, },
  { 10329 /* tr */, SystemZ::TR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10332 /* trace */, SystemZ::TRACE, Convert__GR321_0__GR321_1__BDAddr64Disp122_2, AMFBS_None, { MCK_GR32, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 10338 /* tracg */, SystemZ::TRACG, Convert__GR641_0__GR641_1__BDAddr64Disp202_2, AMFBS_None, { MCK_GR64, MCK_GR64, MCK_BDAddr64Disp20 }, },
  { 10344 /* trap2 */, SystemZ::TRAP2, Convert_NoOperands, AMFBS_None, {  }, },
  { 10350 /* trap4 */, SystemZ::TRAP4, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10356 /* tre */, SystemZ::TRE, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10360 /* troo */, SystemZ::TROOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10360 /* troo */, SystemZ::TROO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10365 /* trot */, SystemZ::TROTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10365 /* trot */, SystemZ::TROT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10370 /* trt */, SystemZ::TRT, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10374 /* trte */, SystemZ::TRTEOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10374 /* trte */, SystemZ::TRTE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10379 /* trto */, SystemZ::TRTOOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10379 /* trto */, SystemZ::TRTO, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10384 /* trtr */, SystemZ::TRTR, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10389 /* trtre */, SystemZ::TRTREOpt, Convert__GR641_1__GR1281_0__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10389 /* trtre */, SystemZ::TRTRE, Convert__GR641_1__GR1281_0__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10395 /* trtt */, SystemZ::TRTTOpt, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1, AMFBS_None, { MCK_GR128, MCK_GR64 }, },
  { 10395 /* trtt */, SystemZ::TRTT, Convert__GR1281_0__GR641_1__Tie0_1_1__Tie1_1_1__U4Imm1_2, AMFBS_None, { MCK_GR128, MCK_GR64, MCK_U4Imm }, },
  { 10400 /* ts */, SystemZ::TS, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10403 /* tsch */, SystemZ::TSCH, Convert__BDAddr64Disp122_0, AMFBS_None, { MCK_BDAddr64Disp12 }, },
  { 10408 /* unpk */, SystemZ::UNPK, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
  { 10413 /* unpka */, SystemZ::UNPKA, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10419 /* unpku */, SystemZ::UNPKU, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 10425 /* upt */, SystemZ::UPT, Convert_NoOperands, AMFBS_None, {  }, },
  { 10429 /* va */, SystemZ::VA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10432 /* vab */, SystemZ::VAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10436 /* vac */, SystemZ::VAC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10440 /* vacc */, SystemZ::VACC, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10445 /* vaccb */, SystemZ::VACCB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10451 /* vaccc */, SystemZ::VACCC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10457 /* vacccq */, SystemZ::VACCCQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10464 /* vaccf */, SystemZ::VACCF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10470 /* vaccg */, SystemZ::VACCG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10476 /* vacch */, SystemZ::VACCH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10482 /* vaccq */, SystemZ::VACCQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10488 /* vacq */, SystemZ::VACQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10493 /* vaf */, SystemZ::VAF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10497 /* vag */, SystemZ::VAG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10501 /* vah */, SystemZ::VAH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10505 /* vap */, SystemZ::VAP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 10509 /* vaq */, SystemZ::VAQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10513 /* vavg */, SystemZ::VAVG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10518 /* vavgb */, SystemZ::VAVGB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10524 /* vavgf */, SystemZ::VAVGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10530 /* vavgg */, SystemZ::VAVGG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10536 /* vavgh */, SystemZ::VAVGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10542 /* vavgl */, SystemZ::VAVGL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10548 /* vavglb */, SystemZ::VAVGLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10555 /* vavglf */, SystemZ::VAVGLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10562 /* vavglg */, SystemZ::VAVGLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10569 /* vavglh */, SystemZ::VAVGLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10576 /* vavglq */, SystemZ::VAVGLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10583 /* vavgq */, SystemZ::VAVGQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10589 /* vblend */, SystemZ::VBLEND, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10596 /* vblendb */, SystemZ::VBLENDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10604 /* vblendf */, SystemZ::VBLENDF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10612 /* vblendg */, SystemZ::VBLENDG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10620 /* vblendh */, SystemZ::VBLENDH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10628 /* vblendq */, SystemZ::VBLENDQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10636 /* vbperm */, SystemZ::VBPERM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10643 /* vcdg */, SystemZ::VCDG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10648 /* vcdgb */, SystemZ::VCDGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10654 /* vcdlg */, SystemZ::VCDLG, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10660 /* vcdlgb */, SystemZ::VCDLGB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10667 /* vcefb */, SystemZ::VCEFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10673 /* vcelfb */, SystemZ::VCELFB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10680 /* vceq */, SystemZ::VCEQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10685 /* vceqb */, SystemZ::VCEQB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10691 /* vceqbs */, SystemZ::VCEQBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10698 /* vceqf */, SystemZ::VCEQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10704 /* vceqfs */, SystemZ::VCEQFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10711 /* vceqg */, SystemZ::VCEQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10717 /* vceqgs */, SystemZ::VCEQGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10724 /* vceqh */, SystemZ::VCEQH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10730 /* vceqhs */, SystemZ::VCEQHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10737 /* vceqq */, SystemZ::VCEQQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10743 /* vceqqs */, SystemZ::VCEQQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10750 /* vcfeb */, SystemZ::VCFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10756 /* vcfn */, SystemZ::VCFN, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10761 /* vcfpl */, SystemZ::VCFPL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10767 /* vcfps */, SystemZ::VCFPS, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10773 /* vcgd */, SystemZ::VCGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10778 /* vcgdb */, SystemZ::VCGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10784 /* vch */, SystemZ::VCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10788 /* vchb */, SystemZ::VCHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10793 /* vchbs */, SystemZ::VCHBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10799 /* vchf */, SystemZ::VCHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10804 /* vchfs */, SystemZ::VCHFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10810 /* vchg */, SystemZ::VCHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10815 /* vchgs */, SystemZ::VCHGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10821 /* vchh */, SystemZ::VCHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10826 /* vchhs */, SystemZ::VCHHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10832 /* vchl */, SystemZ::VCHL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10837 /* vchlb */, SystemZ::VCHLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10843 /* vchlbs */, SystemZ::VCHLBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10850 /* vchlf */, SystemZ::VCHLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10856 /* vchlfs */, SystemZ::VCHLFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10863 /* vchlg */, SystemZ::VCHLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10869 /* vchlgs */, SystemZ::VCHLGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10876 /* vchlh */, SystemZ::VCHLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10882 /* vchlhs */, SystemZ::VCHLHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10889 /* vchlq */, SystemZ::VCHLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10895 /* vchlqs */, SystemZ::VCHLQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10902 /* vchq */, SystemZ::VCHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10907 /* vchqs */, SystemZ::VCHQS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10913 /* vcksm */, SystemZ::VCKSM, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 10919 /* vclfeb */, SystemZ::VCLFEB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10926 /* vclfnh */, SystemZ::VCLFNH, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10933 /* vclfnl */, SystemZ::VCLFNL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10940 /* vclfp */, SystemZ::VCLFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10946 /* vclgd */, SystemZ::VCLGD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 10952 /* vclgdb */, SystemZ::VCLGDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 10959 /* vclz */, SystemZ::VCLZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10964 /* vclzb */, SystemZ::VCLZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10970 /* vclzdp */, SystemZ::VCLZDP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 10977 /* vclzf */, SystemZ::VCLZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10983 /* vclzg */, SystemZ::VCLZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10989 /* vclzh */, SystemZ::VCLZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 10995 /* vclzq */, SystemZ::VCLZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11001 /* vcnf */, SystemZ::VCNF, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11006 /* vcp */, SystemZ::VCP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11010 /* vcrnf */, SystemZ::VCRNF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector_FeatureNNPAssist, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11016 /* vcsfp */, SystemZ::VCSFP, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11022 /* vcsph */, SystemZ::VCSPH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11028 /* vctz */, SystemZ::VCTZ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11033 /* vctzb */, SystemZ::VCTZB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11039 /* vctzf */, SystemZ::VCTZF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11045 /* vctzg */, SystemZ::VCTZG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11051 /* vctzh */, SystemZ::VCTZH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11057 /* vctzq */, SystemZ::VCTZQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11063 /* vcvb */, SystemZ::VCVB, Convert__GR321_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR32, MCK_VR128, MCK_U4Imm }, },
  { 11063 /* vcvb */, SystemZ::VCVBOpt, Convert__GR321_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR32, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11068 /* vcvbg */, SystemZ::VCVBG, Convert__GR641_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_GR64, MCK_VR128, MCK_U4Imm }, },
  { 11068 /* vcvbg */, SystemZ::VCVBGOpt, Convert__GR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement, { MCK_GR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11074 /* vcvbq */, SystemZ::VCVBQ, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11080 /* vcvd */, SystemZ::VCVD, Convert__VR1281_0__GR321_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_U8Imm, MCK_U4Imm }, },
  { 11085 /* vcvdg */, SystemZ::VCVDG, Convert__VR1281_0__GR641_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR64, MCK_U8Imm, MCK_U4Imm }, },
  { 11091 /* vcvdq */, SystemZ::VCVDQ, Convert__VR1281_0__VR1281_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11097 /* vd */, SystemZ::VD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11100 /* vdf */, SystemZ::VDF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11104 /* vdg */, SystemZ::VDG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11108 /* vdl */, SystemZ::VDL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11112 /* vdlf */, SystemZ::VDLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11117 /* vdlg */, SystemZ::VDLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11122 /* vdlq */, SystemZ::VDLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11127 /* vdp */, SystemZ::VDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11131 /* vdq */, SystemZ::VDQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11135 /* vec */, SystemZ::VEC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11139 /* vecb */, SystemZ::VECB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11144 /* vecf */, SystemZ::VECF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11149 /* vecg */, SystemZ::VECG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11154 /* vech */, SystemZ::VECH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11159 /* vecl */, SystemZ::VECL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11164 /* veclb */, SystemZ::VECLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11170 /* veclf */, SystemZ::VECLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11176 /* veclg */, SystemZ::VECLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11182 /* veclh */, SystemZ::VECLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 11188 /* veclq */, SystemZ::VECLQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11194 /* vecq */, SystemZ::VECQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 11199 /* verim */, SystemZ::VERIM, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 11205 /* verimb */, SystemZ::VERIMB, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11212 /* verimf */, SystemZ::VERIMF, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11219 /* verimg */, SystemZ::VERIMG, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11226 /* verimh */, SystemZ::VERIMH, Convert__VR1281_0__Tie0_1_1__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11233 /* verll */, SystemZ::VERLL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11239 /* verllb */, SystemZ::VERLLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11246 /* verllf */, SystemZ::VERLLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11253 /* verllg */, SystemZ::VERLLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11260 /* verllh */, SystemZ::VERLLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11267 /* verllv */, SystemZ::VERLLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11274 /* verllvb */, SystemZ::VERLLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11282 /* verllvf */, SystemZ::VERLLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11290 /* verllvg */, SystemZ::VERLLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11298 /* verllvh */, SystemZ::VERLLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11306 /* vesl */, SystemZ::VESL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11311 /* veslb */, SystemZ::VESLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11317 /* veslf */, SystemZ::VESLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11323 /* veslg */, SystemZ::VESLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11329 /* veslh */, SystemZ::VESLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11335 /* veslv */, SystemZ::VESLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11341 /* veslvb */, SystemZ::VESLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11348 /* veslvf */, SystemZ::VESLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11355 /* veslvg */, SystemZ::VESLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11362 /* veslvh */, SystemZ::VESLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11369 /* vesra */, SystemZ::VESRA, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11375 /* vesrab */, SystemZ::VESRAB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11382 /* vesraf */, SystemZ::VESRAF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11389 /* vesrag */, SystemZ::VESRAG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11396 /* vesrah */, SystemZ::VESRAH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11403 /* vesrav */, SystemZ::VESRAV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11410 /* vesravb */, SystemZ::VESRAVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11418 /* vesravf */, SystemZ::VESRAVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11426 /* vesravg */, SystemZ::VESRAVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11434 /* vesravh */, SystemZ::VESRAVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11442 /* vesrl */, SystemZ::VESRL, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 11448 /* vesrlb */, SystemZ::VESRLB, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11455 /* vesrlf */, SystemZ::VESRLF, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11462 /* vesrlg */, SystemZ::VESRLG, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11469 /* vesrlh */, SystemZ::VESRLH, Convert__VR1281_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 11476 /* vesrlv */, SystemZ::VESRLV, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11483 /* vesrlvb */, SystemZ::VESRLVB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11491 /* vesrlvf */, SystemZ::VESRLVF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11499 /* vesrlvg */, SystemZ::VESRLVG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11507 /* vesrlvh */, SystemZ::VESRLVH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11515 /* veval */, SystemZ::VEVAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U8Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 11521 /* vfa */, SystemZ::VFA, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11525 /* vfadb */, SystemZ::VFADB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11531 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11531 /* vfae */, SystemZ::VFAE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11536 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11536 /* vfaeb */, SystemZ::VFAEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11542 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11542 /* vfaebs */, SystemZ::VFAEBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11549 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11549 /* vfaef */, SystemZ::VFAEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11555 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11555 /* vfaefs */, SystemZ::VFAEFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11562 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11562 /* vfaeh */, SystemZ::VFAEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11568 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11568 /* vfaehs */, SystemZ::VFAEHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11575 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11575 /* vfaezb */, SystemZ::VFAEZB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11582 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11582 /* vfaezbs */, SystemZ::VFAEZBS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11590 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11590 /* vfaezf */, SystemZ::VFAEZF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11597 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11597 /* vfaezfs */, SystemZ::VFAEZFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11605 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11605 /* vfaezh */, SystemZ::VFAEZH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11612 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11612 /* vfaezhs */, SystemZ::VFAEZHS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11620 /* vfasb */, SystemZ::VFASB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11626 /* vfce */, SystemZ::VFCE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11631 /* vfcedb */, SystemZ::VFCEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11638 /* vfcedbs */, SystemZ::VFCEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11646 /* vfcesb */, SystemZ::VFCESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11653 /* vfcesbs */, SystemZ::VFCESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11661 /* vfch */, SystemZ::VFCH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11666 /* vfchdb */, SystemZ::VFCHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11673 /* vfchdbs */, SystemZ::VFCHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11681 /* vfche */, SystemZ::VFCHE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11687 /* vfchedb */, SystemZ::VFCHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11695 /* vfchedbs */, SystemZ::VFCHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11704 /* vfchesb */, SystemZ::VFCHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11712 /* vfchesbs */, SystemZ::VFCHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11721 /* vfchsb */, SystemZ::VFCHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11728 /* vfchsbs */, SystemZ::VFCHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11736 /* vfd */, SystemZ::VFD, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11740 /* vfddb */, SystemZ::VFDDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11746 /* vfdsb */, SystemZ::VFDSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11752 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11752 /* vfee */, SystemZ::VFEE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11757 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11757 /* vfeeb */, SystemZ::VFEEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11763 /* vfeebs */, SystemZ::VFEEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11770 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11770 /* vfeef */, SystemZ::VFEEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11776 /* vfeefs */, SystemZ::VFEEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11783 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11783 /* vfeeh */, SystemZ::VFEEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11789 /* vfeehs */, SystemZ::VFEEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11796 /* vfeezb */, SystemZ::VFEEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11803 /* vfeezbs */, SystemZ::VFEEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11811 /* vfeezf */, SystemZ::VFEEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11818 /* vfeezfs */, SystemZ::VFEEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11826 /* vfeezh */, SystemZ::VFEEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11833 /* vfeezhs */, SystemZ::VFEEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11841 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11841 /* vfene */, SystemZ::VFENE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11847 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11847 /* vfeneb */, SystemZ::VFENEB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11854 /* vfenebs */, SystemZ::VFENEBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11862 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11862 /* vfenef */, SystemZ::VFENEF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11869 /* vfenefs */, SystemZ::VFENEFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11877 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11877 /* vfeneh */, SystemZ::VFENEH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 11884 /* vfenehs */, SystemZ::VFENEHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11892 /* vfenezb */, SystemZ::VFENEZB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11900 /* vfenezbs */, SystemZ::VFENEZBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11909 /* vfenezf */, SystemZ::VFENEZF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11917 /* vfenezfs */, SystemZ::VFENEZFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11926 /* vfenezh */, SystemZ::VFENEZH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11934 /* vfenezhs */, SystemZ::VFENEZHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11943 /* vfi */, SystemZ::VFI, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 11947 /* vfidb */, SystemZ::VFIDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11953 /* vfisb */, SystemZ::VFISB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 11959 /* vfkedb */, SystemZ::VFKEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11966 /* vfkedbs */, SystemZ::VFKEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11974 /* vfkesb */, SystemZ::VFKESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11981 /* vfkesbs */, SystemZ::VFKESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11989 /* vfkhdb */, SystemZ::VFKHDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 11996 /* vfkhdbs */, SystemZ::VFKHDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12004 /* vfkhedb */, SystemZ::VFKHEDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12012 /* vfkhedbs */, SystemZ::VFKHEDBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12021 /* vfkhesb */, SystemZ::VFKHESB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12029 /* vfkhesbs */, SystemZ::VFKHESBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12038 /* vfkhsb */, SystemZ::VFKHSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12045 /* vfkhsbs */, SystemZ::VFKHSBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12053 /* vflcdb */, SystemZ::VFLCDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12060 /* vflcsb */, SystemZ::VFLCSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12067 /* vfll */, SystemZ::VFLL, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12072 /* vflls */, SystemZ::VFLLS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12078 /* vflndb */, SystemZ::VFLNDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12085 /* vflnsb */, SystemZ::VFLNSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12092 /* vflpdb */, SystemZ::VFLPDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12099 /* vflpsb */, SystemZ::VFLPSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12106 /* vflr */, SystemZ::VFLR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12111 /* vflrd */, SystemZ::VFLRD, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12117 /* vfm */, SystemZ::VFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12121 /* vfma */, SystemZ::VFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12126 /* vfmadb */, SystemZ::VFMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12133 /* vfmasb */, SystemZ::VFMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12140 /* vfmax */, SystemZ::VFMAX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12146 /* vfmaxdb */, SystemZ::VFMAXDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12154 /* vfmaxsb */, SystemZ::VFMAXSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12162 /* vfmdb */, SystemZ::VFMDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12168 /* vfmin */, SystemZ::VFMIN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12174 /* vfmindb */, SystemZ::VFMINDB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12182 /* vfminsb */, SystemZ::VFMINSB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12190 /* vfms */, SystemZ::VFMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12195 /* vfmsb */, SystemZ::VFMSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12201 /* vfmsdb */, SystemZ::VFMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12208 /* vfmssb */, SystemZ::VFMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12215 /* vfnma */, SystemZ::VFNMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12221 /* vfnmadb */, SystemZ::VFNMADB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12229 /* vfnmasb */, SystemZ::VFNMASB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12237 /* vfnms */, SystemZ::VFNMS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12243 /* vfnmsdb */, SystemZ::VFNMSDB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12251 /* vfnmssb */, SystemZ::VFNMSSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12259 /* vfpso */, SystemZ::VFPSO, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12265 /* vfpsodb */, SystemZ::VFPSODB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12273 /* vfpsosb */, SystemZ::VFPSOSB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12281 /* vfs */, SystemZ::VFS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12285 /* vfsdb */, SystemZ::VFSDB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12291 /* vfsq */, SystemZ::VFSQ, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12296 /* vfsqdb */, SystemZ::VFSQDB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12303 /* vfsqsb */, SystemZ::VFSQSB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 12310 /* vfssb */, SystemZ::VFSSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12316 /* vftci */, SystemZ::VFTCI, Convert__VR1281_0__VR1281_1__U12Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12322 /* vftcidb */, SystemZ::VFTCIDB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12330 /* vftcisb */, SystemZ::VFTCISB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 12338 /* vgbm */, SystemZ::VGBM, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_U16Imm }, },
  { 12343 /* vgef */, SystemZ::VGEF, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 12348 /* vgeg */, SystemZ::VGEG, Convert__VR1281_0__Tie0_1_1__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 12353 /* vgem */, SystemZ::VGEM, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12358 /* vgemb */, SystemZ::VGEMB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12364 /* vgemf */, SystemZ::VGEMF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12370 /* vgemg */, SystemZ::VGEMG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12376 /* vgemh */, SystemZ::VGEMH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12382 /* vgemq */, SystemZ::VGEMQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12388 /* vgfm */, SystemZ::VGFM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12393 /* vgfma */, SystemZ::VGFMA, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12399 /* vgfmab */, SystemZ::VGFMAB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12406 /* vgfmaf */, SystemZ::VGFMAF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12413 /* vgfmag */, SystemZ::VGFMAG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12420 /* vgfmah */, SystemZ::VGFMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12427 /* vgfmb */, SystemZ::VGFMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12433 /* vgfmf */, SystemZ::VGFMF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12439 /* vgfmg */, SystemZ::VGFMG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12445 /* vgfmh */, SystemZ::VGFMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12451 /* vgm */, SystemZ::VGM, Convert__VR1281_0__U8Imm1_1__U8Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 12455 /* vgmb */, SystemZ::VGMB, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12460 /* vgmf */, SystemZ::VGMF, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12465 /* vgmg */, SystemZ::VGMG, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12470 /* vgmh */, SystemZ::VGMH, Convert__VR1281_0__U8Imm1_1__U8Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_U8Imm, MCK_U8Imm }, },
  { 12475 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12475 /* vistr */, SystemZ::VISTR, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12481 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12481 /* vistrb */, SystemZ::VISTRB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12488 /* vistrbs */, SystemZ::VISTRBS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12496 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12496 /* vistrf */, SystemZ::VISTRF, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12503 /* vistrfs */, SystemZ::VISTRFS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12511 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12511 /* vistrh */, SystemZ::VISTRH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12518 /* vistrhs */, SystemZ::VISTRHS, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12526 /* vl */, SystemZ::VL, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12526 /* vl */, SystemZ::VLAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12529 /* vlbb */, SystemZ::VLBB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12534 /* vlbr */, SystemZ::VLBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12539 /* vlbrf */, SystemZ::VLBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12545 /* vlbrg */, SystemZ::VLBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12551 /* vlbrh */, SystemZ::VLBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12557 /* vlbrq */, SystemZ::VLBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12563 /* vlbrrep */, SystemZ::VLBRREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12571 /* vlbrrepf */, SystemZ::VLBRREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12580 /* vlbrrepg */, SystemZ::VLBRREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12589 /* vlbrreph */, SystemZ::VLBRREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12598 /* vlc */, SystemZ::VLC, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12602 /* vlcb */, SystemZ::VLCB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12607 /* vlcf */, SystemZ::VLCF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12612 /* vlcg */, SystemZ::VLCG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12617 /* vlch */, SystemZ::VLCH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12622 /* vlcq */, SystemZ::VLCQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12627 /* vlde */, SystemZ::VLDE, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12632 /* vldeb */, SystemZ::VLDEB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12638 /* vleb */, SystemZ::VLEB, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12643 /* vlebrf */, SystemZ::VLEBRF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12650 /* vlebrg */, SystemZ::VLEBRG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12657 /* vlebrh */, SystemZ::VLEBRH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12664 /* vled */, SystemZ::VLED, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm, MCK_U4Imm }, },
  { 12669 /* vledb */, SystemZ::VLEDB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 12675 /* vlef */, SystemZ::VLEF, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 12680 /* vleg */, SystemZ::VLEG, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 12685 /* vleh */, SystemZ::VLEH, Convert__VR1281_0__Tie0_1_1__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 12690 /* vleib */, SystemZ::VLEIB, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 12696 /* vleif */, SystemZ::VLEIF, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U2Imm }, },
  { 12702 /* vleig */, SystemZ::VLEIG, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U1Imm }, },
  { 12708 /* vleih */, SystemZ::VLEIH, Convert__VR1281_0__Tie0_1_1__S16Imm1_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U3Imm }, },
  { 12714 /* vler */, SystemZ::VLER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12719 /* vlerf */, SystemZ::VLERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12725 /* vlerg */, SystemZ::VLERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12731 /* vlerh */, SystemZ::VLERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12737 /* vlgv */, SystemZ::VLGV, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12742 /* vlgvb */, SystemZ::VLGVB, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12748 /* vlgvf */, SystemZ::VLGVF, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12754 /* vlgvg */, SystemZ::VLGVG, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12760 /* vlgvh */, SystemZ::VLGVH, Convert__GR641_0__VR1281_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_GR64, MCK_VR128, MCK_BDAddr32Disp12 }, },
  { 12766 /* vlip */, SystemZ::VLIP, Convert__VR1281_0__U16Imm1_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 12771 /* vll */, SystemZ::VLL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12775 /* vllebrz */, SystemZ::VLLEBRZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12783 /* vllebrze */, SystemZ::VLLEBRZE, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12792 /* vllebrzf */, SystemZ::VLLEBRZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12801 /* vllebrzg */, SystemZ::VLLEBRZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12810 /* vllebrzh */, SystemZ::VLLEBRZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12819 /* vllez */, SystemZ::VLLEZ, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12825 /* vllezb */, SystemZ::VLLEZB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12832 /* vllezf */, SystemZ::VLLEZF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12839 /* vllezg */, SystemZ::VLLEZG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12846 /* vllezh */, SystemZ::VLLEZH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12853 /* vllezlf */, SystemZ::VLLEZLF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12861 /* vlm */, SystemZ::VLM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 12861 /* vlm */, SystemZ::VLMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 12865 /* vlp */, SystemZ::VLP, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12869 /* vlpb */, SystemZ::VLPB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12874 /* vlpf */, SystemZ::VLPF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12879 /* vlpg */, SystemZ::VLPG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12884 /* vlph */, SystemZ::VLPH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12889 /* vlpq */, SystemZ::VLPQ, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 12894 /* vlr */, SystemZ::VLR, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 12898 /* vlrep */, SystemZ::VLREP, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 12904 /* vlrepb */, SystemZ::VLREPB, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12911 /* vlrepf */, SystemZ::VLREPF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12918 /* vlrepg */, SystemZ::VLREPG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12925 /* vlreph */, SystemZ::VLREPH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 12932 /* vlrl */, SystemZ::VLRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 12937 /* vlrlr */, SystemZ::VLRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 12943 /* vlvg */, SystemZ::VLVG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12, MCK_U4Imm }, },
  { 12948 /* vlvgb */, SystemZ::VLVGB, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12954 /* vlvgf */, SystemZ::VLVGF, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12960 /* vlvgg */, SystemZ::VLVGG, Convert__VR1281_0__Tie0_1_1__GR641_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_BDAddr32Disp12 }, },
  { 12966 /* vlvgh */, SystemZ::VLVGH, Convert__VR1281_0__Tie0_1_1__GR321_1__BDAddr32Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr32Disp12 }, },
  { 12972 /* vlvgp */, SystemZ::VLVGP, Convert__VR1281_0__GR641_1__GR641_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR64, MCK_GR64 }, },
  { 12978 /* vmae */, SystemZ::VMAE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 12983 /* vmaeb */, SystemZ::VMAEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12989 /* vmaef */, SystemZ::VMAEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 12995 /* vmaeg */, SystemZ::VMAEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13001 /* vmaeh */, SystemZ::VMAEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13007 /* vmah */, SystemZ::VMAH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13012 /* vmahb */, SystemZ::VMAHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13018 /* vmahf */, SystemZ::VMAHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13024 /* vmahg */, SystemZ::VMAHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13030 /* vmahh */, SystemZ::VMAHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13036 /* vmahq */, SystemZ::VMAHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13042 /* vmal */, SystemZ::VMAL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13047 /* vmalb */, SystemZ::VMALB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13053 /* vmale */, SystemZ::VMALE, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13059 /* vmaleb */, SystemZ::VMALEB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13066 /* vmalef */, SystemZ::VMALEF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13073 /* vmaleg */, SystemZ::VMALEG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13080 /* vmaleh */, SystemZ::VMALEH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13087 /* vmalf */, SystemZ::VMALF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13093 /* vmalg */, SystemZ::VMALG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13099 /* vmalh */, SystemZ::VMALH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13105 /* vmalhb */, SystemZ::VMALHB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13112 /* vmalhf */, SystemZ::VMALHF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13119 /* vmalhg */, SystemZ::VMALHG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13126 /* vmalhh */, SystemZ::VMALHH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13133 /* vmalhq */, SystemZ::VMALHQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13140 /* vmalhw */, SystemZ::VMALHW, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13147 /* vmalo */, SystemZ::VMALO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13153 /* vmalob */, SystemZ::VMALOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13160 /* vmalof */, SystemZ::VMALOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13167 /* vmalog */, SystemZ::VMALOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13174 /* vmaloh */, SystemZ::VMALOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13181 /* vmalq */, SystemZ::VMALQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13187 /* vmao */, SystemZ::VMAO, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13192 /* vmaob */, SystemZ::VMAOB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13198 /* vmaof */, SystemZ::VMAOF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13204 /* vmaog */, SystemZ::VMAOG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13210 /* vmaoh */, SystemZ::VMAOH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13216 /* vme */, SystemZ::VME, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13220 /* vmeb */, SystemZ::VMEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13225 /* vmef */, SystemZ::VMEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13230 /* vmeg */, SystemZ::VMEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13235 /* vmeh */, SystemZ::VMEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13240 /* vmh */, SystemZ::VMH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13244 /* vmhb */, SystemZ::VMHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13249 /* vmhf */, SystemZ::VMHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13254 /* vmhg */, SystemZ::VMHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13259 /* vmhh */, SystemZ::VMHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13264 /* vmhq */, SystemZ::VMHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13269 /* vml */, SystemZ::VML, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13273 /* vmlb */, SystemZ::VMLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13278 /* vmle */, SystemZ::VMLE, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13283 /* vmleb */, SystemZ::VMLEB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13289 /* vmlef */, SystemZ::VMLEF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13295 /* vmleg */, SystemZ::VMLEG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13301 /* vmleh */, SystemZ::VMLEH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13307 /* vmlf */, SystemZ::VMLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13312 /* vmlg */, SystemZ::VMLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13317 /* vmlh */, SystemZ::VMLH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13322 /* vmlhb */, SystemZ::VMLHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13328 /* vmlhf */, SystemZ::VMLHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13334 /* vmlhg */, SystemZ::VMLHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13340 /* vmlhh */, SystemZ::VMLHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13346 /* vmlhq */, SystemZ::VMLHQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13352 /* vmlhw */, SystemZ::VMLHW, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13358 /* vmlo */, SystemZ::VMLO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13363 /* vmlob */, SystemZ::VMLOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13369 /* vmlof */, SystemZ::VMLOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13375 /* vmlog */, SystemZ::VMLOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13381 /* vmloh */, SystemZ::VMLOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13387 /* vmlq */, SystemZ::VMLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13392 /* vmn */, SystemZ::VMN, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13396 /* vmnb */, SystemZ::VMNB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13401 /* vmnf */, SystemZ::VMNF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13406 /* vmng */, SystemZ::VMNG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13411 /* vmnh */, SystemZ::VMNH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13416 /* vmnl */, SystemZ::VMNL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13421 /* vmnlb */, SystemZ::VMNLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13427 /* vmnlf */, SystemZ::VMNLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13433 /* vmnlg */, SystemZ::VMNLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13439 /* vmnlh */, SystemZ::VMNLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13445 /* vmnlq */, SystemZ::VMNLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13451 /* vmnq */, SystemZ::VMNQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13456 /* vmo */, SystemZ::VMO, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13460 /* vmob */, SystemZ::VMOB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13465 /* vmof */, SystemZ::VMOF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13470 /* vmog */, SystemZ::VMOG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13475 /* vmoh */, SystemZ::VMOH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13480 /* vmp */, SystemZ::VMP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13484 /* vmrh */, SystemZ::VMRH, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13489 /* vmrhb */, SystemZ::VMRHB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13495 /* vmrhf */, SystemZ::VMRHF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13501 /* vmrhg */, SystemZ::VMRHG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13507 /* vmrhh */, SystemZ::VMRHH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13513 /* vmrl */, SystemZ::VMRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13518 /* vmrlb */, SystemZ::VMRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13524 /* vmrlf */, SystemZ::VMRLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13530 /* vmrlg */, SystemZ::VMRLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13536 /* vmrlh */, SystemZ::VMRLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13542 /* vmsl */, SystemZ::VMSL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13547 /* vmslg */, SystemZ::VMSLG, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13553 /* vmsp */, SystemZ::VMSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13558 /* vmx */, SystemZ::VMX, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13562 /* vmxb */, SystemZ::VMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13567 /* vmxf */, SystemZ::VMXF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13572 /* vmxg */, SystemZ::VMXG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13577 /* vmxh */, SystemZ::VMXH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13582 /* vmxl */, SystemZ::VMXL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13587 /* vmxlb */, SystemZ::VMXLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13593 /* vmxlf */, SystemZ::VMXLF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13599 /* vmxlg */, SystemZ::VMXLG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13605 /* vmxlh */, SystemZ::VMXLH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13611 /* vmxlq */, SystemZ::VMXLQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13617 /* vmxq */, SystemZ::VMXQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13622 /* vn */, SystemZ::VN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13625 /* vnc */, SystemZ::VNC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13629 /* vnn */, SystemZ::VNN, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13633 /* vno */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13637 /* vnot */, SystemZ::VNO, Convert__VR1281_0__VR1281_1__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 13642 /* vnx */, SystemZ::VNX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13646 /* vo */, SystemZ::VO, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13649 /* voc */, SystemZ::VOC, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13653 /* vone */, SystemZ::VONE, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 13658 /* vpdi */, SystemZ::VPDI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13663 /* vperm */, SystemZ::VPERM, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13669 /* vpk */, SystemZ::VPK, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13673 /* vpkf */, SystemZ::VPKF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13678 /* vpkg */, SystemZ::VPKG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13683 /* vpkh */, SystemZ::VPKH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13688 /* vpkls */, SystemZ::VPKLS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13694 /* vpklsf */, SystemZ::VPKLSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13701 /* vpklsfs */, SystemZ::VPKLSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13709 /* vpklsg */, SystemZ::VPKLSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13716 /* vpklsgs */, SystemZ::VPKLSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13724 /* vpklsh */, SystemZ::VPKLSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13731 /* vpklshs */, SystemZ::VPKLSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13739 /* vpks */, SystemZ::VPKS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13744 /* vpksf */, SystemZ::VPKSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13750 /* vpksfs */, SystemZ::VPKSFS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13757 /* vpksg */, SystemZ::VPKSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13763 /* vpksgs */, SystemZ::VPKSGS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13770 /* vpksh */, SystemZ::VPKSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13776 /* vpkshs */, SystemZ::VPKSHS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13783 /* vpkz */, SystemZ::VPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 13788 /* vpkzr */, SystemZ::VPKZR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13794 /* vpopct */, SystemZ::VPOPCT, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13801 /* vpopctb */, SystemZ::VPOPCTB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13809 /* vpopctf */, SystemZ::VPOPCTF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13817 /* vpopctg */, SystemZ::VPOPCTG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13825 /* vpopcth */, SystemZ::VPOPCTH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 13833 /* vpsop */, SystemZ::VPSOP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 13839 /* vr */, SystemZ::VR, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13842 /* vrep */, SystemZ::VREP, Convert__VR1281_0__VR1281_1__U16Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm, MCK_U4Imm }, },
  { 13847 /* vrepb */, SystemZ::VREPB, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13853 /* vrepf */, SystemZ::VREPF, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13859 /* vrepg */, SystemZ::VREPG, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13865 /* vreph */, SystemZ::VREPH, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 13871 /* vrepi */, SystemZ::VREPI, Convert__VR1281_0__S16Imm1_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm, MCK_U4Imm }, },
  { 13877 /* vrepib */, SystemZ::VREPIB, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13884 /* vrepif */, SystemZ::VREPIF, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13891 /* vrepig */, SystemZ::VREPIG, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13898 /* vrepih */, SystemZ::VREPIH, Convert__VR1281_0__S16Imm1_1, AMFBS_FeatureVector, { MCK_VR128, MCK_S16Imm }, },
  { 13905 /* vrf */, SystemZ::VRF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13909 /* vrg */, SystemZ::VRG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13913 /* vrl */, SystemZ::VRL, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 13917 /* vrlf */, SystemZ::VRLF, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13922 /* vrlg */, SystemZ::VRLG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13927 /* vrlq */, SystemZ::VRLQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13932 /* vrp */, SystemZ::VRP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 13936 /* vrq */, SystemZ::VRQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13940 /* vs */, SystemZ::VS, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13943 /* vsb */, SystemZ::VSB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13947 /* vsbcbi */, SystemZ::VSBCBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13954 /* vsbcbiq */, SystemZ::VSBCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13962 /* vsbi */, SystemZ::VSBI, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13967 /* vsbiq */, SystemZ::VSBIQ, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13973 /* vscbi */, SystemZ::VSCBI, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 13979 /* vscbib */, SystemZ::VSCBIB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13986 /* vscbif */, SystemZ::VSCBIF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 13993 /* vscbig */, SystemZ::VSCBIG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14000 /* vscbih */, SystemZ::VSCBIH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14007 /* vscbiq */, SystemZ::VSCBIQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14014 /* vscef */, SystemZ::VSCEF, Convert__VR1281_0__BDVAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U2Imm }, },
  { 14020 /* vsceg */, SystemZ::VSCEG, Convert__VR1281_0__BDVAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDVAddr64Disp12, MCK_U1Imm }, },
  { 14026 /* vschdp */, SystemZ::VSCHDP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14033 /* vschp */, SystemZ::VSCHP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14039 /* vschsp */, SystemZ::VSCHSP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14046 /* vschxp */, SystemZ::VSCHXP, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14053 /* vscshp */, SystemZ::VSCSHP, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14060 /* vsdp */, SystemZ::VSDP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14065 /* vseg */, SystemZ::VSEG, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14070 /* vsegb */, SystemZ::VSEGB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14076 /* vsegf */, SystemZ::VSEGF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14082 /* vsegh */, SystemZ::VSEGH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14088 /* vsel */, SystemZ::VSEL, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14093 /* vsf */, SystemZ::VSF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14097 /* vsg */, SystemZ::VSG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14101 /* vsh */, SystemZ::VSH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14105 /* vsl */, SystemZ::VSL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14109 /* vslb */, SystemZ::VSLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14114 /* vsld */, SystemZ::VSLD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14119 /* vsldb */, SystemZ::VSLDB, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14125 /* vsp */, SystemZ::VSP, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14129 /* vsq */, SystemZ::VSQ, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14133 /* vsra */, SystemZ::VSRA, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14138 /* vsrab */, SystemZ::VSRAB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14144 /* vsrd */, SystemZ::VSRD, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm }, },
  { 14149 /* vsrl */, SystemZ::VSRL, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14154 /* vsrlb */, SystemZ::VSRLB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14160 /* vsrp */, SystemZ::VSRP, Convert__VR1281_0__VR1281_1__U8Imm1_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U8Imm, MCK_U4Imm }, },
  { 14165 /* vsrpr */, SystemZ::VSRPR, Convert__VR1281_0__VR1281_1__VR1281_2__U8Imm1_3__U4Imm1_4, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U8Imm, MCK_U4Imm }, },
  { 14171 /* vst */, SystemZ::VST, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14171 /* vst */, SystemZ::VSTAlign, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14175 /* vstbr */, SystemZ::VSTBR, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14181 /* vstbrf */, SystemZ::VSTBRF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14188 /* vstbrg */, SystemZ::VSTBRG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14195 /* vstbrh */, SystemZ::VSTBRH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14202 /* vstbrq */, SystemZ::VSTBRQ, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14209 /* vsteb */, SystemZ::VSTEB, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14215 /* vstebrf */, SystemZ::VSTEBRF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14223 /* vstebrg */, SystemZ::VSTEBRG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14231 /* vstebrh */, SystemZ::VSTEBRH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14239 /* vstef */, SystemZ::VSTEF, Convert__VR1281_0__BDXAddr64Disp123_1__U2Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U2Imm }, },
  { 14245 /* vsteg */, SystemZ::VSTEG, Convert__VR1281_0__BDXAddr64Disp123_1__U1Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U1Imm }, },
  { 14251 /* vsteh */, SystemZ::VSTEH, Convert__VR1281_0__BDXAddr64Disp123_1__U3Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U3Imm }, },
  { 14257 /* vster */, SystemZ::VSTER, Convert__VR1281_0__BDXAddr64Disp123_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12, MCK_U4Imm }, },
  { 14263 /* vsterf */, SystemZ::VSTERF, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14270 /* vsterg */, SystemZ::VSTERG, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14277 /* vsterh */, SystemZ::VSTERH, Convert__VR1281_0__BDXAddr64Disp123_1, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_BDXAddr64Disp12 }, },
  { 14284 /* vstl */, SystemZ::VSTL, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14289 /* vstm */, SystemZ::VSTM, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12 }, },
  { 14289 /* vstm */, SystemZ::VSTMAlign, Convert__VR1281_0__VR1281_1__BDAddr64Disp122_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_BDAddr64Disp12, MCK_U4Imm }, },
  { 14294 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14294 /* vstrc */, SystemZ::VSTRC, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14300 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14300 /* vstrcb */, SystemZ::VSTRCB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14307 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14307 /* vstrcbs */, SystemZ::VSTRCBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14315 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14315 /* vstrcf */, SystemZ::VSTRCF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14322 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14322 /* vstrcfs */, SystemZ::VSTRCFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14330 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14330 /* vstrch */, SystemZ::VSTRCH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14337 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14337 /* vstrchs */, SystemZ::VSTRCHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14345 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14345 /* vstrczb */, SystemZ::VSTRCZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14353 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14353 /* vstrczbs */, SystemZ::VSTRCZBS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14362 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14362 /* vstrczf */, SystemZ::VSTRCZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14370 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14370 /* vstrczfs */, SystemZ::VSTRCZFS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14379 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14379 /* vstrczh */, SystemZ::VSTRCZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14387 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14387 /* vstrczhs */, SystemZ::VSTRCZHS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14396 /* vstrl */, SystemZ::VSTRL, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14402 /* vstrlr */, SystemZ::VSTRLR, Convert__VR1281_0__GR321_1__BDAddr64Disp122_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_GR32, MCK_BDAddr64Disp12 }, },
  { 14409 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14409 /* vstrs */, SystemZ::VSTRS, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4__U4Imm1_5, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14415 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14415 /* vstrsb */, SystemZ::VSTRSB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14422 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14422 /* vstrsf */, SystemZ::VSTRSF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14429 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__imm_95_0, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14429 /* vstrsh */, SystemZ::VSTRSH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3__U4Imm1_4, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14436 /* vstrszb */, SystemZ::VSTRSZB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14444 /* vstrszf */, SystemZ::VSTRSZF, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14452 /* vstrszh */, SystemZ::VSTRSZH, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14460 /* vsum */, SystemZ::VSUM, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14465 /* vsumb */, SystemZ::VSUMB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14471 /* vsumg */, SystemZ::VSUMG, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14477 /* vsumgf */, SystemZ::VSUMGF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14484 /* vsumgh */, SystemZ::VSUMGH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14491 /* vsumh */, SystemZ::VSUMH, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14497 /* vsumq */, SystemZ::VSUMQ, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14503 /* vsumqf */, SystemZ::VSUMQF, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14510 /* vsumqg */, SystemZ::VSUMQG, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14517 /* vtm */, SystemZ::VTM, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14521 /* vtp */, SystemZ::VTP, Convert__VR1281_0, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128 }, },
  { 14521 /* vtp */, SystemZ::VTPOpt, Convert__VR1281_0__U16Imm1_1, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_U16Imm }, },
  { 14525 /* vtz */, SystemZ::VTZ, Convert__VR1281_0__VR1281_1__U16Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement3, { MCK_VR128, MCK_VR128, MCK_U16Imm }, },
  { 14529 /* vuph */, SystemZ::VUPH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14534 /* vuphb */, SystemZ::VUPHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14540 /* vuphf */, SystemZ::VUPHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14546 /* vuphg */, SystemZ::VUPHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14552 /* vuphh */, SystemZ::VUPHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14558 /* vupkz */, SystemZ::VUPKZ, Convert__VR1281_0__BDAddr64Disp122_1__U8Imm1_2, AMFBS_FeatureVectorPackedDecimal, { MCK_VR128, MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 14564 /* vupkzh */, SystemZ::VUPKZH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14571 /* vupkzl */, SystemZ::VUPKZL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorPackedDecimalEnhancement2, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14578 /* vupl */, SystemZ::VUPL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14583 /* vuplb */, SystemZ::VUPLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14589 /* vuplf */, SystemZ::VUPLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14595 /* vuplg */, SystemZ::VUPLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14601 /* vuplh */, SystemZ::VUPLH, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14607 /* vuplhb */, SystemZ::VUPLHB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14614 /* vuplhf */, SystemZ::VUPLHF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14621 /* vuplhg */, SystemZ::VUPLHG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14628 /* vuplhh */, SystemZ::VUPLHH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14635 /* vuplhw */, SystemZ::VUPLHW, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14642 /* vupll */, SystemZ::VUPLL, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 14648 /* vupllb */, SystemZ::VUPLLB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14655 /* vupllf */, SystemZ::VUPLLF, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14662 /* vupllg */, SystemZ::VUPLLG, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements3, { MCK_VR128, MCK_VR128 }, },
  { 14669 /* vupllh */, SystemZ::VUPLLH, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128 }, },
  { 14676 /* vx */, SystemZ::VX, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVector, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14679 /* vzero */, SystemZ::VZERO, Convert__VR1281_0, AMFBS_FeatureVector, { MCK_VR128 }, },
  { 14685 /* wcdgb */, SystemZ::WCDGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14691 /* wcdlgb */, SystemZ::WCDLGB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14698 /* wcefb */, SystemZ::WCEFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14704 /* wcelfb */, SystemZ::WCELFB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14711 /* wcfeb */, SystemZ::WCFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14717 /* wcgdb */, SystemZ::WCGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14723 /* wclfeb */, SystemZ::WCLFEB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements2, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14730 /* wclgdb */, SystemZ::WCLGDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14737 /* wfadb */, SystemZ::WFADB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14743 /* wfasb */, SystemZ::WFASB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14749 /* wfaxb */, SystemZ::WFAXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14755 /* wfc */, SystemZ::WFC, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14759 /* wfcdb */, SystemZ::WFCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14765 /* wfcedb */, SystemZ::WFCEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14772 /* wfcedbs */, SystemZ::WFCEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14780 /* wfcesb */, SystemZ::WFCESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14787 /* wfcesbs */, SystemZ::WFCESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14795 /* wfcexb */, SystemZ::WFCEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14802 /* wfcexbs */, SystemZ::WFCEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14810 /* wfchdb */, SystemZ::WFCHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14817 /* wfchdbs */, SystemZ::WFCHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14825 /* wfchedb */, SystemZ::WFCHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14833 /* wfchedbs */, SystemZ::WFCHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14842 /* wfchesb */, SystemZ::WFCHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14850 /* wfchesbs */, SystemZ::WFCHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14859 /* wfchexb */, SystemZ::WFCHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14867 /* wfchexbs */, SystemZ::WFCHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14876 /* wfchsb */, SystemZ::WFCHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14883 /* wfchsbs */, SystemZ::WFCHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14891 /* wfchxb */, SystemZ::WFCHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14898 /* wfchxbs */, SystemZ::WFCHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14906 /* wfcsb */, SystemZ::WFCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 14912 /* wfcxb */, SystemZ::WFCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 14918 /* wfddb */, SystemZ::WFDDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14924 /* wfdsb */, SystemZ::WFDSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14930 /* wfdxb */, SystemZ::WFDXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 14936 /* wfidb */, SystemZ::WFIDB, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14942 /* wfisb */, SystemZ::WFISB, Convert__VR321_0__VR321_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm, MCK_U4Imm }, },
  { 14948 /* wfixb */, SystemZ::WFIXB, Convert__VR1281_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 14954 /* wfk */, SystemZ::WFK, Convert__VR641_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 14958 /* wfkdb */, SystemZ::WFKDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 14964 /* wfkedb */, SystemZ::WFKEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14971 /* wfkedbs */, SystemZ::WFKEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 14979 /* wfkesb */, SystemZ::WFKESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14986 /* wfkesbs */, SystemZ::WFKESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 14994 /* wfkexb */, SystemZ::WFKEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15001 /* wfkexbs */, SystemZ::WFKEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15009 /* wfkhdb */, SystemZ::WFKHDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15016 /* wfkhdbs */, SystemZ::WFKHDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15024 /* wfkhedb */, SystemZ::WFKHEDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15032 /* wfkhedbs */, SystemZ::WFKHEDBS, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15041 /* wfkhesb */, SystemZ::WFKHESB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15049 /* wfkhesbs */, SystemZ::WFKHESBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15058 /* wfkhexb */, SystemZ::WFKHEXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15066 /* wfkhexbs */, SystemZ::WFKHEXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15075 /* wfkhsb */, SystemZ::WFKHSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15082 /* wfkhsbs */, SystemZ::WFKHSBS, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15090 /* wfkhxb */, SystemZ::WFKHXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15097 /* wfkhxbs */, SystemZ::WFKHXBS, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15105 /* wfksb */, SystemZ::WFKSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15111 /* wfkxb */, SystemZ::WFKXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15117 /* wflcdb */, SystemZ::WFLCDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15124 /* wflcsb */, SystemZ::WFLCSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15131 /* wflcxb */, SystemZ::WFLCXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15138 /* wflld */, SystemZ::WFLLD, Convert__VR1281_0__VR641_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR64 }, },
  { 15144 /* wflls */, SystemZ::WFLLS, Convert__VR641_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR32 }, },
  { 15150 /* wflndb */, SystemZ::WFLNDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15157 /* wflnsb */, SystemZ::WFLNSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15164 /* wflnxb */, SystemZ::WFLNXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15171 /* wflpdb */, SystemZ::WFLPDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15178 /* wflpsb */, SystemZ::WFLPSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15185 /* wflpxb */, SystemZ::WFLPXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15192 /* wflrd */, SystemZ::WFLRD, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15198 /* wflrx */, SystemZ::WFLRX, Convert__VR641_0__VR1281_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR128, MCK_U4Imm, MCK_U4Imm }, },
  { 15204 /* wfmadb */, SystemZ::WFMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15211 /* wfmasb */, SystemZ::WFMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15218 /* wfmaxb */, SystemZ::WFMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15225 /* wfmaxdb */, SystemZ::WFMAXDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15233 /* wfmaxsb */, SystemZ::WFMAXSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15241 /* wfmaxxb */, SystemZ::WFMAXXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15249 /* wfmdb */, SystemZ::WFMDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15255 /* wfmindb */, SystemZ::WFMINDB, Convert__VR641_0__VR641_1__VR641_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15263 /* wfminsb */, SystemZ::WFMINSB, Convert__VR321_0__VR321_1__VR321_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15271 /* wfminxb */, SystemZ::WFMINXB, Convert__VR1281_0__VR1281_1__VR1281_2__U4Imm1_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15279 /* wfmsb */, SystemZ::WFMSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15285 /* wfmsdb */, SystemZ::WFMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15292 /* wfmssb */, SystemZ::WFMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15299 /* wfmsxb */, SystemZ::WFMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15306 /* wfmxb */, SystemZ::WFMXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15312 /* wfnmadb */, SystemZ::WFNMADB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15320 /* wfnmasb */, SystemZ::WFNMASB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15328 /* wfnmaxb */, SystemZ::WFNMAXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15336 /* wfnmsdb */, SystemZ::WFNMSDB, Convert__VR641_0__VR641_1__VR641_2__VR641_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR64, MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15344 /* wfnmssb */, SystemZ::WFNMSSB, Convert__VR321_0__VR321_1__VR321_2__VR321_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15352 /* wfnmsxb */, SystemZ::WFNMSXB, Convert__VR1281_0__VR1281_1__VR1281_2__VR1281_3, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15360 /* wfpsodb */, SystemZ::WFPSODB, Convert__VR641_0__VR641_1__U4Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U4Imm }, },
  { 15368 /* wfpsosb */, SystemZ::WFPSOSB, Convert__VR321_0__VR321_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U4Imm }, },
  { 15376 /* wfpsoxb */, SystemZ::WFPSOXB, Convert__VR1281_0__VR1281_1__U4Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U4Imm }, },
  { 15384 /* wfsdb */, SystemZ::WFSDB, Convert__VR641_0__VR641_1__VR641_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_VR64 }, },
  { 15390 /* wfsqdb */, SystemZ::WFSQDB, Convert__VR641_0__VR641_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64 }, },
  { 15397 /* wfsqsb */, SystemZ::WFSQSB, Convert__VR321_0__VR321_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32 }, },
  { 15404 /* wfsqxb */, SystemZ::WFSQXB, Convert__VR1281_0__VR1281_1, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128 }, },
  { 15411 /* wfssb */, SystemZ::WFSSB, Convert__VR321_0__VR321_1__VR321_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_VR32 }, },
  { 15417 /* wfsxb */, SystemZ::WFSXB, Convert__VR1281_0__VR1281_1__VR1281_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_VR128 }, },
  { 15423 /* wftcidb */, SystemZ::WFTCIDB, Convert__VR641_0__VR641_1__U12Imm1_2, AMFBS_FeatureVector, { MCK_VR64, MCK_VR64, MCK_U12Imm }, },
  { 15431 /* wftcisb */, SystemZ::WFTCISB, Convert__VR321_0__VR321_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR32, MCK_VR32, MCK_U12Imm }, },
  { 15439 /* wftcixb */, SystemZ::WFTCIXB, Convert__VR1281_0__VR1281_1__U12Imm1_2, AMFBS_FeatureVectorEnhancements1, { MCK_VR128, MCK_VR128, MCK_U12Imm }, },
  { 15447 /* wldeb */, SystemZ::WLDEB, Convert__VR641_0__VR321_1, AMFBS_FeatureVector, { MCK_VR64, MCK_VR32 }, },
  { 15453 /* wledb */, SystemZ::WLEDB, Convert__VR321_0__VR641_1__U4Imm1_2__U4Imm1_3, AMFBS_FeatureVector, { MCK_VR32, MCK_VR64, MCK_U4Imm, MCK_U4Imm }, },
  { 15459 /* x */, SystemZ::X, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp123_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp12 }, },
  { 15461 /* xc */, SystemZ::XC, Convert__BDLAddr64Disp12Len83_0__BDAddr64Disp122_1, AMFBS_None, { MCK_BDLAddr64Disp12Len8, MCK_BDAddr64Disp12 }, },
  { 15464 /* xg */, SystemZ::XG, Convert__GR641_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR64, MCK_BDXAddr64Disp20 }, },
  { 15467 /* xgr */, SystemZ::XGR, Convert__GR641_0__Tie0_1_1__GR641_1, AMFBS_None, { MCK_GR64, MCK_GR64 }, },
  { 15471 /* xgrk */, SystemZ::XGRK, Convert__GR641_0__GR641_1__GR641_2, AMFBS_FeatureDistinctOps, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 15476 /* xi */, SystemZ::XI, Convert__BDAddr64Disp122_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp12, MCK_U8Imm }, },
  { 15479 /* xihf */, SystemZ::XIHF, Convert__GRH321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GRH32, MCK_U32Imm }, },
  { 15484 /* xilf */, SystemZ::XILF, Convert__GR321_0__Tie0_1_1__U32Imm1_1, AMFBS_None, { MCK_GR32, MCK_U32Imm }, },
  { 15489 /* xiy */, SystemZ::XIY, Convert__BDAddr64Disp202_0__U8Imm1_1, AMFBS_None, { MCK_BDAddr64Disp20, MCK_U8Imm }, },
  { 15493 /* xr */, SystemZ::XR, Convert__GR321_0__Tie0_1_1__GR321_1, AMFBS_None, { MCK_GR32, MCK_GR32 }, },
  { 15496 /* xrk */, SystemZ::XRK, Convert__GR321_0__GR321_1__GR321_2, AMFBS_FeatureDistinctOps, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 15500 /* xsch */, SystemZ::XSCH, Convert_NoOperands, AMFBS_None, {  }, },
  { 15505 /* xy */, SystemZ::XY, Convert__GR321_0__Tie0_1_1__BDXAddr64Disp203_1, AMFBS_None, { MCK_GR32, MCK_BDXAddr64Disp20 }, },
  { 15508 /* zap */, SystemZ::ZAP, Convert__BDLAddr64Disp12Len43_0__BDLAddr64Disp12Len43_1, AMFBS_None, { MCK_BDLAddr64Disp12Len4, MCK_BDLAddr64Disp12Len4 }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned SystemZAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 7) {
    ErrorInfo = 7;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((SystemZOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  case 1: Start = std::begin(MatchTable1); End = std::end(MatchTable1); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 6; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs(), *getContext().getAsmInfo()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[7028] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 0 /* a */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 0 /* a */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 0 /* a */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 0 /* a */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2 /* ad */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2 /* ad */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 2 /* ad */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2 /* ad */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 5 /* adb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 5 /* adb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 5 /* adb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 5 /* adb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 9 /* adbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 9 /* adbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 14 /* adr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 14 /* adr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 18 /* adtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 18 /* adtr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 23 /* adtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 23 /* adtra */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 29 /* ae */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 29 /* ae */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 29 /* ae */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 29 /* ae */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 32 /* aeb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 32 /* aeb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 32 /* aeb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 32 /* aeb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 36 /* aebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 36 /* aebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 41 /* aer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 41 /* aer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 45 /* afi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 45 /* afi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 49 /* ag */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 49 /* ag */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 49 /* ag */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 49 /* ag */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 52 /* agf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 52 /* agf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 52 /* agf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 52 /* agf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 56 /* agfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 56 /* agfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 61 /* agfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 61 /* agfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 61 /* agfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 61 /* agfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 66 /* agh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 66 /* agh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions2 },
  { 66 /* agh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 66 /* agh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions2 },
  { 70 /* aghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 70 /* aghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 75 /* aghik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 75 /* aghik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 81 /* agr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 81 /* agr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 85 /* agrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 85 /* agrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 90 /* agsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 90 /* agsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 95 /* ah */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 95 /* ah */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 95 /* ah */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 95 /* ah */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 98 /* ahhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 98 /* ahhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 104 /* ahhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 104 /* ahhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 104 /* ahhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 104 /* ahhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 110 /* ahi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 110 /* ahi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 114 /* ahik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 114 /* ahik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 119 /* ahy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 119 /* ahy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 119 /* ahy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 119 /* ahy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 123 /* aih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 123 /* aih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 127 /* al */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 127 /* al */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 127 /* al */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 127 /* al */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 130 /* alc */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 130 /* alc */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 130 /* alc */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 130 /* alc */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 134 /* alcg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 134 /* alcg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 134 /* alcg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 134 /* alcg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 139 /* alcgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 139 /* alcgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 145 /* alcr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 145 /* alcr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 150 /* alfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 150 /* alfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 155 /* alg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 155 /* alg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 155 /* alg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 155 /* alg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 159 /* algf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 159 /* algf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 159 /* algf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 159 /* algf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 164 /* algfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 164 /* algfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 170 /* algfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 170 /* algfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 170 /* algfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 170 /* algfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 176 /* alghsik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 176 /* alghsik */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 184 /* algr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 184 /* algr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 189 /* algrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 189 /* algrk */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureDistinctOps },
  { 195 /* algsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 195 /* algsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 201 /* alhhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 201 /* alhhhr */, 7 /* 0, 1, 2 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 208 /* alhhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 208 /* alhhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 208 /* alhhlr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 208 /* alhhlr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 215 /* alhsik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 215 /* alhsik */, 3 /* 0, 1 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 222 /* alr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 222 /* alr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 226 /* alrk */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 226 /* alrk */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 231 /* alsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 231 /* alsi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 236 /* alsih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 236 /* alsih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 242 /* alsihn */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 242 /* alsihn */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 249 /* aly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 249 /* aly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 249 /* aly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 249 /* aly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 253 /* ap */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 253 /* ap */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 256 /* ar */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 256 /* ar */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 259 /* ark */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 259 /* ark */, 7 /* 0, 1, 2 */, MCK_GR32, AMFBS_FeatureDistinctOps },
  { 263 /* asi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 263 /* asi */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 267 /* au */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 267 /* au */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 267 /* au */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 267 /* au */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 270 /* aur */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 270 /* aur */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 274 /* aw */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 274 /* aw */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 274 /* aw */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 274 /* aw */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 277 /* awr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 277 /* awr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 281 /* axbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 281 /* axbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 286 /* axr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 286 /* axr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 290 /* axtr */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_None },
  { 290 /* axtr */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_None },
  { 295 /* axtra */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 295 /* axtra */, 7 /* 0, 1, 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 301 /* ay */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 301 /* ay */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 301 /* ay */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 301 /* ay */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 304 /* b */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 304 /* b */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 306 /* bakr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 306 /* bakr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 311 /* bal */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 311 /* bal */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 311 /* bal */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 311 /* bal */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 315 /* balr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 315 /* balr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 315 /* balr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 315 /* balr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 320 /* bas */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 320 /* bas */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 320 /* bas */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 320 /* bas */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 324 /* basr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 324 /* basr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 324 /* basr */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 324 /* basr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 329 /* bassm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 329 /* bassm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 329 /* bassm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 329 /* bassm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 335 /* bc */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 335 /* bc */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 338 /* bcr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 338 /* bcr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 342 /* bct */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 342 /* bct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 342 /* bct */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 342 /* bct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 346 /* bctg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 346 /* bctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 346 /* bctg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 346 /* bctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 351 /* bctgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 351 /* bctgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 357 /* bctr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 357 /* bctr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 357 /* bctr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 357 /* bctr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 362 /* bdepg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 362 /* bdepg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 368 /* be */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 368 /* be */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 371 /* ber */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 371 /* ber */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 375 /* bextg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 375 /* bextg */, 7 /* 0, 1, 2 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 381 /* bh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 381 /* bh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 384 /* bhe */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 388 /* bher */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 393 /* bhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 393 /* bhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 397 /* bi */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 397 /* bi */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 400 /* bic */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 400 /* bic */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 404 /* bie */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 404 /* bie */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 408 /* bih */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 408 /* bih */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 412 /* bihe */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 417 /* bil */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 417 /* bil */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 421 /* bile */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 426 /* bilh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 431 /* bim */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 431 /* bim */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 435 /* bine */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 435 /* bine */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 440 /* binh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 440 /* binh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 445 /* binhe */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 451 /* binl */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 451 /* binl */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 456 /* binle */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 462 /* binlh */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 468 /* binm */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 468 /* binm */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 473 /* bino */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 473 /* bino */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 478 /* binp */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 478 /* binp */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 483 /* binz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 483 /* binz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 488 /* bio */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 488 /* bio */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 492 /* bip */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 492 /* bip */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 496 /* biz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 496 /* biz */, 1 /* 0 */, MCK_BDXAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions2 },
  { 500 /* bl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 500 /* bl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 503 /* ble */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 507 /* bler */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 512 /* blh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 516 /* blhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 521 /* blr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 521 /* blr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 525 /* bm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 525 /* bm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 528 /* bmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 528 /* bmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 532 /* bne */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 532 /* bne */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 536 /* bner */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 536 /* bner */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 541 /* bnh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 541 /* bnh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 545 /* bnhe */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 550 /* bnher */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 556 /* bnhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 556 /* bnhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 561 /* bnl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 561 /* bnl */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 565 /* bnle */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 570 /* bnler */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 576 /* bnlh */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 581 /* bnlhr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 587 /* bnlr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 587 /* bnlr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 592 /* bnm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 592 /* bnm */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 596 /* bnmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 596 /* bnmr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 601 /* bno */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 601 /* bno */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 605 /* bnor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 605 /* bnor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 610 /* bnp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 610 /* bnp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 614 /* bnpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 614 /* bnpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 619 /* bnz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 619 /* bnz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 623 /* bnzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 623 /* bnzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 628 /* bo */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 628 /* bo */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 631 /* bor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 631 /* bor */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 635 /* bp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 635 /* bp */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 638 /* bpp */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureExecutionHint },
  { 638 /* bpp */, 2 /* 1 */, MCK_PCRel16, AMFBS_FeatureExecutionHint },
  { 638 /* bpp */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureExecutionHint },
  { 638 /* bpp */, 2 /* 1 */, MCK_PCRel16, AMFBS_FeatureExecutionHint },
  { 642 /* bpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 642 /* bpr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 646 /* bprp */, 2 /* 1 */, MCK_PCRel12, AMFBS_FeatureExecutionHint },
  { 646 /* bprp */, 4 /* 2 */, MCK_PCRel24, AMFBS_FeatureExecutionHint },
  { 646 /* bprp */, 2 /* 1 */, MCK_PCRel12, AMFBS_FeatureExecutionHint },
  { 646 /* bprp */, 4 /* 2 */, MCK_PCRel24, AMFBS_FeatureExecutionHint },
  { 651 /* br */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 651 /* br */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 654 /* bras */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 654 /* bras */, 2 /* 1 */, MCK_PCRelTLS16, AMFBS_None },
  { 654 /* bras */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 654 /* bras */, 2 /* 1 */, MCK_PCRelTLS16, AMFBS_None },
  { 659 /* brasl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 659 /* brasl */, 2 /* 1 */, MCK_PCRelTLS32, AMFBS_None },
  { 659 /* brasl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 659 /* brasl */, 2 /* 1 */, MCK_PCRelTLS32, AMFBS_None },
  { 665 /* brc */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 665 /* brc */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 669 /* brcl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 669 /* brcl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 674 /* brct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 674 /* brct */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 674 /* brct */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 674 /* brct */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 679 /* brctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 679 /* brctg */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 679 /* brctg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 679 /* brctg */, 2 /* 1 */, MCK_PCRel16, AMFBS_None },
  { 685 /* brcth */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 685 /* brcth */, 2 /* 1 */, MCK_PCRel32, AMFBS_FeatureHighWord },
  { 685 /* brcth */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 685 /* brcth */, 2 /* 1 */, MCK_PCRel32, AMFBS_FeatureHighWord },
  { 691 /* brxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 691 /* brxh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 691 /* brxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 691 /* brxh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 696 /* brxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 696 /* brxhg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 696 /* brxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 696 /* brxhg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 702 /* brxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 702 /* brxle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 702 /* brxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 702 /* brxle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 708 /* brxlg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 708 /* brxlg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 708 /* brxlg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 708 /* brxlg */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 714 /* bsa */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 714 /* bsa */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 718 /* bsg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 718 /* bsg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 722 /* bsm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 722 /* bsm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 722 /* bsm */, 2 /* 1 */, MCK_ADDR64, AMFBS_None },
  { 722 /* bsm */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 726 /* bxh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 726 /* bxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 726 /* bxh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 726 /* bxh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 730 /* bxhg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 730 /* bxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 730 /* bxhg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 730 /* bxhg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 735 /* bxle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 735 /* bxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 735 /* bxle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 735 /* bxle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 740 /* bxleg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 740 /* bxleg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 740 /* bxleg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 740 /* bxleg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 746 /* bz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 746 /* bz */, 1 /* 0 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 749 /* bzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 749 /* bzr */, 1 /* 0 */, MCK_ADDR64, AMFBS_None },
  { 753 /* c */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 753 /* c */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 753 /* c */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 753 /* c */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 755 /* cal */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 755 /* cal */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureConcurrentFunctions },
  { 755 /* cal */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 755 /* cal */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureConcurrentFunctions },
  { 759 /* calg */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 759 /* calg */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 759 /* calg */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 759 /* calg */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 764 /* calgf */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 764 /* calgf */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 764 /* calgf */, 6 /* 1, 2 */, MCK_BDAddr64Disp12, AMFBS_FeatureConcurrentFunctions },
  { 764 /* calgf */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureConcurrentFunctions },
  { 770 /* cd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 770 /* cd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 770 /* cd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 770 /* cd */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 773 /* cdb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 773 /* cdb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 773 /* cdb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 773 /* cdb */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 777 /* cdbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 777 /* cdbr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 782 /* cdfbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 782 /* cdfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 782 /* cdfbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 782 /* cdfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 788 /* cdfbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 788 /* cdfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 788 /* cdfbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 788 /* cdfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 795 /* cdfr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 795 /* cdfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 795 /* cdfr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 795 /* cdfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 800 /* cdftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 800 /* cdftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 800 /* cdftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 800 /* cdftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 806 /* cdgbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 806 /* cdgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 806 /* cdgbr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 806 /* cdgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 812 /* cdgbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 812 /* cdgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 812 /* cdgbra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 812 /* cdgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 819 /* cdgr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 819 /* cdgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 819 /* cdgr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 819 /* cdgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 824 /* cdgtr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 824 /* cdgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 824 /* cdgtr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 824 /* cdgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 830 /* cdgtra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 830 /* cdgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 830 /* cdgtra */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 830 /* cdgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 837 /* cdlfbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 837 /* cdlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 837 /* cdlfbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 837 /* cdlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 844 /* cdlftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 844 /* cdlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 844 /* cdlftr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 844 /* cdlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 851 /* cdlgbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 851 /* cdlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 851 /* cdlgbr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 851 /* cdlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 858 /* cdlgtr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 858 /* cdlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 858 /* cdlgtr */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 858 /* cdlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 865 /* cdpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 865 /* cdpt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 865 /* cdpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 865 /* cdpt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 870 /* cdr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 870 /* cdr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 874 /* cds */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 874 /* cds */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 874 /* cds */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 874 /* cds */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 878 /* cdsg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 878 /* cdsg */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 878 /* cdsg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 878 /* cdsg */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 883 /* cdstr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 883 /* cdstr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 883 /* cdstr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 883 /* cdstr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 889 /* cdsy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 889 /* cdsy */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 889 /* cdsy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 889 /* cdsy */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 894 /* cdtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 894 /* cdtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 899 /* cdutr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 899 /* cdutr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 899 /* cdutr */, 1 /* 0 */, MCK_FP64, AMFBS_None },
  { 899 /* cdutr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 905 /* cdzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 905 /* cdzt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 905 /* cdzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 905 /* cdzt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 910 /* ce */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 910 /* ce */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 910 /* ce */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 910 /* ce */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 913 /* ceb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 913 /* ceb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 913 /* ceb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 913 /* ceb */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 917 /* cebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 917 /* cebr */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 922 /* cedtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 922 /* cedtr */, 3 /* 0, 1 */, MCK_FP64, AMFBS_None },
  { 928 /* cefbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 928 /* cefbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 928 /* cefbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 928 /* cefbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 934 /* cefbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 934 /* cefbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 934 /* cefbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 934 /* cefbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 941 /* cefr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 941 /* cefr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 941 /* cefr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 941 /* cefr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 946 /* cegbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 946 /* cegbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 946 /* cegbr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 946 /* cegbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 952 /* cegbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 952 /* cegbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 952 /* cegbra */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 952 /* cegbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 959 /* cegr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 959 /* cegr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 959 /* cegr */, 1 /* 0 */, MCK_FP32, AMFBS_None },
  { 959 /* cegr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 964 /* celfbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 964 /* celfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 964 /* celfbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 964 /* celfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 971 /* celgbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 971 /* celgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 971 /* celgbr */, 1 /* 0 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 971 /* celgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 978 /* cer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 978 /* cer */, 3 /* 0, 1 */, MCK_FP32, AMFBS_None },
  { 982 /* cextr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 982 /* cextr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 988 /* cfc */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 988 /* cfc */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 992 /* cfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 992 /* cfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 992 /* cfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 992 /* cfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 998 /* cfdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 998 /* cfdbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 998 /* cfdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 998 /* cfdbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1005 /* cfdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1005 /* cfdr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1005 /* cfdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1005 /* cfdr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1010 /* cfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1010 /* cfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1010 /* cfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1010 /* cfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1016 /* cfebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1016 /* cfebr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1016 /* cfebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1016 /* cfebr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1022 /* cfebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1022 /* cfebra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1022 /* cfebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1022 /* cfebra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1029 /* cfer */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1029 /* cfer */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1029 /* cfer */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1029 /* cfer */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1034 /* cfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1034 /* cfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1038 /* cfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1038 /* cfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1038 /* cfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1038 /* cfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1044 /* cfxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1044 /* cfxbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1044 /* cfxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1044 /* cfxbra */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1051 /* cfxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1051 /* cfxr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1051 /* cfxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1051 /* cfxr */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1056 /* cfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1056 /* cfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1056 /* cfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1056 /* cfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 1062 /* cg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1062 /* cg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1062 /* cg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1062 /* cg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1065 /* cgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1065 /* cgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1065 /* cgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1065 /* cgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1071 /* cgdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1071 /* cgdbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1071 /* cgdbra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1071 /* cgdbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1078 /* cgdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1078 /* cgdr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1078 /* cgdr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1078 /* cgdr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1083 /* cgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1083 /* cgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1083 /* cgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_None },
  { 1083 /* cgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1089 /* cgdtra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1089 /* cgdtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1089 /* cgdtra */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 1089 /* cgdtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1096 /* cgebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1096 /* cgebr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1096 /* cgebr */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1096 /* cgebr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1102 /* cgebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1102 /* cgebra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1102 /* cgebra */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 1102 /* cgebra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1109 /* cger */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1109 /* cger */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1109 /* cger */, 4 /* 2 */, MCK_FP32, AMFBS_None },
  { 1109 /* cger */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1114 /* cgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1114 /* cgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1114 /* cgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1114 /* cgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1118 /* cgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1118 /* cgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1123 /* cgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 1123 /* cgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1123 /* cgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 1123 /* cgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1128 /* cgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1128 /* cgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1128 /* cgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1128 /* cgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1134 /* cgh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1134 /* cgh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1134 /* cgh */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1134 /* cgh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1138 /* cghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1138 /* cghi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1143 /* cghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1143 /* cghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1143 /* cghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1143 /* cghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1149 /* cghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1149 /* cghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1155 /* cgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1155 /* cgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1155 /* cgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1155 /* cgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1160 /* cgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1160 /* cgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1160 /* cgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1160 /* cgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1166 /* cgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1166 /* cgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1166 /* cgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1166 /* cgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1172 /* cgibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1172 /* cgibhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1179 /* cgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1179 /* cgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1179 /* cgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1179 /* cgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1185 /* cgible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1185 /* cgible */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1192 /* cgiblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1192 /* cgiblh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1199 /* cgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1199 /* cgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1199 /* cgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1199 /* cgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1206 /* cgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1206 /* cgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1206 /* cgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1206 /* cgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1213 /* cgibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1213 /* cgibnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1221 /* cgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1221 /* cgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1221 /* cgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1221 /* cgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1228 /* cgibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1228 /* cgibnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1236 /* cgibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1236 /* cgibnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1244 /* cgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1244 /* cgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1244 /* cgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1244 /* cgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1249 /* cgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1249 /* cgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1249 /* cgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1249 /* cgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1255 /* cgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1255 /* cgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1255 /* cgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1255 /* cgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1261 /* cgijhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1261 /* cgijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1268 /* cgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1268 /* cgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1268 /* cgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1268 /* cgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1274 /* cgijle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1274 /* cgijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1281 /* cgijlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1281 /* cgijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1288 /* cgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1288 /* cgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1288 /* cgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1288 /* cgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1295 /* cgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1295 /* cgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1295 /* cgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1295 /* cgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1302 /* cgijnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1302 /* cgijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1310 /* cgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1310 /* cgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1310 /* cgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1310 /* cgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1317 /* cgijnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1317 /* cgijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1325 /* cgijnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1325 /* cgijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1333 /* cgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1333 /* cgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1338 /* cgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1338 /* cgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1344 /* cgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1344 /* cgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1350 /* cgithe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1357 /* cgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1357 /* cgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1363 /* cgitle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1370 /* cgitlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1377 /* cgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1377 /* cgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1384 /* cgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1384 /* cgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1391 /* cgitnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1399 /* cgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1399 /* cgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1406 /* cgitnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1414 /* cgitnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1422 /* cgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1422 /* cgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1426 /* cgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1426 /* cgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1426 /* cgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1426 /* cgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1431 /* cgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1431 /* cgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1431 /* cgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1431 /* cgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1437 /* cgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1437 /* cgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1437 /* cgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1437 /* cgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1443 /* cgrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1443 /* cgrbhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1450 /* cgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1450 /* cgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1450 /* cgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1450 /* cgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1456 /* cgrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1456 /* cgrble */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1463 /* cgrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1463 /* cgrblh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1470 /* cgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1470 /* cgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1470 /* cgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1470 /* cgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1477 /* cgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1477 /* cgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1477 /* cgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1477 /* cgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1484 /* cgrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1484 /* cgrbnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1492 /* cgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1492 /* cgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1492 /* cgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1492 /* cgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1499 /* cgrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1499 /* cgrbnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1507 /* cgrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1507 /* cgrbnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1515 /* cgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1515 /* cgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1515 /* cgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1515 /* cgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1520 /* cgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1520 /* cgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1520 /* cgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1520 /* cgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1526 /* cgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1526 /* cgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1526 /* cgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1526 /* cgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1532 /* cgrjhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1532 /* cgrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1539 /* cgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1539 /* cgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1539 /* cgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1539 /* cgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1545 /* cgrjle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1545 /* cgrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1552 /* cgrjlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1552 /* cgrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1559 /* cgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1559 /* cgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1559 /* cgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1559 /* cgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1566 /* cgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1566 /* cgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1566 /* cgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1566 /* cgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1573 /* cgrjnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1573 /* cgrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1581 /* cgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1581 /* cgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1581 /* cgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1581 /* cgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1588 /* cgrjnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1588 /* cgrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1596 /* cgrjnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1596 /* cgrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1604 /* cgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1604 /* cgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1604 /* cgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1604 /* cgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1609 /* cgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1609 /* cgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1614 /* cgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1614 /* cgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1620 /* cgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1620 /* cgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1626 /* cgrthe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1633 /* cgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1633 /* cgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1639 /* cgrtle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1646 /* cgrtlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1653 /* cgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1653 /* cgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1660 /* cgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1660 /* cgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1667 /* cgrtnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1675 /* cgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1675 /* cgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1682 /* cgrtnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1690 /* cgrtnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 1698 /* cgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1698 /* cgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1698 /* cgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1698 /* cgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1704 /* cgxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1704 /* cgxbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1704 /* cgxbra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1704 /* cgxbra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1711 /* cgxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1711 /* cgxr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1711 /* cgxr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1711 /* cgxr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1716 /* cgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1716 /* cgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1716 /* cgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_None },
  { 1716 /* cgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 1722 /* cgxtra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1722 /* cgxtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1722 /* cgxtra */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 1722 /* cgxtra */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 1729 /* ch */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1729 /* ch */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1729 /* ch */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 1729 /* ch */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1732 /* chf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 1732 /* chf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1732 /* chf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 1732 /* chf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1736 /* chhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1736 /* chhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1741 /* chhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1741 /* chhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1747 /* chi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1747 /* chi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1751 /* chlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 1751 /* chlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1751 /* chlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 1751 /* chlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1756 /* chrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1756 /* chrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1756 /* chrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1756 /* chrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 1761 /* chsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1761 /* chsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1766 /* chy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1766 /* chy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1766 /* chy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 1766 /* chy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1770 /* cib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1770 /* cib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1770 /* cib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1770 /* cib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1774 /* cibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1774 /* cibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1774 /* cibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1774 /* cibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1779 /* cibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1779 /* cibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1779 /* cibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1779 /* cibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1784 /* cibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1784 /* cibhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1790 /* cibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1790 /* cibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1790 /* cibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1790 /* cibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1795 /* cible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1795 /* cible */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1801 /* ciblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1801 /* ciblh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1807 /* cibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1807 /* cibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1807 /* cibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1807 /* cibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1813 /* cibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1813 /* cibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1813 /* cibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1813 /* cibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1819 /* cibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1819 /* cibnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1826 /* cibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1826 /* cibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1826 /* cibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1826 /* cibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1832 /* cibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1832 /* cibnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1839 /* cibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 1839 /* cibnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1846 /* cih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1846 /* cih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 1850 /* cij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1850 /* cij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1850 /* cij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1850 /* cij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 1854 /* cije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1854 /* cije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1854 /* cije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1854 /* cije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1859 /* cijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1859 /* cijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1859 /* cijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1859 /* cijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1864 /* cijhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1864 /* cijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1870 /* cijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1870 /* cijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1870 /* cijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1870 /* cijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1875 /* cijle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1875 /* cijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1881 /* cijlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1881 /* cijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1887 /* cijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1887 /* cijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1887 /* cijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1887 /* cijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1893 /* cijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1893 /* cijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1893 /* cijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1893 /* cijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1899 /* cijnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1899 /* cijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1906 /* cijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1906 /* cijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1906 /* cijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1906 /* cijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1912 /* cijnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1912 /* cijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1919 /* cijnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1919 /* cijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 1926 /* cit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1926 /* cit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1930 /* cite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1930 /* cite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1935 /* cith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1935 /* cith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1940 /* cithe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1946 /* citl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1946 /* citl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1951 /* citle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1957 /* citlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1963 /* citne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1963 /* citne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1969 /* citnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1969 /* citnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1975 /* citnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1982 /* citnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1982 /* citnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1988 /* citnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 1995 /* citnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2002 /* cksm */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 2002 /* cksm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2002 /* cksm */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 2002 /* cksm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2007 /* cl */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2007 /* cl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2007 /* cl */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 2007 /* cl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2010 /* clc */, 2 /* 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2010 /* clc */, 1 /* 0 */, MCK_BDLAddr64Disp12Len8, AMFBS_None },
  { 2010 /* clc */, 2 /* 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2010 /* clc */, 1 /* 0 */, MCK_BDLAddr64Disp12Len8, AMFBS_None },
  { 2014 /* clcl */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2014 /* clcl */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2019 /* clcle */, 4 /* 2 */, MCK_BDAddr32Disp12, AMFBS_None },
  { 2019 /* clcle */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2019 /* clcle */, 4 /* 2 */, MCK_BDAddr32Disp12, AMFBS_None },
  { 2019 /* clcle */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2025 /* clclu */, 4 /* 2 */, MCK_BDAddr32Disp20, AMFBS_None },
  { 2025 /* clclu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2025 /* clclu */, 4 /* 2 */, MCK_BDAddr32Disp20, AMFBS_None },
  { 2025 /* clclu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 2031 /* clfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2031 /* clfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2031 /* clfdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2031 /* clfdbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2038 /* clfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2038 /* clfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2038 /* clfdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2038 /* clfdtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2045 /* clfebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2045 /* clfebr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2045 /* clfebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2045 /* clfebr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2052 /* clfhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2052 /* clfhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2059 /* clfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2059 /* clfi */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2064 /* clfit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2064 /* clfit */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2070 /* clfite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2070 /* clfite */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2077 /* clfith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2077 /* clfith */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2084 /* clfithe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2092 /* clfitl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2092 /* clfitl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2099 /* clfitle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2107 /* clfitlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2115 /* clfitne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2115 /* clfitne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2123 /* clfitnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2123 /* clfitnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2131 /* clfitnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2140 /* clfitnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2140 /* clfitnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2148 /* clfitnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2157 /* clfitnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2166 /* clfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2166 /* clfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2166 /* clfxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2166 /* clfxbr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2173 /* clfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2173 /* clfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2173 /* clfxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2173 /* clfxtr */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 2180 /* clg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2180 /* clg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2180 /* clg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2180 /* clg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2184 /* clgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2184 /* clgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2184 /* clgdbr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2184 /* clgdbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2191 /* clgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2191 /* clgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2191 /* clgdtr */, 4 /* 2 */, MCK_FP64, AMFBS_FeatureFPExtension },
  { 2191 /* clgdtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2198 /* clgebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2198 /* clgebr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2198 /* clgebr */, 4 /* 2 */, MCK_FP32, AMFBS_FeatureFPExtension },
  { 2198 /* clgebr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2205 /* clgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2205 /* clgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2205 /* clgf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 2205 /* clgf */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2210 /* clgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2210 /* clgfi */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2216 /* clgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 2216 /* clgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2216 /* clgfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 2216 /* clgfr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2222 /* clgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2222 /* clgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2222 /* clgfrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2222 /* clgfrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2229 /* clghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2229 /* clghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2229 /* clghrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2229 /* clghrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2236 /* clghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2236 /* clghsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2243 /* clgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2243 /* clgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2243 /* clgib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2243 /* clgib */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2249 /* clgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2249 /* clgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2249 /* clgibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2249 /* clgibe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2256 /* clgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2256 /* clgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2256 /* clgibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2256 /* clgibh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2263 /* clgibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2263 /* clgibhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2271 /* clgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2271 /* clgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2271 /* clgibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2271 /* clgibl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2278 /* clgible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2278 /* clgible */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2286 /* clgiblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2286 /* clgiblh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2294 /* clgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2294 /* clgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2294 /* clgibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2294 /* clgibne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2302 /* clgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2302 /* clgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2302 /* clgibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2302 /* clgibnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2310 /* clgibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2310 /* clgibnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2319 /* clgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2319 /* clgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2319 /* clgibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2319 /* clgibnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2327 /* clgibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2327 /* clgibnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2336 /* clgibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2336 /* clgibnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2345 /* clgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2345 /* clgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2345 /* clgij */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2345 /* clgij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2351 /* clgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2351 /* clgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2351 /* clgije */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2351 /* clgije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2358 /* clgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2358 /* clgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2358 /* clgijh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2358 /* clgijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2365 /* clgijhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2365 /* clgijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2373 /* clgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2373 /* clgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2373 /* clgijl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2373 /* clgijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2380 /* clgijle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2380 /* clgijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2388 /* clgijlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2388 /* clgijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2396 /* clgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2396 /* clgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2396 /* clgijne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2396 /* clgijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2404 /* clgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2404 /* clgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2404 /* clgijnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2404 /* clgijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2412 /* clgijnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2412 /* clgijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2421 /* clgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2421 /* clgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2421 /* clgijnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2421 /* clgijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2429 /* clgijnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2429 /* clgijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2438 /* clgijnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2438 /* clgijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2447 /* clgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2447 /* clgit */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2453 /* clgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2453 /* clgite */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2460 /* clgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2460 /* clgith */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2467 /* clgithe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2475 /* clgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2475 /* clgitl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2482 /* clgitle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2490 /* clgitlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2498 /* clgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2498 /* clgitne */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2506 /* clgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2506 /* clgitnh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2514 /* clgitnhe */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2523 /* clgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2523 /* clgitnl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2531 /* clgitnle */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2540 /* clgitnlh */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2549 /* clgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2549 /* clgr */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2554 /* clgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2554 /* clgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2554 /* clgrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2554 /* clgrb */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2560 /* clgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2560 /* clgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2560 /* clgrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2560 /* clgrbe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2567 /* clgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2567 /* clgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2567 /* clgrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2567 /* clgrbh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2574 /* clgrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2574 /* clgrbhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2582 /* clgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2582 /* clgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2582 /* clgrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2582 /* clgrbl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2589 /* clgrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2589 /* clgrble */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2597 /* clgrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2597 /* clgrblh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2605 /* clgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2605 /* clgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2605 /* clgrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2605 /* clgrbne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2613 /* clgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2613 /* clgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2613 /* clgrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2613 /* clgrbnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2621 /* clgrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2621 /* clgrbnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2630 /* clgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2630 /* clgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2630 /* clgrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2630 /* clgrbnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2638 /* clgrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2638 /* clgrbnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2647 /* clgrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2647 /* clgrbnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2656 /* clgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2656 /* clgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2656 /* clgrj */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2656 /* clgrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 2662 /* clgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2662 /* clgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2662 /* clgrje */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2662 /* clgrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2669 /* clgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2669 /* clgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2669 /* clgrjh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2669 /* clgrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2676 /* clgrjhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2676 /* clgrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2684 /* clgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2684 /* clgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2684 /* clgrjl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2684 /* clgrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2691 /* clgrjle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2691 /* clgrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2699 /* clgrjlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2699 /* clgrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2707 /* clgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2707 /* clgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2707 /* clgrjne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2707 /* clgrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2715 /* clgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2715 /* clgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2715 /* clgrjnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2715 /* clgrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2723 /* clgrjnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2723 /* clgrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2732 /* clgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2732 /* clgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2732 /* clgrjnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2732 /* clgrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2740 /* clgrjnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2740 /* clgrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2749 /* clgrjnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2749 /* clgrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 2758 /* clgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2758 /* clgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2758 /* clgrl */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 2758 /* clgrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2764 /* clgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2764 /* clgrt */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2770 /* clgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2770 /* clgrte */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2777 /* clgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2777 /* clgrth */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2784 /* clgrthe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2792 /* clgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2792 /* clgrtl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2799 /* clgrtle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2807 /* clgrtlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2815 /* clgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2815 /* clgrtne */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2823 /* clgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2823 /* clgrtnh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2831 /* clgrtnhe */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2840 /* clgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2840 /* clgrtnl */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2848 /* clgrtnle */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2857 /* clgrtnlh */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 2866 /* clgt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2866 /* clgt */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2866 /* clgt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2866 /* clgt */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2871 /* clgte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2871 /* clgte */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2871 /* clgte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2871 /* clgte */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2877 /* clgth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2877 /* clgth */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2877 /* clgth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2877 /* clgth */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2883 /* clgthe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2883 /* clgthe */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2890 /* clgtl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2890 /* clgtl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2890 /* clgtl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2890 /* clgtl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2896 /* clgtle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2896 /* clgtle */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2903 /* clgtlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2903 /* clgtlh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2910 /* clgtne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2910 /* clgtne */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2910 /* clgtne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2910 /* clgtne */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2917 /* clgtnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2917 /* clgtnh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2917 /* clgtnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2917 /* clgtnh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2924 /* clgtnhe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2924 /* clgtnhe */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2932 /* clgtnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2932 /* clgtnl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2932 /* clgtnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2932 /* clgtnl */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2939 /* clgtnle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2939 /* clgtnle */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2947 /* clgtnlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 2947 /* clgtnlh */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions },
  { 2955 /* clgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2955 /* clgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2955 /* clgxbr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2955 /* clgxbr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2962 /* clgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2962 /* clgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2962 /* clgxtr */, 4 /* 2 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 2962 /* clgxtr */, 1 /* 0 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 2969 /* clhf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 2969 /* clhf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2969 /* clhf */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_FeatureHighWord },
  { 2969 /* clhf */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2974 /* clhhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2974 /* clhhr */, 3 /* 0, 1 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2980 /* clhhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2980 /* clhhsi */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2987 /* clhlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 2987 /* clhlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2987 /* clhlr */, 2 /* 1 */, MCK_GR32, AMFBS_FeatureHighWord },
  { 2987 /* clhlr */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 2993 /* clhrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2993 /* clhrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2993 /* clhrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 2993 /* clhrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 2999 /* cli */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 2999 /* cli */, 1 /* 0 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3003 /* clib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3003 /* clib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3003 /* clib */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3003 /* clib */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3008 /* clibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3008 /* clibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3008 /* clibe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3008 /* clibe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3014 /* clibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3014 /* clibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3014 /* clibh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3014 /* clibh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3020 /* clibhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3020 /* clibhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3027 /* clibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3027 /* clibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3027 /* clibl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3027 /* clibl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3033 /* clible */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3033 /* clible */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3040 /* cliblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3040 /* cliblh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3047 /* clibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3047 /* clibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3047 /* clibne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3047 /* clibne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3054 /* clibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3054 /* clibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3054 /* clibnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3054 /* clibnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3061 /* clibnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3061 /* clibnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3069 /* clibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3069 /* clibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3069 /* clibnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3069 /* clibnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3076 /* clibnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3076 /* clibnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3084 /* clibnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3084 /* clibnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3092 /* clih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 3092 /* clih */, 1 /* 0 */, MCK_GRH32, AMFBS_FeatureHighWord },
  { 3097 /* clij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3097 /* clij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3097 /* clij */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3097 /* clij */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3102 /* clije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3102 /* clije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3102 /* clije */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3102 /* clije */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3108 /* clijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3108 /* clijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3108 /* clijh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3108 /* clijh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3114 /* clijhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3114 /* clijhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3121 /* clijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3121 /* clijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3121 /* clijl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3121 /* clijl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3127 /* clijle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3127 /* clijle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3134 /* clijlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3134 /* clijlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3141 /* clijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3141 /* clijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3141 /* clijne */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3141 /* clijne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3148 /* clijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3148 /* clijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3148 /* clijnh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3148 /* clijnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3155 /* clijnhe */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3155 /* clijnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3163 /* clijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3163 /* clijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3163 /* clijnl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3163 /* clijnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3170 /* clijnle */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3170 /* clijnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3178 /* clijnlh */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3178 /* clijnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3186 /* cliy */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3186 /* cliy */, 1 /* 0 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3191 /* clm */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3191 /* clm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3191 /* clm */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3191 /* clm */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3195 /* clmh */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3195 /* clmh */, 1 /* 0 */, MCK_GRH32, AMFBS_None },
  { 3195 /* clmh */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3195 /* clmh */, 1 /* 0 */, MCK_GRH32, AMFBS_None },
  { 3200 /* clmy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3200 /* clmy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3200 /* clmy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3200 /* clmy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3205 /* clr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3205 /* clr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3209 /* clrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3209 /* clrb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3209 /* clrb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3209 /* clrb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3214 /* clrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3214 /* clrbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3214 /* clrbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3214 /* clrbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3220 /* clrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3220 /* clrbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3220 /* clrbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3220 /* clrbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3226 /* clrbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3226 /* clrbhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3233 /* clrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3233 /* clrbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3233 /* clrbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3233 /* clrbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3239 /* clrble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3239 /* clrble */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3246 /* clrblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3246 /* clrblh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3253 /* clrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3253 /* clrbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3253 /* clrbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3253 /* clrbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3260 /* clrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3260 /* clrbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3260 /* clrbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3260 /* clrbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3267 /* clrbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3267 /* clrbnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3275 /* clrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3275 /* clrbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3275 /* clrbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3275 /* clrbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3282 /* clrbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3282 /* clrbnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3290 /* clrbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3290 /* clrbnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3298 /* clrj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3298 /* clrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3298 /* clrj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3298 /* clrj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3303 /* clrje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3303 /* clrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3303 /* clrje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3303 /* clrje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3309 /* clrjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3309 /* clrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3309 /* clrjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3309 /* clrjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3315 /* clrjhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3315 /* clrjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3322 /* clrjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3322 /* clrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3322 /* clrjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3322 /* clrjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3328 /* clrjle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3328 /* clrjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3335 /* clrjlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3335 /* clrjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3342 /* clrjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3342 /* clrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3342 /* clrjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3342 /* clrjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3349 /* clrjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3349 /* clrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3349 /* clrjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3349 /* clrjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3356 /* clrjnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3356 /* clrjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3364 /* clrjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3364 /* clrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3364 /* clrjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3364 /* clrjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3371 /* clrjnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3371 /* clrjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3379 /* clrjnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3379 /* clrjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3387 /* clrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3387 /* clrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3387 /* clrl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3387 /* clrl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3392 /* clrt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3392 /* clrt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3397 /* clrte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3397 /* clrte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3403 /* clrth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3403 /* clrth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3409 /* clrthe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3416 /* clrtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3416 /* clrtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3422 /* clrtle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3429 /* clrtlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3436 /* clrtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3436 /* clrtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3443 /* clrtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3443 /* clrtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3450 /* clrtnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3458 /* clrtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3458 /* clrtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3465 /* clrtnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3473 /* clrtnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3481 /* clst */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3481 /* clst */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3486 /* clt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3486 /* clt */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3486 /* clt */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3486 /* clt */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3490 /* clte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3490 /* clte */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3490 /* clte */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3490 /* clte */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3495 /* clth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3495 /* clth */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3495 /* clth */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3495 /* clth */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3500 /* clthe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3500 /* clthe */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3506 /* cltl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3506 /* cltl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3506 /* cltl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3506 /* cltl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3511 /* cltle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3511 /* cltle */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3517 /* cltlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3517 /* cltlh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3523 /* cltne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3523 /* cltne */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3523 /* cltne */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3523 /* cltne */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3529 /* cltnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3529 /* cltnh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3529 /* cltnh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3529 /* cltnh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3535 /* cltnhe */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3535 /* cltnhe */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3542 /* cltnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3542 /* cltnl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3542 /* cltnl */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3542 /* cltnl */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3548 /* cltnle */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3548 /* cltnle */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3555 /* cltnlh */, 2 /* 1 */, MCK_BDAddr64Disp20, AMFBS_FeatureMiscellaneousExtensions },
  { 3555 /* cltnlh */, 1 /* 0 */, MCK_GR32, AMFBS_FeatureMiscellaneousExtensions },
  { 3562 /* cly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3562 /* cly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3562 /* cly */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3562 /* cly */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3566 /* clzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3566 /* clzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3571 /* cmpsc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3571 /* cmpsc */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3577 /* cp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 3577 /* cp */, 3 /* 0, 1 */, MCK_BDLAddr64Disp12Len4, AMFBS_None },
  { 3580 /* cpdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3580 /* cpdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 3580 /* cpdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3580 /* cpdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPPackedConversion },
  { 3585 /* cpsdr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 3585 /* cpsdr */, 7 /* 0, 1, 2 */, MCK_FP64, AMFBS_None },
  { 3591 /* cpxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3591 /* cpxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 3591 /* cpxt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 3591 /* cpxt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 3596 /* cpya */, 3 /* 0, 1 */, MCK_AR32, AMFBS_None },
  { 3596 /* cpya */, 3 /* 0, 1 */, MCK_AR32, AMFBS_None },
  { 3601 /* cr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3601 /* cr */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3604 /* crb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3604 /* crb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3604 /* crb */, 8 /* 3 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3604 /* crb */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3608 /* crbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3608 /* crbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3608 /* crbe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3608 /* crbe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3613 /* crbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3613 /* crbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3613 /* crbh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3613 /* crbh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3618 /* crbhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3618 /* crbhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3624 /* crbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3624 /* crbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3624 /* crbl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3624 /* crbl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3629 /* crble */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3629 /* crble */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3635 /* crblh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3635 /* crblh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3641 /* crbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3641 /* crbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3641 /* crbne */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3641 /* crbne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3647 /* crbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3647 /* crbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3647 /* crbnh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3647 /* crbnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3653 /* crbnhe */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3653 /* crbnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3660 /* crbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3660 /* crbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3660 /* crbnl */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3660 /* crbnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3666 /* crbnle */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3666 /* crbnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3673 /* crbnlh */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3673 /* crbnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3680 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 5 /* 0, 2 */, MCK_GR128, AMFBS_FeatureEnhancedDAT2 },
  { 3680 /* crdte */, 2 /* 1 */, MCK_GR64, AMFBS_FeatureEnhancedDAT2 },
  { 3686 /* crj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3686 /* crj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3686 /* crj */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3686 /* crj */, 8 /* 3 */, MCK_PCRel16, AMFBS_None },
  { 3690 /* crje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3690 /* crje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3690 /* crje */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3690 /* crje */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3695 /* crjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3695 /* crjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3695 /* crjh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3695 /* crjh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3700 /* crjhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3700 /* crjhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3706 /* crjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3706 /* crjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3706 /* crjl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3706 /* crjl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3711 /* crjle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3711 /* crjle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3717 /* crjlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3717 /* crjlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3723 /* crjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3723 /* crjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3723 /* crjne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3723 /* crjne */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3729 /* crjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3729 /* crjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3729 /* crjnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3729 /* crjnh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3735 /* crjnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3735 /* crjnhe */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3742 /* crjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3742 /* crjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3742 /* crjnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3742 /* crjnl */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3748 /* crjnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3748 /* crjnle */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3755 /* crjnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3755 /* crjnlh */, 4 /* 2 */, MCK_PCRel16, AMFBS_None },
  { 3762 /* crl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3762 /* crl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3762 /* crl */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3762 /* crl */, 2 /* 1 */, MCK_PCRel32, AMFBS_None },
  { 3766 /* crt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3766 /* crt */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3770 /* crte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3770 /* crte */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3775 /* crth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3775 /* crth */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3780 /* crthe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3786 /* crtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3786 /* crtl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3791 /* crtle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3797 /* crtlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3803 /* crtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3803 /* crtne */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3809 /* crtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3809 /* crtnh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3815 /* crtnhe */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3822 /* crtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3822 /* crtnl */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3828 /* crtnle */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3835 /* crtnlh */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3842 /* cs */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3842 /* cs */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3842 /* cs */, 4 /* 2 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3842 /* cs */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3850 /* csdtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3850 /* csdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3850 /* csdtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3850 /* csdtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3856 /* csg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3856 /* csg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3856 /* csg */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3856 /* csg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_None },
  { 3860 /* csp */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3860 /* csp */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3860 /* csp */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3860 /* csp */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3864 /* cspg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3864 /* cspg */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3864 /* cspg */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3864 /* cspg */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 3869 /* csst */, 3 /* 0, 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3869 /* csst */, 4 /* 2 */, MCK_GR64, AMFBS_None },
  { 3869 /* csst */, 3 /* 0, 1 */, MCK_BDAddr64Disp12, AMFBS_None },
  { 3869 /* csst */, 4 /* 2 */, MCK_GR64, AMFBS_None },
  { 3874 /* csxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3874 /* csxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3874 /* csxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3874 /* csxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3880 /* csy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3880 /* csy */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3880 /* csy */, 4 /* 2 */, MCK_BDAddr64Disp20, AMFBS_None },
  { 3880 /* csy */, 3 /* 0, 1 */, MCK_GR32, AMFBS_None },
  { 3884 /* ctzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3884 /* ctzg */, 3 /* 0, 1 */, MCK_GR64, AMFBS_FeatureMiscellaneousExtensions4 },
  { 3889 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3889 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3889 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3889 /* cu12 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3894 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3894 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3894 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3894 /* cu14 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3899 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3899 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3899 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3899 /* cu21 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3904 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3904 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3904 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3904 /* cu24 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3909 /* cu41 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3909 /* cu41 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3914 /* cu42 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3914 /* cu42 */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3919 /* cudtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3919 /* cudtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3919 /* cudtr */, 2 /* 1 */, MCK_FP64, AMFBS_None },
  { 3919 /* cudtr */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3925 /* cuse */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3925 /* cuse */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3930 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3930 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3930 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3930 /* cutfu */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3936 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3936 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3936 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3936 /* cuutf */, 3 /* 0, 1 */, MCK_GR128, AMFBS_None },
  { 3942 /* cuxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3942 /* cuxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3942 /* cuxtr */, 2 /* 1 */, MCK_FP128, AMFBS_None },
  { 3942 /* cuxtr */, 1 /* 0 */, MCK_GR128, AMFBS_None },
  { 3948 /* cvb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3948 /* cvb */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3948 /* cvb */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3948 /* cvb */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3952 /* cvbg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3952 /* cvbg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3952 /* cvbg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3952 /* cvbg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3957 /* cvby */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3957 /* cvby */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3957 /* cvby */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3957 /* cvby */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3962 /* cvd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3962 /* cvd */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3962 /* cvd */, 2 /* 1 */, MCK_BDXAddr64Disp12, AMFBS_None },
  { 3962 /* cvd */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3966 /* cvdg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3966 /* cvdg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3966 /* cvdg */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3966 /* cvdg */, 1 /* 0 */, MCK_GR64, AMFBS_None },
  { 3971 /* cvdy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3971 /* cvdy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3971 /* cvdy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 3971 /* cvdy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 3976 /* cxbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 3976 /* cxbr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 3981 /* cxfbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3981 /* cxfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3981 /* cxfbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3981 /* cxfbr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3987 /* cxfbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3987 /* cxfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 3987 /* cxfbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3987 /* cxfbra */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 3994 /* cxfr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3994 /* cxfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3994 /* cxfr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 3994 /* cxfr */, 2 /* 1 */, MCK_GR32, AMFBS_None },
  { 3999 /* cxftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3999 /* cxftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 3999 /* cxftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 3999 /* cxftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4005 /* cxgbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4005 /* cxgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4005 /* cxgbr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4005 /* cxgbr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4011 /* cxgbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4011 /* cxgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4011 /* cxgbra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4011 /* cxgbra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4018 /* cxgr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4018 /* cxgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4018 /* cxgr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4018 /* cxgr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4023 /* cxgtr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4023 /* cxgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4023 /* cxgtr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4023 /* cxgtr */, 2 /* 1 */, MCK_GR64, AMFBS_None },
  { 4029 /* cxgtra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4029 /* cxgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4029 /* cxgtra */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4029 /* cxgtra */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4036 /* cxlfbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4036 /* cxlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4036 /* cxlfbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4036 /* cxlfbr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4043 /* cxlftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4043 /* cxlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4043 /* cxlftr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4043 /* cxlftr */, 4 /* 2 */, MCK_GR32, AMFBS_FeatureFPExtension },
  { 4050 /* cxlgbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4050 /* cxlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4050 /* cxlgbr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4050 /* cxlgbr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4057 /* cxlgtr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4057 /* cxlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4057 /* cxlgtr */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureFPExtension },
  { 4057 /* cxlgtr */, 4 /* 2 */, MCK_GR64, AMFBS_FeatureFPExtension },
  { 4064 /* cxpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 4064 /* cxpt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 4064 /* cxpt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPPackedConversion },
  { 4064 /* cxpt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPPackedConversion },
  { 4069 /* cxr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4069 /* cxr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4073 /* cxstr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4073 /* cxstr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4073 /* cxstr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4073 /* cxstr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4079 /* cxtr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4079 /* cxtr */, 3 /* 0, 1 */, MCK_FP128, AMFBS_None },
  { 4084 /* cxutr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4084 /* cxutr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4084 /* cxutr */, 1 /* 0 */, MCK_FP128, AMFBS_None },
  { 4084 /* cxutr */, 2 /* 1 */, MCK_GR128, AMFBS_None },
  { 4090 /* cxzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4090 /* cxzt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4090 /* cxzt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4090 /* cxzt */, 1 /* 0 */, MCK_FP128, AMFBS_FeatureDFPZonedConversion },
  { 4095 /* cy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4095 /* cy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 4095 /* cy */, 2 /* 1 */, MCK_BDXAddr64Disp20, AMFBS_None },
  { 4095 /* cy */, 1 /* 0 */, MCK_GR32, AMFBS_None },
  { 4098 /* czdt */, 2 /* 1 */, MCK_BDLAddr64Disp12Len8, AMFBS_FeatureDFPZonedConversion },
  { 4098 /* czdt */, 1 /* 0 */, MCK_FP64, AMFBS_FeatureDFPZonedConversion },
  { 4098 /* czdt */, 2 /* 1 */