/* parsed class NVC5B0 */

#include "nvtypes.h"
#include "clc5b0.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvc5b0_NOP {
    uint32_t parameter;
};

static inline void
__NVC5B0_NOP(uint32_t *val_out, struct nv_nvc5b0_NOP st)
{
    uint32_t val = 0;
    
    val |= st.parameter;
    *val_out = val;
}

#define V_NVC5B0_NOP(val, args...) { \
    struct nv_nvc5b0_NOP __data = { .parameter = (args) }; \
    __NVC5B0_NOP(&val, __data); \
}

#define VA_NVC5B0_NOP V_NVC5B0_NOP

#define P_NVC5B0_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_NOP, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_APPLICATION_ID {
    uint32_t id;
};

static inline void
__NVC5B0_SET_APPLICATION_ID(uint32_t *val_out, struct nv_nvc5b0_SET_APPLICATION_ID st)
{
    uint32_t val = 0;
    
    val |= st.id;
    *val_out = val;
}

#define V_NVC5B0_SET_APPLICATION_ID(val, args...) { \
    UNUSED uint32_t ID_MPEG12 = NVC5B0_SET_APPLICATION_ID_ID_MPEG12; \
    UNUSED uint32_t ID_VC1 = NVC5B0_SET_APPLICATION_ID_ID_VC1; \
    UNUSED uint32_t ID_H264 = NVC5B0_SET_APPLICATION_ID_ID_H264; \
    UNUSED uint32_t ID_MPEG4 = NVC5B0_SET_APPLICATION_ID_ID_MPEG4; \
    UNUSED uint32_t ID_VP8 = NVC5B0_SET_APPLICATION_ID_ID_VP8; \
    UNUSED uint32_t ID_HEVC = NVC5B0_SET_APPLICATION_ID_ID_HEVC; \
    UNUSED uint32_t ID_VP9 = NVC5B0_SET_APPLICATION_ID_ID_VP9; \
    UNUSED uint32_t ID_HEVC_PARSER = NVC5B0_SET_APPLICATION_ID_ID_HEVC_PARSER; \
    struct nv_nvc5b0_SET_APPLICATION_ID __data = { .id = (args) }; \
    __NVC5B0_SET_APPLICATION_ID(&val, __data); \
}

#define VA_NVC5B0_SET_APPLICATION_ID V_NVC5B0_SET_APPLICATION_ID

#define P_NVC5B0_SET_APPLICATION_ID(push, args...) do { \
    UNUSED uint32_t ID_MPEG12 = NVC5B0_SET_APPLICATION_ID_ID_MPEG12; \
    UNUSED uint32_t ID_VC1 = NVC5B0_SET_APPLICATION_ID_ID_VC1; \
    UNUSED uint32_t ID_H264 = NVC5B0_SET_APPLICATION_ID_ID_H264; \
    UNUSED uint32_t ID_MPEG4 = NVC5B0_SET_APPLICATION_ID_ID_MPEG4; \
    UNUSED uint32_t ID_VP8 = NVC5B0_SET_APPLICATION_ID_ID_VP8; \
    UNUSED uint32_t ID_HEVC = NVC5B0_SET_APPLICATION_ID_ID_HEVC; \
    UNUSED uint32_t ID_VP9 = NVC5B0_SET_APPLICATION_ID_ID_VP9; \
    UNUSED uint32_t ID_HEVC_PARSER = NVC5B0_SET_APPLICATION_ID_ID_HEVC_PARSER; \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_APPLICATION_ID(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_APPLICATION_ID, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_WATCHDOG_TIMER {
    uint32_t timer;
};

static inline void
__NVC5B0_SET_WATCHDOG_TIMER(uint32_t *val_out, struct nv_nvc5b0_SET_WATCHDOG_TIMER st)
{
    uint32_t val = 0;
    
    val |= st.timer;
    *val_out = val;
}

#define V_NVC5B0_SET_WATCHDOG_TIMER(val, args...) { \
    struct nv_nvc5b0_SET_WATCHDOG_TIMER __data = { .timer = (args) }; \
    __NVC5B0_SET_WATCHDOG_TIMER(&val, __data); \
}

#define VA_NVC5B0_SET_WATCHDOG_TIMER V_NVC5B0_SET_WATCHDOG_TIMER

#define P_NVC5B0_SET_WATCHDOG_TIMER(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_WATCHDOG_TIMER(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_WATCHDOG_TIMER, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SEMAPHORE_A {
    uint32_t upper;
};

static inline void
__NVC5B0_SEMAPHORE_A(uint32_t *val_out, struct nv_nvc5b0_SEMAPHORE_A st)
{
    uint32_t val = 0;
    
    assert(st.upper < (1ULL << 8));
    val |= st.upper << 0;
    *val_out = val;
}

#define V_NVC5B0_SEMAPHORE_A(val, args...) { \
    struct nv_nvc5b0_SEMAPHORE_A __data = { .upper = (args) }; \
    __NVC5B0_SEMAPHORE_A(&val, __data); \
}

#define VA_NVC5B0_SEMAPHORE_A V_NVC5B0_SEMAPHORE_A

#define P_NVC5B0_SEMAPHORE_A(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SEMAPHORE_A(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SEMAPHORE_A, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SEMAPHORE_B {
    uint32_t lower;
};

static inline void
__NVC5B0_SEMAPHORE_B(uint32_t *val_out, struct nv_nvc5b0_SEMAPHORE_B st)
{
    uint32_t val = 0;
    
    val |= st.lower;
    *val_out = val;
}

#define V_NVC5B0_SEMAPHORE_B(val, args...) { \
    struct nv_nvc5b0_SEMAPHORE_B __data = { .lower = (args) }; \
    __NVC5B0_SEMAPHORE_B(&val, __data); \
}

#define VA_NVC5B0_SEMAPHORE_B V_NVC5B0_SEMAPHORE_B

#define P_NVC5B0_SEMAPHORE_B(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SEMAPHORE_B(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SEMAPHORE_B, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SEMAPHORE_C {
    uint32_t payload;
};

static inline void
__NVC5B0_SEMAPHORE_C(uint32_t *val_out, struct nv_nvc5b0_SEMAPHORE_C st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVC5B0_SEMAPHORE_C(val, args...) { \
    struct nv_nvc5b0_SEMAPHORE_C __data = { .payload = (args) }; \
    __NVC5B0_SEMAPHORE_C(&val, __data); \
}

#define VA_NVC5B0_SEMAPHORE_C V_NVC5B0_SEMAPHORE_C

#define P_NVC5B0_SEMAPHORE_C(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SEMAPHORE_C(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SEMAPHORE_C, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_CTX_SAVE_AREA {
    uint32_t offset;
};

static inline void
__NVC5B0_CTX_SAVE_AREA(uint32_t *val_out, struct nv_nvc5b0_CTX_SAVE_AREA st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_CTX_SAVE_AREA(val, args...) { \
    struct nv_nvc5b0_CTX_SAVE_AREA __data = { .offset = (args) }; \
    __NVC5B0_CTX_SAVE_AREA(&val, __data); \
}

#define VA_NVC5B0_CTX_SAVE_AREA V_NVC5B0_CTX_SAVE_AREA

#define P_NVC5B0_CTX_SAVE_AREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_CTX_SAVE_AREA(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_CTX_SAVE_AREA, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_CTX_SWITCH {
    uint32_t op;
    uint32_t ctxid_valid;
    uint32_t reserved0;
    uint32_t ctx_id;
    uint32_t reserved1;
};

static inline void
__NVC5B0_CTX_SWITCH(uint32_t *val_out, struct nv_nvc5b0_CTX_SWITCH st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    
    assert(st.ctxid_valid < (1ULL << 1));
    val |= st.ctxid_valid << 2;
    
    assert(st.reserved0 < (1ULL << 5));
    val |= st.reserved0 << 3;
    
    assert(st.ctx_id < (1ULL << 16));
    val |= st.ctx_id << 8;
    
    assert(st.reserved1 < (1ULL << 8));
    val |= st.reserved1 << 24;
    *val_out = val;
}

#define V_NVC5B0_CTX_SWITCH(val, args...) { \
    UNUSED uint32_t OP_CTX_UPDATE = NVC5B0_CTX_SWITCH_OP_CTX_UPDATE; \
    UNUSED uint32_t OP_CTX_SAVE = NVC5B0_CTX_SWITCH_OP_CTX_SAVE; \
    UNUSED uint32_t OP_CTX_RESTORE = NVC5B0_CTX_SWITCH_OP_CTX_RESTORE; \
    UNUSED uint32_t OP_CTX_FORCERESTORE = NVC5B0_CTX_SWITCH_OP_CTX_FORCERESTORE; \
    UNUSED uint32_t CTXID_VALID_FALSE = NVC5B0_CTX_SWITCH_CTXID_VALID_FALSE; \
    UNUSED uint32_t CTXID_VALID_TRUE = NVC5B0_CTX_SWITCH_CTXID_VALID_TRUE; \
    struct nv_nvc5b0_CTX_SWITCH __data = args; \
    __NVC5B0_CTX_SWITCH(&val, __data); \
}

#define VA_NVC5B0_CTX_SWITCH V_NVC5B0_CTX_SWITCH

#define P_NVC5B0_CTX_SWITCH(push, args...) do { \
    UNUSED uint32_t OP_CTX_UPDATE = NVC5B0_CTX_SWITCH_OP_CTX_UPDATE; \
    UNUSED uint32_t OP_CTX_SAVE = NVC5B0_CTX_SWITCH_OP_CTX_SAVE; \
    UNUSED uint32_t OP_CTX_RESTORE = NVC5B0_CTX_SWITCH_OP_CTX_RESTORE; \
    UNUSED uint32_t OP_CTX_FORCERESTORE = NVC5B0_CTX_SWITCH_OP_CTX_FORCERESTORE; \
    UNUSED uint32_t CTXID_VALID_FALSE = NVC5B0_CTX_SWITCH_CTXID_VALID_FALSE; \
    UNUSED uint32_t CTXID_VALID_TRUE = NVC5B0_CTX_SWITCH_CTXID_VALID_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC5B0_CTX_SWITCH(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_CTX_SWITCH, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_EXECUTE {
    uint32_t notify;
    uint32_t notify_on;
    uint32_t awaken;
};

static inline void
__NVC5B0_EXECUTE(uint32_t *val_out, struct nv_nvc5b0_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.notify < (1ULL << 1));
    val |= st.notify << 0;
    
    assert(st.notify_on < (1ULL << 1));
    val |= st.notify_on << 1;
    
    assert(st.awaken < (1ULL << 1));
    val |= st.awaken << 8;
    *val_out = val;
}

#define V_NVC5B0_EXECUTE(val, args...) { \
    UNUSED uint32_t NOTIFY_DISABLE = NVC5B0_EXECUTE_NOTIFY_DISABLE; \
    UNUSED uint32_t NOTIFY_ENABLE = NVC5B0_EXECUTE_NOTIFY_ENABLE; \
    UNUSED uint32_t NOTIFY_ON_END = NVC5B0_EXECUTE_NOTIFY_ON_END; \
    UNUSED uint32_t NOTIFY_ON_BEGIN = NVC5B0_EXECUTE_NOTIFY_ON_BEGIN; \
    UNUSED uint32_t AWAKEN_DISABLE = NVC5B0_EXECUTE_AWAKEN_DISABLE; \
    UNUSED uint32_t AWAKEN_ENABLE = NVC5B0_EXECUTE_AWAKEN_ENABLE; \
    struct nv_nvc5b0_EXECUTE __data = args; \
    __NVC5B0_EXECUTE(&val, __data); \
}

#define VA_NVC5B0_EXECUTE V_NVC5B0_EXECUTE

#define P_NVC5B0_EXECUTE(push, args...) do { \
    UNUSED uint32_t NOTIFY_DISABLE = NVC5B0_EXECUTE_NOTIFY_DISABLE; \
    UNUSED uint32_t NOTIFY_ENABLE = NVC5B0_EXECUTE_NOTIFY_ENABLE; \
    UNUSED uint32_t NOTIFY_ON_END = NVC5B0_EXECUTE_NOTIFY_ON_END; \
    UNUSED uint32_t NOTIFY_ON_BEGIN = NVC5B0_EXECUTE_NOTIFY_ON_BEGIN; \
    UNUSED uint32_t AWAKEN_DISABLE = NVC5B0_EXECUTE_AWAKEN_DISABLE; \
    UNUSED uint32_t AWAKEN_ENABLE = NVC5B0_EXECUTE_AWAKEN_ENABLE; \
    uint32_t nvk_p_ret; \
    V_NVC5B0_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_EXECUTE, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SEMAPHORE_D {
    uint32_t structure_size;
    uint32_t awaken_enable;
    uint32_t operation;
    uint32_t flush_disable;
};

static inline void
__NVC5B0_SEMAPHORE_D(uint32_t *val_out, struct nv_nvc5b0_SEMAPHORE_D st)
{
    uint32_t val = 0;
    
    assert(st.structure_size < (1ULL << 1));
    val |= st.structure_size << 0;
    
    assert(st.awaken_enable < (1ULL << 1));
    val |= st.awaken_enable << 8;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 16;
    
    assert(st.flush_disable < (1ULL << 1));
    val |= st.flush_disable << 21;
    *val_out = val;
}

#define V_NVC5B0_SEMAPHORE_D(val, args...) { \
    UNUSED uint32_t STRUCTURE_SIZE_ONE = NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR = NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC5B0_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_RESERVED0 = NVC5B0_SEMAPHORE_D_OPERATION_RESERVED0; \
    UNUSED uint32_t OPERATION_RESERVED1 = NVC5B0_SEMAPHORE_D_OPERATION_RESERVED1; \
    UNUSED uint32_t OPERATION_TRAP = NVC5B0_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    struct nv_nvc5b0_SEMAPHORE_D __data = args; \
    __NVC5B0_SEMAPHORE_D(&val, __data); \
}

#define VA_NVC5B0_SEMAPHORE_D V_NVC5B0_SEMAPHORE_D

#define P_NVC5B0_SEMAPHORE_D(push, args...) do { \
    UNUSED uint32_t STRUCTURE_SIZE_ONE = NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_ONE; \
    UNUSED uint32_t STRUCTURE_SIZE_FOUR = NVC5B0_SEMAPHORE_D_STRUCTURE_SIZE_FOUR; \
    UNUSED uint32_t AWAKEN_ENABLE_FALSE = NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_FALSE; \
    UNUSED uint32_t AWAKEN_ENABLE_TRUE = NVC5B0_SEMAPHORE_D_AWAKEN_ENABLE_TRUE; \
    UNUSED uint32_t OPERATION_RELEASE = NVC5B0_SEMAPHORE_D_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_RESERVED0 = NVC5B0_SEMAPHORE_D_OPERATION_RESERVED0; \
    UNUSED uint32_t OPERATION_RESERVED1 = NVC5B0_SEMAPHORE_D_OPERATION_RESERVED1; \
    UNUSED uint32_t OPERATION_TRAP = NVC5B0_SEMAPHORE_D_OPERATION_TRAP; \
    UNUSED uint32_t FLUSH_DISABLE_FALSE = NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_FALSE; \
    UNUSED uint32_t FLUSH_DISABLE_TRUE = NVC5B0_SEMAPHORE_D_FLUSH_DISABLE_TRUE; \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SEMAPHORE_D(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SEMAPHORE_D, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_CONTROL_PARAMS {
    uint32_t codec_type;
    uint32_t gptimer_on;
    uint32_t ret_error;
    uint32_t err_conceal_on;
    uint32_t error_frm_idx;
    uint32_t mbtimer_on;
    uint32_t ec_intra_frame_using_pslc;
    uint32_t all_intra_frame;
    uint32_t reserved;
};

static inline void
__NVC5B0_SET_CONTROL_PARAMS(uint32_t *val_out, struct nv_nvc5b0_SET_CONTROL_PARAMS st)
{
    uint32_t val = 0;
    
    assert(st.codec_type < (1ULL << 4));
    val |= st.codec_type << 0;
    
    assert(st.gptimer_on < (1ULL << 1));
    val |= st.gptimer_on << 4;
    
    assert(st.ret_error < (1ULL << 1));
    val |= st.ret_error << 5;
    
    assert(st.err_conceal_on < (1ULL << 1));
    val |= st.err_conceal_on << 6;
    
    assert(st.error_frm_idx < (1ULL << 6));
    val |= st.error_frm_idx << 7;
    
    assert(st.mbtimer_on < (1ULL << 1));
    val |= st.mbtimer_on << 13;
    
    assert(st.ec_intra_frame_using_pslc < (1ULL << 1));
    val |= st.ec_intra_frame_using_pslc << 14;
    
    assert(st.all_intra_frame < (1ULL << 1));
    val |= st.all_intra_frame << 17;
    
    assert(st.reserved < (1ULL << 14));
    val |= st.reserved << 18;
    *val_out = val;
}

#define V_NVC5B0_SET_CONTROL_PARAMS(val, args...) { \
    UNUSED uint32_t CODEC_TYPE_MPEG1 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1; \
    UNUSED uint32_t CODEC_TYPE_MPEG2 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2; \
    UNUSED uint32_t CODEC_TYPE_VC1 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1; \
    UNUSED uint32_t CODEC_TYPE_H264 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264; \
    UNUSED uint32_t CODEC_TYPE_MPEG4 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4; \
    UNUSED uint32_t CODEC_TYPE_DIVX3 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_DIVX3; \
    UNUSED uint32_t CODEC_TYPE_VP8 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8; \
    UNUSED uint32_t CODEC_TYPE_HEVC = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC; \
    UNUSED uint32_t CODEC_TYPE_VP9 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9; \
    struct nv_nvc5b0_SET_CONTROL_PARAMS __data = args; \
    __NVC5B0_SET_CONTROL_PARAMS(&val, __data); \
}

#define VA_NVC5B0_SET_CONTROL_PARAMS V_NVC5B0_SET_CONTROL_PARAMS

#define P_NVC5B0_SET_CONTROL_PARAMS(push, args...) do { \
    UNUSED uint32_t CODEC_TYPE_MPEG1 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG1; \
    UNUSED uint32_t CODEC_TYPE_MPEG2 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG2; \
    UNUSED uint32_t CODEC_TYPE_VC1 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VC1; \
    UNUSED uint32_t CODEC_TYPE_H264 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_H264; \
    UNUSED uint32_t CODEC_TYPE_MPEG4 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_MPEG4; \
    UNUSED uint32_t CODEC_TYPE_DIVX3 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_DIVX3; \
    UNUSED uint32_t CODEC_TYPE_VP8 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP8; \
    UNUSED uint32_t CODEC_TYPE_HEVC = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_HEVC; \
    UNUSED uint32_t CODEC_TYPE_VP9 = NVC5B0_SET_CONTROL_PARAMS_CODEC_TYPE_VP9; \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_CONTROL_PARAMS(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_CONTROL_PARAMS, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_DRV_PIC_SETUP_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_DRV_PIC_SETUP_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_DRV_PIC_SETUP_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_DRV_PIC_SETUP_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_DRV_PIC_SETUP_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_DRV_PIC_SETUP_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_DRV_PIC_SETUP_OFFSET V_NVC5B0_SET_DRV_PIC_SETUP_OFFSET

#define P_NVC5B0_SET_DRV_PIC_SETUP_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_DRV_PIC_SETUP_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_DRV_PIC_SETUP_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_IN_BUF_BASE_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_IN_BUF_BASE_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_IN_BUF_BASE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_IN_BUF_BASE_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_IN_BUF_BASE_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_IN_BUF_BASE_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_IN_BUF_BASE_OFFSET V_NVC5B0_SET_IN_BUF_BASE_OFFSET

#define P_NVC5B0_SET_IN_BUF_BASE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_IN_BUF_BASE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_IN_BUF_BASE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_INDEX {
    uint32_t index;
};

static inline void
__NVC5B0_SET_PICTURE_INDEX(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.index;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_INDEX(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_INDEX __data = { .index = (args) }; \
    __NVC5B0_SET_PICTURE_INDEX(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_INDEX V_NVC5B0_SET_PICTURE_INDEX

#define P_NVC5B0_SET_PICTURE_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_INDEX, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_SLICE_OFFSETS_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_SLICE_OFFSETS_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_SLICE_OFFSETS_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET V_NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET

#define P_NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_SLICE_OFFSETS_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_COLOC_DATA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_COLOC_DATA_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_COLOC_DATA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_COLOC_DATA_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_COLOC_DATA_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_COLOC_DATA_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_COLOC_DATA_OFFSET V_NVC5B0_SET_COLOC_DATA_OFFSET

#define P_NVC5B0_SET_COLOC_DATA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_COLOC_DATA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_COLOC_DATA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_HISTORY_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_HISTORY_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_HISTORY_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_HISTORY_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_HISTORY_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_HISTORY_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_HISTORY_OFFSET V_NVC5B0_SET_HISTORY_OFFSET

#define P_NVC5B0_SET_HISTORY_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_HISTORY_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_HISTORY_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_DISPLAY_BUF_SIZE {
    uint32_t size;
};

static inline void
__NVC5B0_SET_DISPLAY_BUF_SIZE(uint32_t *val_out, struct nv_nvc5b0_SET_DISPLAY_BUF_SIZE st)
{
    uint32_t val = 0;
    
    val |= st.size;
    *val_out = val;
}

#define V_NVC5B0_SET_DISPLAY_BUF_SIZE(val, args...) { \
    struct nv_nvc5b0_SET_DISPLAY_BUF_SIZE __data = { .size = (args) }; \
    __NVC5B0_SET_DISPLAY_BUF_SIZE(&val, __data); \
}

#define VA_NVC5B0_SET_DISPLAY_BUF_SIZE V_NVC5B0_SET_DISPLAY_BUF_SIZE

#define P_NVC5B0_SET_DISPLAY_BUF_SIZE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_DISPLAY_BUF_SIZE(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_DISPLAY_BUF_SIZE, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_HISTOGRAM_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_HISTOGRAM_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_HISTOGRAM_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_HISTOGRAM_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_HISTOGRAM_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_HISTOGRAM_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_HISTOGRAM_OFFSET V_NVC5B0_SET_HISTOGRAM_OFFSET

#define P_NVC5B0_SET_HISTOGRAM_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_HISTOGRAM_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_HISTOGRAM_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_NVDEC_STATUS_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_NVDEC_STATUS_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_NVDEC_STATUS_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_NVDEC_STATUS_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_NVDEC_STATUS_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_NVDEC_STATUS_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_NVDEC_STATUS_OFFSET V_NVC5B0_SET_NVDEC_STATUS_OFFSET

#define P_NVC5B0_SET_NVDEC_STATUS_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_NVDEC_STATUS_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_NVDEC_STATUS_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_DISPLAY_BUF_LUMA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_DISPLAY_BUF_LUMA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_DISPLAY_BUF_LUMA_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET V_NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET

#define P_NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_DISPLAY_BUF_LUMA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_DISPLAY_BUF_CHROMA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_DISPLAY_BUF_CHROMA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_DISPLAY_BUF_CHROMA_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET V_NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET

#define P_NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_DISPLAY_BUF_CHROMA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET0 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET0(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET0 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET0(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET0 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET0(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET0 V_NVC5B0_SET_PICTURE_LUMA_OFFSET0

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET0(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET0, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET1 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET1(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET1 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET1(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET1 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET1(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET1 V_NVC5B0_SET_PICTURE_LUMA_OFFSET1

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET1(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET1, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET2 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET2(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET2 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET2(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET2 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET2(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET2 V_NVC5B0_SET_PICTURE_LUMA_OFFSET2

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET2(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET2, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET3 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET3(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET3 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET3(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET3 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET3(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET3 V_NVC5B0_SET_PICTURE_LUMA_OFFSET3

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET3(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET3, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET4 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET4(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET4 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET4(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET4 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET4(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET4 V_NVC5B0_SET_PICTURE_LUMA_OFFSET4

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET4(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET4(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET4, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET5 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET5(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET5 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET5(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET5 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET5(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET5 V_NVC5B0_SET_PICTURE_LUMA_OFFSET5

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET5(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET5(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET5, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET6 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET6(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET6 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET6(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET6 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET6(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET6 V_NVC5B0_SET_PICTURE_LUMA_OFFSET6

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET6(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET6(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET6, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET7 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET7(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET7 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET7(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET7 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET7(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET7 V_NVC5B0_SET_PICTURE_LUMA_OFFSET7

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET7(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET7(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET7, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET8 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET8(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET8 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET8(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET8 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET8(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET8 V_NVC5B0_SET_PICTURE_LUMA_OFFSET8

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET8(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET8, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET9 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET9(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET9 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET9(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET9 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET9(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET9 V_NVC5B0_SET_PICTURE_LUMA_OFFSET9

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET9(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET9(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET9, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET10 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET10(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET10 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET10(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET10 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET10(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET10 V_NVC5B0_SET_PICTURE_LUMA_OFFSET10

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET10(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET10, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET11 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET11(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET11 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET11(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET11 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET11(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET11 V_NVC5B0_SET_PICTURE_LUMA_OFFSET11

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET11(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET11, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET12 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET12(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET12 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET12(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET12 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET12(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET12 V_NVC5B0_SET_PICTURE_LUMA_OFFSET12

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET12(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET12, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET13 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET13(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET13 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET13(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET13 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET13(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET13 V_NVC5B0_SET_PICTURE_LUMA_OFFSET13

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET13(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET13, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET14 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET14(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET14 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET14(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET14 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET14(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET14 V_NVC5B0_SET_PICTURE_LUMA_OFFSET14

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET14(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET14, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET15 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET15(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET15 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET15(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET15 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET15(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET15 V_NVC5B0_SET_PICTURE_LUMA_OFFSET15

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET15(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET15, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET16 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_LUMA_OFFSET16(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET16 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_LUMA_OFFSET16(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_LUMA_OFFSET16 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_LUMA_OFFSET16(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_LUMA_OFFSET16 V_NVC5B0_SET_PICTURE_LUMA_OFFSET16

#define P_NVC5B0_SET_PICTURE_LUMA_OFFSET16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_LUMA_OFFSET16(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_LUMA_OFFSET16, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET0 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET0(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET0 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET0(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET0 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET0(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET0 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET0

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET0(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET0(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET0, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET1 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET1(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET1 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET1(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET1 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET1(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET1 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET1

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET1(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET1(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET1, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET2 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET2(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET2 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET2(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET2 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET2(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET2 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET2

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET2(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET2(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET2, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET3 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET3(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET3 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET3(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET3 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET3(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET3 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET3

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET3(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET3(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET3, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET4 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET4(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET4 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET4(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET4 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET4(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET4 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET4

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET4(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET4(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET4, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET5 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET5(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET5 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET5(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET5 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET5(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET5 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET5

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET5(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET5(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET5, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET6 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET6(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET6 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET6(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET6 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET6(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET6 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET6

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET6(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET6(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET6, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET7 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET7(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET7 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET7(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET7 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET7(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET7 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET7

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET7(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET7(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET7, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET8 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET8(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET8 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET8(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET8 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET8(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET8 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET8

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET8(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET8(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET8, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET9 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET9(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET9 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET9(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET9 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET9(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET9 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET9

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET9(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET9(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET9, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET10 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET10(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET10 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET10(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET10 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET10(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET10 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET10

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET10(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET10(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET10, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET11 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET11(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET11 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET11(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET11 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET11(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET11 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET11

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET11(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET11(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET11, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET12 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET12(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET12 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET12(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET12 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET12(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET12 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET12

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET12(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET12(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET12, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET13 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET13(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET13 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET13(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET13 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET13(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET13 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET13

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET13(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET13(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET13, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET14 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET14(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET14 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET14(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET14 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET14(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET14 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET14

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET14(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET14(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET14, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET15 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET15(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET15 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET15(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET15 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET15(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET15 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET15

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET15(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET15(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET15, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET16 {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PICTURE_CHROMA_OFFSET16(uint32_t *val_out, struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET16 st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PICTURE_CHROMA_OFFSET16(val, args...) { \
    struct nv_nvc5b0_SET_PICTURE_CHROMA_OFFSET16 __data = { .offset = (args) }; \
    __NVC5B0_SET_PICTURE_CHROMA_OFFSET16(&val, __data); \
}

#define VA_NVC5B0_SET_PICTURE_CHROMA_OFFSET16 V_NVC5B0_SET_PICTURE_CHROMA_OFFSET16

#define P_NVC5B0_SET_PICTURE_CHROMA_OFFSET16(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PICTURE_CHROMA_OFFSET16(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PICTURE_CHROMA_OFFSET16, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_PIC_SCRATCH_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_PIC_SCRATCH_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_PIC_SCRATCH_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET V_NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET

#define P_NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_PIC_SCRATCH_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_SET_EXTERNAL_MVBUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET(uint32_t *val_out, struct nv_nvc5b0_SET_EXTERNAL_MVBUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET(val, args...) { \
    struct nv_nvc5b0_SET_EXTERNAL_MVBUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET(&val, __data); \
}

#define VA_NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET V_NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET

#define P_NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_SET_EXTERNAL_MVBUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_H264_SET_MBHIST_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_H264_SET_MBHIST_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_H264_SET_MBHIST_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_H264_SET_MBHIST_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_H264_SET_MBHIST_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_H264_SET_MBHIST_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_H264_SET_MBHIST_BUF_OFFSET V_NVC5B0_H264_SET_MBHIST_BUF_OFFSET

#define P_NVC5B0_H264_SET_MBHIST_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_H264_SET_MBHIST_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_H264_SET_MBHIST_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP8_SET_PROB_DATA_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP8_SET_PROB_DATA_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP8_SET_PROB_DATA_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP8_SET_PROB_DATA_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP8_SET_PROB_DATA_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP8_SET_PROB_DATA_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP8_SET_PROB_DATA_OFFSET V_NVC5B0_VP8_SET_PROB_DATA_OFFSET

#define P_NVC5B0_VP8_SET_PROB_DATA_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP8_SET_PROB_DATA_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP8_SET_PROB_DATA_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET V_NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET

#define P_NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP8_SET_HEADER_PARTITION_BUF_BASE_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_SCALING_LIST_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_SCALING_LIST_OFFSET(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_SCALING_LIST_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_SCALING_LIST_OFFSET(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_SCALING_LIST_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_SCALING_LIST_OFFSET(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_SCALING_LIST_OFFSET V_NVC5B0_HEVC_SET_SCALING_LIST_OFFSET

#define P_NVC5B0_HEVC_SET_SCALING_LIST_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_SCALING_LIST_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_SCALING_LIST_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_TILE_SIZES_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_TILE_SIZES_OFFSET(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_TILE_SIZES_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_TILE_SIZES_OFFSET(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_TILE_SIZES_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_TILE_SIZES_OFFSET(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_TILE_SIZES_OFFSET V_NVC5B0_HEVC_SET_TILE_SIZES_OFFSET

#define P_NVC5B0_HEVC_SET_TILE_SIZES_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_TILE_SIZES_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_TILE_SIZES_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_FILTER_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_FILTER_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_FILTER_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET V_NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET

#define P_NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_FILTER_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_SAO_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_SAO_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_SAO_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET V_NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET

#define P_NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_SAO_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET V_NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET

#define P_NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_SLICE_INFO_BUFFER_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_HEVC_SET_SLICE_GROUP_INDEX {
    uint32_t offset;
};

static inline void
__NVC5B0_HEVC_SET_SLICE_GROUP_INDEX(uint32_t *val_out, struct nv_nvc5b0_HEVC_SET_SLICE_GROUP_INDEX st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_HEVC_SET_SLICE_GROUP_INDEX(val, args...) { \
    struct nv_nvc5b0_HEVC_SET_SLICE_GROUP_INDEX __data = { .offset = (args) }; \
    __NVC5B0_HEVC_SET_SLICE_GROUP_INDEX(&val, __data); \
}

#define VA_NVC5B0_HEVC_SET_SLICE_GROUP_INDEX V_NVC5B0_HEVC_SET_SLICE_GROUP_INDEX

#define P_NVC5B0_HEVC_SET_SLICE_GROUP_INDEX(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_HEVC_SET_SLICE_GROUP_INDEX(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_HEVC_SET_SLICE_GROUP_INDEX, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_PROB_TAB_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_PROB_TAB_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_PROB_TAB_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET V_NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET

#define P_NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_PROB_TAB_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_CTX_COUNTER_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_CTX_COUNTER_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_CTX_COUNTER_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET V_NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET

#define P_NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_CTX_COUNTER_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_SEGMENT_READ_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_SEGMENT_READ_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_SEGMENT_READ_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET V_NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET

#define P_NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_SEGMENT_READ_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET V_NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET

#define P_NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_SEGMENT_WRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_TILE_SIZE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_TILE_SIZE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_TILE_SIZE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET V_NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET

#define P_NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_TILE_SIZE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_COL_MVWRITE_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_COL_MVWRITE_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_COL_MVWRITE_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET V_NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET

#define P_NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_COL_MVWRITE_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_COL_MVREAD_BUF_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_COL_MVREAD_BUF_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_COL_MVREAD_BUF_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET V_NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET

#define P_NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_COL_MVREAD_BUF_OFFSET, nvk_p_ret); \
} while(0)

struct nv_nvc5b0_VP9_SET_FILTER_BUFFER_OFFSET {
    uint32_t offset;
};

static inline void
__NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET(uint32_t *val_out, struct nv_nvc5b0_VP9_SET_FILTER_BUFFER_OFFSET st)
{
    uint32_t val = 0;
    
    val |= st.offset;
    *val_out = val;
}

#define V_NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET(val, args...) { \
    struct nv_nvc5b0_VP9_SET_FILTER_BUFFER_OFFSET __data = { .offset = (args) }; \
    __NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET(&val, __data); \
}

#define VA_NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET V_NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET

#define P_NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET(nvk_p_ret, args); \
    nv_push_val(push, NVC5B0_VP9_SET_FILTER_BUFFER_OFFSET, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVC5B0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVC5B0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
