/* parsed class NVCA6F */

#include "nvtypes.h"
#include "clca6f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nvca6f_SEM_ADDR_LO {
    uint32_t offset;
};

static inline void
__NVCA6F_SEM_ADDR_LO(uint32_t *val_out, struct nv_nvca6f_SEM_ADDR_LO st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 30));
    val |= st.offset << 2;
    *val_out = val;
}

#define V_NVCA6F_SEM_ADDR_LO(val, args...) { \
    struct nv_nvca6f_SEM_ADDR_LO __data = { .offset = (args) }; \
    __NVCA6F_SEM_ADDR_LO(&val, __data); \
}

#define VA_NVCA6F_SEM_ADDR_LO V_NVCA6F_SEM_ADDR_LO

#define P_NVCA6F_SEM_ADDR_LO(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVCA6F_SEM_ADDR_LO(nvk_p_ret, args); \
    nv_push_val(push, NVCA6F_SEM_ADDR_LO, nvk_p_ret); \
} while(0)

struct nv_nvca6f_SEM_ADDR_HI {
    uint32_t offset;
};

static inline void
__NVCA6F_SEM_ADDR_HI(uint32_t *val_out, struct nv_nvca6f_SEM_ADDR_HI st)
{
    uint32_t val = 0;
    
    assert(st.offset < (1ULL << 25));
    val |= st.offset << 0;
    *val_out = val;
}

#define V_NVCA6F_SEM_ADDR_HI(val, args...) { \
    struct nv_nvca6f_SEM_ADDR_HI __data = { .offset = (args) }; \
    __NVCA6F_SEM_ADDR_HI(&val, __data); \
}

#define VA_NVCA6F_SEM_ADDR_HI V_NVCA6F_SEM_ADDR_HI

#define P_NVCA6F_SEM_ADDR_HI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVCA6F_SEM_ADDR_HI(nvk_p_ret, args); \
    nv_push_val(push, NVCA6F_SEM_ADDR_HI, nvk_p_ret); \
} while(0)

struct nv_nvca6f_SEM_EXECUTE {
    uint32_t operation;
    uint32_t release_wfi;
    uint32_t payload_size;
};

static inline void
__NVCA6F_SEM_EXECUTE(uint32_t *val_out, struct nv_nvca6f_SEM_EXECUTE st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 3));
    val |= st.operation << 0;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.payload_size < (1ULL << 1));
    val |= st.payload_size << 24;
    *val_out = val;
}

#define V_NVCA6F_SEM_EXECUTE(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVCA6F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVCA6F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVCA6F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVCA6F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    struct nv_nvca6f_SEM_EXECUTE __data = args; \
    __NVCA6F_SEM_EXECUTE(&val, __data); \
}

#define VA_NVCA6F_SEM_EXECUTE V_NVCA6F_SEM_EXECUTE

#define P_NVCA6F_SEM_EXECUTE(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVCA6F_SEM_EXECUTE_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVCA6F_SEM_EXECUTE_OPERATION_RELEASE; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVCA6F_SEM_EXECUTE_RELEASE_WFI_DIS; \
    UNUSED uint32_t PAYLOAD_SIZE_32BIT = NVCA6F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT; \
    uint32_t nvk_p_ret; \
    V_NVCA6F_SEM_EXECUTE(nvk_p_ret, args); \
    nv_push_val(push, NVCA6F_SEM_EXECUTE, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVCA6F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVCA6F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
