// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolArrayValue = sync.Pool{
		New: func() any {
			return &otlpcommon.ArrayValue{}
		},
	}
)

func NewOrigArrayValue() *otlpcommon.ArrayValue {
	if !UseProtoPooling.IsEnabled() {
		return &otlpcommon.ArrayValue{}
	}
	return protoPoolArrayValue.Get().(*otlpcommon.ArrayValue)
}

func DeleteOrigArrayValue(orig *otlpcommon.ArrayValue, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.Values {
		DeleteOrigAnyValue(&orig.Values[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolArrayValue.Put(orig)
	}
}

func CopyOrigArrayValue(dest, src *otlpcommon.ArrayValue) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.Values = CopyOrigAnyValueSlice(dest.Values, src.Values)
}

func GenTestOrigArrayValue() *otlpcommon.ArrayValue {
	orig := NewOrigArrayValue()
	orig.Values = GenerateOrigTestAnyValueSlice()
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigArrayValue(orig *otlpcommon.ArrayValue, dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.Values) > 0 {
		dest.WriteObjectField("values")
		dest.WriteArrayStart()
		MarshalJSONOrigAnyValue(&orig.Values[0], dest)
		for i := 1; i < len(orig.Values); i++ {
			dest.WriteMore()
			MarshalJSONOrigAnyValue(&orig.Values[i], dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigArrayValue unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigArrayValue(orig *otlpcommon.ArrayValue, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "values":
			for iter.ReadArray() {
				orig.Values = append(orig.Values, otlpcommon.AnyValue{})
				UnmarshalJSONOrigAnyValue(&orig.Values[len(orig.Values)-1], iter)
			}

		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigArrayValue(orig *otlpcommon.ArrayValue) int {
	var n int
	var l int
	_ = l
	for i := range orig.Values {
		l = SizeProtoOrigAnyValue(&orig.Values[i])
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func MarshalProtoOrigArrayValue(orig *otlpcommon.ArrayValue, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.Values) - 1; i >= 0; i-- {
		l = MarshalProtoOrigAnyValue(&orig.Values[i], buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigArrayValue(orig *otlpcommon.ArrayValue, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Values = append(orig.Values, otlpcommon.AnyValue{})
			err = UnmarshalProtoOrigAnyValue(&orig.Values[len(orig.Values)-1], buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
