use gdk4::RGBA;

use crate::themes::NewsflashTheme;

#[derive(Debug, Clone, Copy)]
pub struct ThemeInfo {
    pub name: &'static str,
    pub foreground: RGBA,
    pub background: RGBA,
    pub accent: Option<RGBA>,
    pub is_dark: bool,
}

impl ThemeInfo {
    const ADWAITA_LIGHT: ThemeInfo = ThemeInfo {
        name: "adwaita-light",
        foreground: RGBA::new(0.113_725, 0.121_568, 0.109_803, 1.0),
        background: RGBA::new(0.980_392, 0.980_392, 0.980_392, 1.0),
        accent: None,
        is_dark: false,
    };
    const ADWAITA_DARK: ThemeInfo = ThemeInfo {
        name: "adwaita-dark",
        foreground: RGBA::new(1.0, 1.0, 1.0, 0.9),
        background: RGBA::new(0.133_333, 0.133_333, 0.149_019, 1.0),
        accent: None,
        is_dark: true,
    };
    const SPRING: ThemeInfo = ThemeInfo {
        name: "spring",
        foreground: RGBA::new(0.250_980, 0.368_627, 0.501_960, 1.0),
        background: RGBA::new(0.972_549, 1.0, 0.949_019, 1.0),
        accent: Some(RGBA::new(0.250_980, 0.368_627, 0.501_960, 1.0)),
        is_dark: false,
    };
    const MIDNIGHT: ThemeInfo = ThemeInfo {
        name: "midnight",
        foreground: RGBA::new(1.0, 1.0, 1.0, 0.6),
        background: RGBA::new(0.137_254, 0.207_843, 0.250_980, 1.0),
        accent: Some(RGBA::new(0.160_784, 0.470_588, 0.650_980, 1.0)),
        is_dark: true,
    };
    const PARCHMENT: ThemeInfo = ThemeInfo {
        name: "parchment",
        foreground: RGBA::new(0.0, 0.0, 0.0, 0.8),
        background: RGBA::new(0.980_392, 0.949_019, 0.882_352, 1.0),
        accent: Some(RGBA::new(0.6, 0.250_980, 0.058_823, 1.0)),
        is_dark: false,
    };
    const GRUVBOX: ThemeInfo = ThemeInfo {
        name: "gruvbox",
        foreground: RGBA::new(0.984_313, 0.945_098, 0.780_392, 0.8),
        background: RGBA::new(0.156_862, 0.156_862, 0.156_862, 1.0),
        accent: Some(RGBA::new(0.407_843, 0.615_686, 0.415_686, 1.0)),
        is_dark: true,
    };
    const ZORIN: ThemeInfo = ThemeInfo {
        name: "zorin",
        foreground: RGBA::new(0.741_176, 0.901_960, 0.984_313, 1.0),
        background: RGBA::new(0.117_647, 0.145_098, 0.160_784, 1.0),
        accent: Some(RGBA::new(0.741_176, 0.901_960, 0.984_313, 1.0)),
        is_dark: true,
    };

    pub fn get(theme: &NewsflashTheme) -> Self {
        match theme {
            NewsflashTheme::Default => {
                if libadwaita::StyleManager::default().is_dark() {
                    Self::ADWAITA_DARK
                } else {
                    Self::ADWAITA_LIGHT
                }
            }
            NewsflashTheme::Spring => Self::SPRING,
            NewsflashTheme::Midnight => Self::MIDNIGHT,
            NewsflashTheme::Parchment => Self::PARCHMENT,
            NewsflashTheme::Gruvbox => Self::GRUVBOX,
            NewsflashTheme::Zorin => Self::ZORIN,
        }
    }
}
