/* Evaluation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Evaluation.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io)
 *               2014 Marvin Beckers <beckersmarvin@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Marvin Beckers <beckersmarvin@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PANTHEON_CALCULATOR_CORE_TYPE_EVAL_ERROR (pantheon_calculator_core_eval_error_get_type ())

#define PANTHEON_CALCULATOR_CORE_TYPE_SHUNTING_ERROR (pantheon_calculator_core_shunting_error_get_type ())

#define PANTHEON_CALCULATOR_CORE_TYPE_OUT_ERROR (pantheon_calculator_core_out_error_get_type ())

#define PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION (pantheon_calculator_core_evaluation_get_type ())
#define PANTHEON_CALCULATOR_CORE_EVALUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluation))
#define PANTHEON_CALCULATOR_CORE_EVALUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluationClass))
#define PANTHEON_CALCULATOR_CORE_IS_EVALUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION))
#define PANTHEON_CALCULATOR_CORE_IS_EVALUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION))
#define PANTHEON_CALCULATOR_CORE_EVALUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluationClass))

typedef struct _PantheonCalculatorCoreEvaluation PantheonCalculatorCoreEvaluation;
typedef struct _PantheonCalculatorCoreEvaluationClass PantheonCalculatorCoreEvaluationClass;
typedef struct _PantheonCalculatorCoreEvaluationPrivate PantheonCalculatorCoreEvaluationPrivate;

#define PANTHEON_CALCULATOR_CORE_TYPE_SCANNER (pantheon_calculator_core_scanner_get_type ())
#define PANTHEON_CALCULATOR_CORE_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScanner))
#define PANTHEON_CALCULATOR_CORE_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER))
#define PANTHEON_CALCULATOR_CORE_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_SCANNER, PantheonCalculatorCoreScannerClass))

typedef struct _PantheonCalculatorCoreScanner PantheonCalculatorCoreScanner;
typedef struct _PantheonCalculatorCoreScannerClass PantheonCalculatorCoreScannerClass;
enum  {
	PANTHEON_CALCULATOR_CORE_EVALUATION_0_PROPERTY,
	PANTHEON_CALCULATOR_CORE_EVALUATION_NUM_PROPERTIES
};
static GParamSpec* pantheon_calculator_core_evaluation_properties[PANTHEON_CALCULATOR_CORE_EVALUATION_NUM_PROPERTIES];

#define PANTHEON_CALCULATOR_CORE_EVALUATION_TYPE_OPERATOR (pantheon_calculator_core_evaluation_operator_get_type ())
typedef struct _PantheonCalculatorCoreEvaluationOperator PantheonCalculatorCoreEvaluationOperator;
typedef gdouble (*PantheonCalculatorCoreEvaluationEval) (gdouble a, gdouble b);
#define _g_free0(var) (var = (g_free (var), NULL))

#define PANTHEON_CALCULATOR_CORE_EVALUATION_TYPE_FUNCTION (pantheon_calculator_core_evaluation_function_get_type ())
typedef struct _PantheonCalculatorCoreEvaluationFunction PantheonCalculatorCoreEvaluationFunction;

#define PANTHEON_CALCULATOR_CORE_EVALUATION_TYPE_CONSTANT (pantheon_calculator_core_evaluation_constant_get_type ())
typedef struct _PantheonCalculatorCoreEvaluationConstant PantheonCalculatorCoreEvaluationConstant;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PANTHEON_CALCULATOR_CORE_TYPE_TOKEN (pantheon_calculator_core_token_get_type ())
#define PANTHEON_CALCULATOR_CORE_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreToken))
#define PANTHEON_CALCULATOR_CORE_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreTokenClass))
#define PANTHEON_CALCULATOR_CORE_IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN))
#define PANTHEON_CALCULATOR_CORE_IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN))
#define PANTHEON_CALCULATOR_CORE_TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANTHEON_CALCULATOR_CORE_TYPE_TOKEN, PantheonCalculatorCoreTokenClass))

typedef struct _PantheonCalculatorCoreToken PantheonCalculatorCoreToken;
typedef struct _PantheonCalculatorCoreTokenClass PantheonCalculatorCoreTokenClass;

#define PANTHEON_CALCULATOR_CORE_TYPE_SCANNER_ERROR (pantheon_calculator_core_scanner_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef enum  {
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NULL_NUMBER,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_SEPARATOR,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_ALPHA,
	PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_EOF
} PantheonCalculatorCoreTokenType;

#define PANTHEON_CALCULATOR_CORE_TYPE_TOKEN_TYPE (pantheon_calculator_core_token_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

typedef enum  {
	PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_FUNCTION,
	PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_OPERATOR,
	PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_CONSTANT
} PantheonCalculatorCoreEVAL_ERROR;
#define PANTHEON_CALCULATOR_CORE_EVAL_ERROR pantheon_calculator_core_eval_error_quark ()

typedef enum  {
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_DUMMY,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_OPERATOR,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_FUNCTION,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_CONSTANT,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_MISMATCHED_P,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_UNKNOWN_TOKEN,
	PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_STACK_EMPTY
} PantheonCalculatorCoreSHUNTING_ERROR;
#define PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR pantheon_calculator_core_shunting_error_quark ()

typedef enum  {
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_EVAL_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_CHECK_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_SHUNTING_ERROR,
	PANTHEON_CALCULATOR_CORE_OUT_ERROR_SCANNER_ERROR
} PantheonCalculatorCoreOUT_ERROR;
#define PANTHEON_CALCULATOR_CORE_OUT_ERROR pantheon_calculator_core_out_error_quark ()

struct _PantheonCalculatorCoreEvaluation {
	GObject parent_instance;
	PantheonCalculatorCoreEvaluationPrivate * priv;
	PantheonCalculatorCoreScanner* scanner;
};

struct _PantheonCalculatorCoreEvaluationClass {
	GObjectClass parent_class;
};

struct _PantheonCalculatorCoreEvaluationOperator {
	gchar* symbol;
	gint inputs;
	gint prec;
	gchar* fixity;
	PantheonCalculatorCoreEvaluationEval eval;
};

struct _PantheonCalculatorCoreEvaluationFunction {
	gchar* symbol;
	gint inputs;
	PantheonCalculatorCoreEvaluationEval eval;
};

struct _PantheonCalculatorCoreEvaluationConstant {
	gchar* symbol;
	PantheonCalculatorCoreEvaluationEval eval;
};

typedef enum  {
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_UNKNOWN_TOKEN,
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_ALPHA_INVALID,
	PANTHEON_CALCULATOR_CORE_SCANNER_ERROR_MISMATCHED_PARENTHESES
} PantheonCalculatorCoreSCANNER_ERROR;
#define PANTHEON_CALCULATOR_CORE_SCANNER_ERROR pantheon_calculator_core_scanner_error_quark ()

static gpointer pantheon_calculator_core_evaluation_parent_class = NULL;
static PantheonCalculatorCoreEvaluationOperator* pantheon_calculator_core_evaluation_operators;
static gint pantheon_calculator_core_evaluation_operators_length1;
static PantheonCalculatorCoreEvaluationOperator* pantheon_calculator_core_evaluation_operators = NULL;
static gint pantheon_calculator_core_evaluation_operators_length1 = 0;
static gint _pantheon_calculator_core_evaluation_operators_size_ = 0;
static PantheonCalculatorCoreEvaluationFunction* pantheon_calculator_core_evaluation_functions;
static gint pantheon_calculator_core_evaluation_functions_length1;
static PantheonCalculatorCoreEvaluationFunction* pantheon_calculator_core_evaluation_functions = NULL;
static gint pantheon_calculator_core_evaluation_functions_length1 = 0;
static gint _pantheon_calculator_core_evaluation_functions_size_ = 0;
static PantheonCalculatorCoreEvaluationConstant* pantheon_calculator_core_evaluation_constants;
static gint pantheon_calculator_core_evaluation_constants_length1;
static PantheonCalculatorCoreEvaluationConstant* pantheon_calculator_core_evaluation_constants = NULL;
static gint pantheon_calculator_core_evaluation_constants_length1 = 0;
static gint _pantheon_calculator_core_evaluation_constants_size_ = 0;

VALA_EXTERN GQuark pantheon_calculator_core_eval_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_eval_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark pantheon_calculator_core_shunting_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_shunting_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GQuark pantheon_calculator_core_out_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_out_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pantheon_calculator_core_evaluation_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreEvaluation, g_object_unref)
VALA_EXTERN GType pantheon_calculator_core_scanner_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreScanner, g_object_unref)
static GType pantheon_calculator_core_evaluation_operator_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonCalculatorCoreEvaluationOperator* pantheon_calculator_core_evaluation_operator_dup (const PantheonCalculatorCoreEvaluationOperator* self);
static void pantheon_calculator_core_evaluation_operator_free (PantheonCalculatorCoreEvaluationOperator* self);
static void pantheon_calculator_core_evaluation_operator_copy (const PantheonCalculatorCoreEvaluationOperator* self,
                                                        PantheonCalculatorCoreEvaluationOperator* dest);
static void pantheon_calculator_core_evaluation_operator_destroy (PantheonCalculatorCoreEvaluationOperator* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonCalculatorCoreEvaluationOperator, pantheon_calculator_core_evaluation_operator_destroy)
static gdouble _pantheon_calculator_core_evaluation_operators_lambda5_ (gdouble a,
                                                                 gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda5__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                           gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda6_ (gdouble a,
                                                                 gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda6__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                           gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda7_ (gdouble a,
                                                                 gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda7__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                           gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda8_ (gdouble a,
                                                                 gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda8__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                           gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda9_ (gdouble a,
                                                                 gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda9__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                           gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda10_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda10__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda11_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda11__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda12_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda12__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda13_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda13__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda14_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda14__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_operators_lambda15_ (gdouble a,
                                                                  gdouble b);
static gdouble __pantheon_calculator_core_evaluation_operators_lambda15__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static GType pantheon_calculator_core_evaluation_function_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonCalculatorCoreEvaluationFunction* pantheon_calculator_core_evaluation_function_dup (const PantheonCalculatorCoreEvaluationFunction* self);
static void pantheon_calculator_core_evaluation_function_free (PantheonCalculatorCoreEvaluationFunction* self);
static void pantheon_calculator_core_evaluation_function_copy (const PantheonCalculatorCoreEvaluationFunction* self,
                                                        PantheonCalculatorCoreEvaluationFunction* dest);
static void pantheon_calculator_core_evaluation_function_destroy (PantheonCalculatorCoreEvaluationFunction* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonCalculatorCoreEvaluationFunction, pantheon_calculator_core_evaluation_function_destroy)
static gdouble _pantheon_calculator_core_evaluation_functions_lambda16_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda16__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda17_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda17__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda18_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda18__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda19_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda19__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda20_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda20__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda21_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda21__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda22_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda22__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda23_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda23__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda24_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda24__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda25_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda25__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda26_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda26__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda27_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda27__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda28_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda28__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_functions_lambda29_ (gdouble a);
static gdouble __pantheon_calculator_core_evaluation_functions_lambda29__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static GType pantheon_calculator_core_evaluation_constant_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static PantheonCalculatorCoreEvaluationConstant* pantheon_calculator_core_evaluation_constant_dup (const PantheonCalculatorCoreEvaluationConstant* self);
static void pantheon_calculator_core_evaluation_constant_free (PantheonCalculatorCoreEvaluationConstant* self);
static void pantheon_calculator_core_evaluation_constant_copy (const PantheonCalculatorCoreEvaluationConstant* self,
                                                        PantheonCalculatorCoreEvaluationConstant* dest);
static void pantheon_calculator_core_evaluation_constant_destroy (PantheonCalculatorCoreEvaluationConstant* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PantheonCalculatorCoreEvaluationConstant, pantheon_calculator_core_evaluation_constant_destroy)
static gdouble _pantheon_calculator_core_evaluation_constants_lambda30_ (void);
static gdouble __pantheon_calculator_core_evaluation_constants_lambda30__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_constants_lambda31_ (void);
static gdouble __pantheon_calculator_core_evaluation_constants_lambda31__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
static gdouble _pantheon_calculator_core_evaluation_constants_lambda32_ (void);
static gdouble __pantheon_calculator_core_evaluation_constants_lambda32__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                            gdouble b);
VALA_EXTERN PantheonCalculatorCoreScanner* pantheon_calculator_core_scanner_new (void);
VALA_EXTERN PantheonCalculatorCoreScanner* pantheon_calculator_core_scanner_construct (GType object_type);
VALA_EXTERN PantheonCalculatorCoreEvaluation* pantheon_calculator_core_evaluation_new (void);
VALA_EXTERN PantheonCalculatorCoreEvaluation* pantheon_calculator_core_evaluation_construct (GType object_type);
VALA_EXTERN gchar* pantheon_calculator_core_evaluation_evaluate (PantheonCalculatorCoreEvaluation* self,
                                                     const gchar* str,
                                                     gint d_places,
                                                     GError** error);
VALA_EXTERN GType pantheon_calculator_core_token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PantheonCalculatorCoreToken, g_object_unref)
VALA_EXTERN GQuark pantheon_calculator_core_scanner_error_quark (void);
VALA_EXTERN GType pantheon_calculator_core_scanner_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GList* pantheon_calculator_core_scanner_scan (PantheonCalculatorCoreScanner* self,
                                              const gchar* input,
                                              GError** error);
static GList* pantheon_calculator_core_evaluation_shunting_yard (PantheonCalculatorCoreEvaluation* self,
                                                          GList* token_list,
                                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gdouble pantheon_calculator_core_evaluation_eval_postfix (PantheonCalculatorCoreEvaluation* self,
                                                          GList* token_list,
                                                          GError** error);
static gchar* pantheon_calculator_core_evaluation_number_to_string (PantheonCalculatorCoreEvaluation* self,
                                                             gdouble d,
                                                             gint d_places);
VALA_EXTERN GType pantheon_calculator_core_token_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PantheonCalculatorCoreTokenType pantheon_calculator_core_token_get_token_type (PantheonCalculatorCoreToken* self);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
static void pantheon_calculator_core_evaluation_get_operator (PantheonCalculatorCoreEvaluation* self,
                                                       PantheonCalculatorCoreToken* t,
                                                       PantheonCalculatorCoreEvaluationOperator* result,
                                                       GError** error);
VALA_EXTERN const gchar* pantheon_calculator_core_token_get_content (PantheonCalculatorCoreToken* self);
static void pantheon_calculator_core_evaluation_get_constant (PantheonCalculatorCoreEvaluation* self,
                                                       PantheonCalculatorCoreToken* t,
                                                       PantheonCalculatorCoreEvaluationConstant* result,
                                                       GError** error);
VALA_EXTERN PantheonCalculatorCoreToken* pantheon_calculator_core_token_new (const gchar* in_content,
                                                                 PantheonCalculatorCoreTokenType in_token_type);
VALA_EXTERN PantheonCalculatorCoreToken* pantheon_calculator_core_token_construct (GType object_type,
                                                                       const gchar* in_content,
                                                                       PantheonCalculatorCoreTokenType in_token_type);
static PantheonCalculatorCoreToken* pantheon_calculator_core_evaluation_compute (PantheonCalculatorCoreEvaluation* self,
                                                                          PantheonCalculatorCoreEvaluationEval eval,
                                                                          PantheonCalculatorCoreToken* t1,
                                                                          PantheonCalculatorCoreToken* t2,
                                                                          GError** error);
static void pantheon_calculator_core_evaluation_get_function (PantheonCalculatorCoreEvaluation* self,
                                                       PantheonCalculatorCoreToken* t,
                                                       PantheonCalculatorCoreEvaluationFunction* result,
                                                       GError** error);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_operator (PantheonCalculatorCoreToken* t);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_function (PantheonCalculatorCoreToken* t);
VALA_EXTERN gboolean pantheon_calculator_core_evaluation_is_constant (PantheonCalculatorCoreToken* t);
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_decimal_symbol (PantheonCalculatorCoreScanner* self);
VALA_EXTERN const gchar* pantheon_calculator_core_scanner_get_separator_symbol (PantheonCalculatorCoreScanner* self);
static void pantheon_calculator_core_evaluation_finalize (GObject * obj);
static GType pantheon_calculator_core_evaluation_get_type_once (void);

GQuark
pantheon_calculator_core_eval_error_quark (void)
{
	return g_quark_from_static_string ("pantheon-calculator-core-eval-error-quark");
}

static GType
pantheon_calculator_core_eval_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_FUNCTION, "PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_FUNCTION", "no-function"}, {PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_OPERATOR, "PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_OPERATOR", "no-operator"}, {PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_CONSTANT, "PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_CONSTANT", "no-constant"}, {0, NULL, NULL}};
	GType pantheon_calculator_core_eval_error_type_id;
	pantheon_calculator_core_eval_error_type_id = g_enum_register_static ("PantheonCalculatorCoreEVAL_ERROR", values);
	return pantheon_calculator_core_eval_error_type_id;
}

GType
pantheon_calculator_core_eval_error_get_type (void)
{
	static volatile gsize pantheon_calculator_core_eval_error_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_eval_error_type_id__once)) {
		GType pantheon_calculator_core_eval_error_type_id;
		pantheon_calculator_core_eval_error_type_id = pantheon_calculator_core_eval_error_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_eval_error_type_id__once, pantheon_calculator_core_eval_error_type_id);
	}
	return pantheon_calculator_core_eval_error_type_id__once;
}

GQuark
pantheon_calculator_core_shunting_error_quark (void)
{
	return g_quark_from_static_string ("pantheon-calculator-core-shunting-error-quark");
}

static GType
pantheon_calculator_core_shunting_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_DUMMY, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_DUMMY", "dummy"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_OPERATOR, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_OPERATOR", "no-operator"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_FUNCTION, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_FUNCTION", "no-function"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_CONSTANT, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_CONSTANT", "no-constant"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_MISMATCHED_P, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_MISMATCHED_P", "mismatched-p"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_UNKNOWN_TOKEN, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_UNKNOWN_TOKEN", "unknown-token"}, {PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_STACK_EMPTY, "PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_STACK_EMPTY", "stack-empty"}, {0, NULL, NULL}};
	GType pantheon_calculator_core_shunting_error_type_id;
	pantheon_calculator_core_shunting_error_type_id = g_enum_register_static ("PantheonCalculatorCoreSHUNTING_ERROR", values);
	return pantheon_calculator_core_shunting_error_type_id;
}

GType
pantheon_calculator_core_shunting_error_get_type (void)
{
	static volatile gsize pantheon_calculator_core_shunting_error_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_shunting_error_type_id__once)) {
		GType pantheon_calculator_core_shunting_error_type_id;
		pantheon_calculator_core_shunting_error_type_id = pantheon_calculator_core_shunting_error_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_shunting_error_type_id__once, pantheon_calculator_core_shunting_error_type_id);
	}
	return pantheon_calculator_core_shunting_error_type_id__once;
}

GQuark
pantheon_calculator_core_out_error_quark (void)
{
	return g_quark_from_static_string ("pantheon-calculator-core-out-error-quark");
}

static GType
pantheon_calculator_core_out_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PANTHEON_CALCULATOR_CORE_OUT_ERROR_EVAL_ERROR, "PANTHEON_CALCULATOR_CORE_OUT_ERROR_EVAL_ERROR", "eval-error"}, {PANTHEON_CALCULATOR_CORE_OUT_ERROR_CHECK_ERROR, "PANTHEON_CALCULATOR_CORE_OUT_ERROR_CHECK_ERROR", "check-error"}, {PANTHEON_CALCULATOR_CORE_OUT_ERROR_SHUNTING_ERROR, "PANTHEON_CALCULATOR_CORE_OUT_ERROR_SHUNTING_ERROR", "shunting-error"}, {PANTHEON_CALCULATOR_CORE_OUT_ERROR_SCANNER_ERROR, "PANTHEON_CALCULATOR_CORE_OUT_ERROR_SCANNER_ERROR", "scanner-error"}, {0, NULL, NULL}};
	GType pantheon_calculator_core_out_error_type_id;
	pantheon_calculator_core_out_error_type_id = g_enum_register_static ("PantheonCalculatorCoreOUT_ERROR", values);
	return pantheon_calculator_core_out_error_type_id;
}

GType
pantheon_calculator_core_out_error_get_type (void)
{
	static volatile gsize pantheon_calculator_core_out_error_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_out_error_type_id__once)) {
		GType pantheon_calculator_core_out_error_type_id;
		pantheon_calculator_core_out_error_type_id = pantheon_calculator_core_out_error_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_out_error_type_id__once, pantheon_calculator_core_out_error_type_id);
	}
	return pantheon_calculator_core_out_error_type_id__once;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda5_ (gdouble a,
                                                         gdouble b)
{
	gdouble result;
	result = a + b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda5__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                   gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda5_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda6_ (gdouble a,
                                                         gdouble b)
{
	gdouble result;
	result = a - b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda6__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                   gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda6_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda7_ (gdouble a,
                                                         gdouble b)
{
	gdouble result;
	result = a - b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda7__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                   gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda7_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda8_ (gdouble a,
                                                         gdouble b)
{
	gdouble result;
	result = a * b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda8__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                   gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda8_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda9_ (gdouble a,
                                                         gdouble b)
{
	gdouble result;
	result = a * b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda9__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                   gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda9_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda10_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = a / b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda10__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda10_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda11_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = a / b;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda11__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda11_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda12_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = fmod (a, b);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda12__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda12_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda13_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = pow (a, b);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda13__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda13_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda14_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = a * pow ((gdouble) 10, b);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda14__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda14_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_operators_lambda15_ (gdouble a,
                                                          gdouble b)
{
	gdouble result;
	result = b / 100.0;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_operators_lambda15__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_operators_lambda15_ (a, b);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda16_ (gdouble a)
{
	gdouble result;
	result = sin (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda16__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda16_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda17_ (gdouble a)
{
	gdouble result;
	result = cos (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda17__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda17_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda18_ (gdouble a)
{
	gdouble result;
	result = tan (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda18__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda18_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda19_ (gdouble a)
{
	gdouble result;
	result = sinh (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda19__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda19_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda20_ (gdouble a)
{
	gdouble result;
	result = cosh (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda20__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda20_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda21_ (gdouble a)
{
	gdouble result;
	result = tanh (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda21__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda21_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda22_ (gdouble a)
{
	gdouble result;
	result = log10 (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda22__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda22_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda23_ (gdouble a)
{
	gdouble result;
	result = log (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda23__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda23_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda24_ (gdouble a)
{
	gdouble result;
	result = exp (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda24__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda24_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda25_ (gdouble a)
{
	gdouble result;
	result = sqrt (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda25__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda25_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda26_ (gdouble a)
{
	gdouble result;
	result = sqrt (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda26__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda26_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda27_ (gdouble a)
{
	gdouble result;
	result = asin (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda27__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda27_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda28_ (gdouble a)
{
	gdouble result;
	result = acos (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda28__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda28_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_functions_lambda29_ (gdouble a)
{
	gdouble result;
	result = atan (a);
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_functions_lambda29__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_functions_lambda29_ (a);
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_constants_lambda30_ (void)
{
	gdouble result;
	result = G_PI;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_constants_lambda30__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_constants_lambda30_ ();
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_constants_lambda31_ (void)
{
	gdouble result;
	result = G_PI;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_constants_lambda31__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_constants_lambda31_ ();
	return result;
}

static gdouble
_pantheon_calculator_core_evaluation_constants_lambda32_ (void)
{
	gdouble result;
	result = G_E;
	return result;
}

static gdouble
__pantheon_calculator_core_evaluation_constants_lambda32__pantheon_calculator_core_evaluation_eval (gdouble a,
                                                                                                    gdouble b)
{
	gdouble result;
	result = _pantheon_calculator_core_evaluation_constants_lambda32_ ();
	return result;
}

PantheonCalculatorCoreEvaluation*
pantheon_calculator_core_evaluation_construct (GType object_type)
{
	PantheonCalculatorCoreEvaluation * self = NULL;
	self = (PantheonCalculatorCoreEvaluation*) g_object_new (object_type, NULL);
	return self;
}

PantheonCalculatorCoreEvaluation*
pantheon_calculator_core_evaluation_new (void)
{
	return pantheon_calculator_core_evaluation_construct (PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gchar*
pantheon_calculator_core_evaluation_evaluate (PantheonCalculatorCoreEvaluation* self,
                                              const gchar* str,
                                              gint d_places,
                                              GError** error)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (str != NULL, NULL);
	{
		GList* tokenlist = NULL;
		PantheonCalculatorCoreScanner* _tmp0_;
		GList* _tmp1_;
		gdouble d = 0.0;
		gchar* _tmp14_;
		_tmp0_ = self->scanner;
		_tmp1_ = pantheon_calculator_core_scanner_scan (_tmp0_, str, &_inner_error0_);
		tokenlist = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		d = 0.0;
		{
			GList* _tmp2_ = NULL;
			GList* _tmp3_;
			GList* _tmp4_;
			GList* _tmp5_;
			_tmp3_ = tokenlist;
			_tmp4_ = pantheon_calculator_core_evaluation_shunting_yard (self, _tmp3_, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			(tokenlist == NULL) ? NULL : (tokenlist = (_g_list_free__g_object_unref0_ (tokenlist), NULL));
			tokenlist = _tmp5_;
			{
				gdouble _tmp6_ = 0.0;
				GList* _tmp7_;
				_tmp7_ = tokenlist;
				_tmp6_ = pantheon_calculator_core_evaluation_eval_postfix (self, _tmp7_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				d = _tmp6_;
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp8_;
				const gchar* _tmp9_;
				GError* _tmp10_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = e;
				_tmp9_ = _tmp8_->message;
				_tmp10_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_OUT_ERROR, PANTHEON_CALCULATOR_CORE_OUT_ERROR_EVAL_ERROR, _tmp9_);
				_inner_error0_ = _tmp10_;
				_g_error_free0 (e);
				goto __finally2;
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
				goto __catch1_g_error;
			}
			(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			GError* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			_tmp13_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_OUT_ERROR, PANTHEON_CALCULATOR_CORE_OUT_ERROR_SHUNTING_ERROR, _tmp12_);
			_inner_error0_ = _tmp13_;
			_g_error_free0 (e);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(tokenlist == NULL) ? NULL : (tokenlist = (_g_list_free__g_object_unref0_ (tokenlist), NULL));
			goto __catch0_g_error;
		}
		_tmp14_ = pantheon_calculator_core_evaluation_number_to_string (self, d, d_places);
		result = _tmp14_;
		(tokenlist == NULL) ? NULL : (tokenlist = (_g_list_free__g_object_unref0_ (tokenlist), NULL));
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		GError* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		_tmp17_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_OUT_ERROR, PANTHEON_CALCULATOR_CORE_OUT_ERROR_SCANNER_ERROR, _tmp16_);
		_inner_error0_ = _tmp17_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_OUT_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GList*
pantheon_calculator_core_evaluation_shunting_yard (PantheonCalculatorCoreEvaluation* self,
                                                   GList* token_list,
                                                   GError** error)
{
	GList* output = NULL;
	GQueue* op_stack = NULL;
	GQueue* _tmp0_;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	output = NULL;
	_tmp0_ = g_queue_new ();
	op_stack = _tmp0_;
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
		t_collection = token_list;
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
			PantheonCalculatorCoreToken* _tmp1_;
			PantheonCalculatorCoreToken* t = NULL;
			_tmp1_ = _g_object_ref0 ((PantheonCalculatorCoreToken*) t_it->data);
			t = _tmp1_;
			{
				PantheonCalculatorCoreToken* _tmp2_;
				PantheonCalculatorCoreTokenType _tmp3_;
				PantheonCalculatorCoreTokenType _tmp4_;
				_tmp2_ = t;
				_tmp3_ = pantheon_calculator_core_token_get_token_type (_tmp2_);
				_tmp4_ = _tmp3_;
				switch (_tmp4_) {
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER:
					{
						PantheonCalculatorCoreToken* _tmp5_;
						PantheonCalculatorCoreToken* _tmp6_;
						_tmp5_ = t;
						_tmp6_ = _g_object_ref0 (_tmp5_);
						output = g_list_append (output, _tmp6_);
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT:
					{
						PantheonCalculatorCoreToken* _tmp7_;
						PantheonCalculatorCoreToken* _tmp8_;
						_tmp7_ = t;
						_tmp8_ = _g_object_ref0 (_tmp7_);
						output = g_list_append (output, _tmp8_);
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION:
					{
						GQueue* _tmp9_;
						PantheonCalculatorCoreToken* _tmp10_;
						PantheonCalculatorCoreToken* _tmp11_;
						_tmp9_ = op_stack;
						_tmp10_ = t;
						_tmp11_ = _g_object_ref0 (_tmp10_);
						g_queue_push_tail (_tmp9_, _tmp11_);
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_SEPARATOR:
					{
						GQueue* _tmp20_;
						gconstpointer _tmp21_;
						PantheonCalculatorCoreTokenType _tmp22_;
						PantheonCalculatorCoreTokenType _tmp23_;
						while (TRUE) {
							gboolean _tmp12_ = FALSE;
							GQueue* _tmp13_;
							GQueue* _tmp18_;
							gpointer _tmp19_;
							_tmp13_ = op_stack;
							if (!g_queue_is_empty (_tmp13_)) {
								GQueue* _tmp14_;
								gconstpointer _tmp15_;
								PantheonCalculatorCoreTokenType _tmp16_;
								PantheonCalculatorCoreTokenType _tmp17_;
								_tmp14_ = op_stack;
								_tmp15_ = g_queue_peek_tail (_tmp14_);
								_tmp16_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp15_);
								_tmp17_ = _tmp16_;
								_tmp12_ = _tmp17_ != PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT;
							} else {
								_tmp12_ = FALSE;
							}
							if (!_tmp12_) {
								break;
							}
							_tmp18_ = op_stack;
							_tmp19_ = g_queue_pop_tail (_tmp18_);
							output = g_list_append (output, (PantheonCalculatorCoreToken*) _tmp19_);
						}
						_tmp20_ = op_stack;
						_tmp21_ = g_queue_peek_tail (_tmp20_);
						_tmp22_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp21_);
						_tmp23_ = _tmp22_;
						if (_tmp23_ != PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT) {
							GError* _tmp24_;
							_tmp24_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_MISMATCHED_P, "Content of parentheses is mismatched.");
							_inner_error0_ = _tmp24_;
							if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (t);
								(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
								(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
								return NULL;
							} else {
								_g_object_unref0 (t);
								(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
								(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR:
					{
						GQueue* _tmp25_;
						GQueue* _tmp59_;
						PantheonCalculatorCoreToken* _tmp60_;
						PantheonCalculatorCoreToken* _tmp61_;
						_tmp25_ = op_stack;
						if (!g_queue_is_empty (_tmp25_)) {
							PantheonCalculatorCoreEvaluationOperator op1 = {0};
							PantheonCalculatorCoreToken* _tmp26_;
							PantheonCalculatorCoreEvaluationOperator _tmp27_ = {0};
							PantheonCalculatorCoreEvaluationOperator op2 = {0};
							_tmp26_ = t;
							pantheon_calculator_core_evaluation_get_operator (self, _tmp26_, &_tmp27_, &_inner_error0_);
							op1 = _tmp27_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
									g_propagate_error (error, _inner_error0_);
									_g_object_unref0 (t);
									(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
									(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
									return NULL;
								} else {
									_g_object_unref0 (t);
									(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
									(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							memset (&op2, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
							{
								PantheonCalculatorCoreEvaluationOperator _tmp28_ = {0};
								GQueue* _tmp29_;
								gconstpointer _tmp30_;
								PantheonCalculatorCoreEvaluationOperator _tmp31_ = {0};
								PantheonCalculatorCoreEvaluationOperator _tmp32_;
								_tmp29_ = op_stack;
								_tmp30_ = g_queue_peek_tail (_tmp29_);
								pantheon_calculator_core_evaluation_get_operator (self, (PantheonCalculatorCoreToken*) _tmp30_, &_tmp31_, &_inner_error0_);
								_tmp28_ = _tmp31_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
										goto __catch0_pantheon_calculator_core_shunting_error;
									}
									pantheon_calculator_core_evaluation_operator_destroy (&op2);
									pantheon_calculator_core_evaluation_operator_destroy (&op1);
									_g_object_unref0 (t);
									(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
									(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
								_tmp32_ = _tmp28_;
								memset (&_tmp28_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
								pantheon_calculator_core_evaluation_operator_destroy (&op2);
								op2 = _tmp32_;
								pantheon_calculator_core_evaluation_operator_destroy (&_tmp28_);
							}
							goto __finally0;
							__catch0_pantheon_calculator_core_shunting_error:
							{
								g_clear_error (&_inner_error0_);
							}
							__finally0:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
									g_propagate_error (error, _inner_error0_);
									pantheon_calculator_core_evaluation_operator_destroy (&op2);
									pantheon_calculator_core_evaluation_operator_destroy (&op1);
									_g_object_unref0 (t);
									(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
									(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
									return NULL;
								} else {
									pantheon_calculator_core_evaluation_operator_destroy (&op2);
									pantheon_calculator_core_evaluation_operator_destroy (&op1);
									_g_object_unref0 (t);
									(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
									(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
							}
							while (TRUE) {
								gboolean _tmp33_ = FALSE;
								gboolean _tmp34_ = FALSE;
								GQueue* _tmp35_;
								GQueue* _tmp51_;
								gpointer _tmp52_;
								GQueue* _tmp53_;
								_tmp35_ = op_stack;
								if (!g_queue_is_empty (_tmp35_)) {
									GQueue* _tmp36_;
									gconstpointer _tmp37_;
									PantheonCalculatorCoreTokenType _tmp38_;
									PantheonCalculatorCoreTokenType _tmp39_;
									_tmp36_ = op_stack;
									_tmp37_ = g_queue_peek_tail (_tmp36_);
									_tmp38_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp37_);
									_tmp39_ = _tmp38_;
									_tmp34_ = _tmp39_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR;
								} else {
									_tmp34_ = FALSE;
								}
								if (_tmp34_) {
									gboolean _tmp40_ = FALSE;
									gboolean _tmp41_ = FALSE;
									PantheonCalculatorCoreEvaluationOperator _tmp42_;
									const gchar* _tmp43_;
									_tmp42_ = op2;
									_tmp43_ = _tmp42_.fixity;
									if (g_strcmp0 (_tmp43_, "LEFT") == 0) {
										PantheonCalculatorCoreEvaluationOperator _tmp44_;
										PantheonCalculatorCoreEvaluationOperator _tmp45_;
										_tmp44_ = op1;
										_tmp45_ = op2;
										_tmp41_ = _tmp44_.prec <= _tmp45_.prec;
									} else {
										_tmp41_ = FALSE;
									}
									if (_tmp41_) {
										_tmp40_ = TRUE;
									} else {
										gboolean _tmp46_ = FALSE;
										PantheonCalculatorCoreEvaluationOperator _tmp47_;
										const gchar* _tmp48_;
										_tmp47_ = op2;
										_tmp48_ = _tmp47_.fixity;
										if (g_strcmp0 (_tmp48_, "RIGHT") == 0) {
											PantheonCalculatorCoreEvaluationOperator _tmp49_;
											PantheonCalculatorCoreEvaluationOperator _tmp50_;
											_tmp49_ = op1;
											_tmp50_ = op2;
											_tmp46_ = _tmp49_.prec < _tmp50_.prec;
										} else {
											_tmp46_ = FALSE;
										}
										_tmp40_ = _tmp46_;
									}
									_tmp33_ = _tmp40_;
								} else {
									_tmp33_ = FALSE;
								}
								if (!_tmp33_) {
									break;
								}
								_tmp51_ = op_stack;
								_tmp52_ = g_queue_pop_tail (_tmp51_);
								output = g_list_append (output, (PantheonCalculatorCoreToken*) _tmp52_);
								_tmp53_ = op_stack;
								if (!g_queue_is_empty (_tmp53_)) {
									{
										PantheonCalculatorCoreEvaluationOperator _tmp54_ = {0};
										GQueue* _tmp55_;
										gconstpointer _tmp56_;
										PantheonCalculatorCoreEvaluationOperator _tmp57_ = {0};
										PantheonCalculatorCoreEvaluationOperator _tmp58_;
										_tmp55_ = op_stack;
										_tmp56_ = g_queue_peek_tail (_tmp55_);
										pantheon_calculator_core_evaluation_get_operator (self, (PantheonCalculatorCoreToken*) _tmp56_, &_tmp57_, &_inner_error0_);
										_tmp54_ = _tmp57_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
												goto __catch1_pantheon_calculator_core_shunting_error;
											}
											pantheon_calculator_core_evaluation_operator_destroy (&op2);
											pantheon_calculator_core_evaluation_operator_destroy (&op1);
											_g_object_unref0 (t);
											(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
											(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return NULL;
										}
										_tmp58_ = _tmp54_;
										memset (&_tmp54_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
										pantheon_calculator_core_evaluation_operator_destroy (&op2);
										op2 = _tmp58_;
										pantheon_calculator_core_evaluation_operator_destroy (&_tmp54_);
									}
									goto __finally1;
									__catch1_pantheon_calculator_core_shunting_error:
									{
										g_clear_error (&_inner_error0_);
									}
									__finally1:
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
											g_propagate_error (error, _inner_error0_);
											pantheon_calculator_core_evaluation_operator_destroy (&op2);
											pantheon_calculator_core_evaluation_operator_destroy (&op1);
											_g_object_unref0 (t);
											(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
											(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
											return NULL;
										} else {
											pantheon_calculator_core_evaluation_operator_destroy (&op2);
											pantheon_calculator_core_evaluation_operator_destroy (&op1);
											_g_object_unref0 (t);
											(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
											(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return NULL;
										}
									}
								}
							}
							pantheon_calculator_core_evaluation_operator_destroy (&op2);
							pantheon_calculator_core_evaluation_operator_destroy (&op1);
						}
						_tmp59_ = op_stack;
						_tmp60_ = t;
						_tmp61_ = _g_object_ref0 (_tmp60_);
						g_queue_push_tail (_tmp59_, _tmp61_);
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT:
					{
						GQueue* _tmp62_;
						PantheonCalculatorCoreToken* _tmp63_;
						PantheonCalculatorCoreToken* _tmp64_;
						_tmp62_ = op_stack;
						_tmp63_ = t;
						_tmp64_ = _g_object_ref0 (_tmp63_);
						g_queue_push_tail (_tmp62_, _tmp64_);
						break;
					}
					case PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT:
					{
						gboolean _tmp72_ = FALSE;
						GQueue* _tmp73_;
						gboolean _tmp81_ = FALSE;
						GQueue* _tmp82_;
						while (TRUE) {
							GQueue* _tmp65_;
							GQueue* _tmp66_;
							gconstpointer _tmp67_;
							PantheonCalculatorCoreTokenType _tmp68_;
							PantheonCalculatorCoreTokenType _tmp69_;
							_tmp65_ = op_stack;
							if (!(!g_queue_is_empty (_tmp65_))) {
								break;
							}
							_tmp66_ = op_stack;
							_tmp67_ = g_queue_peek_tail (_tmp66_);
							_tmp68_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp67_);
							_tmp69_ = _tmp68_;
							if (_tmp69_ != PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT) {
								GQueue* _tmp70_;
								gpointer _tmp71_;
								_tmp70_ = op_stack;
								_tmp71_ = g_queue_pop_tail (_tmp70_);
								output = g_list_append (output, (PantheonCalculatorCoreToken*) _tmp71_);
							} else {
								break;
							}
						}
						_tmp73_ = op_stack;
						if (!g_queue_is_empty (_tmp73_)) {
							GQueue* _tmp74_;
							gconstpointer _tmp75_;
							PantheonCalculatorCoreTokenType _tmp76_;
							PantheonCalculatorCoreTokenType _tmp77_;
							_tmp74_ = op_stack;
							_tmp75_ = g_queue_peek_tail (_tmp74_);
							_tmp76_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp75_);
							_tmp77_ = _tmp76_;
							_tmp72_ = _tmp77_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT;
						} else {
							_tmp72_ = FALSE;
						}
						if (_tmp72_) {
							GQueue* _tmp78_;
							gpointer _tmp79_;
							PantheonCalculatorCoreToken* _tmp80_;
							_tmp78_ = op_stack;
							_tmp79_ = g_queue_pop_tail (_tmp78_);
							_tmp80_ = (PantheonCalculatorCoreToken*) _tmp79_;
							_g_object_unref0 (_tmp80_);
						}
						_tmp82_ = op_stack;
						if (!g_queue_is_empty (_tmp82_)) {
							GQueue* _tmp83_;
							gconstpointer _tmp84_;
							PantheonCalculatorCoreTokenType _tmp85_;
							PantheonCalculatorCoreTokenType _tmp86_;
							_tmp83_ = op_stack;
							_tmp84_ = g_queue_peek_tail (_tmp83_);
							_tmp85_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp84_);
							_tmp86_ = _tmp85_;
							_tmp81_ = _tmp86_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION;
						} else {
							_tmp81_ = FALSE;
						}
						if (_tmp81_) {
							GQueue* _tmp87_;
							gpointer _tmp88_;
							_tmp87_ = op_stack;
							_tmp88_ = g_queue_pop_tail (_tmp87_);
							output = g_list_append (output, (PantheonCalculatorCoreToken*) _tmp88_);
						}
						break;
					}
					default:
					{
						PantheonCalculatorCoreToken* _tmp89_;
						const gchar* _tmp90_;
						const gchar* _tmp91_;
						GError* _tmp92_;
						_tmp89_ = t;
						_tmp90_ = pantheon_calculator_core_token_get_content (_tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = g_error_new (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_UNKNOWN_TOKEN, "'%s' is unknown.", _tmp91_);
						_inner_error0_ = _tmp92_;
						if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (t);
							(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
							(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
							return NULL;
						} else {
							_g_object_unref0 (t);
							(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
							(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
				_g_object_unref0 (t);
			}
		}
	}
	while (TRUE) {
		GQueue* _tmp93_;
		gboolean _tmp94_ = FALSE;
		GQueue* _tmp95_;
		gconstpointer _tmp96_;
		PantheonCalculatorCoreTokenType _tmp97_;
		PantheonCalculatorCoreTokenType _tmp98_;
		_tmp93_ = op_stack;
		if (!(!g_queue_is_empty (_tmp93_))) {
			break;
		}
		_tmp95_ = op_stack;
		_tmp96_ = g_queue_peek_tail (_tmp95_);
		_tmp97_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp96_);
		_tmp98_ = _tmp97_;
		if (_tmp98_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_LEFT) {
			_tmp94_ = TRUE;
		} else {
			GQueue* _tmp99_;
			gconstpointer _tmp100_;
			PantheonCalculatorCoreTokenType _tmp101_;
			PantheonCalculatorCoreTokenType _tmp102_;
			_tmp99_ = op_stack;
			_tmp100_ = g_queue_peek_tail (_tmp99_);
			_tmp101_ = pantheon_calculator_core_token_get_token_type ((PantheonCalculatorCoreToken*) _tmp100_);
			_tmp102_ = _tmp101_;
			_tmp94_ = _tmp102_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_P_RIGHT;
		}
		if (_tmp94_) {
			GError* _tmp103_;
			_tmp103_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_MISMATCHED_P, "Mismatched parenthesis.");
			_inner_error0_ = _tmp103_;
			if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
				g_propagate_error (error, _inner_error0_);
				(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
				(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
				return NULL;
			} else {
				(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
				(output == NULL) ? NULL : (output = (_g_list_free__g_object_unref0_ (output), NULL));
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		} else {
			GQueue* _tmp104_;
			gpointer _tmp105_;
			_tmp104_ = op_stack;
			_tmp105_ = g_queue_pop_tail (_tmp104_);
			output = g_list_append (output, (PantheonCalculatorCoreToken*) _tmp105_);
		}
	}
	result = output;
	(op_stack == NULL) ? NULL : (op_stack = (_g_queue_free__g_object_unref0_ (op_stack), NULL));
	return result;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gdouble
pantheon_calculator_core_evaluation_eval_postfix (PantheonCalculatorCoreEvaluation* self,
                                                  GList* token_list,
                                                  GError** error)
{
	GQueue* stack = NULL;
	GQueue* _tmp0_;
	GQueue* _tmp73_;
	gpointer _tmp74_;
	PantheonCalculatorCoreToken* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	gdouble _tmp78_;
	GError* _inner_error0_ = NULL;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = g_queue_new ();
	stack = _tmp0_;
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
		t_collection = token_list;
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
			PantheonCalculatorCoreToken* _tmp1_;
			PantheonCalculatorCoreToken* t = NULL;
			_tmp1_ = _g_object_ref0 ((PantheonCalculatorCoreToken*) t_it->data);
			t = _tmp1_;
			{
				PantheonCalculatorCoreToken* _tmp2_;
				PantheonCalculatorCoreTokenType _tmp3_;
				PantheonCalculatorCoreTokenType _tmp4_;
				_tmp2_ = t;
				_tmp3_ = pantheon_calculator_core_token_get_token_type (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER) {
					GQueue* _tmp5_;
					PantheonCalculatorCoreToken* _tmp6_;
					PantheonCalculatorCoreToken* _tmp7_;
					_tmp5_ = stack;
					_tmp6_ = t;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					g_queue_push_tail (_tmp5_, _tmp7_);
				} else {
					PantheonCalculatorCoreToken* _tmp8_;
					PantheonCalculatorCoreTokenType _tmp9_;
					PantheonCalculatorCoreTokenType _tmp10_;
					_tmp8_ = t;
					_tmp9_ = pantheon_calculator_core_token_get_token_type (_tmp8_);
					_tmp10_ = _tmp9_;
					if (_tmp10_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_CONSTANT) {
						{
							PantheonCalculatorCoreEvaluationConstant c = {0};
							PantheonCalculatorCoreToken* _tmp11_;
							PantheonCalculatorCoreEvaluationConstant _tmp12_ = {0};
							GQueue* _tmp14_;
							PantheonCalculatorCoreEvaluationConstant _tmp15_;
							PantheonCalculatorCoreEvaluationEval _tmp16_;
							gchar* _tmp17_;
							gchar* _tmp18_;
							PantheonCalculatorCoreToken* _tmp19_;
							_tmp11_ = t;
							pantheon_calculator_core_evaluation_get_constant (self, _tmp11_, &_tmp12_, &_inner_error0_);
							c = _tmp12_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								gdouble _tmp13_ = -1.0;
								if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
									goto __catch0_pantheon_calculator_core_shunting_error;
								}
								_g_object_unref0 (t);
								(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp13_;
							}
							_tmp14_ = stack;
							_tmp15_ = c;
							_tmp16_ = _tmp15_.eval;
							_tmp17_ = double_to_string (_tmp16_ ((gdouble) 0, (gdouble) 0));
							_tmp18_ = _tmp17_;
							_tmp19_ = pantheon_calculator_core_token_new (_tmp18_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER);
							g_queue_push_tail (_tmp14_, _tmp19_);
							_g_free0 (_tmp18_);
							pantheon_calculator_core_evaluation_constant_destroy (&c);
						}
						goto __finally0;
						__catch0_pantheon_calculator_core_shunting_error:
						{
							GError* _tmp20_;
							g_clear_error (&_inner_error0_);
							_tmp20_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_EVAL_ERROR, PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_CONSTANT, "");
							_inner_error0_ = _tmp20_;
							goto __finally0;
						}
						__finally0:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_EVAL_ERROR) {
								gdouble _tmp21_ = -1.0;
								g_propagate_error (error, _inner_error0_);
								_g_object_unref0 (t);
								(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
								return _tmp21_;
							} else {
								gdouble _tmp22_ = -1.0;
								_g_object_unref0 (t);
								(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return _tmp22_;
							}
						}
					} else {
						PantheonCalculatorCoreToken* _tmp23_;
						PantheonCalculatorCoreTokenType _tmp24_;
						PantheonCalculatorCoreTokenType _tmp25_;
						_tmp23_ = t;
						_tmp24_ = pantheon_calculator_core_token_get_token_type (_tmp23_);
						_tmp25_ = _tmp24_;
						if (_tmp25_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_OPERATOR) {
							{
								PantheonCalculatorCoreEvaluationOperator o = {0};
								PantheonCalculatorCoreToken* _tmp26_;
								PantheonCalculatorCoreEvaluationOperator _tmp27_ = {0};
								PantheonCalculatorCoreToken* t1 = NULL;
								GQueue* _tmp29_;
								gpointer _tmp30_;
								PantheonCalculatorCoreToken* t2 = NULL;
								PantheonCalculatorCoreToken* _tmp31_;
								gboolean _tmp32_ = FALSE;
								GQueue* _tmp33_;
								PantheonCalculatorCoreToken* _tmp37_ = NULL;
								PantheonCalculatorCoreEvaluationOperator _tmp38_;
								PantheonCalculatorCoreEvaluationEval _tmp39_;
								PantheonCalculatorCoreToken* _tmp40_;
								PantheonCalculatorCoreToken* _tmp41_;
								PantheonCalculatorCoreToken* _tmp42_;
								GQueue* _tmp43_;
								PantheonCalculatorCoreToken* _tmp44_;
								_tmp26_ = t;
								pantheon_calculator_core_evaluation_get_operator (self, _tmp26_, &_tmp27_, &_inner_error0_);
								o = _tmp27_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									gdouble _tmp28_ = -1.0;
									if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
										goto __catch1_pantheon_calculator_core_shunting_error;
									}
									_g_object_unref0 (t);
									(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return _tmp28_;
								}
								_tmp29_ = stack;
								_tmp30_ = g_queue_pop_tail (_tmp29_);
								t1 = (PantheonCalculatorCoreToken*) _tmp30_;
								_tmp31_ = pantheon_calculator_core_token_new ("0", PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER);
								t2 = _tmp31_;
								_tmp33_ = stack;
								if (!g_queue_is_empty (_tmp33_)) {
									PantheonCalculatorCoreEvaluationOperator _tmp34_;
									_tmp34_ = o;
									_tmp32_ = _tmp34_.inputs == 2;
								} else {
									_tmp32_ = FALSE;
								}
								if (_tmp32_) {
									GQueue* _tmp35_;
									gpointer _tmp36_;
									_tmp35_ = stack;
									_tmp36_ = g_queue_pop_tail (_tmp35_);
									_g_object_unref0 (t2);
									t2 = (PantheonCalculatorCoreToken*) _tmp36_;
								}
								_tmp38_ = o;
								_tmp39_ = _tmp38_.eval;
								_tmp40_ = t2;
								_tmp41_ = t1;
								_tmp42_ = pantheon_calculator_core_evaluation_compute (self, _tmp39_, _tmp40_, _tmp41_, &_inner_error0_);
								_tmp37_ = _tmp42_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									_g_object_unref0 (t2);
									_g_object_unref0 (t1);
									pantheon_calculator_core_evaluation_operator_destroy (&o);
									if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
										goto __catch1_pantheon_calculator_core_shunting_error;
									}
									goto __finally1;
								}
								_tmp43_ = stack;
								_tmp44_ = _tmp37_;
								_tmp37_ = NULL;
								g_queue_push_tail (_tmp43_, _tmp44_);
								_g_object_unref0 (_tmp37_);
								_g_object_unref0 (t2);
								_g_object_unref0 (t1);
								pantheon_calculator_core_evaluation_operator_destroy (&o);
							}
							goto __finally1;
							__catch1_pantheon_calculator_core_shunting_error:
							{
								GError* _tmp45_;
								g_clear_error (&_inner_error0_);
								_tmp45_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_EVAL_ERROR, PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_OPERATOR, "");
								_inner_error0_ = _tmp45_;
								goto __finally1;
							}
							__finally1:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_EVAL_ERROR) {
									gdouble _tmp46_ = -1.0;
									g_propagate_error (error, _inner_error0_);
									_g_object_unref0 (t);
									(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
									return _tmp46_;
								} else {
									gdouble _tmp47_ = -1.0;
									_g_object_unref0 (t);
									(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return _tmp47_;
								}
							}
						} else {
							PantheonCalculatorCoreToken* _tmp48_;
							PantheonCalculatorCoreTokenType _tmp49_;
							PantheonCalculatorCoreTokenType _tmp50_;
							_tmp48_ = t;
							_tmp49_ = pantheon_calculator_core_token_get_token_type (_tmp48_);
							_tmp50_ = _tmp49_;
							if (_tmp50_ == PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_FUNCTION) {
								{
									PantheonCalculatorCoreEvaluationFunction f = {0};
									PantheonCalculatorCoreToken* _tmp51_;
									PantheonCalculatorCoreEvaluationFunction _tmp52_ = {0};
									PantheonCalculatorCoreToken* t1 = NULL;
									GQueue* _tmp54_;
									gpointer _tmp55_;
									PantheonCalculatorCoreToken* t2 = NULL;
									PantheonCalculatorCoreToken* _tmp56_;
									gboolean _tmp57_ = FALSE;
									GQueue* _tmp58_;
									PantheonCalculatorCoreToken* _tmp62_ = NULL;
									PantheonCalculatorCoreEvaluationFunction _tmp63_;
									PantheonCalculatorCoreEvaluationEval _tmp64_;
									PantheonCalculatorCoreToken* _tmp65_;
									PantheonCalculatorCoreToken* _tmp66_;
									PantheonCalculatorCoreToken* _tmp67_;
									GQueue* _tmp68_;
									PantheonCalculatorCoreToken* _tmp69_;
									_tmp51_ = t;
									pantheon_calculator_core_evaluation_get_function (self, _tmp51_, &_tmp52_, &_inner_error0_);
									f = _tmp52_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										gdouble _tmp53_ = -1.0;
										if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
											goto __catch2_pantheon_calculator_core_shunting_error;
										}
										_g_object_unref0 (t);
										(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return _tmp53_;
									}
									_tmp54_ = stack;
									_tmp55_ = g_queue_pop_tail (_tmp54_);
									t1 = (PantheonCalculatorCoreToken*) _tmp55_;
									_tmp56_ = pantheon_calculator_core_token_new ("0", PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER);
									t2 = _tmp56_;
									_tmp58_ = stack;
									if (!g_queue_is_empty (_tmp58_)) {
										PantheonCalculatorCoreEvaluationFunction _tmp59_;
										_tmp59_ = f;
										_tmp57_ = _tmp59_.inputs == 2;
									} else {
										_tmp57_ = FALSE;
									}
									if (_tmp57_) {
										GQueue* _tmp60_;
										gpointer _tmp61_;
										_tmp60_ = stack;
										_tmp61_ = g_queue_pop_tail (_tmp60_);
										_g_object_unref0 (t2);
										t2 = (PantheonCalculatorCoreToken*) _tmp61_;
									}
									_tmp63_ = f;
									_tmp64_ = _tmp63_.eval;
									_tmp65_ = t1;
									_tmp66_ = t2;
									_tmp67_ = pantheon_calculator_core_evaluation_compute (self, _tmp64_, _tmp65_, _tmp66_, &_inner_error0_);
									_tmp62_ = _tmp67_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_object_unref0 (t2);
										_g_object_unref0 (t1);
										pantheon_calculator_core_evaluation_function_destroy (&f);
										if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
											goto __catch2_pantheon_calculator_core_shunting_error;
										}
										goto __finally2;
									}
									_tmp68_ = stack;
									_tmp69_ = _tmp62_;
									_tmp62_ = NULL;
									g_queue_push_tail (_tmp68_, _tmp69_);
									_g_object_unref0 (_tmp62_);
									_g_object_unref0 (t2);
									_g_object_unref0 (t1);
									pantheon_calculator_core_evaluation_function_destroy (&f);
								}
								goto __finally2;
								__catch2_pantheon_calculator_core_shunting_error:
								{
									GError* _tmp70_;
									g_clear_error (&_inner_error0_);
									_tmp70_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_EVAL_ERROR, PANTHEON_CALCULATOR_CORE_EVAL_ERROR_NO_FUNCTION, "");
									_inner_error0_ = _tmp70_;
									goto __finally2;
								}
								__finally2:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_EVAL_ERROR) {
										gdouble _tmp71_ = -1.0;
										g_propagate_error (error, _inner_error0_);
										_g_object_unref0 (t);
										(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
										return _tmp71_;
									} else {
										gdouble _tmp72_ = -1.0;
										_g_object_unref0 (t);
										(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return _tmp72_;
									}
								}
							}
						}
					}
				}
				_g_object_unref0 (t);
			}
		}
	}
	_tmp73_ = stack;
	_tmp74_ = g_queue_pop_tail (_tmp73_);
	_tmp75_ = (PantheonCalculatorCoreToken*) _tmp74_;
	_tmp76_ = pantheon_calculator_core_token_get_content (_tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = double_parse (_tmp77_);
	_g_object_unref0 (_tmp75_);
	result = _tmp78_;
	(stack == NULL) ? NULL : (stack = (_g_queue_free__g_object_unref0_ (stack), NULL));
	return result;
}

gboolean
pantheon_calculator_core_evaluation_is_operator (PantheonCalculatorCoreToken* t)
{
	PantheonCalculatorCoreEvaluationOperator* _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = pantheon_calculator_core_evaluation_operators;
	_tmp0__length1 = pantheon_calculator_core_evaluation_operators_length1;
	{
		PantheonCalculatorCoreEvaluationOperator* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < o_collection_length1; o_it = o_it + 1) {
			PantheonCalculatorCoreEvaluationOperator _tmp1_;
			PantheonCalculatorCoreEvaluationOperator _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationOperator o = {0};
			_tmp1_ = o_collection[o_it];
			pantheon_calculator_core_evaluation_operator_copy (&_tmp1_, &_tmp2_);
			o = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationOperator _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = o;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					result = TRUE;
					pantheon_calculator_core_evaluation_operator_destroy (&o);
					return result;
				}
				pantheon_calculator_core_evaluation_operator_destroy (&o);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
pantheon_calculator_core_evaluation_is_function (PantheonCalculatorCoreToken* t)
{
	PantheonCalculatorCoreEvaluationFunction* _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = pantheon_calculator_core_evaluation_functions;
	_tmp0__length1 = pantheon_calculator_core_evaluation_functions_length1;
	{
		PantheonCalculatorCoreEvaluationFunction* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp0_;
		f_collection_length1 = _tmp0__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			PantheonCalculatorCoreEvaluationFunction _tmp1_;
			PantheonCalculatorCoreEvaluationFunction _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationFunction f = {0};
			_tmp1_ = f_collection[f_it];
			pantheon_calculator_core_evaluation_function_copy (&_tmp1_, &_tmp2_);
			f = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationFunction _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = f;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					result = TRUE;
					pantheon_calculator_core_evaluation_function_destroy (&f);
					return result;
				}
				pantheon_calculator_core_evaluation_function_destroy (&f);
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
pantheon_calculator_core_evaluation_is_constant (PantheonCalculatorCoreToken* t)
{
	PantheonCalculatorCoreEvaluationConstant* _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = pantheon_calculator_core_evaluation_constants;
	_tmp0__length1 = pantheon_calculator_core_evaluation_constants_length1;
	{
		PantheonCalculatorCoreEvaluationConstant* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			PantheonCalculatorCoreEvaluationConstant _tmp1_;
			PantheonCalculatorCoreEvaluationConstant _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationConstant c = {0};
			_tmp1_ = c_collection[c_it];
			pantheon_calculator_core_evaluation_constant_copy (&_tmp1_, &_tmp2_);
			c = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationConstant _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = c;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					result = TRUE;
					pantheon_calculator_core_evaluation_constant_destroy (&c);
					return result;
				}
				pantheon_calculator_core_evaluation_constant_destroy (&c);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
pantheon_calculator_core_evaluation_get_operator (PantheonCalculatorCoreEvaluation* self,
                                                  PantheonCalculatorCoreToken* t,
                                                  PantheonCalculatorCoreEvaluationOperator* result,
                                                  GError** error)
{
	PantheonCalculatorCoreEvaluationOperator* _tmp0_;
	gint _tmp0__length1;
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = pantheon_calculator_core_evaluation_operators;
	_tmp0__length1 = pantheon_calculator_core_evaluation_operators_length1;
	{
		PantheonCalculatorCoreEvaluationOperator* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp0_;
		o_collection_length1 = _tmp0__length1;
		for (o_it = 0; o_it < o_collection_length1; o_it = o_it + 1) {
			PantheonCalculatorCoreEvaluationOperator _tmp1_;
			PantheonCalculatorCoreEvaluationOperator _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationOperator o = {0};
			_tmp1_ = o_collection[o_it];
			pantheon_calculator_core_evaluation_operator_copy (&_tmp1_, &_tmp2_);
			o = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationOperator _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = o;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					*result = o;
					return;
				}
				pantheon_calculator_core_evaluation_operator_destroy (&o);
			}
		}
	}
	_tmp7_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_OPERATOR, "");
	_inner_error0_ = _tmp7_;
	if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pantheon_calculator_core_evaluation_get_function (PantheonCalculatorCoreEvaluation* self,
                                                  PantheonCalculatorCoreToken* t,
                                                  PantheonCalculatorCoreEvaluationFunction* result,
                                                  GError** error)
{
	PantheonCalculatorCoreEvaluationFunction* _tmp0_;
	gint _tmp0__length1;
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = pantheon_calculator_core_evaluation_functions;
	_tmp0__length1 = pantheon_calculator_core_evaluation_functions_length1;
	{
		PantheonCalculatorCoreEvaluationFunction* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
		f_collection = _tmp0_;
		f_collection_length1 = _tmp0__length1;
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
			PantheonCalculatorCoreEvaluationFunction _tmp1_;
			PantheonCalculatorCoreEvaluationFunction _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationFunction f = {0};
			_tmp1_ = f_collection[f_it];
			pantheon_calculator_core_evaluation_function_copy (&_tmp1_, &_tmp2_);
			f = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationFunction _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = f;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					*result = f;
					return;
				}
				pantheon_calculator_core_evaluation_function_destroy (&f);
			}
		}
	}
	_tmp7_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_FUNCTION, "");
	_inner_error0_ = _tmp7_;
	if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pantheon_calculator_core_evaluation_get_constant (PantheonCalculatorCoreEvaluation* self,
                                                  PantheonCalculatorCoreToken* t,
                                                  PantheonCalculatorCoreEvaluationConstant* result,
                                                  GError** error)
{
	PantheonCalculatorCoreEvaluationConstant* _tmp0_;
	gint _tmp0__length1;
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = pantheon_calculator_core_evaluation_constants;
	_tmp0__length1 = pantheon_calculator_core_evaluation_constants_length1;
	{
		PantheonCalculatorCoreEvaluationConstant* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp0_;
		c_collection_length1 = _tmp0__length1;
		for (c_it = 0; c_it < c_collection_length1; c_it = c_it + 1) {
			PantheonCalculatorCoreEvaluationConstant _tmp1_;
			PantheonCalculatorCoreEvaluationConstant _tmp2_ = {0};
			PantheonCalculatorCoreEvaluationConstant c = {0};
			_tmp1_ = c_collection[c_it];
			pantheon_calculator_core_evaluation_constant_copy (&_tmp1_, &_tmp2_);
			c = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				PantheonCalculatorCoreEvaluationConstant _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = pantheon_calculator_core_token_get_content (t);
				_tmp4_ = _tmp3_;
				_tmp5_ = c;
				_tmp6_ = _tmp5_.symbol;
				if (g_strcmp0 (_tmp4_, _tmp6_) == 0) {
					*result = c;
					return;
				}
				pantheon_calculator_core_evaluation_constant_destroy (&c);
			}
		}
	}
	_tmp7_ = g_error_new_literal (PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR, PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR_NO_CONSTANT, "");
	_inner_error0_ = _tmp7_;
	if (_inner_error0_->domain == PANTHEON_CALCULATOR_CORE_SHUNTING_ERROR) {
		g_propagate_error (error, _inner_error0_);
		return;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static PantheonCalculatorCoreToken*
pantheon_calculator_core_evaluation_compute (PantheonCalculatorCoreEvaluation* self,
                                             PantheonCalculatorCoreEvaluationEval eval,
                                             PantheonCalculatorCoreToken* t1,
                                             PantheonCalculatorCoreToken* t2,
                                             GError** error)
{
	gdouble d = 0.0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	PantheonCalculatorCoreToken* _tmp6_;
	PantheonCalculatorCoreToken* _tmp7_;
	PantheonCalculatorCoreToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t1 != NULL, NULL);
	g_return_val_if_fail (t2 != NULL, NULL);
	_tmp0_ = pantheon_calculator_core_token_get_content (t1);
	_tmp1_ = _tmp0_;
	_tmp2_ = pantheon_calculator_core_token_get_content (t2);
	_tmp3_ = _tmp2_;
	d = eval (double_parse (_tmp1_), double_parse (_tmp3_));
	if ((fabs (d) - 0.0) < DBL_EPSILON) {
		d = 0.0;
	}
	_tmp4_ = double_to_string (d);
	_tmp5_ = _tmp4_;
	_tmp6_ = pantheon_calculator_core_token_new (_tmp5_, PANTHEON_CALCULATOR_CORE_TOKEN_TYPE_NUMBER);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	result = _tmp7_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
pantheon_calculator_core_evaluation_number_to_string (PantheonCalculatorCoreEvaluation* self,
                                                      gdouble d,
                                                      gint d_places)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* s_localized = NULL;
	const gchar* _tmp1_;
	PantheonCalculatorCoreScanner* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp9_;
	PantheonCalculatorCoreScanner* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GString* builder = NULL;
	const gchar* _tmp15_;
	GString* _tmp16_;
	gint decimal_pos = 0;
	const gchar* _tmp17_;
	PantheonCalculatorCoreScanner* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint end_position = 0;
	const gchar* _tmp24_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%.9f", d);
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = self->scanner;
	_tmp3_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp1_, ".", _tmp4_);
	s_localized = _tmp5_;
	while (TRUE) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = s_localized;
		if (!g_str_has_suffix (_tmp6_, "0")) {
			break;
		}
		_tmp7_ = s_localized;
		_tmp8_ = string_slice (_tmp7_, (glong) 0, (glong) -1);
		_g_free0 (s_localized);
		s_localized = _tmp8_;
	}
	_tmp9_ = s_localized;
	_tmp10_ = self->scanner;
	_tmp11_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_str_has_suffix (_tmp9_, _tmp12_)) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = s_localized;
		_tmp14_ = string_slice (_tmp13_, (glong) 0, (glong) -1);
		_g_free0 (s_localized);
		s_localized = _tmp14_;
	}
	_tmp15_ = s_localized;
	_tmp16_ = g_string_new (_tmp15_);
	builder = _tmp16_;
	_tmp17_ = s_localized;
	_tmp18_ = self->scanner;
	_tmp19_ = pantheon_calculator_core_scanner_get_decimal_symbol (_tmp18_);
	_tmp20_ = _tmp19_;
	decimal_pos = string_last_index_of (_tmp17_, _tmp20_, 0);
	if (decimal_pos == -1) {
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = s_localized;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		decimal_pos = _tmp23_;
	}
	end_position = 0;
	_tmp24_ = s_localized;
	if (g_str_has_prefix (_tmp24_, "-")) {
		end_position = 1;
	}
	{
		gint i = 0;
		i = decimal_pos - 3;
		{
			gboolean _tmp25_ = FALSE;
			_tmp25_ = TRUE;
			while (TRUE) {
				GString* _tmp26_;
				PantheonCalculatorCoreScanner* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				if (!_tmp25_) {
					i -= 3;
				}
				_tmp25_ = FALSE;
				if (!(i > end_position)) {
					break;
				}
				_tmp26_ = builder;
				_tmp27_ = self->scanner;
				_tmp28_ = pantheon_calculator_core_scanner_get_separator_symbol (_tmp27_);
				_tmp29_ = _tmp28_;
				g_string_insert (_tmp26_, (gssize) i, _tmp29_);
			}
		}
	}
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	_g_string_free0 (builder);
	_g_free0 (s_localized);
	_g_free0 (s);
	return result;
}

static void
pantheon_calculator_core_evaluation_operator_copy (const PantheonCalculatorCoreEvaluationOperator* self,
                                                   PantheonCalculatorCoreEvaluationOperator* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	PantheonCalculatorCoreEvaluationEval _tmp4_;
	_tmp0_ = (*self).symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).symbol);
	(*dest).symbol = _tmp1_;
	(*dest).inputs = (*self).inputs;
	(*dest).prec = (*self).prec;
	_tmp2_ = (*self).fixity;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).fixity);
	(*dest).fixity = _tmp3_;
	_tmp4_ = (*self).eval;
	(*dest).eval = _tmp4_;
}

static void
pantheon_calculator_core_evaluation_operator_destroy (PantheonCalculatorCoreEvaluationOperator* self)
{
	_g_free0 ((*self).symbol);
	_g_free0 ((*self).fixity);
}

static PantheonCalculatorCoreEvaluationOperator*
pantheon_calculator_core_evaluation_operator_dup (const PantheonCalculatorCoreEvaluationOperator* self)
{
	PantheonCalculatorCoreEvaluationOperator* dup;
	dup = g_new0 (PantheonCalculatorCoreEvaluationOperator, 1);
	pantheon_calculator_core_evaluation_operator_copy (self, dup);
	return dup;
}

static void
pantheon_calculator_core_evaluation_operator_free (PantheonCalculatorCoreEvaluationOperator* self)
{
	pantheon_calculator_core_evaluation_operator_destroy (self);
	g_free (self);
}

static GType
pantheon_calculator_core_evaluation_operator_get_type_once (void)
{
	GType pantheon_calculator_core_evaluation_operator_type_id;
	pantheon_calculator_core_evaluation_operator_type_id = g_boxed_type_register_static ("PantheonCalculatorCoreEvaluationOperator", (GBoxedCopyFunc) pantheon_calculator_core_evaluation_operator_dup, (GBoxedFreeFunc) pantheon_calculator_core_evaluation_operator_free);
	return pantheon_calculator_core_evaluation_operator_type_id;
}

static GType
pantheon_calculator_core_evaluation_operator_get_type (void)
{
	static volatile gsize pantheon_calculator_core_evaluation_operator_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_evaluation_operator_type_id__once)) {
		GType pantheon_calculator_core_evaluation_operator_type_id;
		pantheon_calculator_core_evaluation_operator_type_id = pantheon_calculator_core_evaluation_operator_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_evaluation_operator_type_id__once, pantheon_calculator_core_evaluation_operator_type_id);
	}
	return pantheon_calculator_core_evaluation_operator_type_id__once;
}

static void
pantheon_calculator_core_evaluation_function_copy (const PantheonCalculatorCoreEvaluationFunction* self,
                                                   PantheonCalculatorCoreEvaluationFunction* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PantheonCalculatorCoreEvaluationEval _tmp2_;
	_tmp0_ = (*self).symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).symbol);
	(*dest).symbol = _tmp1_;
	(*dest).inputs = (*self).inputs;
	_tmp2_ = (*self).eval;
	(*dest).eval = _tmp2_;
}

static void
pantheon_calculator_core_evaluation_function_destroy (PantheonCalculatorCoreEvaluationFunction* self)
{
	_g_free0 ((*self).symbol);
}

static PantheonCalculatorCoreEvaluationFunction*
pantheon_calculator_core_evaluation_function_dup (const PantheonCalculatorCoreEvaluationFunction* self)
{
	PantheonCalculatorCoreEvaluationFunction* dup;
	dup = g_new0 (PantheonCalculatorCoreEvaluationFunction, 1);
	pantheon_calculator_core_evaluation_function_copy (self, dup);
	return dup;
}

static void
pantheon_calculator_core_evaluation_function_free (PantheonCalculatorCoreEvaluationFunction* self)
{
	pantheon_calculator_core_evaluation_function_destroy (self);
	g_free (self);
}

static GType
pantheon_calculator_core_evaluation_function_get_type_once (void)
{
	GType pantheon_calculator_core_evaluation_function_type_id;
	pantheon_calculator_core_evaluation_function_type_id = g_boxed_type_register_static ("PantheonCalculatorCoreEvaluationFunction", (GBoxedCopyFunc) pantheon_calculator_core_evaluation_function_dup, (GBoxedFreeFunc) pantheon_calculator_core_evaluation_function_free);
	return pantheon_calculator_core_evaluation_function_type_id;
}

static GType
pantheon_calculator_core_evaluation_function_get_type (void)
{
	static volatile gsize pantheon_calculator_core_evaluation_function_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_evaluation_function_type_id__once)) {
		GType pantheon_calculator_core_evaluation_function_type_id;
		pantheon_calculator_core_evaluation_function_type_id = pantheon_calculator_core_evaluation_function_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_evaluation_function_type_id__once, pantheon_calculator_core_evaluation_function_type_id);
	}
	return pantheon_calculator_core_evaluation_function_type_id__once;
}

static void
pantheon_calculator_core_evaluation_constant_copy (const PantheonCalculatorCoreEvaluationConstant* self,
                                                   PantheonCalculatorCoreEvaluationConstant* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	PantheonCalculatorCoreEvaluationEval _tmp2_;
	_tmp0_ = (*self).symbol;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).symbol);
	(*dest).symbol = _tmp1_;
	_tmp2_ = (*self).eval;
	(*dest).eval = _tmp2_;
}

static void
pantheon_calculator_core_evaluation_constant_destroy (PantheonCalculatorCoreEvaluationConstant* self)
{
	_g_free0 ((*self).symbol);
}

static PantheonCalculatorCoreEvaluationConstant*
pantheon_calculator_core_evaluation_constant_dup (const PantheonCalculatorCoreEvaluationConstant* self)
{
	PantheonCalculatorCoreEvaluationConstant* dup;
	dup = g_new0 (PantheonCalculatorCoreEvaluationConstant, 1);
	pantheon_calculator_core_evaluation_constant_copy (self, dup);
	return dup;
}

static void
pantheon_calculator_core_evaluation_constant_free (PantheonCalculatorCoreEvaluationConstant* self)
{
	pantheon_calculator_core_evaluation_constant_destroy (self);
	g_free (self);
}

static GType
pantheon_calculator_core_evaluation_constant_get_type_once (void)
{
	GType pantheon_calculator_core_evaluation_constant_type_id;
	pantheon_calculator_core_evaluation_constant_type_id = g_boxed_type_register_static ("PantheonCalculatorCoreEvaluationConstant", (GBoxedCopyFunc) pantheon_calculator_core_evaluation_constant_dup, (GBoxedFreeFunc) pantheon_calculator_core_evaluation_constant_free);
	return pantheon_calculator_core_evaluation_constant_type_id;
}

static GType
pantheon_calculator_core_evaluation_constant_get_type (void)
{
	static volatile gsize pantheon_calculator_core_evaluation_constant_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_evaluation_constant_type_id__once)) {
		GType pantheon_calculator_core_evaluation_constant_type_id;
		pantheon_calculator_core_evaluation_constant_type_id = pantheon_calculator_core_evaluation_constant_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_evaluation_constant_type_id__once, pantheon_calculator_core_evaluation_constant_type_id);
	}
	return pantheon_calculator_core_evaluation_constant_type_id__once;
}

static void
pantheon_calculator_core_evaluation_class_init (PantheonCalculatorCoreEvaluationClass * klass,
                                                gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PantheonCalculatorCoreEvaluationOperator _tmp2_ = {0};
	gchar* _tmp3_;
	gchar* _tmp4_;
	PantheonCalculatorCoreEvaluationOperator _tmp5_ = {0};
	gchar* _tmp6_;
	gchar* _tmp7_;
	PantheonCalculatorCoreEvaluationOperator _tmp8_ = {0};
	gchar* _tmp9_;
	gchar* _tmp10_;
	PantheonCalculatorCoreEvaluationOperator _tmp11_ = {0};
	gchar* _tmp12_;
	gchar* _tmp13_;
	PantheonCalculatorCoreEvaluationOperator _tmp14_ = {0};
	gchar* _tmp15_;
	gchar* _tmp16_;
	PantheonCalculatorCoreEvaluationOperator _tmp17_ = {0};
	gchar* _tmp18_;
	gchar* _tmp19_;
	PantheonCalculatorCoreEvaluationOperator _tmp20_ = {0};
	gchar* _tmp21_;
	gchar* _tmp22_;
	PantheonCalculatorCoreEvaluationOperator _tmp23_ = {0};
	gchar* _tmp24_;
	gchar* _tmp25_;
	PantheonCalculatorCoreEvaluationOperator _tmp26_ = {0};
	gchar* _tmp27_;
	gchar* _tmp28_;
	PantheonCalculatorCoreEvaluationOperator _tmp29_ = {0};
	gchar* _tmp30_;
	gchar* _tmp31_;
	PantheonCalculatorCoreEvaluationOperator _tmp32_ = {0};
	PantheonCalculatorCoreEvaluationOperator* _tmp33_;
	gchar* _tmp34_;
	PantheonCalculatorCoreEvaluationFunction _tmp35_ = {0};
	gchar* _tmp36_;
	PantheonCalculatorCoreEvaluationFunction _tmp37_ = {0};
	gchar* _tmp38_;
	PantheonCalculatorCoreEvaluationFunction _tmp39_ = {0};
	gchar* _tmp40_;
	PantheonCalculatorCoreEvaluationFunction _tmp41_ = {0};
	gchar* _tmp42_;
	PantheonCalculatorCoreEvaluationFunction _tmp43_ = {0};
	gchar* _tmp44_;
	PantheonCalculatorCoreEvaluationFunction _tmp45_ = {0};
	gchar* _tmp46_;
	PantheonCalculatorCoreEvaluationFunction _tmp47_ = {0};
	gchar* _tmp48_;
	PantheonCalculatorCoreEvaluationFunction _tmp49_ = {0};
	gchar* _tmp50_;
	PantheonCalculatorCoreEvaluationFunction _tmp51_ = {0};
	gchar* _tmp52_;
	PantheonCalculatorCoreEvaluationFunction _tmp53_ = {0};
	gchar* _tmp54_;
	PantheonCalculatorCoreEvaluationFunction _tmp55_ = {0};
	gchar* _tmp56_;
	PantheonCalculatorCoreEvaluationFunction _tmp57_ = {0};
	gchar* _tmp58_;
	PantheonCalculatorCoreEvaluationFunction _tmp59_ = {0};
	gchar* _tmp60_;
	PantheonCalculatorCoreEvaluationFunction _tmp61_ = {0};
	PantheonCalculatorCoreEvaluationFunction* _tmp62_;
	gchar* _tmp63_;
	PantheonCalculatorCoreEvaluationConstant _tmp64_ = {0};
	gchar* _tmp65_;
	PantheonCalculatorCoreEvaluationConstant _tmp66_ = {0};
	gchar* _tmp67_;
	PantheonCalculatorCoreEvaluationConstant _tmp68_ = {0};
	PantheonCalculatorCoreEvaluationConstant* _tmp69_;
	pantheon_calculator_core_evaluation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = pantheon_calculator_core_evaluation_finalize;
	_tmp0_ = g_strdup ("+");
	_tmp1_ = g_strdup ("LEFT");
	memset (&_tmp2_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp2_.symbol);
	_tmp2_.symbol = _tmp0_;
	_tmp2_.inputs = 2;
	_tmp2_.prec = 1;
	_g_free0 (_tmp2_.fixity);
	_tmp2_.fixity = _tmp1_;
	_tmp2_.eval = __pantheon_calculator_core_evaluation_operators_lambda5__pantheon_calculator_core_evaluation_eval;
	_tmp3_ = g_strdup ("-");
	_tmp4_ = g_strdup ("LEFT");
	memset (&_tmp5_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp5_.symbol);
	_tmp5_.symbol = _tmp3_;
	_tmp5_.inputs = 2;
	_tmp5_.prec = 1;
	_g_free0 (_tmp5_.fixity);
	_tmp5_.fixity = _tmp4_;
	_tmp5_.eval = __pantheon_calculator_core_evaluation_operators_lambda6__pantheon_calculator_core_evaluation_eval;
	_tmp6_ = g_strdup ("−");
	_tmp7_ = g_strdup ("LEFT");
	memset (&_tmp8_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp8_.symbol);
	_tmp8_.symbol = _tmp6_;
	_tmp8_.inputs = 2;
	_tmp8_.prec = 1;
	_g_free0 (_tmp8_.fixity);
	_tmp8_.fixity = _tmp7_;
	_tmp8_.eval = __pantheon_calculator_core_evaluation_operators_lambda7__pantheon_calculator_core_evaluation_eval;
	_tmp9_ = g_strdup ("*");
	_tmp10_ = g_strdup ("LEFT");
	memset (&_tmp11_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp11_.symbol);
	_tmp11_.symbol = _tmp9_;
	_tmp11_.inputs = 2;
	_tmp11_.prec = 2;
	_g_free0 (_tmp11_.fixity);
	_tmp11_.fixity = _tmp10_;
	_tmp11_.eval = __pantheon_calculator_core_evaluation_operators_lambda8__pantheon_calculator_core_evaluation_eval;
	_tmp12_ = g_strdup ("×");
	_tmp13_ = g_strdup ("LEFT");
	memset (&_tmp14_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp14_.symbol);
	_tmp14_.symbol = _tmp12_;
	_tmp14_.inputs = 2;
	_tmp14_.prec = 2;
	_g_free0 (_tmp14_.fixity);
	_tmp14_.fixity = _tmp13_;
	_tmp14_.eval = __pantheon_calculator_core_evaluation_operators_lambda9__pantheon_calculator_core_evaluation_eval;
	_tmp15_ = g_strdup ("/");
	_tmp16_ = g_strdup ("LEFT");
	memset (&_tmp17_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp17_.symbol);
	_tmp17_.symbol = _tmp15_;
	_tmp17_.inputs = 2;
	_tmp17_.prec = 2;
	_g_free0 (_tmp17_.fixity);
	_tmp17_.fixity = _tmp16_;
	_tmp17_.eval = __pantheon_calculator_core_evaluation_operators_lambda10__pantheon_calculator_core_evaluation_eval;
	_tmp18_ = g_strdup ("÷");
	_tmp19_ = g_strdup ("LEFT");
	memset (&_tmp20_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp20_.symbol);
	_tmp20_.symbol = _tmp18_;
	_tmp20_.inputs = 2;
	_tmp20_.prec = 2;
	_g_free0 (_tmp20_.fixity);
	_tmp20_.fixity = _tmp19_;
	_tmp20_.eval = __pantheon_calculator_core_evaluation_operators_lambda11__pantheon_calculator_core_evaluation_eval;
	_tmp21_ = g_strdup ("mod");
	_tmp22_ = g_strdup ("LEFT");
	memset (&_tmp23_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp23_.symbol);
	_tmp23_.symbol = _tmp21_;
	_tmp23_.inputs = 2;
	_tmp23_.prec = 2;
	_g_free0 (_tmp23_.fixity);
	_tmp23_.fixity = _tmp22_;
	_tmp23_.eval = __pantheon_calculator_core_evaluation_operators_lambda12__pantheon_calculator_core_evaluation_eval;
	_tmp24_ = g_strdup ("^");
	_tmp25_ = g_strdup ("RIGHT");
	memset (&_tmp26_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp26_.symbol);
	_tmp26_.symbol = _tmp24_;
	_tmp26_.inputs = 2;
	_tmp26_.prec = 3;
	_g_free0 (_tmp26_.fixity);
	_tmp26_.fixity = _tmp25_;
	_tmp26_.eval = __pantheon_calculator_core_evaluation_operators_lambda13__pantheon_calculator_core_evaluation_eval;
	_tmp27_ = g_strdup ("E");
	_tmp28_ = g_strdup ("RIGHT");
	memset (&_tmp29_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp29_.symbol);
	_tmp29_.symbol = _tmp27_;
	_tmp29_.inputs = 2;
	_tmp29_.prec = 4;
	_g_free0 (_tmp29_.fixity);
	_tmp29_.fixity = _tmp28_;
	_tmp29_.eval = __pantheon_calculator_core_evaluation_operators_lambda14__pantheon_calculator_core_evaluation_eval;
	_tmp30_ = g_strdup ("%");
	_tmp31_ = g_strdup ("LEFT");
	memset (&_tmp32_, 0, sizeof (PantheonCalculatorCoreEvaluationOperator));
	_g_free0 (_tmp32_.symbol);
	_tmp32_.symbol = _tmp30_;
	_tmp32_.inputs = 1;
	_tmp32_.prec = 5;
	_g_free0 (_tmp32_.fixity);
	_tmp32_.fixity = _tmp31_;
	_tmp32_.eval = __pantheon_calculator_core_evaluation_operators_lambda15__pantheon_calculator_core_evaluation_eval;
	_tmp33_ = g_new0 (PantheonCalculatorCoreEvaluationOperator, 11);
	_tmp33_[0] = _tmp2_;
	_tmp33_[1] = _tmp5_;
	_tmp33_[2] = _tmp8_;
	_tmp33_[3] = _tmp11_;
	_tmp33_[4] = _tmp14_;
	_tmp33_[5] = _tmp17_;
	_tmp33_[6] = _tmp20_;
	_tmp33_[7] = _tmp23_;
	_tmp33_[8] = _tmp26_;
	_tmp33_[9] = _tmp29_;
	_tmp33_[10] = _tmp32_;
	pantheon_calculator_core_evaluation_operators = _tmp33_;
	pantheon_calculator_core_evaluation_operators_length1 = 11;
	_pantheon_calculator_core_evaluation_operators_size_ = pantheon_calculator_core_evaluation_operators_length1;
	_tmp34_ = g_strdup ("sin");
	memset (&_tmp35_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp35_.symbol);
	_tmp35_.symbol = _tmp34_;
	_tmp35_.inputs = 1;
	_tmp35_.eval = __pantheon_calculator_core_evaluation_functions_lambda16__pantheon_calculator_core_evaluation_eval;
	_tmp36_ = g_strdup ("cos");
	memset (&_tmp37_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp37_.symbol);
	_tmp37_.symbol = _tmp36_;
	_tmp37_.inputs = 1;
	_tmp37_.eval = __pantheon_calculator_core_evaluation_functions_lambda17__pantheon_calculator_core_evaluation_eval;
	_tmp38_ = g_strdup ("tan");
	memset (&_tmp39_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp39_.symbol);
	_tmp39_.symbol = _tmp38_;
	_tmp39_.inputs = 1;
	_tmp39_.eval = __pantheon_calculator_core_evaluation_functions_lambda18__pantheon_calculator_core_evaluation_eval;
	_tmp40_ = g_strdup ("sinh");
	memset (&_tmp41_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp41_.symbol);
	_tmp41_.symbol = _tmp40_;
	_tmp41_.inputs = 1;
	_tmp41_.eval = __pantheon_calculator_core_evaluation_functions_lambda19__pantheon_calculator_core_evaluation_eval;
	_tmp42_ = g_strdup ("cosh");
	memset (&_tmp43_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp43_.symbol);
	_tmp43_.symbol = _tmp42_;
	_tmp43_.inputs = 1;
	_tmp43_.eval = __pantheon_calculator_core_evaluation_functions_lambda20__pantheon_calculator_core_evaluation_eval;
	_tmp44_ = g_strdup ("tanh");
	memset (&_tmp45_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp45_.symbol);
	_tmp45_.symbol = _tmp44_;
	_tmp45_.inputs = 1;
	_tmp45_.eval = __pantheon_calculator_core_evaluation_functions_lambda21__pantheon_calculator_core_evaluation_eval;
	_tmp46_ = g_strdup ("log");
	memset (&_tmp47_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp47_.symbol);
	_tmp47_.symbol = _tmp46_;
	_tmp47_.inputs = 1;
	_tmp47_.eval = __pantheon_calculator_core_evaluation_functions_lambda22__pantheon_calculator_core_evaluation_eval;
	_tmp48_ = g_strdup ("ln");
	memset (&_tmp49_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp49_.symbol);
	_tmp49_.symbol = _tmp48_;
	_tmp49_.inputs = 1;
	_tmp49_.eval = __pantheon_calculator_core_evaluation_functions_lambda23__pantheon_calculator_core_evaluation_eval;
	_tmp50_ = g_strdup ("exp");
	memset (&_tmp51_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp51_.symbol);
	_tmp51_.symbol = _tmp50_;
	_tmp51_.inputs = 1;
	_tmp51_.eval = __pantheon_calculator_core_evaluation_functions_lambda24__pantheon_calculator_core_evaluation_eval;
	_tmp52_ = g_strdup ("sqrt");
	memset (&_tmp53_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp53_.symbol);
	_tmp53_.symbol = _tmp52_;
	_tmp53_.inputs = 1;
	_tmp53_.eval = __pantheon_calculator_core_evaluation_functions_lambda25__pantheon_calculator_core_evaluation_eval;
	_tmp54_ = g_strdup ("√");
	memset (&_tmp55_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp55_.symbol);
	_tmp55_.symbol = _tmp54_;
	_tmp55_.inputs = 1;
	_tmp55_.eval = __pantheon_calculator_core_evaluation_functions_lambda26__pantheon_calculator_core_evaluation_eval;
	_tmp56_ = g_strdup ("asin");
	memset (&_tmp57_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp57_.symbol);
	_tmp57_.symbol = _tmp56_;
	_tmp57_.inputs = 1;
	_tmp57_.eval = __pantheon_calculator_core_evaluation_functions_lambda27__pantheon_calculator_core_evaluation_eval;
	_tmp58_ = g_strdup ("acos");
	memset (&_tmp59_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp59_.symbol);
	_tmp59_.symbol = _tmp58_;
	_tmp59_.inputs = 1;
	_tmp59_.eval = __pantheon_calculator_core_evaluation_functions_lambda28__pantheon_calculator_core_evaluation_eval;
	_tmp60_ = g_strdup ("atan");
	memset (&_tmp61_, 0, sizeof (PantheonCalculatorCoreEvaluationFunction));
	_g_free0 (_tmp61_.symbol);
	_tmp61_.symbol = _tmp60_;
	_tmp61_.inputs = 1;
	_tmp61_.eval = __pantheon_calculator_core_evaluation_functions_lambda29__pantheon_calculator_core_evaluation_eval;
	_tmp62_ = g_new0 (PantheonCalculatorCoreEvaluationFunction, 14);
	_tmp62_[0] = _tmp35_;
	_tmp62_[1] = _tmp37_;
	_tmp62_[2] = _tmp39_;
	_tmp62_[3] = _tmp41_;
	_tmp62_[4] = _tmp43_;
	_tmp62_[5] = _tmp45_;
	_tmp62_[6] = _tmp47_;
	_tmp62_[7] = _tmp49_;
	_tmp62_[8] = _tmp51_;
	_tmp62_[9] = _tmp53_;
	_tmp62_[10] = _tmp55_;
	_tmp62_[11] = _tmp57_;
	_tmp62_[12] = _tmp59_;
	_tmp62_[13] = _tmp61_;
	pantheon_calculator_core_evaluation_functions = _tmp62_;
	pantheon_calculator_core_evaluation_functions_length1 = 14;
	_pantheon_calculator_core_evaluation_functions_size_ = pantheon_calculator_core_evaluation_functions_length1;
	_tmp63_ = g_strdup ("pi");
	memset (&_tmp64_, 0, sizeof (PantheonCalculatorCoreEvaluationConstant));
	_g_free0 (_tmp64_.symbol);
	_tmp64_.symbol = _tmp63_;
	_tmp64_.eval = __pantheon_calculator_core_evaluation_constants_lambda30__pantheon_calculator_core_evaluation_eval;
	_tmp65_ = g_strdup ("π");
	memset (&_tmp66_, 0, sizeof (PantheonCalculatorCoreEvaluationConstant));
	_g_free0 (_tmp66_.symbol);
	_tmp66_.symbol = _tmp65_;
	_tmp66_.eval = __pantheon_calculator_core_evaluation_constants_lambda31__pantheon_calculator_core_evaluation_eval;
	_tmp67_ = g_strdup ("e");
	memset (&_tmp68_, 0, sizeof (PantheonCalculatorCoreEvaluationConstant));
	_g_free0 (_tmp68_.symbol);
	_tmp68_.symbol = _tmp67_;
	_tmp68_.eval = __pantheon_calculator_core_evaluation_constants_lambda32__pantheon_calculator_core_evaluation_eval;
	_tmp69_ = g_new0 (PantheonCalculatorCoreEvaluationConstant, 3);
	_tmp69_[0] = _tmp64_;
	_tmp69_[1] = _tmp66_;
	_tmp69_[2] = _tmp68_;
	pantheon_calculator_core_evaluation_constants = _tmp69_;
	pantheon_calculator_core_evaluation_constants_length1 = 3;
	_pantheon_calculator_core_evaluation_constants_size_ = pantheon_calculator_core_evaluation_constants_length1;
}

static void
pantheon_calculator_core_evaluation_instance_init (PantheonCalculatorCoreEvaluation * self,
                                                   gpointer klass)
{
	PantheonCalculatorCoreScanner* _tmp0_;
	_tmp0_ = pantheon_calculator_core_scanner_new ();
	self->scanner = _tmp0_;
}

static void
pantheon_calculator_core_evaluation_finalize (GObject * obj)
{
	PantheonCalculatorCoreEvaluation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_CALCULATOR_CORE_TYPE_EVALUATION, PantheonCalculatorCoreEvaluation);
	_g_object_unref0 (self->scanner);
	G_OBJECT_CLASS (pantheon_calculator_core_evaluation_parent_class)->finalize (obj);
}

static GType
pantheon_calculator_core_evaluation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonCalculatorCoreEvaluationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_calculator_core_evaluation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonCalculatorCoreEvaluation), 0, (GInstanceInitFunc) pantheon_calculator_core_evaluation_instance_init, NULL };
	GType pantheon_calculator_core_evaluation_type_id;
	pantheon_calculator_core_evaluation_type_id = g_type_register_static (G_TYPE_OBJECT, "PantheonCalculatorCoreEvaluation", &g_define_type_info, 0);
	return pantheon_calculator_core_evaluation_type_id;
}

GType
pantheon_calculator_core_evaluation_get_type (void)
{
	static volatile gsize pantheon_calculator_core_evaluation_type_id__once = 0;
	if (g_once_init_enter (&pantheon_calculator_core_evaluation_type_id__once)) {
		GType pantheon_calculator_core_evaluation_type_id;
		pantheon_calculator_core_evaluation_type_id = pantheon_calculator_core_evaluation_get_type_once ();
		g_once_init_leave (&pantheon_calculator_core_evaluation_type_id__once, pantheon_calculator_core_evaluation_type_id);
	}
	return pantheon_calculator_core_evaluation_type_id__once;
}

