/* NetworkListBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from NetworkListBox.vala, do not modify */

/* NetworkListBox.vala
 *
 * Copyright 2020 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_NETWORK_LIST_BOX (sidebar_network_list_box_get_type ())
#define SIDEBAR_NETWORK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox))
#define SIDEBAR_NETWORK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBoxClass))
#define SIDEBAR_IS_NETWORK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX))
#define SIDEBAR_IS_NETWORK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_NETWORK_LIST_BOX))
#define SIDEBAR_NETWORK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBoxClass))

typedef struct _SidebarNetworkListBox SidebarNetworkListBox;
typedef struct _SidebarNetworkListBoxClass SidebarNetworkListBoxClass;
typedef struct _SidebarNetworkListBoxPrivate SidebarNetworkListBoxPrivate;
enum  {
	SIDEBAR_NETWORK_LIST_BOX_0_PROPERTY,
	SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY,
	SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY,
	SIDEBAR_NETWORK_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* sidebar_network_list_box_properties[SIDEBAR_NETWORK_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;

#define SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW (sidebar_abstract_mountable_row_get_type ())
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW))
#define SIDEBAR_ABSTRACT_MOUNTABLE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRowClass))

typedef struct _SidebarAbstractMountableRow SidebarAbstractMountableRow;
typedef struct _SidebarAbstractMountableRowClass SidebarAbstractMountableRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW (sidebar_volumeless_mount_row_get_type ())
#define SIDEBAR_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRow))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_IS_VOLUMELESS_MOUNT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW))
#define SIDEBAR_VOLUMELESS_MOUNT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_VOLUMELESS_MOUNT_ROW, SidebarVolumelessMountRowClass))

typedef struct _SidebarVolumelessMountRow SidebarVolumelessMountRow;
typedef struct _SidebarVolumelessMountRowClass SidebarVolumelessMountRowClass;

#define SIDEBAR_TYPE_NETWORK_ROW (sidebar_network_row_get_type ())
#define SIDEBAR_NETWORK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRow))
#define SIDEBAR_NETWORK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRowClass))
#define SIDEBAR_IS_NETWORK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_NETWORK_ROW))
#define SIDEBAR_IS_NETWORK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_NETWORK_ROW))
#define SIDEBAR_NETWORK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_NETWORK_ROW, SidebarNetworkRowClass))

typedef struct _SidebarNetworkRow SidebarNetworkRow;
typedef struct _SidebarNetworkRowClass SidebarNetworkRowClass;

struct _SidebarNetworkListBox {
	GtkBox parent_instance;
	SidebarNetworkListBoxPrivate * priv;
};

struct _SidebarNetworkListBoxClass {
	GtkBoxClass parent_class;
};

struct _SidebarNetworkListBoxPrivate {
	FilesSidebarInterface* _sidebar;
	GtkListBox* _list_box;
};

static gint SidebarNetworkListBox_private_offset;
static gpointer sidebar_network_list_box_parent_class = NULL;
static SidebarSidebarListInterfaceIface * sidebar_network_list_box_sidebar_sidebar_list_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_network_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarNetworkListBox, g_object_unref)
VALA_EXTERN SidebarNetworkListBox* sidebar_network_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarNetworkListBox* sidebar_network_list_box_construct (GType object_type,
                                                           FilesSidebarInterface* sidebar);
static gint sidebar_network_list_box_network_sort_func (SidebarNetworkListBox* self,
                                                 GtkListBoxRow* row1,
                                                 GtkListBoxRow* row2);
VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN GType sidebar_abstract_mountable_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarAbstractMountableRow, g_object_unref)
VALA_EXTERN const gchar* sidebar_abstract_mountable_row_get_sort_key (SidebarAbstractMountableRow* self);
static SidebarBookmarkRow* sidebar_network_list_box_add_bookmark (SidebarNetworkListBox* self,
                                                           const gchar* label,
                                                           const gchar* uri,
                                                           GIcon* gicon,
                                                           gboolean permanent,
                                                           gboolean pinned,
                                                           const gchar* uuid,
                                                           GMount* mount);
VALA_EXTERN SidebarNetworkRow* sidebar_network_row_new (const gchar* name,
                                            const gchar* uri,
                                            GIcon* gicon,
                                            SidebarSidebarListInterface* list,
                                            gboolean pinned,
                                            gboolean permanent,
                                            const gchar* _uuid,
                                            GMount* _mount);
VALA_EXTERN SidebarNetworkRow* sidebar_network_row_construct (GType object_type,
                                                  const gchar* name,
                                                  const gchar* uri,
                                                  GIcon* gicon,
                                                  SidebarSidebarListInterface* list,
                                                  gboolean pinned,
                                                  gboolean permanent,
                                                  const gchar* _uuid,
                                                  GMount* _mount);
VALA_EXTERN GType sidebar_volumeless_mount_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarVolumelessMountRow, g_object_unref)
VALA_EXTERN GType sidebar_network_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarNetworkRow, g_object_unref)
static guint32 sidebar_network_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                                       FilesSidebarPluginItem* plugin_item);
static void sidebar_network_list_box_bookmark_mount_if_not_shadowed (SidebarNetworkListBox* self,
                                                              GMount* mount);
static void sidebar_network_list_box_real_refresh (SidebarSidebarListInterface* base);
VALA_EXTERN gboolean files_is_admin (void);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void sidebar_network_list_box_real_unselect_all_items (SidebarSidebarListInterface* base);
static void sidebar_network_list_box_real_select_item (SidebarSidebarListInterface* base,
                                                GtkListBoxRow* item);
static GObject * sidebar_network_list_box_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void _sidebar_network_list_box_bookmark_mount_if_not_shadowed_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                                            GMount* mount,
                                                                                            gpointer self);
static void _sidebar_network_list_box___lambda185_ (SidebarNetworkListBox* self,
                                             GtkListBoxRow* row);
static void __sidebar_network_list_box___lambda185__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                         GtkListBoxRow* row,
                                                                         gpointer self);
static void _sidebar_network_list_box___lambda186_ (SidebarNetworkListBox* self,
                                             GtkListBoxRow* row);
static void __sidebar_network_list_box___lambda186__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static gint _sidebar_network_list_box_network_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                         GtkListBoxRow* row2,
                                                                         gpointer self);
static void sidebar_network_list_box_finalize (GObject * obj);
static GType sidebar_network_list_box_get_type_once (void);
static void _vala_sidebar_network_list_box_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_sidebar_network_list_box_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sidebar_network_list_box_get_instance_private (SidebarNetworkListBox* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarNetworkListBox_private_offset);
}

SidebarNetworkListBox*
sidebar_network_list_box_construct (GType object_type,
                                    FilesSidebarInterface* sidebar)
{
	SidebarNetworkListBox * self = NULL;
	g_return_val_if_fail (sidebar != NULL, NULL);
	self = (SidebarNetworkListBox*) g_object_new (object_type, "sidebar", sidebar, NULL);
	return self;
}

SidebarNetworkListBox*
sidebar_network_list_box_new (FilesSidebarInterface* sidebar)
{
	return sidebar_network_list_box_construct (SIDEBAR_TYPE_NETWORK_LIST_BOX, sidebar);
}

static gint
sidebar_network_list_box_network_sort_func (SidebarNetworkListBox* self,
                                            GtkListBoxRow* row1,
                                            GtkListBoxRow* row2)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* key1 = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* key2 = NULL;
	gchar* _tmp9_;
	GCompareFunc _tmp10_;
	const gchar* _tmp11_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (row1 != NULL) {
		_tmp1_ = SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (row1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = sidebar_abstract_mountable_row_get_sort_key (G_TYPE_CHECK_INSTANCE_CAST (row1, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = "";
	}
	_tmp4_ = g_strdup (_tmp0_);
	key1 = _tmp4_;
	if (row2 != NULL) {
		_tmp6_ = SIDEBAR_IS_ABSTRACT_MOUNTABLE_ROW (row2);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = sidebar_abstract_mountable_row_get_sort_key (G_TYPE_CHECK_INSTANCE_CAST (row2, SIDEBAR_TYPE_ABSTRACT_MOUNTABLE_ROW, SidebarAbstractMountableRow));
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = "";
	}
	_tmp9_ = g_strdup (_tmp5_);
	key2 = _tmp9_;
	_tmp10_ = ((GCompareFunc) g_strcmp0);
	_tmp11_ = key1;
	result = _tmp10_ (_tmp11_, key2);
	_g_free0 (key2);
	_g_free0 (key1);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SidebarBookmarkRow*
sidebar_network_list_box_add_bookmark (SidebarNetworkListBox* self,
                                       const gchar* label,
                                       const gchar* uri,
                                       GIcon* gicon,
                                       gboolean permanent,
                                       gboolean pinned,
                                       const gchar* uuid,
                                       GMount* mount)
{
	GtkListBoxRow* row = NULL;
	GtkListBoxRow* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkListBoxRow* _tmp2_;
	GtkListBoxRow* _tmp8_;
	SidebarBookmarkRow* _tmp9_;
	SidebarBookmarkRow* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	row = NULL;
	_tmp1_ = sidebar_sidebar_list_interface_has_uri ((SidebarSidebarListInterface*) self, uri, &_tmp0_);
	_g_object_unref0 (row);
	_tmp2_ = _g_object_ref0 (_tmp0_);
	row = _tmp2_;
	if (!_tmp1_) {
		const gchar* _tmp3_ = NULL;
		SidebarNetworkRow* _tmp4_;
		GtkListBox* _tmp5_;
		GtkListBox* _tmp6_;
		GtkListBoxRow* _tmp7_;
		if (uuid != NULL) {
			_tmp3_ = uuid;
		} else {
			_tmp3_ = uri;
		}
		_tmp4_ = sidebar_network_row_new (label, uri, gicon, (SidebarSidebarListInterface*) self, pinned, permanent, _tmp3_, mount);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (row);
		row = (GtkListBoxRow*) _tmp4_;
		_tmp5_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = row;
		gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	}
	_tmp8_ = row;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow));
	result = _tmp9_;
	_g_object_unref0 (row);
	return result;
}

static guint32
sidebar_network_list_box_real_add_plugin_item (SidebarSidebarListInterface* base,
                                               FilesSidebarPluginItem* plugin_item)
{
	SidebarNetworkListBox * self;
	SidebarBookmarkRow* row = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GMount* _tmp6_;
	GMount* _tmp7_;
	SidebarBookmarkRow* _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	guint32 result;
	self = (SidebarNetworkListBox*) base;
	g_return_val_if_fail (plugin_item != NULL, 0U);
	_tmp0_ = files_sidebar_plugin_item_get_name (plugin_item);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_sidebar_plugin_item_get_uri (plugin_item);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_sidebar_plugin_item_get_icon (plugin_item);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_sidebar_plugin_item_get_mount (plugin_item);
	_tmp7_ = _tmp6_;
	_tmp8_ = sidebar_network_list_box_add_bookmark (self, _tmp1_, _tmp3_, _tmp5_, FALSE, TRUE, NULL, _tmp7_);
	row = _tmp8_;
	sidebar_sidebar_item_interface_update_plugin_data ((SidebarSidebarItemInterface*) row, plugin_item);
	_tmp9_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) row);
	_tmp10_ = _tmp9_;
	result = _tmp10_;
	_g_object_unref0 (row);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
sidebar_network_list_box_bookmark_mount_if_not_shadowed (SidebarNetworkListBox* self,
                                                         GMount* mount)
{
	gchar* scheme = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	if (g_mount_is_shadowed (mount)) {
		return;
	}
	_tmp0_ = g_mount_get_root (mount);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_uri_parse_scheme (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	scheme = _tmp5_;
	_tmp7_ = scheme;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = scheme;
		_tmp6_ = string_contains ("smb ftp sftp afp dav davs", _tmp8_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GIcon* _tmp15_;
		GIcon* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		SidebarBookmarkRow* _tmp19_;
		SidebarBookmarkRow* _tmp20_;
		_tmp9_ = g_mount_get_name (mount);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_mount_get_default_location (mount);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_mount_get_icon (mount);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_mount_get_name (mount);
		_tmp18_ = _tmp17_;
		_tmp19_ = sidebar_network_list_box_add_bookmark (self, _tmp10_, _tmp14_, _tmp16_, FALSE, FALSE, _tmp18_, mount);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_g_free0 (scheme);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
sidebar_network_list_box_real_refresh (SidebarSidebarListInterface* base)
{
	SidebarNetworkListBox * self;
	SidebarBookmarkRow* row = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	SidebarBookmarkRow* _tmp2_;
	SidebarBookmarkRow* _tmp3_;
	SidebarBookmarkRow* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GVolumeMonitor* _tmp10_;
	GVolumeMonitor* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	self = (SidebarNetworkListBox*) base;
	sidebar_sidebar_list_interface_clear ((SidebarSidebarListInterface*) self);
	if (files_is_admin ()) {
		return;
	}
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (FILES_ICON_NETWORK);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_network_list_box_add_bookmark (self, _ ("Entire Network"), FILES_NETWORK_URI, (GIcon*) _tmp1_, TRUE, TRUE, NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	row = _tmp3_;
	_tmp4_ = row;
	_tmp5_ = g_strdup ("<Alt>N");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	_tmp8_ = granite_markup_accel_tooltip (_tmp7_, (gint) 1, _ ("Browse the contents of the network"));
	_tmp9_ = _tmp8_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_volume_monitor_get ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_volume_monitor_get_mounts (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp13_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* mount = NULL;
			mount = (GMount*) mount_it->data;
			{
				GMount* _tmp14_;
				_tmp14_ = mount;
				sidebar_network_list_box_bookmark_mount_if_not_shadowed (self, _tmp14_);
			}
		}
		(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
	}
	_g_object_unref0 (row);
}

static void
sidebar_network_list_box_real_unselect_all_items (SidebarSidebarListInterface* base)
{
	SidebarNetworkListBox * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	self = (SidebarNetworkListBox*) base;
	_tmp0_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp1_ = _tmp0_;
	gtk_list_box_unselect_all (_tmp1_);
}

static void
sidebar_network_list_box_real_select_item (SidebarSidebarListInterface* base,
                                           GtkListBoxRow* item)
{
	SidebarNetworkListBox * self;
	gboolean _tmp0_ = FALSE;
	self = (SidebarNetworkListBox*) base;
	if (item != NULL) {
		_tmp0_ = SIDEBAR_IS_NETWORK_ROW (item);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp1_;
		GtkListBox* _tmp2_;
		_tmp1_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
		_tmp2_ = _tmp1_;
		gtk_list_box_select_row (_tmp2_, item);
	} else {
		sidebar_sidebar_list_interface_unselect_all_items ((SidebarSidebarListInterface*) self);
	}
}

static FilesSidebarInterface*
sidebar_network_list_box_real_get_sidebar (SidebarSidebarListInterface* base)
{
	FilesSidebarInterface* result;
	SidebarNetworkListBox* self;
	FilesSidebarInterface* _tmp0_;
	self = (SidebarNetworkListBox*) base;
	_tmp0_ = self->priv->_sidebar;
	result = _tmp0_;
	return result;
}

static void
sidebar_network_list_box_real_set_sidebar (SidebarSidebarListInterface* base,
                                           FilesSidebarInterface* value)
{
	SidebarNetworkListBox* self;
	FilesSidebarInterface* old_value;
	self = (SidebarNetworkListBox*) base;
	old_value = sidebar_network_list_box_real_get_sidebar (base);
	if (old_value != value) {
		FilesSidebarInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sidebar);
		self->priv->_sidebar = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_network_list_box_properties[SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY]);
	}
}

static GtkListBox*
sidebar_network_list_box_real_get_list_box (SidebarSidebarListInterface* base)
{
	GtkListBox* result;
	SidebarNetworkListBox* self;
	GtkListBox* _tmp0_;
	self = (SidebarNetworkListBox*) base;
	_tmp0_ = self->priv->_list_box;
	result = _tmp0_;
	return result;
}

static void
sidebar_network_list_box_real_set_list_box (SidebarSidebarListInterface* base,
                                            GtkListBox* value)
{
	SidebarNetworkListBox* self;
	GtkListBox* old_value;
	self = (SidebarNetworkListBox*) base;
	old_value = sidebar_network_list_box_real_get_list_box (base);
	if (old_value != value) {
		GtkListBox* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list_box);
		self->priv->_list_box = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_network_list_box_properties[SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY]);
	}
}

static void
_sidebar_network_list_box_bookmark_mount_if_not_shadowed_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                                       GMount* mount,
                                                                                       gpointer self)
{
	sidebar_network_list_box_bookmark_mount_if_not_shadowed ((SidebarNetworkListBox*) self, mount);
}

static void
_sidebar_network_list_box___lambda185_ (SidebarNetworkListBox* self,
                                        GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) G_TYPE_CHECK_INSTANCE_CAST (row, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow), FILES_OPEN_FLAG_DEFAULT);
	}
}

static void
__sidebar_network_list_box___lambda185__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self)
{
	_sidebar_network_list_box___lambda185_ ((SidebarNetworkListBox*) self, row);
}

static void
_sidebar_network_list_box___lambda186_ (SidebarNetworkListBox* self,
                                        GtkListBoxRow* row)
{
	if (SIDEBAR_IS_BOOKMARK_ROW (row)) {
		sidebar_sidebar_list_interface_select_item ((SidebarSidebarListInterface*) self, row);
	}
}

static void
__sidebar_network_list_box___lambda186__gtk_list_box_row_selected (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	_sidebar_network_list_box___lambda186_ ((SidebarNetworkListBox*) self, row);
}

static gint
_sidebar_network_list_box_network_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                    GtkListBoxRow* row2,
                                                                    gpointer self)
{
	gint result;
	result = sidebar_network_list_box_network_sort_func ((SidebarNetworkListBox*) self, row1, row2);
	return result;
}

static GObject *
sidebar_network_list_box_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarNetworkListBox * self;
	GtkListBox* _tmp0_ = NULL;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	GVolumeMonitor* volume_monitor = NULL;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	parent_class = G_OBJECT_CLASS (sidebar_network_list_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_SINGLE);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp3_ = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = g_volume_monitor_get ();
	volume_monitor = _tmp4_;
	_tmp5_ = volume_monitor;
	g_signal_connect_object (_tmp5_, "mount-added", (GCallback) _sidebar_network_list_box_bookmark_mount_if_not_shadowed_g_volume_monitor_mount_added, self, 0);
	_tmp6_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp7_ = _tmp6_;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) __sidebar_network_list_box___lambda185__gtk_list_box_row_activated, self, 0);
	_tmp8_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp9_ = _tmp8_;
	g_signal_connect_object (_tmp9_, "row-selected", (GCallback) __sidebar_network_list_box___lambda186__gtk_list_box_row_selected, self, 0);
	_tmp10_ = sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self);
	_tmp11_ = _tmp10_;
	gtk_list_box_set_sort_func (_tmp11_, _sidebar_network_list_box_network_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (volume_monitor);
	return obj;
}

static void
sidebar_network_list_box_class_init (SidebarNetworkListBoxClass * klass,
                                     gpointer klass_data)
{
	sidebar_network_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarNetworkListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_network_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_network_list_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_network_list_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_network_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY, sidebar_network_list_box_properties[SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY] = g_param_spec_object ("sidebar", "sidebar", "sidebar", FILES_TYPE_SIDEBAR_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY, sidebar_network_list_box_properties[SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY] = g_param_spec_object ("list-box", "list-box", "list-box", gtk_list_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
sidebar_network_list_box_sidebar_sidebar_list_interface_interface_init (SidebarSidebarListInterfaceIface * iface,
                                                                        gpointer iface_data)
{
	sidebar_network_list_box_sidebar_sidebar_list_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_plugin_item = (guint32 (*) (SidebarSidebarListInterface*, FilesSidebarPluginItem*)) sidebar_network_list_box_real_add_plugin_item;
	iface->refresh = (void (*) (SidebarSidebarListInterface*)) sidebar_network_list_box_real_refresh;
	iface->unselect_all_items = (void (*) (SidebarSidebarListInterface*)) sidebar_network_list_box_real_unselect_all_items;
	iface->select_item = (void (*) (SidebarSidebarListInterface*, GtkListBoxRow*)) sidebar_network_list_box_real_select_item;
	iface->get_sidebar = sidebar_network_list_box_real_get_sidebar;
	iface->set_sidebar = sidebar_network_list_box_real_set_sidebar;
	iface->get_list_box = sidebar_network_list_box_real_get_list_box;
	iface->set_list_box = sidebar_network_list_box_real_set_list_box;
}

static void
sidebar_network_list_box_instance_init (SidebarNetworkListBox * self,
                                        gpointer klass)
{
	self->priv = sidebar_network_list_box_get_instance_private (self);
}

static void
sidebar_network_list_box_finalize (GObject * obj)
{
	SidebarNetworkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox);
	_g_object_unref0 (self->priv->_sidebar);
	_g_object_unref0 (self->priv->_list_box);
	G_OBJECT_CLASS (sidebar_network_list_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_network_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarNetworkListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_network_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarNetworkListBox), 0, (GInstanceInitFunc) sidebar_network_list_box_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_list_interface_info = { (GInterfaceInitFunc) sidebar_network_list_box_sidebar_sidebar_list_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_network_list_box_type_id;
	sidebar_network_list_box_type_id = g_type_register_static (gtk_box_get_type (), "SidebarNetworkListBox", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_network_list_box_type_id, SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, &sidebar_sidebar_list_interface_info);
	SidebarNetworkListBox_private_offset = g_type_add_instance_private (sidebar_network_list_box_type_id, sizeof (SidebarNetworkListBoxPrivate));
	return sidebar_network_list_box_type_id;
}

GType
sidebar_network_list_box_get_type (void)
{
	static volatile gsize sidebar_network_list_box_type_id__once = 0;
	if (g_once_init_enter (&sidebar_network_list_box_type_id__once)) {
		GType sidebar_network_list_box_type_id;
		sidebar_network_list_box_type_id = sidebar_network_list_box_get_type_once ();
		g_once_init_leave (&sidebar_network_list_box_type_id__once, sidebar_network_list_box_type_id);
	}
	return sidebar_network_list_box_type_id__once;
}

static void
_vala_sidebar_network_list_box_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	SidebarNetworkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox);
	switch (property_id) {
		case SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_sidebar ((SidebarSidebarListInterface*) self));
		break;
		case SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_list_interface_get_list_box ((SidebarSidebarListInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_network_list_box_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	SidebarNetworkListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox);
	switch (property_id) {
		case SIDEBAR_NETWORK_LIST_BOX_SIDEBAR_PROPERTY:
		sidebar_sidebar_list_interface_set_sidebar ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_NETWORK_LIST_BOX_LIST_BOX_PROPERTY:
		sidebar_sidebar_list_interface_set_list_box ((SidebarSidebarListInterface*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

