/* SeekBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SeekBar.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gst/gst.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_SEEK_BAR (music_seek_bar_get_type ())
#define MUSIC_SEEK_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_SEEK_BAR, MusicSeekBar))
#define MUSIC_SEEK_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_SEEK_BAR, MusicSeekBarClass))
#define MUSIC_IS_SEEK_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_SEEK_BAR))
#define MUSIC_IS_SEEK_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_SEEK_BAR))
#define MUSIC_SEEK_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_SEEK_BAR, MusicSeekBarClass))

typedef struct _MusicSeekBar MusicSeekBar;
typedef struct _MusicSeekBarClass MusicSeekBarClass;
typedef struct _MusicSeekBarPrivate MusicSeekBarPrivate;
enum  {
	MUSIC_SEEK_BAR_0_PROPERTY,
	MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY,
	MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY,
	MUSIC_SEEK_BAR_NUM_PROPERTIES
};
static GParamSpec* music_seek_bar_properties[MUSIC_SEEK_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;

struct _MusicSeekBar {
	GtkBox parent_instance;
	MusicSeekBarPrivate * priv;
};

struct _MusicSeekBarClass {
	GtkBoxClass parent_class;
};

struct _MusicSeekBarPrivate {
	gboolean scale_pressed;
	gint64 _playback_duration;
	gint64 _playback_position;
	GtkLabel* duration_label;
	GtkLabel* position_label;
	GtkScale* scale;
};

static gint MusicSeekBar_private_offset;
static gpointer music_seek_bar_parent_class = NULL;

VALA_EXTERN GType music_seek_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicSeekBar, g_object_unref)
static void music_seek_bar_scale_value_changed (MusicSeekBar* self);
VALA_EXTERN gint64 music_seek_bar_get_playback_duration (MusicSeekBar* self);
VALA_EXTERN MusicSeekBar* music_seek_bar_new (void);
VALA_EXTERN MusicSeekBar* music_seek_bar_construct (GType object_type);
VALA_EXTERN void music_seek_bar_set_playback_duration (MusicSeekBar* self,
                                           gint64 value);
VALA_EXTERN gint64 music_seek_bar_get_playback_position (MusicSeekBar* self);
VALA_EXTERN void music_seek_bar_set_playback_position (MusicSeekBar* self,
                                           gint64 value);
static GObject * music_seek_bar_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _music_seek_bar___lambda11_ (MusicSeekBar* self);
static void _music_seek_bar_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                                  gpointer self);
static void __music_seek_bar___lambda11__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                             gint n_press,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self);
static void _music_seek_bar___lambda12_ (MusicSeekBar* self);
VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
VALA_EXTERN void music_playback_manager_seek_to_progress (MusicPlaybackManager* self,
                                              gdouble percent);
static void __music_seek_bar___lambda12__gtk_gesture_click_stopped (GtkGestureClick* _sender,
                                                             gpointer self);
static void music_seek_bar_finalize (GObject * obj);
static GType music_seek_bar_get_type_once (void);
static void _vala_music_seek_bar_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_music_seek_bar_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
music_seek_bar_get_instance_private (MusicSeekBar* self)
{
	return G_STRUCT_MEMBER_P (self, MusicSeekBar_private_offset);
}

static void
music_seek_bar_scale_value_changed (MusicSeekBar* self)
{
	GtkLabel* _tmp0_;
	GtkScale* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->position_label;
	_tmp1_ = self->priv->scale;
	_tmp2_ = music_seek_bar_get_playback_duration (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = granite_date_time_seconds_to_time ((gint) (gtk_range_get_value ((GtkRange*) _tmp1_) * (_tmp3_ / GST_SECOND)));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("<span font-features='tnum'>%s</span>", _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}

MusicSeekBar*
music_seek_bar_construct (GType object_type)
{
	MusicSeekBar * self = NULL;
	self = (MusicSeekBar*) g_object_new (object_type, NULL);
	return self;
}

MusicSeekBar*
music_seek_bar_new (void)
{
	return music_seek_bar_construct (MUSIC_TYPE_SEEK_BAR);
}

gint64
music_seek_bar_get_playback_duration (MusicSeekBar* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_playback_duration;
	return result;
}

void
music_seek_bar_set_playback_duration (MusicSeekBar* self,
                                      gint64 value)
{
	gint64 duration = 0LL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	duration = value;
	if (duration < ((gint64) 0)) {
		duration = (gint64) 0;
	}
	self->priv->_playback_duration = duration;
	_tmp0_ = self->priv->duration_label;
	_tmp1_ = granite_date_time_seconds_to_time ((gint) (duration / GST_SECOND));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("<span font-features='tnum'>%s</span>", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_label_set_label (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_object_notify_by_pspec ((GObject *) self, music_seek_bar_properties[MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY]);
}

gint64
music_seek_bar_get_playback_position (MusicSeekBar* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_playback_position;
	return result;
}

void
music_seek_bar_set_playback_position (MusicSeekBar* self,
                                      gint64 value)
{
	gint64 position = 0LL;
	g_return_if_fail (self != NULL);
	position = value;
	if (position < ((gint64) 0)) {
		position = (gint64) 0;
	}
	self->priv->_playback_position = position;
	if (!self->priv->scale_pressed) {
		GtkLabel* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->position_label;
		_tmp1_ = granite_date_time_seconds_to_time ((gint) (position / GST_SECOND));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("<span font-features='tnum'>%s</span>", _tmp2_);
		_tmp4_ = _tmp3_;
		gtk_label_set_label (_tmp0_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		if (position != ((gint64) 0)) {
			GtkScale* _tmp5_;
			gint64 _tmp6_;
			gint64 _tmp7_;
			_tmp5_ = self->priv->scale;
			_tmp6_ = music_seek_bar_get_playback_duration (self);
			_tmp7_ = _tmp6_;
			gtk_range_set_value ((GtkRange*) _tmp5_, (((gdouble) 1) / _tmp7_) * position);
		} else {
			GtkScale* _tmp8_;
			_tmp8_ = self->priv->scale;
			gtk_range_set_value ((GtkRange*) _tmp8_, (gdouble) 0);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, music_seek_bar_properties[MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY]);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_music_seek_bar_scale_value_changed_gtk_range_value_changed (GtkRange* _sender,
                                                             gpointer self)
{
	music_seek_bar_scale_value_changed ((MusicSeekBar*) self);
}

static void
_music_seek_bar___lambda11_ (MusicSeekBar* self)
{
	GtkScale* _tmp0_;
	_tmp0_ = self->priv->scale;
	g_signal_connect_object ((GtkRange*) _tmp0_, "value-changed", (GCallback) _music_seek_bar_scale_value_changed_gtk_range_value_changed, self, 0);
	self->priv->scale_pressed = TRUE;
}

static void
__music_seek_bar___lambda11__gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                        gint n_press,
                                                        gdouble x,
                                                        gdouble y,
                                                        gpointer self)
{
	_music_seek_bar___lambda11_ ((MusicSeekBar*) self);
}

static void
_music_seek_bar___lambda12_ (MusicSeekBar* self)
{
	GtkScale* _tmp0_;
	guint _tmp1_;
	MusicPlaybackManager* _tmp2_;
	GtkScale* _tmp3_;
	_tmp0_ = self->priv->scale;
	g_signal_parse_name ("value-changed", gtk_range_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkRange*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _music_seek_bar_scale_value_changed_gtk_range_value_changed, self);
	_tmp2_ = music_playback_manager_get_default ();
	_tmp3_ = self->priv->scale;
	music_playback_manager_seek_to_progress (_tmp2_, gtk_range_get_value ((GtkRange*) _tmp3_));
	self->priv->scale_pressed = FALSE;
}

static void
__music_seek_bar___lambda12__gtk_gesture_click_stopped (GtkGestureClick* _sender,
                                                        gpointer self)
{
	_music_seek_bar___lambda12_ ((MusicSeekBar*) self);
}

static GObject *
music_seek_bar_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicSeekBar * self;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkGestureClick* scale_event_controller = NULL;
	GtkGestureClick* _tmp2_;
	GtkScale* _tmp3_ = NULL;
	GtkScale* _tmp4_;
	GtkGestureClick* _tmp5_;
	GtkEventController* _tmp6_;
	GtkScale* _tmp7_;
	GtkLabel* _tmp8_;
	GtkScale* _tmp9_;
	GtkLabel* _tmp10_;
	GtkGestureClick* _tmp11_;
	GtkGestureClick* _tmp12_;
	parent_class = G_OBJECT_CLASS (music_seek_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_SEEK_BAR, MusicSeekBar);
	_tmp0_ = (GtkLabel*) gtk_label_new ("--:--");
	gtk_label_set_use_markup (_tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->position_label);
	self->priv->position_label = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("--:--");
	gtk_label_set_use_markup (_tmp1_, TRUE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->duration_label);
	self->priv->duration_label = _tmp1_;
	_tmp2_ = (GtkGestureClick*) gtk_gesture_click_new ();
	scale_event_controller = _tmp2_;
	_tmp3_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 1, 0.1);
	gtk_scale_set_draw_value (_tmp3_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->scale);
	self->priv->scale = _tmp3_;
	_tmp4_ = self->priv->scale;
	_tmp5_ = scale_event_controller;
	_tmp6_ = _g_object_ref0 ((GtkEventController*) _tmp5_);
	gtk_widget_add_controller ((GtkWidget*) _tmp4_, _tmp6_);
	_tmp7_ = self->priv->scale;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_ACCENT);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_widget_add_css_class ((GtkWidget*) self, "seek-bar");
	_tmp8_ = self->priv->position_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->scale;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->duration_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp10_);
	_tmp11_ = scale_event_controller;
	g_signal_connect_object (_tmp11_, "pressed", (GCallback) __music_seek_bar___lambda11__gtk_gesture_click_pressed, self, 0);
	_tmp12_ = scale_event_controller;
	g_signal_connect_object (_tmp12_, "stopped", (GCallback) __music_seek_bar___lambda12__gtk_gesture_click_stopped, self, 0);
	_g_object_unref0 (scale_event_controller);
	return obj;
}

static void
music_seek_bar_class_init (MusicSeekBarClass * klass,
                           gpointer klass_data)
{
	music_seek_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicSeekBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_music_seek_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_music_seek_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = music_seek_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_seek_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY, music_seek_bar_properties[MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY] = g_param_spec_int64 ("playback-duration", "playback-duration", "playback-duration", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY, music_seek_bar_properties[MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY] = g_param_spec_int64 ("playback-position", "playback-position", "playback-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
music_seek_bar_instance_init (MusicSeekBar * self,
                              gpointer klass)
{
	self->priv = music_seek_bar_get_instance_private (self);
	self->priv->scale_pressed = FALSE;
}

static void
music_seek_bar_finalize (GObject * obj)
{
	MusicSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_SEEK_BAR, MusicSeekBar);
	_g_object_unref0 (self->priv->duration_label);
	_g_object_unref0 (self->priv->position_label);
	_g_object_unref0 (self->priv->scale);
	G_OBJECT_CLASS (music_seek_bar_parent_class)->finalize (obj);
}

static GType
music_seek_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicSeekBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_seek_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicSeekBar), 0, (GInstanceInitFunc) music_seek_bar_instance_init, NULL };
	GType music_seek_bar_type_id;
	music_seek_bar_type_id = g_type_register_static (gtk_box_get_type (), "MusicSeekBar", &g_define_type_info, 0);
	MusicSeekBar_private_offset = g_type_add_instance_private (music_seek_bar_type_id, sizeof (MusicSeekBarPrivate));
	return music_seek_bar_type_id;
}

GType
music_seek_bar_get_type (void)
{
	static volatile gsize music_seek_bar_type_id__once = 0;
	if (g_once_init_enter (&music_seek_bar_type_id__once)) {
		GType music_seek_bar_type_id;
		music_seek_bar_type_id = music_seek_bar_get_type_once ();
		g_once_init_leave (&music_seek_bar_type_id__once, music_seek_bar_type_id);
	}
	return music_seek_bar_type_id__once;
}

static void
_vala_music_seek_bar_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MusicSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_SEEK_BAR, MusicSeekBar);
	switch (property_id) {
		case MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY:
		g_value_set_int64 (value, music_seek_bar_get_playback_duration (self));
		break;
		case MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY:
		g_value_set_int64 (value, music_seek_bar_get_playback_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_music_seek_bar_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MusicSeekBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_SEEK_BAR, MusicSeekBar);
	switch (property_id) {
		case MUSIC_SEEK_BAR_PLAYBACK_DURATION_PROPERTY:
		music_seek_bar_set_playback_duration (self, g_value_get_int64 (value));
		break;
		case MUSIC_SEEK_BAR_PLAYBACK_POSITION_PROPERTY:
		music_seek_bar_set_playback_position (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

