// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <ConfigureInfo.h>

//
// This file is automatically generated by CMake. DO NOT EDIT!
//
namespace visitcommon {

std::string
Version()
{
#define VISIT_VERSION "2.7.0"
#ifdef VISIT_VERSION
     return VISIT_VERSION;
#else
     return "2.0";
#endif
}

std::string 
GITVersion()
{
/* #undef VISIT_GIT_VERSION */
#ifdef VISIT_GIT_VERSION
    return std::string(VISIT_GIT_VERSION);
#else
    return std::string("");
#endif
}

std::string
VersionControlVersionString()
{
/* #undef VISIT_VERSION_STRING */
#ifdef VISIT_VERSION_STRING
    return std::string(VISIT_VERSION_STRING);
#else
    return std::string("git version ") + GITVersion();
#endif
}

std::string
SlashString()
{
#ifdef _WIN32
    return "\\";
#else
    return "/";
#endif
}

char 
SlashChar()
{
#ifdef _WIN32
    return '\\';
#else
    return '/';
#endif  
}

std::string
PluginExtension()
{
#ifdef _WIN32
     return ".dll";
#elif defined(__APPLE__)
     return ".dylib";
#else
     return ".so";
#endif
}

int
RenderingSizeLimit()
{
/* #undef VISIT_RENDERING_SIZE_LIMIT */
#ifdef VISIT_RENDERING_SIZE_LIMIT
    return VISIT_RENDERING_SIZE_LIMIT;
#else
    return 4096;
#endif
}

};
