#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAbstractInterpolatedVelocityField_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAMRInterpolatedVelocityField_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeInterpolatedVelocityField_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkEvenlySpacedStreamlines2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLagrangianBasicIntegrationModel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLagrangianMatidaIntegrationModel_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLagrangianParticle_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLagrangianParticleTracker_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearTransformCellLocator_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkModifiedBSPTree_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParallelVectors_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParticlePathFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParticleTracer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkParticleTracerBase_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStreaklineFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStreamSurface_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStreamTracer_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTemporalInterpolatedVelocityField_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVectorFieldTopology_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVortexCore_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersFlowPathsCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAbstractInterpolatedVelocityField_Init(csi);
  vtkAMRInterpolatedVelocityField_Init(csi);
  vtkCompositeInterpolatedVelocityField_Init(csi);
  vtkEvenlySpacedStreamlines2D_Init(csi);
  vtkLagrangianBasicIntegrationModel_Init(csi);
  vtkLagrangianMatidaIntegrationModel_Init(csi);
  vtkLagrangianParticle_Init(csi);
  vtkLagrangianParticleTracker_Init(csi);
  vtkLinearTransformCellLocator_Init(csi);
  vtkModifiedBSPTree_Init(csi);
  vtkParallelVectors_Init(csi);
  vtkParticlePathFilter_Init(csi);
  vtkParticleTracer_Init(csi);
  vtkParticleTracerBase_Init(csi);
  vtkStreaklineFilter_Init(csi);
  vtkStreamSurface_Init(csi);
  vtkStreamTracer_Init(csi);
  vtkTemporalInterpolatedVelocityField_Init(csi);
  vtkVectorFieldTopology_Init(csi);
  vtkVortexCore_Init(csi);
}
