// python wrapper for vtkTCPNetworkAccessManager
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkTCPNetworkAccessManager.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkTCPNetworkAccessManager(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkTCPNetworkAccessManager_ClassNew(); }

#ifndef DECLARED_PyvtkNetworkAccessManager_ClassNew
extern "C" { PyObject *PyvtkNetworkAccessManager_ClassNew(); }
#define DECLARED_PyvtkNetworkAccessManager_ClassNew
#endif

static PyObject *
PyvtkTCPNetworkAccessManager_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkTCPNetworkAccessManager::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkTCPNetworkAccessManager::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkTCPNetworkAccessManager *tempr = vtkTCPNetworkAccessManager::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkTCPNetworkAccessManager *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkTCPNetworkAccessManager::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkTCPNetworkAccessManager::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkTCPNetworkAccessManager::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_NewConnection_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  vtkNetworkAccessManager::ConnectionResult temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetEnumValue(temp1, "vtkNetworkAccessManager.ConnectionResult"))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->NewConnection(temp0, temp1) :
      op->vtkTCPNetworkAccessManager::NewConnection(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkTCPNetworkAccessManager_NewConnection_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->NewConnection(temp0) :
      op->vtkTCPNetworkAccessManager::NewConnection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkTCPNetworkAccessManager_NewConnection(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkTCPNetworkAccessManager_NewConnection_s1(self, args);
    case 1:
      return PyvtkTCPNetworkAccessManager_NewConnection_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "NewConnection");
  return nullptr;
}


static PyObject *
PyvtkTCPNetworkAccessManager_AbortPendingConnection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AbortPendingConnection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AbortPendingConnection();
    }
    else
    {
      op->vtkTCPNetworkAccessManager::AbortPendingConnection();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_ProcessEvents(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessEvents");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  unsigned long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessEvents(temp0) :
      op->vtkTCPNetworkAccessManager::ProcessEvents(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_GetNetworkEventsAvailable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNetworkEventsAvailable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetNetworkEventsAvailable() :
      op->vtkTCPNetworkAccessManager::GetNetworkEventsAvailable());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_GetPendingConnectionsPresent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPendingConnectionsPresent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPendingConnectionsPresent() :
      op->vtkTCPNetworkAccessManager::GetPendingConnectionsPresent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_DisableFurtherConnections(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableFurtherConnections");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->DisableFurtherConnections(temp0, temp1);
    }
    else
    {
      op->vtkTCPNetworkAccessManager::DisableFurtherConnections(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkTCPNetworkAccessManager_GetWrongConnectID(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWrongConnectID");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkTCPNetworkAccessManager *op = static_cast<vtkTCPNetworkAccessManager *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWrongConnectID() :
      op->vtkTCPNetworkAccessManager::GetWrongConnectID());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkTCPNetworkAccessManager_Methods[] = {
  {"IsTypeOf", PyvtkTCPNetworkAccessManager_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkTCPNetworkAccessManager_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkTCPNetworkAccessManager_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkTCPNetworkAccessManager\nC++: static vtkTCPNetworkAccessManager *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkTCPNetworkAccessManager_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkTCPNetworkAccessManager\nC++: vtkTCPNetworkAccessManager *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkTCPNetworkAccessManager_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkTCPNetworkAccessManager_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"NewConnection", PyvtkTCPNetworkAccessManager_NewConnection, METH_VARARGS,
   "NewConnection(self, url:str,\n    result:vtkNetworkAccessManager.ConnectionResult)\n    -> vtkMultiProcessController\nC++: vtkMultiProcessController *NewConnection(const char *url,\n    vtkNetworkAccessManager::ConnectionResult &result) override;\nNewConnection(self, url:str) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *NewConnection(\n    const char *url)\n\n"},
  {"AbortPendingConnection", PyvtkTCPNetworkAccessManager_AbortPendingConnection, METH_VARARGS,
   "AbortPendingConnection(self) -> None\nC++: void AbortPendingConnection() override;\n\nUsed to abort pending connection creation, if any. Refer to\nNewConnection() for details.\n"},
  {"ProcessEvents", PyvtkTCPNetworkAccessManager_ProcessEvents, METH_VARARGS,
   "ProcessEvents(self, timeout_msecs:int) -> int\nC++: int ProcessEvents(unsigned long timeout_msecs) override;\n\nProcess any network activity.\n"},
  {"GetNetworkEventsAvailable", PyvtkTCPNetworkAccessManager_GetNetworkEventsAvailable, METH_VARARGS,
   "GetNetworkEventsAvailable(self) -> bool\nC++: bool GetNetworkEventsAvailable() override;\n\nPeeks to check if any activity is available. When this call\nreturns true, ProcessEvents() will always result in some activity\nprocessing if called afterword.\n"},
  {"GetPendingConnectionsPresent", PyvtkTCPNetworkAccessManager_GetPendingConnectionsPresent, METH_VARARGS,
   "GetPendingConnectionsPresent(self) -> bool\nC++: bool GetPendingConnectionsPresent() override;\n\nReturns true is the manager is currently waiting for any\nconnections.\n"},
  {"DisableFurtherConnections", PyvtkTCPNetworkAccessManager_DisableFurtherConnections, METH_VARARGS,
   "DisableFurtherConnections(self, port:int, disable:bool) -> None\nC++: void DisableFurtherConnections(int port, bool disable)\n    override;\n\nEnable/disable further connections for given port.\n"},
  {"GetWrongConnectID", PyvtkTCPNetworkAccessManager_GetWrongConnectID, METH_VARARGS,
   "GetWrongConnectID(self) -> bool\nC++: bool GetWrongConnectID() override;\n\nReturns true if the last check of connect ids was wrong.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkTCPNetworkAccessManager_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("network_events_available"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTCPNetworkAccessManager_GetNetworkEventsAvailable(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNetworkEventsAvailable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("pending_connections_present"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTCPNetworkAccessManager_GetPendingConnectionsPresent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPendingConnectionsPresent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("wrong_connect_id"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkTCPNetworkAccessManager_GetWrongConnectID(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetWrongConnectID\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkTCPNetworkAccessManager_Doc =
  "vtkTCPNetworkAccessManager - vtkTCPNetworkAccessManager is a concrete\nimplementation of vtkNetworkAccessManager that uses tcp/ip sockets\nfor communication between processes.\n\n"
  "Superclass: vtkNetworkAccessManager\n\n"
  "It supports urls that use \"tcp\" as their protocol specifier.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkTCPNetworkAccessManager_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingCore.vtkTCPNetworkAccessManager", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkTCPNetworkAccessManager_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkTCPNetworkAccessManager_StaticNew()
{
  return vtkTCPNetworkAccessManager::New();
}

PyObject *PyvtkTCPNetworkAccessManager_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkTCPNetworkAccessManager_Type, PyvtkTCPNetworkAccessManager_Methods,
    "vtkTCPNetworkAccessManager",
 &PyvtkTCPNetworkAccessManager_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkNetworkAccessManager_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkTCPNetworkAccessManager_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkTCPNetworkAccessManager(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkTCPNetworkAccessManager_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkTCPNetworkAccessManager", o) != 0)
  {
    Py_DECREF(o);
  }

}

