// ClientServer wrapper for vtkMeshQuality object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkMeshQuality.h"
#include "vtkSystemIncludes.h"
#include "vtkClientServerInterpreter.h"
#include "vtkClientServerStream.h"


static vtkObjectBase *vtkMeshQualityClientServerNewCommand(void* /*ctx*/)
{
  return vtkMeshQuality::New();
}


static int vtkMeshQualityCommand(
  vtkClientServerInterpreter *arlu, vtkObjectBase *ob,
  const char *method, const vtkClientServerStream& msg,
  vtkClientServerStream& resultStream, void* /*ctx*/)
{
  vtkMeshQuality *op = vtkMeshQuality::SafeDownCast(ob);
  if(!op)
    {
    vtkOStrStreamWrapper vtkmsg;
    vtkmsg << "Cannot cast " << ob->GetClassName() << " object to vtkMeshQuality.  "
           << "This probably means the class specifies the incorrect superclass in vtkTypeMacro.";
    resultStream.Reset();
    resultStream << vtkClientServerStream::Error
                 << vtkmsg.str() << 0 << vtkClientServerStream::End;
    return 0;
    }
  (void)arlu;
  if (!strcmp("IsTypeOf",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkMeshQuality::IsTypeOf(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("IsA",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    int      temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->IsA(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SafeDownCast",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkObjectBase  *temp0;
    vtkMeshQuality  *temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkObjectBase"))
      {
      temp20 = vtkMeshQuality::SafeDownCast(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("NewInstance",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkMeshQuality  *temp20;
      {
      temp20 = (op)->NewInstance();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBaseType",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = vtkMeshQuality::GetNumberOfGenerationsFromBaseType(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("GetNumberOfGenerationsFromBase",method) && msg.GetNumberOfArguments(0) == 3)
    {
    char    *temp0;
    long long   temp20;
    if(msg.GetArgument(0, 2, &temp0))
      {
      temp20 = (op)->GetNumberOfGenerationsFromBase(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("New",method) && msg.GetNumberOfArguments(0) == 2)
    {
    vtkMeshQuality  *temp20;
      {
      temp20 = vtkMeshQuality::New();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << (vtkObjectBase *)temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetSaveCellQuality",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetSaveCellQuality(temp0);
      return 1;
      }
    }
  if (!strcmp("GetSaveCellQuality",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetSaveCellQuality();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SaveCellQualityOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SaveCellQualityOn();
      return 1;
      }
    }
  if (!strcmp("SaveCellQualityOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SaveCellQualityOff();
      return 1;
      }
    }
  if (!strcmp("SetLinearApproximation",method) && msg.GetNumberOfArguments(0) == 3)
    {
    bool   temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetLinearApproximation(temp0);
      return 1;
      }
    }
  if (!strcmp("GetLinearApproximation",method) && msg.GetNumberOfArguments(0) == 2)
    {
    bool   temp20;
      {
      temp20 = (op)->GetLinearApproximation();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("LinearApproximationOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LinearApproximationOn();
      return 1;
      }
    }
  if (!strcmp("LinearApproximationOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->LinearApproximationOff();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetTriangleQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToArea",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToArea();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToAspectRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToAspectRatio();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToRadiusRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToRadiusRatio();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToMinAngle",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToMinAngle();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToMaxAngle",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToMaxAngle();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToCondition",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToCondition();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToRelativeSizeSquared();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToShapeAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToShapeAndSize();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToDistortion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToDistortion();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetTriangleQualityMeasureToNormalizedInradius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTriangleQualityMeasureToNormalizedInradius();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetQuadQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToAspectRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToAspectRatio();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToRadiusRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToRadiusRatio();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToMedAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToMedAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToMaxAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToMaxEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToMaxEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToSkew();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToTaper",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToTaper();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToWarpage",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToWarpage();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToArea",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToArea();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToStretch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToStretch();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToMinAngle",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToMinAngle();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToMaxAngle",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToMaxAngle();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToOddy",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToOddy();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToCondition",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToCondition();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToJacobian();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToShear",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToShear();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToRelativeSizeSquared();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToShapeAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToShapeAndSize();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToShearAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToShearAndSize();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToDistortion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToDistortion();
      return 1;
      }
    }
  if (!strcmp("SetQuadQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetQuadQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetTetQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToAspectRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToAspectRatio();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToRadiusRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToRadiusRatio();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToMinAngle",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToMinAngle();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToCollapseRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToCollapseRatio();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToAspectGamma",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToAspectGamma();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToVolume",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToVolume();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToCondition",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToCondition();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToJacobian();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToRelativeSizeSquared();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToShapeAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToShapeAndSize();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToDistortion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToDistortion();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToEquivolumeSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToEquivolumeSkew();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToMeanRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToMeanRatio();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToNormalizedInradius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToNormalizedInradius();
      return 1;
      }
    }
  if (!strcmp("SetTetQualityMeasureToSquishIndex",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetTetQualityMeasureToSquishIndex();
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetPyramidQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetPyramidQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasureToJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetPyramidQualityMeasureToJacobian();
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetPyramidQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetPyramidQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetPyramidQualityMeasureToVolume",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetPyramidQualityMeasureToVolume();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetWedgeQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToCondition",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToCondition();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToDistortion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToDistortion();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToJacobian();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToMaxAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToMaxStretch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToMaxStretch();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToMeanAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToMeanAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetWedgeQualityMeasureToVolume",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetWedgeQualityMeasureToVolume();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasure",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetHexQualityMeasure(temp0);
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToMedAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToMedAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToMaxAspectFrobenius();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToMaxEdgeRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToMaxEdgeRatio();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToSkew();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToTaper",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToTaper();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToVolume",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToVolume();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToStretch",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToStretch();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToDiagonal",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToDiagonal();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToDimension",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToDimension();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToOddy",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToOddy();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToCondition",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToCondition();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToJacobian();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToScaledJacobian",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToScaledJacobian();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToShear",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToShear();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToShape",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToShape();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToRelativeSizeSquared();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToShapeAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToShapeAndSize();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToShearAndSize",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToShearAndSize();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToDistortion",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToDistortion();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToEquiangleSkew();
      return 1;
      }
    }
  if (!strcmp("SetHexQualityMeasureToNodalJacobianRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->SetHexQualityMeasureToNodalJacobianRatio();
      return 1;
      }
    }
  if (!strcmp("TriangleArea",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleArea(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleAspectRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleAspectRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleRadiusRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleRadiusRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleMinAngle",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleMinAngle(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleMaxAngle",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleMaxAngle(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleCondition",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleCondition(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleRelativeSizeSquared(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleShapeAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleShapeAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleDistortion",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleDistortion(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TriangleNormalizedInradius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TriangleNormalizedInradius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadAspectRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadAspectRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadRadiusRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadRadiusRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadMedAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadMedAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadMaxAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadMinAngle",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadMinAngle(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadMaxEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadMaxEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadTaper",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadTaper(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadWarpage",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadWarpage(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadArea",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadArea(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadStretch",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadStretch(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadMaxAngle",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadMaxAngle(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadOddy",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadOddy(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadCondition",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadCondition(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadShear",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadShear(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadRelativeSizeSquared(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadShapeAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadShapeAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadShearAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadShearAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadDistortion",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadDistortion(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("QuadEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::QuadEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetAspectRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetAspectRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetRadiusRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetRadiusRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetMinAngle",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetMinAngle(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetCollapseRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetCollapseRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetAspectGamma",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetAspectGamma(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetVolume",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetVolume(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetCondition",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetCondition(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetRelativeSizeSquared(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetShapeAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetShapeAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetDistortion",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetDistortion(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetEquivolumeSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetEquivolumeSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetMeanRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetMeanRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetNormalizedInradius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetNormalizedInradius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("TetSquishIndex",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::TetSquishIndex(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PyramidEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::PyramidEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PyramidJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::PyramidJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PyramidScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::PyramidScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PyramidShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::PyramidShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("PyramidVolume",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::PyramidVolume(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeCondition",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeCondition(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeDistortion",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeDistortion(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeMaxAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeMaxStretch",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeMaxStretch(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeMeanAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeMeanAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("WedgeVolume",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::WedgeVolume(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexMedAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexMedAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexMaxAspectFrobenius",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexMaxAspectFrobenius(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexMaxEdgeRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexMaxEdgeRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexTaper",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexTaper(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexVolume",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexVolume(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexStretch",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexStretch(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexDiagonal",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexDiagonal(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexDimension",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexDimension(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexOddy",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexOddy(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexCondition",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexCondition(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexScaledJacobian",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexScaledJacobian(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexShear",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexShear(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexShape",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexShape(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexRelativeSizeSquared",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexRelativeSizeSquared(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexShapeAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexShapeAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexShearAndSize",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexShearAndSize(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexDistortion",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexDistortion(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexEquiangleSkew",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexEquiangleSkew(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("HexNodalJacobianRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    vtkCell  *temp0;
    double   temp20;
    if(vtkClientServerStreamGetArgumentObject(msg, 0, 2, &temp0, "vtkCell"))
      {
      temp20 = vtkMeshQuality::HexNodalJacobianRatio(temp0);
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("SetRatio",method) && msg.GetNumberOfArguments(0) == 3)
    {
    int      temp0;
    if(msg.GetArgument(0, 2, &temp0))
      {
      op->SetRatio(temp0);
      return 1;
      }
    }
  if (!strcmp("GetRatio",method) && msg.GetNumberOfArguments(0) == 2)
    {
    int      temp20;
      {
      temp20 = (op)->GetRatio();
      resultStream.Reset();
      resultStream << vtkClientServerStream::Reply << temp20 << vtkClientServerStream::End;
      return 1;
      }
    }
  if (!strcmp("RatioOn",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RatioOn();
      return 1;
      }
    }
  if (!strcmp("RatioOff",method) && msg.GetNumberOfArguments(0) == 2)
    {
      {
      op->RatioOff();
      return 1;
      }
    }

  {
    const char* commandName = "vtkDataSetAlgorithm";
    if (arlu->HasCommandFunction(commandName) &&
        arlu->CallCommandFunction(commandName, op, method, msg, resultStream)) { return 1; }
  }
  if(resultStream.GetNumberOfMessages() > 0 &&
     resultStream.GetCommand(0) == vtkClientServerStream::Error &&
     resultStream.GetNumberOfArguments(0) > 1)
    {
    /* A superclass wrapper prepared a special message. */
    return 0;
    }
  vtkOStrStreamWrapper vtkmsg;
  vtkmsg << "Object type: vtkMeshQuality, could not find requested method: \""
         << method << "\"\nor the method was called with incorrect arguments.\n";
  resultStream.Reset();
  resultStream << vtkClientServerStream::Error
               << vtkmsg.str() << vtkClientServerStream::End;
  vtkmsg.rdbuf()->freeze(0);
  return 0;
}


//-------------------------------------------------------------------------auto
extern "C"
{
VTK_ABI_HIDDEN void vtkMeshQuality_Init(vtkClientServerInterpreter* csi)
{
  static vtkClientServerInterpreter* last = nullptr;
  if(last != csi)
    {
    last = csi;
    csi->AddNewInstanceFunction("vtkMeshQuality", vtkMeshQualityClientServerNewCommand);
    csi->AddCommandFunction("vtkMeshQuality", vtkMeshQualityCommand);
    }
}
}
