#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImageCanvasSource2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageEllipsoidSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageGaussianSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageGridSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMandelbrotSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageNoiseSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSinusoidSource_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingSourcesCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImageCanvasSource2D_Init(csi);
  vtkImageEllipsoidSource_Init(csi);
  vtkImageGaussianSource_Init(csi);
  vtkImageGridSource_Init(csi);
  vtkImageMandelbrotSource_Init(csi);
  vtkImageNoiseSource_Init(csi);
  vtkImageSinusoidSource_Init(csi);
}
