// python wrapper for vtkExtractScatterPlot
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExtractScatterPlot.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExtractScatterPlot(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExtractScatterPlot_ClassNew(); }


static PyObject *
PyvtkExtractScatterPlot_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExtractScatterPlot::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExtractScatterPlot::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExtractScatterPlot *tempr = vtkExtractScatterPlot::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExtractScatterPlot *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExtractScatterPlot::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExtractScatterPlot::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExtractScatterPlot::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_SetXComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXComponent(temp0);
    }
    else
    {
      op->vtkExtractScatterPlot::SetXComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXComponentMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXComponentMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXComponentMinValue() :
      op->vtkExtractScatterPlot::GetXComponentMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXComponentMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXComponentMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXComponentMaxValue() :
      op->vtkExtractScatterPlot::GetXComponentMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXComponent() :
      op->vtkExtractScatterPlot::GetXComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_SetYComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYComponent(temp0);
    }
    else
    {
      op->vtkExtractScatterPlot::SetYComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYComponentMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYComponentMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYComponentMinValue() :
      op->vtkExtractScatterPlot::GetYComponentMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYComponentMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYComponentMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYComponentMaxValue() :
      op->vtkExtractScatterPlot::GetYComponentMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYComponent() :
      op->vtkExtractScatterPlot::GetYComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_SetXBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetXBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetXBinCount(temp0);
    }
    else
    {
      op->vtkExtractScatterPlot::SetXBinCount(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXBinCountMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXBinCountMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXBinCountMinValue() :
      op->vtkExtractScatterPlot::GetXBinCountMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXBinCountMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXBinCountMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXBinCountMaxValue() :
      op->vtkExtractScatterPlot::GetXBinCountMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetXBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetXBinCount() :
      op->vtkExtractScatterPlot::GetXBinCount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_SetYBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetYBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetYBinCount(temp0);
    }
    else
    {
      op->vtkExtractScatterPlot::SetYBinCount(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYBinCountMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYBinCountMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYBinCountMinValue() :
      op->vtkExtractScatterPlot::GetYBinCountMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYBinCountMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYBinCountMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYBinCountMaxValue() :
      op->vtkExtractScatterPlot::GetYBinCountMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExtractScatterPlot_GetYBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetYBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExtractScatterPlot *op = static_cast<vtkExtractScatterPlot *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetYBinCount() :
      op->vtkExtractScatterPlot::GetYBinCount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkExtractScatterPlot_Methods[] = {
  {"IsTypeOf", PyvtkExtractScatterPlot_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExtractScatterPlot_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExtractScatterPlot_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExtractScatterPlot\nC++: static vtkExtractScatterPlot *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExtractScatterPlot_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExtractScatterPlot\nC++: vtkExtractScatterPlot *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExtractScatterPlot_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExtractScatterPlot_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetXComponent", PyvtkExtractScatterPlot_SetXComponent, METH_VARARGS,
   "SetXComponent(self, _arg:int) -> None\nC++: virtual void SetXComponent(int _arg)\n\nControls which input data component should be binned, for input\narrays with more-than-one component\n"},
  {"GetXComponentMinValue", PyvtkExtractScatterPlot_GetXComponentMinValue, METH_VARARGS,
   "GetXComponentMinValue(self) -> int\nC++: virtual int GetXComponentMinValue()\n\n"},
  {"GetXComponentMaxValue", PyvtkExtractScatterPlot_GetXComponentMaxValue, METH_VARARGS,
   "GetXComponentMaxValue(self) -> int\nC++: virtual int GetXComponentMaxValue()\n\n"},
  {"GetXComponent", PyvtkExtractScatterPlot_GetXComponent, METH_VARARGS,
   "GetXComponent(self) -> int\nC++: virtual int GetXComponent()\n\n"},
  {"SetYComponent", PyvtkExtractScatterPlot_SetYComponent, METH_VARARGS,
   "SetYComponent(self, _arg:int) -> None\nC++: virtual void SetYComponent(int _arg)\n\nControls which input data component should be binned, for input\narrays with more-than-one component\n"},
  {"GetYComponentMinValue", PyvtkExtractScatterPlot_GetYComponentMinValue, METH_VARARGS,
   "GetYComponentMinValue(self) -> int\nC++: virtual int GetYComponentMinValue()\n\n"},
  {"GetYComponentMaxValue", PyvtkExtractScatterPlot_GetYComponentMaxValue, METH_VARARGS,
   "GetYComponentMaxValue(self) -> int\nC++: virtual int GetYComponentMaxValue()\n\n"},
  {"GetYComponent", PyvtkExtractScatterPlot_GetYComponent, METH_VARARGS,
   "GetYComponent(self) -> int\nC++: virtual int GetYComponent()\n\n"},
  {"SetXBinCount", PyvtkExtractScatterPlot_SetXBinCount, METH_VARARGS,
   "SetXBinCount(self, _arg:int) -> None\nC++: virtual void SetXBinCount(int _arg)\n\nControls the number of bins along the X axis in the output\nhistogram data\n"},
  {"GetXBinCountMinValue", PyvtkExtractScatterPlot_GetXBinCountMinValue, METH_VARARGS,
   "GetXBinCountMinValue(self) -> int\nC++: virtual int GetXBinCountMinValue()\n\n"},
  {"GetXBinCountMaxValue", PyvtkExtractScatterPlot_GetXBinCountMaxValue, METH_VARARGS,
   "GetXBinCountMaxValue(self) -> int\nC++: virtual int GetXBinCountMaxValue()\n\n"},
  {"GetXBinCount", PyvtkExtractScatterPlot_GetXBinCount, METH_VARARGS,
   "GetXBinCount(self) -> int\nC++: virtual int GetXBinCount()\n\n"},
  {"SetYBinCount", PyvtkExtractScatterPlot_SetYBinCount, METH_VARARGS,
   "SetYBinCount(self, _arg:int) -> None\nC++: virtual void SetYBinCount(int _arg)\n\nControls the number of bins along the Y axis in the output\nhistogram data\n"},
  {"GetYBinCountMinValue", PyvtkExtractScatterPlot_GetYBinCountMinValue, METH_VARARGS,
   "GetYBinCountMinValue(self) -> int\nC++: virtual int GetYBinCountMinValue()\n\n"},
  {"GetYBinCountMaxValue", PyvtkExtractScatterPlot_GetYBinCountMaxValue, METH_VARARGS,
   "GetYBinCountMaxValue(self) -> int\nC++: virtual int GetYBinCountMaxValue()\n\n"},
  {"GetYBinCount", PyvtkExtractScatterPlot_GetYBinCount, METH_VARARGS,
   "GetYBinCount(self) -> int\nC++: virtual int GetYBinCount()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExtractScatterPlot_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("x_component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractScatterPlot_GetXComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractScatterPlot_SetXComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractScatterPlot_SetXComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXComponent/SetXComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractScatterPlot_GetYComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractScatterPlot_SetYComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractScatterPlot_SetYComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYComponent/SetYComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("x_bin_count"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractScatterPlot_GetXBinCount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractScatterPlot_SetXBinCount(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractScatterPlot_SetXBinCount(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetXBinCount/SetXBinCount\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("y_bin_count"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExtractScatterPlot_GetYBinCount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExtractScatterPlot_SetYBinCount(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExtractScatterPlot_SetYBinCount(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetYBinCount/SetYBinCount\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExtractScatterPlot_Doc =
  "vtkExtractScatterPlot - Extract a scatter plot (two-dimensional\nhistogram) from any dataset\n\n"
  "Superclass: vtkPolyDataAlgorithm\n\n"
  "vtkExtractScatterPlot accepts any vtkDataSet as input and produces a\n"
  "vtkPolyData containing two-dimensional histogram data as output.  The\n"
  "output vtkPolyData will contain two vtkDoubleArray instances named\n"
  "\"x_bin_extents\" and \"y_bin_extents\", which contain the boundaries\n"
  "between bins along each dimension.  It will also contain a\n"
  "vtkUnsignedLongArray named \"bin_values\" which contains the value for\n"
  "each bin.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExtractScatterPlot_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkExtractScatterPlot", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExtractScatterPlot_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExtractScatterPlot_StaticNew()
{
  return vtkExtractScatterPlot::New();
}

PyObject *PyvtkExtractScatterPlot_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExtractScatterPlot_Type, PyvtkExtractScatterPlot_Methods,
    "vtkExtractScatterPlot",
 &PyvtkExtractScatterPlot_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPolyDataAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExtractScatterPlot_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExtractScatterPlot(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExtractScatterPlot_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExtractScatterPlot", o) != 0)
  {
    Py_DECREF(o);
  }

}

