// python wrapper for vtkPVScalarBarActor
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVScalarBarActor.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVScalarBarActor(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVScalarBarActor_ClassNew(); }


static PyObject *
PyvtkPVScalarBarActor_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVScalarBarActor::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVScalarBarActor::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVScalarBarActor *tempr = vtkPVScalarBarActor::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVScalarBarActor *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVScalarBarActor::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVScalarBarActor::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVScalarBarActor::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetAspectRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAspectRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetAspectRatio() :
      op->vtkPVScalarBarActor::GetAspectRatio());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetAspectRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAspectRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAspectRatio(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetAspectRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetAutomaticLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutomaticLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAutomaticLabelFormat() :
      op->vtkPVScalarBarActor::GetAutomaticLabelFormat());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetAutomaticLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutomaticLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutomaticLabelFormat(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetAutomaticLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AutomaticLabelFormatOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticLabelFormatOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticLabelFormatOn();
    }
    else
    {
      op->vtkPVScalarBarActor::AutomaticLabelFormatOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AutomaticLabelFormatOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticLabelFormatOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticLabelFormatOff();
    }
    else
    {
      op->vtkPVScalarBarActor::AutomaticLabelFormatOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetDrawTickMarks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDrawTickMarks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDrawTickMarks() :
      op->vtkPVScalarBarActor::GetDrawTickMarks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetDrawTickMarks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDrawTickMarks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDrawTickMarks(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetDrawTickMarks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_DrawTickMarksOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DrawTickMarksOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DrawTickMarksOn();
    }
    else
    {
      op->vtkPVScalarBarActor::DrawTickMarksOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_DrawTickMarksOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DrawTickMarksOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DrawTickMarksOff();
    }
    else
    {
      op->vtkPVScalarBarActor::DrawTickMarksOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetDrawSubTickMarks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDrawSubTickMarks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetDrawSubTickMarks() :
      op->vtkPVScalarBarActor::GetDrawSubTickMarks());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetDrawSubTickMarks(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDrawSubTickMarks");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDrawSubTickMarks(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetDrawSubTickMarks(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_DrawSubTickMarksOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DrawSubTickMarksOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DrawSubTickMarksOn();
    }
    else
    {
      op->vtkPVScalarBarActor::DrawSubTickMarksOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_DrawSubTickMarksOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DrawSubTickMarksOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DrawSubTickMarksOff();
    }
    else
    {
      op->vtkPVScalarBarActor::DrawSubTickMarksOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetAddRangeLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddRangeLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAddRangeLabels() :
      op->vtkPVScalarBarActor::GetAddRangeLabels());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetAddRangeLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddRangeLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddRangeLabels(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetAddRangeLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AddRangeLabelsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRangeLabelsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddRangeLabelsOn();
    }
    else
    {
      op->vtkPVScalarBarActor::AddRangeLabelsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AddRangeLabelsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRangeLabelsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddRangeLabelsOff();
    }
    else
    {
      op->vtkPVScalarBarActor::AddRangeLabelsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetAutomaticAnnotations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAutomaticAnnotations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAutomaticAnnotations(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetAutomaticAnnotations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetAutomaticAnnotations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAutomaticAnnotations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAutomaticAnnotations() :
      op->vtkPVScalarBarActor::GetAutomaticAnnotations());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AutomaticAnnotationsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticAnnotationsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticAnnotationsOn();
    }
    else
    {
      op->vtkPVScalarBarActor::AutomaticAnnotationsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AutomaticAnnotationsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AutomaticAnnotationsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AutomaticAnnotationsOff();
    }
    else
    {
      op->vtkPVScalarBarActor::AutomaticAnnotationsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetRangeLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRangeLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetRangeLabelFormat() :
      op->vtkPVScalarBarActor::GetRangeLabelFormat());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetRangeLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRangeLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRangeLabelFormat(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetRangeLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AddValueLabelIfUnoccluded(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddValueLabelIfUnoccluded");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->AddValueLabelIfUnoccluded(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVScalarBarActor::AddValueLabelIfUnoccluded(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetTitleJustification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleJustification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleJustification() :
      op->vtkPVScalarBarActor::GetTitleJustification());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetTitleJustification(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleJustification");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleJustification(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetTitleJustification(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetTitleJustificationMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleJustificationMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleJustificationMinValue() :
      op->vtkPVScalarBarActor::GetTitleJustificationMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetTitleJustificationMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleJustificationMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleJustificationMaxValue() :
      op->vtkPVScalarBarActor::GetTitleJustificationMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_GetAddRangeAnnotations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAddRangeAnnotations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAddRangeAnnotations() :
      op->vtkPVScalarBarActor::GetAddRangeAnnotations());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_SetAddRangeAnnotations(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAddRangeAnnotations");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAddRangeAnnotations(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::SetAddRangeAnnotations(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AddRangeAnnotationsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRangeAnnotationsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddRangeAnnotationsOn();
    }
    else
    {
      op->vtkPVScalarBarActor::AddRangeAnnotationsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_AddRangeAnnotationsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddRangeAnnotationsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->AddRangeAnnotationsOff();
    }
    else
    {
      op->vtkPVScalarBarActor::AddRangeAnnotationsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_ReleaseGraphicsResources(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ReleaseGraphicsResources");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  vtkWindow *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkWindow"))
  {
    if (ap.IsBound())
    {
      op->ReleaseGraphicsResources(temp0);
    }
    else
    {
      op->vtkPVScalarBarActor::ReleaseGraphicsResources(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_RenderOpaqueGeometry(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderOpaqueGeometry");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  vtkViewport *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkViewport"))
  {
    int tempr = (ap.IsBound() ?
      op->RenderOpaqueGeometry(temp0) :
      op->vtkPVScalarBarActor::RenderOpaqueGeometry(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVScalarBarActor_RenderOverlay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RenderOverlay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVScalarBarActor *op = static_cast<vtkPVScalarBarActor *>(vp);

  vtkViewport *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkViewport"))
  {
    int tempr = (ap.IsBound() ?
      op->RenderOverlay(temp0) :
      op->vtkPVScalarBarActor::RenderOverlay(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVScalarBarActor_Methods[] = {
  {"IsTypeOf", PyvtkPVScalarBarActor_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVScalarBarActor_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVScalarBarActor_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVScalarBarActor\nC++: static vtkPVScalarBarActor *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVScalarBarActor_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVScalarBarActor\nC++: vtkPVScalarBarActor *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVScalarBarActor_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVScalarBarActor_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetAspectRatio", PyvtkPVScalarBarActor_GetAspectRatio, METH_VARARGS,
   "GetAspectRatio(self) -> float\nC++: virtual double GetAspectRatio()\n\nThe bar aspect ratio (length/width).  Defaults to 20.  Note that\nthis the aspect ratio of the color bar only, not including\nlabels.\n"},
  {"SetAspectRatio", PyvtkPVScalarBarActor_SetAspectRatio, METH_VARARGS,
   "SetAspectRatio(self, _arg:float) -> None\nC++: virtual void SetAspectRatio(double _arg)\n\n"},
  {"GetAutomaticLabelFormat", PyvtkPVScalarBarActor_GetAutomaticLabelFormat, METH_VARARGS,
   "GetAutomaticLabelFormat(self) -> int\nC++: virtual int GetAutomaticLabelFormat()\n\nIf true (the default), the printf format used for the labels will\nbe automatically generated to make the numbers best fit within\nthe widget.  If false, the LabelFormat ivar will be used.\n"},
  {"SetAutomaticLabelFormat", PyvtkPVScalarBarActor_SetAutomaticLabelFormat, METH_VARARGS,
   "SetAutomaticLabelFormat(self, _arg:int) -> None\nC++: virtual void SetAutomaticLabelFormat(int _arg)\n\n"},
  {"AutomaticLabelFormatOn", PyvtkPVScalarBarActor_AutomaticLabelFormatOn, METH_VARARGS,
   "AutomaticLabelFormatOn(self) -> None\nC++: virtual void AutomaticLabelFormatOn()\n\n"},
  {"AutomaticLabelFormatOff", PyvtkPVScalarBarActor_AutomaticLabelFormatOff, METH_VARARGS,
   "AutomaticLabelFormatOff(self) -> None\nC++: virtual void AutomaticLabelFormatOff()\n\n"},
  {"GetDrawTickMarks", PyvtkPVScalarBarActor_GetDrawTickMarks, METH_VARARGS,
   "GetDrawTickMarks(self) -> int\nC++: virtual int GetDrawTickMarks()\n\nIf true (the default), tick marks will be drawn.\n"},
  {"SetDrawTickMarks", PyvtkPVScalarBarActor_SetDrawTickMarks, METH_VARARGS,
   "SetDrawTickMarks(self, _arg:int) -> None\nC++: virtual void SetDrawTickMarks(int _arg)\n\n"},
  {"DrawTickMarksOn", PyvtkPVScalarBarActor_DrawTickMarksOn, METH_VARARGS,
   "DrawTickMarksOn(self) -> None\nC++: virtual void DrawTickMarksOn()\n\n"},
  {"DrawTickMarksOff", PyvtkPVScalarBarActor_DrawTickMarksOff, METH_VARARGS,
   "DrawTickMarksOff(self) -> None\nC++: virtual void DrawTickMarksOff()\n\n"},
  {"GetDrawSubTickMarks", PyvtkPVScalarBarActor_GetDrawSubTickMarks, METH_VARARGS,
   "GetDrawSubTickMarks(self) -> int\nC++: virtual int GetDrawSubTickMarks()\n\nIf true (the default), sub-tick marks will be drawn.\n"},
  {"SetDrawSubTickMarks", PyvtkPVScalarBarActor_SetDrawSubTickMarks, METH_VARARGS,
   "SetDrawSubTickMarks(self, _arg:int) -> None\nC++: virtual void SetDrawSubTickMarks(int _arg)\n\n"},
  {"DrawSubTickMarksOn", PyvtkPVScalarBarActor_DrawSubTickMarksOn, METH_VARARGS,
   "DrawSubTickMarksOn(self) -> None\nC++: virtual void DrawSubTickMarksOn()\n\n"},
  {"DrawSubTickMarksOff", PyvtkPVScalarBarActor_DrawSubTickMarksOff, METH_VARARGS,
   "DrawSubTickMarksOff(self) -> None\nC++: virtual void DrawSubTickMarksOff()\n\n"},
  {"GetAddRangeLabels", PyvtkPVScalarBarActor_GetAddRangeLabels, METH_VARARGS,
   "GetAddRangeLabels(self) -> int\nC++: virtual int GetAddRangeLabels()\n\nSet whether the range endpoints (minimum and maximum) are added\nas labels alongside other value labels.\n"},
  {"SetAddRangeLabels", PyvtkPVScalarBarActor_SetAddRangeLabels, METH_VARARGS,
   "SetAddRangeLabels(self, _arg:int) -> None\nC++: virtual void SetAddRangeLabels(int _arg)\n\n"},
  {"AddRangeLabelsOn", PyvtkPVScalarBarActor_AddRangeLabelsOn, METH_VARARGS,
   "AddRangeLabelsOn(self) -> None\nC++: virtual void AddRangeLabelsOn()\n\n"},
  {"AddRangeLabelsOff", PyvtkPVScalarBarActor_AddRangeLabelsOff, METH_VARARGS,
   "AddRangeLabelsOff(self) -> None\nC++: virtual void AddRangeLabelsOff()\n\n"},
  {"SetAutomaticAnnotations", PyvtkPVScalarBarActor_SetAutomaticAnnotations, METH_VARARGS,
   "SetAutomaticAnnotations(self, _arg:int) -> None\nC++: virtual void SetAutomaticAnnotations(int _arg)\n\nSet whether annotions are automatically created according the\nnumber of discrete colors. Default is FALSE;\n"},
  {"GetAutomaticAnnotations", PyvtkPVScalarBarActor_GetAutomaticAnnotations, METH_VARARGS,
   "GetAutomaticAnnotations(self) -> int\nC++: virtual int GetAutomaticAnnotations()\n\n"},
  {"AutomaticAnnotationsOn", PyvtkPVScalarBarActor_AutomaticAnnotationsOn, METH_VARARGS,
   "AutomaticAnnotationsOn(self) -> None\nC++: virtual void AutomaticAnnotationsOn()\n\n"},
  {"AutomaticAnnotationsOff", PyvtkPVScalarBarActor_AutomaticAnnotationsOff, METH_VARARGS,
   "AutomaticAnnotationsOff(self) -> None\nC++: virtual void AutomaticAnnotationsOff()\n\n"},
  {"GetRangeLabelFormat", PyvtkPVScalarBarActor_GetRangeLabelFormat, METH_VARARGS,
   "GetRangeLabelFormat(self) -> str\nC++: virtual char *GetRangeLabelFormat()\n\nSet the C-style format string for the range labels.\n"},
  {"SetRangeLabelFormat", PyvtkPVScalarBarActor_SetRangeLabelFormat, METH_VARARGS,
   "SetRangeLabelFormat(self, _arg:str) -> None\nC++: virtual void SetRangeLabelFormat(const char *_arg)\n\n"},
  {"AddValueLabelIfUnoccluded", PyvtkPVScalarBarActor_AddValueLabelIfUnoccluded, METH_VARARGS,
   "AddValueLabelIfUnoccluded(self, value:float, pos:float,\n    diff:float) -> None\nC++: virtual void AddValueLabelIfUnoccluded(double value,\n    double pos, double diff)\n\nAdd value as annotation label on scalar bar at the given position\n"},
  {"GetTitleJustification", PyvtkPVScalarBarActor_GetTitleJustification, METH_VARARGS,
   "GetTitleJustification(self) -> int\nC++: virtual int GetTitleJustification()\n\nSet the title justification. Valid values are VTK_TEXT_LEFT,\nVTK_TEXT_CENTERED, and VTK_TEXT_RIGHT.\n"},
  {"SetTitleJustification", PyvtkPVScalarBarActor_SetTitleJustification, METH_VARARGS,
   "SetTitleJustification(self, _arg:int) -> None\nC++: virtual void SetTitleJustification(int _arg)\n\n"},
  {"GetTitleJustificationMinValue", PyvtkPVScalarBarActor_GetTitleJustificationMinValue, METH_VARARGS,
   "GetTitleJustificationMinValue(self) -> int\nC++: virtual int GetTitleJustificationMinValue()\n\n"},
  {"GetTitleJustificationMaxValue", PyvtkPVScalarBarActor_GetTitleJustificationMaxValue, METH_VARARGS,
   "GetTitleJustificationMaxValue(self) -> int\nC++: virtual int GetTitleJustificationMaxValue()\n\n"},
  {"GetAddRangeAnnotations", PyvtkPVScalarBarActor_GetAddRangeAnnotations, METH_VARARGS,
   "GetAddRangeAnnotations(self) -> int\nC++: virtual int GetAddRangeAnnotations()\n\nSet whether the scalar data range endpoints (minimum and maximum)\nare added as annotations.\n"},
  {"SetAddRangeAnnotations", PyvtkPVScalarBarActor_SetAddRangeAnnotations, METH_VARARGS,
   "SetAddRangeAnnotations(self, _arg:int) -> None\nC++: virtual void SetAddRangeAnnotations(int _arg)\n\n"},
  {"AddRangeAnnotationsOn", PyvtkPVScalarBarActor_AddRangeAnnotationsOn, METH_VARARGS,
   "AddRangeAnnotationsOn(self) -> None\nC++: virtual void AddRangeAnnotationsOn()\n\n"},
  {"AddRangeAnnotationsOff", PyvtkPVScalarBarActor_AddRangeAnnotationsOff, METH_VARARGS,
   "AddRangeAnnotationsOff(self) -> None\nC++: virtual void AddRangeAnnotationsOff()\n\n"},
  {"ReleaseGraphicsResources", PyvtkPVScalarBarActor_ReleaseGraphicsResources, METH_VARARGS,
   "ReleaseGraphicsResources(self, __a:vtkWindow) -> None\nC++: void ReleaseGraphicsResources(vtkWindow *) override;\n\nRelease any graphics resources that are being consumed by this\nactor. The parameter window could be used to determine which\ngraphic resources to release.\n"},
  {"RenderOpaqueGeometry", PyvtkPVScalarBarActor_RenderOpaqueGeometry, METH_VARARGS,
   "RenderOpaqueGeometry(self, viewport:vtkViewport) -> int\nC++: int RenderOpaqueGeometry(vtkViewport *viewport) override;\n\nOverridden to sync internal variables with renderer state.\n"},
  {"RenderOverlay", PyvtkPVScalarBarActor_RenderOverlay, METH_VARARGS,
   "RenderOverlay(self, viewport:vtkViewport) -> int\nC++: int RenderOverlay(vtkViewport *viewport) override;\n\nDraw the scalar bar and annotation text to the screen.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVScalarBarActor_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("aspect_ratio"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetAspectRatio(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetAspectRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetAspectRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAspectRatio/SetAspectRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("automatic_label_format"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetAutomaticLabelFormat(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetAutomaticLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetAutomaticLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticLabelFormat/SetAutomaticLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("draw_tick_marks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetDrawTickMarks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetDrawTickMarks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetDrawTickMarks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDrawTickMarks/SetDrawTickMarks\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("draw_sub_tick_marks"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetDrawSubTickMarks(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetDrawSubTickMarks(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetDrawSubTickMarks(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDrawSubTickMarks/SetDrawSubTickMarks\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_range_labels"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetAddRangeLabels(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetAddRangeLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetAddRangeLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddRangeLabels/SetAddRangeLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("automatic_annotations"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetAutomaticAnnotations(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetAutomaticAnnotations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetAutomaticAnnotations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAutomaticAnnotations/SetAutomaticAnnotations\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("range_label_format"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetRangeLabelFormat(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetRangeLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetRangeLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRangeLabelFormat/SetRangeLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_justification"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetTitleJustification(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetTitleJustification(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetTitleJustification(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleJustification/SetTitleJustification\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("add_range_annotations"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVScalarBarActor_GetAddRangeAnnotations(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVScalarBarActor_SetAddRangeAnnotations(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVScalarBarActor_SetAddRangeAnnotations(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAddRangeAnnotations/SetAddRangeAnnotations\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVScalarBarActor_Doc =
  "vtkPVScalarBarActor - A scalar bar with labels of fixed font.\n\n"
  "Superclass: vtkScalarBarActor\n\n"
  "vtkPVScalarBarActor has basically the same functionality as\n"
  "vtkScalarBarActor except that the fonts are set to a fixed size and\n"
  "tick labels vary in precision before their size is adjusted to meet\n"
  "geometric constraints. These changes make it easier to control in\n"
  "ParaView.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVScalarBarActor_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVScalarBarActor", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVScalarBarActor_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVScalarBarActor_StaticNew()
{
  return vtkPVScalarBarActor::New();
}

PyObject *PyvtkPVScalarBarActor_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVScalarBarActor_Type, PyvtkPVScalarBarActor_Methods,
    "vtkPVScalarBarActor",
 &PyvtkPVScalarBarActor_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkScalarBarActor");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVScalarBarActor_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVScalarBarActor(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVScalarBarActor_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVScalarBarActor", o) != 0)
  {
    Py_DECREF(o);
  }

}

