// This file is generated by kconfig_compiler_kf6 from kscreenlockersettings.kcfg.
// All changes you do to this file will be lost.
#ifndef KSCREENSAVERSETTINGS_H
#define KSCREENSAVERSETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class KScreenSaverSettings : public KConfigSkeleton
{
  public:

    static KScreenSaverSettings *self();
    ~KScreenSaverSettings() override;

    /**
      Set Screen lock enabled
    */
    static
    void setAutolock( bool v )
    {
      if (!self()->isAutolockImmutable())
        self()->mAutolock = v;
    }

    /**
      Get Screen lock enabled
    */
    static
    bool autolock()
    {
      return self()->mAutolock;
    }

    /**
      Is Screen lock enabled Immutable
    */
    static
    bool isAutolockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Autolock" ) );
    }

    /**
      Set Screen saver timeout
    */
    static
    void setTimeout( int v )
    {
      if (v < 1)
      {
        qDebug() << "setTimeout: value " << v << " is less than the minimum value of 1";
        v = 1;
      }
      if (!self()->isTimeoutImmutable())
        self()->mTimeout = v;
    }

    /**
      Get Screen saver timeout
    */
    static
    int timeout()
    {
      return self()->mTimeout;
    }

    /**
      Is Screen saver timeout Immutable
    */
    static
    bool isTimeoutImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Timeout" ) );
    }

    /**
      Set Lock
    */
    static
    void setLock( bool v )
    {
      if (!self()->isLockImmutable())
        self()->mLock = v;
    }

    /**
      Get Lock
    */
    static
    bool lock()
    {
      return self()->mLock;
    }

    /**
      Is Lock Immutable
    */
    static
    bool isLockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Lock" ) );
    }

    /**
      Set LockGrace
    */
    static
    void setLockGrace( int v )
    {
      if (v < 0)
      {
        qDebug() << "setLockGrace: value " << v << " is less than the minimum value of 0";
        v = 0;
      }

      if (v > 300)
      {
        qDebug() << "setLockGrace: value " << v << " is greater than the maximum value of 300";
        v = 300;
      }

      if (!self()->isLockGraceImmutable())
        self()->mLockGrace = v;
    }

    /**
      Get LockGrace
    */
    static
    int lockGrace()
    {
      return self()->mLockGrace;
    }

    /**
      Is LockGrace Immutable
    */
    static
    bool isLockGraceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockGrace" ) );
    }

    /**
      Set LockOnResume
    */
    static
    void setLockOnResume( bool v )
    {
      if (!self()->isLockOnResumeImmutable())
        self()->mLockOnResume = v;
    }

    /**
      Get LockOnResume
    */
    static
    bool lockOnResume()
    {
      return self()->mLockOnResume;
    }

    /**
      Is LockOnResume Immutable
    */
    static
    bool isLockOnResumeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "LockOnResume" ) );
    }

    /**
      Set Theme
    */
    static
    void setTheme( const QString & v )
    {
      if (!self()->isThemeImmutable())
        self()->mTheme = v;
    }

    /**
      Get Theme
    */
    static
    QString theme()
    {
      return self()->mTheme;
    }

    /**
      Is Theme Immutable
    */
    static
    bool isThemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Theme" ) );
    }

    /**
      Set ThemeBackground
    */
    static
    void setThemeBackground( const QString & v )
    {
      if (!self()->isThemeBackgroundImmutable())
        self()->mThemeBackground = v;
    }

    /**
      Get ThemeBackground
    */
    static
    QString themeBackground()
    {
      return self()->mThemeBackground;
    }

    /**
      Is ThemeBackground Immutable
    */
    static
    bool isThemeBackgroundImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ThemeBackground" ) );
    }

  protected:
    KScreenSaverSettings();
    friend class KScreenSaverSettingsHelper;


    // Daemon
    bool mAutolock;
    int mTimeout;
    bool mLock;
    int mLockGrace;
    bool mLockOnResume;

    // Greeter
    QString mTheme;
    QString mThemeBackground;
};

#endif

