/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtMultimedia.h"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qvideoframe.sip"
#include <qvideoframe.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"

#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qvideoframeformat.sip"
#include <qvideoframeformat.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qimage.sip"
#include <qimage.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qtvideo.sip"
#include <qtvideo.h>
#line 39 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qpainter.sip"
#include <qpainter.h>
#line 42 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 170 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qrect.sip"
#include <qrect.h>
#line 45 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 28 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qvideoframe.sip"
#include <qvideoframe.h>
#line 82 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtMultimedia/qvideoframe.sip"
#include <qvideoframe.h>
#line 50 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 53 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qsize.sip"
#include <qsize.h>
#line 56 "/build/pyqt6/src/pyqt6-6.10.1/build/QtMultimedia/sipQtMultimediaQVideoFrame.cpp"


PyDoc_STRVAR(doc_QVideoFrame_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isValid(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isValid, doc_QVideoFrame_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_pixelFormat, "pixelFormat(self) -> QVideoFrameFormat.PixelFormat");

extern "C" {static PyObject *meth_QVideoFrame_pixelFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_pixelFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrameFormat::PixelFormat sipRes;

            sipRes = sipCpp->pixelFormat();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrameFormat_PixelFormat);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_pixelFormat, doc_QVideoFrame_pixelFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_handleType, "handleType(self) -> QVideoFrame.HandleType");

extern "C" {static PyObject *meth_QVideoFrame_handleType(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_handleType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrame::HandleType sipRes;

            sipRes = sipCpp->handleType();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_HandleType);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_handleType, doc_QVideoFrame_handleType);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_size, "size(self) -> QSize");

extern "C" {static PyObject *meth_QVideoFrame_size(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_size(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QSize*sipRes;

            sipRes = new ::QSize(sipCpp->size());

            return sipConvertFromNewType(sipRes, sipType_QSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_size, doc_QVideoFrame_size);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_width, "width(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_width(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_width(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->width();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_width, doc_QVideoFrame_width);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_height, "height(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_height(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_height(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->height();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_height, doc_QVideoFrame_height);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isMapped, "isMapped(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isMapped(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isMapped(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isMapped();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isMapped, doc_QVideoFrame_isMapped);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isReadable, "isReadable(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isReadable(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isReadable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isReadable();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isReadable, doc_QVideoFrame_isReadable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_isWritable, "isWritable(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_isWritable(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_isWritable(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isWritable();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_isWritable, doc_QVideoFrame_isWritable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_mapMode, "mapMode(self) -> QVideoFrame.MapMode");

extern "C" {static PyObject *meth_QVideoFrame_mapMode(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_mapMode(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrame::MapMode sipRes;

            sipRes = sipCpp->mapMode();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_MapMode);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_mapMode, doc_QVideoFrame_mapMode);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_map, "map(self, mode: QVideoFrame.MapMode) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_map(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_map(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame::MapMode a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QVideoFrame_MapMode, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->map(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_map, doc_QVideoFrame_map);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_unmap, "unmap(self)");

extern "C" {static PyObject *meth_QVideoFrame_unmap(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_unmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            sipCpp->unmap();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_unmap, doc_QVideoFrame_unmap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_bytesPerLine, "bytesPerLine(self, plane: int) -> int");

extern "C" {static PyObject *meth_QVideoFrame_bytesPerLine(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_bytesPerLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->bytesPerLine(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_bytesPerLine, doc_QVideoFrame_bytesPerLine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_bits, "bits(self, plane: int) -> Optional[PyQt6.sip.voidptr]");

extern "C" {static PyObject *meth_QVideoFrame_bits(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_bits(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            void*sipRes;

            sipRes = sipCpp->bits(a0);

            return sipConvertFromVoidPtr(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_bits, doc_QVideoFrame_bits);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_mappedBytes, "mappedBytes(self, plane: int) -> int");

extern "C" {static PyObject *meth_QVideoFrame_mappedBytes(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_mappedBytes(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->mappedBytes(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_mappedBytes, doc_QVideoFrame_mappedBytes);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_startTime, "startTime(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_startTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_startTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->startTime();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_startTime, doc_QVideoFrame_startTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setStartTime, "setStartTime(self, time: int)");

extern "C" {static PyObject *meth_QVideoFrame_setStartTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setStartTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setStartTime(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setStartTime, doc_QVideoFrame_setStartTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_endTime, "endTime(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_endTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_endTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::qint64 sipRes;

            sipRes = sipCpp->endTime();

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_endTime, doc_QVideoFrame_endTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setEndTime, "setEndTime(self, time: int)");

extern "C" {static PyObject *meth_QVideoFrame_setEndTime(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setEndTime(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qint64 a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bn", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setEndTime(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setEndTime, doc_QVideoFrame_setEndTime);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_planeCount, "planeCount(self) -> int");

extern "C" {static PyObject *meth_QVideoFrame_planeCount(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_planeCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->planeCount();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_planeCount, doc_QVideoFrame_planeCount);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_surfaceFormat, "surfaceFormat(self) -> QVideoFrameFormat");

extern "C" {static PyObject *meth_QVideoFrame_surfaceFormat(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_surfaceFormat(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrameFormat*sipRes;

            sipRes = new ::QVideoFrameFormat(sipCpp->surfaceFormat());

            return sipConvertFromNewType(sipRes, sipType_QVideoFrameFormat, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_surfaceFormat, doc_QVideoFrame_surfaceFormat);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_toImage, "toImage(self) -> QImage");

extern "C" {static PyObject *meth_QVideoFrame_toImage(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_toImage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QImage*sipRes;

            sipRes = new ::QImage(sipCpp->toImage());

            return sipConvertFromNewType(sipRes, sipType_QImage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_toImage, doc_QVideoFrame_toImage);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_subtitleText, "subtitleText(self) -> str");

extern "C" {static PyObject *meth_QVideoFrame_subtitleText(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_subtitleText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->subtitleText());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_subtitleText, doc_QVideoFrame_subtitleText);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setSubtitleText, "setSubtitleText(self, text: Optional[str])");

extern "C" {static PyObject *meth_QVideoFrame_setSubtitleText(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setSubtitleText(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setSubtitleText(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setSubtitleText, doc_QVideoFrame_setSubtitleText);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_paint, "paint(self, painter: Optional[QPainter], rect: QRectF, options: QVideoFrame.PaintOptions)");

extern "C" {static PyObject *meth_QVideoFrame_paint(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_paint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPainter* a0;
        const ::QRectF* a1;
        const ::QVideoFrame::PaintOptions* a2;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ8J9J9", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QPainter, &a0, sipType_QRectF, &a1, sipType_QVideoFrame_PaintOptions, &a2))
        {
            sipCpp->paint(a0, *a1, *a2);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_paint, doc_QVideoFrame_paint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setRotationAngle, "setRotationAngle(self, a0: QVideoFrame.RotationAngle)");

extern "C" {static PyObject *meth_QVideoFrame_setRotationAngle(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setRotationAngle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVideoFrame::RotationAngle a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QVideoFrame_RotationAngle, &a0))
        {
            sipCpp->setRotationAngle(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setRotationAngle, doc_QVideoFrame_setRotationAngle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_rotationAngle, "rotationAngle(self) -> QVideoFrame.RotationAngle");

extern "C" {static PyObject *meth_QVideoFrame_rotationAngle(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_rotationAngle(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QVideoFrame::RotationAngle sipRes;

            sipRes = sipCpp->rotationAngle();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QVideoFrame_RotationAngle);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_rotationAngle, doc_QVideoFrame_rotationAngle);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setMirrored, "setMirrored(self, a0: bool)");

extern "C" {static PyObject *meth_QVideoFrame_setMirrored(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setMirrored(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bb", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setMirrored(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setMirrored, doc_QVideoFrame_setMirrored);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_mirrored, "mirrored(self) -> bool");

extern "C" {static PyObject *meth_QVideoFrame_mirrored(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_mirrored(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->mirrored();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_mirrored, doc_QVideoFrame_mirrored);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setRotation, "setRotation(self, angle: QtVideo.Rotation)");

extern "C" {static PyObject *meth_QVideoFrame_setRotation(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setRotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QtVideo::Rotation a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QVideoFrame, &sipCpp, sipType_QtVideo_Rotation, &a0))
        {
            sipCpp->setRotation(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setRotation, doc_QVideoFrame_setRotation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_rotation, "rotation(self) -> QtVideo.Rotation");

extern "C" {static PyObject *meth_QVideoFrame_rotation(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_rotation(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::QtVideo::Rotation sipRes;

            sipRes = sipCpp->rotation();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QtVideo_Rotation);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_rotation, doc_QVideoFrame_rotation);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_setStreamFrameRate, "setStreamFrameRate(self, rate: float)");

extern "C" {static PyObject *meth_QVideoFrame_setStreamFrameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_setStreamFrameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::qreal a0;
        ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bd", &sipSelf, sipType_QVideoFrame, &sipCpp, &a0))
        {
            sipCpp->setStreamFrameRate(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_setStreamFrameRate, doc_QVideoFrame_setStreamFrameRate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVideoFrame_streamFrameRate, "streamFrameRate(self) -> float");

extern "C" {static PyObject *meth_QVideoFrame_streamFrameRate(PyObject *, PyObject *);}
static PyObject *meth_QVideoFrame_streamFrameRate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVideoFrame, &sipCpp))
        {
            ::qreal sipRes;

            sipRes = sipCpp->streamFrameRate();

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVideoFrame, sipName_streamFrameRate, doc_QVideoFrame_streamFrameRate);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVideoFrame___ne__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrame___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrame *sipCpp = reinterpret_cast< ::QVideoFrame *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrame));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrame, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrame::operator!=(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, ne_slot, sipType_QVideoFrame, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVideoFrame___eq__(PyObject *, PyObject *);}
static PyObject *slot_QVideoFrame___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVideoFrame *sipCpp = reinterpret_cast< ::QVideoFrame *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVideoFrame));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVideoFrame* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVideoFrame, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->::QVideoFrame::operator==(*a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtMultimedia, eq_slot, sipType_QVideoFrame, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QVideoFrame(void *, int);}
static void release_QVideoFrame(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVideoFrame *>(sipCppV);
}


extern "C" {static void *array_QVideoFrame(Py_ssize_t);}
static void *array_QVideoFrame(Py_ssize_t sipNrElem)
{
    return new ::QVideoFrame[sipNrElem];
}


extern "C" {static void array_delete_QVideoFrame(void *);}
static void array_delete_QVideoFrame(void *sipCpp)
{
    delete[] reinterpret_cast< ::QVideoFrame *>(sipCpp);
}


extern "C" {static void assign_QVideoFrame(void *, Py_ssize_t, void *);}
static void assign_QVideoFrame(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVideoFrame *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVideoFrame *>(sipSrc);
}


extern "C" {static void *copy_QVideoFrame(const void *, Py_ssize_t);}
static void *copy_QVideoFrame(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVideoFrame(reinterpret_cast<const ::QVideoFrame *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVideoFrame(sipSimpleWrapper *);}
static void dealloc_QVideoFrame(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVideoFrame(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVideoFrame(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVideoFrame(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QVideoFrame *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QVideoFrame();

            return sipCpp;
        }
    }

    {
        const ::QVideoFrameFormat* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVideoFrameFormat, &a0))
        {
            sipCpp = new ::QVideoFrame(*a0);

            return sipCpp;
        }
    }

    {
        const ::QImage* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QImage, &a0))
        {
            sipCpp = new ::QVideoFrame(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVideoFrame* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVideoFrame, &a0))
        {
            sipCpp = new ::QVideoFrame(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVideoFrame[] = {
    {(void *)slot_QVideoFrame___ne__, ne_slot},
    {(void *)slot_QVideoFrame___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVideoFrame[] = {
    {sipName_bits, meth_QVideoFrame_bits, METH_VARARGS, doc_QVideoFrame_bits},
    {sipName_bytesPerLine, meth_QVideoFrame_bytesPerLine, METH_VARARGS, doc_QVideoFrame_bytesPerLine},
    {sipName_endTime, meth_QVideoFrame_endTime, METH_VARARGS, doc_QVideoFrame_endTime},
    {sipName_handleType, meth_QVideoFrame_handleType, METH_VARARGS, doc_QVideoFrame_handleType},
    {sipName_height, meth_QVideoFrame_height, METH_VARARGS, doc_QVideoFrame_height},
    {sipName_isMapped, meth_QVideoFrame_isMapped, METH_VARARGS, doc_QVideoFrame_isMapped},
    {sipName_isReadable, meth_QVideoFrame_isReadable, METH_VARARGS, doc_QVideoFrame_isReadable},
    {sipName_isValid, meth_QVideoFrame_isValid, METH_VARARGS, doc_QVideoFrame_isValid},
    {sipName_isWritable, meth_QVideoFrame_isWritable, METH_VARARGS, doc_QVideoFrame_isWritable},
    {sipName_map, meth_QVideoFrame_map, METH_VARARGS, doc_QVideoFrame_map},
    {sipName_mapMode, meth_QVideoFrame_mapMode, METH_VARARGS, doc_QVideoFrame_mapMode},
    {sipName_mappedBytes, meth_QVideoFrame_mappedBytes, METH_VARARGS, doc_QVideoFrame_mappedBytes},
    {sipName_mirrored, meth_QVideoFrame_mirrored, METH_VARARGS, doc_QVideoFrame_mirrored},
    {sipName_paint, meth_QVideoFrame_paint, METH_VARARGS, doc_QVideoFrame_paint},
    {sipName_pixelFormat, meth_QVideoFrame_pixelFormat, METH_VARARGS, doc_QVideoFrame_pixelFormat},
    {sipName_planeCount, meth_QVideoFrame_planeCount, METH_VARARGS, doc_QVideoFrame_planeCount},
    {sipName_rotation, meth_QVideoFrame_rotation, METH_VARARGS, doc_QVideoFrame_rotation},
    {sipName_rotationAngle, meth_QVideoFrame_rotationAngle, METH_VARARGS, doc_QVideoFrame_rotationAngle},
    {sipName_setEndTime, meth_QVideoFrame_setEndTime, METH_VARARGS, doc_QVideoFrame_setEndTime},
    {sipName_setMirrored, meth_QVideoFrame_setMirrored, METH_VARARGS, doc_QVideoFrame_setMirrored},
    {sipName_setRotation, meth_QVideoFrame_setRotation, METH_VARARGS, doc_QVideoFrame_setRotation},
    {sipName_setRotationAngle, meth_QVideoFrame_setRotationAngle, METH_VARARGS, doc_QVideoFrame_setRotationAngle},
    {sipName_setStartTime, meth_QVideoFrame_setStartTime, METH_VARARGS, doc_QVideoFrame_setStartTime},
    {sipName_setStreamFrameRate, meth_QVideoFrame_setStreamFrameRate, METH_VARARGS, doc_QVideoFrame_setStreamFrameRate},
    {sipName_setSubtitleText, meth_QVideoFrame_setSubtitleText, METH_VARARGS, doc_QVideoFrame_setSubtitleText},
    {sipName_size, meth_QVideoFrame_size, METH_VARARGS, doc_QVideoFrame_size},
    {sipName_startTime, meth_QVideoFrame_startTime, METH_VARARGS, doc_QVideoFrame_startTime},
    {sipName_streamFrameRate, meth_QVideoFrame_streamFrameRate, METH_VARARGS, doc_QVideoFrame_streamFrameRate},
    {sipName_subtitleText, meth_QVideoFrame_subtitleText, METH_VARARGS, doc_QVideoFrame_subtitleText},
    {sipName_surfaceFormat, meth_QVideoFrame_surfaceFormat, METH_VARARGS, doc_QVideoFrame_surfaceFormat},
    {sipName_toImage, meth_QVideoFrame_toImage, METH_VARARGS, doc_QVideoFrame_toImage},
    {sipName_unmap, meth_QVideoFrame_unmap, METH_VARARGS, doc_QVideoFrame_unmap},
    {sipName_width, meth_QVideoFrame_width, METH_VARARGS, doc_QVideoFrame_width}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QVideoFrame[] = {
    {sipName_NoHandle, static_cast<int>(::QVideoFrame::NoHandle)},
    {sipName_RhiTextureHandle, static_cast<int>(::QVideoFrame::RhiTextureHandle)},
    {sipName_NotMapped, static_cast<int>(::QVideoFrame::NotMapped)},
    {sipName_ReadOnly, static_cast<int>(::QVideoFrame::ReadOnly)},
    {sipName_WriteOnly, static_cast<int>(::QVideoFrame::WriteOnly)},
    {sipName_ReadWrite, static_cast<int>(::QVideoFrame::ReadWrite)},
    {sipName_Rotation0, static_cast<int>(::QVideoFrame::Rotation0)},
    {sipName_Rotation90, static_cast<int>(::QVideoFrame::Rotation90)},
    {sipName_Rotation180, static_cast<int>(::QVideoFrame::Rotation180)},
    {sipName_Rotation270, static_cast<int>(::QVideoFrame::Rotation270)},
    {0, 0}
};

PyDoc_STRVAR(doc_QVideoFrame, "\1QVideoFrame()\n"
"QVideoFrame(format: QVideoFrameFormat)\n"
"QVideoFrame(image: QImage)\n"
"QVideoFrame(other: QVideoFrame)");


sipClassTypeDef sipTypeDef_QtMultimedia_QVideoFrame = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVideoFrame,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QVideoFrame,
        {0, 0, 1},
        33, methods_QVideoFrame,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QVideoFrame, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVideoFrame,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVideoFrame,
    init_type_QVideoFrame,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVideoFrame,
    assign_QVideoFrame,
    array_QVideoFrame,
    copy_QVideoFrame,
    release_QVideoFrame,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QVideoFrame,
    sizeof (::QVideoFrame),
};
