// third_party/blink/public/mojom/native_io/native_io.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/native_io/native_io.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/native_io/native_io.mojom-params-data.h"
#include "third_party/blink/public/mojom/native_io/native_io.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/native_io/native_io.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NATIVE_IO_NATIVE_IO_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char NativeIOFileHost::Name_[] = "blink.mojom.NativeIOFileHost";
bool NativeIOFileHost::Close() {
  NOTREACHED();
  return false;
}
bool NativeIOFileHost::SetLength(int64_t length, ::base::File backing_file, bool* out_success, ::base::File* out_backing_file) {
  NOTREACHED();
  return false;
}
class NativeIOFileHost_Close_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_Close_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_HandleSyncResponse);
};

class NativeIOFileHost_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_Close_ForwardToCallback(
      NativeIOFileHost::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOFileHost::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_ForwardToCallback);
};
class NativeIOFileHost_SetLength_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_SetLength_HandleSyncResponse(
      bool* result, bool* out_success, ::base::File* out_backing_file)
      : result_(result), out_success_(out_success), out_backing_file_(out_backing_file) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  ::base::File* out_backing_file_;DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_SetLength_HandleSyncResponse);
};

class NativeIOFileHost_SetLength_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOFileHost_SetLength_ForwardToCallback(
      NativeIOFileHost::SetLengthCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOFileHost::SetLengthCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_SetLength_ForwardToCallback);
};

NativeIOFileHostProxy::NativeIOFileHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NativeIOFileHostProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_Close_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_Close_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  return result;
}

void NativeIOFileHostProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeIOFileHost::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_Close_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOFileHostProxy::SetLength(
    int64_t param_length, ::base::File param_backing_file, bool* out_param_success, ::base::File* out_param_backing_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOFileHost::SetLength", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("length", base::NumberToString(param_length));
      raw_value->SetString("backing_file", base::trace_event::ValueToString(param_backing_file, "<value of type ::base::File>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_SetLength_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_SetLength_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->length = param_length;
  typename decltype(params->backing_file)::BaseType::BufferWriter
      backing_file_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      param_backing_file, buffer, &backing_file_writer, &serialization_context);
  params->backing_file.Set(
      backing_file_writer.is_null() ? nullptr : backing_file_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->backing_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null backing_file in NativeIOFileHost.SetLength request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("SetLength");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_SetLength_HandleSyncResponse(
          &result, out_param_success, out_param_backing_file));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOFileHost::SetLength", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      if (out_param_backing_file) {
        raw_value->SetString("backing_file", base::trace_event::ValueToString((*out_param_backing_file), "<value of type ::base::File>"));
      } else {
        raw_value->SetString("backing_file", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NativeIOFileHostProxy::SetLength(
    int64_t in_length, ::base::File in_backing_file, SetLengthCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOFileHost::SetLength", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("length", base::NumberToString(in_length));
      raw_value->SetString("backing_file", base::trace_event::ValueToString(in_backing_file, "<value of type ::base::File>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_SetLength_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_SetLength_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->length = in_length;
  typename decltype(params->backing_file)::BaseType::BufferWriter
      backing_file_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_backing_file, buffer, &backing_file_writer, &serialization_context);
  params->backing_file.Set(
      backing_file_writer.is_null() ? nullptr : backing_file_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->backing_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null backing_file in NativeIOFileHost.SetLength request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("SetLength");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOFileHost_SetLength_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeIOFileHost_Close_ProxyToResponder {
 public:
  static NativeIOFileHost::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOFileHost_Close_ProxyToResponder> proxy(
        new NativeIOFileHost_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOFileHost_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOFileHost_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOFileHost_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOFileHost::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_Close_ProxyToResponder);
};

bool NativeIOFileHost_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOFileHost::CloseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOFileHost_Close_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NativeIOFileHost_Close_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NativeIOFileHost_Close_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::NativeIOFileHost::CloseCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_Close_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOFileHost::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOFileHost_Close_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_Close_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOFileHost_Close_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NativeIOFileHost_Close_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 0, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NativeIOFileHost_SetLength_ProxyToResponder {
 public:
  static NativeIOFileHost::SetLengthCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOFileHost_SetLength_ProxyToResponder> proxy(
        new NativeIOFileHost_SetLength_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOFileHost_SetLength_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOFileHost_SetLength_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOFileHost_SetLength_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOFileHost::SetLengthCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, ::base::File in_backing_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOFileHost_SetLength_ProxyToResponder);
};

bool NativeIOFileHost_SetLength_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOFileHost::SetLengthCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_SetLength_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOFileHost_SetLength_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ::base::File p_backing_file{};
  NativeIOFileHost_SetLength_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_backing_file));
  return true;
}

void NativeIOFileHost_SetLength_ProxyToResponder::Run(
    bool in_success, ::base::File in_backing_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOFileHost::SetLengthCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->SetString("backing_file", base::trace_event::ValueToString(in_backing_file, "<value of type ::base::File>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOFileHost_SetLength_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOFileHost_SetLength_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->backing_file)::BaseType::BufferWriter
      backing_file_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_backing_file, buffer, &backing_file_writer, &serialization_context);
  params->backing_file.Set(
      backing_file_writer.is_null() ? nullptr : backing_file_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->backing_file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null backing_file in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOFileHost::SetLengthCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOFileHost::Name_);
  message.set_method_name("SetLength");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOFileHost_SetLength_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOFileHost_SetLength_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOFileHost_SetLength_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  ::base::File p_backing_file{};
  NativeIOFileHost_SetLength_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOFileHost::Name_, 1, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_backing_file_ = std::move(p_backing_file);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool NativeIOFileHostStubDispatch::Accept(
    NativeIOFileHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeIOFileHost_Close_Name: {
      break;
    }
    case internal::kNativeIOFileHost_SetLength_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeIOFileHostStubDispatch::AcceptWithResponder(
    NativeIOFileHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeIOFileHost_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOFileHost::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOFileHost::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOFileHost_Close_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOFileHost_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeIOFileHost_Close_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOFileHost::Name_, 0, false);
        return false;
      }
      NativeIOFileHost::CloseCallback callback =
          NativeIOFileHost_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
    case internal::kNativeIOFileHost_SetLength_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOFileHost::SetLength",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOFileHost::SetLength");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOFileHost_SetLength_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOFileHost_SetLength_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_length{};
      ::base::File p_backing_file{};
      NativeIOFileHost_SetLength_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_length = input_data_view.length();
      if (success && !input_data_view.ReadBackingFile(&p_backing_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOFileHost::Name_, 1, false);
        return false;
      }
      NativeIOFileHost::SetLengthCallback callback =
          NativeIOFileHost_SetLength_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetLength(
std::move(p_length), 
std::move(p_backing_file), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeIOFileHostValidationInfo[] = {
    {&internal::NativeIOFileHost_Close_Params_Data::Validate,
     &internal::NativeIOFileHost_Close_ResponseParams_Data::Validate},
    {&internal::NativeIOFileHost_SetLength_Params_Data::Validate,
     &internal::NativeIOFileHost_SetLength_ResponseParams_Data::Validate},
};

bool NativeIOFileHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeIOFileHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeIOFileHostValidationInfo);
}

bool NativeIOFileHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeIOFileHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeIOFileHostValidationInfo);
}
const char NativeIOHost::Name_[] = "blink.mojom.NativeIOHost";
bool NativeIOHost::OpenFile(const std::string& name, ::mojo::PendingReceiver<NativeIOFileHost> file_host_receiver, ::base::File* out_backing_file) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::DeleteFile(const std::string& name, bool* out_success) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::GetAllFileNames(bool* out_success, std::vector<std::string>* out_names) {
  NOTREACHED();
  return false;
}
bool NativeIOHost::RenameFile(const std::string& old_name, const std::string& new_name, bool* out_success) {
  NOTREACHED();
  return false;
}
class NativeIOHost_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_OpenFile_HandleSyncResponse(
      bool* result, ::base::File* out_backing_file)
      : result_(result), out_backing_file_(out_backing_file) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File* out_backing_file_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_HandleSyncResponse);
};

class NativeIOHost_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_OpenFile_ForwardToCallback(
      NativeIOHost::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::OpenFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_ForwardToCallback);
};
class NativeIOHost_DeleteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_DeleteFile_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_HandleSyncResponse);
};

class NativeIOHost_DeleteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_DeleteFile_ForwardToCallback(
      NativeIOHost::DeleteFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::DeleteFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_ForwardToCallback);
};
class NativeIOHost_GetAllFileNames_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_GetAllFileNames_HandleSyncResponse(
      bool* result, bool* out_success, std::vector<std::string>* out_names)
      : result_(result), out_success_(out_success), out_names_(out_names) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;
  std::vector<std::string>* out_names_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_HandleSyncResponse);
};

class NativeIOHost_GetAllFileNames_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_GetAllFileNames_ForwardToCallback(
      NativeIOHost::GetAllFileNamesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::GetAllFileNamesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_ForwardToCallback);
};
class NativeIOHost_RenameFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RenameFile_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_HandleSyncResponse);
};

class NativeIOHost_RenameFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeIOHost_RenameFile_ForwardToCallback(
      NativeIOHost::RenameFileCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeIOHost::RenameFileCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_ForwardToCallback);
};

NativeIOHostProxy::NativeIOHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NativeIOHostProxy::OpenFile(
    const std::string& param_name, ::mojo::PendingReceiver<NativeIOFileHost> param_file_host_receiver, ::base::File* out_param_backing_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", param_name);
      raw_value->SetBoolean("file_host_receiver", param_file_host_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_OpenFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeIOFileHostInterfaceBase>>(
      param_file_host_receiver, &params->file_host_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_host_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_host_receiver in NativeIOHost.OpenFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_OpenFile_HandleSyncResponse(
          &result, out_param_backing_file));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_backing_file) {
        raw_value->SetString("backing_file", base::trace_event::ValueToString((*out_param_backing_file), "<value of type ::base::File>"));
      } else {
        raw_value->SetString("backing_file", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NativeIOHostProxy::OpenFile(
    const std::string& in_name, ::mojo::PendingReceiver<NativeIOFileHost> in_file_host_receiver, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::OpenFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", in_name);
      raw_value->SetBoolean("file_host_receiver", in_file_host_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_OpenFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.OpenFile request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::NativeIOFileHostInterfaceBase>>(
      in_file_host_receiver, &params->file_host_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->file_host_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid file_host_receiver in NativeIOHost.OpenFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_OpenFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::DeleteFile(
    const std::string& param_name, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", param_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_DeleteFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.DeleteFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_DeleteFile_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NativeIOHostProxy::DeleteFile(
    const std::string& in_name, DeleteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::DeleteFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("name", in_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_DeleteFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->name)::BaseType::BufferWriter
      name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, buffer, &name_writer, &serialization_context);
  params->name.Set(
      name_writer.is_null() ? nullptr : name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in NativeIOHost.DeleteFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_DeleteFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::GetAllFileNames(
    bool* out_param_success, std::vector<std::string>* out_param_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "blink::mojom::NativeIOHost::GetAllFileNames");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_GetAllFileNames_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_GetAllFileNames_HandleSyncResponse(
          &result, out_param_success, out_param_names));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::GetAllFileNames", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      if (out_param_names) {
        raw_value->BeginArray("names");
        for (const auto& item0 : (*out_param_names)) {
          raw_value->AppendString(item0);
        }
        raw_value->EndArray();
      } else {
        raw_value->SetString("names", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NativeIOHostProxy::GetAllFileNames(
    GetAllFileNamesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeIOHost::GetAllFileNames");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_GetAllFileNames_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_GetAllFileNames_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NativeIOHostProxy::RenameFile(
    const std::string& param_old_name, const std::string& param_new_name, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("old_name", param_old_name);
      raw_value->SetString("new_name", param_new_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_RenameFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->old_name)::BaseType::BufferWriter
      old_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_old_name, buffer, &old_name_writer, &serialization_context);
  params->old_name.Set(
      old_name_writer.is_null() ? nullptr : old_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_name in NativeIOHost.RenameFile request");
  typename decltype(params->new_name)::BaseType::BufferWriter
      new_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_new_name, buffer, &new_name_writer, &serialization_context);
  params->new_name.Set(
      new_name_writer.is_null() ? nullptr : new_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in NativeIOHost.RenameFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RenameFile_HandleSyncResponse(
          &result, out_param_success));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_success) {
        raw_value->SetBoolean("success", (*out_param_success));
      } else {
        raw_value->SetString("success", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NativeIOHostProxy::RenameFile(
    const std::string& in_old_name, const std::string& in_new_name, RenameFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeIOHost::RenameFile", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("old_name", in_old_name);
      raw_value->SetString("new_name", in_new_name);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_RenameFile_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->old_name)::BaseType::BufferWriter
      old_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_old_name, buffer, &old_name_writer, &serialization_context);
  params->old_name.Set(
      old_name_writer.is_null() ? nullptr : old_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_name in NativeIOHost.RenameFile request");
  typename decltype(params->new_name)::BaseType::BufferWriter
      new_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_name, buffer, &new_name_writer, &serialization_context);
  params->new_name.Set(
      new_name_writer.is_null() ? nullptr : new_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_name in NativeIOHost.RenameFile request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeIOHost_RenameFile_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeIOHost_OpenFile_ProxyToResponder {
 public:
  static NativeIOHost::OpenFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_OpenFile_ProxyToResponder> proxy(
        new NativeIOHost_OpenFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_OpenFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File in_backing_file);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_OpenFile_ProxyToResponder);
};

bool NativeIOHost_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::OpenFileCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::File p_backing_file{};
  NativeIOHost_OpenFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_backing_file));
  return true;
}

void NativeIOHost_OpenFile_ProxyToResponder::Run(
    ::base::File in_backing_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::OpenFileCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("backing_file", base::trace_event::ValueToString(in_backing_file, "<value of type ::base::File>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_OpenFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_OpenFile_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->backing_file)::BaseType::BufferWriter
      backing_file_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_backing_file, buffer, &backing_file_writer, &serialization_context);
  params->backing_file.Set(
      backing_file_writer.is_null() ? nullptr : backing_file_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::OpenFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::File p_backing_file{};
  NativeIOHost_OpenFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadBackingFile(&p_backing_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 0, true);
    return false;
  }
  *out_backing_file_ = std::move(p_backing_file);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NativeIOHost_DeleteFile_ProxyToResponder {
 public:
  static NativeIOHost::DeleteFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_DeleteFile_ProxyToResponder> proxy(
        new NativeIOHost_DeleteFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_DeleteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_DeleteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_DeleteFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::DeleteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_DeleteFile_ProxyToResponder);
};

bool NativeIOHost_DeleteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::DeleteFileCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_DeleteFile_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NativeIOHost_DeleteFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void NativeIOHost_DeleteFile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::DeleteFileCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_DeleteFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_DeleteFile_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::DeleteFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("DeleteFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_DeleteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_DeleteFile_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NativeIOHost_DeleteFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 1, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NativeIOHost_GetAllFileNames_ProxyToResponder {
 public:
  static NativeIOHost::GetAllFileNamesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_GetAllFileNames_ProxyToResponder> proxy(
        new NativeIOHost_GetAllFileNames_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_GetAllFileNames_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_GetAllFileNames_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_GetAllFileNames_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::GetAllFileNamesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::vector<std::string>& in_names);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_GetAllFileNames_ProxyToResponder);
};

bool NativeIOHost_GetAllFileNames_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::GetAllFileNamesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOHost_GetAllFileNames_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_GetAllFileNames_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  std::vector<std::string> p_names{};
  NativeIOHost_GetAllFileNames_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadNames(&p_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_names));
  return true;
}

void NativeIOHost_GetAllFileNames_ProxyToResponder::Run(
    bool in_success, const std::vector<std::string>& in_names) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::GetAllFileNamesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      raw_value->BeginArray("names");
      for (const auto& item0 : in_names) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_GetAllFileNames_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_GetAllFileNames_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  typename decltype(params->names)::BaseType::BufferWriter
      names_writer;
  const mojo::internal::ContainerValidateParams names_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_names, buffer, &names_writer, &names_validate_params,
      &serialization_context);
  params->names.Set(
      names_writer.is_null() ? nullptr : names_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->names.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null names in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::GetAllFileNamesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("GetAllFileNames");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_GetAllFileNames_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_GetAllFileNames_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_GetAllFileNames_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  std::vector<std::string> p_names{};
  NativeIOHost_GetAllFileNames_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadNames(&p_names))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 2, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *out_names_ = std::move(p_names);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NativeIOHost_RenameFile_ProxyToResponder {
 public:
  static NativeIOHost::RenameFileCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeIOHost_RenameFile_ProxyToResponder> proxy(
        new NativeIOHost_RenameFile_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeIOHost_RenameFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeIOHost_RenameFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeIOHost_RenameFile_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeIOHost::RenameFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeIOHost_RenameFile_ProxyToResponder);
};

bool NativeIOHost_RenameFile_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeIOHost::RenameFileCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeIOHost_RenameFile_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NativeIOHost_RenameFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void NativeIOHost_RenameFile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeIOHost::RenameFileCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeIOHost_RenameFile_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeIOHost_RenameFile_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeIOHost::RenameFileCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeIOHost::Name_);
  message.set_method_name("RenameFile");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NativeIOHost_RenameFile_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NativeIOHost_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<internal::NativeIOHost_RenameFile_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NativeIOHost_RenameFile_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeIOHost::Name_, 3, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool NativeIOHostStubDispatch::Accept(
    NativeIOHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeIOHost_OpenFile_Name: {
      break;
    }
    case internal::kNativeIOHost_DeleteFile_Name: {
      break;
    }
    case internal::kNativeIOHost_GetAllFileNames_Name: {
      break;
    }
    case internal::kNativeIOHost_RenameFile_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeIOHostStubDispatch::AcceptWithResponder(
    NativeIOHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeIOHost_OpenFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::OpenFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::OpenFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      ::mojo::PendingReceiver<NativeIOFileHost> p_file_host_receiver{};
      NativeIOHost_OpenFile_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success) {
        p_file_host_receiver =
            input_data_view.TakeFileHostReceiver<decltype(p_file_host_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 0, false);
        return false;
      }
      NativeIOHost::OpenFileCallback callback =
          NativeIOHost_OpenFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(
std::move(p_name), 
std::move(p_file_host_receiver), std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_DeleteFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::DeleteFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::DeleteFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_DeleteFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_DeleteFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_name{};
      NativeIOHost_DeleteFile_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 1, false);
        return false;
      }
      NativeIOHost::DeleteFileCallback callback =
          NativeIOHost_DeleteFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteFile(
std::move(p_name), std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_GetAllFileNames_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::GetAllFileNames",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::GetAllFileNames");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_GetAllFileNames_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_GetAllFileNames_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeIOHost_GetAllFileNames_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 2, false);
        return false;
      }
      NativeIOHost::GetAllFileNamesCallback callback =
          NativeIOHost_GetAllFileNames_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllFileNames(std::move(callback));
      return true;
    }
    case internal::kNativeIOHost_RenameFile_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeIOHost::RenameFile",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeIOHost::RenameFile");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeIOHost_RenameFile_Params_Data* params =
          reinterpret_cast<
              internal::NativeIOHost_RenameFile_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_old_name{};
      std::string p_new_name{};
      NativeIOHost_RenameFile_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOldName(&p_old_name))
        success = false;
      if (success && !input_data_view.ReadNewName(&p_new_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeIOHost::Name_, 3, false);
        return false;
      }
      NativeIOHost::RenameFileCallback callback =
          NativeIOHost_RenameFile_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameFile(
std::move(p_old_name), 
std::move(p_new_name), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeIOHostValidationInfo[] = {
    {&internal::NativeIOHost_OpenFile_Params_Data::Validate,
     &internal::NativeIOHost_OpenFile_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_DeleteFile_Params_Data::Validate,
     &internal::NativeIOHost_DeleteFile_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_GetAllFileNames_Params_Data::Validate,
     &internal::NativeIOHost_GetAllFileNames_ResponseParams_Data::Validate},
    {&internal::NativeIOHost_RenameFile_Params_Data::Validate,
     &internal::NativeIOHost_RenameFile_ResponseParams_Data::Validate},
};

bool NativeIOHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeIOHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeIOHostValidationInfo);
}

bool NativeIOHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::NativeIOHost::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeIOHostValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif