// third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-shared.h"
#include "third_party/blink/public/mojom/service_worker/dispatch_fetch_event_params.mojom-blink-forward.h"
#include "services/network/public/mojom/url_loader.mojom-blink.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-blink.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-blink.h"
#include "third_party/blink/public/mojom/timing/worker_timing_container.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {
namespace blink {








class PLATFORM_EXPORT DispatchFetchEventParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DispatchFetchEventParams, T>::value>;
  using DataView = DispatchFetchEventParamsDataView;
  using Data_ = internal::DispatchFetchEventParams_Data;

  template <typename... Args>
  static DispatchFetchEventParamsPtr New(Args&&... args) {
    return DispatchFetchEventParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DispatchFetchEventParamsPtr From(const U& u) {
    return mojo::TypeConverter<DispatchFetchEventParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DispatchFetchEventParams>::Convert(*this);
  }


  DispatchFetchEventParams();

  DispatchFetchEventParams(
      ::blink::mojom::blink::FetchAPIRequestPtr request,
      const WTF::String& client_id,
      ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderClient> preload_url_loader_client_receiver,
      ::mojo::PendingRemote<::blink::mojom::blink::WorkerTimingContainer> worker_timing_remote,
      bool is_offline_capability_check);

  ~DispatchFetchEventParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DispatchFetchEventParamsPtr>
  DispatchFetchEventParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DispatchFetchEventParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DispatchFetchEventParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DispatchFetchEventParams_UnserializedMessageContext<
            UserType, DispatchFetchEventParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<DispatchFetchEventParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return DispatchFetchEventParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DispatchFetchEventParams_UnserializedMessageContext<
            UserType, DispatchFetchEventParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DispatchFetchEventParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::mojom::blink::FetchAPIRequestPtr request;
  
  WTF::String client_id;
  
  ::mojo::PendingReceiver<::network::mojom::blink::URLLoaderClient> preload_url_loader_client_receiver;
  
  ::mojo::PendingRemote<::blink::mojom::blink::WorkerTimingContainer> worker_timing_remote;
  
  bool is_offline_capability_check;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(DispatchFetchEventParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DispatchFetchEventParamsPtr DispatchFetchEventParams::Clone() const {
  return New(
      mojo::Clone(request),
      mojo::Clone(client_id),
      mojo::Clone(preload_url_loader_client_receiver),
      mojo::Clone(worker_timing_remote),
      mojo::Clone(is_offline_capability_check)
  );
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>*>
bool DispatchFetchEventParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->request, other_struct.request))
    return false;
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  if (!mojo::Equals(this->preload_url_loader_client_receiver, other_struct.preload_url_loader_client_receiver))
    return false;
  if (!mojo::Equals(this->worker_timing_remote, other_struct.worker_timing_remote))
    return false;
  if (!mojo::Equals(this->is_offline_capability_check, other_struct.is_offline_capability_check))
    return false;
  return true;
}

template <typename T, DispatchFetchEventParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.request, rhs.request))
    return true;
  if (std::less<>{}(rhs.request, lhs.request))
    return false;
  if (std::less<>{}(lhs.client_id, rhs.client_id))
    return true;
  if (std::less<>{}(rhs.client_id, lhs.client_id))
    return false;
  if (std::less<>{}(lhs.preload_url_loader_client_receiver, rhs.preload_url_loader_client_receiver))
    return true;
  if (std::less<>{}(rhs.preload_url_loader_client_receiver, lhs.preload_url_loader_client_receiver))
    return false;
  if (std::less<>{}(lhs.worker_timing_remote, rhs.worker_timing_remote))
    return true;
  if (std::less<>{}(rhs.worker_timing_remote, lhs.worker_timing_remote))
    return false;
  if (std::less<>{}(lhs.is_offline_capability_check, rhs.is_offline_capability_check))
    return true;
  if (std::less<>{}(rhs.is_offline_capability_check, lhs.is_offline_capability_check))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::DispatchFetchEventParams::DataView,
                                         ::blink::mojom::blink::DispatchFetchEventParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::DispatchFetchEventParamsPtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::DispatchFetchEventParams::request)& request(
       ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) {
    return input->request;
  }

  static const decltype(::blink::mojom::blink::DispatchFetchEventParams::client_id)& client_id(
      const ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) {
    return input->client_id;
  }

  static  decltype(::blink::mojom::blink::DispatchFetchEventParams::preload_url_loader_client_receiver)& preload_url_loader_client_receiver(
       ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) {
    return input->preload_url_loader_client_receiver;
  }

  static  decltype(::blink::mojom::blink::DispatchFetchEventParams::worker_timing_remote)& worker_timing_remote(
       ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) {
    return input->worker_timing_remote;
  }

  static decltype(::blink::mojom::blink::DispatchFetchEventParams::is_offline_capability_check) is_offline_capability_check(
      const ::blink::mojom::blink::DispatchFetchEventParamsPtr& input) {
    return input->is_offline_capability_check;
  }

  static bool Read(::blink::mojom::blink::DispatchFetchEventParams::DataView input, ::blink::mojom::blink::DispatchFetchEventParamsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_DISPATCH_FETCH_EVENT_PARAMS_MOJOM_BLINK_H_