// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by running:
//     ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/embed_js_in_cpp.py --directory gen/chrome/test/chromedriver/chrome ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/call_function.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/dispatch_touch_event.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/execute_async_script.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/execute_script.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/focus.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/get_element_location.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/get_element_region.js ../../../../../qtwebengine/src/3rdparty/chromium/chrome/test/chromedriver/js/is_option_element_toggleable.js

#include "chrome/test/chromedriver/chrome/js.h"

const char kCallFunctionScript[] =
    "function() { // Copyright 2012 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "/**\n"
    " * Enum for WebDriver status codes.\n"
    " * @enum {number}\n"
    " */\n"
    "const StatusCode = {\n"
    "  STALE_ELEMENT_REFERENCE: 10,\n"
    "  JAVA_SCRIPT_ERROR: 17,\n"
    "  NO_SUCH_SHADOW_ROOT: 65,\n"
    "  DETACHED_SHADOW_ROOT: 66,\n"
    "};\n"
    "\n"
    "/**\n"
    " * Enum for node types.\n"
    " * @enum {number}\n"
    " */\n"
    "const NodeType = {\n"
    "  ELEMENT: 1,\n"
    "  DOCUMENT: 9,\n"
    "};\n"
    "\n"
    "/**\n"
    " * Dictionary key to use for holding an element ID.\n"
    " * @const\n"
    " * @type {string}\n"
    " */\n"
    "var ELEMENT_KEY = 'ELEMENT';\n"
    "\n"
    "/**\n"
    " * Dictionary key to use for holding a shadow element ID.\n"
    " * @const\n"
    " * @type {string}\n"
    " */\n"
    "const SHADOW_ROOT_KEY = 'shadow-6066-11e4-a52e-4f735466cecf';\n"
    "const W3C_ELEMENT_KEY = 'element-6066-11e4-a52e-4f735466cecf';\n"
    "const FRAME_KEY = 'frame-075b-4da1-b6ba-e579c2d3230a';\n"
    "const WINDOW_KEY = 'window-fcc6-11e5-b4f8-330a88ab9d7f';\n"
    "\n"
    "const REF_KEYS = [\n"
    "    W3C_ELEMENT_KEY,\n"
    "    SHADOW_ROOT_KEY,\n"
    "    FRAME_KEY,\n"
    "    WINDOW_KEY,\n"
    "    ELEMENT_KEY,\n"
    "];\n"
    "\n"
    "/**\n"
    " * True if using W3C Element references.\n"
    " * @const\n"
    " * @type {boolean}\n"
    " */\n"
    "var w3cEnabled = false;\n"
    "\n"
    "/**\n"
    " * True if shadow dom is enabled.\n"
    " * @const\n"
    " * @type {boolean}\n"
    " */\n"
    "const SHADOW_DOM_ENABLED = typeof ShadowRoot === 'function';\n"
    "\n"
    "/**\n"
    " * Constructs new error to be thrown with given code and message.\n"
    " * @param {string} message Message reported to user.\n"
    " * @param {StatusCode} code StatusCode for error.\n"
    " * @return {!Error} Error object that can be thrown.\n"
    " */\n"
    "function newError(message, code) {\n"
    "  const error = new Error(message);\n"
    "  error.code = code;\n"
    "  return error;\n"
    "}\n"
    "\n"
    "function isNodeReachable(node) {\n"
    "  const Window = window.cdc_adoQpoasnfa76pfcZLmcfl_Window || window.Window;\n"
    "  const nodeRoot = getNodeRootThroughAnyShadows(node);\n"
    "  return (nodeRoot == document.documentElement.parentNode)\n"
    "      || (nodeRoot instanceof Window);\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns the root element of the node.  Found by traversing parentNodes until\n"
    " * a node with no parent is found.  This node is considered the root.\n"
    " * @param {?Node} node The node to find the root element for.\n"
    " * @return {?Node} The root node.\n"
    " */\n"
    "function getNodeRoot(node) {\n"
    "  while (node && node.parentNode) {\n"
    "    node = node.parentNode;\n"
    "  }\n"
    "  return node;\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns the root element of the node, jumping up through shadow roots if\n"
    " * any are found.\n"
    " */\n"
    "function getNodeRootThroughAnyShadows(node) {\n"
    "  let root = getNodeRoot(node);\n"
    "  while (SHADOW_DOM_ENABLED && root instanceof ShadowRoot) {\n"
    "    root = getNodeRoot(root.host);\n"
    "  }\n"
    "  return root;\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns whether given value is an element.\n"
    " * @param {*} value The value to identify as object.\n"
    " * @return {boolean} True if value is a cacheable element.\n"
    " */\n"
    "function isElement(value) {\n"
    "  // As of crrev.com/1316933002, typeof() for some elements will return\n"
    "  // 'function', not 'object'. So we need to check for both non-null objects, as\n"
    "  // well Elements that also happen to be callable functions (e.g. <embed> and\n"
    "  // <object> elements). Note that we can not use |value instanceof Object| here\n"
    "  // since this does not work with frames/iframes, for example\n"
    "  // frames[0].document.body instanceof Object == false even though\n"
    "  // typeof(frames[0].document.body) == 'object'.\n"
    "  try {\n"
    "    return ((typeof(value) == 'object' && value != null) ||\n"
    "              (typeof(value) == 'function' && value.nodeName &&\n"
    "              value.nodeType == NodeType.ELEMENT)) &&\n"
    "            (value.nodeType == NodeType.ELEMENT   ||\n"
    "             value.nodeType == NodeType.DOCUMENT  ||\n"
    "             (SHADOW_DOM_ENABLED && value instanceof ShadowRoot));\n"
    "  } catch {\n"
    "    // OOPIF content window\n"
    "    return false;\n"
    "  }\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns whether given value is a collection (iterable with\n"
    " * 'length' property).\n"
    " * @param {*} value The value to identify as a collection.\n"
    " * @return {boolean} True if value is an iterable collection.\n"
    " */\n"
    "function isCollection(value) {\n"
    "  const Symbol = window.cdc_adoQpoasnfa76pfcZLmcfl_Symbol || window.Symbol;\n"
    "  return (typeof value[Symbol.iterator] === 'function') &&\n"
    "      ('length' in value) &&\n"
    "      (typeof value.length === 'number');\n"
    "}\n"
    "\n"
    "/**\n"
    " * Deep-clones item, given object references in seen, using cloning algorithm\n"
    " * algo. Implements \"clone an object\" from W3C-spec (#dfn-clone-an-object).\n"
    " * @param {*} item Object or collection to deep clone.\n"
    " * @param {!Array<*>} seen Object references that have already been seen.\n"
    " * @param {function(*, Array<*>) : *} algo Cloning algorithm to use to\n"
    " *     deep clone properties of item.\n"
    " * @param {!Array<*>} nodes List of serialized nodes\n"
    " * @return {*} Clone of item with status of cloning.\n"
    " */\n"
    "function cloneWithAlgorithm(item, seen, algo, nodes) {\n"
    "  let tmp = null;\n"
    "  function maybeCopyProperty(prop) {\n"
    "    let sourceValue = null;\n"
    "    try {\n"
    "      sourceValue = item[prop];\n"
    "    } catch(e) {\n"
    "      throw newError('error reading property', StatusCode.JAVA_SCRIPT_ERROR);\n"
    "    }\n"
    "    return algo(sourceValue, seen, nodes);\n"
    "  }\n"
    "\n"
    "  if (isCollection(item)) {\n"
    "    const Array = window.cdc_adoQpoasnfa76pfcZLmcfl_Array || window.Array;\n"
    "    tmp = new Array(item.length);\n"
    "    for (let i = 0; i < item.length; ++i)\n"
    "      tmp[i] = maybeCopyProperty(i);\n"
    "  } else {\n"
    "    tmp = {};\n"
    "    for (let prop in item)\n"
    "      tmp[prop] = maybeCopyProperty(prop);\n"
    "  }\n"
    "  return tmp;\n"
    "}\n"
    "\n"
    "/**\n"
    " * Wrapper to cloneWithAlgorithm, with circular reference detection logic.\n"
    " * @param {*} item Object or collection to deep clone.\n"
    " * @param {!Array<*>} seen Object references that have already been seen.\n"
    " * @param {function(*, Array<*>) : *} algo Cloning algorithm to use to\n"
    " *     deep clone properties of item.\n"
    " * @param {!Array<*>} nodes List of serialized nodes\n"
    " * @return {*} Clone of item with status of cloning.\n"
    " */\n"
    "function cloneWithCircularCheck(item, seen, algo, nodes) {\n"
    "  if (seen.includes(item))\n"
    "    throw newError('circular reference', StatusCode.JAVA_SCRIPT_ERROR);\n"
    "  seen.push(item);\n"
    "  const result = cloneWithAlgorithm(item, seen, algo, nodes);\n"
    "  seen.pop();\n"
    "  return result;\n"
    "}\n"
    "\n"
    "/*\n"
    " * Prohibits call of object.prototype.toJSoN()\n"
    " */\n"
    "function serializationGuard(object) {\n"
    "  const handler = {\n"
    "    get(target, name) {\n"
    "      const value = target[name]\n"
    "      if (typeof value !== 'function')\n"
    "        return value;\n"
    "      // Objects that have own toJSON are never guarded with a proxy.\n"
    "      // All other functions are replaced with {} in preprocessResult.\n"
    "      // The only remaining case when a client tries to access a method is a\n"
    "      // call to non-own toJSON by JSON.stringify.\n"
    "      // In this case this method needs to be concealed.\n"
    "      return undefined;\n"
    "    }\n"
    "  }\n"
    "  const Proxy = window.cdc_adoQpoasnfa76pfcZLmcfl_Proxy || window.Proxy;\n"
    "  return new Proxy(object, handler);\n"
    "}\n"
    "\n"
    "\n"
    "\n"
    "/**\n"
    " * Returns deep clone of given value, replacing element references with a\n"
    " * serialized string representing that element.\n"
    " * @param {*} item Object or collection to deep clone.\n"
    " * @param {!Array<*>} seen Object references that have already been seen.\n"
    " * @param {!Array<*>} nodes List of serialized nodes\n"
    " * @return {*} Clone of item with status of cloning.\n"
    " */\n"
    "function preprocessResult(item, seen, nodes) {\n"
    "  if (item === undefined || item === null)\n"
    "    return null;\n"
    "  if (typeof item === 'boolean' ||\n"
    "      typeof item === 'number' ||\n"
    "      typeof item === 'string')\n"
    "    return item;\n"
    "  // We never descend to own property toJSON.\n"
    "  // Any other function must be serialized as an object.\n"
    "  if (typeof item === 'function')\n"
    "    return {};\n"
    "  if (isElement(item)) {\n"
    "    if (!isNodeReachable(item)) {\n"
    "      if (item instanceof ShadowRoot)\n"
    "        throw newError('shadow root is detached from the current frame',\n"
    "            StatusCode.DETACHED_SHADOW_ROOT);\n"
    "      throw newError('stale element not found in the current frame',\n"
    "                     StatusCode.STALE_ELEMENT_REFERENCE);\n"
    "    }\n"
    "    const ret = {};\n"
    "    let key = ELEMENT_KEY;\n"
    "    if (item instanceof ShadowRoot) {\n"
    "      if (!item.nodeType ||\n"
    "          item.nodeType !== item.DOCUMENT_FRAGMENT_NODE ||\n"
    "          !item.host) {\n"
    "        throw newError('no such shadow root', StatusCode.NO_SUCH_SHADOW_ROOT);\n"
    "      }\n"
    "      key = SHADOW_ROOT_KEY;\n"
    "    }\n"
    "    ret[key] = nodes.length;\n"
    "    nodes.push(item);\n"
    "    return serializationGuard(ret);\n"
    "  }\n"
    "\n"
    "  let WindowProxy = window.cdc_adoQpoasnfa76pfcZLmcfl_Window || window.Window;\n"
    "  let is_oopif = false;\n"
    "  try {\n"
    "    WindowProxy = item.cdc_adoQpoasnfa76pfcZLmcfl_Window || item.Window\n"
    "        || WindowProxy;\n"
    "  } catch {\n"
    "    is_oopif = true;\n"
    "  }\n"
    "\n"
    "  if (is_oopif || item instanceof WindowProxy) {\n"
    "    const ret = {};\n"
    "    ret[WINDOW_KEY] = nodes.length;\n"
    "    nodes.push(item);\n"
    "    return serializationGuard(ret);\n"
    "  }\n"
    "\n"
    "  if (Object.hasOwn(item, 'toJSON') && typeof item.toJSON === 'function') {\n"
    "      // Not guarded because we want item.toJSON to be invoked by\n"
    "      // JSON.stringify.\n"
    "      return item;\n"
    "  }\n"
    "\n"
    "  // Deep cloning of Array and Objects.\n"
    "  return serializationGuard(\n"
    "      cloneWithCircularCheck(item, seen, preprocessResult, nodes));\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns deserialized deep clone of given value, replacing serialized string\n"
    " * references to elements with a element reference, if found.\n"
    " * @param {*} item Object or collection to deep clone.\n"
    " * @param {!Array<*>} seen Object references that have already been seen.\n"
    " * @param {!Array<*>} nodes List of referred nodes\n"
    " * @return {*} Clone of item with status of cloning.\n"
    " */\n"
    "function resolveReferencesRecursive(item, seen, nodes) {\n"
    "  if (item === undefined ||\n"
    "      item === null ||\n"
    "      typeof item === 'boolean' ||\n"
    "      typeof item === 'number' ||\n"
    "      typeof item === 'string' ||\n"
    "      typeof item === 'function')\n"
    "    return item;\n"
    "  for (const key of REF_KEYS) {\n"
    "    if (!item.hasOwnProperty(key))\n"
    "      continue;\n"
    "    let idx = item[key];\n"
    "    if (idx < 0 || idx >= nodes.length) {\n"
    "      throw newError('unable to resove node reference. '\n"
    "          + 'Node index is out of range.', StatusCode.JAVA_SCRIPT_ERROR);\n"
    "    }\n"
    "    if (key == FRAME_KEY)\n"
    "      return nodes[idx].contentWindow;\n"
    "    return nodes[idx];\n"
    "  }\n"
    "  if (isCollection(item) || typeof item === 'object')\n"
    "    return cloneWithAlgorithm(item, seen, resolveReferencesRecursive, nodes);\n"
    "  throw newError('unhandled object', StatusCode.JAVA_SCRIPT_ERROR);\n"
    "}\n"
    "\n"
    "/**\n"
    " * Returns deserialized deep clone of given value, replacing serialized string\n"
    " * references to elements with a element reference, if found.\n"
    " * @param {*} item Object or collection to deep clone.\n"
    " * @param {!Array<*>} nodes List of referred nodes\n"
    " * @return {*} Clone of item with status of cloning.\n"
    " */\n"
    "function resolveReferences(args, nodes) {\n"
    "  for (let idx = 0; idx < nodes.length; ++idx) {\n"
    "    if (!isNodeReachable(nodes[idx])) {\n"
    "      if (nodes[idx] instanceof ShadowRoot)\n"
    "        throw newError('shadow root is detached from the current frame',\n"
    "            StatusCode.DETACHED_SHADOW_ROOT);\n"
    "      throw newError('stale element not found in the current frame',\n"
    "                     StatusCode.STALE_ELEMENT_REFERENCE);\n"
    "    }\n"
    "  }\n"
    "  return resolveReferencesRecursive(args, [], nodes);\n"
    "}\n"
    "\n"
    "/**\n"
    " * Calls a given function and returns its value.\n"
    " *\n"
    " * The inputs to and outputs of the function will be unwrapped and wrapped\n"
    " * respectively, unless otherwise specified. This wrapping involves converting\n"
    " * between cached object reference IDs and actual JS objects.\n"
    " *\n"
    " * @param {function(...[*]) : *} func The function to invoke.\n"
    " * @param {!Array<*>} args The array of arguments to supply to the function,\n"
    " *     which will be unwrapped before invoking the function.\n"
    " * @param {boolean} w3c Whether to return a W3C compliant element reference.\n"
    " * @param {!Array<*>} Nodes referred in the arguments.\n"
    " * @return {*} An object containing a status and value property, where status\n"
    " *     is a WebDriver status code and value is the wrapped value. If an\n"
    " *     unwrapped return was specified, this will be the function's pure return\n"
    " *     value.\n"
    " */\n"
    "function callFunction(func, args, w3c, nodes) {\n"
    "  if (w3c) {\n"
    "    w3cEnabled = true;\n"
    "    ELEMENT_KEY = W3C_ELEMENT_KEY;\n"
    "  }\n"
    "\n"
    "  function buildError(error) {\n"
    "    const errorResponse = serializationGuard({\n"
    "      status: error.code || StatusCode.JAVA_SCRIPT_ERROR,\n"
    "      value: error.message || error\n"
    "    });\n"
    "    const JSON = window.cdc_adoQpoasnfa76pfcZLmcfl_JSON || window.JSON;\n"
    "    return [JSON.stringify(errorResponse)];\n"
    "  }\n"
    "\n"
    "  const Promise = window.cdc_adoQpoasnfa76pfcZLmcfl_Promise || window.Promise;\n"
    "  let unwrappedArgs = null;\n"
    "  try {\n"
    "    unwrappedArgs = resolveReferences(args, nodes);\n"
    "  } catch (error) {\n"
    "    return Promise.resolve(buildError(error));\n"
    "  }\n"
    "\n"
    "  try {\n"
    "    const tmp = func.apply(null, unwrappedArgs);\n"
    "    return Promise.resolve(tmp).then((result) => {\n"
    "      ret_nodes = [];\n"
    "      const response = {\n"
    "        status: 0,\n"
    "        value: preprocessResult(result, [], ret_nodes)\n"
    "      };\n"
    "      const JSON = window.cdc_adoQpoasnfa76pfcZLmcfl_JSON || window.JSON;\n"
    "      return [JSON.stringify(response), ...ret_nodes];\n"
    "    }).catch(buildError);\n"
    "  } catch (error) {\n"
    "    return Promise.resolve(buildError(error));\n"
    "  }\n"
    "}\n"
    "; return callFunction.apply(null, arguments) }\n";
const char kDispatchTouchEventScript[] =
    "function() { // Copyright 2017 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "/**\n"
    " * Dispatches a fake touch event with a single touch point.\n"
    " *\n"
    " * @param {number} x X-coordinate of the touch point relative to viewport\n"
    " *     in CSS pixels.\n"
    " * @param {number} y Y-coordinate of the touch point relative to viewport\n"
    " *     in CSS pixels.\n"
    " * @param {string} type Touch event type, e.g. touchstart.\n"
    " */\n"
    "function dispatchTouchEvent(x, y, type) {\n"
    "  var element = window.document.elementFromPoint(x, y);\n"
    "  var inputDeviceCapabilities =\n"
    "    new InputDeviceCapabilities({firesTouchEvents: true});\n"
    "  var touch = new Touch({\n"
    "    identifier: 0,\n"
    "    target: element,\n"
    "    clientX: x,\n"
    "    clientY: y,\n"
    "    pageX: x + window.document.scrollingElement.scrollLeft,\n"
    "    pageY: y + window.document.scrollingElement.scrollTop,\n"
    "    force: 1,\n"
    "    radiusX: 1,\n"
    "    radiusY: 1,\n"
    "    screenX: x + window.screenX,\n"
    "    screenY: y + window.screenY,\n"
    "  });\n"
    "  var event = new TouchEvent(type, {\n"
    "    touches: [touch],\n"
    "    targetTouches: [touch],\n"
    "    changedTouches: [touch],\n"
    "    ctrlKey: false,\n"
    "    shiftKey: false,\n"
    "    altKey: false,\n"
    "    metaKey: false,\n"
    "    view: window,\n"
    "    bubbles: true,\n"
    "    cancelable: false,\n"
    "    composed: true,\n"
    "    sourceCapabilities: inputDeviceCapabilities,\n"
    "  });\n"
    "  element.dispatchEvent(event);\n"
    "}\n"
    "; return dispatchTouchEvent.apply(null, arguments) }\n";
const char kExecuteAsyncScriptScript[] =
    "function() { // Copyright 2013 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "/**\n"
    " * Enum for WebDriver status codes.\n"
    " * @enum {number}\n"
    " */\n"
    "var StatusCode = {\n"
    "  OK: 0,\n"
    "  UNKNOWN_ERROR: 13,\n"
    "  JAVASCRIPT_ERROR: 17,\n"
    "  SCRIPT_TIMEOUT: 28,\n"
    "};\n"
    "\n"
    "/**\n"
    "* Execute the given script and save its asynchronous result.\n"
    "*\n"
    "* If script1 finishes after script2 is executed, then script1's result will be\n"
    "* discarded while script2's will be saved.\n"
    "*\n"
    "* @param {string} script The asynchronous script to be executed. The script\n"
    "*     should be a proper function body. It will be wrapped in a function and\n"
    "*     invoked with the given arguments and, as the final argument, a callback\n"
    "*     function to invoke to report the asynchronous result.\n"
    "* @param {!Array<*>} args Arguments to be passed to the script.\n"
    "* @param {boolean} isUserSupplied Whether the script is supplied by the user.\n"
    "*     If not, UnknownError will be used instead of JavaScriptError if an\n"
    "*     exception occurs during the script, and an additional error callback will\n"
    "*     be supplied to the script.\n"
    "* @param {boolean} timeout The duration in ms to keep the returned promise from\n"
    "* being garbage collected.\n"
    "*/\n"
    "async function executeAsyncScript(script, args, isUserSupplied, timeout) {\n"
    "  const Promise = window.cdc_adoQpoasnfa76pfcZLmcfl_Promise || window.Promise;\n"
    "  function isThenable(value) {\n"
    "    return typeof value === 'object' && typeof value.then === 'function';\n"
    "  }\n"
    "  function reportValue(value) {\n"
    "    return {status: StatusCode.OK, value: value};\n"
    "  }\n"
    "  function reportError(error) {\n"
    "    var code = isUserSupplied ? StatusCode.JAVASCRIPT_ERROR :\n"
    "                                (error.code || StatusCode.UNKNOWN_ERROR);\n"
    "    var message = error.message;\n"
    "    if (error.stack) {\n"
    "      message += \"\\nJavaScript stack:\\n\" + error.stack;\n"
    "    }\n"
    "    return {status: code, value: message};\n"
    "  }\n"
    "  var promise = new Promise((resolve, reject) => {\n"
    "    args.push(resolve);\n"
    "    if (!isUserSupplied) {\n"
    "      args.push(reject);\n"
    "    }\n"
    "    try {\n"
    "      let scriptResult = new Function(script).apply(null, args);\n"
    "      if (isThenable(scriptResult)) {\n"
    "        const resolvedPromise = Promise.resolve(scriptResult);\n"
    "        resolvedPromise.then((value) => {\n"
    "          // Must be thenable if user-supplied.\n"
    "          if (!isUserSupplied || isThenable(value))\n"
    "            resolve(value);\n"
    "        })\n"
    "        .catch(reject);\n"
    "      }\n"
    "    } catch (error) {\n"
    "      reject(error);\n"
    "    }\n"
    "  });\n"
    "\n"
    "  if (typeof timeout !== 'undefined') {\n"
    "    setTimeout(() => {return promise;}, timeout);\n"
    "  }\n"
    "  return await promise.then((result) => {\n"
    "    return reportValue(result);\n"
    "  }).catch((error) => {\n"
    "    return reportError(error);\n"
    "  });\n"
    "}\n"
    "; return executeAsyncScript.apply(null, arguments) }\n";
const char kExecuteScriptScript[] =
    "function() { // Copyright 2019 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "/**\n"
    "* Execute the given script following the Execute-Script specification laid out\n"
    "* in the W3C WebDriver spec, except for serialization/deserialization of args,\n"
    "* which is handled by callFunction.\n"
    "*\n"
    "* @param {string} script The script to be executed.\n"
    "* @param {!Array<*>} args Arguments to be passed to the script.\n"
    "*/\n"
    "function executeScript(script, args) {\n"
    "  try {\n"
    "    // Convert script (as a string) into an async function.\n"
    "    const f = (new Function('return async function(){' + script + '}'))();\n"
    "    const Promise = window.cdc_adoQpoasnfa76pfcZLmcfl_Promise || window.Promise;\n"
    "    return Promise.resolve(f.apply(null, args));\n"
    "  } catch (e) {\n"
    "    return Promise.reject(e);\n"
    "  }\n"
    "}\n"
    "; return executeScript.apply(null, arguments) }\n";
const char kFocusScript[] =
    "function() { // Copyright 2013 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "function focus(element) {\n"
    "  // Focus the target element in order to send keys to it.\n"
    "  // First, the currently active element is blurred, if it is different from\n"
    "  // the target element. We do not want to blur an element unnecessarily,\n"
    "  // because this may cause us to lose the current cursor position in the\n"
    "  // element.\n"
    "  // Secondly, we focus the target element.\n"
    "  // Thirdly, we check if the new active element is the target element. If not,\n"
    "  // we throw an error.\n"
    "  // Additional notes:\n"
    "  //   - |document.activeElement| is the currently focused element, or body if\n"
    "  //     no element is focused\n"
    "  //   - Even if |document.hasFocus()| returns true and the active element is\n"
    "  //     the body, sometimes we still need to focus the body element for send\n"
    "  //     keys to work. Not sure why\n"
    "  //   - You cannot focus a descendant of a content editable node\n"
    "  //   - V8 throws a TypeError when calling setSelectionRange for a non-text\n"
    "  //     input, which still have setSelectionRange defined. For chrome 29+, V8\n"
    "  //     throws a DOMException with code InvalidStateError.\n"
    "  var doc = element.ownerDocument || element;\n"
    "  var prevActiveElement = doc.activeElement;\n"
    "  if (element != prevActiveElement && prevActiveElement)\n"
    "    prevActiveElement.blur();\n"
    "  element.focus();\n"
    "\n"
    "  var activeElement = doc.activeElement;\n"
    "  // If the element is in a shadow DOM, then as far as the document is\n"
    "  // concerned, the shadow host is the active element. We need to go through the\n"
    "  // tree of shadow DOMs to check that the element we gave focus to is now\n"
    "  // active.\n"
    "  if (element != activeElement && !element.contains(activeElement)) {\n"
    "    var shadowRoot = activeElement.shadowRoot;\n"
    "    while (shadowRoot) {\n"
    "      var activeElement = shadowRoot.activeElement;\n"
    "      if (element == activeElement) {\n"
    "        // the shadow DOM's active element is our requested element. We're good.\n"
    "        break;\n"
    "      }\n"
    "      // The shadow DOM's active element isn't our requested element, check to\n"
    "      // see if there's a nested shadow DOM.\n"
    "      shadowRoot = activeElement.shadowRoot;\n"
    "    }\n"
    "  }\n"
    "  if (element != activeElement && !element.contains(activeElement))\n"
    "    throw new Error('cannot focus element');\n"
    "}\n"
    "; return focus.apply(null, arguments) }\n";
const char kGetElementLocationScript[] =
    "function() { // Copyright 2019 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "/**\n"
    " * Constructs new error to be thrown with given code and message.\n"
    " *\n"
    " * @param {string} message Message reported to user.\n"
    " * @param {StatusCode} code StatusCode for error.\n"
    " * @return {!Error} Error object that can be thrown.\n"
    " */\n"
    "function newError(message, code) {\n"
    "  const error = new Error(message);\n"
    "  error.code = code;\n"
    "  return error;\n"
    "}\n"
    "\n"
    "/**\n"
    " * Get the root node for the given element, jumping up through any ShadowRoots\n"
    " * if they are found.\n"
    " *\n"
    " * @param {Node} node The node to find the root of\n"
    " * @return {Node} The root node\n"
    " */\n"
    "function getNodeRootThroughAnyShadows(node) {\n"
    "  // Fetch the root node for the current node.\n"
    "  let root = node.getRootNode()\n"
    "\n"
    "  // Keep jumping to the root node for the attachment host of any ShadowRoot.\n"
    "  while (root.host) {\n"
    "    root = root.host.getRootNode()\n"
    "  }\n"
    "\n"
    "  return root;\n"
    "}\n"
    "\n"
    "/**\n"
    " * Check whether the specified node is attached to the DOM, either directly or\n"
    " * via any attached ShadowRoot.\n"
    " *\n"
    " * @param {Node} node The node to test\n"
    " * @return {boolean} Whether the node is attached to the DOM.\n"
    " */\n"
    "function isNodeReachable(node) {\n"
    "  const nodeRoot = getNodeRootThroughAnyShadows(node);\n"
    "\n"
    "  // Check whether the root is the Document or Proxy node.\n"
    "  return (nodeRoot == document.documentElement.parentNode);\n"
    "}\n"
    "\n"
    "function getFirstNonZeroWidthHeightRect(rects) {\n"
    "  for (const rect of rects) {\n"
    "    if (rect.height > 0 && rect.width > 0) {\n"
    "      return rect;\n"
    "    }\n"
    "  }\n"
    "  return rects[0];\n"
    "}\n"
    "\n"
    "function getParentRect(element) {\n"
    "  var parent = element.parentElement;\n"
    "  var parentRect = getFirstNonZeroWidthHeightRect(parent.getClientRects());\n"
    "  return parentRect;\n"
    "}\n"
    "\n"
    "function getInViewPoint(element) {\n"
    "  var rectangles = element.getClientRects();\n"
    "  if (rectangles.length === 0) {\n"
    "    return false;\n"
    "  }\n"
    "\n"
    "  var rect = getFirstNonZeroWidthHeightRect(rectangles);\n"
    "  var left = Math.max(0, rect.left);\n"
    "  var right = Math.min(window.innerWidth, rect.right);\n"
    "  var top = Math.max(0, rect.top);\n"
    "  var bottom = Math.min(window.innerHeight, rect.bottom);\n"
    "\n"
    "  // Find the view boundary of the element by checking itself and all of its\n"
    "  // ancestor's boundary.\n"
    "  while (element.parentElement != null &&\n"
    "         element.parentElement != document.body &&\n"
    "         element.parentElement.getClientRects().length > 0) {\n"
    "    var parentStyle = window.getComputedStyle(element.parentElement);\n"
    "    var overflow = parentStyle.getPropertyValue(\"overflow\");\n"
    "    var overflowX = parentStyle.getPropertyValue(\"overflow-x\");\n"
    "    var overflowY = parentStyle.getPropertyValue(\"overflow-y\");\n"
    "    var parentRect = getParentRect(element);\n"
    "    // Only consider about overflow cases when the parent area overlaps with\n"
    "    // the element's area.\n"
    "    if (parentRect.right > left && parentRect.bottom > top &&\n"
    "        right > parentRect.left && bottom > parentRect.top) {\n"
    "      if (overflow == \"auto\" || overflow == \"scroll\" || overflow == \"hidden\") {\n"
    "        left = Math.max(left, parentRect.left);\n"
    "        right = Math.min(right, parentRect.right);\n"
    "        top = Math.max(top, parentRect.top);\n"
    "        bottom = Math.min(bottom, parentRect.bottom);\n"
    "      } else {\n"
    "        if (overflowX == \"auto\" || overflowX == \"scroll\" ||\n"
    "            overflowX == \"hidden\") {\n"
    "          left = Math.max(left, parentRect.left);\n"
    "          right = Math.min(right, parentRect.right);\n"
    "        }\n"
    "        if (overflowY == \"auto\" || overflowY == \"scroll\" ||\n"
    "            overflowY == \"hidden\") {\n"
    "          top = Math.max(top, parentRect.top);\n"
    "          bottom = Math.min(bottom, parentRect.bottom);\n"
    "        }\n"
    "      }\n"
    "    }\n"
    "    element = element.parentElement;\n"
    "  }\n"
    "\n"
    "  var x = 0.5 * (left + right);\n"
    "  var y = 0.5 * (top + bottom);\n"
    "  return [x, y, left, top];\n"
    "}\n"
    "\n"
    "function rootNodeIncludes(element, elementPoint) {\n"
    "  if (!element)\n"
    "    return false;\n"
    "  let rootNode = element.getRootNode();\n"
    "  if (rootNode.elementsFromPoint(elementPoint[0], elementPoint[1])\n"
    "      .includes(element)) {\n"
    "    if (rootNode == document)\n"
    "      return true;\n"
    "    return rootNodeIncludes(rootNode.host, elementPoint);\n"
    "  }\n"
    "  return false;\n"
    "}\n"
    "\n"
    "function inView(element) {\n"
    "  var elementPoint = getInViewPoint(element);\n"
    "  if (!elementPoint ||\n"
    "      elementPoint[0] <= 0 || elementPoint[1] <= 0 ||\n"
    "      elementPoint[0] >= window.innerWidth ||\n"
    "      elementPoint[1] >= window.innerHeight ||\n"
    "      !rootNodeIncludes(element, elementPoint)) {\n"
    "    return false;\n"
    "  }\n"
    "\n"
    "  return true;\n"
    "}\n"
    "\n"
    "function getElementLocation(element, center) {\n"
    "  // Check that node type is element.\n"
    "  if (element.nodeType != 1)\n"
    "    throw new Error(element + ' is not an element');\n"
    "\n"
    "  if (!isNodeReachable(element)) {\n"
    "    // errorCode 10: StaleElementException\n"
    "    throw newError('element is not attached to the page document', 10);\n"
    "  }\n"
    "\n"
    "  if (!inView(element)) {\n"
    "    element.scrollIntoView({behavior: \"instant\",\n"
    "                            block: \"end\",\n"
    "                            inline: \"nearest\"});\n"
    "  }\n"
    "\n"
    "  var clientRects = element.getClientRects();\n"
    "  if (clientRects.length === 0) {\n"
    "    // errorCode 60: ElementNotInteractableException\n"
    "    throw newError(element + ' has no size and location', 60);\n"
    "  }\n"
    "\n"
    "  var elementPoint = getInViewPoint(element);\n"
    "  if (center) {\n"
    "    return {\n"
    "        'x': elementPoint[0],\n"
    "        'y': elementPoint[1]\n"
    "    };\n"
    "  } else {\n"
    "    return {\n"
    "        'x': elementPoint[2],\n"
    "        'y': elementPoint[3]\n"
    "    };\n"
    "  }\n"
    "}\n"
    "; return getElementLocation.apply(null, arguments) }\n";
const char kGetElementRegionScript[] =
    "function() { // Copyright 2013 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "// Return the portion of the element that should be made visible.\n"
    "// Based on the WebDriver spec, this function only considers the first rectangle\n"
    "// returned by element.getClientRects function.\n"
    "// * When the rectangle is already partially visible in the enclosing viewport,\n"
    "//   return the portion that is currently visible. According to WebDriver spec,\n"
    "//   no scrolling should be done to bring more of the element into view.\n"
    "// * When the rectangle is completely outside of the enclosing viewport,\n"
    "//   return the entire rectangle, as WebDriver spec requires us to scroll the\n"
    "//   entire rectangle into view. (However, scrolling is NOT the responsibility\n"
    "//   of this function.)\n"
    "//\n"
    "// The returned value is an object with the following properties about the\n"
    "// region mentioned above: left, top, height, width. Note that left and top are\n"
    "// relative to the upper-left corner of the element's bounding client rect (as\n"
    "// returned by element.getBoundingClientRect).\n"
    "function getElementRegion(element) {\n"
    "  // Check that node type is element.\n"
    "  if (element.nodeType != 1)\n"
    "    throw new Error(element + ' is not an element');\n"
    "\n"
    "  // We try 2 methods to determine element region. Try the first client rect,\n"
    "  // and then the bounding client rect.\n"
    "  // SVG is one case that doesn't have a first client rect.\n"
    "  const clientRects = element.getClientRects();\n"
    "\n"
    "  // Determines if region is partially in viewport, returning visible region\n"
    "  // if so. If not, returns null. If fully visible, returns original region.\n"
    "  function getVisibleSubregion(region) {\n"
    "    // Given two regions, determines if any intersection occurs.\n"
    "    // Overlapping edges are not considered intersections.\n"
    "    function getIntersectingSubregion(region1, region2) {\n"
    "      if (!(Math.round(region2.right)  <= Math.round(region1.left)   ||\n"
    "            Math.round(region2.left)   >= Math.round(region1.right)  ||\n"
    "            Math.round(region2.top)    >= Math.round(region1.bottom) ||\n"
    "            Math.round(region2.bottom) <= Math.round(region1.top))) {\n"
    "        // Determines region of intersection.\n"
    "        // If region2 contains region1, returns region1.\n"
    "        // If region1 contains region2, returns region2.\n"
    "        return {\n"
    "          'left': Math.max(region1.left, region2.left),\n"
    "          'right': Math.min(region1.right, region2.right),\n"
    "          'bottom': Math.min(region1.bottom, region2.bottom),\n"
    "          'top': Math.max(region1.top, region2.top)\n"
    "        };\n"
    "      }\n"
    "      return null;\n"
    "    }\n"
    "    const visualViewport = window.visualViewport;\n"
    "    // We need to disregard any scrollbars therefore instead of innerSize\n"
    "    // of the window we should use the viewport size.\n"
    "    // This size can be affected (scaled) by user's pinch.\n"
    "    // We need to undo this scaling because client rects are calculated\n"
    "    // relatively to the original unscaled viewport.\n"
    "    const viewport = new DOMRect(0, 0,\n"
    "      visualViewport.width * visualViewport.scale,\n"
    "      visualViewport.height * visualViewport.scale\n"
    "    );\n"
    "    return getIntersectingSubregion(viewport, region);\n"
    "  }\n"
    "\n"
    "  let boundingRect = null;\n"
    "  let clientRect = null;\n"
    "  // Element area of a map has same first ClientRect and BoundingClientRect\n"
    "  // after blink roll at chromium commit position 290738 which includes blink\n"
    "  // revision 180610. Thus handle area as a special case.\n"
    "  if (clientRects.length == 0 || element.tagName.toLowerCase() == 'area') {\n"
    "    // Area clicking is technically not supported by W3C standard but is a\n"
    "    // desired feature. Returns region containing the area instead of subregion\n"
    "    // so that whole area is visible and always clicked correctly.\n"
    "    if (element.tagName.toLowerCase() == 'area') {\n"
    "      const coords = element.coords.split(',');\n"
    "      if (element.shape.toLowerCase() == 'rect') {\n"
    "        if (coords.length != 4)\n"
    "          throw new Error('failed to detect the region of the area');\n"
    "        const leftX = Number(coords[0]);\n"
    "        const topY = Number(coords[1]);\n"
    "        const rightX = Number(coords[2]);\n"
    "        const bottomY = Number(coords[3]);\n"
    "        return {\n"
    "            'left': leftX,\n"
    "            'top': topY,\n"
    "            'width': rightX - leftX,\n"
    "            'height': bottomY - topY\n"
    "        };\n"
    "      } else if (element.shape.toLowerCase() == 'circle') {\n"
    "        if (coords.length != 3)\n"
    "          throw new Error('failed to detect the region of the area');\n"
    "        const centerX = Number(coords[0]);\n"
    "        const centerY = Number(coords[1]);\n"
    "        const radius = Number(coords[2]);\n"
    "        return {\n"
    "            'left': Math.max(0, centerX - radius),\n"
    "            'top': Math.max(0, centerY - radius),\n"
    "            'width': radius * 2,\n"
    "            'height': radius * 2\n"
    "        };\n"
    "      } else if (element.shape.toLowerCase() == 'poly') {\n"
    "        if (coords.length < 2)\n"
    "          throw new Error('failed to detect the region of the area');\n"
    "        let minX = Number(coords[0]);\n"
    "        let minY = Number(coords[1]);\n"
    "        let maxX = minX;\n"
    "        let maxY = minY;\n"
    "        for (i = 2; i < coords.length; i += 2) {\n"
    "          const x = Number(coords[i]);\n"
    "          const y = Number(coords[i + 1]);\n"
    "          minX = Math.min(minX, x);\n"
    "          minY = Math.min(minY, y);\n"
    "          maxX = Math.max(maxX, x);\n"
    "          maxY = Math.max(maxY, y);\n"
    "        }\n"
    "        return {\n"
    "            'left': minX,\n"
    "            'top': minY,\n"
    "            'width': maxX - minX,\n"
    "            'height': maxY - minY\n"
    "        };\n"
    "      } else {\n"
    "        throw new Error('shape=' + element.shape + ' is not supported');\n"
    "      }\n"
    "    } else {\n"
    "      clientRect = boundingRect = element.getBoundingClientRect();\n"
    "    }\n"
    "  } else {\n"
    "    boundingRect = element.getBoundingClientRect();\n"
    "    clientRect = clientRects[0];\n"
    "    for (let i = 0; i < clientRects.length; i++) {\n"
    "      if (clientRects[i].height != 0 && clientRects[i].width != 0) {\n"
    "        clientRect = clientRects[i];\n"
    "        break;\n"
    "      }\n"
    "    }\n"
    "  }\n"
    "  const visiblePortion = getVisibleSubregion(clientRect) || clientRect;\n"
    "  // Returned region is relative to boundingRect's left,top.\n"
    "  return {\n"
    "    'left': visiblePortion.left - boundingRect.left,\n"
    "    'top': visiblePortion.top - boundingRect.top,\n"
    "    'height': visiblePortion.bottom - visiblePortion.top,\n"
    "    'width': visiblePortion.right - visiblePortion.left\n"
    "  };\n"
    "}\n"
    "; return getElementRegion.apply(null, arguments) }\n";
const char kIsOptionElementToggleableScript[] =
    "function() { // Copyright 2013 The Chromium Authors\n"
    "// Use of this source code is governed by a BSD-style license that can be\n"
    "// found in the LICENSE file.\n"
    "\n"
    "function isOptionElementToggleable(option) {\n"
    "  if (option.tagName.toLowerCase() != 'option')\n"
    "    throw new Error('element is not an option');\n"
    "  for (var parent = option.parentElement;\n"
    "       parent;\n"
    "       parent = parent.parentElement) {\n"
    "    if (parent.tagName.toLowerCase() == 'select') {\n"
    "      return parent.multiple;\n"
    "    }\n"
    "  }\n"
    "  throw new Error('option element is not in a select');\n"
    "}\n"
    "; return isOptionElementToggleable.apply(null, arguments) }\n";
