// components/performance_manager/public/mojom/web_memory.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/performance_manager/public/mojom/web_memory.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-params-data.h"
namespace performance_manager {
namespace mojom {

NOINLINE static const char* WebMemoryAttribution_ScopeToStringHelper(WebMemoryAttribution_Scope value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebMemoryAttribution_Scope::kCrossOriginAggregated:
      return "kCrossOriginAggregated";
    case WebMemoryAttribution_Scope::kWindow:
      return "kWindow";
    case WebMemoryAttribution_Scope::kDedicatedWorker:
      return "kDedicatedWorker";
    case WebMemoryAttribution_Scope::kServiceWorker:
      return "kServiceWorker";
    case WebMemoryAttribution_Scope::kSharedWorker:
      return "kSharedWorker";
    default:
      return nullptr;
  }
}

std::string WebMemoryAttribution_ScopeToString(WebMemoryAttribution_Scope value) {
  const char *str = WebMemoryAttribution_ScopeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebMemoryAttribution_Scope value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebMemoryAttribution_Scope value) {
  return os << WebMemoryAttribution_ScopeToString(value);
}

NOINLINE static const char* WebMemoryMeasurement_ModeToStringHelper(WebMemoryMeasurement_Mode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case WebMemoryMeasurement_Mode::kDefault:
      return "kDefault";
    case WebMemoryMeasurement_Mode::kEager:
      return "kEager";
    default:
      return nullptr;
  }
}

std::string WebMemoryMeasurement_ModeToString(WebMemoryMeasurement_Mode value) {
  const char *str = WebMemoryMeasurement_ModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown WebMemoryMeasurement_Mode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, WebMemoryMeasurement_Mode value) {
  return os << WebMemoryMeasurement_ModeToString(value);
}

namespace internal {


// static
bool WebMemoryAttribution_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebMemoryAttribution_Data* object =
      static_cast<const WebMemoryAttribution_Data*>(data);


  if (!::performance_manager::mojom::internal::WebMemoryAttribution_Scope_Data
        ::Validate(object->scope, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& src_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->src, validation_context,
                                         &src_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

WebMemoryAttribution_Data::WebMemoryAttribution_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryUsage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebMemoryUsage_Data* object =
      static_cast<const WebMemoryUsage_Data*>(data);

  return true;
}

WebMemoryUsage_Data::WebMemoryUsage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryBreakdownEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebMemoryBreakdownEntry_Data* object =
      static_cast<const WebMemoryBreakdownEntry_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->memory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->canvas_memory, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution, validation_context,
                                         &attribution_validate_params)) {
    return false;
  }

  return true;
}

WebMemoryBreakdownEntry_Data::WebMemoryBreakdownEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WebMemoryMeasurement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WebMemoryMeasurement_Data* object =
      static_cast<const WebMemoryMeasurement_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->breakdown, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& breakdown_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->breakdown, validation_context,
                                         &breakdown_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->detached_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->shared_memory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->blink_memory, validation_context))
    return false;

  return true;
}

WebMemoryMeasurement_Data::WebMemoryMeasurement_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace performance_manager

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::WebMemoryAttribution_Scope>::WriteIntoTrace(
   perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryAttribution_Scope value) {
  return std::move(context).WriteString(::performance_manager::mojom::WebMemoryAttribution_ScopeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode>::WriteIntoTrace(
   perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryMeasurement_Mode value) {
  return std::move(context).WriteString(::performance_manager::mojom::WebMemoryMeasurement_ModeToString(value));
}

} // namespace perfetto