// components/services/filesystem/public/mojom/directory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_H_
#define COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/filesystem/public/mojom/directory.mojom-features.h"  // IWYU pragma: export
#include "components/services/filesystem/public/mojom/directory.mojom-shared.h"  // IWYU pragma: export
#include "components/services/filesystem/public/mojom/directory.mojom-forward.h"  // IWYU pragma: export
#include "components/services/filesystem/public/mojom/types.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_error.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace filesystem::mojom {

class DirectoryProxy;

template <typename ImplRefTraits>
class DirectoryStub;

class DirectoryRequestValidator;
class DirectoryResponseValidator;


class Directory
    : public DirectoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    69515528, 
    78407241, 
    97170833, 
    209635940, 
    297665100, 
    486559879, 
    1158442745, 
    1276018750, 
    1413652154, 
    1426746571, 
    1564586304, 
    1848528236, 
    1858028766
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DirectoryInterfaceBase;
  using Proxy_ = DirectoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = DirectoryStub<ImplRefTraits>;

  using RequestValidator_ = DirectoryRequestValidator;
  using ResponseValidator_ = DirectoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kOpenFileHandleMinVersion = 0,
    kOpenFileHandlesMinVersion = 0,
    kOpenDirectoryMinVersion = 0,
    kRenameMinVersion = 0,
    kReplaceMinVersion = 0,
    kDeleteMinVersion = 0,
    kExistsMinVersion = 0,
    kIsWritableMinVersion = 0,
    kFlushMinVersion = 0,
    kStatFileMinVersion = 0,
    kCloneMinVersion = 0,
    kReadEntireFileMinVersion = 0,
    kWriteFileMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFileHandle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFileHandles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDirectory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Rename_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Replace_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Delete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Exists_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsWritable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Flush_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StatFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Clone_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReadEntireFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WriteFile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Directory() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Read(::base::File::Error* out_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents);

  using ReadCallback = base::OnceCallback<void(::base::File::Error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>)>;
  
  virtual void Read(ReadCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFileHandle(const std::string& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle);

  using OpenFileHandleCallback = base::OnceCallback<void(::base::File::Error, ::base::File)>;
  
  virtual void OpenFileHandle(const std::string& path, uint32_t open_flags, OpenFileHandleCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFileHandles(std::vector<FileOpenDetailsPtr> files, std::vector<FileOpenResultPtr>* out_results);

  using OpenFileHandlesCallback = base::OnceCallback<void(std::vector<FileOpenResultPtr>)>;
  
  virtual void OpenFileHandles(std::vector<FileOpenDetailsPtr> files, OpenFileHandlesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error);

  using OpenDirectoryCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, OpenDirectoryCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Rename(const std::string& path, const std::string& new_path, ::base::File::Error* out_error);

  using RenameCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void Rename(const std::string& path, const std::string& new_path, RenameCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Replace(const std::string& path, const std::string& new_path, ::base::File::Error* out_error);

  using ReplaceCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void Replace(const std::string& path, const std::string& new_path, ReplaceCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Delete(const std::string& path, uint32_t delete_flags, ::base::File::Error* out_error);

  using DeleteCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void Delete(const std::string& path, uint32_t delete_flags, DeleteCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Exists(const std::string& path, ::base::File::Error* out_error, bool* out_exists);

  using ExistsCallback = base::OnceCallback<void(::base::File::Error, bool)>;
  
  virtual void Exists(const std::string& path, ExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool IsWritable(const std::string& path, ::base::File::Error* out_error, bool* out_is_writable);

  using IsWritableCallback = base::OnceCallback<void(::base::File::Error, bool)>;
  
  virtual void IsWritable(const std::string& path, IsWritableCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Flush(::base::File::Error* out_error);

  using FlushCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void Flush(FlushCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool StatFile(const std::string& path, ::base::File::Error* out_error, ::filesystem::mojom::FileInformationPtr* out_file_information);

  using StatFileCallback = base::OnceCallback<void(::base::File::Error, ::filesystem::mojom::FileInformationPtr)>;
  
  virtual void StatFile(const std::string& path, StatFileCallback callback) = 0;

  
  virtual void Clone(::mojo::PendingReceiver<Directory> directory) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ReadEntireFile(const std::string& path, ::base::File::Error* out_error, std::vector<uint8_t>* out_data);

  using ReadEntireFileCallback = base::OnceCallback<void(::base::File::Error, const std::vector<uint8_t>&)>;
  
  virtual void ReadEntireFile(const std::string& path, ReadEntireFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WriteFile(const std::string& path, const std::vector<uint8_t>& data, ::base::File::Error* out_error);

  using WriteFileCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void WriteFile(const std::string& path, const std::vector<uint8_t>& data, WriteFileCallback callback) = 0;
};



class  DirectoryProxy
    : public Directory {
 public:
  using InterfaceType = Directory;

  explicit DirectoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Read(::base::File::Error* out_error, std::optional<std::vector<::filesystem::mojom::DirectoryEntryPtr>>* out_directory_contents) final;
  
  void Read(ReadCallback callback) final;
  
  bool OpenFileHandle(const std::string& path, uint32_t open_flags, ::base::File::Error* out_error, ::base::File* out_file_handle) final;
  
  void OpenFileHandle(const std::string& path, uint32_t open_flags, OpenFileHandleCallback callback) final;
  
  bool OpenFileHandles(std::vector<FileOpenDetailsPtr> files, std::vector<FileOpenResultPtr>* out_results) final;
  
  void OpenFileHandles(std::vector<FileOpenDetailsPtr> files, OpenFileHandlesCallback callback) final;
  
  bool OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, ::base::File::Error* out_error) final;
  
  void OpenDirectory(const std::string& path, ::mojo::PendingReceiver<Directory> directory, uint32_t open_flags, OpenDirectoryCallback callback) final;
  
  bool Rename(const std::string& path, const std::string& new_path, ::base::File::Error* out_error) final;
  
  void Rename(const std::string& path, const std::string& new_path, RenameCallback callback) final;
  
  bool Replace(const std::string& path, const std::string& new_path, ::base::File::Error* out_error) final;
  
  void Replace(const std::string& path, const std::string& new_path, ReplaceCallback callback) final;
  
  bool Delete(const std::string& path, uint32_t delete_flags, ::base::File::Error* out_error) final;
  
  void Delete(const std::string& path, uint32_t delete_flags, DeleteCallback callback) final;
  
  bool Exists(const std::string& path, ::base::File::Error* out_error, bool* out_exists) final;
  
  void Exists(const std::string& path, ExistsCallback callback) final;
  
  bool IsWritable(const std::string& path, ::base::File::Error* out_error, bool* out_is_writable) final;
  
  void IsWritable(const std::string& path, IsWritableCallback callback) final;
  
  bool Flush(::base::File::Error* out_error) final;
  
  void Flush(FlushCallback callback) final;
  
  bool StatFile(const std::string& path, ::base::File::Error* out_error, ::filesystem::mojom::FileInformationPtr* out_file_information) final;
  
  void StatFile(const std::string& path, StatFileCallback callback) final;
  
  void Clone(::mojo::PendingReceiver<Directory> directory) final;
  
  bool ReadEntireFile(const std::string& path, ::base::File::Error* out_error, std::vector<uint8_t>* out_data) final;
  
  void ReadEntireFile(const std::string& path, ReadEntireFileCallback callback) final;
  
  bool WriteFile(const std::string& path, const std::vector<uint8_t>& data, ::base::File::Error* out_error) final;
  
  void WriteFile(const std::string& path, const std::vector<uint8_t>& data, WriteFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DirectoryStubDispatch {
 public:
  static bool Accept(Directory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Directory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Directory>>
class DirectoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DirectoryStub() = default;
  ~DirectoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DirectoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DirectoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  FileOpenDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileOpenDetails, T>::value>;
  using DataView = FileOpenDetailsDataView;
  using Data_ = internal::FileOpenDetails_Data;

  template <typename... Args>
  static FileOpenDetailsPtr New(Args&&... args) {
    return FileOpenDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileOpenDetailsPtr From(const U& u) {
    return mojo::TypeConverter<FileOpenDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileOpenDetails>::Convert(*this);
  }


  FileOpenDetails();

  FileOpenDetails(
      const std::string& path,
      uint32_t open_flags);


  ~FileOpenDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileOpenDetailsPtr>
  FileOpenDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FileOpenDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileOpenDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileOpenDetails_UnserializedMessageContext<
            UserType, FileOpenDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileOpenDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileOpenDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileOpenDetails_UnserializedMessageContext<
            UserType, FileOpenDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileOpenDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string path;
  
  uint32_t open_flags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileOpenDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  FileOpenResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FileOpenResult, T>::value>;
  using DataView = FileOpenResultDataView;
  using Data_ = internal::FileOpenResult_Data;

  template <typename... Args>
  static FileOpenResultPtr New(Args&&... args) {
    return FileOpenResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FileOpenResultPtr From(const U& u) {
    return mojo::TypeConverter<FileOpenResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FileOpenResult>::Convert(*this);
  }


  FileOpenResult();

  FileOpenResult(
      const std::string& path,
      ::base::File::Error error,
      ::base::File file_handle);

FileOpenResult(const FileOpenResult&) = delete;
FileOpenResult& operator=(const FileOpenResult&) = delete;

  ~FileOpenResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FileOpenResultPtr>
  FileOpenResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FileOpenResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FileOpenResult_UnserializedMessageContext<
            UserType, FileOpenResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FileOpenResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FileOpenResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FileOpenResult_UnserializedMessageContext<
            UserType, FileOpenResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FileOpenResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string path;
  
  ::base::File::Error error;
  
  ::base::File file_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FileOpenResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
FileOpenDetailsPtr FileOpenDetails::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(open_flags)
  );
}

template <typename T, FileOpenDetails::EnableIfSame<T>*>
bool FileOpenDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->open_flags, other_struct.open_flags))
    return false;
  return true;
}

template <typename T, FileOpenDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.open_flags < rhs.open_flags)
    return true;
  if (rhs.open_flags < lhs.open_flags)
    return false;
  return false;
}
template <typename StructPtrType>
FileOpenResultPtr FileOpenResult::Clone() const {
  return New(
      mojo::Clone(path),
      mojo::Clone(error),
      mojo::Clone(file_handle)
  );
}

template <typename T, FileOpenResult::EnableIfSame<T>*>
bool FileOpenResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->file_handle, other_struct.file_handle))
    return false;
  return true;
}

template <typename T, FileOpenResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.error < rhs.error)
    return true;
  if (rhs.error < lhs.error)
    return false;
  if (lhs.file_handle < rhs.file_handle)
    return true;
  if (rhs.file_handle < lhs.file_handle)
    return false;
  return false;
}


}  // filesystem::mojom

namespace mojo {


template <>
struct  StructTraits<::filesystem::mojom::FileOpenDetails::DataView,
                                         ::filesystem::mojom::FileOpenDetailsPtr> {
  static bool IsNull(const ::filesystem::mojom::FileOpenDetailsPtr& input) { return !input; }
  static void SetToNull(::filesystem::mojom::FileOpenDetailsPtr* output) { output->reset(); }

  static const decltype(::filesystem::mojom::FileOpenDetails::path)& path(
      const ::filesystem::mojom::FileOpenDetailsPtr& input) {
    return input->path;
  }

  static decltype(::filesystem::mojom::FileOpenDetails::open_flags) open_flags(
      const ::filesystem::mojom::FileOpenDetailsPtr& input) {
    return input->open_flags;
  }

  static bool Read(::filesystem::mojom::FileOpenDetails::DataView input, ::filesystem::mojom::FileOpenDetailsPtr* output);
};


template <>
struct  StructTraits<::filesystem::mojom::FileOpenResult::DataView,
                                         ::filesystem::mojom::FileOpenResultPtr> {
  static bool IsNull(const ::filesystem::mojom::FileOpenResultPtr& input) { return !input; }
  static void SetToNull(::filesystem::mojom::FileOpenResultPtr* output) { output->reset(); }

  static const decltype(::filesystem::mojom::FileOpenResult::path)& path(
      const ::filesystem::mojom::FileOpenResultPtr& input) {
    return input->path;
  }

  static decltype(::filesystem::mojom::FileOpenResult::error) error(
      const ::filesystem::mojom::FileOpenResultPtr& input) {
    return input->error;
  }

  static  decltype(::filesystem::mojom::FileOpenResult::file_handle)& file_handle(
       ::filesystem::mojom::FileOpenResultPtr& input) {
    return input->file_handle;
  }

  static bool Read(::filesystem::mojom::FileOpenResult::DataView input, ::filesystem::mojom::FileOpenResultPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_FILESYSTEM_PUBLIC_MOJOM_DIRECTORY_MOJOM_H_